C
C Create order of loci for outputting a pedigree
C  1 = as is
C  2 = LINKAGE
C  3 = GENEHUNTER
C  4 = MENDEL
C  5 = LINKAGE PPD
C
      subroutine lorder(typ,nloci,loctyp,nord,locord)
      integer MAXLOC
      parameter(MAXLOC=120)

      integer typ
C Locus structure
      integer nloci,loctyp(MAXLOC)
C Printing order of loci
      integer nord,locord(MAXLOC)

      integer i
C
C Default is no manipulation
C
      if (typ.lt.2) then
        nord=nloci
        do 10 i=1,nloci
          locord(i)=i
   10   continue
C
C else Genehunter 2 ordering
C
      else
        nord=0
C no more than one binary trait if typ=3
        if (typ.eq.2 .or. typ.eq.3 .or. typ.eq.5) then
          do 20 i=1,nloci
          if (loctyp(i).eq.4) then
            nord=nord+1
            locord(nord)=i
            if (typ.eq.3) goto 21
          end if
   20     continue
   21     continue
        end if
C all the markers 
        do 30 i=1,nloci
        if (loctyp(i).eq.1 .or. loctyp(i).eq.2) then
          nord=nord+1
          locord(nord)=i
        end if
   30   continue
C MENDEL factors
        if (typ.eq.4) then
          do 40 i=1,nloci
          if (loctyp(i).eq.4) then
            nord=nord+1
            locord(nord)=i
          end if
   40     continue
        end if
C then the quantitative traits
        do 50 i=1,nloci
        if (loctyp(i).eq.3) then
          nord=nord+1
          locord(nord)=i
        end if
   50   continue
      end if
      return
      end
C end-of-order
C
C Write map 
C
C 10 = table for Sib-pair output
C  0 = LINKAGE
C  1 = LINKAGE plus dummy binary trait
C  2 = GENEHUNTER plus dummy binary trait
C  3 = GENEHUNTER
C  4 = MENDEL
C 20 = MENDEL .var file 
C  5 = ASPEX
C  6 = MERLIN
C  7 = LOKI  
C  8 = STRUCTURE
C  9 = SOLAR
C
      subroutine wrmap(ostr,typ,mapf,nloci,loc,loctyp,locnotes,
     &                 nord,locord, map)
      integer MAXLOC, MISS
      parameter(MAXLOC=120,MISS=-9999)

      integer mapf, ostr, typ
C Locus structure
      integer nloci,loctyp(MAXLOC)
      character*20 loc(MAXLOC)
      character*40 locnotes(MAXLOC)
C Printing order of loci
      integer nord,locord(MAXLOC)
C position of locus on sex-averaged linkage map
      real map(MAXLOC)

      integer i, k
      logical frst
      character*21 tnam
      real dist
C functions
      real invmap
C show map
      dist=0.0
      frst=.true.
      if (typ.eq.10) then
        write(*,'(/a//a/a)') 'User specified marker map:',
     2    'Marker         Pos (cM)   Theta' ,
     3    '-----------    --------   -----' 
        do 20 i=1,nloci
        if (loctyp(i).le.2) then
          if (map(i).ne.MISS) then
            dist=map(i)-dist
            if (dist.lt.0.0) dist=1000.0
            write(*,'(a15,f8.2,f8.3,3x,a)') 
     &        loc(i),map(i),invmap(dist,mapf),locnotes(i)
            dist=map(i)
          else
            write(*,'(a15,5x,a1,7x,a1,6x,a)') 
     &        loc(i),'x','x',locnotes(i)
          end if
        end if
   20   continue
        write(*,*)
C write Linkage or Genehunter locus file map
      else if (typ.ge.0 .and. typ.le.3) then
        dist=MISS
        if (typ.eq.1 .or. typ.eq.2) write(OSTR,'(a,$)') '  .000'
        do 30 k=1,nord 
        i=locord(k)
        if (loctyp(i).le.4) then
          if (frst) then
            frst=.not.frst
          elseif (dist.ne.MISS .and. map(i).ge.dist) then
            if (typ.eq.2 .or.typ.eq.3) then
              write(ostr,'(1x,f6.2,$)') max(0.01,map(i)-dist)
            else
              write(ostr,'(1x,f6.4,$)') invmap(map(i)-dist,mapf)
            end if
          else
            if (typ.eq.2 .or. typ.eq.3) then
              write(ostr,'(a,$)') ' 0.0'
            else
              write(ostr,'(a,$)') ' .4999'
            end if
          end if
          dist=map(i)
        end if
   30   continue
C MENDEL map file
      else if (typ.eq.4) then
        do 40 i=1,nloci
        if (loctyp(i).le.4) then
          if (frst) then
            frst=.not.frst
          elseif (dist.ne.MISS .and. map(i).ge.dist) then
            dist=map(i)-dist
            write(ostr,'(8x,f8.4,f8.4)') 
     &        invmap(dist,mapf), invmap(dist,mapf)
          else
            write(ostr,'(8x,f8.4,f8.4)') 0.5, 0.5
          end if
          dist=map(i)
          call shorten(i, nloci, loc, 8, tnam)
          write(ostr,'(a8)') tnam
        end if
   40   continue
C MENDEL var file
      else if (typ.eq.20) then
        do 45 i=1,nloci
        if (loctyp(i).eq.3) then
          call shorten(i, nloci, loc, 8, tnam)
          write(ostr,'(a8)') tnam  
        end if
   45   continue
C ASPEX map 
      else if (typ.eq.5) then
        k=0
        write(ostr,'(a,$)') 'set dist {'
        do 50 i=1,nloci
        if (loctyp(i).le.2) then
          k=k+1
          if (map(i).ne.MISS .and. map(i).ge.dist) then
            write(ostr,'(1x,f5.3,$)') 
     &        max(0.001,0.01*(map(i)-dist))
            dist=map(i)
          elseif (dist.eq.0.0) then
            write(ostr,'(a,$)') ' 0.001'
            dist=-100.0
          else
            write(ostr,'(a,$)') ' 0.50'
            dist=-100.0
          end if
          if (k.eq.6) then
            k=0
            write(ostr,'(/a,$)') '          '
          end if
        end if
   50   continue
        write(ostr,'(a)') ' 0.01 }'
C MERLIN map file
      else if (typ.eq.6) then
        do 60 i=1,nloci
        if (loctyp(i).le.2) then
          if (map(i).ne.MISS) then
            write(ostr,'(2a,f9.3)') '1 ',loc(i),map(i)
            dist=map(i)
          else
            write(ostr,'(2a,f9.3)') '1 ',loc(i), 1000.0+dist
            dist=dist+1000.0
          end if
        end if
   60   continue
C LOKI parameter file map positions
      else if (typ.eq.7) then
        write(ostr,'(a/a//a,f9.3/)') 
     &    'ITERATIONS 1000', 'START OUTPUT 50,1', 'TOTAL MAP 3600.0'
        do 80 i=1,nloci
        if (loctyp(i).eq.1 .and. map(i).ne.MISS) then
          call addlet(loc(i), tnam)
          write(ostr,'(a,a20,f9.3)') 'POSITION ',tnam,map(i)
        end if
   80   continue
C STRUCTURE datafile map positions
      else if (typ.eq.8) then
        do 90 i=1,nloci
        if (loctyp(i).le.2) then
          write(ostr,'(1x,a,$)') loc(i)
        end if
   90   continue
        write(ostr,'(a)') ' '
        do 100 i=1,nloci
        if (loctyp(i).le.2) then
          if (frst) then
            frst=.not.frst
            write(ostr,'(1x,a2,$)') '-1'
          elseif (dist.ne.MISS .and. map(i).ge.dist) then
            dist=map(i)-dist
            write(ostr,'(1x,f7.2,$)') dist
          else
            write(ostr,'(1x,a2,$)') '-1'
          end if
          dist=map(i)
        end if
  100   continue
        write(ostr,*)
C SOLAR map file
      else if (typ.eq.9) then
        write(ostr,'(a)') '1'
        do 110 i=1,nloci
        if (loctyp(i).le.2) then
          if (map(i).ne.MISS) then
            write(ostr,'(a,f9.3)') loc(i),map(i)
            dist=map(i)
          else
            write(ostr,'(a,f9.3)') loc(i), 1000.0+dist
            dist=dist+1000.0
          end if
        end if
  110   continue
      end if
      return
      end
C end-of-wrmap
C
C Write out pedigree header with locus names 
C
      subroutine pedhead(longnam,nwid,nloci,loc,loctyp,locpos,lin)
      integer LINSIZ,MAXLOC
      parameter (LINSIZ=1024,MAXLOC=120)
      integer longnam,nwid
C Locus structure
      character*20 loc(MAXLOC)
      integer nloci,loctyp(MAXLOC),locpos(MAXLOC)
      character*(LINSIZ) lin
C local variables
      integer eos,i,j,pos
      character*3 sex
C functions
      integer eow
      data sex /'sex'/

      write(*,'(/a)') '!'
      do 10 i=1,2
        lin='!'
        pos=longnam+35
        lin(pos:pos)=sex(i:i)
        pos=pos+2
        do 15 j=1,nloci
        if(loctyp(j).le.2) then
           pos=pos+9
        elseif(loctyp(j).eq.3) then
           pos=pos+nwid+2
        elseif(loctyp(j).eq.4) then
           eos=max(0,3-eow(loc(j)))
           if (eos.lt.i) lin(pos:pos)=loc(j)(i-eos:i-eos)
           pos=pos+2
        end if
   15   continue
        write(*,'(a)') lin(1:pos)
   10 continue

      lin(1:longnam)='! Pedigree'
      pos=longnam+6
      lin(pos:pos+31)='Person     Father     Mother x'
      pos=pos+31

      do 25 j=1,nloci
      if(loctyp(j).le.2) then
         eos=eow(loc(j))
         lin(pos+8-eos:pos+7)=loc(j)(1:eos)
         pos=pos+9
      elseif(loctyp(j).eq.3) then
         eos=min(nwid,eow(loc(j)))
         lin(pos+nwid-eos:pos+nwid-1)=loc(j)(1:eos)
         pos=pos+nwid+2
      elseif(loctyp(j).eq.4) then
         eos=max(0,3-eow(loc(j)))
         lin(pos:pos)=loc(j)(i-eos:i-eos)
         pos=pos+2
      end if
   25 continue
      write(*,'(a/a)') lin(1:pos),'!'
      return
      end
C end-of-pedhead
C
C Write out pedigree using GAS format
C
      subroutine pedout(wrk,strm,typ,imp,nwid,ndec,longnam,misval,nrc,
     2             pedigree,actset,num,nfound,
     3             id,fa,mo,sex,locus,nloci,loctyp,locpos,numloc,lin)
      integer LINSIZ,KNOWN,MAXSIZ,MAXLOC,MISS
      parameter (LINSIZ=1024,KNOWN=0,MAXSIZ=1000,
     &           MAXLOC=120,MISS=-9999)
      integer imp,longnam,ndec,nrc,nwid,strm,typ,wrk
      character*1 misval
C Pedigree structure
      character*10 pedigree
      integer actset,num,nfound 
      character*10 id(MAXSIZ) 
      integer fa(MAXSIZ),mo(MAXSIZ),sex(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)
C Locus structure
      integer nloci,loctyp(MAXLOC),locpos(MAXLOC)
      character*(LINSIZ) lin
C local variables
      character*8 fdec
      character*20 loc20,miss20

      integer i,j,nobs,pos
      logical last, noimp
C
C quantitative variable format
  
      call wrform('f', nwid, ndec, fdec)
      miss20=' '
      pos=min(nwid-ndec,19)
      miss20(pos:pos)=misval

      noimp=(imp.ne.3 .and. imp.ne.6)
      last=.false.
      nobs=0
      rewind(wrk)
   10 continue
       call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &            numloc, last)
       if (last) goto 20

       if (actset.le.0) goto 10

        do 15 i=1,num
C compulsory data
          nobs=nobs+1
          lin=' '
          lin(1:longnam)=pedigree(1:longnam)
          pos=longnam+2 
          loc20=id(i)
          call juststr('r',loc20,10)
          lin(pos:pos+9)=loc20(1:10)
          pos=pos+11
          if (fa(i).eq.MISS) then
            lin(pos+9:pos+9)=misval
            lin(pos+20:pos+20)=misval
            pos=pos+22
          else
            loc20=id(fa(i))
            call juststr('r',loc20,10)
            lin(pos:pos+9)=loc20(1:10)
            pos=pos+11
            loc20=id(mo(i))
            call juststr('r',loc20,10)
            lin(pos:pos+9)=loc20(1:10)
            pos=pos+11
          end if
          if (sex(i).eq.2) then
            lin(pos:pos)='f'
          elseif (sex(i).eq.1) then
            lin(pos:pos)='m'
          else
            lin(pos:pos)=misval
          end if
          pos=pos+2
C phenotypes
          do 25 j=1,nloci
          if (loctyp(j).le.2) then
             if (locus(i,locpos(j)).eq.MISS .or. 
     &           (noimp .and. locus(i,locpos(j)).le.KNOWN)) then
               if (misval.eq.'x') then
                 call wrgtp(MISS, MISS, lin(pos+1:pos+7),typ+1)
               else
                 lin(pos+4:pos+4)=misval
               end if
             else
               call wrgtp(int(abs(locus(i,locpos(j)))),
     2                    int(abs(locus(i,locpos(j)+1))),
     3                    lin(pos+1:pos+7),typ+1)
             end if
             pos=pos+9
          elseif(loctyp(j).eq.3) then
             if(locus(i,locpos(j)).eq.MISS) then
               write(loc20,'(a)') miss20
             else
               write(loc20,fdec) locus(i,locpos(j))
             end if
             lin(pos:pos+nwid-1)=loc20(1:nwid)
             pos=pos+nwid+2
          elseif(loctyp(j).eq.4) then
             if (locus(i,locpos(j)).eq.MISS .or.
     &           locus(i,locpos(j)).eq.0.0) then
               lin(pos:pos)=misval
             elseif(locus(i,locpos(j)).eq.1.0) then
               lin(pos:pos)='n'
             elseif(locus(i,locpos(j)).eq.2.0) then
               lin(pos:pos)='y'
             end if
             pos=pos+2
          end if
   25     continue
          write(strm,'(a)') lin(1:pos-2)
          if (nrc.gt.0 .and. nobs.eq.nrc) return
   15   continue
      goto 10
   20 continue
      return
      end
C end-of-pedout
C
C Write out PAP pedigree
C
      subroutine wrpap(wrk,wrk2,trip,phen,pedigree,actset,num,nfound,
     2                 id,fa,mo,sex,locus,nloci,loctyp,locpos,numloc,
     3                 numal,name,alfrq)
      integer KNOWN,LINSIZ,MAXALL,MAXSIZ,MAXLOC,MISS
      parameter (KNOWN=0,LINSIZ=1024,MAXALL=60,MAXSIZ=1000,
     &           MAXLOC=120,MISS=-9999)
      integer phen,trip,wrk,wrk2
C Pedigree structure
      character*10 pedigree
      character*10 id(MAXSIZ)
      integer actset,num,nfound,fa(MAXSIZ),mo(MAXSIZ),sex(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)
C Locus structure
      integer nloci,loctyp(MAXLOC),locpos(MAXLOC)
      character*(LINSIZ) lin
      character*8 loc1
C allele frequencies structure
      integer numal, name(MAXALL)
      double precision alfrq(MAXALL)
C local variables
      integer eop,famcnt,famno,g1,g2,i,j,pos,nfam,sx 
      logical last
C functions
      integer eow, getnam
C
C A unique ID number is obtained for each individual by adding the famno
C (which increases in multiples of famcnt, minimum 1000) to their position
C 1..num
C 
      famcnt=int(10.0**int(max(3.0,1.0+log10(float(MAXSIZ)))))
      famno=0
      nfam=0
      pedigree=' '
      last=.false.
      rewind(wrk)
   10 continue
       call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &            numloc, last)
       if (last) goto 20

         if (actset.le.0) goto 10

         nfam=nfam+1
         famno=famno+famcnt
         eop=eow(pedigree)
         lin=' '
         if (num.eq.nfound) then
           do 14 i=1,num
           if (sex(i).eq.1) then
             write(trip,'(4i8,4a)') 
     &       nfam,famno+i,famno+num+i,0,' # ',pedigree(1:eop),'-',id(i)
           else
             write(trip,'(4i8,4a)') 
     &       nfam,famno+num+i,famno+i,0,' # ',pedigree(1:eop),'-',id(i)
           end if
   14      continue
         end if
         do 15 i=1,num
           rewind(wrk2)
           sx=1
           if (sex(i).eq.2) sx=2
           if (fa(i).ne.MISS.and.mo(i).ne.MISS) then
             write(trip,'(4i8,9a)') 
     2       nfam,famno+fa(i),famno+mo(i),famno+i,
     3       ' # ',pedigree(1:eop),'-',id(i),
     4       ' (',id(fa(i))(1:eow(id(fa(i)))),' x ',
     5            id(mo(i))(1:eow(id(mo(i)))),')'
           end if
           write(loc1,'(i8)') famno+i
           lin(1:8)=loc1
           write(loc1,'(i8)') sx
           lin(9:16)=loc1
           pos=17
           do 17 j=1,nloci
             if (pos.gt.122) then
               write(phen,'(a)') lin(1:pos-1)
               lin(1:pos-1)=' '
               pos=1
             end if 
             if (loctyp(j).le.2) then
                read(wrk2) numal,(name(k),k=1,numal),
     &                     (alfrq(k),k=1,numal)
                if (locus(i,locpos(j)).lt.KNOWN) then
                  write(loc1,'(a8)') '   -9999'
                else
                  g1=getnam(locus(i,locpos(j)),numal,name)
                  g2=getnam(locus(i,locpos(j)+1),numal,name)
                  if (loctyp(j).eq.2 .and. sex(i).ne.2) then
                    write(loc1,'(i8)') numal*(numal+1)/2+g1
                  else
                    write(loc1,'(i8)') g2*(g2-1)/2+g1
                  end if
                end if
                lin(pos:pos+7)=loc1
                pos=pos+8
             elseif (loctyp(j).eq.3) then
               if (locus(i,locpos(j)).eq.MISS) then
                 write(loc1,'(a8)') '   -9999'
               else
                 write(loc1,'(f8.4)') locus(i,locpos(j))
               end if
               lin(pos:pos+7)=loc1
               pos=pos+8
             elseif (loctyp(j).eq.4) then
               if (locus(i,locpos(j)).eq.MISS) then
                 write(loc1,'(a8)') '   -9999'
               elseif (locus(i,locpos(j)).eq.1) then
                 write(loc1,'(a8)') '1'
               elseif (locus(i,locpos(j)).eq.2) then
                 write(loc1,'(a8)') '2'
               end if
               lin(pos:pos+7)=loc1
               pos=pos+8
             end if
   17      continue
           if (pos.gt.1) then
             write(phen,'(a)') lin(1:pos-1)
             lin(1:pos-1)=' '
             pos=1
           end if 
   15    continue
      goto 10
   20 continue
      return
      end
C end-of-wrpap
C
C Write out SAGE pedigree
C
      subroutine wrsage(wrk,strm,pedigree,actset,num,id,fa,mo,sex,locus,
     &                  nloci, loctyp,locpos,numloc)
      integer LINSIZ,MAXSIZ,MAXLOC,MISS
      parameter (LINSIZ=1024,MAXSIZ=1000,MAXLOC=120,MISS=-9999)
      integer strm,wrk,actset,num
C Pedigree structure
      character*10 pedigree
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ),mo(MAXSIZ),sex(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)
C Locus structure
      integer nloci,loctyp(MAXLOC),locpos(MAXLOC)
      character*(LINSIZ) lin
      character*9 loc1
      character*4 loc2
      character*1 sx
      integer i,j,pos,nfound,nfam
      logical last
      nfam=0
      pedigree=' '
      last=.false.
      rewind(wrk)
   10 continue
       call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &            numloc, last)
       if (last) goto 20

         if (actset.le.0) goto 10

         nfam=nfam+1
         pos=1
         lin=' '

         do 15 i=1,num
           sx='M'
           if (sex(i).eq.2) sx='F'
           if (fa(i).eq.MISS.and.mo(i).eq.MISS) then
             write(strm,'(a5,i5,a8,16x,a1)') 
     &          'fsp  ',nfam,id(i),sx
           else
             write(strm,'(a5,i5,3a8,a1)') 
     &          'fsp  ',nfam,id(i),id(fa(i)),id(mo(i)),sx
           end if
           do 17 j=1,nloci
             if (pos.gt.122) then
               write(strm,'(a)') lin(1:pos-1)
               lin(1:pos-1)=' '
               pos=1
             end if 
            if (loctyp(j).eq.1) then
              if (locus(i,locpos(j)).eq.MISS) then
                write(loc1,'(a9)') ' '
              else
                write(loc1,'(i4.4,a1,i4.4)') 
     &            int(locus(i,locpos(j))),'/',int(locus(i,locpos(j)+1))
              end if
              lin(pos:pos+8)=loc1
              pos=pos+9
            elseif (loctyp(j).eq.3) then
             if (locus(i,locpos(j)).eq.MISS) then
               write(loc1,'(1x,f8.4)') -99.0
             else
               write(loc1,'(1x,f8.4)') locus(i,locpos(j))
             end if
             lin(pos:pos+8)=loc1
             pos=pos+9
           elseif (loctyp(j).eq.4) then
             if (locus(i,locpos(j)).eq.MISS) then
               write(loc2,'(1x,a3)') '-99'
             elseif (locus(i,locpos(j)).eq.1) then
               write(loc2,'(1x,a3)') '1'
             elseif (locus(i,locpos(j)).eq.2) then
               write(loc2,'(1x,a3)') '2'
             end if
             lin(pos:pos+3)=loc2
             pos=pos+4
           end if
   17      continue
           if (pos.gt.1) then
             write(strm,'(a)') lin(1:pos-1)
             lin(1:pos-1)=' '
             pos=1
           end if 
   15    continue
      goto 10
   20 continue

      return
      end
C end-of-wrsage
C
C write out Linkage type file pre- or post- Makeped style
C
C pre: ped id fa mo sex ...
C ppd: ped.n id.n fa.n mo.n child1.n patsibid.n matsibid.n sex proband.n ...
C      where ped.n, id.n are sequential numerical ID number
C
      subroutine wrlink(wrk,wrk2,strm,typ,renumall,nwid,ndec,pedigree,
     2             actset,num, nfound,id,fa,mo,sex,locus,nloci,loctyp,
     3             locpos,nord,locord,numloc,numal,name,alfrq)
      integer KNOWN,LINSIZ,MAXSIZ,MAXLOC,MISS,MAXALL
      parameter (KNOWN=0,LINSIZ=1024,MAXSIZ=1000,MAXLOC=120,
     &           MISS=-9999,MAXALL=60)
      integer ndec,nwid,strm,typ,wrk,wrk2
      logical renumall
C Pedigree structure
      character*10 pedigree
      integer actset, num, nfound
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ),mo(MAXSIZ),sex(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)
C Locus structure
      integer nloci,loctyp(MAXLOC),locpos(MAXLOC)
C Printing order of loci
      integer nord,locord(MAXLOC)
C allele frequencies structure
      integer numal, name(MAXALL)
      double precision alfrq(MAXALL)
C
      character*(LINSIZ) lin
      character*8 fdec
      character*20 miss20
      character*24 loc24 
      character*1 sx
      integer all3, eop, gene, gen2, i, j, k, kid1, l, matsib, 
     &        nped, patsib, pos, pro
      logical last
C functions
      integer eow, getnam
C
C quantitative variable format 
      call wrform('f', nwid, ndec, fdec)
      miss20=' '
      pos=min(nwid-ndec,19)
      if (typ.eq.2 .or. typ.eq.3) then
        miss20(pos:pos)='-'
      else
        miss20(pos:pos)='0'
      end if

      nped=0
      pedigree=' '
      last=.false.
      rewind(wrk)
   10 continue
       call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &            numloc, last)
       if (last) goto 20

        if (actset.le.0) goto 10

        eop=eow(pedigree)
        nped=nped+1
C recode alleles to 1..n
        if (renumall) then
          rewind(wrk2)
          do 100 l=1,nord
            j=locord(l)
            if (loctyp(j).le.2) then
              gene=locpos(j)
              gen2=gene+1
              read(wrk2) numal,(name(k),k=1,numal), (alfrq(k),k=1,numal)
              do 110 i=1, num
                if (locus(i,gene).gt.KNOWN) then
                  locus(i,gene)=getnam(locus(i,gene),numal,name)
                  locus(i,gen2)=getnam(locus(i,gen2),numal,name)
                end if
  110         continue
            end if
  100     continue
        end if
C write records
        do 15 i=1,num
          lin=' '
          sx='1'
          if (sex(i).eq.2) sx='2'
          if (typ.eq.5 .or. typ.eq.6) then
            write(loc24,'(i10,1x,i10)') nped,i
          else
            write(loc24,'(a10,1x,a10)') pedigree,id(i)
          end if
          lin(1:21)=loc24(1:21)
          if (typ.eq.5 .or. typ.eq.6) then
            if (fa(i).eq.MISS) then
              write(loc24,'(1x,i10,1x,i10)') 0, 0
            else
              write(loc24,'(1x,i10,1x,i10)') fa(i), mo(i)
            end if
          else 
            if (fa(i).eq.MISS) then
              write(loc24,'(1x,a10,1x,a10,1x,a1)') 
     &          '0         ','0         ',sx
            else
              write(loc24,'(1x,a10,1x,a10,1x,a1)') 
     &          id(fa(i)),id(mo(i)),sx
            end if
          end if
          lin(22:45)=loc24
          pos=47
          if (typ.eq.5 .or. typ.eq.6) then
            all3=0
            kid1=0
            matsib=0
            patsib=0
            pro=0
            if (i.eq.1) pro=1
            do 50 j=i+1, num
              if (kid1.eq.0 .and. (fa(j).eq.i .or. mo(j).eq.i)) then
                all3=all3+1
                kid1=j
              else if (i.gt.nfound) then
                if (patsib.eq.0 .and. fa(j).eq.fa(i)) then
                  all3=all3+1
                  patsib=j
                end if
                if (matsib.eq.0 .and. mo(j).eq.mo(i)) then
                  all3=all3+1
                  matsib=j
                end if
              end if
              if (all3.eq.3) goto 51
   50       continue
   51       continue
            write(loc24,'(3(1x,i4),1x,a1,1x,i1)') 
     &         kid1, patsib, matsib, sx, pro
            lin(47:65)=loc24(1:19)
            pos=67
          end if
C Add dummy binary trait when asked
          if (typ.eq.1 .or. typ.eq.2 .or. typ.eq.6) then
            lin(pos:(pos+2))=' 2 '
            pos=pos+3
          end if
          do 25 l=1,nord
            j=locord(l)
            if (loctyp(j).le.2) then
              if(locus(i,locpos(j)).le.KNOWN) then
                write(loc24,'(1x,a3,1x,a3)') '0','0'
              else
                write(loc24,'(1x,i3,1x,i3)') 
     &            int(locus(i,locpos(j))), int(locus(i,locpos(j)+1))
              end if
              lin(pos:pos+7)=loc24(1:8)
              pos=pos+9
            elseif (loctyp(j).eq.3) then
              if(locus(i,locpos(j)).eq.MISS) then
                write(loc24,'(a)') miss20
              elseif(locus(i,locpos(j)).eq.0.0) then
                write(loc24,'(a)') '  0.000001'
              else
                write(loc24,fdec) locus(i,locpos(j))
              end if
              lin(pos:pos+nwid-1)=loc24(1:nwid)
              pos=pos+nwid+2
            elseif (loctyp(j).eq.4) then
              if (locus(i,locpos(j)).eq.1.0d0) then
                lin(pos:pos)='1'
              elseif (locus(i,locpos(j)).eq.2.0d0) then
                lin(pos:pos)='2'
              else
                lin(pos:pos)='0'
              end if
              pos=pos+2
            end if
   25     continue
          if (typ.eq.5 .or. typ.eq.6) then
            lin(pos:(pos+4+eop))='Ped: ' // pedigree(1:eop)
            pos=pos+6+eop
            lin(pos:(pos+12))='Per: ' // id(i)
            pos=pos+14
          end if
          write(strm,'(a)') lin(1:pos-1)
   15   continue
      goto 10
   20 continue
      return
      end
C end-of-wrlink
C
C write out CRI-MAP type file
C
      subroutine wrcri(wrk,wrk2,strm,pedigree,actset,num,id,fa,mo,sex,
     2                 locus,nloci,loctyp,locpos,numloc,
     3                 numal,name,alfrq)
      integer KNOWN,LINSIZ,MAXSIZ,MAXLOC,MISS,MAXALL
      parameter (KNOWN=0,LINSIZ=1024,MAXSIZ=1000,MAXLOC=120,
     &           MISS=-9999,MAXALL=60)
      integer strm,wrk,wrk2,actset,num
C Pedigree structure
      character*10 pedigree
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ),mo(MAXSIZ),sex(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)
C Locus structure
      integer nloci,loctyp(MAXLOC),locpos(MAXLOC)
C allele frequencies structure
      integer numal, name(MAXALL)
      double precision alfrq(MAXALL)
C
      character*(LINSIZ) lin
      character*8 part1
      character*20 part2
      character*9 loc1
      character*1 sx
      integer i,j,pos,nfound
      logical last
C functions
      integer getnam
C
      pedigree=' '
      last=.false.
      rewind(wrk)
   10 continue
       call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &            numloc, last)
       if (last) goto 20

        if (actset.le.0) goto 10

        write(strm,'(1x,a10/1x,i3)') pedigree, num
        do 15 i=1,num
          rewind(wrk2)
          lin=' '
          write(part1,'(a10)') id(i)
          sx='0'
          if (sex(i).eq.2) sx='1'
          if (fa(i).eq.MISS) then
            write(part2,'(1x,a10,1x,a10,1x,a1)')  
     &          '0         ','0         ',sx
          else
            write(part2,'(1x,a10,1x,a10,1x,a1)') id(fa(i)),id(mo(i)),sx
          end if
          lin(1:10)=part1
          lin(11:34)=part2
          pos=35
          do 25 j=1,nloci
          if(loctyp(j).eq.1) then
             read(wrk2) numal,(name(k),k=1,numal),(alfrq(k),k=1,numal)
             if(locus(i,locpos(j)).le.KNOWN) then
               write(loc1,'(1x,a3,1x,a3)') '0','0'
             else
               write(loc1,'(1x,i3,1x,i3)') 
     2          getnam(locus(i,locpos(j)),numal,name),
     3          getnam(locus(i,locpos(j)+1),numal,name)
             end if
             lin(pos:pos+8)=loc1
             pos=pos+9
          end if
   25     continue
         write(strm,'(a)') lin(1:pos-1)
   15   continue
      goto 10
   20 continue
      return
      end
C end-of-wrcri
C
C write out FISHER or MENDEL type pedigree file
C
      subroutine wrfish(wrk, strm, ndec, twinning,  pedigree, actset, 
     2                  num, nfound, id, fa, mo, sex,  locus, nloci,
     3                  loctyp, locpos, numloc, nord, locord,  fstyle)
      integer KNOWN,LINSIZ,MAXSIZ,MAXLOC,MISS
      parameter (KNOWN=0,LINSIZ=1024,MAXSIZ=1000,
     &           MAXLOC=120,MISS=-9999)
      integer ndec,strm,twinning,wrk,fstyle
C Pedigree structure
      character*10 pedigree
      character*10 id(MAXSIZ)
      integer actset,num,nfound,fa(MAXSIZ),mo(MAXSIZ),sex(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)
C Locus structure
      integer nloci,loctyp(MAXLOC),locpos(MAXLOC)
C Printing order of loci
      integer nord,locord(MAXLOC)

      character*(LINSIZ) lin
      character*22 part2
      character*9 fdec, loc1
      character*1 sx, tw
      integer i,j,k,pos,nlp,ntwins
      logical last
C functions
      integer eow
C quantitative variable format 
      i=ndec
      if (i.gt.7) i=7
      write(fdec, '(a,i1,a)') '(1x,f8.', i, ')'
      pedigree=' '
      last=.false.
      nlp=0
      do 1 i=1,nloci
        if(loctyp(i).le.4) nlp=nlp+1
    1 continue
      if (fstyle.eq.1) then
        write(strm,'(1x,a/1x,a,i4,a)') 
     &      '(2(i3,1x),a8)','(a8,2(1x,a8),2(1x,a1),',nlp,'(1x,a8))'
      else
        write(strm,'(1x,a/1x,a,i4,a)') 
     &      '(i3,1x,a8)','(a8,2(1x,a8),2(1x,a1),',nlp,'(1x,a8))'
      end if
      rewind(wrk)
   10 continue
       call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &            numloc, last)
       if (last) goto 20

        if (actset.le.0) goto 10

        ntwins=0
        if (twinning.gt.0) then
          do 12 i=1, num
          if (locus(i,twinning).gt.KNOWN) then
            ntwins=ntwins+1
          end if
   12     continue
        end if
        if (fstyle.eq.1) then
          write(strm,'(2(i3,1x),a8)') 0,num,pedigree(1:8)
        else
          write(strm,'(i3,1x,a8)') num,pedigree(1:8)
        end if
        do 15 i=1,num
          lin=' '
          tw=' '
          if (ntwins.gt.1 .and. locus(i,twinning).gt.KNOWN) then
            tw='1'
            write(*,'(4a)') pedigree(1:eow(pedigree)), '--', id(i), 
     &                      ' marked as a MZ twin.'
          end if
          sx='M'
          if (sex(i).eq.2) sx='F'
          lin(1:8)=id(i)
          if (fa(i).eq.MISS) then
            write(part2,'(1x,a8,1x,a8,1x,a1,1x,a1)') ' ',' ',sx,tw
          else
            write(part2,'(1x,a8,1x,a8,1x,a1,1x,a1)') 
     &            id(fa(i)),id(mo(i)),sx,tw
          end if
          lin(9:30)=part2
          pos=31
          do 25 k=1,nord 
            j=locord(k)
            if (loctyp(j).le.2) then
              if (locus(i,locpos(j)).le.KNOWN) then
                write(loc1,'(1x,a8)') ' '
                lin(pos:pos+8)=loc1
              else
                call wrgtp(int(locus(i,locpos(j))),
     2                     int(locus(i,locpos(j)+1)),
     3                     lin(pos+2:pos+8),1)
              end if
              pos=pos+9
            elseif(loctyp(j).eq.3) then
              if(locus(i,locpos(j)).eq.MISS) then
                write(loc1,'(1x,a8)') ' '
              else
                write(loc1,fdec) locus(i,locpos(j))
              end if
              lin(pos:pos+8)=loc1
              pos=pos+9
            elseif(loctyp(j).eq.4) then
              if(locus(i,locpos(j)).eq.1.0) then
                write(loc1,'(1x,a8)') 'NORMAL  '
              elseif(locus(i,locpos(j)).eq.2.0) then
                write(loc1,'(1x,a8)') 'AFFECTED'
              else
                write(loc1,'(1x,a8)') ' '
              end if
              lin(pos:pos+8)=loc1
              pos=pos+9
            end if
   25     continue
          write(strm,'(a)') lin(1:pos-1)
   15   continue
      goto 10
   20 continue
      return
      end
C end-of-wrfish
C
C write out Arlequin data file (haplotype data)
C
      subroutine wrarl(wrk,wrk2,strm,pedigree,actset,num,nfound,id,fa,
     2                 mo,sex, locus,nloci,loc,loctyp,locpos,numloc,
     3                 mar,hset,typ)
      integer KNOWN,MAXHAP,MAXSIZ,MAXLOC,MISS
      parameter (KNOWN=0,MAXSIZ=1000,MAXLOC=120,
     &           MAXHAP=MAXLOC/2,MISS=-9999)
      integer strm,typ,wrk,wrk2
C Pedigree structure
      character*10 pedigree
      character*10 id(MAXSIZ)
      integer actset,num,nfound,fa(MAXSIZ),mo(MAXSIZ),sex(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)
C Locus structure
      integer nloci,loctyp(MAXLOC),locpos(MAXLOC)
      character*20 loc(MAXLOC)
C
C Storage space for haplotypes
      integer hset(MAXSIZ,MAXHAP,2)
C List of active marker loci
      integer mar(MAXLOC)
C local variables
      integer gene,gen2,i,j,k,maxid,maxinf,ninf,nlp,nsamp
      integer nt1, nt2, tr1, tr2
      character*3 all  
      logical last

      nlp=0
      do 1 j=1,nloci
      if (loctyp(j).eq.1) then
        nlp=nlp+1
        mar(nlp)=locpos(j)
      end if
    1 continue
      nsamp=0

      pedigree=' '
      last=.false.
      rewind(wrk)
   10 continue
       call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &            numloc, last)
       if (last) goto 20

        if (actset.le.0) goto 10
C
C Go through pedigree, either all member genotypes
        if (typ.eq.0) then
         do 12 i=1,num
           ninf=0
           do 13 j=1,nlp
             gene=mar(j)
             gen2=gene+1
             hset(1,j,1)=MISS
             hset(1,j,2)=MISS
             if (locus(i,gene).gt.KNOWN) then
               ninf=ninf+1
               hset(1,j,1)=int(locus(i,gene))
               hset(1,j,2)=int(locus(i,gen2))
             end if
   13      continue
           if (ninf.gt.1) then
             nsamp=nsamp+1
             write(wrk2) ((hset(1,j,k),j=1,nlp),k=1,2)
           end if
   12    continue
        else
C
C or the most useful callable haplotype per family
         maxid=0
         maxinf=0
         do 15 i=nfound+1,num
           ninf=0
           do 16 j=1,nlp
             gene=mar(j)
             gen2=gene+1
             if (locus(i,gene).gt.KNOWN .and. locus(fa(i),gene).gt.KNOWN
     2           .and. locus(mo(i),gene).gt.KNOWN) then
               ninf=ninf+1
               call trans(int(locus(fa(i),gene)),int(locus(fa(i),gen2)),
     2                    int(locus(mo(i),gene)),int(locus(mo(i),gen2)),
     3                    int(locus(i,gene)), int(locus(i,gen2)),
     4                    tr1,tr2,nt1,nt2,0)
               hset(i,j,1)=tr1
               hset(i,j,2)=tr2
               hset(mo(i),j,1)=tr1
               hset(mo(i),j,2)=nt1
               hset(fa(i),j,1)=tr2
               hset(fa(i),j,2)=nt2
             else
               hset(i,j,1)=MISS
               hset(i,j,2)=MISS
               hset(mo(i),j,1)=MISS
               hset(mo(i),j,2)=MISS
               hset(fa(i),j,1)=MISS
               hset(fa(i),j,2)=MISS
             end if
   16      continue
           if (ninf.gt.maxinf) then
             maxinf=ninf
             maxid=i
           end if
   15    continue
         if (maxinf.gt.1) then
           if (typ.eq.1) then
             nsamp=nsamp+1
             write(wrk2) ((hset(maxid,j,k),j=1,nlp),k=1,2)
           else
             nsamp=nsamp+2
             write(wrk2) ((hset(fa(maxid),j,k),j=1,nlp),k=1,2)
             write(wrk2) ((hset(mo(maxid),j,k),j=1,nlp),k=1,2)
           end if
         end if
        end if
      goto 10
   20 continue
C
C Write haplotypes
C
      write(strm,'(a/a/a/a)') 
     &  '#','# Arlequin format data written by Sib-pair','#','[Profile]'
      if (typ.eq.0) then
        write(strm,'(3x,a)') 
     &    'Title="Genotype data: All genotyped individuals"' 
      else if (typ.eq.1) then
        write(strm,'(3x,a)') 
     &    'Title="Haplotype data: one child per family"' 
      else
        write(strm,'(3x,a)') 
     &   'Title="Haplotype data: two parents per family"' 
      end if
      write(strm,'(3x,a)') 
     2  'NbSamples=1', 'GenotypicData=1'  
      write(strm,'(3x,a,i1)') 'GameticPhase=',min(typ,1)
      write(strm,'(3x,a)') 
     2  'RecessiveData=0','DataType=STANDARD',
     3  'LocusSeparator=WHITESPACE','MissingData="x"'
      write(strm,'(a/3x,a/6x,a/6x,a,i5/6x,a)') '[Data]','[[Samples]]',
     &  'SampleName="Population 1"', 'SampleSize=',nsamp,'SampleData= {'
C
      rewind(wrk2)
      do 50 i=1,nsamp
        read(wrk2) ((hset(1,j,k),j=1,nlp),k=1,2)
        write(strm,'(i10,i3,$)') i,1 
        do 60 j=1,nlp
          call wrall(hset(1,j,1),all)
          write(strm,'(1x,a3,$)') all
   60   continue
        write(strm,'(/12x,a,$)') ' '
        do 65 j=1,nlp
          call wrall(hset(1,j,2),all)
          write(strm,'(1x,a3,$)') all
   65   continue
        write(strm,*)
   50 continue
      write(strm,'(6x,a)') '}'
      return
      end
C end-of-wrarl 
C
C write out data file used by Jonathon Pritchard's structure program
C
      subroutine wrprd(wrk,strm,trait,pedigree,actset,num,nfound,id,fa,
     &             mo,sex,locus,nloci,loc,loctyp,locpos,numloc,typ)
      integer KNOWN,LMISS,LINSIZ,MAXSIZ,MAXLOC,MISS
      parameter (KNOWN=0,LINSIZ=1024,MAXSIZ=1000,MAXLOC=120,
     &           LMISS=-9, MISS=-9999)
      integer strm,trait,wrk
      integer typ
C Pedigree structure
      character*10 pedigree
      character*10 id(MAXSIZ)
      integer actset,num,nfound,fa(MAXSIZ),mo(MAXSIZ),sex(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)
C Locus structure
      integer nloci,loctyp(MAXLOC),locpos(MAXLOC)
      character*20 loc(MAXLOC)

      integer eop,fin,g1,g2,i,j,tval
      logical last
C functions
      integer eow

      pedigree=' '
      last=.false.

      rewind(wrk)
   10 continue
       call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &            numloc, last)
       if (last) goto 20

        if (actset.le.0) goto 10

        eop=eow(pedigree)
        fin=num
        if (typ.eq.1) fin=nfound
        do 15 i=1,fin
          if (trait.eq.MISS) then
            tval=0
          else
            tval=int(locus(i,trait))-1
          end if
          write(strm, '(3a, 2(1x, i2),$)') 
     &      pedigree(1:eop),'-',id(i)(1:eow(id(i))), 1, tval
          do 25 j=1,nloci
          if (loctyp(j).eq.1) then
            g1=int(locus(i,locpos(j)))
            g2=int(locus(i,locpos(j)+1))
            if (g1.le.KNOWN) then
              g1=LMISS
              g2=LMISS
            end if
            write(strm,'(1x,i3,1x,i3,$)') g1,g2
          end if
   25     continue
          write(strm,*) 
   15   continue
      goto 10
   20 continue
      return
      end
C end-of-wrprd 
C
C write out pedigree file used by Rams (Sang Hong Lee) 
C
      subroutine wrrams(wrk, strm, strm2, trait, pedigree, actset, num, 
     2                  nfound, id, fa, mo, sex, locus, nloci, loc, 
     3                  loctyp, locpos, numloc)
      integer KNOWN, MAXSIZ, MAXLOC, MISS
      parameter (KNOWN=0, MAXSIZ=1000,
     &           MAXLOC=120, MISS=-9999)
      integer strm, strm2, trait, wrk
C Pedigree structure
      character*10 pedigree
      character*10 id(MAXSIZ)
      integer actset,num,nfound,fa(MAXSIZ),mo(MAXSIZ),sex(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)
C Locus structure
      integer nloci,loctyp(MAXLOC),locpos(MAXLOC)
      character*20 loc(MAXLOC)
      integer fid, i, j, mid, n, nr
      logical last

      n=0
      nr=0
      pedigree=' '
      last=.false.
      rewind(wrk)
   10 continue
       call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &            numloc, last)
       if (last) goto 20

        if (actset.le.0) goto 10

        do 15 i=1,num
          fid=0
          mid=0
          if (fa(i).ne.MISS) fid=n+fa(i)
          if (mo(i).ne.MISS) mid=n+mo(i)
          write(strm, '(i5, 2(1x, i5), $)') n+i, fid, mid
          do 25 j=1,nloci
          if (loctyp(j).eq.1) then
            if (locus(i,locpos(j)).le.KNOWN) then
              write(strm,'(3x,a1,$)') '0'
            else
              write(strm,'(1x,i3,$)') int(locus(i,locpos(j)))
            end if
          else if (trait.eq.j .and. locus(i, locpos(j)).ne.MISS) then
            nr=nr+1
            write(strm2,'(i1,1x,i5,1x,f9.4)') 
     &        1, n+i, locus(i,locpos(j))
          end if
   25     continue
          write(strm,'(a,$)') '  '
          do 35 j=1,nloci
          if (loctyp(j).eq.1) then
            if (locus(i,locpos(j)).le.KNOWN) then
              write(strm,'(3x,a1,$)') '0'
            else
              write(strm,'(1x,i3,$)') int(locus(i,locpos(j)+1))
            end if
          end if
   35     continue
          write(strm,'(3a)') ' # ', pedigree, id(i)
   15   continue
        n=n+num
      goto 10
   20 continue
      write(*,'(a, i5, a, i5)') 'NA= ', n, ' NR=', nr
      return
      end
C end-of-wrrams
C
C write out Nexus gdatype data file used by GDA
C
      subroutine wrgda(wrk,strm,pedigree,actset,num,nfound,id,fa,mo,sex,
     &                 locus,nloci,loc,loctyp,locpos,numloc,typ)
      integer KNOWN,LINSIZ,MAXSIZ,MAXLOC,MISS
      parameter (KNOWN=0,LINSIZ=1024,MAXSIZ=1000,
     &           MAXLOC=120,MISS=-9999)
      integer strm,wrk
      integer typ
C Pedigree structure
      character*10 pedigree
      character*10 id(MAXSIZ)
      integer actset,num,nfound,fa(MAXSIZ),mo(MAXSIZ),sex(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)
C Locus structure
      integer nloci,loctyp(MAXLOC),locpos(MAXLOC)
      character*20 loc(MAXLOC)
      character*(LINSIZ) lin
      character*10 loc1
      integer eop,fin,i,j,n,nlp,pos
      logical last
C functions
      integer eow

      pedigree=' '
      last=.false.
      n=0
      nlp=0
      do 1 j=1,nloci
        if(loctyp(j).eq.1) nlp=nlp+1
    1 continue
      write(strm,'(3(a/),a,i3,a,2(/a))') 
     2  '#nexus','[ Nexus gdatype format data written by Sib-pair ]',
     3  'begin gdadata;', 'dimensions nloci=',nlp,' npops=1;',
     5  'format tokens labels missing=x datapoint=standard;',
     6  'locusallelelabels'
      i=0
      do 2 j=1,nloci
      if (loctyp(j).eq.1) then
        i=i+1
        if (i.lt.nlp) then
          write(strm,'(2x,i3,1x,2a)')   i,loc(j),','
        else
          write(strm,'(2x,i3,1x,a,3(/a))') i,loc(j),';','matrix','Pop1:'
        end if
      end if
    2 continue

      rewind(wrk)
   10 continue
       call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &            numloc, last)
       if (last) goto 20

        if (actset.le.0) goto 10

        eop=eow(pedigree)
        fin=num
        if (typ.eq.1) fin=nfound
        do 15 i=1,fin
          lin=' '
          n=n+1
          write(loc1,'(2x,i8)') n
          lin(1:10)=loc1
          pos=11
          do 25 j=1,nloci
          if (loctyp(j).eq.1) then
            if (locus(i,locpos(j)).le.KNOWN) then
              write(loc1,'(1x,a8)') '   x/x  '
            else
              write(loc1,'(2x,i3.3,a1,i3.3)') 
     &          int(locus(i,locpos(j))),'/',int(locus(i,locpos(j)+1))
            end if
            lin(pos:pos+8)=loc1
            pos=pos+9
          end if
   25     continue
          lin(pos:pos+2)=' [ '
          pos=pos+3
          lin(pos:pos+eop-1)=pedigree
          pos=pos+eop
          write(loc1,'(a10)') id(i)
          lin(pos:pos+9)=loc1
          lin(pos+10:pos+12)=' ] '
          write(strm,'(a)') lin(1:pos+12)
   15   continue
      goto 10
   20 continue
      write(strm,'(a/a)') ';','end;'
      return
      end
C end-of-wrgda 
C
C write out Mapmaker-Sibs phenotype file
C
      subroutine wrphe(wrk,strm,pedigree,actset,num,nfound,id,fa,mo,sex,
     &                 locus,nloci,loctyp,locpos,numloc)
      integer MAXSIZ,MAXLOC,MISS
      parameter (MAXSIZ=1000,MAXLOC=120,MISS=-9999)
      integer strm,wrk
C Pedigree structure
      character*10 pedigree
      character*10 id(MAXSIZ)
      integer actset,num,nfound,fa(MAXSIZ),mo(MAXSIZ),sex(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)
C Locus structure
      integer nloci,loctyp(MAXLOC),locpos(MAXLOC)
      integer eop,i,j,nlp
      logical last
      character*10 chid
C functions
      integer eow

      pedigree=' '
      last=.false.
      nlp=0
      do 1 j=1,nloci
        if(loctyp(j).eq.3) nlp=nlp+1
    1 continue
      write(strm,'(i3)') nlp

      rewind(wrk)
   10 continue
       call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &            numloc, last)
       if (last) goto 20

        if (actset.le.0) goto 10

        eop=eow(pedigree)
        do 15 i=nfound+1,num
          call wrid('l',id(i),chid,0)
          write(strm,'(a,1x,a,$)') pedigree(1:eop),chid(1:eow(chid))
          do 25 j=1,nloci
          if (loctyp(j).eq.3) then
            if (locus(i,locpos(j)).eq.MISS) then
              write(strm,'(1x,a9,$)') '    -    '
            else
              write(strm,'(1x,f9.4,$)') locus(i,locpos(j))
            end if
          end if
   25     continue
          write(strm,*)
   15   continue
      goto 10
   20 continue
      return
      end
C end-of-wrphe 
C
C Write out pedigree as character-delimited
C typ
C 1   full pedigree
C 2   id,fa,mo,sex,ped (for SOLAR)
C 3   ped, id, data
C 4   id, data
C
      subroutine wrcsv(wrk,strm,typ,imp,nwid,ndec,
     2             pedigree,actset,num,nfound,
     3             id,fa,mo,sex,locus,nloci,loc,loctyp,locpos,numloc)
      integer LINSIZ,KNOWN,MAXSIZ,MAXLOC,MISS
      parameter (LINSIZ=1024,KNOWN=0,MAXSIZ=1000,
     &           MAXLOC=120,MISS=-9999)
      integer imp,ndec,nwid,strm,typ,wrk
C Pedigree structure
      character*10 pedigree
      integer actset,num,nfound 
      character*10 id(MAXSIZ) 
      integer fa(MAXSIZ),mo(MAXSIZ),sex(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)
C Locus structure
      integer nloci
      character*20 loc(MAXLOC)
      integer loctyp(MAXLOC),locpos(MAXLOC)
C local variables
      character*1 sep
      character*2 na
      character*7 gtp
      character*10 fdec
      character*20 loc20

      integer i,j
      logical last
C functions
      integer eow, sow

      na='NA'
      sep=','
C
C quantitative variable format
      call wrform('f', nwid, ndec, fdec)
      fdec(eow(fdec):(eow(fdec)+2))=',$)'
C header
      if (typ.eq.1) then
        write(strm, '(a,$)') 'ped,id,fa,mo,sex' 
      else if (typ.eq.2) then
        write(strm, '(a,$)') 'famid,id,fa,mo,sex' 
        na=' '
      else if (typ.eq.3) then
        write(strm, '(a,$)') 'famid,id' 
        na=' '
      else if (typ.eq.4) then
        write(strm, '(a,$)') 'id' 
        na=' '
      end if
      if (typ.ne.2) then
        do 1 i=1, nloci
        if (loctyp(i).lt.5) then
          write(strm,'(2a,$)')  sep, loc(i)(1:eow(loc(i))) 
        end if
    1   continue
      end if
      write(strm,*)

      last=.false.
      rewind(wrk)
   10 continue
       call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &            numloc, last)
       if (last) goto 20

       if (actset.le.0) goto 10

        do 15 i=1,num
C compulsory data
          if (typ.le.3) then
            write(strm,'(3a,$)') 
     &        pedigree(1:eow(pedigree)),sep,id(i)(1:eow(id(i)))
            if (typ.le.2) then
              if (fa(i).eq.MISS) then
                write(strm,'(4a,$)') sep,na,sep,na
              else
                write(strm,'(4a,$)')
     2            sep, id(fa(i))(1:eow(id(fa(i)))),
     3            sep, id(mo(i))(1:eow(id(mo(i)))) 
              end if
              if (sex(i).eq.1) then
                write(strm,'(2a,$)') sep, 'm'
              else if (sex(i).eq.2) then
                write(strm,'(2a,$)') sep, 'f'
              else
                write(strm,'(2a,$)') sep, na
              end if
            end if
          else if (typ.eq.4) then
            write(strm,'(a,$)') id(i)(1:eow(id(i)))
          end if
C phenotypes
          if (typ.ne.2) then
            do 25 j=1,nloci
              if (loctyp(j).le.2) then
                 write(strm,'(a,$)') sep
                 if (locus(i,locpos(j)).gt.KNOWN) then
                   call wrgtp(int(abs(locus(i,locpos(j)))),
     2                        int(abs(locus(i,locpos(j)+1))), gtp,1)
                   write(strm,'(a,$)') gtp(sow(gtp):eow(gtp))
                 else
                   write(strm,'(a,$)') na
                 end if
              elseif(loctyp(j).eq.3) then
                 write(strm,'(a,$)') sep
                 if (locus(i,locpos(j)).ne.MISS) then
                   write(loc20,fdec) locus(i,locpos(j))
                   write(strm,'(a,$)') loc20(sow(loc20):eow(loc20))
                 else
                   write(strm,'(a,$)') na
                 end if
              elseif(loctyp(j).eq.4) then
                 write(strm,'(a,$)') sep
                 if(locus(i,locpos(j)).eq.1.0) then
                   write(strm,'(a,$)') 'n'
                 elseif(locus(i,locpos(j)).eq.2.0) then
                   write(strm,'(a,$)') 'y'
                 else
                   write(strm,'(a,$)') na
                 end if
              end if
   25       continue
          end if
          write(strm,*)
   15   continue
      goto 10
   20 continue
      return
      end
C end-of-wrcsv 
C
C Describe pedigree using dot graphics language
C
      subroutine wrdot(wrk,strm,trait,gene,pedigree,actset,num,nfound,
     &             id,fa,mo,sex,locus,nloci,loctyp,locpos,numloc,lin)
      integer LINSIZ,KNOWN,MAXSIZ,MAXLOC,MISS
      parameter (LINSIZ=1024,KNOWN=0,MAXSIZ=1000,
     &           MAXLOC=120,MISS=-9999)
      integer gene,trait,strm,wrk
C Pedigree structure
      character*10 pedigree
      integer actset,num,nfound 
      character*10 id(MAXSIZ) 
      integer fa(MAXSIZ),mo(MAXSIZ),sex(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)
C Locus structure
      integer nloci,loctyp(MAXLOC),locpos(MAXLOC)
      character*(LINSIZ) lin
C local variables
      character*7 gtp
      character*8 marriage, shap, shade
      integer currf, currm, i,nfam
      logical last
C functions
      integer eow
C
      last=.false.
      rewind(wrk)
   10 continue
       call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &            numloc, last)
       if (last) goto 20

        if (actset.le.0) goto 10

        write(strm,'(3a/a/a/a/3a/a/)') 
     2    'digraph Ped_', pedigree, ' {',
     3    '# page = "8.2677165,11.692913" ;', 'ratio = "auto" ;',
     4    'mincross = 2.0 ;', 'label = "Pedigree ', 
     5    pedigree(1:eow(pedigree)), '" ;','rotate = 90 ;'
        do 15 i=1,num
          if (sex(i).eq.1) then
            shap='box'
          elseif (sex(i).eq.2) then
            shap='circle'
          else
            shap='diamond'
          end if
          if (trait.ne.MISS .and. locus(i,trait).eq.2) then
            shade='grey'
          else
            shade='white'
          end if
          write(strm,'(4a,$)') 
     &      '"',id(i)(1:eow(id(i))),'" [shape=',shap 
          if (gene.ne.MISS) then
            call wrgtp(int(locus(i, gene)), int(locus(i, gene+1)), 
     &                 gtp, 1)
            write(strm,'(3a,$)') 'label="\\N\\n', gtp, '"'
          end if
          write(strm,'(3a)') 
     &      ', regular=1,style=filled,fillcolor=',shade,'] ;'
   15   continue
        nfam=0
        currf=MISS   
        currm=MISS   
        do 25 i=nfound+1, num
          if (fa(i).ne.currf .or. mo(i).ne.currm) then
            nfam=nfam+1
            write(marriage,'(a4,i4.4)') 'marr',nfam
            currf=fa(i)
            currm=mo(i)
            write(strm,'(4a/5a/5a)') '"', marriage,'" [shape=diamond,',
     2        'style=filled,label="",height=.1,width=.1] ;',
     3        '"',id(currf)(1:eow(id(currf))),'" -> "', marriage,
     4        '" [dir=none,weight=1] ;',  
     5        '"',id(currm)(1:eow(id(currm))),'" -> "', marriage,
     6        '" [dir=none,weight=1] ;'
          end if
          write(strm,'(5a)') '"', marriage,'" -> "',id(i)(1:eow(id(i))),
     &     '" [dir=none, weight=2] ;'
   25   continue
        write(strm,'(a)')  '}'
      goto 10
   20 continue
      return
      end
C end-of-wrdot 
C
C Write out data for particular pedigree or particular person 
C
      subroutine showdata(wrk,fped,fid,larg,words,
     2              nloci,loc,loctyp,locpos, pedigree, actset,
     3              num,nfound,id,fa,mo,sex,locus, numloc, nwid, ndec)
      integer MAXLOC, MAXCOL, MAXSIZ, MISS
      parameter (MAXLOC=120, MAXCOL=MAXLOC+5, MAXSIZ=1000, MISS=-9999)

      integer fid,fped,larg,ndec,nwid, wrk
      character*20 words(MAXCOL)
C Pedigree structure
      character*10 pedigree
      integer actset,num, nfound
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ), sex(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)
C Locus structure
      character*20 loc(MAXLOC)
      integer nloci,loctyp(MAXLOC),locpos(MAXLOC)
C
      integer i, j, nrec
      logical found, last
C functions
      logical strfind
C interrupt
      integer irupt
      common /flag/ irupt

      irupt=0
      nrec=0
      last=.false.
      rewind(wrk)
   10 continue
       call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &            numloc, last)
       if (last .or. irupt.ne.0) goto 20

        if (actset.le.0) goto 10

        found=.false.
        do 50 j=fped, fid-2
        if (strfind(words(j)(1:10),pedigree,1)) then
          found=.not.found
          goto 60
        end if
   50   continue
   60   continue
        if (found) then
          if (fid.gt.larg) then
            do 70 i=1, num
              call wrind(i,pedigree,id,fa,mo,sex,
     &                   locus,nloci,loc,loctyp,locpos, nwid, ndec)
   70       continue
            nrec=nrec+num
          else
            do 75 i=1, num
              do 80 j=fid, larg 
              if (strfind(words(j)(1:10),id(i),1)) then
                call wrind(i,pedigree,id,fa,mo,sex,
     &                     locus,nloci,loc,loctyp,locpos, nwid, ndec)
                nrec=nrec+1
                goto 75
              end if
   80         continue
   75       continue
          end if
        end if
      goto 10
   20 continue
      write(*,'(/a,i6,a)') 'Printed ',nrec,' records.'
      return
      end
C end-of-showdata
C
C write out data for an individual
C
      subroutine wrind(idx,pedigree,id,fa,mo,sex,
     &                 locus,nloci,loc,loctyp,locpos, nwid, ndec)
      integer KNOWN,MAXSIZ,MAXLOC,MISS
      parameter (KNOWN=0,MAXSIZ=1000,MAXLOC=120,MISS=-9999)
      integer idx, ndec, nwid
C Pedigree structure
      character*10 pedigree
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ),mo(MAXSIZ),sex(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)
C Locus structure
      character*20 loc(MAXLOC)
      integer nloci,loctyp(MAXLOC),locpos(MAXLOC)
C local variables
      integer j, lpos
      character*1 ch
      character*7 gtp
      character*10 fdec
      character*20 curloc, loc20
C functions
      integer eow

      call wrform('f', nwid, ndec, fdec)
      call wrsex(sex(idx),ch)

      write(*,'(2a,1x,2a,$)') 
     2  'ped=', pedigree(1:eow(pedigree)),
     3  'id=',id(idx)(1:eow(id(idx))) 
      if (fa(idx).eq.MISS) then
        write(*,'(a,1x,$)') ' fa=x mo=x'
      else
        write(*,'(2a,1x,2a,$)') 
     2    ' fa=', id(fa(idx))(1:eow(id(fa(idx)))) ,
     3    'mo=', id(mo(idx))(1:eow(id(mo(idx))))  
      end if
      write(*,'(2a,$)') ' sex=',ch
      do 25 j=1,nloci
      if (loctyp(j).le.4) then
        lpos=locpos(j)
        curloc=loc(j)
        if (locus(idx,lpos).eq.MISS) then
          write(*,'(1x,2a,1x,$)') curloc(1:eow(curloc)), '=x'
        else if (loctyp(j).le.2) then
          if (locus(idx,lpos).le.KNOWN) then
            write(*,'(1x,2a,1x,$)') curloc(1:eow(curloc)), '=x'
          else
            call wrgtp(int(locus(idx,lpos)), 
     &                 int(locus(idx,lpos+1)),gtp,1)
            call juststr('l',gtp,7)
            write(*,'(1x,3a,1x,$)') 
     &         curloc(1:eow(curloc)), '=', gtp(1:eow(gtp))
          end if
        else if (loctyp(j).eq.4) then
          call wraff(locus(idx,lpos),ch)
          write(*,'(1x,3a,1x,$)') curloc(1:eow(curloc)), '=', ch
        else 
          write(loc20,fdec) locus(idx,lpos)
          call juststr('l',loc20,20)
          write(*,'(1x,3a,$)') curloc(1:eow(curloc)), '=',
     &                         loc20(1:eow(loc20))
        end if
      end if
   25 continue
      write(*,*)
      return
      end
C end-of-wrind 
C
C print subset of data for an individual -- for messages
      subroutine prdata(idx, sta, fin, typ, 
     &                  nloci, loc, loctyp, locpos, locus)
      integer KNOWN,MAXSIZ,MAXLOC,MISS 
      parameter (KNOWN=0,MAXSIZ=1000,MAXLOC=120,MISS=-9999)
      integer idx, fin, sta, typ
C Pedigree structure
      double precision locus(MAXSIZ,MAXLOC)
C locus structure
      integer nloci
      character*20 loc(MAXLOC)
      integer loctyp(MAXLOC), locpos(MAXLOC)
      integer i, j, lpos
      character*7 gtp
C function 
      integer eow

      do 10 i=1, sta
        write(*,'(a1,$)') ' '
   10 continue
      lpos=sta+1

      i=0
   20 continue
      if (lpos.gt.fin) goto 30
        i=i+1
        if (typ.eq.10 .or. loctyp(i).eq.typ) then
          if ((loctyp(i).eq.1 .or. loctyp(i).eq.2) .and.
     &         locus(idx,locpos(i)).gt.KNOWN) then
            j=eow(loc(i))
            write(*,'(2a,$)') loc(i)(1:j), '='
            lpos=lpos+j+2
            call wrgtp(int(locus(idx,locpos(i))), 
     &                 int(locus(idx,locpos(i)+1)),gtp,1)
            call juststr('l',gtp,7)
            j=eow(gtp)
            write(*,'(2a,$)') gtp(1:j),' '
            lpos=lpos+j+1
          end if
        end if
      goto 20
   30 continue
      write(*,*)
      return
      end
C end-of-prdata
