C
C Calculate BLUPs for VC model
C
      subroutine doblup(wrk,locnam,trait,h2,pedigree,actset,num,
     2             nfound,id,fa,mo,sex,locus,numloc,value,
     3             ainv, cov, plevel)
      integer IBDSIZ, MAXIBD, MAXSIZ, MAXLOC, MISS
      parameter (MAXSIZ=1000, MAXLOC=120, MAXIBD=1000, 
     &           IBDSIZ=MAXIBD*(MAXIBD+1)/2, MISS=-9999)
C
      integer plevel, trait, wrk
      character*10 locnam
      double precision h2
C  Pedigree structure
      character*10 pedigree
      integer actset,num, nfound
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ)
      integer sex(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)
C Array to contain covariances and inverse
      double precision value(MAXSIZ)
      double precision ainv(IBDSIZ), cov(IBDSIZ)
C local variables
      integer i, nobs
      logical last
      double precision fmu, gmu, lam, res, rss
      double precision bval(MAXSIZ)

      write(*,'(/a/a,a10,a,f5.1,a/a)') 
     2  '-----------------------------------------------------',
     3  'BLUPs for "',locnam,'" with H2 =',100.0*h2,'%', 
     4  '-----------------------------------------------------' 
      write(*,'(2a)') 'Pedigree  Individual  Observed   ',
     &                'BLUP     FamMean  Residual'
      nobs=0
      fmu=0.0d0
      gmu=0.0d0
      rss=0.0d0
      lam=(1.0d0-h2)/h2
      last=.false.
      rewind(wrk)
    5 continue
        call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &             numloc, last)
        if (last) goto 20
C
        if (actset.le.0) goto 5
C
        do 30 i=1,num
          value(i)=locus(i, trait)
          bval(i+2)=0.0d0
   30   continue
        call blup(lam, num, nfound, fa, mo, 
     &                value, ainv, cov, bval, fmu)
        do 50 i=1,num
          if (value(i).ne.MISS) then
            nobs=nobs+1
            gmu=gmu+fmu
            res=value(i)-fmu-bval(i)
            rss=rss+res*res
            write(*,'(a,1x,a,4(1x,f9.4))') 
     &        pedigree, id(i), value(i), bval(i), fmu, res
          else
            write(*,'(a,2(1x,a),3(1x,f9.4))') 
     &        pedigree, id(i), '    x    ', bval(i), fmu, 0.0d0
          end if
   50   continue
      goto 5
   20 continue
      gmu=gmu/dfloat(nobs)
      rss=rss/dfloat(nobs)
      write(*,'(/a,f12.4/a,f12.4)') 
     2  'Overall intercept       =', gmu,
     3  'Mean Square Error (VE)  =', rss
      return
      end
C end-of-doblup
C
C Calculate BLUPs for current pedigree 
C
      subroutine blup(lam, num, nfound, fa, mo, 
     &                value, ainv, cov, bval, fmu)
      integer IBDSIZ, MAXIBD, MAXSIZ, MISS
      parameter (MAXSIZ=1000, MISS=-9999, 
     &           MAXIBD=1000, IBDSIZ=MAXIBD*(MAXIBD+1)/2)
      integer nfound, num
C Pedigree structure
      integer fa(MAXSIZ),mo(MAXSIZ)
      double precision value(MAXSIZ)
      double precision bval(MAXSIZ)
C Array to contain kinship coefficients
      double precision ainv(MAXIBD)
C Work arrays for AS164
      integer ncov, nter
      double precision cov(MAXIBD)
C Heritability, estimated familial mean and RSS
      double precision fmu, lam
      integer i, j, nobs
      double precision tot
C functions
      integer clcpos

      nobs=0
      tot=0.0d0
      do 10 i=1,num
      if (value(i).ne.MISS) then
        nobs=nobs+1
        tot=tot+value(i)
      end if
   10 continue
      fmu=tot/dfloat(nobs)
      call invkin(num,nfound,fa,mo,ainv)
      nter=num+2
      ncov=nter*(nter+1)/2

      call inicov(nter, ncov, cov)

      do 200 i=1, num
        do 30 j=1, num
          bval(j)=lam*ainv(clcpos(i,j))
   30   continue
        bval(i)=bval(i)+1.0d0
        bval(num+1)=1.0d0
        if (value(i).ne.MISS) then
          bval(nter)=value(i)
        else
          bval(nter)=fmu
        end if
        call givenc(cov, ncov, nter, bval, 1.0d0, ifail)
  200 continue

      do 35 j=1,num
        bval(j)=1.0d0
   35 continue
      bval(num+1)=dfloat(num)
      bval(nter)=tot * dfloat(num)/dfloat(nobs)
      call givenc(cov, ncov, nter, bval, 1.0d0, ifail)
      call bsub(cov, ncov, nter, bval, nter-1, ifail)
      if (ifail.ne.0) write(*,*) 'ERROR in bsub()'
      fmu = bval(num+1)
      return
      end
C end-of-blup
C
C Variance components analysis 
C
      subroutine sibqtl(wrk,twrk,tranam,trait,locnam,gene,pedigree,
     2              actset,num, nfound,id,fa,mo,sex,locus,numloc,
     3              numal,name,alfrq, untyped,set,a,c,plevel,toler)
      integer KNOWN,MAXALL,IBDSIZ,MAXIBD,NPAR,MAXSIZ,MAXLOC,MISS
      parameter (KNOWN=0, MAXALL=60,MAXSIZ=1000,MAXLOC=120,
     2           MAXVP=60, MAXIBD=1000, 
     3           IBDSIZ=MAXIBD*(MAXIBD+1)/2, MISS=-9999)
C
      double precision GRADTL
      parameter (GRADTL = 1.0d-12)
C
      integer gene,trait,twrk,wrk,plevel
      character*10 locnam, tranam
      double precision toler
C  Pedigree structure
      character*10 pedigree
      integer actset,num, nfound
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ)
      integer sex(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)
C allele frequencies structure
      integer numal, name(MAXALL)
      double precision alfrq(MAXALL)
C Array to contain covariances and inverse
      double precision a(IBDSIZ), c(IBDSIZ)
C work arrays
      integer set(MAXSIZ,2)
      logical untyped(MAXSIZ)
      double precision parest(MAXVP), w(MAXVP*(MAXVP+5))
      double precision m(MAXSIZ),w1(MAXSIZ),w2(MAXSIZ),y(MAXSIZ)
C local variables
      integer currf, currm, fin, gen2, i, i1, i2, i3, i4, ier, iter,
     &        j, k, maxfn, modl, nn, nfix, pos, sibs, tot
      character*3 histo
      logical last
      double precision aelik, asyp, aqelik, d2, lod, ymean, yvar
C functions
      integer getnam
      double precision chip

      if (plevel.gt.0) then
        write(*,'(/a/a,a10,a,a10,a/a)') 
     2  '-----------------------------------------------------',
     3  'VC linkage analysis for "',tranam,'" v "' ,locnam,'"',
     4  '-----------------------------------------------------' 
      end if

      gen2=gene+1
      last=.false.
      nfix=1
      nfam=0
      npar=4
      sibs=0
      tot=0 
      ymean=0.0d0
      yvar=0.0d0
      rewind(wrk)
    5 continue
        call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &             numloc, last)
        if (last) goto 20
C
        if (actset.le.0) goto 5
C
        do 70 i=1,num
        if (locus(i,gene).gt.KNOWN) then
          untyped(i)=.false.
          set(i,1)=getnam(locus(i,gene),numal,name)
          set(i,2)=getnam(locus(i,gen2),numal,name)
        else  
          untyped(i)=.true.
          set(i,1)=MISS
          set(i,2)=MISS
        end if
   70   continue
C
C Full sibs
C
        fin=num
        currf=fa(fin)
        currm=mo(fin)
        do 90 k=num-1,nfound,-1
          if (fa(k).ne.currf .or. mo(k).ne.currm) then
            nobs=0
            do 92 i=k+1,fin
            if (locus(i,trait).ne.MISS .and. .not.untyped(i)) then 
              nobs=nobs+1
              tot=tot+1
              y(nobs)=locus(i,trait)
              call moment(tot,y(nobs),ymean,yvar)
            end if
   92       continue
C
C Skip if no usable individuals in this sibship
C else reduce ibd matrix to that for phenotyped individuals only
C
            if (nobs.gt.0) then
              nfam=nfam+1
              sibs=sibs+nobs*(nobs-1)/2
C kinships
              call filltri(nobs,nobs*(nobs+1)/2,a,1.0d0,0.5d0)
C ibds
              call nucibd(gene,currf,currm,k+1,fin,set,
     &                untyped, c, numal, name, alfrq)
              nn=0
              pos=0
              do 60 i=k+1,fin
                do 65 j=k+1,i
                  pos=pos+1
                  if (locus(i,trait).ne.MISS .and. .not.untyped(i) .and.
     &                locus(j,trait).ne.MISS .and. .not.untyped(j)) then
                    nn=nn+1
                    a(nn)=a(pos)
                  end if
   65           continue
   60         continue
C     pos=0
C     do kk=1, nobs
C       write(*,'(i2,1x,f8.4,100(1x,f6.4):)') kk,y(kk),(a(pos+i),i=1,kk)
C       pos=pos+kk
C     end do
              write(twrk) nobs, nn, nfix, 
     2                    ((locus(i,j), j=1, nfix), y(i), i=1, nobs),
     3                    (a(i), i=1, nn), (c(i),i=1, nn)
            end if
C Now update to next sibship
            fin=k
            currf=fa(fin)
            currm=mo(fin)
          end if
   90   continue
C
      goto 5
   20 continue
C
C plug in starting values and iterate for MLEs
C
      if (sibs.eq.0) return

      yvar=yvar/dfloat(tot)
      maxfn=5000

      npar=3
      parest(1)=ymean
      parest(2)=0.1d0*yvar
      parest(3)=0.9d0*yvar
C
      aelik=0.0d0
      modl=1
      call initvm(npar, i1,i2,i3,i4, ier)
      call varmet(npar,parest,aelik,w(i3),w,w(i1),w(i2),w(i4),
     2            GRADTL,toler,maxfn,ier,iter,twrk,modl,nfix,
     3            y,locus,a,c,m,w1,w2,plevel)
      if (ier.ne.0) call vmerr(ier, maxfn)

      call mvnlik(twrk,modl,npar,nfix,parest,y,locus,a,aelik,c,m,w1,w2)

      npar=4
      modl=2
      parest(4)=abs(parest(3))
      parest(3)=0.1d0*abs(parest(2))
      parest(2)=0.9d0*abs(parest(2))
      aqelik=0.0d0
      call initvm(npar, i1,i2,i3,i4, ier)
      call varmet(npar,parest,aqelik,w(i3),w,w(i1),w(i2),w(i4),
     &            GRADTL,toler,maxfn,ier,iter,twrk,modl,nfix,
     3            y,locus,a,c,m,w1,w2,plevel)
      if (ier.ne.0) call vmerr(ier, maxfn)

      call mvnlik(twrk,modl,npar,nfix,parest,y,locus,a,aqelik,c,m,w1,w2)
      d2=aelik-aqelik
      lod=0.217142d0*d2
      asyp=chip(d2,1)

      parest(2)=abs(parest(2))
      parest(3)=abs(parest(3))
      parest(4)=abs(parest(4))
      yvar=100.0d0/(parest(2)+parest(3)+parest(4))
      if (plevel.gt.0) then
        write(*,'(2(/a,i5))') 
     2    'Number of sibships         = ', nfam,
     3    'Number of observations     = ', tot  
        write(*,'(a,f12.6,3(/a,f12.6,a,f5.1,a))') 
     2  'Trait mean                 = ', parest(1),
     3  'Additive genetic variance  = ', parest(2), 
     4  ' (',parest(2)*yvar,'%)',
     5  'QTL genetic variance       = ', parest(3), 
     6  ' (',parest(3)*yvar,'%)',
     7  'Environmental variance     = ', parest(4), 
     8  ' (',parest(4)*yvar,'%)' 
        write(*,'(a,f8.2,4x,a,f5.2,a/a,i5)') 
     5  'Linkage chi-square (lod)   = ', d2,' (',lod,')',
     6  'Total function evaluations = ', iter 
      else
        call phist(asyp,1.0d0,histo)
        write(*,'(a10,1x,i6,3x,a,4x,f10.1,2(1x,f6.4),1x,i6,2(1x,a))')
     &    locnam, sibs, '-', lod, asyp, 1.0d0, 0, 'VC ',histo
      end if
      return
      end
C end-of-sibqtl 
C
C Variance components analysis 
C typ 1=CE 2=AE 3=ACE 4=ADE 
C     5=AQE (6 if ibd matrix in script)
C     7=CQE
C
      subroutine varcom(wrk,wrk2,twrk,nterms,terms,loc,loctyp,locpos,
     2              locnam, gene, numal, name, parest, mean, 
     3              pedigree,actset,num,nfound,id,fa,mo,sex,
     4              locus,numloc,untyped,a,c,mlik,mpar,plevel,typ,toler)
      integer IBDSIZ,MAXALL,MAXIBD,MAXVP,MAXSIZ,MAXTER,MAXLOC,MISS
      parameter (MAXALL=60, MAXSIZ=1000, MAXLOC=120, MAXVP=60,
     2           MAXIBD=1000, IBDSIZ=MAXIBD*(MAXIBD+1)/2,
     3           MAXTER=MAXIBD/2, MISS=-9999)
C
      double precision GRADTL
      parameter (GRADTL = 1.0d-14)
C gene=a covariate marker, mpar=no. model parameters, nterms=no. traits,
C typ=model to be fitted AE ADE AQE, llik=final model loglik
C twrk=stream for ibds, wrk2=scratch file for likelihood
      integer gene, mpar, nterms, plevel, twrk, typ, wrk, wrk2
      double precision mlik, toler
C If linkage the marker 
      character*10 locnam
C if a marker among the covariates, the allele names
      integer numal
      integer name(MAXALL)
C position of y and x variables
      integer terms(MAXSIZ)
C overall means for variables 
      double precision mean(MAXTER)
C  Pedigree structure
      character*10 pedigree
      integer actset,num, nfound
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ)
      integer sex(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)
C Locus structure:
C number of loci, locus name, locus type, and locus position in file
      character*20 loc(MAXLOC)
      integer loctyp(MAXLOC),locpos(MAXLOC)
C Array to contain covariances and inverse
      double precision a(IBDSIZ), c(IBDSIZ)
C row of design matrix
      integer nfix
      double precision val(MAXLOC)
C other work arrays
      logical untyped(MAXSIZ)
      double precision parest(MAXVP)  
      double precision w(MAXVP*(MAXVP+5))
      double precision m(MAXSIZ), w1(MAXSIZ), w2(MAXSIZ), y(MAXSIZ)
C local variables
      integer i, i1, i2, i3, i4, ier, iter1, iter2, 
     &        maxfn, modl, ncat, nn, pos, ppos, tot, ypos
      character*3 allel, histo  
      character*3 ranmod(7)
      character*20 label
      logical last
      double precision asyp, lik, lik_ae, lik_e, domtest, gentest,
     &                 va, vd, ve, ymean, yvar
C functions
      logical complete
      integer eow
      double precision chip
      data ranmod /'C  ','A  ','A+C','A+D','A+Q','A+Q','C+Q'/

      nfix=nterms
      if (gene.gt.0) nfix=nfix+numal-2

      if (nfix.gt.MAXLOC) then
        write(*,'(a)') 'ERROR: Too many fixed effects specified.'
        return
      end if

      last=.false.
      nfam=0
      tot=0 
      ypos=locpos(terms(nterms))
      lik=0.0d0
      lik_ae=0.0d0
      lik_e=0.0d0
      ymean=0.0d0
      yvar=0.0d0
      rewind(wrk)
    5 continue
        call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &             numloc, last)
        if (last) goto 20
C
        if (actset.le.0) goto 5
C
        nobs=0

        do 50 i=1,num
        if (complete(i, nterms, terms, locpos, loctyp, locus)) then
          untyped(i)=.false.
          nobs=nobs+1
          tot=tot+1
          y(nobs)=locus(i,ypos)
          call moment(tot, y(nobs), ymean, yvar)
          call fixeff(i, 1, gene, numal, name, nterms, terms, 
     &                loctyp, locpos, mean, locus, val)
          do 53 j=1, nfix   
            locus(nobs,j)=val(j)
   53     continue
        else
          untyped(i)=.true.
        end if
   50   continue
C
C load the random effects covariance matrices (a and c)
C
        if (typ.ne.1 .and. typ.ne.7) then
          call kinship(num,nfound,fa,mo,a)
        else
          call filltri(num, num*(num+1)/2, a, 1.0d0, 1.0d0)
        end if
        if (typ.eq.3) then
          call filltri(num, num*(num+1)/2, c, 1.0d0, 1.0d0)
        else if (typ.eq.4) then
          call frater(num,nfound,fa,mo,a,c)
        else if (typ.eq.5 .or. typ.eq.7) then
          idx=0
          do 55 i=1, num
            read(twrk,*) (c(j),j=idx+1,idx+i)
            if (plevel.gt.1) then
              write(*,'(a10,12(1x,f5.3):)') 
     &          id(i),(c(j),j=idx+1,min(idx+12,idx+i))
            end if
            idx=idx+i
   55     continue
        else if (typ.eq.6) then
          read(*,*) (c(i),i=i,num*(num+1)/2)
        end if
C
C drop matrix entries for incomplete records
        if (nobs.ne.num) then
          nn=0
          pos=0
          do 60 i=1, num
            if (.not.untyped(i)) then
              do 65 j=1,i
              if (.not.untyped(j)) then
                nn=nn+1
                a(nn)=a(pos+j)
                c(nn)=c(pos+j)
              end if
   65         continue
            end if
            pos=pos+i
   60     continue
        else
          nn=nobs*(nobs+1)/2
        end if
        if (nobs.gt.0) then
          nfam=nfam+1
          write(wrk2) nobs, nn, nfix, 
     2                ((locus(i,j), j=1, nfix), y(i), i=1, nobs),
     3                (a(i), i=1, nn), (c(i), i=1, nn)
        end if
C
      goto 5
   20 continue
      yvar=yvar/dfloat(tot)
C
      if (typ.lt.5 .or. plevel.gt.0) then
        write(*,'(/a/a,a10,a/a)') 
     2    '------------------------------------------------',
     3    'Variance components analysis for "',loc(terms(nterms)),'"',
     4    '------------------------------------------------' 
        if (nfix.gt.1) then
          write(*, '(3a,$)') ' Fixed: ',
     &       loc(terms(nterms))(1:eow(loc(terms(nterms)))), ' ~ mu'
          do 95 j=1, nterms-1
            write(*,'(2a,$)')
     &       ' + ', loc(terms(j))(1:eow(loc(terms(j))))
            if (terms(j) .eq. gene) then
              write(*,'(a,$)') '(M)'
            end if
   95     continue
          write(*,*)
        end if
        write(*,'(2a,$)') 'Random: ',ranmod(typ)
        if (typ.gt.4) then
          write(*,'(3a,$)') '{',locnam(1:eow(locnam)),'}'
        end if
        write(*,*)


        write(*,'(2(/a,i5))') 
     2    'Number of families         = ', nfam,
     3    'Number of observations     = ', tot  
      end if
C
C plug in starting values and iterate for MLEs
C ADE
C
      maxfn=5000
      npar=nfix
      npar=npar+1
      parest(npar)=0.1d0*yvar
      if (typ.gt.2) then
        modl=2
        npar=npar+1
        parest(npar)=0.1d0
        npar=npar+1
        parest(npar)=0.8d0*yvar

        call initvm(npar, i1,i2,i3,i4, ier)
        call varmet(npar,parest,lik,w(i3),w,w(i1),w(i2),w(i4),GRADTL,
     &              toler,maxfn,ier,iter1,wrk2,modl,nfix,y,locus,a,c,m,
     3              w1,w2,plevel)
C
        if (ier.ne.0) call vmerr(ier, maxfn)
        
        call mvnlik(wrk2,modl,npar,nfix,parest,y,locus,a,lik,c,m,w1,w2)
        va=abs(parest(nfix+1))
        vd=abs(parest(nfix+2))
        ve=abs(parest(nfix+3))

C starting values for AE run
        parest(nfix+1)=va+vd
        parest(nfix+2)=ve
      else
        npar=npar+1
        parest(npar)=0.9d0*yvar
      end if
C AE
      npar=nfix+2
      modl=1

      call initvm(npar, i1,i2,i3,i4, ier)
      call varmet(npar,parest,lik_ae,w(i3),w,w(i1),w(i2),w(i4),GRADTL,
     2            toler,maxfn,ier,iter2,wrk2,modl,nfix,y,locus,a,c,m,
     3            w1,w2,plevel)
C
      if (ier.ne.0) call vmerr(ier, maxfn)
        
      domtest=0.0d0
      if (typ.gt.2) domtest=lik_ae-lik
C Choose simplest model to report 
      if (typ.lt.5 .and. domtest .le. 3.84d0) then
        call mvnlik(wrk2,modl,npar,nfix,parest,y,locus,a,lik,c,m,w1,w2)
        va=abs(parest(nfix+1))
        vd=0.0d0
        ve=abs(parest(nfix+2))
C grid
C       do kk=1, 49
C         parest(2)=0.02*dfloat(kk)*yvar
C         parest(3)=yvar-parest(2)
C         call mvnlik(wrk2,modl,npar,nfix,parest,y,locus,a,lik,c,m,w1,w2)
C         write(*,*) -0.5d0*lik, parest(2), parest(3)
C       end do
      else if (typ.gt.2) then
        npar=nfix+3
      else
        lik=lik_ae
      end if
C test A(D)E v E
      if (nfix.eq.1) then
        lik_e = dfloat(tot)*(log(yvar)+1.0d0)
      else
        modl=0
        call initvm(nfix+1, i1,i2,i3,i4, ier)
        call varmet(nfix+1,parest,lik_e,w(i3),w,w(i1),w(i2),w(i4),
     2              GRADTL,toler,maxfn,ier,iter2,wrk2,modl,nfix,
     3              y,locus,a,c,m,w1,w2,plevel)
      end if
      gentest=lik_e-lik

      yvar=100.0d0/(va + vd + ve)
      asyp=chip(domtest,1)

      if (typ.lt.5 .or. plevel.gt.0) then
        ppos=1
        write(*,'(a,f12.6)') 
     2    'Trait mean (intercept)     = ', parest(ppos) 
        do 120 j=1, nterms-1
          pos=terms(j)
          ncat=1
          if (pos.eq.gene) ncat=numal-1
          do 121 k=1, ncat
            ppos=ppos+1
            label=loc(pos)
            if (pos.eq.gene) then
              call wrall(name(k+1), allel)
              call juststr('l',allel,3)
              label=label(1:eow(label)) // '*' // allel(1:eow(allel))
            end if
            write(*,'(3a,f12.6)') 
     &        'Beta ',label        , '  = ', parest(ppos)
  121     continue
  120   continue
        if (typ.ne.1 .and. typ.ne.7) then
          write(*,'(/a,f12.6,a,f5.1,a)') 
     3      'Additive genetic variance  = ', va  , ' (',va*yvar,'%)' 
        else
          write(*,'(/a,f12.6,a,f5.1,a)') 
     3      'Familial variance          = ', va  , ' (',va*yvar,'%)' 
        end if
        if (npar.eq.(nfix+3)) then
          if (typ.eq.4) then
            write(*,'(a,f12.6,a,f5.1,a)') 
     &      'Dominance genetic variance = ', vd  , ' (',vd*yvar,'%)' 
          else if (typ.eq.5 .or. typ.eq.6 .or. typ.eq.7) then
            write(*,'(a,f12.6,a,f5.1,a)') 
     &      'QTL genetic variance       = ', vd  , ' (',vd*yvar,'%)' 
          else if (typ.eq.3) then
            write(*,'(a,f12.6,a,f5.1,a)') 
     &      'Familial env variance      = ', vd  , ' (',vd*yvar,'%)' 
          end if
        end if
        write(*,'(a,f12.6,a,f5.1,a/a,f12.6)')
     2    'Environmental variance     = ', ve  , ' (',ve*yvar,'%)',
     3    'Model loglikelihood        = ', -0.5d0*lik 
        if (typ.eq.4) then
          write(*,'(/a,f8.2,4x,a,i1,a,f5.3,a)') 
     2      'Chi-square testing VD=0    = ', domtest,
     3      ' (df=',1,', P=',asyp,')' 
        else if (typ.eq.5 .or. typ.eq.6 .or. typ.eq.7) then
          write(*,'(/a,f8.2,4x,a,i1,a,f5.3,a)') 
     2      'Chi-square testing VQ=0    = ', domtest,
     3      ' (df=',1,', P=',asyp,')' 
        else if (typ.eq.3) then
          write(*,'(/a,f8.2,4x,a,i1,a,f5.3,a)') 
     2      'Chi-square testing VC=0    = ', domtest,
     3      ' (df=',1,', P=',asyp,')' 
        end if
        if (typ.ne.1 .and. typ.ne.7) then
          write(*,'(/a,f8.2,4x,a,i1,a,f5.3,a)') 
     4      'Chi-square testing VG=0    = ', gentest,
     5      ' (df=',npar-nfix-1,', P=',chip(gentest,npar-nfix-1),')' 
        else
          write(*,'(/a,f8.2,4x,a,i1,a,f5.3,a)') 
     4      'Chi-square testing VC=0    = ', gentest,
     5      ' (df=',npar-nfix-1,', P=',chip(gentest,npar-nfix-1),')' 
        end if
        write(*,'(a,i5)') 
     &    'Total function evaluations = ', max(iter1,iter2) 
      else
        call phist(asyp,1.0d0,histo)
        write(*,'(a10,2(1x,i6),1x,f10.1,2(1x,f6.4),1x,i6,2(1x,a))')
     2    locnam, nfam, tot, 0.217142d0*domtest, 
     3    asyp, 1.0d0, 0, 'VC ',histo
      end if
C return model loglik for construction of LRTS
      mpar=npar
      mlik=lik
      return
      end
C end-of-varcom 
C
C MVN model loglikelihood
C
      subroutine mvnlik(twrk,typ,npar,nfix,parest,y,x,a,q,c,m,w1,w2)
C
      integer IBDSIZ, MAXLOC, MAXSIZ
      parameter (MAXLOC=120, MAXSIZ=1000, IBDSIZ=MAXSIZ*(MAXSIZ+1)/2)

      integer npar, nfix, typ, twrk
      double precision x(MAXSIZ, MAXLOC)
      double precision parest(*),q
      double precision y(MAXSIZ), a(IBDSIZ)
C work arrays
      double precision c(IBDSIZ),m(MAXSIZ),w1(MAXSIZ),w2(MAXSIZ)
C local variables
      integer i, ifault, n, nn, nullty, pos
      double precision quad, logdet, va, ve, vq, ymean, yp
C     integer clcpos

      ifault=0
      nullty=0
      q=0.0d0
      ymean=parest(1)
      va=0.0d0
      vq=0.0d0
      ve=abs(parest(npar))
      if (typ.ge.1) va=abs(parest(nfix+1))
      if (typ.eq.2) vq=abs(parest(nfix+2))
      
      rewind(twrk)
   10 continue
        read(twrk,end=50) n, nn, nfix, 
     2                    ((x(i,j), j=1,nfix), y(i), i=1,n),
     &                    (a(i),i=1, nn), (c(i),i=1, nn)
        pos=0
        do 15 i=1,nn
          a(i)=a(i)*va+c(i)*vq
   15   continue
        do 20 i=1,n
          pos=pos+i
          yp=ymean
          do 21 j=2, nfix
            yp=yp+parest(j)*x(i,j)
   21     continue
          m(i)=yp
          a(pos)=a(pos)+ve
   20   continue
        call syminv(a,n,nn,c,w1,logdet,nullty,ifault)
        if (ifault.ne.0) then 
          q=1.0d99
        else
          call quadform(n,y,m,nn,c,w1,w2,quad)
          q=q+logdet+quad
        end if
      goto 10
   50 continue
      return
      end
C end-of-mvnlik
C
C AS 319 Varmet: likelihood function work arrays passed directly
C                likelihood function explicitly named
C
      subroutine varmet(npar,b,f0,g,h,c,d,t,gradtl,toler,maxfn,ifault,
     &                  ifn,twrk,typ,nfix,y,x,a,ainv,m,w1,w2,plevel)
      integer irupt
      common /flag/ irupt

      integer IBDSIZ, ICMAX, MAXLOC, MAXIBD, MAXSIZ
      double precision W
      parameter (ICMAX=20, MAXLOC=120, MAXSIZ=1000, MAXIBD=1000, 
     2           IBDSIZ=MAXIBD*(MAXIBD+1)/2, W=0.2d0)
      integer ifn, nfix, plevel, twrk, typ
      double precision x(MAXSIZ, MAXLOC)
      double precision b(npar),f0, g(npar), h(npar,npar),c(npar),
     &                 d(npar),t(2*npar),gradtl,toler,d1,s,ck,f1,d2
      double precision a(IBDSIZ), y(MAXSIZ)
C work arrays
      double precision ainv(IBDSIZ),m(MAXSIZ),w1(MAXSIZ),w2(MAXSIZ)
C local variables
      integer i, ic, icount, ilast, ig, k, l, np
C
      ig = 0
      ifn = 0
      ifault = 0
      irupt = 0
      np = npar + 1
C
      call mvnlik(twrk,typ,npar,nfix,b,y,x,a,f0,ainv,m,w1,w2)
      ifn = ifn + 1
      if (plevel.gt.1) then
        write(*,'(i4,1x,f12.6,(t17,10(1x,f12.6)):)') 
     &    ifn, f0, (b(i),i=1, npar)
      end if
C
      call grad(npar,b,f0,g,t(np),gradtl,ifault,
     &          twrk,typ,nfix,y,x,a,ainv,m,w1,w2)
      if (ifault.gt.0) return
C
      ig = ig + 1
      ifn = ifn + npar
      if (ifn.gt.maxfn) then
        ifault = 4
        return
      endif
C
   10 do 30 k = 1,npar
         do 20 l = 1,npar
            h(k,l) = 0.0d0
   20    continue
         h(k,k) = 1.00d0
   30 continue
      ilast = ig
C
   40 do 50 i = 1,npar
         d(i) = b(i)
         c(i) = g(i)
   50 continue
C
      d1 = 0.0d0
      do 70 i = 1,npar
         s = 0.0d0
         do 60 j = 1,npar
            s = s - h(i,j)*g(j)
   60    continue
         t(i) = s
         d1 = d1 - s*g(i)
   70 continue
C
      if(d1.le.0.0d0) then
         if(ilast.eq.ig) then
            return
         endif
         go to 10
      else
         ck = 1.0d0
         ic = 0
   90    icount = 0
         do 100 i = 1,npar
            b(i) = d(i) + ck*t(i)
            if(b(i).eq.d(i)) then
               icount = icount + 1
            endif
  100    continue
C
         if(icount.ge.npar) then
            if(ilast.eq.ig) then
               return
            endif
            go to 10
         else
            call mvnlik(twrk,typ,npar,nfix,b,y,x,a,f1,ainv,m,w1,w2)
            ifn = ifn + 1
            if (plevel.gt.1) then
              write(*,'(i4,1x,f12.6,(t17,10(1x,f12.6)):)') 
     &          ifn, f0, (b(i),i=1, npar)
            end if
            if (ifn.gt.maxfn) then
              ifault = 4
              return
            else if (irupt.gt.0) then
              ifault = 5
              return
            else if (f1.eq.1.0d99) then
              ck = W * ck
              ic = ic+1
              if (ic.gt.ICMAX) then
                ifault = 3
                return
              endif
              go to 90
C
            else if(f1.ge.f0 - d1*ck*toler) then
               ck = W * ck
               go to 90
            else
               f0 = f1
               call grad(npar,b,f0,g,t(np),gradtl,ifault,
     &                   twrk,typ,nfix,y,x,a,ainv,m,w1,w2)
               if(ifault.gt.0) then
                  return
               endif
               ig = ig + 1
               ifn = ifn + npar
               if(ifn.gt.maxfn) then
                  ifault = 4
                  return
               endif
C
               d1 = 0.0d0
               do 130 i = 1,npar
                  t(i) = ck*t(i)
                  c(i) = g(i) - c(i)
                  d1 = d1 + t(i)*c(i)
  130          continue
C
               if(d1.le.0.0d0) then
                  goto 10
               endif
C
               d2 = 0.0d0
               do 150 i = 1,npar
                  s = 0.0d0
                  do 140 j = 1,npar
                     s = s + h(i,j)*c(j)
  140             continue
                  d(i) = s
                  d2 = d2 + s*c(i)
  150          continue
               d2 = 1.0d0 + d2/d1
C
               do 170 i = 1,npar
                  do 170 j = 1,npar
                     h(i,j) = h(i,j) - (t(i)*d(j) + d(i)*t(j) -
     &               d2*t(i)*t(j))/d1
  170          continue
            endif
         endif
      endif
      go to 40
      end
C end-of-varmet
C
C Approximate gradient
C
      subroutine grad(npar,b,f0,g,sa,er,ifault,
     &                twrk,typ,nfix,y,x,a,c,m,w1,w2)
      integer IBDSIZ, MAXIBD, MAXLOC, MAXSIZ
      parameter (MAXSIZ=1000, MAXLOC=120, MAXIBD=1000, 
     &           IBDSIZ=MAXIBD*(MAXIBD+1)/2)
      integer ifault, nfix, npar, twrk, typ
      double precision x(MAXSIZ, MAXLOC)
      double precision b(npar),er,f0,g(npar),h,sa(npar)
      double precision a(IBDSIZ), y(IBDSIZ)
C work arrays
      double precision c(IBDSIZ),m(MAXSIZ),w1(MAXSIZ),w2(MAXSIZ)
C local variables 
      integer i, jc, jcmax
      double precision f1
C
      jcmax=npar-2
      jc = 0
C
      do 20 i = 1,npar
        h =(dabs(b(i)) +dsqrt(er)) *dsqrt(er)
        sa(i) = b(i)
        b(i) = b(i) + h
        call mvnlik(twrk,typ,npar,nfix,b,y,x,a,f1,c,m,w1,w2)
        b(i) = sa(i)
C
        if (f1.eq.1.0d99) then
          f1 = f0 + h
          jc = jc + 1
        endif
C
        g(i) = (f1 -f0)/h
   20 continue
C
      if (jc.gt.jcmax) ifault = 2
      return
      end
C end-of-grad
C 
C Initialize varmet work arrays etc
C
      subroutine initvm(npar, i1,i2,i3,i4, ier)
      integer i1,i2,i3,i4,ier,npar
      ier=0
      i1 = npar*npar + 1
      i2 = i1 + npar
      i3 = i2 + npar
      i4 = i3 + npar
      return
      end
C end-of-initvar
C
C varmet error messages
C
      subroutine vmerr(ier, maxfn)
      integer ier, maxfn
      if (ier.eq.1) then
        write(*,'(/a/)') 'ERROR: Likelihood undefined at initial value.'
      else if (ier.eq.2) then
        write(*,'(/a/)') 'ERROR: Gradient undefined in too many dims.'
      else if (ier.eq.3) then
        write(*,'(/a/)') 'ERROR: Unable to find minimum.'
      else if (ier.eq.4) then
        write(*,'(/a,i4,a/)') 'ERROR: Exceeded ',maxfn,' evaluations.'
      else if (ier.eq.5) then
        write(*,'(/a/)') 'ERROR: Terminated by user prematurely.'
      end if
      return
      end
C end-of-vmerr
C
C A row of the design matrix for the fixed effects part of model for
C varcom and segsim.
C Possibly including one marker for full dummy encoding.
C Possibly including an intercept.
C Missing x values replaced by overall mean
C
      subroutine fixeff(idx,interc,gene,numal,name, nterms, terms, 
     &                  loctyp, locpos, mean, locus, val)
      integer KNOWN, MAXALL, MAXIBD, MAXSIZ, MAXTER, MAXLOC, MISS
      parameter (KNOWN=0, MAXALL=60, MAXSIZ=1000, MAXLOC=120,
     &            MISS=-9999, MAXIBD=1000, MAXTER=MAXIBD/2)
      integer idx, interc, nterms
C the marker position, number and names of alleles
      integer gene, numal, name(MAXALL)
C position of y and x variables
      integer terms(MAXSIZ)
      integer loctyp(MAXLOC),locpos(MAXLOC)
C and their overall means
      double precision mean(MAXTER)
C data input and output arrays
      double precision locus(MAXSIZ, MAXLOC), val(MAXLOC)
C
      integer a1, a2, j, pos, vpos
C functions
      integer getnam

      vpos=0
      if (interc.eq.1) then
        vpos=1
        val(vpos)=1.0
      end if
      do 5 j=1, nterms-1
        pos=terms(j)
        if (pos.eq.gene) then
          if (locus(idx, locpos(gene)).gt.KNOWN) then
            do 10 k=1, numal-1
              val(vpos+k)=0.0
   10       continue
            a1=getnam(locus(idx,locpos(gene)),numal,name)-1
            a2=getnam(locus(idx,locpos(gene)+1),numal,name)-1
            if (a1.gt.0) val(vpos+a1)=val(vpos+a1) + 1
            if (a2.gt.0) val(vpos+a2)=val(vpos+a2) + 1
          else
            do 15 k=1, numal-1
              val(vpos+k)=mean(vpos+k-interc)
   15       continue
          end if
          vpos=vpos+numal-1
        else if (loctyp(pos).le.2) then
          vpos=vpos+1
          if (locus(idx, locpos(pos)).gt.KNOWN) then
            val(vpos)=0.5*(locus(idx,locpos(pos)) + 
     &                     locus(idx,locpos(pos)+1))
          else
            val(vpos)=mean(vpos-interc)
          end if
        elseif (loctyp(pos).eq.4) then
          vpos=vpos+1
          if (locus(idx, locpos(pos)).ne.MISS) then
            val(vpos)=locus(idx,locpos(pos))-1.0
          else
            val(vpos)=mean(vpos-interc)
          end if
        else if (loctyp(pos).eq.3) then
          vpos=vpos+1
          if (locus(idx, locpos(pos)).ne.MISS) then
            val(vpos)=locus(idx,locpos(pos))
          else
            val(vpos)=mean(vpos-interc)
          end if
        end if
    5 continue
      return
      end
C end-of-fixeff
