C |||| SIB-PAIR: A program for simple genetic analysis
C |\/| Version : HEAD_TXT
C |/\| Author  : David L Duffy (c) 1995-2006
C ||||
C Program SIB-PAIR imputes missing parental genotypes where unequivocal
C and does TDT,APM, association and sib-pair analyses.
C Data is read from a GAS type datafile.
C
C C-Preprocessor (ifdef) statements are used to select
C platform specific features: the non-F77-standard time, date and
C iand functions.
C
C The input/output streams
C
      integer INSTRM,CSTRM,LSTR,OSTR,OSTR2,WRK,WRK2,TWRK,TWRK2
      parameter(INSTRM=3,CSTRM=4,OSTR=7,OSTR2=8,
     &          WRK=1,WRK2=2,TWRK=7,TWRK2=8,LSTR=9)
C
C The SIGINT interrupt level indicator: levels above 0 lead to
C termination of the existing subroutine, and return of control to
C the main command loop
C
      integer irupt, sigstat
      common /flag/ irupt
      intrinsic signal
      external handler
C
C job control indicators:
C cutoff=min cell size to use in TDT, iter=#Monte Carlo iterations,
C burnin=#prelim MCMC iterations, maxtry=#trials to generate starting
C value for a missing genotype, mincnt=min numerator for MC P-value
C fraction, nbatch=#batches for MCMC SDs, emiter=#EM iterations,
C imp=level of imputation missing vals, 
C gene=col of current gene, plevel=print level, 
C showorig=detail on haplotyping output, skipline=no. of lines to 
C skip at head of pedigree file, 
C trait=col of current trait, toler=convergence criterion for varmet, 
C twinning=zero if no twins present in dataset, else position of
C          twinship indicator phenotype
C typ=ibd or ibs for APM etc, parental contrib for TDT,
C twomark=markers for 3-pt, H-E regression, th1, th2, th12 the thetas.
C sibr the full-sib trait correlation for S&P regression
C sibm, sibv the trait mean and variance for S&P regression
C
C addsex=sex as dummy quant trait, assfnd=assoc in founders only,
C censor=censoring variable for survival analysis,
C chek=check mendelisms, droperr=delete genotypes causing mendel errors,
C epoch=epoch for Julian dates (defaults to 2440588==1970-01-01),
C famerr=error in pedigree structure, fndr=freq in founders only, 
C gt=side of threshhold (0=nil, 15='<', 16='>', 17='ge', 18='le',
C 19='ne',20='eq') loconly=*inc*luding locus information only,
C last=last pedigree, link=Linkage format, prompt=show a prompt,
C red=file read, mche=MC P-val for H-E regression,
C gene=marker in analysis, trait=trait in analysis, off=offset trait, 
C use2=restrict TDT to cases both parents typed, 
C xlin xlinkd=x-linked markers, zrec=assume zero recomb for haps
C
      logical addsex, assfnd, chek, echo, famerr, filexist,
     &   last, loconly, prompt, red, mche, xlinkd
      integer burnin, emiter, iter, maxtry, mincnt, nbatch
      integer censor, cutoff, droperr, fndr, gt, imp, gene, limp, link,
     2    mapf, nwarn, off, plevel, prob, showorig, skipline, 
     3    trait, twinning, typ, use2, wrknum, xlin, zrec
      integer twomark(2)
      double precision sibm, sibr, sibv, th1, th2, th12
      double precision epoch, thresh, toler
C
C input stream (ilevel =0 history; ilevel =1 stdin; =2 include file)
C workfile directory and files
C
      integer ilevel
      character*40 version
      character*72 datdir,wrkdir 
      character*144 infil,outfil,pedfil,wrkfil,wrk2fil
C
C Various counts:
C nfam=sibships in pedigree, nobs=total subjects, nped=pedigrees, 
C nships=total sibships, tfound=total founders, inconsist=problems,
C ntwins=total number of MZ twins
C badfam=number of discarded families, badnum=number of discarded records,
C ndiscard=number of discarded genotypes (caused inconsistencies)
C imputd=imputed genotypes, typed=no. typed at marker, totall=no. of
C alleles typed (2*typed for autosomal markers), ntyped=no. any genotype
C tottyp=total number of genotypes in data
C biggest=size of largest ped, deepest=largest number of generations,
C totgen=accum generations per family, onemem=number of families with 
C only 1 member, onegen=number of families with only 1 generation.
C
      integer nfam,nobs,nped,nships,ntwins,tfound 
      integer badfam, badnum, inconsist, imputd, ndiscard
      integer biggest,deepest,ntyped,onegen,onemem,
     &        totall,totgen,tottyp,typed
C
C Pedigree structure:
C pedigree name; selected; size; no. of founders; individual ids & sexes; 
C pointers to parental ids; 
C trait and genotype values; number of values;
C depth (number of generations)
C
C LINSIZ=input buffer size (chars)
C MAXALL=maximum number of alleles; MAXG=maximum number of genotype
C MAXSIZ=maximum pedigree size; MAXLOC=maximum number of columns used
C by loci (so MAXLOC/2 maximum for codom markers); MISS=missing data
C point placeholder; LOT=all loci; MAXCOL=max columns for id + loci;
C HAPSIZ=haplotype array size, WRKSIZ=phenoset array size,
C MAXIBD=maximum pedigree size for relative-pairwise statistics
C IBDSIZ=maximum array size for relative-pairwise statistics
C MAXTER=maximum number of variables for regression etc
C MAXCOV=maximum size of covariance matrix of variables
C
      integer HAPSIZ, IBDSIZ, LINSIZ, LLMSIZ, MAXALL, MAXCOL, MAXCOV,
     &        MAXG, MAXHAP, MAXIBD, MAXLOC, MAXSIZ, MAXTER, MISS, WRKSIZ
      parameter(LINSIZ=40000, MAXALL=2, MAXG=MAXALL*(MAXALL+1)/2, 
     2   MAXSIZ=20, MAXLOC=10000, MAXHAP=MAXLOC/2, MISS=-9999, 
     3   MAXCOL=MAXLOC+5, HAPSIZ=MAXSIZ*MAXLOC, MAXIBD=20, 
     4   IBDSIZ=MAXIBD*(MAXIBD+1)/2, MAXTER=MAXIBD/2, LLMSIZ=HAPSIZ/8, 
     5   MAXCOV=MAXTER*(MAXTER+1)/2,  WRKSIZ=MAXSIZ*MAXG*2)
C    6   WRKSIZ=HAPSIZ+7*MAXSIZ+10*MAXG+ 5*MAXALL+ 4*IBDSIZ)
C
C MAXPAR=maximum number of segregation model parameters
C RANPAR=number of random effects model parameters
      integer MAXPAR, RANPAR
      parameter(MAXPAR=50, RANPAR=24)
     
      character*10 pedigree
      integer actset,num,nfound 
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ),mo(MAXSIZ),sex(MAXSIZ)
      integer numloc
      double precision locus(MAXSIZ,MAXLOC)
      integer higen
C
C Locus structure:
C number of loci, locus name, locus type, and locus position in file
C loctyp 1=marker 2=x-marker 3=quant 4=affection 5-8=deleted
C
      integer nloci
      character*20 loc(MAXLOC)
      character*40 locnotes(MAXLOC)
      integer loctyp(MAXLOC),locpos(MAXLOC)
C
C position of locus on sex-averaged linkage map
C
      real map(MAXLOC)
C
C position of locus in output locus and pedigree files
C may be fewer than nloci loci for output
C
      integer nord, locord(MAXLOC)
C
C Phenoset arrays: possible genotypes for each individual in the pedigree
C
      integer ngeno,gset(MAXSIZ,MAXG,2)
C
C Storage space for haplotypes
C
      integer hset(MAXSIZ,MAXHAP,2)
C work array for quantitative values 
C notably contingency tables (equivalenced to hset)
      real vset(HAPSIZ)
C
C work arrays for large log-linear models and some tabulations 
C (equivalenced to hset)
C
C scatter = scatter matrix connecting observed and full contingency table
C counts  = observed contingency table (length ncells)
C ex      = expected values for contingency table iteration i
C oldex   = expected values for contingency table iteration i-1
C full    = expected values for full (unobserved) contingency table
C           (length nfull)
C model   = design matrix  (length nfull x totpars)
C offset  = offset for full (length nfull)
C
      integer scatter(LLMSIZ)
      real counts(LLMSIZ), ex(LLMSIZ),
     2     oldex(LLMSIZ), full(LLMSIZ),
     3     offset(LLMSIZ), model(2*LLMSIZ)
C
C workspace: genotype array or list of parents or linked list...
C
      integer set(MAXSIZ,2)
C
C ibd-genotype
      integer sibd(MAXSIZ,2)
C proposed genotype array
      integer set2(MAXSIZ,2)
C list of founder alleles or sort key
C work arrays for sorting etc (equivalenced)
      integer key(2*MAXSIZ)
      integer key1(MAXSIZ), key2(MAXSIZ)
C work arrays for quantitative traits (equivalenced)
      double precision value(MAXSIZ), valu2(MAXSIZ)
C indicate if individual typed at locus
      logical untyped(MAXSIZ)
C work arrays for sorting/listing (equivalenced) 
      integer ord(MAXSIZ)
C
C allele and genotype frequencies within entire sample for given locus 
C
      integer numal, name(MAXALL)
      double precision alfrq(MAXALL), cumfrq(MAXALL), gfrq(MAXG)
      integer numal2, name2(MAXALL)
      double precision alfrq2(MAXALL)
C
C Genotype counts: allele1,allele2, number transmitted, number not trans
C Arrays used by association and TDT analyses
C
      integer nallele,cntall(MAXG,4), ngcount,gcount(MAXG,4)
C
C mean ibd (or ibs) sharing for all relative pairs
C
      double precision ibdcount(IBDSIZ)
      double precision count2(IBDSIZ)
C
C Regression parameters and work arrays
C equivalenced with ibdcount (except for mval, used to pass means about)
C
      double precision x(MAXTER), r(MAXCOV), b(MAXTER), cov(MAXCOV)
      double precision mval(MAXTER)
C
C Mixed model analysis parameters 
C linkf=link function 1=identity 2=logit 3=probit 4=MFT 5=log
C modtyp=likelihood family (1=gaussian, 2=binomial, 3=poisson)
C nqtl=trait loci in model
C nfix=number of fixed effects
C Model parameters
C model pars 1=P(all) 2=a 3=d 4=AA 5=AB 6=BB 
C            7=mu 8=totvar 9=VA 10=VD 11=VG 12=VC 13=VS 14=VE 
C            15=sdG 16=sdC 17=sdM 18=sdE
C            19=a2 20=d2 21=h2 22=c2 23=m2 24=e2 
C            25..MAXPAR=Betas
C Random Effects: 
C  QTL:
C   1=P(all)  2=a  3=d  
C   4=muAA  5=muAB  6=muBB 
C   7=mu  8=totvar  9=VA  10=VD 
C  Polygenes:
C   11=VG  14=sdG
C  Familial environment
C   12=VC  15=sdC
C  Maternal/sibship effect
C   13=VS  17=sdS
C  Error
C   14=VE  18=sdE
C  Proportions of variance
C   19=a2 20=d2 21=h2 22=c2 23=s2 24=e2 
C Fixed Effects:
C   25...MAXPAR
C
C parnam  = parameter name  
C paract  = status 
C             0=excluded 
C             1=estimated 
C             2=fixed     
C             3=function of estimated parameter
C par     = parameter estimate
C parscal = scale size for MCMC proposal distribution 
C             (usually approx standard error)
C tune=adjustment parameter for MCMC proposal distributions,
C mcalg=Metropolis algorithm 
C             1=Slice sampler for global parameters
C             2="Plain" Metropolis sampler for all parameters
C             3=Slice sampler for all (continuous) parameters
C nchain=number of random effect chains (actually clones of families)
C priran=print random effects (segsim)  
C shap=shape parameter of likelihood function eg Weibull
C
      integer linkf, modtyp, nchain, nfix, nqtl, priran
      real tune
      double precision shap
      character*14 parnam(MAXPAR)
      integer paract(MAXPAR)
      double precision par(MAXPAR), parscal(MAXPAR)
C
C Likelihoods and no. parameters for consecutive model fits (such as varcom)
C accessed via lrt command; whlik points to last result
      integer whlik, mdf, mpar(2)
      double precision lrts, mlik(2)
C
C recode (combine alleles, adjust quant variables)
C
      integer nf
      double precision recto, recfro(MAXALL)
      double precision adjval
C
C Box-cox transformation and/or truncation of variable
C
      double precision divisor, hival, loval, offst, power
C
C Number of decimal digits and width in output pedigree file:
C All quantitative variables default to 9 characters
C
      integer ndec, nwid
C
C character array to initially read data into
      character*(LINSIZ) lin
      character*20 words(MAXCOL)
      character*80 bigwor(MAXCOL/4)
C
C list for evaluation of expressions (tag1,value1)...(tagNTERM,valueNTERM)
      integer nterm
      integer wtyp(MAXCOL)
      double precision expr(MAXCOL,2)
C
C keywords not hard coded
C
C Token name, left binding power, right binding power, operation
      integer TOKNUM
      parameter (TOKNUM=48)
      character*6 token(TOKNUM)
      integer lbp(0:TOKNUM), rbp(0:TOKNUM), op(0:TOKNUM)
C
C Environmental (automatic) variables for evaluator
      integer ENVNUM
      parameter (ENVNUM=11)
      character*6 env(ENVNUM)
C
C equivalence to reuse workspace
C Note that the reserved space may be excessive for the data type, in order
C to avoid misalignment (eg character must not force integer to start on
C an odd-byte boundary)
C
C  Array   Dimension         Type   Cumulative space (4 byt) reserved in work()
C  ------- ----------       -----   --------------------------------------------
C     gset MAXSIZ*MAXG*2    I (4)   2*MAXSIZ*MAXG
C 
C     hset MAXSIZ*MAXHAP*2  I (4)   2*MAXSIZ*MAXHAP (=HAPSIZ)
C 
C     vset MAXSIZ*MAXHAP*2  R (4)   2*MAXSIZ*MAXHAP (=HAPSIZ)
C
C     sibd 2*MAXSIZ         I (4)   HAPSIZ+2*MAXSIZ
C     set2 2*MAXSIZ         I (4)   HAPSIZ+4*MAXSIZ
C     key1 MAXSIZ           I (4)   HAPSIZ+5*MAXSIZ
C     key2 MAXSIZ           I (4)   HAPSIZ+6*MAXSIZ
C      key 2*MAXSIZ         I (4)   HAPSIZ+6*MAXSIZ
C  untyped MAXSIZ           L (4)   HAPSIZ+7*MAXSIZ
C      ord MAXSIZ           I (4)   HAPSIZ+7*MAXSIZ  
C   cntall 4*MAXG           I (4)   HAPSIZ+7*MAXSIZ+ 4*MAXG
C   gcount 4*MAXG           I (4)   HAPSIZ+7*MAXSIZ+ 8*MAXG
C   recfro MAXALL           R (4)   HAPSIZ+7*MAXSIZ+ 8*MAXG+ 1*MAXALL
C    name2 MAXALL           I (4)   HAPSIZ+7*MAXSIZ+ 8*MAXG+ 1*MAXALL
C   alfrq2 MAXALL           D (8)   HAPSIZ+7*MAXSIZ+ 8*MAXG+ 3*MAXALL
C   cumfrq MAXALL           D (8)   HAPSIZ+7*MAXSIZ+ 8*MAXG+ 5*MAXALL
C     gfrq MAXG             D (8)   HAPSIZ+7*MAXSIZ+10*MAXG+ 5*MAXALL
C ibdcount IBDSIZ           D (8)   HAPSIZ+7*MAXSIZ+10*MAXG+ 5*MAXALL+ 2*IBDSIZ
C   count2 IBDSIZ           D (8)   HAPSIZ+7*MAXSIZ+10*MAXG+ 5*MAXALL+ 4*IBDSIZ 
C
C        x MAXTER           D (8)   HAPSIZ+7*MAXSIZ+10*MAXG+ 5*MAXALL+ 2*MAXTER
C        r MAXCOV           D (8)   HAPSIZ+7*MAXSIZ+10*MAXG+ 5*MAXALL+ 
C                                   2*MAXTER+2*MAXCOV
C        b MAXTER           D (8)   HAPSIZ+7*MAXSIZ+10*MAXG+ 5*MAXALL+
C                                   2*IBDSIZ+2*MAXTER
C      cov MAXCOV           D (8)   HAPSIZ+7*MAXSIZ+10*MAXG+ 5*MAXALL+
C                                   2*IBDSIZ+2*MAXTER+2*MAXCOV
C
C      lin LINSIZ           C (1)   HAPSIZ+7*MAXSIZ+10*MAXG+ 5*MAXALL+ LINSIZ
C    words 20*MAXCOL        C (1)   HAPSIZ+7*MAXSIZ+10*MAXG+ 5*MAXALL+ 
C                                   20*MAXCOL+ LINSIZ
C   bigwor 20*MAXCOL        C (1)   HAPSIZ+7*MAXSIZ+10*MAXG+ 5*MAXALL+ 
C                                   20*MAXCOL+ LINSIZ
C
      integer work(WRKSIZ)
C
      equivalence (work(1), gset(1,1,1))
      equivalence (work(1), hset(1,1,1))
      equivalence (work(1), vset(1))
      equivalence (work(1), counts(1))
      equivalence (work(LLMSIZ+1),scatter(1))
      equivalence (work(2*LLMSIZ+1),ex(1))
      equivalence (work(3*LLMSIZ+1),oldex(1))
      equivalence (work(4*LLMSIZ+1),full(1))
      equivalence (work(5*LLMSIZ+1),offset(1))
      equivalence (work(6*LLMSIZ+1),model(1))
C
#ifndef BIG
      equivalence (work(HAPSIZ+1), sibd(1,1))
      equivalence (work(HAPSIZ+2*MAXSIZ+1), set2(1,1))
      equivalence (work(HAPSIZ+4*MAXSIZ+1), key(1))
      equivalence (work(HAPSIZ+4*MAXSIZ+1), key1(1))
      equivalence (work(HAPSIZ+5*MAXSIZ+1), key2(1))
      equivalence (work(HAPSIZ+6*MAXSIZ+1), untyped(1))
      equivalence (work(HAPSIZ+6*MAXSIZ+1), ord(1))
      equivalence (work(HAPSIZ+7*MAXSIZ+1), cntall(1,1))
      equivalence (work(HAPSIZ+7*MAXSIZ+4*MAXG+1), gcount(1,1))
      equivalence (work(HAPSIZ+7*MAXSIZ+8*MAXG+1), recfro(1))
      equivalence (work(HAPSIZ+7*MAXSIZ+8*MAXG+1), name2(1))
      equivalence (work(HAPSIZ+7*MAXSIZ+8*MAXG+1*MAXALL+1), alfrq2(1))
      equivalence (work(HAPSIZ+7*MAXSIZ+8*MAXG+3*MAXALL+1), cumfrq(1))
      equivalence (work(HAPSIZ+7*MAXSIZ+8*MAXG+5*MAXALL+1), gfrq(1))
      equivalence (work(HAPSIZ+7*MAXSIZ+10*MAXG+5*MAXALL+1),ibdcount(1))
      equivalence (work(HAPSIZ+7*MAXSIZ+10*MAXG+5*MAXALL+2*IBDSIZ+1),
     &             count2(1))
C
      equivalence (work(HAPSIZ+7*MAXSIZ+10*MAXG+5*MAXALL+1),x(1))
      equivalence (work(HAPSIZ+7*MAXSIZ+10*MAXG+5*MAXALL+2*MAXTER+1),
     &             r(1))
      equivalence (work(HAPSIZ+7*MAXSIZ+10*MAXG+5*MAXALL+2*IBDSIZ+1),
     &             b(1))
      equivalence (work(HAPSIZ+7*MAXSIZ+10*MAXG+5*MAXALL+2*IBDSIZ+
     &             2*MAXTER+1),cov(1))
C Nonstandard equivalencing of character and integer
      equivalence (work(HAPSIZ+7*MAXSIZ+10*MAXG+5*MAXALL+1), lin)
      equivalence (work(HAPSIZ+7*MAXSIZ+10*MAXG+5*MAXALL+LINSIZ+1), 
     &             words(1))
      equivalence (work(HAPSIZ+7*MAXSIZ+10*MAXG+5*MAXALL+LINSIZ+1), 
     &             bigwor(1))
#endif /* BIG */
C
C time/random number generator seeds
C
C C library (DJGPP libc, GNU glibc etc):
C   time() -- date and time as sec since 1/1/1970
C   ctime() -- date and time as 24 character string
C
C f77 library (libU77):
C   time() -- date and time as sec since 1/1/1970 as integer
C   fdate() -- date and time as 24 character string 
C
      integer ix,iy,iz
      common /rndseed/ ix,iy,iz
C
C "local" counters etc
C
C actn=type of expression (arithmetic, dry run, evaluate),
C eop=length of pedigree name, gen2=position of 2nd allele, 
C length=line length, longnam=highest value of eop, nlin=line of command file, 
C nhis=line of history (continuing lines are combined), 
C nmark=marker loci found for twopoint() or other procedures
C bigped=name of largest pedigree, deeped=name of the deepest pedigree 
C h2=heritability, weight=variable containing weight for weighted H-E
C istyp=typed at any marker, maxsibs=sibship size to truncate to
C nprob=number of index individuals in pedigree, newloc=added locus,
C newtyp=added locus type, oldnam=check if already used
C nrc=number of lines per record, varlen=length of an outputted variable
C tnum=total no. Ss, tped=total no. peds, tot=total active Ss
C
      integer actn,eop,error,gen2,i,j,k,length,longnam,maxsibs,
     2        highest,newloc,newtyp,nhis,nlin,nmark,nrc,
     3        tnum,tped,tot,varlen,weight
C candidate allele and alternative
      integer candal, other
      logical istyp, oldnam
      character*3 keyword, keyw2
      character*12 typloc(4)
      character*10 bigped, deeped  
      character*20 twintrait
      real dist
      double precision all1, all2, h2, tmp
C time (time stamp and procedure timings) timer=1 prints procedure timings
      integer t0, timer
      real t1
C
C functions
      logical allmiss, alltyped, iscomp, isinuse, isreal, strfind
      integer eow, findml, findwh, othall, topall
      double precision aval, chip, fval, togreg, tojulian
#ifndef DOS
      logical isatty
      intrinsic isatty
#endif /* DOS */

#ifdef HPUX
      character*8 timestr
      character*9 today

      version=VERSION // ' HPUX'

      t0=int(secnds(0.0))
      call date(today)
      call time(timestr)
      ix=int(30000*ran(t0))
      iy=int(30000*ran(t0))
      iz=int(30000*ran(t0))
 
      write(*,'(a/2a/a/4a/)')
     2  '|||| SIB-PAIR: A program for simple genetic analysis',
     3  '|\\/| Version : ',version,
     4  '|/\\| Author  : David L Duffy (c) 1995-2006',
     5  '|||| Job run : ',today,' at ',timestr
      prompt=.false.

#endif /* HPUX */
#if defined (F2C) || defined (G95)
      integer time
      character*24 fdate
C stamp and initialize
C
      version=VERSION 

      t0=time()
      ix=mod(t0,29282)
      if (t0.gt.29282) then
        iy=mod(t0/29282,29282)
      else
        iy=mod(419*ix+6173,29282)
      end if
      iz=mod(419*iy+6173,29282)
      write(*,'(a/2a/a/2a/)')
     2  '|||| SIB-PAIR: A program for simple genetic analysis',
     3  '|\\/| Version : ',version,
     4  '|/\\| Author  : David L Duffy (c) 1995-2006',
     5  '|||| Job run : ',fdate()
#ifdef DOS
      prompt=.false.
#else
      prompt=isatty(5)
#endif /* DOS */
#endif /* F2C */
#ifdef DEC
      character*8 tim
      character*9 dat

      version=VERSION // ' DEC'

      t0=int(secnds(0.0))
      call time(tim)
      call date(dat)
      call itime(ix,iy,iz)
      write(*,'(a/2a/a/4a/)')
     2  '|||| SIB-PAIR: A program for simple genetic analysis',
     3  '|\\/| Version : ',version,
     4  '|/\\| Author  : David L Duffy (c) 1995-2006',
     5  '|||| Job run : ',dat,' at ',tim
      prompt=.false.

#endif /* DEC */
#ifdef SUN
      character*24 date
      integer it(3)

      version=VERSION // ' SUN'

      t0=int(secnds(0.0))
      call fdate(date)
      call itime(it)
      ix=it(1)
      iy=it(2)
      iz=it(3)
C
      write(*,'(a/2a/a/2a/)')
     2  '|||| SIB-PAIR: A program for simple genetic analysis',
     3  '|\\/| Version : ',version,
     4  '|/\\| Author  : David L Duffy (c) 1995-2006',
     5  '|||| Job run : ',date
      prompt=.false.

#endif /* SUN */

C
C Initialize list of reserved words
C
C Token name, left binding power, right binding power, operation
C
C Pos Name     LBP  RBP  Op (1=unary postfix; 2=binary, infix; 3=if; 
C --- -------  ---  ---  --  10=zero-arg functions eg rand)
C   0 unbound    0    0   0
C   1 (        200    0   0
C   2 )          0    5   0
C   3 if         0   45   3
C   4 then       5   25   0
C   5 else       5   25   0
C   6 *        120  121   2
C   7 /        120  121   2
C   8 +        100  101   2
C   9 -        100  101   2
C  10 ^        139  138   2
C  11 =          0    0   2
C  12 not       70   70   1
C  13 and       65   66   2
C  14 or        60   61   2
C  15 <         80   80   2
C  16 >         80   80   2
C  17 ge        80   80   2
C  18 le        80   80   2
C  19 ne        80   80   2
C  20 eq        80   80   2
C  21 neg       138 138   1
C  22 pos       138 138   1
C  23 abs       140 140   1
C  24 sqrt      140 140   1
C  25 log       140 140   1
C  26 exp       140 140   1
C  27 sin       140 140   1
C  28 cos       140 140   1
C  29 tan       140 140   1
C  30 asin      140 140   1
C  31 acos      140 140   1
C  32 atan      140 140   1
C  33 inht      140 140   1
C  34 int       140 140   1
C  35 round     140 140   1
C  36 istyp     140 140   1
C  37 untyp     140 140   1
C  38 ishet     140 140   1
C  39 ishom     140 140   1
C  40 alla      140 140   1
C  41 allb      140 140   1
C  42 rand        0   0  10
C  43 rnorm       0   0  10
C  44 pi          0   0  10
C  45 y           0   0  10
C  46 n           0   0  10
C  47 x           0   0  10
C  48 NUM         0   0  10
C
      data token /'(',')','if','then','else','*','/',
     2     '+','-','^','=','not','and','or','<','>',
     3     'ge','le','ne','eq','neg','pos','abs','sqrt','log','exp',
     4     'sin','cos','tan','asin','acos','atan','inht','int','round',
     5     'istyp','untyp','ishet','ishom','alla', 'allb', 
     6     'rand','rnorm','pi','y','n','x','NUM'/
      data lbp /0, 200,0,0,5,5,120,120,
     2     100,100,139,0,70,65,60,80,80,
     3     80,80,80,80,138,138,140,140,140,140,
     4     140,140,140,140,140,140,140,140,140,
     5     140,140,140,140,140,140,0,0,0,0,0,0,0/
      data rbp /0, 0,5,45,25,25,121,121,
     2     101,101,138,0,70,66,61,80,80,
     3     80,80,80,80,138,138,140,140,140,140,
     4     140,140,140,140,140,140,140,140,140,
     5     140,140,140,140,140,140,0,0,0,0,0,0,0/
      data op /0, 0,0,3,0,0,2,2,
     2     2,2,2,2,1,2,2,2,2,2,2,2,2,1,1,1,1,1,1,
     3     1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
     4     10,10,10,10,10,10,10/
C
C And environmental (automatically defined) variables 
      data env /'female','male','isfou','isnon','num',
     &          'nfoun','anytyp','alltyp','numtyp','famnum','index'/
C
C Segregation model parameter names
      data parnam /'pA', 'a', 'd', 'AA', 'AB', 'BB',
     2             'mu', 'VT', 'VA', 'VD', 'VG', 'VC', 'VS', 'VE',
     3             'sdG', 'sdC', 'sdS', 'sdE', 
     4             'a2', 'd2', 'h2', 'c2', 's2', 'e2', 26*' '/ 
      data typloc /'marker','xmarker','quantitative','affection'/
      burnin=100
      datdir=' '
      dist=0.0
      echo=.false.
      emiter=20
      epoch=2440588.0d0
      ilevel=1
      imp=0
      iter=200
      lin=' '
      mapf=1
      maxtry=5000
      mcalg=1
      mincnt=20
      ndec=4
      nbatch=int(sqrt(10*float(iter)))
      nchain=1
      nwid=9
      nhis=0
      nlin=0
      plevel=0
      priran=0
      shap=1.0d0
      showorig=2
      toler=1.0d-6
      tune=0.3
      wrkdir=' '
      if (prompt) call openlog(LSTR, nhis)

#ifdef F2C
C
C intercept and act on SIGINT
C
      call signal(2, handler, sigstat)
#endif /* F2C */

C Global restart

  999 continue

      pedfil=' '
      outfil=' '
      call uniqnam(t0,wrkfil,'wrk')
      call uniqnam(t0,wrk2fil,'tmp')
      ngeno=0
      nloci=0
      numloc=0
      twinning=MISS
      wrknum=1
      addsex=.false.
      chek=.true.
      droperr=0
      fndr=0
      last=.false.
      link=0
      loconly=.false.
      red=.false.
      skipline=0
      whlik=2
      mpar(1)=0
      mpar(2)=0
      mlik(1)=0.0d0
      mlik(2)=0.0d0
      t1=0.0
      timer=0
      use2=2
      zrec=1
      pedigree=' '
C
C main loop -- reads stdin, parses
C
    1 continue
        irupt=0
        if (prompt) write(*,'(/a,$)') '>> '
        i=1
    3   continue
          if (ilevel.eq.1) then
            read(*,'(a)',end=2) lin(i:LINSIZ)
          else if (ilevel.eq.2) then
            read(CSTRM,'(a)',end=2) lin(i:LINSIZ)
          end if
          nlin=nlin+1
          i=eow(lin)
        if (i.gt.1 .and. lin(i-1:i).eq.' \\') goto 3

        if ((echo .or. plevel.gt.0) .and. 
     &      lin(1:1).ne.'#' .and. lin(1:1).ne.'!') then
          write(*,'(/2a/)') '-> ',lin(1:75)
        end if
        narg=MAXCOL
        call args(lin,narg,words,1)
        keyword=words(1)(1:3)
        keyw2=words(2)(1:3)
        call proct(t1, 0)
C record command line to log (providing not already history)
        if (ilevel.eq.0) then
          ilevel=1
        else if (prompt .and. keyword.ne.'las' .and.
     &           keyword(1:1).ne.'!' .and. keyword(1:1).ne.'#') then
          nhis=nhis+1
          write(LSTR,'(a)') lin(1:eow(lin))
        end if
C
C Locus description
        if (keyword.eq.'set' .and. keyw2.eq.'loc') then
          newloc=numloc+1
          if (words(4)(1:3).eq.'mar' .or. words(4)(1:3).eq.'nam') then
            newtyp=1
            newloc=newloc+1
          elseif (words(4)(1:3).eq.'xma') then
            newtyp=2
            newloc=newloc+1
          elseif (words(4)(1:3).eq.'aff') then
            newtyp=4
          else
            newtyp=3
            if (words(4)(1:3).ne.'qua') then
              write(*,'(3a/7x,a/)') 
     2          'ERROR: Do not recognise locus type ',words(4),'.',
     3               'Treating as quantitative trait.'
            end if
          end if
C Check if enough room and whether previously declared locus name or
C reserved word
          oldnam=isinuse(words(3), nloci, loc, token, env)
          if (newloc.gt.MAXLOC) then
            write(*,'(a,i3,a1/7x,3a/)') 
     2        'ERROR: Number of columns of data exceeds maximum ',
     3        MAXLOC,'.',
     4        'Variable ',words(3)(1:eow(words(3))),' not added.'
          else
            nloci=nloci+1
            loc(nloci)=words(3)
            if (oldnam) then
              k=min(20,eow(loc(nloci))+1)
              loc(nloci)(k:k)='_'
              write(*,'(a/7x,3a/)') 
     2        'WARNING: Locus is already declared or a reserved word.',
     3        'Changed name to "',loc(nloci)(1:k),'".'
            end if
            loctyp(nloci)=newtyp
            locpos(nloci)=numloc+1
            map(nloci)=MISS
            locnotes(nloci)=' '
            if (narg.gt.4) then
              k=5
              if (isreal(words(5))) then
                map(nloci)=sngl(fval(words(5)))
                k=k+1
              end if
              call annotate(k, narg, words, locnotes(nloci))
            end if
C If pedigree workfile already exists, create a new variable
            if (red) then
              write(*,'(3a)') 'Creating new variable "',
     &                        loc(nloci)(1:eow(loc(nloci))),'".'
              call newnam(wrknum, wrkfil)
              open(TWRK,file=wrkfil,form='unformatted')
              call addvar(WRK,TWRK,newloc,pedigree,actset,num,nfound,
     &                id,fa,mo,sex,locus,numloc)
              close(WRK,status='delete')
              close(TWRK,status='keep')
              open(WRK,file=wrkfil,form='unformatted')
            end if
            numloc=newloc
          end if
C
C Marker map 
        elseif (keyword.eq.'set' .and. keyw2.eq.'map') then
          if (words(3)(1:3).eq.'fun') then
            if (words(4)(1:3).eq.'kos') then
              write(*,'(/a/)') 'NOTE:  Using Kosambi mapping function.' 
              mapf=2
            else
              write(*,'(/a/)') 'NOTE:  Using Haldane mapping function.' 
              mapf=1
            end if
          else
            j=2
            do 710 i=1,nloci
            if (loctyp(i).le.2) then
              j=j+1
              if (j.le.narg) then
                dist=sngl(fval(words(j)))
              else
                write(*,'(a/)') 
     &            'NOTE:  Ran out of user specified map positions.'
                dist=dist+100.0
              end if
              map(i)=dist
            end if
  710       continue
          end if
        elseif (keyword.eq.'set' .and. keyw2.eq.'dis') then
          j=1
          do 712 i=1,nloci
          if (loctyp(i).le.2) then
            j=j+1
            if (j.eq.2) then
              dist=0.0
            elseif (j.le.narg) then
              dist=sngl(fval(words(j)))+dist
            else
              write(*,'(a/)') 
     &          'NOTE:  Ran out of user specified map distances.'
              dist=dist+100.0
            end if
            map(i)=dist
          end if
  712     continue
        elseif (keyword.eq.'sho') then
          if (keyw2.eq.'map') then
            call wrmap(0,10,mapf,nloci,loc,loctyp,locnotes,
     &                 nord,locord,map)
          else if (keyw2.eq.'ped') then
            trait=MISS
            call dogen(WRK,TWRK,pedigree,actset,num,nfound,id,fa,mo,sex,
     &                 locus, numloc,ord,set,trait,plevel)
          else
            call actped(red, WRK, pedfil, nloci, loc, loctyp, locpos,
     2                  locnotes, locord, pedigree, actset, num, nfound,
     3                  id, fa, mo, sex, locus, numloc, plevel)
          end if
        elseif (keyword.eq.'rea' .and. keyw2.eq.'loc') then
          call args(lin,narg,bigwor,1)
          inquire(file=bigwor(4),exist=filexist)
          if (filexist) then
            if (bigwor(3)(1:3).eq.'lin') then
              open(TWRK,file=bigwor(4),status='old')
              call rdlinloc(TWRK,lin,words,nloci,loc,  
     2                      locpos,loctyp,nord,locord,
     3                      map,ord,numloc,token,env)
              close(TWRK)
              write(*,'(/a,i4,a/)') 'Read in names of ', nloci,
     &          ' loci from locus file.'
              open(WRK2,file=wrk2fil,form='unformatted')
              call ordvar(WRK2,nloci,loc,loctyp,locpos,
     &                    nord,locord,map,ord)
              close(WRK2,status='delete')
            elseif (bigwor(3)(1:3).eq.'mer') then
              open(TWRK,file=bigwor(4),status='old')
              xlin=0
              if (bigwor(5)(1:3).eq.'xli') xlin=1
              call rdmerloc(TWRK,xlin,lin,words,nloci,loc,  
     2                      locpos,loctyp,nord,locord,
     3                      map,ord,numloc,token,env)
              close(TWRK)
              write(*,'(/a,i4,a/)') 'Read in names of ', nloci,
     &          ' loci from locus file.'
            else
              write(*,'(a)') 'ERROR:  Locus file type not supported'
            end if
          else
            write(*,'(3a)') 
     &        'ERROR:  File',bigwor(4)(1:eow(words(4))),' not found.'
          end if
        elseif (keyword.eq.'rea' .and. keyw2.eq.'map') then
          call args(lin,narg,bigwor,1)
          inquire(file=bigwor(3),exist=filexist)
          if (filexist) then
            open(TWRK,file=bigwor(3),status='old')
            call readmap(TWRK,lin,words,nloci,loc,loctyp,map,plevel)
            close(TWRK)
          else
            write(*,'(3a)') 
     &        'ERROR:  File',bigwor(4)(1:eow(words(4))),' not found.'
          end if
C
C Pedigree file to read from
        elseif (keyword.eq.'rea' .and. (keyw2.eq.'ped' 
     &          .or. keyw2.eq.'lin' .or. keyw2.eq.'ppd')) then
          call args(lin,narg,bigwor,1)
          link=0
          skipline=0
          if (bigwor(2)(1:3).eq.'lin') then
            link=1
          else if (bigwor(2)(1:3).eq.'ppd') then
            link=2
          end if
          pedfil=bigwor(3)
          if (bigwor(4)(1:3).eq.'ski') then
            skipline=ival(bigwor(5))
          end if
C
C pedigree data may be inline: transfer data to temporary file
C following lines are pedigree data, and are terminated by a line
C starting  ";;;;".  Require exact keyword match to avoid clashes with files.
C
          if (pedfil.eq.'inl' .or. pedfil.eq.'inline') then
            pedfil='inline.ped' 
            call mknewfil(OSTR, pedfil, wrkdir)
            open(OSTR,file=pedfil)
  350       continue
              if (ilevel.eq.1) then
                read(*,'(a)',end=2) lin(1:LINSIZ)
              else
                read(CSTRM,'(a)',end=2) lin(1:LINSIZ)
              end if
              nlin=nlin+1
            if (lin(1:4).ne.';;;;') then
              write(OSTR,*) lin(1:eow(lin))
              goto 350
            end if
            close(OSTR,status='keep')
C else check if file exists
          else
            call cat(datdir,pedfil)
            inquire(file=pedfil,exist=filexist)
            if (.not.filexist) then
              write(*,'(/3a/7x,3a/)') 
     2          'NOTE:  Pedigree file "',pedfil(1:eow(pedfil)),
     3          '" does not exist.','Trying "',
     4          bigwor(3)(1:eow(bigwor(3))),'".'
              pedfil=bigwor(3)
              inquire(file=pedfil,exist=filexist)
              if (.not.filexist) then
                write(*,'(/3a/)') 
     2            'ERROR: Pedigree file "',pedfil(1:eow(pedfil)),
     3            '" does not exist.'
                pedfil=' '
              end if
            end if
          end if
C set output number of decimal points
        elseif (keyword.eq.'set' .and. keyw2.eq.'nde') then
          if (narg.gt.3) then
            nwid=ival(words(3))
            ndec=ival(words(4))
          else
            ndec=ival(words(3))
          end if
          if (nwid.le.0) then
            nwid=9
          elseif (nwid.gt.20) then
            nwid=20
          end if
          if (ndec.gt.nwid) then
            ndec=nwid
          elseif (ndec.lt.0) then
            ndec=0
          end if
          write(*,'(/a,i2,a,i2/)') 
     &      'NOTE:  Number of decimal digits w.d w=',nwid,' d=',ndec
C set output verbosity
        elseif (keyword.eq.'set' .and. 
     2          (keyw2.eq.'out'.or.keyw2.eq.'ple')) 
     3  then
          if (words(3)(1:3).eq.'ver') then
            plevel=2
          elseif (words(3).eq.'on') then
            plevel=1
          elseif (words(3)(1:3).eq.'off') then
            plevel=0
          else
            plevel=ival(words(3))
          end if
          write(*,'(/a,i2/)') 'NOTE:  Print level ',plevel
C set haplotyping output verbosity
        elseif (keyword.eq.'set' .and. keyw2.eq.'hap') then
          if (words(3)(1:3).eq.'ver') then
            showorig=2
          elseif (words(3).eq.'on') then
            showorig=1
          elseif (words(3)(1:3).eq.'off') then
            showorig=0
          else
            showorig=ival(words(3))
          end if
          write(*,'(/a,i2/)') 'NOTE:  Haplotype print level ', showorig
C set pedigree weighting formula
        elseif (keyword.eq.'set'.and.keyw2.eq.'wei') then
          if (words(3)(1:3).eq.'fou') then
            fndr=1
            write(*,'(/a/7x,a/)') 
     2        'NOTE:  Using pedigree gene frequencies',
     3        'weighted by number of founders in pedigree'
          elseif (words(3)(1:3).eq.'imp') then
            fndr=2
            write(*,'(/a,a/)') 
     2        'NOTE:  Using count of imputed alleles',
     3        ' in founders of pedigree'
          else
            fndr=0
            write(*,'(/a/)') 
     &        'NOTE:  Using unweighted sample gene frequencies'
          end if
C set name of data directory
        elseif (keyword.eq.'set' .and. 
     2          (keyw2.eq.'dir' .or. keyw2.eq.'dat')) 
     3  then
          call args(lin,narg,bigwor,1)
          datdir=bigwor(3)
          inquire(file=datdir,exist=filexist)
          if (.not.filexist) then
            write(*,'(/3a/7x,a/)') 
     2        'NOTE:  Directory "',datdir(1:eow(datdir)),
     3        '" not found.','Using ./ as data directory.'
            datdir=' '
          else
            write(*,'(/3a/)') 
     2        'NOTE:  Directory for pedigree files now "',
     3        datdir(1:eow(datdir)),'".'
          end if
C set name of workfile directory
        elseif (keyword.eq.'set'.and.keyw2.eq.'wor') then
          call args(lin,narg,bigwor,1)
          wrkdir=bigwor(3)
          inquire(file=wrkdir,exist=filexist)
          if (.not.filexist) then
            write(*,'(/3a/7x,a/)') 
     2        'NOTE:  Directory "',wrkdir(1:eow(wrkdir)),
     3        '" not found.','Using ./ as work directory.'
          else
            write(*,'(/3a/)') 
     2        'NOTE:  Directory for temporary files now "',
     3        wrkdir(1:eow(wrkdir)),'".'
            call cat(wrkdir,wrkfil)
            call cat(wrkdir,wrk2fil)
          end if
C set location of twinship indicator quantitative trait
C have to keep trait name until read to be resolved
        elseif (keyword.eq.'set'.and.keyw2.eq.'twi'.and..not.red) 
     &  then
          twinning=0
          twintrait=words(3)
          write(*,'(/3a/)') 
     2      'NOTE:  The phenotype "',twintrait(1:eow(twintrait)),
     3      '" now indicates monozygotic (twin) sibships.' 
C add sex to data file as dummy quantitative trait
        elseif (keyword.eq.'set'.and.words(2).eq.'sex'.and..not.red) 
     &  then
          addsex=.true.
          do 300 i=nloci,1,-1
            gen2=i+1
            loc(gen2)=loc(i)
            loctyp(gen2)=loctyp(i)
            locpos(gen2)=locpos(i)+1
  300     continue
          loc(1)='sex'
          loctyp(1)=3
          locpos(1)=1
          nloci=nloci+1
          numloc=numloc+1
        elseif (keyword.eq.'set'.and.keyw2.eq.'ech') then
          echo=.true.
          if (words(3).eq.'off') then
            echo=.false.
          end if
        elseif (keyword.eq.'set'.and.keyw2.eq.'tim') then
          timer=1
          if (words(3).eq.'off') timer=0
C set initial burn-in iterations for Monte-Carlo Markov Chain routines
        elseif (keyword.eq.'set'.and.keyw2.eq.'bur') then
          if (narg.gt.2) burnin=ival(words(3))
          write(*,'(/a,i6/)') 
     &      'NOTE:  Number of MC burn-in iterations ',burnin
        elseif (keyword.eq.'set'.and.keyw2.eq.'bat') then
          if (narg.gt.2) nbatch=ival(words(3))
          write(*,'(/a,i6/)') 
     &      'NOTE:  Number of MC batches ',nbatch
        elseif (keyword.eq.'set'.and.keyw2.eq.'emi') then
          if (narg.gt.2) emiter=ival(words(3))
          write(*,'(/a,i6/)') 
     &      'NOTE:  Number of EM iterations ',emiter
        elseif (keyword.eq.'set'.and.keyw2.eq.'ite') then
          if (narg.gt.2) then
            iter=ival(words(3))
            nbatch=max(1, int(sqrt(10*float(iter))))
          end if
          write(*,'(/a,i6/)') 
     &      'NOTE:  Number of MC iterations ',iter
        elseif (keyword.eq.'set'.and.keyw2.eq.'tun') then
          if (narg.gt.2) tune=fval(words(3))
          if (tune.le.0.0) tune=0.3
          write(*,'(/a,f9.4/)') 
     &      'NOTE:  MCMC proposal tuning parameter ', tune  
        elseif (keyword.eq.'set'.and.keyw2.eq.'tol') then
          if (narg.gt.2) toler=fval(words(3))
          if (toler.le.0.0d0) toler=1.0d-6
          write(*,'(/a,f9.4/)') 
     &      'NOTE:  Convergence criterion ', toler 
        elseif (keyword.eq.'set'.and.keyw2.eq.'cha') then
          if (narg.gt.2) then
            nchain=max(1, ival(words(3)))
          end if
          write(*,'(/a,i2/)') 
     &      'NOTE:  Number of MC random effects chains ', nchain
        elseif (keyword.eq.'set'.and.keyw2.eq.'mca') then
          if (words(3)(1:3).eq.'ord') then
            mcalg=2
          else if (narg.gt.2) then
            mcalg=ival(words(3))
            if (mcalg.lt.1) mcalg=1
            if (mcalg.gt.3) mcalg=3
          end if
          if (mcalg.eq.1) then
            write(*,'(/a/)') 
     &        'NOTE:  Metropolis slice sampler in use for globals.'
          else if (mcalg.eq.2) then
            write(*,'(/a/)') 
     &        'NOTE:  Ordinary Metropolis sampler in use.'
          else if (mcalg.eq.3) then
            write(*,'(/a/7x,a/)') 
     2        'NOTE:  Metropolis slice sampler in use for all ',
     3               'continuous parameters (eg breeding values).'
          end if
        elseif (keyword.eq.'set'.and.keyw2.eq.'sta') then
          if (ival(words(3)).gt.0) then
            maxtry=ival(words(3))
          end if
          write(*,'(/a,i6/)') 
     2      'NOTE:  Number of attempts to generate starting genotypes ',
     3      maxtry
        elseif (keyword.eq.'set'.and.keyw2.eq.'min') then
          if (narg.gt.2) mincnt=ival(words(3))
          write(*,'(/a,i6/)') 
     &      'NOTE:  Minimum numerator for MC P-values ',mincnt
        elseif (keyword.eq.'set'.and.keyw2.eq.'see') then
          if (narg.gt.2) then
            ix=ival(words(3))
            iy=ival(words(4))
            iz=ival(words(5))
            if (iy.eq.0) iy=ix
            if (iz.eq.0) iz=iy
          end if
          write(*,'(a,3(1x,i5)/)') 'Seeds for RNG (AS183)=',ix,iy,iz
        elseif (keyword.eq.'set'.and.keyw2.eq.'pro') then
          prompt=.true.
          if (words(3).eq.'off') then
            prompt=.false.
          else if (prompt) then
            call openlog(LSTR, nhis)
          end if
        elseif (keyword.eq.'set'.and.keyw2.eq.'che') then
          if (words(3).eq.'off') then
            chek=.false.
          elseif (words(3).eq.'on') then
            chek=.true.
          end if
        elseif (keyword.eq.'set'.and.keyw2.eq.'err') then
          if (words(3).eq.'off') then
            droperr=0
          elseif (words(3).eq.'on') then
            droperr=2
          else
            droperr=ival(words(3))
          end if
        elseif (keyword.eq.'set'.and.keyw2.eq.'tdt') then
          if (words(3)(1:3).eq.'bot') then
            use2=2
            write(*,'(/2a/)') 
     2        'NOTE:  Index may contribute to TDT only where ',
     3        'both parents typed.'
          elseif (words(3)(1:3).eq.'fir') then
            use2=3
            write(*,'(/2a/)') 
     2        'NOTE:  Only one index case per pedigree used -- ',
     3        'both parents must be typed.'
          else
            use2=1
            write(*,'(/2a/)') 
     2        'NOTE:  Index may contribute to TDT if one or ',
     3        'both parents typed.'
          end if
        elseif (keyword.eq.'set'.and.keyw2.eq.'hre') then
          if (words(3)(1:3).eq.'zer' .or. words(3)(1:3).eq.'fou') then
            zrec=1
          else if (words(3)(1:3).eq.'chi') then
            zrec=2
          else
            zrec=ival(words(3))
          end if
          if (zrec.eq.0) zrec=2
          if (zrec.eq.1) then
            write(*,'(a/7x,a)') 
     2        'NOTE:  Marker LD model assumes zero recombinants.',
     3        'In trios, parental haplotypes inferred and used.'
          else
            write(*,'(a/7x,a)') 
     2        'NOTE:  Marker LD model assumes recombinants.',
     3        'In trios, offspring haplotypes inferred and used.'
          end if
        elseif (keyword.eq.'set'.and.keyw2.eq.'imp') then
          if (words(3).eq.'off') then
            imp=0
          elseif (words(3).eq.'on') then
            imp=1
          elseif (words(3)(1:3).eq.'lan') then
            imp=4
          else
            imp=ival(words(3))
          end if
          if (imp.gt.0) chek=.true.
        elseif (keyword.eq.'ren' .and. narg.gt.2) then
          call gettrait(words(2),10,0,nloci,loc,loctyp,trait)
          oldnam=isinuse(words(narg), nloci, loc, token, env)
          if (trait.ne.MISS .and. .not.oldnam) then
            write(*,'(5a)') 'Renaming locus "',
     2        loc(trait)(1:eow(loc(trait))),'" to "',
     3        words(narg)(1:eow(words(narg))),'".'
            loc(trait)=words(narg)(1:10)
          else if (oldnam) then
            write(*,'(3a)') 'ERROR: "',
     &        words(narg)(1:eow(words(narg))),'" in use or reserved.'
          end if
C
C keep or drop variables from active list
        elseif (keyword.eq.'kee' .or. keyword.eq.'dro') then
          typ=1
          if (keyword.eq.'dro') typ=2
C select via criterion
          if (keyw2.eq.'whe') then
            do 308 i=1, nloci
              ord(i)=0
  308       continue
C if monomorphic
            if (words(3)(1:3).eq.'mon') then
              do 303 i=1,nloci
              if (loctyp(i).eq.1 .or. loctyp(i).eq.2) then
                call freq(WRK,locpos(i), loctyp(i),pedigree,actset,
     2                    num,nfound,id,fa,mo,sex,locus,numloc,
     3                    numal,name,fndr,alfrq,totall,typed)
                if (numal.lt.2) ord(i)=1
              end if
  303         continue
C via frequency of commonest allele
            else if (words(3)(1:3).eq.'max') then 
              hival=fval(words(4))
              do 304 i=1,nloci
              if (loctyp(i).eq.1 .or. loctyp(i).eq.2) then
                call freq(WRK,locpos(i), loctyp(i),pedigree,actset,
     2                    num,nfound,id,fa,mo,sex,locus,numloc,
     3                    numal,name,fndr,alfrq,totall,typed)
                highest=topall(numal,alfrq)
                if (alfrq(highest).gt.hival) ord(i)=1
              end if
  304         continue
C via the number typed at that locus
            else if (words(3)(1:3).eq.'num') then 
              ntyped=ival(words(4))
              call coutyp(WRK,nloci,loctyp,locpos,
     2                    pedigree, actset, num, nfound,
     3                    id,fa,mo,sex,locus,numloc,
     4                    ord,nped,tnum,tped,tot)
              do 305 i=1,nloci
              if ((typ.eq.1 .and. ord(i).ge.ntyped) .or. 
     &            (typ.eq.2 .and. ord(i).lt.ntyped)) then
                ord(i)=1
              else
                ord(i)=0
              end if
  305         continue
C via a search of the annotations for that locus
            else
              words(3)='*' // words(3)(1:eow(words(3))) // '*'
              do 306 i=1,nloci
                if (strfind(words(3),locnotes(i),1)) then
                  ord(i)=1
                end if
  306         continue
            end if
C or a list of names or wild-card search of the names
          else
            call loadnam(2,narg,words,nloci,loc,
     &                   loctyp,ord,nord,locord,1)
          end if
          if (typ.eq.1) then
            do 31 i=1,nloci
            if (loctyp(i).le.4) then
              loctyp(i)=loctyp(i)+4  
            end if
   31       continue
            do 302 i=1,nloci
            if (ord(i).gt.0) then
              loctyp(i)=loctyp(i)-4
            end if
  302       continue
          else
            do 301 i=1,nloci
            if (ord(i).gt.0 .and. loctyp(i).le.4) then
              loctyp(i)=loctyp(i)+4
            end if
  301       continue
          end if
        elseif (keyword.eq.'und') then
          call loadnam(2,narg,words,nloci,loc,loctyp,ord,nord,locord,2)
          do 33 i=1,nloci
          if (loctyp(i).gt.4 .and. ord(i).gt.0) then
            loctyp(i)=loctyp(i)-4
          end if
   33     continue
C
        elseif (keyword.eq.'ord') then
          call loadnam(2,narg,words,nloci,loc,loctyp,ord,nord,locord,1)
          open(WRK2,file=wrk2fil,form='unformatted')
          call ordvar(WRK2,nloci,loc,loctyp,locpos,nord,locord,map,ord)
          close(WRK2,status='delete')
        elseif (keyword.eq.'run') then
          if (imp.eq.0 .or. imp.eq.4) then
            write(*,'(/2a/8x,a/)') 
     2        'NOTE:  Imputation level 0.  ',
     3        'Not imputing parental genotypes',
     4        'in program step for purposes of TDT etc.'
          elseif (imp.eq.1 .or. imp.eq.5) then
            write(*,'(/a/7x,a/)') 
     2        'NOTE:  Imputation level 1.  Imputing untyped parental',
     3       ' genotypes where unequivocal.'
          elseif (imp.eq.2 .or. imp.eq.6) then
            write(*,'(/a/4(7x,a/))') 
     2        'NOTE:  Imputation level 2.  Imputing untyped parental',
     3        'genotypes where unequivocal.',
     4        'If only the joint parental genotype can be',
     5        'imputed ie {ab} x {cd} .eqv. {cd} x {ab}, then',
     6        'the father is assigned lowest (order) genotype.'
          elseif (imp.eq.3 .or. imp.eq.7) then
            write(*,'(/a/4(7x,a/))') 
     2        'NOTE:  Imputation level 3.  Imputing ALL untyped', 
     3        'genotypes as that conditionally most likely given',
     4        'both the observed genotypes and those imputed up to',
     5        'that point (sequential imputation).'
          end if
          if (twinning.ne.MISS) then
            call gettrait(twintrait,3,4,nloci,loc,loctyp,twinning)
          end if
          if (plevel.gt.0) then
            call info(burnin,imp,iter,ix,iy,iz,mapf,mincnt,plevel,
     2             showorig,addsex,chek,droperr,prompt,use2,
     3             datdir,version,wrkdir)
          end if
          write(*,'(a,a/a,i5)')    
     2        'Pedigree file        = ',pedfil,
     3        'Number of loci       = ',nloci
          call ascend(nloci,locord)
          call listloci(nloci,locord,nloci,loc,loctyp,locpos,locnotes,1)
          if (pedfil.eq.' ') then
            write(*,'(/a/7x,a/)') 
     2        'ERROR: Pedigree file not defined yet.',
     3               'Making dummy pedigree file "inline.ped".'
            pedfil='inline.ped' 
            call mknewfil(OSTR, pedfil, wrkdir)
            open(OSTR,file=pedfil)
            do 400 i=1, 10
              write(OSTR,'(i2,1x,i2,100a:)') i,i,(' x',j=1,numloc+3)
  400       continue
            close(OSTR)
          else
            inquire(file=pedfil,exist=filexist)
            if (.not.filexist) then
              write(*,'(/3a/7x,a/)') 
     2          'ERROR: Pedigree file "',pedfil(1:eow(pedfil)),
     3          '" not found.', 'Stopping prematurely.'
              call stamp(t0)
              stop
            end if
          end if
          inquire(file=wrkfil,exist=filexist)
          if (filexist) then
            close(WRK,status='delete')
          end if
          open(INSTRM,file=pedfil,status='OLD')
          open(WRK,file=wrkfil,form='unformatted')
C
C read in pedigree file, accumulate descriptive statistics,
C do preliminary checks (resolving nonmendelisms by deleting
C problem genotypes) and write to workfile
C
          badfam=0
          badnum=0
          inconsist=0
          imputd=0
          longnam=0
          ndiscard=0
          nwarn=0
          nobs=0
          nped=0
          nships=0
          ntwins=0
          ntyped=0
          tfound=0
          tottyp=0
          bigped=' '
          biggest=0
          deeped=' '
          deepest=0
          totgen=0
          onegen=0
          onemem=0

    5     continue
            famerr=.false.
            call asstyp(nloci, loctyp, locpos, numloc, locord)
            open(WRK2,file=wrk2fil,form='unformatted')
            call pedin(INSTRM,WRK,WRK2,addsex,skipline,link,pedigree,
     2                 num,nfound,id,fa,mo,sex,locus,locord,ord,key1,
     3                 key2,set,last,higen,numloc,lin,words,nwarn,nfam,
     4                 famerr,plevel)
            close(WRK2,status='delete')
            eop=eow(pedigree)
C 
C If pedigree error, drop from further analysis
            if (famerr) then
              write(*,'(/4a/)') 
     2          'ERROR:  Too many pedigree errors. ',
     3          'Dropping pedigree ',pedigree(1:eop),'.' 
              badfam=badfam+1
              badnum=badnum+num
C
C else write to work file
            else  
              if (eop.gt.longnam) longnam=eop
              if (higen.eq.1) onegen=onegen+1
              if (num.eq.1) onemem=onemem+1
              if (num.gt.biggest) then
                biggest=num
                bigped=pedigree
              end if
              if (higen.gt.deepest) then
                deepest=higen
                deeped=pedigree
              end if
              nobs=nobs+num
              nped=nped+1
              nships=nships+nfam
              tfound=tfound+nfound
              totgen=totgen+higen
C
C replace twin sibship indicator with pointer to first twin (or self)
C
            if (twinning.ne.MISS) then
C             do 165 i=1,nfound
C               twin(i)=i
C 165         continue
              do 166 i=nfound+1,num
C               twin(i)=int(locus(i,twinning))
                if (locus(i,twinning).ne.MISS) ntwins=ntwins+1
  166         continue
C             call mkpoint(nfound+1,num,twin,ord,key1)
C           else
C             do 167 i=1,num
C               twin(i)=i
C 167         continue
            end if
C
C order alleles in genotype, rounding as go
C count total genotyped individuals
C
              do 68 i=1,num
                istyp=.false.
                do 69 j=1,nloci
                  if (loctyp(j).le.2) then 
                    gene=locpos(j)
                    gen2=gene+1
C make males homozygotes if X-linked and second allele set to missing
                    if (loctyp(j).eq.2 .and. sex(i).eq.1 .and.
     2                locus(i,gene).ne.MISS .and. locus(i,gene).ne.0.0
     3                .and. (locus(i,gen2).eq.MISS .or.
     4                       locus(i,gen2).eq.0.0)) then
                      locus(i,gen2)=locus(i,gene)
                    end if

                    if (locus(i,gene).eq.0.0 .or. locus(i,gen2).eq.0.0
     2               .or. locus(i,gene).eq.MISS 
     3               .or. locus(i,gen2).eq.MISS) then
                      locus(i,gene)=MISS
                      locus(i,gen2)=MISS
                    elseif (locus(i,gene).gt.locus(i,gen2)) then
                      istyp=.true.
                      tmp=anint(locus(i,gen2))
                      locus(i,gen2)=anint(locus(i,gene))
                      locus(i,gene)=tmp
                    else
                      istyp=.true.
                      locus(i,gene)=anint(locus(i,gene))
                      locus(i,gen2)=anint(locus(i,gen2))
                    end if
                  else if (loctyp(j).eq.4) then
                    gene=locpos(j)
                    if (locus(i,gene).ne.1.0 .and. 
     &                  locus(i,gene).ne.2.0) then
                      locus(i,gene)=MISS
                    end if
                  end if
   69           continue
                if (istyp) ntyped=ntyped+1
   68         continue
C
              if (plevel.ge.0) then
                write(*,'(a,a10,3(1x,a,i4))') 
     2            'Pedigree: ',pedigree, 'No. members: ',num, 
     3            'No. founders: ',nfound, 'No. sibships: ',nfam
              end if
C
C Do nuclear family level Mendelian checking
C
              if (chek) then
                call check(pedigree,num,nfound,id,fa,mo,sex,locus,
     2                     nloci,loc,loctyp,locpos,set,untyped,
     3                     droperr,ndiscard,inconsist,plevel)
              end if
              actset=1
              call wrkout(WRK,pedigree,actset,num,nfound,id,fa,mo,sex,
     &                    locus,numloc)
            end if
          if (.not.last .and. irupt.eq.0) goto 5
          close(INSTRM)
C
C List number of problems encountered
C
          if (droperr.gt.0) then
            write(*,'(/a/a,i5)')  
     2        'Nuclear family error checking completed.',
     3        'Number discarded genotypes = ',ndiscard 
          end if
          if (inconsist.gt.0) then
            write(*,'(/a/a,i5/a)')  
     2        'Nuclear family error checking completed.',
     3        'Number of data problems    = ',inconsist,
     4        'NOTE:  Stopping prematurely.'
            close(WRK,status='delete')
            call stamp(t0)
            stop
          end if
C
C end of 1st while loop
C now perform imputation if requested
C
          if (imp.ge.0) then

            open(WRK2,file=wrk2fil,form='unformatted')
            do 95 i=1,nloci
            if (loctyp(i).le.2) then
              xlinkd=(loctyp(i).eq.2)
              call freq(WRK,locpos(i),loctyp(i),pedigree,
     2               actset,num,nfound,id,fa,mo,sex,locus,numloc,
     3               numal,name,fndr,alfrq,totall,typed)
              call wrfreq(WRK2,loc(i),numal,name,alfrq,map(i),
     &                    totall,typed,nobs,3)
              tottyp=tottyp+typed 
            end if
   95       continue
            call newnam(wrknum, wrkfil)
            open(TWRK,file=wrkfil,form='unformatted')
            rewind(WRK)
            last=.false.

  100       continue
            call wrkin(WRK,pedigree,actset,num,nfound,id,fa,mo,sex,
     &                 locus, numloc,last)
            if (last .or. irupt.ne.0) goto 200
              rewind(WRK2)
              do 120 i=1,nloci
              if (loctyp(i).le.2) then
                xlinkd=(loctyp(i).eq.2)
                read(WRK2) numal,(name(j),j=1,numal),
     &            (alfrq(j),j=1,numal)
                if (allmiss(locpos(i),num,locus)) then
                  if (numal.eq.0) name(1)=1
                  if (plevel.gt.0) then
                    write(*,'(/4a/)') 
     2                'NOTE:  All members of pedigree ',
     3                pedigree(1:eow(pedigree)),
     4                ' are untyped at locus ',loc(i)
                  end if
                  call setall(locpos(i),num,locus, -dfloat(name(1)))
                elseif (imp.gt.0) then
                  limp=imp
                  call exclude(limp,loc(i),xlinkd,locpos(i),pedigree,
     2              num,nfound,id,fa,mo,sex,locus,numal,name,alfrq,set,
     3              ngeno,gset,inconsist,imputd,plevel)
                  if (limp.gt.3) then
                    call accum(numal,alfrq,cumfrq)
                    call start(maxtry,loc(i),xlinkd,locpos(i),pedigree,
     &                      num,nfound,id,fa,mo,sex,locus,numal,name,
     3                      cumfrq,set,sibd,key,inconsist,plevel)
                  end if
                elseif (imp.eq.0.and..not.alltyped(locpos(i),num,locus))
     &          then
                  call accum(numal,alfrq,cumfrq)
                  call start(maxtry,loc(i),xlinkd,locpos(i),pedigree,
     &                    num,nfound,id,fa,mo,sex,locus,numal,name,
     3                    cumfrq,set,sibd,key,inconsist,plevel)
                end if
              end if
  120         continue
              call wrkout(TWRK,pedigree,actset,num,nfound,id,fa,mo,sex,
     &                    locus, numloc)
            goto 100
  200       continue
            close(WRK2,status='delete')
            close(WRK,status='delete')
            close(TWRK,status='keep')
            open(WRK,file=wrkfil,form='unformatted')
          end if
C
C Summary statistics on families
C
          write(*,'(4(/a,i5))') 
     2      'Total number of pedigrees  = ',nped,
     3      'Number with only 1 member  = ',onemem,
     4      'Total number of sibships   = ',nships,
     5      'Total number of subjects   = ',nobs 
          write(*,'(a,i5,a,f5.1,a/a,i6)') 
     2      'Total subjects genotyped   = ',ntyped,
     3      ' (',float(100*ntyped)/float(max(1,nobs)),'%)',
     4      'Total number of genotypes  = ',tottyp
          write(*,'(a,i5,3a/a,i5,3a)') 
     2      'Largest pedigree (members) = ',biggest,
     3      ' (Pedigree ',bigped(1:eow(bigped)),')',
     4      'Deepest pedigree (genrtns) = ',deepest,
     5      ' (Pedigree ',deeped(1:eow(deeped)),')' 
          write(*,'(/a,f7.1/a,f7.1)') 
     2      'Mean size of pedigrees     = ',
     3      dfloat(nobs)/dfloat(max(1,nped)),
     4      'Mean pedigree depth        = ',
     5      dfloat(totgen)/dfloat(max(1,nped)) 
          if (nped.gt.onegen) then
            write(*,'(a,f7.1/a,f7.1)') 
     2      'Mean size where >1 members = ',
     3       dfloat(nobs-onemem)/dfloat(nped-onemem),
     4      'Mean depth where >1 geners = ',
     5       dfloat(totgen-onegen)/dfloat(nped-onegen)
          end if
          write(*,'(a,i5//a,i5/a,i5)') 
     2      'Number of imputed genotypes= ',imputd,
     3      'Number of pedigree errors  = ',badfam,
     4      'Number of deleted records  = ',badnum
          if (nwarn.gt.0) then
            write(*,'(/a,i5)')  
     &      'Number of warnings         = ',nwarn
          end if
C
C Abort if persisting problems
C
          if (inconsist.gt.0) then
            write(*,'(/a,i5)') 
     &      'Number of problems         = ',inconsist 
            if (droperr.lt.2) then
              write(*,'(a)') 'NOTE:  Stopping prematurely.'
              close(WRK,status='delete')
              call stamp(t0)
              stop
            end if
          end if
          if (nped.gt.0) red=.true.
C If reading only locus information from included file return control
          if (loconly) goto 2
C Rename to unique IDs                  
        elseif (keyword.eq.'uni' .and. red) then
          write(*,'(a/a/)') 
     2      'Renaming each pedigree and person to unique numerical ID.',
     3      'Inactive pedigrees are not renumbered!'
          typ=1
          if (keyw2.eq.'seq') then
            typ=2
            write(*,'(a)') 'Individual IDs are sequential.'
          end if
          call newnam(wrknum, wrkfil)
          open(TWRK,file=wrkfil,form='unformatted')
          call uniqid(WRK,TWRK,pedigree,actset,num,nfound,
     &                id,fa,mo,sex,locus,numloc,typ)
          close(WRK,status='delete')
          close(TWRK,status='keep')
          open(WRK,file=wrkfil,form='unformatted')
C Break into component nuclear families
        elseif (keyword.eq.'nuc' .and. red) then
          maxsibs=MAXSIZ-2
          typ=1
          do 48 i=2,narg
          if (words(i)(1:3).eq.'gra') then
            typ=2
          else
            maxsibs=ival(words(i))
          end if
   48     continue
          if (maxsibs.lt.0 .or. maxsibs.gt.(MAXSIZ-2)) maxsibs=MAXSIZ-2
          write(*,'(/a,i4,a,i4,a/a)') 
     2      'Dividing ',nped,' pedigrees into ',nships, 
     3      ' nuclear families.', 
     4      'Individuals are duplicated as necessary.'
          if (maxsibs.ne.(MAXSIZ-2)) then
            write(*,'(a,i3,a/)') 
     2        'Sibships with more than ',maxsibs,
     3        ' members are truncated.'
          else
            write(*,*)
          end if
          longnam=min(longnam+3,10)
          call newnam(wrknum, wrkfil)
          open(TWRK,file=wrkfil,form='unformatted')
          call nuclear(WRK,TWRK,pedigree,actset,num,nfound,
     &                 id,fa,mo,sex,locus,numloc,maxsibs,typ)
          close(WRK,status='delete')
          close(TWRK,status='keep')
          open(WRK,file=wrkfil,form='unformatted')
C break into unrelated cases and controls
        elseif (keyword.eq.'cas' .and. red) then
          call gettrait(words(2),10,0,nloci,loc,loctyp,trait)
          if (trait.ne.MISS) then
            write(*,'(/a/3a/)') 
     2         'Extracting unrelated cases from pedigrees.',
     3         'Subjects must be nonmissing for "',
     4         loc(trait)(1:eow(loc(trait))),'".'
            longnam=min(longnam+3,10)
            call newnam(wrknum, wrkfil)
            open(TWRK,file=wrkfil,form='unformatted')
            call wricas(WRK,TWRK,locpos(trait),pedigree,actset,
     &                  num,nfound,id,fa,mo,sex,locus,numloc)
            close(WRK,status='delete')
            close(TWRK,status='keep')
            open(WRK,file=wrkfil,form='unformatted')
          else
            write(*,'(a)') 'ERROR: Need to specify trait to split on.'
          end if
C extract disjoint subpedigrees
        elseif (keyword.eq.'sub' .and. red) then
          longnam=min(longnam+3,10)
          write(*,'(/a/)') 
     &      'Dividing compound pedigrees into component pedigrees.'  
          call newnam(wrknum, wrkfil)
          open(TWRK,file=wrkfil,form='unformatted')
          call disjoin(WRK,TWRK,pedigree,actset,num,nfound,id,fa,mo,sex,
     &                 locus,numloc,ord,set,plevel)
          close(WRK,status='delete')
          close(TWRK,status='keep')
          open(WRK,file=wrkfil,form='unformatted')
C prune pedigree to affecteds plus connectors
        elseif (keyword.eq.'pru' .and. red) then
          call getbin(2,narg,words,nloci,loc,loctyp,trait,gt,thresh)
          if (trait.ne.MISS) then
            call newnam(wrknum, wrkfil)
            open(TWRK,file=wrkfil,form='unformatted')
            call prunep(WRK,TWRK,loc(trait),locpos(trait),gt,thresh,
     2              pedigree,num,nfound,id,fa,mo,sex,locus,numloc,
     3              key,ord,set,plevel)
            close(WRK,status='delete')
            close(TWRK,status='keep')
            open(WRK,file=wrkfil,form='unformatted')
          else
            write(*,'(a)') 'ERROR: Need to specify trait to prune on.'
          end if
C edit <pedigree> <person> <trait> to <value1> [<value2>]
        elseif (keyword.eq.'edi' .and. red) then
          call args(lin,narg,words,3)
          call gettrait(words(4),10,0,nloci,loc,loctyp,trait)
          if (trait.ne.MISS) then
            if (loctyp(trait).le.2) then
              all1=aval(words(narg-1))
              all2=aval(words(narg))
            else
              all1=fval(words(narg))
            end if
            call newnam(wrknum, wrkfil)
            open(TWRK,file=wrkfil,form='unformatted')
            call edit(WRK,TWRK,words(2)(1:10),words(3)(1:8),
     2                locpos(trait),loc(trait),
     3                loctyp(trait),all1,all2,
     4                pedigree,actset,num,nfound,
     5                id,fa,mo,sex,locus,numloc)
            close(WRK,status='delete')
            close(TWRK,status='keep')
            open(WRK,file=wrkfil,form='unformatted')
          else
            write(*,'(a)') 'ERROR: Need to specify locus to edit.'
          end if
C delete data for <pedigree> <person> or condition
        elseif (keyword.eq.'del' .and. red) then
          typ=0
          call args(lin,narg,words,2)
          i=findwh(2, narg, narg, words)
          if (i.ne.0) then
            typ=2
            call loadnam(2,i-1,words,nloci,loc,loctyp,
     &                   ord,nord,locord,1)
          else if (narg.eq.3) then
            typ=1
          end if
          if (typ.ne.0) then
            call newnam(wrknum, wrkfil)
            open(TWRK,file=wrkfil,form='unformatted')
            if (typ.eq.1) then
              call edit(WRK,TWRK,words(2)(1:10),words(3)(1:8),
     2                MISS,'          ',MISS,0.0d0,0.0d0,
     3                pedigree,actset,num,nfound,id,fa,mo,sex,
     4                locus,numloc)
            else
              call seldel(WRK,TWRK,nord,locord,i+1,narg,words,nloci,loc,
     2               loctyp,locpos,token,env,lbp,rbp,op,wtyp,expr,
     3               pedigree,actset,num,nfound,id,fa,mo,sex,
     4               locus,numloc,plevel)
            end if
            close(WRK,status='delete')
            close(TWRK,status='keep')
            open(WRK,file=wrkfil,form='unformatted')
          end if
C standardize quantitative trait
        elseif (keyword.eq.'sta'.and.red) then
          call gettrait(words(2),3,0,nloci,loc,loctyp,trait)
          if (trait.ne.MISS) then
            typ=1
            if (words(3)(1:3).eq.'fam') then
              typ=2
              write(*,'(/3a)') 'Standardizing "',loc(trait),
     &          '" WITHIN each family to mean=0, variance=1.'
            else
              write(*,'(/3a)') 'Standardizing "',loc(trait),
     &          '" to mean=0, variance=1.'
            end if
            call newnam(wrknum, wrkfil)
            open(TWRK,file=wrkfil,form='unformatted')
            call stand(WRK,TWRK,locpos(trait),pedigree,actset,num,
     &                 nfound,id,fa,mo,sex,locus,numloc,typ)
            close(WRK,status='delete')
            close(TWRK,status='keep')
            open(WRK,file=wrkfil,form='unformatted')
          else
            write(*,'(a)') 
     &        'ERROR: Need to specify locus to standardize.'
          end if
C K-M survival analysis and nonparametric survivor residuals
        elseif (keyword.eq.'kap'.and.red) then
          call gettrait(words(2),3,0,nloci,loc,loctyp,trait)
          call gettrait(words(3),4,0,nloci,loc,loctyp,prob)
          if (trait.ne.MISS .and. prob.ne.MISS) then
            write(*,'(/a/3a/a)')
     2       '------------------------------------------------',
     3       'Kaplan-Meier survivor function for "',
     4       loc(trait)(1:eow(loc(trait))),'"',
     5       '------------------------------------------------'  
            write(*,'(3a)') 
     5       '"',loc(prob)(1:eow(loc(prob))), 
     6       '" is outcome (censoring) trait.'
            typ=1
            if (words(4)(1:2).eq.'re') then
              typ=2
              write(*,'(/3a)') 'Replacing value of "',
     2          loc(trait)(1:eow(loc(trait))), 
     3          '" with nonparametric residual.'
              call newnam(wrknum, wrkfil)
              open(TWRK,file=wrkfil,form='unformatted')
              call prodlim(WRK,TWRK,locpos(trait),locpos(prob),
     2               pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     3               numloc,value,valu2,set,typ,plevel)
              close(WRK,status='delete')
              close(TWRK,status='keep')
              open(WRK,file=wrkfil,form='unformatted')
            else
              call prodlim(WRK,TWRK,locpos(trait),locpos(prob),
     2               pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     3               numloc,value,valu2,set,typ,plevel)
            end if
          else
            write(*,'(a)') 
     &        'ERROR: Need to specify age trait and censoring trait.'
          end if
C to Julian or ISO (epoch 19700101)
        else if (keyword.eq.'set' .and. keyw2.eq.'epo') then
          if (narg.gt.2) then
            if (words(3)(1:3).eq.'iso') then
              epoch=2440588.0d0
            else if (words(3)(1:3).eq.'jul') then
              epoch=0.0d0
            else if (words(3)(1:3).eq.'mjd') then
              epoch=2400000.0d0
            else
              epoch=tojulian(fval(words(4)))
            end if
          end if
          call wrdate(epoch, words(1), 1)
          write(*,'(/a,i9,a,a10,a/)') 
     2       'NOTE:  Julian date epoch ', int(epoch),
     3       ' (', words(1), ').'
        else if (keyword.eq.'dat') then
          if (isreal(words(2))) then
            if (words(3)(1:3).eq.'gre') then
              tmp=togreg(fval(words(2))+epoch)
            else
              tmp=tojulian(fval(words(2)))-epoch
            end if
            write(*,'(/3a,i9)') 
     &        'Date: ', words(2)(1:eow(words(2))), ' = ', int(tmp)
          else if (red) then
            call gettrait(words(2),3,0,nloci,loc,loctyp,trait)
            if (trait.ne.MISS) then
              typ=1
              if (words(3)(1:3).eq.'gre') then
                typ=2
              else if (words(3)(1:3).eq.'yea') then
                typ=3
              end if
              call newnam(wrknum, wrkfil)
              open(TWRK,file=wrkfil,form='unformatted')
              call dateconv(WRK,TWRK,locpos(trait),pedigree,actset,num,
     &                      nfound,id,fa,mo,sex,locus,numloc,typ,epoch)
              close(WRK,status='delete')
              close(TWRK,status='keep')
              open(WRK,file=wrkfil,form='unformatted')
            else
              write(*,'(a)') 'ERROR: Need to specify date (variable).'
            end if
          else
            write(*,'(a/a)') 'ERROR: Dataset not yet read in.',
     &                       'NOTE:  Date format is yyyymmdd.' 
          end if
C linear regressive adjustment of quantitative trait
        else if (keyword.eq.'adj' .and. words(3).eq.'on' .and. red) then
          call gettrait(words(2),3,0,nloci,loc,loctyp,trait)
          call gettrait(words(4),10,0,nloci,loc,loctyp,gene)
          if (trait.ne.MISS .and. gene.ne.MISS) then
            write(*,'(/5a)') 
     2        'Performing regression adjustment of "',
     3        loc(trait)(1:eow(loc(trait))), '" on "', 
     4        loc(gene)(1:eow(loc(gene))),'"'
            if (words(5).eq.'to' .and. narg.eq.6) then
              if (words(6).eq.'m' .or. words(6).eq.'M') then
                adjval=1.0d0
                write(*,'(a/)') 'Adjusting to male expectation'
              elseif (words(6).eq.'f' .or. words(6).eq.'F') then
                adjval=0.0d0
                write(*,'(a/)') 'Adjusting to female expectation'
              else
                adjval=fval(words(6))
                write(*,'(3a,f12.4/)') 
     &            'Adjusting to ',loc(gene),' =',adjval
              end if
            else
              adjval=MISS
              write(*,'(3a/)') 
     &          'Adjusting to ',loc(gene),' = mean value'
            end if
            call newnam(wrknum, wrkfil)
            open(TWRK,file=wrkfil,form='unformatted')
            call adjust(WRK,TWRK,locpos(trait),locpos(gene),adjval,
     2                  pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     3                  numloc,plevel)
            close(WRK,status='delete')
            close(TWRK,status='keep')
            open(WRK,file=wrkfil,form='unformatted')
          else
            write(*,'(a)') 
     &        'ERROR: Need to specify regression variables.'
          end if
C Box-Cox transformation of quantitative trait
        elseif ((keyword.eq.'tra' .or. keyword.eq.'box')
     2          .and. red)  then
          call gettrait(words(2),3,0,nloci,loc,loctyp,trait)
          if (trait.ne.MISS) then
            divisor=fval(words(3))
            offst=fval(words(4))
            power=fval(words(5))
            loval=fval(words(6))
            hival=fval(words(7))
            if (divisor.eq.MISS .or. divisor.eq.0.0d0) divisor=1.0d0
            if (offst.eq.MISS) offst=0.0d0
            if (power.eq.MISS) power=1.0d0
            write(*,'(/3a/3(/a,f9.4))') 
     2        'Transforming locus "',loc(trait)(1:eow(loc(trait))),
     3        '" via boxcox{(x-m)/d,p}', ' Divisor d= ',divisor,
     5        ' Offset  m= ',offst, ' Power p= ',power 
            if (power.eq.1.0d0) then
              write(*,'(a)') ' boxcox{x}= x' 
            elseif (power.eq.0.0d0) then
              write(*,'(a)') ' boxcox{x}= log(x)' 
            else
              write(*,'(a)') ' boxcox{x}= (x^p-1)/p'
            end if
            if (loval.ne.MISS) then
              write(*,'(a,f9.4)') 
     &          ' Truncating transformed values < ',loval
            end if
            if (hival.ne.MISS) then
              write(*,'(a,f9.4)') 
     &          ' Truncating transformed values > ',hival
            end if
            call newnam(wrknum, wrkfil)
            open(TWRK,file=wrkfil,form='unformatted')
            call boxcox(WRK,TWRK,locpos(trait),offst,divisor,power,
     2                  loval, hival, pedigree,actset,num,nfound,
     3                  id,fa,mo,sex,locus,numloc)
            close(WRK,status='delete')
            close(TWRK,status='keep')
            open(WRK,file=wrkfil,form='unformatted')
          else
            write(*,'(a)') 
     &        'ERROR: Need to specify quantitative trait to transform.'
          end if
C global recoding of trait values
        elseif(keyword.eq.'rec' .and. red) then
          call gettrait(words(2),10,0,nloci,loc,loctyp,trait)
          if (trait.ne.MISS) then
            typ=0
            if (words(3)(1:3).eq.'cla') then
              if (loctyp(trait).eq.3 .or. loctyp(trait).eq.4) then
                loctyp(trait)=7-loctyp(trait)
                write(*,'(4a)') 'Recast ',loc(trait)(1:eow(loc(trait))),
     &                          ' as ', typloc(loctyp(trait))
              end if
            else if (narg.eq.2 .and. loctyp(trait).le.2) then
              typ=2
              call freq(WRK,locpos(trait),loctyp(trait),pedigree,
     2               actset,num,nfound,id,fa,mo,sex,locus,numloc,
     3               numal,name,fndr,alfrq,totall,typed)
            else if (words(narg-1).eq.'to' .and. narg.gt.4) then
              typ=1
              if (loctyp(trait).le.2) then
                recto=aval(words(narg))
                nf=narg-4
                do 49 i=1,nf
                  recfro(i)=aval(words(2+i))
   49           continue
              else
                recto=fval(words(narg))
                nf=narg-4
                do 52 i=1,nf
                  recfro(i)=fval(words(2+i))
   52           continue
              end if
            end if
            if (typ.ne.0) then
              call newnam(wrknum, wrkfil)
              open(TWRK,file=wrkfil,form='unformatted')
              if (typ.eq.1) then
                call recode(WRK,TWRK,loc(trait),locpos(trait),
     2                 loctyp(trait),recto,nf,recfro,pedigree,actset,
     3                 num,nfound,id,fa,mo,sex,locus,numloc)
              else if (typ.eq.2) then
                call renumb(WRK,TWRK,loc(trait),locpos(trait),
     2                 numal,name,pedigree,actset,
     3                 num,nfound,id,fa,mo,sex,locus,numloc)
              end if
              close(WRK,status='delete')
              close(TWRK,status='keep')
              open(WRK,file=wrkfil,form='unformatted')
            end if
          else
            write(*,'(a)') 'ERROR: Need to specify locus to recode.'
          end if
C If alleles are nucleotides recode to other strand
        else if(keyword.eq.'fli' .and. red) then
          call loadnam(2,narg,words,nloci,loc,loctyp,ord,nord,locord,1)
          do 58 i=1,nord
            j=locord(i)
            if (loctyp(j).eq.1 .or. loctyp(j).eq.2) then
              call freq(WRK,locpos(j), loctyp(j),pedigree,actset,
     2                  num,nfound,id,fa,mo,sex,locus,numloc,
     3                  numal,name,fndr,alfrq,totall,typed)
              if (numal.le.2) then
                call newnam(wrknum, wrkfil)
                open(TWRK,file=wrkfil,form='unformatted')
                call flip(WRK,TWRK,loc(j),locpos(j),pedigree,actset,num,
     &                    nfound,id,fa,mo,sex,locus,numloc)
                close(WRK,status='delete')
                close(TWRK,status='keep')
                open(WRK,file=wrkfil,form='unformatted')
              end if
            end if
   58     continue
C combine rare alleles for marker loci
        elseif(keyword.eq.'com'.and.red) then
          thresh=0.05d0
          if (isreal(words(narg))) then
            thresh=fval(words(narg))
            narg=narg-1
          end if
          call loadnam(2,narg,words,nloci,loc,loctyp,ord,nord,locord,1)
          do 59 i=1,nord 
            j=locord(i)
            if (loctyp(j).eq.1 .or. loctyp(j).eq.2) then
              write(*,'(3a)') 'Combining rare alleles for ',loc(j),'.'
              call freq(WRK,locpos(j), loctyp(j),pedigree,actset,
     2                  num,nfound,id,fa,mo,sex,locus,numloc,
     3                  numal,name,fndr,alfrq,totall,typed)
              call combine(thresh,recto,nf,recfro,numal,name,alfrq)
              if (nf.gt.1) then
                 call newnam(wrknum, wrkfil)
                 open(TWRK,file=wrkfil,form='unformatted')
                 call recode(WRK,TWRK,loc(j),locpos(j),
     2                   loctyp(j),recto,nf,recfro,pedigree,actset,
     3                   num,nfound,id,fa,mo,sex,locus,numloc)
                 close(WRK,status='delete')
                 close(TWRK,status='keep')
                 open(WRK,file=wrkfil,form='unformatted')
              end if
            end if
   59     continue
        elseif ((keyword.eq.'fac' .or. keyword.eq.'ran').and.red) 
     &  then
          call gettrait(words(2),10,0,nloci,loc,loctyp,gene)
          call gettrait(words(3),3,0,nloci,loc,loctyp,trait)
          typ=1
          if (words(4)(1:3).eq.'fam') typ=2
          if (trait.ne.MISS .and. gene.ne.MISS) then
            if (loctyp(gene).le.2) then
              call freq(WRK,locpos(gene), loctyp(gene),pedigree,actset,
     2                  num,nfound,id,fa,mo, sex,locus,numloc,
     3                  numal,name,fndr,alfrq,totall,typed)
              write(*,'(/3a,i3,3a)') 
     2          'Coding genotypes at "', loc(gene)(1:eow(loc(gene))),
     3          '" to a number 1...',(numal*(numal+1))/2,' in "',
     4          loc(trait)(1:eow(loc(trait))), '".'  
            else 
              write(*,'(/5a)') 
     2          'Placing ranks at "', loc(gene)(1:eow(loc(gene))),
     3          '" in "', loc(trait)(1:eow(loc(trait))), '".'  
            end if
            call newnam(wrknum, wrkfil)
            open(TWRK,file=wrkfil,form='unformatted')
            if (loctyp(gene).le.2) then
              call factor(WRK,TWRK,locpos(trait),locpos(gene),numal,
     2               name,pedigree,actset,num,nfound,id,fa,mo,sex,
     3               locus,numloc)
            else
              call dorank(WRK,TWRK,locpos(trait),locpos(gene),typ,
     &               pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     3               numloc,value,ord)
            end if
            close(WRK,status='delete')
            close(TWRK,status='keep')
            open(WRK,file=wrkfil,form='unformatted')
          else
            write(*,'(a)') 
     &        'ERROR: Need to specify scored locus and result locus.'
          end if
C
C simulate marker data (unconditionally or conditional on one marker)
C
        elseif (keyword.eq.'sim' .and. red) then
          gene=MISS
          h2=0.5d0
          typ=2
          call gettrait(words(2),10,0,nloci,loc,loctyp,trait)
          if (trait.ne.MISS) then
            i=3
            if (loctyp(trait).eq.3 .or. loctyp(trait).eq.4) then
              if (i.le.narg .and. isreal(words(i))) then
                h2=fval(words(i))
                if (h2.gt.1.0d0) then
                  h2=1.0d0
                else if (h2.le.0.0d0) then
                  h2=0.0d0
                end if
                i=i+1
              end if
              typ=1
              write(*,'(3a,f5.3,a)') 
     2          'Simulating "',words(2)(1:eow(words(2))), 
     3          '" as a trait of heritability ',h2,'.'
            else  
              if (.not.isreal(words(i))) then
                call gettrait(words(i),1,0,nloci,loc,loctyp,gene)
                i=i+1
              end if
              if (gene.eq.MISS) then
                if (loctyp(trait).eq.1) then
                  gene=trait
                  typ=1
                  call rdfreq(i,narg,words,nallele,cumfrq)
                  write(*,'(3a,i3,a)') 
     2              'Simulating "',words(2)(1:eow(words(2))), 
     3              '" as a ',nallele,'-allele marker.'
                end if
              else
                call freq(WRK,locpos(gene),loctyp(gene),pedigree,actset,
     2                    num,nfound,id,fa,mo, sex,locus,numloc,
     3                    numal,name,fndr,alfrq,totall,typed)
                if (loctyp(trait).eq.1) then
                  if (i.eq.narg) then
                    typ=3
                    write(*,'(5a)') 
     2                'Simulating "',words(2)(1:eow(words(2))), 
     3                '" as a perfectly informative marker linked to "',
     4              words(3)(1:eow(words(3))),'".' 
                  else
                    call rdfreq(i,narg,words,nallele,cumfrq)
                    write(*,'(3a,i3,3a)') 
     2              'Simulating "',words(2)(1:eow(words(2))),'" as a ',
     3              nallele,'-allele marker linked to "',
     4              words(3)(1:eow(words(3))),'".' 
                  end if
                else
                  typ=2
                  write(*,'(3a)') 
     2              'QTL is completely linked to "',
     3              loc(gene)(1:eow(loc(gene))),'".'
                end if
              end if
            end if
            call newnam(wrknum, wrkfil)
            open(TWRK,file=wrkfil,form='unformatted')
            if (loctyp(trait).eq.1 .or. loctyp(trait).eq.2) then
              call wrsim(WRK,TWRK,typ,locpos(trait),locpos(gene),
     2                pedigree,actset,num,nfound,id,fa,mo,sex,
     3                locus,numloc,numal,name,
     4                cumfrq,untyped,set,sibd,key,plevel)
            else if (loctyp(trait).eq.3 .or. loctyp(trait).eq.4) then
              call wrsimq(WRK, TWRK, typ, locpos(trait), loctyp(trait), 
     2                h2, locpos(gene), pedigree, actset, num, nfound,
     3                id, fa, mo, sex, locus, numloc, numal, name,
     4                cumfrq, set, sibd, key, ibdcount, plevel)
            end if
            close(WRK,status='delete')
            close(TWRK,status='keep')
            open(WRK,file=wrkfil,form='unformatted')
          else
            write(*,'(a)') 'ERROR: Need to specify locus to simulate.'
          end if
C
C selection of pedigrees on name of pedigree or of a member
C
        elseif (keyword.eq.'sel' .and. red .and.  
     &          (keyw2.eq.'ped' .or. keyw2.eq.'id')) then
          i=3
          typ=1
          do 66 j=3, 4
            if (words(j).eq.'not') then
              i=i+1
              typ=3-typ
            else if (words(j).eq.'in') then
              i=i+1
            end if
   66     continue
          if (keyw2.eq.'id') typ=typ+2
          call newnam(wrknum, wrkfil)
          open(TWRK,file=wrkfil,form='unformatted')
          call selped(WRK,TWRK,typ,i,narg,words, pedigree,actset,num,
     &                nfound, id,fa,mo,sex,locus,numloc,plevel)
          close(WRK,status='delete')
          close(TWRK,status='keep')
          open(WRK,file=wrkfil,form='unformatted')
        elseif (keyword.eq.'pri' .and. red .and. keyw2.eq.'ped') then
          i=narg+2
          do 67 j=3, narg
          if (words(j).eq.'id') then
            i=j+1
          end if
   67     continue
          call showdata(WRK,3,i,narg,words,nloci,loc,loctyp,locpos,
     2            pedigree,actset,num,nfound,
     3            id,fa,mo,sex,locus,numloc,nwid,ndec)
C
C selection of pedigrees on logical expression 
C eg given trait value or pedigree size
C
        elseif (keyword.eq.'sel' .and. red) then
          call args(lin,narg,words,2)
          if ((keyw2.eq.'con' .or. keyw2.eq.'exa') .and.
     &        words(4)(1:3).eq.'whe') then
            typ=4
            nprob=ival(words(3))
            if (nprob.eq.0 .or. keyw2.eq.'exa') typ=typ+1
            i=5
          else
            typ=3
            nprob=1
            i=2
            if (keyw2.eq.'whe') i=i+1
          end if
          call typwords(i,narg,words,nloci,loc,loctyp,token,env,
     &                  wtyp,expr,actn)
          if (actn.eq.0) then
            write(*,'(/a)') 'ERROR: Could not parse condition.'
          else
            call newnam(wrknum, wrkfil)
            open(TWRK,file=wrkfil,form='unformatted')
            call doselect(WRK,TWRK,typ,nprob,i,narg,words,nloci,loc,
     2             loctyp,locpos,token,env,lbp,rbp,op,wtyp,expr,
     3             pedigree,actset,num,nfound,id,fa,mo,sex,locus,numloc,
     4             nobs,plevel)
            close(WRK,status='delete')
            close(TWRK,status='keep')
            open(WRK,file=wrkfil,form='unformatted')
          end if
        elseif (keyword.eq.'uns' .and. red) then
          call newnam(wrknum, wrkfil)
          open(TWRK,file=wrkfil,form='unformatted')
          call unsel(WRK,TWRK,pedigree,actset,num,nfound,
     &            id,fa,mo,sex,locus,numloc,nobs,plevel)
          close(WRK,status='delete')
          close(TWRK,status='keep')
          open(WRK,file=wrkfil,form='unformatted')
C pack (ie permanently delete) inactive loci and pedigrees
        elseif (keyword.eq.'pac' .and. red) then
          typ=3
          if (keyw2.eq.'ped') then
            typ=1
          else if (keyw2.eq.'loc') then
            typ=2
          end if
          call newnam(wrknum, wrkfil)
          open(TWRK,file=wrkfil,form='unformatted')
          call packer(WRK,TWRK,typ,pedigree,actset,num,nfound,
     2             id,fa,mo,sex,locus,numloc,nobs,
     3             nloci,loc,loctyp,locpos, map,
     4             nord,locord,plevel)
          close(WRK,status='delete')
          close(TWRK,status='keep')
          open(WRK,file=wrkfil,form='unformatted')
C count pedigrees, sibships on simple expression
        elseif ((keyword.eq.'cou' .or. keyword.eq.'pri') .and. red) then
          typ=1
          if (keyword.eq.'pri') typ=2
          call args(lin,narg,words,2)
          i=2
          if (keyw2.eq.'whe') i=i+1
          call typwords(i,narg,words,nloci,loc,loctyp,token,env,
     &                  wtyp,expr,actn)
          if (actn.eq.0) then
            write(*,'(/a)') 'ERROR: Could not parse condition.'
          else
            call docount(WRK,typ,i,narg,words,nloci,loc,loctyp,locpos,
     2            token,env,lbp,rbp,op,wtyp,expr,pedigree,actset,
     3            num,nfound,id,fa,mo,sex,locus,numloc,nwid,ndec,plevel)
          end if
C recmin haplotypes
        elseif (keyword.eq.'hap' .and. red) then
          call gettrait(words(2),4,0,nloci,loc,loctyp,trait)
          write(*,'(/a/a/a)')
     2    '------------------------------------------------',
     3    'Summary of sibship haplotypes',
     4    '------------------------------------------------' 
          open(WRK2,file=wrk2fil,form='unformatted')
          call dohaplo(WRK,WRK2,trait,iter,nloci,loc,loctyp,locpos,
     2           pedigree,actset,num,nfound,id,fa,mo,sex,locus,numloc,
     3           hset,showorig)
          close(WRK2,status='delete')
C haplotypes from complete trios
        elseif (keyword.eq.'tri' .and. red) then
          if (narg.eq.1) then
            narg=2
            words(2)='$m'
          end if
          call loadnam(2,narg,words,nloci,loc,
     &                 loctyp,ord,nord,locord,1)
          write(*,'(/a/a,a,3(a1,a)/(12x,4(a1,a)):)')
     2      '------------------------------------------------',
     3      'Haplotypes: ', loc(locord(1))(1:eow(loc(locord(1)))),
     4      ('-',loc(locord(j))(1:eow(loc(locord(j)))),j=2,nord)
          write(*,'(a)') 
     &      '------------------------------------------------' 
          call hapimp(WRK, nord, locord, loc, locpos,loctyp,
     2           pedigree,actset,num,nfound,id,fa,mo,sex,locus,numloc,
     3           ord, key, set, hset, plevel)
C pedigree listing
        elseif (keyword.eq.'gen' .and. red) then
          call gettrait(words(2),3,0,nloci,loc,loctyp,trait)
          write(*,'(/a/a/a)')
     2    '------------------------------------------------',
     3    'Summary of structure of pedigrees',
     4    '------------------------------------------------' 
          if (trait.ne.MISS) then
            write(*,'(3a/)') 
     2        'NOTE:  Writing generation number to ',
     3        loc(trait)(1:eow(loc(trait))),'.'
            trait=locpos(trait)
            call newnam(wrknum, wrkfil)
            open(TWRK,file=wrkfil,form='unformatted')
            call dogen(WRK,TWRK,pedigree,actset,num,nfound,id,fa,mo,sex,
     &                 locus, numloc,ord,set,trait,plevel)
            close(WRK,status='delete')
            close(TWRK,status='keep')
            open(WRK,file=wrkfil,form='unformatted')
          else
            call dogen(WRK,TWRK,pedigree,actset,num,nfound,id,fa,mo,sex,
     &                 locus, numloc,ord,set,trait,plevel)
          end if
        elseif (keyword.eq.'rel' .and. red) then
            call relations(WRK,words(2)(1:10),words(3)(1:8),
     2           pedigree,actset,num,
     3           nfound,id,fa,mo,sex,locus,numloc,key,plevel)
C HWE chi-squares
        elseif (keyword.eq.'hwe') then
          if (narg.eq.2 .and. isreal(words(2))) then
            numal=ival(words(2))
            call hwep(numal,gcount)
          else if (red) then
            i=2
            assfnd=.false.
            if (keyw2.eq.'fou') then
              i=3
              assfnd=.true.
            end if
            call loadnam(i,narg,words,
     &                   nloci,loc,loctyp,ord,nord,locord,1)

            write(*,'(/a/a/a)')
     2      '--------------------------------------------------',
     3      'Hardy-Weinberg equilibrium for marker loci',
     4      '--------------------------------------------------'
            if (assfnd) then
              write(*,'(a/)') 
     &          'NOTE:  Analysis restricted to founders only.'
            end if
            if (plevel.lt.1) then
              write(*,'(/a/a)')
     2        'Marker     Typed  Genos  Chi-square Asy P  Emp P  Iters',
     3        '---------- ------ ------ ---------- ------ ------ ------'
            end if
            do 219 i=1,nord 
              j=locord(i)
              if ((loctyp(j).eq.1.or.loctyp(j).eq.2) .and.
     &            irupt.eq.0) then
                xlinkd=(loctyp(j).eq.2)
                call freq(WRK,locpos(j), loctyp(j),pedigree,actset,
     2                    num,nfound,id,fa,mo,sex,locus,numloc,
     3                    numal,name,fndr,alfrq,totall,typed)
                call accum(numal,alfrq,cumfrq)
                open(WRK2,file=wrk2fil,form='unformatted')
                call dohwe(WRK,WRK2,loc(j),locpos(j),
     2                 xlinkd,iter,mincnt,assfnd,pedigree,actset,
     3                 num,nfound,id,fa,mo,sex,locus,numloc,numal,
     4                 name,cumfrq,set,untyped,ngcount,gcount,plevel)
                close(WRK2,status='delete')
                if (plevel.gt.0) then
                  if (.not.xlinkd) then
                    call domar(WRK,locpos(j),pedigree,actset,num,nfound,
     &                     id,fa,mo,sex, locus,numloc, 
     3                     numal,name,alfrq,plevel)
                  end if
                  call margen(WRK,locpos(j),xlinkd,pedigree,actset,num,
     2                   nfound,id,fa,mo,sex,locus,numloc,
     3                   key1,key2,scatter,gfrq,iter,
     4                   numal,name,alfrq,plevel)
                end if
              end if
  219       continue
          else
            write(*,'(a)') 'ERROR: Need number or dataset read in.'
          end if
C LD chi-squares
        elseif (keyword.eq.'dis' .or. keyword.eq.'ld') then
          if ((narg.eq.2 .or. narg.eq.3) .and. isreal(words(2))) then
            numal=ival(words(2))
            numal2=numal
            if (narg.eq.3) numal2=ival(words(3))
            call ldp(numal,name,numal2,name2,scatter,counts,full,ex,
     &               oldex,model,offset,x,r,b,cov,plevel)
          else if (red) then
            write(*,'(/a/a/a/)')
     2      '---------------------------------------------------',
     3      'Inter-marker allelic association analysis',
     4      '---------------------------------------------------' 
            typ=3
            if (narg.eq.2 .and. keyw2.eq.'all') then
              typ=typ+1
            else
              call gettrait(words(2),1,2,nloci,loc,loctyp,trait)
              call gettrait(words(3),1,2,nloci,loc,loctyp,gene)
              if (trait.ne.MISS) typ=typ-1
              if (gene.ne.MISS) typ=typ-1
            end if
            istyp=(keyword.eq.'ld')
            if (plevel.lt.1) then
              write(*,'(a/a)') 
     2  'Marker 1   Marker 2      N mean D''    r2 Chi-sq  df  Asy P',
     3  '---------- ---------- ---- ------- ----- ------ --- ------'
            end if
            last=.false.
 430        continue
              call ldlist(typ,trait,gene,nloci,loctyp,last)
            if (last) goto 431
              call freq(WRK,locpos(trait), loctyp(trait),pedigree,
     2                  actset,num,nfound,id,fa,mo, sex,locus,numloc,
     3                  numal,name,fndr,alfrq,totall,typed)
              call freq(WRK,locpos(gene), loctyp(gene),pedigree,
     2                  actset,num,nfound,id,fa,mo, sex,locus,numloc,
     3                  numal2,name2,fndr,alfrq2,totall,typed)
              if (istyp .or. (numal.gt.5 .and. numal2.gt.5)) then
                call twold(WRK,zrec,locpos(trait),loc(trait),
     2                    loctyp(trait),locpos(gene),loc(gene),
     3                    loctyp(gene),iter,pedigree,actset,num,
     4                    nfound,id,fa,mo,sex,locus,numloc,numal,name,
     5                    alfrq,numal2,name2,alfrq2,untyped,
     6                    ngcount,gcount,key,gfrq,plevel)
              else
                call twold2(WRK,zrec,locpos(trait),loc(trait),
     2                    loctyp(trait),locpos(gene),loc(gene),
     3                    loctyp(gene),iter,pedigree,actset,num,nfound,
     4                    id,fa,mo,sex,locus,numloc,numal,
     5                    name,numal2,name2,scatter,counts,full,ex,
     6                    oldex,model,offset,x,r,b,cov,untyped,plevel)
              end if
            goto 430
 431        continue
          else
            write(*,'(a)') 'ERROR: Need numbers or dataset read in.'
          end if
C print out estimated genotype distribution for selected individuals from a
C particular pedigree
        elseif (keyword.eq.'mcm' .and. red) then
          call gettrait(words(2),1,0,nloci,loc,loctyp,gene)
          if (gene.ne.MISS .and. irupt.eq.0) then
            write(*,'(/a/3a/a)')
     2      '--------------------------------------------------',
     3      'MCMC genotype distribution for marker "',
     4      loc(gene)(1:eow(loc(gene))),'"',
     5      '--------------------------------------------------'
            call freq(WRK,locpos(gene),loctyp(gene),pedigree,actset,
     2                num,nfound,id,fa,mo,sex,locus,numloc,
     3                numal,name,fndr,alfrq,totall,typed)
            call accum(numal,alfrq,cumfrq)
            call doimp(WRK,locpos(gene),narg,words,
     2             iter,burnin,pedigree,actset,num,nfound,
     3             id,fa,mo,sex,locus,numloc,numal,name,alfrq,cumfrq,
     4             gfrq,set,set2,sibd,key,untyped,plevel)
          else
            write(*,'(a)') 'ERROR: Need a marker locus to simulate.'
          end if

C association analysis (ANOVA or chi-square)
        elseif (keyword.eq.'ass' .and. red) then
          call gettrait(words(2),3,4,nloci,loc,loctyp,trait)
          assfnd=.false.
          gt=0
          nord=0
          thresh=MISS
          typ=1
C while not end of list of keywords
          i=3
  441     if (i.gt.narg) goto 442
            keyword=words(i)(1:3)
            if (iscomp(keyword)) then
              call docomp(i, words, gt, thresh)
            elseif (keyword.eq.'gen') then
              typ=2
              i=i+1
            elseif (keyword.eq.'fou') then
              assfnd=.true.
              i=i+1
            else if (keyword.eq.'cov' .and. i.lt.narg) then
              call gettrait(words(i+1),10,0,nloci,loc,loctyp,gene)
              if (gene.ne.MISS) then
                nord=nord+1
                locord(nord)=gene
              end if
              i=i+2
            else
              write(*,'(3a)') 'Skipping unknown keyword "',
     &          words(i)(1:eow(words(i))),'".'
              i=i+1
            end if  
            goto 441
  442     continue
          if (trait.ne.MISS) then
            write(*,'(/a/3a/a)')
     2      '--------------------------------------------------',
     3      'Allelic association testing for trait "',
     4      loc(trait)(1:eow(loc(trait))),'"',
     4      '--------------------------------------------------'
            if (assfnd) then
              write(*,'(a/)') 
     &          'NOTE:  Analysis restricted to founders only.'
            end if
            if (thresh.ne.MISS) call defpro(gt, thresh)
            if (typ.eq.2) then
              write(*,'(a/)') 
     &          'NOTE:  Genotypic rather than allelic association test.'
            end if
            if (nord.gt.0) then
              write(*,'(a,$)') 'NOTE:  Covariates are:'
              do 443 i=1, nord
                j=locord(i)
                write(*,'(3a,$)') ' "',loc(j)(1:eow(loc(j))),'"'
  443         continue
              write(*,'(a)') '.'
            end if
            if (plevel.lt.1) then
              if (typ.eq.1) then
                 write(*,'(/a/a)')
     2      'Marker     Typed  Allels Chi-square Asy P  Emp P  Iters',
     3      '---------- ------ ------ ---------- ------ ------ ------'
              else
                 write(*,'(/a/a)')
     2      'Marker     Typed  Gtps   Chi-square Asy P  Emp P  Iters',
     3      '---------- ------ ------ ---------- ------ ------ ------'
              end if
            end if
            do 600 i=1,nloci
            if ((loctyp(i).eq.1.or.loctyp(i).eq.2).and.irupt.eq.0) then
              xlinkd=(loctyp(i).eq.2)
              call freq(WRK,locpos(i), loctyp(i),pedigree,actset,
     2                  num,nfound,id,fa,mo,sex, locus,numloc,
     3                  numal,name,fndr,alfrq,totall,typed)
              highest=topall(numal,alfrq)
              call accum(numal,alfrq,cumfrq)
              open(WRK2,file=wrk2fil,form='unformatted')
              if (loctyp(trait).eq.3 .and. thresh.eq.MISS) then
                call doanova(WRK,WRK2,locpos(trait),loc(i),locpos(i),
     2                xlinkd,iter,mincnt,assfnd,x,r,b,cov,pedigree,
     3                actset,num,nfound,id,fa,mo,sex,locus,numloc,
     4                numal,name,cumfrq,untyped,value,key2,
     5                set,plevel,typ)
                close(WRK2,status='delete')
                open(WRK2,file=wrk2fil,form='unformatted')
                call qtdt(WRK,WRK2,locpos(trait),loc(i),locpos(i),
     2                xlinkd,iter,mincnt,x,r,b,cov,pedigree,actset,
     3                num,nfound,id,fa,mo,sex,locus,numloc,numal,name,
     4                untyped,value,key2,set,plevel)
              else
                call doassoc(WRK,WRK2,locpos(trait),loc(i),locpos(i),
     2            iter,mincnt,xlinkd,assfnd,gt,thresh,pedigree,
     3            actset,num,nfound,id,fa,mo,sex,locus,numloc,numal,
     4            name,cntall,cumfrq,key1,untyped,set,plevel,typ)
                close(WRK2,status='delete')
                open(WRK2,file=wrk2fil,form='unformatted')
                call binass(WRK,WRK2,TWRK,TWRK2,locpos(trait),i,
     2            highest,nord,locord,loc,loctyp,locpos,iter,mincnt,
     3            xlinkd,assfnd,gt,thresh,x,r,b,cov,
     4            pedigree,actset,num,nfound,id,fa,mo,sex,
     5            locus,numloc,ord,numal,name,cumfrq,
     6            set,key2,plevel)
                if (.not.xlinkd) then
                  close(WRK2,status='delete')
                  open(WRK2,file=wrk2fil,form='unformatted')
                  call rctdt(WRK,WRK2,locpos(trait),loc(i),locpos(i),
     2                  iter,mincnt,gt,thresh,pedigree,actset,
     3                  num,nfound,id,fa,mo,sex,locus,numloc,numal,
     4                  name,cntall,key1,set,alfrq,cumfrq,gfrq,plevel)
                end if
              end if
              close(WRK2,status='delete')
            end if
  600       continue
          else
            write(*,'(a)') 'ERROR: Need to specify trait locus.'
          end if
C homozygosity analysis
        elseif ((keyword.eq.'hom' .or. keyword.eq.'mul') .and. red) then
          call getbin(2,narg,words,nloci,loc,loctyp,trait,gt,thresh)
          if (trait.ne.MISS) then
            write(*,'(/a/3a/a)')
     2      '--------------------------------------------------',
     3      'Marker homozygosity in cases of trait "',
     4      loc(trait)(1:eow(loc(trait))),'"',
     5      '--------------------------------------------------'
            if (thresh.ne.MISS) call defpro(gt, thresh)
            trait=locpos(trait)
          else
            write(*,'(/a/a/a)')
     2      '--------------------------------------------------',
     3      'Marker homozygosity in all typed individuals',
     4      '--------------------------------------------------'
          end if
          if (keyword.eq.'hom') then
            write(*,'(/a/a)')
     2      'Marker        N    Obs    Exp    Fis     Z  Emp P  Iters',
     3      '---------- ---- ------ ------ ------ ------ ------ ------'
            do 660 i=1,nloci
            if ((loctyp(i).eq.1.or.loctyp(i).eq.2).and.irupt.eq.0) then
              xlinkd=(loctyp(i).eq.2)
              call freq(WRK,locpos(i),loctyp(i),pedigree,actset,
     2                  num,nfound,id,fa,mo,sex,locus,numloc,
     3                  numal,name,fndr,alfrq,totall,typed)
              call accum(numal,alfrq,cumfrq)
              open(WRK2,file=wrk2fil,form='unformatted')
              call dohomoz(WRK,WRK2,trait,loc(i),locpos(i),xlinkd,
     2                    iter,mincnt,gt,thresh,pedigree,actset,num,
     3                    nfound,id,fa,mo,sex,locus,numloc,numal,alfrq,
     4                    cumfrq,untyped,set,plevel)
              close(WRK2,status='delete')
            end if
  660       continue
          else
            if (plevel.le.0) then
              write(*,'(/2a/2a)') '     Marker Set          Aff  Nmark',
     2           ' Obs-Run Exp-Run    Z    Emp P  Iters',
     3                            '--------------------- ------ ------',
     4           ' ------- ------- ------ ------  -----'
            end if
            open(WRK2,file=wrk2fil,form='unformatted')
            do 661 i=1,nloci
            if (loctyp(i).eq.1 .and. irupt.eq.0) then
              call freq(WRK,locpos(i), loctyp(i),pedigree,actset,
     2                  num,nfound,id,fa,mo,sex,locus,numloc,
     3                  numal,name,fndr,alfrq,totall,typed)
              call accum(numal,alfrq,cumfrq)
              write(WRK2) numal,(cumfrq(j),j=1,numal)
            end if
  661       continue
            call newnam(wrknum, wrkfil)
            open(TWRK,file=wrkfil,form='unformatted')
            call mulhom(WRK,WRK2,TWRK,trait,gt,thresh,xlinkd,
     2             iter,mincnt,nloci,loc,loctyp,locpos,
     3             map,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     4             numloc,hset,numal,cumfrq,plevel)
            close(WRK2,status='delete')
            close(TWRK,status='delete')
          end if
C Schaid and Sommer
        elseif (keyword.eq.'sch' .and. red) then
          call gettrait(words(2),4,0,nloci,loc,loctyp,trait)
          call gettrait(words(3),1,0,nloci,loc,loctyp,gene)
          candal=int(aval(words(4)))
          other=0 
          if (trait.ne.MISS .and. gene.ne.MISS) then
            write(*,'(/a/3a/a)')
     2      '--------------------------------------------------',
     3      'Schaid & Sommer HWE analysis of trait "',
     4      loc(trait)(1:eow(loc(trait))),'"',
     5      '--------------------------------------------------'
            call freq(WRK,locpos(gene),loctyp(gene),pedigree,actset,
     2                num,nfound,id,fa,mo,sex,locus,numloc,
     3                numal,name,fndr,alfrq,totall,typed)
            if (candal.le.0) then
              candal=name(topall(numal,alfrq))
            end if
            call wrall(candal, keyw2)
            if (numal.eq.2) then
              other=othall(int(candal), numal, name)
            end if
            write(*,'(4a)') 
     &        'Versus allele ',keyw2,' of marker ',loc(gene)
            call nucseg(WRK,locpos(trait),locpos(gene),candal,other,
     2             x,r,b,cov,pedigree,actset,num,nfound,id,fa,mo,sex,
     3             locus, numloc, key, plevel)
          else
            write(*,'(a)') 'ERROR: Need to specify trait and marker.'
          end if
C TDTs
        elseif (keyword.eq.'tdt'.and.red) then
          call gettrait(words(2),3,4,nloci,loc,loctyp,trait)
          if (trait.ne.MISS) then
            cutoff=0
            gt=0
            thresh=MISS
            typ=3
C while not end of list of keywords
            i=3
  318       if (i.gt.narg) goto 319
              keyword=words(i)(1:3)
              if (iscomp(keyword)) then
                call docomp(i, words, gt, thresh)
              else if (keyword.eq.'cut') then
                cutoff=ival(words(i+1))
                i=i+2
              elseif (keyword.eq.'mat') then
                typ=1
                i=i+1
              elseif (keyword.eq.'pat') then
                typ=2
                i=i+1
              else
                write(*,'(3a)') 'Skipping unknown keyword "',
     &            words(i)(1:eow(words(i))),'".'
                i=i+1
              end if  
              goto 318
  319       continue
C
            write(*,'(/a/3a/a/)')
     2      '------------------------------------------------',
     3      'TDT for trait "',loc(trait)(1:eow(loc(trait))),
     4      '" v. all markers',
     5      '------------------------------------------------'
            if (typ.eq.1) then
                write(*,'(a/)') 'NOTE:  Maternal contributions only.'
            elseif (typ.eq.2) then
                write(*,'(a/)') 'NOTE:  Paternal contributions only.'
            end if
            if (thresh.ne.MISS) call defpro(gt, thresh)
            if (plevel.lt.1) then
              write(*,'(/a/a)')
     2        'Marker     Typed  NParam Chi-square Asy P  Emp P  Iters',
     3        '---------- ------ ------ ---------- ------ ------ ------'
            end if
            do 20 i=1,nloci
            if ((loctyp(i).eq.1.or.loctyp(i).eq.2).and.irupt.eq.0) then
              xlinkd=(loctyp(i).eq.2)
              call freq(WRK,locpos(i), loctyp(i),pedigree,actset,
     2                  num,nfound,id,fa,mo,sex,locus,numloc,
     3                  numal,name,fndr,alfrq,totall,typed)
              open(WRK2,file=wrk2fil,form='unformatted')
              call dotdt(WRK,WRK2,locpos(trait),loc(i),locpos(i),xlinkd,
     2          iter,mincnt,use2,typ,cutoff,gt,thresh,pedigree,
     3          actset,num,nfound,id,fa,mo,sex,locus,numloc,numal,name,
     4          untyped,set,nallele,cntall,ngcount,gcount,plevel)
              close(WRK2,status='delete')
            end if
   20       continue
          else
            write(*,'(a)') 'ERROR: Need to specify trait.'
          end if
C Nontransmitted alleles to proband
        elseif (keyword.eq.'hrr'.and.red) then
          call getbin(2,narg,words,nloci,loc,loctyp,trait,gt,thresh)
          if (trait.ne.MISS) then
            write(*,'(/a/3a/a/)')
     2      '----------------------------------------------------',
     3      'Haplotype Relative Risk for trait "', 
     4      loc(trait)(1:eow(loc(trait))),'" v. all markers',
     5      '----------------------------------------------------'
            if (thresh.ne.MISS) call defpro(gt, thresh)
            if (plevel.lt.1) then
              write(*,'(/a/a)')
     2        'Marker     Typed  NParam Chi-square Asy P  Emp P  Iters',
     3        '---------- ------ ------ ---------- ------ ------ ------'
            end if
            do 21 i=1,nloci
            if ((loctyp(i).eq.1.or.loctyp(i).eq.2).and.irupt.eq.0) then
              xlinkd=(loctyp(i).eq.2)
              call freq(WRK,locpos(i), loctyp(i),pedigree,actset,
     2                  num,nfound,id,fa,mo,sex,locus,numloc,
     3                  numal,name,fndr,alfrq,totall,typed)
              call accum(numal,alfrq,cumfrq)
              open(WRK2,file=wrk2fil,form='unformatted')
              call dohrr(WRK,WRK2,locpos(trait),loc(i),locpos(i),
     2               iter,mincnt,xlinkd,gt,thresh,pedigree,actset,
     3               num,nfound,id,fa,mo,sex,locus,numloc,numal,
     4               name,cntall,cumfrq,key1,untyped,set,plevel)
              close(WRK2,status='delete')
            end if
   21       continue
          else
            write(*,'(a)') 'ERROR: Need to specify trait.'
          end if
C descriptive statistics for traits
        elseif ((keyword.eq.'fre' .or. keyword.eq.'des') .and. red) then
          typ=1
          if (keyw2.eq.'snp') then
            typ=2
            narg=3
            words(2)='$m'
            words(3)='$x'
            write(*,'(/a/a)') 
     2        'Marker         NAll  Allele(s)    Freq   Het    Ntyped',
     3        '-------------- ---- -----------   ------ ------ ------'
          end if
          call loadnam(2,narg,words,nloci,loc,loctyp,ord,nord,locord,1)
          do 19 i=1,nord 
          if (irupt.eq.0) then
            j=locord(i)
            if (loctyp(j).eq.1 .or. loctyp(j).eq.2) then
              call freq(WRK,locpos(j), loctyp(j),pedigree,actset,
     2                  num,nfound,id,fa,mo,sex,locus,numloc,
     3                  numal,name,fndr,alfrq,totall,typed)
              call wrfreq(WRK2,loc(j),numal,name,alfrq,map(i),
     &               totall,typed,nobs,typ)
            elseif (loctyp(j).eq.3) then
              call famcor(WRK,loc(j),locpos(j),pedigree,actset,num,
     &               nfound,id,fa,mo,sex, locus, numloc,plevel)
            elseif (loctyp(j).eq.4) then
              call segrat(WRK,loc(j),locpos(j),pedigree,actset,num,
     &               nfound,id,fa,mo,sex, locus, numloc)
            end if
          end if
   19     continue
C MCEM estimation of marker allele frequencies
        elseif (keyword.eq.'mcf'.and.red) then
          call loadnam(2,narg,words,nloci,loc,loctyp,ord,nord,locord,1)
          do 119 i=1,nord 
          if (irupt.eq.0) then
            j=locord(i)
            if (loctyp(j).eq.1) then
              call freq(WRK,locpos(j), loctyp(j),pedigree,actset,
     2                  num,nfound,id,fa,mo,sex,locus,numloc,
     3                  numal,name,fndr,alfrq,totall,typed)
              call mcfreq(WRK,TWRK,TWRK2,locpos(j),iter, emiter,
     3               pedigree,actset,num,nfound,id,fa,mo,sex,
     4               locus,numloc,numal,name,alfrq,alfrq2,gfrq,set,set2,
     5               sibd,key,untyped,totall,typed,plevel)
              call wrfreq(WRK2,loc(j),numal,name,alfrq,map(i),
     &               totall,typed,nobs,11)
            end if
          end if
  119     continue
C Corrected segregation ratios following Davie 1976
        elseif (keyword.eq.'dav'.and.red) then
          call gettrait(words(2),4,0,nloci,loc,loctyp,trait)
          call gettrait(words(3),4,0,nloci,loc,loctyp,prob)
          if (trait.ne.MISS) then
            if (prob.eq.MISS) prob=trait
            call davie(WRK,loc(trait),locpos(trait),loc(prob),
     2               locpos(prob),pedigree,actset,num,nfound,id,fa,mo,
     3               sex,locus,numloc,plevel)
          else
            write(*,'(a)') 'ERROR: Need to specify trait.'
          end if
C
C Variance components analysis
C typ 1=CE 2=AE 3=ACE 4=ADE 
C     5=AQE (6=AQE if ibd matrix in script)
C     7=CQE
C
        elseif (keyword.eq.'var' .and. red) then
          call gettrait(words(2),3,4,nloci,loc,loctyp,trait)
          if (trait.ne.MISS) then
            nord=0
            typ=4
            i=3
            gene=MISS
  531       if (i.gt.narg) goto 532
              keyword=words(i)(1:3)
              if (keyword.eq.'ce') then
                typ=1
                i=i+1
              elseif (keyword.eq.'ae') then
                typ=2
                i=i+1
              elseif (keyword.eq.'ace') then
                typ=3
                i=i+1
              elseif (keyword.eq.'aqe') then
                typ=6
                i=i+1
              else if (keyword.eq.'cov' .and. i.lt.narg) then
                call loadnam(i+1,narg,words,nloci,loc,
     &                       loctyp,ord,nord,locord,1)
                gene=findml(nord,locord,loctyp)
                i=narg+1
              else
                write(*,'(3a)') 'Skipping unknown keyword "',
     &            words(i)(1:eow(words(i))),'".'
                i=i+1
              end if  
              goto 531
  532       continue
            nord=nord+1
            locord(nord)=trait
C enumerate levels for covariate marker and 
C calculate fixed effects starting values
            if (gene .ne. MISS) then
              call freq(WRK,locpos(gene),loctyp(gene),pedigree,actset,
     2                  num,nfound,id,fa,mo,sex,locus,numloc,
     3                  numal,name,fndr,alfrq,totall,typed)
            end if
            if (nord.gt.1) then
              call regress(WRK,TWRK,-1,nord,locord,loc,loctyp,locpos,
     2               gene,numal,name,x,r,b,cov,mval,pedigree,actset,
     3               num,nfound,id,fa,mo,sex,locus,numloc,plevel)
              do 533 j=1, min(MAXALL, MAXTER)
                alfrq(j)=b(j)
  533         continue
            end if
            whlik=3-whlik
            open(WRK2,file=wrk2fil,form='unformatted')
            call varcom(WRK,WRK2,TWRK,nord,locord,loc,loctyp,locpos,
     2              loc(gene),gene,numal,name,alfrq, mval,
     3              pedigree,actset,num,nfound,id,fa,mo,sex,
     4              locus,numloc,untyped,ibdcount,count2,
     5              mlik(whlik), mpar(whlik), plevel, typ, toler)
            close(WRK2,status='delete')
          else
            write(*,'(a)') 'ERROR: Need to specify trait.'
          end if
        elseif (keyword.eq.'lrt' .and. red) then
          expr(1,1)=mlik(whlik)-mlik(3-whlik)
          i=mpar(3-whlik)-mpar(whlik)
          if (i.lt.0) then
            i=-i
            expr(1,1)=-expr(1,1)
          end if
          write(*,'(/a/a/2(a,f12.4,i5/),a,f12.4,i5,2x,f6.4)') 
     2      'Term         -2*LL NPar  P-value',
     3      '------ ----------- ----  -------',
     4      'Model0', mlik(3-whlik), mpar(3-whlik),
     5      'Model1', mlik(whlik), mpar(whlik),
     6      'LRTS  ', expr(1,1), i, chip(expr(1,1),i)
        elseif (keyword.eq.'blu' .and. red) then
          call gettrait(words(2),3,0,nloci,loc,loctyp,trait)
          h2=fval(words(3))
          if (h2.gt.1.0d0) then
            h2=1.d00
          else if (h2 .ne. MISS .and. h2.le.0.0d0) then
            h2=0.d00
          end if
          if (trait.ne.MISS .and. h2.ne.MISS) then
            call doblup(WRK,loc(trait),locpos(trait),h2,pedigree,actset,
     2             num,nfound,id,fa,mo,sex,locus,numloc,value,
     3             ibdcount, count2, plevel)
          else
            write(*,'(a)') 
     &        'ERROR: Need to specify trait and heritability.'
          end if
C
C SML/Finite polygenic/mixed/GLMM MCMC sampler
C
        elseif (keyword.eq.'fpm' .and. red) then
          call gettrait(words(2),3,4,nloci,loc,loctyp,trait)
          if (trait.ne.MISS) then
            nfix=0
            censor=MISS
            off=MISS
            call mksegmod(narg, words, trait, gt, thresh, off, censor,
     2             nord, locord, nloci, loc, loctyp, priran,
     3             nqtl, paract, par, parscal, linkf, modtyp, shap)
            if (nord.gt.1) then
              nfix=nord-1
              gene=findml(nord,locord,loctyp)
C enumerate levels for covariate marker and 
C calculate fixed effects starting values and scales
              if (gene .ne. MISS) then
                call freq(WRK,locpos(gene),loctyp(gene),pedigree,actset,
     2                    num,nfound,id,fa,mo,sex,locus,numloc,
     3                    numal,name,fndr,alfrq,totall,typed)
                nfix=nfix+numal-2
              end if
              if (nfix .le. (MAXPAR-RANPAR)) then
                call regress(WRK,TWRK,-1,nord,locord,loc,loctyp,
     2                 locpos,gene,numal,name,x,r,b,cov,mval,
     3                 pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     4                 numloc,plevel)
                if (linkf.ne.1 .and. modtyp.eq.2) then
                  call binreg(WRK, TWRK, TWRK2, 1, nord, locord, loc, 
     2                   loctyp, locpos, off, censor, gene, numal, 
     3                   name, x, r, b, cov, pedigree, actset, num, 
     4                   nfound, id, fa, mo, sex, locus, numloc, 
     5                   shap, lrts, mdf, -1)
                else if ((linkf.eq.5 .and. modtyp.eq.3) .or. 
     &                   modtyp.eq.4) then
                  call binreg(WRK, TWRK, TWRK2, modtyp-1, nord, locord, 
     2                   loc, loctyp, locpos, off, censor, gene,
     3                   numal, name, x, r, b, cov, pedigree, actset,
     4                   num, nfound, id, fa, mo, sex, locus, numloc,
     5                   shap, lrts, mdf, -1)
                end if
                call preseg(modtyp, nord, locord, loc, gene, numal,
     &                      name, b, r, parnam, paract, par, parscal)
              end if
            end if
            if (nfix .le. (MAXPAR-RANPAR)) then
              whlik=3-whlik
              call segsim(WRK,TWRK,TWRK2, wrk2fil, linkf, 
     2               modtyp, shap, trait, gt, thresh, off, censor, nfix,
     3               nord, locord, gene, numal, name, loc, loctyp,
     4               locpos, burnin, iter, nbatch, tune, nchain, nqtl,
     5               parnam, par, paract, parscal, mval, pedigree,
     6               num, nfound, id, fa, mo, sex, locus, numloc,
     7               set, hset, ord, cumfrq, ibdcount, mlik(whlik),
     8               mpar(whlik), priran, mcalg, plevel)
            else
              write(*,'(a)') 'ERROR: Too many covariates specified.'
            end if
          else
            write(*,'(a)') 'ERROR: Need to specify trait.'
          end if
C Test relative pair relatedness using mean IBS sharing 
        elseif (keyword.eq.'sha'.and.red) then
          typ=1
          if (keyw2.eq.'typ') typ=2
          open(WRK2,file=wrk2fil,form='unformatted')
          do 352 i=1,nloci
          if (loctyp(i).eq.1) then
            call freq(WRK,locpos(i), loctyp(i),pedigree,actset,
     2                num,nfound,id,fa,mo,sex,locus,numloc,
     3                numal,name,fndr,alfrq,totall,typed)
            call accum(numal,alfrq,cumfrq)
            write(WRK2) numal,(cumfrq(j),j=1,numal)
          end if
  352     continue
          call allibs(WRK,WRK2,iter,nloci,loc,loctyp,locpos,
     2           map,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     3           numloc,hset,ibdcount,count2,numal,cumfrq,typ,plevel)
          close(WRK2,status='delete')
C Test sib pair relatedness using mean IBS sharing 
        elseif (keyword.eq.'cki'.and.red) then
          open(WRK2,file=wrk2fil,form='unformatted')
          do 351 i=1,nloci
          if (loctyp(i).eq.1 .and. irupt.eq.0) then
            call freq(WRK,locpos(i), loctyp(i),pedigree,actset,
     2                num,nfound,id,fa,mo,sex,locus,numloc,
     3                numal,name,fndr,alfrq,totall,typed)
            call wrfreq(WRK2,loc(i),numal,name,alfrq,map(i),
     &                  totall, typed,nobs,3)
          end if
  351     continue
          call ckibs(WRK,WRK2,pedigree,actset,num, nfound, id,fa,mo,sex,
     &               locus,numloc,nloci,loctyp,locpos,numal,name,alfrq)
          close(WRK2,status='delete')
        elseif (keyword.eq.'mzt' .and. red) then
          call gettrait(words(2),3,4,nloci,loc,loctyp,trait)
          gt=0
          typ=1
          thresh=MISS
C while not end of list of keywords
          i=3
  444     if (i.gt.narg) goto 445
            keyword=words(i)(1:3)
            if (iscomp(keyword)) then
              call docomp(i, words, gt, thresh)
            elseif (keyword.eq.'dro' .or. keyword.eq.'del') then
              typ=2
              i=i+1
            elseif (keyword.eq.'cle') then
              typ=3
              i=i+1
            else
              write(*,'(3a)') 'Skipping unknown keyword "',
     &          words(i)(1:eow(words(i))),'".'
              i=i+1
            end if  
            goto 444
  445     continue
          if (trait.ne.MISS) then
            if (typ.eq.1) then
              call mzgtp(WRK,locpos(trait),gt,thresh, pedigree,
     2                   actset,num,nfound,id,fa,mo,sex,locus,numloc,
     3                   nloci,loc,loctyp, locpos)
            else
              call newnam(wrknum, wrkfil)
              open(TWRK,file=wrkfil,form='unformatted')
              call dropt2(WRK,TWRK,locpos(trait),gt,thresh,typ,pedigree,
     2                    actset,num,nfound,id,fa,mo,sex,locus,
     3                    numloc,nloci,loc,loctyp,locpos,plevel)
              close(WRK,status='delete')
              close(TWRK,status='keep')
              open(WRK,file=wrkfil,form='unformatted')
            end if
          else
            write(*,'(a)') 'ERROR: Need to specify zygosity indicator.'
          end if
C Test mixture of distributions for quantitative trait
        elseif ((keyword.eq.'mix'.or. keyword.eq.'his').and.red) then
          call gettrait(words(2),3,0,nloci,loc,loctyp,trait)
          if (trait.ne.MISS) then
            nmix=ival(words(3))
            if (keyword.eq.'his') then
              nmix=1
            elseif (nmix.lt.1 .or. nmix.gt.5) then
              nmix=2
            end if
            if (words(4)(1:3).eq.'nor') then
              typ=1
            elseif (words(4)(1:3).eq.'poo') then
              typ=2
            elseif (words(4)(1:3).eq.'exp') then
              typ=3
            elseif (words(4)(1:3).eq.'poi') then
              typ=4
            else
              typ=ival(words(4))
            end if
            if (typ.lt.1 .or. typ.gt.4) typ=1
            call domix(WRK,loc(trait),locpos(trait),nmix,typ,
     2             pedigree,actset,num,nfound,
     3             id,fa,mo,sex,locus,numloc,value,ord,plevel)
          else
            write(*,'(a)') 'ERROR: Need to specify quantitative trait.'
          end if
C Means and correlations for traits
        elseif ((keyword.eq.'mea' .or. keyword.eq.'cor') .and. red) then
          call loadnam(2,narg,words,nloci,loc,loctyp,ord,nord,locord,1)
          call docov(WRK,nord,locord,loc,loctyp,locpos,
     2             x,b,cov,pedigree,actset,num,nfound,id,fa,mo,sex,
     3             locus,numloc,plevel)
C Multiple linear or logistic regression of trait
        elseif ((keyword.eq.'reg' .or. keyword.eq.'imp' .or. 
     2           keyword.eq.'pre' .or. keyword.eq.'res') .and.
     3           narg.gt.3 .and. red) then
          nf=narg
          censor=MISS
          off=MISS
          typ=0
          if (keyword.eq.'res') then
            typ=1
          elseif (keyword.eq.'imp') then
            typ=2
          elseif (keyword.eq.'pre') then
            typ=3
          end if
C any flags at end of line
          if (words(nf).eq.'complete') then
            typ=typ+10
            nf=nf-1
          end if
          if (words(nf).eq.'poisson') then
            typ=5
            nf=nf-1
          else if (words(nf-1).eq.'exponential') then
            typ=7
            call gettrait(words(nf),4,0,nloci,loc,loctyp,censor)
            nf=nf-2
          else if (words(nf).eq.'exponential') then
            typ=7
            nf=nf-1
          else if (words(nf-1).eq.'weibull') then
            typ=6
            call gettrait(words(nf),4,0,nloci,loc,loctyp,censor)
            nf=nf-2
          else if (words(nf).eq.'weibull') then
            typ=6
            nf=nf-1
          end if
          if (words(nf-1).eq.'offset') then
            call gettrait(words(nf),3,0,nloci,loc,loctyp,off)
            nf=nf-2
          end if
C first read the x variables
          call loadnam(4,nf,words,nloci,loc,loctyp,ord,nord,locord,1)
C then read the y variable which is added onto the end of the list
          call gettrait(words(2),3,4,nloci,loc,loctyp,trait)
          if (trait.ne.MISS) then
C mark first marker for full allelic encoding
            gene=findml(nord,locord,loctyp)
            if (gene.ne.MISS) then
              call freq(WRK,locpos(gene),loctyp(gene),pedigree,actset,
     2                  num,nfound,id,fa,mo,sex,locus,numloc,
     3                  numal,name,fndr,alfrq,totall,typed)
            end if
            if (loctyp(trait).eq.4) typ=4
            nord=nord+1
            locord(nord)=trait
            if (typ.eq.0) then
              call regress(WRK,TWRK,typ,nord,locord,loc,loctyp,locpos,
     2               gene,numal,name,x,r,b,cov,mval,pedigree,actset,
     3               num,nfound,id,fa,mo,sex,locus,numloc,plevel)
            else if (typ.ge.4 .and. typ.le.7) then
              typ=typ-3
              whlik=3-whlik
              call binreg(WRK, TWRK, TWRK2, typ, nord, locord, loc, 
     2               loctyp, locpos, off, censor, gene, numal, name,
     3               x, r, b, cov, pedigree, actset, num, nfound,
     4               id, fa, mo, sex, locus, numloc, shap, mlik(whlik),
     5               mpar(whlik), plevel)
            else
              call newnam(wrknum, wrkfil)
              open(TWRK,file=wrkfil,form='unformatted')
              call regress(WRK,TWRK,typ,nord,locord,loc,loctyp,locpos,
     2               gene,numal,name,x,r,b,cov,mval,pedigree,actset,
     3               num,nfound,id,fa,mo,sex,locus,numloc,plevel)
              close(WRK,status='delete')
              close(TWRK,status='keep')
              open(WRK,file=wrkfil,form='unformatted')
            end if
          else
            write(*,'(a)') 
     &        'ERROR: Need to specify regression y and x variables.'
          end if
C cross-tabulation
        elseif ((keyword.eq.'tab' .or. keyword.eq.'kru') .and. red) then
          typ=1
          if (keyword.eq.'kru' .and. narg.eq.3) then
            call gettrait(words(2),3,0,nloci,loc,loctyp,trait)
            call gettrait(words(3),10,0,nloci,loc,loctyp,gene)
            if (trait.ne.MISS .and. gene.ne.MISS) then
              typ=2
              nmark=2
              ord(1)=gene 
              ord(2)=trait
              call xtab(WRK,typ,nmark,ord,loc,locpos,loctyp,
     2                  pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     3                  numloc,value,vset,key1,key2,iter,ord,plevel)
            end if
          elseif (narg.gt.1) then
            call loadnam(2,narg,words,nloci,loc,loctyp,ord,
     &                   nord,locord,1)
            call xtab(WRK,typ,nord,locord,loc,locpos,loctyp,
     2                pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     3                numloc,value,vset,key1,key2,iter,ord,plevel)
          else
            nmark=1
            write(*,*)
            do 129 i=1,nloci
            if (loctyp(i).lt.5) then
              ord(1)=i 
              call xtab(WRK,typ,nmark,ord,loc,locpos,loctyp,
     2                pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     3                numloc,value,vset,key1,key2,iter,ord,plevel)
            end if
  129       continue
          end if
C APM analyses - IBD or IBS based
        elseif (keyword.eq.'apm'.and.red) then
          call getbin(2,narg,words,nloci,loc,loctyp,trait,gt,thresh)
          if (trait.ne.MISS .and. iter.gt.0) then
            typ=1
            if (words(3).eq.'ibd' .or.words(5).eq.'ibd') typ=2
            write(*,'(/a/a,a10,a/a/)')
     2      '------------------------------------------------',
     3      'APM for trait "',
     4      loc(trait)(1:eow(loc(trait))),'" v. all markers',
     5      '------------------------------------------------'
            if (typ.eq.2) then
              write(*,'(a/)') 
     &          'NOTE:  Identity-by-descent based statistic used.'
            end if
            if (thresh.ne.MISS) call defpro(gt, thresh)
            if (plevel.lt.1) then
              write(*,'(/a/a)')
     2        'Marker     NFams  NAff   Z-value    Asy P  Emp P  Iters',
     3        '---------- ------ ------ ---------- ------ ------ ------'
            end if
            do 45 i=1,nloci
            if (loctyp(i).eq.1 .and. irupt.eq.0) then
              call freq(WRK,locpos(i), loctyp(i),pedigree,actset,
     2                  num,nfound,id,fa,mo,sex,locus,numloc,
     3                  numal,name,fndr,alfrq,totall,typed)
              call accum(numal,alfrq,cumfrq)
              call doapm(WRK,locpos(trait),loc(i),locpos(i),typ,iter,
     2               burnin,gt,thresh,pedigree,actset,num,nfound,id,
     3               fa,mo,sex,locus,numloc,numal,name,alfrq,cumfrq,
     4               gfrq,set,set2,sibd,key,untyped,plevel)
            end if
   45       continue
          else
            write(*,'(a)') 'ERROR: Need to specify trait and iter>0.'
          end if
C ASP analyses
        elseif (keyword.eq.'asp'.and.red) then
          call getbin(2,narg,words,nloci,loc,loctyp,trait,gt,thresh)
          if (trait.ne.MISS) then
            write(*,'(/a/3a/a/)')
     2      '------------------------------------------------',
     3      'IBS ASP for "', 
     4      loc(trait)(1:eow(loc(trait))),'" v. all marker loci',
     4      '------------------------------------------------'
            if (thresh.ne.MISS) call defpro(gt, thresh)
            if (plevel.lt.1) then
              write(*,'(a/a)')
     2        'Marker     NPairs mIBS   ExpIBS Asy P  mIBD   Asy P',
     3        '---------- ------ ------ ------ ------ ------ ------'
            end if
            do 230 i=1,nloci
            if (loctyp(i).eq.1 .and. irupt.eq.0) then
              call freq(WRK,locpos(i), loctyp(i),pedigree,actset,
     2                  num,nfound,id,fa,mo,sex,locus,numloc,
     3                  numal,name,fndr,alfrq,totall,typed)
              call doasp(WRK,locpos(trait),loc(i),locpos(i),gt,thresh,
     2                   pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     3                   numloc,numal,name,alfrq,ibdcount,untyped,set,
     4                   plevel)
            end if
 230        continue
          else
            write(*,'(a)') 'ERROR: Need to specify trait.'
          end if
C H-E sib-pair linkage analysis
        elseif ((keyword.eq.'sib' .or. keyword.eq.'he1' 
     2          .or. keyword.eq.'he2' .or. keyword.eq.'vis') .and. red)
     3  then
          call gettrait(words(2),3,4,nloci,loc,loctyp,trait)
          if (trait.ne.MISS) then
            typ=3
            words(1)='Sham S+D'
            if (keyword.eq.'he1') then
              typ=1
              words(1)='Standard'
            elseif (keyword.eq.'he2') then
              typ=2
              words(1)='CP-based'
            elseif (keyword.eq.'vis') then
              typ=4
              words(1)='V&H S+D '
            end if
            gene=MISS
            sibm=MISS
            sibr=MISS
            sibv=MISS
            weight=MISS
            mche=.false.
            i=3
  433       continue
              if (words(i).eq.'sim') then
                mche=.true.
              elseif (words(i).eq.'var') then
                i=i+1
                sibv=fval(words(i))
              elseif (words(i).eq.'sd') then
                i=i+1
                sibv=fval(words(i))**2
              elseif (words(i).eq.'mea') then
                i=i+1
                sibm=fval(words(i))
              elseif (words(i).eq.'cor') then
                i=i+1
                sibr=fval(words(i))
              else
                call gettrait(words(i),3,0,nloci,loc,loctyp,gene)
                if (gene.ne.MISS) weight=locpos(gene)
              end if
              i=i+1
            if (i.le.narg) goto 433

            write(*,'(/a/a8,3a/a)')
     2 '---------------------------------------------------------',
     3 words(1),' H-E for trait "',
     4 loc(trait)(1:eow(loc(trait))),'" v. all markers',
     5 '---------------------------------------------------------'
            if (gene.ne.MISS) then
              write(*,'(3a,2(/7x,a))') 
     2          'NOTE:  Each pair contribution weighted by mean of "',
     3          loc(gene)(1:eow(loc(gene))),'"',
     4          'for each member. Weight is taken as proportional to',
     5          'the variance for that contribution (WLS).'
            end if
            if (sibr.ne.MISS) then
              write(*,'(a,f5.3)') 
     &          'NOTE:  Using trait sibling correlation provided: ',sibr
            end if
            if (sibm.ne.MISS) then
              write(*,'(a,f10.4,a,f10.4,a)') 
     2          'NOTE:  Using trait mean (SD) provided: ',
     3           sibm,' (',sqrt(sibv),')'
            end if
            if (plevel.lt.1) then
              write(*,'(/a/a)')
     2      'Marker     FSibs  HSibs  t-value    Asy P  Emp P  Iters',
     3      '---------- ------ ------ ---------- ------ ------ ------'
            end if
            do 30 i=1,nloci
            if (loctyp(i).eq.1 .and. irupt.eq.0) then
              call freq(WRK,locpos(i), loctyp(i),pedigree,actset,
     2                  num,nfound,id,fa,mo,sex,locus,numloc,
     3                  numal,name,fndr,alfrq,totall,typed)
              call accum(numal,alfrq,cumfrq)
              open(WRK2,file=wrk2fil,form='unformatted')
              call sibpair(WRK,WRK2,loc(trait),locpos(trait),
     2               loc(i),locpos(i),typ,sibm,sibr,sibv,
     3               mche,iter,mincnt,weight,pedigree,actset,num,nfound,
     4               id,fa,mo,sex,locus,numloc,numal,name,alfrq,cumfrq,
     5               ibdcount,untyped,set,plevel)
              close(WRK2,status='delete')
            end if
  30        continue
          else
            write(*,'(a)') 'ERROR: Need to specify trait.'
          end if
C VC QTL linkage analysis
        elseif (keyword.eq.'qtl'.and.red) then
          call gettrait(words(2),3,4,nloci,loc,loctyp,trait)
          if (trait.ne.MISS) then
            write(*,'(/a/3a/a)')
     2 '---------------------------------------------------------',
     3 'VC linkage analysis for trait "', 
     4 loc(trait)(1:eow(loc(trait))),'" v. all markers',
     5 '---------------------------------------------------------'
            gene=MISS
            typ=1
            nord=0
            i=3
  541       if (i.gt.narg) goto 542
              keyword=words(i)(1:3)
              if (keyword.eq.'ful') then 
                typ=5
                i=i+1
              else if (keyword.eq.'cqe') then
                typ=7
                i=i+1
              else if (keyword.eq.'cov' .and. i.lt.narg) then
                call loadnam(i+1,narg,words,nloci,loc,
     &                       loctyp,ord,nord,locord,1)
                gene=findml(nord,locord,loctyp)
                i=narg+1
              else
                write(*,'(3a)') 'Skipping unknown keyword "',
     &            words(i)(1:eow(words(i))),'".'
                i=i+1
              end if  
              goto 541
  542       continue
            nord=nord+1
            locord(nord)=trait
            if (typ.eq.1) then
              if (plevel.lt.1) then
                write(*,'(/a/a)')
     2        'Marker     FSibs  HSibs  lod score  Asy P  Emp P  Iters',
     3        '---------- ------ ------ ---------- ------ ------ ------'
              end if
              do 130 i=1,nloci
              if (loctyp(i).eq.1 .and. irupt.eq.0) then
                call freq(WRK,locpos(i),loctyp(i),pedigree,actset,
     2                    num,nfound,id,fa,mo,sex,locus,numloc,
     3                    numal,name,fndr,alfrq,totall,typed)
                open(WRK2,file=wrk2fil,form='unformatted')
                call sibqtl(WRK,WRK2,loc(trait),locpos(trait),
     2                 loc(i),locpos(i),pedigree,actset,num,nfound,
     3                 id,fa,mo,sex,locus,numloc,numal,name,alfrq, 
     4                 untyped,set,ibdcount,count2,plevel,toler)
                close(WRK2,status='delete')
              end if
 130          continue
            else
              if (plevel.lt.1) then
                write(*,'(/a/a)')
     2        'Marker     NFams  NPheno lod score  Asy P  Emp P  Iters',
     3        '---------- ------ ------ ---------- ------ ------ ------'
              end if
C evaluate IBD at ith marker 
              do 131 i=1,nloci
              if (loctyp(i).eq.1 .and. irupt.eq.0) then
                call freq(WRK,locpos(i),loctyp(i),pedigree,actset,
     2                  num,nfound,id,fa,mo,sex, locus,numloc,
     3                  numal,name,fndr,alfrq,totall,typed)
                if (typed.gt.0) then
                  open(TWRK,file='ibdfil.tmp')
                  call wribd(WRK,TWRK,locpos(i),iter,burnin,typ,
     2                    pedigree,actset,num,nfound,id,fa,mo,sex,
     3                    locus, numloc,numal,name,alfrq,gfrq,untyped,
     4                    set,set2,sibd,key,ibdcount,plevel)
C enumerate levels for any covariate marker
                  if (gene .ne. MISS) then
                    call freq(WRK,locpos(gene),loctyp(gene),pedigree,
     2                     actset,num,nfound,id,fa,mo,sex,locus,numloc,
     3                     numal,name,fndr,alfrq,totall,typed)
                  end if
C calculate fixed effects starting values running regress() silently
                  if (nord.gt.1) then
                    call regress(WRK,TWRK,-1,nord,locord,loc,loctyp,
     2                     locpos,gene,numal,name,x,r,b,cov,mval,
     3                     pedigree,actset,num,nfound,id,fa,mo,sex,
     4                     locus,numloc,plevel)
                    do 534 j=1, min(MAXALL, MAXTER)
                      alfrq(j)=b(j)
  534               continue
                  end if
                  whlik=3-whlik
                  open(WRK2,file=wrk2fil,form='unformatted')
                  call varcom(WRK,WRK2,TWRK,nord,locord,loc,loctyp,
     2                    locpos, loc(i), gene, numal, name, alfrq, 
     3                    mval, pedigree, actset, num, nfound, id, 
     4                    fa, mo, sex, locus, numloc, untyped, ibdcount,
     5                    count2, mlik(whlik), mpar(whlik), 
     6                    plevel, typ, toler)
                  close(WRK2,status='delete')
                  close(TWRK,status='delete')
                end if
              end if
 131          continue
            end if
          else
            write(*,'(a)') 'ERROR: Need to specify trait.'
          end if
C sib-pair linkage between markers after Elston
        elseif (keyword.eq.'lin'.and.red) then
          write(*,'(/a/a/a//a/a)')
     2 '---------------------------------------------------',
     3 'Inter-marker sib pair linkage analysis',
     4 '---------------------------------------------------',
     5 'Marker 1   Marker 2   Sibships Sibpairs  r(IBD) Recomb',
     6 '---------- ---------- -------- --------  ------ -------'
          call gettrait(words(2),1,0,nloci,loc,loctyp,trait)
          call gettrait(words(3),1,0,nloci,loc,loctyp,gene)
          if (trait.ne.MISS) then
            call freq(WRK,locpos(trait), loctyp(trait),pedigree,actset,
     2             num,nfound,id,fa,mo,sex,locus,numloc,
     3             numal,name,fndr,alfrq,totall,typed)
            if (gene.ne.MISS) then
              call freq(WRK,locpos(gene), loctyp(gene),pedigree,actset,
     2             num,nfound,id,fa,mo,sex,locus,numloc,
     3             numal2,name2,fndr,alfrq2,totall,typed)
              call twopoi(WRK,locpos(trait),loc(trait),numal,name,alfrq,
     2           locpos(gene), loc(gene), numal2, name2, alfrq2,
     3           pedigree,actset,num,nfound, id, fa, mo, sex, locus,
     4           numloc, ibdcount,count2,untyped,set,set2,plevel)
            else
              do 330 i=1,nloci
              if (loctyp(i).eq.1 .and. i.ne.trait .and. irupt.eq.0) then
                call freq(WRK,locpos(i), loctyp(i),pedigree,actset,
     2                 num,nfound,id,fa,mo,sex,locus,numloc,
     3                 numal2,name2,fndr,alfrq2,totall,typed)
                call twopoi(WRK,locpos(trait),loc(trait),numal,name,
     2                 alfrq,locpos(i), loc(i), numal2, name2, alfrq2,
     3                 pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     4                 numloc, ibdcount,count2,untyped,set,set2,plevel)
              end if
 330          continue
            end if
          else
            do 331 i=1,nloci
            if (loctyp(i).eq.1 .and. irupt.eq.0) then
              if (trait.ne.MISS) then
                call freq(WRK,locpos(trait),loctyp(trait),pedigree,
     2             actset,num,nfound,id,fa,mo,sex,locus,numloc,
     3             numal,name,fndr,alfrq,totall,typed)
                call freq(WRK,locpos(i), loctyp(i),pedigree,actset,
     2                    num,nfound,id,fa,mo,sex,locus,numloc,
     3                    numal2,name2,fndr,alfrq2,totall,typed)
                call twopoi(WRK,locpos(trait),loc(trait),numal,name,
     2               alfrq,locpos(i), loc(i), numal2, name2, alfrq2,
     3               pedigree,actset,num,nfound, id, fa, mo, sex, locus,
     4               numloc, ibdcount,count2,untyped,set,set2,plevel)
              end if
              trait=i
            end if
 331        continue
          end if
C Interval H-E
        elseif (keyword.eq.'two'.and.red) then
          trait=MISS
          nmark=0
          do 27 i=1,nloci
          do 27 j=2,narg
          if (words(j).eq.loc(i)) then
             if (loctyp(i).eq.3 .or. loctyp(i).eq.4) then
               trait=i
             elseif (loctyp(i).eq.1 .and. nmark.lt.2) then
               nmark=nmark+1
               twomark(nmark)=i
             end if
          end if
          th12=fval(words(5))
   27     continue
          if (trait.ne.MISS .and. nmark.eq.2) then

          write(*,'(/a/a,a10,a,a10,a,a10,a/a/)')
     2   '------------------------------------------------------------',
     3   '2-point trait "',loc(trait)(1:eow(loc(trait))),'" v. loci "',
     4   loc(twomark(1))(1:eow(loc(twomark(1)))),
     5   '", "',loc(twomark(2))(1:eow(loc(twomark(2)))),'"',
     6   '------------------------------------------------------------'
          write(*,'(3a)') 'Theta12 Theta1 Theta2   N     Pi',
     2                    '      Intcpt      Slope      t-value',
     3                    '  P-value'
          call freq(WRK,locpos(twomark(1)),loctyp(twomark(1)),pedigree,
     2              actset,num,nfound,id,fa,mo,sex,locus,numloc,
     3              numal,name,fndr,alfrq,totall,typed)
          call freq(WRK,locpos(twomark(2)),loctyp(twomark(2)),pedigree,
     2              actset,num,nfound,id,fa,mo,sex,locus,numloc,
     3              numal2,name2,fndr,alfrq2,totall,typed)
C
C No interference 
          do 35 i=0,5
            th1=0.2d0*th12*dfloat(i)
            th2=th12-th1+2*th1*th12
                    call twopair(WRK,locpos(trait),locpos(twomark(1)),
     2                   locpos(twomark(2)),th1, th2, th12,
     3                   pedigree,actset,num,nfound,id,fa,mo,sex,locus, 
     4                   numloc, numal,name,alfrq,numal2,name2,alfrq2)
   35     continue

          else
            write(*,'(a)') 'ERROR: Need to specify trait and markers.'
          end if
C
C List individuals and matings with largest number of affected 
C descendants for each pedigree
C
        elseif (keyword.eq.'anc'.and.red) then
          call getbin(2,narg,words,nloci,loc,loctyp,trait,gt,thresh)
          if (trait.ne.MISS) then
            call ancest(WRK,loc(trait),locpos(trait),gt,thresh,pedigree,
     2             actset,num,nfound,id,fa,mo,sex,locus,numloc,ord,
     3             ibdcount, plevel)
          else
            write(*,'(a)') 'ERROR: Need to specify trait.'
          end if 
C kinship and inbreeding coefficients
        elseif (keyword.eq.'kin'.and.red) then
          typ=1
          if (keyw2.eq.'pai') then
            typ=2
          else if (keyw2.eq.'inb') then
            typ=3
          else if (narg.gt.1) then
            call getbin(2,narg,words,nloci,loc,loctyp,trait,gt,thresh)
            if (trait.ne.MISS) then
              typ=4
            else
              write(*,'(3a)') 'ERROR: Did not recognize ',
     &                        words(2)(1:eow(words(2))), '.'
            end if
          end if
          if (typ.ne.4) then
            call dokin(WRK,typ,pedigree,actset,num,nfound,id,fa,mo,sex,
     &             locus,numloc,ibdcount)
          else
            call casekin(WRK,loc(trait),locpos(trait),gt,thresh,
     2             pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     3             numloc,ord,ibdcount, plevel)
          end if
C IBD matrices
        elseif ((keyword.eq.'ibd'.or.keyword.eq.'ibs').and.red) then
          call gettrait(words(2),1,0,nloci,loc,loctyp,gene)
          typ=1
          if (keyword.eq.'ibs') typ=typ+2
          if (words(3)(1:3).eq.'pai') typ=typ+1
          if (gene.ne.MISS .and. iter.gt.0) then
            write(*,'(/a/5a/a)')
     2       '------------------------------------------------',
     3       'Estimated ',keyword,' sharing at locus "',
     4       loc(gene)(1:eow(loc(trait))),'"',
     5       '------------------------------------------------' 
            if (mod(typ,2).eq.0) then
              write(*,'(a//a/)') 
     2          'NOTE:  Writing one relative pair per record',
     3          'Pedigree   Person-1 Person-2   ibd'
            end if
            call freq(WRK,locpos(gene),loctyp(gene),pedigree,actset,
     2                num,nfound,id,fa,mo,sex, locus,numloc,
     3                numal,name,fndr,alfrq,totall,typed)
            if (typed.gt.0) then
              call wribd(WRK,TWRK,locpos(gene),iter,burnin,typ,
     2                   pedigree,actset,num,nfound,id,fa,mo,sex,locus, 
     3                   numloc,numal,name,alfrq,gfrq,untyped,
     4                   set,set2,sibd,key,ibdcount,plevel)
            else
              write(*,'(a)') 'No genotyped individuals.'
            end if
          else
            write(*,'(a)') 'ERROR: Need to specify marker.'
          end if
        elseif ((keyword.eq.'hbd').and.red) then
          call gettrait(words(2),1,0,nloci,loc,loctyp,gene)
          call gettrait(words(3),3,0,nloci,loc,loctyp,trait)
          if (gene.ne.MISS .and. iter.gt.0) then
            write(*,'(/a/3a/a)')
     2       '-------------------------------------------------------',
     3       'Estimated homozygosity-by-descent at locus "',
     4       loc(gene)(1:eow(loc(gene))),'"',
     5       '-------------------------------------------------------' 
            if (trait.ne.MISS) then
              write(*,'(3a)') 'Writing HBD to "',
     &          loc(trait)(1:eow(loc(trait))),'"' 
              trait=locpos(trait)
            end if
            call freq(WRK,locpos(gene),loctyp(gene),pedigree,actset,
     2                num,nfound,id,fa,mo,sex, locus,numloc,
     3                numal,name,fndr,alfrq,totall,typed)
            if (typed.gt.0) then
              if (trait.ne.MISS) then
                call newnam(wrknum, wrkfil)
                open(TWRK,file=wrkfil,form='unformatted')
              end if
              call wrhbd(WRK,TWRK,locpos(gene),trait,iter,burnin,
     2                   pedigree,actset,num,nfound,id,fa,mo,sex,locus, 
     3                   numloc,numal,name,alfrq,gfrq,untyped,
     4                   set,set2,sibd,key,ibdcount,plevel)
              if (trait.ne.MISS) then
                close(WRK,status='delete')
                close(TWRK,status='keep')
                open(WRK,file=wrkfil,form='unformatted')
              end if
            else
              write(*,'(a)') 'No genotyped individuals.'
            end if
          else
            write(*,'(a)') 'ERROR: Need to specify marker.'
          end if
C
C write out locus file
        elseif (keyword.eq.'wri'.and. keyw2.eq.'loc') then
          call args(lin,narg,bigwor,1)
          if (bigwor(3).eq.'gas') then
            outfil=bigwor(4)
            open(OSTR,file=outfil,err=9999)
            write(*,'(/2a)') 
     &        'Writing GAS type locus file: ',outfil
            do 60 i=1,nloci
            if (loctyp(i).eq.1) then
              call freq(WRK,locpos(i),loctyp(i),pedigree,actset,
     2                  num,nfound,id,fa,mo,sex,locus,numloc,
     3                  numal,name,fndr,alfrq,totall,typed)
              write(OSTR,'(1x,3a)') 'set locus ',loc(i),' named'
              call wrfreq(OSTR,loc(i),numal,name,alfrq,map(i),
     &                    totall, typed,nobs,4)
              write(OSTR,'(a2)') ' ;'
            else if (loctyp(i).eq.3) then
              write(OSTR,'(1x,3a/1x,a/1x,a)') 
     2          'set locus ',loc(i),' quantitative',
     3          '2 eqfreq', 'nostat ;'
            else if (loctyp(i).eq.4) then
              write(OSTR,'(1x,3a/1x,a/1x,a/1x,a)') 
     2          'set locus ',loc(i),' affection',
     3          '2 eqfreq','1', '0.1 0.1 0.1 ;'
            end if
   60       continue
          elseif (bigwor(3)(1:3).eq.'sib') then
            outfil=bigwor(4)
            if (narg.eq.4) bigwor(5)=pedfil
            open(OSTR,file=outfil,err=9999)
            write(*,'(/2a)') 
     &        'Writing Sib-pair type script: ',outfil
            do 61 i=1,nloci
            if (loctyp(i).le.2) then
              if (map(i).ne.MISS) then
                write(OSTR,'(3(a,1x),f8.2)') 
     &            'set locus',loc(i),typloc(loctyp(i)), map(i)
              else
                write(OSTR,'(3(a,1x))') 
     &            'set locus ',loc(i),typloc(loctyp(i))
              end if
            else if (loctyp(i).eq.3) then
              write(OSTR,'(a,1x,a,1x,a)') 'set locus',loc(i),typloc(3)
            else if (loctyp(i).eq.4) then
              write(OSTR,'(a,1x,a,1x,a)') 'set locus',loc(i),typloc(4)
            end if
   61       continue
            write(OSTR,'(2a/a)') 'read pedigree ',bigwor(5),'run'
          elseif (bigwor(3)(1:3).eq.'mer') then
            outfil=bigwor(4)
            open(OSTR,file=outfil,err=9999)
            write(*,'(/2a)') 
     &        'Writing MERLIN locus file: ',outfil
            do 62 i=1,nloci
            if (loctyp(i).le.2) then
              write(OSTR,'(2a)') 'M ',loc(i)
            else if (loctyp(i).eq.3) then
              write(OSTR,'(2a)') 'T ',loc(i)
            else if (loctyp(i).eq.4) then
              write(OSTR,'(2a)') 'A ',loc(i)
            end if
   62       continue
          elseif (bigwor(3)(1:3).eq.'lin' .or. bigwor(3)(1:2).eq.'gh') 
     &    then
            outfil=bigwor(4)
            typ=0
            if (bigwor(5)(1:3).eq.'dum') then
              typ=1
            end if
            if (bigwor(3)(1:2).eq.'gh') then
              typ=3-typ
            elseif (bigwor(5)(1:2).eq.'gh') then
              typ=2
              if (bigwor(6)(1:2).eq.'no') typ=3
            end if
            xlin=0
            if (bigwor(5)(1:3).eq.'xli') xlin=1
            call lorder(typ,nloci,loctyp,nord,locord)
            open(OSTR,file=outfil,err=9999)
            write(*,'(/2a)') 
     &        'Writing LINKAGE type locus file: ',outfil
            call cntmark(nloci,loctyp,nmark,5)
            if (typ.eq.1 .or. typ.eq.2) nmark=nmark+1

            write(OSTR,'(i5,4i3/a)') nmark,0,xlin,5,0,'0 0.0 0.0 0'
            write(OSTR,*) (i,i=1,nmark)
            if (typ.eq.1 .or. typ.eq.2) then
              write(*,'(a)') 'First locus is a dummy binary trait.'
              write(OSTR,'(i1,1x,i5,a/2(f8.6,1x)/i5/3(f8.6,1x))') 
     2          1, 2, ' # Dummy #', 0.5, 0.5, 1, 0.5, 0.5, 0.5
              if (xlin.eq.1) then
                write(OSTR,'(2(f8.6,1x))') 0.0, 0.0
              end if
            end if
            do 65 k=1,nord 
            i=locord(k)
            if (loctyp(i).le.2) then
              call freq(WRK,locpos(i), loctyp(i),pedigree,actset,
     2                  num,nfound,id,fa,mo,sex,locus,numloc,
     3                  numal,name,fndr,alfrq,totall,typed)
              call wrfreq(OSTR,loc(i),numal,name,alfrq,map(i),
     &                    totall, typed,nobs,8)
            else if (loctyp(i).eq.3) then
              write(OSTR,
     2        '(i1,1x,i5,3a/2(f8.6,1x)/f8.6/3(f8.6,1x)/f8.6/f8.6)')
     3          0, 2, ' # ',loc(i), ' #', 0.1, 0.9, 1.0, 
     4          1.0, 1.0, 1.0, 1.0, 1.0
            else if (loctyp(i).eq.4) then
              write(OSTR,'(i1,1x,i5,3a/2(f8.6,1x)/i5/3(f8.6,1x))') 
     2          1, 2, ' # ',loc(i), ' #',0.99, 0.01, 1, 0.05, 0.5, 0.5
              if (xlin.eq.1) then
                write(OSTR,'(2(f8.6,1x))') 0.0, 0.0
              end if
            end if
   65       continue
            write(OSTR,'(a)') '0 0'
            call wrmap(OSTR,typ,mapf,nloci,loc,loctyp,locnotes,
     &                 nord,locord,map)
            write(OSTR,'(/a)') '1 0.1 0.4'
          elseif (bigwor(3)(1:3).eq.'mdf') then
            outfil=bigwor(4)
            open(OSTR,file=outfil,err=9999)
            write(*,'(/2a)') 
     &        'Writing Cyrillic type MDF file: ',outfil
            write(OSTR,'(a/a/i4)') 
     &        'Cyrillic MDF file','1', nloci  
            do 64 i=1,nloci
              if (loctyp(i).le.2) then
                write(OSTR,'(a)') loc(i),'Numbered alleles'
              else if (loctyp(i).eq.3) then
                write(OSTR,'(a)') loc(i),'Quantitative locus'
              else if (loctyp(i).eq.4) then
                write(OSTR,'(a/a/i2)') loc(i), 'Affection locus',2
              end if
   64       continue
            write(OSTR,'(a)') 'Keep symbols','Pedigree number first',
     &        'No DNA sample number'
          elseif (bigwor(3)(1:3).eq.'sag') then
            outfil=bigwor(4)
            open(OSTR,file=outfil,err=9999)
            write(*,'(/2a)') 
     &        'Writing SAGE type locus file: ',outfil
            do 70 i=1,nloci
            if (loctyp(i).eq.1) then
              call freq(WRK,locpos(i), loctyp(i),pedigree,actset,
     2               num,nfound,id,fa,mo,sex,locus,numloc,
     3               numal,name,fndr,alfrq,totall,typed)
              call wrfreq(OSTR,loc(i),numal,name,alfrq,map(i),
     &                    totall, typed,nobs,5)
            end if
   70       continue
          elseif (bigwor(3)(1:3).eq.'lok') then
            outfil=bigwor(4)
            lin=bigwor(5)
            if (narg.eq.4) lin=pedfil
            open(OSTR,file=outfil,err=9999)
            write(*,'(/2a)') 
     &        'Writing Loki prep type control file: ',outfil
            write(OSTR,'(3a/a/a/3a,$)') 
     2        '/* Loki type control file for ', lin(1:eow(lin)),
     3        ' */','/* Written by Sib-pair */', 'MISSING "x"', 
     4        'FILE "',lin(1:eow(lin)),
     5        '", fam, id, father, mother, sx'
            trait=1
            length=80
            do 72 i=1,nloci
              call addlet(loc(i), lin)
              j=eow(lin)
              if (loctyp(i).eq.1) then
                write(OSTR,'(5a,$)') 
     &            ', ',lin(1:j),'_A, ',lin(1:j),'_B' 
                length=length+2*j+8
              elseif (loctyp(i).eq.3 .or. loctyp(i).eq.4) then
                write(OSTR,'(2a,$)') ', ',lin(1:j)
                length=length+j+2
                if (loctyp(i).gt.2 .and. trait.eq.1) trait=i
              end if
              if (length.gt.67) then
                write(OSTR,'(/a,$)') '      '
                length=6
              end if
   72       continue
            write(OSTR,'(/a)') 'PEDIGREE fam, id, father, mother'
            write(OSTR,'(/a)') 'SEX sx "m","f"'
            do 73 i=1,nloci
            if (loctyp(i).eq.1) then
              call addlet(loc(i), lin)
              j=eow(lin)
              write(OSTR,'(7a)') 'MARKER LOCUS ',lin,
     &                   '[',lin(1:j),'_A, ',lin(1:j),'_B]'
            end if
   73       continue
            write(OSTR,'(/a,$)') 'LINK "chrom A"'
            length=15
            do 74 i=1,nloci
            if (loctyp(i).eq.1) then
              call addlet(loc(i), lin)
              j=eow(lin)
              write(OSTR,'(2a,$)') ', ',lin(1:j)
              length=length+j+3
              if (length.gt.70) then
                write(OSTR,'(/a,$)') '      '
                length=6
              end if
            end if
   74       continue
            write(OSTR,*)
            if (loctyp(trait).eq.4) then
              j=eow(loc(trait))
              write(OSTR,'(2a/3a)') 'DISCRETE ',loc(trait),
     &          'AFFECTED WHERE (',loc(trait)(1:j),'="y")'
            end if
            write(OSTR,'(a/3a)') 
     &        'TRAIT LOCUS qtl','MODEL ',loc(trait),'= qtl'
          elseif (bigwor(3).eq.'pap') then
            open(OSTR,file='header.dat')
            open(OSTR2,file='popln.dat')
            write(*,'(/a)') 
     &        'Writing PAP locus files: header.dat and popln.dat'
            gene=1
            gen2=0
            set(1,1)=1
            set(1,2)=0
            words(1)='Gender'
            do 71 i=1,nloci
            if (loctyp(i).le.2) then
              gene=gene+1
              gen2=gen2+1
              set(gene,1)=3
              if (loctyp(i).eq.2) set(gene,1)=4
              set(gene,2)=gen2
              words(gene)=loc(i)
              call freq(WRK,locpos(i), loctyp(i),pedigree,actset,
     2                  num,nfound,id,fa,mo,sex,locus,numloc,
     3                  numal,name,fndr,alfrq,totall,typed)
              call wrfreq(OSTR2,loc(i),numal,name,alfrq,map(i),
     &                    totall, typed,nobs,9)
            elseif (loctyp(i).eq.3) then
              gene=gene+1
              set(gene,1)=2
              set(gene,2)=0
              words(gene)=loc(i)
            elseif (loctyp(i).eq.4) then
              gene=gene+1
              gen2=gen2+1
              set(gene,1)=1
              set(gene,2)=0
              words(gene)=loc(i)
              write(OSTR2,'(2a/2i4,2f8.6)') 
     &          '   1     # ',loc(i),0,100,0.05,0.05
            end if
   71       continue
            if (gene.gt.39) then
              write(*,'(a)') 
     &        'ERROR: PAP phen.dat may have no more than 39 columns'
            elseif (gene.gt.0) then
              write(OSTR,'(2i4,9a8/(10a8):)') 
     &          gene,gene,(words(i),i=1,gene)
              write(OSTR,'(8x,18i4/(20i4):)') 
     &          (set(i,1),set(i,2),i=1,gene)
            end if
            write(OSTR2,*)
            close(OSTR2,status='keep')
          elseif (bigwor(3)(1:3).eq.'men') then
            outfil=bigwor(4)
            typ=4
            if (bigwor(5)(1:3).eq.'tra') typ=3
            open(OSTR,file=outfil,err=9999)
            write(*,'(/2a)') 
     &        'Writing MENDEL type locus file: ',outfil
            if (bigwor(5)(1:3).eq.'var') then
              do 76 i=1,nloci
              if (loctyp(i).eq.3) then
                write(OSTR,'(a8)') loc(i)
              end if
   76         continue
            else
              call lorder(typ,nloci,loctyp,nord,locord)
              do 75 k=1,nord 
                i=locord(k)
                if (loctyp(i).le.2) then
                  typ=7
                  if (loctyp(i).eq.2) typ=10
                  call freq(WRK,locpos(i), loctyp(i),pedigree,actset,
     2                   num,nfound,id,fa,mo, sex,locus,numloc,
     3                   numal,name,fndr,alfrq,totall,typed)
                  call wrfreq(OSTR,loc(i),numal,name,alfrq,map(i),
     &                        totall,typed,nobs,typ)
                elseif (loctyp(i).eq.4) then
                  if (bigwor(5)(1:3).eq.'tra') then
                    write(OSTR,'(2a8,2i2,i4,1x,f8.3,10(/a))') 
     2               loc(i),'AUTOSOME', 2, 2, 1, max(0.0,0.01*map(i)),
     3               '     0010.010000','     0020.990000',
     4               'AFFECTED 3','001/001','001/002','002/002',
     5               'NORMAL   3','001/001','001/002','002/002'
                  else
                    write(OSTR,'(2a8,2i2,2(/a))') 
     &               loc(i),'FACTOR  ', 2, 0, 'AFFECTED  ','NORMAL    '
                  end if
                end if
   75         continue
            end if
          elseif (bigwor(3)(1:3).eq.'asp' .or. bigwor(3)(1:3).eq.'tcl')
     &    then
            outfil=bigwor(4)
            open(OSTR,file=outfil,err=9999)
            call cntmark(nloci,loctyp,nmark,1)
            write(*,'(/2a)') 
     &        'Writing ASPEX type (tcl) locus file: ',outfil
            if (bigwor(5)(1:3).eq.'dis') then 
              write(*,'(a)') 'Using discordant sib pairs.'
              write(OSTR,'(a)') 'set count_discordant true'
            end if
            write(OSTR,'(2(a/),a,i3,6(/a),$)')
     2    'set has_disease_data true', 'set linkage_format true',
     4    'set nloc ',nmark, 'set blank "0"', 
     5    'set discard_partial true','set truncate_sharing false',
     6    'set most_likely true', 'set show_pairs false', 'set loc {' 
            length=0
            do 85 i=1,nloci
            if (loctyp(i).le.2) then
              length=length+1
              write(OSTR,'(1x,a,$)') loc(i)(1:eow(loc(i)))
              if (length.eq.6) then
                length=0
                write(OSTR,'(/a,$)') '         '
              end if
            end if
   85       continue
            write(OSTR,'(a)') ' }'
            call wrmap(OSTR,5,mapf,nloci,loc,loctyp,locnotes,
     &                 nord,locord,map)
          elseif (bigwor(3)(1:3).eq.'str') then
            if (narg.eq.4) then
              outfil='mainparams'
            else
              outfil=bigwor(5)
            end if
            call cntmark(nloci,loctyp,nmark,1)
            write(*,'(/2a)') 
     &        'Writing STRUCTURE mainparams file to: ',outfil
            open(OSTR,file=outfil,err=9999)
            write(OSTR,'(a//a/a/a)') 
     2   'mainparam written by Sib-pair.',
     3   'KEY PARAMETERS FOR THE PROGRAM structure.',
     4   'YOU WILL NEED TO SET THESE IN ORDER TO RUN THE PROGRAM.', 
     5   'VARIOUS OPTIONS CAN BE ADJUSTED IN THE FILE extraparams.'
            write(OSTR,'(a//3a/a/a,i5,a/a,i4,a)') 'Data File', 
     2   '#define INFILE ', bigwor(4), '// (str) input data file',
     4   '#define OUTFILE results  //(str) results file',
     5   '#define NUMINDS  ', tfound ,' // (int) no. individuals',
     6   '#define NUMLOCI  ', nmark ,'  // (int) no. loci' 
            write(OSTR,'(a)') 
     2   '#define LABEL 1', '#define POPDATA 1', '#define POPFLAG 0',
     3   '#define PHENOTYPE 1','#define EXTRACOLS 0',
     4   '#define PHASEINFO 0','#define MARKOVPHASE 1',
     5   '#define MISSING -9','#define PLOIDY 2',
     6   '#define ONEROWPERIND 1', '#define MARKERNAMES 1',
     7   '#define MAPDISTANCES 1' 
            write(OSTR,'(/a/3(/a))') 'Program Parameters',
     2   '#define MAXPOPS 2 // (int) assumed no. of pops', 
     3   '#define BURNIN 2000 // (int) length of burnin period',
     4   '#define NUMREPS 2000 // (int) no. MCMC reps' 
            write(OSTR,'(/a/8(/a))') 'Command line options:',
     2   '-m mainparams', '-e extraparams', '-s stratparams', 
     3   '-K MAXPOPS', '-L NUMLOCI', '-N NUMINDS', 
     4   '-i input file','-o output file'
          elseif (bigwor(3)(1:3).eq.'mim') then
            outfil=bigwor(4)
            open(OSTR,file=outfil,err=9999)
            write(*,'(/2a)') 
     &        'Writing header for a MIM pedigree file to: ',outfil
            call cntmark(nloci,loctyp,nmark,1)
            write(OSTR,'(2a/a/a/i5,a/i5,a)') 
     2        'MIM data file from ',pedfil,'  0.0 # missing value',
     3        '1 0.5 # genetic variance',nmark,' # number of markers',
     4         nmark-2,' # number of analyses'
            do 189 i=2,nmark-1
              write(OSTR,'(a,3(1x,i3))') '999.0 0.0 0.0',i-1,i,i+1
  189       continue
            do 190 i=1,nloci
            if (loctyp(i).eq.1) then
              call freq(WRK,locpos(i), loctyp(i),pedigree,actset,
     2                  num,nfound,id,fa,mo,sex,locus,numloc,
     3                  numal,name,fndr,alfrq,totall,typed)
              write(OSTR,'(a/2(f6.1,1x),i3,1000(1x,f6.4):)') 
     2          loc(i),map(i),map(i),numal,(alfrq(j),j=1,numal)
            end if
  190       continue
          else
            write(*,'(a)') 'ERROR: Locus file type not supported.'
          end if
          close(OSTR,status='keep')
C
C Write map file
        elseif (keyword.eq.'wri' .and. keyw2.eq.'map' .and. narg.gt.2) 
     &  then
          call args(lin,narg,bigwor,1)
          if (bigwor(3)(1:3).eq.'men') then
            outfil=bigwor(4)
            if (outfil.eq.' ') outfil='mendel.map'
            open(OSTR,file=outfil,err=9999)
            write(*,'(/2a)') 
     &        'Writing MENDEL type map file: ',outfil
            call wrmap(OSTR,4,mapf,nloci,loc,loctyp,locnotes,
     &                 nord,locord, map)
            close(OSTR,status='keep')
          else if (bigwor(3)(1:3).eq.'mer') then
            outfil=bigwor(4)
            if (outfil.eq.' ') outfil='merlin.map'
            open(OSTR,file=outfil,err=9999)
            write(*,'(/2a)') 
     &        'Writing MERLIN type map file: ',outfil
            call wrmap(OSTR,6,mapf,nloci,loc,loctyp,locnotes,
     &                 nord,locord, map)
            close(OSTR,status='keep')
          else if (bigwor(3)(1:3).eq.'lok') then
            outfil=bigwor(4)
            if (outfil.eq.' ') outfil='loki.map'
            open(OSTR,file=outfil,err=9999)
            write(*,'(/2a)') 
     &        'Writing LOKI type parameter file: ',outfil
            call wrmap(OSTR,7,mapf,nloci,loc,loctyp,locnotes,
     &                 nord,locord, map)
            close(OSTR,status='keep')
          else if (bigwor(3)(1:3).eq.'sol') then
            outfil=bigwor(4)
            if (outfil.eq.' ') outfil='solar.map'
            open(OSTR,file=outfil,err=9999)
            write(*,'(/2a)') 
     &        'Writing SOLAR type map file: ',outfil
            call wrmap(OSTR,9,mapf,nloci,loc,loctyp,locnotes,
     &                 nord,locord, map)
            close(OSTR,status='keep')
          else
            write(*,'(a)') 'ERROR: Map file type not supported.'
          end if
C List of quantitative traits for Mendel
        elseif (keyword.eq.'wri' .and. keyw2.eq.'var' .and. narg.gt.2) 
     &  then
          call args(lin,narg,bigwor,1)
          if (bigwor(3)(1:3).eq.'men') then
            outfil=bigwor(4)
            if (outfil.eq.' ') outfil='mendel.var'
          else
            outfil=bigwor(3)
          end if
          open(OSTR,file=outfil,err=9999)
          write(*,'(/2a)') 
     &      'Writing MENDEL type var file: ',outfil
          call wrmap(OSTR,20,mapf,nloci,loc,loctyp,locnotes,
     &               nord,locord, map)
          close(OSTR,status='keep')
C
C write pedigree file
        elseif (keyword.eq.'hea'.and.red) then
          nrec=10
          if (narg.eq.2) nrec=max(1, ival(words(2)))
          call pedhead(longnam,nwid,nloci,loc,loctyp,locpos,lin)
          call pedout(WRK,6,2,imp,nwid,ndec,longnam,'x',nrec,
     2          pedigree,actset,num,nfound,
     3          id,fa,mo,sex,locus,nloci,loctyp,locpos,numloc,lin)
        elseif (keyword.eq.'wri'.and.red) then
          call args(lin,narg,bigwor,1)
          if (narg.eq.1) then
            call pedhead(longnam,nwid,nloci,loc,loctyp,locpos,lin)
            call pedout(WRK,6,2,imp,nwid,ndec,longnam,'x',0,
     2            pedigree,actset,num,nfound,
     3            id,fa,mo,sex,locus,nloci,loctyp,locpos,numloc,lin)
          elseif ((narg.eq.2 .and. bigwor(2).ne.'pap') .or. 
     &        keyw2.eq.'ped' .or. bigwor(2).eq.'gas') then
            if (narg.eq.2) then
              outfil=bigwor(2)
            else
              outfil=bigwor(3)
            end if
            open(OSTR,file=outfil,status='unknown',err=9999)
            write(*,'(/2a)') 
     &        'Writing GAS type pedigree file: ',outfil
            call pedout(WRK,OSTR,1,imp,nwid,ndec,longnam,'x',0,
     2            pedigree,actset,num,nfound,
     3            id,fa,mo,sex,locus,nloci,loctyp,locpos,numloc,lin)
          elseif (keyw2.eq.'mad') then
            outfil=bigwor(3)
            open(OSTR,file=outfil,err=9999)
            write(*,'(/2a)') 
     &        'Writing Madeline data table: ',outfil
            write(OSTR,'(a)') 
     &        'FAMID C','STUDYID C','FATHER C','MOTHER C','SEX X'
            do 245 i=1,nloci
            if (loctyp(i).le.2) then
              write(OSTR,'(2a)') loc(i)(1:eow(loc(i))),' G'
            else if (loctyp(i).eq.3) then
              write(OSTR,'(2a)') loc(i)(1:eow(loc(i))),' N'
            else if (loctyp(i).eq.4) then
              write(OSTR,'(2a)') loc(i)(1:eow(loc(i))),' C'
            end if
  245       continue
            write(OSTR,*)
            call pedout(WRK,OSTR,2,imp,nwid,ndec,longnam,'.',0,
     2            pedigree,actset,num,nfound,
     3            id,fa,mo,sex,locus,nloci,loctyp,locpos,numloc,lin)
          elseif (keyw2.eq.'fis') then
            outfil=bigwor(3)
            open(OSTR,file=outfil,err=9999)
            write(*,'(/2a)') 
     &        'Writing FISHER type pedigree file: ',outfil
            call lorder(4,nloci,loctyp,nord,locord)
            call wrfish(WRK,OSTR,twinning,pedigree,actset,num,nfound,
     2             id,fa,mo,sex,locus,nloci,loctyp,locpos,
     3             numloc,nord,locord,1)
          elseif (keyw2.eq.'cri') then
            outfil=bigwor(3)
            open(OSTR,file=outfil,status='unknown',err=9999)
            open(WRK2,file=wrk2fil,form='unformatted')
            call cntmark(nloci,loctyp,nmark,1)
            write(*,'(/2a)') 
     &        'Writing CRIMAP type pedigree file: ',outfil
            write(OSTR,'(2(1x,i3))') nped,nmark
            do 246 i=1,nloci
            if (loctyp(i).eq.1) then
              write(OSTR,'(a)') loc(i)
              call freq(WRK,locpos(i), loctyp(i),pedigree,actset,
     2                  num,nfound,id,fa,mo,sex,locus,numloc,
     3                  numal,name,fndr,alfrq,totall,typed)
              call wrfreq(WRK2,loc(i),numal,name,alfrq,map(i),
     &                    totall,typed,nobs,3)
            end if
  246       continue
            call wrcri(WRK,WRK2,OSTR,pedigree,actset,num,id,fa,mo,sex,
     2                  locus,nloci,loctyp,locpos,numloc,
     3                  numal,name,alfrq)
            close(WRK2,status='delete')
          elseif (keyw2.eq.'men') then
            outfil=bigwor(3)
            typ=4
            if (bigwor(4)(1:3).eq.'tra') typ=3
            open(OSTR,file=outfil,status='unknown',err=9999)
            write(*,'(/2a)') 
     &        'Writing MENDEL type pedigree file: ',outfil
            call lorder(typ,nloci,loctyp,nord,locord)
            call wrfish(WRK,OSTR,twinning,pedigree,actset,num,nfound,
     2             id,fa,mo,sex,locus,nloci,loctyp,locpos,
     3             numloc,nord,locord,2)
          elseif (keyw2.eq.'dot') then
            outfil=bigwor(3)
            call gettrait(bigwor(4),4,0,nloci,loc,loctyp,trait)
            if (trait.ne.MISS) trait=locpos(trait)
            open(OSTR,file=outfil,status='unknown',err=9999)
            write(*,'(/2a)') 
     &        'Writing pedigree drawing for dot: ',outfil
            if (trait.ne.MISS) then
              write(*,'(8x,2a)') 
     &          'Filled symbols represent: ', bigwor(4)
            end if
            call wrdot(WRK,OSTR,trait,pedigree,actset,num,nfound,
     &             id,fa,mo,sex,locus,nloci,loctyp,locpos,numloc,lin)
          elseif (keyw2.eq.'lin' .or. keyw2.eq.'asp' .or.
     2            keyw2.eq.'tcl' .or. bigwor(2)(1:2).eq.'gh' .or.
     3            keyw2.eq.'ppd') then
            outfil=bigwor(3)
            typ=0
            if (bigwor(4)(1:3).eq.'dum') then
              typ=1
            end if
            if (bigwor(2)(1:2).eq.'gh') then
              typ=3-typ
            elseif (bigwor(4)(1:2).eq.'gh') then
              typ=2
              if (bigwor(5)(1:2).eq.'no') typ=3
            elseif (keyw2.eq.'ppd') then
              typ=typ+5
            end if
            call lorder(typ,nloci,loctyp,nord,locord)
            open(OSTR,file=outfil,status='unknown',err=9999)
            open(WRK2,file=wrk2fil,form='unformatted')
            if (keyw2.eq.'lin' .or. bigwor(2)(1:2).eq.'gh' .or.
     &          keyw2.eq.'ppd') then
              write(*,'(/2a)') 
     &          'Writing LINKAGE type pedigree file: ',outfil
              do 50 i=1,nloci
              if (loctyp(i).le.2) then
                call freq(WRK,locpos(i), loctyp(i),pedigree,actset,
     2                    num,nfound,id,fa,mo,sex,locus,numloc,
     3                    numal,name,fndr,alfrq,totall,typed)
                call wrfreq(WRK2,loc(i),numal,name,alfrq,map(i),
     &                      totall,typed,nobs,3)
              end if
   50         continue
            else
              write(*,'(/2a)') 
     &          'Writing ASPEX type pedigree file: ',outfil
              do 51 i=1,nloci
              if (loctyp(i).le.2) then
                write(OSTR,'(2a,$)') loc(i)(1:eow(loc(i))),' '
                call freq(WRK,locpos(i), loctyp(i),pedigree,actset,
     2                    num,nfound,id,fa,mo,sex,locus,numloc,
     3                    numal,name,fndr,alfrq,totall,typed)
                call wrfreq(WRK2,loc(i),numal,name,alfrq,map(i),
     &                      totall,typed,nobs,3)
              end if
   51         continue
              write(OSTR,*)
            end if
            if (typ.eq.1 .or. typ.eq.2) then
              write(*,'(a)') 'Position 6 is a dummy binary trait.'
            end if
            call wrlink(WRK,WRK2,OSTR,typ,nwid,ndec,pedigree,actset,num,
     2                  nfound,id,fa,mo,sex,locus,nloci,loctyp,locpos,
     3                  nord,locord,numloc,numal,name,alfrq)
            close(WRK2,status='delete')
          elseif (keyw2.eq.'sag') then
            outfil=bigwor(3)
            open(OSTR,file=outfil,status='unknown',err=9999)
            length=0
            nrc=2
            write(*,'(/2a,7(/a))') 
     2       'Writing FSP type pedigree file: ',outfil,
     3       'Record 1:','  Pedigree     6- 10','  ID          11- 18',
     4       '  Father ID   19- 26','  Mother ID   27- 34', 
     5       '  Sex         35- 35','Record 2:'
            do 80 i=1,nloci
              if (length.gt.122) then
                nrc=nrc+1
                length=0
                write(*,'(a,i2,a1)') 'Record',nrc,':'
              end if
              if (loctyp(i).lt.5) then
                varlen=9
                if (loctyp(i).eq.4) varlen=4
                write(*,'(2x,a10,1x,i3,a1,i3)') 
     &            loc(i),length+1,'-',length+varlen
                length=length+varlen
              end if
   80       continue
C write an fsp control file then the fsp pedigree file
            open(OSTR2,file='fsp.par')
            write(OSTR2,'(a,i2,a/5i5,a2/a)') 
     2        'FSP input parameters -- ',nrc,' records per person',
     3        1,0,0,0,nrc,'MF','(a5,i5,3a8,a1)'
            close(OSTR2,status='keep')
            call wrsage(WRK,OSTR,pedigree,actset,num,id,fa,mo,sex,
     &                  locus,nloci,loctyp,locpos,numloc)
          elseif (bigwor(2).eq.'pap') then
            open(OSTR,file='trip.dat')
            open(OSTR2,file='phen.dat')
            open(WRK2,file=wrk2fil,form='unformatted')
            do 250 i=1,nloci
            if (loctyp(i).le.2) then
              call freq(WRK,locpos(i),loctyp(i),pedigree,actset,
     2                  num,nfound,id,fa,mo,sex,locus,numloc,
     3                  numal,name,fndr,alfrq,totall,typed)
              call wrfreq(WRK2,loc(i),numal,name,alfrq,map(i),
     7                    totall,typed,nobs,3)
            end if
  250       continue
            write(*,'(/a)') 
     &        'Writing PAP type pedigree files: phen.dat and trip.dat'
            call wrpap(WRK,WRK2,OSTR,OSTR2,pedigree,actset,num,nfound,
     2                 id,fa,mo,sex,locus,nloci,loctyp,locpos,numloc,
     3                 numal,name,alfrq)
            close(WRK2,status='delete')
            close(OSTR2,status='keep')
          elseif (keyw2.eq.'gda') then
            outfil=bigwor(3)
            open(OSTR,file=outfil,err=9999)
            typ=1
            if (bigwor(4)(1:3).eq.'all') typ=2
            write(*,'(/2a)') 
     &        'Writing GDA (gdatype) data file: ',outfil
            call wrgda(WRK,OSTR,pedigree,actset,num,nfound,id,fa,mo,sex,
     &                 locus,nloci,loc,loctyp,locpos,numloc,typ)
          elseif (keyw2.eq.'str') then
            outfil=bigwor(3)
            call gettrait(bigwor(4),4,0,nloci,loc,loctyp,trait)
            if (trait.ne.MISS) then
              trait=locpos(trait)
            end if
            typ=1
            if (bigwor(narg).eq.'all') typ=2
            write(*,'(/2a)') 
     &        'Writing structure data file: ',outfil
            open(OSTR,file=outfil,err=9999)
            call wrmap(OSTR,8,mapf,nloci,loc,loctyp,locnotes,
     &                 nord,locord, map)
            call wrprd(WRK,OSTR,trait,pedigree,actset,num,nfound,id,fa,
     &             mo,sex,locus,nloci,loc,loctyp,locpos,numloc,typ)
          elseif (keyw2.eq.'arl') then
            outfil=bigwor(3)
            open(OSTR,file=outfil,err=9999)
            open(WRK2,file=wrk2fil,form='unformatted')
            if (bigwor(4)(1:3).eq.'par') then 
              typ=2
              write(*,'(a/2a)') 'Writing 4 longest parental haplotypes',
     &        ' per family to Arlequin data file: ',outfil
            else if (bigwor(4)(1:3).eq.'all') then 
              typ=0
              write(*,'(2a)') 
     &        'Writing all genotypes to Arlequin data file: ',outfil
            else
              typ=1
              write(*,'(a/2a)') 'Writing 2 longest haplotypes',
     &        ' per family to Arlequin data file: ',outfil
            end if
            call wrarl(WRK,WRK2,OSTR,pedigree,actset,num,nfound,id,fa,
     &                 mo,sex,
     2                 locus,nloci,loc,loctyp,locpos,numloc,
     3                 locord,hset,typ)
            close(WRK2,status='delete')
          elseif (keyw2.eq.'phe') then
            outfil=bigwor(3)
            open(OSTR,file=outfil,err=9999)
            write(*,'(/2a)') 
     &        'Writing Mapmaker-Sibs phenotype data file: ',outfil
            call wrphe(WRK,OSTR,pedigree,actset,num,nfound,id,fa,mo,sex,
     &                 locus,nloci,loctyp,locpos,numloc)
          elseif (keyw2.eq.'ram') then
            call gettrait(bigwor(3)(1:20),3,4,nloci,loc,loctyp,trait)
            if (trait.ne.MISS) then
              open(OSTR,file='LDL_rams.ped')
              open(OSTR2,file='LDL_rams.dat')
              write(*,'(/a)') 
     &          'Writing LDL_rams pedigree and phenotype files.'
              call wrrams(wrk, OSTR, OSTR2, trait, pedigree, 
     2                    actset, num, nfound, id, fa, mo, sex, locus,
     3                    nloci, loc, loctyp, locpos, numloc)
              close(OSTR2, status='keep')
            else
              write(*,'(a)') 'Need to specify trait locus!'
            end if
          elseif (keyw2.eq.'csv' .or. keyw2.eq.'sol') then
C 1=ped,id,fa,mo,sex,data (na='NA') 
C 2=famid,id,fa,mo,sex (na=' ')
C 3=famid,id,data
C 4=id,data
            typ=1
            if (keyw2.eq.'sol') typ=2
            if (bigwor(4)(1:3).eq.'phe') typ=3
            if (bigwor(5)(1:3).eq.'nop') typ=4
            outfil=bigwor(3)
            open(OSTR,file=outfil,err=9999)
            write(*,'(/2a)') 
     &        'Writing CSV data file: ',outfil
            call wrcsv(WRK,OSTR,typ,imp,nwid,ndec,
     2             pedigree,actset,num,nfound,
     3             id,fa,mo,sex,locus,nloci,loc,loctyp,locpos,numloc)
          else
            write(*,'(a)') 'ERROR: Pedigree file type not supported.'
          end if
          close(OSTR,status='keep')
C
C SML predicted recurrence risks, ibd sharing etc
        elseif (keyword.eq.'grr') then
          if (narg.ge.4) then
            write(*,'(3(/a))')
     2        '------------------------------------------------',
     3        'Single Major Locus Recurrence Risk Calculation',
     4        '------------------------------------------------'
            call grrpen(words(5)(1:3),fval(words(2)),
     &                  fval(words(3)),fval(words(4)))
          end if
        elseif (keyword.eq.'sml') then
          typ=1
          do 195  i=2, narg
            expr(i-1,1)=fval(words(i))
            if (expr(i-1,1).gt.1.0d0) typ=2
  195     continue
          do 196  i=narg+1,8
            expr(i-1,1)=0.0d0
  196     continue
          if (narg.gt.5) typ=2
          if (typ.eq.2 .and. narg.ge.5 .and. narg.lt.8) then
            j=max(5,narg-1)
            do 197  i=narg+1, 8
              expr(i-1,1)=expr(j,1)
  197       continue
          end if
          if (typ.eq.1 .and. narg.ge.2) then
            write(*,'(3(/a))')
     2      '------------------------------------------------',
     3      'Single Major Locus Recurrence Risk Calculation',
     4      '------------------------------------------------'
            call recrisk(expr(1,1), expr(2,1), expr(3,1), expr(4,1))
          else if (typ.eq.2 .and. narg.ge.2) then
            write(*,'(3(/a))')
     2      '------------------------------------------------',
     3      'Quantitative Trait SML Expectations',
     4      '------------------------------------------------'
            call qtlpars(expr(1,1), expr(2,1), expr(3,1), expr(4,1),
     &                   expr(5,1), expr(6,1), expr(7,1))
          end if
C Contingency chi-square
        elseif (keyword.eq.'chi') then
          i=ival(words(2))
          j=ival(words(3))
          if (i.gt.1 .and. j.gt.1) then
            call rcp(i,name,j,name2,key,gfrq,iter)
          else
            write(*,'(a)') 'Give number of rows and columns in table!'
          end if
C CI for a proportion
        elseif (keyword.eq.'pro') then
          i=ival(words(2))
          j=ival(words(3))
          tmp=fval(words(4))
          call propci(i,j,tmp)
C Chi-square P-value
        elseif (keyword.eq.'pch') then
          tmp=fval(words(2))
          i=ival(words(3))
          write(*,*) chip(tmp,i)
C Long list of variables
        elseif (keyword.eq.'lis') then
          call loadnam(2,narg,words,nloci,loc,loctyp,ord,nord,locord,3)
          call listloci(nord,locord,nloci,loc,loctyp,locpos,locnotes,1)
C Short list of variables
        elseif (keyword.eq.'ls') then
          call loadnam(2,narg,words,nloci,loc,loctyp,ord,nord,locord,3)
          call listloci(nord,locord,nloci,loc,loctyp,locpos,locnotes,2)
C Program setting and data summary
        elseif (keyword.eq.'inf') then
          call info(burnin,imp,iter,ix,iy,iz,mapf,mincnt,plevel,
     2              showorig,addsex,chek,droperr,prompt,use2,
     3              datdir,version,wrkdir)
          call actped(red, WRK, pedfil, nloci, loc, loctyp, locpos,
     2                locnotes, locord, pedigree, actset, num, nfound,
     3                id, fa, mo, sex, locus, numloc, plevel)
C Help
        elseif (keyword.eq.'hel' .or. keyword.eq.'?') then
          typ=7
          if (narg.eq.1) then
            typ=6
          else if (keyw2(1:2).eq.'Al') then
            typ=1
          else if (keyw2(1:1).eq.'G') then
            typ=2
          else if (keyw2(1:1).eq.'O') then
            typ=3
          else if (keyw2(1:1).eq.'D') then
            typ=4
          else if (keyw2(1:2).eq.'An') then
            typ=5
          end if
          call help(typ,words(2),lin,TWRK2)
C Report elapsed time for each procedure
        elseif (keyword.eq.'tim') then
          call stamp(t0)
        elseif (keyword(1:1).eq.'!' .or. keyword(1:1).eq.'#') then
          write(*,'(a)') lin(1:79)
          goto 1
C Pass command to shell
        elseif ((keyword(1:1).eq.'%'.or.keyword(1:1).eq.'$') .and.
     &          eow(lin).gt.1) then
          call shell(lin)
C List files in current directory (Unix like systems)
        elseif (words(1).eq.'dir') then
          lin='$ ls' // lin(4:eow(lin))
          call shell(lin)
C Read commands from a file
        elseif ((keyword.eq.'inc' .or. keyword.eq.'loc') .and.
     &          ilevel.eq.1) then
          call args(lin,narg,bigwor,1)
          infil=bigwor(2)
          inquire(file=infil,exist=filexist)
          if (filexist) then
            write(*,'(/3a)') 
     &        'Reading commands from "', infil(1:eow(infil)),'".'
            ilevel=ilevel+1
            open(CSTRM,file=infil,status='unknown')
            loconly=(keyword.eq.'loc')
          else
            write(*,'(/3a/)') 
     &        'ERROR:  Unable to open "', infil(1:eow(infil)),'".'
          end if
C History
        elseif (keyword.eq.'las') then
          if (narg.eq.1) then
            rewind(LSTR)
            do 101 i=1, nhis
              read(LSTR, '(a)') lin
              write(*,'(i4,2a)') i,': ',lin(1:eow(lin))
  101       continue
          else if (ilevel.eq.1 .and. isreal(words(2))) then
            ilevel=0
            k=ival(words(2))
            if (k.eq.0 .or. k.gt.nhis) then
              k=nhis
            else if (k.lt.0) then
              k=nhis+k+1
            end if
            rewind(LSTR)
            do 102 i=1, k
              read(LSTR,'(a)') lin
  102       continue
            write(*,'(i4,2a)') k,': ',lin(1:eow(lin))
            do 103 i=k+1, nhis
              read(LSTR,*)
  103       continue
          end if
C Reset program
        elseif (keyword.eq.'cle') then
          close(WRK,status='delete')
          goto 999
        elseif (keyword(1:1).eq.' ') then
          continue
C Exit parser loop
        elseif (keyword.eq.'sto' .or. keyword.eq.'qui' .or.
     &          keyword.eq.'exi' .or.keyword(1:2).eq.'by') then
          goto 2
C
C Maybe an expression?
        else
          call args(lin,narg,words,2)
          nterm=narg
          if (keyword.eq.'let') then
            do 198 i=2, nterm
              words(i-1)=words(i)
  198       continue
            nterm=nterm-1
          end if
          call typwords(1,nterm,words,nloci,loc,loctyp,token,env,
     &                  wtyp,expr,actn)
          if (actn.eq.0) then
            error=1
          else
            if (actn.eq.2) call dryrun(1,nterm,wtyp)
            call parser(nterm,wtyp,expr,lbp,rbp,op,error)
C Write answer
            if (error.gt.0 .or. nterm.gt.1) then
              error=1
            else if (actn.eq.1) then 
              call wrans('=> ',expr, wtyp)
            else if (red) then
              write(*,'(a/)') 'Operating on pedigree file' 

              call newnam(wrknum, wrkfil)
              open(TWRK,file=wrkfil,form='unformatted')
              call evalped(WRK, TWRK, narg, words, nloci, loc, loctyp,
     2                     locpos, token, env, lbp, rbp, op, wtyp, expr,
     3                     pedigree, actset, num, nfound, id, fa, mo,
     4                     sex, locus, numloc, droperr, plevel)
              close(WRK,status='delete')
              close(TWRK,status='keep')
              open(WRK,file=wrkfil,form='unformatted')
            else 
              error=1
            end if
          end if
          if (error.eq.1) then
            write(*,'(a,i3,a/7x,a/)')   
     &        'ERROR: problematic input at line ',nlin,':',lin(1:72)
            if (.not.red) write(*,'(a/7x,a/)')
     2        'NOTE:  data set has not yet been read in.',
     3        'Most procedures require a preceding "run" statement.'
          end if
        end if
        call proct(t1, timer)
        call flush(6)
      goto 1
C
C target for i/o errors
C
 9999 continue
        write(*,'(a,i3,2a)') 
     &    'ERROR: I/O error at line ',nlin,': ',lin(1:48)
        if (outfil.eq.' ') then
          write(*,'(7x,a)') 'Null file name!'
        end if
      goto 1
C
C end of main loop
C return to higher level if included commands
C
    2 continue   
      if (ilevel.gt.1) then
        write(*,'(/3a/)') 
     &    'Closing include file "',infil(1:eow(infil)),'".'
        ilevel=ilevel-1
        close(CSTRM,status='keep')
        goto 1
      end if
C
      inquire(unit=LSTR,opened=filexist)
      if (filexist) then
        close(LSTR,status='keep')
      end if
      close(WRK,status='delete')
      call stamp(t0)
      end
C end-of-main
C
C interrupt handler: usable only if compiler supports 
C signal() subroutine
C
      subroutine handler()
      integer irupt
      common /flag/ irupt

      irupt=irupt+1
      if (irupt.gt.5) then
        write(*,'(a)') 'Multiple interrupts received!  Exiting.'
        stop
      end if
      return
      end
C end-of-handler
C
C read in pedigree 
C
      subroutine pedin(strm,wrk,wrk2,addsex,skipline,link, pedigree,num,
     3             nfound,id,fa,mo,sex,locus,locord,ord,key1,key2,set,
     4             last,higen,numloc,lin,words,nwarn,nfam,famerr,plevel)

      integer LINSIZ,MAXSIZ,MAXLOC,MAXCOL,MISS
      parameter (LINSIZ=40000,MAXSIZ=20,MAXLOC=10000,MAXCOL=MAXLOC+5,
     &           MISS=-9999)

      character*20 words(MAXCOL)
      character*(LINSIZ) lin

      integer higen, narg, nfam, nwarn, link, plevel, skipline, 
     &        strm, wrk, wrk2
      logical addsex, famerr, last
C Pedigree structure
      character*10 pedigree
      integer num, nfound
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ), sex(MAXSIZ)
      integer numloc
      double precision locus(MAXSIZ,MAXLOC)
C type of each column of locus
      integer locord(MAXLOC)
C Work arrays for sorting etc
      integer key1(MAXSIZ),key2(MAXSIZ),key3(MAXSIZ),ord(MAXSIZ)  
      integer set(MAXSIZ,2)

      integer col,extra,eop,first,i,nerr,nfields,
     &        nid,pos,sexfa,sexmo, sxpos
      character*10 cfa, cid, cmo
C functions
      integer eow  
      double precision aval, fval

      eop=0
      extra=0
      first=6
      sxpos=5
      if (link.eq.2) then
        first=10
        sxpos=8
      end if
      last=.false.
      nerr=0
      nfound=0 
      nid=0
      num=0
      nfields=first+numloc-1
      pedigree=' '

      do 2 i=1,MAXSIZ
        key2(i)=0
    2 continue
C
C Read in pedigree data
C
      do 3 i=1,skipline
        read(strm,'(a)',end=14) lin
    3 continue
C
    5 continue
        read(strm,'(a)',end=14) lin
        narg=MAXCOL
        call args(lin,narg,words,3)
        if (words(1)(1:1).eq.'!' .or. words(1)(1:1).eq.'#') then
          if (plevel.gt.1) write(*,'(a)') lin(1:79)
        elseif (words(1).eq.' ') then
          continue
        elseif (words(1).eq.'pedigree') then
          continue
        elseif (pedigree.eq.words(1)(1:10) .or. num.eq.0) then
          if (num.eq.0) then
            pedigree=words(1)(1:10)
            eop=eow(pedigree)
          elseif (nid.ge.MAXSIZ) then
            write(*,'(/3a,i4,a/7x,a/)') 
     2        'ERROR: Number of members for pedigree ',
     3        pedigree(1:eop), ' exceeds ',MAXSIZ,
     4        ', the maximum allowed.', 'Stopping prematurely.'
            close(strm,status='keep')
            close(wrk,status='delete')
            close(wrk2,status='delete')
            stop
          end if
          if (narg.ne.nfields) then
            nwarn=nwarn+1
            if (nwarn.le.25) then
              if (narg.lt.nfields) then
                write(*,'(/a/7x,a/)') 
     2          'ERROR: Insufficient number of data fields in:',
     3                  lin(1:72)
              else
                write(*,'(/a/7x,a/)') 
     2          'NOTE:  Excessive number of data fields in:',
     3                  lin(1:72)
              end if
            end if
          end if
          num=num+1
          pedigree=words(1)(1:10)
          cid=words(2)(1:10)
          cfa=words(3)(1:10)
          cmo=words(4)(1:10)
C sex
          sex(num)=MISS
          if (words(sxpos).eq.'f' .or. words(sxpos).eq.'F' .or.
     &        words(sxpos).eq.'2') then
            sex(num)=2
          elseif (words(sxpos).eq.'m' .or. words(sxpos).eq.'M' .or.
     &            words(sxpos).eq.'1') then
            sex(num)=1
          end if
C
C all other variables
          col=0
          if (addsex) col=col+1
          if (link.gt.0) then
            do 20 j=first,nfields
              col=col+1
              locus(num,col)=fval(words(j))
              if (fval(words(j)).eq.0.0) locus(num,col)=MISS
   20       continue
          else
            do 30 j=first,nfields
              col=col+1
              if (locord(col).eq.1 .or. locord(col).eq.2) then
                locus(num,col)=aval(words(j))
              else
                locus(num,col)=fval(words(j))
              end if
   30       continue
          end if
C
C pad if short of data
          do 40 j=col+1,numloc
            locus(num,j)=MISS
   40     continue
C
C Tabulate individual IDs, creating a pointer to the table of IDs,
C and a pointer to the position of the person
C
          call tabid(cid,nid,id,key2,1,key1(num))
          ord(key1(num))=num

          if (cfa.eq.'0'.or.cfa.eq.'X'.or.cfa.eq.'.') cfa='x'
          if (cmo.eq.'0'.or.cmo.eq.'X'.or.cmo.eq.'.') cmo='x'

          if (cid.eq.cfa .or. cid.eq.cmo) then
            write(*,'(/5a/)') 'ERROR: Person ',
     &        pedigree(1:eop),'-', cid(1:eow(cid)),' is his own parent.'
            famerr=.true.
          else if (cfa.ne.'x' .and. cfa.eq.cmo) then
            write(*,'(/7a/)') 'ERROR: Person ',
     2        pedigree(1:eop),'-', cfa(1:eow(cid)),
     3        ' is both father and mother of ', cid(1:eow(cid)),'.'
            famerr=.true.
          end if
C
C Tabulate parental IDs
C adding extra records where a parental ID is not specified
C
C nonfounder
          if (cfa.ne.'x' .and. cmo.ne.'x') then
            call tabid(cfa,nid,id,key2,0,fa(num))
            call tabid(cmo,nid,id,key2,0,mo(num))
C founder
          elseif (cfa.eq.'x' .and. cmo.eq.'x') then 
            nfound=nfound+1
            fa(num)=MISS
            mo(num)=MISS
C nonfounder with one parent not specified -- check if enough storage space
          elseif (nid.ge.MAXSIZ) then 
            write(*,'(/3a,i4,a/7x,a/)') 
     2        'ERROR: Number of members for pedigree ',
     3        pedigree(1:eop), ' will exceed ',MAXSIZ,
     4        ', the maximum allowed if a dummy record created.', 
     5        'Stopping prematurely.'
            close(strm,status='keep')
            close(wrk,status='delete')
            close(wrk2,status='delete')
            stop
C create new father
          elseif (cfa.eq.'x') then 
            call tabid(cmo,nid,id,key2,0,mo(num))
            extra=extra+1
            nid=nid+1
            fa(num)=nid
            write(cfa,'(a2,i3.3)') 'ZZ',extra
            id(nid)=cfa
            call mkdummy(num,nfound,MISS,addsex,fa,mo,sex,numloc,locus)
            ord(nid)=num
            key1(num)=nid
            key2(nid)=1
            if (plevel.ge.0) then
              write(*,'(/8a/)') 'NOTE:  Father of person ',
     2          pedigree(1:eop),'-',cid(1:eow(cid)),
     3          ' not specified.  Creating ',
     4          pedigree(1:eop),'-',cfa(1:eow(cfa)) 
            end if
C create new mother
          elseif (cmo.eq.'x') then 
            call tabid(cfa,nid,id,key2,0,fa(num))
            extra=extra+1
            nid=nid+1
            mo(num)=nid
            write(cmo,'(a2,i3.3)') 'ZZ',extra
            id(nid)=cmo
            call mkdummy(num,nfound,MISS,addsex,fa,mo,sex,numloc,locus)
            ord(nid)=num
            key1(num)=nid
            key2(nid)=1
            if (plevel.ge.0) then
              write(*,'(/8a/)') 'NOTE:  Mother of person ',
     2          pedigree(1:eop),'-',cid(1:eow(cid)),
     3          ' not specified.  Creating ',
     4          pedigree(1:eop),'-',cmo(1:eow(cmo)) 
            end if
          end if
        else
          backspace(strm)
          goto 15
        end if
        goto 5
C
C end of while loop
C
   14 last=.true.
   15 continue
C
C Check for errors 
C
      if (famerr) return
C By individual 
      do 100 i=1,nid
        if (key2(i).gt.1) then
          write(*,'(/5a/)') 'ERROR: Duplicate record for person ',
     &      pedigree(1:eop),'-',id(i)(1:eow(id(i))),'.'
          nerr=1
        elseif (key2(i).eq.0) then
          if (plevel.ge.0) then
            write(*,'(/5a/)') 'NOTE:  Creating dummy record for ',
     &        pedigree(1:eop),'-',id(i)(1:eow(id(i))),'.'
          end if
          if (num.eq.MAXSIZ) then
            write(*,'(/3a,i4,a/7x,a/)') 
     2        'ERROR: Number of members for pedigree ',
     3        pedigree(1:eop), ' will exceed ',MAXSIZ,
     4        ', the maximum allowed.', 'Stopping prematurely.'
            close(strm,status='keep')
            close(wrk,status='delete')
            close(wrk2,status='delete')
            stop
          end if
          j=MISS
          call mkdummy(num,nfound,j,addsex,fa,mo,sex,numloc,locus)
          ord(i)=num
          key1(num)=i
        end if
  100 continue
C
C By mating
      do 110 i=1,num
      if (fa(i).ne.MISS .and. mo(i).ne.MISS) then
        cid=id(key1(i))
        sexfa=sex(ord(fa(i)))
        sexmo=sex(ord(mo(i)))
        if (sexfa.eq.1 .and. sexmo.eq.2) goto 110

        if ((sexfa.eq.2 .and. (sexmo.eq.1.or.sexmo.eq.MISS)) .or.
     &           (sexfa.eq.MISS .and. sexmo.eq.1)) then
          if (plevel.ge.0) then
            write(*,'(/4a/7x,a/)') 
     2        'NOTE:  Father and mother of person ',
     3        pedigree(1:eop),'-',cid(1:eow(cid)),
     4        ' appear to be swapped around.','Reordering.'
          end if
          j=fa(i)
          fa(i)=mo(i)
          mo(i)=j
          sexfa=sex(ord(fa(i)))
          sexmo=sex(ord(mo(i)))
        elseif (sexfa.ne.MISS .and. sexfa.eq.sexmo) then
          write(*,'(/5a/)') 'ERROR: Parents of person ',
     2      pedigree(1:eop),'-',cid(1:eow(cid)),
     3      ' appear to be the same sex.'
          nerr=1
        end if
C
C one reordered, fill in missing sexes
        if (sexfa.eq.1 .and. sexmo.eq.MISS) then
          if (plevel.ge.0) then
            write(*,'(/5a/7x,a)') 'NOTE:  Person ',
     2        pedigree(1:eop),'-',id(mo(i))(1:eow(id(mo(i)))),
     3        ' appears as a mother and sex was unspecified.',
     4        'Setting sex to female.'
          end if
          sex(ord(mo(i)))=2
        else if (sexfa.eq.MISS .and. sexmo.eq.2) then
          if (plevel.ge.0) then
            write(*,'(/5a/7x,a)') 'NOTE:  Person ',
     2        pedigree(1:eop),'-',id(fa(i))(1:eow(id(fa(i)))),
     3        ' appears as a father and sex was unspecified.',
     4        'Setting sex to male.'
          end if
          sex(ord(fa(i)))=1
        else if (sexfa.eq.MISS .and. sexmo.eq.MISS) then
          sex(ord(fa(i)))=1
          sex(ord(mo(i)))=2
        end if
      end if
  110 continue
      if (nerr.ne.0) then
        famerr=.true.
        return
      end if
C
C sex may also have been requested as a quantitative variable
C
      if (addsex) then
        do 120 i=1,num
          if (sex(i).eq.2) then
            locus(i,1)=0.0d0
          elseif (sex(i).eq.1) then
            locus(i,1)=1.0d0
          else
            locus(i,1)=0.5d0
          end if
  120   continue
      end if
C
C Sort the pedigree on generation number, id, and parental ID,
C returning the sorted position in ord
C
      call famsort(pedigree,num,nfound,nid,id,key1,fa,mo,key2,key3,ord,
     &             set,higen,nfam,nerr,plevel)
C
C Catch pedigree errors
      if (nerr.ne.0) then
        famerr=.true.
        return
      end if
C
C reorder the pedigree using external file
C
      do 140 i=1,num
        key2(ord(i))=i
  140 continue
      do 150 i=1,num
        pos=ord(i)
        if (fa(pos).ne.MISS) then
          write(wrk2) id(key1(pos)),key2(fa(pos)),key2(mo(pos)),
     &      sex(pos), (locus(pos,j),j=1,numloc)
        else
          write(wrk2) id(key1(pos)),MISS,MISS, sex(pos), 
     &      (locus(pos,j),j=1,numloc)
        end if
  150 continue
      rewind(wrk2)
      do 160 i=1,num
        read(wrk2) id(i),fa(i),mo(i),sex(i),(locus(i,j),j=1,numloc)
  160 continue
      return
      end
C end-of-pedin
C
C Tabulate alphanumeric IDs in order of appearance
C
      subroutine tabid(curid,nid,id,count,inc,pos)
      integer MAXSIZ, MISS
      parameter (MAXSIZ=20,MISS=-9999)

      integer nid, pos
      character*10 curid  

      character*10 id(MAXSIZ)
      integer count(MAXSIZ)

      do 10 pos=1,nid
      if (id(pos).eq.curid) then
        count(pos)=count(pos)+inc
        return 
      end if
   10 continue

      if (nid.lt.MAXSIZ) then
        nid=nid+1
        pos=nid
        id(pos)=curid
        count(pos)=inc
      else
        pos=MISS
        write(*,'(a,i5,a/)') 'ERROR: More than ',MAXSIZ,' IDs in family'
      end if
      return
      end
C end-of-tabid
C
C Work out generation number ord(), then sort family on 
C founder status, generation number, parental ID, 
C and personal ID giving their position in ord().
C Returns the ranking in ord(), and the depth of the pedigree in higen
C
      subroutine famsort(pedigree,num,nfound,nid,id,pid,fa,mo,
     &                   key1,key2,ord,set,higen,nfam,nerr,plevel)
      integer MAXSIZ, MISS
      parameter (MAXSIZ=20,MISS=-9999)
      integer higen, nerr, nfam, plevel
C Pedigree structure
      character*10 pedigree 
      character*10 id(MAXSIZ)
      integer num,nfound,pid(MAXSIZ),fa(MAXSIZ),mo(MAXSIZ)
      integer key1(MAXSIZ), key2(MAXSIZ), ord(MAXSIZ), set(MAXSIZ,2)
C
      integer curkey1, curkey2, i, maxgrp, nsub, stratum
C
C nsub=number of disjoint subpedigrees within "pedigree"; higen=number of
C generations in family; subped no. 1 largest, size maxgrp
C
C first change the parental ID pointer from id table position 
C to file position as required by connect() and gener()
C
      do 15 i=1,num
      if (fa(i).ne.MISS) then
        fa(i)=ord(fa(i))
        mo(i)=ord(mo(i))
      end if
   15 continue
C
C determine collating order of IDs in table
C
      call ascend(nid, key1)
      call csort(nid, id, key1)
C
C create reverse index from sorted table to original records
C so that the multiple key sort can be performed
C
      call ascend(nid, ord)
      call isort(1, nid, key1, ord, 2)
      do 20 i=1,num
        pid(i)=ord(pid(i))
   20 continue
C
C determine if one or more subpedigrees are present
C
      call connect(num,fa,mo,set,nsub,maxgrp)
C
C list any subpedigrees
C
      if (nsub.gt.1 .and. plevel.ge.0) then
        call wrsubped(pedigree,num,id,pid,set,nsub,maxgrp,plevel)
      end if
C
C get the generation number
C
      call gener(pedigree,num,fa,mo,nsub,set,key1,higen,nerr,plevel)
C
C and sort on generation number and foundership
C
      do 60 i=1,num
      if (fa(i).ne.MISS) then
        key1(i)=higen+key1(i)
      end if
   60 continue
      call ascend(num,ord)
      call isort(1,num,key1,ord,2)
C now on paternal ID
      do 160 i=nfound+1,num
        key2(i)=pid(fa(ord(i)))
  160 continue
      call msdsort(nfound+1,num,key1,key2,ord)
C now on maternal ID
      stratum=0
      curkey1=MISS
      curkey2=MISS
      do 260 i=nfound+1,num
        if (key1(i).ne.curkey1 .or. 
     &      key1(i).eq.curkey1 .and. key2(i).ne.curkey2) then
          stratum=stratum+1
          curkey1=key1(i)
          curkey2=key2(i)
        end if
        key2(i)=stratum
        key1(i)=pid(mo(ord(i)))
  260 continue
      call msdsort(nfound+1,num,key2,key1,ord)
C now on ID
      do 360 i=1,nfound
        key1(i)=0
        key2(i)=pid(ord(i))
  360 continue
      stratum=0
      curkey1=MISS
      curkey2=MISS
      do 370 i=nfound+1,num
        if (key2(i).ne.curkey1 .or. key1(i).ne.curkey2) then
          stratum=stratum+1
          curkey1=key2(i)
          curkey2=key1(i)
        end if
        key1(i)=stratum
        key2(i)=pid(ord(i))
  370 continue
      call isort(1, nfound, key2, ord, 2)
      call msdsort(nfound+1,num,key1,key2,ord)
      nfam=stratum
      return
      end
C end-of-famsort
C
C MSD radix sort key1, key2
C
      subroutine msdsort(bot,top,key1,key2,ord)
      integer MAXSIZ
      parameter(MAXSIZ=20)
      integer bot, top
      integer key1(MAXSIZ),key2(MAXSIZ),ord(MAXSIZ)
      integer curkey,fin,i,sta

      curkey=key1(bot)
      sta=bot
      fin=bot
      do 197 i=bot+1,top
        if (key1(i).eq.curkey) then
          fin=i
        else
          call isort(sta, fin, key2, ord, 2)
          sta=i
          fin=i
          curkey=key1(sta)
        end if
  197 continue
      call isort(sta, fin, key2, ord, 2)
      return
      end
C end-of-msdsort
C
C Create dummy records for added individals
C
      subroutine mkdummy(num,nfound,sx,addsex,fa,mo,sex,numloc,locus)
      integer MAXLOC, MAXSIZ, MISS
      parameter (MAXLOC=10000,MAXSIZ=20,MISS=-9999)

      integer nfound,num,numloc,sx
      logical addsex
      integer fa(MAXSIZ),mo(MAXSIZ),sex(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)
      integer j

      num=num+1
      nfound=nfound+1
      fa(num)=MISS
      mo(num)=MISS
      sex(num)=sx
      do 15 j=1,numloc
        locus(num,j)=MISS
   15 continue
      if (addsex) then
        if (sex(num).eq.2) then
          locus(num,1)=0.0d0
        elseif (sex(num).eq.1) then
          locus(num,1)=1.0d0
        else
          locus(num,1)=0.5d0
        end if
      end if
      return
      end
C end-of-mkdummy
C
C Read pedigree from work file
C
      subroutine wrkin(wrk,pedigree,actset, num,nfound,id,fa,mo,sex,
     &                 locus,numloc,last)
      integer MAXSIZ,MAXLOC
      parameter (MAXSIZ=20,MAXLOC=10000)
C Pedigree structure
      character*10 pedigree
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ), sex(MAXSIZ)
      integer actset,num,nfound,numloc,wrk
      double precision locus(MAXSIZ,MAXLOC)
      logical last
      integer i,j
      last=.false.
      read(wrk,end=30) pedigree,actset,num,nfound
      do 20 i=1,num
        read(wrk) id(i),fa(i),mo(i),sex(i),(locus(i,j),j=1,numloc)
   20 continue
      return
C
   30 last=.true.
      return
      end
C end-of-wrkin
C
C Write pedigree to work file
C
      subroutine wrkout(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,
     &                  locus,numloc)
      integer MAXSIZ,MAXLOC
      parameter (MAXSIZ=20,MAXLOC=10000)
C Pedigree structure
      character*10 pedigree
      integer actset, num, nfound
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ), sex(MAXSIZ)
      integer numloc,wrk
      double precision locus(MAXSIZ,MAXLOC)
      integer i

      write(wrk) pedigree, actset, num, nfound
      do 10 i=1,num
        write(wrk) id(i),fa(i),mo(i),sex(i),(locus(i,j),j=1,numloc)
   10 continue
      return
      end
C end-of-wrkout
C
C Add extra blank columns to the dataset
C
      subroutine addvar(wrk,twrk,newloc,pedigree,actset,num,nfound,
     &                  id,fa,mo,sex,locus,numloc)
      integer MAXSIZ, MAXLOC, MISS
      parameter(MAXSIZ=20, MAXLOC=10000, MISS=-9999)

      integer newloc, wrk, twrk

      character*10 pedigree
      integer num,nfound 
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ),mo(MAXSIZ),sex(MAXSIZ)
      integer numloc
      double precision locus(MAXSIZ,MAXLOC)
C
      integer actset,i,j
      logical last

      last=.false.
      rewind(wrk)
   10 continue
       call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &            numloc,last)
       if (last) goto 20
        do 15 i=1,num
        do 15 j=numloc+1,newloc
          locus(i,j)=MISS
   15   continue
        call wrkout(twrk,pedigree,actset,num,nfound,id,fa,mo,sex,
     &              locus,newloc)
      goto 10
   20 continue
      return
      end
C end-of-addvar
C
C Make every individual and pedigree ID a unique number
C
      subroutine uniqid(wrk,twrk,pedigree,actset,num,nfound,
     &                  id,fa,mo,sex,locus,numloc,typ)
      integer MAXSIZ, MAXLOC, MISS
      parameter(MAXSIZ=20, MAXLOC=10000, MISS=-9999)

      integer wrk, twrk, typ

      character*10 pedigree
      integer num,nfound 
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ),mo(MAXSIZ),sex(MAXSIZ)
      integer numloc
      double precision locus(MAXSIZ,MAXLOC)
C
      integer actset, famcnt, i, idbase, idno, nfam, tot
      logical last

      famcnt=int(10.0**int(max(3.0,1.0+log10(float(MAXSIZ)))))
      idbase=0
      nfam=0
      tot=0
      pedigree=' '
      last=.false.
      rewind(wrk)
   10 continue
       call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &            numloc, last)
       if (last) goto 20

        if (actset.gt.0) then
          nfam=nfam+1
          if (typ.eq.1) then
            idbase=idbase+famcnt
            idno=idbase
          else
            idno=tot
          end if
          write(pedigree,'(i6.6)') nfam  
          do 15 i=1,num
            idno=idno+1
            write(id(i),'(i10)') idno
            call juststr('l',id(i),10)
   15     continue
          tot=tot+num
        end if
        call wrkout(twrk,pedigree,actset,num,nfound,id,fa,mo,sex,
     &              locus,numloc)
      goto 10
   20 continue
      write(*,'(a,i5,a)') 'Renamed ', nfam, ' pedigrees.'
      return
      end
C end-of-uniqid
C
C Assign a locus type to every column of data file
C
      subroutine asstyp(nloci, loctyp, locpos, numloc, locord)
      integer MAXLOC
      parameter(MAXLOC=10000)

      integer nloci, numloc
      integer locpos(MAXLOC), locord(MAXLOC), loctyp(MAXLOC)

      do 5 i=1, numloc
        locord(i)=0
    5 continue
      do 10 i=1, nloci
        locord(locpos(i))=loctyp(i)
        if (loctyp(i).eq.1 .or. loctyp(i).eq.2) then
          locord(locpos(i)+1)=loctyp(i)
        end if
   10 continue
      return
      end
C end-of-asstyp
C
C summarize current pedigree file
C
      subroutine actped(red, wrk, pedfil, nloci,loc,loctyp,locpos,
     2                  locnotes, typed, pedigree, actset, num, nfound,
     3                  id,fa,mo,sex,locus,numloc,plevel)
      integer KNOWN, MAXSIZ, MAXLOC, MISS, VSIZ
      parameter(KNOWN=0, MAXSIZ=20, MAXLOC=10000, 
     &          MISS=-9999, VSIZ=MAXSIZ*MAXLOC)

      integer plevel, wrk
      logical red
      character*144 pedfil
C
C Locus structure:
C number of loci, locus name, locus type, and locus position in file
C
      integer nloci
      character*20 loc(MAXLOC)
      character*40 locnotes(MAXLOC)
      integer loctyp(MAXLOC),locpos(MAXLOC)
C  Pedigree structure
      character*10 pedigree
      integer actset,num, nfound
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ)
      integer sex(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)

      integer typed(MAXLOC)
C local variables
      integer j, nmark, nped, tnum, tot, tped 
      character*1 typloc(8)
C functions
      integer eow
      data typloc/'m','x','q','a','d','d','d','d'/

      call cntmark(nloci,loctyp,nmark,2)
      write(*,'(3a/a,i6,a,i6)')   
     2  'Pedigree file         = "',pedfil(1:eow(pedfil)),'"',
     3  'Number of active loci = ',nmark,' of ',nloci

      if (.not.red) return
        
      call coutyp(wrk,nloci,loctyp,locpos,
     2            pedigree, actset, num, nfound,
     3            id,fa,mo,sex,locus,numloc,typed,nped,tnum,tped,tot)

      write(*,'((a,i6,a,i6))') 
     2  'Number of active peds = ',nped , ' of ', tped,
     3  'Number of active inds = ',tot , ' of ', tnum
      write(*,'(2(/a10,1x,a4,1x,a8,1x,a6))') 
     2  'Locus     ','Type','Position','Typed', 
     3  '----------','----','--------','-----'
      do 50 j=1,nloci
        if (loctyp(j).eq.1 .or. loctyp(j).eq.2 .or.
     &      loctyp(j).eq.5 .or. loctyp(j).eq.6) then
          write(*,'(a10,2x,a1,3x,i3,a2,i3,1x,i6,1x,a,f5.1,a,3x,a)') 
     2      loc(j),typloc(loctyp(j)),locpos(j)+5,'--',locpos(j)+6,
     3      typed(j), '(',100.0*float(typed(j))/float(tot),'%)',
     4      locnotes(j)(1:eow(locnotes(j)))
        else 
          write(*,'(a10,2x,a1,3x,i3,6x,i6,1x,a,f5.1,a,3x,a)') 
     2      loc(j),typloc(loctyp(j)),locpos(j)+5,
     3      typed(j), '(',100.0*float(typed(j))/float(tot),'%)',
     4      locnotes(j)(1:eow(locnotes(j)))
        end if
   50 continue

      return
      end
C end-of-actped
C
C Give counts of typed individuals for each locus
C
      subroutine coutyp(wrk,nloci,loctyp,locpos,
     2                  pedigree, actset, num, nfound,
     3                  id,fa,mo,sex,locus,numloc,
     4                  typed,nped,tnum,tped,tot)
      integer KNOWN, MAXSIZ, MAXLOC, MISS, VSIZ
      parameter(KNOWN=0, MAXSIZ=20, MAXLOC=10000, 
     &          MISS=-9999, VSIZ=MAXSIZ*MAXLOC)

      integer nped, tnum, tot, tped, wrk
C
C Locus structure:
C number of loci, locus name, locus type, and locus position in file
C
      integer nloci
      integer loctyp(MAXLOC),locpos(MAXLOC)
C  Pedigree structure
      character*10 pedigree
      integer actset,num, nfound
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ)
      integer sex(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)

      integer typed(MAXLOC)
C local variables
      integer i, j  
      logical last
      double precision val

      nped=0
      tot=0
      tnum=0
      tped=0
      do 1 j=1, nloci
        typed(j)=0
    1 continue
      last=.false.
      rewind(wrk)
    5 continue
        call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &             numloc, last)
        if (last) goto 20

        tped=tped+1
        tnum=tnum+num

        if (actset.le.0) goto 5

        nped=nped+1
        tot=tot+num
        do 7 i=1,num
          do 8 j=1, nloci
            val=locus(i,locpos(j))
            if (val.ne.MISS .and. .not.((loctyp(j).eq.1 .or. 
     2          loctyp(j).eq.2 .or. loctyp(j).eq.5 .or. loctyp(j).eq.6)
     3          .and. val.le.KNOWN)) then
              typed(j)=typed(j)+1
            end if
    8     continue
    7   continue
      goto 5
   20 continue
      return
      end
C end-of-coutyp
C
C check for simple inconsistencies between child and parent
C if requested, delete any problem genotypes (up to and including
C all genotypes for a nuclear family)
C
C error                                     action if droperr
C ----------------------------------------  ----------------------------
C 11=single parent-offspring inconsistency  delete child genotype
C 12=Multiple p-o inconsistencies           delete all nuclear fam genos
C 13=Inconsistencies between siblings       delete all nuclear fam genos
C 14=More than 4 alleles segregating        delete all nuclear fam genos
C
C
      subroutine check(pedigree,num,nfound,id,fa,mo,sex,locus,
     2                 nloci,loc,loctyp,locpos,set,xmale,
     3                 droperr,ndiscard,inconsist,plevel)
      integer KNOWN,MAXLOC,MAXSIZ,MISS
      parameter (KNOWN=0,MAXLOC=10000,MAXSIZ=20,MISS=-9999)
      integer droperr, inconsist, ndiscard, plevel
C Pedigree structure
      character*10 pedigree
      integer num,nfound 
      character*10 id(MAXSIZ) 
      integer fa(MAXSIZ),mo(MAXSIZ),sex(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)
C
      integer nloci
      character*20 loc(MAXLOC)
      integer loctyp(MAXLOC),locpos(MAXLOC)
C
C count of segregating alleles
      integer nall, allele(5)
C sibship genotypes
      integer set(MAXSIZ,2)
      logical xmale(MAXSIZ)
C other local variables
      integer c1,c2,currf,currm,eop,gene,gen2,i,j,
     &        nkids, p11,p12,p21,p22,sta
      integer bad1, bad2, badchild, errtyp
      integer ptyped
      logical err, thiserr, xlinkd
      character*7 gtp
C functions
      integer eow, parcon
      logical opcon
C
      eop=eow(pedigree)
      do 10 j=1,nloci
      if (loctyp(j).le.2) then 
        xlinkd=(loctyp(j).eq.2)
        badchild=MISS
        gene=locpos(j)
        gen2=gene+1
        nkids=0
        ptyped=0
        currf=MISS
        currm=MISS
C
C Check for male X-linked heterozygotes
        if (xlinkd) then
          err=.false.
          do 15 i=1, num
            if (sex(i).eq.1 .and. locus(i,gene).gt.KNOWN .and.
     &          locus(i,gene).ne.locus(i, gen2)) then
              call wrgtp(int(locus(i,gene)), int(locus(i,gen2)),gtp,1)
              write(*,'(/9a/)') 'ERROR: Heterozygous male ',
     2          pedigree(1:eop),'-',id(i)(1:eow(id(i))),
     3          ' at X-linked locus ',loc(j),' {',gtp,'}'
              if (droperr.gt.0) then
                locus(i,gene)=MISS
                locus(i,gen2)=MISS
              else
                err=.true.
                inconsist=inconsist+1
              end if
            else if (sex(i).eq.MISS .and. locus(i,gene).gt.KNOWN) then
              call wrgtp(int(locus(i,gene)), int(locus(i,gen2)),gtp,1)
              write(*,'(/9a/)') 'NOTE:  Unspecified sex for ',
     2          pedigree(1:eop),'-',id(i)(1:eow(id(i))),
     3          ' at X-linked locus ',loc(j),' {',gtp,'}'
            end if
   15     continue
          if (err) return
        end if
C
C Check each nuclear family
C
        err=.false.
        do 20 i=nfound+1,num
C Print results of last sibship and do parents of current sibship
          if (fa(i).ne.currf .or. mo(i).ne.currm) then
            if (err) then
              if (nall.gt.4) errtyp=14
C Temporarily put back deleted genotype if errtyp=11
              if (badchild.ne.MISS) then
                locus(badchild,gene)=dfloat(bad1)
                locus(badchild,gen2)=dfloat(bad2)
              end if
C
C print only the list of genotypes for the family if verbosity low
C otherwise a pedigree drawing
C
              call famerr(loc(j),gene,pedigree,id,fa,mo,sex,locus,
     &                  currf,currm,badchild,sta,i-1,errtyp,plevel)
C
C And delete genotype if errtyp=11 or family if errtyp>11
              if (droperr.gt.0 .and. errtyp.ge.11) then
                call remfam(currf,currm,sta,i-1,gene,locus,ndiscard)
              end if
              err=.false.
            end if 
C initialize current sibship
            errtyp=0
            badchild=MISS
            sta=i
            nkids=0
            currf=fa(i)
            currm=mo(i)
            p11=int(locus(currf,gene))
            p12=int(locus(currf,gen2))
            p21=int(locus(currm,gene))
            p22=int(locus(currm,gen2))
            nall=0
            ptyped=0
            if (p11.gt.KNOWN) then
              ptyped=ptyped+1
              call addall(p11,nall,allele)
              call addall(p12,nall,allele)
            end if
            if (p21.gt.KNOWN) then
              ptyped=ptyped+2
              call addall(p21,nall,allele)
              call addall(p22,nall,allele)
            end if
          end if
C
C do current child if typed
C
          if (locus(i,gene).gt.KNOWN) then
            thiserr=.false.
            c1=int(locus(i,gene))
            c2=int(locus(i,gen2))
            nkids=nkids+1
            xmale(nkids)=(xlinkd .and. sex(i).ne.2)
            set(nkids,1)=c1
            set(nkids,2)=c2
C
C test for simple parent-offspring inconsistency
C if single error, try deleting just child
C
            if ((ptyped.eq.3 .and.
     2        parcon(c1,c2,p11,p12,p21,p22,xmale(nkids)).eq.0) .or.
     3        (ptyped.eq.1 .and. .not.xmale(nkids) .and. 
     4                           .not.opcon(c1,c2,p11,p12)) .or.
     5        (ptyped.eq.2 .and. .not.opcon(c1,c2,p21,p22))) then
              thiserr=.true.
              if (errtyp.eq.0) then
                errtyp=11
                badchild=i
                bad1=c1
                bad2=c2
                locus(i,gene)=MISS
                locus(i,gen2)=MISS
              elseif (errtyp.eq.11) then
                errtyp=12
              end if
C or too many alleles segregating in sibship
            else
              call addall(c1,nall,allele)
              call addall(c2,nall,allele)
              if (nall.gt.4 .or. (xlinkd .and. nall.gt.3)) then
                thiserr=.true.
                errtyp=14
C else test for more complex errors
              elseif (.not.err .and. ptyped.ne.3 .and. nkids.gt.1) 
     &        then
                call nuchek(xlinkd,ptyped,p11,p12,p21,p22,
     &                 nkids,set,xmale,nall,allele,thiserr)
                errtyp=13
              end if
            end if
C If an error, note the responsible child
            if (thiserr) then
              err=.true.
              if (droperr.eq.0) inconsist=inconsist+1
              if (plevel.gt.-2) then
                call wrgtp(c1,c2,gtp,1)
                write(*,'(/9a/)') 'NOTE:  Inconsistency due child ',
     2            pedigree(1:eop),'-',id(i)(1:eow(id(i))),
     3            ' at locus ',loc(j),' {',gtp,'}'
              end if
            end if
          end if
   20   continue
C
C Last sibship 
C
        if (err) then
          if (nall.gt.4) errtyp=14
          if (badchild.ne.MISS) then
            locus(badchild,gene)=dfloat(bad1)
            locus(badchild,gen2)=dfloat(bad2)
          end if
          call famerr(loc(j),gene,pedigree,id,fa,mo,sex,locus,
     &                currf,currm,badchild,sta,i-1,errtyp,plevel)
          if (droperr.gt.0 .and. errtyp.ge.11) then
            call remfam(currf,currm,sta,i-1,gene,locus,ndiscard)
          end if
        end if 
      end if
   10 continue
      return
      end
C end-of-check
C
C identify parental alleles in nuclear family
C
      subroutine addall(iall,nall,allele)
      integer iall
      integer nall, allele(5)
      integer i
C find a match      
      do 10 i=1,nall
      if (iall.eq.allele(i)) then
        return
      end if
   10 continue
C else create new allele entry
      nall=nall+1
      if (nall.le.4) allele(nall)=iall
      return
      end
C end-of-addall
C
C nuclear family consistency check (untyped parents)
C
      subroutine nuchek(xlinkd,ptyped,p11,p12,p21,p22,
     &                  nkids,set,xmale,nall,allele,thiserr)
      integer KNOWN, MAXALL, MAXSIZ, MAXLOC, MISS
      parameter(KNOWN=0, MAXALL=2, MAXSIZ=20,  
     &          MAXLOC=10000, MISS=-9999)
      integer p11, p12, p21, p22, ptyped
      logical thiserr, xlinkd
C Pedigree structure
      integer nkids
      integer set(MAXSIZ,2)  
      logical xmale(MAXSIZ)
C
C count of segregating alleles, and frequency
      integer nall, allele(5)
C other local variables
      integer g1,g2,g3,g4
      integer i,mg1,mg2,pg1,pg2
      integer i1,i2,t1,t2
C functions
      integer parcon, whall
C
C While loop to list all possible genotypes
C initialize genotype indices
C
      if (ptyped.eq.1) then
        t1=1
        i1=1
        g1=whall(p11,nall,allele)
        g2=whall(p12,nall,allele)
      else
        t1=nall*(nall+1)/2
        i1=0
        g1=1
        g2=0
      end if
      if (ptyped.eq.2) then
        t2=1
        i2=1
        g3=whall(p21,nall,allele)
        g4=whall(p22,nall,allele)
      else
        t2=nall*(nall+1)/2
        i2=t2
        g3=1
        g4=0
      end if
C
C simulated nested do-loops
C check if inner loop completed once
C
      thiserr=.true.
  100 continue
        if (i2.eq.t2) then
          call couple(i1,t1,nall,g1,g2)
          pg1=allele(g1)
          pg2=allele(g2)
          if (xlinkd) pg2=pg1
          if (t2.gt.1) i2=0
        end if
        call couple(i2,t2,nall,g3,g4)
        mg1=allele(g3)
        mg2=allele(g4)
C       write(*,*) 'fa: ',pg1,'/',pg2,' ', mg1,'/', mg2
        do 10 i=1, nkids
C         write(*,*) 'Child ',i,' ',set(i,1),'/',set(i,2),' parcon=',
C    &      parcon(set(i,1),set(i,2),pg1,pg2,mg1,mg2,xmale(i))
        if (parcon(set(i,1),set(i,2),pg1,pg2,mg1,mg2,xmale(i)).eq.0) 
     &  then
          goto 55
        end if
   10   continue
C else (if consistent) return good news
          thiserr=.false.
          return
   55   continue
C end of while loop
      if (i1.ne.t1 .or. i2.ne.t2) goto 100
      return
      end
C end-of-nuchek
C
C Write out nuclear family error
C
      subroutine famerr(locnam,gene,pedigree,id,fa,mo,sex,locus,
     &                  currf,currm,badchild,sta,fin,errtyp,plevel)
      integer MAXSIZ, MAXLOC, MISS
      parameter(MAXSIZ=20, MAXLOC=10000, MISS=-9999)

      integer badchild,currf,currm,errtyp,fin,gene,plevel,sta

      character*20 locnam
      character*10 pedigree
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ), sex(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)
      integer i, eop, gen2  
C
C functions
      integer eow
C
      eop=eow(pedigree)
      gen2=gene+1

      if (plevel.ge.0) then
        call describe(locnam,gene,pedigree,id,fa,mo,sex,locus,
     &                currf,currm,sta,fin,errtyp)
      else
        call inderr(pedigree, eop, id(currf), locnam, 
     &            int(locus(currf,gene)),int(locus(currf,gen2)))
        call inderr(pedigree, eop, id(currm), locnam, 
     &            int(locus(currm,gene)),int(locus(currm,gen2)))
        if (badchild.ne.MISS) then
           call inderr(pedigree, eop, id(badchild), locnam, 
     &            int(locus(badchild,gene)),int(locus(badchild,gen2)))
        else
          do 5 i=sta,fin
            call inderr(pedigree, eop, id(i), locnam, 
     &             int(locus(i,gene)),int(locus(i,gen2)))
    5     continue
        end if
      end if
      return
      end
C end-of-famerr
C
C write genotype for an individual flagged as a Mendelian error
C
      subroutine inderr(pedigree, eop, cid, locnam, all1, all2)
      integer MISS
      parameter (MISS=-9999)
      integer all1, all2, eop
      character*10 pedigree
      character*20 locnam
      character*10 cid
      character*7 gtp
C
      if (all1.eq.MISS) return

      call wrgtp(all1, all2, gtp,1)
      write(*,'(3a,1x,a,1x,2a)') pedigree(1:eop),'-',cid,
     &      locnam, gtp, ' Possible Mendelian error'
      return
      end
C end-of-inderr
C
C Drop a genotype from data if causing inconsistency
C
      subroutine remove(idx,gene,locus,ndiscard)

      integer KNOWN,MAXLOC,MAXSIZ,MISS
      parameter (KNOWN=0,MAXLOC=10000,MAXSIZ=20,MISS=-9999)
      integer gene, idx, ndiscard
      double precision locus(MAXSIZ,MAXLOC)
C
      if (locus(idx,gene).gt.KNOWN) then
        ndiscard=ndiscard+1
        locus(idx,gene)=MISS
        locus(idx,gene+1)=MISS
      end if
      return
      end
C end-of-remove
C
C drop a nuclear family's genotypes
C
      subroutine remfam(currf,currm,sta,fin,gene,locus,ndiscard)

      integer MAXLOC,MAXSIZ
      parameter (MAXLOC=10000,MAXSIZ=20)
      integer currf, currm, fin, gene, ndiscard, sta
      double precision locus(MAXSIZ,MAXLOC)

      integer i

      call remove(currf,gene,locus,ndiscard)
      call remove(currm,gene,locus,ndiscard)
      do 10 i=sta,fin
        call remove(i,gene,locus,ndiscard)
   10 continue
      return 
      end
C end-of-remfam
C
C set an entire family's genotypes to uninformative
C
      subroutine setall(gene,num,locus,val)
      integer MAXLOC,MAXSIZ
      parameter (MAXLOC=10000,MAXSIZ=20)
      integer gene
      double precision val, locus(MAXSIZ,MAXLOC)

      integer gen2, i
      
      gen2=gene+1
      do 10 i=1, num
        locus(i,gene)= val
        locus(i,gen2)= val
   10 continue
      return 
      end
C end-of-remall
C
C If Lange-Goradia algorithm not used, initialize genotypes for random walk
C algorithms via a conditional gene dropping algorithm
C
      subroutine start(maxtry,locnam,xlinkd,gene,pedigree,num,nfound,
     2                 id,fa,mo,sex,locus,numal,name,cumfrq,
     3                 set,sibd,key,inconsist,plevel)
      integer MAXLOC, MAXSIZ, MISS, MAXALL
      parameter(MAXLOC=10000, MAXSIZ=20, MISS=-9999, MAXALL=2)
      integer gene, inconsist, maxtry, plevel
C
C  Pedigree structure
      character*10 pedigree
      integer num,nfound 
      character*10 id(MAXSIZ) 
      integer fa(MAXSIZ),mo(MAXSIZ),sex(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)
C allele frequencies structure
      character*20 locnam
      logical xlinkd
      integer numal, name(MAXALL)
      double precision cumfrq(MAXALL)
      integer set(MAXSIZ,2), key(2*MAXSIZ), sibd(MAXSIZ,2)
C local variables
      integer found, g1, g2, gen2, i, failid, restart
      logical fin, xmale
C functions
      integer eow, getnam


      found=0
      gen2=gene+1
      failid=MISS
      do 5 i=1, num
        if (locus(i,gene).lt.0) then
          g1=MISS
          g2=MISS
        else
          g1=getnam(locus(i,gene),numal,name)
          g2=getnam(locus(i,gen2),numal,name)
        end if
        call update(i,g1,g2,set)
    5 continue
      do 10 i=1,nfound
        found=found+1
        sibd(i,1)=found
        found=found+1
        sibd(i,2)=found
   10 continue
C
C start of loop -- terminated by either a successful simulation
C of ibd, or bailout due <maxtry> iterations without success
C
      restart=0
   40 continue
        found=0
        do 45 i=1,nfound
          found=found+1
          key(found)=set(i,1)
          found=found+1
          key(found)=set(i,2)
   45   continue
        do 46 i=nfound+1,num
          sibd(i,1)=MISS
          sibd(i,2)=MISS
   46   continue

   50   continue
          fin=.true.
          do 70 i=nfound+1,num
          if (sibd(i,1).eq.MISS) then
            if (sibd(fa(i),1).ne.MISS .and. sibd(mo(i),1).ne.MISS) then
              xmale=(xlinkd.and.sex(i).ne.2)
              call genof3(i,fa(i),mo(i),xmale,set,sibd,key,failid)
              if (failid.ne.MISS) then
                if (restart.lt.maxtry) then
                  restart=restart+1
                  if (plevel.gt.1) 
     2              write(*,*) 'Restart ',restart,' due to person ',
     3                pedigree,'-',id(failid),set(i,1),set(i,2)
                  goto 40
                else
                  write(*,'(4a/7x,3a,3(/7x,a)/)') 
     2    'ERROR: Unable to generate starting genotypes at locus ',
     3    locnam(1:eow(locnam)),' for pedigree ', pedigree,
     4    'due to parent(s) of person ',id(failid)(1:eow(id(failid))),
     5    '.','This is either due to a Mendelian inconsistency, ',
     6    'or because the pedigree is very large,',
     7    'in which case it may disappear if the job is rerun.'

                  inconsist=inconsist+1
                  return
                end if
              end if
            else
              fin=.false.
            end if
          end if
   70     continue
      if (.not.fin) goto 50
C
      call fillin(num,nfound,set,sibd,key,name,cumfrq,gene,locus)
C     if (plevel.gt.2) then
C       do 100 i=1, nfound
C         write(*,*) pedigree, id(i), ' x x ',
C    &               locus(i,1), locus(i,2), sibd(i,1), sibd(i,2)
C 100   continue
C       do 101 i=nfound+1, num
C         write(*,*) pedigree, id(i), id(fa(i)), id(mo(i)), 
C    &               locus(i,1), locus(i,2), sibd(i,1), sibd(i,2)
C 101   continue
C     end if
      return
      end
C end-of-start
C
C  Drop ibd-alleles conditional on observed markers
C  and randomly where marker genotype not observed -- restart
C  if later generates inconsistency
C 
      subroutine genof3(idx,fa,mo,xmale,set,sibd,key,failid)
      integer MAXSIZ, MISS
      parameter(MAXSIZ=20, MISS=-9999)
      integer idx,fa,mo,failid
      integer set(MAXSIZ,2),sibd(MAXSIZ,2),key(2*MAXSIZ)
      logical xmale
      integer a1,a2,first,maxtrials,second,tr1,tr2,trials
C sample without replacement from {{1,2},{1,2},{1,2}}
      integer choice, seed, space(8)
C functions
      integer irandom
C
      failid=MISS
      maxtrials=8
      trials=0
      do 10 i=1,maxtrials
        space(i)=i
   10 continue

    1 continue

      trials=trials+1
      choice=irandom(trials, maxtrials)
      seed=space(choice)
      space(choice)=space(trials)

#if defined (F2C) || defined (SUN)
      tr1=and(seed,4)/4+1
      tr2=and(seed,2)/2+1
      first=and(seed,1)+1
#else
      tr1=iand(seed,4)/4+1
      tr2=iand(seed,2)/2+1
      first=iand(seed,1)+1
#endif /* F2C */

      second=3-first
      a1=sibd(fa,tr1)
      a2=sibd(mo,tr2)
      if (xmale) a1=a2
C
C test for loop
C
      if (a1.eq.a2 .and. set(idx,1).ne.set(idx,2)) then
        if (trials.lt.maxtrials) goto 1
        failid=idx
        return
      end if
C
      if (set(idx,1).eq.MISS) then
        sibd(idx,1)=a1
        sibd(idx,2)=a2
      elseif (key(a1).eq.MISS .and. key(a2).eq.MISS) then
        key(a1)=set(idx,first)
        key(a2)=set(idx,second)
        sibd(idx,1)=a1
        sibd(idx,2)=a2
      elseif (key(a1).eq.MISS .and. (set(idx,1).eq.key(a2) .or.
     &        set(idx,2).eq.key(a2))) then
        if (set(idx,1).eq.key(a2)) then
          key(a1)=set(idx,2)
          sibd(idx,1)=a2
          sibd(idx,2)=a1
        else
          key(a1)=set(idx,1)
          sibd(idx,1)=a1
          sibd(idx,2)=a2
        end if
      elseif (key(a2).eq.MISS .and. (set(idx,1).eq.key(a1) .or.
     &        set(idx,2).eq.key(a1))) then
        if (set(idx,1).eq.key(a1)) then
          key(a2)=set(idx,2)
          sibd(idx,1)=a1
          sibd(idx,2)=a2
        else
          key(a2)=set(idx,1)
          sibd(idx,1)=a2
          sibd(idx,2)=a1
        end if
      elseif (set(idx,1).eq.key(a1) .and. 
     &        set(idx,2).eq.key(a2)) then
        sibd(idx,1)=a1
        sibd(idx,2)=a2
      elseif (set(idx,1).eq.key(a2) .and. 
     &        set(idx,2).eq.key(a1)) then
        sibd(idx,1)=a2
        sibd(idx,2)=a1
      elseif (trials.lt.maxtrials) then
        goto 1
      else
        failid=idx
      end if
      return
      end
C end-of-genof3
C
C infer missing genotypes based on sibd values after run of start
C
      subroutine fillin(num,nfound,set,sibd,key,name,cumfrq,gene,locus)
      integer MAXALL, MAXLOC, MAXSIZ, MISS
      parameter(MAXALL=2, MAXLOC=10000, MAXSIZ=20, MISS=-9999)
      integer gene
C  Pedigree structure
      integer num, nfound, set(MAXSIZ,2), sibd(MAXSIZ,2), key(2*MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)
C  Cumulative allele frequencies
      integer name(MAXALL)
      double precision cumfrq(MAXALL)
C local variables
      integer g1,g2,gen2,i,tmp

      gen2=gene+1
      do 1 j=1,2*nfound
      if (key(j).eq.MISS) then
        do 2 i=1,num
        if (sibd(i,1).eq.j .and. set(i,1).ne.MISS) then
          key(j)=set(i,1)
        elseif (sibd(i,2).eq.j .and. set(i,2).ne.MISS) then
          key(j)=set(i,2)
        end if
    2   continue
        if (key(j).eq.MISS) then
          call found(cumfrq,g1)
          key(j)=g1
        end if
      end if
    1 continue
C
      do 5 i=1,num
      if (set(i,1).eq.MISS) then
        g1=name(key(sibd(i,1)))
        g2=name(key(sibd(i,2)))
        if (g1.gt.g2) then
          locus(i,gene)=-dfloat(g2)
          locus(i,gen2)=-dfloat(g1)
          tmp=sibd(i,1)
          sibd(i,1)=sibd(i,2)
          sibd(i,2)=tmp
        else
          locus(i,gene)=-dfloat(g1)
          locus(i,gen2)=-dfloat(g2)
        end if
      end if
    5 continue
      return
      end
C end-of-fillin
C
C Excluding genotypes from parental phenoset
C Straight Lange & Goradia AJHG 1987 40: 250-256
C
      subroutine exclude(imp,locnam,xlinkd,gene,pedigree,num,nfound,
     2               id,fa,mo,sex,locus,numal,name,alfrq,set,
     3               ngeno,gset,inconsist,imputd,plevel)
      integer MAXALL,MAXG,MAXLOC,MAXSIZ,MISS,KNOWN
      parameter (MAXALL=2,MAXG=MAXALL*(MAXALL+1)/2, MAXLOC=10000,
     &           MAXSIZ=20, MISS=-9999,KNOWN=0)
      integer imp,gene,inconsist,imputd,plevel 
C Pedigree structure
      character*10 pedigree
      integer num,nfound 
      character*10 id(MAXSIZ) 
      integer fa(MAXSIZ),mo(MAXSIZ),sex(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)
C allele frequencies structure
      character*20 locnam
      logical xlinkd
      integer numal, name(MAXALL)
      double precision alfrq(MAXALL)
C phenoset arrays - parents and propositus; set() carries ngeno's for ped
C if set(pos,2) is nonzero, skip this sibship to pos=set(pos,2)
C 
      integer set(MAXSIZ,2)
      integer ngeno, gset(MAXSIZ,MAXG,2)
C local variables
C currin=prior no. of errors; currf and currm=current parents
C sta,fin=boundaries of current sibship; mxgeno=commonest genotype
C gfrq=genotype freq; mult=2 if heterozygote; mxfrq=freq of commonest geno
C
      integer currin,currf,currm,sta,fin,gen2,mxgeno
      double precision gfrq,mult,mxfrq
C functions 
      integer eow
      double precision getfreq
C
      currin=inconsist
C
C initialize phenosets
      gen2=gene+1
      do 160 i=1,num
        if (locus(i,gene).ne.MISS) then
          set(i,1)=1
          gset(i,1,1)=int(locus(i,gene))
          gset(i,1,2)=int(locus(i,gen2))
        elseif (xlinkd .and. sex(i).eq.1) then
          ngeno=0
          do 165 j=1,numal
            ngeno=ngeno+1
            gset(i,ngeno,1)=name(j)
            gset(i,ngeno,2)=name(j)
  165     continue
          set(i,1)=ngeno
        else
          ngeno=0
          do 170 j=1,numal
          do 170 k=j,numal
            ngeno=ngeno+1
            gset(i,ngeno,1)=name(j)
            gset(i,ngeno,2)=name(k)
  170     continue
          set(i,1)=ngeno
        end if
        set(i,2)=0
  160 continue
C
C locate beginnings and ends of sibships
      sta=nfound+1
      currf=fa(sta)
      currm=mo(sta)
      do 175 i=nfound+1,num
      if (fa(i).ne.currf .or. mo(i).ne.currm) then
        currf=fa(i)
        currm=mo(i)
        set(sta,2)=i
        sta=i
      end if
  175 continue
C last is special case
      set(sta,2)=num+1   
C
C loop through all nuclear families until all phenosets finalised
C
      call exc(locnam,xlinkd,gene,pedigree,num,nfound,
     2         id,fa,mo,sex,locus,set,ngeno,gset,
     3         currf,currm,sta,fin,inconsist,plevel)
C
C update workfile (compulsory since this replaces old workfile)
C
      if (inconsist.gt.currin) then
        call setall(gene,num,locus,-dfloat(name(1)))
        return
      else if (imp.eq.2 .or. imp.eq.5) then
        do 190 i=nfound+1,num
        if (set(i,2).ne.0) then
          currf=fa(i)
          currm=mo(i)
          if (set(currf,1).eq.2.and.set(currm,1).eq.2) then
            if (gset(currf,1,1).eq.gset(currm,1,1) .and. 
     2          gset(currf,1,2).eq.gset(currm,1,2) .and.
     3          gset(currf,2,1).eq.gset(currm,2,1) .and. 
     4          gset(currf,2,2).eq.gset(currm,2,2) ) 
     5      then
              imputd=imputd+2
              if (plevel.gt.0) then
                write(*,'(/6a/7x,3a,2(a,i3,a1,i3)/)')
     2            'NOTE:  Imputed spouses ',id(currf),' and ',id(currm),
     3            ' in pedigree ',pedigree(1:eow(pedigree)),
     4            'at locus "',locnam(1:eow(locnam)),'"',' to be ',
     5            gset(currf,1,1),'/',gset(currf,1,2),' and ',
     6            gset(currf,2,1),'/',gset(currf,2,2)
              end if
              locus(currf,gene)= -dfloat(gset(currf,1,1))
              locus(currf,gen2)= -dfloat(gset(currf,1,2))
              locus(currm,gene)= -dfloat(gset(currf,2,1))
              locus(currm,gen2)= -dfloat(gset(currf,2,2))
            end if
          end if
        end if
  190   continue
      end if
C
C write out phenosets for untyped individuals and update imputed loci
C
      if (imp.ne.4) then
        do 195 i=1,num
        if (locus(i,gene).le.KNOWN) then
          ngeno=set(i,1)
          if (ngeno.eq.1) then
            imputd=imputd+1
            if (plevel.gt.0) then
              write(*,'(/7a,i3,a1,i3/)')
     2          'NOTE:  Imputed person ',pedigree(1:eow(pedigree)),'-',
     3          id(i)(1:eow(id(i))),' at locus "',locnam(1:eow(locnam)),
     4          '" to be ', gset(i,1,1),'/',gset(i,1,2)
            end if
            locus(i,gene)=dfloat(gset(i,1,1))
            locus(i,gen2)=dfloat(gset(i,1,2))
          end if
        end if
  195   continue
      end if
      if (plevel.gt.1) then
        call wrset(locnam,pedigree,num,id,set,gset)
      end if
C
C Now sequentially initialise so-far untyped individuals to be a 
C likely genotype.  Move through the pedigree, impute
C the current untyped individual, prune genotypes for the remaining
C untyped individuals thus made illegal, until end of pedigree.
C Denote initialised genotypes with negative allele values.
C
C Do not perform sequential imputation if Mendelian errors detected or imp>3.
C
C If failure of sequential imputation, switch to MC start() algorithm
C
      if (imp.gt.3 .or. inconsist.gt.currin) return

      do 200 i=1,num
        if (set(i,1).gt.1) then
          ngeno=set(i,1)
          mxfrq=0.0d0
          do 210 j=1,ngeno
            mult=2.0d0
            if (gset(i,j,1).eq.gset(i,j,2)) mult=1.0d0
            gfrq= mult*getfreq(gset(i,j,1),numal,name,alfrq)*
     &            getfreq(gset(i,j,2),numal,name,alfrq)
            if (gfrq.gt.mxfrq) then
              mxfrq=gfrq
              mxgeno=j
            end if
  210     continue
          locus(i,gene)= -dfloat(gset(i,mxgeno,1))
          locus(i,gen2)= -dfloat(gset(i,mxgeno,2))
          set(i,1)=1
          gset(i,1,1)= gset(i,mxgeno,1)
          gset(i,1,2)= gset(i,mxgeno,2)
          call exc(locnam,xlinkd,gene,pedigree,num,nfound,
     2             id,fa,mo,sex,locus,set,ngeno,gset,
     3             currf,currm,sta,fin,inconsist,-2)
C
C if only one genotype in phenoset but locus not yet updated then update
        elseif (locus(i,gene).eq.MISS) then
          locus(i,gene)= -dfloat(gset(i,1,1))
          locus(i,gen2)= -dfloat(gset(i,1,2))
        end if
C
C check for failure of algorithm -- may need to switch to start()
        if (inconsist.gt.currin) then
          inconsist=currin
          imp=imp+4
          return
        end if
  200 continue
      return      
      end
C end-of-exclude
C
C write out phenoset
C
      subroutine wrset(locnam,pedigree,num,id,set,gset)
      integer MAXALL,MAXG,MAXSIZ
      parameter(MAXALL=2,MAXG=MAXALL*(MAXALL+1)/2,MAXSIZ=20)
      integer num,set(MAXSIZ,2)
      character*10 id(MAXSIZ)
      integer gset(MAXSIZ,MAXG,2)
      character*10 pedigree
      character*20 locnam
      integer i,j,ngeno
C functions
      integer eow
      write(*,'(/4a/a/a)') 
     2  'Phenosets for locus ',locnam(1:eow(locnam)),
     3  ' in pedigree ',pedigree, 'ID         Count    Legal Genotypes',
     4                            '---------- -------- ---------------'
      do 10 i=1,num
        ngeno=set(i,1)
        write(*,'(a10,1x,i8,7(1x,i3,a1,i3):)') id(i),ngeno,
     &    (gset(i,j,1),'/',gset(i,j,2),j=1,min(ngeno,7))
   10 continue
      write(*,*)
      return
      end
C end-of-wrset
C
C perform exclusion for the pedigree regardless of imputation level
C
      subroutine exc(locnam,xlinkd,gene,pedigree,num,nfound,
     2               id,fa,mo,sex,locus,set,ngeno,gset,
     3               currf,currm,sta,fin,inconsist,plevel)
      integer MAXALL,MAXG,MAXSIZ,MAXLOC
      parameter (MAXALL=2,MAXG=MAXALL*(MAXALL+1)/2,MAXSIZ=20,
     &           MAXLOC=10000)
      integer gene, sta, fin, currf, currm, inconsist, plevel
      logical xlinkd
C part of pedigree structure
      character*10 pedigree
      character*20 locnam
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ), sex(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)
C pointers to sibships
      integer set(MAXSIZ,2)
C arrays to contain full phenosets for all pedigree members
      integer ngeno,gset(MAXSIZ,MAXG,2)
C local variables
      logical change,complete
      integer it,incon
C functions
      integer eow
C
      it=0
    1 continue
        change=.false.
        complete=.true.
        sta=nfound+1
        it=it+1
        if (plevel.gt.2) then
          write(*,'(/5a,i2/)') 'Pedigree ',pedigree,' locus ',locnam,
     &     ' Iteration ',it
        end if
C
C One iteration of pedigree - sibship by sibship
C
    5   continue
        if (sta.gt.num) goto 15
        if (set(sta,2).lt.0) then
           sta=-set(sta,2)
           goto 5
         end if
          currf=fa(sta)
          currm=mo(sta)
          fin=set(sta,2)-1
          if (plevel.gt.2) then
            write(*,'(4(a,a10))') 
     2        'Nuclear family: ',id(currf),' x ',id(currm),
     3        '   Off: ',id(sta),' to ',id(fin)
          end if
          incon=0
          call landg(xlinkd,sta,fin,sex,set,ngeno,gset,currf,currm,
     &               change,incon)
C
C check to see if completely unambiguous -- skip in future if true
C
          complete=.true.
          if (set(currf,1).gt.1.or.set(currm,1).gt.1) then
            complete=.false.
          else
            do 25 i=sta,fin
            if (set(i,1).gt.1) then
              complete=.false.
              goto 26
            end if
   25       continue
   26       continue
          end if
          if (complete) set(sta,2)=-fin-1
C
C Check for inconsistencies.
C If being used to generate starting genotypes, 
C don't print a worrying message.
C Old behaviour was to continue looking for errors, but probably cheapest
C to bail out now, as most are fall-out from the first inconsistency.
C
          if (incon.gt.0) then
            inconsist=inconsist+incon
            if (plevel.gt.-2) then
              write(*,'(/5a/)') 
     2          'NOTE:  Mendelian inconsistency in pedigree ',
     3           pedigree(1:eow(pedigree)),' at locus "',
     4           locnam(1:eow(locnam)),'".'
              call describe(locnam,gene,pedigree,id,fa,mo,sex,locus,
     &                      currf,currm,sta,fin,10)
              call famset(pedigree,currf,currm,sta,fin,gene,num,nfound,
     &                    id,fa,mo,locus,set,gset)
            end if
            return
          end if
C increment to next sibship
          sta=fin+1
        
        goto 5
   15   continue
C
C end of iteration through pedigree
        if (plevel.gt.2) then
          call wrset(locnam,pedigree,num,id,set,gset)
        end if
      if (change) goto 1
      return
      end
C end-of-exc
C
C 2nd version of impute -- following Lange & Goradia, 1987
C
      subroutine landg(xlinkd,sta,fin,sex,set,ngeno,gset,currf,currm,
     &                 change,incon)

      integer MAXALL,MAXG,MAXSIZ
      parameter (MAXALL=2,MAXG=MAXALL*(MAXALL+1)/2,MAXSIZ=20)
      integer sta, fin, currf, currm
      integer sex(MAXSIZ), set(MAXSIZ,2)
      integer ngeno,gset(MAXSIZ,MAXG,2)
      logical chachi,change,con,pcon,xlinkd,xmale
C
      logical keep(MAXG),keep2(MAXG)
      integer i,j,k,l,ngeno1,ngeno2,totgen
C functions
      integer parcon
C
      xmale=.false.
      ngeno1=set(currf,1)
      ngeno2=set(currm,1)
      totgen=ngeno1+ngeno2
C
C first prune parental genotypes inconsistent with children
C
      do 5 j=1,ngeno1
    5   keep(j)=.false.
      do 6 k=1,ngeno2
    6   keep2(k)=.false.
      do 10 j=1,ngeno1
      do 10 k=1,ngeno2
        pcon=.true.
        do 15 i=sta,fin
          ngeno=set(i,1)
          xmale=(xlinkd .and. sex(i).ne.2)
          con=.false.
          do 16 l=1,ngeno
          if (parcon(gset(i,l,1),gset(i,l,2),gset(currf,j,1),
     2        gset(currf,j,2),gset(currm,k,1),gset(currm,k,2),
     3        xmale).gt.0) then
            con=.true.
          end if
   16     continue
          if (.not.con) then
            pcon=.false.
            goto 17
          end if
   15   continue
   17   continue
C
C save this parental genotype if consistent
C
        if (pcon) then
          keep(j)=.true.
          keep2(k)=.true.
        end if
   10 continue
      call prune(currf,ngeno1,gset,keep)
      call prune(currm,ngeno2,gset,keep2)
      if (totgen.ne.(ngeno1+ngeno2)) then
        change=.true.
        set(currf,1)=ngeno1
        set(currm,1)=ngeno2
        if (ngeno1.eq.0) then
          incon=incon+1
        end if
        if (ngeno2.eq.0) then
          incon=incon+1
        end if
      end if
C
C then examine each child's phenoset and remove genotypes inconsistent
C with the current parental phenosets
C
      do 25 i=sta,fin
        ngeno=set(i,1)
        xmale=(xlinkd .and. sex(i).ne.2)
        if (ngeno.gt.1) then
          do 26 l=1,ngeno
            keep(l)=.false.
            do 26 j=1,ngeno1
            do 26 k=1,ngeno2
            if (parcon(gset(i,l,1),gset(i,l,2),gset(currf,j,1),
     2          gset(currf,j,2),gset(currm,k,1),gset(currm,k,2),
     3          xmale).gt.0) then
              keep(l)=.true.
            end if
   26     continue
C see if any alterations made
          chachi=.false.
          do 27 l=1,ngeno
          if (.not.keep(l)) then
            chachi=.true.
            goto 28
          end if
   27     continue
   28     continue
          if (chachi) then
            change=.true.
            call prune(i,ngeno,gset,keep)
            set(i,1)=ngeno
            if (ngeno.eq.0) then
              incon=incon+1
            end if
          end if
        end if
   25 continue
      return
      end
C end-of-landg
C
C remove unwanted genotypes from phenoset
C
      subroutine prune(idx,ngeno,gset,keep)
      integer MAXALL,MAXG,MAXSIZ
      parameter (MAXALL=2,MAXG=MAXALL*(MAXALL+1)/2,MAXSIZ=20)
      integer idx, ngeno, gset(MAXSIZ,MAXG,2)
      logical keep(MAXG)
      integer old,nkept
      nkept=0
      do 20 old=1,ngeno
      if (keep(old)) then
        nkept=nkept+1
        if (nkept.ne.old) call swapg(idx,gset,old,nkept)
      end if
   20 continue
C Mark end of old phenoset, so can print out if later needed
      gset(idx,ngeno+1,1)=0
      ngeno=nkept
      return
      end
C end-of-prune
C
C swap two genotypes within a phenoset array
C
      subroutine swapg(idx,gset,j,k)
      integer MAXALL,MAXG,MAXSIZ
      parameter (MAXALL=2,MAXG=MAXALL*(MAXALL+1)/2,MAXSIZ=20)
      integer idx,j,k,gset(MAXSIZ,MAXG,2)
      integer tmp
      tmp=gset(idx,j,1)
      gset(idx,j,1)=gset(idx,k,1)
      gset(idx,k,1)=tmp
      tmp=gset(idx,j,2)
      gset(idx,j,2)=gset(idx,k,2)
      gset(idx,k,2)=tmp
      return
      end
C end-of-swapg
C
C Tests if child genotype consistent with parental genotypes:
C parcon=4*Pr(Child_genotype|Father_genotype,Mother_genotype)
C if xmale  TRUE then X-linked locus *and* male child
C
      integer function parcon(c1,c2,p11,p12,p21,p22,xmale)
      integer c1,c2,p11,p12,p21,p22
      logical xmale 
      parcon=0
      if (xmale) then
        if (c1.eq.p21) parcon=parcon+2
        if (c1.eq.p22) parcon=parcon+2
        return
      end if
      if ((c1.eq.p11 .and. c2.eq.p21) .or. (c1.eq.p21 .and. c2.eq.p11)) 
     &  parcon=parcon+1
      if ((c1.eq.p11 .and. c2.eq.p22) .or. (c1.eq.p22 .and. c2.eq.p11))
     &  parcon=parcon+1
      if ((c1.eq.p12 .and. c2.eq.p21) .or. (c1.eq.p21 .and. c2.eq.p12))
     &  parcon=parcon+1
      if ((c1.eq.p12 .and. c2.eq.p22) .or. (c1.eq.p22 .and. c2.eq.p12))
     &  parcon=parcon+1
      return
      end
C end-of-parcon
C
C test if child genotype consistent with one parental genotype
C
      logical function opcon(c1,c2,p1,p2)
      integer c1,c2,p1,p2
      opcon=.false.
      if (c1.eq.p1 .or. c1.eq.p2 .or. c2.eq.p1 .or. c2.eq.p2) 
     &  opcon=.true.
      return
      end
C end-of-opcon
C
C write out genotypes in nuclear family and grandparents
C
      subroutine describe(locnam,gene,pedigree,id,fa,mo,sex,locus,
     &                    currf,currm,sta,fin,mesg)
      integer MAXSIZ, MAXLOC, MISS, WIDE
      parameter(MAXSIZ=20, MAXLOC=10000, MISS=-9999, WIDE=12)

      integer currf, currm, fin, gene, mesg, sta
      character*20 locnam
      character*10 pedigree
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ), sex(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)
      integer i, eol, eop, gen2, leftm, npars, pos, nsibs
      logical gp1, gp2  
      character*7 gtp
      character*10 chid
      character*128 lin
C
C functions
      integer eow
C
C
C else
C
C Check if useful to view
C
      if (mesg.lt.10) then
        npars=0
        if (locus(currf,gene).ne.MISS) npars=npars+1
        if (locus(currm,gene).ne.MISS) npars=npars+1
        nsibs=0
        do 5 i=sta,fin
        if (locus(i,gene).ne.MISS) then
          nsibs=nsibs+1 
        end if
    5   continue
        if (nsibs.eq.0 .or. (nsibs.eq.1 .and. npars.eq.0)) return
      end if
C
C if useful
C
      gen2=gene+1
      eop=eow(pedigree)
      lin=' '
      write(*,'(3a/a)') 'Locus "',locnam(1:eow(locnam)),'"',
     &                  '------------------'
      write(*,'(8a/)')
     2  'Sibship: ',pedigree(1:eop),'-',id(currf)(1:eow(id(currf))),
     3  ' x ',pedigree(1:eop),'-',id(currm)(1:eow(id(currm))) 
C
C write an edifying message, if supplied
C
      if (mesg.eq.10) then
        write(*,'(a/)') 
     &    'Multigenerational inconsistency between genotypes.'
      elseif (mesg.eq.11) then
        write(*,'(a/)') 
     &    'Inconsistency between parent and child genotypes.'
      elseif (mesg.eq.12) then
        write(*,'(a/)') 
     &    'Multiple inconsistencies between parent and child genotypes.'
      elseif (mesg.eq.13) then
        write(*,'(a/)') 
     &    'Inconsistency between sibling genotypes.'
      elseif (mesg.eq.14) then
        write(*,'(a/)') 
     &    'More than 4 alleles segregating in nuclear family.'
      elseif (mesg.eq.15) then
        write(*,'(a/)') 
     &    'Inconsistency between imputed parent and child genotypes.'
      end if
      gp1=(fa(currf).ne.MISS)
      gp2=(fa(currm).ne.MISS)
C
C Show grandparental generation if useful and present
C
      if (mesg.lt.11 .and. (gp1 .or. gp2)) then
        if (gp1) then
          call wrid('c',id(fa(currf)),chid,sex(fa(currf)))
          lin(17:26)=chid
          call wrid('c',id(mo(currf)),chid,sex(mo(currf)))
          lin(27:36)=chid
          eol=36
        end if
        if (gp2) then
          call wrid('c',id(fa(currm)),chid,sex(fa(currm)))
          lin(37:46)=chid
          call wrid('c',id(mo(currm)),chid,sex(mo(currm)))
          lin(47:56)=chid
          eol=56
        end if
        write(*,'(a)') lin(1:eol)
        lin=' '
        if (gp1) then
          call wrgtp(int(locus(fa(currf),gene)),
     &               int(locus(fa(currf),gen2)),gtp,1)
          lin(18:24)=gtp
          call wrgtp(int(locus(mo(currf),gene)),
     &               int(locus(mo(currf),gen2)),gtp,1)
          lin(28:34)=gtp
          eol=34
        end if
        if (gp2) then
          call wrgtp(int(locus(fa(currm),gene)),
     &               int(locus(fa(currm),gen2)),gtp,1)
          lin(38:44)=gtp
          call wrgtp(int(locus(mo(currm),gene)),
     &               int(locus(mo(currm),gen2)),gtp,1)
          lin(48:54)=gtp
          eol=54
        end if
        write(*,'(a)') lin(1:eol)
        lin=' '
        if (gp1) then
          lin(21:21)='|'
          lin(31:31)='|'
          eol=31
        end if
        if (gp2) then
          lin(41:41)='|'
          lin(51:51)='|'
          eol=51
        end if
        write(*,'(a)') lin(1:eol)
        lin=' '
        if (gp1) then
          lin(21:31)='+====+====+'
          eol=31
        end if
        if (gp2) then
          lin(41:51)='+====+====+'
          eol=51
        end if
        write(*,'(a)') lin(1:eol)
        lin=' '
        if (gp1) then
          lin(26:26)='|'
          eol=26
        end if
        if (gp2) then
          lin(46:46)='|'
          eol=46
        end if
        write(*,'(a)') lin(1:eol)
        lin=' '
      end if
C
C Now the parents of the nuclear family
C
      call wrid('c',id(currf),chid,sex(currf))
      lin(22:31)=chid
      call wrid('c',id(currm),chid,sex(currm))
      lin(42:51)=chid
      write(*,'(a)') lin(1:50)
      lin=' '
      call wrgtp(int(locus(currf,gene)),int(locus(currf,gen2)),gtp,1)
      lin(23:29)=gtp
      call wrgtp(int(locus(currm,gene)),int(locus(currm,gen2)),gtp,1)
      lin(43:49)=gtp
      write(*,'(a)') lin(1:49)
      lin=' '
      write(*,'(25x,a1,19x,a1/25x,a21/35x,a1)')
     &  '|','|','+=========+=========+','|'
C
C Then the children
C
      nsibs=fin-sta+1
      if (nsibs.eq.1) then
        call wrid('c',id(sta),chid,sex(sta))
        call wrgtp(int(locus(sta,gene)),int(locus(sta,gen2)),gtp,1)
        write(*,'(35x,a1/31x,a10/32x,a7)') '|',chid,gtp
      elseif (nsibs.gt.WIDE) then
        do 10 i=sta,fin
          call wrgtp(int(locus(i,gene)),int(locus(i,gen2)),gtp,1)
          write(*,'(28x,a8,1x,a7)') id(i),gtp
   10   continue
      else
        leftm=max(3,38-5*nsibs)
        pos=leftm+3
        do 15 i=1,nsibs-1
          lin(pos:pos+10)='+---------+'
          pos=pos+10
   15   continue
        lin(36:36)='+'
        write(*,'(a)') lin(1:pos)
        lin=' '
        pos=leftm+3
        do 20 i=1,nsibs
          lin(pos:pos)='|'
          pos=pos+10
   20   continue
        write(*,'(a)') lin(1:pos)
        lin=' '
        pos=leftm-1
        do 25 i=sta,fin
          call wrid('c',id(i),chid,sex(i))
          lin(pos:pos+9)=chid
          pos=pos+10
   25   continue
        write(*,'(a)') lin(1:pos)
        lin=' '
        pos=leftm
        do 30 i=sta,fin
          call wrgtp(int(locus(i,gene)),int(locus(i,gen2)),gtp,1)
          lin(pos:pos+6)=gtp
          pos=pos+10
   30   continue
        write(*,'(a)') lin(1:pos)
      end if
      write(*,*)
      return
      end
C end-of-describe
C
C Write out phenoset for a nuclear family (plus grandparents and halfsibs)
C Useful in detecting sources of long distance Mendelian inconsistencies.
C
      subroutine famset(pedigree,currf,currm,sta,fin,gene,num,nfound,
     &                  id,fa,mo,locus,set,gset)
      integer MAXALL,MAXG,MAXLOC,MAXSIZ,MISS
      parameter(MAXALL=2,MAXG=MAXALL*(MAXALL+1)/2,MAXLOC=10000,
     &          MAXSIZ=20,MISS=-9999)
      integer currf, currm, fin, gene, num, nfound, sta
      character*10 pedigree
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)
      integer set(MAXSIZ,2), gset(MAXSIZ,MAXG,2)

      integer g1,g2,gen2,gfa,gmo,i
      logical found
C functions
      logical allinset

      gen2=gene+1

      write(*,'(a/a)') 'ID       Count    Problem phenosets',
     &                 '-------- -------- -----------------'
C Grandparental phenosets
      if (fa(currf).ne.MISS) then
        write(*,'(/a)') 'Paternal Gparents'
        call indset(fa(currf),gene,id,locus,set,gset)
        call indset(mo(currf),gene,id,locus,set,gset)
      end if
      if (fa(currm).ne.MISS) then
        write(*,'(/a)') 'Maternal Gparents'
        call indset(fa(currm),gene,id,locus,set,gset)
        call indset(mo(currm),gene,id,locus,set,gset)
      end if
C Uncles and aunts phenosets
      if (fa(currf).ne.MISS) then
        gfa=fa(currf)
        gmo=mo(currf)
        found=.false.
        do 20 i=nfound+1,num
        if (fa(i).eq.gfa .and. mo(i).eq.gmo .and. i.ne.currf) then
          if (.not.found) then
            write(*,'(/a)') 'Paternal Uncles/Aunts'
            found=.true.
          end if
          call indset(i,gene,id,locus,set,gset)
        end if  
   20   continue
      end if
      if (fa(currm).ne.MISS) then
        gfa=fa(currm)
        gmo=mo(currm)
        found=.false.
        do 30 i=nfound+1,num
        if (fa(i).eq.gfa .and. mo(i).eq.gmo .and. i.ne.currm) then
          if (.not.found) then
            write(*,'(/a)') 'Maternal Uncles/Aunts'
            found=.true.
          end if
          call indset(i,gene,id,locus,set,gset)
        end if  
   30   continue
      end if
C Parental phenosets
      write(*,'(/a)') 'Father'
      call indset(currf,gene,id,locus,set,gset)
      write(*,'(/a)') 'Mother'
      call indset(currm,gene,id,locus,set,gset)
C Sibship phenosets
      write(*,'(/a)') 'Children'
      do 10 i=sta,fin
        call indset(i,gene,id,locus,set,gset)
   10 continue
C Half-sib phenosets
      found=.false.
      do 40 i=nfound+1,num
      if (fa(i).eq.currf .and. mo(i).ne.currm) then
        if (.not.found) then
          write(*,'(/a)') 'Paternal Half-sibs'
          found=.true.
        end if
        call indset(i,gene,id,locus,set,gset)
      end if  
   40 continue
      found=.false.
      do 50 i=nfound+1,num
      if (fa(i).ne.currf .and. mo(i).eq.currm) then
        if (.not.found) then
          write(*,'(/a)') 'Maternal Half-sibs'
          found=.true.
        end if
        call indset(i,gene,id,locus,set,gset)
      end if  
   50 continue
      write(*,*)
C
C See if single allele might explain inconsistency between untyped parent 
C and offspring
C
      do 100 i=sta,fin
      if (locus(i,gene).ne.MISS) then
        g1=int(locus(i,gene))
        g2=int(locus(i,gen2))
        if (set(currf,1).eq.0) then
          call cntbad(currf,ngeno,gset)
          if (.not.allinset(currf,g1,ngeno,gset)) then
            call wroddall(pedigree,id(currf),id(i),g1)
          end if
          if (.not.allinset(currf,g2,ngeno,gset)) then
            call wroddall(pedigree,id(currf),id(i),g1)
          end if
        end if
        if (set(currm,1).eq.0) then
          call cntbad(currm,ngeno,gset)
          if (.not.allinset(currm,g1,ngeno,gset)) then
            call wroddall(pedigree,id(currm),id(i),g1)
          end if
          if (.not.allinset(currm,g2,ngeno,gset)) then
            call wroddall(pedigree,id(currm),id(i),g2)
          end if
        end if
      end if
  100 continue
      write(*,*)
      return
      end
C end-of-famset
C
C write out phenoset for an individual 
C
      subroutine indset(idx,gene,id,locus,set,gset)
      integer MAXALL,MAXG,MAXLOC,MAXSIZ,MISS
      parameter(MAXALL=2,MAXG=MAXALL*(MAXALL+1)/2,MAXLOC=10000,
     &          MAXSIZ=20,MISS=-9999)
      integer gene, idx, set(MAXSIZ,2)
      character*10 id(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)
      integer gset(MAXSIZ,MAXG,2)
      integer gen2,i,ngeno

      gen2=gene+1
      if (locus(idx,gene).ne.MISS) then
        write(*,'(a10,1x,a8,1x,i3,a1,i3)') id(idx),'Typed',
     &    int(locus(idx,gene)), '/', int(locus(idx,gen2))
      elseif (set(idx,1).eq.0) then
        call cntbad(idx,ngeno,gset)
        write(*,'(a10,1x,a8,7(1x,i3,a1,i3):)') id(idx),'Problem',
     &    (gset(idx,i,1),'/',gset(idx,i,2),i=1,min(ngeno,7))
      else
        ngeno=set(idx,1)
        write(*,'(a10,1x,i8,7(1x,i3,a1,i3):)') id(idx),ngeno,
     &    (gset(idx,i,1),'/',gset(idx,i,2),i=1,min(ngeno,7))
      end if
      return
      end
C end-of-indset
C
C see if particular allele in phenoset for idx person
C
      logical function allinset(idx,iall,ngeno,gset)
      integer MAXALL,MAXG,MAXSIZ
      parameter(MAXALL=2,MAXG=MAXALL*(MAXALL+1)/2,MAXSIZ=20)
      integer iall, idx, ngeno
      integer gset(MAXSIZ,MAXG,2)

      integer i

      allinset=.true.
      do 10 i=1,ngeno
      if (gset(idx,i,1).eq.iall .or. gset(idx,i,2).eq.iall) then
        return
      end if
   10 continue
C else if not found
      allinset=.false.
      return
      end
C end-of-allinset
C
C If phenoset contains zero legal genotypes, reconstruct last state
C
      subroutine cntbad(idx,ngeno,gset)
      integer MAXALL,MAXG,MAXSIZ
      parameter(MAXALL=2,MAXG=MAXALL*(MAXALL+1)/2,MAXSIZ=20)
      integer idx, ngeno
      integer gset(MAXSIZ,MAXG,2)
      integer i

      do 10 i=1,MAXG
        if (gset(idx,i,1).eq.0) then
          ngeno=i-1
          return 
        end if
   10 continue
      ngeno=0
      return
      end
C end-of-cntbad
C
C If find an odd-allele-out, write out its location
C
      subroutine wroddall(pedigree,parent,child,iall)
      character*10 pedigree
      character*10 parent, child
      integer iall
      integer eop
C functions
      integer eow

      eop=eow(pedigree)

      write(*,'(5a,i3,5a)') 'Parent ',pedigree(1:eop),'-',
     2  parent(1:eow(parent)), ' cannot carry the ',
     3  iall,' allele found in child ',
     4  pedigree(1:eop),'-',child(1:eow(child)),'.'
      return
      end
C end-of-wroddall
C
C Check if MZ twins have different genotypes
C
      subroutine mzgtp(wrk,mztwin,gt,thresh,pedigree,actset,num,nfound,
     2             id,fa,mo,sex,locus,numloc,nloci,loc,loctyp, locpos)
      integer MAXALL,MAXSIZ,MAXLOC,KNOWN
      parameter (MAXALL=2,MAXSIZ=20,MAXLOC=10000,KNOWN=0)

      integer gt
      integer mztwin, wrk
      double precision thresh
C Pedigree structure
      integer actset,num, nfound
      character*10 pedigree
      character*10 id(MAXSIZ) 
      integer fa(MAXSIZ), mo(MAXSIZ), sex(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)
      integer numloc
C
C locus structure
      integer nloci
      character*20 loc(MAXLOC)
      integer loctyp(MAXLOC),locpos(MAXLOC)
C
      logical last, samefa, samemo
      integer g1, g2, g3, g4, gene, i, j, k, npairs
      integer err(MAXLOC), tot(MAXLOC)
      character*7 gtp1, gtp2
C functions
      double precision isaff
C
      npairs=0
      pedigree=' '
      do 1 i=1, MAXLOC
        err(i)=0
        tot(i)=0
    1 continue
      last=.false.
      rewind(wrk)
C
      write(*,'(4(/a))')
     2  '------------------------------------------------------------',
     3  'Checking for MZ discordance at marker loci',
     4  '------------------------------------------------------------',
     5  'Pedigree    Person1  Person2  Locus       Geno1   Geno2'
    5 continue
       call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &            numloc, last)
       if (last) goto 20

        if (actset.le.0) goto 5
C
C only iterate nonfounders
        do 10 i=nfound+1,num-1
          do 15 j=i+1,num
            samefa=(fa(i).eq.fa(j))
            samemo=(mo(i).eq.mo(j))
C
C Share parents and zygosity indicator
C
            if (samefa.and.samemo .and. 
     2          int(isaff(locus(i,mztwin),thresh,gt)).eq.2 .and.
     3          int(isaff(locus(j,mztwin),thresh,gt)).eq.2) then
              con=0
              den=0
              do 30 k=1,nloci
              if (loctyp(k).eq.1 .or. loctyp(k).eq.2) then
                gene=locpos(k)
                g1=int(locus(i,gene))
                g3=int(locus(j,gene))
                if (g1.gt.KNOWN .and. g3.gt.KNOWN) then
                  den=den+1
                  g2=int(locus(i,gene+1))
                  g4=int(locus(j,gene+1))
                  tot(k)=tot(k)+1
                  if ((g1.eq.g3 .and. g2.eq.g4).or.
     &                (g1.eq.g4 .and. g2.eq.g3)) then
                    con=con+1
                  else
                    err(k)=err(k)+1
                    call wrgtp(g1,g2,gtp1,1)
                    call wrgtp(g3,g4,gtp2,1)
                    write(*,'(3(1x,a),1x,a10,2(1x,a))') 
     2                pedigree, id(i), id(j), loc(k), gtp1, gtp2
                  end if
                end if
              end if
   30         continue
              if (den.gt.0) then
                npairs=npairs+1
              end if
            end if
   15     continue
   10   continue
      goto 5 
   20 continue
      if (npairs.gt.0) then
        write(*,'(/a/a)') 'Locus     Dis   Pairs  Prop',
     &                    '-------   ----- -----  -------'
        do 50 k=1, nloci
        if (loctyp(k).eq.1 .or. loctyp(k).eq.2) then
          if (tot(k).gt.0) then
            write(*,'(a10, 1x, i5, 1x, i5, 2x, f6.4)') 
     &        loc(k), err(k), tot(k), dfloat(err(k))/dfloat(tot(k))
          end if
        end if
   50   continue
      else
        write(*,'(/a)') 'No useful monozygotic twin pairs.'
      end if
      return
      end
C end-of-mzgtp

C
C See if all members of a pedigree are connected
C
      subroutine connect(num,fa,mo,set,nsub,maxgrp)
      integer MAXSIZ,MISS
      parameter(MAXSIZ=20,MISS=-9999)

      integer maxgrp, nsub
      integer num, fa(MAXSIZ), mo(MAXSIZ)
      integer set(MAXSIZ,2)
C local variables
      integer biggrp,i,idx,numgrp
      logical fin
C
      do 1 i=1,num
        set(i,1)=MISS
        set(i,2)=MISS
    1 continue

      biggrp=1
      idx=1
      maxgrp=0
      numgrp=1
      nsub=1
      set(idx,1)=nsub
      set(idx,2)=idx

      if (num.eq.1) return
C
C while able to update, indicate if individual is part of cluster
C connected to index individual
C
    5 continue
        fin=.true.
        do 10 i=1,num
        if (set(i,1).eq.nsub .and. fa(i).ne.MISS) then
          if (set(fa(i),1).eq.MISS) then
            call addlist(fa(i),idx,set)
            numgrp=numgrp+1
            fin=.false.
          end if
          if (set(mo(i),1).eq.MISS) then
            call addlist(mo(i),idx,set)
            numgrp=numgrp+1
            fin=.false.
          end if
        elseif (set(i,1).eq.MISS) then
          if (fa(i).ne.MISS .and. 
     &        (set(fa(i),1).eq.nsub .or. set(mo(i),1).eq.nsub)) then
            call addlist(i,idx,set)
            numgrp=numgrp+1
            fin=.false.
          end if
        end if
   10   continue
      if (.not.fin) goto 5
C
C Test whether ungrouped individuals remain in pedigree
C If yes, initiate new group around a new index and iterate
C
      if (numgrp.gt.maxgrp) then
        biggrp=nsub
        maxgrp=numgrp
      end if
      do 20 i=1,num
      if (set(i,1).eq.MISS) then
        idx=i
        nsub=nsub+1
        set(idx,1)=nsub
        set(idx,2)=idx
        numgrp=1
        goto 5
      end if
   20 continue
C
C Make biggest subpedigree No. 1
C
      if (biggrp.ne.1) then
        do 25 i=1,num
          if (set(i,1).eq.biggrp) then
            set(i,1)=1
          elseif (set(i,1).eq.1) then
            set(i,1)=biggrp
          end if
   25   continue
      end if
      return
      end
C end-of-connect
C
C shift an individual from the list of ungrouped individuals
C to the appropriate group (subpedigree) nucleating around the index person.
C
      subroutine addlist(pos,idx,set)
      integer MAXSIZ
      parameter (MAXSIZ=20)
      integer idx,pos
      integer set(MAXSIZ,2)
C
C add the current person to the list after the index person for that family
C
      set(pos,2)=set(idx,2)
      set(pos,1)=set(idx,1)
      set(idx,2)=pos
      return
      end
C end-of-addlist
C
C find list number <target>
C
      subroutine findlist(target,num,set,pos)
      integer MAXSIZ,MISS
      parameter (MAXSIZ=20,MISS=-9999)
      integer num,pos,target 
      integer set(MAXSIZ,2)
      do 10 pos=1,num
      if (set(pos,1).eq.target) then
        return
      end if
   10 continue
C list not found
      pos=MISS
      return
      end
C end-of-findlist
C
C List the members of pedigree(s)
C
      subroutine wrsubped(pedigree,num,id,key,set,nsub,maxgrp,plevel)
      integer MAXSIZ,MISS
      parameter(MAXSIZ=20,MISS=-9999)

      integer maxgrp, nsub, plevel
      character*10 pedigree  
      character*10 id(MAXSIZ)
      integer num, key(MAXSIZ)
      integer set(MAXSIZ,2)
C local variables
      integer eop,i
C functions
      integer eow
C
      eop=eow(pedigree)
      write(*,'(/3a,i4,a/7x,a,i4,a/)') 'NOTE:  Pedigree ', 
     2  pedigree(1:eop),' contains ',nsub,' disjoint pedigrees.',
     3  'The largest subpedigree contains ',maxgrp,' members.'
      if (num-maxgrp.lt.20 .and. maxgrp.gt.num/3) then
        do 30 i=1,num
        if (set(i,1).ne.1) then
          write(*,'(/5a)') 
     2   'NOTE:  ',pedigree(1:eop),'-', id(key(i))(1:eow(id(key(i)))),
     3   ' is not a member of the main pedigree.' 
        end if
   30   continue
        write(*,*) 
      end if
      if (plevel.gt.1) then
        write(*,'(/a,i3,a/)') 
     &    'Members of largest subpedigree (N=',maxgrp,')'
        do 40 i=1,num
        if (set(i,1).eq.1) then
          write(*,'(3a)') pedigree(1:eop),'-', id(i)(1:eow(id(i)))  
        end if
   40   continue
        write(*,*)
      end if
      return
      end
C end-of-wrsubped
C
C Work out generation number ord().
C Visit every person in each subpedigree in turn.
C The missing value for generation must be a large negative value.
C
      subroutine gener(pedigree,num,fa,mo,nsub,set,ord,higen,
     &                 nerr,plevel)
      integer MAXSIZ,MISGEN,MISS
      parameter (MAXSIZ=20,MISGEN=-9999,MISS=-9999)
      integer higen, nerr, plevel
C Pedigree structure
      character*10 pedigree
      integer num, fa(MAXSIZ), mo(MAXSIZ)
      integer ord(MAXSIZ), set(MAXSIZ,2)
C
C
      integer cfa, cgen, cmo, curped, dit, eop, i, idx, it, maxit
      integer logen, upgen
      logical fin, fin2
C functions
      integer eow

      eop=eow(pedigree)
      higen=1
      maxit=2*num
      do 5 i=1,num
        ord(i)=MISGEN
    5 continue
C
C do each subpedigree in turn
C 
      do 10 curped=1,nsub

      call findlist(curped,num,set,idx)
      upgen=0
      logen=0
      ord(idx)=0
      if (plevel.gt.1) then
        write(*,'(a,i5,a,i5)') 'Evaluating sub-pedigree ',curped,
     &    ' via index person ',idx
      end if 

      it=0
      i=idx
C
C Each iteration moves as far down the pedigree as possible then
C moves up no more than one generation
C
   15 continue
        it=it+1
        fin=.true.
C down leg
        dit=0
  100   continue
          fin2=.true.
          dit=dit+1
          if (dit.gt.maxit) then
            write(*,'(/5a/)') 
     2        'ERROR:  Probable illegal loop (eg own grandfather) ',
     3        'in pedigree ', pedigree(1:eop), '.'
            nerr=1
            return
          end if 

  115     continue      
            if (fa(i).ne.MISS) then
              cfa=fa(i)
              cmo=mo(i)
              cgen=max(ord(cfa),ord(cmo))+1
              if ((ord(cfa).ne.MISGEN .or. ord(cmo).ne.MISGEN) .and.
     2            ord(i).ne.cgen) then
                fin2=.false.
                ord(i)=cgen
              end if
            end if
            i=set(i,2)
          if (i.ne.idx) goto 115

        if (.not.fin2) goto 100
C up leg
  215   continue      
          if (fa(i).ne.MISS) then
            cgen=ord(i)
            if (cgen.ne.MISGEN) then
              cfa=fa(i)
              cmo=mo(i)
              if (ord(cfa).eq.MISGEN .or. 
     &            (fa(cfa).eq.MISS .and. cgen.le.ord(cfa))) then
                ord(cfa)=cgen-1
                fin=.false.
              end if
              if (ord(cmo).eq.MISGEN .or.
     &            (fa(cmo).eq.MISS .and. cgen.le.ord(cmo))) then
                ord(cmo)=cgen-1
                fin=.false.
              end if
            end if
          end if
          i=set(i,2)
        if (i.ne.idx) goto 215
C check if finished and update max and min generation number
      if (.not. fin .and. it.le.maxit) goto 15
      if (it.gt.maxit) then 
        write(*,'(/a,i3,a/7x,4a/)') 
     2    'NOTE:  Exceeded ',maxit,' iterations while calculating',
     3    'generation number for pedigree ', pedigree(1:eop), 
     4    ', subpedigree ',curped
      end if
C
C end of main loop
C
C adjust generation numbering to 1..G for founders, marry-ins etc
C
   20 continue     
        if (ord(i).gt.upgen) then
          upgen=ord(i)
        elseif (ord(i).lt.logen) then
          logen=ord(i)
        end if
        i=set(i,2)
      if (i.ne.idx) goto 20
      logen=1-logen
      upgen=upgen+logen
C
   25 continue
        if (fa(i).eq.MISS) then
          ord(i)=ord(i)+logen
        else
          ord(i)=MISGEN
        end if
        i=set(i,2)
      if (i.ne.idx) goto 25
C
C redo nonfounders, now that all founders set correctly
C
      it=0
   30 continue
        it=it+1
        fin=.true.
C
C if both parents have a known generation number, set index to
C max(fa_gen,mo_gen)+1
C
   35   continue
          if (fa(i).ne.MISS) then
            cfa=fa(i)
            cmo=mo(i)
            if (ord(i).eq.MISGEN) then
              if (ord(cfa).ne.MISGEN .and. ord(cmo).ne.MISGEN) 
     &        then
                ord(i)=max(ord(cfa),ord(cmo))+1
              else
                fin=.false.
              end if
            end if
          end if
          i=set(i,2)
        if (i.ne.idx) goto 35

      if (.not.fin) goto 30

      if (upgen.gt.higen) higen=upgen
C
   10 continue
C
      return
      end
C end-of-gener
C
C Write out pedigrees as list of nuclear families plus marry-ins by
C generation number
C
      subroutine dogen(wrk,twrk,pedigree,actset,num,nfound,id,fa,mo,sex,
     &                 locus, numloc,ord,set,trait,plevel)
      integer MAXSIZ,MAXLOC,MISS
      parameter (MAXSIZ=20,MAXLOC=10000,MISS=-9999)
      integer plevel, trait, twrk, wrk
C Pedigree structure
      character*10 pedigree
      integer actset, num, nfound
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ), sex(MAXSIZ)
      integer ord(MAXSIZ), set(MAXSIZ,2)
      integer numloc
      double precision locus(MAXSIZ,MAXLOC)
      logical last
      integer biggest,curped,deepest,eop,higen,i,maxgrp,nped,nsub,
     &        onegen,onemem,nerr,nobs,totgen
      character*10 bigped, deeped
C functions
      integer eow
C
      biggest=0
      bigped=' '
      deeped=' '
      deepest=0
      nerr=0
      nobs=0
      nped=0
      onegen=0
      onemem=0
      totgen=0
      if (plevel.lt.1) then
        write(*,'(a)') 'Pedigree    Size Fndrs  Gens Disjoint',
     &                 '---------- ----- ----- ----- --------'
      end if

      rewind(wrk)
   10 continue
       call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &            numloc, last)
       if (last) goto 20

        if (actset.gt.0) then
         if (num.gt.1 .or. plevel.gt.1) then
           eop=eow(pedigree)
           call connect(num,fa,mo,set,nsub,maxgrp)
           call gener(pedigree,num,fa,mo,nsub,set,ord,higen,nerr,0)
           if (plevel.gt.0) then
             write(*,'(/a,a10,a,i5,a,i5,a,i2/)') 
     2         'Pedigree ',pedigree,' No=',num,' No founders=',nfound, 
     3         ' No generations=',higen
             if (nsub.gt.1) then
               write(*,'(3x,3a,i4,a/)') 
     2           'Disjoint sub-pedigree ',pedigree(1:eop),
     3           '-001 (largest, N=',maxgrp,')'
             end if
             call wrgen(num,id,fa,mo,1,set,higen,ord)
             if (nsub.gt.1 .and. (nsub.le.10 .or. plevel.gt.0)) then
               do 15 curped=2,nsub
                 write(*,'(/3x,3a,i3.3/)') 
     &             'Disjoint sub-pedigree ',pedigree(1:eop),'-',curped
                 call wrgen(num,id,fa,mo,curped,set,higen,ord)
   15          continue
             end if
           else if (nsub.gt.1) then
             write(*,'(a10,3(1x,i5),3x,a,i4)') 
     &         pedigree, num, nfound, higen, 'y,', nsub
           else
             write(*,'(a10,3(1x,i5))') 
     &         pedigree, num, nfound, higen
           end if
         else
           higen=1
           ord(1)=1
         end if
         if (num.eq.1) onemem=onemem+1
         if (higen.eq.1) onegen=onegen+1
         if (num.gt.biggest) then
           biggest=num
           bigped=pedigree
         end if
         if (higen.gt.deepest) then
           deepest=higen
           deeped=pedigree
         end if
         totgen=totgen+higen
         nped=nped+1
         nobs=nobs+num
C
C save the generation number to a quantitative variable if requested
         if (trait.ne.MISS) then
           do 17 i=1,num
             locus(i,trait)=float(ord(i))
   17      continue
           call wrkout(twrk,pedigree,actset,num,nfound,id,fa,mo,sex,
     &                 locus,numloc)
         end if
        end if
      goto 10
   20 continue
      write(*,'(/a,i5/a,i5)') 
     2  'Total number of pedigrees  = ',nped,
     3  'Number with only 1 member  = ',onemem 
      write(*,'(a,i5,3a/a,i5,3a)') 
     4  'Largest pedigree (members) = ',biggest,
     5  ' (Pedigree ',bigped(1:eow(bigped)),')',
     6  'Deepest pedigree (genrtns) = ',deepest,
     7  ' (Pedigree ',deeped(1:eow(deeped)),')' 
      write(*,'(/a,f5.1/a,f5.1)') 
     2  'Mean size of pedigrees     = ',dfloat(nobs)/dfloat(nped),
     3  'Mean pedigree depth        = ',dfloat(totgen)/dfloat(nped) 
      if (nped.gt.onegen) then
        write(*,'(a,f5.1/a,f5.1)') 
     2  'Mean size where >1 members = ',
     3   dfloat(nobs-onegen)/dfloat(nped-onemem),
     4  'Mean depth where >1 members= ',
     5   dfloat(totgen-onegen)/dfloat(nped-onegen)
      end if
      return
      end
C end-of-dogen
C
C Write out structure and generation numbers
C   List of sibships by generation number
C
      subroutine wrgen(num,id,fa,mo,curped,set,higen,ord)
      integer MAXSIZ,MISS
      parameter (MAXSIZ=20,MISS=-9999)
      integer curped, higen
C Pedigree structure
      integer num
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ)
      integer ord(MAXSIZ), set(MAXSIZ,2)
C
C assorted counters, indices
C
      integer cfa, cmo, eoi, eoi2, i, j, mat, pos
C Functions
      integer eow

      do 20 j=1,higen
        cfa=MISS
        cmo=MISS
        pos=0
        write(*,'(1x,i3,a,$)') j,': '
        do 25 i=1,num
        if (ord(i).eq.j .and. set(i,1).eq.curped) then
          if (fa(i).ne.MISS) then
            if (fa(i).ne.cfa .or. mo(i).ne.cmo) then
              cfa=fa(i)
              cmo=mo(i)
              eoi=eow(id(cfa))
              eoi2=eow(id(cmo))
              mat=eoi+eoi2+12
              pos=mat
              write(*,'(/7x,5a,$)') 
     &          '{',id(cfa)(1:eoi),' x ',id(cmo)(1:eoi2),'}'
            end if
            eoi=eow(id(i))
            pos=pos+eoi+2
            if (pos.gt.78) then
              pos=mat+eoi+2
              write(*,'(/a,$)') '            '
              do 26 k=13,mat-1
                write(*,'(a1,$)') ' '
   26         continue
              write(*,'(a,$)') '+'
            end if
            write(*,'(2a,$)') '--',id(i)(1:eoi)
          else
            eoi=eow(id(i))
            pos=pos+eoi+3
            if (pos.gt.78) then
              write(*,'(/a,$)') '      '
              pos=eoi+9
            end if
            write(*,'(1x,3a,$)') '(',id(i)(1:eoi),')'
          end if
        end if
   25   continue
        write(*,*)
   20 continue
      return
      end
C end-of-wrgen
C
C Give kinships among affecteds
C
      subroutine casekin(wrk,locnam,trait,gt,thresh,pedigree,actset,
     2             num,nfound,id,fa,mo,sex,locus,numloc,aff,
     3             ibdcount, plevel)
      integer IBDSIZ, MAXIBD, MAXLOC, MAXSIZ, MISS
      parameter(MAXLOC=10000,MAXSIZ=20,MISS=-9999,
     &          MAXIBD=20, IBDSIZ=MAXIBD*(MAXIBD+1)/2)

      integer gt, plevel, trait, wrk
      character*10 locnam
      double precision thresh
      character*10 pedigree  
      character*10 id(MAXSIZ)
      integer actset,num, fa(MAXSIZ), mo(MAXSIZ), sex(MAXSIZ)
      integer numloc
      double precision locus(MAXSIZ,MAXLOC)
      integer aff(MAXSIZ)
C ibd sharing
      double precision ibdcount(IBDSIZ)
C local variables
      integer i, j, naff, nfam, ninbred, npairs, nspor, pos, 
     &        totaff, totpairs
      logical ispor, last
      double precision inb, meanf, meanr, kin
C functions
      integer clcpos
      double precision isaff
C
      write(*,'(/a/3a/a)')
     2  '--------------------------------------------------',
     3  'Relationships of probands with trait "',locnam,'"',
     4  '--------------------------------------------------' 
      if (thresh.ne.MISS) call defpro(gt, thresh)

      if (plevel.eq.0) then
        write(*,'(a/a)') 
     2    'Pedigree      Aff Sporad Inbred  mean R  mean F',
     3    '---------- ------ ------ ------  ------  ------'
      end if
      nfam=0
      totaff=0
      totpairs=0
      meanf=0.0d0
      meanr=0.0d0
      last=.false.
      rewind(wrk)
   10 continue
       call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &            numloc, last)
       if (last) goto 20
C 
       if (actset.le.0) goto 10

         naff=0
         do 25 i=1,num
         if (isaff(locus(i,trait),thresh,gt).eq.2.0) then
           naff=naff+1
           aff(naff)=i
         end if
   25    continue
C 
C Skip if nobody affected
C
       if (naff.eq.0) goto 10
C
C calculate mean inbreeding for affecteds
C and print out kinships for cases
C
         nfam=nfam+1
         npairs=naff*(naff-1)/2
         totaff=totaff+naff
         totpairs=totpairs+npairs
         call kinship(num,nfound,fa,mo,ibdcount)
         if (plevel.gt.0) then 
           write(*,'(/2a)') 'Pedigree ',pedigree
           do 70 i=1, naff
             write(*,'(a5,50(1x,f5.3),(/5x,50(1x,f5.3):))') 
     2         id(aff(i)), (ibdcount(clcpos(aff(i),aff(j))), j=1,i)
   70      continue
         end if
         ninbred=0
         nspor=0
         inb=0.0d0
         kin=0.0d0
         do 75 i=1, naff
           pos=aff(i)
           inb=inb+ibdcount(clcpos(pos,pos))-1.0d0
           if (ibdcount(clcpos(pos,pos)).gt.1.0d0) then
             ninbred=ninbred+1
             if (plevel.gt.0) then
               write(*,'(3a)') 'Proband ', id(pos), ' is inbred.'
             end if
           end if
           ispor=.true.
           do 79 j=1, i-1 
             kin=kin+ibdcount(clcpos(pos,aff(j)))
             if (ibdcount(clcpos(pos,aff(j))).ne.0.0d0) then
               ispor=.false.
             end if
   79      continue
           do 80 j=i+1, naff
           if (ibdcount(clcpos(pos,aff(j))).ne.0.0d0) then
             ispor=.false.
           end if
   80      continue
           if (ispor) then
             nspor=nspor+1
             if (plevel.gt.0) then
               write(*,'(3a)') 
     &           'Proband ',id(pos),' is a sporadic case.'
             end if
           end if
   75    continue
         meanf=meanf+inb
         meanr=meanr+kin
         inb=inb/dfloat(naff)
         if (npairs.gt.0) kin=kin/dfloat(npairs)
         if (plevel.eq.0) then
           write(*,'(a10,3i7,2(2x,f6.4))') 
     &       pedigree, naff, nspor, ninbred, kin, inb
         end if
       goto 10
   20 continue
C
C write mean R and F for all affecteds
C
      if (totaff.gt.0) then
        meanf=meanf/dfloat(totaff)
        meanr=meanr/dfloat(totpairs)
        write(*,'(2(/a,1x,f8.6,a,i5,a))') 
     2    'Mean relatedness of cases   = ',
     3    meanr,' (based on ',totpairs,' affected relative pairs)',
     4    'Mean inbreeding of cases    = ',
     5    meanf,' (based on ',totaff,' affected individuals)'
      end if
      return
      end
C end-of-casekin
C
C Find the ancestor(s) shared by the maximum number of affecteds
C Also calculate inbreeding among all cases within each family
C
      subroutine ancest(wrk,locnam,trait,gt,thresh,pedigree,actset,num,
     2                  nfound, id,fa,mo,sex,locus,numloc,aff,
     3                  ibdcount, plevel)
      integer IBDSIZ, MAXIBD, MAXLOC, MAXSIZ, MISS
      parameter(MAXLOC=10000,MAXSIZ=20,MISS=-9999,
     &          MAXIBD=20, IBDSIZ=MAXIBD*(MAXIBD+1)/2)

      integer gt, plevel, trait, wrk
      character*10 locnam
      double precision thresh
      character*10 pedigree  
      character*10 id(MAXSIZ)
      integer actset,num, fa(MAXSIZ), mo(MAXSIZ), sex(MAXSIZ)
      integer numloc
      double precision locus(MAXSIZ,MAXLOC)
      integer aff(MAXSIZ)
C ibd sharing
      double precision ibdcount(IBDSIZ)
C local variables
      integer bestid, nid, bestfa, nfa, bestmo, nmo, i, naff, totaff
      logical last
      double precision meanf
C functions
      double precision isaff
C
      meanf=0.0d0
      naff=0
      write(*,'(/a/3a/a)')
     2  '--------------------------------------------------',
     3  'Ancestors of probands with trait "',locnam,'"',
     4  '--------------------------------------------------' 
      if (thresh.ne.MISS) call defpro(gt, thresh)
      write(*,'(/a/a)')
     2  'Pedigree   Father   Mother   Number of Affected Descendents',
     3  '---------- -------- -------- ------------------------------'
      last=.false.
      rewind(wrk)
   10 continue
       call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &            numloc, last)
       if (last) goto 20
C 
C Skip if singleton
C
       if (actset.le.0 .or. (num-nfound).lt.2) goto 10

         totaff=0
         do 25 i=1,num
         if (isaff(locus(i,trait),thresh,gt).eq.2.0) then
           aff(i)=1
           totaff=totaff+1
         else
           aff(i)=0
         end if
   25    continue
C 
C Skip if nobody affected
C
       if (totaff.eq.0) goto 10
C
C calculate mean inbreeding for affecteds
C
         naff=naff+totaff
         call kinship(num,nfound,fa,mo,ibdcount)
         idx=0
          do 70 i=1,num
            idx=idx+i
            if (aff(i).eq.1) then
              meanf=meanf+ibdcount(idx)-1.0d0
            end if
   70     continue
C
C Accumulate counts of descendents who are affected
C
         bestid=MISS
         nid=0
         bestfa=MISS
         nfa=0
         bestmo=MISS
         nmo=0
         do 30 i=num,nfound+1,-1
           aff(fa(i))=aff(fa(i))+aff(i)
           aff(mo(i))=aff(mo(i))+aff(i)
   30    continue
C
C Find largest count of affecteds as low in the pedigree as possible
C
         do 40 i=num,nfound+1,-1
           if (aff(i).gt.nid) then
             nid=aff(i)
             bestid=i
           end if
           if ((aff(fa(i))+aff(mo(i))).gt.(nfa+nmo)) then
             bestfa=fa(i)
             nfa=aff(fa(i))
             bestmo=mo(i)
             nmo=aff(mo(i))
           end if
   40    continue
         do 50 i=nfound,1,-1
           if (aff(i).gt.nid) then
             nid=aff(i)
             bestid=i
           end if
   50    continue
C
C Write the best individual ancestor and ancestral mating
C
         call wrdesc(pedigree,id(bestid),sex(bestid),nid,totaff)
         write(*,'(a10,1x,a10,1x,a10,1x,2(i4,a,f5.1,a))') 
     2     pedigree,id(bestfa),id(bestmo),
     3     nfa,' (',float(100*nfa)/float(totaff),'%), ',
     4     nmo,' (',float(100*nmo)/float(totaff),'%)'
         if (plevel.gt.1) then
           write(*,*) 
           do 100 i=1, num
           if (aff(i).gt.1) then
             call wrdesc(pedigree,id(i),sex(i),aff(i),totaff)
           end if
  100      continue
           write(*,*) 
         end if
       goto 10
   20 continue
C
C write mean F for all affecteds
C
      if (naff.gt.0) meanf=meanf/dfloat(naff)
      write(*,'(/a,1x,f8.6,a,i5,a)') 'Mean inbreeding of cases    = ',
     &    meanf,' (based on ',naff,' affected individuals)'
      return
      end
C end-of-ancest
C
C write person and number of descendants
      subroutine wrdesc(pedigree,cid,sx,ndesc,ntot)
      character*10 pedigree
      character*10 cid
      integer ndesc, ntot, sx
      if (sx.eq.1) then
        write(*,'(a10,1x,a10,8x,i4,a,f5.1,a)') pedigree,cid,
     &     ndesc,' (',float(100*ndesc)/float(ntot),'%)'
      else
        write(*,'(a10,8x,a10,1x,i4,a,f5.1,a)') pedigree,cid,
     &     ndesc,' (',float(100*ndesc)/float(ntot),'%)'
      end if
      return
      end
C end-of-wrdesc
C
C Prune pedigree to ancestors shared by affecteds
C
      subroutine prunep(wrk,twrk,locnam,trait,gt,thresh,
     2                  pedigree,num,nfound,id,fa,mo,sex,locus,numloc,
     3                  key,ord,set,plevel)
      integer MAXLOC,MAXSIZ,MISS
      parameter(MAXLOC=10000,MAXSIZ=20,MISS=-9999)

      integer gt, plevel, trait, twrk, wrk
      character*10 locnam
      double precision thresh
      character*10 pedigree  
      character*10 id(MAXSIZ)
      integer actset,num, fa(MAXSIZ), mo(MAXSIZ), sex(MAXSIZ)
      integer numloc
      double precision locus(MAXSIZ,MAXLOC)
      integer key(MAXSIZ), ord(MAXSIZ), set(MAXSIZ,2)
C local variables
      integer i, no, nf, naff, pos, totno, totnum
      logical last
C functions
      double precision isaff

      totno=0
      totnum=0
      
      write(*,'(/a/3a/a)')
     2  '--------------------------------------------------',
     3  ' Pruning pedigrees of probands with trait "',locnam,'"',
     4  '--------------------------------------------------' 
      if (thresh.ne.MISS) call defpro(gt, thresh)
      if (plevel.gt.1) then
        write(*,'(a/a/)') 
     2    '           Number of        Pedigree Size',
     3    'Pedigree   Index Cases  Original       New'
      end if

      last=.false.
      rewind(wrk)
   10 continue
       call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &            numloc, last)
       if (last) goto 20
C 
         if (actset.le.0) then
           call wrkout(twrk,pedigree,actset,num,nfound,id,fa,mo,sex,
     &                 locus,numloc)
           goto 10
         end if

         totnum=totnum+num
         naff=0
         do 25 i=1,num
           if (isaff(locus(i,trait),thresh,gt).eq.2.0) then
             set(i,1)=1
             set(i,2)=1
             naff=naff+1
           else
             set(i,1)=0
             set(i,2)=0
           end if
           ord(i)=0
   25    continue
C 
C Skip if nobody affected
C
       if (naff.eq.0) goto 10
C
C Accumulate counts of descendents who are affected
C
         do 30 i=num,nfound+1,-1
           set(fa(i),1)=set(fa(i),1)+set(i,1)
           set(mo(i),1)=set(mo(i),1)+set(i,1)
   30    continue
C
C Find MRCAs 
         do 40 i=nfound+1, num
         if (set(i,1).ne.0) then
           if (set(fa(i),1).gt.set(i,1)) set(fa(i),2)=1
           if (set(mo(i),1).gt.set(i,1)) set(mo(i),2)=1
         end if
   40    continue
C Add connectors and other parents, if needed
         do 50 i=nfound+1, num
           if (set(i,1).ne.0) then
             if (set(fa(i),2).ne.0) set(i,2)=1
             if (set(mo(i),2).ne.0) set(i,2)=1
           end if
           if (set(i,2).ne.0) then
             if (set(fa(i),2).ne.0) set(mo(i),2)=1
             if (set(mo(i),2).ne.0) set(fa(i),2)=1
           end if
   50    continue
C
C New founders
         nf=0
         do 60 i=1, nfound
         if (set(i,2).ne.0) then
           nf=nf+1
           ord(i)=nf
         end if
   60    continue
         do 70 i=nfound+1, num
         if (set(i,2).ne.0 .and. 
     &       set(fa(i),2).eq.0 .and. set(mo(i),2).eq.0) then
           nf=nf+1
           ord(i)=nf
           fa(i)=MISS
           mo(i)=MISS
         end if
   70    continue
C New nonfounders
         no=nf
         do 80 i=nfound+1, num
         if (set(i,2).ne.0 .and. ord(i).eq.0) then
           no=no+1
           ord(i)=no
           fa(i)=ord(fa(i))
           mo(i)=ord(mo(i))
         end if
   80    continue
         totno=totno+no
C write new pedigree
         if (plevel.gt.1) then
           write(*,'(a10,1x,i5,2(8x,i5))') pedigree, naff, num, no
         end if
         do 100 i=1,num
         if (ord(i).ne.0) then
           key(ord(i))=i
         end if
  100    continue
         write(twrk) pedigree, actset, no, nf
         do 110 i=1,no
           pos=key(i)
           write(twrk) id(pos),fa(pos),mo(pos),sex(pos),
     &                 (locus(pos,j),j=1,numloc)
  110    continue
       goto 10
   20 continue
      write(*,'(/a,i5,a)') 
     &  'Dropped ',totnum-totno, ' pedigree members.'
      return
      end
C end-of-prunep
C
C Write relatives of index
C
      subroutine relations(wrk,tped,tid,pedigree,actset,num,
     &             nfound,id,fa,mo,sex,locus,numloc,key,plevel)
      integer MAXLOC,MAXSIZ,MISS
      parameter(MAXLOC=10000,MAXSIZ=20,MISS=-9999)

      integer plevel, wrk
C target pedigree,id
      character*10 tid
      character*10 tped
      character*10 pedigree  
      character*10 id(MAXSIZ)
      integer actset,num,nfound,fa(MAXSIZ), mo(MAXSIZ), sex(MAXSIZ)
      integer numloc
      double precision locus(MAXSIZ,MAXLOC)
      logical last
      integer key(MAXSIZ)
C
      integer cfa, cmo, eop, idx, ndesc, nmat, noff, nsibs
C functions
      integer eow

      eop=eow(tped)
      last=.false.
      idx=0
      rewind(wrk)
   10 continue
       call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &            numloc, last)
       if (last) goto 20
        if (actset.gt.0 .and. tped .eq. pedigree) then
          do 15 i=1,num
          if (tid .eq. id(i)) then
            idx=i
            goto 16
          end if
   15     continue
   16     continue
        end if
       if (idx.eq.0) goto 10
        ndesc=0
        nmh=0
        noff=0
        nph=0
        nsibs=0
        cfa=fa(idx)
        cmo=mo(idx)
        do 25 i=1, num
          key(i)=0
   25   continue
        key(idx)=1
        if (idx.gt.nfound) then
          do 30 i=nfound+1, num
            if (i.eq.idx) then
              continue
            else if (fa(i).eq.cfa .and. mo(i).eq.cmo) then
              nsibs=nsibs+1
              key(i)=-1
            else if (fa(i).eq.cfa) then
              nph=nph+1
              key(i)=-2
            else if (mo(i).eq.cmo) then
              nmh=nmh+1
              key(i)=-3
            end if
   30     continue
        end if
        do 40 i=nfound+1, num
          if (key(fa(i)).gt.0 .or. key(mo(i)).gt.0) then
            key(i)=min(3,max(key(fa(i)), key(mo(i)))+1)
            ndesc=ndesc+1
            if (fa(i).eq. idx .or. mo(i).eq.idx) then
              noff=noff+1
            end if
          end if
   40   continue

        write(*,'(a//a,11x,3a)') 'Class         N   IDs',
     3     'Index',pedigree(1:eop),'-',id(idx)(1:eow(id(idx)))
        if (cfa.ne.MISS) then
          write(*,'(a,9x,7a)') 'Parents', 
     2      pedigree(1:eop),'-',id(cfa)(1:eow(id(cfa))), ' ', 
     3      pedigree(1:eop),'-',id(cmo)(1:eow(id(cmo)))
        end if
        write(*,'(a,4x,i3,$)')   'Siblings', nsibs
        call prrel(-1, pedigree, num, id, key, eop) 
        if (nph.gt.0) then
          write(*,'(a,i3,$)') 'Pat halfsibs', nph 
          call prrel(-2, pedigree, num, id, key, eop) 
        end if
        if (nmh.gt.0) then
          write(*,'(a,i3,$)') 'Mat halfsibs', nph 
          call prrel(-3, pedigree, num, id, key, eop) 
        end if
        write(*,'(a,3x,i3,$)') 'Offspring', noff 
        call prrel(2, pedigree, num, id, key, eop) 
        write(*,'(a,i3,$)')  'Descendants ', ndesc
        call prrel(3, pedigree, num, id, key, eop) 
C Mates 
        do 50 i=1, num
          key(i)=0
   50   continue
        key(idx)=1
        do 60 i=nfound+1, num
          if (key(fa(i)).eq.1) then
            key(mo(i))=2
          else if (key(mo(i)).eq.1) then
            key(fa(i))=2
          end if
   60   continue
        nmat=0
        do 70 i=1, num
        if (key(i).eq.2) then
          nmat=nmat+1
        end if
   70   continue
        write(*,'(a,3x,i3,$)') 'Mates    ', nmat 
        call prrel(2, pedigree, num, id, key, eop) 
   20 continue
      return
      end
C end-of-relations
C 
C print list of relatives
      subroutine prrel(iclass, pedigree, num, id, key, eop) 
      integer MAXSIZ, FC, LC
      parameter(FC=17, LC=75, MAXSIZ=20)
      integer eop, iclass, num 
      character*10 pedigree  
      character*10 id(MAXSIZ)
      integer key(MAXSIZ)
      integer i
C function
      integer eow

      pos=FC
      do 10 i=1, num
      if (key(i).eq.iclass) then
        pos=pos+eop+eow(id(i))+2
        if (pos.gt.LC) then
          pos=FC+eop+eow(id(i))+2
          write(*,'(/14x,a1,$)') ' '
        end if
        write(*,'(1x,3a,$)') pedigree(1:eop),'-',id(i)(1:eow(id(i)))
      end if  
   10 continue
      write(*,*)
      return
      end
C end-of-prrel
C
C extract unrelated individuals with information for a criterion trait
C
      subroutine wricas(wrk,twrk,trait,pedigree,actset,
     &                  num,nfound,id,fa,mo,sex,locus,numloc)
      integer MAXSIZ,MAXLOC,MISS
      parameter (MAXSIZ=20,MAXLOC=10000,MISS=-9999)
      integer trait,wrk,twrk
C Pedigree structure
      character*10 pedigree
      integer actset,num,nfound 
      character*10 id(MAXSIZ) 
      integer fa(MAXSIZ),mo(MAXSIZ),sex(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)

      integer aff(MAXSIZ)

      logical last
      integer eop, i, nuse, tuse
      character*10 fam
C functions
      integer eow
      
      tuse=0
      last=.false.
      rewind(wrk)
   10 continue
       call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &            numloc, last)
       if (last) goto 20

        if (actset.le.0) then
          call wrkout(twrk,pedigree,actset,num,nfound,id,fa,mo,sex,
     &                locus,numloc)
          goto 10
        end if
       
        do 50 i=1, nfound
          if (locus(i,trait).ne.MISS) then
            aff(i)=2
          else
            aff(i)=1
          end if
   50   continue
        do 70 i=nfound+1, num
          if (aff(fa(i)).eq.1 .and. aff(mo(i)).eq.1) then 
            if (locus(i,trait).ne.MISS) then
              aff(i)=2
              aff(fa(i))=3
              aff(mo(i))=3
            else 
              aff(i)=1
            end if
          else 
            aff(i)=3
          end if
   70   continue

        nuse=0
        eop=eow(pedigree)
        do 100 i=1, num
        if (aff(i).eq.2) then
          nuse=nuse+1
          fam=pedigree
          call makeind(1,nuse,eop,10,fam)
          write(twrk) fam, actset, 1, 1  
          write(twrk) id(i),MISS,MISS,sex(i),(locus(i,j),j=1,numloc)
        end if
  100   continue
        tuse=tuse+nuse
      goto 10
   20 continue
      write(*,'(a,i6,a)') 'Extracted ',tuse,' cases.'
      return
      end
C end-of-getcas 
C
C convert into nuclear families, duplicating individuals as needed
C
      subroutine nuclear(wrk,twrk,pedigree,actset,num,nfound,
     &                   id,fa,mo,sex,locus,numloc,maxsibs,typ)
      integer MAXSIZ,MAXLOC
      parameter (MAXSIZ=20,MAXLOC=10000)
      integer maxsibs,wrk,twrk,typ
C Pedigree structure
      character*10 pedigree
      integer actset,num,nfound 
      character*10 id(MAXSIZ) 
      integer fa(MAXSIZ),mo(MAXSIZ),sex(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)
      logical last

      integer currf, currm, eop, nuc, pos, sta

C functions
      integer eow

      maxsibs=maxsibs-1

      last=.false.
      rewind(wrk)
   10 continue
       call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &            numloc, last)
       if (last) goto 20

       if (nfound.eq.num .or. actset.le.0) then
         call wrkout(twrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &              numloc)
       else
         nuc=0
         eop=eow(pedigree)
         pos=nfound+1
         sta=pos
         currf=fa(sta)
         currm=mo(sta)
   50    continue
           if (fa(pos).ne.currf .or. mo(pos).ne.currm) 
     &     then
             nuc=nuc+1
             call onefam(twrk,pedigree,actset,num,nfound,
     2               id,fa,mo,sex,locus,numloc,maxsibs,
     3               eop, nuc, currf, currm, sta, pos-1, typ)
             sta=pos
             currf=fa(sta)
             currm=mo(sta)
           end if
           pos=pos+1
         if (pos.le.num) goto 50
C last sibship
         nuc=nuc+1
         call onefam(twrk,pedigree,actset,num,nfound,
     2           id,fa,mo,sex,locus,numloc,maxsibs,
     3           eop, nuc, currf, currm, sta, num, typ)
       end if
      goto 10
   20 continue
      return
      end
C end-of-nuclear
C
C write out current nuclear family -- with or without grandparents
C
      subroutine onefam(twrk,pedigree,actset,num,nfound,
     2                  id,fa,mo,sex,locus,numloc,maxsibs,
     3                  eop, nuc, currf, currm, sta, fin, typ)
      integer MAXSIZ,MAXLOC,MISS
      parameter (MAXSIZ=20,MAXLOC=10000,MISS=-9999)
      integer maxsibs, twrk, typ
      integer currf, currm, eop, fin, nuc, sta
C Pedigree structure
      character*10 pedigree
      integer actset,num,nfound 
      character*10 id(MAXSIZ) 
      integer fa(MAXSIZ),mo(MAXSIZ),sex(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)

      character*10 fam
      integer gp1, gp2, gp3, gp4, i, j, nfou, nsibs, p1, p2

      fam=pedigree
      call makeind(1,nuc,eop,10,fam)
      nsibs=min(fin-sta,maxsibs)+1
      nfou=0
      gp1=MISS
      gp2=MISS
      gp3=MISS
      gp4=MISS
      p1=1
      p2=2
      if (typ.eq.2) then
        if (currf.gt.nfound) then
          nfou=nfou+2
          p1=p1+2
          p2=p2+2
          gp1=1
          gp2=2
        end if
        if (currm.gt.nfound) then
          nfou=nfou+2
          p1=p1+2
          p2=p2+2
          gp3=max(gp2,0)+1
          gp4=gp3+1
        end if
      end if
      write(twrk) fam, actset, nsibs+2+nfou, max(2,nfou)
C Grandparents
      if (typ.eq.2) then
        if (currf.gt.nfound) then
          write(twrk) id(fa(currf)),MISS,MISS,1, 
     &      (locus(fa(currf),j),j=1,numloc)
          write(twrk) id(mo(currf)),MISS,MISS,2, 
     &      (locus(mo(currf),j),j=1,numloc)
        end if
        if (currm.gt.nfound) then
          write(twrk) id(fa(currm)),MISS,MISS,1, 
     &      (locus(fa(currm),j),j=1,numloc)
          write(twrk) id(mo(currm)),MISS,MISS,2, 
     &      (locus(mo(currm),j),j=1,numloc)
        end if
      end if
C Parents
      write(twrk) id(currf),gp1,gp2,1, 
     &  (locus(currf,j),j=1,numloc)
      write(twrk) id(currm),gp3,gp4,2, 
     &  (locus(currm,j),j=1,numloc)
C Children
      do 55 i=sta,min(sta+maxsibs,fin)
        write(twrk) id(i),p1,p2,sex(i),
     &    (locus(i,j),j=1,numloc)
   55 continue
      return
      end
C end-of-onefam 
C
C chop into disjoint subpedigrees
C note that the pointers in set(,2) do not follow the sort order of
C the pedigree, as connect() moves both up and down the generations
C
      subroutine disjoin(wrk,twrk,pedigree,actset,num,nfound,id,fa,mo,
     &                   sex,locus,numloc,ord,set,plevel)
      integer MAXSIZ,MAXLOC,MISS
      parameter (MAXSIZ=20,MAXLOC=10000,MISS=-9999)
      integer plevel, wrk, twrk
C Pedigree structure
      character*10 pedigree
      integer actset,num,nfound 
      character*10 id(MAXSIZ) 
      integer fa(MAXSIZ), mo(MAXSIZ), sex(MAXSIZ)
      integer ord(MAXSIZ), set(MAXSIZ,2)
      integer numloc
      double precision locus(MAXSIZ,MAXLOC)
      logical last
      integer curped, eop, maxgrp, nf, nsub, no
      character*10 fam
C functions
      integer eow
C
      last=.false.
      rewind(wrk)
   10 continue
       call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &            numloc, last)
       if (last) goto 20
         if (actset.le.0) then
           call wrkout(twrk,pedigree,actset,num,nfound,id,fa,mo,sex,
     &                 locus,numloc)
           goto 10
         end if
         call connect(num,fa,mo,set,nsub,maxgrp)
         if (plevel.gt.0) then
           write(*,'(3a,i4,a)') 'Pedigree ',pedigree,' written out as ',
     &       nsub,' pedigrees.'
         end if
         if (nsub.eq.1) then
           call wrkout(twrk,pedigree,actset,num,nfound,id,fa,mo,sex,
     &                 locus,numloc)
         else
           eop=eow(pedigree)
           do 15 curped=1,nsub
             nf=0
             no=0
             do 25 i=1,nfound
             if (set(i,1).eq.curped) then
               no=no+1
               nf=nf+1
               ord(i)=no
             end if
   25        continue
             do 26 i=nfound+1,num 
             if (set(i,1).eq.curped) then
               no=no+1
               ord(i)=no
             end if
   26        continue
             fam=pedigree
             call makeind(1,curped,eop,10,fam)
             if (plevel.gt.1) then
               write(*,'(2a)') 'Created pedigree ',fam
             end if
             write(twrk) fam, actset, no, nf
             do 30 i=1,nfound
             if (set(i,1).eq.curped) then
               write(twrk) id(i),MISS,MISS,sex(i),
     &           (locus(i,j),j=1,numloc)
             end if
   30        continue
             do 31 i=nfound+1,num 
             if (set(i,1).eq.curped) then
               write(twrk) id(i),ord(fa(i)),ord(mo(i)),sex(i),
     &           (locus(i,j),j=1,numloc)
             end if
   31        continue
   15      continue
         end if
      goto 10
   20 continue
      return
      end
C end-of-disjoin
C
C Delete MZ twin with least phenotype information out of pair 
C or clean MZ genotypes 
C
      subroutine dropt2(wrk,twrk,mztwin,gt,thresh,typ,pedigree,actset,
     &             num,nfound,id,fa,mo,sex,locus,
     2             numloc,nloci,loc,loctyp,locpos,plevel)
C
      integer KNOWN, MAXSIZ, MAXLOC, MISS
      parameter(KNOWN=0, MAXSIZ=20,MAXLOC=10000,MISS=-9999)
      integer mztwin, plevel, twrk, typ, wrk
      integer gt
      double precision thresh
C  Pedigree structure
      character*10 pedigree
      integer actset, num, nfound
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ), sex(MAXSIZ)
      integer numloc
      double precision locus(MAXSIZ,MAXLOC)
C locus structure
      integer nloci
      character*20 loc(MAXLOC)
      integer loctyp(MAXLOC),locpos(MAXLOC)
C local variables
      integer i, g1,g2,g3,g4, gene, hitwin, k, lotwin, 
     &        npairs, nphen1, nphen2, twin1
      character*7 gtp1, gtp2
      logical last
C functions
      double precision isaff
C
      write(*,'(4(/a))')
     2  '------------------------------------------------------------',
     3  'Checking for MZ discordance at marker loci',
     4  '------------------------------------------------------------',
     5  'Pedigree    Person1  Person2  Locus       Geno1   Geno2'
      npairs=0
      nphen1=0
      last=.false.
      rewind(wrk)
   10 continue
        call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &             numloc, last)
        if (last) goto 50

        if (actset.gt.0) then
          twin1=MISS
          do 20 i=nfound+1,num
          if (int(isaff(locus(i,mztwin),thresh,gt)).eq.2) then
            if (twin1.eq.MISS) then
              twin1=i
              nphen1=0
              do 28 k=1, nloci
              if (loctyp(k).gt.2 .and. locpos(k).ne.MISS) then
                nphen1=nphen1+1
              end if
   28         continue
            else
              if (fa(i).eq.fa(twin1) .and. mo(i).eq.mo(twin1)) then
                nphen2=0
                npairs=npairs+1
C
C zero inconsistent genotypes and fill in blanks where applicable
                do 30 k=1,nloci
                if (loctyp(k).eq.1 .or. loctyp(k).eq.2) then
                  gene=locpos(k)
                  g1=int(locus(twin1,gene))
                  g2=int(locus(i,gene))
                  if (g1.gt.KNOWN .and. g2.gt.KNOWN) then
                    g3=int(locus(twin1,gene+1))
                    g4=int(locus(i,gene+1))
                    if (g1.ne.g2 .or. g3.ne.g4) then
                      call wrgtp(g1,g2,gtp1,1)
                      call wrgtp(g3,g4,gtp2,1)
                      write(*,'(3(1x,a),1x,a10,2(1x,a))') 
     &                  pedigree, id(twin1), id(i), loc(k), gtp1, gtp2
                      locus(twin1,gene)=-locus(twin1,gene)
                      locus(twin1,gene+1)=-locus(twin1,gene+1)
                      locus(i,gene)=-locus(i,gene)
                      locus(i,gene+1)=-locus(i,gene+1)
                    end if
                  else if (g1.le.KNOWN .and. g2.gt.KNOWN) then
                    locus(twin1,gene)=locus(i, gene)
                    locus(twin1,gene+1)=locus(i, gene+1)
                  else if (g1.gt.KNOWN .and. g2.le.KNOWN) then
                    locus(i,gene)=locus(twin1, gene)
                    locus(i,gene+1)=locus(twin1, gene+1)
                  end if
                else if (locus(i,locpos(k)).ne.MISS) then
                  nphen2=nphen2+1
                end if
   30           continue
C
C Pick twin with most phenotype to save, drop other twins data
C averaging quantitative trait values
C
                if (typ.eq.2) then
                  lotwin=i
                  hitwin=twin1
                  if (nphen1.gt.nphen2) then
                    lotwin=twin1
                    hitwin=i
                  end if
                  if (plevel.gt.1) then
                    write(*,*) 'Dropping MZ twin ',pedigree, id(lotwin)
                  end if
                  do 35 k=1,nloci
                    if (loctyp(k).eq.1 .or. loctyp(k).eq.2) then
                      gene=locpos(k)
                      if (locus(lotwin,gene).gt.KNOWN) then
                        locus(lotwin,gene)= -locus(lotwin, gene)
                        locus(lotwin,gene+1)= -locus(lotwin, gene+1)
                      end if
                    else if (loctyp(k).eq.3) then
                      gene=locpos(k)
                      if (locus(hitwin,gene).ne.MISS .and.
     &                    locus(lotwin,gene).ne.MISS) then
                        locus(hitwin,gene)= 0.5*(locus(hitwin,gene)+
     &                                           locus(lotwin, gene))
                      else if (locus(hitwin,gene).eq.MISS) then
                        locus(hitwin,gene)= locus(lotwin,gene)
                      end if
                      locus(lotwin,gene)=MISS
                    else if (loctyp(k).eq.4) then
                      gene=locpos(k)
                      locus(lotwin,gene)=MISS
                    end if
   35             continue
                end if
                twin1=MISS
              else
                twin1=i
              end if
            end if
          end if
   20     continue
        end if
        call wrkout(twrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &              numloc)
      goto 10
   50 continue
      if (typ.eq.2) then
        write(*,*) 
     &    'Dropped one member of ', npairs, ' sets of MZ twins.'
      end if
      return
      end
C end-of-dropt2
C
C Edit alleles for particular gene for particular person 
C
      subroutine edit(wrk,twrk,tped,tid,gene,loc,loctyp,all1,all2,
     2                pedigree,actset,num,nfound,id,fa,mo,sex,
     3                locus,numloc)
      integer MAXSIZ,MAXLOC,MISS
      parameter (MAXSIZ=20,MAXLOC=10000,MISS=-9999)
      integer twrk,wrk
C target pedigree,id,replacement alleles
      character*10 tid
      character*10 tped,loc
      integer gene,loctyp
      double precision all1, all2
C Pedigree structure
      character*10 pedigree
      integer actset,num,nfound 
      character*10 id(MAXSIZ) 
      integer fa(MAXSIZ),mo(MAXSIZ),sex(MAXSIZ)
      integer numloc
      double precision locus(MAXSIZ,MAXLOC)
      logical last
C
      integer i,j,eop,gen2, nchanges
      logical allids
      double precision tmp
      character*1 newbin,oldbin
      character*7 newgtp,oldgtp
      character*10 chid
C functions
      integer eow
      logical strfind

      allids=(tid.eq.'all     ')
      gen2=gene+1
      nchanges=0
      last=.false.
      rewind(wrk)
   10 continue
       call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &            numloc, last)
       if (last) goto 20
        if (actset.gt.0 .and. strfind(tped,pedigree,1)) then
          eop=eow(pedigree)
          do 15 i=1,num
          if (allids .or. strfind(tid,id(i),1)) then
            call wrid('l',id(i),chid,0)
            if (gene .eq. MISS) then
              write(*,'(4a)') 
     2          'Deleting all data for ',
     3          pedigree(1:eop),'-',chid(1:eow(chid)) 
              do 12 j=1,numloc
                locus(i,j)=MISS
   12         continue
            elseif (loctyp .le. 2) then
              if (all1.gt.all2) then
                tmp=all1
                all1=all2
                all2=tmp
              end if
              call wrgtp(int(all1),int(all2),newgtp,1)
              call wrgtp(int(locus(i,gene)),int(locus(i,gen2)),oldgtp,1)
              write(*,'(10a)') 
     2          'Changing ',pedigree(1:eop),'-',chid(1:eow(chid)),
     3          ' at locus "',loc(1:eow(loc)), 
     4          '" from ',oldgtp, ' to ',newgtp
              locus(i,gene)=all1
              locus(i,gen2)=all2
            elseif (loctyp .eq. 3) then
              write(*,'(7a,f8.4,a,f8.4)') 
     2          'Changing ',pedigree(1:eop),'-',chid(1:eow(chid)),
     3          ' at locus "',loc(1:eow(loc)),
     4          '" from ',locus(i,gene),' to ',all1
              locus(i,gene)=all1
            elseif (loctyp .eq. 4) then
              call wraff(all1,newbin)
              call wraff(locus(i,gene),oldbin)
              write(*,'(7a,a8,a,a8)') 
     2          'Changing ',pedigree(1:eop),'-',chid(1:eow(chid)),
     3          ' at locus "',loc(1:eow(loc)),
     4          '" from ', oldbin,' to ',newbin
              locus(i,gene)=all1
            end if
            nchanges=nchanges+1
          end if
   15     continue
        end if
        call wrkout(twrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &              numloc)
      goto 10
   20 continue
      if (nchanges.eq.0) then
        write(*,'(5a)') 'ERROR: Could not find any record matching "', 
     &                  tped(1:eow(tped)), '-', tid(1:eow(tid)),'".'
      end if
      return
      end
C end-of-edit
C
C include or exclude a list of pedigrees
C
      subroutine selped(wrk,twrk,typ,farg,larg,words,pedigree,actset,
     &                  num, nfound,id,fa,mo,sex,locus,numloc,plevel)
      integer MAXLOC, MAXCOL, MAXSIZ, MISS
      parameter (MAXLOC=10000, MAXCOL=MAXLOC+5, MAXSIZ=20, MISS=-9999)

      integer farg,larg,plevel,twrk,typ,wrk
      character*20 words(MAXCOL)
C Pedigree structure
      character*10 pedigree
      integer actset, num, nfound
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ), sex(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)
      logical last
C
      integer i, j, nfam
      logical found, ltyp
C functions
      logical strfind

      ltyp=(typ.eq.2 .or. typ.eq.4) 

      nfam=0
      last=.false.
      rewind(wrk)
   10 continue
       call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &            numloc, last)
       if (last) goto 20
        found=ltyp
        if (typ.le.2) then
          do 50 i=farg, larg
          if (actset.gt.0 .and. strfind(words(i)(1:10),pedigree,1)) then
            found=.not.found
            goto 60
          end if
   50     continue
        else
          do 55 i=farg, larg
          do 55 j=1, num
          if (actset.gt.0 .and. strfind(words(i)(1:10),id(j),1)) then
            found=.not.found
            goto 60
          end if
   55     continue
        end if
   60   continue
        if (found) then
          nfam=nfam+1
          if (plevel.gt.0) write(*,'(2a)') 'Selected pedigree ',pedigree
        else
          actset=-abs(actset)
        end if
        call wrkout(twrk,pedigree,actset,num,nfound,id,fa,mo,sex,
     &              locus,numloc)
      goto 10
   20 continue
      write(*,'(/a,i6,a)') 'Selected ',nfam,' pedigrees.'
      return
      end
C end-of-selped
C
C Convert to/from Julian etc
C
      subroutine dateconv(wrk,twrk,trait,pedigree,actset,num,
     &                    nfound,id,fa,mo,sex,locus,numloc,typ,epoch)
      integer MAXSIZ,MAXLOC,MISS
      parameter (MAXSIZ=20,MAXLOC=10000,MISS=-9999)
      integer trait,twrk,typ,wrk
      double precision epoch
C Pedigree structure
      character*10 pedigree
      integer actset,num, nfound
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ), sex(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)
      logical last
      character*10 sdate
      integer i
C functions
      double precision getyear, togreg, tojulian
                                                                        
      last=.false.
      rewind(wrk)
      if (typ.eq.1) then
        call wrdate(epoch, sdate, 1)
        write(*,'(/3a)') 
     2    'Converting dates from Gregorian to Julian (epoch="', sdate,
     3    '").'
   10   continue
         call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &              numloc, last)
         if (last) goto 20
          do 15 i=1, num
          if (locus(i,trait).ne.MISS) then
            locus(i,trait)=tojulian(locus(i,trait))-epoch
          end if
   15     continue
          call wrkout(twrk,pedigree,actset,num,nfound,id,fa,mo,sex,
     &                locus,numloc)
        goto 10
   20   continue
      else if (typ.eq.2) then
        call wrdate(epoch, sdate, 1)
        write(*,'(/3a)') 
     2    'Converting dates from Julian (epoch="', sdate,
     3    '") to Gregorian.'
   30   continue
         call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &              numloc, last)
         if (last) goto 40
          do 35 i=1, num
          if (locus(i,trait).ne.MISS) then
            locus(i,trait)=togreg(locus(i,trait)+epoch)
          end if
   35     continue
          call wrkout(twrk,pedigree,actset,num,nfound,id,fa,mo,sex,
     &                locus,numloc)
        goto 30
   40   continue
      else if (typ.eq.3) then
        write(*,'(/a)') 'Converting date to decimal years.'
   50   continue
         call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &              numloc, last)
         if (last) goto 60
          do 55 i=1, num
          if (locus(i,trait).ne.MISS) then
            locus(i,trait)=getyear(locus(i,trait))
          end if
   55     continue
          call wrkout(twrk,pedigree,actset,num,nfound,id,fa,mo,sex,
     &                locus,numloc)
        goto 50
   60   continue
      end if
      return
      end
C end-of-dateconv
C
C identify rare alleles at a marker locus and list for combination
C
      subroutine combine(crit,recto,nf,recfro,numal,name,alfrq)
      integer KNOWN,MAXSIZ,MAXLOC,MAXALL
      parameter (KNOWN=0,MAXSIZ=20,MAXLOC=10000,MAXALL=2)
      integer nf
      double precision crit, recto, recfro(MAXALL)
C allele frequencies within entire sample for given locus 
      integer numal, name(MAXALL)
      double precision alfrq(MAXALL)

      nf=0
      do 10 i=1, numal
      if (alfrq(i).le.crit) then
        nf=nf+1
        recfro(nf)=name(i)
      end if
   10 continue
C recode to 999 or nearest available allele number
      recto=1000.0d0
   20 continue
        recto=recto-1.0d0
      do 30 i=1, numal
        if (int(recto).eq.name(i)) goto 20
   30 continue
      return
      end
C end-of-combine
C
C flip alleles to complement eg other strand A<->T G<->C 
C
      subroutine flip(wrk,twrk,loc,gene,pedigree,actset,num,nfound,
     &                id,fa,mo,sex,locus,numloc)
      integer MAXSIZ,MAXLOC,MAXALL,MISS
      parameter (MAXSIZ=20,MAXLOC=10000,MAXALL=2,MISS=-9999)
      integer gene,twrk,wrk
      character*10 loc
C Pedigree structure
      character*10 pedigree
      integer actset,num, nfound
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ), sex(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)
      logical last
      integer g1,g2,gen2,i
C functions
      integer atgc, eow
                                                                        
      write(*,'(/3a)')
     &  'Recoding alleles at "',loc(1:eow(loc)), '" to complement.'
                                                                        
      gen2=gene+1
                                                                        
      last=.false.
      rewind(wrk)
   10 continue
       call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &            numloc, last)
       if (last) goto 20
        do 15 i=1,num
        if (locus(i,gene).ne.MISS) then
          g1=atgc(int(locus(i,gene)))
          g2=atgc(int(locus(i,gen2)))
          call order(g1,g2)
          locus(i,gene)=dfloat(g1)
          locus(i,gen2)=dfloat(g2)
        end if
   15   continue
        call wrkout(twrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &              numloc)
      goto 10
   20 continue
      return
      end
C end-of-flip
C
C complement nucleotide
      integer function atgc(g)
      integer g
      atgc=g
      if (abs(g).eq.10097 .or. abs(g).eq.10065) atgc=g+sign(19,g)
      if (abs(g).eq.10099 .or. abs(g).eq.10067) atgc=g+sign(4,g)
      if (abs(g).eq.10103 .or. abs(g).eq.10071) atgc=g-sign(4,g)
      if (abs(g).eq.10116 .or. abs(g).eq.10084) atgc=g-sign(19,g)
      return
      end
C end-of-atgc
C renumber alleles to consecutive integers
      subroutine renumb(wrk,twrk,loc,gene,numal,name,
     3             pedigree,actset,num,nfound,id,fa,mo,sex,locus,numloc)
      integer MAXSIZ,MAXLOC,MAXALL,MISS
      parameter (MAXSIZ=20,MAXLOC=10000,MAXALL=2,MISS=-9999)
      integer gene,twrk,wrk
      character*10 loc
C Pedigree structure
      character*10 pedigree
      integer actset,num, nfound
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ), sex(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)
      logical last
C allele frequencies within entire sample for given locus 
      integer numal, name(MAXALL)
C
      integer i,g1,g2,gen2
C functions
      integer eow, getnam

      write(*,'(/3a,i3,a)') 'Renumbering alleles at "',loc(1:eow(loc)),
     &                      '" to 1..', numal,'.'

      gen2=gene+1

      last=.false.
      rewind(wrk)
   10 continue
       call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &            numloc, last)
       if (last) goto 20
        do 15 i=1,num
        if (locus(i,gene).ne.MISS) then
          g1=getnam(locus(i,gene),numal,name)
          g2=getnam(locus(i,gen2),numal,name)
          locus(i,gene)=sign(1.0d0,locus(i,gene))*dfloat(g1)
          locus(i,gen2)=sign(1.0d0,locus(i,gene))*dfloat(g2)
        end if
   15   continue
        call wrkout(twrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &              numloc)
      goto 10
   20 continue
      return
      end
C end-of-renumb
C
C recode alleles or values for particular locus -- 
C replace all "from" values with "to" values
C
      subroutine recode(wrk,twrk,loc,gene,typ,recto,nf,recfro,
     &             pedigree,actset,num,nfound,id,fa,mo,sex,locus,numloc)
      integer KNOWN,MAXSIZ,MAXLOC,MAXALL,MISS
      parameter (KNOWN=0,MAXSIZ=20,MAXLOC=10000,MAXALL=2,MISS=-9999)
      integer gene,nf,twrk,typ,wrk
      character*10 loc
      double precision recto, recfro(MAXALL)
C Pedigree structure
      character*10 pedigree
      integer actset,num, nfound
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ), sex(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)
      logical last
C
      integer i,j,gen2, nchange
      character*3 allel
      logical change
      double precision swp

      write(*,'(/a,a10)') 'Recoding locus ',loc
      if (typ.eq.1 .or. typ.eq.2) then
        write(*,'(a,$)') 'From: '
        do 1 i=1, nf
          call wrall(int(recfro(i)), allel)
          write(*,'(1x,a3,$)') allel
    1   continue
        call wrall(int(recto), allel)
        write(*,'(/a,1x,a3/)') 'To  : ',allel
      else
        write(*,'(a,30(1x,f4.0):)') 'From: ',(recfro(i),i=1,nf)
        write(*,'(a,1x,f4.0/)')     'To  : ',recto
      end if

      gen2=gene+1
      nchange=0
      last=.false.
      rewind(wrk)
   10 continue
       call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &            numloc, last)
       if (last) goto 20
        if (actset.gt.0) then
          if (typ.eq.1 .or. typ.eq.2) then
            do 15 i=1,num
              change=.false.
              do 16 j=1,nf
                if (abs(locus(i,gene)).eq.recfro(j)) then
                  if (recto.eq.MISS) then
                    locus(i,gene)=MISS
                    locus(i,gen2)=MISS
                    change=.true.
                  else
                    locus(i,gene)=sign(1.0d0,locus(i,gene))*recto
                    change=(locus(i,gene).gt.KNOWN)
                  end if
                end if
                if (abs(locus(i,gen2)).eq.recfro(j)) then
                  if (recto.eq.MISS) then
                    locus(i,gene)=MISS
                    locus(i,gen2)=MISS
                    change=.true.
                  else
                    locus(i,gen2)=sign(1.0d0,locus(i,gen2))*recto
                    change=(locus(i,gene).gt.KNOWN)
                  end if
                end if
                if (change) then
                  nchange=nchange+1
                  if (locus(i,gene).gt.locus(i,gen2)) then
                    swp=locus(i,gene)
                    locus(i,gene)=locus(i,gen2)
                    locus(i,gen2)=swp
                  end if
                end if
   16         continue
   15       continue
          else
            do 25 i=1,num
            do 25 j=1,nf
              if (locus(i,gene).eq.recfro(j)) then
                locus(i,gene)=recto
                nchange=nchange+1
              end if
   25       continue
          end if
        end if
        call wrkout(twrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &              numloc)
      goto 10
   20 continue
      if (recto.eq.MISS) then
        write(*,'(a,i6,a)') 'Set ',nchange,' values to missing.'
      else
        write(*,'(a,i6,a)') 'Recoded ',nchange,' values.'
      end if
      return
      end
C end-of-recode
C
C Kaplan-Meier estimator of survival function and the Nelson-Aalen 
C estimator of cumulative hazard.
C The Nelson-Aalen estimator is used to produce residuals, if requested.
C These are the deviance residuals of Therneau et al Biometrika 1990:
C equivalent to a variance-stabilized transformed martingale residual.
C
C
      subroutine prodlim(wrk,twrk,trait,censor,pedigree,actset,num,
     2             nfound,id,fa,mo,sex,locus,numloc,
     3             onset,haz,set,typ,plevel)
C
      integer MAXSIZ, MAXLOC, MISS
      parameter(MAXSIZ=20, MAXLOC=10000, MISS=-9999)
      integer censor, plevel, trait, twrk, typ, wrk
C  Pedigree structure
      character*10 pedigree
      integer actset, num, nfound
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ), sex(MAXSIZ)
      integer numloc
      double precision locus(MAXSIZ,MAXLOC)
C Age at onset, associated survival function
      integer naff, nobs, nvals, unaff
      double precision onset(MAXSIZ), haz(MAXSIZ)
      integer set(MAXSIZ,2)
C local variables
      integer i,j,k
      double precision res,x
      double precision dn, na, pl, va
      logical last

      naff=0
      nobs=0
      nvals=0
      do 1 i=1,MAXSIZ
        set(i,1)=0
        set(i,2)=0
    1 continue

      last=.false.
      rewind(wrk)
    5 continue
        call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &             numloc, last)
        if (last) goto 20

        if (actset.gt.0) then
         do 10 i=1,num
         if (locus(i,trait).ne.MISS) then
           nobs=nobs+1
           x=locus(i,trait)
           j=0
   15      continue
             j=j+1
           if (x.gt.onset(j) .and. j.le.nvals) goto 15
           if (x.ne.onset(j)) then
             if (nvals.lt.MAXSIZ) then
               do 30 k=nvals,j,-1
                 onset(k+1)=onset(k)
                 set(k+1,1)=set(k,1)
                 set(k+1,2)=set(k,2)
   30          continue
               nvals=nvals+1
               onset(j)=x
               set(j,1)=0
               set(j,2)=0
             else
               j=nvals
             end if
           end if
           set(j,2)=set(j,2)+1
           if (locus(i,censor).eq.2) then
             naff=naff+1
             set(j,1)=set(j,1)+1
           end if
         end if
   10    continue
        end if
      goto 5
   20 continue

      if (plevel.gt.1) then
        write(*,'(2(/a))') 
     2    ' Rank  Age-at-onset  Failed     Obs',
     3    ' ----------------------------------' 
        do 50 j=1,nvals
          write(*,'(1x,i4,2x,f12.4,2i8)') j,onset(j),set(j,1),set(j,2)
   50   continue
      end if
      write(*,'(2(/a))') 
     2  ' Age-at-onset   Failed  Riskset   H(t)   S(t)    ase',
     3  ' ---------------------------------------------------' 
      na=0.0d0
      pl=1.0d0
      va=0.0d0
      unaff=nobs-naff
      do 110 j=1,nvals
        if (set(j,1).ne.0) then
          dn=dfloat(set(j,1))/dfloat(nobs)
          na=na+dn
          pl=pl*(1.0d0-dn)
          va=va+dn/dfloat(max(1,nobs-set(j,1)))
          write(*,'(1x,f12.4,2(1x,i8),3(1x,f6.4))') 
     &      onset(j),set(j,1),nobs,na,pl,pl*sqrt(va)
        end if
        haz(j)=na
        nobs=nobs-set(j,2)
  110 continue
      write(*,'(/a/a//i5,a,i5,a)')
     2  ' H(t) = Nelson-Aalen estimator of integrated hazard',
     3  ' S(t) = Kaplan-Meier estimator of survivor function',
     4  naff,' affecteds and ',unaff,' unaffecteds used'
      if (typ.eq.1) return
C
C else replace age-at-onset with residual
C
      rewind(wrk)
  175 continue
        call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &             numloc, last)
        if (last) goto 190

        if (actset.gt.0) then
         do 180 i=1,num
         if (locus(i,trait).ne.MISS) then
           x=locus(i,trait)
           j=0
  185      continue
             j=j+1
           if (x.gt.onset(j) .and. j.le.nvals) goto 185
           if (locus(i,censor).eq.2.0d0) then
             res=1.0d0-haz(j)
             locus(i,trait)=sign(1.0d0,res)*
     &                      sqrt(-2*(res+log(1.0d0-res)))
           else
             locus(i,trait)=-sqrt(2*haz(j))
           end if
         end if
  180    continue
        end if
        call wrkout(twrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &              numloc)
      goto 175
  190 continue
      return
      end
C end-of-prodlim
C
C standardization of quantitative trait overall or *within* family
C as required by the approach of Commenge 
C
      subroutine stand(wrk,twrk,trait,pedigree,actset,num,
     &             nfound,id,fa,mo,sex,locus,numloc,typ)
C
      integer MAXSIZ, MAXLOC, MISS
      parameter(MAXSIZ=20, MAXLOC=10000, MISS=-9999)
      integer wrk, twrk, trait, typ
C  Pedigree structure
      character*10 pedigree
      integer actset, num, nfound
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ), sex(MAXSIZ)
      integer numloc
      double precision locus(MAXSIZ,MAXLOC)
      integer i, n
      double precision mu, sd
      logical last

      last=.false.
      rewind(wrk)
      if (typ.eq.2) then
    5   continue
          call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &               numloc, last)
          if (last) goto 20

          if (actset.gt.0) then
            n=0
            mu=0.0d0
            sd=0.0d0
            do 10 i=1,num
            if (locus(i,trait).ne.MISS) then
              n=n+1
              call moment(n,locus(i,trait),mu,sd)
            end if
   10       continue
C
            if (n.gt.0) then
              sd=sqrt(sd/dfloat(max(1,n-1)))
              do 30 i=1,num
              if (locus(i,trait).ne.MISS) then
                locus(i,trait)=(locus(i,trait)-mu)/sd
              end if
   30         continue
            end if
          end if
          call wrkout(twrk,pedigree,actset,num,nfound,id,fa,mo,sex,
     &                locus, numloc)
        goto 5
   20   continue
      elseif (typ.eq.1) then
        n=0
        mu=0.0d0
        sd=0.0d0
   55   continue
          call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &               numloc, last)
          if (last) goto 70

          if (actset.gt.0) then
            do 60 i=1,num
            if (locus(i,trait).ne.MISS) then
              n=n+1
              call moment(n,locus(i,trait),mu,sd)
            end if
   60       continue
          end if
        goto 55
   70   continue
C
        sd=sqrt(sd/dfloat(max(1,n-1)))
        rewind(wrk)
   75   continue
          call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &               numloc, last)
          if (last) goto 90
          if (actset.gt.0) then
            do 80 i=1,num
            if (locus(i,trait).ne.MISS) then
              locus(i,trait)=(locus(i,trait)-mu)/sd
            end if
   80       continue
          end if
          call wrkout(twrk,pedigree,actset,num,nfound,id,fa,mo,sex,
     &                locus, numloc)
        goto 75
   90   continue
      end if
      return
      end
C end-of-stand
C
C linear regression correction of quantitative trait 1 versus trait 2
C
      subroutine adjust(wrk,twrk,ytrait,xtrait,adjval,pedigree,actset,
     &                  num,nfound,id,fa,mo,sex,locus,numloc,plevel)
C
      integer MAXSIZ, MAXLOC, MISS
      parameter(MAXSIZ=20, MAXLOC=10000, MISS=-9999)
      integer wrk, twrk, ytrait, xtrait, plevel
      double precision adjval
C  Pedigree structure
      character*10 pedigree
      integer actset,num, nfound
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ), sex(MAXSIZ)
      integer numloc
      double precision locus(MAXSIZ,MAXLOC)
      integer n, i, ifail
      logical last
C regression results
      double precision x(3),r(6),b(2)
      double precision alpha,beta,mux 
      n=0
      ifail=0
      mux=0.0d0
      call inicov(3, 6, r)

      last=.false.
      rewind(wrk)
    5 continue
        call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &             numloc, last)
        if (last) goto 20

        if (actset.gt.0) then
         do 10 i=1,num
         if (locus(i,ytrait).ne.MISS .and. locus(i,xtrait).ne.MISS) then
           n=n+1
           x(1)=1.0d0
           x(2)=locus(i,xtrait)
           x(3)=locus(i,ytrait)
           mux=mux+x(2)
           call givenc(r, 6, 3, x, 1.0d0, ifail)
         end if
   10    continue
        end if
      goto 5
   20 continue
C
      call bsub(r, 6, 3, b, 2, ifail)
      alpha=b(1)
      beta=b(2)
      mux=mux/dfloat(n) 
      if (adjval.eq.MISS) adjval=mux
      if (plevel.gt.0) then
        write(*,'(a,f12.4/2(a,f12.4),a,i4,a/)') 
     2    'Adjusting to x-value of ',adjval,
     3    'y = ',alpha,' + ',beta,' * x  (based on ',n,' values)' 
      end if
      if (ifail.gt.0) then
        write(*,'(a/)') 'ERROR: Regression routine problem.'
        return
      end if
C
      rewind(wrk)
   25 continue
        call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &             numloc, last)
        if (last) goto 40

        if (actset.gt.0) then
         do 30 i=1,num
         if (locus(i,ytrait).ne.MISS) then
           if (locus(i,xtrait).ne.MISS) then
             locus(i,ytrait)=locus(i,ytrait)+
     &                       sngl(beta*(adjval-locus(i,xtrait)))
           else
             locus(i,ytrait)=locus(i,ytrait)+ beta*(adjval-mux)
           end if
         end if
   30    continue
        end if
        call wrkout(twrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &              numloc)
      goto 25
   40 continue
      return
      end
C end-of-adjust
C
C transform quantitative trait value
C
C t(x) =    { (x-offset)/divisor }                    Power == 1
C t(x) = log{ (x-offset)/divisor }                    Power == 0
C t(x) =   [{ (x-offset)/divisor }**Power - 1]/Power  Power != 0 && !=1
C Resulting values can be truncated above or below
C
      subroutine boxcox(wrk,twrk,trait,offset,divisor,power,loval,hival,
     &             pedigree,actset,num,nfound,id,fa,mo,sex,locus,numloc)
      integer MAXSIZ,MAXLOC,MISS
      parameter (MAXSIZ=20,MAXLOC=10000,MISS=-9999)
      integer trait,twrk,wrk
      double precision divisor, hival, loval, offset, power
C Pedigree structure
      character*10 pedigree
      integer actset, num, nfound
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ), sex(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)
      logical last
C
      integer i,ifault
      double precision x

      ifault=0
      last=.false.
      rewind(wrk)
   10 continue
       call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &            numloc, last)
       if (last) goto 20

       if (actset.gt.0) then
        if (power.eq.1.0d0) then
          do 15 i=1,num
          if (locus(i,trait).ne.MISS) then
            locus(i,trait)=(locus(i,trait)-offset)/divisor
          end if
   15     continue
        elseif (power.eq.0.0d0) then
          do 25 i=1,num
          if (locus(i,trait).ne.MISS) then
            x=(locus(i,trait)-offset)/divisor
            if (x.le.0) then
              ifault=ifault+1
              locus(i,trait)=MISS
            else
              locus(i,trait)=log(x)
            end if
          end if
   25     continue
        else
          do 35 i=1,num
          if (locus(i,trait).ne.MISS) then
            x=(locus(i,trait)-offset)/divisor
            if ((mod(power,1.0d0).ne.0.0d0 .and. x.lt.0) .or.
     2          (power.lt.0.0d0 .and. x.eq.0.0d0))  then
              ifault=ifault+1
              locus(i,trait)=MISS
            else
              locus(i,trait)=(x**power-1.0d0)/power
            end if
          end if
   35     continue
        end if
        if (loval.ne.MISS) then
          do 45 i=1,num
          if (locus(i,trait).ne.MISS .and. locus(i,trait).lt.loval) then
            locus(i,trait)=loval
          end if
   45     continue
        end if
        if (hival.ne.MISS) then
          do 55 i=1,num
          if (locus(i,trait).ne.MISS .and. locus(i,trait).gt.hival) then
            locus(i,trait)=hival
          end if
   55     continue
        end if
       end if
        call wrkout(twrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &              numloc)
      goto 10
   20 continue

      if (ifault.gt.0) then
        write(*,'(/a,i5,2a/7x,a/)') 
     2    'NOTE:  There were ',ifault,' trait values that could not be',
     3    ' transformed as requested.','New values were set to missing.'
      end if
      return
      end
C end-of-boxcox
C
C Convert a genotype to a quantitative trait
      subroutine factor(wrk,twrk,trget, gene, numal, name, 
     2                  pedigree,actset,num,nfound,id,fa,mo,sex, 
     3                  locus,numloc)
      integer KNOWN,MAXSIZ,MAXLOC,MAXALL,MISS
      parameter (KNOWN=0,MAXSIZ=20,MAXLOC=10000,MAXALL=2,MISS=-9999)
      integer gene,numloc,trget,twrk,wrk
C alleles at the marker
      integer numal, name(MAXALL)
C Pedigree structure
      character*10 pedigree
      integer actset, num, nfound
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ), sex(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)
      logical last
C
      integer g1,g2,gen2,i
C functions
      integer getnam

      gen2=gene+1
      last=.false.
      rewind(wrk)
   10 continue
       call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &            numloc, last)
       if (last) goto 20

        if (actset.gt.0) then
          do 30 i=1,num
            locus(i,trget)=MISS
            if (locus(i,gene).gt.KNOWN) then
              g1=getnam(locus(i,gene),numal,name)
              g2=getnam(locus(i,gen2),numal,name)
              locus(i,trget)=float(g2*(g2-1)/2+g1)
            end if
   30     continue
        end if
        call wrkout(twrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &              numloc)
      goto 10
   20 continue
      return
      end
C end-of-factor
C
      subroutine dorank(wrk,twrk,trget,trait,typ,pedigree,actset,
     &             num,nfound,id,fa,mo,sex,locus,numloc,value,counts)
C
      integer MAXSIZ, MAXLOC, MISS
      parameter(MAXSIZ=20,MAXLOC=10000,MISS=-9999)
      integer trget, trait, twrk, typ, wrk
C  Pedigree structure
      character*10 pedigree
      integer actset, num, nfound
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ), sex(MAXSIZ)
      integer numloc
      double precision locus(MAXSIZ,MAXLOC)
C Quantitative trait values
      integer nvals
      double precision value(MAXSIZ)
      integer counts(MAXSIZ)
C local variables
      integer i
      logical last
C functions
      double precision rank
C
      nvals=0
C
C Tabulate sorted values and frequencies
      last=.false.
      rewind(wrk)
    5 continue
        call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &             numloc, last)
        if (last) goto 20

        if (actset.gt.0) then
         do 10 i=1,num
         if (locus(i,trait).ne.MISS) then
           call qtab(locus(i,trait),nvals,value,counts)
         end if
   10    continue
        end if
      goto 5
   20 continue
C Replace with cumulative counts
      do 100 i=2, nvals
        counts(i)=counts(i)+counts(i-1)
  100 continue
C
C Give rank of each record
      last=.false.
      rewind(wrk)
   25 continue
        call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &             numloc, last)
        if (last) goto 40

        if (actset.gt.0) then
          do 30 i=1,num
          if (locus(i,trait).ne.MISS) then
            locus(i,trget)=rank(locus(i,trait),nvals,value,counts)
          end if
   30     continue
        end if
        call wrkout(twrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &              numloc)
      goto 25
   40 continue
      return
      end
C end-of-dorank
C
C Binary search for closest position of value in an ascending sorted array
C
      double precision function rank(val,num,key,cumcnt)
      integer num, cumcnt(*)
      double precision val, key(*)
      
      integer hi, lo, pos

      hi=num
      lo=1
   10 continue
        pos=(hi+lo)/2
        if (val.gt.key(pos)) then
          lo=pos+1
        elseif (val.lt.key(pos)) then
          hi=pos-1
        else
          goto 20
        end if
      if (hi.ge.lo) goto 10
   20 continue
      lo=0
      if (pos.gt.1) lo=cumcnt(pos-1)
      rank=0.5d0*float(lo+cumcnt(pos)+1)
      return
      end
C end-of-rank 
C
C simulate a single marker, either unconditionally, or
C consistent with ibd sharing at a given locus
C
      subroutine wrsim(wrk,twrk,typ,mark,gene,pedigree,actset,num,
     2              nfound,id,fa,mo,sex,locus, numloc,numal,name,
     3              cumfrq,untyped,set,sibd,key,plevel)
      integer IBDSIZ, KNOWN, MAXALL, MAXG, MAXIBD, MAXSIZ, MAXLOC, MISS
      parameter(MAXALL=2, MAXG=MAXALL*(MAXALL+1)/2, MAXSIZ=20, 
     2          MAXLOC=10000, MISS=-9999, KNOWN=0, 
     3          MAXIBD=20, IBDSIZ=MAXIBD*(MAXIBD+1)/2)
      integer gene,mark,plevel,twrk,typ,wrk
C  Pedigree structure
      character*10 pedigree
      integer actset,num, nfound
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ)
      integer sex(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)
C allele frequencies structure
      integer numal, name(MAXALL)
C frequency of alleles at locus to be simulated
      double precision cumfrq(MAXALL)
C work arrays for simulation
      logical untyped(MAXSIZ)
      integer set(MAXSIZ,2),sibd(MAXSIZ,2),key(2*MAXSIZ)
C local variables
      integer g1,g2,gen2,i,mark2
      double precision a1, a2
      logical last
C functions
      integer getnam

      gen2=gene+1
      mark2=mark+1
      last=.false.
      rewind(wrk)
    5 continue
        call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &             numloc, last)
        if (last) goto 20

        if (actset.le.0) goto 5
 
        if (typ.eq.1) then
C Unconditional simulation 
          call simped(num,nfound,fa,mo,cumfrq,set)
          do 10 i=1,num    
            locus(i,mark)=float(set(i,1))
            locus(i,mark2)=float(set(i,2))
   10     continue
        else
C Conditional on ibd at gene
          do 11 i=1,num
            if (locus(i,gene).le.KNOWN) then
              untyped(i)=.true.
              if (locus(i,gene).eq.0.0d0 .or.locus(i,gene).eq.MISS) then
                g1=MISS
                g2=MISS
              else
                g1=getnam(-locus(i,gene),numal,name)
                g2=getnam(-locus(i,gen2),numal,name)
              end if
            else
              untyped(i)=.false.
              g1=getnam(locus(i,gene),numal,name)
              g2=getnam(locus(i,gen2),numal,name)
            end if
            call update(i,g1,g2,set)
   11     continue
          call simibd(2,pedigree,num,nfound,fa,mo,set,sibd)
          if (typ.eq.2) then
C simulate based on given allele frequencies, ibd and missingness
            do 12 i=1,2*nfound 
              call found(cumfrq,key(i))
   12       continue
            do 13 i=1,num    
              a1=float(key(sibd(i,1)))
              a2=float(key(sibd(i,2)))
              if (untyped(i)) then
                a1=-a1
                a2=-a2
              end if
              if (a1.gt.a2) then
                locus(i,mark)=a2
                locus(i,mark2)=a1
              else
                locus(i,mark)=a1
                locus(i,mark2)=a2
              end if
   13       continue
          else
C perfect marker
            do 14 i=1,num    
              a1=float(sibd(i,1))
              a2=float(sibd(i,2))
              if (a1.gt.a2) then
                locus(i,mark)=a2
                locus(i,mark2)=a1
              else
                locus(i,mark)=a1
                locus(i,mark2)=a2
              end if
   14       continue
          end if
        end if
        call wrkout(twrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &              numloc)
      goto 5
   20 continue
C
      return
      end
C end-of-wrsim  
C
C simulate a quantitative trait of given heritability, 
C either unconditionally, or
C consistent with complete linkage to a given locus
C
      subroutine wrsimq(wrk, twrk, typ, trait, loctyp, h2, gene, 
     2              pedigree, actset, num, nfound, id, fa, mo, sex,
     3              locus, numloc, numal, name, cumfrq, set, sibd, key,
     4              ibdcount, plevel)
      integer IBDSIZ, KNOWN, MAXALL, MAXG, MAXIBD, MAXSIZ, MAXLOC, MISS
      parameter(MAXALL=2, MAXG=MAXALL*(MAXALL+1)/2, MAXSIZ=20, 
     2          MAXLOC=10000, MISS=-9999, KNOWN=0, 
     3          MAXIBD=20, IBDSIZ=MAXIBD*(MAXIBD+1)/2)
      integer gene,loctyp,plevel,trait,twrk,typ,wrk
      double precision h2
C  Pedigree structure
      character*10 pedigree
      integer actset,num, nfound
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ)
      integer sex(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)
C allele frequencies structure
      integer numal, name(MAXALL)
C frequency of alleles at locus to be simulated
      double precision cumfrq(MAXALL)
C work arrays for simulation
      integer set(MAXSIZ,2),sibd(MAXSIZ,2),key(2*MAXSIZ)
      double precision ibdcount(IBDSIZ)
C local variables
      integer cfa, cmo, g1, g2, gen2, i
      double precision aconst, econst, midpar, segsd
      logical last
C functions
      integer getnam
      real randn

      aconst=sqrt(h2)
      econst=sqrt(1.0d0-h2)
      cumfrq(1)=0.5d0
      cumfrq(2)=1.0d0
      last=.false.
      rewind(wrk)
    5 continue
        call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &             numloc, last)
        if (last) goto 20

        if (actset.le.0) goto 5
 
        if (typ.eq.1) then
C Unconditional simulation of trait under control of additive polygenes
          call kinship(num,nfound,fa,mo,ibdcount)
          do 10 i=1, nfound
            locus(i,trait)=dble(randn())
   10     continue
          do 15 i=nfound+1, num
            cfa=fa(i)
            cmo=mo(i)
            midpar=0.5d0*(locus(cfa,trait)+locus(cmo,trait))
            cfa=cfa*(cfa+1)/2
            cmo=cmo*(cmo+1)/2
            segsd=sqrt(1.0d0-0.25d0*(ibdcount(cfa)+ibdcount(cmo)))
            locus(i,trait)=midpar+segsd*dble(randn())
   15     continue
          do 16 i=1, num
            locus(i,trait)=aconst*locus(i,trait)+econst*dble(randn())
            if (loctyp.eq.4) then
              if (locus(i,trait).gt.0.0d0) then
                locus(i,trait)=2.0d0
              else
                locus(i,trait)=1.0d0
              end if
            end if
   16     continue
        else
C Conditional on ibd at marker
          gen2=gene+1
          do 25 i=1,num
            if (locus(i,gene).le.KNOWN) then
              g1=getnam(-locus(i,gene),numal,name)
              g2=getnam(-locus(i,gen2),numal,name)
            else
              g1=getnam(locus(i,gene),numal,name)
              g2=getnam(locus(i,gen2),numal,name)
            end if
            call update(i,g1,g2,set)
   25     continue
          call simibd(2,pedigree,num,nfound,fa,mo,set,sibd)
          do 30 i=1,2*nfound 
            call found(cumfrq,key(i))
   30     continue
          do 35 i=1,num    
            locus(i,trait)=aconst*(key(sibd(i,1))+key(sibd(i,2))-3) +
     &                     econst*randn()
            if (loctyp.eq.4) then
              if (locus(i,trait).gt.0.0d0) then
                locus(i,trait)=2.0d0
              else
                locus(i,trait)=1.0d0
              end if
            end if
   35     continue
        end if
        call wrkout(twrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &              numloc)
      goto 5
   20 continue
C
      return
      end
C end-of-wrsimq
C
C N-way cross-tabulation
C
      subroutine xtab(wrk,analys,nloc,loclist,loc,locpos,loctyp,
     2                pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     3                numloc,val,values,idx,icount,iter,tble,plevel)
      integer KNOWN, MAXSIZ, MAXLOC, MISS, VSIZ
      parameter(KNOWN=0, MAXSIZ=20, MAXLOC=10000, 
     &          MISS=-9999, VSIZ=MAXSIZ*MAXLOC)
 
      integer analys,nloc, numloc,plevel,wrk
      integer loclist(nloc)
C current data vector
      double precision val(MAXSIZ)
C
C Locus structure:
C number of loci, locus name, locus type, and locus position in file
C
      character*20 loc(MAXLOC)
      integer loctyp(MAXLOC),locpos(MAXLOC)
C
C contingency table: idx points to data vector in values
      integer ncells
      integer idx(MAXSIZ), icount(MAXSIZ)
      integer topcat
      real values(VSIZ)
C  Pedigree structure
      character*10 pedigree
      integer actset,num, nfound
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ)
      integer sex(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)
C flat contingency table for permutation P and number of permutations
      integer iter
      integer tble(MAXSIZ)
C local variables
      integer i, iwt, j, lpos, margin, nmarg, nmiss, pos, tot, totdim
      integer ndim(MAXSIZ)
      logical last
C functions
      integer eow
      real encgtp

      nmarg=0
      nmiss=0
      ncells=0
      topcat=0
      tot=0
      last=.false.
      rewind(wrk)
    5 continue
        call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &             numloc, last)
        if (last) goto 20

        if (actset.le.0) goto 5

        do 7 i=1,num
          do 8 j=1, nloc
            lpos=locpos(loclist(j))
            val(j)=locus(i,lpos)
            if (val(j).eq.MISS .or. 
     &          (loctyp(loclist(j)).le.2 .and. val(j).le.KNOWN)) then
              nmiss=nmiss+1
              goto 7
            else if (loctyp(loclist(j)).le.2) then
              val(j)=encgtp(locus(i,lpos),locus(i,lpos+1))
            end if
    8     continue
          tot=tot+1
          call qtabn(nloc,val,ncells,MAXSIZ,idx,icount,0,
     &               topcat,VSIZ,values,1)
    7   continue
      goto 5
   20 continue
C accumulate table margins
      if (nloc.gt.1) then
        margin=ncells
        do 50 i=1,ncells
          pos=idx(i)
          do 60 j=1, nloc
            val(1)=float(j)
            val(2)=values(pos)
            iwt=icount(i)
            call qtabn(2,val,nmarg,MAXSIZ,idx,icount,margin,
     &                 topcat,VSIZ,values,iwt)
            pos=pos+1
   60     continue
   50   continue
        call dimtab(nloc, ncells, nmarg, idx, values, ndim, totdim)
      end if
C write the table
      if (nloc.eq.1) then
        if (plevel.gt.0) then
          write(*,'(/a/3a/a)')
     2    '------------------------------------',
     3    'Tabulation of "',loc(loclist(1)),'"',
     5    '------------------------------------'
        end if
      else 
        write(*,'(/a/5a/a)')
     2    '------------------------------------------------',
     3    'Cross-tabulation of "',
     4    loc(loclist(1))(1:eow(loc(loclist(1)))), '" ... "',
     5    loc(loclist(nloc))(1:eow(loc(loclist(nloc)))),'"',
     6    '------------------------------------------------'
      end if
C print rectangular or listwise table
      if (nloc.eq.1 .and. plevel.lt.1) then
        call onetab(nloc, loclist, loc, loctyp, ncells, idx, 
     &              icount, values, nmiss, tot)
      else if (tot.eq.0) then
        write(*,'(a)') 'No complete observations.'
      else if (nloc.eq.2) then
        call wrtab(analys, nloc, loclist, ndim, loc, loctyp, ncells,
     &              nmarg, idx, icount, values, tot, totdim, tble, iter)
      else
        call listab(nloc, loclist, loc, loctyp, ncells, idx, 
     &              icount, values, tot)
      end if
      return
      end
C end-of-xtab  
C
C Get extent of contingency table
C
      subroutine dimtab(nloc, ncells, nmarg, idx, values, ndim, totdim)
      integer nloc, nmarg, ncells, totdim
      integer ndim(nloc)
C contingency table
      integer idx(*)
      real values(*)
C local variables 
      integer curr, n, i
      n=0
      curr=1
      do 70 i=ncells+1, ncells+nmarg
        if (int(values(idx(i))).eq.curr) then
          n=n+1
        else
          ndim(curr)=n
          curr=curr+1
          n=1
        end if
   70 continue
      ndim(curr)=n
      totdim=ndim(1)
      do 100 i=2, nloc
        totdim=totdim*ndim(i)
  100 continue
      return
      end
C end-of-dimtab
C
C print summary of one-way table
      subroutine onetab(nloc, loclist, loc, loctyp, ncells, idx, 
     &                  icount, values, nmiss, tot)
      integer KNOWN, MAXSIZ, MAXLOC, MISS, VSIZ
      parameter(KNOWN=0, MAXSIZ=20, MAXLOC=10000, 
     &          MISS=-9999, VSIZ=MAXSIZ*MAXLOC)
      integer nloc, nmiss, tot
      integer loclist(nloc)
C number of loci, locus name, locus type, and locus position in file
      character*20 loc(MAXLOC)
      integer loctyp(MAXLOC)
C contingency table
      integer idx(MAXSIZ), icount(MAXSIZ)
      real values(VSIZ)
C local variables 
      integer i, j, n1, n2
      character*7 gtp, gtp2
C functions
      integer eow

      i=loclist(1)
      if (loctyp(i).eq.4) then
        n1=0
        n2=0
        do 95 j=1, ncells
          if (values(idx(j)).eq.1.0) n1=icount(j)
          if (values(idx(j)).eq.2.0) n2=icount(j)
   95   continue
        write(*,'(a,1x,a,i5,2(a8,i5))') 
     &    loc(i),'x:',nmiss,'y:',n2,'n:',n1
      elseif (ncells.gt.6) then
        call wrtrait(dble(values(idx(1))),gtp,loctyp(i))
        call wrtrait(dble(values(idx(ncells))),gtp2,loctyp(i))
        call juststr('l',gtp2,7)
C       write(*,'(a,1x,a,i5,a8,i5,a,i5,a,2(f7.1,a))') 
        write(*,'(a,1x,a,i5,a8,i5,a,i5,5a)') 
     2    loc(i),'x:',nmiss,'y:',tot,' (',ncells,' unique values ',
     3    gtp ,'...', gtp2(1:eow(gtp2)), ')'
C    3    values(idx(1)),'...',
C    5    values(idx(ncells)),')'
      else
        write(*,'(a,1x,a,i5,$)') loc(i),'x:',nmiss
        if (loctyp(i).eq.3) then
          do 100 j=1,ncells
            write(*,'(1x,f7.1,a,i5,$)') values(idx(j)),':',icount(j)
  100     continue
        else
          do 110 j=1,ncells
            call decgtp(values(idx(j)),n1,n2)
            call wrgtp(n1,n2,gtp,1)
            call juststr('r',gtp,7)
            write(*,'(1x,2a,i5,$)') gtp,':',icount(j)
  110     continue
        end if
        write(*,*)
      end if
      return
      end
C end-of-onetab  
C
C print listwise contingency table
      subroutine listab(nloc, loclist, loc, loctyp, ncells, idx, 
     &                  icount, values, tot)
      integer KNOWN, MAXSIZ, MAXLOC, MISS, VSIZ
      parameter(KNOWN=0, MAXSIZ=20, MAXLOC=10000, 
     &          MISS=-9999, VSIZ=MAXSIZ*MAXLOC)
 
      integer nloc, tot
      integer loclist(nloc)
C number of loci, locus name, locus type, and locus position in file
      character*20 loc(MAXLOC)
      integer loctyp(MAXLOC)
C contingency table
      integer idx(MAXSIZ), icount(MAXSIZ)
      real values(VSIZ)
C local variables 
      integer i, j, pos
      character*10 cval
      double precision wt

      do 100 j=1, nloc
        cval=loc(loclist(j))
        call juststr('c',cval,10)
        write(*,'(a10,1x,$)') cval
  100 continue
      write(*,'(a/a,$)') '   Count  Percent',
     &  '------------------'
      do 110 j=1, nloc
        write(*,'(a10,$)') '----------'
  110 continue
      write(*,*)
      wt=100.0d0/dfloat(max(1,tot))
      do 150 i=1,ncells
        pos=idx(i)
        do 160 j=1, nloc
          call wrtrait(dble(values(pos)),cval,loctyp(loclist(j)))
          write(*,'(a10,1x,$)') cval
          pos=pos+1
  160   continue
        write(*,'(1x,i6,4x,f5.1)') icount(i), wt*dfloat(icount(i))
  150 continue
      return
      end
C end-of-listab
C
C print RxC contingency table 
      subroutine wrtab(analys, nloc, loclist, ndim, loc, loctyp, 
     2             ncells, nmarg, idx, icount, values, tot, totdim, 
     3             tble, iter)
      integer KNOWN, MAXSIZ, MAXLOC, MISS, VSIZ
      double precision TOL
      parameter(KNOWN=0, MAXSIZ=20, MAXLOC=10000, 
     &          MISS=-9999, TOL=1.0d-6, VSIZ=MAXSIZ*MAXLOC)
 
      integer analys, nloc, tot, totdim
      integer loclist(nloc), ndim(nloc)
C number of loci, locus name, locus type, and locus position in file
      character*20 loc(MAXLOC)
      integer loctyp(MAXLOC)
C contingency table
      integer ncells, nmarg
      integer idx(MAXSIZ), icount(MAXSIZ)
      real values(VSIZ)
C flat table for permutation P
      integer iter
      integer tble(MAXSIZ)
      double precision ex(MAXSIZ)
C local variables 
      integer address, cnt, df, g1, g2, het, i, icell, issnp, 
     &        n(4), ncol, nxtcell, offset, pos, t1, t2
      character*10 cval1, cval2
      real curr
      double precision er, e, kwstat, nr, pa, pvalue, 
     &                 rank, rankg, ties
      double precision mean(1), x(1), ss(1)
C functions
      double precision chip

      het=MISS
      issnp=0
      ncol=0
      pa=0.0d0
      t1=loclist(1)
      t2=loclist(2)
      cval1=loc(t1)
      cval2=loc(t2)
      n(1)=0
      n(2)=0
      n(3)=0
      n(4)=0
C print as 2x2 table
      if (loctyp(t1).eq.4 .and. loctyp(t2).eq.4) then
        do 10 i=1,ncells
          n(7-2*int(values(idx(i)))-int(values(idx(i)+1)))=icount(i)
   10   continue
        call juststr('c',cval2,10)
        write(*,'(/19x,a10/a10,8x,a3,5x,a/a)') cval2,cval1,
     &    'Yes',' No  Percent','--------------------------------------'
        write(*,'(7x,a3,5x,i6,2x,i6,4x,f5.1)') 
     &    'Yes',n(1),n(2),1.0d2*dfloat(n(1))/dfloat(max(1,n(1)+n(2))) 
        write(*,'(7x,a3,5x,i6,2x,i6,4x,f5.1)') 
     &    ' No',n(3),n(4),1.0d2*dfloat(n(3))/dfloat(max(1,n(3)+n(4))) 
          write(*,'(/a,f6.1)') 'Odds Ratio              = ',
     2      (0.5d0+dfloat(n(1)))*(0.5d0+dfloat(n(4)))/
     3      (0.5d0+dfloat(n(2)))/(0.5d0+dfloat(n(3))) 
C print as RxC table
      else if ((ndim(1).lt.20.or.loctyp(t1).ne.3) .and. 
     &         ndim(2).lt.8 .and. analys.eq.1) then
        write(*,'(/22x,a10/2a,$)') cval2,cval1,' '
        ncol=ndim(2)
        offset=ncells+ndim(1)
        if (loctyp(t2).eq.1 .and. ndim(2).le.3) then
          ncol=ncol+2
          issnp=ndim(2)
          n(1)=0
          n(2)=0
          n(3)=0
        end if
        do 20 i=1, ndim(2)
          pos=idx(offset+i)+1
          if (issnp.gt.0) then
            call decgtp(values(pos),g1,g2)
            if (g1.ne.g2) het=i
          end if
          call wrtrait(dble(values(pos)),cval2,loctyp(t2))
          write(*,'(3x,a10,$)') cval2
   20   continue
          
        offset=ncells
        icell=0
        nxtcell=1
        call fullidx(nxtcell, nloc, ndim, ncells, idx,
     &               values,totdim,address)
        if (issnp.gt.0) then
          write(*,'(2x,a11,2x,a11,$)') 'Allele Freq', 'Exact HWE-P'
        end if
        write(*,'(/11x,8(a13):)') ('--------------', i=1, ncol)
        do 50 i=1, ndim(1)
          call wrtrait(dble(values(idx(offset+i)+1)),cval1,loctyp(t1))
          write(*,'(a10,1x,$)') cval1
          nr=dfloat(icount(offset+i))
          er=nr/dfloat(max(1,tot))
          if (issnp.gt.0) pa=0.0d0
          do 25 j=1, ndim(2)
            icell=icell+1
            if (icell.eq.address) then
              cnt=icount(nxtcell)
              nxtcell=nxtcell+1
              call fullidx(nxtcell, nloc, ndim, ncells, idx,
     &                     values, totdim, address)
            else
              cnt=0
            end if
            e=dfloat(cnt)/max(1.0d0,nr)
            if (e.eq.1.0d0) then
              write(*,'(1x,i5,1x,a,$)') cnt,'(1.00)'
            else
              write(*,'(1x,i5,1x,a,f4.3,a,$)') cnt,'(',e,')'
            end if
            if (issnp.gt.0) then
              cov=cov+cnt*(i-1-mr)*(c-1-mc);
              n(j)=cnt
              if (j.eq.1) then
                pa=e
              else if (issnp.eq.3 .and. j.eq.2) then
                pa=pa+0.5d0*e
              end if
            end if
            tble(icell)=cnt
            ex(icell)=er*dfloat(icount(offset+ndim(1)+j))
   25     continue
          if (issnp.gt.0) then
            if (het.ne.2) then
              n(4)=n(2)
              n(2)=n(het)
              n(het)=n(4)
            end if
            call hwe2(n(1), n(2), n(3), pa, pvalue)
            write(*,'(2(2x,f6.4), 5x, f6.4, $)') pa, 1.0d0-pa, pvalue
          end if
          write(*,*)
   50   continue
        call rctest(ndim(1), ndim(2), tble, ex, idx, icount, iter)
C one-way table of means
      else if (analys.eq.2 .or.(ndim(1).lt.8.and.loctyp(t2).eq.3)) then
        write(*,'(/22x,a10/a,6x,a,14x,a,7x,a/11x,a)') 
     2    cval2,cval1,'Mean','SD','Count',
     3       '---------------------------------------'
        kwstat=0.0d0
        rankg=0.0d0
        mean(1)=0.0d0
        ss(1)=0.0d0
        icell=0
        offset=ncells+ndim(1)
        curr=values(idx(1))
        do 80 i=1, ncells
          if (values(idx(i)).ne.curr) then
            kwstat=kwstat+rankg*rankg/dfloat(icell)
            call wrtrait(dble(curr),cval1,loctyp(t1))
            write(*,'(a10,3x,f12.4,3x,f12.4,1x,i7)') 
     &        cval1, mean(1), sqrt(ss(1)/dfloat(max(icell-1,1))), icell
            curr=values(idx(i))
            icell=0
            mean(1)=0.0d0
            rankg=0.0d0
            ss(1)=0.0d0
          end if
          icell=icell+icount(i)
          x(1)=dble(values(idx(i)+1))
          call dssp(1,icell,icount(i),x,mean,ss)
          rank=0.0d0
          do 90 j=1, ndim(2)
            rank=rank+dfloat(icount(offset+j))
            if (values(idx(i)+1).eq.values(idx(offset+j)+1)) then
               rank=rank-0.5d0*float(icount(offset+j)-1)
               goto 91
            end if
   90     continue
   91     continue
          rankg=rankg+dfloat(icount(i))*rank
   80   continue
        kwstat=kwstat+rankg*rankg/dfloat(icell)
        call wrtrait(dble(curr),cval1,loctyp(t1))
        write(*,'(a10,3x,f12.4,3x,f12.4,1x,i7)') 
     &    cval1, mean(1), sqrt(ss(1)/dfloat(max(icell-1,1))), icell
C Kruskal-Wallis test statistic, then correction for ties
        kwstat=12.0d0*kwstat/dfloat(tot*(tot+1)) - dfloat(3*(tot+1))
        ties=0.0d0
        do 100 j=1, ndim(2)
          ties=ties+dble(icount(offset+j)**3-icount(offset+j))
  100   continue
        kwstat=kwstat/(1.0d0 - ties/dfloat(tot**3-tot))
        df=(ndim(1)-1)
        write(*,'(/a,f7.2,a,i3,a,f6.4,a)') 
     2     'Kruskal-Wallis H=', kwstat, 
     3     ' df=',df,' (P=', chip(kwstat,df),')'
      else
        call listab(nloc, loclist, loc, loctyp, ncells, idx, 
     &              icount, values, tot)
      end if
      return
      end
C end-of-wrtab 
C
C Location of given cell in complete table
C
      subroutine fullidx(icell, nloc, ndim, ncells, 
     &                   idx, values, totdim, address)
      integer MAXSIZ, MAXLOC, VSIZ
      parameter(MAXSIZ=20, MAXLOC=10000, VSIZ=MAXSIZ*MAXLOC)
      integer address, icell, nloc, offset, totdim 
      integer ndim(nloc)
C contingency table
      integer ncells
      integer idx(MAXSIZ)
      real values(VSIZ)

      integer i, j, mult, pos

      address=1
      mult=totdim
      offset=ncells
      do 10 i=1, nloc
        mult=mult/ndim(i)
        do 20 j=1, ndim(i)
          pos=idx(offset+j)+1
          if (values(pos).eq.values(idx(icell)+i-1)) then
            address=address+mult*(j-1)
          end if
   20   continue
        offset=offset+ndim(i)
   10 continue
      return
      end
C end-of-fullidx
C
C Binary trait prevalences and recurrence risks.
C
      subroutine segrat(wrk,locnam,trait,pedigree,actset,num,nfound,
     &                 id,fa,mo,sex, locus, numloc)
C
      integer numloc,trait,wrk
      character*10 locnam
C  Pedigree structure
      integer MAXSIZ, MAXLOC, MISS
      parameter(MAXSIZ=20, MAXLOC=10000, MISS=-9999)
      character*10 pedigree
      integer actset,num, nfound
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ)
      integer sex(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)
C
      integer i, pos, sta, currf,currm
      integer aff(6),den(6),mat(3),matyp,naff,nmiss,nmissf,nsib
      integer sscon, ssdis, hscon, hsdis, gpcon, gpdis, pocon, podis
      real segr(6), ssrec,hsrec,porec, gprec, marrec
      logical last, sibshp
      gpcon=0
      gpdis=0
      gprec=0.0
      hscon=0
      hsdis=0
      hsrec=0.0
      marrec=0.0
      naff=0
      nmiss=0
      nmissf=0
      nsib=0
      pocon=0
      podis=0
      porec=0.0
      sscon=0
      ssdis=0
      ssrec=0.0
      mat(1)=0
      mat(2)=0
      mat(3)=0
      do 1 i=1,6
        aff(i)=0
        den(i)=0
        segr(i)=0.0
    1 continue
      last=.false.
      rewind(wrk)
    5 continue
        call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &             numloc, last)
        if (last) goto 20

        if (actset.le.0) goto 5

        do 7 i=1,num
        if (locus(i,trait).ne.1 .and. locus(i,trait).ne.2) then
          nmiss=nmiss+1
          if (i.le.nfound) nmissf=nmissf+1
        else
          den(4)=den(4)+1
          if (locus(i,trait).eq.2) aff(4)=aff(4)+1
          if (i.le.nfound) then
             den(5)=den(5)+1
             if (locus(i,trait).eq.2) aff(5)=aff(5)+1
          else
             den(6)=den(6)+1
             if (locus(i,trait).eq.2) aff(6)=aff(6)+1
          end if
          do 8 j=max(nfound+1,i+1),num
          if (locus(j,trait).eq.1 .or. locus(j,trait).eq.2) then
            if ((fa(j).eq.i.or.mo(j).eq.i) .or.
     &          (i.gt.nfound .and. (fa(i).eq.j.or.mo(i).eq.j))) then
              if (locus(i,trait).eq.2.and.locus(j,trait).eq.2) then
                pocon=pocon+1
              elseif (locus(i,trait).ne.locus(j,trait)) then
                podis=podis+1
              end if
            elseif ((fa(j).gt.nfound .and. 
     2                     (fa(fa(j)).eq.i .or. mo(fa(j)).eq.i)) .or.
     3              (mo(j).gt.nfound .and. 
     4                     (fa(mo(j)).eq.i .or. mo(mo(j)).eq.i)))
     5      then
              if (locus(i,trait).eq.2.and.locus(j,trait).eq.2) then
                gpcon=gpcon+1
              elseif (locus(i,trait).ne.locus(j,trait)) then
                gpdis=gpdis+1
              end if
            elseif (i.gt.nfound) then
              if (fa(i).eq.fa(j).and.mo(i).eq.mo(j)) then
                if (locus(i,trait).eq.2.and.locus(j,trait).eq.2) then
                  sscon=sscon+1
                elseif (locus(i,trait).ne.locus(j,trait)) then
                  ssdis=ssdis+1
                end if
              elseif (fa(i).eq.fa(j).or.mo(i).eq.mo(j)) then
                if (locus(i,trait).eq.2.and.locus(j,trait).eq.2) then
                  hscon=hscon+1
                elseif (locus(i,trait).ne.locus(j,trait)) then
                  hsdis=hsdis+1
                end if
              elseif ((fa(i).gt.nfound .and. 
     2                       (fa(fa(i)).eq.j .or. mo(fa(i)).eq.j)) .or.
     3                (mo(i).gt.nfound .and. 
     4                       (fa(mo(i)).eq.j .or. mo(mo(i)).eq.j))) 
     5        then
                if (locus(i,trait).eq.2.and.locus(j,trait).eq.2) then
                  gpcon=gpcon+1
                elseif (locus(i,trait).ne.locus(j,trait)) then
                  gpdis=gpdis+1
                end if
              end if
            end if
          end if
    8     continue
        end if
    7   continue
C
C If any nonfounders, do segregation ratios

        if (nfound.eq.num) goto 5

        pos=nfound+1
        sta=pos
        currf=fa(sta)
        currm=mo(sta)
        last=.false.
        sibshp=.false.        
C through sibship by sibship
   10   continue
          if (pos.gt.num) then
            last=.true.
            sibshp=.true.
          elseif (currf.ne.fa(pos) .or. currm.ne.mo(pos)) then
            sibshp=.true.
          end if
          if (sibshp .and. locus(currf,trait).ne.MISS .and.
     2        locus(currm,trait).ne.MISS) 
     3    then
            matyp=1
            if (locus(currf,trait).eq.2) matyp=matyp+1
            if (locus(currm,trait).eq.2) matyp=matyp+1
            mat(matyp)=mat(matyp)+1
            do 12 i=sta,pos-1
              if (locus(i,trait).ne.MISS) then
                nsib=nsib+1
                den(matyp)=den(matyp)+1
              end if
              if (locus(i,trait).eq.2) then
                aff(matyp)=aff(matyp)+1
                naff=naff+1
              end if
   12       continue
          end if
C exit if last sibship
        if (last) goto 5
C else move to next sibship if appropriate and iter
          if (sibshp) then
            sibshp=.false.
            sta=pos
            currf=fa(sta)
            currm=mo(sta)
          end if
          pos=pos+1
        goto 10

C end of segregation ratio loop

   20 continue
C
C last pedigree -- write output
C
      write(*,'(/a/a,a10,a/a/)')
     2  '------------------------------------------------',
     3  'Segregation ratios for trait "',locnam,'"',
     4  '------------------------------------------------'
      do 22 i=1,6
   22   if (den(i).gt.0) segr(i)=float(aff(i))/float(den(i))
      write(*,'(a/a)') 'Total sample   All       Fndrs     Nonfndrs',
     &                 '-------------------------------------------'
      write(*,'(3x,a8,3(1x,i4,a1,i4)/3x,a8,3(5x,f5.3)/3x,a8,3(5x,i5))') 
     2      'Aff/Tot ', aff(4),'/',den(4), aff(5),'/',den(5),
     3      aff(6),'/',den(6), 'Prop Aff',segr(4), segr(5), segr(6),
     4      'Missing ',nmiss,nmissf,nmiss-nmissf
      write(*,'(/a/a)') 'Mating Type     UxU       UxA       AxA',
     &                  '-------------------------------------------'
      write(*,'(3x,a8,3i10/3x,a8,3(1x,i4,a1,i4)/3x,a8,3(5x,f5.3))') 
     2      'Matings ', mat(1),mat(2),mat(3),
     3      'Aff/Tot ', aff(1),'/',den(1), aff(2),'/',den(2),
     4      aff(3),'/',den(3), 'Prop Aff',segr(1), segr(2), segr(3)
      write(*,'(/a/a)') 'Relative pair  RecRisk   Aff-Aff   Aff-UnA',
     &                  '-------------------------------------------'
      if ((pocon+podis).gt.0) 
     &  porec=float(2*pocon)/float(2*pocon+podis)
      if ((sscon+ssdis).gt.0) 
     &  ssrec=float(2*sscon)/float(2*sscon+ssdis)
      if ((hscon+hsdis).gt.0) 
     &  hsrec=float(2*hscon)/float(2*hscon+hsdis)
      if ((gpcon+gpdis).gt.0) 
     &  gprec=float(2*gpcon)/float(2*gpcon+gpdis)
      if ((mat(2)+mat(3)).gt.0) 
     &  marrec=float(2*mat(3))/float(2*mat(3)+mat(2))
      write(*,'(3x,a,5x,f5.3,2(5x,i5),4(/3x,a,5x,f5.3,2(5x,i5)))')  
     2      'Marital ',marrec, mat(3), mat(2),
     3      'Gparent ', gprec, gpcon, gpdis,
     4      'Halfsib ', hsrec, hscon, hsdis,
     5      'Par-Off ', porec, pocon, podis,
     6      'Fullsib ', ssrec, sscon, ssdis
      return
      end
C end-of-segrat
C                                                                           
C  Segregation ratios using Davie 1976
C
      subroutine davie(wrk,loc1,trait,loc2,proband,pedigree,actset,num,
     &                 nfound, id,fa,mo,sex, locus, numloc, plevel)
C
      integer numloc,plevel,proband,trait,wrk
      character*10 loc1, loc2
C  Pedigree structure
      integer MAXSIZ, MAXLOC, MISS, NCLASS
      parameter(MAXSIZ=20, MAXLOC=10000, MISS=-9999, NCLASS=4)
      character*10 pedigree
      integer actset,num, nfound
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ)
      integer sex(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)
C
      integer currf, currm, i, matyp, npro, pos, sta
      integer j(NCLASS), mat(NCLASS), q(NCLASS), r(NCLASS), t(NCLASS)
      double precision den, phat(NCLASS), se(NCLASS)
      logical last, sibshp
C functions
      integer eow

      write(*,'(/a/3a/a)')
     2  '---------------------------------------------------',
     3  'Corrected segregation ratios for trait "',loc1,'"',
     4  '---------------------------------------------------'
      if (trait.eq.proband) then
        write(*,'(a)') 
     &    'NOTE:  Assuming complete ascertainment.'
      else
        write(*,'(3a)') 'NOTE:  Proband defined by "',
     &     loc2(1:eow(loc2)),'".'
      end if

      if (plevel.gt.1) then
        write(*,'(/a,11x,a)') 'Pedigree   Parents',
     &                  'Faff Maff  Npro Naff  Tot'
      end if
      
      do 1 i=1,NCLASS
        j(i)=0
        mat(i)=0
        phat(i)=0.0d0
        r(i)=0
        q(i)=0
        t(i)=0
    1 continue
      last=.false.
      rewind(wrk)
    5 continue
        call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &             numloc, last)
        if (last) goto 20

        if (actset.le.0) goto 5

        pos=nfound+1
        sta=pos
        currf=fa(sta)
        currm=mo(sta)
        last=.false.
        sibshp=.false.        
C through sibship by sibship
   10   continue
          if (pos.gt.num) then
            last=.true.
            sibshp=.true.
          elseif (currf.ne.fa(pos) .or. currm.ne.mo(pos)) then
            sibshp=.true.
          end if
          if (sibshp) then
            npro=0
            do 13 i=sta,pos-1
            if (locus(i,proband).eq.2 .and. locus(i,trait).eq.2) then
              npro=npro+1
            end if
   13       continue
            call davstat(4,pos,sta,npro,trait,locus,mat,j,q,t,r)
            if (locus(currf,trait).ne.MISS .and.  
     &          locus(currm,trait).ne.MISS) then
              matyp=1
              if (locus(currf,trait).eq.2.0) matyp=matyp+1
              if (locus(currm,trait).eq.2.0) matyp=matyp+1
              call davstat(matyp,pos,sta,npro,trait,locus,mat,j,q,t,r)
            end if

            if (plevel.gt.1) then
              call  davwri(pedigree, currf, currm, pos, sta,
     &                     npro, trait, id, locus)
            end if
          end if
C exit if last sibship
        if (last) goto 15
C else move to next sibship if appropriate and iter
          if (sibshp) then
            sibshp=.false.
            sta=pos
            currf=fa(sta)
            currm=mo(sta)
          end if
          pos=pos+1
        goto 10
   15   continue
C
      goto 5
   20 continue
C
C last pedigree -- write output
C
      do 100 i=1,NCLASS
        den=dfloat(t(i)-j(i))
        if (den.gt.0.0d0) then
          phat(i)=dfloat(r(i)-j(i))/den
          se(i)=dfloat((r(i)-j(i))*(t(i)-r(i)))/den**3.0d0 + 
     &          dfloat(2*q(i)*(t(i)-r(i))**2)/den**4.0d0 
          se(i)=sqrt(se(i)) 
        else
          phat(i)=0.0d0
          se(i)=0.0d0
        end if
  100 continue
      write(*,'(/a/a)') 'Mating Type   UxU      UxA      AxA     All',
     &  '-----------------------------------------------'
      write(*,'(3x,a8,4i9/3x,a8,4(1x,i3,a1,i4),2(/3x,a8,4(4x,f5.3)))') 
     2  'Matings ', mat(1),mat(2),mat(3),mat(4), 'Aff/Tot ',
     3   r(1),'/',t(1), r(2),'/',t(2), r(3),'/',t(3), r(4),'/',t(4),
     5  'Risk    ',phat(1), phat(2), phat(3), phat(4),
     6  'Std Err ',se(1),se(2),se(3), se(4)
      return
      end
C end-of-davie
C
C Accumulate counts needed for Davie formula in current family
C
      subroutine davstat(typ,pos,sta,npro,trait,locus,class,j,q,t,r)

      integer MAXSIZ, MAXLOC, MISS, NCLASS
      parameter(MAXSIZ=20, MAXLOC=10000, MISS=-9999, NCLASS=4)
      integer npro, pos, sta, trait, typ
      integer class(NCLASS), j(NCLASS), q(NCLASS), r(NCLASS), t(NCLASS)
      double precision locus(MAXSIZ,MAXLOC)
C
      integer i

      class(typ)=class(typ)+1
      if (npro.eq.1) then
        j(typ)=j(typ)+1
      end if
      if (npro.eq.2) then
        q(typ)=q(typ)+1
      end if
      do 10 i=sta,pos-1
        if (locus(i,trait).ne.MISS) then
          t(typ)=t(typ)+1
        end if
        if (locus(i,trait).eq.2) then
          r(typ)=r(typ)+1
        end if
   10 continue
      return
      end
C end-of-davstat
C
C print prop affected per sibship
C
      subroutine davwri(pedigree, currf, currm, pos, sta, 
     &                  npro,trait,id,locus)

      integer MAXSIZ, MAXLOC, MISS
      parameter(MAXSIZ=20, MAXLOC=10000, MISS=-9999)
      integer currf, currm, npro, pos, sta, trait
      character*10 pedigree
      character*10 id(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)
      integer i, na, nt
      character*1 af, am
C
      na=0
      nt=0
      call wraff(locus(currf,trait),af)
      call wraff(locus(currm,trait),am)
      do 50 i=sta,pos-1
      if (locus(i,trait).ne.MISS) then
        nt=nt+1   
        if (locus(i,trait).eq.2.0) na=na+1   
      end if
   50 continue
      write(*,'(3(a,1x),2(3x,a1,1x),3i5)') 
     &  pedigree, id(currf), id(currm), af, am, npro, na, nt
      return
      end
C end-of-davwri
C
C Quantitative trait relatives means and covariances
C
      subroutine famcor(wrk,locnam,trait,pedigree,actset,num,nfound,
     &                 id,fa,mo,sex, locus, numloc,plevel)
 
      integer numloc,plevel,trait,wrk
      character*10 locnam
C  Pedigree structure
      integer MAXSIZ, MAXLOC, MISS, NCLASS
      parameter(MAXSIZ=20, MAXLOC=10000, MISS=-9999, NCLASS=12)
      character*10 pedigree
      integer actset,num, nfound
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ)
      integer sex(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)
C
      integer i, pos, sta, currf,currm, nships, nsibs
      integer nmiss,nmissf,npairs(NCLASS), tnum(3)
      double precision  mean(3), tvar(3), maxv(3), minv(3)
      double precision cov(NCLASS), mu(NCLASS,2), cvar(NCLASS,2), x1, x2
C Sibship variance test regression results
      double precision x(3),r(6),b(2)
      double precision alpha,beta,sea,seb,ssm,ssw,tvalb
      logical last, sibshp
      character*12 midpar
C functions
      double precision probst
      nmiss=0
      nmissf=0
      nships=0
      do 1 i=1,3
        maxv(i)=-1.0d20
        minv(i)=+1.0d20
        mean(i)=0.0d0
        tvar(i)=0.0d0
        tnum(i)=0 
    1 continue
      do 2 i=1,NCLASS
        mu(i,1)=0.0d0
        mu(i,2)=0.0d0
        npairs(i)=0
        cvar(i,1)=0.0d0
        cvar(i,2)=0.0d0
        cov(i)=0.0d0
    2 continue
      do 3 i=1,6
        r(i)=0.0d0
    3 continue
      j=0
      do 4 i=1,3
        j=j+i
        r(j)=-1.0d0
    4 continue
      write(*,'(/a/a,a10,a/a/)')
     2  '------------------------------------------------',
     3  'Summary statistics for trait "',locnam,'"',
     4  '------------------------------------------------'
      if (plevel.gt.1) then
        write(*,'(2a/2a)') 
     2  'Pedigree   Father   Mother   Midparent    Sibship Mean',
     3  ' log(Sibs Var)',
     4  '---------- -------- -------- ------------ ------------',
     5  ' ------------'
      end if
      last=.false.
      rewind(wrk)
    5 continue
        call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &             numloc, last)
        if (last) goto 20

        if (actset.le.0) goto 5

        do 7 i=1,num
        if (locus(i,trait).eq.MISS) then
          nmiss=nmiss+1
          if (i.le.nfound) nmissf=nmissf+1
        else
          x1=dble(locus(i,trait))
          if (x1.gt.maxv(1)) then
            maxv(1)=x1
          end if
          if (x1.lt.minv(1)) then
            minv(1)=x1
          end if
          tnum(1)=tnum(1)+1
          call moment(tnum(1),x1,mean(1),tvar(1))
          if (i.le.nfound) then
            if (x1.gt.maxv(2)) then
              maxv(2)=x1
            end if
            if (x1.lt.minv(2)) then
              minv(2)=x1
            end if
            tnum(2)=tnum(2)+1
            call moment(tnum(2),x1,mean(2),tvar(2))
          else
            if (x1.gt.maxv(3)) then
              maxv(3)=x1
            end if
            if (x1.lt.minv(3)) then
              minv(3)=x1
            end if
            tnum(3)=tnum(3)+1
            call moment(tnum(3),x1,mean(3),tvar(3))
          end if
          do 8 j=max(nfound+1,i+1),num
          if (locus(j,trait).ne.MISS) then
            x2=dble(locus(j,trait))
            if (fa(j).eq.i.or.mo(j).eq.i) then
              call corr(4,x1,x2,NCLASS,npairs,mu,cvar,cov)    
              if (sex(i).eq.1 .and. sex(j).eq.1) then
                call corr(6,x1,x2,NCLASS,npairs,mu,cvar,cov)    
              else if (sex(i).eq.1 .and. sex(j).eq.2) then
                call corr(7,x1,x2,NCLASS,npairs,mu,cvar,cov)    
              else if (sex(i).eq.2 .and. sex(j).eq.1) then
                call corr(8,x1,x2,NCLASS,npairs,mu,cvar,cov)    
              else if (sex(i).eq.2 .and. sex(j).eq.2) then
                call corr(9,x1,x2,NCLASS,npairs,mu,cvar,cov)    
              end if
            elseif ((fa(j).gt.nfound .and. 
     2                    (fa(fa(j)).eq.i .or. mo(fa(j)).eq.i)) .or.
     3             (mo(j).gt.nfound .and. 
     4                    (fa(mo(j)).eq.i .or. mo(mo(j)).eq.i))) 
     5      then
              call corr(2,x1,x2,NCLASS,npairs,mu,cvar,cov)    
            elseif (i.gt.nfound) then
              if (fa(i).eq.j.or.mo(i).eq.j) then
                call corr(4,x2,x1,NCLASS,npairs,mu,cvar,cov)    
                if (sex(i).eq.1 .and. sex(j).eq.1) then
                  call corr(6,x2,x1,NCLASS,npairs,mu,cvar,cov)    
                else if (sex(i).eq.2 .and. sex(j).eq.1) then
                  call corr(7,x2,x1,NCLASS,npairs,mu,cvar,cov)    
                else if (sex(i).eq.1 .and. sex(j).eq.2) then
                  call corr(8,x2,x1,NCLASS,npairs,mu,cvar,cov)    
                else if (sex(i).eq.2 .and. sex(j).eq.2) then
                  call corr(9,x2,x1,NCLASS,npairs,mu,cvar,cov)    
                end if
              elseif (fa(i).eq.fa(j).and.mo(i).eq.mo(j)) then
                call corr(5,x1,x2,NCLASS,npairs,mu,cvar,cov)    
                call corr(5,x2,x1,NCLASS,npairs,mu,cvar,cov)    
                if (sex(i).eq.1 .and. sex(j).eq.1) then
                  call corr(10,x1,x2,NCLASS,npairs,mu,cvar,cov)    
                  call corr(10,x2,x1,NCLASS,npairs,mu,cvar,cov)    
                else if (sex(i).eq.2 .and. sex(j).eq.2) then
                  call corr(11,x1,x2,NCLASS,npairs,mu,cvar,cov)    
                  call corr(11,x2,x1,NCLASS,npairs,mu,cvar,cov)    
                else if ((sex(i)+sex(j)).eq.3) then
                  call corr(12,x1,x2,NCLASS,npairs,mu,cvar,cov)    
                end if
              elseif (fa(i).eq.fa(j).or.mo(i).eq.mo(j)) then
                call corr(3,x1,x2,NCLASS,npairs,mu,cvar,cov)    
                call corr(3,x2,x1,NCLASS,npairs,mu,cvar,cov)    
              elseif ((fa(i).gt.nfound .and. 
     2                    (fa(fa(i)).eq.j .or. mo(fa(i)).eq.j)) .or.
     3             (mo(i).gt.nfound .and. 
     4                    (fa(mo(i)).eq.j .or. mo(mo(i)).eq.j))) 
     5        then
                call corr(2,x2,x1,NCLASS,npairs,mu,cvar,cov)    
              end if
            end if
          end if
    8     continue
        end if
    7   continue

        pos=nfound+1
        sta=pos
        currf=fa(sta)
        currm=mo(sta)
        last=.false.
        sibshp=.false.        
C through sibship by sibship
   10   continue
          if (pos.gt.num) then
            last=.true.
            if (num.gt.nfound) sibshp=.true.
          elseif (currf.ne.fa(pos) .or. currm.ne.mo(pos)) then
            sibshp=.true.
          end if
          if (sibshp) then
            if (locus(currf,trait).ne.MISS .and. 
     2          locus(currm,trait).ne.MISS) 
     3      then
C marital correlation
              x1=dble(locus(currf,trait))
              x2=dble(locus(currm,trait))
              call corr(1,x1,x2,NCLASS,npairs,mu,cvar,cov)
              write(midpar,'(f12.4)') 0.5d0*(x1+x2)
            else
              midpar='       x    '
            end if
C within-sibship means and variances
            nsibs=0
            ssm=0.0d0
            ssw=0.0d0
            do 12 i=sta,pos-1
            if (locus(i,trait).ne.MISS) then
              x1=dble(locus(i,trait))
              nsibs=nsibs+1
              call moment(nsibs,x1,ssm,ssw)
            end if
   12       continue
            if (nsibs.gt.1 .and. ssw.gt.0.0d0) then
              nships=nships+1
              x(1)=1.0d0
              x(2)=ssm
              x(3)=log(ssw/dfloat(max(1,nsibs-1)))
              if (plevel.gt.1) then
                write(*,'(a10,1x,a10,1x,a10,1x,a12,2(1x,f12.4))') 
     &            pedigree,id(currf),id(currm),midpar,x(2),x(3)
              end if
              call givenc(r, 6, 3, x, 1.0d0, ifail)
            end if
          end if
C exit if last sibship
        if (last) goto 15
C else move to next sibship if appropriate and iter
          if (sibshp) then
            sibshp=.false.
            sta=pos
            currf=fa(sta)
            currm=mo(sta)
          end if
          pos=pos+1
        goto 10
   15   continue
C
      goto 5
   20 continue
C
C last pedigree -- write output
C
      if (tnum(1).gt.0) then
        tvar(1)=tvar(1)/dfloat(max(1,tnum(1)-1))
        tvar(2)=tvar(2)/dfloat(max(1,tnum(2)-1))
        tvar(3)=tvar(3)/dfloat(max(1,tnum(3)-1))
        if (tnum(2).eq.0) then
          maxv(2)=0.0d0
          minv(2)=0.0d0
        elseif (tnum(3).eq.0) then
          maxv(3)=0.0d0
          minv(3)=0.0d0
        end if
        if (plevel.gt.1 .and. nships.gt.0) then
          write(*,*)
        end if
        write(*,'(a/a)')
     2   'Descriptive Stats       All     Founders  Nonfounders',
     3   '-----------------------------------------------------'
        write(*,'(5(a,3x,3(1x,f12.4)/),2(a,2x,3(4x,i5,4x)/))')
     2   'Means      ',mean(1),mean(2),mean(3),
     3   'Variances  ',tvar(1),tvar(2),tvar(3),
     3   'Stand Devs ',sqrt(tvar(1)),sqrt(tvar(2)),sqrt(tvar(3)),
     4   'Maxima     ',maxv(1),maxv(2),maxv(3),
     5   'Minima     ',minv(1),minv(2),minv(3),
     6   'No. obs    ',tnum(1),tnum(2),tnum(3),
     7   'No. missing',nmiss,nmissf,nmiss-nmissf
      else
        write(*,'(a/)') 'NOTE:  No nonmissing observations'
      end if
      call corrstd(NCLASS,npairs,cvar,cov)
      write(*,'(a/a/a)')
     2 '-------------- Familial correlations (pairwise) --------------',
     3 'Rel 1   Rel 2    Std Dev 1    Std Dev 2   Correlation  N Pairs',
     4 '--------------------------------------------------------------'
      write(*,'(a,3(1x,f12.4),4x,i5)')
     & 'Husband Wife  ', cvar(1,1),cvar(1,2),cov(1),npairs(1)
      write(*,'(2(a,3(4x,f9.4),4x,i5/a,4x,f9.4,13x,4x,f9.4,4x,i5/))')
     2 'Gparent Gchild', cvar(2,1),cvar(2,2),cov(2),npairs(2),
     3 'Halfsib Hsib  ', cvar(3,1),          cov(3),npairs(3)/2,
     4 'Parent  Off   ', cvar(4,1),cvar(4,2),cov(4),npairs(4),
     5 'Fullsib Fsib  ', cvar(5,1),          cov(5),npairs(5)/2
      write(*,'(4(a,3(4x,f9.4),4x,i5/))')
     2 'Father  Son   ', cvar(6,1),cvar(6,2),cov(6),npairs(6),
     3 'Father  Dau   ', cvar(7,1),cvar(7,2),cov(7),npairs(7),
     4 'Mother  Son   ', cvar(8,1),cvar(8,2),cov(8),npairs(8),
     5 'Mother  Dau   ', cvar(9,1),cvar(9,2),cov(9),npairs(9) 
      write(*,'(2(a,4x,f9.4,13x,4x,f9.4,4x,i5/),a,3(4x,f9.4),4x,i5/)')
     2 'Brothers      ', cvar(10,1),         cov(10),npairs(10)/2,
     3 'Sisters       ', cvar(11,1),         cov(11),npairs(11)/2,
     4 'Brother-Sister', cvar(12,1),cvar(12,2), cov(12),npairs(12)

      write(*,'(a/a)')  'Fain sibship variance test',
     &                  '--------------------------'

      if (nships.gt.2) then
        call alias(r, 6, 3, 1.0d-15, x, ifail)
        call bsub(r, 6, 3, b, 2, ifail)
        call var(r, 6, cov, 6, 3, nships, 1, ifail)
        alpha=b(1)
        sea=sqrt(cov(1))
        beta=b(2)
        seb=sqrt(cov(3))
        tvalb=abs(beta/seb)
        write(*,'(a,i5,2(/a,f10.4,a,f10.4,a)/a,f10.4,a,i3,a,f6.4,a)')
     3    'No. sibships  = ',nships,
     4    'Intercept     = ',alpha,' (ase=',sea,')',
     5    'Slope         = ',beta, ' (ase=',seb,')',
     6    't value       = ',tvalb,' (df=',nships-2,', P=',
     7                       1.0d0-probst(tvalb,nships-2,ifail),')'
      else
        write(*,'(/a/)') 
     &    'NOTE:  Insufficient number of sibships for Fain test.'
      end if
      return
      end
C end-of-famcor
C
C update means and sums of squares and products
C
C 1=Marital 2=Grandparent-Grandchild 3=Half-sib
C 4=Parent-Offspring 5=Full-sib 
C 6=father-son 7=father-daugher 8=mother-son 9=mother-daughter
C 10=brother 11=sister 12=brother-sister
C
      subroutine corr(typ,x1,x2,nclass,npairs,mean,var,cov)
      integer nclass
      integer typ, npairs(nclass)
      double precision d1, d2, de, wt, x1,x2
      double precision mean(nclass,2), var(nclass,2), cov(nclass)

      npairs(typ)=npairs(typ)+1
      de=dfloat(npairs(typ))
      wt=(de-1.0d0)/de
      d1=x1-mean(typ,1)
      d2=x2-mean(typ,2)
      mean(typ,1)=mean(typ,1)+d1/de
      mean(typ,2)=mean(typ,2)+d2/de
      var(typ,1)=var(typ,1)+ d1*d1*wt
      var(typ,2)=var(typ,2)+ d2*d2*wt
      cov(typ)=cov(typ)+ d1*d2*wt

      return
      end
C end-of-corr
C
C cor to cov for classes
      subroutine corrstd(nclass,npairs,var,cov)
      integer nclass
      integer npairs(nclass)
      double precision var(nclass,2), cov(nclass)
      integer i
      do 10 i=1,nclass
        var(i,1)=sqrt(var(i,1)/dfloat(max(1,npairs(i)-1)))
        var(i,2)=sqrt(var(i,2)/dfloat(max(1,npairs(i)-1)))
        if (var(i,1).gt.0.0d0 .and. var(i,2).gt.0.0d0) then
          cov(i)=cov(i)/dfloat(max(1,npairs(i)-1))/var(i,1)
     &                 /var(i,2)
        else
          cov(i)=0.0d0
        end if
   10 continue
      return
      end
C end-of-corrstd
C
C Means and covariances for multiple trait 
C
      subroutine docov(wrk,nvar,terms,loc,loctyp,locpos,
     2             x,mean,cov,pedigree,actset,num,nfound,id,fa,mo,sex,
     3             locus,numloc,plevel)
C
      integer IBDSIZ, KNOWN, MAXIBD, MAXTER, MAXCOV, MAXSIZ, MAXLOC,MISS
      parameter(KNOWN=0, MAXIBD=20, IBDSIZ=MAXIBD*(MAXIBD+1)/2, 
     2          MAXTER=MAXIBD/2, MAXCOV=MAXTER*(MAXTER+1)/2,
     3          MAXSIZ=20, MAXLOC=10000, MISS=-9999)
      integer nvar, plevel, wrk
C position of y and x variables
      integer terms(MAXSIZ)
C  Pedigree structure
      character*10 pedigree
      integer actset,num, nfound
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ), sex(MAXSIZ)
      integer numloc
      double precision locus(MAXSIZ,MAXLOC)
C
C Locus structure:
C number of loci, locus name, locus type, and locus position in file
C
      character*20 loc(MAXLOC)
      integer loctyp(MAXLOC),locpos(MAXLOC)
C array of means and covariances
      double precision x(MAXTER),mean(MAXTER), cov(MAXCOV)
C local variables
      integer i, ifail, ii, j, nobs, ncov, ntot 
      logical complete, last

      if (nvar.gt.(MAXTER)) then
        write(*,'(/a,i3,a/)') 
     &    'NOTE:  May analyse only the first ',MAXTER,' variables.'
        nvar=MAXTER
      end if

      ncov=nvar*(nvar+1)/2
      nobs=0
      ntot=0
      ifail=0
      do 1 i=1, nvar
        mean(i)=0.0d0
    1 continue
      do 2 i=1, ncov
        cov(i)=0.0d0
    2 continue

      last=.false.
      rewind(wrk)
    5 continue
        call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &             numloc, last)
        if (last) goto 20

        if (actset.le.0) goto 5

        do 10 i=1,num
          complete=.true.
          do 12 j=1,nvar
          if ((loctyp(terms(j)).le.2 .and. 
     2         locus(i,locpos(terms(j))).lt.KNOWN) .or.
     3        locus(i,locpos(terms(j))).eq.MISS) then
            complete=.false.
            goto 13
          end if
   12     continue
   13     continue

          if (complete) then
            nobs=nobs+1
            do 14 j=1,nvar
              if (loctyp(terms(j)).le.2) then
                x(j)=0.5d0*dble(locus(i,locpos(terms(j)))+
     &                            locus(i,locpos(terms(j))+1))
              elseif (loctyp(terms(j)).eq.4) then
                x(j)=dble(locus(i,locpos(terms(j)))-1.0)
              else
                x(j)=dble(locus(i,locpos(terms(j))))
              end if
   14       continue
            call dssp(nvar, nobs, 1, x, mean, cov)
          end if
   10   continue
        ntot=ntot+num
      goto 5
   20 continue
C
      call covcor(nvar, nobs, cov)

      write(*,'(/a/a)') 
     2  'Variable        Mean      Stand Dev  Correlations',
     3  '---------- ------------ ------------ ---------------------'
      ii=0
      do 60 i=1,nvar
        ii=ii+i
        write(*,'(a10,1x,f12.4,1x,f12.4,12(1x,f4.2))') 
     2     loc(terms(i)),mean(i),sqrt(cov(ii)), 
     3     (cov(ii-i+j),j=1,i-1),1.0d0
   60 continue
      write(*,'(2(/a,i7),a,f5.1,a)') 
     2  'Number of variables     =',nvar,
     3  'No. usable observations =',nobs,
     4  '      ( ',float(100*nobs)/float(ntot),'%)' 
C
      return
      end
C end-of-docov  
C
C linear regression analysis of quantitative trait 
C
      subroutine regress(wrk,twrk,typ,nterms,terms,loc,loctyp,locpos,
     2                   gene,numal,name,x,r,b,cov,mean,pedigree,actset,
     3                   num,nfound,id,fa,mo,sex,locus,numloc,plevel)
C
      integer KNOWN, MAXALL, MAXIBD, MAXTER, MAXCOV, 
     &        MAXSIZ, MAXLOC, MISS
      parameter(MAXALL=2, KNOWN=0, MAXIBD=20, MAXTER=MAXIBD/2, 
     2          MAXCOV=MAXTER*(MAXTER+1)/2,
     3          MAXSIZ=20, MAXLOC=10000, MISS=-9999)
      integer nterms, plevel, twrk, typ, wrk
C position of y and x variables
      integer terms(MAXSIZ)
C alleles for first marker (will generate numal-1 dummy variables)
      integer gene, numal, name(MAXALL)
C  Pedigree structure
      character*10 pedigree
      integer actset,num, nfound
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ), sex(MAXSIZ)
      integer numloc
      double precision locus(MAXSIZ,MAXLOC)
C
C Locus structure:
C number of loci, locus name, locus type, and locus position in file
C
      character*20 loc(MAXLOC)
      integer loctyp(MAXLOC),locpos(MAXLOC)
C regression work arrays
      double precision x(MAXTER),r(MAXCOV),b(MAXTER),cov(MAXCOV)
      double precision mean(MAXTER)
C local variables
      integer a1,a2,i,ifail,ii,j,ncat,nchange,ncov,nobs,nter,
     &        ntot,pos,ypos,vpos
      logical comp, fussy, last
C regression results
      integer idf,mdf
      double precision aic,mss,pred,rsq,rss,tval
      character*3 allel, histo
      character*20 label
C functions
      integer eow, getnam
      logical complete
      double precision zp

      ypos=terms(nterms)
      nfix=nterms 
      if (gene.gt.0) nfix=nfix+numal-2
      if (nfix.gt.MAXLOC) then
        write(*,'(a)') 'ERROR: Too many terms specified in model.'
        return
      end if
      nobs=0
      ntot=0
      ifail=0
      nter=nfix+1
      ncov=nter*(nter+1)/2
      call inicov(nter, ncov, r)
      do 1 j=1,nterms
        mean(j)=0.0d0
    1 continue

      last=.false.
      rewind(wrk)
    5 continue
        call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &             numloc, last)
        if (last) goto 20

        if (actset.le.0) goto 5
C
        do 10 i=1,num
        if (complete(i, nterms, terms, locpos, loctyp, locus)) then
          nobs=nobs+1
          vpos=1
          x(vpos)=1.0d0
          do 14 j=1,nterms
            pos=terms(j)
            if (pos.eq.gene) then
              do 16 k=1, numal-1
                x(vpos+k)=0.0
   16         continue
              a1=getnam(locus(i,locpos(gene)),numal,name)-1
              a2=getnam(locus(i,locpos(gene)+1),numal,name)-1
              if (a1.gt.0) x(vpos+a1)=x(vpos+a1) + 1
              if (a2.gt.0) x(vpos+a2)=x(vpos+a2) + 1
              vpos=vpos+numal-1
            else if (loctyp(pos).le.2) then
              vpos=vpos+1
              x(vpos)=0.5d0*dble(locus(i,locpos(pos))+
     &                          locus(i,locpos(pos)+1))
              mean(j)=mean(j)+x(vpos)
            elseif (loctyp(pos).eq.4) then
              vpos=vpos+1
              x(vpos)=dble(locus(i,locpos(pos))-1.0)
              mean(j)=mean(j)+x(vpos)
            else
              vpos=vpos+1
              x(vpos)=dble(locus(i,locpos(pos)))
              mean(j)=mean(j)+x(vpos)
            end if
   14     continue
          call givenc(r, ncov, nter, x, 1.0d0, ifail)
        end if
   10   continue
        ntot=ntot+num
      goto 5
   20 continue

      do 30 j=1, nterms
        mean(j)=mean(j)/dfloat(nobs)
   30 continue
C
      call alias(r, ncov, nter, 1.0d-15, x, ifail)
      call bsub(r, ncov, nter, b, nter-1, ifail)
      call var(r, ncov, cov, ncov, nter, nobs, 1, ifail)
      if (typ.ge.0) then
        write(*,'(/a/3a/a)')
     2    '------------------------------------------------',
     3    'Linear regression analysis of trait "',
     4    loc(ypos)(1:eow(loc(ypos))),'"',
     5    '------------------------------------------------'
        write(*,'(/a/a)') 
     2    '    Variable         Beta    Stand Error        t-Value',
     3    '  -----------------------------------------------------'
      end if
      i=1
      ii=1
      mdf=0
      mss=0.0d0
      tval=abs(b(i))/sqrt(cov(ii))
      call phist(zp(tval),1.0d0,histo)
      if (typ.ge.0) then
        write(*,'(2x,a10,1x,f12.4,3x,f12.4,3x,f12.4,1x,a3)') 
     &    'Intercept ',b(i),sqrt(cov(ii)), tval, histo
      end if
      call sscomp(r, ncov, nter, nobs, 1, rss, idf, ifail)
      do 150 j=1,nterms-1
        pos=terms(j)
        ncat=1
        if (pos.eq.gene) ncat=numal-1
        do 151 k=1, ncat
          label=loc(pos)
          if (pos.eq.gene) then
            call wrall(name(k+1), allel)
            call juststr('l',allel,3)
            label=label(1:eow(label)) // '*' // allel(1:eow(allel))
          end if
          i=i+1
          ii=ii+i
          if (typ.ge.0) then
            tval=abs(b(i))/sqrt(cov(ii))
            call phist(zp(tval),1.0d0,histo)
            write(*,'(2x,a10,1x,f12.4,3x,f12.4,3x,f12.4,1x,a3)') 
     &        label,b(i),sqrt(cov(ii)), tval, histo
          end if
          call sscomp(r, ncov, nter, nobs, i, rss, idf, ifail)
          mdf=mdf+idf
          mss=mss+rss
  151   continue
  150 continue
      call sscomp(r, ncov, nter, nobs, 0, rss, idf, ifail)
      if (typ.ge.0) then
        rsq=1.0d0-rss/(rss+mss)
        mss=mss/dfloat(mdf)
        rss=rss/dfloat(idf)
        aic=log(rss)+2.0d0*dfloat(mdf)/dfloat(nobs)
        write(*,'(/a,i7,a,f5.1,a,2(/a,f12.4,a,i4,a),2(/a,f12.4))') 
     2    'No. usable observations =',nobs,
     3    '      ( ',float(100*nobs)/float(ntot),'%)',
     4    'Model Mean Square       =', mss,' (df=',mdf,')',
     5    'Mean Square Error       =', rss,' (df=',idf,')',
     6    'Multiple R**2           =', rsq,
     7    'Akaike Inf. Criterion   =', aic
      end if
C
C Write out residuals or predicted values if requested
C
      if (typ.lt.1) return

      nchange=0
      fussy=(typ.gt.10)
      if (fussy) typ=typ-10

      last=.false.
      rewind(wrk)
   55 continue
        call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &             numloc, last)
      if (last) goto 40
        if (actset.gt.0) then
         do 60 i=1,num
           comp=.true.
           vpos=1
           pred=b(vpos)
           do 65 j=1, nterms-1
             pos=terms(j)
             if (j.eq.gene) then
               a1=getnam(locus(i,locpos(gene)),numal,name)-1
               a2=getnam(locus(i,locpos(gene)+1),numal,name)-1
               if (a1.gt.0) pred=pred+b(vpos+a1)
               if (a2.gt.0) pred=pred+b(vpos+a2)
               vpos=vpos+numal-1
             else if (loctyp(pos).le.2) then
               vpos=vpos+1
               if (locus(i,pos).lt.KNOWN) then
                 comp=.false.
                 pred=pred+b(vpos)*mean(j)
               else
                 pred=pred+b(vpos)+0.5d0*(locus(i,locpos(pos))+
     &                                    locus(i,locpos(pos)+1))
               end if
             elseif (locus(i,pos).eq.MISS) then
               vpos=vpos+1
               comp=.false.
               pred=pred + b(vpos)*mean(j)
             elseif (loctyp(pos).eq.4) then
               vpos=vpos+1
               pred=pred + b(vpos)*(locus(i,locpos(pos))-1.0d0)
             else
               vpos=vpos+1
               pred=pred+ b(vpos)*locus(i,locpos(pos))
             end if
   65      continue
           if (.not.fussy .or. (fussy .and. comp)) then
             if (typ.eq.1 .and. locus(i,locpos(ypos)).ne.MISS) then
               nchange=nchange+1
               locus(i,locpos(ypos))=locus(i,locpos(ypos))-pred
             elseif (typ.eq.3 .or. 
     &               (typ.eq.2 .and. locus(i,ypos).eq.MISS)) then
               nchange=nchange+1
               locus(i,locpos(ypos))=sngl(pred) 
             end if
           elseif (typ.eq.1) then 
             locus(i,locpos(ypos))=MISS
           end if
   60    continue
        end if
        call wrkout(twrk,pedigree,actset,num,nfound,id,fa,mo,sex,
     &              locus,numloc)
      goto 55
   40 continue
      if (typ.eq.1) then
        write(*,'(/a,i6,3a)') 'Wrote ',nchange,' residuals to ',
     &    loc(ypos)(1:eow(loc(ypos))),'.'
      else
        write(*,'(/a,i6,3a)') 'Wrote ',nchange,' predicted values to ',
     &    loc(ypos)(1:eow(loc(ypos))),'.'
      end if

      return
      end
C end-of-regress
C
C Fit mixture of distributions to quantitative trait
C
      subroutine domix(wrk,locnam,trait,nmix,typ,pedigree,actset,num,
     &             nfound,id,fa,mo,sex,locus,numloc,value,counts,plevel)
C
      integer MAXMIX, MAXSIZ, MAXLOC, MISS, VSIZ
      parameter(MAXMIX=5,MAXSIZ=20,MAXLOC=10000,MISS=-9999,
     &          VSIZ=MAXSIZ*MAXLOC)
      integer nmix, plevel, trait, typ, wrk
      character*10 locnam
C  Pedigree structure
      character*10 pedigree
      integer actset,num, nfound
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ), sex(MAXSIZ)
      integer numloc
      double precision locus(MAXSIZ,MAXLOC)
C Quantitative trait values
      integer nobs, nvals
      double precision value(MAXSIZ)
      integer counts(MAXSIZ)
C Parameter estimates
      double precision logl
      double precision alpha(MAXMIX),mean(MAXMIX),sd(MAXMIX) 
C Likelihood contributions
      double precision prob(MAXSIZ,MAXMIX), den(MAXSIZ)
C local variables
      integer i,ifail,j
      logical last
      real inita,initsd
      character*10 dist(4)
      data dist/'  Normal','Norm: 1 SD','Exponentl',' Poisson'/
C
      nobs=0
      nvals=0

      write(*,'(/a/3a/a)')
     2  '------------------------------------------------',
     3  'Mixture distributions for trait "',locnam,'"',
     4  '------------------------------------------------'

      last=.false.
      rewind(wrk)
    5 continue
        call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &             numloc, last)
        if (last) goto 20

        if (actset.le.0) goto 5
C
C Tabulate sorted values and frequencies
        do 10 i=1,num
        if (locus(i,trait).ne.MISS) then
          nobs=nobs+1
          call qtab(locus(i,trait),nvals,value,counts)
        end if
   10   continue
      goto 5
   20 continue
C
C Produce a histogram with HISTCAT intervals
C
      call dohist(min(nvals,21),nvals,value,counts,nobs)
      call filliben(nobs,nvals,value,counts)
      call symtest(nobs,nvals,value,counts)
C
C starting values for mixture
C
      ifail=0
      inita=1.0/float(nmix)
      initsd=sqrt(value(3*nvals/4)-value(nvals/4))
      do 30 i=1,nmix
        alpha(i)=inita
        mean(i)=value(i*nvals/(nmix+1))
        sd(i)=initsd
   30 continue

      call mixture(typ,nmix,nvals,value,counts,
     &             alpha,mean,sd,prob,den,nobs,logl,ifail,plevel)

      if (plevel.gt.0) then
        write(*,'(/a/a))') 
     2    ' Rank  Trait value    Obs    Posterior probabilities ',
     3    ' -------------------------------------------------------' 
        do 50 j=1,nvals
          write(*,'(1x,i4,2x,f12.4,i8,5(2x,f5.3):)')
     &      j,value(j),counts(j),(alpha(i)*prob(j,i)/den(j),i=1,nmix)
   50   continue
      end if
      if (ifail.ne.0) then
        write(*,'(/a/)') 'ERROR: Problem encountered in estimation.' 
      end if
      write(*,'(/2a,3(/a,i8),/a,f13.4)')
     2  'Distribution type    = ', dist(typ),
     3  'No. of distributions = ', nmix,
     4  'No. of observations  = ', nobs,
     5  'No. of unique values = ', nvals,
     6  '-2*Loglikelihood     = ',-logl-logl 

      write(*,'(2(/a))')
     2  ' Dist     Mean      Standard Dev  Proportion',
     3  ' -------------------------------------------' 
      do 100 i=1,nmix
        write(*,'(1x,i4,1x,f12.4,2x,f12.4,2x,f6.4)') 
     &    i,mean(i),sd(i),alpha(i)
  100 continue
      return
      end
C end-of-domix
C
C Fit mixture of distributions
C Algorithm AS 203 (Appl Stat 1984; 33:327-332)
C
      subroutine mixture(a,k,m,x,n,alpha,mean,sd,f,g,
     &                   nobs,logl,ifail,plevel)
C
      integer MAXMIX, MAXSIZ
      double precision TOL
      parameter(MAXMIX=5, MAXSIZ=20, TOL=1.0d-6)
C
C a=distribution type Nor(k sd) Nor(1 sd) Exp Poi
C k=number of mixture distributions 1..MAXMIX
C m=number of classes 1..MAXSIZ
C
      integer a,k,m,nobs,ifail,plevel
C Parameter estimates
      double precision logl
      double precision alpha(MAXMIX),mean(MAXMIX),sd(MAXMIX)
C
C Data: value and number of observations for that value
      integer n(MAXSIZ)
      double precision x(MAXSIZ)
C Likelihood contributions
      double precision f(MAXSIZ,MAXMIX), g(MAXSIZ)
C
C Local variables
      logical test
      integer counter
      double precision oldlogl,part,poolv,poolsd,sumalpha
C Updated estimates
      double precision nalpha(MAXMIX),nmean(MAXMIX),nsd(MAXMIX),
     &     dt(MAXMIX),nt(MAXMIX),vt(MAXMIX) 
C
      ifail=0
      oldlogl=0.0
      counter=0
      test=.false.
C
C While construct
C
   25 if (test) goto 100 

        if (plevel.gt.2) then
          write(*,'(/a,i5,a,f13.4,a,i2/)') 
     &      'Iter:',counter,' LL:',oldlogl,' Ifail:',ifail
          do 30 j=1,k
            write(*,'(1x,i4,1x,f12.4,2x,f12.4,2x,f6.4)') 
     &        j,mean(j),sd(j),alpha(j)
   30     continue
        end if
        counter=counter+1
        do 40 j=1,k
          if ((alpha(j).gt.1).or.(alpha(j).le.0)) then
            ifail=2
            return
          end if
          if ((mean(j).ge.x(m)).or.(mean(j).le.x(1))) then
            ifail=3
            return
          end if
          if (a.lt.3 .and. sd(j).le.0) then
            ifail=4
            return
          end if
   40   continue
        do 50 i=1,k-1
        do 50 j=i+1,k
          if (mean(i).eq.mean(j)) then
            if (a.lt.3) then
              if (sd(i).eq.sd(j)) then
                ifail=9
                return
              end if
            else
              ifail=8
              return
            end if
          end if
   50   continue
C      
C actual start of EM algorithm a=1-2 Gauss 3 Exp 4 Poisson
C      
        logl=0.0
        do 60 i=1,m
          g(i)=0.0
          do 70 j=1,k
            if (a.eq.3) then
              f(i,j)=exp(-x(i)/mean(j))/mean(j)
            elseif (a.eq.4) then
              if (i.eq.1) then 
                f(i,j)=exp(-mean(j))*mean(j)**x(i)
              else
                f(i,j)=f(i-1,j)*mean(j)**(x(i)-x(i-1))
              end if
            else
              f(i,j)=exp(-0.5*((x(i)-mean(j))/sd(j))**2)/sd(j)
            end if
            g(i)=g(i)+alpha(j)*f(i,j)
   70     continue
          if (g(i).gt.1.0d-25) then
            logl=logl+n(i)*log(g(i))
          end if
   60   continue
C      
C calcs probability densities of the subpopulations which form the
C the mixture, and the loglikelihood function
C      
        test=.true.
        sumalpha=0.0 
C      
        poolv=0.0
        do 80 j=1,k
          nt(j)=0.0
          dt(j)=0.0
          vt(j)=0.0
          do 90 i=1,m
            if (g(i).gt.1.0d-25) then
              part=f(i,j)*n(i)/g(i)
            else
              part=0.0d0
            end if
            dt(j)=dt(j)+part
            nt(j)=nt(j)+part*x(i)
            if (a.lt.3) then 
              vt(j)=vt(j)+part*(x(i)-mean(j))**2
              poolv=poolv+alpha(j)*part*(x(i)-mean(j))**2
            end if
   90     continue
C      
C calc denominators and numerators of new estimates
C      
          nmean(j)=nt(j)/dt(j)
          if (j.ne.k) then
            nalpha(j)=alpha(j)*dt(j)/float(nobs)
            sumalpha=sumalpha+nalpha(j)
          else
            nalpha(k)=1.0-sumalpha
          end if
          if (a.lt.3) then 
            nsd(j)=sqrt(vt(j)/dt(j))
          end if

          if (abs(oldlogl-logl).gt.TOL) then 
            test= .false.
          end if

          oldlogl=logl
          alpha(j)=nalpha(j)
          mean(j)=nmean(j)
          if (a.lt.3) then 
            sd(j)=nsd(j)
          end if
   80   continue
        if (a.eq.2) then
          poolsd=sqrt(poolv/float(nobs))
          do 82 j=1,k
             sd(j)=poolsd
   82     continue
        end if  
      goto 25
C
C End of While (counter) loop
C
  100 continue
C
C variances for other distributions
C
      if (a.eq.3) then
        do 105 j=1,k
          sd(j)=mean(j)
  105   continue
      elseif (a.eq.4) then
        do 110 j=1,k
          sd(j)=sqrt(mean(j))
  110   continue
      end if

      return
      end
C end-of-mixture
C
C update table of quantitative trait values -- binary search and insertion sort
C 
      subroutine qtab(x,nvals,value,icount)
      integer MAXSIZ
      parameter(MAXSIZ=20)
      integer nvals
      double precision value(MAXSIZ), x
      integer icount(MAXSIZ)
      integer hi,lo, pos

      pos=1
      hi=nvals
      lo=1
    1 continue
      if (hi.lt.lo) goto 5
        pos=(hi+lo)/2
        if (x.gt.value(pos)) then
          lo=pos+1
        elseif (x.lt.value(pos)) then
          hi=pos-1
        else
          icount(pos)=icount(pos)+1
          return 
        end if
      goto 1
    5 continue
C 
C else if not found
C
C if enough room, create new category
C
      if (nvals.lt.MAXSIZ) then
        do 25 k=nvals,lo,-1
          value(k+1)=value(k)
          icount(k+1)=icount(k)
   25   continue
        nvals=nvals+1
        value(lo)=x
        icount(lo)=1
C
C else store as average of x and nearest category
C
      else
        value(pos)=value(pos)+(x-value(pos))/float(icount(pos)+1)
        icount(pos)=icount(pos)+1
      end if
      return
      end
C end-of-qtab
C
C update contingency table of trait values -- binary search and insertion sort
C
C ncat=#dimensions, values=data vector, ncells=#cells in table 
C maxcell=max #cells, idx=pointer to label/data for cell,
C icount=counts, offset=start of label in workspace, maxcat=workspace
C size, categories=workspace containing all labels/data,
C iwt=contribution of current data vector (usually one)
C 
      subroutine qtabn(ncat,values,ncells,maxcell,idx,icount,
     &                 offset, topcat, maxcat, categories, iwt)
      integer iwt, ncat, offset
      double precision values(ncat)
C table 
      integer ncells
      integer idx(maxcell),icount(maxcell)
      integer maxcat, topcat
      real categories(maxcat)
C local variables
      integer catpos, endcat, endcell, hi, i, lo, pos

      endcell=offset+ncells
      hi=endcell
      lo=offset+1
      pos=lo
    1 continue
      if (hi.lt.lo) goto 5
        pos=(hi+lo)/2
        catpos=idx(pos)
C test if higher
        do 10 i=1, ncat
          if (sngl(values(i)).gt.categories(catpos)) then
            lo=pos+1
            goto 1
          else if (sngl(values(i)).lt.categories(catpos)) then
            goto 11
          end if
          catpos=catpos+1
   10   continue
   11   continue
C test if lower 
        catpos=idx(pos)
        do 20 i=1, ncat
          if (sngl(values(i)).lt.categories(catpos)) then
            hi=pos-1
            goto 1
          else if (sngl(values(i)).gt.categories(catpos)) then
            goto 21
          end if
          catpos=catpos+1
   20   continue
   21   continue
C just right
        icount(pos)=icount(pos)+iwt
        return 
C 
C else if not found
C
    5 continue
C
C and if enough room, create new category
C
      endcat=topcat+ncat
      if (endcat.le.maxcat .and. endcell.lt.maxcell) then
        do 25 k=endcell,lo,-1
          idx(k+1)=idx(k)
          icount(k+1)=icount(k)
   25   continue
        ncells=ncells+1
        catpos=topcat+1
        idx(lo)=catpos
        do 50 i=1, ncat
          categories(catpos)=sngl(values(i))
          catpos=catpos+1
   50   continue
        icount(lo)=iwt
        topcat=endcat
      else
        write(*,*) 'Too many values for contingency table:'
        write(*,*) (values(i),i=1, ncat), 'n=', iwt
      end if
      return
      end
C end-of-qtabn
C
C Binomial (ilink=1), Poisson (ilink=2), 
C Exponential (ilink=3), Weibull (ilink=4) regression analysis 
C
      subroutine binreg(wrk,wrk2,twrk,ilink,nterms,terms,loc,loctyp,
     2             locpos,offset,censor,gene,numal,name,x,r,b,cov,
     3             pedigree,actset,num,nfound,id,fa,mo,sex,locus,numloc,
     4             wshap, mlik, mpar, plevel)
C
      integer KNOWN, MAXALL, MAXIBD, MAXTER, MAXCOV, MAXSIZ, 
     &        MAXLOC, MISS
      double precision DELTA, EPS
      parameter(DELTA=1.0d-5, EPS=1.0d-6,
     2          KNOWN=0, MAXIBD=20, MAXTER=MAXIBD/2, 
     3          MAXCOV=MAXTER*(MAXTER+1)/2, MAXALL=2, 
     4          MAXSIZ=20, MAXLOC=10000, MISS=-9999)
      integer censor, ilink, nterms, offset, plevel, twrk, wrk, wrk2
      double precision wshap
C model likelihood and degrees of freedom
      integer mpar
      double precision mlik
C position of y and x variables
      integer terms(MAXSIZ)
C alleles for first marker (will generate numal-1 dummy variables)
      integer gene, numal, name(MAXALL)
C  Pedigree structure
      character*10 pedigree
      integer actset,num, nfound
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ), sex(MAXSIZ)
      integer numloc
      double precision locus(MAXSIZ,MAXLOC)
C
C Locus structure:
C number of loci, locus name, locus type, and locus position in file
C
      character*20 loc(MAXLOC)
      integer loctyp(MAXLOC),locpos(MAXLOC)
C regression work arrays
      double precision x(MAXTER),r(MAXCOV),b(MAXTER),cov(MAXCOV)
C local variables
C nfix=number of fixed effects (including dummy variables)
C nter=nfix+1 (the trait)
C 
      integer a1,a2,ifail,ii,it,j,ncov,nfix,nobs,nter,ntot,
     &        pos,nvar,wrknum,vpos,ypos
      character*8 densid(4)
      character*12 wrkfil
      logical last
      double precision offval, v, y
C regression results
      integer bsign, naff
      double precision base, oldshap, shap, tval
      character*3 allel, histo
      character*20 label
C functions
      logical complete
      integer eow, getnam
      double precision ln, zp

      data densid /'Binomial', 'Poisson', 'Weibull', 'Expontl'/

      it=0
      mpar=0
      mlik=0.0d0
      oldshap=1.0d0
      shap=1.0d0
      bsign=1
      if (ilink.eq.3 .or. ilink.eq.4) bsign=-1
      nvar=nterms
      ypos=terms(nterms)
      if (plevel.ge.0) then
        write(*,'(/a/4a/a)')
     2    '------------------------------------------------',
     3    densid(ilink), ' regression analysis of trait "',
     4    loc(ypos)(1:eow(loc(ypos))),'"',
     5    '------------------------------------------------'
      end if
      nfix=nterms
      if (gene.gt.0) nfix=nfix+numal-2
      if (nfix.gt.(MAXTER-1)) then
        write(*,'(a)') 'ERROR: Too many terms specified in model.'
        return
      end if
      if (offset.ne.MISS) then
        if (plevel.ge.0) then
          write(*,'(3a)') 
     &      'Model offset: ', loc(offset)(1:eow(loc(offset))), '.'
        end if
        nvar=nvar+1
        terms(nvar)=offset
      else if (censor.ne.MISS) then
        if (plevel.ge.0) then
          write(*,'(3a)') 
     &      'Censoring variable: ', loc(censor)(1:eow(loc(censor))), '.'
        end if
        nvar=nvar+1
        terms(nvar)=censor
      end if
      naff=0
      nobs=0
      ntot=0
      ifail=0
      nter=nfix+1
      ncov=nter*(nter+1)/2

      wrknum=1
      wrkfil='sp-log.wrk'
      open(twrk,file=wrkfil,form='unformatted')

      last=.false.
      rewind(wrk)
    5 continue
        call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &             numloc, last)
        if (last) goto 20

        if (actset.le.0) goto 5
C
        do 10 i=1,num
        if (complete(i, nvar, terms, locpos, loctyp, locus)) then
          nobs=nobs+1
          vpos=1
          x(vpos)=1.0d0
          do 14 j=1,nterms
            pos=terms(j)
            if (pos.eq.gene) then
              do 16 k=1, numal-1
                x(vpos+k)=0.0
   16         continue
              a1=getnam(locus(i,locpos(gene)),numal,name)-1
              a2=getnam(locus(i,locpos(gene)+1),numal,name)-1
              if (a1.gt.0) x(vpos+a1)=x(vpos+a1) + 1
              if (a2.gt.0) x(vpos+a2)=x(vpos+a2) + 1
              vpos=vpos+numal-1
            else if (loctyp(pos).le.2) then
              vpos=vpos+1
              x(vpos)=0.5d0*(locus(i,locpos(pos))+
     &                       locus(i,locpos(pos)+1))
            elseif (loctyp(pos).eq.4) then
              vpos=vpos+1
              x(vpos)=locus(i,locpos(pos))-1.0d0
            else
              vpos=vpos+1
              x(vpos)=locus(i,locpos(pos))
            end if
   14     continue
          if (ilink.eq.1 .or. ilink.eq.2) then
            y=x(vpos) 
            offval=0.0d0
            if (offset.ne.MISS) then
              offval=locus(i,locpos(offset))
            end if
          else
            y=1.0d0
            if (censor.ne.MISS) then
              y=locus(i, locpos(censor))-1.0d0
            end if
            offval=log(x(vpos))
          end if
          if (ilink.ne.2 .and. y.eq.1.0d0) naff=naff+1
          if (ilink.eq.1) then
            x(nter)=0.25d0*(y-0.5d0-offval)-0.6931472d0
            v=4.0d0
          else
            x(nter)=ln(y+offval)
            v=1.0d0/max(0.5d0, y)
          end if
          write(twrk) y, v, offval, (x(j), j=1, nter)
        end if
   10   continue
        ntot=ntot+num
      goto 5
   20 continue

      if (nobs.gt.0 .and. (ilink.gt.1 .or. 
     &    (naff.ne.0 .and. naff.ne.nobs))) then
C Once round for binomial, poisson, exponential
        if (ilink.ne.3) then
          call fitbin(twrk,wrk2,wrknum,wrkfil,ilink,nobs,nter,ncov,
     &                it,mlik,r,b,y,x,shap,plevel)
C else iterate for Weibull shape parameter
        else
   50     continue
            oldshap=shap
            call fitbin(twrk,wrk2,wrknum,wrkfil,ilink,nobs,nter,ncov,
     &                  ii,mlik,r,b,y,x,shap,plevel)
            it=it+ii
            call weishape(twrk, nobs, naff, nter, b, x, oldshap, shap)
            if (plevel.gt.1) then
              write(*,'(a, f6.3)') 'Weibull shape parameter=', shap
            end if
          if (abs(oldshap-shap).gt.DELTA) goto 50
        end if
        close(twrk,status='delete')

        mpar=nfix  
        call var(r, ncov, cov, ncov, nter, nobs, 2, ifail)

        if (plevel.ge.0) then
          write(*,'(/a/a)') 
     2      '    Variable         Beta    Stand Error        t-Value',
     3      '  -----------------------------------------------------'
          i=1
          ii=1
          tval=abs(b(i))/sqrt(cov(ii))
          call phist(zp(tval),1.0d0,histo)
          write(*,'(2x,a10,1x,f12.4,3x,f12.4,3x,f12.4,1x,a3)') 
     &       'Intercept ',bsign*b(i),sqrt(cov(ii)), tval, histo
          do 150 j=1,nterms-1
            pos=terms(j)
            ncat=1
            if (pos.eq.gene) ncat=numal-1
            do 151 k=1, ncat
              label=loc(pos)
              if (pos.eq.gene) then
                call wrall(name(k+1), allel)
                call juststr('l',allel,3)
                label=label(1:eow(label)) // '*' // allel(1:eow(allel))
              end if
              i=i+1
              ii=ii+i
              if (plevel.ge.0) then
                tval=abs(b(i))/sqrt(cov(ii))
                call phist(zp(tval),1.0d0,histo)
                write(*,'(2x,a10,1x,f12.4,3x,f12.4,3x,f12.4,1x,a3)') 
     &            label,bsign*b(i),sqrt(cov(ii)), tval, histo
              end if
  151       continue
  150     continue

          write(*,'(/a,i7,a,f5.1,a)')
     2      'No. usable observations =',nobs,
     3      '      (',float(100*nobs)/float(ntot),'%)' 
          if (ilink.eq.1) then
            write(*,'(a,i7/)')
     2      'Number of affecteds     =',naff 
          else if (ilink.eq.3 .or. ilink.eq.4) then
            write(*,'(a,i7,a,f5.1,a/)')
     2      'No. of uncensored times =',naff, 
     3      '      (',float(100*naff)/float(nobs),'%)' 
          end if
          if (ilink.eq.3) then
            write(*,'(a, f12.4)') 'Weibull shape parameter =', shap
          end if
C Base model deviance (intercept only)
          if (ilink.eq.1) then
            base=dfloat(naff)/dfloat(nobs)
            base=dfloat(naff)*log(base)+
     &           dfloat(nobs-naff)*log(1.0d0-base)
            base=-base-base
            write(*,'(a,f12.4/a,i7/a,f12.4,a,i4,a/a,f12.4)')
     4        'Null deviance           =', base, 
     5        'Number of iterations    =', it,
     6        'Model LR Chi-square     =', base-mlik,' (df=',nfix,')',
     7        'Akaike Inf. Criterion   =', dfloat(2*mpar)+mlik
          else
            write(*,'(a,i7/a,f12.4,a,i4,a/a,f12.4)')
     5        'Number of iterations    =', it,
     6        'Model LR Chi-square     =', mlik,' (df=',nobs-mpar,')',
     7        'Akaike Inf. Criterion   =', dfloat(2*mpar)+mlik
          end if
        end if
      else 
        if (nobs.eq.0) then
          write(*,'(/a)') 'No usable observations.'
        else if (naff.eq.nobs) then
          write(*,'(/a)') 'Only affecteds with complete information.'
        else if (naff.eq.0) then
          write(*,'(/a)') 'Only unaffecteds with complete information.'
        end if
      end if
      if (wshap.eq.MISS) wshap=shap
      return
      end
C end-of-binreg
C 
C perform binomial (ilink=1) or poisson (ilink=2) regression IRLS, 
C data in scratchfile at stream wrk
C
      subroutine fitbin(wrk,wrk2,wrknum,wrkfil,ilink,nobs,nter,ncov,
     &                  it,x2,r,b,y,x,shap,plevel)
      integer MAXIBD, MAXTER, MAXCOV
      parameter(MAXIBD=20, MAXTER=MAXIBD/2, 
     &          MAXCOV=MAXTER*(MAXTER+1)/2)
      integer ilink, it, ncov, nobs, nter, plevel, 
     &        wrk, wrk2, wrknum
      character*12 wrkfil
C regression work arrays etc
      double precision shap, y, x2
      double precision x(MAXTER),r(MAXCOV),b(MAXTER)
C local variables
      integer itmax
      double precision delta, oldx2  

      it=0
      itmax=200
      delta=1.0d-5
      if (ilink.eq.2) delta=5.0d-5
      x2=-1.0d99
      oldx2=-2.0d99
   10 continue
      if (it.gt.itmax .or. abs(x2-oldx2).lt.DELTA) goto 20
        it=it+1
        oldx2=x2
        call newnam(wrknum, wrkfil)
        open(wrk2,file=wrkfil,form='unformatted')
        call binirls(wrk,wrk2,ilink,nobs,nter,ncov,
     &               x2,r,b,y,x,shap,plevel)
        close(wrk,status='delete')
        close(wrk2,status='keep')
        open(wrk,file=wrkfil,form='unformatted')
        if (plevel.gt.1) then
          write(*,'(i4,a,f16.4,6(1x,f9.4):)') 
     &      it, ': ',x2, (b(j), j=1, min(6,nter-1))
        end if
      goto 10
   20 continue

      if (it.gt.itmax) then 
        write(*,'(/a,i3,a/)') 
     &    'NOTE:  Exceeded max (',itmax,') iterations.'
      end if
      return
      end
C end-of-fitbin
C
C One iteration of IRLS for binomial or poisson regression
C
      subroutine binirls(wrk,wrk2,ilink,nobs,nter,nel,
     &                   x2,r,b,y,x,shap,plevel)
      integer ilink, nter, nel, wrk, wrk2
      double precision r(nel), b(nter), x(nter), x2, y
      double precision EPS
      parameter(EPS=1.0d-6)
      integer i, ifault, plevel
      double precision offval, pred, shap, v, z
C functions
      double precision alogit, logit

      call inicov(nter, nel, r)

      rewind(wrk)
      do 10 i=1, nobs
        read(wrk) y, v, offval, (x(j), j=1, nter)
        call givenc(r, nel, nter, x, v, ifault)
   10 continue
      call alias(r, nel, nter, 1.0d-15, x, ifault)      
      if (ifault.lt.0 .and. plevel.gt.1) then
        write(*,*) 'NOTE:  Parameter ',-ifault,' is aliased.'
      end if
      call bsub(r, nel, nter, b, nter, ifault)
      if (ifault.ne.0 .and. plevel.gt.1) then
        write(*,*) 'IRLS Back subst IFAULT=',ifault
      end if

      x2=0.0d0
      rewind(wrk)
      do 30 i=1,nobs
        read(wrk) y, v, offval, (x(j), j=1, nter)
        pred=0.0d0
        do 35 j=1,nter-1
          pred=pred+b(j)*x(j)
   35   continue
C offset
        pred=pred+shap*offval
        if (ilink.eq.1) then
          pred=alogit(pred)
          v=1.0d0/pred/(1.0d0-pred)
          z=y-pred
          x(nter)=logit(pred)-offval+z*v
          if (pred.gt.EPS .and. (1.0d0-pred).gt.EPS) then
            if (y.eq.1.0d0) then
              x2=x2-log(pred)
            else
              x2=x2-log(1.0d0-pred)
            end if
          end if
        else 
          pred=exp(pred)
          v=1.0d0/pred
          z=y-pred
          x(nter)=log(pred)-shap*offval+z*v
          if (y.gt.EPS .and. pred.gt.EPS) then
            x2=x2+y*log(y/pred)
          end if
        end if
        write(wrk2) y, v, offval, (x(j), j=1, nter)
   30 continue
      x2=x2+x2
      return
      end
C end-of-binirls
C
C Estimate shape for Weibull distribution
C
      subroutine weishape(wrk, nobs, naff, nter, b, x, alpha, alpha2)
      integer MAXIBD, MAXTER, MISS  
      parameter(MAXIBD=20, MAXTER=MAXIBD/2, MISS=-9999)
      integer naff, nobs, nter, wrk
      double precision alpha, alpha2
C regression work arrays etc
      double precision x(MAXTER), b(MAXTER)
      integer i, j
      double precision offval, pred, v, y

      alpha2=0.0d0
      rewind(wrk)
      do 10 i=1,nobs
        read(wrk) y, v, offval, (x(j), j=1, nter)
        pred=0.0d0
        do 15 j=1,nter-1
          pred=pred+b(j)*x(j)
   15   continue
        pred=pred+alpha*offval
        alpha2=alpha2+(exp(pred)-y)*offval/dfloat(naff)
   10 continue
      alpha2=0.5d0*(alpha+1.0d0/alpha2)
      return
      end
C end-of-weishape
C
C Simulation P for RxC contingency table 
C
      subroutine rcp(nr, rows, nc, cols, tble, e, iter)
      integer iter, nc, nr
C
      integer cols(*), rows(*), tble(*)
      double precision e(*)
C local variables
      integer i, j, idx, ncells
C  
      idx=0
      ncells=nr*nc
      do 1 i=1, nr
        write(*,'(a,i3,a,$)') 'Row ',i,': '
        read(*,*,err=100) (tble(j), j=idx+1, idx+nc)
        idx=idx+nc
    1 continue
      call rctest(nr, nc, tble, e, rows, cols, iter)
      return
C input error
  100 write(*,'(a,i3,a)') 
     &    'ERROR: Expected ',ncells,' counts!'
      return
      end
C end-of-rcp
C
C LRTS and Permutation P for RxC contingency table 
C
      subroutine rctest(nr, nc, tble, e, rows, cols, iter)
      integer iter, nc, nr
      double precision pval
C
      integer cols(*), rows(*), tble(*)
      double precision e(*)
C local variables
      integer df, econ, ncon, ncells, tot
      double precision cov, dtot, mc, mh, mr, obschi, sc, sr, t1, t2
C functions
      double precision chip
C  
      if (nr.lt.2 .or. nc.lt.2) return

      ncells=nr*nc
      cov=0.0d0
      mc=0.0d0
      mr=0.0d0
      sc=0.0d0
      sr=0.0d0
      do 1 i=1, nr
        rows(i)=0
    1 continue
      do 6 j=1, nc
        cols(j)=0
    6 continue
      econ=0
      ncon=0
      tot=0
      
      idx=0
      do 10 i=1, nr
      do 10 j=1, nc
        idx=idx+1
        tot=tot+tble(idx)
        rows(i)=rows(i)+tble(idx)
        cols(j)=cols(j)+tble(idx)
        mr=mr+dfloat(i-1)*tble(idx)
        mc=mc+dfloat(j-1)*tble(idx)
   10 continue
      dtot=1.0d0/dfloat(tot)
      mc=mc*dtot
      mr=mr*dtot
      idx=0
      do 20 i=1, nr
      do 20 j=1, nc
        idx=idx+1
        e(idx)=dfloat(rows(i))*dfloat(cols(j))*dtot
        cov=cov+tble(idx)*(dfloat(i-1)-mr)*(dfloat(j-1)-mc)
        sr=sr+tble(idx)*(dfloat(i-1)-mr)*(dfloat(i-1)-mr);
        sc=sc+tble(idx)*(dfloat(j-1)-mc)*(dfloat(j-1)-mc);
   20 continue
      call upchi(ncells, tble, e, obschi)
C if square table, calculate agreement and kappa
      if (nr.eq.nc) then
        idx=1
        do 30 i=1, nr
        ncon=ncon+tble(idx)
        econ=econ+cols(i)*rows(i)
        idx=idx+nr+1
   30   continue
      end if
      mh=dfloat(tot-1)*cov*cov/sr/sc 
      df=(nr-1)*(nc-1)
      write(*,'(/a,i6/a,f7.2/a,i4/a,3x,f6.4)')
     2  '    No. complete observations =',tot,
     3  '    LR contingency chi-square =',obschi,  
     4  '           Degrees of freedom =',df,
     5  '           Asymptotic P-value =', chip(obschi,df)
      if (iter.gt.0) then
        call simchi(nr, rows, nc, cols, tble, e, obschi, 
     &              tot, iter, pval)
        write(*,'(14x,a,3x,f6.4,a,i8,a)') 'Empiric P-value =',pval,
     &    ' (',10*tot*iter,' MCMC iterations)'
      end if
      write(*,'(a,f7.2,2x,a,f6.4,a)')
     &  '             Trend chi-square =', mh, ' (P=', chip(mh, 1), ')'
C If square table, print agreement and kappa
      if (nr.eq.nc) then
        t1=dfloat(ncon)*dtot
        t2=dfloat(econ)*dtot*dtot
        write(*,'(20x,a,3x,f5.3,1x,a,i5,a,i5,a)') 'Agreement =',
     &    t1,' (', ncon, '/', tot, ')'
        write(*,'(16x,a,2x,f7.4)') 'Cohen''s Kappa =',
     &    (t1-t2)/(1.0d0-t2) 
      end if
      return
      end
C end-of-rctest
C
C MCMC a RxC contingency table retaining given margins
C
      subroutine simchi(nr, rows, nc, cols, tble, e, obschi,
     &                  tot, iter, pval)
      integer iter, nc, nr, tot
      double precision obschi, pval
C
      integer cols(*), rows(*), tble(*)
      double precision e(*)

      integer c1, c2, eligc, eligr, i, incr, ip,
     &        it, ncells, r1, r2, isub(4)
      double precision chisq, qa
C interrupt
      common /flag/ irupt
      integer irupt
C functions
      integer irandom
      real random

      pval=1.0d0

      if (iter.le.0) return

      call mkchoose(nr, rows, eligr)
      call mkchoose(nc, cols, eligc)
      
      if (eligr.lt.2 .or. eligc.lt.2) return

      irupt=0
      ncells=nr*nc
      ip=0
      chisq=obschi
      do 10 it=1, 10*iter
      if (irupt.eq.0) then
C dememorise by sampling each tot'th value
        do 50 i=1, tot 
          call choose(2, eligr, rows)
          call choose(2, eligc, cols)
          r1=rows(1)
          r2=rows(2)
          c1=cols(1)
          c2=cols(2)
          call order(r1,r2)
          call order(c1,c2)
          isub(1)=nc*(r1-1)+c1
          isub(2)=nc*(r1-1)+c2
          isub(3)=nc*(r2-1)+c1
          isub(4)=nc*(r2-1)+c2
          incr=2*irandom(1,2)-3
          qa=0.0d0
          if (incr.eq.-1 .and. tble(isub(1)).gt.0 .and.
     &        tble(isub(4)).gt.0) then
            qa=min(1.0d0,dfloat(tble(isub(1))*tble(isub(4)))/
     &                  dfloat((tble(isub(2))+1)*(tble(isub(3))+1)))
          else if (incr.eq.1 .and. tble(isub(2)).gt.0 .and.
     &             tble(isub(3)).gt.0) then
            qa=min(1.0d0,dfloat(tble(isub(2))*tble(isub(3)))/
     &                  dfloat((tble(isub(1))+1)*(tble(isub(4))+1)))
          end if
C If accepted, update table
C
          if (qa.gt.random()) then
            tble(isub(1))=tble(isub(1))+incr
            tble(isub(2))=tble(isub(2))-incr
            tble(isub(3))=tble(isub(3))-incr
            tble(isub(4))=tble(isub(4))+incr
          end if
   50   continue
        call upchi(ncells, tble, e, chisq)
        if (chisq.ge.obschi) ip=ip+1
      end if
   10 continue
      pval=dfloat(ip)/dfloat(it)
      return
      end
C end-of-simchi
C 
C LRTS for contingency table in MCMC
C
      subroutine upchi(ncells, tble, e, lrts)
      double precision TOL 
      parameter(TOL=1.0d-6) 

      integer ncells
      double precision lrts
      integer tble(*)
      double precision e(*)
      integer i, icount

      lrts=0.0d0
      do 10 i=1,ncells
      if (tble(i).gt.0 .and. e(i).gt.TOL) then
        icount=tble(i)
        lrts=lrts+dfloat(icount)*log(dfloat(icount)/e(i))
      end if
   10 continue
      lrts=lrts+lrts
      return
      end
C end-of-upchi
C   
C Load an array with indices of eligible choices (eg nonmissing alleles)
      subroutine mkchoose(ni, eligible , nelig)
      integer nelig, ni, eligible(ni)
      integer i
      nelig=0
      do 5 i=1, ni
      if (eligible(i).gt.0) then
        nelig=nelig+1
        eligible(nelig)=i
      end if
    5 continue
      return
      end
C end-of-mkchoose
C
C Shuffle array of indices so can randomly select combination from
C as first r elements
      subroutine choose(nch, ni, idx)
      integer nch, ni, idx(ni)
      integer i, pos, tmp
C functions
      integer irandom

      do 5 i=1, nch
        pos=irandom(1, ni)
        tmp=idx(pos)
        idx(pos)=idx(i)
        idx(i)=tmp
    5 continue
      return
      end
C end-of-choose
C

C
C perform Haseman-Elston sib-pair regression: two-point Cardon & Fulker
C
      subroutine twopair(wrk,trait,mark1,mark2,th1,th2,th12,
     2              pedigree,actset,num,nfound,id, fa, mo, sex, locus, 
     3              numloc,numal,name,alfrq,numal2,name2,alfrq2)
C
C  Pedigree structure
      integer KNOWN, MAXALL, MAXSIZ, MAXLOC, MISS
      parameter(KNOWN=0,MAXALL=2,MAXSIZ=20,MAXLOC=10000,MISS=-9999)
      character*10 pedigree
      integer actset,num, nfound
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ), sex(MAXSIZ)
      integer numloc
      double precision locus(MAXSIZ,MAXLOC)
      integer trait,mark1,mark2,wrk
      double precision th1,th2,th12
C
C allele frequencies within entire sample for given locus 
C
      integer numal, name(MAXALL)
      double precision alfrq(MAXALL)
      integer numal2, name2(MAXALL)
      double precision alfrq2(MAXALL)
C local variables
      integer contrib,df,hsibs,i,ifail,j,mark12,mark22,sibs
C regression results
      double precision x(4),r(10),b(3),cov(10)
      double precision mux,alpha,sea,beta,seb,tvalb,pi1,pi2
C
      logical last,samefa,samemo
      character*16 error
C functions
      double precision fibd,hibd,pihat, probst
C
      df=0
      ifail=1
      mark12=mark1+1
      mark22=mark2+1
      last=.false.
      hsibs=0
      sibs=0
      mux=0.0d0
      call inicov(4, 10, r)
      rewind(wrk)
    5 continue
        call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &             numloc, last)
        if (last) goto 20

        if (actset.le.0) goto 5

        do 10 i=nfound+1,num-1
         contrib=0 
         do 15 j=i+1,num
          samefa=(fa(i).eq.fa(j))
          samemo=(mo(i).eq.mo(j))
C
C Share at least one parent and both trait & marker values present
C
        if (locus(i,trait).ne.MISS .and. locus(j,trait).ne.MISS  .and.
     2      locus(i,mark1).gt.KNOWN .and. locus(j,mark1).gt.KNOWN .and.
     3      locus(i,mark2).gt.KNOWN .and. locus(j,mark2).gt.KNOWN .and.
     4      (samefa.or.samemo))  then
C full or half sibs
          if (contrib.eq.0) contrib=1
          sibs=sibs+1
          x(1)=1.0d0
          x(4)=(locus(i,trait)-locus(j,trait))**2
          if (samefa.and.samemo) then
C full sib
            pi1=fibd(locus(i,mark1),locus(i,mark12),
     2               locus(j,mark1),locus(j,mark12),
     3               locus(fa(i),mark1),locus(fa(i),mark12),
     4               locus(mo(i),mark1),locus(mo(i),mark12),
     5               numal,name,alfrq )
            pi2=fibd(locus(i,mark2),locus(i,mark22),
     2               locus(j,mark2),locus(j,mark22),
     3               locus(fa(i),mark2),locus(fa(i),mark22),
     4               locus(mo(i),mark2),locus(mo(i),mark22),
     5               numal2,name2,alfrq2 )
            x(2)=0.0d0
            x(3)=pihat(1,th1, th2, th12, pi1, pi2)
          else
C half sib
            hsibs=hsibs+1
            x(2)=1.0d0
            if (samefa) then
              pi1=hibd(locus(i,mark1),locus(i,mark12),
     2                 locus(j,mark1),locus(j,mark12),
     3                 locus(mo(i),mark1),locus(mo(i),mark12),
     4                 locus(fa(i),mark1),locus(fa(i),mark12),
     5                 locus(mo(j),mark1),locus(mo(j),mark12))
              pi2=hibd(locus(i,mark2),locus(i,mark22),
     2                 locus(j,mark2),locus(j,mark22),
     3                 locus(mo(i),mark2),locus(mo(i),mark22),
     4                 locus(fa(i),mark2),locus(fa(i),mark22),
     5                 locus(mo(j),mark2),locus(mo(j),mark22))
              x(3)=pihat(2,th1, th2, th12, pi1, pi2)
            else
              pi1=hibd(locus(i,mark1),locus(i,mark12),
     2                 locus(j,mark1),locus(j,mark12),
     3                 locus(fa(i),mark1),locus(fa(i),mark12),
     4                 locus(mo(i),mark1),locus(mo(i),mark12),
     5                 locus(fa(j),mark1),locus(fa(j),mark12))
              pi2=hibd(locus(i,mark2),locus(i,mark22),
     2                 locus(j,mark2),locus(j,mark22),
     3                 locus(fa(i),mark2),locus(fa(i),mark22),
     4                 locus(mo(i),mark2),locus(mo(i),mark22),
     5                 locus(fa(j),mark2),locus(fa(j),mark22))
              x(3)=pihat(2,th1, th2, th12, pi1, pi2)
            end if
          end if
          mux=mux+x(3)
          call givenc(r, 10, 4, x, 1.0d0, ifail)
        end if              
   15   continue
        df=df+contrib
   10  continue
      goto 5
   20 continue
C 
      mux=mux/dfloat(sibs)
      call alias(r, 10, 4, 1.0d-5, x, ifail)
      call bsub(r, 10, 4, b, 3, ifail)
      call var(r, 10, cov, 10, 4, sibs, 1, ifail)
      alpha=b(1)
      sea=sqrt(cov(1))
      beta=b(3)
      seb=sqrt(cov(6))
      tvalb=beta/seb
      error='                '
      if (ifail.ne.0) error='Regression error'
      df=df-2
      write(*,99) th12,th1,th2,sibs,mux,alpha,beta,
     2            tvalb,probst(tvalb,df,ifail),error,hsibs,
     3            sea, seb, df
   99 format(f5.3,3x,f5.3,2x,f5.3,1x,i4,2x,f5.3,2(3x,f9.3),3x,f6.2,
     2       4x,f5.3,/2x,a16,3x,i4,' (hsibs)',2(' (',f9.3,')'),
     3       '(df=',i4,')')
      return
      end
C end-of-twopair
C
C estimate regression coefficients for E(pi)=intercpt+b1*pi1+b2*pi2
C using Olson 1995
C
      double precision function pihat(typ, th1, th2, th12, pi1, pi2)
      integer typ
      double precision th1, th2, th12
      double precision pi1, pi2
      double precision a0, b1, b2, psi1, psi2, psi12
      psi1=1.0d0-2.0d0*th1*(1.0d0-th1)
      psi2=1.0d0-2.0d0*th2*(1.0d0-th2)
      psi12=1.0d0-2.0d0*th12*(1.0d0-th12)
      a0=(1.0d0-psi1)*(1.0d0-psi2)/psi12
      b1=-psi2*(1.0d0-psi2)*(1-2.0d0*psi1)/psi12/(1-psi12)
      b2=-psi1*(1.0d0-psi1)*(1-2.0d0*psi2)/psi12/(1-psi12)
      if (typ.eq.2) a0=a0/2.0d0
      pihat=a0+b1*pi1+b2*pi2
      return
      end
C end-of-pihat
C
C Monte-Carlo approach to estimating IBD sharing at a marker
C
      subroutine wribd(wrk,twrk,gene,iter,burnin,typ,pedigree,actset,
     2              num,nfound,id,fa,mo,sex,locus, numloc,numal,name,
     3              alfrq,gfrq,untyped,set,set2,sibd,key,
     4              ibdcount, plevel)
      integer IBDSIZ, KNOWN, MAXALL, MAXG, MAXIBD, MAXSIZ, MAXLOC, MISS
      parameter(MAXALL=2, MAXG=MAXALL*(MAXALL+1)/2, MAXSIZ=20, 
     2          MAXLOC=10000, MISS=-9999, KNOWN=0, 
     3          MAXIBD=20, IBDSIZ=MAXIBD*(MAXIBD+1)/2)
      integer burnin,gene,iter,plevel,twrk,typ,wrk 
C  Pedigree structure
      character*10 pedigree
      integer actset,num, nfound
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ)
      integer sex(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)
C allele frequencies structure
      integer numal, name(MAXALL)
      double precision alfrq(MAXALL), gfrq(MAXG)
C work arrays for metropolis algorithm
      integer nuntyp
      logical untyped(MAXSIZ)
      integer set(MAXSIZ,2), sibd(MAXSIZ,2), key(2*MAXSIZ)
C metropolis work arrays
      integer set2(MAXSIZ,2)
C untyped matings
      integer nummat, cntmat(MAXALL,2)
C ibd sharing
      double precision ibdcount(IBDSIZ)
C local variables
      integer g1,g2,gen2,i,idx,j,nfam
      integer iprop, proprate(4), proptyp(4)
      logical alltyp,last,useful
      double precision den, zibd
C functions
      integer getnam

      do 102 i=1,4
        proprate(i)=0
        proptyp(i)=0
  102 continue
      if (typ.eq.3 .or. typ.eq.4) then
        den=1.0d0
      else
        den=1.0d0/dfloat(2*iter)
      end if
      gen2=gene+1
      last=.false.
      nfam=0
      rewind(wrk)
    5 continue
        call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &             numloc, last)
        if (last) goto 20

        if (actset.le.0 .or. num.gt.MAXIBD) goto 5
C
C test if informative pedigree -- at least one relative pair with
C marker genotype for both members
C
        useful=.false.
        do 7 i=1,num
        if (locus(i,gene).gt.KNOWN) then
          do 8 j=max(nfound+1,i+1),num
          if (locus(j,gene).gt.KNOWN) then
            useful=.true.
            goto 9
          end if
    8     continue
        end if
    7   continue
    9   continue
C
        if (.not.useful) then
          if (typ.eq.5) then
            do 11 i=1,num
              write(twrk,*) (0.0d0,j=1,i-1),1.0d0
   11       continue
          end if
          goto 5
        end if
C
C Load genotypes into set()
        nfam=nfam+1
        nuntyp=0
        alltyp=.true.
        do 12 i=1,num
          if (locus(i,gene).le.KNOWN) then
            alltyp=.false.
            untyped(i)=.true.
            nuntyp=nuntyp+1
            if (locus(i,gene).eq.0 .or. locus(i,gene).eq.MISS) then
              g1=MISS
              g2=MISS
            else
              g1=getnam(-locus(i,gene),numal,name)
              g2=getnam(-locus(i,gen2),numal,name)
            end if
          else
            untyped(i)=.false.
            g1=getnam(locus(i,gene),numal,name)
            g2=getnam(locus(i,gen2),numal,name)
          end if
          call update(i,g1,g2,set)
   12   continue
        do 13 idx=1,num*(num-1)/2
          ibdcount(idx)=0.0d0
   13   continue
C
C IBS
C
        if (typ.eq.3 .or. typ.eq.4) then
          idx=0
          do 15 i=2,num
            do 16 j=1,i-1
              idx=idx+1
              if (untyped(i) .or. untyped(j)) then
                ibdcount(idx)=-1.0d0
              else
                call share(set(i,1),set(i,2),
     &                     set(j,1),set(j,2),zibd)
                ibdcount(idx)=zibd
              end if
   16       continue
   15     continue
C
C IBD: all genotypes known
C
        elseif (alltyp) then
          do 10 it=1,iter
            call simibd(2,pedigree,num,nfound,fa,mo,set,sibd)
            idx=0
            do 25 i=2,num
              do 26 j=1,i-1
                idx=idx+1
                call share(sibd(i,1),sibd(i,2),
     &                     sibd(j,1),sibd(j,2),zibd)
                ibdcount(idx)=ibdcount(idx)+zibd+zibd
   26         continue
   25       continue
   10     continue
        else
C IBD: some untyped markers:
C produce genotype frequencies for Metropolis criterion
C enumerate untyped founder matings
          call genot(numal,alfrq,ngtp,gfrq)
          call tabmat(num,nfound,fa,mo,untyped,nummat,cntmat)
C Metropolis simulation of genotypes
          if (plevel.gt.1) then
            write(*,'(/2a,4(/a,i4))') 
     2        'Metropolis simulation of pedigree ',pedigree,
     3        'Untyped Individuals: ',nuntyp,
     4        'Possible genotypes : ',ngtp,
     5        'UnT x UnT matings  : ',nummat,
     6        'Burn-in (iters)    : ',burnin
          end if
          do 44 it=1,burnin
            call drop(it,pedigree,num,nfound,id,fa,mo,nummat,
     &             cntmat,untyped,numal,gfrq,set,set2,sibd,key,iprop,0)
   44     continue
          do 45 it=1,iter
            call drop(it,pedigree,num,nfound,id,fa,mo,nummat,
     2             cntmat,untyped,numal,gfrq,set,set2,sibd,key,
     3             iprop,plevel)
            call simibd(2,pedigree,num,nfound,fa,mo,set,sibd)
            call cntprop(iprop, proprate, proptyp)
C           call simibd(1,pedigree,num,nfound,fa,mo,set,set2)
            idx=0
            do 65 i=2,num
              do 66 j=1,i-1
                idx=idx+1
                call share(sibd(i,1),sibd(i,2),
     &                     sibd(j,1),sibd(j,2),zibd)
                ibdcount(idx)=ibdcount(idx)+zibd+zibd
   66         continue
   65       continue
   45     continue
        end if
        
        idx=0
        if (typ.eq.5 .or. typ.eq.7) then
          do 69 i=1,num
            write(twrk,*) (den*ibdcount(j),j=idx+1,idx+i-1),1.0d0
            idx=idx+i-1
   69     continue
        else if (mod(typ,2).eq.1) then
          write(*,'(/2a/a10,1x,f5.2)') 'Pedigree ',pedigree,id(1),1.0
          do 70 i=2,num
            write(*,'(a10,1x,50f5.2,(/6x,50f5.2):)') 
     2        id(i), (den*ibdcount(j), j=idx+1,idx+i-1), 1.0
            idx=idx+i-1
   70     continue
        else
          do 80 i=2,num
          do 80 j=1,i-1
            idx=idx+1
            write(*,'(a10,2(1x,a10),1x,f6.3)') 
     &        pedigree, id(i), id(j), den*ibdcount(idx)
   80     continue
        end if
      goto 5
   20 continue
      if (typ.eq.5 .or. typ.eq.7) then
        rewind(twrk)
      else if (typ.eq.1 .or. typ.eq.2) then
        call wrprop(0, proprate, proptyp)
      end if
C
      return
      end
C end-of-wribd  
C
C Write kinship coefficients 
C
      subroutine dokin(wrk,typ,pedigree,actset,num,nfound,id,fa,mo,
     &                 sex,locus,numloc,ibdcount)
      integer IBDSIZ,MAXIBD,MAXSIZ,MAXLOC
      parameter (MAXSIZ=20,MAXLOC=10000,MAXIBD=20, 
     &           IBDSIZ=MAXIBD*(MAXIBD+1)/2)
      integer nfound,actset,num,numloc,typ,wrk
C Pedigree structure
      character*10 pedigree
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ)
      integer sex(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)
C Array to contain kinship coefficients
      double precision ibdcount(IBDSIZ)
C
C local variables: gk,gl,hk,hl are parent-pair indices for dominance
      integer gk,gl,hk,hl,i,idx,j,tot
      double precision dom, meanf
      logical last
C functions
      integer clcpos

      meanf=0.0d0
      tot=0
      if (typ.eq.3) then
        write(*,'(3(/a)/2(/a))')
     2   '--------------------------------------------------',
     3   'Individuals with non-zero inbreeding coefficient',
     4   '--------------------------------------------------',
     5   'Pedigree   Person   Father   Mother   F',
     6   '---------- -------- -------- -------- -----'
      else
        write(*,'(3(/a))')
     2   '--------------------------------------------------',
     3   'Coefficient of relationship for all relative pairs',
     4   '--------------------------------------------------'
        if (typ.eq.2) then
          write(*,'(a//a/)') 
     2      'NOTE:  Writing one relative pair per record',
     3      'Pedigree   Person-1 Person-2     R      K'
        end if
      end if

      last=.false.
      rewind(wrk)
    5 continue
       call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &            numloc, last)
       if (last) goto 20

       if (actset.le.0 .or. num.gt.MAXIBD) goto 5
C 
        call kinship(num,nfound,fa,mo,ibdcount)

        if (typ.eq.3) then
          tot=tot+num-nfound
          idx=nfound*(nfound+1)/2
          do 70 i=nfound+1,num
            idx=idx+i
            meanf=meanf+ibdcount(idx)-1.0d0
            if (ibdcount(idx).gt.1.0d0) then
              write(*,'(a10,3(1x,a10),1x,f5.3)') 
     &          pedigree,id(i),id(fa(i)),id(mo(i)),ibdcount(idx)-1.0d0
            end if
   70     continue
        else  
          idx=0
          if (typ.eq.1) then
            write(*,'(/2a)') 'Pedigree ',pedigree
            do 75 i=1,num
              write(*,'(a5,1x,50f5.2,(/6x,50f5.2):)') 
     2          id(i), (ibdcount(j), j=idx+1,idx+i)
              idx=idx+i
   75       continue
          else
            do 80 i=1,num
            do 80 j=1,i  
              idx=idx+1
              if (i.eq.j) then
                dom=1.0d0
              elseif (i.gt.nfound .and. j.gt.nfound) then
                gk=clcpos(fa(i),fa(j))
                hl=clcpos(mo(i),mo(j))
                gl=clcpos(fa(i),mo(j))
                hk=clcpos(mo(i),fa(j))
                dom=ibdcount(gk)*ibdcount(hl)+ibdcount(gl)*ibdcount(hk)
                dom=0.25d0*dom
              else
                dom=0.0d0
              end if
              write(*,'(a10,2(1x,a10),1x,f6.4,1x,f6.4)') 
     &          pedigree, id(i), id(j), ibdcount(idx), dom
   80       continue
          end if
        end if
      goto 5
   20 continue
      if (typ.eq.3) then
        if (tot.gt.0) meanf=meanf/dfloat(tot)
        write(*,'(/a,1x,f8.6,a,i5,a)') 'Mean inbreeding coefficient = ',
     &    meanf,' (based on ',tot,' nonfounder individuals)'
      end if   
      return
      end
C end-of-dokin
C
C Calculate kinship coefficient
C
      subroutine kinship(num,nfound,fa,mo,ibdcount)
      integer IBDSIZ, MAXIBD, MAXSIZ
      parameter (MAXSIZ=20, MAXIBD=20, IBDSIZ=MAXIBD*(MAXIBD+1)/2)
      integer nfound,num
C Pedigree structure
      integer fa(MAXSIZ),mo(MAXSIZ)
C Array to contain kinship coefficients
      double precision ibdcount(IBDSIZ)
C local variables
      integer i,idx,j,posfa,posmo
C functions
      integer clcpos

      idx=0
      do 50 i=1,nfound
        do 55 j=1,i-1
          idx=idx+1
          ibdcount(idx)=0.0d0
   55   continue
        idx=idx+1
        ibdcount(idx)=1.0d0
   50 continue
      do 60 i=nfound+1, num
        do 65 j=1,i-1
          idx=idx+1
          posfa=clcpos(fa(i),j)
          posmo=clcpos(mo(i),j)
          ibdcount(idx)=0.5d0*(ibdcount(posfa)+ibdcount(posmo))
   65   continue
        idx=idx+1
        posfa=clcpos(fa(i),mo(i))
        ibdcount(idx)=1.0d0+0.5d0*ibdcount(posfa)
   60 continue
      return
      end
C end-of-kinship
C
C Calculate coefficient of fraternity
C
      subroutine frater(num,nfound,fa,mo,kin,dom)
      integer IBDSIZ, MAXIBD, MAXSIZ
      parameter (MAXSIZ=20, MAXIBD=20, IBDSIZ=MAXIBD*(MAXIBD+1)/2)
      integer nfound,num
C Pedigree structure
      integer fa(MAXSIZ),mo(MAXSIZ)
C Array to contain domship coefficients
      double precision kin(IBDSIZ), dom(IBDSIZ)
C local variables
      integer i,idx,j,gk,gl,hl,hk
C functions
      integer clcpos

      idx=0
      do 80 i=1,num
      do 80 j=1,i  
        idx=idx+1
        if (i.eq.j) then
          dom(idx)=1.0d0
        elseif (i.gt.nfound .and. j.gt.nfound) then
          gk=clcpos(fa(i),fa(j))
          hl=clcpos(mo(i),mo(j))
          gl=clcpos(fa(i),mo(j))
          hk=clcpos(mo(i),fa(j))
          dom(idx)=0.25d0 * (kin(gk)*kin(hl)+
     &                       kin(gl)*kin(hk))
        else
          dom(idx)=0.0d0
        end if
   80 continue
      return
      end
C end-of-frater
C
C Construct inverse numerator relationship matrix
C 
C A~ = (T~)' D~ T~
C
      subroutine invkin(num,nfound,fa,mo,ainv)
      integer IBDSIZ, MAXIBD, MAXSIZ
      parameter (MAXSIZ=20, MAXIBD=20, IBDSIZ=MAXIBD*(MAXIBD+1)/2)
      integer nfound,num
C Pedigree structure
      integer fa(MAXSIZ),mo(MAXSIZ)
C Array to contain A~
      double precision ainv(IBDSIZ)
C local variables
      integer i,j,jj,k,pos
      double precision res
C functions
      integer clcpos

C calculate T~
      do 10 i=1,num*(num+1)/2
        ainv(i)=0.0d0
   10 continue
      pos=0
      do 20 i=1,num
        pos=pos+i
        ainv(pos)=1.0d0
   20 continue
      do 30 i=nfound+1,num
        ainv(clcpos(fa(i),i))=-0.5d0
        ainv(clcpos(mo(i),i))=-0.5d0
   30 continue
C
C evaluate product r' D~ r where D~[i,i]=1 i=1..nfound; 2 i=nfound+1,num
C
      pos=0
      do 40 i=1,num
        inc=i-1
        do 50 j=1,i
          pos=pos+1
          jj=pos
          res=0.0d0
          do 60 k=i,nfound
            res=res+ainv(jj)*ainv(jj+inc)
            jj=jj+k
   60     continue
          do 65 k=max(nfound+1,i),num
            res=res+2*ainv(jj)*ainv(jj+inc)
            jj=jj+k
   65     continue
          ainv(pos)=res
          inc=inc-1
   50   continue
   40 continue
      return
      end
C end-of-invkin
C
C Calculate standard deviation of segregation error 
C (used for gametic model breeding value calculation)
C
      subroutine segerr(num,nfound,fa,mo,ibdcount,rsd)
      integer IBDSIZ, MAXIBD, MAXSIZ
      parameter (MAXSIZ=20, MAXIBD=20, IBDSIZ=MAXIBD*(MAXIBD+1)/2)
      integer nfound,num
C Pedigree structure
      integer fa(MAXSIZ),mo(MAXSIZ)
C Array to contain kinship coefficients
      double precision ibdcount(IBDSIZ), rsd(MAXSIZ)
C local variables
      integer cfa, cmo, i
      double precision rthalf
C functions
      integer clcpos
      data rthalf /0.70710678118655d0/

      call kinship(num,nfound,fa,mo,ibdcount)
      do 10 i=1, nfound
        rsd(i)=rthalf
   10 continue
      do 20 i=nfound+1, num
        cfa=fa(i)
        cmo=mo(i)
        rsd(i)=sqrt(1.0d0-0.25d0*(ibdcount(clcpos(cfa,cfa))+
     &                            ibdcount(clcpos(cmo,cmo))))
   20 continue
      return
      end
C end-of-segerr
C
C Do ibs sharing ASP analysis as per Lange 1986 and Bishop 1990
C
      subroutine doasp(wrk,trait,locnam,gene,gt,thresh,pedigree,
     2                 actset,num,nfound,id,fa,mo,sex,locus,numloc,
     3                 numal,name,alfrq,ibd,untyped,set,plevel)
      integer IBDSIZ, KNOWN, MAXALL, MAXIBD, MAXSIZ, MAXLOC, MISS
      parameter(MAXIBD=20, IBDSIZ=MAXIBD*(MAXIBD+1)/2, KNOWN=0,
     &          MAXALL=2, MAXSIZ=20, MAXLOC=10000, MISS=-9999)
      integer gene,gt,actset,num,numloc,plevel,trait,wrk
      double precision thresh
      character*10 locnam
C Pedigree structure
      character*10 pedigree
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ)
      integer sex(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)
C allele frequencies structure
      integer numal, name(MAXALL)
      double precision alfrq(MAXALL)
C sibship ibd array 
      double precision ibd(IBDSIZ)
C work arrays for nucibd
      integer set(MAXSIZ,2)
      logical untyped(MAXSIZ)
C calculate expected ibs statistics for marker
      double precision p, p2, p4, pp, pq, pq2, q, f(3), h(3)
C 2 df chi-square
      integer tabf(3),tabh(3)
      double precision chif, chih, ef, eh, ex, muf, muh, mux, obs
C
      integer contrib,currf, currm, fin,gen2,i,ibs,j,k,nfs,nhs,pos
      character*3 histo
      double precision ibdp, ibsp, zibd
      logical last
C functions
      integer getnam
      double precision isaff
      double precision binp, chip

      muf=0.0d0
      muh=0.0d0
      mux=0.0d0
      do 1 i=1,3
        tabf(i)=0
        tabh(i)=0
    1 continue
      gen2=gene+1
      pedigree=' '
      last=.false.
      rewind(wrk)
C Calculate expected values for ibs statistic
      p2=0.0d0
      p4=0.0d0
      pp=0.0d0
      pq2=0.0d0
      do 3 i=1,numal
        p=alfrq(i)
        q=1.0d0-p
        p=p*p
        q=q*q
        p2=p2+p
        pq2=pq2+p*q
        p4=p4+p*p
        do 3 j=i+1,numal
          p=alfrq(i)
          q=alfrq(j)
          pq=1.0d0-p-q
          pp=pp+p*q*pq*pq
    3 continue
      f(3)=0.25d0*(1.0d0+2.0d0*p2*(1.0d0+p2)-p4)
      f(1)=0.25d0*(pq2+pp+pp)
      f(2)=1.0d0-f(3)-f(1)
      ef=f(3)+0.5d0*f(2)
      h(3)=0.5d0*(p2*(1.0d0+p2+p2)-p4)
      h(1)=2.0d0*f(1)
      h(2)=1.0d0-h(3)-h(1)
      eh=h(3)+0.5d0*h(2)
C
    5 continue
       call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &            numloc, last)
       if (last) goto 20

        if (actset.le.0) goto 5
C
        do 7 i=1,num
        if (locus(i,gene).gt.KNOWN) then
          untyped(i)=.false.
          set(i,1)=getnam(locus(i,gene),numal,name)
          set(i,2)=getnam(locus(i,gen2),numal,name)
        else  
          untyped(i)=.true.
          set(i,1)=MISS
          set(i,2)=MISS
        end if
    7   continue
        fin=num
        currf=fa(fin)
        currm=mo(fin)
C only iterate nonfounders -- sibship by sibship
        do 90 k=num-1,nfound,-1
          if (fa(k).ne.currf .or. mo(k).ne.currm) then
            contrib=0
            do 92 i=k+1,fin
            if (isaff(locus(i,trait),thresh,gt).eq.2.0 .and.
     &          .not.untyped(i)) then
              contrib=contrib+1
            end if
   92       continue
C
C Skip if no usable individuals in this sibship
C
            if (contrib.gt.0) then

            call nucibd(gene,currf,currm,k+1,fin,set,untyped,ibd,
     &                  numal, name, alfrq)
            pos=0
            do 95 i=k+1,fin
              do 97 j=k+1,i-1
                pos=pos+1
                if (isaff(locus(i,trait),thresh,gt).eq.2.0 .and.
     2              isaff(locus(j,trait),thresh,gt).eq.2.0 .and.
     3              .not.untyped(i) .and. .not.untyped(j))
     4          then
                  sibs=sibs+1
                  call share(set(i,1), set(i,2),
     &                       set(j,1), set(j,2), zibd)
                  ibs=int(2.0d0*zibd)+1
                  mux=mux+ibd(pos)
                  tabf(ibs)=tabf(ibs)+1
                end if
   97         continue
              pos=pos+1
   95       continue
C
C half-sibs related to current sibship -- only scan sibships not yet visited
C stored in different style to full sibs
C
            do 300 i=nfound+1,k
              if (fa(i).eq.currf .or. mo(i).eq.currm .and.
     2            isaff(locus(i,trait),thresh,gt).eq.2.0 .and.
     3            .not.untyped(i)) then
                contrib=contrib+1
                do 302 j=k+1,fin
                if (isaff(locus(j,trait),thresh,gt).eq.2.0 .and.
     &              .not.untyped(j)) then
                  hsibs=hsibs+1
                  call share(set(i,1), set(i,2),
     &                       set(j,1), set(j,2), zibd)
                  ibs=int(2.0d0*zibd)+1
                  tabh(ibs)=tabh(ibs)+1
                end if
  302           continue
              end if
  300       continue

            end if
C Now update to next sibship
            fin=k
            currf=fa(fin)
            currm=mo(fin)
          end if
   90   continue
      goto 5 
   20 continue

      nfs=tabf(3)+tabf(2)+tabf(1)
      nhs=tabh(3)+tabh(2)+tabh(1)
      if (nfs.gt.0) muf=0.5d0*dfloat(2*tabf(3)+tabf(2))/dfloat(nfs)
      if (nhs.gt.0) muh=0.5d0*dfloat(2*tabh(3)+tabh(2))/dfloat(nhs)
      if (plevel.gt.0) then
        write(*,'(3a/)') 
     &    '----------- ASP analysis for "',locnam,'" --------------'
        write(*,'(2(12x,a/),2(a,i6,2x,3i6,6x,f6.4,3x,f6.4/))')
     2              'No. of  IBS Sharing         Mean IBS sharing',
     3              'Pairs   2/2   1/2   0/2         Obs      Exp',
     4    'Full-sibs',nfs,tabf(3),tabf(2),tabf(1), muf, ef,
     5    'Half-sibs',nhs,tabh(3),tabh(2),tabh(1), muh, eh
        write(*,'(2(12x,a/),2(a,8x,3f6.3/))')
     2              'Expectd IBS Sharing',
     3              '        2/2   1/2   0/2  ',
     4    'Full-sibs',f(3),f(2),f(1), 'Half-sibs',h(3),h(2),h(1)
      end if
      if (nfs.gt.0) then
        chif=0.0d0
        do 25 i=1,3
          ex=dfloat(nfs)*f(i)
          obs=dfloat(tabf(i))
          if (obs.gt.0.001d0 .and. ex.gt.0.001d0) then
            chif=chif+obs*log(obs/ex)
          end if
   25   continue
        chif=chif+chif
        ibsp=chip(chif,2)
        ibdp=binp(2.0d0*mux,dfloat(2*nfs)-2.0d0*mux)
        if (plevel.gt.0) then
          write(*,'(a,f6.1,a,f6.4,a/a,f6.4,a,f6.4,a)') 
     2    'Full-Sib Chi-square (2 df) =',chif,' (P=',ibsp,')',
     3    'Mean full-sib IBD sharing  =',mux/dfloat(nfs),
     4    ' (P=',ibdp,')'
          if (muf.lt.ef) then
            write(*,'(/a/)') 
     &        'NOTE:  Full-sib IBS sharing less than expected.'
          end if
        else
          call phist(ibsp,ibdp,histo)
          write(*,'(a10,1x,i6,5(1x,f6.4),2(1x,a))')
     &    locnam, nfs, muf, ef, ibsp, mux/dfloat(nfs), ibdp, 'ASP',histo
        end if
      end if
      if (nhs.gt.0) then
        chih=0.0d0
        do 35 i=1,3
          ex=dfloat(nhs)*h(i)
          obs=dfloat(tabh(i))
          if (obs.gt.0.001d0 .and. ex.gt.0.001d0) then
            chih=chih+obs*log(obs/ex)
          end if
   35   continue
        chih=chih+chih
        ibsp=chip(chih,2)
        if (plevel.gt.0) then
          write(*,'(a,f6.1,a,f6.4,a)') 
     &      'Half-Sib Chi-square (2 df) =',chih,' (P=',ibsp,')'
          if (muh.lt.eh) then
            write(*,'(/a/)') 
     &      'NOTE:  Half-sib IBS sharing less than expected.'
          end if
        end if
      end if
      return
      end
C end-of-doasp
C
C Perform monte-carlo based APM analysis
C
      subroutine doapm(wrk,trait,locnam,gene,typ,iter,burnin,gt,thresh,
     2                 pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     3                 numloc,numal,name,alfrq,cumfrq,gfrq,
     4                 set,set2,sibd,key,untyped,plevel)
C
      integer MAXALL, MAXG, MAXSIZ, MAXLOC, MISS, KNOWN
      parameter(MAXALL=2, MAXG=MAXALL*(MAXALL+1)/2, MAXSIZ=20, 
     &          MAXLOC=10000, MISS=-9999, KNOWN=0)
      integer burnin,gene,gt,iter,plevel,trait,typ,wrk
      double precision thresh
      character*10 locnam
C pedigree structure
      character*10 pedigree
      integer sex(MAXSIZ)
      integer actset,num, nfound
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ)
      integer set(MAXSIZ,2),sibd(MAXSIZ,2)
      logical untyped(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)
C metropolis work arrays
      integer set2(MAXSIZ,2),key(2*MAXSIZ)
C untyped matings
      integer nummat, cntmat(MAXALL,2)
C allele frequencies structure
      integer numal, name(MAXALL)
      double precision alfrq(MAXALL), cumfrq(MAXALL), gfrq(MAXG)
C
C list of affected individuals
C storage is affected ID in aff(1...aff), unaffected ID in aff(unaff...MAXSIZ)
C
      integer naff, unaff, aff(MAXSIZ)
C other local variables
      logical alltyp,fin,last
      integer gen2,g1,g2,i,iprop,j,k,nt,ut
      character*3 histo
      double precision den
C families containing AA, AU, UU, AA+AU, GPM/WH pairs
      logical pair(5)
C number of families containing AA, AU, UU, or any AA, AU, UU pairs
      integer nfam(4)
C ibd [,1] or ibs [,1-3] based statistics
      double precision wt,z(5,3),oz(5,3),t(5,3),sz(5,3),v(5,3)
      double precision n(5,3), d(5,3), pval(5,3), zsum(5,3)
C functions
      integer eow, getnam
      double precision isaff
      double precision makewt, simil, ppnd, zp
C
      if (numal.eq.0) then
        return
      end if
      den=dfloat(iter)
      gen2=gene+1
      nt=0
      ut=0
      do 4 j=1,4
        nfam(j)=0
    4 continue
      do 5 j=1,5
      do 5 k=1,3
        zsum(j,k)=0.0d0
        n(j,k)=0.0d0
        d(j,k)=0.0d0
    5 continue

      if (plevel.gt.0) then
        write(*,'(/3a/)') 
     &    '----------- APM analysis for "',locnam,'" --------------'
      end if

      last=.false.
      rewind(wrk)
   10 continue
       call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &            numloc, last)
       if (last) goto 20

        if (actset.le.0) goto 10
C
C transfer genotype to set() and record if typed in untyped()
C record affection status in set2(,2)
C
         alltyp=.true.
         nuntyp=0
         do 6 i=1,num
          if (locus(i,gene).le.KNOWN) then
            alltyp=.false.
            untyped(i)=.true.
            nuntyp=nuntyp+1
            if (locus(i,gene).eq.0 .or. locus(i,gene).eq.MISS) then
              if (typ.eq.1) then
                g1=0
                g2=0
              else
                write(*,'(a/7x,a)') 
     2            'ERROR: Starting genotypes were not generated.',
     3            'Imputation must be set to higher than -1.'
                return 
              end if
            else
              g1=getnam(-locus(i,gene),numal,name)
              g2=getnam(-locus(i,gen2),numal,name)
            end if
          else
            untyped(i)=.false.
            g1=getnam(locus(i,gene),numal,name)
            g2=getnam(locus(i,gen2),numal,name)
          end if
          call update(i,g1,g2,set)
          set2(i,2)=int(isaff(locus(i,trait),thresh,gt))
          set2(i,1)=0
    6   continue
C
C store number of offspring in set2(,1)
C
        do 7 i=nfound+1,num
          set2(fa(i),1)=set2(fa(i),1)+1
          set2(mo(i),1)=set2(mo(i),1)+1
    7   continue
C
C trim uninformative persons ie untyped individuals with no offspring
C by setting their affection status to missing -- update their parents
C offspring number (so that end with number of informative offspring)
C
    8   continue
          fin=.true.
          do 9 i=1,num
          if (set2(i,1).eq.0 .and. untyped(i)) then
            fin=.false.
            set2(i,1)=MISS
            set2(i,2)=MISS
            set2(fa(i),1)=set2(fa(i),1)-1
            set2(mo(i),1)=set2(mo(i),1)-1
          end if
    9     continue
        if (.not.fin) goto 8
C
C transfer affection status to list
C
        naff=0
        unaff=MAXSIZ+1
        do 12 i=1,num
        if (.not.untyped(i) .or. typ.eq.2) then
          if (set2(i,2).eq.2) then
            naff=naff+1
            aff(naff)=i
          elseif (set2(i,2).eq.1) then
            unaff=unaff-1
            aff(unaff)=i
          end if
        end if
   12   continue
         unaff=MAXSIZ+1-unaff
C
C check if family appropriate for different (or any) statistics
C
         if ((naff+unaff).lt.2 .or. num.le.3) then
           if (plevel.gt.0) write(*,'(a,a10//a,/)')
     &       'Pedigree ',pedigree, ' Insufficient persons typed'
           goto 10
         end if
         nfam(4)=nfam(4)+1
         pair(1)=.false.
         pair(2)=.false.
         pair(3)=.false.
         pair(4)=.true.
         pair(5)=.false.
         if (naff.gt.1) then
           nfam(1)=nfam(1)+1
           pair(1)=.true.
           pair(5)=.true.
         end if
         if (naff.gt.0 .and. unaff.gt.0) then
           nfam(2)=nfam(2)+1
           pair(2)=.true.
           if (typ.eq.1) pair(5)=.true.
         end if
         if (unaff.gt.1) then
           nfam(3)=nfam(3)+1
           pair(3)=.true.
         end if
         nt=nt+naff
         ut=ut+unaff
C if ibs based statistic
         if (typ.eq.1) then
           call clcibs(naff,unaff,aff,alfrq,set,oz)
           do 11 j=1,5
           do 11 k=1,3
             pval(j,k)=0.0d0
             sz(j,k)=0.0d0
             v(j,k)=0.0d0
   11      continue
C
C generate ibs distribution under null
C
           do 14 i=1, iter
             call simped(num,nfound,fa,mo,cumfrq,set)
             call clcibs(naff,unaff,aff,alfrq,set,z)
C 
C only update statistic if appropriate family
C
             do 13 j=1,5
             if (pair(j)) then
               do 113 k=1,3
                 if (j.ne.2) then
                   if (z(j,k).gt.oz(j,k) .or. (z(j,k).eq.oz(j,k) .and.
     &               random().gt.0.5)) pval(j,k)=pval(j,k)+1.0d0
                 else
                   if (z(j,k).lt.oz(j,k) .or. (z(j,k).eq.oz(j,k) .and.
     &               random().gt.0.5)) pval(j,k)=pval(j,k)+1.0d0
                 end if
                 call moment(i,z(j,k),sz(j,k),v(j,k))
  113          continue
             end if
   13        continue
   14      continue
C
           do 17 j=1,5
           if (pair(j)) then
             do 117 k=1,3
               if (pval(j,k).eq.0.0d0) then
                 pval(j,k)=0.5d0/den
               elseif (pval(j,k).eq.den) then
                 pval(j,k)=1.0d0-0.5d0/den
               else
                 pval(j,k)=pval(j,k)/den
               end if
               zsum(j,k)=zsum(j,k)+ppnd(1.0d0-pval(j,k))
               v(j,k)=v(j,k)/dfloat(max(1,iter-1))
               if (v(j,k).gt.0) then
                 wt=makewt(j,naff,unaff,v(j,k))
                 t(j,k)=(oz(j,k)-sz(j,k))/sqrt(v(j,k))
                 n(j,k)=n(j,k)+wt*(oz(j,k)-sz(j,k))
                 d(j,k)=d(j,k)+wt*wt*v(j,k)
               else
                 t(j,k)=0.0d0
               end if
  117        continue
           else
             t(j,1)=0.0d0
             t(j,2)=0.0d0
             t(j,3)=0.0d0
           end if  
   17      continue
           if (plevel.gt.1) then
             write(*,'(a,a10,a/a,3(/a,4(1x,f10.3),1x,f6.4))')
     2       'Pedigree ',pedigree,
     3       '  E(Z)     Var(Z)         Z          T      MC-P',
     4       'Aff-Aff',
     5       'f(p) = 1        ',sz(1,1),v(1,1),oz(1,1),t(1,1),pval(1,1),
     6       'f(p) = 1/sqrt(p)',sz(1,2),v(1,2),oz(1,2),t(1,2),pval(1,2),
     7       'f(p) = 1/p      ',sz(1,3),v(1,3),oz(1,3),t(1,3),pval(1,3)
             write(*,'(a,3(/a,4(1x,f10.3),1x,f6.4))')
     2       'Aff-UnA',
     3       'f(p) = 1        ',sz(2,1),v(2,1),oz(2,1),t(2,1),pval(2,1),
     4       'f(p) = 1/sqrt(p)',sz(2,2),v(2,2),oz(2,2),t(2,2),pval(2,2),
     5       'f(p) = 1/p      ',sz(2,3),v(2,3),oz(2,3),t(2,3),pval(2,3)
             write(*,'(a,3(/a,4(1x,f10.3),1x,f6.4))')
     2       'Aff-Aff v. Aff-UnA',
     3       'f(p) = 1        ',sz(5,1),v(5,1),oz(5,1),t(5,1),pval(5,1),
     4       'f(p) = 1/sqrt(p)',sz(5,2),v(5,2),oz(5,2),t(5,2),pval(5,2),
     5       'f(p) = 1/p      ',sz(5,3),v(5,3),oz(5,3),t(5,3),pval(5,3)
             write(*,'(a,3(/a,4(1x,f10.3),1x,f6.4))')
     2       'GPM',
     4       'f(p) = 1        ',sz(4,1),v(4,1),oz(4,1),t(4,1),pval(4,1),
     5       'f(p) = 1/sqrt(p)',sz(4,2),v(4,2),oz(4,2),t(4,2),pval(4,2),
     6       'f(p) = 1/p      ',sz(4,3),v(4,3),oz(4,3),t(4,3),pval(4,3)
             write(*,'(/a,10(1x,a)/(10x,10(1x,a)):)') 
     &         'Affecteds:',(id(aff(i))(1:eow(id(aff(i)))),i=1,naff)
             write(*,'(a,10(1x,a)/(10x,10(1x,a)):)') 
     2         'Unaffectd:',(id(aff(i))(1:eow(id(aff(i)))),
     3                       i=MAXSIZ+1-unaff,MAXSIZ)
             write(*,'(/i5,a,i5,a/)') 
     &          naff,' affecteds and ',unaff,' unaffecteds used'
           end if
C else ibd based statistic calculated
        elseif (typ.eq.2) then
           sz(1,1)=0.0d0
           sz(2,1)=0.0d0
           sz(3,1)=0.0d0
           sz(4,1)=0.0d0
           sz(5,1)=0.0d0
           if (alltyp) then
             do 22 i=1,iter
               call simibd(2,pedigree,num,nfound,fa,mo,set,sibd)
               call clcibd(naff,unaff,aff,sibd,z)
               sz(1,1)=sz(1,1)+z(1,1)
               sz(2,1)=sz(2,1)+z(2,1)
               sz(3,1)=sz(3,1)+z(3,1)
               sz(4,1)=sz(4,1)+z(4,1)
               sz(5,1)=sz(5,1)+simil(nfound,naff,aff,sibd,key)
   22        continue
           else
C some untyped markers:
C produce genotype frequencies for Metropolis criterion
C enumerate untyped founder matings
             call genot(numal,alfrq,ngtp,gfrq)
             call tabmat(num,nfound,fa,mo,untyped,nummat,cntmat)
C
C Metropolis simulation of genotypes
C
             if (plevel.gt.2) then
               write(*,'(/2a,4(/a,i4))') 
     2           'Metropolis simulation of pedigree ',pedigree,
     3           'Untyped Individuals: ',nuntyp,
     4           'Possible genotypes : ',ngtp,
     5           'UnT x UnT matings  : ',nummat,
     6           'Burn-in (iters)    : ',burnin
             end if
             do 24 it=1,burnin
               call drop(it,pedigree,num,nfound,id,fa,mo,nummat,
     2                   cntmat,untyped,numal,gfrq,set,set2,sibd,
     3                   key,iprop,0)
   24        continue
             do 25 it=1,iter
               call drop(it,pedigree,num,nfound,id,fa,mo,nummat,
     2                   cntmat,untyped,numal,gfrq,set,set2,sibd,
     3                   key,iprop,plevel)
               call clcibd(naff,unaff,aff,sibd,z)
               sz(1,1)=sz(1,1)+z(1,1)
               sz(2,1)=sz(2,1)+z(2,1)
               sz(3,1)=sz(3,1)+z(3,1)
               sz(4,1)=sz(4,1)+z(4,1)
               sz(5,1)=sz(5,1)+simil(nfound,naff,aff,sibd,key)
   25        continue
           end if
C
C now take mean statistics over different ibd realizations
C
           oz(1,1)=sz(1,1)/den
           oz(2,1)=sz(2,1)/den
           oz(3,1)=sz(3,1)/den
           oz(4,1)=sz(4,1)/den
           oz(5,1)=sz(5,1)/den
C
C generate ibd distribution under null, 
C as of 20030615 conditional on marker informativeness
C
           do 29 j=1,5
             pval(j,1)=0.0d0
             sz(j,1)=0.0d0
             v(j,1)=0.0d0
   29      continue
           do 30 i=1, iter
             call simped(num,nfound,fa,mo,cumfrq,set)
             call simibd(2,pedigree,num,nfound,fa,mo,set,sibd)
             call clcibd(naff,unaff,aff,sibd,z)
             z(5,1)=simil(nfound,naff,aff,sibd,key)
             do 130 j=1,5
             if (pair(j)) then
               if (j.ne.2) then
                 if (z(j,1).gt.oz(j,1) .or. (z(j,1).eq.oz(j,1) .and.
     &               random().gt.0.5)) pval(j,1)=pval(j,1)+1.0d0
               else
                 if (z(j,1).lt.oz(j,1) .or. (z(j,1).eq.oz(j,1) .and.
     &               random().gt.0.5)) pval(j,1)=pval(j,1)+1.0d0
               end if
               call moment(i,z(j,1),sz(j,1),v(j,1))
             end if
  130        continue
   30      continue
           do 36 j=1,5
           if (pair(j)) then
             if (pval(j,1).eq.0.0d0) then
               pval(j,1)=0.5d0/den
             elseif (pval(j,1).eq.den) then
               pval(j,1)=1.0d0-0.5d0/den
             else
               pval(j,1)=pval(j,1)/den
             end if
             zsum(j,1)=zsum(j,1)+ppnd(1.0d0-pval(j,1))
             v(j,1)=v(j,1)/dfloat(max(1,iter-1))
             if (v(j,1).gt.0.0d0) then
               t(j,1)=(oz(j,1)-sz(j,1))/sqrt(v(j,1))
               wt=makewt(j,naff,unaff,v(j,1))
               n(j,1)=n(j,1)+wt*(oz(j,1)-sz(j,1))
               d(j,1)=d(j,1)+wt*wt*v(j,1)
             else
               t(j,1)=0.0d0
             end if
           else
             t(j,1)=0.0d0
           end if
   36      continue
           if (plevel.gt.1) then
             write(*,'(a,a10,a,4(/a,4(1x,f10.3),1x,f6.4))')
     2       'Pedigree ',pedigree,
     3       '  E(Z)     Var(Z)         Z          T      MC-P',
     4       'ibd-based Af-Af ',sz(1,1),v(1,1),oz(1,1),t(1,1),pval(1,1),
     5       'ibd-based Af-Un ',sz(2,1),v(2,1),oz(2,1),t(2,1),pval(2,1),
     6       'ibd-based GPM   ',sz(4,1),v(4,1),oz(4,1),t(4,1),pval(4,1),
     7       'Whit-Halp Score ',sz(5,1),v(5,1),oz(5,1),t(5,1),pval(5,1)
             write(*,'(/a,10(1x,a)/(10x,10(1x,a)):)') 
     &         'Affecteds:',(id(aff(i))(1:eow(id(aff(i)))),i=1,naff)
             write(*,'(a,10(1x,a)/(10x,10(1x,a)):)') 
     2         'Unaffectd:',(id(aff(i))(1:eow(id(aff(i)))),
     3                       i=MAXSIZ+1-unaff,MAXSIZ)
             write(*,'(/i5,a,i5,a/)') 
     &          naff,' affecteds and ',unaff,' unaffecteds used'
           end if
        end if
C end of main loop
      goto 10
   20 continue
      if (plevel.gt.0) then
        write(*,'(/a)')
     &    'Overall statistics        T  NFam  Asy-P InvZ-P' 
      end if
      if (typ.eq.1) then
        do 45 j=1,5
        do 45 k=1,3
          if (nfam(min(j,4)).gt.0) then
            zsum(j,k)=zp(zsum(j,k)/sqrt(dfloat(nfam(min(j,4)))))
          end if
          if (d(j,k).gt.0.0d0) then
            t(j,k)=n(j,k)/sqrt(d(j,k))
          else
            t(j,k)=0.0d0
          end if
   45   continue
        if (plevel.gt.0) then
          write(*,'(a,3(/a,1x,f10.3,1x,i5,2(1x,f6.4)))')
     2      'Aff-Aff',
     3      'f(p) = 1        ',t(1,1),nfam(1),zp(t(1,1)),zsum(1,1),
     4      'f(p) = 1/sqrt(p)',t(1,2),nfam(1),zp(t(1,2)),zsum(1,2),
     5      'f(p) = 1/p      ',t(1,3),nfam(1),zp(t(1,3)),zsum(1,3) 
          write(*,'(a,3(/a,1x,f10.3,1x,i5,2(1x,f6.4)))')
     2      'Aff-UnA',
     3      'f(p) = 1        ',t(2,1),nfam(2),zp(-t(2,1)),zsum(2,1),
     4      'f(p) = 1/sqrt(p)',t(2,2),nfam(2),zp(-t(2,2)),zsum(2,2),
     5      'f(p) = 1/p      ',t(2,3),nfam(2),zp(-t(2,3)),zsum(2,3) 
          write(*,'(a,3(/a,1x,f10.3,1x,i5,2(1x,f6.4)))')
     2      'Aff-Aff v. Aff-UnA',
     3      'f(p) = 1        ',t(5,1),nfam(4),zp(t(5,1)),zsum(5,1),
     4      'f(p) = 1/sqrt(p)',t(5,2),nfam(4),zp(t(5,2)),zsum(5,2),
     5      'f(p) = 1/p      ',t(5,3),nfam(4),zp(t(5,3)),zsum(5,3) 
          write(*,'(a,3(/a,1x,f10.3,1x,i5,2(1x,f6.4)))')
     2      'GPM',
     3      'f(p) = 1        ',t(4,1),nfam(4),zp(t(4,1)),zsum(4,1),
     4      'f(p) = 1/sqrt(p)',t(4,2),nfam(4),zp(t(4,2)),zsum(4,2),
     5      'f(p) = 1/p      ',t(4,3),nfam(4),zp(t(4,3)),zsum(4,3) 
          write(*,'(/a,i5,a,i5,a)') 
     &      'Total of ',nt,' affecteds and ',ut,' unaffecteds used.'
        else
          call phist(zp(t(1,2)), zsum(1,2), histo)
          write(*,'(a10,2(1x,i6),1x,f10.1,2(1x,f6.4),1x,i6,2(1x,a))')
     2      locnam,nfam(1),nt,t(1,2),zp(t(1,2)),zsum(1,2),iter,
     3      'APM-IBS',histo
          call phist(zp(t(4,2)), zsum(4,2), histo)
          write(*,'(a10,2(1x,i6),1x,f10.1,2(1x,f6.4),1x,i6,2(1x,a))')
     2      locnam,nfam(4),nt,t(4,2),zp(t(4,2)),zsum(4,2),iter,
     3      'GPM-IBS',histo
        end if
      elseif (typ.eq.2) then
        if (nfam(1).gt.0) then
          zsum(1,1)=zp(zsum(1,1)/sqrt(dfloat(nfam(1))))
          zsum(5,1)=zp(zsum(5,1)/sqrt(dfloat(nfam(1))))
        end if
        if (nfam(2).gt.0) zsum(2,1)=zp(zsum(2,1)/sqrt(dfloat(nfam(2))))
        if (nfam(4).gt.0) zsum(4,1)=zp(zsum(4,1)/sqrt(dfloat(nfam(4))))
        do 50 j=1,5
        if (d(j,1).gt.0.0d0) then
          t(j,1)=n(j,1)/sqrt(d(j,1))
        else
          t(j,1)=0.0d0
        end if
   50   continue

        if (plevel.gt.0) then
          write(*,'(4(/a,1x,f10.3,1x,i5,2(1x,f6.4)))')
     2      'ibd-based Af-Af ',t(1,1),nfam(1),zp(t(1,1)),zsum(1,1),
     3      'ibd-based Af-Un ',t(2,1),nfam(2),zp(-t(2,1)),zsum(2,1),
     4      'ibd-based GPM   ',t(4,1),nfam(4),zp(t(4,1)),zsum(4,1),
     5      'Whit-Halp Score ',t(5,1),nfam(1),zp(t(5,1)),zsum(5,1) 
          write(*,'(/a,i5,a,i5,a)') 
     &      'Total of ',nt,' affecteds and ',ut,' unaffecteds used.'
        else
          call phist(zp(t(1,1)), zsum(1,1), histo)
          write(*,'(a10,2(1x,i6),1x,f10.1,2(1x,f6.4),1x,i6,2(1x,a))')
     2      locnam,nfam(1),nt,t(1,1),zp(t(1,1)),zsum(1,1),iter,
     3      'APM-IBD',histo
          call phist(zp(t(4,1)), zsum(4,1), histo)
          write(*,'(a10,2(1x,i6),1x,f10.1,2(1x,f6.4),1x,i6,2(1x,a))')
     2      locnam,nfam(4),nt,t(4,1),zp(t(4,1)),zsum(4,1),iter,
     3      'GPM-IBD',histo
        end if
      end if
      return
      end
C end-of-doapm
C
C calculate some plausible weights to allow combination of APM statistics
C from different pedigrees
C type=1 pair=AA, 2 AU, 3 UU, 4 GPM, 5 W-H
C
      double precision function makewt(typ,naff,unaff,var)
      integer typ, naff, unaff
      double precision var
      makewt=0.0d0
      if ((typ.eq.1 .or. typ.eq.5) .and. naff.gt.1) then
        makewt=sqrt(dfloat(naff-1))/sqrt(var)
      elseif (typ.eq.3 .and. unaff.gt.1) then
        makewt=sqrt(dfloat(unaff-1))/sqrt(var)
      elseif (typ.eq.2 .and.(naff+unaff).gt.1) then
        makewt=sqrt(dfloat(naff+unaff-1))/sqrt(var)
      elseif (typ.eq.4 .and.(naff+unaff).gt.1) then
        makewt=dfloat(naff+unaff-1)
        makewt=sqrt(0.5d0*makewt*(makewt-1.0d0))/sqrt(var)
      end if
      return
      end
C end-of-makewt
C
C calculate ibs statistic 
C                      
      subroutine clcibs(naff,unaff,aff,alfrq,set,z)
      integer MAXSIZ, MAXALL
      parameter(MAXSIZ=20, MAXALL=2)
      integer naff,unaff,aff(MAXSIZ),set(MAXSIZ,2)
      double precision alfrq(MAXALL), z(5,3)
      integer i,j,g1,g2,g3,g4,p1,p2
      double precision d1,d2,pr1,pr2
C functions
      double precision delta
      do 5 i=1,5
      do 5 j=1,3
        z(i,j)=0.0d0
    5 continue
C AA statistic
      if (naff.gt.1) then
      do 10 i=1,naff-1
        p1=aff(i)
        g1=set(p1,1)
        g2=set(p1,2)
        pr1=1.0d0/alfrq(g1)
        pr2=1.0d0/alfrq(g2)
        do 10 j=i+1,naff
          p2=aff(j)
C --- the most recent versions of APM exclude parent-offspring pairs
C --- as a method to increase power to detect linkage over association
C           if (fa(p1).ne.p2 .and. mo(p1).ne.p2 .and.
C    &        fa(p2).ne.p1.and.mo(p2).ne.p1) then
C
          g3=set(p2,1)
          g4=set(p2,2)
          d1=delta(g1,g3)+delta(g1,g4)
          d2=delta(g2,g3)+delta(g2,g4)
          z(1,1)=z(1,1)+d1+d2
          z(1,2)=z(1,2)+d1*sqrt(pr1)+d2*sqrt(pr2)
          z(1,3)=z(1,3)+d1*pr1+d2*pr2
   10 continue
      end if
C AU statistic
      if (naff.gt.0 .and. unaff.gt.0) then
      do 20 i=1,naff
        p1=aff(i)
        g1=set(p1,1)
        g2=set(p1,2)
        pr1=1.0d0/alfrq(g1)
        pr2=1.0d0/alfrq(g2)
        do 20 j=MAXSIZ+1-unaff,MAXSIZ
          p2=aff(j)
          g3=set(p2,1)
          g4=set(p2,2)
          d1=delta(g1,g3)+delta(g1,g4)
          d2=delta(g2,g3)+delta(g2,g4)
          z(2,1)=z(2,1)+d1+d2
          z(2,2)=z(2,2)+d1*sqrt(pr1)+d2*sqrt(pr2)
          z(2,3)=z(2,3)+d1*pr1+d2*pr2
   20 continue
      end if
C UU statistic
      if (unaff.gt.1) then
      do 30 i=MAXSIZ+1-unaff,MAXSIZ-1
        p1=aff(i)
        g1=set(p1,1)
        g2=set(p1,2)
        pr1=1.0d0/alfrq(g1)
        pr2=1.0d0/alfrq(g2)
        do 30 j=i+1,MAXSIZ
          p2=aff(j)
          g3=set(p2,1)
          g4=set(p2,2)
          d1=delta(g1,g3)+delta(g1,g4)
          d2=delta(g2,g3)+delta(g2,g4)
          z(3,1)=z(3,1)+d1+d2
          z(3,2)=z(3,2)+d1*sqrt(pr1)+d2*sqrt(pr2)
          z(3,3)=z(3,3)+d1*pr1+d2*pr2
   30 continue
      end if
C Rescale appropriately
      do 40 i=1,3
      do 40 j=1,3
        z(i,j)=0.25d0*z(i,j)
   40 continue
C Combined statistic
      if (naff.gt.1) then
        z(4,1)=z(4,1)+z(1,1)/naff/(naff-1)
        z(4,2)=z(4,2)+z(1,2)/naff/(naff-1)
        z(4,3)=z(4,3)+z(1,3)/naff/(naff-1)
      end if
      if (naff.gt.1 .and. unaff.gt.1) then
        z(5,1)=2.0d0*z(4,1)-z(2,1)/naff/unaff
        z(5,2)=2.0d0*z(4,2)-z(2,2)/naff/unaff
        z(5,3)=2.0d0*z(4,3)-z(2,3)/naff/unaff
        z(4,1)=z(4,1)-z(2,1)/naff/unaff
        z(4,2)=z(4,2)-z(2,2)/naff/unaff
        z(4,3)=z(4,3)-z(2,3)/naff/unaff
      end if
      if (unaff.gt.1) then
        z(4,1)=z(4,1)+z(3,1)/unaff/(unaff-1)
        z(4,2)=z(4,2)+z(3,2)/unaff/(unaff-1)
        z(4,3)=z(4,3)+z(3,3)/unaff/(unaff-1)
      end if
      return
      end
C end-of-clcibs
C
C measure of IBS sharing 
C
      double precision function delta(g1,g2)
      integer g1, g2
      delta=1.0d0
      if (g1.ne.g2) delta=0.0d0
      return
      end
C end-of-delta
C
C calculate ibd sharing statistic based on simulated ibd
C
      subroutine clcibd(naff,unaff,aff,sibd,zibd)
      integer MAXSIZ
      parameter(MAXSIZ=20)
      integer naff,unaff,aff(MAXSIZ),sibd(MAXSIZ,2)
      double precision zibd(5,3)
      integer i,j,g1,g2,g3,g4,p1,p2
      double precision ibd

      zibd(1,1)=0.0d0
      zibd(2,1)=0.0d0
      zibd(3,1)=0.0d0
      zibd(4,1)=0.0d0
      zibd(5,1)=0.0d0
C AA statistic
      if (naff.gt.1) then
      do 10 i=1,naff-1
        p1=aff(i)
        g1=sibd(p1,1)
        g2=sibd(p1,2)
        do 10 j=i+1,naff
          p2=aff(j)
          g3=sibd(p2,1)
          g4=sibd(p2,2)
          call share(g1,g2,g3,g4,ibd)
          zibd(1,1)=zibd(1,1)+ibd
   10 continue
      end if
C AU statistic
      if (naff.gt.0 .and. unaff.gt.0) then
      do 20 i=1,naff
        p1=aff(i)
        g1=sibd(p1,1)
        g2=sibd(p1,2)
        do 20 j=MAXSIZ+1-unaff,MAXSIZ
          p2=aff(j)
          g3=sibd(p2,1)
          g4=sibd(p2,2)
          call share(g1,g2,g3,g4,ibd)
          zibd(2,1)=zibd(2,1)+ibd
   20 continue
      end if
C UU statistic
      if (unaff.gt.1) then
      do 30 i=MAXSIZ+1-unaff,MAXSIZ-1
        p1=aff(i)
        g1=sibd(p1,1)
        g2=sibd(p1,2)
        do 30 j=i+1,MAXSIZ
          p2=aff(j)
          g3=sibd(p2,1)
          g4=sibd(p2,2)
          call share(g1,g2,g3,g4,ibd)
          zibd(3,1)=zibd(3,1)+ibd
   30 continue
      end if
C Combined statistic
      if (naff.gt.1) 
     &  zibd(4,1)=zibd(4,1)+zibd(1,1)/naff/(naff-1)
      if (naff.gt.1 .and. unaff.gt.1) 
     &  zibd(4,1)=zibd(4,1)-zibd(2,1)/naff/unaff
      if (unaff.gt.1) 
     &  zibd(4,1)=zibd(4,1)+zibd(3,1)/unaff/(unaff-1)
      return
      end
C end-of-clcibd
C
C return IBD sharing for relative pair based on ibd-alleles
C
      subroutine share(g1,g2,g3,g4,zibd)
      integer g1,g2,g3,g4
      double precision zibd
      if ((g1.eq.g3 .and. g2.eq.g4).or.(g1.eq.g4 .and. g2.eq.g3)) then
        zibd=1.0d0
      elseif (g1.eq.g3 .or. g1.eq.g4 .or. g2.eq.g3 .or. g2.eq.g4) then
        zibd=0.5d0
      else
        zibd=0.0d0
      end if
      return
      end
C end-of-share
C
C Whittemore's & Halpern's (Biometrics 1994; 50:118-127) measure
C of ibd sharing for multiple relatives
C
C for a set of N individuals, enumerate 2**N vectors containing
C one ibd-allele from each person.  For each such set u_i, calculate
C a measure of overall similarity as the number of [additional] "nontrivial"
C permutations of that set that leave u unchanged.  For example, if
C 3 individuals are {1/2} {1/3} {1/2}, there are 8 u's, which give a total
C abc  Legal permutations (excl obs)   of 10 possible permutations, with
C 111  5    acb, bac, bca, cab, cba    a mean of 10/8.  If a 4th relative
C 112  1    bac                        was ibd-genotype {4/5}, the mean
C 131  1    cba                        would be 10/16.  The mean score (S)
C 132  0                               is used to derive a standardized
C 211  1    acb                        score [S-E(S)]/SD(S), as in the APM
C 212  1    cba                        method, although direct enumeration
C 231  0                               is of course feasible for small N.
C 232  1    cba                        
C
C Randomized version
C
      double precision function simil(nfound,naff,aff,sibd,key)
      integer MAXSIZ
      parameter(MAXSIZ=20)
      integer nfound, naff, aff(MAXSIZ), sibd(MAXSIZ,2)
      integer key(2*MAXSIZ)
      integer i,idx,j,k,tperm
      double precision perm, sum
C functions
      integer irandom
      double precision fact
C
      sum=0.0d0
C
C enumerate all permutations if number of probands (n) < 10
C otherwise sample 1024 random permutations from 2^n
C calls bitwise and, either as and() or iand(), depending on system
C
      if (naff.lt.10) then
        tperm=2**naff
        do 10 i=1,tperm 
          do 15 j=1,2*nfound
            key(j)=0
   15     continue
          k=1
          do 20 j=1,naff
            idx=1

#if defined (F2C) || defined (SUN)
            if (k.eq.and(i,k)) idx=2
#else
            if (k.eq.iand(i,k)) idx=2
#endif /* F2C */

            k=2*k
            key(sibd(aff(j),idx))=key(sibd(aff(j),idx))+1
   20     continue
          perm=0.0d0
          do 25 j=1,2*nfound
          if (key(j).gt.1) then
            if (perm.eq.0.0d0) then
              perm=fact(key(j))
            else
              perm=perm*fact(key(j))
            end if
          end if
   25     continue
          perm=max(perm-1.0d0,0.0d0)
          sum=sum+perm
   10   continue
      else
        tperm=1024
        do 110 i=1,tperm
          do 115 j=1,2*nfound
            key(j)=0
  115     continue
          do 120 j=1,naff
            idx=irandom(1,2)
            key(sibd(aff(j),idx))=key(sibd(aff(j),idx))+1
  120     continue
          perm=0.0d0
          do 125 j=1,2*nfound
          if (key(j).gt.1) then
            if (perm.eq.0.0d0) then
              perm=fact(key(j))
            else
              perm=perm*fact(key(j))
            end if
          end if
  125     continue
          perm=max(perm-1.0d0,0.0d0)
          sum=sum+perm
  110   continue
      end if
      simil=sum/dfloat(tperm)
      return
      end
C end-of-simil
C 
C update new genotype
C
      subroutine update(idx,all1,all2,set)
      integer MAXSIZ
      parameter(MAXSIZ=20)
      integer idx, all1, all2
      integer set(MAXSIZ,2)
      if (all1.gt.all2) then
        set(idx,2)=all1
        set(idx,1)=all2
      else
        set(idx,1)=all1
        set(idx,2)=all2
      end if
      return
      end
C end-of-update
C
C Count alleles in pair of relatives or spouses
C
      subroutine countall(p1,p2,p3,p4,nallele,nmiss)
      integer MISS
      parameter(MISS=-9999)
      integer nallele, nmiss, p1,p2,p3,p4
      nallele=0
      nmiss=0
      if (p1.eq.MISS) then
        nmiss=1
      else
        nallele=1
      end if
      if (p2.eq.MISS) then
        nmiss=nmiss+1
      elseif (p1.ne.p2) then
        nallele=nallele+1
      end if
      if (p3.eq.MISS) then 
        nmiss=nmiss+1
      elseif ((p1.ne.p3).and.(p2.ne.p3)) then
        nallele=nallele+1
      end if
      if (p4.eq.MISS) then
        nmiss=nmiss+1
      elseif ((p1.ne.p4).and.(p2.ne.p4).and.(p3.ne.p4)) then
        nallele=nallele+1
      end if
      return
      end
C end-of-countall
C
C Calculate observed and expected multipoint homozygosity
C Expected distribution simulated using given map
C
      subroutine mulhom(wrk,wrk2,twrk,trait,gt,thresh,xlinkd,
     2             iter,mincnt,nloci,loc,loctyp,locpos,
     3             map,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     4             numloc,hset,numal,cumfrq,plevel)
      integer IBDSIZ,KNOWN,MAXALL,MAXHAP,MAXIBD,MAXSIZ,MAXLOC,MISS
      parameter(KNOWN=0, MAXALL=2, MAXSIZ=20, MAXLOC=10000,
     2          MAXHAP=MAXLOC/2, MISS=-9999,
     3          MAXIBD=20, IBDSIZ=MAXIBD*(MAXIBD+1)/2)
      integer gt,iter,mincnt,plevel,trait,wrk,wrk2,twrk
      double precision thresh
      logical xlinkd
C
C Pedigree structure
      character*10 pedigree
      integer actset,num, nfound
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ), sex(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)
      integer numloc
C
C Locus structure 
      integer nloci
      character*20 loc(MAXLOC)
      integer loctyp(MAXLOC),locpos(MAXLOC)
C
C position of locus on sex-averaged linkage map
C
      real map(MAXLOC)
C
C allele and genotype frequencies within entire sample for given locus 
C
      integer numal
      double precision cumfrq(MAXALL)
C
C Storage space for haplotypes
      integer hset(MAXSIZ,MAXHAP,2)
C
C Marker list and intermarker distances
      integer nmark, mark(MAXHAP), hom(MAXHAP)
      real recdist(MAXHAP)
C 
      integer aff(MAXSIZ)
C
      double precision exprun, obsrun, simrun, varrun
C 
      integer eon, gene, i, it, j, maxrun, naff, ndata, nfam, 
     &        pos, run, tailp
      logical het
      character*3 histo
      character*21 mset

      real dist
      double precision homz, pval
      logical last 
C functions
      integer eow
      real invmap, random
      double precision isaff

      dist=0.0
      nmark=0
      do 1 j=1,nloci
      if (loctyp(j).eq.1) then
        nmark=nmark+1
        mark(nmark)=j
        if (map(j).ne.MISS .and. map(j).ge.dist) then
          recdist(nmark)=invmap(map(j)-dist,1)
          dist=map(j)
        else
          recdist(nmark)=0.50
          dist=0.0
        end if
        if (nmark.eq.MAXHAP) goto 2
      end if
    1 continue
    2 continue
      if (plevel.gt.0) then
        eon=eow(loc(mark(1)))
        write(*,'(/2a,$)') 'Markers: ',loc(mark(1))(1:eon)
        pos=10+eon
        do 3 j=2, nmark
          eon=eow(loc(mark(j)))
          pos=pos+eon+1
          call newlin(9, 78, pos, eon+2)
          write(*,'(2a,$)') ' ', loc(mark(j))(1:eon)
    3   continue
        write(*,'(//a/a)') 
     2    'Pedigree  ID      Run  Homozygosity pattern',
     3    '--------- ------- ---- --------------------'
      end if

      do 5 i=1, MAXSIZ
      do 5 j=1, nmark
        hset(i,j,1)=1
        hset(i,j,2)=1
    5 continue
      obsrun=0.0d0
      exprun=0.0d0
      varrun=0.0d0

      nfam=0
      nobs=0
      ntot=0
      rewind(wrk)
   10 continue
       call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &            numloc, last)
       if (last) goto 20

        if (actset.le.0) goto 10

        ntot=ntot+num

        naff=0
        if (trait.eq.MISS) then
          do 13 i=1,num
            aff(i)=2
            if (xlinkd .and. sex(i).ne.2) aff(i)=MISS
   13     continue
        else
          do 14 i=1,num
            aff(i)=int(isaff(locus(i,trait),thresh,gt))
            if (xlinkd .and. sex(i).ne.2) aff(i)=MISS
   14     continue
        end if
        do 25 i=1,num
          ndata=0
          do 30 j=1,nmark
            gene=locpos(mark(j))
            if (locus(i,gene).gt.KNOWN) then
              ndata=ndata+1
            end if
   30     continue
          if (ndata.eq.nmark .and. aff(i).eq.2) then
            naff=naff+1
            run=0
            maxrun=0
            het=.true.
            do 40 j=1,nmark
              gene=locpos(mark(j))
              if (locus(i,gene).eq.locus(i,gene+1)) then
                hom(j)=1
                run=run+1
                if (run.gt.maxrun) maxrun=run
                if (het) then
                  nrun=nrun+1
                  het=.not.het
                end if
              else
                run=0
                hom(j)=0
                het=.true.  
              end if
   40       continue
            obsrun=obsrun+dfloat(maxrun)
            if ((plevel.eq.1 .and. nobs.le.10) .or. plevel.gt.1) then
              write(*,'(a10,a10,i4,1x,(60i1))') 
     &          pedigree, id(i), maxrun, (hom(j), j=1, nmark)
            end if
          else
            aff(i)=MISS
          end if
   25   continue
        if (naff.gt.0) then
          nfam=nfam+1
          nobs=nobs+naff
          write(twrk) num,nfound, (aff(i),fa(i),mo(i), i=1, num)
        end if
      goto 10
   20 continue
      if (plevel.eq.1 .and. nobs.gt.10) then
        write(*,'(a)') '...'
      end if
      obsrun=obsrun/dfloat(nobs)
      if (plevel.gt.0) then
        write(*,'(/6x,a,i7,a,f5.1,a/6x,a,f12.4,a,i4)')
     2    'No. usable observations =',nobs,
     3    '      (',float(100*nobs)/float(ntot),'%)',
     4    'Mean homozyg run length =', obsrun, ' out of ', nmark
      end if
   
      it=0
      tailp=0
      pval=0.0d0
   99 continue
      if (it.eq.iter .or. tailp.eq.mincnt) goto 100
        it=it+1
        nrun=0
        simrun=0.0d0
        rewind(twrk)
        do 120 j=1, nfam
          read(twrk) num,nfound, (aff(i),fa(i),mo(i), i=1, num)
C         write(*,*) 'Iteration ',it, ' Family', j
          call simhap(wrk2,nmark,mark,recdist,numal,cumfrq,
     &                num,nfound,fa,mo,hset,plevel) 
          call clcrun(num,aff,nmark,hset,nrun,simrun)
  120   continue
        simrun=simrun/dfloat(nobs)
        call moment(it, simrun, exprun, varrun)
        if (simrun.gt.obsrun .or. 
     &      (simrun.eq.obsrun .and.  random().gt.0.5)) then
          tailp=tailp+1
        end if
        if (plevel.gt.1) then
          write(*,'(/a,i4,a,f6.1)') 
     &      'Pseudosample ',it,': mean run length =', simrun
        end if
      goto 99
  100 continue
      varrun=varrun/dfloat(max(1, it-1))
      homz=(obsrun-exprun)/sqrt(varrun)
      pval=dfloat(tailp)/dfloat(max(1,it))
      if (plevel.gt.0) then
        write(*,'(a,f12.4,a,f12.4,a/a,f12.4/6x,a,i4,a,i5,a,f6.4,a)')
     2    '    Mean (Var) simulated runs =',exprun,' (',varrun,')',
     3    '                  Z statistic =',homz, 
     4    'Equalled or exceeded by =',tailp,'/',it,
     5    ' simulated values (',pval,')' 
      else
        call phist(pval,pval,histo)
        mset=loc(mark(1))(1:eow(loc(mark(1)))) // ' - ' //
     &    loc(mark(nmark)) (1:eow(loc(mark(nmark))))
        call juststr('c',mset,21)
        write(*,'(a21,$)') mset
        write(*,'(2i7,2(1x,f7.1),1x,f6.2,1x,f6.4,1x,i6,2(1x,a))')
     2    nobs, nmark, obsrun, exprun, homz, pval, it,'HOM-Run',histo
      end if
      return
      end
C end-of-mulhom 
C
C calculate average maximum run length of homozygosity
C
      subroutine clcrun(num,aff,nmark,hset,nrun,averun)
      integer MAXHAP,MAXLOC,MAXSIZ 
      parameter(MAXSIZ=20, MAXLOC=10000, MAXHAP=MAXLOC/2)
      integer nmark, nrun, num
      integer aff(MAXSIZ), hset(MAXSIZ,MAXHAP,2)
      double precision averun
      integer i, maxrun, run
      logical het

      do 10 i=1,num
      if (aff(i).eq.2) then
        maxrun=0
        run=0
        het=.true.
        do 40 j=1,nmark
          if (hset(i,j,1).eq.hset(i,j,2)) then
            run=run+1
            if (run.gt.maxrun) maxrun=run
            if (het) then
              nrun=nrun+1
              het=.not.het
            end if
          else
            run=0
            het=.true.  
          end if
   40   continue
        averun=averun+dfloat(maxrun)
      end if
   10 continue
      return
      end
C end-of-clcrun
C
C Additive allelic model for association with a quantitative trait
C
      subroutine doanova(wrk,wrk2,trait,locnam,gene,xlinkd,iter,mincnt,
     2              assfnd,x,r,b,cov,pedigree,actset,num,nfound,
     3              id,fa,mo,sex,locus,numloc,numal,name,cumfrq,
     4              untyped,value,counts,set,plevel,typ)
      integer KNOWN,MAXIBD,MAXSIZ,MAXLOC,MAXALL,MAXCOV,MAXTER,MISS
      parameter (KNOWN=0,MAXSIZ=20,MAXLOC=10000,MAXALL=2,MAXIBD=20,
     2           MAXTER=MAXIBD/2,MAXCOV=MAXTER*(MAXTER+1)/2,
     3           MISS=-9999)
      integer gene,iter,mincnt,numal,numloc,plevel,trait,typ,wrk,wrk2
      logical assfnd, xlinkd
      character*10 locnam
C Pedigree structure
      character*10 pedigree
      integer actset,num, nfound
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ), sex(MAXSIZ), set(MAXSIZ,2)
      double precision locus(MAXSIZ,MAXLOC)
      logical last, untyped(MAXSIZ)
C allele frequencies structure
      integer name(MAXALL)
      double precision cumfrq(MAXALL)
C Storage for trait values during randomization
      integer counts(MAXSIZ)
      double precision value(MAXSIZ)
C arrays for allelic effects
      double precision x(MAXTER), r(MAXCOV), b(MAXTER), cov(MAXCOV)
C local variables
      integer g1,g2,gen2,geno,i,idf,ii,it,j,mdf,n,ncats,ncov,nobs,
     &        nter,tailp,nuntyp, tot
      character*3 allel, ana, histo
      character*7 gtp
      double precision asyp, bss, orss, lrts, mss,mu,pval,rss,vss
C functions
      integer clcpos, getnam
      real random
      double precision chip, ln

      last=.false.
      it=0
      nobs=0
      ncats=numal
      ana='HWE'
      if (typ.eq.2) then
        ncats=numal*(numal+1)/2
        ana='Gtp'
      end if
      nter=ncats+1
      ncov=nter*(nter+1)/2
      gen2=gene+1
      call inicov(nter, ncov, r)
      bss=0.0d0
      mu=0.0d0
      nuntyp=0
      do 5 i=1,ncats
        counts(i)=0
    5 continue
      rewind(wrk)
   10 continue
       call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &            numloc, last)
       if (last) goto 20

       if (actset.le.0) goto 10
C
        n=num
        if (assfnd) n=nfound
        if (typ.eq.1) then
          do 12 i=1,n
            value(i)=locus(i,trait)
            untyped(i)=.false.
            if (locus(i,gene).lt.KNOWN) then
              untyped(i)=.true.
              if (locus(i,trait).ne.MISS) nuntyp=nuntyp+1
            elseif (locus(i,trait).ne.MISS) then
              g1=getnam(locus(i,gene),numal,name)
              g2=getnam(locus(i,gen2),numal,name)
              nobs=nobs+1
              do 15 j=1,ncats
                x(j)=0.0d0
   15         continue
              x(nter)=value(i)
              x(g1)=x(g1)+1
              x(g2)=x(g2)+1
              counts(g1)=counts(g1)+1
              counts(g2)=counts(g2)+1
              call moment(nobs,x(nter),mu,bss)
              call givenc(r, ncov, nter, x, 1.0d0, ifail)
            end if
   12     continue
        else if (typ.eq.2) then
          do 17 i=1,n
            value(i)=locus(i,trait)
            untyped(i)=.false.
            if (locus(i,gene).lt.KNOWN) then
              untyped(i)=.true.
              if (locus(i,trait).ne.MISS) nuntyp=nuntyp+1
            elseif (locus(i,trait).ne.MISS) then
              g1=getnam(locus(i,gene),numal,name)
              g2=getnam(locus(i,gen2),numal,name)
              geno=clcpos(g1,g2)
              nobs=nobs+1
              do 19 j=1,ncats
                x(j)=0.0d0
   19         continue
              x(nter)=value(i)
              x(geno)=x(geno)+1
              counts(geno)=counts(geno)+1
              call moment(nobs,x(nter),mu,bss)
              call givenc(r, ncov, nter, x, 1.0d0, ifail)
            end if
   17     continue
        end if
        write(wrk2) n,nfound,
     &              (value(i),fa(i),mo(i),sex(i),untyped(i),i=1,n)
      goto 10
   20 continue
      call alias(r, ncov, nter, 1.0d-15, x, ifail)
      call bsub(r, ncov, nter, b, ncats, ifail)
      call var(r, ncov, cov, ncov, nter, nobs, 1, ifail)

      mdf=0
      mss=0.0d0
      do 150 i=1,ncats 
        call sscomp(r, ncov, nter, nobs, i, rss, idf, ifail)
        mdf=mdf+idf
        mss=mss+rss
  150 continue
      call sscomp(r, ncov, nter, nobs, 0, orss, idf, ifail)

      lrts=dfloat(nobs) * (ln(bss)-ln(orss))
      asyp=chip(lrts,max(1,mdf-1))
      mss=mss/dfloat(max(1,mdf))
      orss=orss/dfloat(max(1,idf))

      if (plevel.gt.0) then
        write(*,'(/a,a10,a)') 
     &    '  ------ QTL Association with "',locnam,'" -----' 
        if (typ.eq.2) then
          write(*,'(a)') 
     &      '  Genotype Gtypic  Mean    Stand Error   Count' 
        else
          write(*,'(a)') 
     &    '    Allele   Allelic Mean    Stand Error   Count' 
        end if
        write(*,'(a)') 
     &    '  ----------------------------------------------'
        ii=0
        tot=nobs
        if (typ.eq.1) then
          tot=nobs+nobs
          do 155 i=1,ncats
            ii=ii+i
            call wrall(name(i), allel)
            write(*,'(5x,a3,5x,f12.4,3x,f12.4,1x,i7)') 
     &         allel,b(i),sqrt(cov(ii)),counts(i)
  155     continue
        else
          i=0
          do 156 g1=1,numal  
          do 156 g2=1,g1
            i=i+1
            ii=ii+i
            call wrgtp(name(g2),name(g1),gtp,1)
            write(*,'(1x,a7,5x,f12.4,3x,f12.4,1x,i7)') 
     &         gtp,b(i),sqrt(cov(ii)),counts(i)
  156     continue
        end if
        write(*,'(a/a,f12.4,3x,f12.4,1x,i7)') 
     2    '  ----------------------------------------------',
     3    '  Total      ',mu, sqrt(bss/dfloat(max(1,nobs-1))), tot
        write(*,'(2(/a,i7),2(/a,f12.4,a,i4,a))') 
     3    ' No. trait(+) marker(-)  =',nuntyp,
     4    ' No. trait(+) marker(+)  =',nobs,
     5    ' Model Mean Square       =', mss,' (df=',mdf,')',
     6    ' Mean Square Error       =',orss,' (df=',idf,')'
        write(*,'(a,f12.4,/a,f12.4)')
     2    ' Likelihood ratio test   =',lrts,
     3    ' Nominal P-value         =',asyp
      end if

      if (iter.gt.0) then
    
C Sequential Monte-Carlo P-value after Besag & Clifford Biometrika 1991
C P= tailp/it if tailp=mincnt or (tailp+1)/(it+1) if tailp<mincnt && it=iter
        mss=0.0d0
        vss=0.0d0
        tailp=0
   49   continue
        if (it.eq.iter .or. tailp.eq. mincnt) goto 50
          it=it+1
          call inicov(nter, ncov, r)
          rewind(wrk2)
   55     continue
            read(wrk2,end=70) n,nfound,
     &        (value(i),fa(i),mo(i),sex(i),untyped(i),i=1,n)
            if (xlinkd) then
              call xsimped(n,nfound,fa,mo,sex,cumfrq,set)
            else
              call simped(n,nfound,fa,mo,cumfrq,set)
            end if
            if (typ.eq.1) then
              do 60 i=1,n
              if (.not.untyped(i).and.value(i).ne.MISS) then
                do 65 j=1,ncats
                  x(j)=0.0d0
   65           continue
                x(nter)=value(i)
                x(set(i,1))=x(set(i,1))+1
                x(set(i,2))=x(set(i,2))+1
                call givenc(r, ncov, nter, x, 1.0d0, ifail)
              end if
   60         continue
            else if (typ.eq.2) then
              do 80 i=1,n
              if (.not.untyped(i).and.value(i).ne.MISS) then
                geno=clcpos(set(i,1),set(i,2))
                do 85 j=1,ncats
                  x(j)=0.0d0
   85           continue
                x(nter)=value(i)
                x(geno)=x(geno)+1
                call givenc(r, ncov, nter, x, 1.0d0, ifail)
              end if
   80         continue
            end if
          goto 55
   70     continue
          call alias(r, ncov, nter, 1.0d-15, x, ifail)
          call sscomp(r, ncov, nter, nobs, 0, rss, idf, ifail)
          rss=rss/dfloat(max(1,idf))
          call moment(it,rss,mss,vss)
          if (rss.lt.orss .or. (rss.eq.orss .and. 
     2        random().gt.0.5d0))  then
            tailp=tailp+1
          end if
          if (plevel.gt.1) then
            write(*,'(/a,i4,a,f12.4)') 
     &       'Pseudosample ',it,': MSE=',rss
          end if
          goto 49
   50   continue
        if (tailp.lt.mincnt) then
          tailp=tailp+1
          it=it+1
        end if
        vss=vss/dfloat(max(1,it-1))
        pval=dfloat(tailp)/dfloat(it)
      else
        tailp=0
        pval=1.0d0
      end if

      if (plevel.gt.0) then
        write(*,'(a,i4,a,i5,a,f6.4,a/a,f12.4,a,f12.4,a)')
     2    ' Equalled or exceeded by =',tailp,'/',it,
     3    ' simulated values (',pval,')',
     4    ' Mean (SD) simulated MSE =',mss,' (',sqrt(vss),')'
      else
        call phist(asyp,pval,histo)
        write(*,'(a10,2(1x,i6),1x,f10.1,2(1x,f6.4),1x,i6,1x,2a,1x,a)')
     &    locnam, nobs, mdf, lrts, asyp, pval, it, 'ANOVA-',ana,histo
      end if
      return
      end
C end-of-doanova
C
C Additive allelic model for association with a quantitative trait
C Conditional on parental genotypes
C
      subroutine qtdt(wrk,wrk2,trait,locnam,gene,xlinkd,iter,mincnt,
     2             x,r,b,cov,pedigree,actset,num,nfound,
     3             id,fa,mo,sex,locus,numloc,
     4             numal,name,untyped,value,count,set,plevel)
      integer KNOWN,MAXIBD,MAXSIZ,MAXLOC,MAXALL,MAXCOV,MAXTER,MISS
      parameter (KNOWN=0,MAXSIZ=20,MAXLOC=10000,MAXALL=2,MAXIBD=20,
     2           MAXTER=MAXIBD/2,MAXCOV=(MAXALL+1)*(MAXALL+2)/2,
     3           MISS=-9999)
      integer gene,iter,mincnt,numal,numloc,plevel,trait,wrk,wrk2
      logical xlinkd
      character*10 locnam
C Pedigree structure
      character*10 pedigree
      integer actset,num, nfound
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ), sex(MAXSIZ), set(MAXSIZ,2)
      double precision locus(MAXSIZ,MAXLOC)
      logical last, untyped(MAXSIZ)
C allele frequencies structure
      integer name(MAXALL)
C Storage for trait values during randomization
      integer count(MAXSIZ)
      double precision value(MAXSIZ)
C arrays for allelic effects
      double precision x(MAXTER), r(MAXCOV), b(MAXTER), cov(MAXCOV)
C local variables
      integer contrib,gen2,i,idf,ii,it,j,mdf,ncov,nobs,nter,tailp,nuntyp
      character*3 allel, histo
      double precision asyp,bss,lrts,mss,mu,pval,orss,rss,vss
C functions
      integer getnam
      real random
      double precision chip, ln

      last=.false.
      nobs=0
      nter=numal+1
      ncov=nter*(nter+1)/2
      gen2=gene+1
      call inicov(nter, ncov, r)
      mu=0.0d0
      bss=0.0d0
      nuntyp=0
      do 5 i=1,numal
        count(i)=0
    5 continue
      rewind(wrk)
   10 continue
       call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &            numloc, last)
       if (last) goto 20

       if (actset.le.0) goto 10
C
C
C load set() with genotypes
        do 11 i=1,num
          untyped(i)=.false.
          value(i)=MISS
          if (locus(i,gene).lt.KNOWN) then
            untyped(i)=.true.
            set(i,1)=MISS
            set(i,2)=MISS
          else
            set(i,1)=getnam(locus(i,gene),numal,name)
            set(i,2)=getnam(locus(i,gen2),numal,name)
          end if
   11   continue
C
C Only phenotyped persons with genotyped parents used-> value() set to trait
        contrib=0
        do 12 i=nfound+1,num
          if (locus(i,trait).ne.MISS .and. .not.untyped(i) .and.
     &        .not.untyped(fa(i)) .and. .not.untyped(mo(i))) then
            contrib=contrib+1
            value(i)=locus(i,trait)
            nobs=nobs+1
            do 15 j=1,numal
              x(j)=0.0d0
   15       continue
            x(nter)=value(i)
            x(set(i,1))=x(set(i,1))+1
            x(set(i,2))=x(set(i,2))+1
            count(set(i,1))=count(set(i,1))+1
            count(set(i,2))=count(set(i,2))+1
            call moment(nobs,x(nter),mu,bss)
            call givenc(r, ncov, nter, x, 1.0d0, ifail)
          end if
   12   continue
        if (contrib.gt.0) then
          write(wrk2) num,nfound,
     2                (value(i),fa(i),mo(i),sex(i),
     3                 untyped(i),set(i,1),set(i,2),i=1,num) 
        end if
      goto 10
   20 continue

      if (nobs.eq.0) then
        if (plevel.gt.0) then
          write(*,'(/a,a10,a/a/a/2(/a,i7))') 
     2    '  ------ QTL Association with "',locnam,'"-------',
     3    '  ------ Conditioned on Parental Genotype -------',
     4    '  -----------------------------------------------',
     5    ' No. trait(+) marker(-)  =',nuntyp,
     6    ' No. trait(+) marker(+)  =',nobs 
        else
          write(*,'(a10,2(1x,i6),1x,f10.1,2(1x,f6.4),1x,i6,1x,a)')
     &    locnam, nobs, 0, 0.0d0, 1.0d0, 1.0d0, 0, 'ANOVA-CPG .'
        end if
        return
      end if
      call alias(r, ncov, nter, 1.0d-15, x, ifail)
      call bsub(r, ncov, nter, b, numal, ifail)
      call var(r, ncov, cov, ncov, nter, nobs, 1, ifail)
      mdf=0
      mss=0.0d0
      do 150 i=1,numal
        call sscomp(r, ncov, nter, nobs, i, rss, idf, ifail)
        mdf=mdf+idf
        mss=mss+rss
  150 continue
      call sscomp(r, ncov, nter, nobs, 0, orss, idf, ifail)
      lrts=dfloat(nobs) * (ln(bss)-ln(orss))
      asyp=chip(lrts,max(1,mdf-1))
      mss=mss/dfloat(max(1,mdf))
      orss=orss/dfloat(max(1,idf))
      if (plevel.gt.0) then
        write(*,'(/a,a10,a/a/a/a)') 
     2  '  ------ QTL Association with "',locnam,'"-------',
     3  '  ------ Conditioned on Parental Genotype -------',
     4  '    Allele   Allelic Mean    Stand Error   Count',
     5  '  -----------------------------------------------'
      ii=0
      do 155 i=1,numal
        ii=ii+i
        call wrall(name(i), allel)
        write(*,'(5x,a3,5x,f12.4,3x,f12.4,1x,i7)') 
     &     allel,b(i),sqrt(cov(ii)),count(i)
  155 continue
        write(*,'(a/a,f12.4,3x,f12.4,1x,i7)') 
     2    '  ----------------------------------------------',
     3    '  Total      ',mu, sqrt(bss/dfloat(max(1,nobs-1))), 2*nobs
        write(*,'(2(/a,i7),2(/a,f12.4,a,i4,a))') 
     3  ' No. trait(+) marker(-)  =',nuntyp,
     4  ' No. trait(+) marker(+)  =',nobs,
     5  ' Model Mean Square       =', mss,' (df=',mdf,')',
     6  ' Mean Square Error       =',orss,' (df=',idf,')'
        write(*,'(a,f12.4,/a,f12.4)')
     2    ' Likelihood ratio test   =',lrts,
     3    ' Nominal P-value         =',asyp
      end if
      if (iter.gt.0) then
    
C Sequential Monte-Carlo P-value after Besag & Clifford Biometrika 1991
C P= tailp/it if tailp=mincnt or (tailp+1)/(it+1) if tailp<mincnt && it=iter
        mss=0.0d0
        vss=0.0d0
        it=0
        tailp=0
   49   continue
        if (it.eq.iter .or. tailp.eq. mincnt) goto 50
          it=it+1
          call inicov(nter, ncov, r)
          rewind(wrk2)
   55     continue
            read(wrk2,end=70) num,nfound,
     2                        (value(i),fa(i),mo(i),sex(i),
     3                         untyped(i),set(i,1),set(i,2),i=1,num) 
            call csimped(num,nfound,fa,mo,sex,untyped,set,xlinkd)
            do 60 i=1,num
            if (value(i).ne.MISS) then
              do 65 j=1,numal
                x(j)=0.0d0
   65         continue
              x(nter)=value(i)
              x(set(i,1))=x(set(i,1))+1
              x(set(i,2))=x(set(i,2))+1
              call givenc(r, ncov, nter, x, 1.0d0, ifail)
            end if
   60       continue
          goto 55
   70     continue
          call alias(r, ncov, nter, 1.0d-15, x, ifail)
          call sscomp(r, ncov, nter, nobs, 0, rss, idf, ifail)
          rss=rss/dfloat(max(1,idf))
          call moment(it,rss,mss,vss)
          if (rss.lt.orss .or. (rss.eq.orss .and. 
     2        random().gt.0.5d0))  then
            tailp=tailp+1
          end if
          if (plevel.gt.1) then
            write(*,'(/a,i4,a,f12.4)') 
     &       'Pseudosample ',it,': MSE=',rss
          end if
          goto 49
   50   continue
        if (tailp.lt.mincnt) then
          tailp=tailp+1
          it=it+1
        end if
        vss=vss/dfloat(max(1,it-1))
        pval=dfloat(tailp)/dfloat(it)
      else
        tailp=0
        pval=1.0d0
      end if

      if (plevel.gt.0) then
        write(*,'(a,i4,a,i5,a,f6.4,a/a,f12.4,a,f12.4,a)')
     2    ' Equalled or exceeded by =',tailp,'/',it,
     3    ' simulated values (',pval,')',
     4    ' Mean (SD) simulated MSE =',mss,' (',sqrt(vss),')'
      else
        call phist(asyp,pval,histo)
        write(*,'(a10,2(1x,i6),1x,f10.1,2(1x,f6.4),1x,i6,2(1x,a))')
     &    locnam, nobs, mdf, lrts, asyp, pval, it, 'ANOVA-CPG',histo
      end if
      return
      end
C end-of-qtdt
C
C Count of marker alleles/genotypes in cases and controls -- codominant system
C
      subroutine doassoc(wrk,wrk2,trait,locnam,gene,iter,mincnt,xlinkd,
     2                   assfnd,gt,thresh,pedigree,actset,num,nfound,id,
     3                   fa,mo,sex,locus,numloc,numal,name,cntall,
     4                   cumfrq,aff,untyped,set,plevel,typ)
      integer KNOWN,MAXSIZ,MAXLOC,MAXALL,MAXG,MISS
      parameter (KNOWN=0,MAXSIZ=20,MAXLOC=10000,MAXALL=2,
     &           MAXG=MAXALL*(MAXALL+1)/2,MISS=-9999)
      integer gene,gt,iter,mincnt,numal,numloc,plevel,trait,typ,wrk,wrk2
      double precision thresh
      logical assfnd, xlinkd
      character*10 locnam
C Pedigree structure
      character*10 pedigree
      integer actset,num, nfound
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ)
      integer sex(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)
      logical last
C work arrays
      integer aff(MAXSIZ), set(MAXSIZ,2)
      logical untyped(MAXSIZ)
C allele frequencies structure
      integer name(MAXALL)
      double precision cumfrq(MAXALL)
C array for allele counts in cases and controls
      integer cntall(MAXG,4)
C F statistics
      integer eh1, eh2, eh12, nhom(2)
      double precision h0, hs, ht, fis, fit, fst, d1, d2
C other local variables
      integer g1,g2,i,it,df,gen2,geno,k,nca,ncats,nco,nuntyp,tailp
      character*3 allel, ana, histo
      character*7 gtp
      real casden, conden
      double precision asyp, chisq, mchisq, ochisq, pexp, pval, vchisq
C functions
      integer clcpos, getnam
      real random
      double precision binz, chip, isaff, twobyk  

      ncats=numal
      ana='HWE'
      if (typ.eq.2) then
        ncats=numal*(numal+1)/2
        ana='Gtp'
      end if
        
      df=-1
      gen2=gene+1
      nhom(1)=0
      nhom(2)=0
      nuntyp=0
      do 2 j=1,ncats  
      do 2 k=1,3
        cntall(j,k)=0
    2 continue
      if (typ.eq.1) then
        if (.not.xlinkd) then
          do 3 j=1, ncats
            cntall(j,4)=name(j)
    3     continue
        else
          k=0
          do 4 i=1, 2
          do 4 j=1, numal
            k=k+1
            cntall(k,4)=name(j)
    4     continue
        end if
      else if (typ.eq.2) then
        do 5 j=1, ncats
          cntall(j,4)=j
    5   continue
      end if
      mchisq=0.0d0
      vchisq=0.0d0
      last=.false.
      rewind(wrk)
   10 continue
       call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &            numloc, last)
       if (last) goto 20

        if (actset.le.0) goto 10
C
        if (assfnd) then
          if (typ.eq.1) then
            do 12 i=1,nfound
              aff(i)=int(isaff(locus(i,trait),thresh,gt))
              if (locus(i,gene).lt.KNOWN) then
                if (aff(i).ne.MISS) nuntyp=nuntyp+1
              elseif (aff(i).eq.1.or.aff(i).eq.2) then
                g1=getnam(locus(i,gene),numal,name)
                g2=getnam(locus(i,gen2),numal,name)
                cntall(g1,aff(i))=cntall(g1,aff(i))+1
                cntall(g2,aff(i))=cntall(g2,aff(i))+1
                if (g1.eq.g2) nhom(aff(i))=nhom(aff(i))+1
              endif
   12       continue
          else if (typ.eq.2) then
            do 13 i=1,nfound
              aff(i)=int(isaff(locus(i,trait),thresh,gt))
              if (locus(i,gene).lt.KNOWN) then
                if (aff(i).ne.MISS) nuntyp=nuntyp+1
              elseif (aff(i).eq.1.or.aff(i).eq.2) then
                g1=getnam(locus(i,gene),numal,name)
                g2=getnam(locus(i,gen2),numal,name)
                geno=clcpos(g1,g2)
                cntall(geno,aff(i))=cntall(geno,aff(i))+1
              endif
   13       continue
          else if (xlinkd) then
            do 14 i=1,nfound
              aff(i)=int(isaff(locus(i,trait),thresh,gt))
              if (locus(i,gene).lt.KNOWN) then
                if (aff(i).ne.MISS) nuntyp=nuntyp+1
              elseif ((aff(i).eq.1.or.aff(i).eq.2) .and. sex(i).ne.MISS)
     &        then
                g1=getnam(locus(i,gene),numal,name)+numal*(sex(i)-1)
                g2=getnam(locus(i,gen2),numal,name)+numal*(sex(i)-1)
                cntall(g1,aff(i))=cntall(g1,aff(i))+1
                cntall(g2,aff(i))=cntall(g2,aff(i))+1
                if (g1.eq.g2) nhom(aff(i))=nhom(aff(i))+1
              endif
   14       continue
          end if
        else
          if (typ.eq.1) then
            do 15 i=1,num
              untyped(i)=.false.
              aff(i)=int(isaff(locus(i,trait),thresh,gt))
              if (locus(i,gene).lt.KNOWN) then
                untyped(i)=.true.
                if (aff(i).ne.MISS) nuntyp=nuntyp+1
              elseif (aff(i).eq.1.or.aff(i).eq.2) then
                g1=getnam(locus(i,gene),numal,name)
                g2=getnam(locus(i,gen2),numal,name)
                cntall(g1,aff(i))=cntall(g1,aff(i))+1
                cntall(g2,aff(i))=cntall(g2,aff(i))+1
                if (g1.eq.g2) nhom(aff(i))=nhom(aff(i))+1
              endif
   15       continue
          else if (typ.eq.2) then
            do 16 i=1,num
              untyped(i)=.false.
              aff(i)=int(isaff(locus(i,trait),thresh,gt))
              if (locus(i,gene).lt.KNOWN) then
                untyped(i)=.true.
                if (aff(i).ne.MISS) nuntyp=nuntyp+1
              elseif (aff(i).eq.1.or.aff(i).eq.2) then
                g1=getnam(locus(i,gene),numal,name)
                g2=getnam(locus(i,gen2),numal,name)
                geno=clcpos(g1,g2)
                cntall(geno,aff(i))=cntall(geno,aff(i))+1
              endif
   16       continue
          else if (xlinkd) then
            do 17 i=1,num
              untyped(i)=.false.
              aff(i)=int(isaff(locus(i,trait),thresh,gt))
              if (locus(i,gene).lt.KNOWN) then
                untyped(i)=.true.
                if (aff(i).ne.MISS) nuntyp=nuntyp+1
              elseif (aff(i).eq.1.or.aff(i).eq.2) then
                g1=getnam(locus(i,gene),numal,name)+numal*(sex(i)-1)
                g2=getnam(locus(i,gen2),numal,name)+numal*(sex(i)-1)
                cntall(g1,aff(i))=cntall(g1,aff(i))+1
                cntall(g2,aff(i))=cntall(g2,aff(i))+1
                if (g1.eq.g2) nhom(aff(i))=nhom(aff(i))+1
              endif
   17       continue
          end if
          write(wrk2) num,nfound,
     &      (aff(i),fa(i),mo(i),sex(i),untyped(i),i=1,num)
        end if
      goto 10
   20 continue
C
      eh1=0
      eh2=0
      eh12=0
      nca=0
      nco=0
      do 25 i=1,ncats 
        nco=nco+cntall(i,1)
        nca=nca+cntall(i,2)
        cntall(i,3)=cntall(i,1)+cntall(i,2)
        if (cntall(i,3).gt.0) df=df+1
   25 continue
C F statistics calculated if allelic test
      if (typ.eq.1 .and. .not.xlinkd) then
        do 26 i=1,ncats 
          eh1=eh1+cntall(i,1)*cntall(i,1)
          eh2=eh2+cntall(i,2)*cntall(i,2)
          eh12=eh12+cntall(i,1)*cntall(i,2)
   26   continue
        d1=max(1.0d0,dfloat(nco))
        d2=max(1.0d0,dfloat(nca))
        h0=1.0d0-dfloat(nhom(1))/d1-dfloat(nhom(2))/d2
        hs=0.5d0*(dfloat(nco*(nco-1)
     2     +2*nhom(1)-eh1)/d1/max(1.0d0,d1-2.0d0)
     3     +dfloat(nca*(nca-1)+2*nhom(2)-eh2)/d2/max(1.0d0,d2-2.0d0))
        ht=1.0d0-dfloat(eh12)/d1/d2
        fis=(hs-h0)/hs
        fit=(ht-h0)/ht
        fst=(ht-hs)/ht
      end if
C Calculate association statistic
      if (nca.gt.0 .and. nco.gt.0) then
        pexp=dfloat(nca)/dfloat(nca+nco)
        ochisq=twobyk(ncats,cntall,pexp)
        asyp=chip(ochisq,df)
      else
        pexp=0.0d0
        ochisq=0.0d0
        asyp=1.0d0
      end if

      if (plevel.gt.0) then
        write(*,'(/a,a10,a)') 
     2    '  ---- Association Analysis for "',locnam,'"-----' 
        if (typ.eq.2) then
          write(*,'(a)') 
     &      '  Genotype   Affected    Unaffected    Total    Dev' 
        else
          write(*,'(a)') 
     &      '    Allele   Affected    Unaffected    Total    Dev' 
        end if
        write(*,'(a)') 
     &    '  ------------------------------------------------'
        casden=max(1.0,float(nca))
        conden=max(1.0,float(nco))
        if (typ.eq.1) then
          do 30 i=1,ncats  
            call wrall(cntall(i,4),allel)
            write(*,'(3x,a3,2x,2(2x,i5,1x,a1,f4.3,a1),i8,1x,f6.1)') 
     2       allel,cntall(i,2),'(',float(cntall(i,2))/casden,')',
     3       cntall(i,1),'(',float(cntall(i,1))/conden,')',cntall(i,3),
     4       binz(cntall(i,2),cntall(i,3),pexp)
   30     continue
        else
          i=1
          do 31 g1=1,numal  
          do 31 g2=1,g1
            call wrgtp(name(g2),name(g1),gtp,1)
            write(*,'(1x,a7,2(2x,i5,1x,a1,f4.3,a1),i8,1x,f6.1)') 
     2       gtp,cntall(i,2),'(',float(cntall(i,2))/casden,')',
     3       cntall(i,1),'(',float(cntall(i,1))/conden,')',cntall(i,3),
     4       binz(cntall(i,2),cntall(i,3),pexp)
            i=i+1
   31     continue
        end if
        write(*,'(a/a8,2(2x,i5,7x),i8)') 
     2    '  -------------------------------------------------',
     3      'Total',nca,nco,nca+nco
        write(*,'(/a,i6/a,i6)') 
     2    '       No. trait(+) marker(-) =',nuntyp,
     3    '       No. trait(+) marker(+) =',(nca+nco)/2
        if (typ.eq.1) then
          write(*,'(a,3(3x,f6.4))') 
     &      '                Fis, Fit, Fst =',fis, fit, fst
        end if
        write(*,'(a,f6.1/a,i4/a,3x,f6.4)')
     2    '   Contingency Pearson chi-sq =',ochisq,
     3    '   Nominal degrees of freedom =',df,
     4    '              Nominal P-value =',asyp
      end if
C
C if founders only, or no cases or no controls or iter=0, then
C Monte-Carlo procedure superfluous
C
      it=0
      tailp=0
      if (assfnd .or. nca.eq.0 .or. nco.eq.0 .or. iter.eq.0) then
        pval=1.0d0
      else
C
C Sequential Monte-Carlo P-value after Besag & Clifford Biometrika 1991
C P= tailp/it if tailp=mincnt or (tailp+1)/(it+1) if tailp<mincnt && it=iter
C
   49   continue
        if (it.eq.iter .or. tailp.eq.mincnt) goto 50
          it=it+1
          do 52 j=1,ncats  
          do 52 k=1,3
            cntall(j,k)=0
   52     continue
          rewind(wrk2)
   55     continue
            read(wrk2,end=70) num,nfound,
     &        (aff(i),fa(i),mo(i),sex(i),untyped(i),i=1,num)
            if (xlinkd) then
              call xsimped(num,nfound,fa,mo,sex,cumfrq,set)
            else
              call simped(num,nfound,fa,mo,cumfrq,set)
            end if
            if (typ.eq.1) then
              do 65 i=1,num
              if (.not.untyped(i).and.(aff(i).eq.1.or.aff(i).eq.2)) then
                cntall(set(i,1),aff(i))=cntall(set(i,1),aff(i))+1
                cntall(set(i,2),aff(i))=cntall(set(i,2),aff(i))+1
              endif
   65         continue
            else if (typ.eq.2) then
              do 66 i=1,num
              if (.not.untyped(i).and.(aff(i).eq.1.or.aff(i).eq.2)) then
                geno=clcpos(set(i,1),set(i,2))
                cntall(geno,aff(i))=cntall(geno,aff(i))+1
              endif
   66         continue
            else if (xlinkd) then
              do 67 i=1,num
              if (.not.untyped(i).and.(aff(i).eq.1.or.aff(i).eq.2)) then
                g1=set(i,1)+numal*(sex(i)-1)
                g2=set(i,2)+numal*(sex(i)-1)
                cntall(g1,aff(i))=cntall(g1,aff(i))+1
                cntall(g2,aff(i))=cntall(g2,aff(i))+1
              endif
   67         continue
            end if
          goto 55
   70     continue

          do 80 i=1,ncats  
            cntall(i,3)=cntall(i,1)+cntall(i,2)
   80     continue
          chisq=twobyk(ncats,cntall,pexp)
          call moment(it,chisq,mchisq,vchisq)
          if (chisq.gt.ochisq .or. (chisq.eq.ochisq .and.
     2        random().gt.0.5))  then
            tailp=tailp+1
          end if
          if (plevel.gt.1) then
            write(*,'(/a,i4,a,f6.1)') 
     &        'Pseudosample ',it,': Chisq=',chisq
            do 85 i=1,ncats
              write(*,'(i8,2(2x,i5,1x,a1,f3.2,a1),i8)') 
     2          cntall(i,4),cntall(i,2),'(',
     3          float(cntall(i,2))/float(nca),')',cntall(i,1),'(',
     4          float(cntall(i,1))/float(nco),')',cntall(i,3)
   85        continue
          end if
          goto 49
   50   continue
        if (tailp.lt.mincnt) then
          tailp=tailp+1
          it=it+1
        end if
        vchisq=vchisq/dfloat(max(1,it-1))
        pval=dfloat(tailp)/dfloat(it)
      end if
      if (plevel.gt.0) then
        write(*,'(a,i4,a,i5,a,f6.4,a/a,f6.1,a,f6.1,a)')
     2    '      Equalled or exceeded by =',tailp,'/',it,
     3    ' simulated values (',pval,')',
     4    ' Mean (Var) simulated chi-sqs =',mchisq,' (',vchisq,')'
      else
        call phist(asyp,pval,histo)
        geno=(nca+nco)/2
        if (typ.eq.2) geno=nca+nco
        write(*,'(a10,2(1x,i6),1x,f10.1,2(1x,f6.4),1x,i6,1x,2a,1x,a)')
     2    locnam, geno, df+1, ochisq, asyp, pval, it, 
     3    'AssX2-',ana,histo
      end if
      return
      end
C end-of-doassoc
C
C Pearson chi-sq for 2xK table (uses only cntall(,1-3))
C
      double precision function twobyk(nallele,cntall,pexp)
      integer MAXALL,MAXG
      parameter(MAXALL=2,MAXG=MAXALL*(MAXALL+1)/2)
      integer nallele, cntall(MAXG,4)
      double precision pexp
      integer i
      double precision num1,num2, den1, den2
      twobyk=0.0d0
      if (pexp.eq.0.0d0 .or. pexp.eq.1.0d0) return
      do 10 i=1,nallele
      if (cntall(i,3).gt.0) then
        den2=pexp*dfloat(cntall(i,3))
        den1=dfloat(cntall(i,3))-den2
        num2=dfloat(cntall(i,2))-den2
        num1=dfloat(cntall(i,1))-den1
        twobyk=twobyk+(num1*num1)/den1+(num2*num2)/den2
      end if
   10 continue
      return
      end
C end-of-twobyk
C
C Binomial regression association analysis 
C
      subroutine binass(wrk,wrk2,twrk,twrk2,trait,gene,baseall,
     2              nvar, terms, loc, loctyp, locpos,
     3              iter,mincnt,addsex,assfnd,gt,thresh,x,r,b,cov,
     4              pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     5              numloc,typed,numal,name,cumfrq,set,counts,plevel)
C
      integer KNOWN, MAXIBD, MAXTER, MAXCOV, MAXALL,
     &        MAXSIZ, MAXLOC, MISS
      double precision DELTA, EPS
      parameter(DELTA=1.0d-5, EPS=1.0d-6,
     2          KNOWN=0, MAXIBD=20, MAXTER=MAXIBD/2, 
     3          MAXCOV=MAXTER*(MAXTER+1)/2, MAXALL=2,
     4          MAXSIZ=20, MAXLOC=10000, MISS=-9999)
C baseall is commonest allele -- used as reference category
C note that gene (but not trait) gives locus number not locus position
      integer baseall, gene, gt, iter, mincnt, numal, plevel, trait, 
     &        twrk, twrk2, wrk, wrk2
      integer terms(MAXLOC)
      logical addsex, assfnd
      double precision thresh
      character*20 loc(MAXLOC)
      integer loctyp(MAXLOC), locpos(MAXLOC)
C  Pedigree structure
      character*10 pedigree
      integer actset,num, nfound
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ), sex(MAXSIZ)
      integer numloc
      double precision locus(MAXSIZ,MAXLOC)
      integer typed(MAXSIZ), set(MAXSIZ,2)
C allele counts
      integer counts(MAXSIZ)
C allele frequencies structure
      integer name(MAXALL)
      double precision cumfrq(MAXALL)
C regression work arrays
      double precision x(MAXTER),r(MAXCOV),b(MAXTER),cov(MAXCOV)
C local variables
      integer g1, g2, gen1, gen2,i,ifail,ii,it,j,mlit,ncov,
     &        nobs,nter,ntot,nuse,tailp,wrknum
      character*12 wrkfil
      logical last
      double precision oddsr, shap, y
C regression results
      integer idf, naff
      double precision asyp,base,chisq,mchisq,ochisq,offval,
     &                 pval,tval,vchisq,weight,x2
      character*3 allel, histo
C functions
      integer getnam
      logical complete
      double precision chip, isaff, zp

      wrknum=1
      wrkfil='sp-ass.wrk'

      gen1=locpos(gene)
      gen2=gen1+1
      it=0
      naff=0
      nobs=0
      ntot=0
      ifail=0
      idf=numal-1
      nter=nvar+numal+1
      if (addsex) nter=nter+1
      nuntyp=0
      ncov=nter*(nter+1)/2
      do 1 i=1,numal
        counts(i)=0
    1 continue
      offval=0.0d0
      shap=1.0d0
      weight=4.0d0

      open(twrk,file=wrkfil,form='unformatted')

      last=.false.
      rewind(wrk)
    5 continue
        call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &             numloc, last)
        if (last) goto 20

        if (actset.le.0) goto 5
C
        n=num
        if (assfnd) n=nfound
        ntot=ntot+n
        nuse=0
        do 12 i=1,n
          if (locus(i,gen1).lt.KNOWN) then
            if (locus(i,trait).ne.MISS) nuntyp=nuntyp+1
          else if (locus(i,trait).ne.MISS .and. 
     &             complete(i, nvar, terms, locpos, loctyp, locus)) then
            nobs=nobs+1
            nuse=nuse+1
            typed(nuse)=i
            y=isaff(locus(i,trait),thresh,gt)-1.0d0
            g1=getnam(locus(i,gen1),numal,name)
            g2=getnam(locus(i,gen2),numal,name)
            counts(g1)=counts(g1)+1
            counts(g2)=counts(g2)+1
            call assdes(addsex,i,g1,g2,numal,baseall,nvar,terms,
     &                  loctyp,locpos,sex,locus,nter,x)
            if (y.eq.1.0d0) naff=naff+1
            x(nter)=0.25d0*(y-0.5d0)-0.6931472d0
            write(twrk) y, weight, offval, (x(j), j=1, nter)
            if (plevel.gt.1) then
              write(*,*) nobs, y, (x(j), j=1, nter-1)
            end if
          end if
   12   continue
        if (nuse.gt.0) then
          write(wrk2) n,nfound,nuse,(fa(i),mo(i),sex(i),i=1,n),
     &                (typed(i),i=1,nuse)
        end if
      goto 5
   20 continue

      if (nobs.gt.0 .and. naff.ne.0 .and. naff.ne.nobs) then
C
        call fitbin(twrk,twrk2,wrknum,wrkfil,1,nobs,nter,ncov,
     &              mlit,x2,r,b,y,x,shap,plevel)

        call var(r, ncov, cov, ncov, nter, nobs, 2, ifail)

        if (plevel.gt.0) then
          write(*,'(/a,a10,a/a/a)') 
     2      '  ------ Analysis for "',loc(gene),'"-------',
     2      '    Allele  Count      OR      t-Value',
     3      '  ---------------------------------------'
          ii=0
          do 250 i=1,numal 
            ii=ii+i
            if (i.ne.baseall) then
              oddsr=exp(b(i))
              tval=abs(b(i))/sqrt(cov(ii))
              call phist(zp(tval),1.0d0,histo)
            else
              oddsr=1.0d0
              tval=0.0d0
              histo=' '
            end if
            call wrall(name(i), allel)
            write(*,'(2x,a3,2x,i8,1x,f12.4,1x,f12.4,1x,a3)') 
     &         allel ,counts(i),oddsr, tval, histo
  250     continue
          do 255 i=1,nvar  
            ii=ii+i+numal
            oddsr=exp(b(numal+i))
            tval=abs(b(numal+i))/sqrt(cov(ii))
            call phist(zp(tval),1.0d0,histo)
            write(*,'(2x,a3,11x,f12.4,1x,f12.4,1x,a3)') 
     &         loc(terms(i)), oddsr, tval, histo
  255     continue
          if (addsex) then
            ii=ii+numal+nvar+1
            oddsr=exp(b(i))
            tval=abs(b(i))/sqrt(cov(ii))
            call phist(zp(tval),1.0d0,histo)
            write(*,'(2x,a3,11x,f12.4,1x,f12.4,1x,a3)') 
     &         'Sex', oddsr, tval, histo
          end if
        end if
C 
C Base model eg intercept only
        if (.not.addsex .and. nvar.eq.0) then
          base=dfloat(naff)/dfloat(nobs)
          base=dfloat(naff)*log(base)+dfloat(nobs-naff)*log(1.0d0-base)
          base=-base-base
        else
          call basmod(twrk,twrk2,wrknum,wrkfil,numal,
     &                nobs,nter,ncov,base,r,b,y,x,shap,plevel) 
        end if
        ochisq=base-x2
        asyp=chip(ochisq,max(1,idf))
        pval=asyp

        if (plevel.gt.0) then
         write(*,'(/6x,a,i7,a,f5.1,a/6x,a,f12.4)')
     2      'No. usable observations =',nobs,
     3      '      ( ',float(100*nobs)/float(ntot),'%)',
     4      '          Null deviance =', base  
         write(*,'(6x,a,i7/6x,a,f12.4,a,i4,a/6x,a,f6.4/6x,a,f12.4)')
     2      '   Number of iterations =', mlit,
     3      '    Model LR Chi-square =', ochisq,' (df=',idf,')',
     4      '        Nominal P-value =',asyp,
     5      '  Akaike Inf. Criterion =', dfloat(2*idf)+x2
        end if

        if (iter.gt.0) then

C Sequential Monte-Carlo P-value after Besag & Clifford Biometrika 1991
C P= tailp/it if tailp=mincnt or (tailp+1)/(it+1) if tailp<mincnt && it=iter
        it=0
        mchisq=0.0d0
        vchisq=0.0d0
        tailp=0
   49   continue
        if (it.eq.iter .or. tailp.eq. mincnt) goto 50
          it=it+1
C rewrite genotype values in regression workfile using those simulated
C under null
          call newnam(wrknum, wrkfil)
          open(twrk2,file=wrkfil,form='unformatted')
          rewind(wrk2)
          rewind(twrk)
   55     continue
            read(wrk2,end=70) n,nfound,nuse,(fa(i),mo(i),sex(i),i=1,n),
     &              (typed(i),i=1,nuse)
            if (addsex) then
              call xsimped(n,nfound,fa,mo,sex,cumfrq,set)
            else
              call simped(n,nfound,fa,mo,cumfrq,set)
            end if
            do 60 i=1,nuse
              idx=typed(i)
              g1=set(idx,1)
              g2=set(idx,2)
              read(twrk) y, weight, offval, (x(j), j=1, nter)
              do 61 j=1,numal 
                x(j)=0.0d0
   61         continue
              x(baseall)=1.0d0
              if (g1.ne.baseall) x(g1)=x(g1)+1
              if (g2.ne.baseall) x(g2)=x(g2)+1
              write(twrk2) y, weight, offval, (x(j), j=1, nter)
   60       continue
          goto 55
   70     continue
          close(twrk,status='delete')
          close(twrk2,status='keep')
          open(twrk,file=wrkfil,form='unformatted')
          call fitbin(twrk,twrk2,wrknum,wrkfil,1,nobs,nter,ncov,
     &                mlit,x2,r,b,y,x,shap,plevel)
C since covariates not resampled, base unchanged!
          chisq=base-x2
          call moment(it,chisq,mchisq,vchisq)
          if (chisq.gt.ochisq .or. (chisq.eq.ochisq .and.
     2        random().gt.0.5))  then
            tailp=tailp+1
          end if
          if (plevel.gt.1) then
            write(*,'(/a,i4,a,f6.1)') 
     &        'Pseudosample ',it,': Chisq=',chisq
          end if
          goto 49
   50   continue
        if (tailp.lt.mincnt) then
          tailp=tailp+1
          it=it+1
        end if
        vchisq=vchisq/dfloat(max(1,it-1))
        pval=dfloat(tailp)/dfloat(it)
      else
        tailp=0
        pval=1.0d0
      end if

      if (plevel.gt.0) then
        write(*,'(6x,a,i4,a,i5,a,f6.4,a/a,f12.4,a,f12.4,a)')
     2    'Equalled or exceeded by =',tailp,'/',it,
     3    ' simulated values (',pval,')',
     4    ' Mean (Var) simulated chi-sqs =',mchisq,' (',vchisq,')'
      else
        call phist(asyp,pval,histo)
          write(*,'(a10,2(1x,i6),1x,f10.1,2(1x,f6.4),1x,i6,1x,a,1x,a)')
     2      loc(gene), nobs, idf+1, ochisq, asyp, pval, it, 
     3      'AssX2-All',histo
        end if
      else if (plevel.gt.0) then
        if (nobs.eq.0) then
          write(*,'(/a)') 'No usable observations.'
        else if (naff.eq.nobs) then
          write(*,'(/a)') 'Only affecteds with genotype information.'
        else if (naff.eq.0) then
          write(*,'(/a)') 'Only unaffecteds with genotype information.'
        end if
      end if
      close(twrk,status='delete')
      return
      end
C end-of-binass
C
C write one row of design matrix for genetic association data
C 1..numal alleles, 1..nvar covariates, sex if X-linked, y-var at end as
C required by givens()
C
      subroutine assdes(addsex,idx,g1,g2,numal,baseall,nvar,terms,
     &                  loctyp,locpos,sex,locus,nter,x)
      integer MAXSIZ, MAXLOC, MISS
      parameter(MAXSIZ=20, MAXLOC=10000, MISS=-9999)
      integer baseall, g1, g2, idx, numal
      logical addsex
      integer nter, nvar, terms(nvar)
      double precision x(nter)
C Locus structure
      integer loctyp(MAXLOC), locpos(MAXLOC)
C Pedigree structure
      integer sex(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)

      integer j, pos

      do 5 j=1,nter  
        x(j)=0.0d0
    5 continue
      if (baseall.eq.MISS) then
        x(g1)=x(g1)+1.0d0
        if (g2.ne.MISS) x(g2)=x(g2)+1.0d0
      else
        x(baseall)=1.0d0
        if (g1.ne.baseall) x(g1)=x(g1)+1.0d0
        if (g2.ne.baseall) x(g2)=x(g2)+1.0d0
      end if
      do 8 j=1, nvar
        pos=terms(j)
        if (loctyp(pos).le.2) then
          x(j+numal)=0.5d0*(locus(idx,locpos(pos))+
     &                      locus(idx,locpos(pos)+1))
        elseif (loctyp(pos).eq.4) then
          x(j+numal)=locus(idx,locpos(pos))-1.0d0
        else
          x(j+numal)=locus(idx,locpos(pos))
        end if
    8 continue
      if (addsex .and. sex(idx).eq.2) x(nter-1)=1.0d0
      return
      end
C end-of-assdes
C
C rewrite fitirls scratch file excluding the marker locus
C
      subroutine basmod(wrk,wrk2,wrknum,oldfil,numal,
     &                  nobs,nter,ncov,lrts,r,b,y,x,shap,plevel) 
      integer MAXIBD, MAXTER, MAXCOV
      parameter(MAXIBD=20,MAXTER=MAXIBD/2,MAXCOV=MAXTER*(MAXTER+1)/2)
      integer ncov, nobs, nter, numal, plevel, wrk, wrk2, wrknum
      character*12 oldfil
      double precision shap
C regression data
      double precision lrts, y, x(MAXTER),r(MAXCOV),b(MAXTER)
C local variables
      integer j, it, newco, newnt
      character*12 newfil
      double precision offval, v

      newfil='sp-basmd.wrk'
      newnt=nter-numal+1
      newco=newnt*(newnt+1)/2
      open(wrk2,file=newfil,form='unformatted')
      rewind(wrk)
      do 10 i=1, nobs
        read(wrk) y,v, offval, (x(j), j=1, nter)
        do 15 j=1, newnt-1
          x(j+1)=x(j+numal)
   15   continue
        x(1)=1.0d0
        write(wrk2) y, v, offval, (x(j), j=1, newnt)
   10 continue
      close(wrk,status='keep')
      close(wrk2,status='keep')
      open(wrk,file=newfil,form='unformatted')
      newco=newnt*(newnt+1)/2
      call fitbin(wrk,wrk2,wrknum,newfil,1,nobs,newnt,newco,
     &            it,lrts,r,b,y,x,shap,plevel)
      close(wrk,status='delete')
      open(wrk,file=oldfil,form='unformatted')
      return
      end
C end-of-basmod
C
C Test the 4 possible unions of gametes 1 2 3 4 -> 13 14 23 24 
C if typ=0 return both parental contributions, else 2=pat, 1=mat
C
      subroutine trans(pg1,pg2,mg1,mg2,cg1,cg2,tr1,tr2,nt1,nt2,typ)
      integer MISS
      parameter(MISS=-9999)
      integer pg1,pg2,mg1,mg2,cg1,cg2,tr1,tr2,nt1,nt2,typ
      real random
      tr1=MISS
      tr2=MISS
      nt1=MISS
      nt2=MISS
      if ((pg1.eq.MISS).and.(mg1.ne.MISS)) then
        if (mg1.eq.cg1 .and. mg2.eq.cg2) then
          if (mg1.eq.mg2) then
            tr1=mg1
            nt1=mg2
          end if
        else if ((mg1.eq.cg1).or.(mg1.eq.cg2)) then
          tr1=mg1
          nt1=mg2
        elseif((mg2.eq.cg1).or.(mg2.eq.cg2)) then 
          tr1=mg2
          nt1=mg1
        end if
      elseif((pg1.ne.MISS).and.(mg1.eq.MISS)) then
        if ((pg1.eq.cg1).and.(pg2.eq.cg2)) then
          if (pg1.eq.pg2) then
            tr2=pg1
            nt2=pg2
          end if
        else if ((pg1.eq.cg1).or.(pg1.eq.cg2)) then
          tr2=pg1
          nt2=pg2
        elseif((pg2.eq.cg1).or.(pg2.eq.cg2)) then
          tr2=pg2
          nt2=pg1
        end if
      elseif(pg1.eq.mg1 .and. pg2.eq.mg2 .and. 
     &       pg1.eq.cg1 .and. pg2.eq.cg2) then
        if (pg1.eq.pg2) then
          tr1=mg1
          nt1=mg2
          tr2=pg2
          nt2=pg1
        else if (typ.eq.0) then
          if (random().gt.0.5) then
            tr1=mg1
            nt1=mg2
            tr2=pg2
            nt2=pg1
          else
            tr1=mg2
            nt1=mg1
            tr2=pg1
            nt2=pg2
          end if
        end if
      elseif(((pg1.eq.cg1).and.(mg1.eq.cg2))
     2        .or.((pg1.eq.cg2).and.(mg1.eq.cg1))) then
        tr1=mg1
        nt1=mg2
        tr2=pg1
        nt2=pg2
      elseif(((pg1.eq.cg1).and.(mg2.eq.cg2))
     2        .or.((pg1.eq.cg2).and.(mg2.eq.cg1))) then
        tr2=pg1
        nt2=pg2
        tr1=mg2
        nt1=mg1
      elseif(((pg2.eq.cg1).and.(mg1.eq.cg2))
     2        .or.((pg2.eq.cg2).and.(mg1.eq.cg1))) then
       tr2=pg2
       nt2=pg1
       tr1=mg1
       nt1=mg2
      elseif(((pg2.eq.cg1).and.(mg2.eq.cg2))
     2        .or.((pg2.eq.cg2).and.(mg2.eq.cg1))) then
       tr2=pg2
       nt2=pg1
       tr1=mg2
       nt1=mg1
      end if
C check to see which parental contribution to retain
      if (typ.eq.1) then
        tr2=MISS
        nt2=MISS
      elseif (typ.eq.2) then
        tr1=MISS
        nt1=MISS
      end if
      return
      end
C end-of-trans
C
C Transmission of X-linked marker to a male
      subroutine xtrans(mg1,mg2,cg1,cg2,tr1,tr2, nt1, nt2)
      integer MISS
      parameter(MISS=-9999)
      integer mg1,mg2,cg1,cg2,tr1,tr2,nt1,nt2
      tr1=MISS
      nt1=MISS
      tr2=MISS
      nt2=MISS
      if (mg1.ne.MISS) then 
        if ((mg1.eq.cg1).or.(mg1.eq.cg2)) then
          tr1=mg1
          nt1=mg2
        else if ((mg2.eq.cg1).or.(mg2.eq.cg2)) then 
          tr1=mg2
          nt1=mg1
        end if
      end if
      return
      end
C end-of-xtrans
C
C Increment counts of transmitted and nontransmitted alleles: parentwise
C
      subroutine incpo(tr,nt,nall,cntall)
      integer MAXALL,MAXG,MISS
      parameter(MAXALL=2,MAXG=MAXALL*(MAXALL+1)/2,MISS=-9999)
      integer tr,nt,nall,cntall(MAXG,4)
      integer i,j,a1,a2
      logical trans
      if (tr.eq.MISS.or.nt.eq.MISS.or.tr.eq.nt) return
      if (tr.le.nt) then
        trans=.true.
        a1=tr
        a2=nt
      else
        trans=.false.
        a1=nt
        a2=tr
      end if
      i=0
    5 continue
        i=i+1
      if (i.le.nall .and. (a1.gt.cntall(i,1).or.
     &    (a1.eq.cntall(i,1).and.a2.gt.cntall(i,2)))) goto 5
      if (i.le.nall .and. cntall(i,1).eq.a1.and.cntall(i,2).eq.a2) then
        if (trans) then
          cntall(i,3)=cntall(i,3)+1
        else
          cntall(i,4)=cntall(i,4)+1
        end if
      else
        do 20 j=nall,i,-1
        do 20 k=1,4
   20     cntall(j+1,k)=cntall(j,k)
        cntall(i,1)=a1
        cntall(i,2)=a2
        if(trans) then
          cntall(i,3)=1
          cntall(i,4)=0
        else
          cntall(i,3)=0
          cntall(i,4)=1
        end if
        nall=nall+1
      end if
      return
      end
C end-of-incpo
C
C Increment counts of transmitted and expected genotypes
C Revised after reading Thomas 1999
C
      subroutine incr(tr1,tr2,nt1,nt2,ngcount,gcount)
      integer MAXALL,MAXG,MISS
      parameter(MAXALL=2,MAXG=MAXALL*(MAXALL+1)/2,MISS=-9999)
      integer tr1,tr2,nt1,nt2,ngcount,gcount(MAXG,4)
C only use cases both parents typed
      if (nt1.eq.MISS .or. nt2.eq.MISS) return
C case
      call insgen(tr1,tr2,ngcount,gcount,3,1)
C 4 pseudo-sibs for control distribution
      call insgen(tr1,tr2,ngcount,gcount,4,1)
      call insgen(tr1,nt2,ngcount,gcount,4,1)
      call insgen(nt1,tr2,ngcount,gcount,4,1)
      call insgen(nt1,nt2,ngcount,gcount,4,1)
      return
      end
C end-of-incr
C
C update counts of genotypes or haplotypes for cases or controls -- 
C binary search and insertion sort
C
      subroutine insgen(a1,a2,ngcount,gcount,typ,haplo)
      integer MAXALL, MAXG 
      parameter(MAXALL=2,MAXG=MAXALL*(MAXALL+1)/2)
      integer a1,a2,haplo,ngcount,gcount(MAXG,4),typ
      integer g1,g2,hi,j,k,lo,pos
C if genotype, order by allele size rather than parent of origin
      if (haplo.eq.2 .or. a1.le.a2) then
        g1=a1
        g2=a2
      else
        g1=a2
        g2=a1
      end if
      pos=1
      hi=ngcount
      lo=1
    1 continue 
      if (hi.lt.lo) goto 5
        pos=(hi+lo)/2
        if (g1.gt.gcount(pos,1) .or.
     &      (g1.eq.gcount(pos,1) .and. g2.gt.gcount(pos,2))) then
          lo=pos+1
        elseif (g1.lt.gcount(pos,1).or.
     &      (g1.eq.gcount(pos,1) .and. g2.lt.gcount(pos,2))) then
          hi=pos-1
        else
          gcount(pos,typ)=gcount(pos,typ)+1
          return
        end if
      goto 1
    5 continue
C else create new category
      do 50 j=ngcount,pos,-1
      do 50 k=1,4
        gcount(j+1,k)=gcount(j,k)
   50 continue
      gcount(lo,1)=g1
      gcount(lo,2)=g2
      gcount(lo,3)=0
      gcount(lo,4)=0        
      gcount(lo,typ)=1
      ngcount=ngcount+1
      return
      end
C end-of-insgen
C
C Haplotype Relative Risk 
C
      subroutine dohrr(wrk,wrk2,trait,locnam,gene,iter,mincnt,xlinkd,
     2                 gt,thresh,pedigree,actset,num,nfound,
     3                 id,fa,mo,sex,locus,numloc,numal,name,cntall,
     4                 cumfrq,aff,untyped,set,plevel)
      integer MAXALL, MAXG, MAXSIZ, MAXLOC, MISS, KNOWN
      parameter(MAXALL=2, MAXG=MAXALL*(MAXALL+1)/2, 
     &          MAXSIZ=20, MAXLOC=10000, MISS=-9999, KNOWN=0)
      integer gene, gt, plevel,trait,wrk,wrk2
      double precision thresh
      logical xlinkd
      character*10 locnam
C pedigree structure
      character*10 pedigree
      integer sex(MAXSIZ)
      integer actset,num, nfound
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)
C allele frequencies structure
      integer numal, name(MAXALL)
      double precision cumfrq(MAXALL)
C array for allele counts in cases and pseudo-controls
      integer cntall(MAXG,4)
C arrays for simulation
      integer aff(MAXSIZ), set(MAXSIZ, 2)
      logical untyped(MAXSIZ)
C
      integer cg1,cg2,pg1,pg2,mg1,mg2,tr1,tr2,nt1,nt2
      logical last
      integer df,gen2,i,idx,j,k,nca,nco,nuntyp,tailp
      integer naff
      logical xmale
      character*1 sx
      character*3 allel, histo
      character*7 gtp, gtp2
      double precision asyp, chisq, mchisq, ochisq, pexp, pval, vchisq
C functions 
      integer getnam
      double precision  binz, chip, isaff, twobyk 
C
      df=-1
      gen2=gene+1
      nuntyp=0
      do 2 j=1,numal  
        cntall(j,4)=name(j)
        do 2 k=1,3
          cntall(j,k)=0
    2   continue
    3 continue
      mchisq=0.0d0
      vchisq=0.0d0
      last=.false.
      rewind(wrk)
C
C If high print level, then list transmitted and nontransmitted alleles
C for each informative proband
C
      if (plevel.gt.1) then
        write(*,'(a/a)') 'Informative Child      Trans    Not Tr ',
     &                   'Pedigree  ID      Sex  Mat Pat  Mat Pat'
      end if
C
   10 continue
       call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &            numloc, last)
       if (last) goto 20

       if (actset.le.0) goto 10
C
         naff=0
         do 11 i=1, num   
           untyped(i)=.false.
   11    continue
         do 12 i=nfound+1,num
           xmale=(xlinkd .and. sex(i).eq.1)
           if (locus(i,gene).lt.KNOWN) then
             nuntyp=nuntyp+1
             untyped(i)=.true.
           else if (isaff(locus(i,trait),thresh,gt).eq.2.0) then
             naff=naff+1
             aff(naff)=i
             pg1=MISS
             pg2=MISS
             if (locus(fa(i),gene).gt.KNOWN) then
               pg1=getnam(locus(fa(i),gene),numal,name)
               pg2=getnam(locus(fa(i),gen2),numal,name)
             end if
             mg1=MISS
             mg2=MISS
             if (locus(mo(i),gene).gt.KNOWN) then
               mg1=getnam(locus(mo(i),gene),numal,name)
               mg2=getnam(locus(mo(i),gen2),numal,name)
             end if
             cg1=getnam(locus(i,gene),numal,name)
             cg2=getnam(locus(i,gen2),numal,name)
             if (xmale) then
               call xtrans(mg1,mg2, cg1, cg2, tr1,tr2,nt1,nt2)
             else
               call trans(pg1,pg2,mg1,mg2,cg1,cg2,tr1,tr2,nt1,nt2,0)
             end if
C *all* transmitted alleles
             cntall(cg1,2)=cntall(cg1,2)+1
             if (.not.xmale) cntall(cg2,2)=cntall(cg2,2)+1
C nontransmitted alleles
             if (nt1.ne.MISS) cntall(nt1,1)=cntall(nt1,1)+1
             if (nt2.ne.MISS .and. .not.xlinkd) then
               cntall(nt2,1)=cntall(nt2,1)+1
             end if
C print out transmitted and nontransmitted genotypes
             if (plevel.gt.1) then
               tr1=name(cg1)
               if (.not.xmale) tr2=name(cg2)
               if (nt1.ne.MISS) nt1=name(nt1)
               if (nt2.ne.MISS .and. .not.xlinkd) then
                 nt2=name(nt2)
               else 
                 nt2=MISS
               end if
               call wrgtp(tr1,tr2,gtp,2)
               call wrgtp(nt1,nt2,gtp2,2)
               sx='m'
               if (sex(i).eq.2) then
                 sx='f'
               else if (sex(i).eq.MISS) then
                 sx=' '
               end if
               write(*,'(a10,a10,2x,a1,1x,2(1x,a8))') 
     &           pedigree,id(i),sx,gtp,gtp2
             end if
           end if
   12    continue
         write(wrk2) num,nfound,
     2     (fa(i),mo(i),sex(i),untyped(i),i=1,num),
     3     naff, (aff(i),i=1, naff)
       goto 10
   20  continue

      nca=0
      nco=0
      do 25 i=1,numal 
        nco=nco+cntall(i,1)
        nca=nca+cntall(i,2)
        cntall(i,3)=cntall(i,1)+cntall(i,2)
        if (cntall(i,3).gt.0) df=df+1
   25 continue
C Calculate association statistic
      if (df.lt.0) df=0
      pexp=0.0d0
      ochisq=0.0d0
      asyp=1.0d0
      if (nca.gt.0 .and. nco.gt.0) then
        pexp=dfloat(nca)/dfloat(nca+nco)
        ochisq=twobyk(numal,cntall,pexp)
        if (df.gt.0) asyp=chip(ochisq,max(1,df))
      end if

      if (plevel.gt.0) then
        write(*,'(/a,a15,a/a/a)') 
     2    '  ---- HRR Analysis for "',locnam,'" ---------' ,
     3    '    Allele   Affected    Control       Total    Dev',
     4    '  ------------------------------------------------'
        casden=max(1.0,float(nca))
        conden=max(1.0,float(nco))
        do 30 i=1,numal  
          call wrall(cntall(i,4),allel)
          write(*,'(3x,a3,2x,2(2x,i5,1x,a1,f4.3,a1),i8,1x,f6.1)') 
     2     allel,cntall(i,2),'(',float(cntall(i,2))/casden,')',
     3     cntall(i,1),'(',float(cntall(i,1))/conden,')',cntall(i,3),
     4     binz(cntall(i,2),cntall(i,3),pexp)
   30   continue
        write(*,'(a/a8,2(2x,i5,7x),i8)') 
     2    '  -------------------------------------------------',
     3      'Total',nca,nco,nca+nco
        write(*,'(/a,i6/a,i6)') 
     2    '       No. trait(+) marker(-) =',nuntyp,
     3    '       No. trait(+) marker(+) =',nca/2 
        write(*,'(a,f6.1/a,i4/a,3x,f6.4)')
     2    '   Contingency Pearson chi-sq =',ochisq,
     3    '   Nominal degrees of freedom =',df,
     4    '              Nominal P-value =',asyp
      end if
C
C if nca=0 or nco=0 or iter=0 or df=0, then Monte-Carlo procedure superfluous
C
      it=0
      tailp=0
      if (nca.eq.0 .or. nco.eq.0 .or. df.eq.0 .or. iter.eq.0) then
        pval=1.0d0
      else
C
C Sequential Monte-Carlo P-value after Besag & Clifford Biometrika 1991
C P= tailp/it if tailp=mincnt or (tailp+1)/(it+1) if tailp<mincnt && it=iter
C
   49   continue
        if (it.eq.iter .or. tailp.eq.mincnt) goto 50
          it=it+1
          do 52 j=1,numal  
          do 52 k=1,3
            cntall(j,k)=0
   52     continue
          rewind(wrk2)
   55     continue
            read(wrk2,end=70) num,nfound,
     2        (fa(i),mo(i),sex(i),untyped(i),i=1,num), 
     3        naff, (aff(i),i=1, naff)
            if (xlinkd) then
              call xsimped(num,nfound,fa,mo,sex,cumfrq,set)
              do 57 i=1, naff
                idx=aff(i)
                pg1=MISS
                pg2=MISS
                mg1=MISS
                mg2=MISS
                if (.not.untyped(fa(idx))) then
                  pg1=set(fa(idx),1)
                  pg2=set(fa(idx),2)
                end if
                if (.not.untyped(mo(idx))) then
                  mg1=set(mo(idx),1)
                  mg2=set(mo(idx),2)
                end if
                cg1=set(idx,1)
                cg2=set(idx,2)
                if (sex(idx).eq.1) then
                  call xtrans(mg1,mg2,cg1,cg2,tr1,tr2,nt1,nt2)
                else
                  call trans(pg1, pg2, mg1, mg2, 
     3                       cg1,cg2,tr1,tr2,nt1,nt2,1)
                end if
                cntall(cg1,2)=cntall(cg1,2)+1
                if (sex(idx).ne.1) cntall(cg2,2)=cntall(cg2,2)+1
                if (nt1.ne.MISS) cntall(nt1,1)=cntall(nt1,1)+1
                if (nt2.ne.MISS) cntall(nt2,1)=cntall(nt2,1)+1
   57         continue
            else
              call simped(num,nfound,fa,mo,cumfrq,set)
              do 58 i=1, naff
                idx=aff(i)
                pg1=MISS
                pg2=MISS
                mg1=MISS
                mg2=MISS
                if (.not.untyped(fa(idx))) then
                  pg1=set(fa(idx),1)
                  pg2=set(fa(idx),2)
                end if
                if (.not.untyped(mo(idx))) then
                  mg1=set(mo(idx),1)
                  mg2=set(mo(idx),2)
                end if
                cg1=set(idx,1)
                cg2=set(idx,2)
                call trans(pg1,pg2,mg1,mg2,cg1,cg2,tr1,tr2,nt1,nt2,1)
                cntall(cg1,2)=cntall(cg1,2)+1
                cntall(cg2,2)=cntall(cg2,2)+1
                if (nt1.ne.MISS) cntall(nt1,1)=cntall(nt1,1)+1
                if (nt2.ne.MISS) cntall(nt2,1)=cntall(nt2,1)+1
   58         continue
            end if
          goto 55
   70     continue

          nco=0
          do 80 i=1,numal  
            nco=nco+cntall(i,1)
            cntall(i,3)=cntall(i,1)+cntall(i,2)
   80     continue
          pexp=dfloat(nca)/dfloat(nca+nco)
          chisq=twobyk(numal,cntall,pexp)
          call moment(it,chisq,mchisq,vchisq)
          if (chisq.gt.ochisq .or. (chisq.eq.ochisq .and.
     2        random().gt.0.5))  then
            tailp=tailp+1
          end if
          if (plevel.gt.1) then
            write(*,'(/a,i4,a,f6.1)') 
     &        'Pseudosample ',it,': Chisq=',chisq
            do 85 i=1,numal
              write(*,'(i8,2(2x,i5,1x,a1,f3.2,a1),i8)') 
     2          cntall(i,4),cntall(i,2),'(',
     3          float(cntall(i,2))/float(nca),')',cntall(i,1),'(',
     4          float(cntall(i,1))/float(nco),')',cntall(i,3)
   85        continue
          end if
          goto 49
   50   continue
        if (tailp.lt.mincnt) then
          tailp=tailp+1
          it=it+1
        end if
        vchisq=vchisq/dfloat(max(1,it-1))
        pval=dfloat(tailp)/dfloat(it)
      end if
      if (plevel.gt.0) then
        write(*,'(a,i4,a,i5,a,f6.4,a/a,f6.1,a,f6.1,a)')
     2    '      Equalled or exceeded by =',tailp,'/',it,
     3    ' simulated values (',pval,')',
     4    ' Mean (Var) simulated chi-sqs =',mchisq,' (',vchisq,')'
      else
        call phist(asyp,pval,histo)
        write(*,'(a10,2(1x,i6),1x,f10.1,2(1x,f6.4),1x,i6,2(1x,a))')
     2      locnam, nca/2, df, ochisq, asyp, pval, it,
     3      'HRR      ',histo
      end if
      return
      end
C end-of-dohrr
C
C Monte-Carlo approach to various TDTs
C
      subroutine dotdt(wrk,wrk2,trait,locnam,gene,xlinkd,iter,mincnt,
     2             use2,typ,cutoff,gt,thresh,pedigree,actset,num,nfound,
     3             id,fa,mo,sex,locus,numloc,numal,name,untyped,set,
     4             nallele,cntall,ngcount,gcount,plevel)
      integer MAXALL, MAXG, MAXSIZ, MAXLOC, MISS, KNOWN
      parameter(MAXALL=2, MAXG=MAXALL*(MAXALL+1)/2, 
     &          MAXSIZ=20, MAXLOC=10000, MISS=-9999, KNOWN=0)
      integer cutoff,gene,gt, iter,mincnt,plevel,trait,typ,use2,wrk,wrk2
      double precision thresh
      logical xlinkd
      character*10 locnam
C pedigree structure
      character*10 pedigree
      integer sex(MAXSIZ)
      integer actset,num, nfound
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ), set(MAXSIZ,2)
      double precision locus(MAXSIZ,MAXLOC)
C allele frequencies structure
      integer numal, name(MAXALL)
C Genotype counts: allele1,allele2, number transmitted, number not trans
      integer nallele,cntall(MAXG,4), ngcount,gcount(MAXG,4)
C
      integer cg1,cg2,pg1,pg2,mg1,mg2,tr1,tr2,nt1,nt2
      logical last, untyped(MAXSIZ)
      integer alltr,allnt,df,gdf,gen2,i,it,j,k,mxiter,ntest,tailp,tot
      integer aff(MAXSIZ),naff,prob,probandi
      logical xmale
      character*3 allel, allel2, histo
      double precision celltdt, tdt, otdt, gtdt, mgtdt, mcnem, pval
      double precision asyp, bestm, bestp, ewens, ftdev
      character*7 gtp, gtp2
C functions 
      logical tdtuse
      real random
      double precision binp, bonf, chip, clcchi, clcmcn, isaff, ln
C
      df=0
      ewens=0.0d0
      gdf=0
      gen2=gene+1
      nallele=0
      ngcount=0
      ntest=0
      mgtdt=0.0d0
      probandi=0
      tot=0
      tdt=0.0d0
      do 2 i=1,MAXG
      do 2 j=1,4
        gcount(i,j)=0
        cntall(i,j)=0
    2 continue
      last=.false.
      rewind(wrk)
C
C If high print level, then list transmitted and nontransmitted alleles
C for each informative proband
C
      if (plevel.gt.1) then
        write(*,'(a/a)') 'Informative Child   Trans    Not Tr ',
     &                   'Pedigree  ID        Mat Pat  Mat Pat'
      end if
C
   10 continue
       call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &            numloc, last)
       if (last) goto 20

       if (actset.le.0) goto 10
C
         naff=0
         do 11 i=1,nfound
           untyped(i)=.false.
           if (locus(i,gene).lt.KNOWN) untyped(i)=.true.
   11    continue
         do 12 i=nfound+1,num
           xmale=(xlinkd .and. sex(i).eq.1)
           untyped(i)=.false.
           if (locus(i,gene).lt.KNOWN) then
             untyped(i)=.true.
           else if (isaff(locus(i,trait),thresh,gt).eq.2.0 .and. 
     &              tdtuse(i,gene,naff,fa,mo,locus,use2,xmale)) then
C
C nonfounder affected & typed & 1 or 2 parents heterozygous at marker
C 
             naff=naff+1
             aff(naff)=i
             pg1=MISS
             pg2=MISS
             if (locus(fa(i),gene).gt.KNOWN) then
               pg1=int(locus(fa(i),gene))
               pg2=int(locus(fa(i),gen2))
             end if
             mg1=MISS
             mg2=MISS
             if (locus(mo(i),gene).gt.KNOWN) then
               mg1=int(locus(mo(i),gene))
               mg2=int(locus(mo(i),gen2))
             end if
             cg1=int(locus(i,gene))
             cg2=int(locus(i,gen2))
             if (xmale) then
               call xtrans(mg1,mg2, cg1, cg2, tr1,tr2,nt1,nt2)
             else
               call trans(pg1,pg2,mg1,mg2,cg1,cg2,tr1,tr2,nt1,nt2,typ)
             end if
             if (plevel.gt.1) then
               call wrgtp(tr1,tr2,gtp,2)
               call wrgtp(nt1,nt2,gtp2,2)
               write(*,'(a10,a10,2(1x,a8))') pedigree,id(i),gtp,gtp2
             end if
             call incpo(tr1,nt1,nallele,cntall)
             call incpo(tr2,nt2,nallele,cntall)
             call incr(tr1,tr2,nt1,nt2,ngcount,gcount)
           end if
   12    continue
         probandi=probandi+naff
         if (naff.gt.0) then
           do 14 i=1,num   
             set(i,1)=MISS
             set(i,2)=MISS
             if (locus(i,gene).gt.KNOWN) then
               set(i,1)=int(abs(locus(i,gene)))
               set(i,2)=int(abs(locus(i,gen2)))
             end if
   14      continue
           write(wrk2) naff,(aff(i),i=1,naff),num,nfound,
     &       (fa(i),mo(i),sex(i),untyped(i),set(i,1),set(i,2),i=1,num) 
         end if
       goto 10
   20  continue
C
      if (plevel.gt.1) then
        write(*,*)
      end if
      if (plevel.gt.0) then
        write(*,'(/a,i3)') 'Number of informative probands: ',probandi
C
        write(*,'(/a,a10,a/a/a)') 
     2   '  - Allele by Allele TDT:"',locnam,'" -',
     3   '  Allele   Trans  Not Tr   TDT   P-value',
     4   '  --------------------------------------'
      end if
      bestm=0.0d0
      bestp=1.0d0
      do 215 i=1,numal
        alltr=0
        allnt=0
        do 220 j=1,nallele
          if (cntall(j,1).eq.name(i)) then
            alltr=alltr+cntall(j,3)
            allnt=allnt+cntall(j,4)
          elseif (cntall(j,2).eq.name(i)) then
            alltr=alltr+cntall(j,4)
            allnt=allnt+cntall(j,3)
          end if
  220   continue
        if ((alltr+allnt).gt.cutoff) then
          ntest=ntest+1
          mcnem=clcmcn(alltr,allnt)
          ewens=ewens+mcnem
          pval=binp(dfloat(alltr),dfloat(allnt))
          if (pval.lt.bestp) then
            bestp=pval
            bestm=mcnem
          end if
          if (plevel.gt.0) then
            call wrall(name(i), allel)
            write(*,'(3x,a3,2x,2i8,f6.1,4x,f6.4)') 
     &        allel,alltr,allnt,mcnem,pval 
          end if
        end if
  215 continue
      if (ntest.gt.1) ewens=dfloat(ntest-1)*ewens/dfloat(ntest)

      if (plevel.gt.0) then
        if (cutoff.gt.0)
     &     write(*,'(/a,i4)') 'Not using rows with totals   =<',cutoff
        if (ntest.gt.0) then
          write(*,'(/a,i4,3(/a,3x,f8.6)/)') 
     2    'No. of alleles used  = ',ntest,
     3    'Bonferroni corr. 5%  = ',bonf(ntest-1,0.05d0),
     4    'Bonferroni corr. 1%  = ',bonf(ntest-1,0.01d0),
     5    'Bonferroni corr. 0.1%= ',bonf(ntest-1,0.001d0)
        else
          write(*,'(a)') 'No alleles meet inclusion criteria'
        end if
      else
        if (ntest.gt.0) asyp=min(1.0d0,(ntest-1)*bestp)
        call phist(asyp,asyp,histo)
        write(*,'(a10,2(1x,i6),1x,f10.1,2(1x,f6.4),1x,i6,2(1x,a))')
     2    locnam, probandi, ntest, bestm, asyp, asyp,
     3    0, 'TDT-Best ', histo
      end if
C
      alltr=0
      allnt=0
      if (plevel.gt.0) then
        write(*,'(/a/a/a)') 
     2    '  -------- Global Allelic TDT --------',
     3    '   All 1   All 2    Tr=1    Tr=2   TDT',
     4    '  ------------------------------------'
      end if
      do 15 i=1,nallele
        celltdt=0.0d0
        alltr=alltr+cntall(i,3)
        allnt=allnt+cntall(i,4)
        if ((cntall(i,3)+cntall(i,4)).gt.cutoff) then
          celltdt=dfloat(cntall(i,3)-cntall(i,4))**2
     &            /dfloat(cntall(i,3)+cntall(i,4))
          tdt=tdt+celltdt
          df=df+1
        end if
        if (plevel.gt.0) then
          call wrall(cntall(i,1), allel)
          call wrall(cntall(i,2), allel2)
          write(*,'(2(3x,a3,2x),2i8,f6.1)') 
     &       allel, allel2 ,cntall(i,3),cntall(i,4),celltdt
        end if
   15 continue
      tot=alltr+allnt
      asyp=1.0d0
      if (df.gt.0) asyp=chip(tdt,df)

      if (plevel.gt.0) then
        write(*,'(/a,f6.1)') 'Allelic TDT Pearson chi-square=',tdt
        if (cutoff.gt.0) then
           write(*,'(a,i4)') 'Not using rows with totals   =<',cutoff
        end if
        write(*,'(12x,a,i4)') 'Degrees of freedom=',df
        write(*,'(23x,a,3x,f6.4)') 'P-value=', asyp
      end if
      if (iter.gt.0 .and. tot.gt.0) then
        mxiter=10*iter
        call shuffle(nallele,cntall,tot,cutoff,tdt,mxiter,mincnt,
     &               pval)
      else
        mxiter=0
        pval=1.0d0
      end if
      if (plevel.gt.0) then
        write(*,'(a,i7,a,3x,f6.4)') 
     &   'Empiric P-value (',mxiter,' iter)=',pval
        write(*,'(/a,f6.1)') '  Ewens allelic TDT chi-square=',ewens
        write(*,'(12x,a,i4)') 'Degrees of freedom=',ntest-1
        write(*,'(23x,a,3x,f6.4)') 'P-value=',chip(ewens,ntest-1)
        write(*,'(/a/a/a)') 
     2    '  ----- Genotypic Transmission Test ------',
     3    '       Genotype     Trans  Expected   Dev',
     4    '  ----------------------------------------'
      else
        call phist(asyp,pval,histo)
        write(*,'(a10,2(1x,i6),1x,f10.1,2(1x,f6.4),1x,i6,2(1x,a))')
     2    locnam, probandi, df, tdt, asyp, pval,mxiter,'TDT-All  ',histo
        asyp=1.0d0
        df=max(0,ntest-1)
        if (df.gt.0) asyp=chip(ewens,df)
        call phist(asyp,asyp,histo)
        write(*,'(a10,2(1x,i6),1x,f10.1,2(1x,f6.4),1x,i6,2(1x,a))')
     2    locnam, probandi, df, ewens, asyp, asyp, 0, 
     3    'TDT-Ewens',histo
      end if

      otdt=0.0d0
      do 225 i=1,ngcount
        if (gcount(i,3).gt.cutoff) then
          gdf=gdf+1
          if (gcount(i,4).gt.cutoff) then
            otdt=otdt+dfloat(gcount(i,3))*
     &           ln(dfloat(4*gcount(i,3))/dfloat(gcount(i,4)))
          end if
        end if    
        call wrgtp(gcount(i,1),gcount(i,2),gtp,1)
        if (plevel.gt.0) then
          write(*,'(8x,a7,1x,i8,1x,f9.1,1x,f6.1)') 
     2     gtp,gcount(i,3),0.25d0*dfloat(gcount(i,4)),
     3     ftdev(dfloat(gcount(i,3)),0.25d0*dfloat(gcount(i,4)))
        end if
  225 continue
      otdt=otdt+otdt
      gdf=max(gdf-1,1)
      asyp=chip(otdt,gdf)
C
C Monte-Carlo only if iter>0
C
      it=0
      tailp=0
      if (iter.eq.0 .or. tot.eq.0) then
        pval=1.0d0
      else
C Sequential Monte-Carlo P-value after Besag & Clifford Biometrika 1991
C P= tailp/it if tailp=mincnt or (tailp+1)/(it+1) if tailp<mincnt && it=iter
   49   continue
        if (it.eq.iter .or. tailp.eq. mincnt) goto 50
          it=it+1
          do 52 j=1,ngcount
          do 52 k=1,4
            gcount(j,k)=0
   52     continue        
          ngcount=0
          rewind(wrk2)

   55     continue
            read(wrk2,end=70) naff,(aff(i),i=1,naff),num,nfound,
     &        (fa(i),mo(i),sex(i),untyped(i),set(i,1),set(i,2),i=1,num) 
            call csimped(num,nfound,fa,mo,sex,untyped,set,xlinkd)
            do 60 i=1,naff
              prob=aff(i)
              pg1=set(fa(prob),1)
              pg2=set(fa(prob),2)
              mg1=set(mo(prob),1)
              mg2=set(mo(prob),2)
              cg1=set(prob,1)
              cg2=set(prob,2)
              call trans(pg1,pg2,mg1,mg2,cg1,cg2,tr1,tr2,nt1,nt2,typ)
              call incr(tr1,tr2,nt1,nt2,ngcount,gcount)
   60       continue
          goto 55
   70     continue
          gtdt=clcchi(ngcount,gcount,cutoff)
          mgtdt=mgtdt+gtdt
          if (gtdt.gt.otdt .or. (gtdt.eq.otdt .and. 
     2        random().gt.0.5d0))  then
            tailp=tailp+1
          end if
          if (plevel.gt.1) then
            write(*,'(/a,i4,a,f6.1)') 
     &       'Pseudosample ',it,': gX2 =',gtdt
            do 325 i=1,ngcount
              call wrgtp(gcount(i,1),gcount(i,2),gtp,1)
  325         write(*,'(8x,a7,1x,2i8)') 
     &          gtp,gcount(i,3),gcount(i,4)
          end if
          goto 49
   50   continue
        if (tailp.lt.mincnt) then
          tailp=tailp+1
          it=it+1
        end if
        mgtdt=mgtdt/dfloat(it)
        pval=dfloat(tailp)/dfloat(it)
      end if
      if (plevel.gt.0) then
        write(*,'(/a,f6.1/a,i4)')
     2    'Genotypic Transmission Chi-sq =',otdt,
     3    '   Nominal degrees of freedom =',gdf
        if (cutoff.gt.0) then
          write(*,'(a,i4)') 'Not using rows with totals   =<',cutoff
        end if
        write(*,'(14x,a,3x,f6.4)') 'Nominal P-value =',asyp
        write(*,'(6x,a,i4,a,i4,a,f6.4,a/a,f6.1)')
     2    'Equalled or exceeded by =',tailp,'/',it,
     3    ' simulated values (',pval,')',
     4    'Mean of simulated chi-squares =',mgtdt
      else
        call phist(asyp,pval,histo)
        write(*,'(a10,2(1x,i6),1x,f10.1,2(1x,f6.4),1x,i6,2(1x,a))')
     &    locnam, probandi, gdf, otdt, asyp, pval, it,'TDT-Gtp  ',histo
      end if
      return
      end
C end-of-dotdt
C
C test if useful for TDT
C
      logical function tdtuse(idx,gene,naff,fa,mo,locus,use2, xmale)
      integer MAXSIZ, MAXLOC, KNOWN
      parameter(MAXSIZ=20, MAXLOC=10000, KNOWN=0)
      integer gene,idx, naff, use2
      logical xmale
C pedigree structure
      integer fa(MAXSIZ),mo(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)
      integer gen2

      gen2=gene+1
      tdtuse=.false.

C both parents untyped
      if (locus(fa(idx),gene).lt.KNOWN .and. 
     &    locus(mo(idx),gene).lt.KNOWN) then
        return
C only using one proband per family
      elseif (naff.gt.0 .and. use2.gt.2) then
        return
C one parent untyped and the other homozygous or same genotype as index
      elseif (locus(mo(idx),gene).lt.KNOWN .and. (use2.gt.1 .or.
     2        ((locus(fa(idx),gene).eq.locus(fa(idx),gen2) .or. 
     3        (locus(idx,gene).eq.locus(fa(idx),gene)
     4        .and. locus(idx,gen2).eq.locus(fa(idx),gen2)))))) then
        return
      elseif (locus(fa(idx),gene).lt.KNOWN .and. 
     2        ((use2.gt.1 .and. .not.xmale) .or.
     3         ((locus(mo(idx),gene).eq.locus(mo(idx),gen2) .or.
     4         (locus(idx,gene).eq.locus(mo(idx),gene)
     5         .and. locus(idx,gen2).eq.locus(mo(idx),gen2)))))) then
        return
C both parents homozygous 
      elseif (locus(fa(idx),gene).eq.locus(fa(idx),gen2) .and. 
     &        locus(mo(idx),gene).eq.locus(mo(idx),gen2)) then 
        return
C both parents same genotype as index
C     elseif (locus(idx,gene).eq.locus(fa(idx),gene) .and. 
C    2        locus(idx,gen2).eq.locus(fa(idx),gen2) .and. 
C    3        locus(idx,gene).eq.locus(mo(idx),gene) .and. 
C    4        locus(idx,gen2).eq.locus(mo(idx),gen2)) then
C       return
      end if
      tdtuse=.true.
      return
      end
C end-of-tdtuse
C
C randomization test for allelic TDT -- shuffle table ITER times 
C using TOT swaps per shuffle
C
      subroutine shuffle(nallele,cntall,tot,cutoff,tdt,mxiter,mincnt,
     &                   pvalue)
      integer MAXALL, MAXG
      parameter(MAXALL=2, MAXG=MAXALL*(MAXALL+1)/2)
      integer mxiter, mincnt
      double precision pvalue, tdt
C Genotype counts: all1, all2, #all1 trans, #all2 trans
      integer nallele,cntall(MAXG,4),tot,cutoff
C local variables
      integer toc,cum,oldcum,row,col
      integer i,it,swap,tailp
      double precision simtdt
C functions
      double precision clctdt
      integer irandom
      real random
C
C Sequential Monte-Carlo P-value after Besag & Clifford Biometrika 1991
C P= tailp/it if tailp=mincnt or (tailp+1)/(it+1) if tailp<mincnt && it=iter
C
      it=0
      tailp=0
    5 continue
      if (it.eq.mxiter .or. tailp.eq.mincnt) goto 10
        it=it+1
        do 20 i=1,tot
          swap=irandom(1,tot)
          oldcum=0
          do 25 row=1,nallele
          do 25 col=3,4
          if (cntall(row,col).gt.0) then
            cum=oldcum+cntall(row,col)
            if  (swap.le.cum .and. swap.gt.oldcum) 
     &      then
              toc=4
              if (col.eq.4) toc=3
              goto 26
            end if
            oldcum=cum
          end if
   25     continue
   26     continue
          cntall(row,col)=cntall(row,col)-1
          cntall(row,toc)=cntall(row,toc)+1
   20   continue
        simtdt=clctdt(nallele,cntall,cutoff)
        if (simtdt.gt.tdt .or. (simtdt.eq.tdt .and. 
     2      random().gt.0.5))  then
          tailp=tailp+1
        end if
      goto 5
   10 continue
      if (tailp.lt.mincnt) then
        tailp=tailp+1
        it=it+1
      end if
      mxiter=it
      pvalue=dfloat(tailp)/dfloat(mxiter)
      return
      end
C end-of-shuffle
C
C calculate symmetry pearson chi-square
C
      double precision function clctdt(ngcount,gcount,cutoff)
C
C Genotype counts
C genotype allele1,allele2, number transmitted, number not trans
      integer MAXALL,MAXG
      parameter(MAXALL=2,MAXG=MAXALL*(MAXALL+1)/2)
      integer ngcount,gcount(MAXG,4),cutoff
      integer j
      clctdt=0.0d0
      do 10 j=1,ngcount
      if ((gcount(j,3)+gcount(j,4)).gt.cutoff) then
        clctdt=clctdt+dfloat(gcount(j,3)-gcount(j,4))**2
     &         /dfloat(gcount(j,3)+gcount(j,4))
      end if
   10 continue
      return
      end
C end-of-clctdt
C
C calculate g.o.f. LR chi-square
C
      double precision function clcchi(ngcount,gcount,cutoff)
C
C Genotype counts
C genotype allele1,allele2, number transmitted, 
C expected number based on parental genotypes
C
      integer MAXALL,MAXG
      parameter(MAXALL=2,MAXG=MAXALL*(MAXALL+1)/2)
      integer ngcount,gcount(MAXG,4),cutoff
      integer j
      clcchi=0.0d0
      do 10 j=1,ngcount
      if (gcount(j,3).gt.cutoff .and. gcount(j,4).gt.cutoff) then
        clcchi=clcchi+dfloat(gcount(j,3))*
     &         log(dfloat(4*gcount(j,3))/dfloat(gcount(j,4)))
      end if
   10 continue
      clcchi=clcchi+clcchi
      return
      end
C end-of-clcchi
C
C Approach of Schaid and Sommer (1993), amplified by Knapp et al (1995)
C
C MM x MM   MM x MN   MM x NN   MN x MN    MN x NN    NN x NN    
C   MM      MM   MN     MN      MM MN NN   MN   NN      NN
C   n1      n2   n3     n4      n5 n6 n7   n8   n9      n10
C
C a=4*n1 + 3*n2 + 3*n3 + 2*n4 + 2*n5 + 2*n6 + 2*n7 + n8 + n9
C b=n2 + n3 + 2*n4 + 2*n5 + 2*n6 + 2*n7 + 3*n8 + 3*n9 + 4*n10
C c=n1 + n2 + n5
C d=n3 + n4 + n6 + n8
C
C providing n-c-d!=0 and a-2c-d!=0 then
C
C p=(a-2*c-d)/2n
C r1= (1-p)*d/(2*p*(n-c-d))
C r2= (1-p)^2 c/(p^2*(n-c-d))
C
C Here, actually done as the log-linear model, as the closed form
C standard error formulae are ugly
C
C
      subroutine nucseg(wrk,trait,gene,candal,other,x,r,b,cov,
     2                  pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     3                  numloc, key, plevel)
      integer MAXCOV, MAXLOC, MAXIBD, MAXSIZ, MAXTER, KNOWN
      parameter(MAXSIZ=20, MAXLOC=10000, KNOWN=0,
     3          MAXIBD=20, MAXTER=MAXIBD/2, 
     4          MAXCOV=MAXTER*(MAXTER+1)/2 )
      integer candal,gene,other,plevel,trait,wrk
C pedigree structure
      character*10 pedigree
      integer sex(MAXSIZ)
      integer actset,num, nfound
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)
C work arrays for log-linear modelling
      double precision x(MAXTER), r(MAXCOV), b(MAXTER), cov(MAXCOV)
      integer key(MAXSIZ)
C local variables
      real counts(16), cpgmod(40), hwemod(64), offset(16)
      integer gen2, i, naff, pos
      character*3 allnam
      character*7 gtp0, gtp1, gtp2
      logical last
      double precision lik0, lik1, p, p0, q, q0, r0, r1, r2,
     &                 e1,e2,e3,e4,e5,e6, se1, se2
C
C functions 
      double precision chip
C
      data hwemod / 1.0,4.0,0.0,1.0,1.0,3.0,0.0,1.0,1.0,3.0,0.0,1.0,
     2              1.0,3.0,1.0,0.0,1.0,3.0,1.0,0.0,1.0,2.0,1.0,0.0,
     3              1.0,2.0,1.0,0.0,1.0,2.0,0.0,1.0,1.0,2.0,1.0,0.0,
     4              1.0,2.0,1.0,0.0,1.0,2.0,0.0,0.0,1.0,1.0,1.0,0.0,
     5              1.0,1.0,1.0,0.0,1.0,1.0,0.0,0.0,1.0,1.0,0.0,0.0,
     6              1.0,0.0,0.0,0.0 /
      data cpgmod / 
     2 1.0,0.0,0.0,0.0,1.0,1.0,0.0,0.0,1.0,0.0,
     3 0.0,1.0,0.0,0.0,1.0,0.0,1.0,0.0,1.0,0.0,
     4 0.0,1.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,0.0,
     5 0.0,0.0,1.0,1.0,0.0,0.0,0.0,1.0,0.0,0.0 /
      gen2=gene+1
      call wrall(candal, allnam)
      naff=0
      do 1 i=1,10
        key(i)=0
    1 continue  
      do 2 i=1,16
        offset(i)=0.0
    2 continue  
      if (plevel.gt.1) then
        write(*,'(/a)') 'Pedigree   ID         Child   Father  Mother'
      end if
      last=.false.
      rewind(wrk)
C
   10 continue
       call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &            numloc, last)
       if (last) goto 20

       if (actset.le.0) goto 10
C
         do 12 i=nfound+1,num
         if (locus(i,trait).eq.2.0 .and.
     2     locus(i,gene).gt.KNOWN .and. locus(fa(i),gene).gt.KNOWN .and.
     3     locus(mo(i),gene).gt.KNOWN)  then
           naff=naff+1
           nfa=0
           nmo=0
           nch=0
           if (int(locus(i,gene)).eq.candal) nch=nch+1
           if (int(locus(i,gen2)).eq.candal) nch=nch+1
           if (int(locus(fa(i),gene)).eq.candal) nfa=nfa+1
           if (int(locus(fa(i),gen2)).eq.candal) nfa=nfa+1
           if (int(locus(mo(i),gene)).eq.candal) nmo=nmo+1
           if (int(locus(mo(i),gen2)).eq.candal) nmo=nmo+1
           if (nmo.eq.1 .and. nfa.eq.1) then
             pos=7-nch
           else if ((nfa+nmo).gt.1) then
             pos=7-nfa-nmo-nch
           else
             pos=10-nfa-nmo-nch
           end if
           key(pos)=key(pos)+1
           if (plevel.gt.1) then
             write(*,'(a10,1x,a10,3(1x,i3,1x,i3))') pedigree,id(i),
     2         int(locus(i,gene)), int(locus(i,gen2)), 
     3         int(locus(fa(i),gene)), int(locus(fa(i),gen2)), 
     4         int(locus(mo(i),gene)), int(locus(mo(i),gen2)) 
           end if
         end if
   12    continue
       goto 10
   20 continue
      counts(1)=float(key(1))
      counts(2)=0.5*float(key(2))
      counts(3)=counts(2)
      counts(4)=0.5*float(key(3))
      counts(5)=counts(4)
      counts(6)=0.5*float(key(4))
      counts(7)=counts(6)
      counts(8)=float(key(5))
      counts(9)=0.5*float(key(6))
      counts(10)=counts(9)
      counts(11)=float(key(7))
      counts(12)=0.5*float(key(8))
      counts(13)=counts(12)
      counts(14)=0.5*float(key(9))
      counts(15)=counts(14)
      counts(16)=float(key(10))

      call loglin(16,4,2,counts,hwemod,offset,x,r,b,cov,lik0)
      p0=exp(b(2))
      p0=p0/(1.0d0+p0)
      q0=1.0d0-p0
      call loglin(16,4,4,counts,hwemod,offset,x,r,b,cov,lik1)
      p=exp(b(2))
      p=p/(1.0d0+p)
      q=1.0d0-p
      r1=b(3)
      r2=b(4)
      r0=p*p*exp(r2)+2*p*q*exp(r1)+q*q
      se1=1.96d0*sqrt(cov(6))
      se2=1.96d0*sqrt(cov(10))
      lik1=lik0-lik1
C
      e1=p0*p0*p0*p0*dfloat(naff)
      e2=4*p0*q0*p0*p0*dfloat(naff)
      e3=2*p0*p0*q0*q0*dfloat(naff)
      e4=4*p0*q0*p0*q0*dfloat(naff)
      e5=4*p0*q0*q0*q0*dfloat(naff)
      e6=q*q*q*q*dfloat(naff)
      call wrgtp(candal,candal,gtp2,1)
      call wrgtp(candal,other,gtp1,1)
      call wrgtp(other,other,gtp0,1)

      write(*,'(/a/6x,a,9x,a,3(1x,a)/a)') 
     2  '------------------------------------------------------------',
     3  'Mating','Total Expected', gtp2, gtp1, gtp0,
     4  '------------------------------------------------------------' 
      write(*,50) gtp2,' x ',gtp2, key(1),e1,key(1),'x  ','x  ',
     2  gtp2,' x ',gtp1, key(2)+key(3),e2,key(2),key(3),'x  ',
     3  gtp2,' x ',gtp0, key(4),e3,'x  ',key(4),'x  ',
     4  gtp1,' x ',gtp1, key(5)+key(6)+key(7),e4,key(5),key(6),key(7),
     5  gtp1,' x ',gtp0, key(8)+key(9),e5,'x  ',key(8),key(9),
     6  gtp0,' x ',gtp0, key(10),e6,'x  ','x  ',key(10) 
   50 format(3a,i9,f9.1,(1x,i5,2x),2a8  /3a,i9,f9.1,2(1x,i5,2x),a8/
     2       3a,i9,f9.1,a8,(1x,i5,2x),a8/3a,i9,f9.1,3(1x,i5,2x)/
     3       3a,i9,f9.1,a8,2(1x,i5,2x)  /3a,i9,f9.1,2a8,1x,i5)
      write(*,'(a//3a,f5.3/a,i5)')  
     2  '------------------------------------------------------------',
     3  'Freq of ',allnam,' allele   =     ',p,
     4  'N affected children  = ',naff 
      write(*,'(/a,f8.2,a,f5.3,a,2(/3(a,f8.2),a)/a,f8.2)') 
     2  'HWE Chi-square (2 df)= ',lik1,' (P=',chip(lik1,2),')',
     3  'Genotypic RR1 (f1)   = ',exp(r1),' (95%CI=',
     4     exp(r1-se1),' to ',exp(r1+se1),')',
     5  'Genotypic RR2 (f2)   = ',exp(r2),' (95%CI=',
     6     exp(r2-se2),' to ',exp(r2+se2),')',
     7  'Attributable risk    = ', 1.0d0-1.0d0/r0
C    7  'Attributable risk    = ', (p*p*(exp(r2)-1.0d0)+
C    8     2*p*q*(exp(r1)-1.0d0))/r0
C
C ML CPG test
C
      counts(1)=float(key(2))
      counts(2)=float(key(3))
      counts(3)=float(key(5))
      counts(4)=0.5*float(key(6))
      counts(5)=counts(4)
      counts(6)=float(key(7))
      counts(7)=float(key(8))
      counts(8)=float(key(9))
      call loglin(8,5,3,counts,cpgmod,offset,x,r,b,cov,lik0)
      call loglin(8,5,5,counts,cpgmod,offset,x,r,b,cov,lik1)
      r1=b(4)
      r2=b(5)
      r0=p*p*exp(r2)+2*p*q*exp(r1)+q*q
      se1=1.96d0*sqrt(cov(10))
      se2=1.96d0*sqrt(cov(15))
      lik1=lik0-lik1
      write(*,'(/a,f8.2,a,f5.3,a,2(/3(a,f8.2),a)/a,f8.2)') 
     2  'CPG Chi-sq    (2 df) = ',lik1,' (P=',chip(lik1,2),')',
     3  'Genotypic RR1 (f1)   = ',exp(r1),' (95%CI=',
     4     exp(r1-se1),' to ',exp(r1+se1),')',
     5  'Genotypic RR2 (f2)   = ',exp(r2),' (95%CI=',
     6     exp(r2-se1),' to ',exp(r2+se1),')',
     7  'Attributable risk    = ',(p*p*(exp(r2)-1.0d0)+
     8     2*p*q*(exp(r1)-1.0d0))/r0
C
      return
      end
C end-of-nucseg
C
C zero-trapped log
      double precision function ln(x)
      double precision x
      if (x.le.0.0d0) then
        ln=0.0d0
      else
        ln=log(x)
      end if
      return
      end
C end-of-ln
C
C perform sibship association permutation test
C
C Combines TDT with SDT: appropriate permutation set for each sibship
C
C If both parents genotyped, then each child can be drawn from 13,14,23,24
C If one or no parents genotyped, but may be reconstructed, then draw
C from mixture of obligate genotypes (those usable to reconstruct the missing
C parents) and 13,14,23,24.
C If cannot unequivocally reconstruct parental genotypes
C draw only from obligate (observed) genotypes among children
C
      subroutine rctdt(wrk,wrk2,trait,locnam,gene,iter,mincnt,gt,
     2             thresh,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     3             numloc, numal,name,cntall,aff,set,x,
     4             mtrans,vtrans,plevel)
C
      integer KNOWN, MAXALL, MAXG, MAXSIZ, MAXLOC, MISS
      double precision EPS
      parameter(EPS=1.0d-6,KNOWN=0, MAXALL=2, 
     2          MAXG=MAXALL*(MAXALL+1)/2,MAXSIZ=20, 
     3          MAXLOC=10000, MISS=-9999)
      integer gene,gt,iter,mincnt,plevel,trait,wrk,wrk2
      double precision thresh
      character*10 locnam
C  Pedigree structure
      character*10 pedigree
      integer actset,num, nfound
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ)
      integer sex(MAXSIZ)
      integer numloc
      double precision locus(MAXSIZ,MAXLOC)
C allele frequencies structure
      integer numal, name(MAXALL)
C array for allele counts in cases and controls
      integer cntall(MAXG,4)
C work arrays for counts and MC iteration
      integer aff(MAXSIZ), set(MAXSIZ,2)
      double precision x(MAXALL),mtrans(MAXALL),vtrans(MAXG)
C local variables
      integer contrib,df,gen2,i,it,j,k,naff,nuntyp,pos,tailp
      integer currf, currm, fin, mg1, mg2, pg1,pg2, nfam, 
     &        parall, ptyped, partyp(4,3)
      logical last
      character*3 allel, histo
      real casden, conden
      double precision asyp, bestz, chisq, obs, 
     &                 mchisq, ochisq, pval, vchisq
C functions
      integer getnam
      logical rctuse
      double precision chip, isaff
C
      df=-1
      gen2=gene+1
      nca=0
      nco=0
      nfam=0
      nuntyp=0
      parall=0
      do 1 i=1,4
        partyp(i,1)=0
        partyp(i,2)=0
        partyp(i,3)=0
    1 continue
      do 2 j=1,numal  
        mtrans(j)=0.0d0
        vtrans(j)=0.0d0
        do 2 k=1,3
          cntall(j,k)=0
    2 continue
      mchisq=0.0d0
      vchisq=0.0d0
      if (plevel.gt.1) then
        write(*,'(/a/a)') 
     2    '----- Sibships used for RC-TDT -----',
     3    'Pedigree   Father   Mother   Aff Tot'
      end if

      last=.false.
      rewind(wrk)
    5 continue
        call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &             numloc, last)
        if (last) goto 20

        if (actset.le.0) goto 5
C
C Full sibs
C
        fin=num
        currf=fa(fin)
        currm=mo(fin)
        do 10 k=num-1,nfound,-1
          if (fa(k).ne.currf .or. mo(k).ne.currm) then
            contrib=0
            naff=0
            do 12 i=k+1,fin
            if (locus(i,gene).gt.KNOWN) then
              contrib=contrib+1
              set(contrib,1)=getnam(locus(i,gene),numal,name)
              set(contrib,2)=getnam(locus(i,gen2),numal,name)
              if (locus(i,trait).ne.MISS) then
                aff(contrib)=int(isaff(locus(i,trait),thresh,gt))
                naff=naff+aff(contrib)-1
              else
                nuntyp=nuntyp+1
              end if
            end if
   12       continue
C
C Skip if no usable individuals in this sibship
C
            if (contrib.gt.0 .and. naff.gt.0) then
              ptyped=1
              if (locus(currf,gene).gt.KNOWN) then
                ptyped=ptyped+1
                pg1=getnam(locus(currf,gene),numal,name)
                pg2=getnam(locus(currf,gen2),numal,name)
              else
                pg1=MISS
                pg2=MISS
              end if
              if (locus(currm,gene).gt.KNOWN) then
                ptyped=ptyped+2
                mg1=getnam(locus(currm,gene),numal,name)
                mg2=getnam(locus(currm,gen2),numal,name)
              else
                mg1=MISS
                mg2=MISS
              end if
              partyp(ptyped,1)=partyp(ptyped,1)+1
              call parimp(pg1,pg2,mg1,mg2,contrib,set,parall)
C
C Skip if family uninformative: need at least one heterozygote parent
C and if parental genotypes imputed, either affected and 
C unaffected offspring to permute, or more than two affected
C
              if (rctuse(pg1,pg2,mg1,mg2,ptyped,parall,contrib,naff))
     &        then
                partyp(ptyped,2)=partyp(ptyped,2)+1
                partyp(ptyped,3)=partyp(ptyped,3)+naff
                if (plevel.gt.1) then
                  write(*,'(a,2(1x,a),2(1x,i3))') 
     &              pedigree, id(currf), id(currm), naff, contrib
                end if
                nfam=nfam+1
                do 14 i=1,contrib
                if (aff(i).ne.MISS) then
                  cntall(set(i,1),aff(i))=cntall(set(i,1),aff(i))+1
                  cntall(set(i,2),aff(i))=cntall(set(i,2),aff(i))+1
                end if
   14           continue
                write(wrk2) pg1,pg2,mg1,mg2,contrib,
     &                      (aff(i),set(i,1),set(i,2),i=1,contrib)
              end if
            end if
C Now update to next sibship
            fin=k
            currf=fa(fin)
            currm=mo(fin)
          end if
   10   continue
C mark end of sibships in current pedigree
      goto 5
   20 continue

      do 25 j=1,numal
        nco=nco+cntall(j,1)
        nca=nca+cntall(j,2)
        cntall(j,3)=cntall(j,1)+cntall(j,2)
        if (cntall(j,3).gt.0) df=df+1
   25 continue
C
C MC estimation of mean and variance
C
      it=0
      tailp=0
      if (iter.eq.0 .or. nca.eq.0 .or. nfam.lt.1) then
        asyp=1.0d0
        pval=1.0d0
      else
C
        do 50 it=1,iter
          call rctsim(wrk2,pg1,pg2,mg1,mg2,contrib,aff,set,numal,x)
          call dssp(numal,it,1,x,mtrans,vtrans)
   50   continue
        do 60 j=1, numal*(numal+1)/2
          vtrans(j)=vtrans(j)/dfloat(max(1,it-1))
   60   continue
C
C Sequential P-value simulation
C
        ochisq=0.0d0
        pos=0
        do 65 j=1, numal
          obs=dfloat(cntall(j,2))
          if (mtrans(j).gt.EPS .and. obs.gt.EPS) then
            ochisq=ochisq+obs*log(obs/mtrans(j))
          end if    
   65   continue

        it=0
   69   continue
        if (it.eq.iter .or. tailp.eq.mincnt) goto 70
          it=it+1
          call rctsim(wrk2,pg1,pg2,mg1,mg2,contrib,aff,set,numal,x)
          chisq=0.0d0
          do 75 j=1, numal
          if (mtrans(j).gt.EPS .and. x(j).gt.EPS) then
            chisq=chisq+x(j)*log(x(j)/mtrans(j))
          end if    
   75     continue
          call moment(it,chisq,mchisq,vchisq)

          if (chisq.gt.ochisq .or. (chisq.eq.ochisq .and.
     2        random().gt.0.5))  then
            tailp=tailp+1
          end if
          if (plevel.gt.1) then
            write(*,'(/a,i4,a,f6.1)') 
     &        'Pseudosample ',it,': RC-TDT=',chisq
          end if
          goto 69
   70   continue
        if (tailp.lt.mincnt) then
          tailp=tailp+1
          it=it+1
        end if
        pval=dfloat(tailp)/dfloat(it)
      end if

      vchisq=vchisq/dfloat(max(1,it-1))
      bestz=0.0d0
      pos=0
      do 110 j=1, numal
        pos=pos+j
        if (vtrans(pos).gt.EPS) then
          x(j)=(dfloat(cntall(j,2))-mtrans(j))/sqrt(vtrans(pos))
        else
          x(j)=0.0d0
        end if
        if ((x(j)*x(j)).gt.abs(bestz)) bestz=x(j)*x(j)
  110 continue

      if (plevel.gt.0 .and. nca.eq.0) then
        write(*,'(/a,a10,a,3(/a,i6)))') 
     2 ' -------- Combined transmission test for "',locnam,'" --------',
     3    '                    marker(-) =',nuntyp,
     4    '       No. trait(+) marker(+) =',(nca+nco)/2,
     5    '          No. useful sibships =',nfam 
      else if (plevel.gt.0) then
        write(*,'(/a,a10,a/a/a)') 
     2 ' -------- Combined transmission test for "',locnam,'" --------',
     3 '   Allele   Affected   Unaffected   Total   E(Aff)    Z    P',
     5 ' -------------------------------------------------------------'
        casden=max(1.0,float(nca))
        conden=max(1.0,float(nco))
        do 30 j=1,numal
          call wrall(name(j),allel)
          write(*,31)
     2     allel,cntall(j,2),'(',float(cntall(j,2))/casden,')',
     3     cntall(j,1),'(',float(cntall(j,1))/conden,')',cntall(j,3),
     4     mtrans(j), x(j), chip(x(j)*x(j),1)
   30   continue
   31   format(3x,a3,2x,2(2x,i5,1x,a1,f3.2,a1),i7,2(1x,f6.1),1x,f6.4)
        write(*,'(a/a8,2(2x,i5,6x),i7)') 
     2 ' -------------------------------------------------------------',
     3      'Total',nca,nco,nca+nco
        write(*,'(3(/a,i6))') 
     2    '                    marker(-) =',nuntyp,
     3    '       No. trait(+) marker(+) =',(nca+nco)/2,
     4    '          No. useful sibships =',nfam 
        write(*,'(a,f6.1/a,i4)')
     2    ' Global association statistic =',ochisq,
     3    '           Degrees of freedom =',max(0,df) 
        write(*,'(a,i4,a,i5,a,f6.4,a/a,f6.1,a,f6.1,a)')
     2    '      Equalled or exceeded by =',tailp,'/',it,
     3    ' simulated values (',pval,')',
     4    ' Mean (Var) simulated chi-sqs =',mchisq,' (',vchisq,')'
        if (plevel.gt.1) then
          write(*,'(/a/a)') 
     2 '  Allele     Tr   E(Tr)  Cov(Tr)',
     3 ' ------- ------ ------- --------------------------------------'
          pos=0
          do 150 j=1, numal
            call wrall(name(j),allel)
            write(*,'(3x,a3,2x,i7,10(1x,f7.2):)')
     2         allel,cntall(j,2),mtrans(j),(vtrans(k),k=pos+1,pos+j)
            pos=pos+j
  150     continue
          write(*,'(/a/a,4(/a,3(2x,i7)))') 
     2 '  Parents genotyped   No. Fams  Useable  Aff Off',
     3 ' ------------------   --------  -------  -------',
     4 '  None               ',partyp(1,1),partyp(1,2),partyp(1,3),
     5 '  Father only        ',partyp(2,1),partyp(2,2),partyp(2,3),
     6 '  Mother only        ',partyp(3,1),partyp(3,2),partyp(3,3),
     7 '  Both parents       ',partyp(4,1),partyp(4,2),partyp(4,3) 
        end if
      else if (nca.gt.0 .and. numal.gt.1) then
        asyp=chip(bestz,1)
        asyp=min(1.0d0,(numal-1)*asyp)
        call phist(asyp,pval,histo)
        write(*,'(a10,2(1x,i6),1x,f10.1,2(1x,f6.4),1x,i6,2(1x,a))')
     2    locnam, nca/2, numal, bestz, asyp, pval,
     3    it, 'RC-TDT   ', histo
        
      end if
      return
      end
C end-of-rctdt   
C
C Make list of possible parental genotypes for this sibship
C
      subroutine parimp(pg1,pg2,mg1,mg2,nsibs,set,parall)

      integer KNOWN, MAXSIZ, MISS
      parameter(KNOWN=0, MAXSIZ=20, MISS=-9999)

      integer nsibs, mg1,mg2, pg1,pg2, parall, set(MAXSIZ,2)
      integer g(4,2), het, i, p11, p12, p21, p22, tmp
      logical d1,d2,d3,d4

C Both parents genotyped
      if (pg1.gt.KNOWN .and. mg1.gt.KNOWN) then
        parall=4
        return 
      end if
C
C initialize g() with a heterozygote genotype if possible
      het=1
      do 10 i=1, nsibs
      if (set(i,1).ne.set(i,2)) then
        het=i
        goto 11
      end if
   10 continue
   11 continue
      g(1,1)=set(het,1)
      g(1,2)=set(het,2)
C Categorise sibs genotype
C in terms of which allele is shared with starting genotype
      do 3 i=2, 4
        g(i,1)=MISS
        g(i,2)=MISS
    3 continue

      do 30 i=1, nsibs
        d1=(set(i,1).eq.g(1,1))
        d4=(set(i,2).eq.g(1,2))
        if (.not.(d1 .and. d4)) then
          d2=(set(i,1).eq.g(1,2))
          d3=(set(i,2).eq.g(1,1))
          if (d1) then
            g(2,1)=set(i,1)
            g(2,2)=set(i,2)
          else if (d3) then
            g(2,1)=set(i,2)
            g(2,2)=set(i,1)
          else if (d2) then
            g(3,1)=set(i,1)
            g(3,2)=set(i,2)
          else if (d4) then
            g(3,1)=set(i,2)
            g(3,2)=set(i,1)
          else 
            g(4,1)=set(i,1)
            g(4,2)=set(i,2)
          end if
        end if
   30 continue
  
C Fix order of 4th genotype so consistent with others
      if ((g(2,2).ne.MISS .and. g(4,2).ne.g(2,2)) .or.
     &    (g(3,1).ne.MISS .and. g(4,1).ne.g(3,1))) then
        tmp=g(4,2)
        g(4,2)=g(4,1)
        g(4,1)=tmp
      end if
C Produce parental phenosets and compare to any known genotypes
      p11=g(1,1)
      p21=g(1,2)
      p12=MISS
      p22=MISS
      if (g(2,2).ne.MISS) p22=g(2,2)
      if (g(4,2).ne.MISS) p22=g(4,2)
      if (g(3,2).ne.MISS) p12=g(3,2)
      if (g(4,1).ne.MISS) p12=g(4,1)
      call order(p11,p12)
      call order(p21,p22)
      if ((mg1.gt.KNOWN .and. ((mg1.eq.p11 .and. mg2.eq.p12)  .or.
     2    (p21.ne.MISS .and. (mg1.ne.p21 .or. mg2.ne.p22)) .or.
     3    (p21.eq.MISS .and. mg1.ne.p22 .and. mg2.ne.p22)))  .or.
     4    (pg1.gt.KNOWN .and. ((pg1.eq.p21 .and. pg2.eq.p22) .or.
     5    (p11.ne.MISS .and. (pg1.ne.p11 .or. pg2.ne.p12)) .or.
     6    (p11.eq.MISS .and. pg1.ne.p12 .and. pg2.ne.p12)))) then
        call swap(p11,p21)
        call swap(p12,p22)
      end if
C Return observed and imputed genotypes
      if (mg1.le.KNOWN) then
        if (p21.ne.MISS) mg1= -p21
        if (p22.ne.MISS) mg2= -p22
      end if
      if (pg1.le.KNOWN) then
        if (p11.ne.MISS) pg1= -p11
        if (p12.ne.MISS) pg2= -p12
      end if

      parall=0
      if (pg1.ne.MISS) parall=parall+1
      if (pg2.ne.MISS) parall=parall+1
      if (mg1.ne.MISS) parall=parall+1
      if (mg2.ne.MISS) parall=parall+1
      return
      end
C end-of-parimp
C
C Simulate the null distribution of sibship genotypes
C Parental alleles imputed via the children must be transmitted 
C at least once to that sibship
C Furthermore, if two imputed alleles are the same in the two parents,
C then these must be transmitted together to at least one child
C
      subroutine rctperm(pg1,pg2,mg1,mg2,nsibs,set)

      integer KNOWN, MAXSIZ, MISS
      parameter(KNOWN=0, MAXSIZ=20, MISS=-9999)

      integer nsibs,mg1,mg2,pg1,pg2, set(MAXSIZ,2)
      integer all(2,2),gen(2,2),hom0,homimp,i,imp0,imputd, 
     &        p1(2),p2(2),swap,tmp,tr1,tr2
C functions
      integer irandom, ranall

C Allow restart since rejection sampling to meet conditions

      do 2 i=1, 2
      do 2 j=1, 2
        all(i,j)=0
        gen(i,j)=0
    2 continue
      if (pg1.lt.KNOWN .and. pg1.ne.MISS) all(1,1)=1
      if (pg2.lt.KNOWN .and. pg2.ne.MISS) all(1,2)=1
      if (mg1.lt.KNOWN .and. mg1.ne.MISS) all(2,1)=1
      if (mg2.lt.KNOWN .and. mg2.ne.MISS) all(2,2)=1
      imp0=all(1,1)+all(1,2)+all(2,1)+all(2,2)

      if ((all(1,1)+all(2,1)).eq.2 .and. pg1.eq.mg1) gen(1,1)=1
      if ((all(1,1)+all(2,2)).eq.2 .and. pg1.eq.mg2) gen(1,2)=1
      if ((all(1,2)+all(2,1)).eq.2 .and. pg2.eq.mg1) gen(2,1)=1
      if ((all(1,2)+all(2,2)).eq.2 .and. pg2.eq.mg2) gen(2,2)=1
      hom0=gen(1,1)+gen(1,2)+gen(2,1)+gen(2,2)

    1 continue

      homimp=hom0
      imputd=imp0
      p1(1)=pg1
      p1(2)=pg2
      p2(1)=mg1
      p2(2)=mg2
      all(1,1)=gen(1,1)
      all(1,2)=gen(1,2)
      all(2,1)=gen(2,1)
      all(2,2)=gen(2,2)
      do 10 i=1, nsibs
        tr1=ranall(p1)
        tr2=ranall(p2)
        if (all(tr1,tr2).eq.1) then
          homimp=homimp-1
          all(tr1,tr2)=0
        end if
        call conoff(tr1,p1,imputd,set(i,1))
        call conoff(tr2,p2,imputd,set(i,2))
   10 continue

      if (imputd.gt.0 .or. homimp.gt.0) goto 1
C
C If matching conditions, now permute genotypes within sibship
C
      do 20 i=1,nsibs
        swap=irandom(1,nsibs)
        tmp=set(swap,1)
        set(swap,1)=set(i,1)
        set(i,1)=tmp
        tmp=set(swap,2)
        set(swap,2)=set(i,2)
        set(i,2)=tmp
   20 continue
      do 30 i=1,nsibs
        call order(set(i,1), set(i,2))
   30 continue
      return
      end
C end-of-rctperm
C
C Randomly transmit nonmissing alleles
      integer function ranall(par)
      integer MISS
      parameter(MISS=-9999)
      integer par(2)
C functions
      integer irandom
      if (par(1).ne.MISS .and. par(2).ne.MISS) then
        ranall=irandom(1,2)
      else if (par(2).eq.MISS) then
        ranall=1
      else
        ranall=2
      end if
      return
      end
C end-of-ranall
C 
C Conditional parent-offspring transmission
C Flag whether an imputed parental allele is transmitted 
      subroutine conoff(tr,par,imputd,off)
      integer KNOWN
      parameter (KNOWN=0)
      integer imputd,off,par(2),tr
      
      if (par(tr).lt.KNOWN) then
        imputd=imputd-1
        par(tr)= -par(tr)
      end if
      off=par(tr)
      return
      end
C end-of-condoff
C
C One simulation of entire set of informative nuclear families 
C
      subroutine rctsim(wrk2,pg1,pg2,mg1,mg2,nsibs,aff,set,numal,trans)
      integer MAXALL, MAXSIZ
      parameter(MAXALL=2, MAXSIZ=20)

      integer mg1,mg2,nsibs,numal,pg1,pg2,wrk2

      integer aff(MAXSIZ), set(MAXSIZ,2)  
      double precision trans(MAXALL)

      integer i,j

      do 5 j=1,numal  
        trans(j)=0.0d0
    5 continue
      rewind(wrk2)
   10 continue
        read(wrk2,end=50) pg1,pg2,mg1,mg2,nsibs,
     &                   (aff(i),set(i,1),set(i,2),i=1,nsibs)
        call rctperm(pg1,pg2,mg1,mg2,nsibs,set)
        do 20 i=1,nsibs
        if (aff(i).eq.2) then
          trans(set(i,1))=trans(set(i,1))+1.0d0
          trans(set(i,2))=trans(set(i,2))+1.0d0
        end if
   20   continue
      goto 10
   50 continue
      return
      end
C end-of-rctsim
C
C test if useful for RC-TDT/FBAT
C
      logical function rctuse(pg1,pg2,mg1,mg2,
     &                        ptyped,parall,contrib,naff)
      integer MISS
      parameter (MISS=-9999)
      integer mg1,mg2,pg1,pg2
      integer contrib,naff,parall,ptyped
      logical h1, h2

      h1=(pg1.ne.MISS .and.abs(pg1).ne.abs(pg2))
      h2=(mg1.ne.MISS .and.abs(mg1).ne.abs(mg2))

      rctuse=.true.
C Both parents homozygous or insufficient parental genotypes
      if (.not.(h1.or.h2) .or.  parall.le.2) then
        rctuse=.false.
        return
C Both parents typed
      else if (ptyped.eq.4) then
        return
C Affected and unaffected children and 3 or 4 identifiable parental alleles
      else if (parall.gt.2 .and. contrib.gt.naff) then
        return
C More than 2 affected children and...
      else if (contrib.gt.2) then
C 4 parental alleles
        if (parall.eq.4) then 
          return
C or 3 parental alleles 12 x 3- or 1- x 23
        else if (h1 .and. abs(pg1).ne.abs(mg2) .and.
     &           abs(pg2).ne.abs(mg2)) then
          return
        else if (h2 .and. abs(mg1).ne.abs(pg2) .and.
     &           abs(mg2).ne.abs(pg2)) then
          return
        end if
      end if
      rctuse=.false.
      return
      end
C end-of-rctuse
C
C Count alleles in entire sample -- codominant system
C Either unweighted or weighted by number of founders in pedigree
C
C If imputation has been done and fndr=2, then return the 
C count of alleles in the founders, both observed and imputed
C
      subroutine freq(wrk,gene,loctyp,pedigree,actset,
     2                num,nfound,id,fa,mo,sex,locus,numloc,
     3                numal,name,fndr,alfrq,totall,typed)
      integer KNOWN,MAXSIZ,MAXLOC,MAXALL,MISS
      parameter (KNOWN=0,MAXSIZ=20,MAXLOC=10000,MAXALL=2,MISS=-9999)
      integer fndr, gene, numloc, totall, typed, wrk
C Pedigree structure
      character*10 pedigree
      integer actset,loctyp,num, nfound
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ), sex(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)
      logical last
C
C allele frequencies structure
      integer tfound, numal, name(MAXALL)
      double precision alfrq(MAXALL)
C
      integer act, den, gen2, i, nfall
      double precision wei

      act=fndr
      gen2=gene+1

C global restart if unimputed genotypes present and fndr=2
C
  999 continue

      numal=0
      nfall=0
      tfound=0
      totall=0
      typed=0

      last=.false.
      rewind(wrk)
   10 continue
       call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &            numloc, last)
       if (last) goto 20

       if (actset.le.0) goto 10
C
C Count observed alleles and skip if none
       den=0
       do 12 i=1,num
         if (locus(i,gene).gt.KNOWN) then
           typed=typed+1
           den=den+1
         end if
         if (loctyp.eq.2 .and. sex(i).eq.1) locus(i,gen2)=KNOWN
         if (locus(i,gen2).gt.KNOWN) den=den+1
   12  continue
       if (den.eq.0) goto 10
C
C If fndr=2 only count alleles in founders
C If fndr=1 weight count in this pedigree by number of founders
C
       tfound=tfound+nfound
       totall=totall+den
       wei=1.0d0
       if (act.eq.1) wei=dfloat(nfound)/dfloat(den)

       if (act.lt.2) then
         do 15 i=1,num
           if (locus(i,gene).gt.KNOWN) then
             call tab(int(locus(i,gene)),numal,name,alfrq,wei)
           end if
           if (locus(i,gen2).gt.KNOWN) then
             call tab(int(locus(i,gen2)),numal,name,alfrq,wei)
           end if
   15    continue
       else
C count imputed founder alleles (bail out if unimputed!)
         do 17 i=1,nfound
           if (locus(i,gene).ne.MISS) then
             if (locus(i,gene).ne.KNOWN) then
               nfall=nfall+1
               call tab(int(abs(locus(i,gene))),numal,name,alfrq,wei)
             end if
           else
             act=0
             goto 999
           end if
           if (locus(i,gen2).ne.MISS) then
             if (locus(i,gen2).ne.KNOWN) then
               nfall=nfall+1
               call tab(int(abs(locus(i,gen2))),numal,name,alfrq,wei)
             end if
           else
             act=0
             goto 999
           end if
   17    continue
       end if
      goto 10
   20 continue

      if (act.eq.0) then
        wei=1.0d0/dfloat(max(1,totall))
      else if (act.eq.1) then
        wei=1.0d0/dfloat(tfound)
      else if (act.eq.2) then
        wei=1.0d0/dfloat(nfall)
      end if
      do 30 i=1,numal
        alfrq(i)=wei*alfrq(i)
   30 continue
      return
      end
C end-of-freq
C
C update table of counts of alleles -- binary search and insertion sort
C
      subroutine tab(curr,numal,name,alfrq,wei)
      integer MAXALL
      parameter(MAXALL=2)
      integer curr, numal, name(MAXALL)
      double precision wei, alfrq(MAXALL)
      integer hi,i,lo,pos

      hi=numal
      lo=1

    1 continue 
      if (hi.lt.lo) goto 5
        pos=(hi+lo)/2
        if (curr.gt.name(pos)) then
          lo=pos+1
        elseif (curr.lt.name(pos)) then
          hi=pos-1
        else
          alfrq(pos)=alfrq(pos)+wei
          return
        end if
      goto 1
    5 continue
C else
      if (numal.lt.MAXALL) then
        do 2 i=numal,lo,-1
          name(i+1)=name(i)
          alfrq(i+1)=alfrq(i)
    2   continue
        numal=numal+1
        name(lo)=curr
        alfrq(lo)=wei
      else
        write(*,'(/a,i2,a/7x,a/)') 
     2    'ERROR: Number of alleles for locus exceeds ',MAXALL,
     3    ', the maximum allowed.','Stopping prematurely.'
        stop
      end if
      return
      end
C end-of-tab
C
C Write out frequencies
C
      subroutine wrfreq(strm,locnam,numal,name,alfrq,mappos,
     &                  totall,typed,nobs,fstyle)
      integer MAXALL
      parameter (MAXALL=2)
      character*20 locnam
      integer fstyle, nobs, strm, totall, typed
C allele frequencies structure
      integer numal, name(MAXALL)
      double precision alfrq(MAXALL)
C map position
      real mappos
C local variables
      integer i, j, nlines
      character*4 allel, allel2
      character*8 mentyp
      double precision corr, het
C functions
      integer eow
      double precision thetaf, uninf

      corr=1.0d0
      het=0.0d0
      if (fstyle.eq.1 .or. fstyle.eq.11) then
        if (fstyle.eq.1) then
          write(*,'(/a/3a/a)')
     2     '------------------------------------------------',
     3     'Allele frequencies for locus "',locnam(1:eow(locnam)),'"',
     4     '------------------------------------------------' 
        else
          write(*,'(/a/3a/a)')
     2     '------------------------------------------------',
     3     'MCEM allele frequencies for locus "',
     4     locnam(1:eow(locnam)),'"',
     5     '------------------------------------------------' 
        end if
        write(*,'(a)') '   Allele  Frequency   Count  Histogram'
        if (numal.eq.0) then
          write(*,'(/6x,a)') 'No nonmissing genotypes'
        else
          do 25 i=1,numal
            call wrall(name(i), allel)
            write(*,'(5x,a3,5x,f6.4,4x,i5,2x,20a1:)') 
     2        allel,alfrq(i),nint(float(totall)*alfrq(i)),
     3        ('*',j=1,max(1,nint(20.0d0*alfrq(i))))
            het=het+alfrq(i)*alfrq(i)
   25     continue
          if (totall.gt.1) corr=dfloat(totall)/dfloat(totall-1)
          het=1.0d0-het
          write(*,'(/a,i4,2(/a,3x,f6.4))')
     2     'Number of alleles    = ',numal,
     3     'Heterozygosity (Hu)  = ',corr*het,
     4     'Poly. Inf. Content   = ',het-uninf(numal, alfrq) 
          if (fstyle.eq.1) then
            write(*,'(a,f13.8/a,i6,1x,a,f5.1,a)')
     5     '4 Neff mu (SSMM)     = ',thetaf(het, typed), 
     6     'Number persons typed = ',typed,
     7     '(',float(100*typed)/float(nobs),'%)'
          else
            write(*,'(a,f13.8/a,i6,1x,a,f5.1,a)')
     5     '4 Neff mu (SSMM)     = ',thetaf(het, totall/2), 
     6     'Number of founders   = ',totall/2,
     7     '(',float(50*typed)/float(totall),'% typed)'
          end if
        end if
C abbreviated output
      elseif (fstyle.eq.2) then
        do 55 i=1,numal
          het=het+alfrq(i)*alfrq(i)
   55   continue
        het=1.0d0-het
        if (totall.gt.1) corr=dfloat(totall)/dfloat(totall-1)
C SNPs
        if (numal.eq.2) then
          do 30 i=1,numal
          if (alfrq(i).le.0.5) then
            call wrall(name(i), allel)
            call wrall(name(3-i), allel2)
            j=eow(allel2)+1
            allel2(j:j)=')'
            write(*,'(a15,i4,2x,3a,2x,2(1x,f6.4),1x,i5)') 
     &       locnam,2,allel,' (',allel2,alfrq(i),corr*het,typed
          end if
   30     continue
C other
        elseif (typed.eq.0) then
          write(*,'(a15,3x,a1,2x,a1,13x,a1,6x,a1,9x,a1)') 
     &      locnam,'-','-','-','-','0'
        elseif (numal.eq.1) then
          call wrall(name(1), allel)
          write(*,'(a15,i4,2x,a4,8x,2(1x,a6),1x,i5)') 
     &      locnam,1,allel,'1.0000',' -    ', typed
        else
          call wrall(name(1), allel)
          allel2=' '
          if (numal.gt.1) call wrall(name(numal), allel2)
          write(*,'(a15,i4,2x,a4,a3,a4,2x,a6,1x,f6.4,1x,i5)')
     2      locnam, numal, allel, '.. ',allel2, ' -    ',corr*het,typed
        end if
C scratch file
      elseif (fstyle.eq.3) then
        write(strm) numal,(name(i),i=1,numal),(alfrq(i),i=1,numal)
C GAS locus file
      elseif (fstyle.eq.4) then
        call precis(numal,alfrq,4)
        write(strm,'(1x,i3,100(1x,f6.4):)') numal,(alfrq(i),i=1,numal)
        write(strm,'(1x,a,100(1x,i3):)') 'name ',(name(i),i=1,numal)
C SAGE locus file
      elseif (fstyle.eq.5) then
        call precis(numal,alfrq,4)
        write(strm,'(a20)') locnam
        do 35 i=1,numal
   35     write(strm,'(1x,i4.4,a,f6.4)') name(i),' = ',alfrq(i)
        write(strm,'(1x,a1)') ';'
        do 40 i=1,numal
        do 40 j=i,numal
   40     write(strm,'(1x,4(i4.4,a))') 
     2       name(i),'/',name(j),' = {',name(i),'/',name(j),'}'
        write(strm,'(1x,a1)') ';'
C new style MENDEL locus file -- used by simwalk and relpair
      elseif (fstyle.eq.7 .or. fstyle.eq.10) then
        mentyp='AUTOSOME'
        if (fstyle.eq.10) mentyp='X-LINKED'
        call precis(numal,alfrq,6)
        write(strm,'(2a8,2i2,i4,1x,f8.3)') 
     &    locnam,mentyp,numal, 0, 1, max(0.0,0.01*mappos)
        do 45 i=1,numal
          call wrall(name(i), allel)
          write(strm,'(5x,a3,f8.6)') allel, alfrq(i)
   45   continue
C Linkage locus file
      elseif (fstyle.eq.8) then
        if (numal.eq.0) then
          write(strm,'(a,1x,2a/a)') 
     &      '3     2  #',locnam, ' #','    0.5    0.5'
        else
          call precis(numal,alfrq,4)
          write(strm,'(i1,1x,i5,3a)') 3,numal,' # ',locnam,' #'
          write(strm,'(100(1x,f6.4):)') (alfrq(i),i=1,numal)
        end if
C PAP popln.dat file
      elseif (fstyle.eq.9) then
        nlines=(numal+4)/5
        write(strm,'(i4,2a)') nlines,' F F # ',locnam
        write(strm,'(i3,5(d15.7))') numal,(alfrq(i),i=1,numal)
      end if
      return
      end
C end-of-wrfreq
C
C remove rounding errors in allele frequencies printed out to precision ndec
C from f3.1 to f9.7
C
      subroutine precis(numal,alfrq,ndec)
      integer MAXALL
      parameter (MAXALL=2)
      integer ndec
C allele frequencies structure
      integer numal
      double precision alfrq(MAXALL)
C topall is most common allele, and the one where we add our correction
      integer i, topall
      character*1 ch
      character*6 fdec
      character*10 buff
      double precision rounded, topfrq, tot

C set print format
      fdec='(f0.0)'
      write(ch,'(i1)') ndec+2
      fdec(3:3)=ch
      write(ch,'(i1)') ndec
      fdec(5:5)=ch
C rewrite to given precision, and calculate accumulated error
      topall=1
      topfrq=0.0d0
      tot=0.0d0
      do 10 i=1,numal
        write(buff,fdec) alfrq(i)
        read(buff,fdec) rounded
        alfrq(i)=rounded
        if (rounded.gt.topfrq) then
          topfrq=rounded
          topall=i
        end if
        tot=tot+rounded
   10 continue
      alfrq(topall)=alfrq(topall)+1.0d0-tot
      return
      end
C end-of-precis
C
C Identify the most common allele
      integer function topall(numal,alfrq)
      integer MAXALL
      parameter (MAXALL=2)
C allele frequencies structure
      integer numal
      double precision alfrq(MAXALL)
      integer i
      double precision topfrq
      topfrq=0.0d0
      topall=0
      do 10 i=1,numal
      if (alfrq(i).gt.topfrq) then
        topfrq=alfrq(i)
        topall=i
      end if
   10 continue
      return
      end
C end-of-topall
C
C Identify an other allele
      integer function othall(thisal,numal,name)
      integer MAXALL, MISS
      parameter (MAXALL=2, MISS=-9999)
      integer thisal
C allele frequencies structure
      integer numal, name(MAXALL)
      integer i
      do 10 i=1,numal
      if (name(i).ne.thisal) then
        othall=name(i) 
        return
      end if
   10 continue
      othall=MISS
      return
      end
C end-of-othall
C
C Frequency of uninformative matings for marker locus
      double precision function uninf(numal, alfrq)
      integer MAXALL
      parameter (MAXALL=2)
C allele frequencies structure
      integer numal  
      double precision alfrq(MAXALL)
      integer i, j
      uninf=0.0d0
      do 127 i=1,numal-1
      do 127 j=i+1,numal
        uninf=uninf+2.0d0*alfrq(i)*alfrq(j)*alfrq(i)*alfrq(j)
  127 continue
      return
      end
C end-of-uninf
C
C Monte-Carlo test for HWE
C
      subroutine dohwe(wrk,wrk2,locnam,gene,xlinkd,iter,mincnt,hwefnd,
     2             pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     3             numloc,  numal, name, cumfrq, set, untyped, 
     4             ngcount,gcount,plevel)
      integer MAXALL, MAXG, MAXSIZ, MAXLOC, KNOWN
      parameter(MAXALL=2, MAXG=MAXALL*(MAXALL+1)/2, 
     &          MAXSIZ=20, MAXLOC=10000, KNOWN=0)
      integer gene,iter,mincnt,plevel,wrk,wrk2
      logical hwefnd, xlinkd
      character*10 locnam
C pedigree structure
      character*10 pedigree
      integer sex(MAXSIZ)
      integer actset,num, nfound
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ), set(MAXSIZ,2)
      double precision locus(MAXSIZ,MAXLOC)
      logical untyped(MAXSIZ)
C allele frequencies structure
      integer numal, name(MAXALL)
      double precision cumfrq(MAXALL)
C Genotype counts: allele1,allele2, genotype count, 
C                  ith allele count
      integer ngcount,gcount(MAXG,4)
C
      integer df, g1, g2, gen2, i, it, j, k, n, tailp,tot,totall,totmal
      double precision asyp, chisq, expf, invden, ochisq, mchisq, 
     &  pval, vchisq
      character*3 histo
      character*7 gtp
      logical last, xmale
C functions 
      integer getnam
      real random
      double precision chip, ftdev, hwechi
C
      gen2=gene+1
      ngcount=0
      do 1 j=1,numal
      do 1 k=1, j
        ngcount=ngcount+1
        gcount(ngcount,1)=0
        gcount(ngcount,2)=0
        gcount(ngcount,3)=0
    1 continue
      it=0
      tot=0
      totmal=0
      last=.false.
      rewind(wrk)
C
   10 continue
       call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &            numloc, last)
       if (last) goto 20

       if (actset.le.0) goto 10
C
         n=num
         if (hwefnd) n=nfound
         do 12 i=1,n
         if (locus(i,gene).le.KNOWN) then
           untyped(i)=.true.
         else
           xmale=(xlinkd .and. sex(i).eq.1)
           tot=tot+1
           if (xmale) totmal=totmal+1
           untyped(i)=.false.
           g1=getnam(locus(i,gene),numal,name)
           g2=getnam(locus(i,gen2),numal,name)
           call tabgen(g1,g2,xmale,numal,gcount)
         end if
   12    continue
         if (.not.hwefnd) then
           write(wrk2) num, nfound, 
     &                 (fa(i),mo(i),sex(i),untyped(i),i=1,num)
        end if
      goto 10
   20 continue

      ochisq=hwechi(numal,gcount,tot,totmal)
      df=numal
      if (xlinkd) df=1
      df=ngcount-df

      if (plevel.gt.0) then
        write(*,'(/3a/a/a)') 
     2   '  -------- Observed Genotypes at "',locnam,'" --------',
     3   '       Genotype          Observed    Expected  Deviate',
     4   '  ----------------------------------------------------'
        totall=2*tot-totmal
        invden=dfloat(tot-totmal)/dfloat(totall*totall)
        i=0
        do 25 j=1,numal
        do 25 k=1, j
          i=i+1
          call wrgtp(name(k),name(j),gtp,1)
          expf=dfloat(gcount(j,2)*gcount(k,2)) * invden
          if (j.ne.k) expf=expf+expf
          write(*,'(8x,a7,3x,i8,a,f5.3,a,f10.1,1x,f8.1)') 
     2      gtp, gcount(i,1), 
     3      ' (',dfloat(gcount(i,1))/dfloat(tot-totmal),') ',
     4      expf, ftdev(dfloat(gcount(i,1)),expf)
   25   continue
        if (totmal.gt.0) then
          invden=dfloat(totmal)/dfloat(totall)
          write(*,'(a)') 
     &      '     Male Haplotype      Observed    Expected  Deviate' 
          do 26 j=1,numal
            call wrgtp(name(j),0,gtp,1)
            expf=dfloat(gcount(j,2)) * invden
            write(*,'(8x,a7,3x,i8,a,f5.3,a,f10.1,1x,f8.1)') 
     2        gtp, gcount(j,3), 
     3        ' (',dfloat(gcount(j,3))/dfloat(totmal),') ',
     4        expf, ftdev(dfloat(gcount(j,3)),expf)
   26     continue
        end if
        write(*,'(a/10x,a,3x,i8,a)') 
     2   '  ----------------------------------------------------',
     3   'Total', tot,' (1.000)'
        if (xlinkd) then
          write(*,'(/a,i4,a,i4,a)')
     &    '       Number of genotypes =',tot,' (',totmal,' male)'
         else
          write(*,'(/a,i4)') '       Number of genotypes =',tot
         end if
        write(*,'(a,f6.1/a,i4/a,3x,f6.4)')
     3  '  Hardy-Weinberg LR chi-sq =',ochisq,
     4  'Nominal degrees of freedom =',df,
     5  '           Nominal P-value =',chip(ochisq,df)
        if (.not.xlinkd .and. numal.eq.2) then 
          call hwe2(gcount(1,1), gcount(2,1), gcount(3,1), expf, pval)
          write(*,'(a,3x,f6.4)')
     &  '             Exact P-value =', pval
        end if
      end if  
C
C MC sequential P-value for HWE
C
      if (.not.hwefnd .and. iter.gt.0 .and. ngcount.gt.1) then
        mchisq=0.0d0
        tailp=0
        vchisq=0.0d0
   49   continue
        if (it.eq.iter .or. tailp.eq.mincnt) goto 50
          it=it+1
          ngcount=0
          do 52 j=1,numal
          do 52 k=1, j
            ngcount=ngcount+1
            gcount(ngcount,1)=0
            gcount(ngcount,2)=0
            gcount(ngcount,3)=0
   52     continue
          rewind(wrk2)
   55     continue
            read(wrk2,end=70) num,nfound, 
     &                        (fa(i),mo(i),sex(i),untyped(i),i=1,num)
            if (xlinkd) then
              call xsimped(num,nfound,fa,mo,sex,cumfrq,set)
            else
              call simped(num,nfound,fa,mo,cumfrq,set)
            end if
            do 65 i=1,num
            if (.not.untyped(i)) then
              xmale=(xlinkd .and. sex(i).eq.1)
              call tabgen(set(i,1),set(i,2),xmale,numal,gcount)
            endif
   65       continue
          goto 55
   70     continue
          chisq=hwechi(numal,gcount,tot,totmal)
          call moment(it,chisq,mchisq,vchisq)
          if (chisq.gt.ochisq .or. (chisq.eq.ochisq .and.
     2        random().gt.0.5))  then
            tailp=tailp+1
          end if
          if (plevel.gt.1) then
            write(*,'(a,i4,a,f6.1)') 
     &        'Pseudosample ',it,': Chisq=',chisq
              if (plevel.gt.2) then
                write(*,*) 'Genos: ',(gcount(j,1), j=1, ngcount)
                write(*,*) 'Allel: ',(gcount(j,2), j=1, numal)
                if (xlinkd) then
                  write(*,*) 'Males: ',(gcount(j,3), j=1, numal)
                end if
              end if
          end if
          goto 49
   50   continue
        if (tailp.lt.mincnt) then
          tailp=tailp+1
          it=it+1
        end if
        vchisq=vchisq/dfloat(max(1,it-1))
        pval=dfloat(tailp)/dfloat(it)
      else
        tailp=0
        pval=1.0d0
      end if
      if (plevel.gt.0) then
        write(*,'(a,i4,a,i5,a,f6.4,a/a,f6.1,a,f6.1,a)')
     2    '      Equalled or exceeded by =',tailp,'/',it,
     3    ' simulated values (',pval,')',
     4    ' Mean (Var) simulated chi-sqs =',mchisq,' (',vchisq,')'
      else
        asyp=chip(ochisq,df)
        call phist(asyp,pval,histo)
        write(*,'(a10,2(1x,i6),1x,f10.1,2(1x,f6.4),1x,i6,2(1x,a))') 
     2    locnam, tot, ngcount, ochisq, chip(ochisq,df), pval, it, 
     3     'HWE',histo
      end if
      return
      end
C end-of-dohwe
C
C Increment counts of genotypes and alleles for HWE test
C Storage of allele counts in gcount(,2) indexed from 1..nall
C Genotypes indexed from 1..ngtp by gcount(,1).
C Males contribute to allele counts but not genotype counts
C
      subroutine tabgen(a1,a2,xmale,numal,gcount)
      integer MAXALL,MAXG
      parameter(MAXALL=2,MAXG=MAXALL*(MAXALL+1)/2)
      integer a1,a2,numal,gcount(MAXG,4)
      logical xmale
C allele counts
      if (xmale) then
        gcount(a1,2)=gcount(a1,2)+1
        gcount(a1,3)=gcount(a1,3)+1
      else
        gcount(a1,2)=gcount(a1,2)+1
        gcount(a2,2)=gcount(a2,2)+1
C genotype count
        idx=a2*(a2-1)/2+a1
        gcount(idx,1)=gcount(idx,1)+1
      end if
      return
      end
C end-of-tabgen
C
C Calculate HWE Chi-square for table entered on command line
C
      subroutine hwep(numal,gcount)
      integer MAXALL, MAXG
      parameter(MAXALL=2, MAXG=MAXALL*(MAXALL+1)/2)
C genotype counts
      integer gcount(MAXG,4), numal
      integer df,i,j,ngcount, tot, totmal
      double precision chisq, pa, pvalue
C functions
      double precision chip, hwechi
      ngcount=0
      tot=0
      totmal=0
      ngcount=numal*(numal+1)/2
      df=ngcount-numal
      do 1 i=1, ngcount
        gcount(i,2)=0
        gcount(i,3)=0
    1 continue
      write(*,'(i3,a,$)') ngcount,' genotype counts> '
      read(*,*,err=100) (gcount(i,1), i=1, ngcount)
      ngcount=0
      do 2 i=1, numal  
      do 2 j=1, i
        ngcount=ngcount+1
        gcount(i,2)=gcount(i,2)+gcount(ngcount,1)
        gcount(j,2)=gcount(j,2)+gcount(ngcount,1)
        tot=tot+gcount(ngcount,1)
    2 continue
      chisq=hwechi(numal,gcount,tot,totmal)
      ngcount=0
      do 5 i=1, numal  
        write(*,'(/f6.4,$)') 0.5d0*dfloat(gcount(i,2))/dfloat(tot)
        do 6 j=1, i
          ngcount=ngcount+1
          write(*,'(i5,$)') gcount(ngcount,1)
    6   continue
    5 continue
      write(*,'(//a,f10.1,a,i3,a,f6.4,a)') 
     &  'HWE X2 =',chisq,' (df=',ngcount,'; P=',chip(chisq,df),')'
      if (numal.eq.2) then
        call hwe2(gcount(1,1), gcount(2,1), gcount(3,1), pa, pvalue)
        write(*, '(a,f10.4)') 'Exact P=', pvalue
      end if 
      return
C input error
  100 write(*,'(a,i3,a)') 
     &    'ERROR: Expected ',ngcount,' genotype counts!'
      return
      end
C end-of-hwep
C
C Calculate Gibbs chi-square for HWE
C
      double precision function hwechi(numal,gcount,tot, totmal)
      integer MAXALL, MAXG
      double precision EPS
      parameter(EPS=1.0d-5, MAXALL=2, MAXG=MAXALL*(MAXALL+1)/2)
C allele frequencies and genotype counts
      integer gcount(MAXG,4), numal, tot, totmal
      integer i,j,k, totall
      double precision c,e,o 

      if (totmal.eq.0) then
        c=0.25d0/dfloat(tot)
      else
        totall=2*tot-totmal
        c=dfloat(tot-totmal)/dfloat(totall*totall)
      end if
      hwechi=0.0d0
      i=0
      do 30 j=1,numal
      do 30 k=1,j
        i=i+1
        o=dfloat(gcount(i,1))
        e=c*dfloat(gcount(j,2)*gcount(k,2))
        if (j.ne.k) e=e+e
        if (e.gt.EPS .and. o.gt.EPS) then
          hwechi=hwechi+o*log(o/e)
        end if
   30 continue
      if (totmal.ne.0) then
        c=dfloat(totmal)/dfloat(totall)
        do 40 j=1,numal
          o=dfloat(gcount(j,3))
          e=c*dfloat(gcount(j,2))
          if (e.gt.EPS .and. o.gt.EPS) then
            hwechi=hwechi+o*log(o/e)
          end if
   40   continue
      end if
      hwechi=hwechi+hwechi
      return
      end
C end-of-hwechi
C
C Calculate HWE test for diallelic autosomal marker
      subroutine hwe2(n11, n12, n22, pa, pvalue)
      integer n11, n12, n22
      integer n, n1, n2
      double precision pa, pvalue
      double precision d, obsd
C functions
      double precision dhwe2
      n=n11+n12+n22
      n1=2*n11+n12
      n2=2*n22+n12
      pa=dfloat(n1)/dfloat(n+n)
      sta=mod(n1, 2)
      fin=min(n1, n2)
      obsd=dhwe2(n11, n12, n22)
      pvalue=0.0d0
      do 10 i=sta, fin, 2
        d=dhwe2((n1-i)/2, i, (n2-i)/2)
        if (d.le.obsd) pvalue=pvalue+d
   10 continue
      return
      end
C end-of-hwe2
C
C hypergeometric for diallelic genotypes under HWE
      double precision function dhwe2(n11, n12, n22)
      integer n11, n12, n22
      integer n, n1, n2
      double precision lfact

      n=n11+n12+n22
      n1=2*n11+n12
      n2=2*n22+n12
      dhwe2=exp(log(2.0d0)*dfloat(n12) + lfact(n) - lfact(n11) 
     2          - lfact(n12) - lfact(n22) - lfact(2*n) + lfact(n1) 
     3          + lfact(n2))
      return
      end
C end-of-dhwe2
C
C marker homozygosity in all subjects or just probands -- codominant system
C
      subroutine dohomoz(wrk,wrk2,trait,locnam,gene,xlinkd,iter,
     2             mincnt,gt,thresh,pedigree,actset,num,nfound,
     3             id,fa,mo,sex,locus,numloc,
     4             numal,alfrq,cumfrq,untyped,set,plevel)
      integer KNOWN,MAXSIZ,MAXLOC,MAXALL,MISS
      parameter (KNOWN=0,MAXSIZ=20,MAXLOC=10000,MAXALL=2,MISS=-9999)
      integer gene,gt,iter,mincnt,numloc,plevel,trait,wrk,wrk2
      double precision thresh
      logical xlinkd
      character*10 locnam
C Pedigree structure
      character*10 pedigree
      integer actset,num, nfound
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ), set(MAXSIZ,2)
      integer sex(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)
      logical last, untyped(MAXSIZ)
C allele frequencies structure
      integer numal
      double precision alfrq(MAXALL), cumfrq(MAXALL)
C 
C homozygosity analysis -- limited to cases
      integer ehomoz, homoz, nca
      integer aff(MAXSIZ),gen2,i,it,tailp
      character*3 histo
      double precision den, ef, expp, fcoeff, obs, pval
C functions
      real random
      double precision binz, isaff

      expp=0.0d0
      gen2=gene+1
      homoz=0
      it=0
      nca=0
      do 5 i=1,numal
        expp=expp+alfrq(i)*alfrq(i)
    5 continue
      last=.false.
      rewind(wrk)
   10 continue
       call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &            numloc, last)
       if (last) goto 20

       if (actset.le.0) goto 10
C

        if (trait.eq.MISS) then
          do 13 i=1,num
            aff(i)=2
            if (xlinkd .and. sex(i).ne.2) aff(i)=MISS
   13     continue
        else
          do 14 i=1,num
            aff(i)=int(isaff(locus(i,trait),thresh,gt))
            if (xlinkd .and. sex(i).ne.2) aff(i)=MISS
   14     continue
        end if
        do 15 i=1,num
          untyped(i)=.false.
          set(i,1)=int(locus(i,gene))
          set(i,2)=int(locus(i,gen2))
          if (set(i,1).lt.KNOWN) then
            untyped(i)=.true.
          elseif (aff(i).eq.2) then
            nca=nca+1
            if (set(i,1).eq.set(i,2)) homoz=homoz+1 
          endif
   15   continue
        write(wrk2) num,nfound,
     &      (aff(i),fa(i),mo(i),untyped(i),i=1,num)
      goto 10
   20 continue
        
      if (nca.gt.0) then
        den=1.0d0/dfloat(nca)
        obs=den*dfloat(homoz)
        fcoeff=(obs-expp)/(1.0d0-expp)
      else
        obs=0.0d0
        fcoeff=0.0d0
      end if
C
C if iter=0 or nca=0, Monte-Carlo procedure superfluous
C
      if (iter.gt.0 .and. nca.gt.0) then
C
C Sequential Monte-Carlo P-value after Besag & Clifford Biometrika 1991
C P= tailp/it if tailp=mincnt or (tailp+1)/(it+1) if tailp<mincnt && it=iter
C
        tailp=0
   49   continue
        if (it.eq.iter .or. tailp.eq.mincnt) goto 50
          it=it+1
          ehomoz=0
          rewind(wrk2)
   55     continue
            read(wrk2,end=70) num,nfound,
     &        (aff(i),fa(i),mo(i),untyped(i),i=1,num)
            if (xlinkd) then
              call xsimped(num,nfound,fa,mo,sex,cumfrq,set)
            else
              call simped(num,nfound,fa,mo,cumfrq,set)
            end if
            do 65 i=1,num
            if (.not.untyped(i) .and. aff(i).eq.2 .and.
     &          set(i,1).eq.set(i,2)) ehomoz=ehomoz+1 
   65       continue
          goto 55
   70     continue
          
          ef=abs((den*dfloat(ehomoz)-expp)/(1.0d0-expp))

          if (ef.gt.abs(fcoeff) .or. (ehomoz.eq.homoz .and.
     2        random().gt.0.5))  then
            tailp=tailp+1
          end if
          if (plevel.gt.1) then
            write(*,'(/a,i4,a,i5)') 
     &        'Pseudosample ',it,': No. homoz=',ehomoz
          end if
          goto 49
   50   continue
        if (tailp.lt.mincnt) then
          tailp=tailp+1
          it=it+1
        end if
        pval=dfloat(tailp)/dfloat(it)
      else
        pval=1.0d0
      end if
      call phist(pval,pval,histo)
      write(*,'(a10,1x,i4,3(1x,f6.4),1x,f6.1,1x,f6.4,1x,i6,2(1x,a))')
     2  locnam, nca, obs, expp, fcoeff, binz(homoz,nca,expp), 
     3   pval, it, 'HOM', histo
      return
      end
C end-of-dohomoz
C
C
C find allele frequency
C
      double precision function getfreq(all,numal,name,alfrq)
      integer MAXALL
      parameter (MAXALL=2)
      integer numal, name(MAXALL)
      double precision alfrq(MAXALL)
      integer all
      integer i, iall
      iall=abs(all)
      call match(iall,numal,name,i)
      if (i.ne.0) then
        getfreq=alfrq(i)
      else
        write(*,'(a/a,i3,a)') 
     &    'Error in routine getfreq','Looking for ',iall,' in:'
        do 99 i=1,numal
   99     write(*,*) name(i), alfrq(i)
        getfreq=0.0d0
      end if
      return
      end
C end-of-getfreq
C
C find index for allele
C
      integer function getnam(rall,numal,name)
      integer MAXALL,MISS
      parameter (MAXALL=2, MISS=-9999)
      integer numal, name(MAXALL)
      double precision rall
      integer i,iall

      getnam=MISS
      if (rall.eq.MISS) return

      iall=int(abs(rall))
      call match(iall,numal,name,i)
      if (i.ne.0) then
        getnam=i
      else
        write(*,'(a/a,i3,a)') 
     &    'Error in routine getnam', 'Looking for ',iall,' in:'
        do 99 i=1,numal
          write(*,*) name(i)
   99   continue
      end if
      return
      end
C end-of-getnam
C
C produce cumulative allele frequencies
C
      subroutine accum(numal,alfrq,cumfrq)
      integer MAXALL
      parameter (MAXALL=2)
      integer numal
      double precision alfrq(MAXALL), cumfrq(MAXALL)
      cumfrq(1)=alfrq(1)
      cumfrq(numal)=1.0d0
      do 10 i=2,numal-1
         cumfrq(i)=cumfrq(i-1)+alfrq(i)
   10 continue
      return
      end
C end-of-accum
C
C produce genotype frequencies for Metropolis algorithm
C
      subroutine genot(numal,alfrq,ngtp,gfrq)
      integer MAXALL, MAXG
      parameter(MAXALL=2, MAXG=MAXALL*(MAXALL+1)/2)
C allele frequencies structure
      integer numal, ngtp
      double precision alfrq(MAXALL), gfrq(MAXG)
C local variables
      integer i

      ngtp=0
      do 5 i=1,numal
      do 5 j=1,i
        ngtp=ngtp+1
        gfrq(ngtp)=alfrq(i)*alfrq(j)
        if (i.ne.j) gfrq(ngtp)=gfrq(ngtp)+gfrq(ngtp)
    5 continue
      return
      end
C end-of-genot
C
C Do ibs sharing in parents as per Bishop 1990
C
      subroutine domar(wrk,gene,pedigree,actset,num,nfound, 
     2                 id,fa,mo,sex,locus,numloc,
     3                 numal,name,alfrq,plevel)
      integer KNOWN,MAXALL,MAXSIZ,MAXLOC,MISS
      parameter (KNOWN=0,MAXALL=2,MAXSIZ=20,MAXLOC=10000,MISS=-9999)
      integer gene,actset,num,numloc,plevel,wrk
C Pedigree structure
      character*10 pedigree
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ)
      integer sex(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)
C allele frequencies structure
      integer numal, name(MAXALL)
      double precision alfrq(MAXALL)
C calculate expected ibs statistics for marker
      double precision p, p2, p4, pp, pq, pq2, q, f(3)
C 2 df chi-square
      integer tab(3)
      double precision chisq, ef, expn, mu, obsn
C
      integer currf, currm, g1,g2,g3,g4,gen2,i,ibd,j,nmat
      double precision zibd
      logical last
C functions
      double precision chip

      if (numal.lt.2) return

      mu=0.0d0
      do 1 i=1,3
        tab(i)=0
    1 continue
      gen2=gene+1

C Calculate expected values for ibs statistic
      p2=0.0d0
      p4=0.0d0
      pp=0.0d0
      pq2=0.0d0
      do 3 i=1,numal
        p=alfrq(i)
        q=1.0d0-p
        p=p*p
        q=q*q
        pq2=pq2+p*q
        p4=p4+p*p
        do 3 j=i+1,numal
          p=alfrq(i)
          q=alfrq(j)
          p2=p2+p*p*q*q
          pq=1.0d0-p-q
          pp=pp+p*q*pq*pq
    3 continue
      f(1)=pq2+pp+pp
      f(3)=4.0d0*p2+p4
      f(2)=1.0d0-f(3)-f(1)
      ef=f(3)+0.5d0*f(2)
C
      rewind(wrk)
      last=.false.
    5 continue
       call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &            numloc, last)
       if (last) goto 20

        if (actset.le.0) goto 5
C 
         currf=MISS
         currm=MISS
         do 13 i=nfound+1,num
           g1=int(locus(fa(i),gene))
           g3=int(locus(mo(i),gene))
           if ((fa(i).ne.currf .or. mo(i).ne.currm) .and.
     &         g1.gt.KNOWN .and. g3.gt.KNOWN) then
             currf=fa(i)
             currm=mo(i)
             g2=int(locus(fa(i),gen2))
             g4=int(locus(mo(i),gen2))
             call share(g1,g2,g3,g4,zibd)
             ibd=int(2.0d0*zibd)+1
             tab(ibd)=tab(ibd)+1
           end if
   13    continue
      goto 5 
   20 continue
      nmat=tab(3)+tab(2)+tab(1)
      if (nmat.gt.0) mu=0.5d0*dfloat(2*tab(3)+tab(2))/dfloat(nmat)
      write(*,'(/a,i4/a,3x,f6.4,a,f6.4,a)')
     2   '   Number of typed matings =',nmat,
     3   ' Parental mean IBS sharing =',  mu, ' (Expected=',ef,')'
      if (nmat.gt.0) then
        chisq=0.0d0
        do 25 i=1,3
          expn=dfloat(nmat)*f(i)
          obsn=dfloat(tab(i))
          if (obsn.gt.0.001d0 .and. expn.gt.0.001d0) then
            chisq=chisq+obsn*log(obsn/expn) 
          end if
   25   continue
        chisq=chisq+chisq
        write(*,'(a,f6.1,a,f6.4,a)')
     &   ' Sharing Chi-square (2 df) =',chisq,' (P=',chip(chisq,2),')' 
      end if
      if (plevel.gt.0) then
        q=1.0d0/dfloat(max(nmat,1))
        write(*,'(2(/21x,a),2(/a,3f8.1))')
     2    'IBS Sharing','2/2     1/2     0/2', 'Observed sharing',
     3    q*dfloat(tab(3)),q*dfloat(tab(2)),q*dfloat(tab(1)),
     4    'Expected sharing', f(3),f(2),f(1) 
      end if
      return
      end
C end-of-domar
C
C Tabulate maternal v. paternal genotypes
C
      subroutine margen(wrk,gene,xlinkd,pedigree,actset,num,nfound, 
     2                 id,fa,mo,sex,locus,numloc,rows,cols,tble,e,
     3                 iter, numal,name,alfrq,plevel)
      integer KNOWN,MAXALL,MAXSIZ,MAXLOC,MISS
      parameter (KNOWN=0,MAXALL=2,MAXSIZ=20,MAXLOC=10000,MISS=-9999)
      integer gene,actset,num,numloc,plevel,wrk
      logical xlinkd
C Pedigree structure
      character*10 pedigree
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ)
      integer sex(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)
C allele frequencies structure
      integer numal, name(MAXALL)
      double precision alfrq(MAXALL)
C table
      integer nr, nc
      integer cols(*), rows(*), tble(*)
      double precision e(*)
C
      integer currf, currm, g1,g2,g3,g4,gen2,i,j,k,nmat,pos 
      logical last
      character*7 gtp
C functions
      integer clcpos, getnam

      if (numal.lt.2) return

      gen2=gene+1
      nc=numal*(numal+1)/2
      nr=nc
      nmat=0
      if (xlinkd) nr=numal
      do 1 i=1, nc*nr
        tble(i)=0
    1 continue
C
      rewind(wrk)
      last=.false.
    5 continue
       call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &            numloc, last)
       if (last) goto 20

        if (actset.le.0) goto 5
C 
         currf=MISS
         currm=MISS
         do 13 i=nfound+1,num
         if ((fa(i).ne.currf .or. mo(i).ne.currm) .and.
     2        locus(fa(i),gene).gt.KNOWN .and.
     3        locus(mo(i),gene).gt.KNOWN) then
             nmat=nmat+1
             currf=fa(i)
             currm=mo(i)
             g1=getnam(locus(fa(i),gene),numal,name)
             g2=getnam(locus(fa(i),gen2),numal,name)
             g3=getnam(locus(mo(i),gene),numal,name)
             g4=getnam(locus(mo(i),gen2),numal,name)
             if (xlinkd) g1=1
             pos=nc*(clcpos(g1,g2)-1)+clcpos(g3,g4)
             tble(pos)=tble(pos)+1
         end if
   13    continue
      goto 5 
   20 continue

      if (nmat.gt.0) then
        write(*,'(/12x,a/a,$)') 'Maternal Genotype','Pat Gtp  '
        do 25 i=1, numal
        do 25 j=1, i
          call wrgtp(name(j),name(i),gtp,1)
          write(*,'(1x,a7,$)') gtp
   25   continue
        write(*,*)
        pos=0
        if (xlinkd) then
          do 30 i=1, nr
            call wrgtp(name(i),0,gtp,1)
            write(*,'(a7,(10i8):)') gtp, (tble(pos+j), j=1, nc)
            pos=pos+nc
   30     continue
        else
          do 35 i=1, numal
          do 35 j=1, i
              call wrgtp(name(j),name(i),gtp,1)
            write(*,'(a7,(10i8):)') gtp, (tble(pos+k), k=1, nc)
            pos=pos+nc
   35     continue
        end if
        call rctest(nr, nc, tble, e, rows, cols, iter)
      else
        write(*,'(a)') 'No useful matings'
      end if
      return
      end
C end-of-margen
C
C Check if multilocus ibs sharing for pairs of sibs is consistent 
C with purported relationship.  Again as per Bishop et al 1990
C
      subroutine ckibs(wrk,wrk2,pedigree,actset,num,nfound,id,fa,mo,sex,
     &              locus, numloc,nloci,loctyp,locpos,numal,name,alfrq)
      integer MAXALL,MAXSIZ,MAXLOC,KNOWN
      parameter (MAXALL=2,MAXSIZ=20,MAXLOC=10000,KNOWN=0)

      integer wrk,wrk2
C Pedigree structure
      integer actset,num, nfound
      character*10 pedigree
      character*10 id(MAXSIZ) 
      integer fa(MAXSIZ), mo(MAXSIZ), sex(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)
      integer numloc
C
C locus structure
      integer nloci
      integer loctyp(MAXLOC),locpos(MAXLOC)
C allele frequencies structure
      integer numal, name(MAXALL)
      double precision alfrq(MAXALL)
C expected ibs statistics for each marker
      double precision e2(MAXLOC,2)
      double precision p, p2, p4
C
      integer den,g1,g2,g3,g4,gene,gen2,i,j,k,npairs,sib
      double precision ex, mibs, mean, var, z
      logical last, samefa, samemo
C
      mean=0.0d0
      npairs=0
      var=0.0d0
      pedigree=' '
      last=.false.
      rewind(wrk)
      rewind(wrk2)
C Calculate expected values for ibs=2 statistic
      do 2 k=1,nloci
      if (loctyp(k).eq.1) then
        read(wrk2) numal,(name(i),i=1,numal),(alfrq(i),i=1,numal)
        p2=0.0d0
        p4=0.0d0
        do 3 i=1,numal
          p=alfrq(i)
          p=p*p
          p2=p2+p
          p4=p4+p*p
    3   continue
        e2(k,1)=0.25d0*(1.0d0+2.0d0*p2*(1.0d0+p2)-p4)
        e2(k,2)=0.5d0*(p2*(1.0d0+p2+p2)-p4)
      end if
    2 continue
C
      write(*,'(4(/a))')
     2  '------------------------------------------------------------',
     3  'Estimated Prob(IBS=2) over all markers for sib-pairs',
     4  '------------------------------------------------------------',
     5  'Pedigree    Pers-1   Pers-2    ibs=2     Exp     Dev   Mrkrs'
    5 continue
       call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &            numloc, last)
       if (last) goto 20

        if (actset.le.0) goto 5
C
C only iterate nonfounders
        do 10 i=nfound+1,num-1
          do 15 j=i+1,num
            samefa=(fa(i).eq.fa(j))
            samemo=(mo(i).eq.mo(j))
C
C Share a parent
C
            if (samefa.or.samemo) then
              den=0
              ex=0.0d0
              mibs=0.0d0
              if (samefa .and. samemo) then
                sib=1
              else
                sib=2
              end if
              do 30 k=1,nloci
              if (loctyp(k).eq.1) then
                gene=locpos(k)
                g1=int(locus(i,gene))
                g3=int(locus(j,gene))
                if (g1.gt.KNOWN .and. g3.gt.KNOWN) then
                  den=den+1
                  gen2=gene+1
                  g2=int(locus(i,gen2))
                  g4=int(locus(j,gen2))
                  ex=ex+e2(k,sib)
                  if ((g1.eq.g3 .and. g2.eq.g4).or.
     &                (g1.eq.g4 .and. g2.eq.g3)) then
                    mibs=mibs+1.0d0
                  end if
                end if
              end if
   30         continue
              if (den.gt.0) then
                npairs=npairs+1
                z=sqrt(mibs)+sqrt(mibs+1)-sqrt(4*ex+1)
                mibs=mibs/dfloat(den)
                ex=ex/dfloat(den)
                call moment(npairs,mibs,mean,var)
                write(*,'(a,2(a10,1x),2(2x,f6.4),1x,f7.2,2x,i3)') 
     &             pedigree, id(i), id(j), mibs, ex, z, den
              end if
            end if
   15     continue
   10   continue
      goto 5 
   20 continue
      if (npairs.gt.1) var=var/(npairs-1)
      write(*,'(/a,f6.4,a,f6.4,a/)') 
     &  'Grand mean P(ibs=2)=',mean,' (SD=',dsqrt(var),')'
      return
      end
C end-of-ckibs
C
C Calculate observed and expected mean IBS for all pairs of relatives
C Expected distribution simulated using given map
C
      subroutine allibs(wrk,wrk2,iter,nloci,loc,loctyp,locpos,
     2             map,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     3             numloc, hset,ibscount,dev,numal,cumfrq,typ,plevel)
      integer IBDSIZ,KNOWN,MAXALL,MAXHAP,MAXIBD,MAXSIZ,MAXLOC,MISS
      parameter(KNOWN=0, MAXALL=2, MAXSIZ=20, MAXLOC=10000,
     2          MAXHAP=MAXLOC/2, MISS=-9999,
     3          MAXIBD=20, IBDSIZ=MAXIBD*(MAXIBD+1)/2)
      integer iter,plevel,typ,wrk,wrk2
C
C Pedigree structure
      character*10 pedigree
      integer actset,num, nfound
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ), sex(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)
      integer numloc
C
C Locus structure 
      integer nloci
      character*20 loc(MAXLOC)
      integer loctyp(MAXLOC),locpos(MAXLOC)
C
C position of locus on sex-averaged linkage map
C
      real map(MAXLOC)
C
C allele and genotype frequencies within entire sample for given locus 
C
      integer numal
      double precision cumfrq(MAXALL)
C
C Storage space for haplotypes
      integer hset(MAXSIZ,MAXHAP,2)
C
C mean ibs sharing for all relative pairs
C
      double precision ibscount(IBDSIZ), dev(IBDSIZ)
C
C Marker list and intermarker distances
      integer nmark, mark(MAXHAP)  
      real recdist(MAXHAP)
C 
      integer gene, gen2, i, j, n, npairs, pos, score
      character*10 fid, mid
      real dist
      double precision crit, den, maxdev
      logical last 
C functions
      real invmap

      dist=0.0
      nmark=0
      do 1 j=1,nloci
      if (loctyp(j).eq.1) then
        nmark=nmark+1
        mark(nmark)=j
        if (map(j).ne.MISS .and. map(j).ge.dist) then
          recdist(nmark)=invmap(map(j)-dist,1)
          dist=map(j)
        else
          recdist(nmark)=0.50
          dist=-1000.0
        end if
        if (nmark.eq.MAXHAP) goto 2
      end if
    1 continue
    2 continue

      den=1.0d0/(dfloat(max(1,iter)))

      write(*,'(4(/a))')
     2  '------------------------------------------------------------',
     3  'IBS sharing outlier pairs contributed by each person',
     4  '------------------------------------------------------------',
     5  'Pedigree   Person   Father   Mother   Max Dev  Outlier Pairs'
      rewind(wrk)
   10 continue
       call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &            numloc, last)
       if (last) goto 20

        if (actset.le.0 .or. num.gt.MAXIBD) goto 10

        crit=0.95d0
        do 25 i=1,num
        do 25 j=1,nmark
          gene=locpos(mark(j))
          gen2=gene+1
          if (locus(i,gene).gt.KNOWN) then
            hset(i,j,1)=int(locus(i,gene))
            hset(i,j,2)=int(locus(i,gen2))
          else
            hset(i,j,1)=MISS
            hset(i,j,2)=MISS
          end if
   25   continue

        npairs=num*(num-1)/2
        do 90 i=1,npairs
          ibscount(i)=0.0d0
          dev(i)=0.0d0
   90   continue
        
        call allshare(num,ibscount,nmark,hset)
        
        do 100 it=1,iter
          if (plevel.gt.2) write(*,'(/a,i5)') pedigree,it
          call simhap(wrk2,nmark,mark,recdist,numal,cumfrq,
     &                num,nfound,fa,mo,hset,plevel) 
          call expshare(num,ibscount,dev,nmark,hset)
  100   continue
        
        do 105 pos=1,npairs
          dev(pos)=den*dev(pos)
  105   continue
        
        if (typ.eq.1) then
          do 110 i=1,num 
            n=0
            score=0
            maxdev=0.0d0
            pos=(i-2)*(i-1)/2
            do 115 j=1,i-1
              pos=pos+1
              if (ibscount(pos).ne.MISS) then
                n=n+1
                if (abs(dev(pos)).gt.abs(maxdev)) maxdev=dev(pos)
                if (abs(dev(pos)).ge.crit) score=score+1
              end if
  115       continue
            pos=1+(i-1)*i/2
            do 116 j=i+1,num 
              pos=pos+j-2
              if (ibscount(pos).ne.MISS) then
                n=n+1
                if (abs(dev(pos)).gt.abs(maxdev)) maxdev=dev(pos)
                if (abs(dev(pos)).ge.crit) score=score+1
              end if
  116       continue
            if (score.gt.0) then
              fid='x'
              mid='x'
              if (fa(i).ne.MISS) fid=id(fa(i))
              if (mo(i).ne.MISS) mid=id(mo(i))
              write(*,'(a,3(1x,a10),1x,f7.2,1x,i5,a1,i5,1x,5a:)') 
     2         pedigree,id(i),fid,mid,maxdev,score,'/',n,
     3         ('*',j=1,5*score/n)
          end if
  110     continue
        end if
        if (typ.eq.2 .or. plevel.gt.1) then
          if (plevel.gt.1) crit=0.0d0
          write(*,'(//a//a)')
     2      'Estimated Sum(IBS) over all markers for relative pairs',
     3      'Pedigree   Pers-1   Pers-2  Sum(IBS)     Dev'
          pos=0
          do 120 i=2,num 
          do 120 j=1,i-1
            pos=pos+1
            if (ibscount(pos).ne.MISS .and. abs(dev(pos)).ge.crit) then
              write(*,'(a,2(1x,a10),2(1x,f7.2))') 
     &         pedigree, id(i), id(j), ibscount(pos),dev(pos)
            end if
  120     continue
          write(*,*)
        end if

      goto 10
   20 continue
      return
      end
C end-of-allibs 
C
C Simulate haplotypes for all family members for given map
C
      subroutine simhap(wrk2,nmark,mark,recdist,numal,cumfrq,
     &                  num,nfound,fa,mo,hset,plevel) 
      integer KNOWN,MAXALL,MAXHAP,MAXSIZ,MAXLOC,MISS
      parameter(KNOWN=0,MAXALL=2, MAXSIZ=20,MAXLOC=10000,
     &          MAXHAP=MAXLOC/2,MISS=-9999)
      integer plevel, wrk2
C
C Pedigree structure
      integer num, nfound
      integer fa(MAXSIZ), mo(MAXSIZ)
C Marker list and intermarker distances
      integer nmark, mark(MAXHAP)  
      real recdist(MAXHAP)
C
C allele and genotype frequencies within entire sample for given locus 
C
      integer numal
      double precision cumfrq(MAXALL)
C
C Storage space for haplotypes
      integer hset(MAXSIZ,MAXHAP,2)

      integer i,ismiss,j
      logical fin, done(MAXSIZ)
C
C Initialize founders
C
      rewind(wrk2)
      do 30 j=1,nmark 
        read(wrk2) numal,(cumfrq(i),i=1,numal)
        do 31 i=1,nfound
          ismiss=sign(1,hset(i,j,1))
          call found(cumfrq,hset(i,j,1))
          hset(i,j,1)=ismiss*hset(i,j,1)
          call found(cumfrq,hset(i,j,2))
          hset(i,j,2)=ismiss*hset(i,j,2)
   31   continue
   30 continue
      do 32 i=1,nfound
        done(i)=.true.
   32 continue
      do 33 i=nfound+1,num
        done(i)=.false.
   33 continue
C
C then gene drop the nonfounders genotypes
C
   40 continue
        fin=.true.
        do 50 i=nfound+1,num
        if (.not.done(i)) then
          if (done(fa(i)) .and. done(mo(i))) then
            call genof6(i,fa(i),mo(i),nmark,hset,recdist)
            done(i)=.true.
          else
            fin=.false.
          end if
        end if
   50   continue
      if (.not.fin) go to 40

      if (plevel.gt.2) then
        do 100 i=1,num
          write(*,'(i4,100i3:)') i,(hset(i,j,1),j=1,nmark)
          write(*,'(4x,100i3:)')   (hset(i,j,2),j=1,nmark)
  100   continue
      end if
      return
      end
C end-of-simhap
C
C transmit haplotypes from each parent to child, including possibility
C of recombination within haplotype
C 
      subroutine genof6(idx,fa,mo,nmark,hset,recdist)
      integer MAXLOC, MAXSIZ, MAXHAP
      parameter(MAXLOC=10000, MAXSIZ=20, MAXHAP=MAXLOC/2)
      integer idx,fa,mo,nmark,hset(MAXSIZ,MAXHAP,2)
      real recdist(MAXHAP)
C local variables
      integer fagranp,mogranp,ismiss,j
C functions
      integer irandom
      real random
C
      fagranp=irandom(1,2)
      mogranp=irandom(1,2)
      do 50 j=1,nmark
        ismiss=sign(1,hset(idx,j,1))
        if (recdist(j).gt.random()) fagranp=3-fagranp
        if (recdist(j).gt.random()) mogranp=3-mogranp
        hset(idx,j,1)=ismiss*abs(hset(fa,j,fagranp))
        hset(idx,j,2)=ismiss*abs(hset(mo,j,mogranp))
   50 continue
      return
      end
C end-of-genof6
C
C Calculate sum of ibs statistics for all markers
C
      subroutine allshare(num,ibscount,nmark,hset)
      integer IBDSIZ, KNOWN, MAXHAP, MAXIBD, MAXSIZ, MAXLOC, MISS
      parameter(KNOWN=0,MAXSIZ=20,MAXLOC=10000, MAXHAP=MAXLOC/2,
     &          MISS=-9999 , MAXIBD=20, IBDSIZ=MAXIBD*(MAXIBD+1)/2)
      integer nmark, num
C Storage space for haplotypes
      integer hset(MAXSIZ,MAXHAP,2)
C mean ibs sharing for all relative pairs
      double precision ibscount(IBDSIZ)
C local variables
      integer i,j,k,n,pos
      double precision tibs, zibs

      pos=0
      do 10 i=2,num
      do 10 j=1,i-1
        pos=pos+1
        n=0
        tibs=0.0d0
        do 20 k=1,nmark
        if (hset(i,k,1).gt.KNOWN .and. hset(j,k,1).gt.KNOWN) then
          n=n+1
          call share(hset(i,k,1),hset(i,k,2),
     &               hset(j,k,1),hset(j,k,2),zibs)
          tibs=tibs+zibs+zibs
        end if
   20   continue
        if (n.gt.0) then
          ibscount(pos)=tibs
        else
          ibscount(pos)=MISS
        end if
   10 continue
      return
      end
C end-of-allshare
C
C Accumulate null-hypothesis simulated ibs statistics for all markers
C
      subroutine expshare(num,ibscount,dev,nmark,hset)
      integer IBDSIZ, KNOWN, MAXHAP, MAXIBD, MAXSIZ, MAXLOC, MISS
      parameter(KNOWN=0,MAXSIZ=20,MAXLOC=10000, MAXHAP=MAXLOC/2,
     &          MISS=-9999 , MAXIBD=20, IBDSIZ=MAXIBD*(MAXIBD+1)/2)
      integer nmark, num
C Storage space for haplotypes
      integer hset(MAXSIZ,MAXHAP,2)
C comparison to null hypothesis ibs sharing for all relative pairs
      double precision ibscount(IBDSIZ), dev(IBDSIZ)
C local variables
      integer i,j,k,pos
      double precision tibs, zibs

      pos=0
      do 10 i=2,num
      do 10 j=1,i-1
        tibs=0.0d0
        pos=pos+1
        if (ibscount(pos).ne.MISS) then
          do 20 k=1,nmark
          if (hset(i,k,1).gt.KNOWN .and. hset(j,k,1).gt.KNOWN) then
            call share(hset(i,k,1),hset(i,k,2),
     &                 hset(j,k,1),hset(j,k,2),zibs)
            tibs=tibs+zibs+zibs
          end if
   20     continue
          if (tibs.gt.ibscount(pos) .or. 
     &        (tibs.eq.ibscount(pos) .and. random().gt.0.5)) then
            dev(pos)=dev(pos)+1.0d0
          else
            dev(pos)=dev(pos)-1.0d0
          end if
        end if
   10 continue
      return
      end
C end-of-expshare
C
C Do LD analysis for unphased data
C
      subroutine ldp(numal,name1,numal2,name2,scatter,counts,full,ex,
     &               oldex, model,offset,x,r,b,cov,plevel)

      integer MAXALL, MAXSIZ, MAXIBD, MAXTER, MAXCOV
      parameter(MAXALL=2, MAXIBD=20, MAXSIZ=20,
     &          MAXTER=MAXIBD/2, MAXCOV=MAXTER*(MAXTER+1)/2)
      integer numal, numal2, plevel
      integer name1(MAXALL), name2(MAXALL)

      integer scatter(*)
      real counts(*), ex(*), full(*), model(*), offset(*), oldex(*)
C
C regression work arrays
      double precision x(MAXTER),r(MAXCOV),b(MAXTER),cov(MAXCOV)
C local variables
      integer ncells, nhcat, ple 
      character*10 loc1, loc2
C  
      loc1='Locus 1'
      loc2='Locus 2'
      ple=max(1, plevel)
      ncells=numal*(numal+1)*numal2*(numal2+1)/4 
      nhcat=numal*numal*numal2*numal2
      call ascend(numal, name1)
      call ascend(numal2, name2)
      write(*,'(i3,a,$)') ncells,' genotype counts> '
      read(*,*,err=100) (counts(i), i=1, ncells)

      call ld2(loc1,numal,name1,loc2,numal2,name2,1,
     2         ncells,nhcat,0,scatter,counts,full,
     3         ex,oldex,model,offset,x,r,b,cov,ple)
      return
C input error
  100 write(*,'(a,i3,a)') 
     &    'ERROR: Expected ',ncells,' genotype counts!'
      return
      end
C end-of-ldp
C
C Map haplotypes to genotypes 1=phase unknown 2=phase known
C
      subroutine haptogen(numal, numal2, scatter, typ, xlinkd)
      integer numal, numal2, scatter(*), typ  
      logical xlinkd
      integer i1, i2, j1, j2, n, ng, pos
C functions
      integer clcpos
      
      ng=0
      pos=0
      if (typ.eq.1 .or. typ.eq.3) then
        n=numal2*(numal2+1)/2
        do 10 i1=1, numal
        do 10 j1=1, numal2
        do 10 i2=1, numal
        do 10 j2=1, numal2
          pos=pos+1
          scatter(pos)=n*(clcpos(i1,i2)-1)+clcpos(j1,j2)
   10   continue
        ng=n*numal*(numal+1)/2
      end if
      if (typ.eq.2 .or. typ.eq.3) then
        n=numal*numal2
        do 20 i1=1, n
        do 20 j1=1, n
          pos=pos+1
          scatter(pos)=ng+clcpos(i1,j1)
   20   continue
        ng=ng+n*(n+1)/2
      end if
      if (xlinkd) then
        do 30 i1=1, numal
        do 30 j1=1, numal2
          pos=pos+1
          scatter(pos)=ng+numal*(i1-1)+j1
   30   continue
      end if
      return
      end
C end-of-haptogen
C
C Double HWE
C
      subroutine twohwe(numal, numal2, nfull, totpars, model, typ,
     &                  xlinkd)
      integer nfull, numal, numal2, totpars, typ 
      logical xlinkd
      real  model(*)
      integer  bloc, i,j, i1, i2, j1, j2, mpos, nhp

      bloc=1
      nhp=numal+numal2
      totpars=nhp
      if (typ.eq.3) then
        totpars=totpars+1
        bloc=bloc+1
      end if
      if (xlinkd) then
        totpars=totpars+1
      end if
      do 1 i=1, nfull*totpars
        model(i)=0.0
    1 continue
      
      mpos=0
      do 20 i=1, bloc
        do 10 i1=1, numal
        do 10 j1=1, numal2
        do 10 i2=1, numal
        do 10 j2=1, numal2
          model(mpos+i1)=model(mpos+i1)+1.0
          model(mpos+i2)=model(mpos+i2)+1.0
          model(mpos+numal+j1)=model(mpos+numal+j1)+1.0
          model(mpos+numal+j2)=model(mpos+numal+j2)+1.0
          if (i.eq.2) model(mpos+nhp+1)=model(mpos+nhp+1)+1.0
          mpos=mpos+totpars
   10   continue
   20 continue
      if (xlinkd) then
        do 30 i=1, numal
        do 30 j=1, numal2
          model(mpos+i)=model(mpos+i)+1.0
          model(mpos+numal+j)=model(mpos+numal+j)+1.0
          model(mpos+totpars)=model(mpos+totpars)+1.0
          mpos=mpos+totpars
   30   continue
      end if
      return
      end
C end-of-twohwe  
C
C Two locus linkage disequilibrium: autosomal or X-linked loci
C
      subroutine twold(wrk,zrec,gene1,loc1,ltyp1,gene2,loc2,ltyp2,iter,
     2             pedigree,actset,num,nfound,id,fa,mo,sex,locus,numloc,
     3             numal,name,alfrq,numal2,name2,alfrq2,
     4             eligible,ngcount,gcount,key,gfrq,plevel)
      integer MAXALL, MAXG, MAXSIZ, MAXLOC, KNOWN
      parameter(MAXALL=2, MAXG=MAXALL*(MAXALL+1)/2, 
     &          MAXSIZ=20, MAXLOC=10000, KNOWN=0)
      integer gene1,gene2,iter,ltyp1,ltyp2,plevel,wrk,zrec
      character*10 loc1, loc2
C pedigree structure
      character*10 pedigree
      integer sex(MAXSIZ)
      integer actset,num, nfound
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)
C
C allele frequencies within entire sample for given locus 
C
      integer numal, name(MAXALL)
      double precision alfrq(MAXALL)
      integer numal2, name2(MAXALL)
      double precision alfrq2(MAXALL)
C
C Typed founders or nonfounders who have untyped parents
      logical eligible(MAXSIZ)
C
C Genotype counts: allele1,allele2, number transmitted, number not trans
      integer ngcount,gcount(MAXG,4)
      integer key(2*MAXSIZ)
      double precision gfrq(MAXG)
C
      integer tr1,tr2,nt1,nt2,tr3,tr4,nt3,nt4
      logical last, xmale
      integer cutoff, df, gene12, gene22, i, idx, j, nhap, ntyped,
     &        tothap  
      character*3 histo
      character*5 rsquare
      character*7 gtp
      double precision asyp, bigd, chisq, d, dprime, e, hedrick, 
     &                 p1, p2, pval, tot
C functions 
      logical useld
      double precision chip, ftdev, getfreq
C
      if (numal.le.1 .or. numal2.le.1) return

      if (plevel.gt.0) then
        write(*,'(/a,a10,a,a10,a/a/)')
     2   'Assoc for locus "',loc1,'" c. locus "',loc2,'"',
     3   '---------------------------------------------------'
      end if
      if (ltyp1.ne.ltyp2) then
        if (plevel.gt.0) then
          write(*,'(a/a)')
     2      'NOTE:  Mixed sex-linked and autosomal markers!',
     3      '          Pooled D'' (Hedrick) =   0.0' 
        else
          write(*,'(2(a10,1x),i4,2x,f6.3,1x,f6.1,1x,i4,1x,f6.4,1x,a)')
     &      loc1,loc2,0,0.0d0,0.0d0,0,1.0d0,'LD '
        end if
        return
      end if
      cutoff=0
      gene12=gene1+1
      gene22=gene2+1
      ntyped=0
      tothap=0
      ngcount=0
      do 2 i=1,numal
        alfrq(i)=0.0d0
        do 3 j=1,numal2
          ngcount=ngcount+1
          gcount(ngcount,1)=name(i)
          gcount(ngcount,2)=name2(j)
          gcount(ngcount,3)=0
    3   continue
    2 continue
      do 4 j=1,numal2
        alfrq2(j)=0.0d0
    4 continue

      last=.false.
      rewind(wrk)
C
C If high print level, then list transmitted and nontransmitted alleles
C for each informative proband
C
      if (plevel.gt.1) then
        write(*,'(a/a)') '  Informative Parent     Trans  Not Tr',
     &                   'Pedigree  ID      Sex    1   2   1   2'
      end if
C
   10 continue
       call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &            numloc, last)
       if (last) goto 20

       if (actset.le.0) goto 10
C
C
C Identify typed founders or nonfounders who have untyped parents
C
         do 11 i=1,nfound
           if (locus(i,gene1).gt.KNOWN .and.locus(i,gene2).gt.KNOWN)
     &     then
             eligible(i)=.true.
           else
             eligible(i)=.false.
           end if
   11    continue
         do 12 i=nfound+1,num
           if (locus(i,gene1).gt.KNOWN .and.locus(i,gene2).gt.KNOWN 
     2         .and. locus(fa(i),gene1).lt.KNOWN
     3         .and. locus(fa(i),gene2).lt.KNOWN
     4         .and. locus(mo(i),gene1).lt.KNOWN
     5         .and. locus(mo(i),gene2).lt.KNOWN)  then
             eligible(i)=.true.
           else
             eligible(i)=.false.
           end if
   12    continue
C
C Go through eligible offspring
C
         do 15 i=nfound+1,num
           if ((eligible(fa(i)) .or. eligible(mo(i))) .and.
     2         useld(locus(i,gene1),locus(i,gene12),locus(i,gene2),
     3           locus(i,gene22),locus(fa(i),gene1),locus(fa(i),gene12),
     4           locus(fa(i),gene2), locus(fa(i),gene22),
     5           locus(mo(i),gene1),locus(mo(i),gene12),
     6           locus(mo(i),gene2),locus(mo(i),gene22))) then
             xmale=(sex(i).eq.1 .and. ltyp1.eq.2)
             if (xmale) then
               call xtrans(
     3             int(locus(mo(i),gene1)), int(locus(mo(i),gene12)),
     4             int(locus(i,gene1)), int(locus(i,gene12)),
     5             tr1,tr2,nt1,nt2)
               call xtrans(
     3             int(locus(mo(i),gene2)), int(locus(mo(i),gene22)),
     4             int(locus(i,gene2)), int(locus(i,gene22)),
     5             tr3,tr4,nt3,nt4)
             else
               call trans(
     2             int(locus(fa(i),gene1)), int(locus(fa(i),gene12)),
     3             int(locus(mo(i),gene1)), int(locus(mo(i),gene12)),
     4             int(locus(i,gene1)), int(locus(i,gene12)),
     5             tr1,tr2,nt1,nt2,0)
               call trans(
     2             int(locus(fa(i),gene2)), int(locus(fa(i),gene22)),
     3             int(locus(mo(i),gene2)), int(locus(mo(i),gene22)),
     4             int(locus(i,gene2)), int(locus(i,gene22)),
     5             tr3,tr4,nt3,nt4,0)
             end if
C
C Note that once the haplotypes are used, the parent is set to ineligible
C along with any other full or half siblings
C
             if (eligible(fa(i)) .and. .not.xmale) then
               idx=fa(i)
               if (tr2.gt.KNOWN .and. tr4.gt.KNOWN) then
                 tothap=tothap+1
                 call insgen(tr2,tr4,ngcount,gcount,3,2)
                 call insall(tr2,numal,name,alfrq)
                 call insall(tr4,numal2,name2,alfrq2)
               end if
               if (ltyp1.eq.1 .and. zrec.eq.1) then
                 ntyped=ntyped+1
                 tothap=tothap+1
                 call insgen(nt2,nt4,ngcount,gcount,3,2)
                 call insall(nt2,numal,name,alfrq)
                 call insall(nt4,numal2,name2,alfrq2)
               end if
               eligible(idx)=.false.
               if (idx.gt.nfound) then
                 do 21 j=nfound+1,num
                   if (eligible(j) .and. 
     &                 (fa(idx).eq.fa(j) .or.  mo(idx).eq.mo(j))) then
                     eligible(j)=.false.
                   end if
   21            continue
               end if
               if (plevel.gt.1) then
                 write(*,'(a10,a10,1x,a1,2x,4(1x,i3))') 
     &           pedigree,id(idx),'m',tr2,tr4, nt2, nt4
               end if
             end if
             if (eligible(mo(i))) then
               idx=mo(i)
               ntyped=ntyped+1
               tothap=tothap+1
               call insgen(tr1,tr3,ngcount,gcount,3,2)
               call insall(tr1,numal,name,alfrq)
               call insall(tr3,numal2,name2,alfrq2)
               if (zrec.eq.1) then
                 tothap=tothap+1
                 call insgen(nt1,nt3,ngcount,gcount,3,2)
                 call insall(nt1,numal,name,alfrq)
                 call insall(nt3,numal2,name2,alfrq2)
               end if
               eligible(idx)=.false.
               if (idx.gt.nfound) then
                 do 22 j=nfound+1,num
                   if (eligible(j) .and. 
     &                 (fa(idx).eq.fa(j) .or.  mo(idx).eq.mo(j))) then
                     eligible(j)=.false.
                   end if
   22            continue
               end if
               if (plevel.gt.1) then
                 write(*,'(a10,a10,1x,a1,2x,4(1x,i3))') 
     &             pedigree,id(idx),'f',tr1,tr3, nt1, nt3 
               end if
             end if
           end if
   15    continue
       goto 10
   20  continue
C
      if (plevel.gt.0) then
       write(*,'(2a/2a)') 
     2   '       Haplotype       Observed   Expected',
     3   '     D        D''      Dev',
     4   '  ----------------------------------------',
     5   '-------------------------'
      end if
      asyp=1.0d0
      chisq=0.0d0
      bigd=0.0d0
      hedrick=0.0d0
      pval=1.0d0
      tot=0.0d0
      if (ntyped.gt.0) then
        tot=dfloat(tothap)
        do 225 i=1,ngcount
          nhap=gcount(i,3)
          key(i)=nhap
          p1=getfreq(gcount(i,1),numal,name,alfrq)/tot 
          p2=getfreq(gcount(i,2),numal2,name2,alfrq2)/tot
          e=tot*p1*p2
          gfrq(i)=e
          if (nhap.gt.cutoff) then
            chisq=chisq+dfloat(nhap)* log(dfloat(nhap)/e)
          end if    
          d=(dfloat(nhap)-e)/tot
          if (d.lt.0.0d0) then
            dprime=d/min(p1*p2,(1.0d0-p1)*(1.0d0-p2))
          elseif (d.eq.0.0d0) then
            dprime=0.0d0
          else
            dprime=d/(min(p1,p2)-p1*p2)
          end if
          if (abs(dprime).gt.abs(bigd)) bigd=abs(dprime)
          hedrick=hedrick+p1*p2*abs(dprime)

          if (plevel.gt.0) then
            call wrgtp(gcount(i,1),gcount(i,2),gtp,2)
            write(*,999) gtp,nhap,'(',dfloat(nhap)/tot,')',e,
     &                   d,dprime,ftdev(dfloat(nhap),e)
  999       format(8x,a7,1x,i8,1x,a1,f5.3,a1,1x,f9.1,2x,f7.4,
     &             2x,f7.4,1x,f6.1)
          end if
  225   continue

        chisq=chisq+chisq
        df=(numal-1)*(numal2-1)
        asyp=chip(chisq,df)

        call simchi(numal,name,numal2,name2,key,gfrq,
     &              chisq,tothap,iter,pval)
      end if 
      if (plevel.gt.0) then
        write(*,'(/a,i4/a,3x,f6.4)')
     2  '   Number of individuals used =',ntyped,
     3  '          Pooled D'' (Hedrick) =',hedrick 
        if (numal.eq.2 .and. numal2.eq.2) then
          d=d/sqrt(p1*(1.0d0-p1))/sqrt(p2*(1.0d0-p2))
          write(*,'(20x,a,3x,f6.4)') 'r-squared =', d*d
        end if
        write(*,'(a,f6.1/a,i4)')
     3  'Linkage disequilibrium Chi-sq =',chisq,
     4  '   Nominal degrees of freedom =',df
        write(*,'(14x,a,3x,f6.4)') 'Nominal P-value =',asyp
        write(*,'(14x,a,3x,f6.4,a,i8,a)') 'Empiric P-value =',pval,
     &    ' (',10*tothap*iter,' MCMC iterations)'
      else
        rsquare=' -   '
        if (numal.eq.2 .and. numal2.eq.2) then
          d=d/sqrt(p1*(1.0d0-p1))/sqrt(p2*(1.0d0-p2))
          write(rsquare,'(f5.3)') d*d
        end if
        call phist(pval,1.0d0,histo)
        write(*,'(2(a10,1x),i4,2x,f6.3,1x,a5,1x,f6.1,1x,i4,
     21x,f6.4,2(1x,a))')
     3    loc1,loc2,ntyped,hedrick,rsquare,chisq,df,pval,'LD ',histo
      end if
C
      return
      end
C end-of-twold
C
C simple increment of allele count where all alleles already identified
C
      subroutine insall(iall,numal,name,alfrq)
      integer MAXALL
      parameter(MAXALL=2)
      integer iall, numal, name(MAXALL)
      double precision alfrq(MAXALL)
      integer idx
C functions
      integer getnam
      idx=getnam(dfloat(iall),numal,name)
      alfrq(idx)=alfrq(idx)+1.0d0
      return
      end
C end-of-insall
C
C Check if useful triad for haplotype inference 
C
      logical function useld(c1,c2,c3,c4,f1,f2,f3,f4,m1,m2,m3,m4)
      integer KNOWN
      parameter(KNOWN=0)
      double precision c1,c2,c3,c4,f1,f2,f3,f4,m1,m2,m3,m4
      logical het1, het2, hom1, hom2

      useld=.false.
      if (c1.le.KNOWN .or. c3.le.KNOWN) return
      if (f1.le.KNOWN .or. f3.le.KNOWN) return
      if (m1.le.KNOWN .or. m3.le.KNOWN) return
C drop out uninformative triads: eg 1.2/3.4 x 1.2/1.3 -> 1.2/3.3
C                      but keep: eg 1.2/3.3 x 1.2/3.3 -> 1.2/3.3
      het1=(c1.eq.f1 .and. c2.eq.f2 .and. c1.eq.m1 .and. c2.eq.m2 .and.
     &      c1.ne.c2)
      hom1=(f1.eq.f2 .and. m1.eq.m2 .and. f1.eq.m1)
      het2=(c3.eq.f3 .and. c4.eq.f4 .and. c3.eq.m3 .and. c4.eq.m4 .and.
     &      c3.ne.c4)
      hom2=(f3.eq.f4 .and. m3.eq.m4 .and. f3.eq.m3)

      if (het1 .and. .not.hom2) return
      if (het2 .and. .not.hom1) return
      
      useld=.true.
      return
      end
C end-of-useld
C
C Do LD analysis for unphased and phased data
C
      subroutine ld2(loc1,numal,name1,loc2,numal2,name2,
     2               typ,ngcat, nhcat, nxcat, scatter,counts,
     3               full,ex,oldex,model,offset,x,r,b,cov,plevel)

      integer MAXALL, MAXSIZ, MAXIBD, MAXTER, MAXCOV
      parameter(MAXALL=2, MAXIBD=20, MAXSIZ=20,
     &          MAXTER=MAXIBD/2, MAXCOV=MAXTER*(MAXTER+1)/2)
      integer ngcat, nhcat, numal, numal2, nxcat, plevel, typ
      integer name1(MAXALL), name2(MAXALL)
      character*10 loc1, loc2

      integer scatter(*)
      real ex(*), counts(*), full(*), model(*), offset(*), oldex(*)
C
C regression work arrays
      double precision x(MAXTER),r(MAXCOV),b(MAXTER),cov(MAXCOV)
C local variables
      integer a1,a2,df,df1,ncells,nfull,npg,
     &        nhap,nobs,noff,npars,nph, nunph,totpars
      logical xlinkd
      character*3 allel, allel2, histo
      character*5 rsquare
      real lnoff
      double precision chisq, d, dprime, hedrick, lrts, p1, p2, pval, r2
C functions
      double precision chip
C  
C set up design and scatter matrices
      nhap=numal*numal2
      npg=nhap*(nhap+1)/2
      totpars=nhap
      nfull=nhcat
      ncells=0
      nmal=0
      nph=0
      nunph=0
      xlinkd=(nxcat.gt.0)
      if (typ.eq.1) then
C unphased problem
        npg=0
        ncells=ngcat
        do 2 i=1, ngcat
          nunph=nunph+int(counts(i))
    2   continue
        noff=nunph
      else if (typ.eq.2) then
C phased data
        ncells=npg
        noff=ncells
        do 3 i=1, npg
          nph=nph+int(counts(i))
    3   continue
        noff=nph
      else if (typ.eq.3) then
C both
        ncells=ngcat+npg
        nfull=nhcat+nhcat
        totpars=totpars+1
        do 4 i=1, ngcat
          nunph=nunph+int(counts(i))
    4   continue
        do 5 i=1, npg
          nph=nph+int(counts(ngcat+i))
    5   continue
        noff=nunph
      end if
C If X-linked, male haplotypes are added at end
      if (xlinkd) then
        ncells=ncells+nxcat
        nfull=nfull+nxcat
        totpars=totpars+1
        do 6 i=1, nxcat
          nmal=nmal+int(counts(ngcat+npg+i))
    6   continue
      end if

      nobs=nph+nunph+nmal
      call twofrq(numal, numal2, ncells, counts, typ, xlinkd)
      npars=totpars
      df1=ncells-totpars
      do 10 i=1, nfull*totpars
        model(i)=0.0
   10 continue
      call gl(nfull-nxcat, npars, model, 1, nhap, nhap, .false.)
      call gl(nfull, npars, model, 1, nhap, 1   , .false.)
      if (typ.eq.3) then
        call gl(nfull-nxcat, npars, model, nhap+1, 2, 
     &          (nfull-nxcat)/2, .true.)
      end if
      if (xlinkd) then
        call gl(nfull, npars, model, npars, 2, nfull-nxcat , .true.)
      end if
      call haptogen(numal, numal2, scatter, typ, xlinkd)
C
C offset by N to give haplotype proportions
      lnoff=log(float(noff))
      do 20 i=1, nfull 
        offset(i)=lnoff
   20 continue

C     write(*,*) ncells, nfull, totpars, npars
C     write(*,*) (counts(kk), kk=1, ncells)

      if (plevel.gt.0) then
        if (typ.eq.1) then
          write(*,'(a,i3,a,i5,a)') 
     &      'Modelling ',ngcat,' unphased genotypes (N=',nunph,').'
        else if (typ.eq.2) then
          write(*,'(a,i3,a,i5,a)') 
     &      'Modelling ',npg, ' phased genotypes (N=',nph,').'
        else
          write(*,'(a,2(i3,a,i5,a))') 
     2      'Modelling ',npg,' phased genotypes (N=',nph,
     3      ') and ',ngcat,' unphased genotypes (N=',nunph,').'
        end if
        if (xlinkd) then
          write(*,'(a,i3,a,i5,a)') 
     &      'And ',nxcat,' male haplotypes (N=',nmal,').'
        end if
      end if
      call emllm(ncells,nfull,totpars,npars,counts,scatter,model,
     &           ex,oldex,full,offset,x,r,b,cov,lrts,plevel)

      if (plevel.gt.1) then
        call ldtab(numal, numal2, counts, ex, typ, xlinkd)
      end if
      if (plevel.gt.0) then
        write(*,'(/a/a)') 
     2  '  Haplotype  Prop      95% CL           D        D''',
     3  '  ----------------------------------------------------'
      end if

      ii=0
      a1=1
      a2=1
      hedrick=0.0d0
      bigd=0.0d0
      r2=0.0d0
      if (numal.eq.2 .and. numal2.eq.2) then
        p1=dble(counts(ncells+a1))
        p2=dble(counts(ncells+numal+a2))
        r2=(exp(b(1))-p1*p2)
        r2=r2*r2/p1/(1.0-p1)/p2/(1.0d0-p2)
      end if
      do 250 i=1,nhap 
        ii=ii+i
        ase=1.96d0*sqrt(cov(ii))
        p1=dble(counts(ncells+a1))
        p2=dble(counts(ncells+numal+a2))
        d=exp(b(i))-p1*p2
        if (d.lt.0.0d0) then
          dprime=d/min(p1*p2,(1.0d0-p1)*(1.0d0-p2))
        elseif (d.eq.0.0d0 .or. p1.eq.0.0d0 .or. p2.eq.0.0d0) then
          dprime=0.0d0
        else
          dprime=d/(min(p1,p2)-p1*p2)
        end if
        if (abs(dprime).gt.abs(bigd)) bigd=abs(dprime)
        hedrick=hedrick+p1*p2*abs(dprime)
        if (plevel.gt.0) then
          call wrall(name1(a1), allel)
          call wrall(name2(a2), allel2)
          write(*,'(1x,a3,1x,a3,3x,f6.4,3x,f6.4,a,f6.4,2(3x,f7.4))') 
     2    allel, allel2, exp(b(i)), 
     3    exp(b(i)-ase), '--', exp(b(i)+ase), d, dprime
        end if
        a2=a2+1
        if (a2.gt.numal2) then
          a1=a1+1
          a2=1
        end if
  250 continue
      call twohwe(numal, numal2, nfull, totpars, model, typ, xlinkd)
      call emllm(ncells,nfull,totpars,totpars,counts,scatter,model,
     &           ex,oldex,full,offset,x,r,b,cov,chisq,plevel)
      df=(numal-1)*(numal2-1)
      chisq=chisq-lrts
      pval=chip(chisq,df)
      rsquare=' -   '
      if (plevel.gt.0) then
        write(*,'(/a,i10/a,f12.2,a,i4,a,f6.4,a)') 
     2    '  Number of genotypes used =', nobs,
     3    '    LD Model LR Chi-square =', lrts,
     4    ' (df=',df1,', P=',chip(lrts,df1),')' 
        write(*,'(a,f12.2,a,i4,a,f6.4,a/a,7x,f7.4)') 
     2    '       LR Chi-square (D=0) =', chisq,
     3    ' (df=',df,', P=',pval,')' ,
     4    '  Hedrick weighted mean D'' =', hedrick
        if (numal.eq.2 .and. numal2.eq.2) then
          write(*,'(17x,a,7x,f7.4)') 'r-squared =', r2
        end if
      else
        if (numal.eq.2 .and. numal2.eq.2) then
          write(rsquare,'(f5.3)') r2
        end if
        call phist(pval,1.0d0,histo)
        write(*,'(2(a10,1x),i4,2x,f6.3,1x,a5,
     21x,f6.1,1x,i4,1x,f6.4,2(1x,a))')
     3    loc1,loc2,nobs,hedrick,rsquare,chisq,df,pval,'LD ',histo
      end if
      return
      end
C end-of-ld2
C
C Marginal allele frequencies two loci
C
      subroutine twofrq(numal, numal2, ncells, counts, typ, xlinkd)
      integer ncells, numal, numal2, typ
      logical xlinkd
      real counts(*)

      integer i,j,i1, i2, j1, j2, n, pos
      real tot

      do 5 pos=ncells+1, ncells+numal+numal2
        counts(pos)=0.0
    5 continue
      tot=0.0
      pos=0
      if (typ.eq.1 .or. typ.eq.3) then
        do 10 i1=1, numal
        do 10 i2=1, i1
        do 10 j1=1, numal2
        do 10 j2=1, j1
          pos=pos+1
          tot=tot+counts(pos)
          counts(ncells+i1)=counts(ncells+i1)+counts(pos)
          counts(ncells+i2)=counts(ncells+i2)+counts(pos)
          counts(ncells+numal+j1)=counts(ncells+numal+j1)+counts(pos)
          counts(ncells+numal+j2)=counts(ncells+numal+j2)+counts(pos)
   10   continue
      end if
      if (typ.eq.2 .or. typ.eq.3) then
        n=numal*numal2
        j1=0
        i1=1
        do 20 i=1, n
          j1=j1+1
          if (j1.gt.numal2) then
            j1=1
            i1=i1+1
          end if
          j2=0
          i2=1
          do 30 j=1, i
            j2=j2+1
            if (j2.gt.numal2) then
              j2=1
              i2=i2+1
            end if
            pos=pos+1
            tot=tot+counts(pos)
            counts(ncells+i1)=counts(ncells+i1)+counts(pos)
            counts(ncells+i2)=counts(ncells+i2)+counts(pos)
            counts(ncells+numal+j1)=counts(ncells+numal+j1)+counts(pos)
            counts(ncells+numal+j2)=counts(ncells+numal+j2)+counts(pos)
   30     continue
   20   continue
      end if
      tot=tot+tot
      if (xlinkd) then
        do 40 i=1, numal
        do 40 j=1, numal2
          pos=pos+1
          tot=tot+counts(pos)
          counts(ncells+i)=counts(ncells+i)+counts(pos)
          counts(ncells+numal+j)=counts(ncells+numal+j)+counts(pos)
   40   continue
      end if
      do 50 pos=ncells+1, ncells+numal+numal2
        counts(pos)=counts(pos)/tot
   50 continue
      return
      end
C end-of-twofrq 
C
C Show table of genotypes and haplotypes
C
      subroutine ldtab(numal,numal2,counts,ex,typ,xlinkd)
      integer numal, numal2, typ
      logical xlinkd
      real counts(*), ex(*)

      integer i,j,i1, i2, j1, j2, n, pos
      character*7 gtp1, gtp2
C functions
      double precision ftdev

      pos=0
      if (typ.eq.1 .or. typ.eq.3) then
        write(*,'(/a)') 
     &    'Unphased Genotypes  Observed  Expected  Deviance'
        do 10 i1=1, numal
        do 10 i2=1, i1
        do 10 j1=1, numal2
        do 10 j2=1, j1
          call wrgtp(i2,i1,gtp1,1)
          call wrgtp(j2,j1,gtp2,1)
          pos=pos+1
          write(*,'(a,1x,a,7x,f6.0,2(3x,f6.1))') 
     2      gtp1,gtp2,counts(pos),ex(pos), 
     3      ftdev(dble(counts(pos)), dble(ex(pos)))
   10   continue
      end if
      if (typ.eq.2 .or. typ.eq.3) then
        write(*,'(a)') 
     &    'Phased Genotypes    Observed  Expected  Deviance'
        n=numal*numal2
        j1=0
        i1=1
        do 20 i=1, n
          j1=j1+1
          if (j1.gt.numal2) then
            j1=1
            i1=i1+1
          end if
          j2=0
          i2=1
          do 30 j=1, i
            j2=j2+1
            if (j2.gt.numal2) then
              j2=1
              i2=i2+1
            end if
            pos=pos+1
            write(*,'(2i3,a,2i3,9x,f6.0,2(3x,f6.1))') 
     2        i1,i2,';',j1,j2,counts(pos),ex(pos), 
     3        ftdev(dble(counts(pos)), dble(ex(pos)))
   30     continue
   20   continue
      end if
      if (xlinkd) then
        write(*,'(a)') 
     &    'Male Haplotypes     Observed  Expected  Deviance'
        do 40 i=1, numal
        do 40 j=1, numal2
          call wrgtp(i,j,gtp1,0)
          pos=pos+1
          write(*,'(3x,a,12x,f6.0,2(3x,f6.1))') 
     2      gtp1,counts(pos),ex(pos), 
     3      ftdev(dble(counts(pos)), dble(ex(pos)))
   40   continue
      end if
      return
      end
C end-of-ldtab  
C
C Two locus linkage disequilibrium: autosomal or X-linked loci
C
      subroutine twold2(wrk,zrec,gene1,loc1,ltyp1,gene2,loc2,ltyp2,iter,
     2  pedigree,actset,num,nfound,id,fa,mo,sex,locus,numloc,
     3  numal,name1,numal2,name2, scatter,counts,
     4  full,ex,oldex,model,offset,x,r,b,cov,eligible,plevel)

      integer KNOWN, MAXALL, MAXLOC, MAXSIZ, MAXIBD, MAXTER, 
     &        MAXCOV, MISS
      parameter(KNOWN=0, MAXALL=2, MAXLOC=10000, MAXIBD=20, 
     2          MISS=-9999, MAXSIZ=20,MAXTER=MAXIBD/2, 
     3          MAXCOV=MAXTER*(MAXTER+1)/2)
      integer gene1,gene2,iter,ltyp1,ltyp2,plevel,wrk, zrec
      integer numal, numal2
      integer name1(MAXALL), name2(MAXALL)
      character*10 loc1, loc2

      integer scatter(*)
      real counts(*), ex(*), full(*), model(*), offset(*), oldex(*)
C
C regression work arrays
      double precision x(MAXTER),r(MAXCOV),b(MAXTER),cov(MAXCOV)
C pedigree structure
      character*10 pedigree
      integer sex(MAXSIZ)
      integer actset,num, nfound
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)
C
C Typed founders or nonfounders who have untyped parents
      logical eligible(MAXSIZ)
C
      integer tr1,tr2,nt1,nt2,tr3,tr4,nt3,nt4
      character*1 ch, sx(2)
      logical last, xmale
      integer cutoff, gene12, gene22, i, idx, j,
     &        ngcat, nhcat, npg, totgeno, tothap, totmal, typ
C functions 
      logical useld
C
      data sx /'m','f'/

      if (numal.le.1 .or. numal2.le.1) return

      ngcat=numal*(numal+1)*numal2*(numal2+1)/4 
      nxcat=numal*numal2
      npg=nxcat*(nxcat+1)/2
      nhcat=nxcat*nxcat

      if (nhcat.gt.MAXSIZ) then
        write(*,'(a)') 'ERROR: Too many possible haplotypes.'
        return
      end if
      if (plevel.gt.0) then
        write(*,'(/a,a10,a,a10,a/a/)')
     2   'Assoc for locus "',loc1,'" c. locus "',loc2,'"',
     3   '---------------------------------------------------'
      end if
      if (ltyp1.ne.ltyp2) then
        if (plevel.gt.0) then
          write(*,'(a/a)')
     2      'NOTE:  Mixed sex-linked and autosomal markers!',
     3      '          Pooled D'' (Hedrick) =   0.0' 
        else
          write(*,'(2(a10,1x),i4,2x,f6.3,1x,f6.1,1x,i4,1x,f6.4,1x,a)')
     &      loc1,loc2,0,0.0d0,0.0d0,0,1.0d0,'LD '
        end if
        return
      end if
      
      cutoff=0
      gene12=gene1+1
      gene22=gene2+1
      totgeno=0
      tothap=0
      totmal=0
      do 5 i=1, MAXSIZ
        counts(i)=0.0
    5 continue


      last=.false.
      rewind(wrk)
C
C If high print level, then list transmitted and nontransmitted alleles
C for each informative proband
C
      if (plevel.gt.2) then
        write(*,'(a/a)') '  Informative Parent     Trans  Not Tr',
     &                   'Pedigree  ID      Sex    1   2   1   2'
      end if
C
   10 continue
       call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &            numloc, last)
       if (last) goto 20

       if (actset.le.0) goto 10
C
C
C Identify typed founders or nonfounders who have untyped parents
C
         do 11 i=1,nfound
           if (locus(i,gene1).gt.KNOWN .and.locus(i,gene2).gt.KNOWN)
     &     then
             eligible(i)=.true.
           else
             eligible(i)=.false.
           end if
   11    continue
         do 12 i=nfound+1,num
           if (locus(i,gene1).gt.KNOWN .and.locus(i,gene2).gt.KNOWN 
     2         .and. locus(fa(i),gene1).lt.KNOWN
     3         .and. locus(fa(i),gene2).lt.KNOWN
     4         .and. locus(mo(i),gene1).lt.KNOWN
     5         .and. locus(mo(i),gene2).lt.KNOWN)  then
             eligible(i)=.true.
           else
             eligible(i)=.false.
           end if
   12    continue
C
C Go through eligible offspring
C
         do 15 i=nfound+1,num
           if ((eligible(fa(i)) .or. eligible(mo(i))) .and.
     2         useld(locus(i,gene1),locus(i,gene12),locus(i,gene2),
     3           locus(i,gene22),locus(fa(i),gene1),locus(fa(i),gene12),
     4           locus(fa(i),gene2), locus(fa(i),gene22),
     5           locus(mo(i),gene1),locus(mo(i),gene12),
     6           locus(mo(i),gene2),locus(mo(i),gene22))) then
             xmale=(sex(i).ne.2 .and. ltyp1.eq.2)
             if (xmale) then
               call xtrans(
     3             int(locus(mo(i),gene1)), int(locus(mo(i),gene12)),
     4             int(locus(i,gene1)), int(locus(i,gene12)),
     5             tr1,tr2,nt1,nt2)
               call xtrans(
     3             int(locus(mo(i),gene2)), int(locus(mo(i),gene22)),
     4             int(locus(i,gene2)), int(locus(i,gene22)),
     5             tr3,tr4,nt3,nt4)
             else
               call trans(
     2             int(locus(fa(i),gene1)), int(locus(fa(i),gene12)),
     3             int(locus(mo(i),gene1)), int(locus(mo(i),gene12)),
     4             int(locus(i,gene1)), int(locus(i,gene12)),
     5             tr1,tr2,nt1,nt2,0)
               call trans(
     2             int(locus(fa(i),gene2)), int(locus(fa(i),gene22)),
     3             int(locus(mo(i),gene2)), int(locus(mo(i),gene22)),
     4             int(locus(i,gene2)), int(locus(i,gene22)),
     5             tr3,tr4,nt3,nt4,0)
             end if
C
C Note that once the haplotypes are used, the parent is set to ineligible
C along with any other full or half siblings
C
             if (eligible(fa(i)) .and. .not.xmale) then
               idx=fa(i)
               ntyped=ntyped+1
               if (ltyp1.eq.1 .and. zrec.eq.1) then
                 tothap=tothap+2
                 call inchap(tr2,nt2,tr4,nt4,ngcat,npg,
     &                  numal,name1,numal2,name2,counts,2)
               else if (ltyp1.eq.2) then
                 totmal=totmal+1
                 call inchap(tr2,tr4,0,0,ngcat,npg,
     &                  numal,name1,numal2,name2,counts,3)
               end if
               eligible(idx)=.false.
               if (idx.gt.nfound) then
                 do 21 j=nfound+1,num
                   if (eligible(j) .and. 
     &                 (fa(idx).eq.fa(j) .or.  mo(idx).eq.mo(j))) then
                     eligible(j)=.false.
                   end if
   21            continue
               end if
               if (plevel.gt.2) then
                 write(*,'(a10,a10,1x,a1,2x,4(1x,i3))') 
     &           pedigree,id(idx),'m',tr2,tr4, nt2, nt4
               end if
             end if
             if (eligible(mo(i))) then
               idx=mo(i)
               ntyped=ntyped+1
               tothap=tothap+2
               if (zrec.eq.1) then
                 call inchap(tr1,nt1,tr3,nt3,ngcat,npg,
     &                  numal,name1,numal2,name2,counts,2)
               else if (xmale) then
                 totmal=totmal+1
                 call inchap(tr1,tr3,0,0,ngcat,npg,
     &                  numal,name1,numal2,name2,counts,3)
               else
                 call inchap(tr1,tr2,tr3,tr4,ngcat,npg,
     &                  numal,name1,numal2,name2,counts,2)
               end if
               eligible(idx)=.false.
               if (idx.gt.nfound) then
                 do 22 j=nfound+1,num
                   if (eligible(j) .and. 
     &                 (fa(idx).eq.fa(j) .or.  mo(idx).eq.mo(j))) then
                     eligible(j)=.false.
                   end if
   22            continue
               end if
               if (plevel.gt.2) then
                 write(*,'(a10,a10,1x,a1,2x,4(1x,i3))') 
     &             pedigree,id(idx),'f',tr1,tr3, nt1, nt3 
               end if
             end if
           end if
   15    continue
         do 17 i=1,num
         if (eligible(i)) then
           xmale=(sex(i).ne.2 .and. ltyp1.eq.2)
           if (xmale) then
             totmal=totmal+1
             call inchap(int(locus(i,gene1)),int(locus(i,gene2)),
     3              0,0,ngcat,npg,numal,name1,numal2,name2,counts,3)
             if (plevel.gt.2) then
               write(*,'(a10,a10,1x,a1,2x,2(1x,i3),2(2x,a1,1x))') 
     2           pedigree, id(i),'m',int(locus(i,gene1)),
     3           int(locus(i,gene2)),'-','-'
             end if
C
C If imputation on and X-linked marker, then unimputable pedigrees
C differ significantly from imputable pedigrees 
C
           else if (ltyp1.le.2) then
             totgeno=totgeno+1
             call inchap(int(locus(i,gene1)),int(locus(i,gene12)),
     2              int(locus(i,gene2)),int(locus(i,gene22)),
     3              ngcat,npg,numal,name1,numal2,name2,counts,1)
             if (plevel.gt.2) then
               ch='x'
               if (sex(i).ne.MISS) ch=sx(sex(i))
               write(*,'(a10,a10,1x,a1,2x,2(1x,i3,a1,i3))') 
     2           pedigree, id(i),ch,
     3           int(locus(i,gene1)),'/',int(locus(i,gene12)),
     4           int(locus(i,gene2)),'/',int(locus(i,gene22)) 
             end if
           end if
         end if
   17    continue
       goto 10
   20 continue
      typ=0
      if (totgeno.gt.0) typ=typ+1
      if (tothap.gt.0) typ=typ+2
      if (totmal.eq.0) nxcat=0
      if (typ.gt.0) then
C if only unphased or phased genotypes, reduce table to that length
        if (typ.eq.1) then
          do 45 i=ngcat+npg+1, ngcat+npg+nxcat
            counts(i-npg)=counts(i)
   45     continue
        else if (typ.eq.2) then
          do 50 i=ngcat+1, ngcat+npg+nxcat
            counts(i-ngcat)=counts(i)
   50     continue
        end if

        call ld2(loc1,numal,name1,loc2,numal2,name2,typ,
     2           ngcat, nhcat, nxcat, scatter,
     3           counts,full,ex,oldex,model,offset,x,r,b,cov,plevel)
      else if (plevel.gt.0) then 
        write(*,'(a)') 'No usable observations.'
      else
        write(*,'(2(a10,1x),a)')
     &    loc1,loc2, '   0    -        -     -  -     LD'
      end if
      return
      end
C end-of-twold2
C 
C increment count of phased or unphased genotype, haplotype 
C
      subroutine inchap(g11,g12,g21,g22,ngcat,npg,  
     &                  numal,name1,numal2,name2,counts,typ)
      integer MISS
      parameter (MISS=-9999)
      integer g11,g12,g21,g22,ngcat,npg,numal,numal2,typ   
      integer name1(*), name2(*)
      real counts(*)
      integer idx
C functions
      integer clcpos, getnam

      if (g11.eq.MISS .or. g21.eq.MISS) return

      if (typ.eq.1) then
        idx=numal2*(numal2+1)/2 *
     2        (clcpos(getnam(dfloat(g11),numal,name1),
     3                getnam(dfloat(g12),numal,name1))-1)+
     4         clcpos(getnam(dfloat(g21),numal2,name2),
     5                getnam(dfloat(g22),numal2,name2))
      else if (typ.eq.2) then
        idx=ngcat+
     2        clcpos(numal*(getnam(dfloat(g11),numal,name1)-1)+
     3               getnam(dfloat(g21),numal2,name2),
     4               numal*(getnam(dfloat(g12),numal,name1)-1)+
     5               getnam(dfloat(g22),numal2,name2))
      else if (typ.eq.3) then
        idx=ngcat+npg+
     2        numal*(getnam(dfloat(g11),numal,name1)-1)+
     3        getnam(dfloat(g12),numal2,name2)
      end if
C     write(*,*) 'index: ',idx, ' ', typ, ' (',g11,g12,g21,g22,')'
      counts(idx)=counts(idx)+1.0
      return
      end
C end-of-inchap
C Modified random walk simulation (one iteration) of pedigree missing
C genotypes (Metropolis-Hastings algorithm) -- proposal uses founder
C allele mutations propagated throughout then pedigree conditional
C on (identity by) descent, swapping ibd origins for heterozygotes,
C alternated with a randomization of descent conditional on marker
C genotype. This procedure has the advantage of being quick,
C but the proposal probabilities are not always symmetric, so they
C are combined with additional local proposals
C
C It is alternated with a locally updating Gibbs sampler. This jointly
C simulates Untyped x Untyped founder matings genotypes conditional on
C offspring and other spouses; other genotypes individual-by-individual,
C conditional on parental, spouse and child genotypes.
C
      subroutine drop(it,pedigree,num,nfound,id,fa,mo,nummat,
     2                cntmat,untyped,numal,gfrq,set,set2,sibd,
     3                key, iprop, plevel)
      integer MAXALL, MAXG, MAXSIZ
      parameter(MAXALL=2, MAXG=MAXALL*(MAXALL+1)/2,
     &          MAXSIZ=20)

      integer iprop, it, plevel
C pedigree structure
      character*10 pedigree
      integer num, nfound
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ)
C genotypic arrays for pedigree: current, proposed; resulting ibd status
      integer set(MAXSIZ,2), set2(MAXSIZ,2)
      integer sibd(MAXSIZ,2), key(2*MAXSIZ)
C indicator of untyped individual
      logical untyped(MAXSIZ)
C allele frequencies structure
      integer numal
      double precision gfrq(MAXG)
C number of untyped matings -- used to decide number and type of mutations
      integer nummat, cntmat(MAXALL,2)
C local variables
      integer gibbsit, gprop, i, mat, par1, par2
      logical xmale
      double precision lr, qa 
C functions
      integer irandom, parcon

      gibbsit=5
      xmale=.false.
      iprop=irandom(1,60)
      if (iprop.gt.4) iprop=4
C
C Metropolis multisite proposals
      if (iprop.le.3) then
C
C Do ibd dropping
C
        if (iprop.eq.1) then
          do 30 i=1,num
            set2(i,1)=set(i,1)
            set2(i,2)=set(i,2)
   30     continue
          call fsimped(it,pedigree,num,nfound,id,fa,mo,set2,sibd,
     &                 untyped,key,plevel)
C
C Or mutate founder allele(s)
C
        else if (iprop.eq.2) then
          call simibd(2,pedigree,num,nfound,fa,mo,set,sibd)
          call mutate(numal,num,nfound,set,sibd,set2,untyped)
C
C Or switch parents of origin
C
        else
          call simibd(2,pedigree,num,nfound,fa,mo,set,sibd)
          call switch(num,nfound,id,fa,mo,set,sibd,set2,untyped)
        end if
C Further shuffle genotypes -- here untyped founder matings
        do 20 mat=1,nummat
          par1=cntmat(mat,1)
          par2=cntmat(mat,2)
          call simpar(num,nfound,fa,mo,set,par1,par2,numal)
   20   continue
C
C now check if the proposal is an acceptable one
C
        if (plevel.gt.2) then
          do 999 i=1,num
            write(*,*) it, ' ', id(i), set(i,1), set(i,2), ' -> ',
     &        set2(i,1), set2(i,2), ' {',sibd(i,1),sibd(i,2),' }'
  999     continue
        end if
        lr=1.0d0
        do 100 i=1,nfound
        if (untyped(i)) then
          lr=lr*gfrq(set2(i,2)*(set2(i,2)-1)/2+set2(i,1))/
     &          gfrq(set(i,2)*(set(i,2)-1)/2+set(i,1))
        end if
  100   continue
        do 110 i=nfound+1,num
          par2=parcon(set2(i,1),set2(i,2),set2(fa(i),1),set2(fa(i),2),
     &                set2(mo(i),1),set2(mo(i),2),xmale)
          par1=parcon(set(i,1),set(i,2),set(fa(i),1),set(fa(i),2),
     &                set(mo(i),1),set(mo(i),2),xmale)
          if (par1.ne.par2) then
            lr=lr*dfloat(par2)/dfloat(par1)
          end if
  110   continue
        qa=min(1.0d0,lr)
C
C If accepted, update genotypes
C
        if (qa.gt.random()) then
          if (plevel.gt.2) then
            write(*,'(a,i1,a,f12.4)') 
     &        'Proposal type ',iprop,' accepted ',lr
          end if
          do 150 i=1,num
          if (untyped(i)) then
            set(i,1)=set2(i,1)
            set(i,2)=set2(i,2)
          end if
  150     continue
        else 
          if (plevel.gt.2) then
            write(*,'(a,i1,a,f12.4)') 
     &        'Proposal type ',iprop,' rejected ',lr
          end if
          iprop=-iprop
        end if
      end if
C
C now local updating via Gibbs sampler
C
      gprop=0
      do 200 mat=1, nummat
        gprop=gprop+1
        key(gprop)=MAXSIZ+mat
  200 continue
      do 250 i=1, num
      if (untyped(i)) then
        gprop=gprop+1
        key(gprop)=i
      end if
  250 continue
      call permut(gprop, key)

      do 300 j=1, gibbsit
      do 300 i=1, gprop
        if (key(i).gt.MAXSIZ) then
C Untyped x untyped founder mating update
          mat=key(i)-MAXSIZ
          par1=cntmat(mat,1)
          par2=cntmat(mat,2)
          call simnuc(par1,par2,num,nfound,fa,mo,set,numal,gfrq)
        else
C individual update
          call simnuc(key(i),key(i),num,nfound,fa,mo,set,numal,gfrq)
        end if
  300 continue
      call simibd(2,pedigree,num,nfound,fa,mo,set,sibd)

      if (plevel.gt.1) then
        write(*,'(a,i6)') 
     &    'Simulated missing genotypes for iteration ',it
        do 160 i=1,num
        if (untyped(i)) then
          write(*,'(i5,1x,a10,2(1x,i3))') it,id(i),set(i,1),set(i,2)
        end if
  160   continue
      end if
      return
      end
C end-of-drop
C 
C  Gibbs sampler for codominant marker locus
C  Simulate parental genotypes for untyped x untyped
C  mating conditional on offspring genotypes
C  or for untyped nonfounders conditional on offspring, spouses 
C  and parents. Family may be contained within larger pedigree, and
C  multiple spouses are possible
C
      subroutine simnuc(par1,par2,num,nfound,fa,mo,set,numal,gfrq)
C
C  Pedigree structure
      integer MAXALL, MAXG, MAXSIZ, MISS
      parameter(MAXALL=2, MAXG=MAXALL*(MAXALL+1)/2,
     &          MAXSIZ=20, MISS=-9999)
      integer num, nfound, fa(MAXSIZ),mo(MAXSIZ), set(MAXSIZ,2)
      integer par1, par2
C genotype frequencies structure
      integer numal
      double precision gfrq(MAXG)
C local variables
      integer fin, i, sta
      double precision targt
C functions
      real random

      sta=MISS
      fin=MISS
      do 10 i=nfound+1,num
      if (par1.eq.fa(i) .or. par2.eq.mo(i)) then
        if (sta.eq.MISS) then
          sta=i
          fin=i
        elseif (i.gt.fin) then
          fin=i
        end if
      end if
   10 continue
C
      if (par1.ne.par2) then
        targt=1.0d0
        call nuclik(par1,par2,sta,fin,fa,mo,set,
     &              numal,gfrq,targt)
        targt=dble(random())*targt
        call nuclik(par1,par2,sta,fin,fa,mo,set,
     &              numal,gfrq,targt)
      else if (par1.le.nfound) then
        targt=1.0d0
        call foulik(par1,fa,mo,set,sta,fin,numal, gfrq, targt)
        targt=dble(random())*targt
        call foulik(par1,fa,mo,set,sta,fin,numal, gfrq, targt)
      else 
        targt=1.0d0
        call onelik(par1,fa,mo,set,sta,fin,targt)
        targt=dble(random())*targt
        call onelik(par1,fa,mo,set,sta,fin,targt)
      end if
      return
      end
C end-of-simnuc
C
C Nuclik is run twice, once to calculate the total likelihood <totlik> of the
C legal genotypes (with target=1), the second time to select a 
C parental genotypes with target ~ U(0,totlik).
C
      subroutine nuclik(par1,par2,sta,fin,fa,mo,set,
     &                  numal,gfrq,targt)
      integer MAXALL, MAXG, MAXSIZ
      parameter(MAXALL=2, MAXG=MAXALL*(MAXALL+1)/2,
     &          MAXSIZ=20)
      double precision targt
C  Pedigree structure
      integer fa(MAXSIZ),mo(MAXSIZ), set(MAXSIZ,2)
      integer fin, g1, g2, mg1, mg2, par1, par2, pg1, pg2, sta
C genotype frequencies structure
      integer numal
      double precision gfrq(MAXG)
C local variables
      integer con, i
      logical xmale
      double precision lik, totlik
C functions
      integer parcon
C 
      xmale=.false.
      totlik=0.0d0

      g1=0
      do 5 mg2=1,numal
      do 5 mg1=1,mg2
        g1=g1+1
        lik=gfrq(g1)
        g2=0
        do 6 pg2=1,numal
        do 6 pg1=1,pg2
          g2=g2+1
          lik=gfrq(g1)*gfrq(g2)
C         if (mg1.ne.mg2) lik=lik+lik
C         if (pg1.ne.pg2) lik=lik+lik
          set(par1,1)=pg1
          set(par1,2)=pg2
          set(par2,1)=mg1
          set(par2,2)=mg2
          do 10 i=sta,fin
            con=parcon(set(i,1),set(i,2),set(fa(i),1),set(fa(i),2),
     &                 set(mo(i),1),set(mo(i),2),xmale)
            if ((par1.eq.fa(i) .or. par2.eq.mo(i)) .and. con.eq.0) then
              goto 55
            end if
            lik=lik*0.25d0*dfloat(con)
   10     continue
C
C else (if consistent) add to legal genotypes
C
          totlik=totlik+lik
C
C check to see if have selected current parental genotypes
C
            if (totlik.ge.targt) then
              return
            end if
   55     continue
    6   continue
    5 continue
      targt=totlik
      return
      end
C end-of-nuclik
C
C Founder codominant locus conditional likelihood
C foulik is run twice, once to calculate the total likelihood <totlik> of the
C legal genotypes (with target=1), the second time to select a genotype,
C with target ~ U(0,totlik).
C
      subroutine foulik(idx, fa, mo, set, sta, fin, numal, gfrq, targt)
      integer MAXALL, MAXG, MAXSIZ, MISS
      parameter(MAXALL=2, MAXG=MAXALL*(MAXALL+1)/2,
     &          MAXSIZ=20, MISS=-9999)
      integer idx
      double precision targt
C  Pedigree structure
      integer fa(MAXSIZ), mo(MAXSIZ), set(MAXSIZ,2)
      integer fin, sta
C genotype frequencies structure
      integer numal
      double precision gfrq(MAXG)
C local variables
      integer con, g1, g2, ng, i
      logical xmale
      double precision lik, totlik
C functions
      integer parcon
C 
      xmale=.false.
      totlik=0.0d0
      ng=0
      do 5 g1=1,numal
      do 5 g2=1,g1 
        ng=ng+1
        lik=gfrq(ng)
C       if (g1.ne.g2) lik=lik+lik
        set(idx,1)=g2
        set(idx,2)=g1
        if (sta.ne.MISS) then
          do 10 i=sta,fin
            con=parcon(set(i,1),set(i,2),set(fa(i),1),set(fa(i),2),
     &                 set(mo(i),1),set(mo(i),2),xmale)
            if ((idx.eq.fa(i) .or. idx.eq.mo(i)) .and. con.eq.0) then
              goto 55
            end if
            lik=lik*0.25d0*dfloat(con)
   10     continue
        end if
        totlik=totlik+lik
C exit if target reached
        if (totlik.ge.targt) then
          return
        end if
   55   continue
    5 continue
      targt=totlik
      return
      end
C end-of-foulik
C
C nonfounder codominant locus conditional likelihood
C onelik is run twice, once to calculate the total likelihood <totlik> of the
C legal genotypes (with target=1), the second time to select a genotype,
C with target ~ U(0,totlik).
C
      subroutine onelik(idx,fa,mo,set,sta,fin,targt)
      integer MAXSIZ, MISS
      parameter(MAXSIZ=20, MISS=-9999)
      integer idx
      double precision targt
C  Pedigree structure
      integer fa(MAXSIZ), mo(MAXSIZ), set(MAXSIZ,2)
      integer fin, sta
C local variables
      integer con, g1, g2, i, i1, i2
      logical xmale
      double precision lik, totlik
C functions
      integer parcon
C 
      xmale=.false.
      totlik=0.0d0
      do 5 i1=1,2
      do 5 i2=1,2
        lik=0.25d0
        g1=set(fa(idx),i1)
        g2=set(mo(idx),i2)
        call order(g1,g2)
        set(idx,1)=g1
        set(idx,2)=g2
        if (sta.ne.MISS) then
          do 10 i=sta,fin
            con=parcon(set(i,1),set(i,2),set(fa(i),1),set(fa(i),2),
     &                 set(mo(i),1),set(mo(i),2),xmale)
            if ((idx.eq.fa(i) .or. idx.eq.mo(i)) .and. con.eq.0) then
              goto 55
            end if
            lik=lik*0.25d0*dfloat(con)
   10     continue
        end if
        totlik=totlik+lik
C exit if target reached
        if (totlik.ge.targt) then
          return
        end if
   55   continue
    5 continue
      targt=totlik
      return
      end
C end-of-onelik
C 
C  Propose parental genotypes for untyped x untyped
C  mating conditional on offspring genotypes
C  Family may be contained within larger pedigree, and
C  multiple spouses are possible
C
      subroutine simpar(num,nfound,fa,mo,set,par1,par2,numal)
C
C  Pedigree structure
      integer MAXALL, MAXG, MAXSIZ, MISS
      parameter(MAXALL=40, MAXG=MAXALL*(MAXALL+1)/2,
     &          MAXSIZ=20, MISS=-9999)
      integer num, nfound, fa(MAXSIZ),mo(MAXSIZ), set(MAXSIZ,2)
      integer par1, par2
C local variables
      integer fin, i, sta
      integer targt, totp
C functions
      integer irandom

      sta=MISS
      fin=MISS
      do 10 i=nfound+1,num
      if (par1.eq.fa(i) .or. par2.eq.mo(i)) then
        if (sta.eq.MISS) then
          sta=i
          fin=i
        elseif (i.gt.fin) then
          fin=i
        end if
      end if
   10 continue
C
      targt=MAXG*MAXG
      call inuclik(fa,mo,set,par1,par2,sta,fin,
     &            numal,targt,totp)
      targt=irandom(1,totp)
      call inuclik(fa,mo,set,par1,par2,sta,fin,
     &            numal,targt,totp)
C
      return
      end
C end-of-simpar
C
C inuclik is an integer version of nuclik
C inuclik is run twice, once to calculate the total number <totp> of the
C legal genotypes (with target=MAXG*MAXG), the second time to select a 
C parental genotype.
C
      subroutine inuclik(fa,mo,set,par1,par2,sta,fin,
     &                   numal,targt,totp)
      integer MAXSIZ
      parameter(MAXSIZ=20)
      integer targt, totp
C  Pedigree structure
      integer fa(MAXSIZ),mo(MAXSIZ), set(MAXSIZ,2)
      integer fin, mg1, mg2, par1, par2, pg1, pg2, sta
C allele frequencies structure
      integer numal

C local variables
      integer con, i
      logical xmale
C functions
      integer parcon
C 
      xmale=.false.
      totp=0

      do 5 mg2=1,numal
      do 5 mg1=1,mg2
      do 5 pg2=1,numal
      do 5 pg1=1,pg2
        set(par1,1)=pg1
        set(par1,2)=pg2
        set(par2,1)=mg1
        set(par2,2)=mg2
        do 10 i=sta,fin
          con=parcon(set(i,1),set(i,2),set(fa(i),1),set(fa(i),2),
     &               set(mo(i),1),set(mo(i),2),xmale)
          if ((par1.eq.fa(i) .or. par2.eq.mo(i)) .and. con.eq.0) then
            goto 55
          end if
   10   continue
C
C else (if consistent) add to legal genotypes
C
        totp=totp+1
C
C check to see if have selected current parental genotypes
C
          if (totp.eq.targt) then
            return
          end if
   55   continue
    5 continue
      return
      end
C end-of-inuclik
C
C Mutate 1-4 allele in untyped founders.  Can never fail, due "backmutation".
C
C (1) mutate an allele never transmitted to a typed individual
C (2) swap parent of origin if have no offspring sharing ibd-allele
C
      subroutine mutate(numal,num,nfound,set,sibd,set2,untyped)
      integer MAXSIZ
      parameter (MAXSIZ=20)
      integer numal
C Pedigree structure
      integer num, nfound
      integer set(MAXSIZ,2), sibd(MAXSIZ,2), set2(MAXSIZ,2)
      logical untyped(MAXSIZ)
C
C mut designates ibd-allele, prop the corresponding marker allele
      integer nmut
      integer mut(4), prop(4)
      integer g1,g2,i,j
C functions
      integer irandom

    1 continue

        nmut=irandom(1,4)
        do 5 j=1,nmut
          mut(j)=irandom(1,2*nfound)
          prop(j)=irandom(1,numal)
    5    continue
         do 10 i=1,num
           g1=set(i,1)
           g2=set(i,2)
           do 15 j=1, nmut
             if (sibd(i,1).eq.mut(j)) g1=prop(j)
             if (sibd(i,2).eq.mut(j)) g2=prop(j)
   15      continue
           call order(g1,g2)
C midloop break
      if ( .not.untyped(i) .and.
     &     (set(i,1).ne.g1 .or. set(i,2).ne.g2)) then
        goto 1
      end if
C
          call update(i,g1,g2,set2)
   10   continue
      return
      end
C end-of-mutate
C
C Do a switch of grandparent of origin of alleles = switch lineage
C
      subroutine switch(num,nfound,id,fa,mo,set,sibd,set2,untyped)
      integer KNOWN,MAXSIZ,MISS
      parameter (KNOWN=0,MAXSIZ=20,MISS=-9999)
C Pedigree structure
      character*10 id(MAXSIZ)
      integer num, nfound, fa(MAXSIZ), mo(MAXSIZ)
      integer set(MAXSIZ,2), sibd(MAXSIZ,2), set2(MAXSIZ,2)
      logical untyped(MAXSIZ)
C
      integer g(2), i, idx, ntrials, par
      logical fin, xmale

C functions
      integer irandom, parcon

      xmale=.false.
      ntrials=0

    1 continue
C
      ntrials=ntrials+1
C
C give up if <num> unsuccessful trials
C
      if (ntrials.gt.num) then
        do 220 i=1,num
          set2(i,1)=set(i,1)
          set2(i,2)=set(i,2)
  220   continue
        return
      end if
C
C provide a heterozygote candidate with both parents untyped
C
      idx=irandom(nfound+1,num)

      if (set(idx,1).eq.set(idx,2) .or. 
     &     .not.untyped(fa(idx)) .or. .not.untyped(mo(idx))) then
         goto 1
      end if
C 
      do 10 i=1,num
        set2(i,1)=MISS
        set2(i,2)=MISS
   10 continue
      g(2)=set(idx,1)
      g(1)=set(idx,2)
      set2(idx,1)=1
      set2(idx,2)=2
C
C Each iteration moves as far up the pedigree as possible 
C
   15 continue
        fin=.true.
        do 100 i=nfound+1,num
        if (set2(i,1).ne.MISS) then
          par=fa(i)
          if (set2(par,1).eq.MISS .and. untyped(par)) then
            call cpibd(par,i,sibd,set2,KNOWN)
            fin=.false.
          end if
          par=mo(i)
          if (set2(par,1).eq.MISS .and. untyped(par)) then
            call cpibd(par,i,sibd,set2,KNOWN)
            fin=.false.
          end if
        end if
  100   continue
      if (.not.fin) goto 15
C
C See if reached one (loop) or two untyped founders, so swap feasible
C
      par=0
      do 110 i=1,nfound
      if (set2(i,1).gt.KNOWN .or. set2(i,2).gt.KNOWN) then
        par=par+1
      end if
  110 continue
C       write(*,*) 'idx=',id(idx), ' par=', par
C       do 999 i=1,num
C         write(*,*) id(i), ' ', set(i,1), set(i,2), ' -> ',
C    &      set2(i,1), set2(i,2), ' {',sibd(i,1),sibd(i,2),'}'
C 999   continue
      if (par.eq.0) then
        goto 1
      end if
C
C swap appropriate alleles of simulated genotype
C
      do 150 i=1,num
        if (set2(i,1).gt.KNOWN) set2(i,1)=g(set2(i,1))
        if (set2(i,2).gt.KNOWN) set2(i,2)=g(set2(i,2))
        if (set2(i,1).le.KNOWN) set2(i,1)=set(i,1)
        if (set2(i,2).le.KNOWN) set2(i,2)=set(i,2)
        call order(set2(i,1),set2(i,2))
        if (i.gt.nfound .and. parcon(set2(i,1),set2(i,2),
     2      set2(fa(i),1),set2(fa(i),2),set2(mo(i),1),
     3      set2(mo(i),2), xmale).eq.0) then
          goto 1
        end if
  150 continue
      return
      end
C end-of-switch
C
C Copy ibd for a pair of relatives.
C Person j has a typing-genotype at sibd2, person i does not.
C The typing-allele corresponding to that shared at sibd()
C is "transmitted" to person i from person j.
C
      subroutine cpibd(i,j,sibd,sibd2,imiss)
      integer MAXSIZ, MISS
      parameter(MAXSIZ=20,MISS=-9999)
      integer i,imiss,j
      integer sibd(MAXSIZ,2), sibd2(MAXSIZ,2)

      if (sibd(i,1).eq.sibd(j,1)) then
        sibd2(i,1)=sibd2(j,1)
      end if
      if (sibd(i,1).eq.sibd(j,2)) then
        sibd2(i,1)=sibd2(j,2)
      end if
      if (sibd(i,2).eq.sibd(j,1)) then
        sibd2(i,2)=sibd2(j,1)
      end if
      if (sibd(i,2).eq.sibd(j,2)) then
        sibd2(i,2)=sibd2(j,2)
      end if
      if (sibd2(i,1).eq.MISS) sibd2(i,1)=imiss
      return
      end
C end-of-cpibd
C
C Simulate (gene-dropping) genotypes at a single autosomal locus
C Conditioning on typed ``founder'' genotypes (true founders/marry-ins
C plus individuals without typed parents) heading informative
C chains of descent 
C
      subroutine csimped(num,nfound,fa,mo,sex,untyped,set,xlinkd)
C
C  Pedigree structure
      integer MAXSIZ, MISS
      parameter(MAXSIZ=20, MISS=-9999)
      integer num,nfound,fa(MAXSIZ),mo(MAXSIZ),sex(MAXSIZ),set(MAXSIZ,2)
      logical untyped(MAXSIZ), xlinkd
      integer i
      logical fin
      do 15 i=nfound+1,num
      if (.not.untyped(fa(i)) .and. .not.untyped(mo(i))) then
        set(i,1)=MISS
        set(i,2)=MISS
      end if
   15 continue

C
C Main loop -- only update individuals with two typed parents
C
      iter=0
   20 continue      
        iter=iter+1
        fin=.true.
        do 30 i=nfound+1,num
        if (set(i,1).eq.MISS .and. 
     &      .not.untyped(fa(i)) .and..not.untyped(mo(i))) then
          if (set(fa(i),1).ne.MISS .and. set(mo(i),1).ne.MISS) 
     &    then
            if (xlinkd .and. sex(i).eq.1) then
              call mumson(i,mo(i),set)
            else
              call genoff(i,fa(i),mo(i),set)
            end if
          else
            fin=.false.
          end if
        end if
   30   continue
      if (.not.fin) goto 20
      return
      end
C end-of-csimped
C
C Simulate pedigree conditional on all founders (all must be typed) and 
C typed nonfounders
C
      subroutine fsimped(it,pedigree,num,nfound,id,fa,mo,set,sibd,
     &                   untyped,key,plevel)
      integer MAXSIZ, MISS 
      parameter(MAXSIZ=20, MISS=-9999)
      integer it, plevel
C  Pedigree structure
      character*10 pedigree
      integer num, nfound
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ)
      integer set(MAXSIZ,2), sibd(MAXSIZ,2)
      integer key(2*MAXSIZ)
      logical untyped(MAXSIZ)
C local variables
      integer found, i, failid, maxtry, nonf, pos, restart, ord(MAXSIZ)
      logical fin

      maxtry=2000
      found=0
      do 10 i=1,nfound
        found=found+1
        sibd(i,1)=found
        key(found)=set(i,1)
        found=found+1
        sibd(i,2)=found
        key(found)=set(i,2)
   10 continue
      nonf=num-nfound
      do 12 i=1, nonf
        ord(i)=nfound+i
   12 continue
C
C start of loop -- terminated by either a successful simulation
C of ibd & genotypes of nonfounders, or bailout due <maxtry> iterations 
C without success
C
      restart=0
   40 continue
        found=0
        do 15 i=1,nfound
          if (untyped(i)) then
            key(found+1)=-set(i,1)
            key(found+2)=-set(i,2)
          end if
          found=found+2
   15   continue
        do 46 i=nfound+1,num
          sibd(i,1)=MISS
          sibd(i,2)=MISS
   46   continue

   50   continue
          fin=.true.
          call permut(nonf, ord)
          do 70 pos=1,nonf
            i=ord(pos)
          if (sibd(i,1).eq.MISS) then
            if (sibd(fa(i),1).ne.MISS .and. sibd(mo(i),1).ne.MISS) then
              call genof4(i,fa(i),mo(i),set,sibd,untyped,key,failid)
              if (failid.ne.MISS) then
                if (restart.lt.maxtry) then
                  restart=restart+1
                  goto 40
                else
                  if (plevel.gt.0) then
                    write(*,'(/a,i4,a/7x,a,a8,2a/)') 
     2 'NOTE:  In iteration ',it,' of the Metropolis algorithm, ',
     3        'simulation of ibd had to restart due to person ',
     4        id(failid),' in pedigree ',pedigree
                    if (plevel.gt.1) then
                      do 997 j=1,nfound
                        write(*,'(a10,a,2(1x,i3),a,2(1x,i3),a,l1)') 
     2                    id(j),'       x       x',set(j,1), set(j,2),
     3                    ' {', sibd(j,1),sibd(j,2), '} ',untyped(j)
  997                 continue
                      do 998 j=nfound+1,num
                        write(*,'(3a10,2(1x,i3),a,2(1x,i3),a,l1)') 
     2                    id(j),id(fa(j)),id(mo(j)), set(j,1), set(j,2),
     3                    ' {', sibd(j,1),sibd(j,2), '} ',untyped(j)
  998                 continue
                    end if
                  end if
                  call simibd(2,pedigree,num,nfound,fa,mo,set,sibd)
                  return
                end if
              end if
            else
              fin=.false.
            end if
          end if
   70     continue
      if (.not.fin) goto 50
C
      call fill2(num,set,sibd,untyped,key)
      return
      end
C end-of-fsimped
C
C  Drop ibd-alleles conditional on observed markers
C  and randomly where marker genotype not observed -- restart
C  if later generates inconsistency
C  This version assumes all founders are typed 
C 
      subroutine genof4(idx,fa,mo,set,sibd,untyped,key,failid)
      integer KNOWN, MAXSIZ, MISS
      parameter(KNOWN=0, MAXSIZ=20, MISS=-9999)
      integer idx,fa,mo,failid
      integer set(MAXSIZ,2),sibd(MAXSIZ,2),key(2*MAXSIZ)
      logical untyped(MAXSIZ)
      integer a1,a2,first,maxtrials, second, tr1,tr2,trials
C sample without replacement from {{1,2},{1,2}}
      integer choice, i, seed, space(4)
C functions
      integer irandom

C
      failid=MISS
      maxtrials=4
      trials=0
      do 10 i=1,maxtrials
        space(i)=i
   10 continue

    1 continue

      trials=trials+1
      choice=irandom(trials, maxtrials)
      seed=space(choice)
      space(choice)=space(trials)

#if defined (F2C) || defined (SUN)
      tr1=and(seed,2)/2+1
      tr2=and(seed,1)+1
#else
      tr2=iand(seed,2)/2+1
      tr1=iand(seed,1)+1
#endif /* F2C */

      a1=sibd(fa,tr1)
      a2=sibd(mo,tr2)

C     write(*,*) 'In GENOF4():'
C      
C     write(*,*) 'Alleles: ',key(1),key(2),key(3),key(4),key(5),key(6)
C     write(*,*) 'Person #',idx,set(idx,1),'/',set(idx,2),
C    &           ' Untyped: ',untyped(idx)
C     write(*,*) 'Father #',fa, set(fa,1),'/',set(fa,2),
C    &           ' Untyped: ',untyped(fa)
C     write(*,*) 'Mother #',mo, set(mo,1),'/',set(mo,2),
C    &           ' Untyped: ',untyped(mo)
C     write(*,*) 'Transmitting: ',a1,' [',key(a1),' ], ',
C    &                            a2,' [',key(a2),' ]'
 
      if (untyped(idx)) then
        sibd(idx,1)=a1
        sibd(idx,2)=a2
      elseif (key(a1).lt.KNOWN .and. key(a2).lt.KNOWN) then
        first=irandom(1,2)
        second=3-first
        sibd(idx,first)=a1
        sibd(idx,second)=a2
        key(a1)=set(idx,first)
        key(a2)=set(idx,second)
      elseif (key(a1).lt.KNOWN .and. set(idx,1).eq.key(a2)) then
        sibd(idx,1)=a2
        sibd(idx,2)=a1
        key(a1)=set(idx,2)
      elseif (key(a1).lt.KNOWN .and. set(idx,2).eq.key(a2)) then
        sibd(idx,1)=a1
        sibd(idx,2)=a2
        key(a1)=set(idx,1)
      elseif (key(a2).lt.KNOWN .and. set(idx,2).eq.key(a1)) then
        sibd(idx,1)=a2
        sibd(idx,2)=a1
        key(a2)=set(idx,1)
      elseif (key(a2).lt.KNOWN .and. set(idx,1).eq.key(a1)) then
        sibd(idx,1)=a1
        sibd(idx,2)=a2
        key(a2)=set(idx,2)
      elseif (set(idx,1).eq.key(a1) .and. 
     &        set(idx,2).eq.key(a2)) then
        sibd(idx,1)=a1
        sibd(idx,2)=a2
      elseif (set(idx,1).eq.key(a2) .and. 
     &        set(idx,2).eq.key(a1)) then
        sibd(idx,1)=a2
        sibd(idx,2)=a1
      elseif (trials.lt.maxtrials) then
        goto 1
      else
        failid=idx
      end if
      return
      end
C end-of-genof4
C
C infer missing genotypes based on sibd values after run of fsimped
C assume all founders are typed
C
      subroutine fill2(num,set,sibd,untyped,key)
      integer MAXSIZ
      parameter(MAXSIZ=20)
C  Pedigree structure
      integer num, set(MAXSIZ,2), sibd(MAXSIZ,2), key(2*MAXSIZ)
      logical untyped(MAXSIZ)
C local variables
      integer g1,g2,i,tmp
C
      do 5 i=1,num
      if (untyped(i)) then
        g1=abs(key(sibd(i,1)))
        g2=abs(key(sibd(i,2)))
        if (g1.gt.g2) then
          tmp=g1
          g1=g2
          g2=tmp
          tmp=sibd(i,1)
          sibd(i,1)=sibd(i,2)
          sibd(i,2)=tmp
        end if
        set(i,1)=g1
        set(i,2)=g2
      end if
    5 continue
      return
      end
C end-of-fill2
C 
C  Simulate (gene-dropping) genotypes at a single autosomal locus
C  in a pedigree of arbitrary complexity 
C
      subroutine simped(num,nfound,fa,mo,cumfrq,set)
C
C  Pedigree structure
      integer MAXSIZ, MISS
      parameter(MAXSIZ=20, MISS=-9999)
      integer num, nfound, fa(MAXSIZ),mo(MAXSIZ), set(MAXSIZ,2)
      double precision cumfrq(*)
      integer i
      logical fin
      do 10 i=1,nfound
         call found(cumfrq,set(i,1))
         call found(cumfrq,set(i,2))
         call order(set(i,1),set(i,2))
   10 continue
      do 15 i=nfound+1,num
         set(i,1)=MISS
         set(i,2)=MISS
   15 continue

   20 continue      
        fin=.true.
        do 30 i=nfound+1,num
        if (set(i,1).eq.MISS) then
          if (set(fa(i),1).ne.MISS.and.set(mo(i),1).ne.MISS) 
     &    then
            call genoff(i,fa(i),mo(i),set)
          else
            fin=.false.
          end if
        end if
   30   continue
      if (.not.fin) goto 20
      return
      end
C end-of-simped
C 
C  Simulate (gene-dropping) genotypes at a single X-linked locus
C  in a pedigree of arbitrary complexity 
C
      subroutine xsimped(num,nfound,fa,mo,sex,cumfrq,set)
C
C  Pedigree structure
      integer MAXSIZ, MISS
      parameter(MAXSIZ=20, MISS=-9999)
      integer num, nfound, fa(MAXSIZ),mo(MAXSIZ), sex(MAXSIZ)
      integer set(MAXSIZ,2)
      double precision cumfrq(*)
      integer i
      logical fin
C functions
      real random

      do 10 i=1,nfound
        call found(cumfrq,set(i,1))
        if (sex(i).eq.1) then
          set(i,2)=set(i,1)
        else
          call found(cumfrq,set(i,2))
          call order(set(i,1),set(i,2))
        end if
   10 continue
      do 15 i=nfound+1,num
         set(i,1)=MISS
         set(i,2)=MISS
   15 continue

   20 continue      
        fin=.true.
        do 30 i=nfound+1,num
        if (set(i,1).eq.MISS) then
          if (set(fa(i),1).ne.MISS.and.set(mo(i),1).ne.MISS) 
     &    then
            if (sex(i).eq.1) then
              if (random().gt.0.5) then
                set(i,1)=set(mo(i),1)
              else
                set(i,1)=set(mo(i),2)
              end if
              set(i,2)=set(i,1)
            else
              call genoff(i,fa(i),mo(i),set)
            end if
          else
            fin=.false.
          end if
        end if
   30   continue
      if (.not.fin) goto 20
      return
      end
C end-of-xsimped
C
C founder frequency
C
      subroutine found(cumfrq,allele)
      integer allele
      double precision cumfrq(*)
      real x
C functions
      real random
      x=random()
      allele=0
   10 continue
        allele=allele+1
      if (x.gt.cumfrq(allele)) goto 10
      return
      end
C end-of-found
C
C transmit genes from parents to child
C 
      subroutine genoff(idx,fa,mo,set)
      integer MAXSIZ
      parameter(MAXSIZ=20)
      integer idx,fa,mo,set(MAXSIZ,2),a1,a2
      real random
      if (random().gt.0.5) then
        a1=set(fa,1)
      else
        a1=set(fa,2)
      end if
      if (random().gt.0.5) then
        a2=set(mo,1)
      else
        a2=set(mo,2)
      end if
      if (a1.gt.a2) then
        set(idx,1)=a2
        set(idx,2)=a1
      else
        set(idx,1)=a1
        set(idx,2)=a2
      end if
      return
      end
C end-of-genoff
C
C transmit single X-linked allele from mother to son
C 
      subroutine mumson(idx,mo,set)
      integer MAXSIZ
      parameter(MAXSIZ=20)
      integer idx,mo,set(MAXSIZ,2)
      real random
      if (random().gt.0.5) then
        set(idx,1)=set(mo,1)
      else
        set(idx,1)=set(mo,2)
      end if
      set(idx,2)=set(idx,1)
      return
      end
C end-of-mumson
C 
C 
C  Given genotypes at a single locus in a pedigree of arbitrary complexity, 
C  generate ibd by gene dropping a perfectly informative marker a la
C  John Blangero.
C  Type=1 unconditional, =2, conditional on observed markers
C
      subroutine simibd(typ,pedigree,num,nfound,fa,mo,set,sibd)
C
C  Pedigree structure
      integer MAXSIZ, MISS
      parameter(MAXSIZ=20, MISS=-9999)
      character*10 pedigree
      integer typ, num, nfound, fa(MAXSIZ),mo(MAXSIZ)
      integer set(MAXSIZ,2), sibd(MAXSIZ,2)
      integer i, ifault, found
      logical fin
      found=0
      do 10 i=1,nfound
        found=found+1
        sibd(i,1)=found
        found=found+1
        sibd(i,2)=found
   10 continue
      do 15 i=nfound+1,num
        sibd(i,1)=MISS
        sibd(i,2)=MISS
   15 continue
C
      if (typ.eq.1) then
   20   continue      
          fin=.true.
          do 30 i=nfound+1,num
          if (sibd(i,1).eq.MISS) then
            if (sibd(fa(i),1).ne.MISS.and.sibd(mo(i),1).ne.MISS) 
     &      then
              call genoff(i,fa(i),mo(i),sibd)
             else
              fin=.false.
            end if
          end if
   30     continue
        if (.not.fin) goto 20
      elseif (typ.eq.2) then
   50   continue      
          fin=.true.
          do 60 i=nfound+1,num
          if (sibd(i,1).eq.MISS) then
            if (sibd(fa(i),1).ne.MISS.and.sibd(mo(i),1).ne.MISS) 
     &      then
              ifault=0
              call genof2(pedigree,i,fa(i),mo(i),set,sibd,ifault)
              if (ifault.ne.0) then
                do 990 j=1, num
                  write(*,*) pedigree, j, fa(j), mo(j), set(j,1),
     &                      set(j,2), sibd(j,1), sibd(j,2)
  990           continue
              end if
            else
              fin=.false.
            end if
          end if
   60     continue
        if (.not.fin) goto 50
      end if
      return
      end
C end-of-simibd
C
C transmit ibd-marker from parents to child, 
C test if consistent with observed marker
C In this version 12/99, the sibd pairs are ordered by the collating
C order of the marker alleles they represent and
C not the collating order of the sibd allele.
C 
      subroutine genof2(pedigree,idx,fa,mo,set,sibd,ifault)
      integer MAXSIZ
      parameter(MAXSIZ=20)
      character*10 pedigree
      integer idx,ifault,fa,mo,set(MAXSIZ,2),sibd(MAXSIZ,2)
      integer c1, c2, maxtrials, par1, par2, tr1, tr2, trials
C sample without replacement from {{1,2},{1,2}}
      integer choice, i, seed, space(4)
C functions
      integer irandom
C
      maxtrials=4
      trials=0
      do 10 i=1,maxtrials
        space(i)=i
   10 continue

      c1=set(idx,1)
      c2=set(idx,2)
    1 continue
        trials=trials+1
        choice=irandom(trials, maxtrials)
        seed=space(choice)
        space(choice)=space(trials)

#if defined (F2C) || defined (SUN)
        tr1=and(seed,2)/2+1
        tr2=and(seed,1)+1
#else
        tr2=iand(seed,2)/2+1
        tr1=iand(seed,1)+1
#endif /* F2C */

        par1=set(fa,tr1)
        par2=set(mo,tr2)
C
C     write(*,*) 'Prop: ',trials,' choice:',choice,
C    2   ' space: ',(space(i),i=1,4),
C    3   ' seed: ',seed,'-> ',tr1,tr2
      if (c1.eq.par1 .and. c2.eq.par2) then
        sibd(idx,1)=sibd(fa,tr1)
        sibd(idx,2)=sibd(mo,tr2)
      elseif (c1.eq.par2.and.c2.eq.par1) then
        sibd(idx,1)=sibd(mo,tr2)
        sibd(idx,2)=sibd(fa,tr1)
      elseif (trials.lt.maxtrials) then
        goto 1
      else 
        write(*,'(a/7x,a/a/)') 
     2    'ERROR: Probable mendelian inconsistency encountered',
     3    'performing ibd simulation.  Stopping prematurely.'
        write(*,*) 'In pedigree ',pedigree,', index person #',idx,
     2    ' has genotype: ',c1,c2,' Parental genotypes: ',
     3    set(fa,1),set(fa,2),' & ',set(mo,1),set(mo,2)
        ifault=1
      end if
      return
      end
C end-of-genof2
C
C count the untyped founder x founder matings for use by Metropolis algs
C
      subroutine tabmat(num,nfound,fa,mo,untyped,nummat,cntmat)
      integer MAXALL, MAXSIZ
      parameter(MAXALL=2, MAXSIZ=20)
      integer num,nfound,fa(MAXSIZ),mo(MAXSIZ)
      logical untyped(MAXSIZ)
      integer nummat, cntmat(MAXALL,2)
C local variables
      integer i

      nummat=0
      do 5 i=1,MAXALL
        cntmat(i,1)=0
        cntmat(i,2)=0
    5 continue
      do 10 i=nfound+1,num
      if (untyped(fa(i)) .and. untyped(mo(i)) .and.
     &    fa(i).le.nfound .and. mo(i).le.nfound) then
        call mattab(fa(i),mo(i),nummat,cntmat)
      end if
   10 continue 
      return
      end
C end-of-tabmat
C
C update list of matings -- simple insertion sort
C
      subroutine mattab(key1,key2,num,cnt)
      integer MAXALL
      parameter(MAXALL=2)
      integer key1, key2, num, cnt(MAXALL,2)
      integer i,pos
      pos=0
    1 continue 
        pos=pos+1
      if (pos.le.num .and. (key1.gt.cnt(pos,1) .or.
     &    (key1.eq.cnt(pos,1) .and. key2.gt.cnt(pos,2)))) goto 1
      if (pos.gt.num .or. key2.ne.cnt(pos,2)) then
        if (num.gt.MAXALL) then
          write(*,'(a,i2,a/)') 
     &      'ERROR: More than ',MAXALL,' UnT x UnT founder matings.'
        else
          do 2 i=num,pos,-1
            cnt(i+1,1)=cnt(i,1)
            cnt(i+1,2)=cnt(i,2)
    2     continue
          num=num+1
          cnt(pos,1)=key1
          cnt(pos,2)=key2
        end if
      end if
      return
      end
C end-of-mattab
C 
C Parse a mixed model
C
      subroutine mksegmod(narg, words, trait, gt, thresh, offset,
     2                    censor, nterms, terms, nloci, loc, loctyp,
     3                    priran, nqtl, paract, par, parscal,
     4                    linkf, modtyp, shap)
      integer MAXCOL, MAXLOC, MAXPAR, MISS, RANPAR
      parameter(MAXPAR=50, MAXLOC=10000, MAXCOL=MAXLOC+5, 
     &          MISS=-9999, RANPAR=24)
      integer censor, gt, linkf, modtyp, nqtl, nterms, offset, 
     &        priran, trait
      double precision shap, thresh
      integer terms(MAXLOC)
C locus names and types
      integer nloci
      character*20 loc(MAXLOC)
      integer loctyp(MAXLOC)
C command arguments
      integer narg
      character*20 words(MAXCOL)
C model pars 1=P(all) 2=a 3=d 4=AA 5=AB 6=BB 
C            7=mu 8=totvar 9=VA 10=VD 11=VG 12=VC 13=VS 14=VE 
C            15=sdG 16=sdC 17=sdS 18=sdE
C            19=a2 20=d2 21=h2 22=c2 23=s2 24=e2 
C            25..MAXPAR=Betas
      integer paract(MAXPAR)
      double precision par(MAXPAR), parscal(MAXPAR)
      character*3 keyword
      integer i, icov
      double precision p, q
C functions
      logical iscomp, isreal
      integer eow
      double precision fval

      censor=MISS
      linkf=0
      modtyp=1
      nqtl=1
      nterms=0
      offset=MISS
      priran=0
      shap=MISS 
      do 1 i=1, MAXPAR
        paract(i)=0
        par(i)=MISS 
        parscal(i)=0.0d0
    1 continue    
C default model additive QTL (free: mu, VT, a2)
      paract(7)=1
      paract(8)=1
      paract(19)=1
      paract(1)=2
      paract(2)=3
      paract(4)=3
      paract(5)=3
      paract(6)=3
      paract(9)=3
      paract(14)=3
      paract(18)=3
      paract(24)=3
      gt=0
      thresh=MISS
      i=3
      if (iscomp(words(3))) then
        call docomp(i, words, gt, thresh)
      end if

    5 if (i.gt.narg) goto 10
        if (words(i).ne.'+') keyword=words(i)(1:3)
C parameters to be estimated
        if (keyword.eq.'d' .or. keyword.eq.'vd' .or.
     &      keyword.eq.'d2') then
          paract(20)=1
          paract(3)=3
          paract(10)=3
          i=i+1
        else if (keyword.eq.'p' .or. keyword.eq.'fre') then
          paract(1)=1
          i=i+1
        else if (keyword.eq.'a' .or. keyword.eq.'va') then
          i=i+1
        else if (keyword.eq.'g' .or. keyword.eq.'vg' .or.
     &           keyword.eq.'h2') then
          paract(21)=1
          paract(11)=3
          paract(15)=3
          i=i+1
        else if (keyword.eq.'c' .or. keyword.eq.'vc' .or.
     &           keyword.eq.'c2') then
          paract(22)=1
          paract(12)=3
          paract(16)=3
          i=i+1
        else if (keyword.eq.'s' .or. keyword.eq.'vs' .or.
     &           keyword.eq.'s2') then
          paract(23)=1
          paract(13)=3
          paract(17)=3
          i=i+1
        else if (i.lt.narg .and. keyword.eq.'lin') then
          if (words(i+1).eq.'ln') then
            linkf=5
          else if (words(i+1)(1:3).eq.'mft') then
            linkf=4
          else if (words(i+1)(1:3).eq.'pro') then
            linkf=3
          else if (words(i+1)(1:3).eq.'log') then
            linkf=2
          else if (words(i+1)(1:2).eq.'id') then
            linkf=1
          else
            linkf=ival(words(i+1))
          end if
          if (linkf.eq.0) linkf=1
          i=i+2
        else if (i.lt.narg .and. keyword.eq.'lik') then
          if (words(i+1)(1:3).eq.'wei') then
            modtyp=4
          else if (words(i+1)(1:3).eq.'poi') then
            modtyp=3
          else if (words(i+1)(1:3).eq.'bin') then
            modtyp=2
          else 
            modtyp=1
          end if
          i=i+2
        else if (i.lt.narg .and. keyword.eq.'fix') then
          if (words(i+1).eq.'var') then
            paract(8)=2
            i=i+2
          else if (words(i+1).eq.'p' .or. words(i+1).eq.'fre') then
            paract(1)=2
            i=i+2
          else if (words(i+1).eq.'a' .or. words(i+1).eq.'va') then
            paract(19)=2
            i=i+2
          else if (words(i+1).eq.'d' .or. words(i+1).eq.'vd') then
            paract(20)=2
            i=i+2
          else if (words(i+1).eq.'g' .or. words(i+1).eq.'vg') then
            paract(11)=2
            paract(21)=3
            i=i+2
          else if (words(i+1).eq.'c' .or. words(i+1).eq.'vc') then
            paract(12)=2
            paract(22)=3
            i=i+2
          else if (words(i+1).eq.'s' .or. words(i+1).eq.'vs') then
            paract(13)=2
            paract(23)=3
            i=i+2
          else if (words(i+1).eq.'m' .or. words(i+1).eq.'mu') then
            paract(7)=2
            i=i+2
          else 
            write(*,'(3a)')
     &          'Cannot fix "', words(i+1)(1:eow(words(i+1))),'".'
            i=i+2
          end if
C starting values for parameters or values to evaluate likelihood at
        else if (i.lt.narg .and. isreal(words(i+1))) then
          if (keyword.eq.'ava') then
            par(2)=fval(words(i+1))
            i=i+2
          else if (keyword.eq.'dva') then
            par(3)=fval(words(i+1))
            i=i+2
          else if (keyword.eq.'pva') then
            par(1)=fval(words(i+1))
            i=i+2
          else if (keyword.eq.'mu') then
            par(7)=fval(words(i+1))
            i=i+2
          else if (keyword.eq.'var') then
            par(8)=fval(words(i+1))
            i=i+2
          else if (keyword.eq.'AA') then
            par(4)=fval(words(i+1))
            i=i+2
          else if (keyword.eq.'AB') then
            par(5)=fval(words(i+1))
            i=i+2
          else if (keyword.eq.'BB') then
            par(6)=fval(words(i+1))
            i=i+2
          else if (keyword.eq.'SD') then
            par(18)=fval(words(i+1))
            i=i+2
          else if (keyword.eq.'gva') then
            par(11)=fval(words(i+1))
            i=i+2
          else if (keyword.eq.'cva') then
            par(12)=fval(words(i+1))
            i=i+2
          else if (keyword.eq.'sva') then
            par(13)=fval(words(i+1))
            i=i+2
          else if (keyword.eq.'nqt') then
            nqtl=ival(words(i+1))
            i=i+2
          else if (keyword.eq.'sha') then
            shap=fval(words(i+1))
            i=i+2
          else 
            write(*,'(3a)') 'Skipping unknown keyword "',
     &                      words(i)(1:eow(words(i))),'".'
            i=i+1
          end if  
        else if (i.lt.narg .and. keyword.eq.'cov') then
          call gettrait(words(i+1),10,0,nloci,loc,loctyp,icov)
          if (icov.ne.MISS .and. nterms.lt.(MAXLOC-1)) then
            nterms=nterms+1
            terms(nterms)=icov
          else
            write(*,'(3a)') 'Skipping "', 
     &          words(i+1)(1:eow(words(i+1))),'": not an active trait.'
          end if
          i=i+2
        else if (i.lt.narg .and. keyword.eq.'off') then
          call gettrait(words(i+1),3,0,nloci,loc,loctyp,offset)
          if (offset.eq.MISS) then
            write(*,'(3a)') 'Variable "', words(i+1)(1:eow(words(i+1))),
     &                      '": not suitable for offset.'
          end if
          i=i+2
        else if (i.lt.narg .and. keyword.eq.'cen') then
          call gettrait(words(i+1),3,4,nloci,loc,loctyp,censor)
          if (censor.eq.MISS) then
            write(*,'(3a)') 'Variable "', words(i+1)(1:eow(words(i+1))),
     &                      '": not suitable for censoring indicator.'
          end if
          i=i+2
        else if (keyword.eq.'pri') then
          priran=1
          i=i+1
        else 
          write(*,'(3a)') 'Skipping unknown keyword "',
     &                    words(i)(1:eow(words(i))),'".'
          i=i+1
        end if
        goto 5
   10 continue
      nterms=nterms+1
      terms(nterms)=trait
C
C if nqtl=0, assume a Gaussian additive polygenic model
C
      if (nqtl.eq.0) then
        paract(1)=0
        paract(2)=0
        paract(3)=0
        paract(4)=0
        paract(5)=0
        paract(6)=0
        paract(9)=0
        paract(19)=0
        paract(20)=0
        if (paract(21).eq.0 .and. paract(22).eq.0 .and.
     &      paract(23).eq.0) then
          paract(21)=1
          paract(11)=3
          paract(15)=3
          paract(24)=3
        end if
C
C if specified p+var+genotypic means, set  a, d, mu, and then VA, VD and VE
C 1=P(all) 2=a 3=d 4=AA 5=AB 6=BB 7=mu 8=totvar 9=VA 10=VD 11=VG 12=VC 13=VS 14=VE 
C 15=sdG 16=sdC 17=sdS 18=sdE 19=a2 20=d2 21=h2 22=c2 23=s2 24=e2 25..MAXPAR=Betas
C
      else if (par(1).ne.MISS .and. par(4).ne.MISS .and. 
     2    par(5).ne.MISS .and. par(6).ne.MISS  .and.
     3    (par(8).ne. MISS .or. par(18).ne. MISS)) then
        p=par(1)
        q=1.0d0-p
        par(1)=0.5d0*abs(par(6)-par(4))
        if (paract(20).ne.0) then
          par(3)=par(5)-0.5d0*(par(4)+par(6))
        else
          par(3)=0.0d0
        end if
        par(4)=p*p*par(4) + 2*p*q*par(5) + q*q*par(6)
        par(9)=2*p*q*(par(2)+(par(1)+par(1)-1.0d0)*par(3))**2
        par(7)=4*p*q*p*q*par(3)*par(3)
        if (par(8).eq.MISS) then
          par(14)=par(18)*par(18)
          par(8)=par(9)+par(10)+par(14)
        else
          par(14)=par(8)-par(9)-par(10)
          par(8)=sqrt(par(14))
        end if
      else if (par(4).ne.MISS .or. par(5).ne.MISS .or.
     &         par(6).ne.MISS) then
        write(*,'(/2a)') 'NOTE:  Need to specify 3 genotypic means, ',
     &                   'allele frequency and variance.'
      end if
C Binomial likelihood can be explicitly requested, but is usually
C inferred using the trait type 
C If binomial or poisson likelihood, alter parameter set
      if (loctyp(trait).eq.4 .or. thresh.ne.MISS) then
        modtyp=2
      end if
      if (modtyp.eq.2 .or. modtyp.eq.3 .or. modtyp.eq.4) then
        paract(8)=0
        paract(24)=0
        paract(14)=3
        paract(18)=3
        do 100 i=21, 23
        if (paract(i).eq.1 .or. paract(i).eq.2) then
          paract(i-10)=paract(i)
          paract(i)=0
          par(i)=MISS
        end if
  100   continue
      end if
C if link function not set, set to conjugate link
      if (linkf.eq.0) then
        if (modtyp.eq.1) then
          linkf=1
        else if (modtyp.eq.2) then
          linkf=2
        else if (modtyp.eq.3 .or. modtyp.eq.4) then
          linkf=5
        end if
      end if
      return
      end
C end-of-mksegmod
C
C Names and preliminary estimates for fixed effects part of mixed model
C
      subroutine preseg(modtyp, nvar, fixed, loc, gene, numal, name, 
     &                  b, r, parnam, paract, par, parscal)
      integer MAXALL, MAXCOV, MAXIBD, MAXLOC, MAXPAR, 
     &        MAXSIZ, MAXTER, RANPAR  
      parameter(MAXALL=2, MAXLOC=10000, MAXSIZ=20, 
     2          MAXIBD=20, MAXTER=MAXIBD/2, 
     3          MAXCOV=MAXTER*(MAXTER+1)/2, MAXPAR=50, RANPAR=24)
C
C nvar=number of variables
C gene=factor coded gene (numal-1 levels)
C nfix=number of columns in design matrix
C      
      integer gene, modtyp, numal, nvar
      integer fixed(MAXSIZ), name(MAXALL)
      character*20 loc(MAXLOC)
      character*14 parnam(MAXPAR)
      integer paract(MAXPAR)
      double precision par(MAXPAR), parscal(MAXPAR)
      double precision b(MAXTER), r(MAXCOV)
      integer i, j, ii, pos, ppos
      character*3 allel
C functions
      integer eow

      i=1
      ii=1
      par(7)=b(i)
      parscal(7)=sqrt(r(ii))
      ppos=RANPAR
      do 20 j=1, nvar-1
        pos=fixed(j)
        ncat=1 
        if (pos.eq.gene) ncat=numal-1
        do 25 k=1, ncat
          i=i+1
          ii=ii+i
          ppos=ppos+1
          par(ppos)=b(i)
          parscal(ppos)=sqrt(r(ii))
          paract(ppos)=1
          if (pos.ne.gene) then
            parnam(ppos)=loc(pos)
          else
            call wrall(name(k+1), allel)
            call juststr('l',allel,3)
            parnam(ppos)=loc(pos)(1:min(10,eow(loc(pos)))) // '*' // 
     &                   allel(1:eow(allel))
          end if
   25   continue
   20 continue
      return
      end
C end-of-preseg
C 
C Mixed model MCMC: simulate genotypes at 1..N unlinked QTLs
C                            Gaussian breeding values
C                            family intercepts
C                            regression coefficients for fixed effects
C
      subroutine segsim(wrk,wrk2,twrk,wrkfil,linkf,modtyp,shap,trait,
     2             gt, thresh, offset, censor, nfix, nvar, fixed, gene,
     3             numal, name, loc,loctyp,locpos, burnin, iter, nbatch,
     4             tune, nchain, nqtl, parnam, par, paract, parscal,
     5             mean, pedigree, num, nfound, id, fa, mo, sex, locus,
     6             numloc, set, hset, terms, cumfrq, ibdcount,mlik,
     7             mpar, priran, mcalg, plevel)
      integer IBDSIZ, MAXALL, MAXCHA, MAXHAP, MAXIBD, MAXLOC,
     &         MAXPAR, MAXPEN, MAXSIZ, MAXTER, MISS, RANPAR, SLMAX
      parameter(MAXSIZ=20, MAXLOC=10000, MISS=-9999, MAXHAP=MAXLOC/2, 
     2          MAXALL=2, MAXPAR=50, MAXCHA=4, MAXPEN=3, 
     3          MAXIBD=20, IBDSIZ=MAXIBD*(MAXIBD+1)/2, 
     4          MAXTER=MAXIBD/2, RANPAR=24, SLMAX=10)
      integer burnin, censor, gene, gt, iter, linkf, mcalg, mpar, 
     2        modtyp, nbatch, nfix, nqtl, offset, plevel, priran, 
     3        trait, twrk, wrk, wrk2
      double precision shap, thresh
      character*144 wrkfil
      double precision mlik
C
C model pars 1=P(all) 2=a 3=d 4=AA 5=AB 6=BB 
C            7=mu 8=totvar 9=VA 10=VD 11=VG 12=VC 13=VS 14=VE 
C            15=sdG 16=sdC 17=sdS 18=sdE
C            19=a2 20=d2 21=h2 22=c2 23=s2 24=e2 
C            25..MAXPAR=Betas
C a and d are Falconer style so
C VA = 2pq(a+(p-q)d)^2
C VD = 4(pqd)^2
C tune=fudge factor for parameter proposals, usually 0.3
C linkf=link function 1=identity 2=logit 3=probit 4=MFT 5=log
C modtyp=likelihood 1=gaussian 2=binomial 3=poisson
C nchain=number of random effects chains (actually copies per family)
C nvar=number of named variables (covariates and trait)
C nfix=number of columns in design matrix
C offset=address of offset variable
C censor=address of the right censoring (binary) variable
C      
      character*14 parnam(MAXPAR)
      integer paract(MAXPAR)
      real tune
      double precision par(MAXPAR), parscal(MAXPAR)
C list of fixed effects
      integer nvar, fixed(MAXSIZ)
C and their observed means (for imputation)
      double precision mean(MAXTER)
C if a marker among the covariates, the allele names
      integer numal
      integer name(MAXALL)
C list of active random and fixed effects
      integer nterms, terms(MAXSIZ)
C Locus structure:
C number of loci, locus name, locus type, and locus position in file
      character*20 loc(MAXLOC)
      integer loctyp(MAXLOC),locpos(MAXLOC)
C Pedigree structure:
      integer actset, num, nfound, numloc
      character*10 pedigree
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ), sex(MAXSIZ) 
      double precision locus(MAXSIZ, MAXLOC)
C proposal and existing QTL genotypes 
      integer nchain
      integer set(MAXSIZ,2), hset(MAXSIZ,MAXHAP,2)
C
C model pars 1=P(all) 2=a 3=d 4=AA 5=AB 6=BB 
C            7=mu 8=totvar 9=VA 10=VD 11=VG 12=VC 13=VS 14=VE 
C            15=sdG 16=sdC 17=sdS 18=sdE
C            19=a2 20=d2 21=h2 22=c2 23=s2 24=e2 
C            25..MAXPAR=Betas
C
      double precision blpar(MAXPAR), bupar(MAXPAR),
     &                 epar(MAXPAR), sdpar(MAXPAR)
C model parameters
      double precision estlik, famlik, fammu, gtplik, lik,
     &                 newlik, cvlik
      double precision cumfrq(MAXALL)
      double precision glogf(MAXPEN)
      double precision val(MAXSIZ), bval(MAXSIZ), mval(MAXSIZ), 
     &                 rsd(MAXSIZ)
C work matrix to generate inbreeding for breeding values
      double precision ibdcount(IBDSIZ)
      double precision tmpval(MAXLOC)
C
C batch intercorrelations etc
C store this and previous batch to calculate order-1 autocorr
C batchit indicates which observation up to in this batch (1..sampit)
C sampit=max(1, 10*iter/nbatch), so nbatch batches per run
C curbat alternates which column is being currently updated
C proprate is acceptance rate for proposals
      integer batchit, bpar, curbat, sampit
      integer np(MAXPAR)
      integer gprop, grate, proprate(MAXPAR), proptyp(MAXPAR)
      double precision  batch(MAXPAR+3,2), covbat(MAXPAR+3),
     &                  mubat(MAXPAR+3,2), varbat(MAXPAR+3,2)
C interrupt
      integer irupt
      common /flag/ irupt
C
C Offset and censoring variables for fixed effect model are in locus()
C after the fixed effects
C
      integer cpos, nextra, opos
C
C other local variables
C maxit=10*(iter+burnin), 
C nprops=no. of proposal types, npar=no. of parameters in model
C nsubit=number of times genotype sampler run per family 
C set to tot*max(1,nqtl)/nfam
C oobounds=proposal outside bounds
C pos=current cursor pos
C ncol=nval+2 (for offset and censoring indicator)
C anyran=any random effects
C bsign=reverse sign of coefficients (eg Weibull as Poisson)
C enull=null hypothesis value for parameter (usually 0)
C likcor=1/nchains (likelihood correction for data replication)
C lmax, rmax=no. of slice expansion iterations to left and right
C
      integer anyran, bsign, i, j, maxit, ncol, nfam, nobs, npar, 
     2        nprops, nships, nsubit, nvals, oobounds, pos,
     3        tailp, tot, totobs, tpos, typ, wrknum

      double precision den, enull, likcor, sd
C
C adjust=1.0 when binomial so trait scores as 0,1
      double precision adjust
C
C baslik=offset for the likelihoods to be averaged etc; 
C ncomp=number of random effects per person;
C qtlden=multiplier to adjust QTL parameters to allow for multiple QTLS;
C hival=upper bound for pars (binomial v. continuous models); nullik=lik
C for null model proposal; pval=empirical p for null; ymean, yvar=sample
C grand mean and variance.
C
      double precision baslik, qtlden, totfrq, 
     &                 hival, nullik, pval, ymean, yvar, zstat
C empfrq=realized QTL1 allele freq in pedigrees; 
C empmu, empvar=realized pA,VA,VC,VS,VE,V(A+C+S+E)/VE in pedigrees
      integer tfound, totall
      double precision empfrq, empvar(6), empmu(6), empve, empvef
      logical last, mkstart
      character*1 ch, algid(2)
      character*8 densid(4)  
      character*8 linkid(5)
C functions
      logical complete
      integer eow, irandom
      double precision isaff, logit
C
      data densid /'Gaussian', 'Binomial', 'Poisson', 'Weibull'/
      data linkid /'Identity', 'Logit   ', 'Probit  ', 'MFT     ',
     &             'Log'/
      data algid /'S','M'/

      write(*,'(/a/a,a10,a/a)') 
     2  '------------------------------------------------',
     3  'Finite Polygenic Model analysis for "',loc(trait),'"',
     4  '------------------------------------------------' 

      npar=RANPAR+nfix
C extra parameters eg shape of multiparameter density
      if (modtyp.eq.4) then
        npar=npar+1
        parnam(npar)='log Shape'
        paract(npar)=1
      end if
C variance components estimated from distribution of individuals' random effects
      bpar=npar+1
      parnam(bpar)='Realized pA'
      paract(bpar)=0
      if (paract(1).gt.0) paract(bpar)=4
      bpar=bpar+1
      parnam(bpar)='Realized VG'
      paract(bpar)=0
      if (paract(11).gt.0 .or. par(21).gt.0) paract(bpar)=4
      bpar=bpar+1
      parnam(bpar)='Realized VC'
      paract(bpar)=0
      if (paract(12).gt.0 .or. par(22).gt.0) paract(bpar)=4
      bpar=bpar+1
      parnam(bpar)='Realized VS'
      paract(bpar)=0
      if (paract(13).gt.0 .or. par(23).gt.0) paract(bpar)=4
      bpar=bpar+1
      parnam(bpar)='Realized VE'
      paract(bpar)=4
      bpar=bpar+1
      parnam(bpar)='VE(F+R)/VE(F)'
      paract(bpar)=4

      if (nqtl .gt. MAXHAP) then
        write(*,'(a)') 'ERROR: Too many QTLs specified in fpm.'
        return
      end if
      ncol=nfix+2
      cpos=0
      nextra=0
      opos=0
      if (offset.ne.MISS) then
        nextra=nextra+1
        fixed(nvar+nextra)=offset
        opos=locpos(offset)
      end if
      if (censor.ne.MISS) then
        nextra=nextra+1
        fixed(nvar+nextra)=censor
        cpos=locpos(censor)
      end if
      wrknum=1
      tpos=locpos(trait)
C
C Initial values and bounds for model parameters
C
      bsign=1
      nterms=0
      oobounds=0

      hival=1.0d99
      adjust=0.0d0
      if (loctyp(trait).eq.4 .or. thresh.ne.MISS) adjust=1.0d0
      if (modtyp.eq.2 .and. (linkf.eq.1 .or. linkf.eq.4)) then
        hival=0.99999d0
      end if
      do 1 i=1, npar
        if (paract(i).eq.1) then
          nterms=nterms+1
          terms(nterms)=i
        end if
        np(i)=0
        proprate(i)=0
        proptyp(i)=0
    1 continue    
      do 1000 i=1, bpar
        epar(i)=0.0d0
        batch(i,1)=0.0d0
        batch(i,2)=0.0d0
        covbat(i)=0.0d0
        varbat(i,1)=0.0d0
        varbat(i,2)=0.0d0
        blpar(i)=0.00001d0 
        bupar(i)=hival  
        mubat(i,1)=0.0d0
        mubat(i,2)=0.0d0
        sdpar(i)=0.0d0
 1000 continue    
      do 1001 i=1, nfix
        blpar(RANPAR+i)=-1.0d99
        bupar(RANPAR+i)=1.0d99
 1001 continue    
C tighter bounds (0-1) on heritabilities etc 
      do 1002 i=19, 24
        bupar(i)=0.99999d0
 1002 continue    

      blpar(7)=-1.0d99
C bounds adjustments if binomial likelihood
      if (modtyp.eq.2) then
        if (linkf.eq.1) blpar(7)=0.00001d0
        bupar(8)=0.25d0
      end if
C default QTL allele frequency of 0.5
      if (par(1).eq.MISS) par(1)=0.5d0
      blpar(1)=0.000001d0
      bupar(1)=0.5d0
C Weibull model parameters need to be reversed
      if (modtyp.eq.4) then
        bsign=-1
        par(npar)=log(shap)
        parscal(npar)=0.05d0
        blpar(npar)=0.000001d0
      end if
C
      tailp=0
      baslik=0.0d0
      empfrq=0.0d0
      estlik=0.0d0
      fammu=0.0d0
      likcor=1.0d0/dfloat(nchain)
      nullik=0.0d0
      cvlik=0.0d0
      totfrq=0.0d0
      cumfrq(1)=0.5d0 
      cumfrq(2)=1.0d0
      call genfreq(par(1), cumfrq, glogf)
      qtlden=1.0d0/dfloat(max(1,nqtl))
      do 3 i=1, MAXSIZ
        bval(i)=0.0d0
        mval(i)=0.0d0
    3 continue
      gprop=0
      grate=0

      last=.false.
      nfam=0
      nships=0
      totobs=0 
      famlik=-1.0d99
      gtplik=-1.0d99
      lik=0.0d0
      ymean=0.0d0
      yvar=0.0d0
      call newnam(wrknum, wrkfil)
      open(twrk,file=wrkfil,form='unformatted')
      rewind(wrk)
    5 continue
        call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &             numloc, last)
        if (last) goto 20
C
        if (actset.le.0) goto 5
C
        nobs=0
        cfa=MISS
        cmo=MISS
        do 50 i=1,num
          val(i)=MISS
          if (complete(i, nvar+nextra, fixed, locpos, loctyp, locus)) 
     &    then
            nobs=nobs+1
            if (num.gt.nfound) then
              if (fa(i).ne.cfa .and. mo(i).ne.cmo) then
                cfa=fa(i)
                cmo=mo(i)
                nships=nships+1
              end if
            end if
            totobs=totobs+1
            if (thresh.ne.MISS) then
              val(i)=isaff(locus(i,tpos),thresh,gt)-adjust
            else
              val(i)=locus(i,tpos)-adjust
            end if
            call moment(totobs,val(i),ymean,yvar)
          end if
C everyone needs fixed effects -- impute missing values
          call fixeff(i, 0, gene, numal, name, nvar, fixed, 
     &                loctyp, locpos, mean, locus, tmpval)
C fixed effects model offset
          tmpval(ncol-1)=0.0d0
          if (opos.gt.0 .and. locus(i, opos).ne.MISS) then
            tmpval(ncol-1)=locus(i, opos)
          end if
C censoring variable
          tmpval(ncol)=MISS 
          if (val(i).ne.MISS) tmpval(ncol)=1.0d0
          if (cpos.gt.0 .and. locus(i, cpos).ne.MISS) then
            tmpval(ncol)=locus(i, cpos)-1.0d0
          end if
C Now transfer observation to work matrix
          do 53 j=1, ncol   
            locus(i,j)=tmpval(j)
   53     continue
   50   continue
        if (nobs.gt.0) then
          nfam=nfam+1
          call segerr(num,nfound,fa,mo,ibdcount,rsd)
          do 55 j=1, nqtl
            call simped(num,nfound,fa,mo,cumfrq,set)
            do 60 i=1, num
              hset(i,j,1)=set(i,1)
              hset(i,j,2)=set(i,2)
   60       continue
   55     continue
          do 70 i=1, nchain
            call fpmwr(twrk,ncol,nqtl,famlik,gtplik,fammu,pedigree,
     &             num,nfound,id,fa,mo,sex,locus,val,bval,rsd,mval,hset)
   70     continue
        end if
C
      goto 5
   20 continue
      yvar=yvar/dfloat(totobs)
      maxit=10*(iter+burnin)
C
C number of random effects per individual 
C Variance may be fixed 
C
      anyran=0
      ncomp=nqtl
      if (paract(11).eq.1 .or. paract(21).eq.1 .or.
     &    paract(11).eq.2 .or. paract(21).eq.2) then
        ncomp=ncomp+1
      end if
      if (paract(13).eq.1 .or. paract(23).eq.1 .or.
     &    paract(13).eq.2 .or. paract(23).eq.2) then
        ncomp=ncomp+1
      end if
      if (ncomp.gt.0 .or. paract(12).eq.1 .or. paract(22).eq.1 .or.
     &    paract(12).eq.2 .or. paract(22).eq.2) then
        anyran=1
      end if
C sampling fraction for batches
      sampit=max(1, 10*iter/nbatch)

      if (nfam.gt.0) then
        write(*,'(5(/a,i7))') 
     2    'Number of families         = ', nfam,
     3    'Number of sibships         = ', nships,
     4    'Number of observations     = ', totobs,  
     5    'Burn-in MCMC iterations    = ', 10*burnin,
     6    'Evaluated MCMC iterations  = ', 10*iter
        if (mcalg.eq.1) then
          write(*,'(a)') 'Metropolis sampler         = Sliced'
        else
          write(*,'(a)') 'Metropolis sampler         = Ordinary'
        end if
        write(*,'(2a/2a)') 
     2    'Model type                 = ', densid(modtyp),
     3    'Link type                  = ', linkid(linkf)
        if (censor.ne.MISS) then
          write(*,'(2a)') 
     2      'Censoring indicator        = ', loc(censor)
        end if
        write(*,'(3a,$)') 
     2    'Fixed Effects              = ', 
     3       loc(trait)(1:eow(loc(trait))), ' ~ mu'
        pos=34+eow(loc(trait))
        do 75 j=1, nvar-1
          write(*,'(2a,$)')
     &     ' + ', loc(fixed(j))(1:eow(loc(fixed(j))))
          pos=pos+3+eow(loc(fixed(j)))
          if (terms(j) .eq. gene) then
            write(*,'(a,$)') '(M)'
            pos=pos+3
          end if
          if (pos.gt.80) then
            pos=35
            write(*,'(/30x,a,$)') ' '
          end if
   75   continue
        if (offset.ne.MISS) then
          write(*,'(/2a)') 
     2      'Offset (for intercept)     = ', loc(offset)
        end if
        write(*,'(/a,$)') 'Random Effects             =' 
        do 80 j=9, 14
        if (paract(j).ne.0) then
          write(*,'(2a,$)') ' ', parnam(j)(1:eow(parnam(j)))
        end if
   80   continue
        write(*,'(/2(/a,f12.6))') 
     2    'Global trait mean          = ', ymean, 
     3    'Global trait variance      = ', yvar   
      else
        write(*,'(/a)') 'No eligible families!'
        close(twrk,status='delete')
        return
      end if
C
C Two alternate samplers: one genotypic, updates family by family
C                         the other, variance components, updates whole dataset
C
C Generate starting values and proposal stepsizes
      parscal(1)=0.25d0
C Total mean and variance
      if (par(7).eq.MISS) then
        par(7)=ymean
        if (modtyp.eq.2 .and. linkf.ne.1) then
          par(7)=logit(ymean)
        else if ((modtyp.eq.3 .and. linkf.eq.5) .or. modtyp.eq.4) then
          par(7)=log(ymean)
        end if
      end if
C This set by preseg() if covariates
      if (nfix.eq.0) then
        if (modtyp.eq.1) then
          parscal(7)=sqrt(yvar/dfloat(totobs))
        else if (modtyp.eq.2) then
          parscal(7)=0.05d0
        else
          parscal(7)=sqrt(par(7)/dfloat(totobs))
        end if
      end if
      if (par(8).eq.MISS) then
        par(8)=yvar
        if (linkf.eq.4) then
          par(8)=1.0d0
        end if
      end if
      parscal(8)=tune*yvar  
      if (modtyp.gt.1) parscal(8)=tune
      do 84 j=9, 14
        if (par(j).eq.MISS) then
          if (paract(j).eq.1) then
            par(j)=0.5d0
          else
            par(j)=0.0d0
          end if
        end if
        parscal(j)=sqrt(parscal(8))
   84 continue
C
C These give stepsize for random effects proposals: VG, VC, VS
C
      do 85 j=15, 18
        parscal(j)=sqrt(parscal(j-4))
   85 continue
C
      do 86 j=19, 23
        if (par(j).eq.MISS) then
          if (paract(j).eq.1) then
            par(j)=0.1d0
          else
            par(j)=0.0d0
          end if
        end if
        parscal(j)=sqrt(tune/6)
   86 continue
      call qtlmod(linkf,modtyp, par, paract, qtlden, cumfrq, glogf)
C
C Inflate number of families to total number including replicates
      nfam=nchain*nfam
C Need starting values for additive polygenic a/o sibship random
C effects?
      mkstart=(paract(11).eq.1 .or. paract(21).eq.1 .or. 
     2         paract(11).eq.2 .or. paract(21).eq.2 .or. 
     3         paract(13).eq.1 .or. paract(23).eq.1 .or.
     4         paract(13).eq.2 .or. paract(23).eq.2)
C Likelihood at starting values
      lik=0.0d0
      if (nfam.gt.1) then
        call newnam(wrknum, wrkfil)
        open(wrk2,file=wrkfil,form='unformatted')
        rewind(twrk)
        do 95 k=1, nfam
          call fpmrd(twrk,ncol,nqtl,famlik,gtplik,fammu,
     2               pedigree,num,nfound,id,fa,mo,sex,locus,
     3               val,bval,rsd,mval,hset)
          if (mkstart) then
            call initvc(par,paract,num,nfound,fa,mo,val,bval,mval)
          end if
          call seglik(linkf, modtyp, nqtl, nfix, glogf, 
     2                par,fammu, num, nfound, fa, mo, val, bval,
     3                rsd, mval, locus, hset, famlik, gtplik, plevel)
          call fpmwr(wrk2,ncol,nqtl,famlik,gtplik,fammu,
     2               pedigree,num,nfound,id,fa,mo,sex,locus,
     3               val,bval,rsd,mval,hset)
          lik=lik+famlik
   95   continue
        close(twrk,status='delete')
        close(wrk2,status='keep')
        open(twrk,file=wrkfil,form='unformatted')
      else
        if (mkstart) then
          call initvc(par,paract,num,nfound,fa,mo,val,bval,mval)
        end if
        call seglik(linkf, modtyp, nqtl, nfix, glogf, 
     2              par,fammu, num, nfound, fa, mo, val, bval,
     3              rsd, mval, locus, hset, famlik, gtplik, plevel)
        lik=lik+famlik
      end if
C
C Main loop - either propose and test a parameter tweak or a 
C   new set of QTL genotypes
C   start with a genotype proposal (typ=nterms+1)
C
      if (plevel.gt.0) then
        write(*,'(/a/2a)') 
     2    ' Parameter      Start Value  Proposal SD      Bounds',
     3    '--------------  -----------  -----------',
     4    '  --------------------'
        do 90 i=1, nterms
          write(*,'(a, 2(1x,f12.6),2(1x,d10.4))') 
     2      parnam(terms(i)), par(terms(i)), parscal(terms(i)),
     3      blpar(terms(i)), bupar(terms(i))
   90   continue
        write(*,'(/a/a)') 
     2    ' Covariate      Mean Value',
     3    '--------------  ----------' 
        do 91 i=1, nfix  
          write(*,'(a, 1x,f12.6)') parnam(RANPAR+i), mean(i)
   91   continue
        write(*,'(/a,g13.6)') 'LogLik at starting values  = ', lik 
        write(*,'(/a,20(1x,a3):)') 
     2    'MCMCPAR       it           lik  prop', 
     3    (parnam(terms(i))(1:3), i=1, nterms)
        write(*,'(a)') 
     &    'MCMCEMP       it           lik  pA VA VC VS VE  VarRat'
      end if

      it=0
      batchit=0
      curbat=1
      irupt=0
      nprops=nterms+anyran
      nvals=0
      typ=nterms+1

  100 continue
        it=it+1
        newlik=0.0d0
C update global parameter estimates via slice sampling
        if (typ.le.nterms) then
          typ=terms(typ)
          if (mcalg.eq.1) then
            call slprop(twrk, typ, linkf, modtyp, nqtl, nfix, ncol, 
     2             cumfrq, glogf, parnam, par, paract, parscal, blpar,
     3             bupar, fammu, nfam, pedigree, num, nfound, id, fa,
     4             mo, sex, val, bval, rsd, mval, locus, hset, lik,
     5             newlik, gtplik, proptyp, proprate, plevel)
          else
            call mhprop(twrk, typ, linkf, modtyp, nqtl, nfix, ncol, 
     2             cumfrq, glogf, parnam, par, paract, parscal, blpar,
     3             bupar, tune, yvar, fammu, nfam, pedigree, num,
     4             nfound, id, fa, mo, sex, val, bval, rsd, mval, locus,
     5             hset, lik, newlik, gtplik, proptyp, proprate, plevel)
          end if
          empve=0.0d0
          if (nfam.gt.1) then
            call newnam(wrknum, wrkfil)
            open(wrk2,file=wrkfil,form='unformatted')
            rewind(twrk)
            do 165 k=1, nfam
              call fpmrd(twrk,ncol,nqtl,famlik,gtplik,fammu,
     2                   pedigree,num,nfound,id,fa,mo,sex,locus,
     3                   val,bval,rsd,mval,hset)
              call seglik(linkf, modtyp, nqtl, nfix, glogf,
     2                 par, fammu, num, nfound, fa, mo, val, bval,
     3                 rsd, mval, locus, hset, famlik, gtplik, plevel)
              call fpmve(linkf, modtyp, nqtl, nfix, par, fammu,
     &                num,val, bval, mval, locus, hset, empve, empvef)
              call fpmwr(wrk2,ncol,nqtl,famlik,gtplik,fammu,
     2                   pedigree,num,nfound,id,fa,mo,sex,locus,
     3                   val,bval,rsd,mval,hset)
  165       continue
            close(twrk,status='delete')
            close(wrk2,status='keep')
            open(twrk,file=wrkfil,form='unformatted')
          else
            call fpmve(linkf, modtyp, nqtl, nfix, par, fammu,
     &             num, val, bval, mval, locus, hset, empve, empvef)
          end if
          empvar(5)=empve/dfloat(nchain*totobs)
          empvar(6)=empve/empvef
        else
C or update trait locus genotypes
          typ=0
          nships=0
          tfound=0
          tot=0
          totall=0
          empfrq=0.0d0
          empve=0.0d0
          empvef=0.0d0
          do 204 j=1, 6
            empmu(j)=0.0d0
            empvar(j)=0.0d0
  204     continue
          if (nfam.gt.1) then
            call newnam(wrknum, wrkfil)
            open(wrk2,file=wrkfil,form='unformatted')
            rewind(twrk)
            do 200 k=1, nfam
              call fpmrd(twrk,ncol,nqtl,famlik,gtplik,fammu,
     2                   pedigree,num,nfound,id,fa,mo,sex,locus,
     3                   val,bval,rsd,mval,hset)
              nsubit=max(1, num*ncomp)
              do 205 j=1, nsubit    
                call oneseg(it,linkf,modtyp,nqtl,nfix,cumfrq,
     2                 glogf,par,parscal,fammu,yvar, pedigree,num,
     3                 nfound,id,fa,mo,val,bval,rsd,mval,locus,set,
     4                 hset,famlik,gtplik,gprop,grate,mcalg,plevel)
  205         continue
              call empval(nqtl, par, num, nfound, fa, mo, hset,
     2                    fammu, bval, mval, k, tot, tfound, nships, 
     3                    empmu, empvar, totall)
              call fpmve(linkf, modtyp, nqtl, nfix, par, fammu,
     &                num, val, bval, mval, locus, hset, empve, empvef)
              call fpmwr(wrk2,ncol,nqtl,famlik,gtplik,fammu,
     2                   pedigree,num,nfound,id,fa,mo,sex,locus,
     3                   val,bval,rsd,mval,hset)
              newlik=newlik+famlik
  200       continue
            close(twrk,status='delete')
            close(wrk2,status='keep')
            open(twrk,file=wrkfil,form='unformatted')
          else
            famlik=lik
            nsubit=max(1, num*ncomp)
            do 206 j=1, nsubit
              call oneseg(it,linkf,modtyp,nqtl,nfix,cumfrq,
     2               glogf,par,parscal,fammu,yvar, pedigree,num,nfound,
     3               id,fa,mo,val,bval,rsd,mval,locus,set,hset,
     4               famlik,gtplik,gprop,grate,mcalg,plevel)
  206       continue
            call empval(nqtl, par, num, nfound, fa, mo, hset,
     2                  fammu, bval, mval, 1, tot, tfound, nships, 
     3                  empmu, empvar, totall)
            call fpmve(linkf, modtyp, nqtl, nfix, par, fammu, num,
     &             val, bval, mval, locus, hset, empve, empvef)
            newlik=famlik
          end if
          call empsum(nfam, tot, tfound, nships, empmu, empvar, 
     &                totall, empfrq)
          empvar(1)=empfrq
          empvar(5)=empve/dfloat(nchain*totobs)
          empvar(6)=empve/empvef
          if (plevel.gt.1) then
            write(*,'(a,2(a,g12.5),a,f5.3, 4(a, f9.4))') 
     2        'Shuffle genotypes',' lik=', newlik, ' (old=',lik,
     3        ') p(A)=',empfrq, ' VG=', empvar(2), ' VC=', empvar(3), 
     4        ' VS=', empvar(4), ' VE=', empvar(5)
          end if
        end if
C
C Sample from run following completion of burn-in
C Batch for standard errors
C
        if (it.gt.(10*burnin)) then
          batchit=batchit+1
          do 301 i=1, 3
            batch(i,curbat)=batch(i,curbat)+par(i)
  301     continue
C summarize genotypic means rather than genotypic deviations
          batch(4,curbat)=batch(4,curbat)+par(4)+par(7)
          batch(5,curbat)=batch(5,curbat)+par(5)+par(7)
          batch(6,curbat)=batch(6,curbat)+par(6)+par(7)
          do 304 i=7, npar
            batch(i,curbat)=batch(i,curbat)+par(i)
  304     continue
C summarize empirical random effect variances
          do 1010 i=npar+1, bpar
            batch(i,curbat)=batch(i,curbat)+empvar(i-npar)
 1010     continue
          if (batchit.eq.sampit) then
            nvals=nvals+1
            batchit=0
            do 302 i=1, bpar
              batch(i,curbat)=batch(i,curbat)/dfloat(sampit)
  302       continue
C lag-1 correlation for batches
            if (nvals.gt.1) then
              do 303 i=1, bpar
                call corr(i,batch(i,curbat),batch(i,3-curbat),
     &                    bpar,np,mubat,varbat,covbat)    
  303         continue
            end if
C
C accumulate mean and SD for parameters
C
            do 320 i=1, bpar  
              call moment(nvals, batch(i,curbat), epar(i), sdpar(i))
              batch(i,3-curbat)=0.0d0
  320       continue
            curbat=3-curbat
            if (nvals.eq.1) baslik=likcor*dfloat(int(newlik))
            call moment(nvals,likcor*newlik-baslik,estlik,cvlik)
C print BLUPs
            if (priran.eq.1 .or. plevel.gt.3) then
              if (nfam.gt.1) then
                rewind(twrk)
                do 330 k=1, nfam
                  call fpmrd(twrk,ncol,nqtl,famlik,gtplik,fammu,
     2                       pedigree,num,nfound,id,fa,mo,sex,locus,
     3                       val,bval,rsd,mval,hset)
                  call wrfpm(it, linkf, modtyp, nqtl, nfix, 
     2                   parnam, par, fammu, famlik, gtplik, pedigree,
     3                   num, nfound, id, fa, mo, sex, val, bval, mval,
     4                   locus, hset)
  330           continue
              else
                call wrfpm(it, linkf, modtyp, nqtl, nfix, parnam,
     2                 par, fammu, famlik, gtplik, pedigree, num,
     3                 nfound, id, fa, mo, sex, val, bval, mval,
     4                 locus, hset)
              end if
            end if
          end if
C Print parameter values for this iteration
          if (plevel.gt.0) then
            write(*,'(a,i7,1x,d14.8,1x,i2,(20(1x,f12.4)):)')
     2        'MCMCPAR ',it, newlik, typ, 
     3        (par(terms(i)), i=1,nterms)
            write(*,'(a,i7,1x,d14.8,1x,f5.3,5(1x,f12.4))')
     2        'MCMCEMP ',it, newlik, (empvar(j), j=1,6)
          end if
        end if
        lik=newlik
        typ=irandom(1,nprops)
      if (it.lt.maxit .and. irupt.eq.0) goto 100
C
C end of main MCMC loop
C
C model pars 1=P(all) 2=a 3=d 4=AA 5=AB 6=BB 
C            7=mu 8=totvar 9=VA 10=VD 11=VG 12=VC 13=VS 14=VE 
C            15=sdG 16=sdC 17=sdS 18=sdE
C            19=a2 20=d2 21=h2 22=c2 23=s2 24=e2 
C            25..MAXPAR=Betas
C
      estlik=estlik+baslik
      cvlik=sqrt(cvlik/dfloat(max(1, nvals-1)))
      cvlik=100.0d0*cvlik/abs(estlik)
      pval=dfloat(tailp)/dfloat(max(1,nvals))
      yvar=100.0d0
      write(*,'(/a,i5)') 
     &  'Number of simulated QTLs   = ', nqtl 
      if (nqtl.gt.0) then
        write(*,'(a,f12.6)') 
     &  'QTL increasing allele freq = ', epar(1)  
      end if
      write(*,'(/a,f12.6)')
     &  'Intercept                  = ', bsign*epar(7) 
      if (nqtl.gt.0) then
        write(*,'(a,f12.6,a,f5.1,a)')
     2  'Additive QTL variance      = ', 
     3  epar(9),' (',epar(19)*yvar,'%)'
        if (paract(10).ne.0) then
          write(*,'(a,f12.6,a,f5.1,a)')
     2   'Dominance QTL variance     = ', 
     3   epar(10),' (',epar(20)*yvar,'%)'
        end if
      end if
      if (paract(11).ne.0) then
        write(*,'(a,f12.6,a,f5.1,a)') 
     2  'Additive polygenic var     = ', 
     3  epar(11),' (',epar(21)*yvar,'%)'
      end if
      if (paract(12).ne.0) then
        write(*,'(a,f12.6,a,f5.1,a)') 
     2  'Family environmental var   = ',
     3  epar(12),' (',epar(22)*yvar,'%)'
      end if
      if (paract(13).ne.0) then
        write(*,'(a,f12.6,a,f5.1,a)') 
     2  'Maternal effect variance   = ',
     3  epar(13),' (',epar(23)*yvar,'%)'
      end if
      if (paract(14).ne.0) then
        write(*,'(a,f12.6,a,f5.1,a)')
     2    'Environmental variance     = ', 
     3    epar(14),' (',epar(24)*yvar,'%)' 
      end if
      if (modtyp.eq.4) then
        write(*,'(a,f9.3)') 
     &    'Weibull shape parameter    = ', exp(epar(RANPAR+nfix+1))
      end if
      write(*,'(a,g13.6/a,f8.2,a)')
     2  'Mean model loglikelihood   = ', estlik, 
     3  'C.V. Loglikelihood         = ', cvlik, '%'

      write(*,'(/a,i5,a,i10,a//2a/2a)') 
     2  'Based on ', nvals, ' batches of size ',sampit,' :', 
     3  'Parameter             Mean         SD    ',
     4  '    Z-value    Inter-batch r Fixed',
     5  '----------------  ----------   ----------',
     6  '   ----------  ------------- -----'
      den=sqrt(dfloat(nchain))/dfloat(max(1, nvals-1))
      call corrstd(bpar,np,varbat,covbat)
      j=0
      do 370 i=1, bpar  
      if (paract(i).ne.0) then
        bsign=1
        enull=0.0d0
C Reverse sign on Weibull parameters
        if (modtyp.eq.4) then
          if (i.eq.7 .or. (i.gt.RANPAR .and. i.le.(RANPAR+nfix))) then 
            bsign=-1
          end if
        end if
        ch=' '
        if (paract(i).eq.2) ch='*'
        sd=sqrt(den*sdpar(i))
        zstat=0.0d0
        if (sd.gt.0d0) zstat=abs(epar(i)-enull)/sd
        write(*,'(a,3(1x,f12.4),6x,f5.3,7x,a1)') 
     2    parnam(i), bsign*epar(i), sd, zstat, covbat(i), ch
        if (covbat(i).gt.0.05) j=1
      end if
  370 continue
      if (j.eq.1) then
        write(*,'(/a/7x,a)') 
     2    'NOTE:  An inter-batch correlation >0.05 suggests these ',
     3           'standard errors to be too small.'
      end if
      j=2
      if (mcalg.eq.3) j=1
      write(*,'(/a/a/a,i14,4x,f5.3,3a)') 
     2  'Proposal               N   Accepted',
     3  '------------ ------------- --------',
     4  'Genotype    ', gprop, dfloat(grate)/dfloat(max(1,gprop)),
     5  ' (',algid(j),')'
      j=mcalg
      if (mcalg.eq.3) j=1
      do 380 i=1, npar
      if (paract(i).eq.1) then
        pval=dfloat(proprate(i))/dfloat(max(1,proptyp(i)))
        write(*,'(a,i12,4x,f5.3,3a)') 
     &     parnam(i), proptyp(i), pval, ' (',algid(j),')'
      end if
  380 continue
      if (mcalg.ne.3) then
        write(*,'(/a/7x,a/7x,a)') 
     2  'NOTE:  For ordinary Metropolis sampling (M), the proposal ',
     3         'acceptance rate is optimally 0.2-0.6.  The slice ', 
     4         'sampler (S) is more robust, but slower.'  
      end if

      mpar=nterms
      mlik=-estlik-estlik
      close(twrk,status='delete')
      return
      end
C end-of-segsim
C
C QTL genotypic log frequencies
      subroutine genfreq(pall, cumfrq, glogf)
      integer MAXPEN
      parameter(MAXPEN=3)
      double precision cumfrq(*), glogf(MAXPEN), pall
      cumfrq(1)=pall
      cumfrq(2)=1.0d0
      glogf(1)=2*log(pall)
      glogf(2)=log(pall)+log(1.0d0-pall)
      glogf(3)=2*log(1.0d0-pall)
      return
      end
C end-of-genfreq
C
C dominance deviation given p, VD
      double precision function domdev(qtlden, p, vd)
      double precision p, qtlden, vd
      domdev=0.5d0*sqrt(qtlden*vd)/(p*(1.0d0-p))
      return
      end
C end-of-domev
C additive deviation given p, VA, VD
      double precision function adddev(qtlden, p, va, vd)
      double precision p, qtlden, va, vd
      double precision domdev
      adddev=(1.0d0-p-p)*domdev(qtlden, p, vd) + 
     &       sqrt(0.5d0*qtlden*va/(p*(1.0d0-p)))
      return
      end
C end-of-adddev
C
C Metropolis sampler for global parameters
C
      subroutine mhprop(twrk, iprop, linkf, modtyp, nqtl, nfix, ncol, 
     2             cumfrq, glogf, parnam, par, paract, parscal, blpar,
     3             bupar, tune, yvar, fammu, nfam, pedigree, num,
     4             nfound, id, fa, mo, sex, val, bval, rsd, mval, locus,
     5             hset, lik, newlik, gtplik, proptyp, proprate, plevel)
      implicit none
      integer MAXHAP, MAXLOC, MAXPEN, MAXSIZ, MISS, 
     &        MAXPAR, RANPAR
      parameter(MAXSIZ=20, MAXLOC=10000, MISS=-9999, 
     2          MAXHAP=MAXLOC/2, MAXPAR=50, MAXPEN=3,
     3          RANPAR=24)
      integer iprop, linkf, modtyp, ncol, nfam, nfix, nqtl, 
     &        num, nfound, plevel, twrk
      real tune
      double precision gtplik, lik, newlik, yvar
      integer paract(MAXPAR)  
      character*14 parnam(MAXPAR)
      double precision blpar(MAXPAR), bupar(MAXPAR), 
     &                 par(MAXPAR), parscal(MAXPAR)
C
C proprate is acceptance rate for proposals
C
      integer proprate(MAXPAR), proptyp(MAXPAR)
C pedigree
      character*10 pedigree
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ), sex(MAXSIZ)
      double precision locus(MAXSIZ, MAXLOC)
C QTL and gaussian polygenic genotypes, phenotypes
      integer hset(MAXSIZ,MAXHAP,2)
      double precision fammu
      double precision bval(MAXSIZ), rsd(MAXSIZ), val(MAXSIZ),
     &                 mval(MAXSIZ)
      double precision cumfrq(*), glogf(MAXPEN)
C local variables
      integer oobounds
      double precision origval, qtlden
C Metropolis criterion variables
      double precision lr, qa
C functions
      real random

      oobounds=0
      origval=par(iprop)
      proptyp(iprop)=proptyp(iprop)+1
      call parprop(iprop, tune, yvar, par, parscal, 
     &             blpar, bupar, oobounds)
      call pedlik(twrk, linkf, modtyp, nqtl, nfix, ncol, cumfrq, 
     2       glogf, par, paract, fammu, nfam, pedigree, num, nfound, 
     3       id, fa, mo, sex, val, bval, rsd, mval, locus, hset,
     4       newlik, gtplik, oobounds, plevel)
      if (oobounds.eq.0) then
        lr=newlik-lik
        qa=min(1.0d0,exp(lr))
      else
        qa=0.0d0
      end if
C
C If accepted, update variance components and family likelihoods
C
      if (qa.gt.random()) then
        if (plevel.gt.1) then
          write(*,'(a,2(a,1x,f9.4),2(a,g12.5),a)') 
     2      'Propose  ',parnam(iprop), origval,'->', par(iprop),
     3      ' lik=', newlik, ' (old=',lik,')  accepted '  
        end if
        proprate(iprop)=proprate(iprop)+1
      else
        if (plevel.gt.1) then
          write(*,'(a,2(a,1x,f9.4),2(a,g12.5),a)') 
     2      'Propose  ',parnam(iprop), origval,'->', par(iprop),
     3      ' lik=', newlik, ' (old=',lik,')  rejected '  
        end if
        qtlden=1.0d0/dfloat(max(1,nqtl))
        par(iprop)=origval
        call qtlmod(linkf,modtyp, par, paract, qtlden, cumfrq, glogf)
        newlik=lik
      end if
      return
      end
C end-of-mhprop
C
C Slice sampler for global parameters
C
      subroutine slprop(twrk, iprop, linkf, modtyp, nqtl, nfix, ncol, 
     2             cumfrq, glogf, parnam, par, paract, parscal, blpar,
     3             bupar, fammu, nfam, pedigree, num, nfound, id, fa,
     4             mo, sex, val, bval, rsd, mval, locus, hset, lik,
     5             newlik, gtplik, proptyp, proprate, plevel)
      integer MAXHAP, MAXLOC, MAXPEN, MAXSIZ, MISS, 
     &        MAXPAR, RANPAR, SLMAX
      parameter(MAXSIZ=20, MAXLOC=10000, MISS=-9999, 
     2          MAXHAP=MAXLOC/2, MAXPAR=50, MAXPEN=3,
     3          RANPAR=24, SLMAX=10)
      integer iprop, linkf, modtyp, ncol, nfam, nfix, nqtl, 
     &        num, nfound, plevel, twrk
      double precision gtplik, lik, newlik
      integer paract(MAXPAR)  
      character*14 parnam(MAXPAR)
      double precision blpar(MAXPAR), bupar(MAXPAR), 
     &                 par(MAXPAR), parscal(MAXPAR)
C
C proprate is acceptance rate for proposals (if sliced, proportion of
C evaluations per accepted proposal
C
      integer proprate(MAXPAR), proptyp(MAXPAR)
C pedigree
      character*10 pedigree
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ), sex(MAXSIZ)
      double precision locus(MAXSIZ, MAXLOC)
C QTL and gaussian polygenic genotypes, phenotypes
      integer hset(MAXSIZ,MAXHAP,2)
      double precision fammu
      double precision bval(MAXSIZ), rsd(MAXSIZ), val(MAXSIZ),
     &                 mval(MAXSIZ)
      double precision cumfrq(*), glogf(MAXPEN)
C local variables
      integer it, lmax, oobounds, rmax
C slice sampler for global parameters
      double precision ltlik, ltval, origval, rtlik, rtval, slicelik
C functions
      integer irandom
      real random

      oobounds=0
      origval=par(iprop)
C always a success, but multiple function evaluations
      proprate(iprop)=proprate(iprop)+1
      proptyp(iprop)=proptyp(iprop)+2
      slicelik=log(dble(random()))+lik
C while loops expanding the slice
      lmax=irandom(1, SLMAX)
      rmax=SLMAX-lmax
C left extent of slice
      ltval=par(iprop)-dble(random())*parscal(iprop)
      if (ltval.lt.blpar(iprop)) then
        ltval=blpar(iprop)
        lmax=0
      end if
      par(iprop)=ltval
      call parbounds(iprop, par, blpar, bupar, oobounds)
      call pedlik(twrk, linkf, modtyp, nqtl, nfix, ncol, cumfrq,
     2       glogf, par, paract, fammu, nfam, pedigree, num, nfound, 
     3       id, fa, mo, sex, val, bval, rsd, mval, locus, hset,
     4       ltlik, gtplik, oobounds, plevel)
   10 continue
      if (lmax.le.0 .or. ltlik.le.slicelik) goto 30
        ltval=ltval-parscal(iprop)
        if (ltval.lt.blpar(iprop)) then
          ltval=blpar(iprop)
          lmax=0
        end if
        par(iprop)=ltval
        call parbounds(iprop, par, blpar, bupar, oobounds)
        call pedlik(twrk, linkf, modtyp, nqtl, nfix, ncol, cumfrq, 
     2         glogf, par, paract, fammu, nfam, pedigree, num, nfound, 
     3         id, fa, mo, sex, val, bval, rsd, mval, locus, hset,
     4         ltlik, gtplik, oobounds, plevel)
        proptyp(iprop)=proptyp(iprop)+1
        lmax=lmax-1
      goto 10
   30 continue
C right extent of slice
      rtval=ltval+parscal(iprop)
      if (rtval.gt.bupar(iprop)) then
        rtval=bupar(iprop)
        rmax=0
      end if
      par(iprop)=rtval
      call parbounds(iprop, par, blpar, bupar, oobounds)
      call pedlik(twrk, linkf, modtyp, nqtl, nfix, ncol, cumfrq, glogf,
     2       par, paract, fammu, nfam, pedigree, num, nfound, 
     3       id, fa, mo, sex, val, bval, rsd, mval, locus, hset,
     4       rtlik, gtplik, oobounds, plevel)
   50 continue
      if (rmax.le.0 .or. rtlik.le.slicelik) goto 70
        rtval=rtval+parscal(iprop)
        if (rtval.gt.bupar(iprop)) then
          rtval=bupar(iprop)
          rmax=0
        end if
        par(iprop)=rtval
        call parbounds(iprop, par, blpar, bupar, oobounds)
        call pedlik(twrk, linkf, modtyp, nqtl, nfix, ncol, cumfrq, 
     2         glogf, par, paract, fammu, nfam, pedigree, num, nfound, 
     3         id, fa, mo, sex, val, bval, rsd, mval, locus, hset,
     4         rtlik, gtplik, oobounds, plevel)
        proptyp(iprop)=proptyp(iprop)+1
        rmax=rmax-1
      goto 50
   70 continue
C sample within slice, shrinking if unsuccessful
      it=0
  100 continue
        it=it+1
        proptyp(iprop)=proptyp(iprop)+1
        par(iprop)=ltval+dble(random())*(rtval-ltval)
        call parbounds(iprop, par, blpar, bupar, oobounds)
        call pedlik(twrk, linkf, modtyp, nqtl, nfix, ncol, cumfrq, 
     2         glogf, par, paract, fammu, nfam, pedigree, num, nfound, 
     3         id, fa, mo, sex, val, bval, rsd, mval, locus, hset,
     4         newlik, gtplik, oobounds, plevel)
      if (newlik.gt.slicelik .or. it.gt.(10*SLMAX)) goto 110
        if (par(iprop).lt.origval) then
          ltval=par(iprop)
          ltlik=newlik
        else
          rtval=par(iprop)
          rtlik=newlik
        end if
      goto 100 
  110 continue
      if (plevel.gt.1) then
        write(*,'(a,2(a,1x,f9.4),2(a,g12.5),a)') 
     2    'Propose  ',parnam(iprop), origval,'->', par(iprop),
     3    ' lik=', newlik, ' (old=',lik,')  accepted '  
      end if
      return
      end
C end-of-slprop
C
C Make a proposal for one QTL model parameter for Metropolis sampler
C oobounds!=0 when proposal is illegal
C
      subroutine parprop(typ, tune, yvar, par, parscal, 
     &                   blpar, bupar, oobounds)
      integer MAXPAR, RANPAR
      parameter(MAXPAR=50, RANPAR=24)
C model pars 1=P(all) 2=a 3=d 4=AA 5=AB 6=BB 
C            7=mu 8=totvar 9=VA 10=VD 11=VG 12=VC 13=VS 14=VE 
C            15=sdG 16=sdC 17=sdS 18=sdE
C            19=a2 20=d2 21=h2 22=c2 23=s2 24=e2 
C            25..MAXPAR=Betas
C
      integer oobounds, typ
      real tune
      double precision yvar
      double precision blpar(MAXPAR), bupar(MAXPAR),
     &                 par(MAXPAR), parscal(MAXPAR) 
C functions
      real randn, rantri

      if (typ.eq.7) then
C mu proposal
        par(7)=par(7)+1.5d0*dble(randn())*parscal(typ)
      else if (typ.eq.8) then
C vt proposal
        par(8)=par(8)+dble(tune*rantri())*yvar
      else if (typ.eq.1 .or. (typ.ge.19 .and. typ.le.23)) then
C p or proportion of variance due to random effect
        call triprop(tune, par(typ))
      else if (typ.le.RANPAR) then
        par(typ)=par(typ)+dble(tune*randn())*parscal(typ)
      else if (typ.gt.RANPAR) then
C fixed effect
        par(typ)=par(typ)+7.0d0*dble(tune*randn())*parscal(typ)
      end if
C bounds check
      call parbounds(typ, par, blpar, bupar, oobounds)
      return
      end
C end-of-parprop
C
C Check Metropolis proposal 
C oobounds!=0 when proposal is illegal
C
      subroutine parbounds(typ, par, blpar, bupar, oobounds)
      integer MAXPAR
      parameter(MAXPAR=50)
C model pars 1=P(all) 2=a 3=d 4=AA 5=AB 6=BB 
C            7=mu 8=totvar 9=VA 10=VD 11=VG 12=VC 13=VS 14=VE 
C            15=sdG 16=sdC 17=sdS 18=sdE
C            19=a2 20=d2 21=h2 22=c2 23=s2 24=e2 
C            25..MAXPAR=Betas
      integer oobounds, typ
      double precision blpar(MAXPAR), bupar(MAXPAR), par(MAXPAR)

      oobounds=0
      if (par(typ).lt.blpar(typ)) then
        oobounds=oobounds+1
      else if (par(typ).gt.bupar(typ)) then
        oobounds=oobounds+2
      else if ((par(19)+par(20)+par(21)+par(22)+par(23)).gt. 1.0d0) then
        oobounds=oobounds+4
      end if
      return
      end
C end-of-parbounds
C
C QTL allelic deviations, allele and genotype frequencies
C From pA, mu, totvar, a2, d2, h2, c2 calculate all other parameters
C
C model pars 1=P(all) 2=a 3=d 4=AA 5=AB 6=BB 
C            7=mu 8=totvar 9=VA 10=VD 11=VG 12=VC 13=VS 14=VE 
C            15=sdG 16=sdC 17=sdS 18=sdE
C            19=a2 20=d2 21=h2 22=c2 23=s2 24=e2 
C            25..MAXPAR=Betas
C
      subroutine qtlmod(linkf, modtyp, par, paract, qtlden, 
     &                  cumfrq, glogf)
      integer MAXPAR, MAXPEN, MISS
      parameter(MAXPAR=50, MAXPEN=3, MISS=-9999)
      integer modtyp
      integer paract(MAXPAR)
      double precision cumfrq(*), glogf(MAXPEN)
      double precision par(MAXPAR), qtlden
      double precision mu, q, var
C functions
      double precision adddev, alogit, domdev

      q=1.0d0-par(1)
      call genfreq(par(1), cumfrq, glogf)
      mu=par(7)
      var=par(8)
C SML: a2 d2
      par(9)=par(19)*var
      par(10)=par(20)*var
      par(2)=adddev(qtlden, par(1), par(9), par(10))
      par(3)=domdev(qtlden, par(1), par(10))
      par(4)=(qtlden-1.0d0) * par(7) - 
     &       2*q*(par(1)*(par(2)+par(3)) + q*par(2))
      par(5)=par(4)+par(2)+par(3)
      par(6)=par(4)+par(2)+par(2)
C  VC: h2 c2 s2
      do 10 i=11, 13
        if (paract(10+i).eq.1 .or. paract(10+i).eq.2) then
          par(i)=par(10+i)*var
        else if (paract(10+i).eq.3) then
          par(10+i)=par(i)/var
        end if
        if (par(i).gt.0.0d0) then
          par(i+4)=sqrt(par(i))
        else
          par(i+4)=1.0d-9  
        end if
   10 continue
C e2
      par(24)=1.0d0-par(19)-par(20)-par(21)-par(22)-par(23)
      if (modtyp.eq.1) then
        par(14)=par(24)*var
      else if (modtyp.eq.2) then
        if (linkf.eq.2) mu=alogit(mu)
        par(14)=mu*(1.0d0-mu)
      else if (modtyp.eq.3 .or. modtyp.eq.4) then
        if (linkf.eq.5) mu=exp(mu)
        par(14)=mu
      end if
      par(18)=sqrt(par(14))
      return
      end
C end-of-qtlmod
C
C check bounds on linear binomial model terms 
C
      subroutine chkbin(par, nqtl, oobounds)
      integer MAXPAR, MAXPEN, MISS
      parameter(MAXPAR=50, MAXPEN=3, MISS=-9999)
      integer nqtl, oobounds
      double precision par(MAXPAR)
C local variables
      integer i
      double precision pred

      do 10 i=1, 3
        pred=par(7)+nqtl*par(3+i)
        if (pred.lt.0.0d0) then
          oobounds=1
          goto 11
        else if (pred.gt.1.0d0) then
          oobounds=2
          goto 11
        end if
   10 continue
   11 continue
      return
      end
C end-of-chkbin
C 
C Circularized triangular random proportion
C
      subroutine triprop(tune, p)
      real tune
      double precision p
C functions
      real rantri
      p=p+dble(tune*rantri())
      if (p.gt.1.0d0) then
        p=p-1.0d0
      else if (p.lt.0.0d0) then
        p=1.0d0-p
      end if
      return
      end
C end-of-triprop
C
C link function for binary data
C linkf=1 identity 2 logit 3 probit 4 MFT 5=Log
C
      subroutine linfun(linkf, y, thresh)
      integer linkf
      double precision thresh, y
C functions
      double precision alogit, zp
      external alogit, zp
      if (linkf.eq.1) then
        return
      else if (linkf.eq.2) then
        y=alogit(y)
      else if (linkf.eq.3) then
        y=zp(y)
      else if (linkf.eq.4) then
        y=y-thresh
        if (y.ge.thresh) then
          y=1.0d0
        else
          y=0.0d0
        end if
      else if (linkf.eq.5) then
        y=exp(y)
      end if
      return
      end
C end-of-linfun
C
C Poisson or Binomial or Gaussian log density for FPM
      double precision function dens(x, mu, sd, shap, cens, modtyp)
      double precision SMALL
      parameter(SMALL=2.0d-308)
C modtyp: gaussian=1 binomial=1 poisson=3 weibull=4
      integer modtyp
      double precision cens, x, mu, sd, shap
      double precision dnorm, dpois, dweib, ln
      external dnorm, dpois, dweib, ln
      dens = 0.0d0
      if (modtyp.eq.1) then
        dens = dnorm(x, mu, sd)
      else if (modtyp.eq.2) then
        dens = ln(x*mu+(1.0d0-x)*(1.0d0-mu))
      else if (modtyp.eq.3) then
        if (mu.gt.SMALL) then
          dens = dpois(x, mu)
        end if
      else if (modtyp.eq.4) then
        if (mu.gt.SMALL) then
          dens = dweib(x, mu, shap, cens)
        end if
      end if
C     write(*,*) 'dens=', dens, x, mu, ' model=', modtyp
C     write(*,*) 'shap=', shap, ' cens=', cens
      return
      end
C end-of-dens 
C 
C Calculate likelihood under FPM for entire sample of pedigrees
C
      subroutine pedlik(twrk, linkf, modtyp, nqtl, nfix, ncol, 
     2                  cumfrq, glogf, par, paract, fammu, nfam,
     3                  pedigree, num, nfound, id, fa, mo, sex, val,
     4                  bval, rsd, mval, locus, hset, lik, gtplik,
     5                  oobounds, plevel)

      integer MAXHAP, MAXLOC, MAXPEN, MAXSIZ, MISS, 
     &        MAXPAR, RANPAR
      parameter(MAXSIZ=20, MAXLOC=10000, MISS=-9999, 
     2          MAXHAP=MAXLOC/2, MAXPAR=50, MAXPEN=3,
     3          RANPAR=24)
      integer linkf, modtyp, ncol, nfam, nfix, nqtl, 
     &        num, nfound, oobounds, plevel, twrk
      integer paract(MAXPAR)
      double precision par(MAXPAR)
      character*10 pedigree
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ), sex(MAXSIZ)
      double precision locus(MAXSIZ, MAXLOC)
C QTL and gaussian polygenic genotypes, phenotypes
      integer hset(MAXSIZ,MAXHAP,2)
      double precision fammu
      double precision bval(MAXSIZ), rsd(MAXSIZ), val(MAXSIZ),
     &                 mval(MAXSIZ)
      double precision cumfrq(*), glogf(MAXPEN)
      double precision gtplik, lik
C local variables
      integer k
      double precision famlik, qtlden

      famlik=0.0d0
      gtplik=0.0d0
      lik=0.0d0
      qtlden=1.0d0/dfloat(max(1,nqtl))
      call qtlmod(linkf, modtyp, par, paract, qtlden, cumfrq, glogf)
      if (modtyp.eq.2 .and. linkf.eq.1 .and. oobounds.eq.0) then
        call chkbin(par, nqtl, oobounds)
      end if
      if (oobounds.eq.0) then
        if (nfam.gt.1) then
          rewind(twrk)
          do 160 k=1, nfam
            call fpmrd(twrk,ncol,nqtl,famlik,gtplik,fammu,
     2                 pedigree,num,nfound,id,fa,mo,sex,locus,
     3                 val,bval,rsd,mval,hset)
            call seglik(linkf, modtyp, nqtl, nfix, glogf, 
     2              par,fammu, num, nfound, fa, mo, val, bval,
     3              rsd, mval, locus, hset, famlik, gtplik, plevel)
            lik=lik+famlik
  160     continue
        else
          call seglik(linkf, modtyp, nqtl, nfix, glogf,
     2            par, fammu, num, nfound, fa, mo, val, bval,
     3            rsd, mval, locus, hset, lik, gtplik, plevel)
        end if
      else 
        lik=-1.0d-99
      end if
      return
      end
C end-of-pedlik
C
C Calculate likelihood under FPM for one pedigree
C
      subroutine seglik(linkf, modtyp, nqtl, nfix, glogf, par,
     2                  fammu, num, nfound, fa, mo, val, bval, rsd, 
     3                  mval, locus, hset, lik, gtplik, plevel)

      integer MAXHAP, MAXLOC, MAXPEN, MAXSIZ, MISS, 
     &        MAXPAR, RANPAR
      parameter(MAXSIZ=20, MAXLOC=10000, MISS=-9999, 
     2          MAXHAP=MAXLOC/2, MAXPAR=50, MAXPEN=3,
     3          RANPAR=24)
      integer linkf, modtyp, nqtl, num, nfound, plevel
      integer fa(MAXSIZ), mo(MAXSIZ)
      double precision locus(MAXSIZ, MAXLOC)
C QTL and gaussian polygenic genotypes, phenotypes
      integer hset(MAXSIZ,MAXHAP,2)
      double precision fammu
      double precision bval(MAXSIZ), rsd(MAXSIZ), val(MAXSIZ),
     &                 mval(MAXSIZ)
C model parameters
C            1=P(all) 2=a 3=d 4=AA 5=AB 6=BB 
C            7=mu 8=totvar 9=VA 10=VD 11=VG 12=VC 13=VS 14=VE 
C            15=sdG 16=sdC 17=sdS 18=sdE
C            19=a2 20=d2 21=h2 22=c2 23=s2 24=e2 
C            25..MAXPAR=Betas
      double precision glogf(MAXPEN)
      double precision gtplik, lik, par(MAXPAR)
C local variables
      integer curmo, i
      double precision indlik, indglik, shap, yp
C functions
C     integer parcon
      double precision dens, dnorm
      external dens, dnorm

      shap=1.0d0
      if (modtyp.eq.4) shap=exp(par(RANPAR+nfix+1))
C
C evaluate likelihood for each pedigree
      gtplik=0.0d0
      lik=0.0d0
C
C Founders: different VG and VS likelihoods from those of nonfounders
      do 100 i=1,nfound
        call seglf(i, linkf, modtyp, shap, nqtl, nfix, glogf,
     2             par, fammu, num, nfound, fa, mo, val, bval, rsd, 
     3             mval, locus, hset, yp, indlik, indglik)
        lik=lik+indlik
        gtplik=gtplik+indglik
  100 continue
C
C Nonfounders
      curmo=MISS
      do 110 i=nfound+1,num
        call seglnf(i, curmo, linkf, modtyp, shap, nqtl, nfix, glogf,
     2              par, fammu, num, nfound, fa, mo, val, bval, rsd, 
     3              mval, locus, hset, yp, indlik, indglik)
        lik=lik+indlik
        gtplik=gtplik+indglik
  110 continue
C Familial environmental effect contribution
      if (par(12).gt.0.0d0) then
        gtplik=gtplik+dnorm(fammu, 0.0d0, par(16))
      end if
      lik=lik+gtplik
      return
      end
C end-of-seglik
C 
C Update (gene-dropping) genotypes at one of N unlinked QTLs
C or Gaussian polygenotype or familial random intercept
C
      subroutine oneseg(it, linkf, modtyp, nqtl, nfix, cumfrq, 
     2             glogf, par, parscal, fammu, yvar, pedigree, num, 
     3             nfound, id, fa, mo, val, bval, rsd, mval, locus, set,
     4             hset, lik, gtplik, gprop, grate, mcalg, plevel)

      integer MAXHAP, MAXLOC, MAXSIZ, MISS, MAXPAR, MAXPEN, RANPAR
      parameter(MAXSIZ=20, MAXLOC=10000, MISS=-9999, 
     &          MAXHAP=MAXLOC/2, MAXPAR=50, MAXPEN=3, RANPAR=24)
      double precision BADLIK
      parameter(BADLIK=1.0d-99)
      integer gprop, grate, it, linkf, mcalg, modtyp, nfix, nqtl,
     &         num, nfound, plevel
      double precision yvar
      character*10 pedigree
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ) 
      double precision locus(MAXSIZ, MAXLOC)
C proposal and existing QTL genotypes
      integer set(MAXSIZ,2), hset(MAXSIZ,MAXHAP,2)
      double precision fammu, mval(MAXSIZ)  
      double precision bval(MAXSIZ), rsd(MAXSIZ), val(MAXSIZ)
C model parameters
C  lik=model likelihood, lr=likelihood ratio newlik/lik,
C  qa=Metropolis criterion
      double precision cumfrq(*), gtplik, lik, lr, qa
      double precision glogf(MAXPEN), yp
      double precision par(MAXPAR), parscal(MAXPAR)
C local variables
      integer curmo, i, ieff, iqtl, ocurmo
      integer nspec, speceff(3)
      logical xmale
      double precision indglik, indlik, newglik, newlik, shap
      double precision newbval(MAXSIZ), newfmu, newmval(MAXSIZ)
C
      integer nchanges, changes(MAXSIZ)
C functions
      integer irandom
      real randn, random
      double precision dnorm
      external dnorm, irandom, randn, random
      
      shap=1.0d0
      if (modtyp.eq.4) shap=exp(par(RANPAR+nfix+1))
      xmale=.false.
      ieff=0
      nspec=0
      do 1 i=11, 13
      if (par(i).gt.0.0d0) then
        nspec=nspec+1
        speceff(nspec)=i
      end if
    1 continue
      if ((nqtl+nspec).eq.0) return

      iqtl=irandom(1,nqtl+nspec)
      if (plevel.gt.2) then
        if (iqtl.le.nqtl) then
          write(*,'(a,a)') '#    it pedigree   id      lik ', 
     &      'trait     pred      bval   (   sd    )     proposed'

        else
          write(*,'(a)')
     2      '#    it pedigree id lik  trait pred (sd) qtl proposed' 
        end if
      end if
      newglik=0.0d0
      newlik=0.0d0
      do 5 i=1, num
        newbval(i)=bval(i)
        newmval(i)=mval(i)
    5 continue
      newfmu=fammu
C
C evaluate likelihood for each pedigree
C   parscal 15=sdG 16=sdC 17=sdS
C
      ieff=0
      nchanges=num
      if (iqtl.gt.nqtl) then
        ieff=speceff(iqtl-nqtl)
        if (mcalg.eq.3) then
          call oneslice(ieff, linkf, modtyp, shap, nqtl, nfix, 
     2           glogf, par, parscal, fammu, pedigree, num, 
     3           nfound, id, fa, mo, val, bval, rsd, mval, locus,
     4           hset, lik, gtplik, grate, gprop, plevel)
          return
        else if (ieff.eq.11) then
          call simpol(parscal(15), num, nfound, fa, mo, newbval,
     &                nchanges, changes)
        else if (ieff.eq.12) then
          newfmu=fammu+0.5d0*parscal(16)*dble(randn())
        else
          call simmat(parscal(17), num, nfound, fa, mo, val,
     &                newmval, nchanges, changes)
        end if
      else if (irandom(1,num).eq.1) then
        call simped(num,nfound,fa,mo,cumfrq,set)
        call set2hap(iqtl, num, set, hset, 3)
      else if (iqtl.gt.0) then
        call set2hap(iqtl, num, set, hset, 2)
        call isimped(num,nfound,fa,mo,cumfrq,set)
        call set2hap(iqtl, num, set, hset, 3)
      end if
C
C Likelihood ratio if more efficient
      if (ieff.gt.0 .and. (2*nchanges).lt.num) then
        curmo=MISS
        ocurmo=MISS
        lr=0.0d0
        do 50 j=1, nchanges
          i=changes(j)
          if (i.le.nfound) then
            call seglf(i, linkf, modtyp, shap, nqtl, nfix, glogf,
     2                 par, newfmu, num, nfound, fa, mo, val, newbval, 
     3                 rsd, newmval, locus, hset, yp, indlik, indglik)
            lr=lr+indlik+indglik
            call seglf(i, linkf, modtyp, shap, nqtl, nfix, glogf,
     2                 par, fammu, num, nfound, fa, mo, val, bval, 
     3                 rsd, mval, locus, hset, yp, indlik, indglik)
            lr=lr-indlik-indglik
            if (plevel.gt.2) then
              call wronep(i,it,yp,iqtl,nqtl,ieff,indlik+indglik,par,
     2                    pedigree,id, val, bval, mval, hset, 
     3                    newbval, newmval, set)
            end if
          else
            call seglnf(i, curmo, linkf, modtyp, shap, nqtl, nfix,
     2                  glogf, par, newfmu, num, nfound, fa, mo, val,
     3                  newbval, rsd, newmval, locus, hset, yp, 
     4                  indlik, indglik)
            lr=lr+indlik+indglik
            call seglnf(i, ocurmo, linkf, modtyp, shap, nqtl, nfix,
     2                  glogf, par, fammu, num, nfound, fa, mo, val,
     3                  bval, rsd, mval, locus, hset, yp, 
     4                  indlik, indglik)
            lr=lr-indlik-indglik
            if (plevel.gt.2) then
              call wronep(i,it,yp,iqtl,nqtl,ieff,indlik+indglik,par,
     2                    pedigree,id, val, bval, mval, hset, 
     3                    newbval, newmval, set)
            end if
          end if
   50   continue
        newlik=lik+lr
      else
C
C else complete likelihood 
        do 100 i=1,nfound
          call seglf(i, linkf, modtyp, shap, nqtl, nfix, glogf,
     2           par, newfmu, num, nfound, fa, mo, val, newbval, rsd, 
     3           newmval, locus, hset, yp, indlik, indglik)
          if (plevel.gt.2) then
            call wronep(i,it,yp,iqtl,nqtl,ieff,indlik+indglik,par,
     2                  pedigree,id, val, bval, mval, hset, 
     3                  newbval, newmval, set)
          end if
          if (indlik.eq.BADLIK) then
            qa=0.0d0
            goto 115
          end if
          newlik=newlik+indlik
          newglik=newglik+indglik
  100   continue
        curmo=MISS
        do 110 i=nfound+1,num
          call seglnf(i, curmo, linkf, modtyp, shap, nqtl, nfix,glogf,
     2           par, newfmu, num, nfound, fa, mo, val, newbval, rsd,
     3           newmval, locus, hset, yp, indlik, indglik)
          if (plevel.gt.2) then
            call wronep(i,it,yp,iqtl,nqtl,ieff,indlik+indglik,par,
     2                  pedigree,id, val, bval, mval, hset, 
     3                  newbval, newmval, set)
          end if
          if (indlik.eq.BADLIK) then
            qa=0.0d0
            goto 115
          end if
          newlik=newlik+indlik
          newglik=newglik+indglik
  110   continue

C Familial environmental effect contribution
        if (par(12).gt.0.0d0) then
          newglik=newglik+dnorm(newfmu, 0.0d0, par(16))
        end if
        newlik=newlik+newglik
        lr=newlik-lik
      end if
      qa=min(1.0d0,exp(lr))
C If bounds were exceeded qa set to 0 and jumped to here:
  115 continue
C
C If accepted, update genotypes

      gprop=gprop+1
      if (qa.gt.random()) then
        grate=grate+1
        if (plevel.gt.2) then
          write(*,199) 'Proposal accepted for pedigree ', pedigree, 
     2                 ' oldgtp=', gtplik, ' newgtp=', newglik, 
     3                 ' oldlik=', lik, ' newlik=', newlik
        end if
        lik=newlik
        gtplik=newglik
        if (iqtl.gt.nqtl) then
          do 150 i=1,num
            bval(i)=newbval(i)
            mval(i)=newmval(i)
  150     continue
        end if
        fammu=newfmu
      else if (plevel.gt.2) then
        write(*,199) 'Proposal rejected for pedigree ', pedigree, 
     2               ' oldgtp=', gtplik, ' newgtp=', newglik, 
     3               ' oldlik=', lik, ' newlik=', newlik
        call set2hap(iqtl, num, set, hset, 1)
      end if
  199 format(2a,4(a,f12.4))
      return
      end
C end-of-oneseg
C 
C Slice sampler updating Gaussian polygenotype 
C
      subroutine oneslice(ieff, linkf, modtyp, shap, nqtl, nfix, 
     2             glogf, par, parscal, fammu, pedigree, num, 
     3             nfound, id, fa, mo, val, bval, rsd, mval, locus,
     4             hset, lik, gtplik, grate, gprop, plevel)

      integer MAXHAP, MAXLOC, MAXSIZ, MISS, MAXPAR, MAXPEN, RANPAR
      parameter(MAXSIZ=20, MAXLOC=10000, MISS=-9999, 
     &          MAXHAP=MAXLOC/2, MAXPAR=50, MAXPEN=3, RANPAR=24)
      double precision BADLIK
      parameter(BADLIK=1.0d-99)
      integer ieff, linkf, modtyp, nfix, nqtl, num, nfound, plevel
      double precision shap
      character*10 pedigree
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ) 
      double precision locus(MAXSIZ, MAXLOC)
C proposal and existing QTL genotypes
      integer hset(MAXSIZ,MAXHAP,2)
      double precision fammu, mval(MAXSIZ)  
      double precision bval(MAXSIZ), rsd(MAXSIZ), val(MAXSIZ)
C model parameters
      double precision gtplik, lik
      double precision glogf(MAXPEN)
      double precision par(MAXPAR), parscal(MAXPAR)
      integer gprop, grate
C local variables
      integer i, idx, it, lmax, rmax
      integer nchanges, changes(MAXSIZ)
      double precision baslik, newglik, newlik, ltlik, rtlik, slicelik
      double precision basgtp, ltval, origval, prop, rtval
C functions
      integer irandom
      
      it=10
C Proposal to change one random effect for this pedigree;
C change may have ramifications to offspring likelihood contribution
      nchanges=0
      if (ieff.eq.11) then
        idx=irandom(1, num)
        origval=bval(idx)
        nchanges=nchanges+1
        changes(nchanges)=idx
        do 10 i=nfound+1, num
        if (fa(i).eq.idx .or. mo(i).eq.idx) then
          nchanges=nchanges+1
          changes(nchanges)=i
        end if
   10   continue
      else if (ieff.eq.12) then
        origval=fammu
        nchanges=num
        call ascend(nchanges, changes)
      else if (ieff.eq.13) then
    5   continue
          idx=irandom(1, num)
        if (mval(idx).eq.MISS) goto 5
        origval=mval(idx)
        if (idx.gt.nfound) then
          do 15 i=nfound+1, num
          if (mo(i).eq.mo(idx)) then
            nchanges=nchanges+1
            changes(nchanges)=i
          end if
   15     continue
        else
          nchanges=nchanges+1
          changes(nchanges)=idx
        end if
      end if
C current likelihood  
      call idxlik(nchanges, changes, linkf, modtyp, shap, nqtl, nfix,
     2            glogf, par, parscal, fammu, pedigree, num, 
     3            nfound, id, fa, mo, val, bval, rsd, mval, locus,
     4            hset, baslik, basgtp)
C slice threshold and initial proposals for slice width
      slicelik=log(dble(random()))+baslik
C while loops expanding the slice
      gprop=gprop+3
      lmax=irandom(1, it)
      rmax=it-lmax
      ltval=origval-dble(random())*parscal(4+ieff)
      call sliceprop(ieff, idx, nchanges, changes, 
     &               ltval, fammu, bval, mval)
      call idxlik(nchanges, changes, linkf, modtyp, shap, nqtl, nfix,
     2            glogf, par, parscal, fammu, pedigree, num, 
     3            nfound, id, fa, mo, val, bval, rsd, mval, locus,
     4            hset, ltlik, newglik)
   20 continue
      if (lmax.eq.0 .or. ltlik.le.slicelik) goto 30
        ltval=ltval-parscal(4+ieff)
        call sliceprop(ieff, idx, nchanges, changes, 
     &                 ltval, fammu, bval, mval)
        call idxlik(nchanges, changes, linkf, modtyp, shap, nqtl, nfix,
     2              glogf, par, parscal, fammu, pedigree, num,
     3              nfound, id, fa, mo, val, bval, rsd, mval, locus,
     4              hset, ltlik, newglik)
        gprop=gprop+1
        lmax=lmax-1
      goto 20
   30 continue
C
      rtval=ltval+parscal(4+ieff)
      call sliceprop(ieff, idx, nchanges, changes, 
     &               rtval, fammu, bval, mval)
      call idxlik(nchanges, changes, linkf, modtyp, shap, nqtl, nfix,
     2            glogf, par, parscal, fammu, pedigree, num, 
     3            nfound, id, fa, mo, val, bval, rsd, mval, locus,
     4            hset, rtlik, newglik)
   40 continue
      if (rmax.eq.0 .or. rtlik.le.slicelik) goto 50
        rtval=rtval+parscal(4+ieff)
        call sliceprop(ieff, idx, nchanges, changes, 
     &                 rtval, fammu, bval, mval)
        call idxlik(nchanges, changes, linkf, modtyp, shap, nqtl, nfix,
     2              glogf, par, parscal, fammu, pedigree, num,
     3              nfound, id, fa, mo, val, bval, rsd, mval, locus,
     4              hset, rtlik, newglik)
        gprop=gprop+1
        rmax=rmax-1
      goto 40
   50 continue
C sample within slice, shrinking if unsuccessful
      it=0
   60 continue
        it=it+1
        gprop=gprop+1
        prop=ltval+dble(random())*(rtval-ltval)
        call sliceprop(ieff, idx, nchanges, changes, 
     &                 prop, fammu, bval, mval)
        call idxlik(nchanges, changes, linkf, modtyp, shap, nqtl, nfix,
     2              glogf, par, parscal, fammu, pedigree, num,
     3              nfound, id, fa, mo, val, bval, rsd, mval, locus,
     4              hset, newlik, newglik)
      if (newlik.gt.slicelik) goto 70
        if (prop.lt.origval) then
          ltval=prop
          ltlik=newlik
        else
          rtval=prop
          rtlik=newlik
        end if
      goto 60    
   70 continue
      grate=grate+1
      lik=lik+newlik-baslik
      gtplik=gtplik+newglik-basgtp
      return
      end
C end-of-oneslice
C
C copy proposal to appropriate location
C
      subroutine sliceprop(ieff, idx, nchanges, changes, 
     &                     prop, fammu, bval, mval)
      integer MAXLOC, MAXSIZ 
      parameter(MAXSIZ=20, MAXLOC=10000)
      integer idx, ieff
      integer nchanges, changes(MAXSIZ)
      double precision bval(MAXSIZ), fammu, mval(MAXSIZ), prop
      if (ieff.eq.11) then
        bval(idx)=prop 
      else if (ieff.eq.12) then
        fammu=prop 
      else if (ieff.eq.13) then
        do 10 i=1, nchanges
          mval(changes(i))=prop
   10   continue
      end if
      return
      end
C end-of-sliceprop
C 
C Gaussian polygenotype likelihood contribution of individual idx (and
C affected relatives)
C
      subroutine idxlik(nchanges, changes, linkf, modtyp, shap, nqtl,
     2             nfix, glogf, par, parscal, fammu, pedigree, 
     3             num, nfound, id, fa, mo, val, bval, rsd, mval, locus,
     4             hset, lik, gtplik)

      integer MAXHAP, MAXLOC, MAXSIZ, MISS, MAXPAR, MAXPEN, RANPAR
      parameter(MAXSIZ=20, MAXLOC=10000, MISS=-9999, 
     &          MAXHAP=MAXLOC/2, MAXPAR=50, MAXPEN=3, RANPAR=24)
      double precision BADLIK
      parameter(BADLIK=1.0d-99)
      integer linkf, modtyp, nfix, nqtl, num, nfound
      integer nchanges, changes(MAXSIZ)
      double precision shap
      character*10 pedigree
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ) 
      double precision locus(MAXSIZ, MAXLOC)
C proposal and existing QTL genotypes
      integer hset(MAXSIZ,MAXHAP,2)
      double precision fammu, mval(MAXSIZ)  
      double precision bval(MAXSIZ), rsd(MAXSIZ), val(MAXSIZ)
C model parameters
      double precision gtplik, lik
      double precision glogf(MAXPEN)
      double precision par(MAXPAR), parscal(MAXPAR)
C local variables
      integer curmo, idx, j
      double precision indglik, indlik, yp
C functions 
      double precision dnorm
      
      curmo=MISS
      gtplik=0.0d0
      lik=0.0d0
      do 50 j=1, nchanges
        idx=changes(j)
        if (idx.le.nfound) then
          call seglf(idx, linkf, modtyp, shap, nqtl, nfix, glogf,
     2               par, fammu, num, nfound, fa, mo, val, bval, 
     3               rsd, mval, locus, hset, yp, indlik, indglik)
        else
          call seglnf(idx, curmo, linkf, modtyp, shap, nqtl, nfix,
     2                glogf, par, fammu, num, nfound, fa, mo, val,
     3                bval, rsd, mval, locus, hset, yp, 
     4                indlik, indglik)
        end if
        if (indlik.eq.BADLIK) then
          lik=-BADLIK
          return
        end if
        gtplik=gtplik+indglik
        lik=lik+indlik
   50 continue
C Familial environmental effect contribution
      if (par(12).gt.0.0d0) then
        gtplik=gtplik+dnorm(fammu, 0.0d0, par(16))
      end if
      lik=lik+gtplik
      return
      end
C end-of-idxlik
C
C Likelihood contribution of a founder
      subroutine seglf(idx, linkf, modtyp, shap, nqtl, nfix, glogf,
     2                 par, fammu, num, nfound, fa, mo, val, bval, rsd, 
     3                 mval, locus, hset, yp, lik, gtplik)

      integer MAXHAP, MAXLOC, MAXPEN, MAXSIZ, MISS, 
     &        MAXPAR, RANPAR
      parameter(MAXSIZ=20, MAXLOC=10000, MISS=-9999, 
     2          MAXHAP=MAXLOC/2, MAXPAR=50, MAXPEN=3,
     3          RANPAR=24)
      double precision BADLIK
      parameter(BADLIK=1.0d-99)
      integer idx, linkf, modtyp, nqtl, num, nfound
      integer fa(MAXSIZ), mo(MAXSIZ)
      double precision locus(MAXSIZ, MAXLOC)
      double precision shap
C QTL and gaussian polygenic genotypes, phenotypes
      integer hset(MAXSIZ,MAXHAP,2)
      double precision fammu
      double precision bval(MAXSIZ), rsd(MAXSIZ), val(MAXSIZ),
     &                 mval(MAXSIZ)
C model parameters
C            1=P(all) 2=a 3=d 4=AA 5=AB 6=BB 
C            7=mu 8=totvar 9=VA 10=VD 11=VG 12=VC 13=VS 14=VE 
C            15=sdG 16=sdC 17=sdS 18=sdE
C            19=a2 20=d2 21=h2 22=c2 23=s2 24=e2 
C            25..MAXPAR=Betas
      double precision glogf(MAXPEN)
      double precision gtplik, lik, par(MAXPAR), yp
C local variables
      integer gtp, j
C functions
C     integer parcon
      double precision dens, dnorm
      external dens, dnorm
C
      lik=0.0d0
      gtplik=0.0d0
      yp=par(7)+bval(idx)+mval(idx)+fammu
      do 105 j=1, nfix
        yp=yp+par(RANPAR+j)*locus(idx,j)
  105 continue
C offset
      yp=yp+locus(idx, nfix+1)
C QTL contributions
      do 120 j=1, nqtl
        gtp=hset(idx,j,2)*(hset(idx,j,2)-1)/2+hset(idx,j,1)
        yp=yp+par(3+gtp)
        gtplik=gtplik+glogf(gtp)
  120 continue
      call linfun(linkf, yp, par(7))
C Bound check binary phenotypes -- why need to evaluate unphenotypeds
      if (modtyp.eq.2 .and. (yp.lt.0.0d0 .or. yp.gt.1.0d0)) then
        lik=BADLIK 
        return
      end if
C Phenotypic likelihood contribution
      if (val(idx).ne.MISS) then
        lik=lik+dens(val(idx), yp, par(18), shap, 
     &               locus(idx,nfix+2), modtyp)
C Sibship/maternal effect contribution -- 
C if founder and phenotype unobserved, does not contribute information (cf genes)
        if (par(13).gt.0.0d0) then
          gtplik=gtplik+dnorm(mval(idx), 0.0d0, par(17))
        end if
      end if
C Gaussian polygenotype contribution
      if (par(11).gt.0.0d0) then
        gtplik=gtplik+dnorm(bval(idx), 0.0d0, par(15))
      end if
      return
      end
C end-of-seglf 
C
C Likelihood contribution of a nonfounder
      subroutine seglnf(idx, curmo, linkf, modtyp, shap, nqtl, nfix, 
     2                  glogf, par, fammu, num, nfound, fa, mo, val, 
     3                  bval, rsd, mval, locus, hset, yp, lik, gtplik)

      integer MAXHAP, MAXLOC, MAXPEN, MAXSIZ, MISS, 
     &        MAXPAR, RANPAR
      parameter(MAXSIZ=20, MAXLOC=10000, MISS=-9999, 
     2          MAXHAP=MAXLOC/2, MAXPAR=50, MAXPEN=3,
     3          RANPAR=24)
      double precision BADLIK
      parameter(BADLIK=1.0d-99)
      integer curmo, idx, linkf, modtyp, nqtl, num, nfound
      integer fa(MAXSIZ), mo(MAXSIZ)
      double precision locus(MAXSIZ, MAXLOC)
C QTL and gaussian polygenic genotypes, phenotypes
      integer hset(MAXSIZ,MAXHAP,2)
      double precision fammu
      double precision bval(MAXSIZ), rsd(MAXSIZ), val(MAXSIZ),
     &                 mval(MAXSIZ)
C model parameters
C            1=P(all) 2=a 3=d 4=AA 5=AB 6=BB 
C            7=mu 8=totvar 9=VA 10=VD 11=VG 12=VC 13=VS 14=VE 
C            15=sdG 16=sdC 17=sdS 18=sdE
C            19=a2 20=d2 21=h2 22=c2 23=s2 24=e2 
C            25..MAXPAR=Betas
      double precision glogf(MAXPEN)
      double precision gtplik, lik, par(MAXPAR), shap, yp, ypf
C local variables
      double precision midpar
C functions
C     integer parcon
      double precision dens, dnorm
      external dens, dnorm
C
      lik=0.0d0
      gtplik=0.0d0
      call fpmpred(idx, modtyp, shap, nqtl, nfix, par, fammu,
     &             bval, mval, locus, hset, yp, ypf)
      call linfun(linkf, yp, par(7))
C Bound check binary phenotypes -- why need to evaluate unphenotypeds
      if (modtyp.eq.2 .and. (yp.lt.0.0d0 .or. yp.gt.1.0d0)) then
        lik=BADLIK 
        return
      end if
C Phenotypic likelihood contribution
      if (val(idx).ne.MISS) then
        lik=lik+dens(val(idx), yp, par(18), shap, 
     &               locus(idx,nfix+2), modtyp)
C Sibship/maternal effect contribution
C If no sibship members phenotyped, does not contribute to likelihood
        if (par(13).gt.0.0d0 .and. mo(idx).ne.curmo) then
          curmo=mo(idx)
          gtplik=gtplik+dnorm(mval(idx), 0.0d0, par(17))
        end if
      end if
C Gaussian polygenotype transmission contribution
      if (par(11).gt.0.0d0) then
        midpar=0.5d0*(bval(fa(idx))+bval(mo(idx)))
        gtplik=gtplik+dnorm(bval(idx), midpar, par(15)*rsd(idx))
      end if
      return
      end
C end-of-seglnf 
C 
C  Resimulate (gene-dropping) genotypes at a single autosomal locus
C  in descendants of randomly selected index 
C
      subroutine isimped(num,nfound,fa,mo,cumfrq,set)
C
C  Pedigree structure
      integer MAXSIZ, MISS
      parameter(MAXSIZ=20, MISS=-9999)
      integer num, nfound, fa(MAXSIZ),mo(MAXSIZ), set(MAXSIZ,2)
      double precision cumfrq(*)
      integer i, idx
      logical fin
C functions
      integer irandom
C select an index person or mating and zero out descendants
      idx=irandom(1, num)
      if (idx.le.nfound .or. irandom(1,2).eq.1) then
        set(idx,1)=MISS
        set(idx,2)=MISS
      else
        set(fa(idx),1)=MISS
        set(fa(idx),2)=MISS
        set(mo(idx),1)=MISS
        set(mo(idx),2)=MISS
      end if
      do 15 i=nfound+1,num
      if (set(fa(i),1).eq.MISS .or. set(mo(i),1).eq.MISS) then
        set(i,1)=MISS
        set(i,2)=MISS
      end if
   15 continue
C fill in missing genotypes
      do 17 i=1, nfound
      if (set(i,1).eq.MISS) then
        call found(cumfrq, set(i,1))
        call found(cumfrq, set(i,2))
        call order(set(i,1),set(i,2))
      end if  
   17 continue

   20 continue      
        fin=.true.
        do 30 i=nfound+1,num
        if (set(i,1).eq.MISS) then
          if (set(fa(i),1).ne.MISS.and.set(mo(i),1).ne.MISS) 
     &    then
            call genoff(i,fa(i),mo(i),set)
          else
            fin=.false.
          end if
        end if
   30   continue
      if (.not.fin) goto 20
      return
      end
C end-of-isimped
C
C Propose updated additive polygenic values in a pedigree
C
      subroutine simpol(vsd,num,nfound,fa,mo,bval,nchanges,changes)
C
C  Pedigree structure
      integer MAXSIZ, MISS
      parameter(MAXSIZ=20, MISS=-9999)
      integer num, nfound, fa(MAXSIZ),mo(MAXSIZ)
      integer nchanges, changes(MAXSIZ)
      double precision bval(MAXSIZ), vsd
      integer i, idx, np, sim(MAXSIZ)
C functions
      integer irandom
      real randn
C
C select an 1-4 index persons or matings or everyone
C choose to alter descendants or not
C
      do 1 i=1, num
        sim(i)=0
    1 continue
      if (irandom(1,num).eq.1) then
        do 5 i=1, num
          sim(i)=1
    5   continue
      else
        np=irandom(1,4)
        do 10 i=1, np
          idx=irandom(1, num)
          if (irandom(1,2).eq.1 .and. idx.gt.nfound) then
            sim(fa(idx))=1
            sim(mo(idx))=1
          else
            sim(idx)=1
          end if
   10   continue
        if (irandom(1,4).eq.1) then
          do 15 i=nfound+1,num
          if (sim(fa(i)).eq.1 .or. sim(mo(i)).eq.1) then
            sim(i)=1
          end if
   15     continue
        end if
      end if
C tweak indicated breeding value
      nchanges=0
      do 20 i=1, num   
      if (sim(i).eq.1) then
        nchanges=nchanges+1
        changes(nchanges)=i
        bval(i)=bval(i)+vsd*dble(randn())
      end if  
   20 continue
C also have to recalculate contribution for unaltered offspring of those with
C altered breeding values
      do 30 i=nfound+1, num   
      if (sim(i).eq.0 .and. (sim(fa(i)).eq.1 .or. sim(mo(i)).eq.1)) then
        nchanges=nchanges+1
        changes(nchanges)=i
      end if  
   30 continue
      return
      end
C end-of-simpol
C
C Propose updated sibship/maternal effects in a pedigree
C
      subroutine simmat(vstep,num,nfound,fa,mo,val,mval,
     &                  nchanges,changes)
C
C  Pedigree structure
      integer MAXSIZ, MISS
      parameter(MAXSIZ=20, MISS=-9999)
      integer num, nfound, fa(MAXSIZ), mo(MAXSIZ),
     &        nchanges, changes(MAXSIZ) 
      double precision vstep
      double precision mval(MAXSIZ), val(MAXSIZ)
      integer elig, i, idx
C functions
      integer irandom
      real randn
C
      elig=0
      nchanges=0
      do 10 i=1, num
      if (val(i).ne.MISS) then
        elig=elig+1
        changes(elig)=i
      end if
   10 continue
C
      idx=changes(irandom(1,elig))
      mval(idx)=mval(idx)+vstep*dble(randn())
      if (idx.gt.nfound) then
        do 15 j=nfound+1, num
        if (mo(j).eq.mo(idx)) then
          mval(j)=mval(idx)
          nchanges=nchanges+1
          changes(nchanges)=j  
        end if
   15   continue
      else
        nchanges=nchanges+1
        changes(nchanges)=idx
      end if
      return
      end
C end-of-simmat
C
C Get empirical estimates of random effects
C
      subroutine empval(nqtl, par, num, nfound, fa, mo, hset,
     2                  fammu, bval, mval, ifam, tot, tfound, nships, 
     3                  empmu,  empvar, totall)
      integer MAXLOC, MAXPAR, MAXSIZ, MISS
      parameter(MAXPAR=50, MAXSIZ=20, MAXLOC=10000, 
     &          MAXHAP=MAXLOC/2, MISS=-9999)
      integer nqtl
      double precision par(MAXPAR)
      integer num, nfound, fa(MAXSIZ), mo(MAXSIZ)
      integer hset(MAXSIZ,MAXHAP,2)
      double precision fammu, bval(MAXSIZ), mval(MAXSIZ)
      integer ifam, nships, tfound, tot, totall
      double precision empmu(6), empvar(6)
C local variables
      integer i
C
C empirical allele count for 1st qtl
      if (nqtl.gt.0) then
        do 200 i=1,nfound 
          totall=totall+hset(i,1,1)+hset(i,1,2)
  200   continue
        tfound=tfound+nfound
      end if
C VG
      if (par(11).gt.0.0d0) then
        do 210 i=1, num
          tot=tot+1
          call moment(tot, bval(i), empmu(2), empvar(2))
  210   continue
      end if
C VC
      if (par(12).gt.0.0d0) then
        call moment(ifam, fammu, empmu(3), empvar(3))
      end if
C
C VS: random effect not always estimated
      if (par(13).gt.0.0d0) then
        cmo=MISS
        do 220 i=nfound+1, num
        if (mo(i).ne.cmo .and. mval(i).ne.MISS) then
          cmo=mo(i)
          nships=nships+1
          call moment(nships, mval(i), empmu(4), empvar(4))
        end if
  220   continue
      end if
      return
      end
C end-of-empval
C
C Tote up empirical statistics for random effects: VG, VC, VS
C
      subroutine empsum(nfam, tot, tfound, nships, empmu, empvar, 
     &                  totall, empfrq)
      integer nfam, nships, tfound, tot, totall
      double precision empfrq, empmu(6), empvar(6)
      if (totall.gt.0) empfrq=dfloat(4*tfound-totall)/dfloat(2*tfound)
      empvar(2)=empvar(2)/dfloat(max(1,tot-1))
      empvar(3)=empvar(3)/dfloat(max(1,nfam-1))
      empvar(4)=empvar(4)/dfloat(max(1,nships-1))
      return
      end
C end-of-empsum
C
C Initialize additive genetic and/or maternal random effects
C
      subroutine initvc(par, paract, num, nfound, fa, mo, 
     &                  val, bval, mval)
C  Pedigree structure
      integer MAXPAR, MAXSIZ, MISS
      parameter(MAXPAR=50, MAXSIZ=20, MISS=-9999)
      integer paract(MAXPAR)
      double precision par(MAXPAR)
      integer num, nfound, fa(MAXSIZ),mo(MAXSIZ)
      double precision bval(MAXSIZ), mval(MAXSIZ), val(MAXSIZ)
      integer cfa, cmo, i
      double precision mateff, segsd
C functions
      real randn
C
      if (paract(21).eq.1 .or. paract(11).eq.1 .or.
     &    paract(21).eq.2 .or. paract(11).eq.2) then
        segsd=par(15)/sqrt(2.0d0)
        do 10 i=1, nfound
          bval(i)=dble(randn())*par(15)
   10   continue
        do 15 i=nfound+1, num
          cfa=fa(i)
          cmo=mo(i)
          midpar=0.5d0*(bval(cfa)+bval(cmo))
          bval(i)=midpar+dble(randn())*segsd
   15   continue
      end if
      if (paract(23).eq.1 .or. paract(13).eq.1 .or.
     &    paract(23).eq.2 .or. paract(13).eq.2) then
        do 50 i=1, nfound
          if (val(i).ne.MISS) then
            mval(i)=dble(randn())*par(17)
          else
            mval(i)=MISS
          end if
   50   continue
        cmo=MISS
        mateff=0.0d0
        do 60 i=nfound+1, num
          if (val(i).ne.MISS) then
            if (mo(i).ne.cmo) then
              cmo=mo(i)
              mateff=dble(randn())*par(17)
            end if
            mval(i)=mateff
          else
            mval(i)=MISS
          end if
   60   continue
      end if
      return
      end
C end-of-initvc
C 
C Copy or swap genotypes from set to hset
C 1=set->hset; 2=hset->set; 3=swap
C
      subroutine set2hap(hpos, num, set, hset, typ)
      integer MAXHAP, MAXLOC, MAXSIZ
      parameter(MAXSIZ=20, MAXLOC=10000, MAXHAP=MAXLOC/2)
      integer hpos, num, typ
C QTL genotypes
      integer hset(MAXSIZ,MAXHAP,2), set(MAXSIZ, 2)
      integer i, tmp

      if (typ.eq.1) then
        do 10 i=1, num
          hset(i,hpos,1)=set(i,1)
          hset(i,hpos,2)=set(i,2)
   10   continue
      else if (typ.eq.2) then
        do 20 i=1, num
          set(i,1)=hset(i,hpos,1)
          set(i,2)=hset(i,hpos,2)
   20   continue
      else
        do 30 i=1, num
          tmp=hset(i,hpos,1)
          hset(i,hpos,1)=set(i,1)
          set(i,1)=tmp
          tmp=hset(i,hpos,2)
          hset(i,hpos,2)=set(i,2)
          set(i,2)=tmp
   30   continue
      end if
      return
      end
C end-of-set2hap
C
C Realized VE
C
      subroutine fpmve(linkf, modtyp, nqtl, nfix, par, fammu,
     &                 num, val, bval, mval, locus, hset, ve, vef)
      integer MAXHAP, MAXLOC, MAXSIZ, MISS, MAXPAR, RANPAR
      parameter(MAXSIZ=20, MAXLOC=10000, MISS=-9999, 
     &          MAXHAP=MAXLOC/2, MAXPAR=50, RANPAR=24)
      integer linkf, modtyp, nfix, nqtl, num
      integer hset(MAXSIZ,MAXHAP,2)
      double precision locus(MAXSIZ, MAXLOC)
      double precision bval(MAXSIZ), mval(MAXSIZ), val(MAXSIZ)
      double precision fammu, par(MAXPAR), ve, vef
      integer i
      double precision shap, yp, ypf

      shap=1.0d0
      if (modtyp.eq.4) shap=exp(par(RANPAR+nfix+1))
      do 20 i=1, num
      if (val(i).ne.MISS) then
        call fpmpred(i, modtyp, shap, nqtl, nfix, par, fammu,
     &               bval, mval, locus, hset, yp, ypf)
        if (modtyp.eq.4) then
          yp=-yp/shap
          ypf=-ypf/shap
        end if
        call linfun(linkf, yp, par(7))
        call linfun(linkf, ypf, par(7))
        yp=val(i)-yp
        ve=ve+yp*yp
        ypf=val(i)-ypf
        vef=vef+ypf*ypf
      end if
   20 continue
      return
      end
C end-of-fpmve
C
C FPM Linear predictor
C
      subroutine fpmpred(idx, modtyp, shap, nqtl, nfix, par, fammu,
     &                   bval, mval, locus, hset, yp, ypf)
      integer MAXHAP, MAXLOC, MAXSIZ, MISS, MAXPAR, RANPAR
      parameter(MAXSIZ=20, MAXLOC=10000, MISS=-9999, 
     &          MAXHAP=MAXLOC/2, MAXPAR=50, RANPAR=24)
      integer idx, nfix, nqtl
      integer hset(MAXSIZ,MAXHAP,2)
      double precision locus(MAXSIZ, MAXLOC)
      double precision bval(MAXSIZ), mval(MAXSIZ)
      double precision fammu, par(MAXPAR)
C yp and ypf are linear predictor for full model and fixed effects model
C respectively
      double precision shap, yp, ypf
      integer gtp, j

      ypf=par(7)
      do 25 j=1, nfix
        ypf=ypf+par(RANPAR+j)*locus(idx,j)
   25 continue
C offset
      ypf=ypf+locus(idx, nfix+1)
      yp=ypf+fammu+bval(idx)+mval(idx)
      do 30 j=1, nqtl
        gtp=hset(idx,j,2)*(hset(idx,j,2)-1)/2+hset(idx,j,1)
        yp=yp+par(3+gtp)
   30 continue
      return
      end
C end-of-fpmpred
C
C
C Print oneseg's proposed genotypes for one individual
C
      subroutine wronep(idx, it, yp, iqtl, nqtl, ieff, lik, par, 
     2                  pedigree, id, val, bval, mval, hset, 
     3                  newbval, newmval, set)

      integer MAXHAP, MAXLOC, MAXSIZ, MISS, MAXPAR, RANPAR
      parameter(MAXSIZ=20, MAXLOC=10000, MISS=-9999, 
     &          MAXHAP=MAXLOC/2, MAXPAR=50, RANPAR=24)
      integer idx, ieff, iqtl, it, nqtl 
      character*10 pedigree
      character*10 id(MAXSIZ)
      double precision lik, yp
      integer hset(MAXSIZ,MAXHAP,2), set(MAXSIZ, 2)
      double precision bval(MAXSIZ), mval(MAXSIZ), val(MAXSIZ)
      double precision newbval(MAXSIZ), newmval(MAXSIZ)
      double precision par(MAXPAR)

      if (iqtl.le.nqtl .and. nqtl.gt.0) then
        write(*,'(i7,1x,a10,1x,a10,3(1x,f9.4),1x,3(i3,a),i3)') 
     2    it,pedigree,id(idx),lik,val(idx),yp,set(idx,1),'/',
     3    set(idx,2),' -> ',hset(idx,iqtl,1),'/',hset(idx,iqtl,2)
      else if (ieff.eq.11) then
        write(*,'(i7,1x,a10,1x,a10,4(1x,f9.4),2(a,f9.4))') 
     2    it,pedigree,id(idx),lik,val(idx),yp, 
     3    bval(idx),' (',par(15),') -> ',newbval(idx)
      else if (ieff.eq.13) then
        write(*,'(i7,1x,a10,1x,a10,4(1x,f9.4),2(a,f9.4))') 
     2    it,pedigree,id(idx),lik,val(idx),yp, 
     3    mval(idx),' (',par(17),') -> ',newmval(idx)
      end if
      return
      end
C end-of-wronep
C
C Print simulated genotypes from FPM iteration
C
      subroutine wrfpm(it, linkf, modtyp, nqtl, nfix, parnam, par,
     2             fammu, famlik, gtplik, pedigree, num, nfound, 
     3             id, fa, mo, sex, val, bval, mval, locus, hset)

      integer MAXHAP, MAXLOC, MAXSIZ, MISS, MAXPAR, RANPAR
      parameter(MAXSIZ=20, MAXLOC=10000, MISS=-9999, 
     &          MAXHAP=MAXLOC/2, MAXPAR=50, RANPAR=24)
      integer it, linkf, nfix, modtyp, nqtl, num, nfound
      character*10 pedigree
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ), hset(MAXSIZ,MAXHAP,2), sex(MAXSIZ)
      double precision locus(MAXSIZ, MAXLOC)
      character*14 parnam(MAXPAR)
      double precision bval(MAXSIZ), mval(MAXSIZ), val(MAXSIZ)
      double precision famlik, fammu, gtplik, par(MAXPAR)
      integer addsco, cmo, i, j, gtp
      character*1 ch
      double precision shap, sval, yp
C functions
      integer eow

      shap=1.0d0
      if (modtyp.eq.4) shap=exp(par(RANPAR+nfix+1))
      write(*,'(2a,$)') '# MCMC it pedigree id fa mo sex ',
     &   'famlik gtplik fammu trait pred bval mval qtlall'
      do 5 j=1, nqtl
        write(*,'(a,i2.2,$)') ' qtl', j
    5 continue
      do 6 j=1, nfix
        write(*,'(1x,a,$)') parnam(RANPAR+j)(1:eow(parnam(RANPAR+j)))
    6 continue
      write(*,*) 'offset censored'
C   
      cmo=MISS
      sval=0.0d0
      do 20 i=1, num
        addsco=0
C if VS>0 then unphenotyped individuals/sibships get random S value
        if (par(13).gt.0.0d0) then
          if (mval(i).ne.MISS) then
            sval=mval(i)
          else if (i.le.nfound .or. mo(i).ne.cmo) then
            cmo=mo(i)
            sval=par(17)*dble(randn())
          end if
        end if
        yp=par(7)+fammu+bval(i)+sval
        do 25 j=1, nfix
          yp=yp+par(RANPAR+j)*locus(i,j)
   25   continue
C offset
        yp=yp+locus(i, nfix+1)
        do 30 j=1, nqtl
          gtp=hset(i,j,2)*(hset(i,j,2)-1)/2+hset(i,j,1)
          addsco=addsco+gtp-1
          yp=yp+par(3+gtp)
   30   continue
        if (modtyp.eq.4) then
          yp=-yp/shap
        end if
        call linfun(linkf, yp, par(7))

        write(*,'(a,i6,2(1x,a),$)') 'MCMC ', it, pedigree, id(i)
        if (fa(i).eq.MISS) then
          write(*,'(2(1x,a10),$)') 'x         ','x         '
        else
          write(*,'(2(1x,a10),$)') id(fa(i)), id(mo(i))
        end if
        call wrsex(sex(i), ch)
        write(*,'(1x,a1,$)') ch
        write(*,'(2(1x,f12.2),f12.6,$)') famlik, gtplik, fammu
        if (val(i).eq.MISS) then
          write(*,'(6x,a,$)') 'x      '
        else
          write(*,'(1x,f12.6,$)') val(i)
        end if
        write(*,'(3(1x,f12.6),1x,i3,$)') yp, bval(i), mval(i), addsco  
        do 35 j=1, nqtl
          write(*,'(1x,i1,a1,i1)') hset(i,j,1), '/', hset(i,j,2)
   35   continue
        do 36 j=1, nfix+1
          write(*,'(1x,f9.4,$)') locus(i,j)
   36   continue
        write(*,'(1x,i1)') max(0, int(locus(i,nfix+2)))
   20 continue
      return
      end
C end-of-wrfpm
C
C Read FPM data from work file
C
      subroutine fpmrd(wrk,ncol,nqtl,famlik,gtplik,fammu,pedigree,
     2              num,nfound,id,fa,mo,sex,locus,val,bval,rsd,
     3              mval, hset)
      integer MAXSIZ,MAXLOC, MAXHAP
      parameter (MAXSIZ=20, MAXLOC=10000, MAXHAP=MAXLOC/2)
      integer ncol, nqtl, wrk
C Pedigree structure
      character*10 pedigree
      integer num, nfound
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ), sex(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)
      integer hset(MAXSIZ,MAXHAP,2)
      double precision famlik, fammu, gtplik
      double precision bval(MAXSIZ), mval(MAXSIZ), rsd(MAXSIZ), 
     &                 val(MAXSIZ)  
      integer i, j
      read(wrk) pedigree, num, nfound, famlik, gtplik, fammu,
     2  (id(i), fa(i), mo(i), sex(i), 
     3   val(i), bval(i), rsd(i), mval(i), 
     4   (locus(i,j), j=1, ncol), 
     5   (hset(i,j,1), hset(i,j,2), j=1, nqtl), i=1,num)
      return
      end
C end-of-fpmrd
C
C Write FPM data to work file
C
      subroutine fpmwr(wrk,ncol,nqtl,famlik,gtplik,fammu,pedigree,
     2              num,nfound,id,fa,mo,sex,locus,val,bval,rsd,
     3              mval, hset)
      integer MAXSIZ,MAXLOC
      parameter (MAXSIZ=20, MAXLOC=10000, MAXHAP=MAXLOC/2)
      integer ncol, nqtl, wrk
C Pedigree structure
      character*10 pedigree
      integer num, nfound
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ), sex(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)
      integer hset(MAXSIZ,MAXHAP,2)
      double precision famlik, fammu, gtplik
      double precision bval(MAXSIZ), mval(MAXSIZ), rsd(MAXSIZ), 
     &                 val(MAXSIZ)  
      integer i, j
      write(wrk) pedigree, num, nfound, famlik, gtplik, fammu,
     2  (id(i), fa(i), mo(i), sex(i), 
     3   val(i), bval(i), rsd(i), mval(i), 
     4   (locus(i,j), j=1, ncol), 
     5   (hset(i,j,1), hset(i,j,2), j=1, nqtl), i=1,num)
      return
      end
C end-of-fpmwr
C
C Print out simulated genotype distribution for specified persons in one
C pedigree
C
      subroutine doimp(wrk,gene,narg,words,iter,
     2             burnin,pedigree,actset,num,nfound,id,
     3             fa,mo,sex,locus,numloc,numal,name,alfrq,cumfrq,
     4             gfrq,set,set2,sibd,key,untyped,plevel)
      integer KNOWN, MAXALL, MAXCOL, MAXG, MAXSIZ,
     &        MAXLOC, MISS
      parameter(MAXALL=2, MAXG=MAXALL*(MAXALL+1)/2, MAXSIZ=20, 
     2          MAXLOC=10000, MAXCOL=MAXLOC+5, MISS=-9999, KNOWN=0) 
      integer burnin,gene,iter,plevel,wrk 
      integer narg
      character*20 words(MAXCOL)
C  Pedigree structure
      character*10 pedigree
      integer actset,num, nfound
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ)
      integer sex(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)
C allele frequencies structure
      integer numal, name(MAXALL)
      double precision alfrq(MAXALL), cumfrq(MAXALL), gfrq(MAXG)
C work arrays for metropolis algorithm
      integer nuntyp
      logical untyped(MAXSIZ)
      integer set(MAXSIZ,2), sibd(MAXSIZ,2), key(2*MAXSIZ)
C metropolis work arrays
      integer set2(MAXSIZ,2)
C untyped matings
      integer nummat, cntmat(MAXALL,2)
C local variables
      integer g1, g2, gen2, i, iprop, j, nind, indx(MAXSIZ)
      logical alltyp, last, xmale
      character*10 gtp
C functions
      integer getnam

      xmale=.false.
      gen2=gene+1
      last=.false.
      rewind(wrk)
    5 continue
        call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &             numloc, last)
        if (last) goto 20

        if (actset.le.0 .or. (pedigree.ne.words(3))) goto 5
C
C Load selected people into indx and genotypes into set()
        write(*,*) 'Pedigree ', pedigree, ':'
        nind=0
        do 10 j=4, narg
          do 11 i=1,num
          if (words(j).eq.id(i)) then
            nind=nind+1
            indx(nind)=i
            goto 10
          end if
   11     continue
   10   continue
        do 12 i=1, nind
          call wrid('c',id(indx(i)),gtp,0)
          write(*,'(a10,$)') gtp
   12   continue
        write(*,*)

        nuntyp=0
        alltyp=.true.
        do 25 i=1,num
          if (locus(i,gene).le.KNOWN) then
            alltyp=.false.
            untyped(i)=.true.
            nuntyp=nuntyp+1
            if (locus(i,gene).eq.0 .or. locus(i,gene).eq.MISS) then
              g1=MISS
              g2=MISS
            else
              g1=getnam(-locus(i,gene),numal,name)
              g2=getnam(-locus(i,gen2),numal,name)
            end if
          else
            untyped(i)=.false.
            g1=getnam(locus(i,gene),numal,name)
            g2=getnam(locus(i,gen2),numal,name)
          end if
          call update(i,g1,g2,set)
   25   continue
        
        if (alltyp) then
          do 26 i=1, nind
            call wrgtp(name(set(indx(i),1)),name(set(indx(i),2)),gtp,1)
            write(*,'(a10,$)') gtp
   26     continue
          write(*,*) 
        else
C produce genotype frequencies for Metropolis criterion
C enumerate untyped founder matings
          call genot(numal,alfrq,ngtp,gfrq)
          call tabmat(num,nfound,fa,mo,untyped,nummat,cntmat)
C Metropolis simulation of genotypes
          if (plevel.gt.1) then
            write(*,'(/2a,4(/a,i4))') 
     2        'Metropolis simulation of pedigree ',pedigree,
     3        'Untyped Individuals: ',nuntyp,
     4        'Possible genotypes : ',ngtp,
     5        'UnT x UnT matings  : ',nummat,
     6        'Burn-in (iters)    : ',burnin
          end if
          do 44 it=1,burnin
            call drop(it,pedigree,num,nfound,id,fa,mo,nummat,
     &             cntmat,untyped,numal,gfrq,set,set2,sibd,key,iprop,0)
   44     continue
          do 45 it=1,iter
            call drop(it,pedigree,num,nfound,id,fa,mo,nummat,
     2             cntmat,untyped,numal,gfrq,set,set2,sibd,
     3             key,iprop,plevel)
            write(*,'(i2,$)') iprop
            do 46 i=1, nind
              call wrgtp(name(set(indx(i),1)),
     &                   name(set(indx(i),2)),gtp,1)
              write(*,'(a10,$)') gtp
   46       continue
          write(*,*) 
   45     continue
        end if
   20 continue
      return
      end
C end-of-doimp
C
C Monte-Carlo approach to estimating one-locus homozygosity by descent 
C
      subroutine wrhbd(wrk,twrk,gene,trait,iter,burnin,pedigree,
     2              actset,num,nfound,id,fa,mo,sex,locus, numloc,
     3              numal,name,alfrq,gfrq,untyped,set,set2,sibd,key,
     4              ibdcount, plevel)
      integer IBDSIZ, KNOWN, MAXALL, MAXG, MAXIBD, MAXSIZ, MAXLOC, MISS
      parameter(MAXALL=2, MAXG=MAXALL*(MAXALL+1)/2, MAXSIZ=20, 
     2          MAXLOC=10000, MISS=-9999, KNOWN=0, 
     3          MAXIBD=20, IBDSIZ=MAXIBD*(MAXIBD+1)/2)
      integer burnin,gene,iter,plevel,trait,twrk,wrk 
C  Pedigree structure
      character*10 pedigree
      integer actset,num, nfound
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ)
      integer sex(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)
C allele frequencies structure
      integer numal, name(MAXALL)
      double precision alfrq(MAXALL), gfrq(MAXG)
C work arrays for metropolis algorithm
      integer nuntyp
      logical untyped(MAXSIZ)
      integer set(MAXSIZ,2), sibd(MAXSIZ,2), key(2*MAXSIZ)
C metropolis work arrays
      integer set2(MAXSIZ,2)
C untyped matings
      integer nummat, cntmat(MAXALL,2)
C homozygosity-by-descent
      double precision ibdcount(MAXIBD)
C local variables
      integer g1,g2,gen2,i,idx,iprop,nfam
      logical alltyp,last,useful
      character*7 gtp
      double precision den
C functions
      integer getnam

      if (trait.eq.MISS .or. plevel.gt.1) then
        write(*,'(a)') 'Pedigree   ID        HBD    F       Gtp'
      end if

      den=1.0d0/dfloat(iter)
      gen2=gene+1
      last=.false.
      nfam=0
      rewind(wrk)
    5 continue
        call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &             numloc, last)
        if (last) goto 20

        if (actset.le.0) then
          if (trait.ne.MISS) then
            call wrkout(twrk,pedigree,actset,num,nfound,id,fa,mo,sex,
     &                  locus,numloc)
          end if
          goto 5
        end if
C
C test if informative pedigree -- at least one genotyped individual
C
        useful=.false.
        do 7 i=1,num
        if (locus(i,gene).gt.KNOWN) then
          useful=.true.
          goto 8
        end if
    7   continue
    8   continue
C
        if (.not.useful) then
          if (trait.ne.MISS) then
            call wrkout(twrk,pedigree,actset,num,nfound,id,fa,mo,sex,
     &                  locus,numloc)
          end if
          goto 5
        end if
C
C Load genotypes into set()
        nfam=nfam+1
        nuntyp=0
        alltyp=.true.
        do 12 i=1,num
          if (locus(i,gene).le.KNOWN) then
            alltyp=.false.
            untyped(i)=.true.
            nuntyp=nuntyp+1
            if (locus(i,gene).eq.0 .or. locus(i,gene).eq.MISS) then
              g1=MISS
              g2=MISS
            else
              g1=getnam(-locus(i,gene),numal,name)
              g2=getnam(-locus(i,gen2),numal,name)
            end if
          else
            untyped(i)=.false.
            g1=getnam(locus(i,gene),numal,name)
            g2=getnam(locus(i,gen2),numal,name)
          end if
          call update(i,g1,g2,set)
   12   continue
        call kinship(num,nfound,fa,mo,ibdcount)
        idx=0
        do 15 i=1, num
          idx=idx+i
          ibdcount(i)=ibdcount(idx)-1.0d0
   15   continue
        do 16 i=num+1, 2*num
          ibdcount(i)=0.0d0
   16   continue
C
C IBD: all genotypes known
C
        if (alltyp) then
          do 10 it=1,iter
            call simibd(2,pedigree,num,nfound,fa,mo,set,sibd)
            do 25 i=1,num
            if (sibd(i,1).eq.sibd(i,2)) then
              ibdcount(num+i)=ibdcount(num+i)+1.0d0
            end if
   25       continue
   10     continue
        else
C IBD: some untyped markers:
C produce genotype frequencies for Metropolis criterion
C enumerate untyped founder matings
          call genot(numal,alfrq,ngtp,gfrq)
          call tabmat(num,nfound,fa,mo,untyped,nummat,cntmat)
C Metropolis simulation of genotypes
          if (plevel.gt.1) then
            write(*,'(/2a,4(/a,i4))') 
     2        'Metropolis simulation of pedigree ',pedigree,
     3        'Untyped Individuals: ',nuntyp,
     4        'Possible genotypes : ',ngtp,
     5        'UnT x UnT matings  : ',nummat,
     6        'Burn-in (iters)    : ',burnin
          end if
          do 44 it=1,burnin
            call drop(it,pedigree,num,nfound,id,fa,mo,nummat,
     &             cntmat,untyped,numal,gfrq,set,set2,sibd,key,iprop,0)
   44     continue
          do 45 it=1,iter
            call drop(it,pedigree,num,nfound,id,fa,mo,nummat,
     2             cntmat,untyped,numal,gfrq,set,set2,sibd,
     3             key,iprop,plevel)
            call simibd(2,pedigree,num,nfound,fa,mo,set,sibd)
            do 65 i=1,num
            if (sibd(i,1).eq.sibd(i,2)) then
              ibdcount(num+i)=ibdcount(num+i)+1.0d0
            end if
   65       continue
   45     continue
        end if
        if (trait.eq.MISS .or. plevel.gt.1) then
          do 70 i=1,num
            if (untyped(i)) then
              call wrgtp(MISS,MISS,gtp,1)
            else
              call wrgtp(int(locus(i,gene)), 
     &                   int(locus(i,gen2)),gtp,1)
            end if
            write(*,'(a10,1x,a10,2(1x,f6.4), 1x, a7)') 
     &        pedigree, id(i), den*ibdcount(num+i), ibdcount(i), gtp
   70     continue
        end if
        if (trait.ne.MISS) then
          do 80 i=1,num
            locus(i, trait)=den*ibdcount(num+i)
   80     continue
          call wrkout(twrk,pedigree,actset,num,nfound,id,fa,mo,sex,
     &                locus,numloc)
        end if
      goto 5
   20 continue
C
      return
      end
C end-of-wrhbd  
C
C MCEM for pedigree allele frequencies
C
      subroutine mcfreq(wrk,twrk,twrk2,gene,iter,emiter,pedigree,
     3             actset,num,nfound,id,fa,mo,sex,locus,numloc,numal,
     4             name,alfrq,alfrq2,gfrq,set,set2,sibd,key,
     5             untyped,totall,typed,plevel)
      integer KNOWN, MAXALL, MAXCOL, MAXG, MAXSIZ,
     &        MAXLOC, MISS
      parameter(MAXALL=2, MAXG=MAXALL*(MAXALL+1)/2, MAXSIZ=20, 
     2          MAXLOC=10000, MAXCOL=MAXLOC+5, MISS=-9999, KNOWN=0) 
      integer emiter, gene, iter, plevel, totall,twrk,twrk2,typed,wrk 
C  Pedigree structure
      character*10 pedigree
      integer actset,num, nfound
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ)
      integer sex(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)
C allele frequencies structure
      integer numal, name(MAXALL)
      double precision alfrq(MAXALL), alfrq2(MAXALL), 
     &                 gfrq(MAXG)
C work arrays for metropolis algorithm
      integer nuntyp
      logical untyped(MAXSIZ)
      integer set(MAXSIZ,2), sibd(MAXSIZ,2), key(2*MAXSIZ)
C metropolis work arrays
      integer set2(MAXSIZ,2)
C interrupt
      integer irupt
      common /flag/ irupt
C untyped matings
      integer nummat, cntmat(MAXALL,2)
C local variables
      integer emit, g1, g2, gen2, i, iprop, j, maxem, nfam, 
     &        ntyped, tfound, wrknum
      integer proprate(4), proptyp(4)
      character*12 wrkfil
      logical alltyp,last
      double precision accel, delta, den, one,  wei
C functions
      integer getnam  

      if (numal.eq.0) then
        return
      end if

      wrknum=1
      wrkfil='sp-mcf.wrk'
      call newnam(wrknum, wrkfil)
      open(twrk,file=wrkfil,form='unformatted')

      gen2=gene+1
      nfam=0
      ntyped=0
      nuntyp=0
      tfound=0
      one=1.0d0
      wei=1.0d0/dfloat(iter)
      last=.false.
      rewind(wrk)
    5 continue
        call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &             numloc, last)
        if (last) goto 20

        if (actset.le.0) goto 5

        nfam=nfam+1
        tfound=tfound+nfound
        alltyp=.true.
        do 25 i=1,num
          if (locus(i,gene).le.KNOWN) then
            if (i.le.nfound) then
              alltyp=.false.
              nuntyp=nuntyp+1
            end if
            untyped(i)=.true.
            if (locus(i,gene).eq.0 .or. locus(i,gene).eq.MISS) then
              g1=MISS
              g2=MISS
            else
              g1=getnam(-locus(i,gene),numal,name)
              g2=getnam(-locus(i,gen2),numal,name)
            end if
          else
            ntyped=ntyped+1
            untyped(i)=.false.
            g1=getnam(locus(i,gene),numal,name)
            g2=getnam(locus(i,gen2),numal,name)
          end if
          call update(i,g1,g2,set)
   25   continue
        write(twrk) alltyp, pedigree, num, nfound, 
     &    (id(i),fa(i),mo(i), untyped(i), set(i,1), set(i,2), i=1, num)
      goto 5
   20 continue

      maxem=emiter
      if (nuntyp.eq.0) maxem=1

      den=1.0d0/dfloat(2*tfound)
C
C EM iterations
C
      do 99 i=1, numal
        alfrq(i)=1.0d0/dfloat(numal)
   99 continue

      emit=0
  100 continue
        emit=emit+1
        do 101 i=1, numal
          alfrq2(i)=0.0d0
  101   continue
        do 102 i=1,4
          proprate(i)=0
          proptyp(i)=0
  102   continue
        call genot(numal,alfrq,ngtp,gfrq)
        call newnam(wrknum, wrkfil)
        open(twrk2,file=wrkfil,form='unformatted')
        rewind(twrk)
        do 65 j=1, nfam
          read(twrk) alltyp, pedigree, num, nfound, 
     &      (id(i),fa(i),mo(i),untyped(i), set(i,1),set(i,2), i=1, num)
          if (.not.alltyp) then
            call tabmat(num,nfound,fa,mo,untyped,nummat,cntmat)
            if (plevel.gt.1) then
              write(*,'(/2a)') 
     &          'Metropolis simulation of pedigree ',pedigree 
            end if
            do 45 it=1,iter
              call drop(it,pedigree,num,nfound,id,fa,mo,nummat,
     2               cntmat,untyped,numal,gfrq,set,set2,sibd,
     3               key,iprop,plevel)
              call cntprop(iprop, proprate, proptyp)
              do 50 i=1, nfound
                alfrq2(set(i,1))=alfrq2(set(i,1))+wei
                alfrq2(set(i,2))=alfrq2(set(i,2))+wei
   50         continue
   45       continue
          else
            do 55 i=1, nfound
              alfrq2(set(i,1))=alfrq2(set(i,1))+one
              alfrq2(set(i,2))=alfrq2(set(i,2))+one
   55       continue
          end if
          write(twrk2) alltyp, pedigree, num, nfound, 
     &      (id(i),fa(i),mo(i),untyped(i), set(i,1),set(i,2), i=1, num)
   65   continue
        accel=1.0d0
        if (emit.le.(maxem/2)) then
          accel=dfloat(emit+1)/dfloat(emit)
        end if
        do 75 i=1, numal
           delta=alfrq(i)-den*alfrq2(i)
           alfrq(i)=alfrq(i)-accel*delta
           if (alfrq(i).lt.0.0d0) alfrq(i)=0.01d0
           if (alfrq(i).gt.1.0d0) alfrq(i)=0.99d0
   75   continue
        if (plevel.gt.0) then
          call wrprop(emit, proprate, proptyp)
          write(*,'(i4,1x,12(1x,f5.3):)') emit, (alfrq(i), i=1, numal)
        end if
        close(twrk,status='delete')
        close(twrk2,status='keep')
        open(twrk,file=wrkfil,form='unformatted')
      if (emit.lt.maxem .and. irupt.eq.0) goto 100
      close(twrk,status='delete')
      if (plevel.gt.0) write(*,*)
      totall=2*tfound
      typed=tfound-nuntyp
      return
      end
C end-of-mcfreq
C
C Increment counts of MCMC proposal type
C
      subroutine cntprop(iprop, proprate, proptyp)
      integer iprop 
      integer proprate(4), proptyp(4)
      proptyp(abs(iprop))=proptyp(abs(iprop))+1
      if (iprop.gt.0) then
        proprate(iprop)=proprate(iprop)+1
      end if
      return
      end
C end-of-cntprop
C
C Summary of MCMC proposals from drop()
C
      subroutine wrprop(ilabel, proprate, proptyp)
      integer ilabel
      integer proprate(4), proptyp(4)
      character*3 proplab(4)
      data proplab /'ibd','mut','swi','loc'/

      if (ilabel.gt.0) then
        write(*,'(a,i4,$)') 'DROP ', ilabel
      else
        write(*,'(/a,$)') 'MCMC proposals:'
      end if
      write(*,'(4(1x, a3, i7, 1x, f5.3))')
     2  (proplab(i), proptyp(i), 
     3   dfloat(proprate(i))/dfloat(max(1,proptyp(i))), i=1,4)
      return
      end
C end-of-wrprop
C
C write out haplotypes in nuclear family and grandparents
C
      subroutine dohaplo(wrk,wrk2,trait,iter,nloci,loc,loctyp,locpos,
     &             pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &             numloc,hset,showorig)
      integer KNOWN, MAXHAP, MAXSIZ, MAXLOC, MISS
      parameter(KNOWN=0,MAXSIZ=20,MAXLOC=10000,
     &          MAXHAP=MAXLOC/2,MISS=-9999)

      integer iter,showorig,trait,wrk,wrk2
C
C Pedigree structure
      character*10 pedigree
      integer actset, num, nfound
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ), sex(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)
      integer numloc
C
C Locus structure 
      integer nloci
      character*20 loc(MAXLOC)
      integer loctyp(MAXLOC),locpos(MAXLOC)
C
C Storage space for haplotypes
      integer hset(MAXSIZ,MAXHAP,2)
C
C Marker list
      integer nmark, mark(MAXHAP)
C 
      integer currf, currm, gene, gen2, i, j, sta, ltyp
      logical last

      irupt=0

      ltyp=0
      nmark=0
      do 1 j=1,nloci
      if (loctyp(j).le.2) then
        if (ltyp.eq.0) then
          ltyp=loctyp(j)
        else if (loctyp(j).ne.ltyp) then
          write(*,'(a)')
     &      'NOTE:  Mixed sex-linked and autosomal markers!' 
        end if
        nmark=nmark+1
        mark(nmark)=j
        if (nmark.eq.MAXHAP) goto 2
      end if
    1 continue
    2 continue
      if (ltyp.eq.0) then
        write(*,'(a)') 'ERROR: No markers active.' 
        return
      end if

      rewind(wrk)
   10 continue
       call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &            numloc,last)
       if (last .or. irupt.gt.0) goto 20

       if (actset.le.0) goto 10
C
        do 25 i=1,num
        do 25 j=1,nmark
          gene=locpos(mark(j))
          gen2=gene+1
          if (locus(i,gene).gt.KNOWN) then
            hset(i,j,1)=int(locus(i,gene))
            hset(i,j,2)=int(locus(i,gen2))
          else
            hset(i,j,1)=MISS
            hset(i,j,2)=MISS
          end if
   25   continue

        currf=fa(nfound+1)
        currm=mo(nfound+1)
        sta=nfound+1
        do 30 i=nfound+1,num
C Print results of last sibship and do parents of current sibship
          if (fa(i).ne.currf .or. mo(i).ne.currm) then
            call wrhaplo(wrk2,pedigree,currf,currm,sta,i-1,nmark,mark, 
     &            iter,trait,nloci,loc,id,fa,mo,sex,locus,hset,showorig)
            sta=i
            currf=fa(i)
            currm=mo(i)
          end if
   30   continue
        call wrhaplo(wrk2,pedigree,currf,currm,sta,num,nmark,mark, 
     &         iter,trait,nloci,loc,id,fa,mo,sex,locus,hset,showorig)
      goto 10
   20 continue

      return
      end
C end-of-dohaplo
C
C Write haplotypes for sibship, parents, and grandparents, if available
C
      subroutine wrhaplo(wrk2,pedigree,currf,currm,sta,fin,nmark,mark, 
     2             iter,trait,nloci,loc,id,fa,mo,sex,locus,
     3             hset,showorig)
      integer MAXSIZ, MAXLOC, MAXHAP, MISS, WIDE
      parameter(MAXSIZ=20,MAXLOC=10000,MAXHAP=MAXLOC/2,
     &          MISS=-9999,WIDE=12)

      integer currf, currm, fin, iter, sta, trait,wrk2
      integer showorig
C Marker list
      integer nmark, mark(MAXHAP)
C
C Pedigree structure
      character*10 pedigree
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ), sex(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)
C
C Locus structure:
      integer nloci
      character*20 loc(MAXLOC)
C
C Storage space for haplotypes
      integer hset(MAXSIZ,MAXHAP,2)
C
C local variables
      integer i, j, eol, eop, leftm, npars, pos, nsibs
      logical gp1, gp2, use
      character*1 pchrom(4),mchrom(4)
      character*3 allel
      character*7 gtp
      character*10 chid
      character*128 lin
C
C functions
      integer eow,gpsrc

      data mchrom,pchrom /'|','c','d','*','|','a','b','*'/

      if (showorig.lt.2) then
        mchrom(1)=' '
        mchrom(2)=' '
        mchrom(3)=' '
        pchrom(1)=' '
        pchrom(2)=' '
        pchrom(3)=' '
        if (showorig.lt.1) then
          mchrom(4)=' '
          pchrom(4)=' '
        end if
      end if
      eop=eow(pedigree)
C
C Check if useful to view (some typed siblings or one child plus parent)
C
      npars=0
      nsibs=0
      call usehap(currf,nmark,hset,use)
      if (use) npars=npars+1
      call usehap(currm,nmark,hset,use)
      if (use) npars=npars+1
      do 2 i=sta,fin
        call usehap(i,nmark,hset,use)
        if (use) then
          nsibs=nsibs+1 
        end if
    2 continue
    
      if (nsibs.eq.0 .or. (nsibs.eq.1 .and. npars.eq.0)) return
C
C Utility of grandparents
C
      if (fa(currf).ne.MISS) then
        call usehap(fa(currf),nmark,hset,gp1)
        if (.not.gp1) call usehap(mo(currf),nmark,hset,gp1)
      else
        gp1=.false.
      end if
      if (fa(currm).ne.MISS) then
        call usehap(fa(currm),nmark,hset,gp2)
        if (.not.gp2) call usehap(mo(currm),nmark,hset,gp2)
      else
        gp2=.false.
      end if

C note the nuclear family level inconsistencies
      write(*,'(8a/)')
     2  'Sibship: ',pedigree(1:eop),'-',id(currf)(1:eow(id(currf))),
     3  ' x ',pedigree(1:eop),'-',id(currm)(1:eow(id(currm))) 
      call check2(pedigree,eop,currf,currm,sta,fin,id,
     &            nmark,mark,loc,hset)
      call maxshare(currf,currm,fa(currf),mo(currf),
     &              fa(currm),mo(currm),sta,fin,iter,nmark,hset)
      if (iter.gt.0) then
        call recmin(wrk2,currf,currm,fa(currf),mo(currf),
     &              fa(currm),mo(currm),sta,fin,iter,nmark,hset)
      end if
      lin=' '
C
C Show grandparental generation if useful and present
C
C IDs
      if (gp1 .or. gp2) then
        if (gp1) then
          call wrid('c',id(fa(currf)),chid,sex(fa(currf)))
          lin(17:26)=chid
          call wrid('c',id(mo(currf)),chid,sex(mo(currf)))
          lin(27:36)=chid
          eol=35
        end if
        if (gp2) then
          call wrid('c',id(fa(currm)),chid,sex(fa(currm)))
          lin(37:46)=chid
          call wrid('c',id(mo(currm)),chid,sex(mo(currm)))
          lin(47:56)=chid
          eol=55
        end if
        write(*,'(a)') lin(1:eol)
C trait if requested
        if (trait.ne.MISS) then
          if (gp1) then
            call wraff7(locus(fa(currf),trait),gtp)
            lin(18:24)=gtp
            call wraff7(locus(mo(currf),trait),gtp)
            lin(28:34)=gtp
            eol=34
          end if
          if (gp2) then
            call wraff7(locus(fa(currm),trait),gtp)
            lin(38:44)=gtp
            call wraff7(locus(mo(currm),trait),gtp)
            lin(48:54)=gtp
            eol=54
          end if
          write(*,'(a)') lin(1:eol)
        end if
C markers
        do 10 j=1,nmark
          lin=' '
          if (gp1) then
            call wrgtp(hset(fa(currf),j,1),
     &                 hset(fa(currf),j,2),gtp,0)
            lin(18:24)=gtp
            call wrgtp(hset(mo(currf),j,1),
     &                 hset(mo(currf),j,2),gtp,0)
            lin(28:34)=gtp
            eol=34
          end if
          if (gp2) then
            call wrgtp(hset(fa(currm),j,1),
     &                 hset(fa(currm),j,2),gtp,0)
            lin(38:44)=gtp
            call wrgtp(hset(mo(currm),j,1),
     &                 hset(mo(currm),j,2),gtp,0)
            lin(48:54)=gtp
            eol=54
          end if
          write(*,'(a)') lin(1:eol)
   10   continue
        lin=' '
        if (gp1) then
          lin(21:21)='|'
          lin(31:31)='|'
          eol=31
        end if
        if (gp2) then
          lin(41:41)='|'
          lin(51:51)='|'
          eol=51
        end if
        write(*,'(a)') lin(1:eol)
        lin=' '
        if (gp1) then
          lin(21:31)='+====+====+'
          eol=31
        end if
        if (gp2) then
          lin(41:51)='+====+====+'
          eol=51
        end if
        write(*,'(a)') lin(1:eol)
        lin=' '
        if (gp1) then
          lin(26:26)='|'
          eol=26
        end if
        if (gp2) then
          lin(46:46)='|'
          eol=46
        end if
        write(*,'(a)') lin(1:eol)
        lin=' '
      end if
C
C Now the parents of the nuclear family
C
      call wrid('c',id(currf),chid,sex(currf))
      lin(22:31)=chid
      call wrid('c',id(currm),chid,sex(currm))
      lin(42:51)=chid
      write(*,'(a)') lin(1:50)
      if (trait.ne.MISS) then
        lin=' '
        lin(11:20)=loc(trait)
        call wraff7(locus(currf,trait),gtp)
        lin(23:29)=gtp
        call wraff7(locus(currm,trait),gtp)
        lin(43:49)=gtp
        write(*,'(a)') lin(1:49)
      end if
      do 20 j=1,nmark
        lin=' '
        lin(11:20)=loc(mark(j))
        call wrgtp(hset(currf,j,1),hset(currf,j,2),gtp,0)
        lin(23:29)=gtp
        call wrgtp(hset(currm,j,1),hset(currm,j,2),gtp,0)
        lin(43:49)=gtp
        write(*,'(a)') lin(1:49)
        lin=' '
   20 continue
      write(*,'(25x,a1,19x,a1/25x,a21/35x,a1)')
     &  '|','|','+=========+=========+','|'
C
C Then the children
C
      nsibs=fin-sta+1
      if (nsibs.eq.1) then
        call wrid('c',id(sta),chid,sex(sta))
        write(*,'(35x,a1/31x,a10)') '|',chid
        if (trait.ne.MISS) then
          call wraff7(locus(sta,trait),gtp)
          write(*,'(20x,a10,2x,a7)') loc(trait),gtp
        end if
        do 30 j=1,nmark
          call wrgtp(hset(sta,j,1),hset(sta,j,2),gtp,0)
          write(*,'(20x,a10,1x,a1,a7,a1)') loc(mark(j)),
     2      pchrom(gpsrc(currf,sta,1,j,hset)+1),
     3      gtp,
     4      mchrom(gpsrc(currm,sta,2,j,hset)+1)
   30   continue
        if (showorig.gt.0 .and. iter.gt.0) then
          call recnum(sta,currf,currm,nmark,hset,gtp)
          write(*,'(32x,a7)') gtp 
        end if
      elseif (nsibs.gt.WIDE) then
        do 40 i=sta,fin
          write(*,*)
          lin=' '
          pos=1
          do 41 j=1,nmark
            call wrall(hset(i,j,1),allel)
            lin(pos:pos+2)=allel
            pos=pos+4
   41     continue
          write(*,'(28x,a10,a)') id(i),lin(1:pos)
          lin=' '
          pos=1
          do 42 j=1,nmark
            call wrall(hset(i,j,2),allel)
            lin(pos:pos+2)=allel
            pos=pos+4
   42     continue
          call recnum(i,currf,currm,nmark,hset,gtp)
          write(*,'(28x,a,1x,a)') gtp,lin(1:pos)
   40   continue
      else
        leftm=max(13,38-5*nsibs)
        pos=leftm+3
        do 50 i=1,nsibs-1
          lin(pos:pos+10)='+---------+'
          pos=pos+10
   50   continue
        lin(36:36)='+'
        write(*,'(a)') lin(1:pos)
        lin=' '
        pos=leftm+3
        do 60 i=1,nsibs
          lin(pos:pos)='|'
          pos=pos+10
   60   continue
        write(*,'(a)') lin(1:pos)
        lin=' '
        pos=leftm
        do 70 i=sta,fin
          call wrid('c',id(i),chid,sex(i))
          lin(pos:pos+9)=chid
          pos=pos+11
   70   continue
        write(*,'(a)') lin(1:pos)
        if (trait.ne.MISS) then
          lin=' '
          lin(leftm-12:leftm-3)=loc(trait)
          pos=leftm
          do 75 i=sta,fin
            call wraff7(locus(i,trait),gtp)
            lin(pos:pos+6)=gtp
            pos=pos+10
   75     continue
          write(*,'(a)') lin(1:pos)
        end if
        do 80 j=1,nmark
          lin=' '
          lin(leftm-12:leftm-3)=loc(mark(j))
          pos=leftm
          do 90 i=sta,fin
            call wrgtp(hset(i,j,1),hset(i,j,2),gtp,0)
            lin(pos:pos+6)=gtp
            lin(pos-1:pos-1)=pchrom(gpsrc(currf,i,1,j,hset)+1)
            lin(pos+7:pos+7)=mchrom(gpsrc(currm,i,2,j,hset)+1)
            pos=pos+10
   90     continue
          write(*,'(a)') lin(1:pos)
   80   continue

        if (showorig.gt.0 .and. iter.gt.0) then
          lin=' '
          pos=leftm 
          do 100 i=sta,fin
            call recnum(i,currf,currm,nmark,hset,gtp)
            lin(pos:pos+6)=gtp
            pos=pos+10
  100     continue
          write(*,'(a)') lin(1:pos)
        end if
      end if
      write(*,*)

      return
      end
C end-of-wrhaplo 
C
C Search for best haplotypes based on recmin criterion
C
      subroutine recmin(wrk2,currf,currm,gran1,gran2,gran3,gran4,
     &                  sta,fin,iter,nmark,hset)
      integer KNOWN, MAXLOC, MAXHAP, MAXSIZ, MISS
      parameter(KNOWN=0, MAXLOC=10000, MAXHAP=MAXLOC/2, 
     &          MAXSIZ=20, MISS=-9999)

      integer iter, wrk2
      integer currf, currm, fin, gran1, gran2, gran3, gran4, sta
      integer nmark, hset(MAXSIZ,MAXHAP,2)

      integer nchoice, choice(MAXSIZ)

      integer i, it, kids, maxit, nerr, nrec
      integer id1, id2, id3, loc1, loc2, loc3, pos1, pos2, tmp, typ
      integer oall1, oall2, whp1, whp2, whgp1, whgp2
      logical gp1, gp2, gp3, gp4, s1

      integer hicount, hicrit, minstart, nconverge, starts
      integer bestcrit, newcrit, oldcrit
      double precision rate, temp
C functions
      integer irandom
      logical metrop
C
C Only visit useful individuals
C
      nchoice=0
      if (gran1.ne.MISS) then
        call addhap(gran1,nmark,hset,nchoice,choice,gp1)
        call addhap(gran2,nmark,hset,nchoice,choice,gp2)
      else
        gp1=.false.
        gp2=.false.
      end if
      if (gran3.ne.MISS) then
        call addhap(gran3,nmark,hset,nchoice,choice,gp3)
        call addhap(gran4,nmark,hset,nchoice,choice,gp4)
      else
        gp3=.false.
        gp4=.false.
      end if
C Always include parents
      nchoice=nchoice+1
      choice(nchoice)=currf
      nchoice=nchoice+1
      choice(nchoice)=currm
C
C Mark start of children's IDs in choice()
C
      kids=nchoice+1
      do 2 i=sta,fin
        call addhap(i,nmark,hset,nchoice,choice,s1)
    2 continue
C
C maxit is maximum number of iterations of SA search algorithm
C and controls the cooling schedule: rate
C
C pos1 and pos2 are the boundaries of the region currently being worked on
C (sliding window which traverses the whole region repeatedly)
C
C The stopping criterion is a failure to improve for nconverge proposals
C
C The SA algorithm is restarted a minimum of minstart occasions, since the
C solution space is multimodal, and the best criterion found in the
C 1st minstart iterations is then read back from wrk2
C
C wrk2 is the stream for the scratch file where solutions from each 
C iteration are stored.
C
      rewind(wrk2)

      bestcrit=0
      minstart=5
      maxit=iter*nmark*nchoice
      nconverge=50*nmark*nchoice
      oldcrit=0
      pos1=1
      pos2=min(nmark,5)
      rate=0.02**(2.0/float(maxit))
C
C Loop to minimize recmin criterion
C Tries minstart restarts
C
      starts=0
    4 continue

      starts=starts+1
C zero out imputed haplotypes
      call delhap(currf,nmark,hset)
      call delhap(currm,nmark,hset)
      if (gp1) call delhap(gran1,nmark,hset)
      if (gp2) call delhap(gran2,nmark,hset)
      if (gp3) call delhap(gran3,nmark,hset)
      if (gp4) call delhap(gran4,nmark,hset)

      hicount=0
      hicrit=0
      temp=20.0

      it=0
    5 continue
        it=it+1
C
C Generate proposal: either 1,2,3 switches of origin,
C or impute one or two parental alleles based on a child
C
        typ=irandom(1,5)
        if (typ.lt.4) then
          id1=choice(irandom(1,nchoice))
          loc1=irandom(pos1,pos2)
          call shuffhap(id1,loc1,hset)
          if (typ.ge.2) then
            id2=choice(irandom(1,nchoice))
            loc2=irandom(pos1,pos2)
            call shuffhap(id2,loc2,hset)
            if (typ.eq.3) then
              id3=choice(irandom(1,nchoice))
              loc3=irandom(pos1,pos2)
              call shuffhap(id3,loc3,hset)
            end if
          end if
        else
C Pick an index person with included parents
   10     continue
            id1=choice(irandom(kids-2,nchoice))
          if ((id1.eq.currf .and. .not.gp1) .or. 
     &        (id1.eq.currm .and. .not.gp3)) goto 10
          loc1=irandom(pos1,pos2)
          whp1=irandom(1,2)
          whgp1=irandom(1,2)
          if (id1.eq.currf) then
            id2=gran1
            id3=gran2
          elseif (id1.eq.currm) then
            id2=gran3
            id3=gran4
          else
            id2=currf
            id3=currm
          end if
          if (whp1.eq.2) then
            tmp=id2
            id2=id3
            id3=tmp
          end if
          oall1=hset(id2,loc1,whgp1)
          if (oall1.lt.KNOWN) then
            hset(id2,loc1,whgp1)=-abs(hset(id1,loc1,whp1))
          end if
          if (typ.eq.5) then
            whp2=3-whp1
            whgp2=irandom(1,2)
            oall2=hset(id3,loc1,whgp2)
            if (oall2.lt.KNOWN) then
              hset(id3,loc1,whgp2)=-abs(hset(id1,loc1,whp2))
            end if
            if (whp1.eq.2) call shuffhap(id1,loc1,hset)
          end if 
        end if
C Calculate criterion
        newcrit=0
C grandparents v. parents
        if (gp1) then
          call scorerec(gran1,currf,1,nmark,hset,nrec,nerr,newcrit)
        end if
        if (gp2) then
          call scorerec(gran2,currf,2,nmark,hset,nrec,nerr,newcrit)
        end if
        if (gp3) then
          call scorerec(gran3,currm,1,nmark,hset,nrec,nerr,newcrit)
        end if
        if (gp4) then
          call scorerec(gran4,currm,2,nmark,hset,nrec,nerr,newcrit)
        end if
C parents v. children
        do 60 i=kids, nchoice
          call scorerec(currf,choice(i),1,nmark,hset,nrec,nerr,newcrit)
   60   continue
        do 70 i=kids, nchoice
          call scorerec(currm,choice(i),2,nmark,hset,nrec,nerr,newcrit)
   70   continue
C
C Test if (still) at a local or global minumum
C
        if (newcrit.gt.hicrit) then
          hicrit=newcrit
          hicount=1
        elseif (newcrit.eq.hicrit) then
          hicount=hicount+1
        end if
C
C Reverse proposal if worsens fit criterion, else accept new model
C
        if (metrop(newcrit,oldcrit,temp)) then
          oldcrit=newcrit
        else
          if (typ.lt.4) then
            call shuffhap(id1,loc1,hset)
            if (typ.ge.2) then
              call shuffhap(id2,loc2,hset)
              if (typ.eq.3) call shuffhap(id3,loc3,hset)
            end if
          else
            hset(id2,loc1,whgp1)=oall1
            if (typ.eq.5) then
              hset(id3,loc1,whgp2)=oall2
              if (whp1.eq.2) call shuffhap(id1,loc1,hset)
            end if
          end if
        end if

        if (mod(it,10*nchoice).eq.0) then
          pos2=pos2+1
          if (pos2.gt.nmark) then
            pos2=min(5,nmark)
            pos1=1
          else
            pos1=pos1+1
          end if
        end if

        temp=rate*temp
C
C End of while loop: stop if stuck or maximum iterations exceeded
C
      if (it.le.maxit .and. hicount.le.nconverge) goto 5

      if (oldcrit.gt.bestcrit) bestcrit=oldcrit
      write(wrk2) oldcrit, hset

      if (starts.le.minstart) goto 4

      write(*,'(a,i5,a/)') '(Recmin criterion=',bestcrit,')' 
C
C Retrieve best solution
C
      rewind(wrk2)
  100 continue
        read(wrk2) oldcrit, hset
      if (oldcrit.lt.bestcrit) goto 100

      return
      end
C end-of-recmin
C
C Metropolis crit allowing for overflow/underflow
C
      logical function metrop(new,old,temp)
      integer new, old
      double precision temp
      double precision ratio
C functions
      real random
      if (new.ge.old) then
        metrop=.true.
        return
      end if
      ratio=float(new-old)/temp
      if (ratio.gt.-8.0d0) then
        metrop=(random().lt.exp(ratio))
      else
        metrop=.false.
      end if
      return
      end
C end-of-metrop
C
C shuffle alleles between haplotype
C
      subroutine shuffhap(idx,target,hset)
      integer MAXLOC, MAXHAP, MAXSIZ, MISS
      parameter(MAXLOC=10000, MAXHAP=MAXLOC/2, MAXSIZ=20, MISS=-9999)

      integer idx, target
C Haplotypes
      integer hset(MAXSIZ,MAXHAP,2)
      integer tmp

      tmp=hset(idx,target,1)
      hset(idx,target,1)=hset(idx,target,2)
      hset(idx,target,2)=tmp
      return
      end
C end-of-shuffhap
C
C check if useful genotypes and add to list
C
      subroutine addhap(idx,nmark,hset,nchoice,choice,use)
      integer KNOWN, MAXLOC, MAXHAP, MAXSIZ, MISS
      parameter(KNOWN=0, MAXLOC=10000, MAXHAP=MAXLOC/2, 
     &          MAXSIZ=20, MISS=-9999)
      integer idx
C Haplotypes
      integer nmark, hset(MAXSIZ,MAXHAP,2)
      integer nchoice, choice(MAXSIZ)
      logical use

      call usehap(idx,nmark,hset,use)
      if (use) then
        nchoice=nchoice+1
        choice(nchoice)=idx
      end if
      return
      end
C end-of-addhap
C
C check if useful genotypes
C
      subroutine usehap(idx,nmark,hset,use)
      integer KNOWN, MAXLOC, MAXHAP, MAXSIZ
      parameter(KNOWN=0, MAXLOC=10000, MAXHAP=MAXLOC/2, MAXSIZ=20)
      integer idx
C Haplotypes
      integer nmark, hset(MAXSIZ,MAXHAP,2)
      logical use

      integer j

      use=.false.
      do 10 j=1,nmark
      if (hset(idx,j,1).gt.KNOWN) then
        use=.true.
        return
      end if
   10 continue

      return
      end
C end-of-usehap
C
C zero imputed haplotypes
C
      subroutine delhap(idx,nmark,hset)
      integer KNOWN, MAXLOC, MAXHAP, MAXSIZ, MISS
      parameter(KNOWN=0, MAXLOC=10000, MAXHAP=MAXLOC/2, 
     &          MAXSIZ=20, MISS=-9999)
      integer idx
C Haplotypes
      integer nmark, hset(MAXSIZ,MAXHAP,2)

      integer j

      do 10 j=1,nmark
      if (hset(idx,j,1).lt.KNOWN) then
        hset(idx,j,1)=MISS
        hset(idx,j,2)=MISS
      end if
   10 continue

      return
      end
C end-of-delhap
C
C score match of parental haplotypes to child haplotype: 
C  length of matched haplotype and number of recombinants
C
      subroutine scorerec(parent,child,orig,nmark,hset,nrec,nerr,match)
      integer KNOWN, MAXLOC, MAXHAP, MAXSIZ, MISS
      parameter(KNOWN=0, MAXLOC=10000, MAXHAP=MAXLOC/2, 
     &          MAXSIZ=20, MISS=-9999)

      integer  child, orig, nerr, nrec, parent, match 
C Haplotypes
      integer nmark, hset(MAXSIZ,MAXHAP,2)
      integer contrib, gpar, j, source
C functions
      integer gpsrc

      contrib=0
      nerr=0
      nrec=0
      source=0
      do 10 j=1,nmark
      if (hset(child,j,orig).ne.MISS) then
C
C score for number of known or imputed genotypes
C penalise imputed homozygous genotypes
C
        contrib=contrib+2
        if (hset(parent,j,1).ne.MISS) then
          contrib=contrib+1
          if (hset(parent,j,1).lt.KNOWN .and. 
     &        hset(parent,j,1).eq.hset(parent,j,2)) then
            contrib=contrib-1
          end if
        end if
        if (hset(parent,j,2).ne.MISS) then
          contrib=contrib+1
        end if
C
C Count recombinants and errors/mutations
C
        gpar=gpsrc(parent,child,orig,j,hset)
        if (gpar.eq.3) then
          nerr=nerr+1
        elseif (gpar.ne.0) then
          if (source.ne.0 .and. gpar.ne.source) nrec=nrec+1
          source=gpar
        end if
      end if
   10 continue
      match=match+contrib-3*nrec-10*nerr
      return
      end
C end-of-scorerec
C
C Count recombination and "mutation" events: write number as string 
C (same length as a genotype, so looks nice in output)
C
      subroutine recnum(child,currf,currm,nmark,hset,str)
      integer KNOWN, MAXLOC, MAXHAP, MAXSIZ, MISS
      parameter(KNOWN=0, MAXLOC=10000, MAXHAP=MAXLOC/2, 
     &          MAXSIZ=20, MISS=-9999)

      integer currf,currm,child
      character*7 str
      integer nmark, hset(MAXSIZ,MAXHAP,2)

      integer dum, materr, matrec, nerr, nrec, paterr, patrec
      character*1 ch

      dum=0
      call scorerec(currf,child,1,nmark,hset,patrec,paterr,dum)
      call scorerec(currm,child,2,nmark,hset,matrec,materr,dum)
      nerr=paterr+materr
      nrec=patrec+matrec
      if (nerr.gt.0) then
        ch='*'
      elseif (nrec.gt.0) then
        ch='+'
      else
        ch=' '
      end if
      write(str,'(a1,a1,i1,a1,i1,a1,a1)') ch,'[',nrec,';',nerr,']',ch

      return
      end
C end-of-recnum
C
C check for simple inconsistencies between child and parent
C
      subroutine check2(pedigree,eop,currf,currm,sta,fin,id,
     &                  nmark,mark,loc,hset)
      integer KNOWN, MAXLOC,MAXHAP,MAXSIZ,MISS
      parameter (KNOWN=0,MAXLOC=10000, MAXHAP=MAXLOC/2,
     &           MAXSIZ=20,MISS=-9999)

      integer currf, currm, eop, fin, sta
C Pedigree structure
      character*10 pedigree
      character*10 id(MAXSIZ) 
      integer hset(MAXSIZ,MAXHAP,2)
C
C Locus names and list of marker loci
      character*20 loc(MAXLOC)
      integer nmark, mark(MAXHAP)
C
C count of segregating alleles
      integer nall, allele(4)
C other local variables
      integer c1,c2,i,j,p11,p12,p21,p22
      logical anyerr, err, thiserr, xmale
      character*7 gtp
C functions
      integer eow, parcon
      logical opcon
C
      xmale=.false.

      anyerr=.false.
      do 10 j=1,nmark
        err=.false.
        p11=hset(currf,j,1)
        p12=hset(currf,j,2)
        call order(p11,p12)
        p21=hset(currm,j,1)
        p22=hset(currm,j,2)
        call order(p21,p22)
        nall=0
        ptyped=0
        if (p11.gt.KNOWN) then
          ptyped=ptyped+1
          call addall(p11,nall,allele)
          call addall(p12,nall,allele)
        end if
        if (p21.gt.KNOWN) then
          ptyped=ptyped+2
          call addall(p21,nall,allele)
          call addall(p22,nall,allele)
        end if
Cx      if (ptyped.ne.3) then
Cx        nset=0
Cx        call initp(p1,p2)
Cx      end if
C do each typed child in the sibship
        do 20 i=sta,fin
        if (hset(i,j,1).gt.KNOWN) then
          thiserr=.false.
          c1=hset(i,j,1)
          c2=hset(i,j,2)
          call order(c1,c2)
C test for simple parent-offspring inconsistency
          if ((ptyped.eq.3 .and.
     2         parcon(c1,c2,p11,p12,p21,p22,xmale).eq.0) .or.
     3        (ptyped.eq.1 .and. .not.opcon(c1,c2,p11,p12)) .or.
     4        (ptyped.eq.2 .and. .not.opcon(c1,c2,p21,p22))) then
            thiserr=.true.
C or too many alleles segregating in sibship
          else
            call addall(c1,nall,allele)
            call addall(c2,nall,allele)
            if (nall.gt.4) then
              thiserr=.true.
C else test for more complex errors
Cx          elseif (.not.err .and. ptyped.ne.3) then
Cx            call nucheck(c1,c2,xmale,nset,p1,p2,thiserr)
            end if
          end if
C If an error, note the responsible child
          if (thiserr) then
            err=.true.
            call wrgtp(c1,c2,gtp,1)
            write(*,'(9a)') 'NOTE:  Inconsistency due child ',
     2        pedigree(1:eop),'-',id(i)(1:eow(id(i))),
     3        ' at locus ',loc(mark(j)),' {',gtp,'}'
          end if
        end if
   20   continue
        if (err) anyerr=.true.
   10 continue

      if (anyerr) write(*,*)
      return
      end
C end-of-check2
C
C Write a trait value as a seven-character string
C
      subroutine wraff7(value,string)
      double precision value
      character*7 string
      if (value.eq.1.0d0) then
        string='  UnA  '
      elseif (value.eq.2.0d0) then
        string='  Aff  '
      else
        string='   ?   '
      end if
      return
      end
C end-of-wraff7
C
C Assess grandparental origin of allele
C
      integer function gpsrc(parent,child,orig,loc,hset)
      integer MAXLOC, MAXHAP, MAXSIZ, MISS
      parameter(MAXLOC=10000, MAXHAP=MAXLOC/2, MAXSIZ=20, MISS=-9999)

      integer  child, loc, orig, parent
C Haplotypes
      integer hset(MAXSIZ,MAXHAP,2)

      integer c1, p1, p2

      gpsrc=0
      c1=abs(hset(child,loc,orig))
      if (-c1.eq.MISS) return

      p1=abs(hset(parent,loc,1))
      p2=abs(hset(parent,loc,2))
      if (c1.eq.p1 .and. c1.ne.p2) then
        gpsrc=1
      elseif (c1.eq.p2 .and. c1.ne.p1) then
        gpsrc=2
      elseif (-p1.ne.MISS .and. c1.ne.p1 .and.
     &        -p2.ne.MISS .and. c1.ne.p2) then
        gpsrc=3
      end if
      return
      end
C end-of-gpsrc
C
C Search for best haplotypes based on simple sharing criterion.
C Called either as preliminary to recmin or in own right.
C Imputes missing parental haplotypes in simple-minded fashion.
C
      subroutine maxshare(currf,currm,gran1,gran2,gran3,gran4,
     &                    sta,fin,iter,nmark,hset)
      integer KNOWN, MAXHAP, MAXLOC, MAXSIZ, MISS
      parameter(KNOWN=0, MAXLOC=10000, MAXHAP=MAXLOC/2, MAXSIZ=20, 
     &          MISS=-9999)

      integer currf, currm, fin, gran1, gran2, gran3, gran4, iter, sta
      integer nmark, hset(MAXSIZ,MAXHAP,2)

      integer nchoice, choice(MAXSIZ)

      integer i, it, j, kids, maxit, newcrit, oldcrit
      integer id1, id2, loc1, loc2, type
      logical gp1, gp2, gp3, gp4, p1, p1imp, p2, p2imp, s1
      double precision rate, temp
C functions
      integer irandom
      logical metrop
C
C Only visit useful individuals
C
      nchoice=0
      if (gran1.ne.MISS) then
        call addhap(gran1,nmark,hset,nchoice,choice,gp1)
        call addhap(gran2,nmark,hset,nchoice,choice,gp2)
      else
        gp1=.false.
        gp2=.false.
      end if
      if (gran3.ne.MISS) then
        call addhap(gran3,nmark,hset,nchoice,choice,gp3)
        call addhap(gran4,nmark,hset,nchoice,choice,gp4)
      else
        gp3=.false.
        gp4=.false.
      end if
      
      call addhap(currf,nmark,hset,nchoice,choice,p1)
      call addhap(currm,nmark,hset,nchoice,choice,p2)

C
C Mark start of children's IDs in choice()
C
      kids=nchoice+1
      do 2 i=sta,fin
        call addhap(i,nmark,hset,nchoice,choice,s1)
    2 continue

      maxit=max(200,iter)*nmark*nchoice/4
      oldcrit=0
      rate=0.02**(2.0/float(maxit))
      temp=100.0

      do 5 it=1,maxit
C
C Generate proposal: either a single switch or double switch of origin
C
      type=irandom(1,2)
      id1=choice(irandom(1,nchoice))
      loc1=irandom(1,nmark)
      call shuffhap(id1,loc1,hset)
      if (type.eq.2) then
        id2=choice(irandom(1,nchoice))
        loc2=irandom(1,nmark)
        call shuffhap(id2,loc2,hset)
      end if
C Calculate criterion
      newcrit=0
C grandparents v. parents
      if (gp1) then
        call hmatch(gran1,currf,1,1,4,nmark,hset,newcrit)
        call hmatch(gran1,currf,2,1,4,nmark,hset,newcrit)
        if (.not.p1) then
          do 20 i=kids, nchoice
            call hmatch(currf,choice(i),1,1,10,nmark,hset,newcrit)
            call hmatch(currf,choice(i),2,1,10,nmark,hset,newcrit)
   20     continue
        end if
      end if
      if (gp2) then
        call hmatch(gran2,currf,1,2,4,nmark,hset,newcrit)
        call hmatch(gran2,currf,2,2,4,nmark,hset,newcrit)
        if (.not.p1) then
          do 30 i=kids, nchoice
            call hmatch(currf,choice(i),1,1,10,nmark,hset,newcrit)
            call hmatch(currf,choice(i),2,1,10,nmark,hset,newcrit)
   30     continue
        end if
      end if
      if (gp3) then
        call hmatch(gran3,currm,1,1,4,nmark,hset,newcrit)
        call hmatch(gran3,currm,2,1,4,nmark,hset,newcrit)
        if (.not.p2) then
          do 40 i=kids, nchoice
            call hmatch(currf,choice(i),1,2,10,nmark,hset,newcrit)
            call hmatch(currf,choice(i),2,2,10,nmark,hset,newcrit)
   40     continue
        end if
      end if
      if (gp4) then
        call hmatch(gran4,currm,1,2,4,nmark,hset,newcrit)
        call hmatch(gran4,currm,2,2,4,nmark,hset,newcrit)
        if (.not.p2) then
          do 50 i=kids, nchoice
            call hmatch(currf,choice(i),1,2,10,nmark,hset,newcrit)
            call hmatch(currf,choice(i),2,2,10,nmark,hset,newcrit)
   50     continue
        end if
      end if
C parents v. children
      if (p1) then
        do 60 i=kids, nchoice
          call hmatch(currf,choice(i),1,1,10,nmark,hset,newcrit)
          call hmatch(currf,choice(i),2,1,10,nmark,hset,newcrit)
   60   continue
      end if
      if (p2) then
        do 70 i=kids, nchoice
          call hmatch(currm,choice(i),1,2,10,nmark,hset,newcrit)
          call hmatch(currm,choice(i),2,2,10,nmark,hset,newcrit)
   70   continue
      end if
C children v. children
      do 80 i=kids, nchoice-1
      do 80 j=i+1, nchoice
        call hmatch(choice(i),choice(j),1,1,1,nmark,hset,newcrit)
        call hmatch(choice(i),choice(j),2,2,1,nmark,hset,newcrit)
   80 continue
C
C Reverse proposal if worsens fit criterion, else accept new model
C
      if (metrop(newcrit,oldcrit,temp)) then
        oldcrit=newcrit
      else
        call shuffhap(id1,loc1,hset)
        if (type.eq.2) call shuffhap(id2,loc2,hset)
      end if

      temp=rate*temp
C
    5 continue
C
C Impute missing parental genotypes where possible
C Note when there are preexisting imputed genotypes from other marriages
C
      p1imp=.false.
      p2imp=.false.
      do 100 j=1,nmark
        if (.not.p1imp .and. 
     2      (hset(currf,j,1).gt.MISS .and. hset(currf,j,1).lt.KNOWN).or.
     3      (hset(currf,j,2).gt.MISS .and. hset(currf,j,2).lt.KNOWN)) 
     4  then
          p1imp=.true.
        end if
        if (.not.p2imp .and. 
     2      (hset(currm,j,1).gt.MISS .and. hset(currm,j,1).lt.KNOWN).or.
     3      (hset(currm,j,2).gt.MISS .and. hset(currm,j,2).lt.KNOWN)) 
     4  then
          p2imp=.true.
        end if
C Impute paternal alleles based on these children
        if (hset(currf,j,1).eq.MISS .or. hset(currf,j,2).eq.MISS) then
          do 110 i=kids, nchoice
          if (hset(choice(i),j,1).ne.MISS) then
            if (hset(currf,j,1).eq.MISS) then
              hset(currf,j,1)=-hset(choice(i),j,1)
            elseif (hset(currf,j,2).eq.MISS .or. 
     &              hset(currf,j,1).eq.hset(currf,j,2)) then
              hset(currf,j,2)=-hset(choice(i),j,1)
            end if
          end if
  110     continue
        end if
C Impute maternal alleles based on these children
        if (hset(currm,j,1).eq.MISS .or. hset(currm,j,2).eq.MISS) then
          do 120 i=kids, nchoice
          if (hset(choice(i),j,2).ne.MISS) then
            if (hset(currm,j,1).eq.MISS) then
              hset(currm,j,1)=-hset(choice(i),j,2)
            elseif (hset(currm,j,2).eq.MISS .or. 
     &              hset(currm,j,1).eq.hset(currm,j,2)) then
              hset(currm,j,2)=-hset(choice(i),j,2)
            end if
          end if
  120     continue
        end if
  100 continue
C
      if (p1imp) then
        write(*,'(2a/)') 'NOTE:  Some paternal alleles were imputed ',
     &                   'via another marriage.'
      end if
      if (p2imp) then
        write(*,'(2a/)') 'NOTE:  Some maternal alleles were imputed ',
     &                   'via another marriage.'
      end if
C     
      return
      end
C end-of-maxshare
C
C score match of haplotype 1 to haplotype 2: length of match as well as
C absolute number of matches
C
      subroutine hmatch(id1,id2,orig1,orig2,mult,nmark,hset,match)
      integer MAXHAP, MAXLOC, MAXSIZ, MISS
      parameter(MAXLOC=10000, MAXHAP=MAXLOC/2, MAXSIZ=20, MISS=-9999)

      integer id1, id2, match, mult, orig1, orig2
C Haplotypes
      integer nmark, hset(MAXSIZ,MAXHAP,2)
      integer contrib, j, weight

      contrib=0
      weight=0
      do 10 j=1,nmark
      if (hset(id1,j,orig1).eq.hset(id2,j,orig2)) then
        weight=weight+1
        contrib=contrib+weight
      elseif (hset(id1,j,orig1).ne.MISS .and. 
     &        hset(id2,j,orig2).ne.MISS) then
        weight=weight/2
      end if
   10 continue
      match=match+mult*contrib
      return
      end
C end-of-hmatch
C
C Infer haplotypes of autosomal or X-linked loci deterministically (fully
C typed parents and offspring)
C
      subroutine hapimp(wrk, nord, locord, loc, locpos, loctyp,
     2             pedigree,actset,num,nfound,id,fa,mo,sex,locus,numloc,
     3             typed, recomb, set, hset, plevel)
      integer KNOWN, MAXHAP, MAXSIZ, MAXLOC, MISS
      parameter(KNOWN=0,MAXSIZ=20,MAXLOC=10000,
     &          MAXHAP=MAXLOC/2,MISS=-9999)
      integer plevel,wrk
C loci
      integer nord
      character*20 loc(MAXLOC)
      integer locord(MAXLOC), locpos(MAXLOC), loctyp(MAXLOC)
      
C pedigree structure
      character*10 pedigree
      integer sex(MAXSIZ)
      integer actset,num, nfound
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)
      integer numloc
C
C Storage space for haplotypes and whether yet phased; 
      integer hset(MAXSIZ,MAXHAP,2), set(MAXSIZ,2)
C Count of obligate recombinants
      integer recomb(MAXSIZ)
C
C Typed founders or nonfounders 
      integer typed(MAXSIZ)
C
      integer tr1,tr2,nt1,nt2
      logical last, xmale
      integer allx, fap, fas, gene, gen2, i, j, 
     &        mop, mos, ntyped, tothap  
      character*3 allel
C functions 
C
      integer eow

      allx=0
      do 5 j=1, nord
        recomb(j)=0
        i=loctyp(locord(j))
        if (allx.eq.0) then
          allx=i
        else if (allx.ne.i) then
          allx=10
        end if
    5 continue
      if (allx.eq.0) then
        write(*,'(/a)') 'ERROR: No marker loci.'
        return
      else if (allx.eq.10) then
        write(*,'(/a)') 'ERROR: Mixed autosomal and X-linked markers.'
        return
      end if

      ntyped=0
      tothap=0

      last=.false.
      rewind(wrk)
C
   10 continue
       call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &            numloc, last)
       if (last) goto 100

       if (actset.le.0) goto 10
C
C
C Identify typed founders or nonfounders who have untyped parents
C
         do 11 i=1,num
           typed(i)=0
           set(i,1)=MISS
           set(i,2)=MISS
           do 12 j=1,nord   
             hset(i,j,1)=MISS
             hset(i,j,2)=MISS
             gene=locpos(locord(j))
             if (locus(i,gene).gt.KNOWN) then
               typed(i)=typed(i)+1
             end if
   12      continue
           if (typed(i).eq.nord) then
             ntyped=ntyped+1
           end if
   11    continue
C
C Go through eligible offspring
C
         do 15 i=nfound+1,num
         if (typed(i).eq.nord) then
           if ((typed(fa(i)).eq.nord .and. typed(mo(i)).eq.nord)) 
     &     then
             tothap=tothap+2
             set(i,1)=1
             set(i,2)=1
             fap=set(fa(i),1)
             mop=set(mo(i),1)
             fas=0
             mos=0
             do 20 j=1, nord
               k=locord(j)
               gene=locpos(k)
               gen2=gene+1
               xmale=(allx.eq.2 .and. sex(i).eq.1)
               if (xmale) then
                 call xtrans(
     3               int(locus(mo(i),gene)), int(locus(mo(i),gen2)),
     4               int(locus(i,gene)), int(locus(i,gen2)),
     5               tr1,tr2,nt1,nt2)
               else
                 call trans(
     2               int(locus(fa(i),gene)), int(locus(fa(i),gen2)),
     3               int(locus(mo(i),gene)), int(locus(mo(i),gen2)),
     4               int(locus(i,gene)), int(locus(i,gen2)),
     5               tr1,tr2,nt1,nt2,0)
               end if
               hset(i,j,1)=tr1
               hset(i,j,2)=tr2
               if (fap.eq.MISS) then
                 hset(fa(i),j,1)=tr2
                 hset(fa(i),j,2)=nt2
               else if (hset(fa(i),j,1).eq.tr2 .and. tr2.ne.nt2) then
                 if (fas.eq.2) then
                   write(*,'(4a)') '# Obligate paternal recombinant ',
     2               loc(locord(j-1))(1:eow(loc(locord(j-1)))),'-',
     3               loc(locord(j))(1:eow(loc(locord(j))))
                   recomb(j)=recomb(j)+1
                 end if
                 fas=1
               else if (hset(fa(i),j,1).eq.nt2 .and. tr2.ne.nt2) then
                 if (fas.eq.1) then
                   write(*,'(4a)') '# Obligate paternal recombinant ',
     2               loc(locord(j-1))(1:eow(loc(locord(j-1)))),'-',
     3               loc(locord(j))(1:eow(loc(locord(j))))
                     recomb(j)=recomb(j)+1
                 end if
                 fas=2
               end if
               if (mop.eq.MISS) then
                 hset(mo(i),j,1)=tr1
                 hset(mo(i),j,2)=nt1
               else if (hset(mo(i),j,1).eq.tr1 .and. tr1.ne.nt1) then
                 if (mos.eq.2) then
                   write(*,'(4a)') '# Obligate maternal recombinant ',
     &               loc(locord(j-1)),'-',loc(locord(j))
                   recomb(j)=recomb(j)+1
                 end if
                 mos=1
               else if (hset(mo(i),j,1).eq.nt1 .and. tr1.ne.nt1) then
                 if (mos.eq.1) then
                   write(*,'(4a)') '# Obligate maternal recombinant ',
     2               loc(locord(j-1))(1:eow(loc(locord(j-1)))),'-',
     3               loc(locord(j))(1:eow(loc(locord(j))))
                   recomb(j)=recomb(j)+1
                 end if
                 mos=2
               end if
   20        continue
             if (fap.eq.MISS) then
               set(i,1)=1
               set(fa(i),1)=1
               set(fa(i),2)=2
             end if
             if (mop.eq.MISS) then
               set(i,2)=1
               set(mo(i),1)=1
               set(mo(i),2)=2
             end if
           end if
         end if
   15    continue
         do 50 i=1, num
         if (set(i,1).ne.MISS) then
           write(*,'(a,1x,a,$)') pedigree, id(i)
           do 60 j=1, nord
             call wrall(hset(i,j,1),allel)
             write(*,'(1x,a3,$)') allel
   60      continue
           if (set(i,2).ne.MISS) then
             write(*,'(/a,1x,a,$)') pedigree, id(i)
             do 70 j=1, nord
               call wrall(hset(i,j,2),allel)
               write(*,'(1x,a3,$)') allel
   70        continue
           end if
           write(*,*)
         end if
   50    continue
       goto 10
  100 continue
      write(*,*)
      write(*,*) '# Total genotyped =', ntyped
      write(*,*) '# Total haplotypes=', tothap
      write(*,*) '# Obligate recombinants by interval:'
      write(*,*) '# ', (j,j=1,nord)
      write(*,*) '# ', (recomb(j),j=2,nord)
      return
      end
C end-of-hapimp
C
C perform Haseman-Elston sib-pair regression: univariate
C using squared difference or centred cross-product 
C and ibds estimated from the entire sibship
C if missing parental genotypes 
C
C typ  
C  1   Original Haseman-Elston
C  2   Haseman-Elston II
C  3   Sham and Purcell
C  4   Visscher and Hopper
C
      subroutine sibpair(wrk,wrk2,tranam,trait,locnam,gene,typ,
     2              sibm,sibr,sibv,mche,iter,mincnt,weight,pedigree,
     3              actset,num,nfound,id,fa,mo,sex,locus,numloc,
     4              numal,name,alfrq,cumfrq,ibd,untyped,set,plevel)
C
      integer IBDSIZ, KNOWN, MAXALL, MAXIBD, MAXSIZ, MAXLOC, MISS
      parameter(MAXIBD=20, IBDSIZ=MAXIBD*(MAXIBD+1)/2, KNOWN=0,
     &          MAXALL=2, MAXSIZ=20, MAXLOC=10000, MISS=-9999)
      integer gene,iter,mincnt,plevel,trait,typ,weight,wrk,wrk2
      double precision sibm, sibr, sibv
      logical mche
      character*10 locnam,tranam
C  Pedigree structure
      character*10 pedigree
      integer actset,num, nfound
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ)
      integer sex(MAXSIZ)
      integer numloc
      double precision locus(MAXSIZ,MAXLOC)
C allele frequencies structure
      integer numal, name(MAXALL)
      double precision alfrq(MAXALL)
      double precision cumfrq(MAXALL)
C sibship ibd array 
      double precision ibd(IBDSIZ)
C work arrays for MC iteration
      integer set(MAXSIZ,2)
      logical untyped(MAXSIZ)
C local variables
      integer contrib,df,famdf,fsdf, gen2,hsibs,i,it,j,k,ped,pos,sibs
      integer commp, currf, currm, fin, nfam, nped, sta, tailp
      logical last, mhs, phs
      character*3 histo
      double precision ibd_hs
C regression results
      integer afail, bfail, vfail
      double precision x(4),r(10),b(3),cov(10)
      double precision asyp,beta,denf1,denf2,denh1,denh2,kf,kh,
     2   mub,mux,muy,muy2,oalpha,obeta,pval,rf,rh,rf0,rh0,sdb,sea,seb,
     3   tvalb,vay,wt,y1,y2,ycf,ych
C Score test of Szatkiewicz et al
      double precision aconst, aden, anum, ascore, aterm
C required by Visscher & Hopper double regression
      double precision rs(10), vd, vs, wt_vh, ys
C required by Szatkiewicz and Feingold Robust Discordant Pairs Test
      double precision pivar, rdp, rdpnum, rdpden
C functions
      integer getnam
      double precision hibd, probst, regwt, zp
C
      gen2=gene+1

      if (plevel.gt.0) then
        write(*,'(/a/5a/a/)') 
     2    '-----------------------------------------------',
     3    ' H-E analysis for "',tranam,'" v. "',locnam,'"',
     4    '-----------------------------------------------'
      end if
C
C Obtain trait mean, sib and half-sib trait correlations
C Note that sibcor zeroes the correlations 
C
      if (sibr.ne.MISS) then
        call sibcor(WRK,trait,1,pedigree,actset,num,nfound,
     &          id,fa,mo,sex,locus,numloc,muy,vay,rf,rh,plevel)
        rf=sibr
        rh=0.5d0*rf
        if (sibm.ne.MISS) muy=sibm
        if (sibv.ne.MISS) vay=sibv
      else
        call sibcor(WRK,trait,typ,pedigree,actset,num,nfound,
     &          id,fa,mo,sex,locus,numloc,muy,vay,rf,rh,plevel)
      end if
      muy2=muy+muy
      rf0=max(0.0d0,rf)
      rh0=max(0.0d0,rh)
      denf1=1.0d0/(1.0d0+rf0)**2
      denf2=1.0d0/(1.0d0-rf0)**2
      denh1=1.0d0/(1.0d0+rh0)**2
      denh2=1.0d0/(1.0d0-rh0)**2
      ycf=4.0d0*rf0/(1.0d0-rf0*rf0)
      ych=4.0d0*rh0/(1.0d0-rh0*rh0)
      kf=4.0d0*(1.0d0+rf0*rf0)/(1.0d0-rf0*rf0)**2
      kh=4.0d0*(1.0d0+rh0*rh0)/(1.0d0-rh0*rh0)**2
C RDP test
      rdp=0.0d0
      rdpnum=0.0d0
      rdpden=0.0d0
      pivar=0.0d0
C Score test
      ascore=0.0d0
      anum=0.0d0
      aden=0.0d0
      aconst=4.0d0*rf0*denf2
C
C move through sib pairs
C
      df=0
      fsdf=0
      hsibs=0
      nfam=0
      nped=0
      sibs=0
      mux=0.0d0
      call inicov(4, 10, r)
      call inicov(4, 10, rs)
      last=.false.
      rewind(wrk)
   50 continue
        call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &             numloc, last)
        if (last) goto 200

        if (actset.le.0) goto 50
C
C
C record if typed in untyped() and write file for MC routine
C
        nped=nped+1
        do 70 i=1,num
        if (locus(i,gene).gt.KNOWN) then
          untyped(i)=.false.
          set(i,1)=getnam(locus(i,gene),numal,name)
          set(i,2)=getnam(locus(i,gen2),numal,name)
        else  
          untyped(i)=.true.
          set(i,1)=MISS
          set(i,2)=MISS
        end if
   70   continue
        write(wrk2) num,nfound,(fa(i),mo(i),untyped(i),i=1,num)
C
C Full sibs
C
        famdf=0
        fin=num
        currf=fa(fin)
        currm=mo(fin)
        do 90 k=num-1,nfound,-1
          if (fa(k).ne.currf .or. mo(k).ne.currm) then
            nfam=nfam+1
            contrib=0
            do 92 i=k+1,fin
            if (locus(i,trait).ne.MISS .and. .not.untyped(i)) then
              contrib=contrib+1
            end if
   92       continue
C
C Skip if no usable individuals in this sibship
C
            if (contrib.gt.0) then

            df=df+contrib-1
            fsdf=fsdf+contrib-1
            famdf=famdf+contrib-1
            write(wrk2) currf, currm, k+1, fin, contrib*(contrib-1)/2
            call nucibd(gene,currf,currm,k+1,fin,set,untyped,ibd,
     &                  numal, name, alfrq)
            pos=0
            do 95 i=k+1,fin
              y1=locus(i,trait)
              do 97 j=k+1,i-1
                y2=locus(j,trait)
                pos=pos+1
                if (y1.ne.MISS .and. y2.ne.MISS .and.
     3              .not.untyped(i) .and. .not.untyped(j)) 
     4          then
                  sibs=sibs+1
                  wt=regwt(weight,i,j,locus)
                  x(1)=1.0d0
                  x(2)=0.0d0
                  aterm=(denf1*(y1+y2-muy2)**2 - denf2*(y1-y2)**2)/vay
                  if (typ.eq.3) then
                    x(3)=kf*(ibd(pos)-0.5d0)
                    x(4)=ycf+aterm
                  elseif (typ.eq.2) then
                    x(3)=ibd(pos)
                    x(4)=(y1-muy)*(y2-muy)
                  else
                    x(3)=ibd(pos)
                    x(4)=(y1-y2)**2
                  end if
                  anum=anum+aterm*(ibd(pos)-0.5d0)
                  aden=aden+aterm*aterm
                  rdpnum=rdpnum+(y1-y2)**2 * (0.5d0-ibd(pos))
                  rdpden=rdpden+(y1-y2)**4 
                  pivar=pivar + ibd(pos)*(1.0d0-ibd(pos))
                  mux=mux+ibd(pos)
                  write(wrk2) pos,wt,x(4)
                  if (plevel.gt.1) then
                    write(*,*) pedigree, id(i), id(j), y1, y2, ibd(pos)
                  end if
                  call givenc(r, 10, 4, x, wt, afail)
                  if (typ.eq.4) then
                    x(1)=1.0d0
                    x(2)=0.0d0
                    x(3)=ibd(pos)
                    x(4)=(y1+y2-muy2)**2
                    write(wrk2) pos,wt,x(4)
                    call givenc(rs, 10, 4, x, wt, afail)
                  end if
                end if
   97         continue
C and now skip the self-correlation (that VC approach does use)
              pos=pos+1
   95       continue
C
C half-sibs related to current sibship -- only scan sibships not yet visited
C stored in different style to full sibs
C
            do 300 i=nfound+1,k
              phs=(fa(i).eq.currf)
              mhs=(mo(i).eq.currm)
              if ((phs .or. mhs) .and. 
     &            locus(i,trait).ne.MISS .and. .not.untyped(i)) then
                write(wrk2) contrib 
                df=df+1
                y1=locus(i,trait)
                do 302 j=k+1,fin
                if (locus(j,trait).ne.MISS .and. .not.untyped(j)) then
                  y2=locus(j,trait)
                  hsibs=hsibs+1
                  wt=regwt(weight,i,j,locus)
                  x(1)=1.0d0
                  x(2)=1.0d0
                  if (typ.eq.3) then
                    x(4)=ych+(denh1*(y1+y2-muy2)**2 -
     &                   denh2*(y1-y2)**2)/vay
                  elseif (typ.eq.2) then
                    x(4)=(y1-muy)*(y2-muy)
                  else
                    x(4)=(y1-y2)**2
                  end if
                  if (phs) then
                    x(3)=hibd(dfloat(set(i,1)),dfloat(set(i,2)),
     2                        dfloat(set(j,1)),dfloat(set(j,2)),
     3                        dfloat(set(mo(i),1)),dfloat(set(mo(i),2)),
     4                        dfloat(set(fa(i),1)),dfloat(set(fa(i),2)),
     5                        dfloat(set(mo(j),1)),dfloat(set(mo(j),2)))
                    write(wrk2) i,j,mo(i),fa(i),mo(j),wt,x(4)
                    if (typ.eq.4) then
                      ibd_hs=x(3)
                      ys=(y1+y2-muy2)**2
                      write(wrk2) i,j,mo(i),fa(i),mo(j),wt,ys
                    end if
                  else
                    x(3)=hibd(dfloat(set(i,1)),dfloat(set(i,2)),
     2                        dfloat(set(j,1)),dfloat(set(j,2)),
     3                        dfloat(set(fa(i),1)),dfloat(set(fa(i),2)),
     4                        dfloat(set(mo(i),1)),dfloat(set(mo(i),2)),
     5                        dfloat(set(fa(j),1)),dfloat(set(fa(j),2)))
                    write(wrk2) i,j,fa(i),mo(i),fa(j),wt,x(4)
                    if (typ.eq.4) then
                      ibd_hs=x(3)
                      ys=(y1+y2-muy2)**2
                      write(wrk2) i,j,fa(i),mo(i),fa(j),wt,ys
                    end if
                  end if
                  if (plevel.gt.1) then
                    write(*,*) pedigree, id(i), id(j), y1, y2, x(3)
                  end if
                  if (typ.eq.3) x(3)=kh*(x(3)-0.25d0)
                  call givenc(r, 10, 4, x, wt, afail)
                  if (typ.eq.4) then
                    x(1)=1.0d0
                    x(2)=1.0d0
                    x(3)=ibd_hs
                    x(4)=ys
                    call givenc(rs, 10, 4, x, wt, afail)
                  end if
                end if
  302           continue
              end if
  300       continue
C mark last halfsib pair
            write(wrk2) 0

            end if
C Now update to next sibship
            fin=k
            currf=fa(fin)
            currm=mo(fin)
          end if
   90   continue
C mark end of sibships in current pedigree
        write(wrk2) MISS, MISS, MISS, MISS, MISS
      goto 50
  200 continue
C
C fitting intercept=0
C
      if (typ.eq.3) then
        x(1)=1.0d0
        x(2)=0.0d0
        x(3)=0.0d0
        x(4)=0.0d0
        call givenc(r, 10, 4, x, 0.0d0, afail)
      end if
C
      if (df.gt.0) then
        mux=mux/dfloat(sibs)
        call alias(r, 10, 4, 1.0d-15, x, afail)
        call bsub(r, 10, 4, b, 3, bfail)
        call var(r, 10, cov, 10, 4, sibs+hsibs, 1, vfail)
        oalpha=b(1)
        sea=sqrt(cov(1))
        obeta=b(3)
        seb=sqrt(cov(6))
        if (typ.eq.4) then
          vd=1.0d0/cov(6)
          call alias(rs, 10, 4, 1.0d-15, x, afail)
          call bsub(rs, 10, 4, b, 3, bfail)
          call var(rs, 10, cov, 10, 4, sibs+hsibs, 1, vfail)
          vs=1.0d0/cov(6)
          wt_vh=vd/(vd+vs)
          obeta=0.5d0*((1.0d0-wt_vh)*b(3)-wt_vh*obeta)
          seb=0.5d0*sqrt(wt_vh)*seb
        end if
        tvalb=obeta/seb
        if (afail.gt.0 .or. bfail.gt.0 .or. vfail.gt.0) then
          write(*,'(/a,3(/7x,a,i3))') 
     2      'ERROR: Problem in regression (AS164) subroutines.',
     3             'Aliasing Ifail=',afail,
     4             'Backsub  Ifail=',bfail,
     5             'Variance Ifail=',vfail 
        end if
        df=df-2
        if (typ.eq.3) df=df+1
        if (typ.gt.1) then
          asyp=1.0d0-probst(tvalb,df,afail)
        else
          asyp=probst(tvalb,df,afail)
        end if
        if (fsdf.gt.0) then
          ascore=anum/sqrt(aden*(0.25d0-pivar/dfloat(sibs)))
          rdp=rdpnum/sqrt(rdpden*(0.25d0-pivar/dfloat(sibs)))
        end if
      else
        mux=0.0d0
        oalpha=0.0d0
        sea=0.0d0
        obeta=0.0d0
        seb=0.0d0
        tvalb=0.0d0
        df=0
        asyp=1.0d0
      end if
C
C MC P-value estimation
C
      it=0
      tailp=0
      mub=0.0d0
      sdb=0.0d0
      if (.not.mche .or. iter.eq.0 .or. df.lt.1) then
        pval=1.0d0
      else
C
C Now can simulate genotypes and do sequential P-value simulation
C
  299   continue
        if (it.eq.iter .or. tailp.eq. mincnt) goto 400
          it=it+1
          call inicov(4, 10, r)
          call inicov(4, 10, rs)
          rewind(wrk2)
          do 330 ped=1,nped
            read(wrk2) num,nfound,(fa(i),mo(i),untyped(i),i=1,num)
            call simped(num,nfound,fa,mo,cumfrq,set)
            do 335 i=1,num
            if (untyped(i)) then
              set(i,1)=MISS
              set(i,2)=MISS
            end if
  335       continue
C     
C read list of sibships -- last one is labelled as missing parents
C     
  500       continue
              read(wrk2) currf, currm, sta, fin, npairs
        
            if (currf.eq.MISS) goto 501
        
              call nucibd(gene,currf,currm,sta,fin,set,untyped,ibd,
     &                    numal, name, alfrq)
              do 310 k=1,npairs
                read(wrk2) pos,wt,x(4)
                x(1)=1.0d0
                x(2)=0.0d0
                if (typ.eq.3) then
                  x(3)=kf*(ibd(pos)-0.5d0)
                else
                  x(3)=ibd(pos)
                end if
                call givenc(r, 10, 4, x, wt, afail)
                if (typ.eq.4) then
                  read(wrk2) pos,wt,x(4)
                  x(1)=1.0d0
                  x(2)=0.0d0
                  x(3)=ibd(pos)
                  call givenc(rs, 10, 4, x, wt, afail)
                end if
  310         continue
C     
C list of half-sib pairs follows each sibship
C     
  503         continue
                read(wrk2) npairs
              if (npairs.le.0) goto 504
                do 311 k=1,npairs
                  read(wrk2) i,j,currf,commp,currm,wt,x(4)
                  x(1)=1.0d0
                  x(2)=1.0d0
                  x(3)=hibd(dfloat(set(i,1)),dfloat(set(i,2)),
     2                      dfloat(set(j,1)),dfloat(set(j,2)),
     3                      dfloat(set(currf,1)),dfloat(set(currf,2)),
     4                      dfloat(set(commp,1)),dfloat(set(commp,2)),
     5                      dfloat(set(currm,1)),dfloat(set(currm,2)))
                  if (typ.eq.3) x(3)=kh*(x(3)-0.25d0)
                  call givenc(r, 10, 4, x, wt, afail)
                  if (typ.eq.4) then
                    read(wrk2) i,j,currf,commp,currm,wt,x(4)
                    x(1)=1.0d0
                    x(2)=1.0d0
                    x(3)=hibd(dfloat(set(i,1)),dfloat(set(i,2)),
     2                      dfloat(set(j,1)),dfloat(set(j,2)),
     3                      dfloat(set(currf,1)),dfloat(set(currf,2)),
     4                      dfloat(set(commp,1)),dfloat(set(commp,2)),
     5                      dfloat(set(currm,1)),dfloat(set(currm,2)))
                    call givenc(rs, 10, 4, x, wt, afail)
                  end if
  311           continue
              goto 503
  504         continue
                
            goto 500
  501       continue
        
  330     continue
          if (typ.eq.3) then
            x(1)=1.0d0
            x(2)=0.0d0
            x(3)=0.0d0
            x(4)=0.0d0
            call givenc(r, 10, 4, x, 0.0d0, afail)
          end if
          call alias(r, 10, 4, 1.0d-15, x, afail)
          call bsub(r, 10, 4, b, 3, bfail)
          beta=b(3)
          if (typ.eq.4) then
            call alias(rs, 10, 4, 1.0d-15, x, afail)
            call bsub(rs, 10, 4, b, 3, bfail)
            beta=0.5d0*((1.0d0-wt_vh)*b(3)-wt_vh*beta)
          end if
          call moment(it,beta,mub,sdb)
          if ((typ.eq.1 .and. beta.lt.obeta) .or. 
     2        (typ.gt.1 .and. beta.gt.obeta) .or. 
     3        (beta.eq.obeta .and. random().gt.0.5d0))  then
            tailp=tailp+1
          end if
          if (plevel.gt.1) then
            write(*,'(a,i4,a,f12.4,a,2i3)') 
     &        'Pseudosample ',it,': Beta=', beta, ' Ifail=',afail, bfail
          end if
        
          goto 299
  400   continue
        if (tailp.lt.mincnt) then
          tailp=tailp+1
          it=it+1
        end if
        sdb=sqrt(sdb/dfloat(max(1,it-1)))
        pval=dfloat(tailp)/dfloat(it)
      end if
      if (plevel.gt.0) then
        write(*,'(/a,i5,a,i5,a/a,i5/a,f5.3)') 
     2    'No. full-sib pairs = ',sibs, ' (in ',nfam,' sibships)',
     2    'No. half-sib pairs = ',hsibs, 'Mean full-sib ibd = ',mux
        write(*,'(a,f10.4,a,f10.4,a/a,f10.4,a,f10.4,a)')
     2    'Intercept (f-s)    = ',oalpha,' (ase=',sea,')',
     3    'Slope              = ',obeta, ' (ase=',seb,')'
        write(*,'(a,f10.4,a,i4,a,f6.4,a)')
     2    't value            = ',tvalb,' (df=',df,
     3    ', P=', asyp ,')' 
        write(*,'(/a,i4,a,i5,a,f6.4,a/a,f12.4,a,f12.4,a)')
     2    'Equalled or exceeded by =',tailp,'/',it,
     3    ' simulated values (',pval,')',
     4    'Mean (SD) simulated Beta=',mub,' (',sdb,')'
C Score and RDP test
        write(*,'(/a,f10.4,a,f6.4,a)')
     2    'Score test (f-s)   = ',ascore,' (P=', zp(ascore) ,')' 
        write(*,'(a,f10.4,a,f6.4,a)')
     2    'Robust Disc Pair t = ',rdp,' (P=', zp(rdp),')' 
      else
        call phist(asyp,pval,histo)
        write(*,'(a10,2(1x,i6),1x,f10.1,2(1x,f6.4),1x,i6,2(1x,a))')
     &    locnam, sibs, hsibs, tvalb, asyp, pval, it, 'H-E',histo
      end if
      return
      end
C end-of-sibpair
C
C Estimate sibling and half-sib intraclass correlations
C
      subroutine sibcor(wrk,trait,typ,pedigree,actset,num,nfound,
     3              id,fa,mo,sex,locus,numloc,muy,vay,rf,rh,plevel)
C
      integer KNOWN, MAXSIZ, MAXLOC, MISS
      parameter(KNOWN=0, MAXSIZ=20, MAXLOC=10000, MISS=-9999)
      integer plevel,trait,typ,wrk
      double precision muy, rf, rh, vay
C  Pedigree structure
      character*10 pedigree
      integer actset,num, nfound
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ)
      integer sex(MAXSIZ)
      integer numloc
      double precision locus(MAXSIZ,MAXLOC)
C local variables
      integer hsibs,i,j,k,sibs
      integer currf, currm, fin
      double precision y1, y2
      logical last, mhs, phs
C
C Mean and variance of trait in nonfounders
C
      n=0
      hsibs=0
      sibs=0
      muy=0.0d0
      vay=0.0d0
      rf=0.0d0
      rh=0.0d0
      last=.false.
      rewind(wrk)
    1 continue
        call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &             numloc, last)
       if (last) goto 2

        if (actset.le.0) goto 1
C
        do 3 i=nfound+1,num
        if (locus(i,trait).ne.MISS) then
          n=n+1
          call moment(n,locus(i,trait),muy,vay)
        end if
    3   continue
      goto 1
    2 continue
      vay=vay/dble(max(1,n-1))
C
      if (typ.gt.1) then

      last=.false.
      rewind(wrk)
    5 continue
        call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &             numloc, last)
        if (last) goto 50

        if (actset.le.0) goto 5
C
        fin=num
        currf=fa(fin)
        currm=mo(fin)
        do 10 k=num-1,nfound,-1
          if (fa(k).ne.currf .or. mo(k).ne.currm) then
            do 12 i=k+1,fin-1
            if (locus(i,trait).ne.MISS) then
              y1=locus(i,trait)
              do 13 j=i+1,fin
              if (locus(j,trait).ne.MISS) then
                sibs=sibs+1
                y2=locus(j,trait)
                rf=rf+(y1-muy)*(y2-muy)
              end if
   13         continue
            end if
   12       continue
C
C half-sibs related to current sibship
C
            do 30 i=nfound+1,k
              phs=(fa(i).eq.currf)
              mhs=(mo(i).eq.currm)
              if ((phs .or. mhs) .and. 
     &            locus(i,trait).ne.MISS) then
                y1=locus(i,trait)
                do 31 j=k+1,fin
                if (locus(j,trait).ne.MISS) then
                  hsibs=hsibs+1
                  y2=locus(j,trait)
                  rh=rh+(y1-muy)*(y2-muy)
                end if
   31           continue
              end if
   30       continue
C Now update to next sibship
            fin=k
            currf=fa(fin)
            currm=mo(fin)
          end if
   10   continue
C mark end of sibships in current pedigree
      goto 5
   50 continue

      rf=rf/dfloat(max(1,sibs-1))/vay
      rh=rh/dfloat(max(1,hsibs-1))/vay

      end if

      if (plevel.gt.0) then
        write(*,'(a,f10.4,a,f10.4,a)') 
     &    'Trait mean (nonfo) = ',muy,' (SD=',sqrt(vay),')'
        if (typ.gt.1) then
          write(*,'(a,f5.3,a,i5,a/a,f5.3,a,i5,a)') 
     2      'Sibling r          = ',rf,' (',sibs,' pairs)',
     3      'Half-sib r         = ',rh,' (',hsibs,' pairs)'
          if (rh.le.0.0d0) then
            write(*,'(a,f5.3)') 'Working half-sib r = ',0.5d0*rf
          end if
        end if
      end if
      if (rh.le.0.0d0) rh=0.5d0*rf
      return
      end
C end-of-sibcor
C
C Routines to calculate ibd sharing using full sibship information
C where parent(s) untyped.
C
C ibd(1..nsib*(nsib+1)/2)
C prall(5) probs for 1..4 observed alleles plus all others
C
C 1. enumerate alleles segregating among children
C 2. generate short list of genotypes for parents
C 3. sum up ibd sharing for each pair of sibs for each genotype freq
C 
      subroutine nucibd(gene,cfa,cmo,sta,fin,set,untyped,ibd,
     &                  numal, name, alfrq)
      integer IBDSIZ, KNOWN, MAXALL, MAXIBD, MAXSIZ, MAXLOC, MISS
      parameter(MAXIBD=20, IBDSIZ=MAXIBD*(MAXIBD+1)/2, KNOWN=0,
     &          MAXALL=2, MAXSIZ=20, MAXLOC=10000, MISS=-9999)
      integer gene
C Pedigree structure
      integer cfa, cmo, fin, sta, set(MAXSIZ,2)  
      logical untyped(MAXSIZ)
C allele frequencies structure
      integer numal, name(MAXALL)
      double precision alfrq(MAXALL)
C
      double precision ibd(IBDSIZ)
C
C count of segregating alleles, and frequency
      integer nall, allele(5)
      double precision prall(5)
C other local variables
      integer g1,g2,g3,g4
      integer gen2,i,j,nind,npairs,mg1,mg2,pg1,pg2,pos
      integer i1,i2,t1,t2
      logical xmale
      double precision lik, totp
C functions
      integer parcon, whall
      double precision shibd

      xmale=.false.

      gen2=gene+1
      pos=0

      ptyped=0
      if (.not.untyped(cfa)) then
        ptyped=ptyped+1
        pg1=set(cfa,1)
        pg2=set(cfa,2)
      end if
      if (.not.untyped(cmo)) then
        ptyped=ptyped+2
        mg1=set(cmo,1)
        mg2=set(cmo,2)
      end if

      if (ptyped.eq.3) then
        do 120 i=sta, fin
          do 121 j=sta, i-1
            pos=pos+1
            ibd(pos)=shibd(set(i,1),set(i,2),set(j,1),set(j,2),
     &                     pg1, pg2, mg1, mg2)
  121     continue
          pos=pos+1
          ibd(pos)=1.0d0
  120   continue
        return
      end if
C
C else sum over all possible parental genotypes
C
      nall=0
      if (ptyped.eq.1) then
        call addall(pg1,nall,allele)
        call addall(pg2,nall,allele)
      elseif (ptyped.eq.2) then
        call addall(mg1,nall,allele)
        call addall(mg2,nall,allele)
      end if
      do 1 i=sta, fin
      if (.not.untyped(i)) then
        call addall(set(i,1),nall,allele)
        call addall(set(i,2),nall,allele)
      end if
    1 continue

      nind=fin-sta+1
      npairs=nind*(nind+1)/2
C first check
      if (nall.gt.4) then
        write(*,'(a)') 'ERROR:  Mendelian inconsistency detected.'
        call filltri(nind,npairs,ibd,1.0d0,0.5d0)
        return
      end if
C else continue
      call filltri(nind,npairs,ibd,1.0d0,0.0d0)
      nall=nall+1
      allele(nall)=0 
      prall(nall)=1.0d0
      do 2 i=1,nall-1
        prall(i)=alfrq(allele(i))
        prall(nall)=prall(nall)-prall(i)
    2 continue
C
C While loop to list all possible genotypes
C initialize genotype indices
C
      if (ptyped.eq.1) then
        t1=1
        i1=1
        g1=whall(pg1,nall,allele)
        g2=whall(pg2,nall,allele)
      else
        t1=nall*(nall+1)/2
        i1=0
        g1=1
        g2=0
      end if
      if (ptyped.eq.2) then
        t2=1
        i2=1
        g3=whall(mg1,nall,allele)
        g4=whall(mg2,nall,allele)
      else
        t2=nall*(nall+1)/2
        i2=t2
        g3=1
        g4=0
      end if
C
C simulated nested do-loops
C check if inner loop completed once
C
      totp=0.0d0

  100 continue
        if (i2.eq.t2) then
          call couple(i1,t1,nall,g1,g2)
          pg1=allele(g1)
          pg2=allele(g2)
          if (t2.gt.1) i2=0
        end if
        call couple(i2,t2,nall,g3,g4)
        mg1=allele(g3)
        mg2=allele(g4)
        do 10 i=sta,fin
        if (.not.untyped(i) .and. 
     &      parcon(set(i,1),set(i,2),pg1,pg2,mg1,mg2,xmale).eq.0) then
          goto 55
        end if
   10   continue
C
C else (if consistent) calculate likelihood
C
C L = Pr(G) = Pr(Children & Parents) = Pr(P) Pr(C|P) 
C   = Prod{ Pr(P_j) } Prod { Pr(C_i | Father_i Mother_i }
C
        lik=prall(g1)*prall(g2)*prall(g3)*prall(g4)
        if (g1.ne.g2) lik=lik+lik
        if (g3.ne.g4) lik=lik+lik
        do 15 i=sta,fin
        if (.not.untyped(i)) then
          lik=lik*0.25d0*
     &        dfloat(parcon(set(i,1),set(i,2),pg1,pg2,mg1,mg2,xmale))
        end if
   15   continue

        totp=totp+lik
C
        pos=0
        do 20 i=sta, fin
          do 21 j=sta, i-1
            pos=pos+1
            ibd(pos)=ibd(pos)+
     2               lik*shibd(set(i,1),set(i,2),set(j,1),set(j,2),
     3                         pg1,pg2,mg1,mg2)
   21     continue
          pos=pos+1
   20   continue
   55   continue
C end of while loop
      if (i1.ne.t1 .or. i2.ne.t2) goto 100
C abort if error else rescale likelihood
      if (totp.eq.0.0d0) then
        write(*,'(a)') 'ERROR:  Mendelian inconsistency detected.'
        call filltri(nind,npairs,ibd,1.0d0,0.5d0)
      else
        totp=1.0d0/totp
        pos=0
        do 33 i=1,nind
          do 34 j=1,i-1
            pos=pos+1
            ibd(pos)=min(1.0d0,totp*ibd(pos))
   34     continue
          pos=pos+1
   33   continue
      end if
      return
      end
C end-of-nucibd
C
C Enumerate all combinations of i ~ I(1..range) with itself
C If index=tot then return last tuple
C
      subroutine couple(idx,tot,range,i1,i2)
      integer idx,i1,i2,range,tot

      if (idx.eq.tot) return

      idx=idx+1
      i2=i2+1
      if (i2.gt.range) then
        i1=i1+1
        if (i1.gt.range) i1=1
        i2=i1
      end if
      return
      end
C end-of-couple
C
C Find index of allele segregating in nuclear family
C
      integer function whall(iall,nall,allele)
      integer iall, nall, allele(5)
      integer i
      do 10 i=1,nall-1
      if (iall.eq.allele(i)) then
        whall=i
        return
      end if
   10 continue
      whall=nall
      return
      end
C end-of-whall
C
C Calculate ibd sharing for full sibs when parental genotypes known
C
      double precision function shibd(c11,c12,c21,c22,p11,p12,p21,p22)
      integer KNOWN, MISS
      parameter(KNOWN=0, MISS=-9999)
      integer c11,c12,c21,c22,p11,p12,p21,p22

      logical h1, h2
      integer nallele, nmiss, cnallele
      integer shared
C 
C overall expectation 
      shibd=0.5d0
C
C deal with simplest cases
      call countall(c11,c12,c21,c22,cnallele,nmiss)
      if (cnallele.eq.4 .or.(c11.ne.c21 .and. c11.ne.c22 .and.
     &    c12.ne.c21 .and. c12.ne.c22)) then
        shibd=0.0d0
        return
      end if
      call countall(p11,p12,p21,p22,nallele,nmiss)
C
      h1=.false.
      h2=.false.
      if (p11.ne.p12) h1=.true.
      if (p21.ne.p22) h2=.true.
      shared=MISS
      if (nallele.eq.3 .and. h1 .and. h2) then
        shared=p11
        if (p11.ne.p21 .and. p11.ne.p22) shared=p12
      end if
      if (nallele.eq.4 .or. (nallele.eq.3 .and. h1.and.h2)) then
        if (c11.eq.c21 .and. c12.eq.c22 ) then
          shibd=1.0d0
        elseif (c11.ne.c12 .and. c21.ne.c22 .and.
     3      (((c11.eq.c21.or.c11.eq.c22) .and. c11.eq.shared ) .or.
     4      ((c12.eq.c21.or.c12.eq.c22) .and. c12.eq.shared )))  then
          shibd=0.0d0
        end if
      elseif (nallele.eq.3) then
        shibd=0.25d0
        if (c11.eq.c21 .and. c12.eq.c22 ) shibd=0.75d0
      else
        if (h1 .and. h2) then
          if (c11.eq.c21 .and. c12.eq.c22) then
            shibd=1.0d0
            if (c11.ne.c22) shibd=0.5d0
          end if
        elseif (h1 .or. h2) then  
          shibd=0.25d0
          if (c11.eq.c21 .and. c12.eq.c22) shibd=0.75d0
        end if
      end if
      return
      end
C end-of-shibd
C
C Calculate regression weight
C
      double precision function regwt(weight,i,j,locus)
      integer MAXSIZ, MAXLOC, MISS
      parameter(MAXSIZ=20, MAXLOC=10000, MISS=-9999)
      integer i,j,weight
      double precision locus(MAXSIZ,MAXLOC)
      if (weight.ne.MISS .and. 
     2    locus(i,weight).ne.MISS .and.
     3    locus(j,weight).ne.MISS) then
        regwt=0.5d0*(locus(i,weight)+locus(j,weight))
      else
        regwt=1.0d0
      end if
      return
      end
C end-of-regwt
C
C Calculate ibd sharing for full sibs 
C
      double precision function fibd(c11,c12,c21,c22,p11,p12,p21,p22, 
     &                               numal,name,alfrq)
      integer KNOWN, MAXALL, MISS
      parameter(KNOWN=0, MAXALL=2, MISS=-9999)
      integer nallele, nmiss, cnallele, cnmiss
      double precision c11,c12,c21,c22,p11,p12,p21,p22
      logical h1, h2
C allele frequencies structure
      integer numal, name(MAXALL)
      double precision alfrq(MAXALL)
      integer ic11,ic12,ic21,ic22,ip11,ip12,ip21,ip22,t1,t2
      integer shared, unshared
      double precision pr1, pr2
C functions
      double precision getfreq
C 
C overall expectation 
      fibd=0.5d0
      ic11=MISS
      ic12=MISS
      ic21=MISS
      ic22=MISS
      if (c11.gt.KNOWN) ic11=int(c11)
      if (c12.gt.KNOWN) ic12=int(c12)
      if (c21.gt.KNOWN) ic21=int(c21)
      if (c22.gt.KNOWN) ic22=int(c22)
C
C deal with simplest cases
      call countall(ic11,ic12,ic21,ic22,cnallele,cnmiss)
      if (cnmiss.gt.0) then 
        return
      elseif (cnallele.eq.4 .or.(ic11.ne.ic21 .and. ic11.ne.ic22 .and.
     &        ic12.ne.ic21 .and. ic12.ne.ic22)) then
        fibd=0.0d0
        return
      end if
      ip11=MISS
      ip12=MISS
      ip21=MISS
      ip22=MISS
      if (p11.gt.KNOWN) ip11=int(p11)
      if (p12.gt.KNOWN) ip12=int(p12)
      if (p21.gt.KNOWN) ip21=int(p21)
      if (p22.gt.KNOWN) ip22=int(p22)
      call countall(ip11,ip12,ip21,ip22,nallele,nmiss)
      if (nallele.eq.1.and.nmiss.eq.0) return
C
C deal with all missing parental genotypes
      if (nmiss.eq.4) then
        if (cnallele.eq.1) then
          fibd=1.0d0/(1.0d0+getfreq(ic11,numal,name,alfrq))
        elseif (cnallele.eq.2) then
          if (ic11.eq.ic12) then
            fibd=1.0d0/2.0d0/(1.0d0+getfreq(ic11,numal,name,alfrq))
          elseif (ic21.eq.ic22) then
            fibd=1.0d0/2.0d0/(1.0d0+getfreq(ic21,numal,name,alfrq))
          else
            pr1=getfreq(ic11,numal,name,alfrq)
            pr2=getfreq(ic12,numal,name,alfrq)
            fibd=(2.0d0+pr1+pr2)/2.0d0/(1.0d0+pr1+pr2+2.0d0*pr1*pr2)
          end if
        elseif (cnallele.eq.3) then
          if (ic11.eq.ic21.or.ic11.eq.ic22) then
            fibd=1.0d0/2.0d0/(1.0d0+
     &           2.0d0*getfreq(ic11,numal,name,alfrq))
          else
            fibd=1.0d0/2.0d0/(1.0d0+
     &           2.0d0*getfreq(ic21,numal,name,alfrq))
          end if
        end if
C     write(*,'(a,i1,a,f5.3)') 'nallele=',nallele,' ibd=',fibd
C     write(*,'(a)') 'Child-1   Child-2   Parent-1  Parent-2'
C     write(*,'(8i5)') ic11,ic12,ic21,ic22,ip11,ip12,ip21,ip22
        return
      end if
C
C else do case where only one parent has been typed
C
      if ((ip11.eq.MISS.and.ip12.eq.MISS) .or. 
     &    (ip21.eq.MISS.and.ip22.eq.MISS)) then
        if (ip11.eq.MISS) then
          t1=ip21
          t2=ip22
        else
          t1=ip11
          t2=ip12
        end if
C       write(*,*) 't1,t2=',t1,t2,' cnallele=',cnallele
C       write(*,*) 'freq=',getfreq(ic11,numal,name,alfrq)
        h1=.false.
        if (t1.ne.t2) h1=.true.
        if (cnallele.eq.1) then
          pr1=getfreq(ic11,numal,name,alfrq)
          if (t1.eq.ic11.and..not.h1) then
C --------- fibd=(3.0d0-getfreq(ic11,numal,name,alfrq))/4.0d0
            fibd=(3.0d0+pr1)/(4.0d0+4.0d0*pr1)
          else
            fibd=(2.0d0*pr1+1.0d0)/(3.0d0*pr1+1.0d0)
          end if
        elseif (cnallele.eq.2) then
          if (ic11.eq.ic12) then
C first child is homozygote and second is heterozygote
            unshared=ic21
            if (ic21.eq.ic11) unshared=ic22
            if (.not.h1) then
               fibd=0.25d0
            elseif (t1.eq.unshared .or. t2.eq.unshared) then
               pr1=getfreq(ic11,numal,name,alfrq)
               pr2=getfreq(unshared,numal,name,alfrq)
               fibd=0.5d0*(1.0d0+pr2)/(1+pr1+pr2)
C ------------ fibd=1.0d0/2.0d0/(1.0d0+getfreq(ic11,numal,name,alfrq))
            else
               fibd=1.0d0
            end if
          elseif (ic21.eq.ic22) then
C second child is homozygote and first is heterozygote
            unshared=ic11
            if (ic11.eq.ic21) unshared=ic12
            if (.not.h1) then
               fibd=0.25d0
            elseif (t1.eq.unshared .or. t2.eq.unshared) then
               pr1=getfreq(ic21,numal,name,alfrq)
               pr2=getfreq(unshared,numal,name,alfrq)
               fibd=0.5d0*(1.0d0+pr2)/(1+pr1+pr2)
C ------------ fibd=1.0d0/2.0d0/(1.0d0+getfreq(ic21,numal,name,alfrq))
            else
               fibd=1.0d0
            end if
          else
C 12-12 sibpair
            if (.not.h1) then
              if (t1.eq.ic11) then
                pr1=getfreq(ic12,numal,name,alfrq)
              else
                pr1=getfreq(ic11,numal,name,alfrq)
              end if
              fibd=(3.0d0+pr1)/4.0d0/(1.0d0+pr1)
            elseif (t1.eq.ic11 .and. t2.eq.ic12) then
              pr1=getfreq(ic11,numal,name,alfrq)
              pr2=getfreq(ic12,numal,name,alfrq)
              fibd=0.5d0*(pr1*(2.0d0+pr1)+pr2*(2.0d0+pr2))/(pr1+pr2)/
     &             (1.0d0+pr1+pr2)
C             fibd=((pr1-pr2)**2+2.0d0*(pr1+pr2))/
C    &             2.0d0/(pr1**2+pr1+pr2+pr2**2)
            else
              if (t1.eq.ic11) then
                pr1=getfreq(ic12,numal,name,alfrq)
              else
                pr1=getfreq(ic11,numal,name,alfrq)
              end if
              fibd=(2.0d0+pr1)/2.0d0/(1.0d0+pr1)
            end if
          end if
        elseif (cnallele.eq.3) then
          shared=ic11
          if (ic12.eq.ic21 .or. ic12.eq.ic22) shared=ic12
          if ((t1.eq.ic11.and.t2.eq.ic12) .or.
     &        (t1.eq.ic21.and.t2.eq.ic22)) then
            pr1=getfreq(t1,numal,name,alfrq)
            pr2=getfreq(t2,numal,name,alfrq)
            if (t2.eq.shared) then
              fibd=0.5d0*pr1/(pr1+pr2)
            else
              fibd=0.5d0*pr2/(pr1+pr2)
            end if
          else
            pr1=getfreq(shared,numal,name,alfrq)
            fibd=0.25d0*(2.0d0-pr1)
          end if
        end if
C ---------------------------- Diagnostic Print
C     write(*,'(a,i1,a,f5.3)') 'nallele=',nallele,' ibd=',fibd
C     write(*,'(a)') 'Child-1   Child-2   Parent-1  Parent-2'
C     write(*,'(8i5)') ic11,ic12,ic21,ic22,ip11,ip12,ip21,ip22
C ------------------------ End Diagnostic Print
        return
      end if
C
C proceed to case where all parental genotypes known
      h1=.false.
      h2=.false.
      if (ip11.ne.ip12) h1=.true.
      if (ip21.ne.ip22) h2=.true.
      shared=MISS
      if (nallele.eq.3 .and.h1.and.h2) then
        shared=ip11
        if (ip11.ne.ip21.and.ip11.ne.ip22) shared=ip12
      end if
      if (nallele.eq.4 .or. (nallele.eq.3 .and. h1.and.h2)) then
        if (ic11.eq.ic21 .and. ic12.eq.ic22 ) then
          fibd=1.0d0
        elseif (ic11.ne.ic12 .and. ic21.ne.ic22 .and.
     3      (((ic11.eq.ic21.or.ic11.eq.ic22) .and. ic11.eq.shared ) .or.
     4      ((ic12.eq.ic21.or.ic12.eq.ic22) .and. ic12.eq.shared ))) 
     5  then
          fibd=0.0d0
        end if
      elseif (nallele.eq.3) then
        fibd=0.25d0
        if (ic11.eq.ic21 .and. ic12.eq.ic22 ) fibd=0.75d0
      else
        if (h1 .and. h2) then
          if (ic11.eq.ic21 .and. ic12.eq.ic22) then
            fibd=1.0d0
            if (ic11.ne.ic22) fibd=0.5d0
          end if
        elseif (h1 .or. h2) then  
          fibd=0.25d0
          if (ic11.eq.ic21 .and. ic12.eq.ic22) fibd=0.75d0
        end if
      end if
C------------------------------- Diagnostic Print
C     write(*,'(a,i1,a,f5.3)') 'nallele=',nallele,' ibd=',fibd
C     write(*,'(a)') 'Child-1   Child-2   Parent-1  Parent-2'
C     write(*,'(8i5)') ic11,ic12,ic21,ic22,ip11,ip12,ip21,ip22
C--------------------------- End Diagnostic Print
      return
      end
C end-of-fibd
C
C estimate ibd score for a pair of half-sibs -- parents known
C tabulations of number of genes expected shared ibd
C 
      double precision function hibd(c11,c12,c21,c22,
     &                               p11,p12,pc1,pc2,p21,p22)
      integer KNOWN, MISS
      parameter(KNOWN=0, MISS=-9999)
      double precision c11,c12,c21,c22,p11,p12,pc1,pc2,p21,p22
      integer d, n
      integer ip(6), ic(4)

C IBS=0 added 20051224!
      if (c11.ne.c21 .and. c11.ne.c22 .and. 
     &   c12.ne.c21 .and. c12.ne.c22) then
        hibd=0.0d0
        return
      end if

      hibd=0.25d0
C if homozygote common parent, no linkage information
      if (pc1.gt.KNOWN .and. pc1.eq.pc2) return

      d=0
      n=0
      ic(1)=int(c11)
      ic(2)=int(c12)
      ic(3)=int(c21)
      ic(4)=int(c22)
      ip(1)=int(p11)
      ip(2)=int(p12)
      ip(3)=int(pc1)
      ip(4)=int(pc2)
      ip(5)=int(p21)
      ip(6)=int(p22)
      do 1 i1=1,2
      do 1 i2=3,4
      if ((ic(1).eq.ip(i1) .and. ic(2).eq.ip(i2)) .or.
     &    (ic(2).eq.ip(i1) .and. ic(1).eq.ip(i2))) then
        do 2 i3=3,4
        do 2 i4=5,6
        if ((ic(3).eq.ip(i3) .and. ic(4).eq.ip(i4)) .or.
     &      (ic(4).eq.ip(i3) .and. ic(3).eq.ip(i4))) then
          n=n+1
          if (i2.eq.i3) d=d+1
        end if
    2   continue
      end if
    1 continue
      if (n.gt.0) then
        hibd=0.5d0*dfloat(d)/dfloat(n)
      end if
      return
      end
C end-of-hibd
C
C perform Elston & Keats sib pair linkage analysis 
C between two codominant markers
C
C recombination fraction c= 0.5 (1-sqrt(r))
C where r is the correlation between mean ibd at marker1 and mean ibd at
C marker2 for all sib pairings
C
      subroutine twopoi(wrk,mark1, loc1, numal, name, alfrq, 
     2             mark2, loc2, numal2, name2, alfrq2,pedigree,
     3             actset,num,nfound, id, fa, mo, sex, locus, numloc, 
     4             ibd1, ibd2, untyped,set,set2,plevel)
      integer IBDSIZ, KNOWN, MAXALL, MAXIBD, MAXSIZ, MAXLOC, MISS
      parameter(MAXIBD=20, IBDSIZ=MAXIBD*(MAXIBD+1)/2, KNOWN=0,
     &          MAXALL=2, MAXLOC=10000,MAXSIZ=20,MISS=-9999)
      integer mark1,mark2,plevel,wrk
      character*10 loc1, loc2
C  Pedigree structure
      character*10 pedigree
      integer actset,num, nfound
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ), sex(MAXSIZ)
      integer numloc
      double precision locus(MAXSIZ,MAXLOC)
C
C allele frequencies within entire sample for given locus 
C
      integer numal, name(MAXALL)
      double precision alfrq(MAXALL)
      integer numal2, name2(MAXALL)
      double precision alfrq2(MAXALL)
C ibd sharing
      double precision ibd1(IBDSIZ), ibd2(IBDSIZ)
C work arrays for MC iteration
      integer set(MAXSIZ,2), set2(MAXSIZ,2)
      logical untyped(MAXSIZ)

C local variables
      integer contrib, currf, currm, fin, i,j,pos, mark12, mark22, sibs
      double precision cov(3), hz, mean(2), r, rhi, rlo, y(2), zr
      logical untyp2(MAXSIZ)
      logical last
C functions
      integer getnam
      double precision inht, rtheta
C
      nfam=0
      sibs=0
      mark12=mark1+1
      mark22=mark2+1
      mean(1)=0.0d0
      mean(2)=0.0d0
      cov(1)=0.0d0
      cov(2)=0.0d0
      cov(3)=0.0d0

      last=.false.
      rewind(wrk)
    5 continue
        call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &             numloc, last)
        if (last) goto 20

        if (actset.le.0) goto 5
C
        do 70 i=1,num
        if (locus(i,mark1).gt.KNOWN) then
          untyped(i)=.false.
          set(i,1)=getnam(locus(i,mark1),numal,name)
          set(i,2)=getnam(locus(i,mark12),numal,name)
        else  
          untyped(i)=.true.
          set(i,1)=MISS
          set(i,2)=MISS
        end if
        if (locus(i,mark2).gt.KNOWN) then
          untyp2(i)=.false.
          set2(i,1)=getnam(locus(i,mark2),numal2,name2)
          set2(i,2)=getnam(locus(i,mark22),numal2,name2)
        else  
          untyp2(i)=.true.
          set2(i,1)=MISS
          set2(i,2)=MISS
        end if
   70   continue

        fin=num
        currf=fa(fin)
        currm=mo(fin)
        do 90 k=num-1,nfound,-1
          if (fa(k).ne.currf .or. mo(k).ne.currm) then
            contrib=0
            do 92 i=k+1,fin
            if (.not.untyped(i) .and. .not.untyp2(i)) then
              contrib=contrib+1
            end if
   92       continue
C
C Skip if no usable individuals in this sibship
C
            if (contrib.gt.0) then

              nfam=nfam+1
              call nucibd(mark1,currf,currm,k+1,fin,set,untyped,ibd1,
     &                    numal, name, alfrq)
              call nucibd(mark2,currf,currm,k+1,fin,set2,untyp2,ibd2,
     &                    numal2, name2, alfrq2)
              pos=0
              do 95 i=k+1,fin
                do 97 j=k+1,i-1
                  pos=pos+1
                  if (.not.untyped(i) .and. .not.untyped(j) .and.
     &                .not.untyp2(i) .and. .not.untyp2(j)) then
                    y(1)=ibd1(pos)
                    y(2)=ibd2(pos)
                    sibs=sibs+1
                    if (plevel.gt.1) then
                      write(*,'(i5,3(1x,a),2(1x,f6.4))') 
     &                  sibs, pedigree, id(i), id(j), y(1), y(2)
                    end if
                    call dssp(2, sibs, 1, y, mean, cov)
                  end if
   97           continue
                pos=pos+1
   95         continue

            end if
C Now update to next sibship
            fin=k
            currf=fa(fin)
            currm=mo(fin)
          end if
   90   continue

   10  continue
      goto 5
   20 continue
C 
      r=cov(2)/sqrt(cov(1))/sqrt(cov(3))
      zr=inht(r)
      hz=1.96d0*sqrt(1.0d0/dfloat(sibs-1)+2.0d0/dfloat((sibs-1)**2))
      rlo=tanh(zr-hz)
      rhi=tanh(zr+hz)

      write(*,'(a10,1x,a10,2(1x,i8),2(3x,f5.3),1x,f5.3,a,f5.3)') 
     &  loc1,loc2,nfam,sibs,r,rtheta(r), rtheta(rhi), '--', rtheta(rlo)
      return
      end
C end-of-twopoi 
C
C Create order of loci for outputting a pedigree
C  1 = as is
C  2 = LINKAGE
C  3 = GENEHUNTER
C  4 = MENDEL
C
      subroutine lorder(typ,nloci,loctyp,nord,locord)
      integer MAXLOC
      parameter(MAXLOC=10000)

      integer typ
C Locus structure
      integer nloci,loctyp(MAXLOC)
C Printing order of loci
      integer nord,locord(MAXLOC)

      integer i
C
C Default is no manipulation
C
      if (typ.lt.2) then
        nord=nloci
        do 10 i=1,nloci
          locord(i)=i
   10   continue
C
C else Genehunter 2 ordering
C
      else
        nord=0
C no more than one binary trait if typ=3
        if (typ.eq.2 .or. typ.eq.3) then
          do 20 i=1,nloci
          if (loctyp(i).eq.4) then
            nord=nord+1
            locord(nord)=i
            if (typ.eq.3) goto 21
          end if
   20     continue
   21     continue
        end if
C all the markers 
        do 30 i=1,nloci
        if (loctyp(i).eq.1 .or. loctyp(i).eq.2) then
          nord=nord+1
          locord(nord)=i
        end if
   30   continue
C MENDEL factors
        if (typ.eq.4) then
          do 40 i=1,nloci
          if (loctyp(i).eq.4) then
            nord=nord+1
            locord(nord)=i
          end if
   40     continue
        end if
C then the quantitative traits
        do 50 i=1,nloci
        if (loctyp(i).eq.3) then
          nord=nord+1
          locord(nord)=i
        end if
   50   continue
      end if
      return
      end
C end-of-order
C
C Write map 
C
C 10 = table for Sib-pair output
C  0 = LINKAGE
C  1 = LINKAGE plus dummy binary trait
C  2 = GENEHUNTER plus dummy binary trait
C  3 = GENEHUNTER
C  4 = MENDEL
C 20 = MENDEL .var file 
C  5 = ASPEX
C  6 = MERLIN
C  7 = LOKI  
C  8 = STRUCTURE
C  9 = SOLAR
C
      subroutine wrmap(ostr,typ,mapf,nloci,loc,loctyp,locnotes,
     &                 nord,locord, map)
      integer MAXLOC, MISS
      parameter(MAXLOC=10000,MISS=-9999)

      integer mapf, ostr, typ
C Locus structure
      integer nloci,loctyp(MAXLOC)
      character*20 loc(MAXLOC)
      character*40 locnotes(MAXLOC)
C Printing order of loci
      integer nord,locord(MAXLOC)
C position of locus on sex-averaged linkage map
      real map(MAXLOC)

      integer i, k
      logical frst
      character*21 tnam
      real dist
C functions
      real invmap
C show map
      dist=0.0
      frst=.true.
      if (typ.eq.10) then
        write(*,'(/a//a/a)') 'User specified marker map:',
     2    'Marker         Pos (cM)   Theta' ,
     3    '-----------    --------   -----' 
        do 20 i=1,nloci
        if (loctyp(i).le.2) then
          if (map(i).ne.MISS) then
            dist=map(i)-dist
            if (dist.lt.0.0) dist=1000.0
            write(*,'(a15,f8.2,f8.3,3x,a)') 
     &        loc(i),map(i),invmap(dist,mapf),locnotes(i)
            dist=map(i)
          else
            write(*,'(a15,5x,a1,7x,a1,6x,a)') 
     &        loc(i),'x','x',locnotes(i)
          end if
        end if
   20   continue
        write(*,*)
C write Linkage or Genehunter locus file map
      else if (typ.ge.0 .and. typ.le.3) then
        dist=MISS
        if (typ.eq.1 .or. typ.eq.2) write(OSTR,'(a,$)') '  .000'
        do 30 k=1,nord 
        i=locord(k)
        if (loctyp(i).le.4) then
          if (frst) then
            frst=.not.frst
          elseif (dist.ne.MISS .and. map(i).ge.dist) then
            if (typ.eq.2 .or.typ.eq.3) then
              write(ostr,'(1x,f6.2,$)') max(0.01,map(i)-dist)
            else
              write(ostr,'(1x,f6.4,$)') invmap(map(i)-dist,mapf)
            end if
          else
            if (typ.eq.2 .or. typ.eq.3) then
              write(ostr,'(a,$)') ' 0.0'
            else
              write(ostr,'(a,$)') ' .4999'
            end if
          end if
          dist=map(i)
        end if
   30   continue
C MENDEL map file
      else if (typ.eq.4) then
        do 40 i=1,nloci
        if (loctyp(i).le.4) then
          if (frst) then
            frst=.not.frst
          elseif (dist.ne.MISS .and. map(i).ge.dist) then
            dist=map(i)-dist
            write(ostr,'(8x,f8.4,f8.4)') 
     &        invmap(dist,mapf), invmap(dist,mapf)
          else
            write(ostr,'(8x,f8.4,f8.4)') 0.5, 0.5
          end if
          dist=map(i)
          write(ostr,'(a8)') loc(i)
        end if
   40   continue
C MENDEL var file
      else if (typ.eq.20) then
        do 45 i=1,nloci
        if (loctyp(i).eq.3) then
          write(ostr,'(a8)') loc(i)
        end if
   45   continue
C ASPEX map 
      else if (typ.eq.5) then
        k=0
        write(ostr,'(a,$)') 'set dist {'
        do 50 i=1,nloci
        if (loctyp(i).le.2) then
          k=k+1
          if (map(i).ne.MISS .and. map(i).ge.dist) then
            write(ostr,'(1x,f5.3,$)') 
     &        max(0.001,0.01*(map(i)-dist))
            dist=map(i)
          elseif (dist.eq.0.0) then
            write(ostr,'(a,$)') ' 0.001'
            dist=-100.0
          else
            write(ostr,'(a,$)') ' 0.50'
            dist=-100.0
          end if
          if (k.eq.6) then
            k=0
            write(ostr,'(/a,$)') '          '
          end if
        end if
   50   continue
        write(ostr,'(a)') ' 0.01 }'
C MERLIN map file
      else if (typ.eq.6) then
        do 60 i=1,nloci
        if (loctyp(i).le.2) then
          if (map(i).ne.MISS) then
            write(ostr,'(2a,f9.3)') '1 ',loc(i),map(i)
            dist=map(i)
          else
            write(ostr,'(2a,f9.3)') '1 ',loc(i), 1000.0+dist
            dist=dist+1000.0
          end if
        end if
   60   continue
C LOKI parameter file map positions
      else if (typ.eq.7) then
        write(ostr,'(a/a//a,f9.3/)') 
     &    'ITERATIONS 1000', 'START OUTPUT 50,1', 'TOTAL MAP 3600.0'
        do 80 i=1,nloci
        if (loctyp(i).eq.1 .and. map(i).ne.MISS) then
          call addlet(loc(i), tnam)
          write(ostr,'(a,a20,f9.3)') 'POSITION ',tnam,map(i)
        end if
   80   continue
C STRUCTURE datafile map positions
      else if (typ.eq.8) then
        do 90 i=1,nloci
        if (loctyp(i).le.2) then
          write(ostr,'(1x,a,$)') loc(i)
        end if
   90   continue
        write(ostr,'(a)') ' '
        do 100 i=1,nloci
        if (loctyp(i).le.2) then
          if (frst) then
            frst=.not.frst
            write(ostr,'(1x,a2,$)') '-1'
          elseif (dist.ne.MISS .and. map(i).ge.dist) then
            dist=map(i)-dist
            write(ostr,'(1x,f7.2,$)') dist
          else
            write(ostr,'(1x,a2,$)') '-1'
          end if
          dist=map(i)
        end if
  100   continue
        write(ostr,*)
C SOLAR map file
      else if (typ.eq.9) then
        write(ostr,'(a)') '1'
        do 110 i=1,nloci
        if (loctyp(i).le.2) then
          if (map(i).ne.MISS) then
            write(ostr,'(a,f9.3)') loc(i),map(i)
            dist=map(i)
          else
            write(ostr,'(a,f9.3)') loc(i), 1000.0+dist
            dist=dist+1000.0
          end if
        end if
  110   continue
      end if
      return
      end
C end-of-wrmap
C
C Write out pedigree header with locus names 
C
      subroutine pedhead(longnam,nwid,nloci,loc,loctyp,locpos,lin)
      integer LINSIZ,MAXLOC
      parameter (LINSIZ=40000,MAXLOC=10000)
      integer longnam,nwid
C Locus structure
      character*20 loc(MAXLOC)
      integer nloci,loctyp(MAXLOC),locpos(MAXLOC)
      character*(LINSIZ) lin
C local variables
      integer eos,i,j,pos
      character*3 sex
C functions
      integer eow
      data sex /'sex'/

      write(*,'(/a)') '!'
      do 10 i=1,2
        lin='!'
        pos=longnam+35
        lin(pos:pos)=sex(i:i)
        pos=pos+2
        do 15 j=1,nloci
        if(loctyp(j).le.2) then
           pos=pos+9
        elseif(loctyp(j).eq.3) then
           pos=pos+nwid+2
        elseif(loctyp(j).eq.4) then
           eos=max(0,3-eow(loc(j)))
           if (eos.lt.i) lin(pos:pos)=loc(j)(i-eos:i-eos)
           pos=pos+2
        end if
   15   continue
        write(*,'(a)') lin(1:pos)
   10 continue

      lin(1:longnam)='! Pedigree'
      pos=longnam+6
      lin(pos:pos+31)='Person     Father     Mother x'
      pos=pos+31

      do 25 j=1,nloci
      if(loctyp(j).le.2) then
         eos=eow(loc(j))
         lin(pos+8-eos:pos+7)=loc(j)(1:eos)
         pos=pos+9
      elseif(loctyp(j).eq.3) then
         eos=min(nwid,eow(loc(j)))
         lin(pos+nwid-eos:pos+nwid-1)=loc(j)(1:eos)
         pos=pos+nwid+2
      elseif(loctyp(j).eq.4) then
         eos=max(0,3-eow(loc(j)))
         lin(pos:pos)=loc(j)(i-eos:i-eos)
         pos=pos+2
      end if
   25 continue
      write(*,'(a/a)') lin(1:pos),'!'
      return
      end
C end-of-pedhead
C
C Write out pedigree using GAS format
C
      subroutine pedout(wrk,strm,typ,imp,nwid,ndec,longnam,misval,nrc,
     2             pedigree,actset,num,nfound,
     3             id,fa,mo,sex,locus,nloci,loctyp,locpos,numloc,lin)
      integer LINSIZ,KNOWN,MAXSIZ,MAXLOC,MISS
      parameter (LINSIZ=40000,KNOWN=0,MAXSIZ=20,
     &           MAXLOC=10000,MISS=-9999)
      integer imp,longnam,ndec,nrc,nwid,strm,typ,wrk
      character*1 misval
C Pedigree structure
      character*10 pedigree
      integer actset,num,nfound 
      character*10 id(MAXSIZ) 
      integer fa(MAXSIZ),mo(MAXSIZ),sex(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)
C Locus structure
      integer nloci,loctyp(MAXLOC),locpos(MAXLOC)
      character*(LINSIZ) lin
C local variables
      character*8 fdec
      character*20 loc20,miss20

      integer i,j,nobs,pos
      logical last, noimp
C
C quantitative variable format
  
      call wrform('f', nwid, ndec, fdec)
      miss20=' '
      pos=min(nwid-ndec,19)
      miss20(pos:pos)=misval

      noimp=(imp.ne.3 .and. imp.ne.6)
      last=.false.
      nobs=0
      rewind(wrk)
   10 continue
       call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &            numloc, last)
       if (last) goto 20

       if (actset.le.0) goto 10

        do 15 i=1,num
C compulsory data
          nobs=nobs+1
          lin=' '
          lin(1:longnam)=pedigree(1:longnam)
          pos=longnam+2 
          loc20=id(i)
          call juststr('r',loc20,10)
          lin(pos:pos+9)=loc20(1:10)
          pos=pos+11
          if (fa(i).eq.MISS) then
            lin(pos+9:pos+9)=misval
            lin(pos+20:pos+20)=misval
            pos=pos+22
          else
            loc20=id(fa(i))
            call juststr('r',loc20,10)
            lin(pos:pos+9)=loc20(1:10)
            pos=pos+11
            loc20=id(mo(i))
            call juststr('r',loc20,10)
            lin(pos:pos+9)=loc20(1:10)
            pos=pos+11
          end if
          if (sex(i).eq.2) then
            lin(pos:pos)='f'
          elseif (sex(i).eq.1) then
            lin(pos:pos)='m'
          else
            lin(pos:pos)=misval
          end if
          pos=pos+2
C phenotypes
          do 25 j=1,nloci
          if (loctyp(j).le.2) then
             if (locus(i,locpos(j)).eq.MISS .or. 
     &           (noimp .and. locus(i,locpos(j)).le.KNOWN)) then
               if (misval.eq.'x') then
                 call wrgtp(MISS, MISS, lin(pos+1:pos+7),typ+1)
               else
                 lin(pos+4:pos+4)=misval
               end if
             else
               call wrgtp(int(abs(locus(i,locpos(j)))),
     2                    int(abs(locus(i,locpos(j)+1))),
     3                    lin(pos+1:pos+7),typ+1)
             end if
             pos=pos+9
          elseif(loctyp(j).eq.3) then
             if(locus(i,locpos(j)).eq.MISS) then
               write(loc20,'(a)') miss20
             else
               write(loc20,fdec) locus(i,locpos(j))
             end if
             lin(pos:pos+nwid-1)=loc20(1:nwid)
             pos=pos+nwid+2
          elseif(loctyp(j).eq.4) then
             if (locus(i,locpos(j)).eq.MISS .or.
     &           locus(i,locpos(j)).eq.0.0) then
               lin(pos:pos)=misval
             elseif(locus(i,locpos(j)).eq.1.0) then
               lin(pos:pos)='n'
             elseif(locus(i,locpos(j)).eq.2.0) then
               lin(pos:pos)='y'
             end if
             pos=pos+2
          end if
   25     continue
          write(strm,'(a)') lin(1:pos-2)
          if (nrc.gt.0 .and. nobs.eq.nrc) return
   15   continue
      goto 10
   20 continue
      return
      end
C end-of-pedout
C
C Write out PAP pedigree
C
      subroutine wrpap(wrk,wrk2,trip,phen,pedigree,actset,num,nfound,
     2                 id,fa,mo,sex,locus,nloci,loctyp,locpos,numloc,
     3                 numal,name,alfrq)
      integer KNOWN,LINSIZ,MAXALL,MAXSIZ,MAXLOC,MISS
      parameter (KNOWN=0,LINSIZ=40000,MAXALL=2,MAXSIZ=20,
     &           MAXLOC=10000,MISS=-9999)
      integer phen,trip,wrk,wrk2
C Pedigree structure
      character*10 pedigree
      character*10 id(MAXSIZ)
      integer actset,num,nfound,fa(MAXSIZ),mo(MAXSIZ),sex(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)
C Locus structure
      integer nloci,loctyp(MAXLOC),locpos(MAXLOC)
      character*(LINSIZ) lin
      character*8 loc1
C allele frequencies structure
      integer numal, name(MAXALL)
      double precision alfrq(MAXALL)
C local variables
      integer eop,famcnt,famno,g1,g2,i,j,pos,nfam,sx 
      logical last
C functions
      integer eow, getnam
C
C A unique ID number is obtained for each individual by adding the famno
C (which increases in multiples of famcnt, minimum 1000) to their position
C 1..num
C 
      famcnt=int(10.0**int(max(3.0,1.0+log10(float(MAXSIZ)))))
      famno=0
      nfam=0
      pedigree=' '
      last=.false.
      rewind(wrk)
   10 continue
       call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &            numloc, last)
       if (last) goto 20

         if (actset.le.0) goto 10

         nfam=nfam+1
         famno=famno+famcnt
         eop=eow(pedigree)
         lin=' '
         if (num.eq.nfound) then
           do 14 i=1,num
           if (sex(i).eq.1) then
             write(trip,'(4i8,4a)') 
     &       nfam,famno+i,famno+num+i,0,' # ',pedigree(1:eop),'-',id(i)
           else
             write(trip,'(4i8,4a)') 
     &       nfam,famno+num+i,famno+i,0,' # ',pedigree(1:eop),'-',id(i)
           end if
   14      continue
         end if
         do 15 i=1,num
           rewind(wrk2)
           sx=1
           if (sex(i).eq.2) sx=2
           if (fa(i).ne.MISS.and.mo(i).ne.MISS) then
             write(trip,'(4i8,9a)') 
     2       nfam,famno+fa(i),famno+mo(i),famno+i,
     3       ' # ',pedigree(1:eop),'-',id(i),
     4       ' (',id(fa(i))(1:eow(id(fa(i)))),' x ',
     5            id(mo(i))(1:eow(id(mo(i)))),')'
           end if
           write(loc1,'(i8)') famno+i
           lin(1:8)=loc1
           write(loc1,'(i8)') sx
           lin(9:16)=loc1
           pos=17
           do 17 j=1,nloci
             if (pos.gt.122) then
               write(phen,'(a)') lin(1:pos-1)
               lin(1:pos-1)=' '
               pos=1
             end if 
             if (loctyp(j).le.2) then
                read(wrk2) numal,(name(k),k=1,numal),
     &                     (alfrq(k),k=1,numal)
                if (locus(i,locpos(j)).lt.KNOWN) then
                  write(loc1,'(a8)') '   -9999'
                else
                  g1=getnam(locus(i,locpos(j)),numal,name)
                  g2=getnam(locus(i,locpos(j)+1),numal,name)
                  if (loctyp(j).eq.2 .and. sex(i).ne.2) then
                    write(loc1,'(i8)') numal*(numal+1)/2+g1
                  else
                    write(loc1,'(i8)') g2*(g2-1)/2+g1
                  end if
                end if
                lin(pos:pos+7)=loc1
                pos=pos+8
             elseif (loctyp(j).eq.3) then
               if (locus(i,locpos(j)).eq.MISS) then
                 write(loc1,'(a8)') '   -9999'
               else
                 write(loc1,'(f8.4)') locus(i,locpos(j))
               end if
               lin(pos:pos+7)=loc1
               pos=pos+8
             elseif (loctyp(j).eq.4) then
               if (locus(i,locpos(j)).eq.MISS) then
                 write(loc1,'(a8)') '   -9999'
               elseif (locus(i,locpos(j)).eq.1) then
                 write(loc1,'(a8)') '1'
               elseif (locus(i,locpos(j)).eq.2) then
                 write(loc1,'(a8)') '2'
               end if
               lin(pos:pos+7)=loc1
               pos=pos+8
             end if
   17      continue
           if (pos.gt.1) then
             write(phen,'(a)') lin(1:pos-1)
             lin(1:pos-1)=' '
             pos=1
           end if 
   15    continue
      goto 10
   20 continue
      return
      end
C end-of-wrpap
C
C Write out SAGE pedigree
C
      subroutine wrsage(wrk,strm,pedigree,actset,num,id,fa,mo,sex,locus,
     &                  nloci, loctyp,locpos,numloc)
      integer LINSIZ,MAXSIZ,MAXLOC,MISS
      parameter (LINSIZ=40000,MAXSIZ=20,MAXLOC=10000,MISS=-9999)
      integer strm,wrk,actset,num
C Pedigree structure
      character*10 pedigree
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ),mo(MAXSIZ),sex(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)
C Locus structure
      integer nloci,loctyp(MAXLOC),locpos(MAXLOC)
      character*(LINSIZ) lin
      character*9 loc1
      character*4 loc2
      character*1 sx
      integer i,j,pos,nfound,nfam
      logical last
      nfam=0
      pedigree=' '
      last=.false.
      rewind(wrk)
   10 continue
       call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &            numloc, last)
       if (last) goto 20

         if (actset.le.0) goto 10

         nfam=nfam+1
         pos=1
         lin=' '

         do 15 i=1,num
           sx='M'
           if (sex(i).eq.2) sx='F'
           if (fa(i).eq.MISS.and.mo(i).eq.MISS) then
             write(strm,'(a5,i5,a8,16x,a1)') 
     &          'fsp  ',nfam,id(i),sx
           else
             write(strm,'(a5,i5,3a8,a1)') 
     &          'fsp  ',nfam,id(i),id(fa(i)),id(mo(i)),sx
           end if
           do 17 j=1,nloci
             if (pos.gt.122) then
               write(strm,'(a)') lin(1:pos-1)
               lin(1:pos-1)=' '
               pos=1
             end if 
            if (loctyp(j).eq.1) then
              if (locus(i,locpos(j)).eq.MISS) then
                write(loc1,'(a9)') ' '
              else
                write(loc1,'(i4.4,a1,i4.4)') 
     &            int(locus(i,locpos(j))),'/',int(locus(i,locpos(j)+1))
              end if
              lin(pos:pos+8)=loc1
              pos=pos+9
            elseif (loctyp(j).eq.3) then
             if (locus(i,locpos(j)).eq.MISS) then
               write(loc1,'(1x,f8.4)') -99.0
             else
               write(loc1,'(1x,f8.4)') locus(i,locpos(j))
             end if
             lin(pos:pos+8)=loc1
             pos=pos+9
           elseif (loctyp(j).eq.4) then
             if (locus(i,locpos(j)).eq.MISS) then
               write(loc2,'(1x,a3)') '-99'
             elseif (locus(i,locpos(j)).eq.1) then
               write(loc2,'(1x,a3)') '1'
             elseif (locus(i,locpos(j)).eq.2) then
               write(loc2,'(1x,a3)') '2'
             end if
             lin(pos:pos+3)=loc2
             pos=pos+4
           end if
   17      continue
           if (pos.gt.1) then
             write(strm,'(a)') lin(1:pos-1)
             lin(1:pos-1)=' '
             pos=1
           end if 
   15    continue
      goto 10
   20 continue

      return
      end
C end-of-wrsage
C
C write out linkage type file
C
      subroutine wrlink(wrk,wrk2,strm,typ,nwid,ndec,pedigree,actset,
     2             num, nfound,id,fa,mo,sex,locus,nloci,loctyp,locpos,
     3             nord,locord,numloc,numal,name,alfrq)
      integer KNOWN,LINSIZ,MAXSIZ,MAXLOC,MISS,MAXALL
      parameter (KNOWN=0,LINSIZ=40000,MAXSIZ=20,MAXLOC=10000,
     &           MISS=-9999,MAXALL=2)
      integer ndec,nwid,strm,typ,wrk,wrk2
C Pedigree structure
      character*10 pedigree
      integer actset, num, nfound
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ),mo(MAXSIZ),sex(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)
C Locus structure
      integer nloci,loctyp(MAXLOC),locpos(MAXLOC)
C Printing order of loci
      integer nord,locord(MAXLOC)
C allele frequencies structure
      integer numal, name(MAXALL)
      double precision alfrq(MAXALL)
C
      character*(LINSIZ) lin
      character*8 fdec
      character*20 loc20,miss20
      character*1 sx
      integer all3, eop, i, j, k, kid1, l, matsib, 
     &        nped, patsib, pos, pro
      logical last
C functions
      integer eow, getnam
C
C quantitative variable format 
      call wrform('f', nwid, ndec, fdec)
      miss20=' '
      pos=min(nwid-ndec,19)
      if (typ.eq.2 .or. typ.eq.3) then
        miss20(pos:pos)='-'
      else
        miss20(pos:pos)='0'
      end if

      nped=0
      pedigree=' '
      last=.false.
      rewind(wrk)
   10 continue
       call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &            numloc, last)
       if (last) goto 20

        if (actset.le.0) goto 10

        eop=eow(pedigree)
        nped=nped+1
        do 15 i=1,num
          rewind(wrk2)
          lin=' '
          sx='1'
          if (sex(i).eq.2) sx='2'
          if (typ.eq.5 .or. typ.eq.6) then
            write(loc20,'(i10,1x,i10)') nped,i
          else
            write(loc20,'(a10,1x,a10)') pedigree,id(i)
          end if
          lin(1:19)=loc20(1:19)
          if (typ.eq.5 .or. typ.eq.6) then
            if (fa(i).eq.MISS) then
              write(loc20,'(1x,i8,1x,i10)') 0, 0
            else
              write(loc20,'(1x,i8,1x,i10)') fa(i), mo(i)
            end if
          else 
            if (fa(i).eq.MISS) then
              write(loc20,'(1x,a10,1x,a10,1x,a1)') 
     &          '0         ','0         ',sx
            else
              write(loc20,'(1x,a10,1x,a10,1x,a1)') 
     &          id(fa(i)),id(mo(i)),sx
            end if
          end if
          lin(20:39)=loc20
          pos=41
          if (typ.eq.5 .or. typ.eq.6) then
            all3=0
            kid1=0
            matsib=0
            patsib=0
            pro=0
            if (i.eq.1) pro=1
            do 50 j=i+1, num
              if (kid1.eq.0 .and. fa(j).eq.i .or. mo(j).eq.i) then
                all3=all3+1
                kid1=j
              else if (i.gt.nfound) then
                if (patsib.eq.0 .and. fa(j).eq.fa(i)) then
                  all3=all3+1
                  patsib=j
                end if
                if (matsib.eq.0 .and. mo(j).eq.mo(i)) then
                  all3=all3+1
                  matsib=j
                end if
              end if
              if (all3.eq.3) goto 51
   50       continue
   51       continue
            write(loc20,'(3(1x,i4),1x,a1,1x,i1)') 
     &         kid1, patsib, matsib, sx, pro
            lin(40:59)=loc20
            pos=60
          end if
C Add dummy binary trait when asked
          if (typ.eq.1 .or. typ.eq.2 .or. typ.eq.6) then
            lin(pos:(pos+2))=' 2 '
            pos=pos+3
          end if
          do 25 l=1,nord
            j=locord(l)
            if (loctyp(j).le.2) then
              read(wrk2) numal,(name(k),k=1,numal),(alfrq(k),k=1,numal)
              if(locus(i,locpos(j)).le.KNOWN) then
                write(loc20,'(1x,a3,1x,a3)') '0','0'
              else
                write(loc20,'(1x,i3,1x,i3)') 
     2           getnam(locus(i,locpos(j)),numal,name),
     3           getnam(locus(i,locpos(j)+1),numal,name)
              end if
              lin(pos:pos+7)=loc20(1:8)
              pos=pos+9
            elseif (loctyp(j).eq.3) then
              if(locus(i,locpos(j)).eq.MISS) then
                write(loc20,'(a)') miss20
              elseif(locus(i,locpos(j)).eq.0.0) then
                write(loc20,'(a)') '  0.000001'
              else
                write(loc20,fdec) locus(i,locpos(j))
              end if
              lin(pos:pos+nwid-1)=loc20(1:nwid)
              pos=pos+nwid+2
            elseif (loctyp(j).eq.4) then
              if (locus(i,locpos(j)).eq.1) then
                lin(pos:pos)='1'
              elseif (locus(i,locpos(j)).eq.2.0) then
                lin(pos:pos)='2'
              else
                lin(pos:pos)='0'
              end if
              pos=pos+2
            end if
   25     continue
          if (typ.eq.5 .or. typ.eq.6) then
            lin(pos:(pos+4+eop))='Ped: ' // pedigree(1:eop)
            pos=pos+6+eop
            lin(pos:(pos+12))='Per: ' // id(i)
            pos=pos+14
          end if
          write(strm,'(a)') lin(1:pos-1)
   15   continue
      goto 10
   20 continue
      return
      end
C end-of-wrlink
C
C write out CRI-MAP type file
C
      subroutine wrcri(wrk,wrk2,strm,pedigree,actset,num,id,fa,mo,sex,
     2                 locus,nloci,loctyp,locpos,numloc,
     3                 numal,name,alfrq)
      integer KNOWN,LINSIZ,MAXSIZ,MAXLOC,MISS,MAXALL
      parameter (KNOWN=0,LINSIZ=40000,MAXSIZ=20,MAXLOC=10000,
     &           MISS=-9999,MAXALL=2)
      integer strm,wrk,wrk2,actset,num
C Pedigree structure
      character*10 pedigree
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ),mo(MAXSIZ),sex(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)
C Locus structure
      integer nloci,loctyp(MAXLOC),locpos(MAXLOC)
C allele frequencies structure
      integer numal, name(MAXALL)
      double precision alfrq(MAXALL)
C
      character*(LINSIZ) lin
      character*8 part1
      character*20 part2
      character*9 loc1
      character*1 sx
      integer i,j,pos,nfound
      logical last
C functions
      integer getnam
C
      pedigree=' '
      last=.false.
      rewind(wrk)
   10 continue
       call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &            numloc, last)
       if (last) goto 20

        if (actset.le.0) goto 10

        write(strm,'(1x,a10/1x,i3)') pedigree, num
        do 15 i=1,num
          rewind(wrk2)
          lin=' '
          write(part1,'(a10)') id(i)
          sx='0'
          if (sex(i).eq.2) sx='1'
          if (fa(i).eq.MISS) then
            write(part2,'(1x,a10,1x,a10,1x,a1)')  
     &          '0         ','0         ',sx
          else
            write(part2,'(1x,a10,1x,a10,1x,a1)') id(fa(i)),id(mo(i)),sx
          end if
          lin(1:10)=part1
          lin(11:34)=part2
          pos=35
          do 25 j=1,nloci
          if(loctyp(j).eq.1) then
             read(wrk2) numal,(name(k),k=1,numal),(alfrq(k),k=1,numal)
             if(locus(i,locpos(j)).le.KNOWN) then
               write(loc1,'(1x,a3,1x,a3)') '0','0'
             else
               write(loc1,'(1x,i3,1x,i3)') 
     2          getnam(locus(i,locpos(j)),numal,name),
     3          getnam(locus(i,locpos(j)+1),numal,name)
             end if
             lin(pos:pos+8)=loc1
             pos=pos+9
          end if
   25     continue
         write(strm,'(a)') lin(1:pos-1)
   15   continue
      goto 10
   20 continue
      return
      end
C end-of-wrcri
C
C write out FISHER or MENDEL type pedigree file
C
      subroutine wrfish(wrk,strm,twinning, pedigree,actset,num,nfound,
     2                  id,fa,mo,sex, locus,nloci,loctyp,locpos,
     3                  numloc,nord,locord, fstyle)
      integer KNOWN,LINSIZ,MAXSIZ,MAXLOC,MISS
      parameter (KNOWN=0,LINSIZ=40000,MAXSIZ=20,
     &           MAXLOC=10000,MISS=-9999)
      integer strm,twinning,wrk,fstyle
C Pedigree structure
      character*10 pedigree
      character*10 id(MAXSIZ)
      integer actset,num,nfound,fa(MAXSIZ),mo(MAXSIZ),sex(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)
C Locus structure
      integer nloci,loctyp(MAXLOC),locpos(MAXLOC)
C Printing order of loci
      integer nord,locord(MAXLOC)

      character*(LINSIZ) lin
      character*22 part2
      character*9 loc1
      character*1 sx, tw
      integer i,j,k,pos,nlp
      logical last
      pedigree=' '
      last=.false.
      nlp=0
      do 1 i=1,nloci
        if(loctyp(i).le.4) nlp=nlp+1
    1 continue
      if (fstyle.eq.1) then
        write(strm,'(1x,a/1x,a,i4,a)') 
     &      '(2(i3,1x),a8)','(a8,2(1x,a8),2(1x,a1),',nlp,'(1x,a8))'
      else
        write(strm,'(1x,a/1x,a,i4,a)') 
     &      '(i3,1x,a8)','(a8,2(1x,a8),2(1x,a1),',nlp,'(1x,a8))'
      end if
      rewind(wrk)
   10 continue
       call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &            numloc, last)
       if (last) goto 20

        if (actset.le.0) goto 10

        if (fstyle.eq.1) then
          write(strm,'(2(i3,1x),a8)') 0,num,pedigree(1:8)
        else
          write(strm,'(i3,1x,a8)') num,pedigree(1:8)
        end if
        do 15 i=1,num
          lin=' '
          tw=' '
          if (twinning.ne.MISS .and. locus(i,twinning).ne.MISS) tw='1'
          sx='M'
          if (sex(i).eq.2) sx='F'
          lin(1:8)=id(i)
          if (fa(i).eq.MISS) then
            write(part2,'(1x,a8,1x,a8,1x,a1,1x,a1)') ' ',' ',sx,tw
          else
            write(part2,'(1x,a8,1x,a8,1x,a1,1x,a1)') 
     &            id(fa(i)),id(mo(i)),sx,tw
          end if
          lin(9:30)=part2
          pos=31
          do 25 k=1,nord 
            j=locord(k)
            if (loctyp(j).le.2) then
              if (locus(i,locpos(j)).le.KNOWN) then
                write(loc1,'(1x,a8)') ' '
                lin(pos:pos+8)=loc1
              else
                call wrgtp(int(locus(i,locpos(j))),
     2                     int(locus(i,locpos(j)+1)),
     3                     lin(pos+2:pos+8),1)
              end if
              pos=pos+9
            elseif(loctyp(j).eq.3) then
              if(locus(i,locpos(j)).eq.MISS) then
                write(loc1,'(1x,a8)') ' '
              else
                write(loc1,'(1x,f8.4)') locus(i,locpos(j))
              end if
              lin(pos:pos+8)=loc1
              pos=pos+9
            elseif(loctyp(j).eq.4) then
              if(locus(i,locpos(j)).eq.1.0) then
                write(loc1,'(1x,a8)') 'NORMAL  '
              elseif(locus(i,locpos(j)).eq.2.0) then
                write(loc1,'(1x,a8)') 'AFFECTED'
              else
                write(loc1,'(1x,a8)') ' '
              end if
              lin(pos:pos+8)=loc1
              pos=pos+9
            end if
   25     continue
          write(strm,'(a)') lin(1:pos-1)
   15   continue
      goto 10
   20 continue
      return
      end
C end-of-wrfish
C
C write out Arlequin data file (haplotype data)
C
      subroutine wrarl(wrk,wrk2,strm,pedigree,actset,num,nfound,id,fa,
     2                 mo,sex, locus,nloci,loc,loctyp,locpos,numloc,
     3                 mar,hset,typ)
      integer KNOWN,MAXHAP,MAXSIZ,MAXLOC,MISS
      parameter (KNOWN=0,MAXSIZ=20,MAXLOC=10000,
     &           MAXHAP=MAXLOC/2,MISS=-9999)
      integer strm,typ,wrk,wrk2
C Pedigree structure
      character*10 pedigree
      character*10 id(MAXSIZ)
      integer actset,num,nfound,fa(MAXSIZ),mo(MAXSIZ),sex(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)
C Locus structure
      integer nloci,loctyp(MAXLOC),locpos(MAXLOC)
      character*20 loc(MAXLOC)
C
C Storage space for haplotypes
      integer hset(MAXSIZ,MAXHAP,2)
C List of active marker loci
      integer mar(MAXLOC)
C local variables
      integer gene,gen2,i,j,k,maxid,maxinf,ninf,nlp,nsamp
      integer nt1, nt2, tr1, tr2
      character*3 all  
      logical last

      nlp=0
      do 1 j=1,nloci
      if (loctyp(j).eq.1) then
        nlp=nlp+1
        mar(nlp)=locpos(j)
      end if
    1 continue
      nsamp=0

      pedigree=' '
      last=.false.
      rewind(wrk)
   10 continue
       call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &            numloc, last)
       if (last) goto 20

        if (actset.le.0) goto 10
C
C Go through pedigree, either all member genotypes
        if (typ.eq.0) then
         do 12 i=1,num
           ninf=0
           do 13 j=1,nlp
             gene=mar(j)
             gen2=gene+1
             hset(1,j,1)=MISS
             hset(1,j,2)=MISS
             if (locus(i,gene).gt.KNOWN) then
               ninf=ninf+1
               hset(1,j,1)=int(locus(i,gene))
               hset(1,j,2)=int(locus(i,gen2))
             end if
   13      continue
           if (ninf.gt.1) then
             nsamp=nsamp+1
             write(wrk2) ((hset(1,j,k),j=1,nlp),k=1,2)
           end if
   12    continue
        else
C
C or the most useful callable haplotype per family
         maxid=0
         maxinf=0
         do 15 i=nfound+1,num
           ninf=0
           do 16 j=1,nlp
             gene=mar(j)
             gen2=gene+1
             if (locus(i,gene).gt.KNOWN .and. locus(fa(i),gene).gt.KNOWN
     2           .and. locus(mo(i),gene).gt.KNOWN) then
               ninf=ninf+1
               call trans(int(locus(fa(i),gene)),int(locus(fa(i),gen2)),
     2                    int(locus(mo(i),gene)),int(locus(mo(i),gen2)),
     3                    int(locus(i,gene)), int(locus(i,gen2)),
     4                    tr1,tr2,nt1,nt2,0)
               hset(i,j,1)=tr1
               hset(i,j,2)=tr2
               hset(mo(i),j,1)=tr1
               hset(mo(i),j,2)=nt1
               hset(fa(i),j,1)=tr2
               hset(fa(i),j,2)=nt2
             else
               hset(i,j,1)=MISS
               hset(i,j,2)=MISS
               hset(mo(i),j,1)=MISS
               hset(mo(i),j,2)=MISS
               hset(fa(i),j,1)=MISS
               hset(fa(i),j,2)=MISS
             end if
   16      continue
           if (ninf.gt.maxinf) then
             maxinf=ninf
             maxid=i
           end if
   15    continue
         if (maxinf.gt.1) then
           if (typ.eq.1) then
             nsamp=nsamp+1
             write(wrk2) ((hset(maxid,j,k),j=1,nlp),k=1,2)
           else
             nsamp=nsamp+2
             write(wrk2) ((hset(fa(maxid),j,k),j=1,nlp),k=1,2)
             write(wrk2) ((hset(mo(maxid),j,k),j=1,nlp),k=1,2)
           end if
         end if
        end if
      goto 10
   20 continue
C
C Write haplotypes
C
      write(strm,'(a/a/a/a)') 
     &  '#','# Arlequin format data written by Sib-pair','#','[Profile]' 
      if (typ.eq.0) then
        write(strm,'(3x,a)') 
     &    'Title="Genotype data: All genotyped individuals"' 
      else if (typ.eq.1) then
        write(strm,'(3x,a)') 
     &    'Title="Haplotype data: one child per family"' 
      else
        write(strm,'(3x,a)') 
     &   'Title="Haplotype data: two parents per family"' 
      end if
      write(strm,'(3x,a)') 
     2  'NbSamples=1', 'GenotypicData=1'  
      write(strm,'(3x,a,i1)') 'GameticPhase=',min(typ,1)
      write(strm,'(3x,a)') 
     2  'RecessiveData=0','DataType=STANDARD',
     3  'LocusSeparator=WHITESPACE','MissingData="x"'
      write(strm,'(a/3x,a/6x,a/6x,a,i5/6x,a)') '[Data]','[[Samples]]',
     &  'SampleName="Population 1"', 'SampleSize=',nsamp,'SampleData= {'
C
      rewind(wrk2)
      do 50 i=1,nsamp
        read(wrk2) ((hset(1,j,k),j=1,nlp),k=1,2)
        write(strm,'(i10,i3,$)') i,1 
        do 60 j=1,nlp
          call wrall(hset(1,j,1),all)
          write(strm,'(1x,a3,$)') all
   60   continue
        write(strm,'(/12x,a,$)') ' '
        do 65 j=1,nlp
          call wrall(hset(1,j,2),all)
          write(strm,'(1x,a3,$)') all
   65   continue
        write(strm,*)
   50 continue
      write(strm,'(6x,a)') '}'
      return
      end
C end-of-wrarl 
C
C write out data file used by Jonathon Pritchard's structure program
C
      subroutine wrprd(wrk,strm,trait,pedigree,actset,num,nfound,id,fa,
     &             mo,sex,locus,nloci,loc,loctyp,locpos,numloc,typ)
      integer KNOWN,LMISS,LINSIZ,MAXSIZ,MAXLOC,MISS
      parameter (KNOWN=0,LINSIZ=40000,MAXSIZ=20,MAXLOC=10000,
     &           LMISS=-9, MISS=-9999)
      integer strm,trait,wrk
      integer typ
C Pedigree structure
      character*10 pedigree
      character*10 id(MAXSIZ)
      integer actset,num,nfound,fa(MAXSIZ),mo(MAXSIZ),sex(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)
C Locus structure
      integer nloci,loctyp(MAXLOC),locpos(MAXLOC)
      character*20 loc(MAXLOC)

      integer eop,fin,g1,g2,i,j,tval
      logical last
C functions
      integer eow

      pedigree=' '
      last=.false.

      rewind(wrk)
   10 continue
       call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &            numloc, last)
       if (last) goto 20

        if (actset.le.0) goto 10

        eop=eow(pedigree)
        fin=num
        if (typ.eq.1) fin=nfound
        do 15 i=1,fin
          if (trait.eq.MISS) then
            tval=0
          else
            tval=int(locus(i,trait))-1
          end if
          write(strm, '(3a, 2(1x, i2),$)') 
     &      pedigree(1:eop),'-',id(i)(1:eow(id(i))), 1, tval
          do 25 j=1,nloci
          if (loctyp(j).eq.1) then
            g1=int(locus(i,locpos(j)))
            g2=int(locus(i,locpos(j)+1))
            if (g1.le.KNOWN) then
              g1=LMISS
              g2=LMISS
            end if
            write(strm,'(1x,i3,1x,i3,$)') g1,g2
          end if
   25     continue
          write(strm,*) 
   15   continue
      goto 10
   20 continue
      return
      end
C end-of-wrprd 
C
C write out pedigree file used by Rams (Sang Hong Lee) 
C
      subroutine wrrams(wrk, strm, strm2, trait, pedigree, actset, num, 
     2                  nfound, id, fa, mo, sex, locus, nloci, loc, 
     3                  loctyp, locpos, numloc)
      integer KNOWN, MAXSIZ, MAXLOC, MISS
      parameter (KNOWN=0, MAXSIZ=20,
     &           MAXLOC=10000, MISS=-9999)
      integer strm, strm2, trait, wrk
C Pedigree structure
      character*10 pedigree
      character*10 id(MAXSIZ)
      integer actset,num,nfound,fa(MAXSIZ),mo(MAXSIZ),sex(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)
C Locus structure
      integer nloci,loctyp(MAXLOC),locpos(MAXLOC)
      character*20 loc(MAXLOC)
      integer fid, i, j, mid, n, nr
      logical last

      n=0
      nr=0
      pedigree=' '
      last=.false.
      rewind(wrk)
   10 continue
       call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &            numloc, last)
       if (last) goto 20

        if (actset.le.0) goto 10

        do 15 i=1,num
          fid=0
          mid=0
          if (fa(i).ne.MISS) fid=n+fa(i)
          if (mo(i).ne.MISS) mid=n+mo(i)
          write(strm, '(i5, 2(1x, i5), $)') n+i, fid, mid
          do 25 j=1,nloci
          if (loctyp(j).eq.1) then
            if (locus(i,locpos(j)).le.KNOWN) then
              write(strm,'(3x,a1,$)') '0'
            else
              write(strm,'(1x,i3,$)') int(locus(i,locpos(j)))
            end if
          else if (trait.eq.j .and. locus(i, locpos(j)).ne.MISS) then
            nr=nr+1
            write(strm2,'(i1,1x,i5,1x,f9.4)') 
     &        1, n+i, locus(i,locpos(j))
          end if
   25     continue
          write(strm,'(a,$)') '  '
          do 35 j=1,nloci
          if (loctyp(j).eq.1) then
            if (locus(i,locpos(j)).le.KNOWN) then
              write(strm,'(3x,a1,$)') '0'
            else
              write(strm,'(1x,i3,$)') int(locus(i,locpos(j)+1))
            end if
          end if
   35     continue
          write(strm,'(3a)') ' # ', pedigree, id(i)
   15   continue
        n=n+num
      goto 10
   20 continue
      write(*,'(a, i5, a, i5)') 'NA= ', n, ' NR=', nr
      return
      end
C end-of-wrrams
C
C write out Nexus gdatype data file used by GDA
C
      subroutine wrgda(wrk,strm,pedigree,actset,num,nfound,id,fa,mo,sex,
     &                 locus,nloci,loc,loctyp,locpos,numloc,typ)
      integer KNOWN,LINSIZ,MAXSIZ,MAXLOC,MISS
      parameter (KNOWN=0,LINSIZ=40000,MAXSIZ=20,
     &           MAXLOC=10000,MISS=-9999)
      integer strm,wrk
      integer typ
C Pedigree structure
      character*10 pedigree
      character*10 id(MAXSIZ)
      integer actset,num,nfound,fa(MAXSIZ),mo(MAXSIZ),sex(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)
C Locus structure
      integer nloci,loctyp(MAXLOC),locpos(MAXLOC)
      character*20 loc(MAXLOC)
      character*(LINSIZ) lin
      character*10 loc1
      integer eop,fin,i,j,n,nlp,pos
      logical last
C functions
      integer eow

      pedigree=' '
      last=.false.
      n=0
      nlp=0
      do 1 j=1,nloci
        if(loctyp(j).eq.1) nlp=nlp+1
    1 continue
      write(strm,'(3(a/),a,i3,a,2(/a))') 
     2  '#nexus','[ Nexus gdatype format data written by Sib-pair ]',
     3  'begin gdadata;', 'dimensions nloci=',nlp,' npops=1;',
     5  'format tokens labels missing=x datapoint=standard;',
     6  'locusallelelabels'
      i=0
      do 2 j=1,nloci
      if (loctyp(j).eq.1) then
        i=i+1
        if (i.lt.nlp) then
          write(strm,'(2x,i3,1x,2a)')   i,loc(j),','
        else
          write(strm,'(2x,i3,1x,a,3(/a))') i,loc(j),';','matrix','Pop1:'
        end if
      end if
    2 continue

      rewind(wrk)
   10 continue
       call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &            numloc, last)
       if (last) goto 20

        if (actset.le.0) goto 10

        eop=eow(pedigree)
        fin=num
        if (typ.eq.1) fin=nfound
        do 15 i=1,fin
          lin=' '
          n=n+1
          write(loc1,'(2x,i8)') n
          lin(1:10)=loc1
          pos=11
          do 25 j=1,nloci
          if (loctyp(j).eq.1) then
            if (locus(i,locpos(j)).le.KNOWN) then
              write(loc1,'(1x,a8)') '   x/x  '
            else
              write(loc1,'(2x,i3.3,a1,i3.3)') 
     &          int(locus(i,locpos(j))),'/',int(locus(i,locpos(j)+1))
            end if
            lin(pos:pos+8)=loc1
            pos=pos+9
          end if
   25     continue
          lin(pos:pos+2)=' [ '
          pos=pos+3
          lin(pos:pos+eop-1)=pedigree
          pos=pos+eop
          write(loc1,'(a10)') id(i)
          lin(pos:pos+9)=loc1
          lin(pos+10:pos+12)=' ] '
          write(strm,'(a)') lin(1:pos+12)
   15   continue
      goto 10
   20 continue
      write(strm,'(a/a)') ';','end;'
      return
      end
C end-of-wrgda 
C
C write out Mapmaker-Sibs phenotype file
C
      subroutine wrphe(wrk,strm,pedigree,actset,num,nfound,id,fa,mo,sex,
     &                 locus,nloci,loctyp,locpos,numloc)
      integer MAXSIZ,MAXLOC,MISS
      parameter (MAXSIZ=20,MAXLOC=10000,MISS=-9999)
      integer strm,wrk
C Pedigree structure
      character*10 pedigree
      character*10 id(MAXSIZ)
      integer actset,num,nfound,fa(MAXSIZ),mo(MAXSIZ),sex(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)
C Locus structure
      integer nloci,loctyp(MAXLOC),locpos(MAXLOC)
      integer eop,i,j,nlp
      logical last
      character*10 chid
C functions
      integer eow

      pedigree=' '
      last=.false.
      nlp=0
      do 1 j=1,nloci
        if(loctyp(j).eq.3) nlp=nlp+1
    1 continue
      write(strm,'(i3)') nlp

      rewind(wrk)
   10 continue
       call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &            numloc, last)
       if (last) goto 20

        if (actset.le.0) goto 10

        eop=eow(pedigree)
        do 15 i=nfound+1,num
          call wrid('l',id(i),chid,0)
          write(strm,'(a,1x,a,$)') pedigree(1:eop),chid(1:eow(chid))
          do 25 j=1,nloci
          if (loctyp(j).eq.3) then
            if (locus(i,locpos(j)).eq.MISS) then
              write(strm,'(1x,a9,$)') '    -    '
            else
              write(strm,'(1x,f9.4,$)') locus(i,locpos(j))
            end if
          end if
   25     continue
          write(strm,*)
   15   continue
      goto 10
   20 continue
      return
      end
C end-of-wrphe 
C
C Write out pedigree as character-delimited
C typ
C 1   full pedigree
C 2   id,fa,mo,sex,ped (for SOLAR)
C 3   ped, id, data
C 4   id, data
C
      subroutine wrcsv(wrk,strm,typ,imp,nwid,ndec,
     2             pedigree,actset,num,nfound,
     3             id,fa,mo,sex,locus,nloci,loc,loctyp,locpos,numloc)
      integer LINSIZ,KNOWN,MAXSIZ,MAXLOC,MISS
      parameter (LINSIZ=40000,KNOWN=0,MAXSIZ=20,
     &           MAXLOC=10000,MISS=-9999)
      integer imp,ndec,nwid,strm,typ,wrk
C Pedigree structure
      character*10 pedigree
      integer actset,num,nfound 
      character*10 id(MAXSIZ) 
      integer fa(MAXSIZ),mo(MAXSIZ),sex(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)
C Locus structure
      integer nloci
      character*20 loc(MAXLOC)
      integer loctyp(MAXLOC),locpos(MAXLOC)
C local variables
      character*1 sep
      character*2 na
      character*7 gtp
      character*10 fdec
      character*20 loc20

      integer i,j
      logical last
C functions
      integer eow, sow

      na='NA'
      sep=','
C
C quantitative variable format
      call wrform('f', nwid, ndec, fdec)
      fdec(eow(fdec):(eow(fdec)+2))=',$)'
C header
      if (typ.eq.1) then
        write(strm, '(a,$)') 'ped,id,fa,mo,sex' 
      else if (typ.eq.2) then
        write(strm, '(a,$)') 'famid,id,fa,mo,sex' 
        na=' '
      else if (typ.eq.3) then
        write(strm, '(a,$)') 'famid,id' 
        na=' '
      else if (typ.eq.4) then
        write(strm, '(a,$)') 'id' 
        na=' '
      end if
      if (typ.ne.2) then
        do 1 i=1, nloci
        if (loctyp(i).lt.5) then
          write(strm,'(2a,$)')  sep, loc(i)(1:eow(loc(i))) 
        end if
    1   continue
      end if
      write(strm,*)

      last=.false.
      rewind(wrk)
   10 continue
       call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &            numloc, last)
       if (last) goto 20

       if (actset.le.0) goto 10

        do 15 i=1,num
C compulsory data
          if (typ.le.3) then
            write(strm,'(3a,$)') 
     &        pedigree(1:eow(pedigree)),sep,id(i)(1:eow(id(i)))
            if (typ.le.2) then
              if (fa(i).eq.MISS) then
                write(strm,'(4a,$)') sep,na,sep,na
              else
                write(strm,'(4a,$)')
     2            sep, id(fa(i))(1:eow(id(fa(i)))),
     3            sep, id(mo(i))(1:eow(id(mo(i)))) 
              end if
              if (sex(i).eq.1) then
                write(strm,'(2a,$)') sep, 'm'
              else if (sex(i).eq.2) then
                write(strm,'(2a,$)') sep, 'f'
              else
                write(strm,'(2a,$)') sep, na
              end if
            end if
          else if (typ.eq.4) then
            write(strm,'(a,$)') id(i)(1:eow(id(i)))
          end if
C phenotypes
          if (typ.ne.2) then
            do 25 j=1,nloci
              if (loctyp(j).le.2) then
                 write(strm,'(a,$)') sep
                 if (locus(i,locpos(j)).gt.KNOWN) then
                   call wrgtp(int(abs(locus(i,locpos(j)))),
     2                        int(abs(locus(i,locpos(j)+1))), gtp,1)
                   write(strm,'(a,$)') gtp(sow(gtp):eow(gtp))
                 else
                   write(strm,'(a,$)') na
                 end if
              elseif(loctyp(j).eq.3) then
                 write(strm,'(a,$)') sep
                 if (locus(i,locpos(j)).ne.MISS) then
                   write(loc20,fdec) locus(i,locpos(j))
                   write(strm,'(a,$)') loc20(sow(loc20):eow(loc20))
                 else
                   write(strm,'(a,$)') na
                 end if
              elseif(loctyp(j).eq.4) then
                 write(strm,'(a,$)') sep
                 if(locus(i,locpos(j)).eq.1.0) then
                   write(strm,'(a,$)') 'n'
                 elseif(locus(i,locpos(j)).eq.2.0) then
                   write(strm,'(a,$)') 'y'
                 else
                   write(strm,'(a,$)') na
                 end if
              end if
   25       continue
          end if
          write(strm,*)
   15   continue
      goto 10
   20 continue
      return
      end
C end-of-wrcsv 
C
C Describe pedigree using dot graphics language
C
      subroutine wrdot(wrk,strm,trait,pedigree,actset,num,nfound,
     &             id,fa,mo,sex,locus,nloci,loctyp,locpos,numloc,lin)
      integer LINSIZ,KNOWN,MAXSIZ,MAXLOC,MISS
      parameter (LINSIZ=40000,KNOWN=0,MAXSIZ=20,
     &           MAXLOC=10000,MISS=-9999)
      integer trait,strm,wrk
C Pedigree structure
      character*10 pedigree
      integer actset,num,nfound 
      character*10 id(MAXSIZ) 
      integer fa(MAXSIZ),mo(MAXSIZ),sex(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)
C Locus structure
      integer nloci,loctyp(MAXLOC),locpos(MAXLOC)
      character*(LINSIZ) lin
C local variables
      character*8 marriage, shape, shade
      integer currf, currm, i,nfam
      logical last
C functions
      integer eow
C
      last=.false.
      rewind(wrk)
   10 continue
       call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &            numloc, last)
       if (last) goto 20

        if (actset.le.0) goto 10

        write(strm,'(3a/a/a/a/3a/a/)') 
     2    'digraph Ped_', pedigree, ' {',
     3    '# page = "8.2677165,11.692913" ;', 'ratio = "auto" ;',
     4    'mincross = 2.0 ;', 'label = "Pedigree ', 
     5    pedigree(1:eow(pedigree)), '" ;','rotate = 90 ;'
        do 15 i=1,num
          if (sex(i).eq.1) then
            shape='circle'
          elseif (sex(i).eq.2) then
            shape='box'
          else
            shape='diamond'
          end if
          if (trait.ne.MISS .and. locus(i,trait).eq.2) then
            shade='grey'
          else
            shade='white'
          end if
          write(strm,'(7a)') '"',id(i)(1:eow(id(i))),'" [shape=',shape,
     &      ', regular=1,style=filled,fillcolor=',shade,'] ;'
   15   continue
        nfam=0
        currf=MISS   
        currm=MISS   
        do 25 i=nfound+1, num
          if (fa(i).ne.currf .or. mo(i).ne.currm) then
            nfam=nfam+1
            write(marriage,'(a4,i4.4)') 'marr',nfam
            currf=fa(i)
            currm=mo(i)
            write(strm,'(4a/5a/5a)') '"', marriage,'" [shape=diamond,',
     2        'style=filled,label="",height=.1,width=.1] ;',
     3        '"',id(currf)(1:eow(id(currf))),'" -> "', marriage,
     4        '" [dir=none,weight=1] ;',  
     5        '"',id(currm)(1:eow(id(currm))),'" -> "', marriage,
     6        '" [dir=none,weight=1] ;'
          end if
          write(strm,'(5a)') '"', marriage,'" -> "',id(i)(1:eow(id(i))),
     &     '" [dir=none, weight=2] ;'
   25   continue
        write(strm,'(a)')  '}'
      goto 10
   20 continue
      return
      end
C end-of-wrdot 
C
C Write out data for particular pedigree or particular person 
C
      subroutine showdata(wrk,fped,fid,larg,words,
     2              nloci,loc,loctyp,locpos, pedigree, actset,
     3              num,nfound,id,fa,mo,sex,locus, numloc, nwid, ndec)
      integer MAXLOC, MAXCOL, MAXSIZ, MISS
      parameter (MAXLOC=10000, MAXCOL=MAXLOC+5, MAXSIZ=20, MISS=-9999)

      integer fid,fped,larg,ndec,nwid, wrk
      character*20 words(MAXCOL)
C Pedigree structure
      character*10 pedigree
      integer actset,num, nfound
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ), sex(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)
C Locus structure
      character*20 loc(MAXLOC)
      integer nloci,loctyp(MAXLOC),locpos(MAXLOC)
C
      integer i, j, nrec
      logical found, last
C functions
      logical strfind

      nrec=0
      last=.false.
      rewind(wrk)
   10 continue
       call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &            numloc, last)
       if (last) goto 20

        if (actset.le.0) goto 10

        found=.false.
        do 50 j=fped, fid-2
        if (strfind(words(j)(1:10),pedigree,1)) then
          found=.not.found
          goto 60
        end if
   50   continue
   60   continue
        if (found) then
          if (fid.gt.larg) then
            do 70 i=1, num
              call wrind(i,pedigree,id,fa,mo,sex,
     &                   locus,nloci,loc,loctyp,locpos, nwid, ndec)
   70       continue
            nrec=nrec+num
          else
            do 75 i=1, num
              do 80 j=fid, larg 
              if (strfind(words(j)(1:10),id(i),1)) then
                call wrind(i,pedigree,id,fa,mo,sex,
     &                     locus,nloci,loc,loctyp,locpos, nwid, ndec)
                nrec=nrec+1
                goto 75
              end if
   80         continue
   75       continue
          end if
        end if
      goto 10
   20 continue
      write(*,'(/a,i6,a)') 'Printed ',nrec,' records.'
      return
      end
C end-of-showdata
C
C write out data for an individual
C
      subroutine wrind(idx,pedigree,id,fa,mo,sex,
     &                 locus,nloci,loc,loctyp,locpos, nwid, ndec)
      integer KNOWN,MAXSIZ,MAXLOC,MISS
      parameter (KNOWN=0,MAXSIZ=20,MAXLOC=10000,MISS=-9999)
      integer idx, ndec, nwid
C Pedigree structure
      character*10 pedigree
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ),mo(MAXSIZ),sex(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)
C Locus structure
      character*20 loc(MAXLOC)
      integer nloci,loctyp(MAXLOC),locpos(MAXLOC)
C local variables
      integer j, lpos
      character*1 ch
      character*7 gtp
      character*10 fdec
      character*20 curloc, loc20
C functions
      integer eow

      call wrform('f', nwid, ndec, fdec)
      call wrsex(sex(idx),ch)

      write(*,'(2a,1x,2a,$)') 
     2  'ped=', pedigree(1:eow(pedigree)),
     3  'id=',id(idx)(1:eow(id(idx))) 
      if (fa(idx).eq.MISS) then
        write(*,'(a,1x,$)') ' fa=x mo=x'
      else
        write(*,'(2a,1x,2a,$)') 
     2    ' fa=', id(fa(idx))(1:eow(id(fa(idx)))) ,
     3    'mo=', id(mo(idx))(1:eow(id(mo(idx))))  
      end if
      write(*,'(2a,$)') ' sex=',ch
      do 25 j=1,nloci
      if (loctyp(j).le.4) then
        lpos=locpos(j)
        curloc=loc(j)
        if (locus(idx,lpos).eq.MISS) then
          write(*,'(1x,2a,1x,$)') curloc(1:eow(curloc)), '=x'
        else if (loctyp(j).le.2) then
          if (locus(idx,lpos).le.KNOWN) then
            write(*,'(1x,2a,1x,$)') curloc(1:eow(curloc)), '=x'
          else
            call wrgtp(int(locus(idx,lpos)), 
     &                 int(locus(idx,lpos+1)),gtp,1)
            call juststr('l',gtp,7)
            write(*,'(1x,3a,1x,$)') 
     &         curloc(1:eow(curloc)), '=', gtp(1:eow(gtp))
          end if
        else if (loctyp(j).eq.4) then
          call wraff(locus(idx,lpos),ch)
          write(*,'(1x,3a,1x,$)') curloc(1:eow(curloc)), '=', ch
        else 
          write(loc20,fdec) locus(idx,lpos)
          call juststr('l',loc20,20)
          write(*,'(1x,3a,$)') curloc(1:eow(curloc)), '=',
     &                         loc20(1:eow(loc20))
        end if
      end if
   25 continue
      write(*,*)
      return
      end
C end-of-wrind 
C
C extracts narg arguments from input string s
C
C typ=1  whitespace separated
C typ=2  whitespace separated or reserved character (id by opchar())
C typ=3  whitespace or slash separated (so genotypes can be written a/b)
C
      subroutine args(s,narg,arg,typ)
      character*(*) s
      integer narg, typ
      character*(*) arg(narg)
      integer eol,i,iarg,n,sarg,sol
C functions
      integer eow, sow
      logical opchar

      do 5 i=1,narg
        arg(i)=' '
    5 continue
      sol=sow(s)
      eol=eow(s)

      n=1
      i=sol
C
C start of main loop
   30 continue

      if (i.gt.eol) goto 40
C a reserved operator is one word
        if (typ.eq.2 .and. opchar(s(i:i))) then
          arg(n)=s(i:i)
          n=n+1
C if not for language parser, 
C skip slashes as these are genotype allele separators
        elseif (typ.eq.3 .and. n.gt.4 .and. s(i:i).eq.'/') then
          continue
C quoted text, usually genotypes "a/b"
        elseif (s(i:i).eq.'"') then
          iarg=-1
C skip leading blanks within quotes
   35     continue
            i=i+1
          if (i.lt.eol .and. s(i:i).eq.' ') goto 35
          sarg=i
   45     continue
          if (i.gt.eol .or. s(i:i).eq.'"') goto 60
            iarg=iarg+1
            i=i+1
          goto 45
C any other character must start a word so read up to next boundary
        elseif (s(i:i).ne.' ' .and. s(i:i).ne.'\t') then
          iarg=-1
          sarg=i
   50     continue
          if (i.gt.eol .or. s(i:i).eq.' ' .or. s(i:i).eq.'\t' .or.
     2        s(i:i).eq.'"' .or. 
     3        (typ.eq.2 .and. opchar(s(i:i))) .or.
     4        (typ.eq.3 .and. s(i:i).eq.'/')) then
            i=i-1
            goto 60
          end if
            iarg=iarg+1
            i=i+1
          goto 50
   60     continue
C        
          arg(n)=s(sarg:(sarg+iarg))
          n=n+1
        end if
        i=i+1
      goto 30
   40 continue
C
C return # arguments actually found 
      narg=n-1
      return
      end 
C end-of-arg
C
C is a reserved character for primitives?  "()*+-/<=>^"
C
      logical function opchar(ch)
      character*1 ch
      integer ich
C functions
      integer ichar
      ich=ichar(ch)
      opchar=((ich.ge.40 .and. ich.le.43) .or. ich.eq.45 .or. 
     &  ich.eq.47 .or. (ich.ge.60 .and. ich.le.62) .or. ich.eq.94)
      return
      end
C end-of-opchar
C
C character to integer conversion via internal read
C
      integer function ival(string)
      integer MISS
      parameter(MISS=-9999)
      character*20 string
      integer i
      if (string.eq.' ') then
        ival=0
      elseif (string.eq.'x' .or. string.eq.'X' .or. string.eq.'.') then
        ival=MISS
      else
        read(string,'(i20)',err=10) i
        ival=i
      end if 
      return
C error -- word is not an integer
   10 write(*,'(2a/)') 'ERROR: Unable to read integer ',string
      ival=0
      return
      end
C end-of-ival
C
C character to float conversion via internal read
C
      double precision function fval(string)
      integer BLANK, MISS
      parameter(BLANK=-9999,MISS=-9999)
      character*20 string
      double precision v

      if (string.eq.' ' .or. string.eq.'-') then
        fval=BLANK
      elseif (string.eq.'x' .or. string.eq.'X' .or. string.eq.'.') then
        fval=MISS
      elseif (string.eq.'y' .or. string.eq.'Y') then
        fval=2.0
      elseif (string.eq.'n' .or. string.eq.'N') then
        fval=1.0
      else
        read(string,'(f20.0)',err=10) v
        fval=v
      end if 
      return
C error -- word is not a number
   10 write(*,'(2a/)') 'ERROR: Unable to read real number ',string
      fval=0.0
      return
      end
C end-of-fval
C
C read allele values either numeric or letter code
C
      double precision function aval(string)
      integer BLANK, MISS
      parameter(BLANK=-9999,MISS=-9999)
      character*(*) string
      integer ich
      character*8 fstring
      double precision v
C functions
      integer eow, ichar

      if (string.eq.' ' .or. string.eq.'-') then
        aval=BLANK
      elseif (string.eq.'x' .or. string.eq.'X' .or. string.eq.'.') then
        aval=MISS
C a single character might be a letter code
      else if (eow(string).eq.1) then
        ich=ichar(string(1:1))
C a single digit
        if (ich.ge.48 .and. ich.le.57) then
          aval=dfloat(ich-48)
C a letter a-zA-Z maps to 10001..52
        else if ((ich.ge.65 .and. ich.le.90) .or. 
     &           (ich.ge.97 .and. ich.le.122)) then
          aval=dfloat(ich+10000)
        else 
          aval=MISS
        end if
      else
        call wrform('f', len(string), 0, fstring)
        read(string,fstring,err=10) v
        aval=v
      end if 
      return
C error -- word is not a number
   10 write(*,'(2a/)') 'ERROR: Unable to interpret allele ',string
      aval=MISS
      return
      end
C end-of-aval
C
C skip leading whitespace
C
      integer function sow(string)
      character*(*) string
      do 10 i=1,len(string)
   10   if (string(i:i).ne.' ' .and. string(i:i).ne.'\t') goto 20
   20 sow=i
      return
      end
C
C find end of string
C
      integer function eow(string)
      character*(*) string
      do 10 i=len(string),1,-1
   10   if (string(i:i).ne.' ') goto 20
   20 eow=i
      return
      end
C end-of-eow
C
C Justify a string of characters within a string
C
      subroutine juststr(just,string,length)
      integer length
      character*1 just
      character*(*) string
      integer fin,i,j,sta

      sta=0
   10 continue
        sta=sta+1
      if (string(sta:sta).eq.' '.and. sta.le.length) goto 10
      fin=length+1
   20 continue
        fin=fin-1
      if (string(fin:fin).eq.' '.and. fin.gt.0) goto 20
      
      i=length-fin+sta
      if (just.eq.'c') then
        i=(i+1)/2
      elseif (just.eq.'l') then
        i=1
      end if
      j=i+fin-sta
C This seems to be quickest
      string(i:j)=string(sta:fin)
      string(1:i-1)=' '
      string(j+1:length)=' '
      return
      end
C end-of-juststr
C
C find a character in a string
C
      integer function chfind(ch, string)
      character*1 ch
      character*(*) string
      integer lent
C functions
      integer eow
      lent=eow(string)
      do 10 chfind=1, lent
        if (ch.eq.string(chfind:chfind)) return
   10 continue
      chfind=0
      return
      end
C
C Compare string to a search string, allowing wildcards '*.', and case
C matching
C
      logical function strfind(regexp, targt, nocase)
      character*(*) regexp, targt
      integer nocase
      integer i, ich1, ich2, lenr, lent, pos, wpos
      logical looking, wild
C functions
      integer eow, ichar
      
      lenr=eow(regexp)
      lent=eow(targt)
C while regexp and target not exhausted
      i=1  
      pos=1
      wpos=0
      wild=.false.
      looking=.true.
      strfind=.true.
   10 continue
C
C     write(*,*)
C    2 regexp(1:(pos-1)),'[',regexp(pos:pos),']',regexp((pos+1):lenr),
C    3 ' ',targt(1:(i-1)),'[',targt(i:i),']',targt((i+1):lent),' ',
C    4 wild, looking, strfind
C     
        if (regexp(pos:pos).eq.'*') then
          wild=.true.
          wpos=pos
          pos=pos+1
          looking=(pos.le.lenr) 
        else
C this character matches?
          if (regexp(pos:pos).eq.'.') then
            strfind=.true.
          elseif (nocase.eq.2) then
            ich1=ichar(regexp(pos:pos))
            ich2=ichar(targt(i:i))
            if (ich1.ge.65 .and. ich1.le.90) ich1=ich1+32
            if (ich2.ge.65 .and. ich2.le.90) ich2=ich2+32
            strfind=(ich1 .eq. ich2)
          else
            strfind=(regexp(pos: