C
C extracts narg arguments from input string s
C
C typ=1  whitespace separated
C typ=2  whitespace separated or reserved character (id by opchar())
C typ=3  whitespace or slash separated (so genotypes can be written a/b)
C
      subroutine args(s,narg,arg,typ)
      character*(*) s
      integer narg, typ
      character*(*) arg(narg)
      integer eol,i,iarg,n,sarg,sol
C functions
      integer eow, sow
      logical opchar

      do 5 i=1,narg
        arg(i)=' '
    5 continue
      call sclean(s)
      sol=sow(s)
      eol=eow(s)

      n=1
      i=sol
C
C start of main loop
   30 continue

      if (i.gt.eol) goto 40
C a reserved operator is one word
        if (typ.eq.2 .and. opchar(s(i:i))) then
          arg(n)=s(i:i)
          n=n+1
C if not for language parser, 
C skip slashes as these are genotype allele separators
        elseif (typ.eq.3 .and. n.gt.4 .and. s(i:i).eq.'/') then
          continue
C quoted text, usually genotypes "a/b"
        elseif (s(i:i).eq.'"') then
          iarg=-1
C skip leading blanks within quotes
   35     continue
            i=i+1
          if (i.lt.eol .and. s(i:i).eq.' ') goto 35
          sarg=i
   45     continue
          if (i.gt.eol .or. s(i:i).eq.'"') goto 70
            iarg=iarg+1
            i=i+1
          goto 45
   70     continue
          arg(n)=s(sarg:(sarg+iarg))
          n=n+1
C any other character must start a word so read up to next boundary
        elseif (s(i:i).ne.' ' .and. s(i:i).ne.'\t') then
          iarg=-1
          sarg=i
   50     continue
          if (i.gt.eol .or. s(i:i).eq.' ' .or. s(i:i).eq.'\t' .or.
     2        s(i:i).eq.'"' .or. 
     3        (typ.eq.2 .and. opchar(s(i:i))) .or.
     4        (typ.eq.3 .and. s(i:i).eq.'/')) then
            i=i-1
            goto 60
          end if
            iarg=iarg+1
            i=i+1
          goto 50
   60     continue
C        
          arg(n)=s(sarg:(sarg+iarg))
          n=n+1
        end if
        i=i+1
      goto 30
   40 continue
C
C return # arguments actually found 
      narg=n-1
      return
      end 
C end-of-arg
C
C is a reserved character for primitives?  "()*+-/<=>^"
C
      logical function opchar(ch)
      character*1 ch
      integer ich
C functions
      integer ichar
      ich=ichar(ch)
      opchar=((ich.ge.40 .and. ich.le.43) .or. ich.eq.45 .or. 
     &  ich.eq.47 .or. (ich.ge.60 .and. ich.le.62) .or. ich.eq.94)
      return
      end
C end-of-opchar
C
C character to integer conversion via internal read
C
      integer function ival(string)
      integer MISS
      parameter(MISS=-9999)
      character*20 string
      integer i
      if (string.eq.' ') then
        ival=0
      elseif (string.eq.'x' .or. string.eq.'X' .or. string.eq.'.') then
        ival=MISS
      else
        read(string,'(i20)',err=10) i
        ival=i
      end if 
      return
C error -- word is not an integer
   10 write(*,'(2a/)') 'ERROR: Unable to read integer ',string
      ival=0
      return
      end
C end-of-ival
C
C character to float conversion via internal read
C
      double precision function fval(string)
      integer BLANK, MISS
      parameter(BLANK=-9999,MISS=-9999)
      character*20 string
      double precision v

      if (string.eq.' ' .or. string.eq.'-') then
        fval=BLANK
      elseif (string.eq.'x' .or. string.eq.'X' .or. string.eq.'.') then
        fval=MISS
      elseif (string.eq.'y' .or. string.eq.'Y') then
        fval=2.0
      elseif (string.eq.'n' .or. string.eq.'N') then
        fval=1.0
      else
        read(string,'(f20.0)',err=10) v
        fval=v
      end if 
      return
C error -- word is not a number
   10 write(*,'(2a/)') 'ERROR: Unable to read real number ',string
      fval=0.0
      return
      end
C end-of-fval
C
C read allele values either numeric or letter code
C
      double precision function aval(string)
      integer BLANK, MISS
      parameter(BLANK=-9999,MISS=-9999)
      character*(*) string
      integer ich
      character*8 fstring
      double precision v
C functions
      integer eow, ichar

      if (string.eq.' ' .or. string.eq.'-') then
        aval=BLANK
      elseif (string.eq.'x' .or. string.eq.'X' .or. string.eq.'.') then
        aval=MISS
C a single character might be a letter code
      else if (eow(string).eq.1) then
        ich=ichar(string(1:1))
C a single digit
        if (ich.ge.48 .and. ich.le.57) then
          aval=dfloat(ich-48)
C a letter a-zA-Z maps to 10001..52
        else if ((ich.ge.65 .and. ich.le.90) .or. 
     &           (ich.ge.97 .and. ich.le.122)) then
          aval=dfloat(ich+10000)
        else 
          aval=MISS
        end if
      else
        call wrform('f', len(string), 0, fstring)
        read(string,fstring,err=10) v
        aval=v
      end if 
      return
C error -- word is not a number
   10 write(*,'(2a/)') 'ERROR: Unable to interpret allele ',string
      aval=MISS
      return
      end
C end-of-aval
C
C skip leading whitespace
C
      integer function sow(string)
      character*(*) string
      do 10 i=1,len(string)
   10   if (string(i:i).ne.' ' .and. string(i:i).ne.'\t') goto 20
   20 sow=i
      return
      end
C
C find end of string
C
      integer function eow(string)
      character*(*) string
      do 10 i=len(string),1,-1
   10   if (string(i:i).ne.' ') goto 20
   20 eow=i
      return
      end
C end-of-eow
C
C scrub non-ASCII characters
C
      subroutine sclean(string)
      character*(*) string
      do 10 i=1,len(string)
      if (ichar(string(i:i)).lt.32) then
        string(i:i)=' '
      end if
   10 continue
      return
      end
C
C Justify a string of characters within a string
C
      subroutine juststr(just,string,length)
      integer length
      character*1 just
      character*(*) string
      integer fin,i,j,sta

      sta=0
   10 continue
        sta=sta+1
      if (string(sta:sta).eq.' '.and. sta.le.length) goto 10
      fin=length+1
   20 continue
        fin=fin-1
      if (string(fin:fin).eq.' '.and. fin.gt.0) goto 20
      
      i=length-fin+sta
      if (just.eq.'c') then
        i=(i+1)/2
      elseif (just.eq.'l') then
        i=1
      end if
      j=i+fin-sta
C This seems to be quickest
      string(i:j)=string(sta:fin)
      string(1:i-1)=' '
      string(j+1:length)=' '
      return
      end
C end-of-juststr
C
C find a character in a string
C
      integer function chfind(ch, string)
      character*1 ch
      character*(*) string
      integer lent
C functions
      integer eow
      lent=eow(string)
      do 10 chfind=1, lent
        if (ch.eq.string(chfind:chfind)) return
   10 continue
      chfind=0
      return
      end
C
C Compare string to a search string, allowing wildcards '*.', and case
C matching
C
      logical function strfind(regexp, targt, nocase)
      character*(*) regexp, targt
      integer nocase
      integer i, ich1, ich2, lenr, lent, pos, wpos
      logical looking, wild
C functions
      integer eow, ichar
      
      lenr=eow(regexp)
      lent=eow(targt)
C while regexp and target not exhausted
      i=1  
      pos=1
      wpos=0
      wild=.false.
      looking=.true.
      strfind=.true.
   10 continue
C
C     write(*,*)
C    2 regexp(1:(pos-1)),'[',regexp(pos:pos),']',regexp((pos+1):lenr),
C    3 ' ',targt(1:(i-1)),'[',targt(i:i),']',targt((i+1):lent),' ',
C    4 wild, looking, strfind
C     
        if (regexp(pos:pos).eq.'*') then
          wild=.true.
          wpos=pos
          pos=pos+1
          looking=(pos.le.lenr) 
        else
C this character matches?
          if (regexp(pos:pos).eq.'.') then
            strfind=.true.
          elseif (nocase.eq.2) then
            ich1=ichar(regexp(pos:pos))
            ich2=ichar(targt(i:i))
            if (ich1.ge.65 .and. ich1.le.90) ich1=ich1+32
            if (ich2.ge.65 .and. ich2.le.90) ich2=ich2+32
            strfind=(ich1 .eq. ich2)
          else
            strfind=(regexp(pos:pos).eq.targt(i:i))
          end if
          looking=strfind
          if (wild) then
            looking=.true.
            if (strfind) then
              wild=.false.
            else
              pos=wpos
            end if
          end if
          pos=pos+1
          i=i+1
C target exhausted? If regexp ends in wild card, then found
          if (i.gt.lent) then
            looking=.false.
            if (regexp(pos:pos).eq.'*' .and. pos.eq.lenr) wild=.true.
            if (pos.le.lenr .and. .not.wild) strfind=.false.
          end if
C regexp exhausted? If regexp doesn't end in wild card, then not found
          if (pos.gt.lenr) then
            looking=.false.
            if (i.le.lent .and. .not.wild) strfind=.false.
C if not exhausted and only partial match and previous wild card, then recycle
          else if (.not.strfind .and. wpos.ne.0 .and. i.le.lent) then
            looking=.true.
            pos=wpos+1
          end if
        end if
      if (looking) goto 10

      return
      end
C end-of-strfind
C
C copy words to a string
      subroutine annotate(sta,fin, words, note)
      integer fin, sta
      character*(*) note, words(*)
      integer i, nlen, pos, wlen
C functions
      integer eow

      nlen=len(note)
      pos=1
      do 10 i=sta, fin
        wlen=eow(words(i))
        if ((pos+wlen).le.nlen) then
          note(pos:(pos+wlen))=words(i)(1:wlen)
        else 
          note(pos:nlen)=words(i)(1:(nlen-pos+1))
          return
        end if
        pos=pos+wlen+1
   10 continue
      return
      end
C end-of-annotate
C
C create a shorter unique version of a string eg locus name
C MENDEL for instance wants 8 character locus names
C
      subroutine shorten(idx, nwords, words, newlen, res)
      integer idx, newlen, nwords
      character*(*) res, words(nwords)
      integer i, ncopies, nindch, offset
C functions
      integer eow

      res=words(idx)(1:newlen)
      if (eow(words(idx)).lt.newlen) return

      ncopies=0    
      do 10 i=1, nwords
      if (words(i)(1:newlen).eq.res) then
        ncopies=ncopies+1
      end if
   10 continue
      if (ncopies.gt.1) then
        ncopies=0
        nindch=newlen-1
        do 20 i=1, idx-1
        if (words(i)(1:nindch).eq.res(1:nindch)) then
          ncopies=ncopies+1
        end if
   20   continue
        ncopies=ncopies+1
        if (ncopies.gt.117) then
          write(*,'(4a)') 'ERROR: too many collisions caused by ',
     2                    'truncation of "', 
     3                    words(idx)(1:eow(words(idx))),'".'
        else
          offset=64
          if (ncopies.gt.26) offset=96
          if (ncopies.gt.52) offset=190
          res(newlen:newlen)=char(offset+ncopies)
        end if
      end if

      write(*,'(5a)') 'Shortened "', words(idx)(1:eow(words(idx))), 
     &                '" to "', res(1:eow(res)), '"'
      return
      end
C end-of-shorten
C
C hash an integer to a two character string 01-99,A-Z,a-z,a-z...
C append to name: typ=1, appended with underscore; typ=2, appended directly 
C
      subroutine makeind(typ,idx,eos,los,string)
      integer eos, los, idx, typ
      character*(*) string
      integer d1, d2, i
      character*2 ch
      character*8 fdec

      if (idx.lt.100) then
        write(ch,'(i2.2)') idx
      elseif (idx.lt.776) then
        i=idx-100
        d1=65+i/26
        d2=65+mod(i,26)
        ch(1:1)=char(d1)
        ch(2:2)=char(d2)
      else
        i=idx-776
        d1=i/26
        d2=mod(i,26)
        ch(1:1)=char(97+mod(d1,26))
        ch(2:2)=char(97+mod(d2,26))
      end if

C add number to name if short enough
      if (typ.eq.2 .and. eos.lt.(los-1)) then
        string((eos+1):(eos+2))=ch
      else if (eos.lt.(los-2)) then
        string((eos+1):(eos+1))='_'
        string((eos+2):(eos+3))=ch
      else
C check if danger of nonunique new name
        if (string((los-2):(los-2)).eq.'_' .and. eos.eq.los) then
          d1=1
          do 10 i=2,los
            d1=mod(d1*ichar(string(i:i)),1048576)
   10     continue
          call wrform('i', los, los, fdec)
          write(string, fdec) d1
        end if
        string(3:3)='_'
        string(1:2)=ch
      end if

      return
      end
C end-of-makeind
C
C write id as justified (l,c,r) string, possibly indicating sex
C as male [101] or female (102)
C
      subroutine wrid(just,id,chid,sx)
      integer sx
      character*8 id
      character*1 just
      character*10 chid
C local variables
      integer i
      character*1 left(2),right(2)
C functions
      integer eow

      data left(1),left(2),right(1),right(2) /'[','(',']',')'/

      chid=' '
      if (sx.eq.1 .or. sx.eq.2) then
        i=eow(id)
        chid(1:1)=left(sx)
        chid(2:i+1)=id
        chid(i+2:i+2)=right(sx)
      else
        chid=id
      end if
      call juststr(just,chid,10)
      return
      end
C end-of-wrid
C
C write out allele   
C
      subroutine wrall(iall,allel)
      integer MISS,KNOWN
      parameter(MISS=-9999,KNOWN=0)
      integer iall
      character*(*) allel
      if (iall.eq.MISS) then 
        allel='  x'
      else if (iall.eq.KNOWN) then
        allel='  -'
      else if (abs(iall).gt.10000) then
        allel=char(abs(iall)-10000) 
      else 
        write(allel,'(i3)') abs(iall) 
      end if
      return
      end
C end-of-wrall
C
C write out genotype 
C
      subroutine wrgtp(all1,all2,gtp,typ)
      integer MISS,KNOWN
      parameter(MISS=-9999,KNOWN=0)
      integer all1,all2,typ
      character*(*) gtp
      character*3 sall

      integer isep, mid

      isep=0
      if (all1.lt.KNOWN .and. all1.ne.MISS) isep=2
      mid=len(gtp)/2+1
      gtp=' '
      if (all1.eq.MISS) then 
        sall='  x'
      elseif (all1.eq.KNOWN) then
        sall='  -'
      else
        if (abs(all1).gt.10000) then
          sall=char(abs(all1)-10000) 
        else
          write(sall,'(i3)') abs(all1)
        end if
      end if
      call juststr('r',sall,3)
      gtp((mid-3):(mid-1))=sall

      if (all2.eq.MISS) then 
        sall='x  '
      elseif (all2.eq.KNOWN) then
        sall='-  '
      else
        if (abs(all2).gt.10000) then
          sall=char(abs(all2)-10000) 
        else
          write(sall,'(i3)') abs(all2)
        end if
      end if
      call juststr('l',sall,3)
      gtp((mid+1):(mid+3))=sall

      if (mod(typ,2).eq.1) then
        gtp(mid:mid)='/'
      elseif (isep.ne.0) then
        gtp(mid:mid)=':'
      end if

      return
      end
C end-of-wrgtp
C 
C decode genotype code
      subroutine decgtp(value,g1,g2)
      real value
      integer g1, g2, ival
      ival=int(value)
      g1=ival/1000 
      g2=mod(ival,1000)
      if (g1.lt.0) then
        g1=10128+g1
        g2=10128+g2
      end if
      return
      end
C end-of-decgtp
C hash a genotype
      real function encgtp(a1,a2)
      double precision a1, a2
      if (a1.gt.10000.0d0) then
        a1=a1-10128.0d0
        a2=a2-10128.0d0
      end if
      encgtp=sngl(1000.0d0*a1+a2)
      return
      end
C end-of-encgtp
C
C write out trait value to a string
C
      subroutine wrtrait(value,str,typ, ndec)
      integer ndec, typ
      double precision value
      character*10 str
      integer g1, g2
      character*10 fstring
      if (typ.eq.1 .or. typ.eq.2) then
        call decgtp(sngl(value),g1,g2)
        call wrgtp(g1,g2,str,1)
      else if (typ.eq.4) then
        str='     y'
        if (value.eq.1.0d0) str='     n'
      else
        call wrform('f', 10, ndec, fstring)
        write(str,fstring) value
      end if
      return
      end
C end-of-wrtrait
C
C binary trait as character
C
      subroutine wraff(value,ch)
      double precision value
      character*1 ch
      ch='x'
      if (value .eq. 1.0d0) then
        ch='n'
      elseif (value .eq. 2.0d0) then
        ch='y'
      end if
      return
      end
C end-of-wraff
C
C write sex as character
      subroutine wrsex(sex,ch)
      integer sex
      character*(*) ch
      ch='x'
      if (sex.eq.1) then
        ch='m'
      else if (sex.eq.2) then
        ch='f'
      end if
      return
      end
C end-of-wrsex
C write date as character
      subroutine wrdate(date,str,typ)
      double precision date
      character*(*) str
      integer typ
C function
      double precision togreg
      if (typ.eq.1) then
        write(str,'(i9.9)') int(togreg(date)) 
      else if (typ.eq.2) then
        write(str,'(i9.9)') int(date) 
      end if
      str=str(2:5) // '-' // str(6:7) // '-' // str(8:9)
      return
      end
C end-of-wrdate
C
C Fortran format statement to write one number
C
      subroutine wrform(typ, nwid, ndec, fstring)
      integer ndec, nwid
      character*1 typ
      character*(*) fstring
      character*2 cdec, cwid
C functions
      integer sow

      write(cwid,'(i2)') nwid
      write(cdec,'(i2)') ndec
      write(fstring,'(6a)') 
     &  '(', typ, cwid(sow(cwid):2),'.',cdec(sow(cdec):2),')'
      return
      end
C end-of-wrform
C
C write P-values as a histogram: . + * ** ***
C
      subroutine phist(pval1, pval2, histo)
      double precision pval1, pval2
      character*3 histo
      double precision pval

      pval=min(pval1, pval2)
      histo='.  '
      if (pval.lt.0.0001d0) then
        histo='***'
      elseif (pval.lt.0.001d0) then
        histo='**'
      elseif (pval.lt.0.01d0) then
        histo='*'
      elseif (pval.lt.0.1d0) then
        histo='+'
      end if
      return
      end
C end-of-phist
C 
C write a string with leading "x" if starts with an integer
C Loki and R for example do not allow variable names that start with a digit
C
      subroutine addlet(old, new)
      character*(*) old, new
      character*1 ch
      ch=old(1:1)
      if (ichar(ch).ge.48 .and. ichar(ch).le.57) then
        new='x' // old
      else
        new=old
      end if
      return
      end
C end-of-addlet 
C
C concatenate directory to existing filename
C
      subroutine cat(dirnam,filnam)
      character*(*) dirnam, filnam
      integer len1,len2
C functions
      integer eow

      len1=eow(dirnam)
      if (len1.gt.0) then
        call slash(dirnam,len1)
        len2=eow(filnam)
        if ((len1+len2).gt.len(filnam)) then
          write(*,'(a,i3,a/7x,3a/)') 
     2      'ERROR: Path name exceeds ',len(filnam),' characters.',
     3      'File path remains "',filnam(1:len2),'".'
        else      
          filnam(len1+1:len1+len2+1)=filnam(1:len2)
          filnam(1:len1)=dirnam(1:len1)
        end if
      end if
      return
      end 
C end-of-cat
C
C test what character used to separate directories
C
      subroutine slash(dirnam,lend)
      character*(*) dirnam
      integer lend
      integer i
      character*1 sla

      sla='\\'
      do 10 i=1,lend
      if (dirnam(i:i).eq.'/') then
        sla='/'
        goto 11
      end if
   10 continue
   11 continue
      if (dirnam(lend:lend).ne.sla) then
        lend=lend+1
        dirnam(lend:lend)=sla
      end if
      return
      end
C end-of-slash
C
C create workfile name 8.3 prefix '.' suffix
C
      subroutine uniqnam(seed, filnam, suffix)
      integer seed
      character*(*) filnam
      character*3 suffix
      integer i,j
      j=seed
      filnam='sp------'
      if (len(filnam).lt.12) return
      do 10 i=4,8
        filnam(i:i)=char(97+mod(j,26))
        j=j/26
   10 continue
      filnam(9:9)='.'
      filnam(10:12)=suffix
      return
      end
C end-of-uniqnam
C
C create new workfile name
C
      subroutine newnam(wrknum, wrkfil)
      integer wrknum
      character*(*) wrkfil
      integer j
C functions
      integer eow
      wrknum=wrknum+1
      if (wrknum.eq.10) wrknum=1
      j=eow(wrkfil)
      wrkfil(j:j)=char(48+wrknum)
      return
      end
C end-of-newnam
C
C Create a new file (deleting old instances of that name
C
      subroutine mknewfil(str, filnam, wrkdir)
      integer str
      character*(*) filnam, wrkdir
      logical filexist

      call cat(wrkdir,filnam)
      inquire(file=filnam,exist=filexist)
      if (filexist) then
        open(str,file=filnam)
        close(str,status='delete')
      end if
      return
      end
C end-of-mknewfil
C
C Open the standard log file "sib-pair.log"
C
      subroutine openlog(lstr, nhis)
      integer lstr, nhis
      logical filexist
      inquire(unit=lstr,opened=filexist)
      if (filexist) then
        write(*,'(a)') 
     &    'NOTE:  Log stream was in use.  Closing and reopening!'
        close(lstr,status='keep')
      end if
      inquire(file='sib-pair.log',exist=filexist)
      if (filexist) then
        open(lstr, file='sib-pair.log')
        close(lstr, status='delete')
      end if
      open(lstr, file='sib-pair.log', status='new')
      nhis=0
      return
      end
C end-of-openlog 
C
C Write out program information
C
      subroutine info(burnin,imp,iter,ix,iy,iz,mapf,mincnt,plevel,
     2             showorig,addsex,chek,droperr,prompt,use2,
     3             datdir,version,wrkdir)
      integer HAPSIZ, IBDSIZ, LINSIZ, MAXALL, MAXG, MAXHAP,  
     &        MAXIBD, MAXSIZ, MAXLOC, MISS, WRKSIZ
      parameter(LINSIZ=1024, MAXALL=60, MAXG=MAXALL*(MAXALL+1)/2, 
     2   MAXSIZ=1000, MAXLOC=120, MAXHAP=MAXLOC/2, MISS=-9999, 
     3   MAXCOL=MAXLOC+5, HAPSIZ=MAXSIZ*MAXLOC,WRKSIZ=MAXSIZ*MAXG*2,
     4   MAXIBD=1000, IBDSIZ=MAXIBD*(MAXIBD+1)/2)
      integer burnin, droperr, imp, iter, ix, iy, iz, mapf, 
     &        mincnt, plevel, showorig, use2, wrkspace
      logical addsex, chek, prompt
      character*40 version
      character*40 datdir,wrkdir 
      character*7 map(2)

      data map(1)/'Haldane'/,map(2)/'Kosambi'/

      wrkspace=max(WRKSIZ, HAPSIZ+7*MAXSIZ+10*MAXG+5*MAXALL+3*IBDSIZ)
     &         +MAXSIZ*(MAXLOC+4)
      write(*,'(2a/)') 
     &        'Program version      = ',version
      write(*,'(6(a,i5/))') 
     2        'Maximum record length= ',LINSIZ,
     3        'Maximum pedigree size= ',MAXSIZ,
     4        'Maximum # phenotypes = ',MAXLOC,
     5        'Maximum # alleles    = ',MAXALL,
     6        'Maximum # genotypes  = ',MAXG,
     7        'Maximum # haplotypes = ',MAXHAP
      write(*,'(3(a,i5/))')
     2        'Imputation level     = ',imp,
     3        'Simple Mendel checks = ',chek,
     4        'Drop incon. genotypes= ',droperr
      write(*,'(4(a,i5/),a,3(1x,i5)/)') 
     2        'No. parents for TDT >= ',use2,
     3        'Maximum MC iterations= ',iter,
     4        'Min numerator P-value= ',mincnt,
     5        'Burn-in MC iterations= ',burnin,
     6        'Seeds for RNG (AS183)=',ix,iy,iz
      write(*,'(a,i5,a/)')    
     2        'Main workspace size  = ', wrkspace/256,' kB'
      write(*,'(a,l5/a,l5/a,i5/a,i5/)')    
     2        'Add dummy var for sex= ',addsex,
     3        'Show prompt string   = ',prompt,
     4        'Output detail level  = ',plevel,
     5        'Haplotype detail lvl = ',showorig
      write(*,'(2(2a/))')    
     2        'Data file directory  = ',datdir,
     3        'Work file directory  = ',wrkdir
      write(*,'(2a/)') 
     &        'Map function         = ',map(mapf)
      return
      end
C end-of-info
C
C brief online help
C
      subroutine help(typ, regexp, lin, twrk)
      integer LINSIZ
      parameter (LINSIZ=1024)
      integer typ, twrk
      character*20 regexp
      character*(LINSIZ) lin

      integer i, lenr, strm
      character*12 wrkfil
C functions
      integer eow
      logical strfind

      strm=6
      wrkfil='sib-pair.hlp'
      if (typ.ge.7) then
        strm=twrk
        open(strm,file=wrkfil,status='unknown')
      end if
        
C
      if (typ.eq.6) then
        write(strm,'(a/a//a//a//a)')
     2  'Keywords can be shortened to the first 3 letters.',
     3  'Help prints a brief summary of all commands:',
     4  '  help [<key> | All | Globals | Operators | Data | Analysis]',
     5  'For full online help:',
     6  '  $ your_favourite_HTML_browser sib-pair.html'
        return
      end if
      if (typ.eq.1 .or. typ.eq.2 .or. typ.eq.7) then
        write(strm,'(a)') 
     2  '*Globals*','!|# {comment}', '%|$ {shell command}', 
     3  'hel [<key>|Al|Gl|Op|Da|An] {help}','qui|bye {exit}',
     4  'cle {reset}','inc|loc <fil> {include commands}',
     5  'lis|ls <loc1>.[to]..<locN> [$(m|x|q|a)[rm]] {list loci}' ,
     6  'las <line no> {cmd history}', 
     7  'sho [map|ped] {show current marker map|peds}' 
        write(strm,'(a)') 
     2  'inf {program info}', 'las [<num>] {command history}', 
     3  'tim {total elapsed time}',
     4  'set tim [on|off] {time procedures}',
     5  'set epo [jul|iso|mjd|<epo>] {set epoch for Julian dates}'
       write(strm,'(a)') 
     2  'set pro [on|off] {display prompt}','set ech [on|off] {echo}',
     3  'set out|ple -1|0|1|2|ver|on|off {output verbosity}',
     4  'set hap 0|1|2|ver|on|off {haplotype detail}',
     5  'set nde [<nwid>] <ndec> {output pedigree decimal digits}',
     6  'set wei fou {weight allele frequencies}' 
       write(strm,'(a)') 
     2  'set ite|bur|emi <it> {maximum MC|burn-in|EM iters}',
     3  'set tun <tun> {MCMC proposal tuner}',
     4  'set bat <num> {number of MCMC batches}',
     5  'set cha <num> {number of MCMC chains}',
     6  'set min <num> {required numerator approximate P-values}' 
       write(strm,'(a)') 
     2  'set see <s1> <s2> <s3> {RNG seeds}',
     3  'set err [on|off] {remove nuclear family mendelian errors}', 
     4  'set tdt both|one|fir {parents typed for TDT}',
     5  'set hre zero|chi {assume zero recomb for phased LD model}' 
       write(strm,'(a)') 
     2  'set map fun kos|hal {set mapping function}',
     3  'pch <x2> <df> {Chi-square P-value}',
     4  'chi <nr> <nc> {Contingency Chi-square}',
     5  'pro <num> <den> [<width>] {CI for proportion}' 
       write(strm,'(a)') 
     2  'sml <pA> <penAA> <penAB> <penBB> {recurrence risks}',
     3  'grr <prev> <pA> <GRR> [<add|dom|rec>] {recurrence risks}' 
      end if
      if (typ.eq.1 .or. typ.eq.3 .or. typ.eq.7) then
        write(strm,'(a)') '*Operators/functions*',
     3  ' ( ) if then else * / + - ^ = not and or < > ge le ne eq',
     4  ' >= <= ^= == neg pos abs sqrt log exp sin cos tan asin acos',
     5  ' atan inht int round rand rnorm pi y n x "<all>/<all>"' 
       write(strm,'(a)') 
     2  ' istyp|untyp <mar>    {genotype available this person?}',
     3  ' ishom|ishet <mar>    {hom/het genotype?}',
     4  ' alla|allb <mar>      {first/second allele of genotype}',
     5  ' anytyp alltyp numtyp {available active markers? no. typed}',
     6  ' commar               {max markers typed common to rels}' 
       write(strm,'(a)') 
     2  ' isfou isnon          {founder/nonfounder?}',
     3  ' female male          {male/female?}',
     4  ' num nfoun            {family size/no. founders}',
     5  ' famnum index         {family no. 1..n, person no. 1..n}'
      end if
      if (typ.eq.1 .or. typ.eq.4 .or. typ.eq.7) then
        write(strm,'(a)') 
     2  '*Data*','set dat|wor <path> {data | work directory}',
     3  'set imp 0|1|2|3|off|on {impute unmeasured genotypes}',
     4  'set loc <nam> mar|xma|qua|aff {declare locus position,type}',
     5  'ren <loc> [to] <new> {rename locus}',
     6  'rea ped <fil>|inline [ski <n>] {declare pedigree file}' 
        write(strm,'(a)') 
     2  'rea lin|ppd <fil>|inline {declare pedigree file Linkage type}',
     3  'rea loc lin <fil> {read Linkage locus position,type,map}',
     4  'rea loc mer <fil> {read Merlin locus file}' 
        write(strm,'(a)') 
     2  'rea map <fil> {read map, guessing format}',
     3  'set map <pos1>...<posN> {set marker map positions}',
     4  'set dis <dis12> <dis23>...<disN-1N> {set map distances (cM)}',
     5  'ord <loc1>.[to]..<locN> [$(m|x|q|a)[rm]] {reorder loci}' 
        write(strm,'(a)') 
     2  'set sex on {add dummy variable}',
     3  'set twi <twin> {MZ twin indicator}',
     4  'run {process pedigree data}', 
     5  'kee <loc1>.[to]..<locN> [$m|x|q|a] {retain loci in analysis}',
     6  'dro <loc1>.[to]..<locN> [$m|x|q|a] {drop loci from analysis}' 
        write(strm,'(2a)') 
     2  'kee|dro whe mon|max <frq>|num <ntyp>|dis <dis>|eve <Nth>|',
     3  '<str> {keep useful loci}',
     4  'und [<loc1>.[to]..<locN> [$m|x|q|a]] ',
     5  '{return loci to analysis}'
        write(strm,'(a)')
     2  'sel [con|exa <npro> whe] <expr> {select pedigrees}',
     3  'sel [ped|id] [not [in]] <ped1>...<pedN> {select on name}',
     4  'uns {return pedigrees to analysis}',
     5  'pac [loc|ped] {delete dropped pedigrees and loci permanently}',
     6  'rec [<mar>|$(m|x)] [fre] {recode alleles to 1..n by size/freq}'
        write(strm,'(a)')
     2  'rec <loc> <val1>...<valN> to <new> {recode old values to new}',
     3  'com <mar1>...<marN> [<thr>] {recode rare alleles}',
     4  'tra <loc> <div> <sub> <pow> <lo> <hi> {power transform}',
     5  'ran <tra> <rank> {rank trait or genotype values}',
     6  'kap <tra> <cen> [res] {survivor function estimate}'  
        write(strm,'(a)')
     2  'dat (<yyyymmdd> jul)|(<num> gre) {julian date conversion}',
     3  'dat [<tra>] [jul|gre|yea] {julian date conversion}' ,
     4  'adj <tra> on <loc1> [to <xval>|m|f] {linear regress adjust}' ,
     5  'res <tra> on <loc1>...<locN> [com] {linear regress resid}',
     6  'pre <tra> on <loc1>...<locN> [com] {linear regress predicted}',
     7  'imp <tra> on <loc1>...<locN> [com] {linear regress imputation}'
        write(strm,'(a)')
     2  'edi <ped> <per>|all <loc> [to] <val1> [<val2>] {edit data}',
     3  'del <ped> <per>|all {set all data missing for person or}',
     4  'del [<loc1>...<locN>] whe <expr> {set selected data missing}',
     5  'sta <loc> [fam] {standardize trait value}' 
        write(strm,'(a)')
     2  'sim <mar> [<linked_to>] [<Nall>|<frq1>.<frqN>] {sim a marker}',
     3  'sim <tra> [<h2>] [<linked_to>] {sim a trait}'
        write(strm,'(a)')
     2  'nuc [<maxsibs>] [gra] {convert to (trimmed) nuclear families}',
     3  'sub {divide into subpedigrees (if compound)}', 
     4  'pru <tra> [c_op <thr>] {prune unaffecteds}' ,
     5  'cas <tra> {divide into unrelated cases}' ,
     6  'uni [seq] {generate numerical IDs}' 
        write(strm,'(a)')
     2  'pri ped <ped1>...<pedN> [id <id1>...<idN>] {print data}',
     3  'wri {print data}', 'hea {print head of pedigree file}',
     4  'wri pap {write PAP trip.dat and phen.dat}',
     5  'wri ram <tra> {write LDL_rams ped and dat files}',
     6  'wri [gas] <fil> {write GAS type ped file}',
     7  'wri csv|sol <fil> [phe] [nop] {write CSV type file}'
        write(strm,'(2a)')
     2  'wri arl [par|all]|asp|cri|dot [<tra> [<gen>]]|fis <fil>',
     3  ' {write ped file}',
     4  'wri gda|(gh|lin|ppd) [dum]|men|mim|ped|phe|sag|tcl <fil>',
     5  ' {write ped file}',
     6  'wri loc asp|ecl|fis|gas|gh [dum]|lin [dum]|lok|men|mer|rel|',
     7  'sag|tcl <fil> [xli|<chr>] {write locus file}'  
        write(strm,'(a)')
     2  'wri loc sib <fil> [<pedfil>] {write Sib-pair script}',
     3  'wri loc pap {write PAP header.dat and popln.dat}' ,
     4  'wri map men|mer|lok|sol <fil> {write MENDEL... map file}',
     5  'wri var [men] <fil> {write MENDEL var file}' 
      end if
      if (typ.eq.1 .or. typ.eq.5 .or. typ.eq.7) then
        write(strm,'(a)')
     2  '*Analysis*','gen [<ped>] {summarize pedigree(s)}',
     3  'rel <ped> <id> {show immediate relatives of index}',
     4  'anc <tra> [c_op <thr>] {common ancestor of most probands}',
     5  'cou|pri [whe] <expr> {count or print where expression true}' 
        write(strm,'(a)')
     2  'hap [<bin tra>] {show sibship haplotypes}',
     3  'tri {show triad-phaseable haplotypes}',
     4  'fre|des [snp|<loc1>..<locN>] {descriptive statistics}',
     5  'his <qua tra> {histogram and normality test}'  
        write(strm,'(a)')
     2  'mea|cor [<loc1>..<locN>] {phenotypic means and correlations}',
     3  'mix <qua tra> [[<num>] [nor|poo|exp|poi]] {test admixture}', 
     4  'tab <tr1> [<tr2>...<trN>] {contingency table}', 
     5  'kru <qua tra> <loc> {Kruskall-Wallis test}' 
        write(strm,'(2a)')
     2  'reg <tra> on <loc1>.[to]..<locN> [off <off>] [poisson]',
     3  ' {linear/logistic/poisson regression}' 
       write(strm,'(a)')
     2  'dav <tra> <pro> {segregation ratios under ascertainment}', 
     3  'hwe [fou] {test HWE}',
     4  'dis|ld <loc1> <loc2> {intragametic association}',
     5  'hom [<tra> [<c_op> <thr>]] {marker homozygosity}',
     6  'mul [<tra> [<c_op> <thr>]] {multipoint homozygosity}' 
       write(strm,'(a)')
     2  'kin [pai|inb] [<tra> [c_op <thr>]] {kinship/inbreeding coefs}',
     3  'ib[s|d] <loc> [pai] {relative pair ibs/ibd sharing at marker}',
     4  'hbd <loc> [<coe>] {homozygosity-by-descent at marker}', 
     5  'mcf <mar1> [..<marN>] {MCEM allele frequencies}',
     6  'mcm <mar> <ped> <id1>..<idN> {MCMC genotype distribution}' 
       write(strm,'(a)')
     4  'cki {sib pair ibs sharing at multiple markers}', 
     5  'sha {rel pair ibs sharing at multiple markers}' 
       write(strm,'(2a)')
     2  'mzt <tra> [<c_op> <thr>] [del|cle]',
     3  ' {MZ pair genotype discordance|drop one member}',
     4  'ass <tra> [<c_op> <thr>] [fou] [gen] [cov <cov>]',
     5  ' {allelic/genotypic assoc}' 
       write(strm,'(a)')
     2  'hrr <tra> [<c_op> <thr>] {HRR}',
     3  'tdt <tra> [<c_op> <thr>] [pat|mat] {several TDTs}',
     4  'sch <tra> <mar> [<all>] {Schaid & Sommer HWE test}',
     5  'asp <tra> [<c_op> <thr>] {affected sib-pair IBS}', 
     6  'apm <tra> [<c_op> <thr>] [ibd|ibs] {IBS or IBD APM}' 
       write(strm,'(2a/a/a/a)')
     2  'sib <tra> [<wei>] [sim] [cor <r> [mea <m>]',
     3  ' [sd|var <v>]] {S&P QTL linkage}',
     4  'vis <tra> [<wei>] [sim] {V&H H-E regression}',
     5  'he1 <tra> [<wei>] [sim] {Trad H-E regression}',
     6  'he2 <tra> [<wei>] [sim] {Cross-product H-E regression}',
     7  'two <tra> <loc1> <loc2> <theta> {two-point Haseman-Elston}' 
       write(strm,'(2a)')
     2  'qtl <tra> [full [cqe] [cov <var1>..<varN>]]',
     3  ' {sibs or pedigree VC linkage}',
     4  'var <tra> [[a][c][d]e] [cov <var1>..<varN>]',
     5  ' {Variance Components trait analysis}'
       write(strm,'(a)')
     5  'lrt {Compare last 2 models fitted (VC/GLM/GLMM)}',
     6  'blu <tra> <h2> {BLUP for AE variance components model}' 
       write(strm,'(2a)')
     2  'fpm <tra>  [<c_op> <thr>] [nqtl <nqtl>] [p] [a] [d] [g] [c]',
     3  ' [s] {MCMC mixed/SML/finite polygenic model}' 
       write(strm,'(2a)')
     2  'fpm <tra> ... [(p|g|a|c|s)va|AA|AB|BB|mu|var <val>]',
     3  ' {MCMC fpm start values}' 
       write(strm,'(2a)')
     2  'fpm <tra> ... [fixed p|a|c|d|e|g|m|mu|s|var',
     3  ' {MCMC fpm fixed pars}' 
       write(strm,'(2a)')
     2  'fpm <tra> ... [lin logit|probit|ln|mft] [lik gau|bin|poi] ',
     3  ' [cov <var1> [+ <var2>...] {MCMC fpm GLMM pars}' 
      end if

      if (typ.ge.7) then
        lenr=eow(regexp)
        do 5 i=lenr,1,-1
          regexp((i+1):(i+1))=regexp(i:i)
    5   continue
        regexp(1:1)='*'
        lenr=min(20,lenr+2)
        regexp(lenr:lenr)='*'

        rewind(strm)
   10   continue
          read(strm,'(a)',end=20) lin
          if (strfind(regexp, lin, 2)) then
            write(*,'(a)') lin(1:eow(lin))
          end if
        goto 10
   20   continue
        close(strm,status='delete')
      end if
      return
      end
C end-of-help
C pass line to shell -- requires existence of fairly 
C                       standard routine system()
C
      subroutine shell(lin)
      character*(*) lin
      integer sta,fin
      sta=0
    5 continue
        sta=sta+1
      if (lin(sta:sta).ne.'$' .and. lin(sta:sta).ne.'%') goto 5
    7 continue
        sta=sta+1
      if (lin(sta:sta).eq.' ') goto 7
      fin=len(lin)
   10 continue
        fin=fin-1
      if (lin(fin:fin).eq.' ') goto 10
      write(*,'(a/3a/a)') '!','! "',lin(sta:min(fin,75)),'"','!'
      call system(lin(sta:fin))
      return
      end
C end-of-shell
C
C write elapsed time since last asked
C
      subroutine stamp(t0)
      integer elapsed, t0
C functions
#if defined (F2C) || defined (G95)
      integer time
      elapsed=time()-t0
#else
      real secnds
      elapsed=int(secnds(float(t0)))
#endif /* F2C */
      if (elapsed.lt.120) then
        write(*,'(/a,i5,a)') 
     &    'This job took ',elapsed,' seconds'
      elseif (elapsed.lt.7200) then
        write(*,'(/a,f5.1,a)') 
     &    'This job took ',float(elapsed)/60.0,' minutes'
      else
        write(*,'(/a,f5.1,a)') 
     &    'This job took ',float(elapsed)/3600.0,' hours'
      end if
      return
      end
C end-of-stamp
C
C time a procedure
      subroutine proct(t1,plevel)
      integer plevel
      real t1, t2
C functions 
#ifdef F2C
      real second 
      t2=second()
#elif defined (G95)
      real secnds
      t2=real(secnds(0.0))
#else
      real secnds
      t2=secnds()
#endif /* F2C */
      if (plevel.ne.0) write(*,'(a,f7.2,a)') '[',t2-t1,' s]'
      t1=t2
      return
      end
C end-of-proct
C
C determine if trait being compared to a constant, for isaff
C
      logical function iscomp(op)
      character*(*) op
      iscomp=(op.eq.'<' .or. op.eq.'>' .or. op.eq.'lt' .or. 
     3        op.eq.'gt' .or. op.eq.'und' .or. op.eq.'ove' .or. 
     4        op.eq.'>=' .or. op.eq.'<=' .or. op.eq.'le' .or. 
     6        op.eq.'ge' .or. op.eq.'ne' .or. op.eq.'^=' .or. 
     7        op.eq.'==' .or.op.eq.'eq')
      return  
      end
C end-of-iscomp
C
C parse comparison in isaff 
C 15='<', 16='>', 17='ge', 18='le',19='ne',20='eq' 
C
      subroutine docomp(pos, words, gt, thresh)
      integer MAXLOC, MAXCOL
      parameter (MAXLOC=120, MAXCOL=MAXLOC+5)
      integer gt, pos
      double precision thresh
      character*20 words(MAXCOL)
      character*3 op
      integer tpos
C functions
      integer eow
      logical iscomp
      double precision fval
      gt=0
      tpos=pos+1
      op=words(pos)(1:3)
      if (iscomp(words(tpos))) then
        op=op(1:eow(op)) // words(tpos)(1:eow(words(tpos)))
        tpos=tpos+1
      end if
      if (op.eq.'<' .or. op.eq.'lt' .or. op.eq.'und') then
        gt=15
      elseif (op.eq.'>' .or. op.eq.'gt' .or. 
     &        op.eq.'ove') then
        gt=16
      elseif (op.eq.'>=' .or. op.eq.'ge') then 
        gt=17
      elseif (op.eq.'<=' .or. op.eq.'le') then 
        gt=18
      elseif (op.eq.'^=' .or. op.eq.'ne') then 
        gt=19
      elseif (op.eq.'==' .or. op.eq.'eq') then 
        gt=20
      end if
      thresh=fval(words(tpos))
      pos=tpos+1
      return
      end
C end-of-docomp
C
C Message defining proband based on comparison
      subroutine defpro(gt, thresh)
      integer gt
      double precision thresh
      character*2 ctok(6)
      data ctok /' <',' >','>=','<=','^=','=='/
C
      write(*,'(2a,1x,f9.4/)') 
     &  'NOTE:  Proband defined as trait value ', ctok(gt-14), thresh
      return
      end
C end-of-descmp
C
C determine if index person is affected or unaffected
C
      double precision function isaff(val,thresh,gt)
      integer MISS
      parameter(MISS=-9999)
      integer gt
      double precision val, thresh

      isaff=val
      if (thresh.ne.MISS .and. isaff.ne.MISS) then
        if (gt.eq.15 .and. isaff.lt.thresh) then
          isaff=2.0d0
        elseif (gt.eq.16 .and. isaff.gt.thresh) then
          isaff=2.0d0
        elseif (gt.eq.17 .and. isaff.ge.thresh) then
          isaff=2.0d0
        elseif (gt.eq.18 .and. isaff.le.thresh) then
          isaff=2.0d0
        elseif (gt.eq.19 .and. isaff.ne.thresh) then
          isaff=2.0d0
        elseif (gt.eq.20 .and. isaff.eq.thresh) then
          isaff=2.0d0
        else
          isaff=1.0d0
        end if
      end if
      return
      end
C end-of-isaff
C
C swap alleles so ordered consistently
C      
      subroutine order(all1,all2)
      integer all1,all2,swp
      if (all1.gt.all2) then
         swp=all1
         all1=all2
         all2=swp
      end if
      return
      end
C end-of-order
C
C swap alleles
C      
      subroutine swap(all1,all2)
      integer all1,all2,swp
      swp=all1
      all1=all2
      all2=swp
      return
      end
C end-of-swap 
C
C determine if word is name of a trait locus
C typ1=10, any locus type
C typ1,typ2=1..5, that locus type only
C
      subroutine gettrait(nam,typ1,typ2,nloci,loc,loctyp,trait)
      integer MAXLOC, MISS
      parameter(MAXLOC=120, MISS=-9999)
      character*20 nam
      integer nloci, trait, typ1, typ2
      character*20 loc(MAXLOC)
      integer loctyp(MAXLOC)
      integer i
C functions
      integer eow, ival
      logical isreal

      trait=MISS
      if (nam.eq.' ') return
      if (isreal(nam)) then
        trait=ival(nam)
        if (trait.le.0 .or. trait.gt.nloci) trait=MISS
      else    
        do 5 i=1,nloci
        if (nam.eq.loc(i)) then
          trait=i
          goto 6
        end if
    5   continue
    6   continue
      end if
      if (trait.eq.MISS) then
        write(*,'(/3a)') 'NOTE:  Unable to find requested variable "', 
     &                     nam(1:eow(nam)),'".'
      else if (loctyp(trait).gt.4 .and. typ1.ne.20) then
        write(*,'(/3a)') 'NOTE:  "', loc(trait)(1:eow(loc(trait))),
     &    '" is currently dropped from analysis.'
        trait=MISS
      else if (loctyp(trait).ne.typ1 .and. typ1.ne.10 .and.
     &         loctyp(trait).ne.typ2 .and. typ1.ne.20) then
        write(*,'(/3a)') 'NOTE:  "', loc(trait)(1:eow(loc(trait))),
     &    '" is inappropriate locus type for requested procedure.'
        trait=MISS
      end if
      return  
      end
C end-of-gettrait
C
C check if name is not already used or reserved
C
      logical function isinuse(string, nloci, loc, token, env)
      integer ENVNUM, MAXLOC, TOKNUM
      parameter (ENVNUM=12,MAXLOC=120,TOKNUM=46)
      integer nloci
      character*(*) string
      character*6 token(TOKNUM), env(ENVNUM)
      character*20 loc(MAXLOC)
      integer i
C functions
      logical isreal

      isinuse=.false.
      do 5 i=1, nloci
      if (loc(i).eq.string) then
        isinuse=.true.
      end if
    5 continue
      do 10 i=1, TOKNUM
      if (token(i).eq.string) then
        isinuse=.true.
      end if
   10 continue
      do 15 i=1, ENVNUM
      if (env(i).eq.string) then
        isinuse=.true.
      end if
   15 continue
      if (isreal(string)) isinuse=.true.
      return
      end
C end-of-isinuse
C
C Get a single binary trait or dichotomized quantitative trait
C
      subroutine getbin(sta,fin,words,nloci,loc,loctyp,
     &                  trait,gt,thresh)
      integer MAXLOC, MISS
      parameter(MAXLOC=120, MISS=-9999)
      integer fin, gt, nloci, sta, trait
      character*20 words(fin)  
      double precision thresh
      character*20 loc(MAXLOC)
      integer loctyp(MAXLOC)
      integer i
      character*3 keyword
C functions
      logical iscomp

      call gettrait(words(sta),3,4,nloci,loc,loctyp,trait)

      gt=0
      thresh=MISS
      i=sta+1
   10 continue
        keyword=words(i)(1:3)
        if (iscomp(keyword)) then
          call docomp(i, words, gt, thresh)
        else
          i=i+1
        end if  
      if (i .lt. fin) goto 10
      if (trait.ne.MISS .and. thresh.eq.MISS .and. 
     &    loctyp(trait).eq.3) then
        trait=MISS
      end if
      return
      end
C end-of-getbin
C
C load list of traits into an array
C
      subroutine loadnam(sta,fin,words,nloci,loc,loctyp,map,chosen,
     &                   nterms,terms,typ)
      integer MAXLOC
      parameter(MAXLOC=120)

      integer fin, nloci, sta, typ
      integer chosen(*)
      integer nterms, terms(*)
      character*20 words(fin)  
      character*20 loc(MAXLOC)
      integer loctyp(MAXLOC)
      real map(MAXLOC)
C local variables
      integer i, locnum, nmark, offset, pos, span
      integer be, dir, en
      logical bymap
      integer imap(MAXLOC), ord(MAXLOC)
C functions 
      integer chfind, ival
      logical isreal, strfind

      bymap=.false.
      do 1 locnum=1, nloci
        chosen(locnum)=0
    1 continue
      nterms=0
C empty list is all loci
      if (sta.gt.fin) then
        if (typ.eq.1) then
          do 5 locnum=1,nloci
          if (loctyp(locnum).le.4) then
            nterms=nterms+1
            chosen(locnum)=nterms
          end if
    5     continue
        else if (typ.eq.2) then
          do 6 locnum=1,nloci
          if (loctyp(locnum).ge.5) then
            nterms=nterms+1
            chosen(locnum)=nterms
          end if
    6     continue
        else
          do 7 locnum=1,nloci
            nterms=nterms+1
            chosen(locnum)=nterms
    7     continue
        end if
      end if

      pos=sta
      i=0
      locnum=1
      offset=0
      if (typ.eq.2) offset=4
   10 continue
      if (pos.gt.fin) goto 40
        if (words(pos)(1:1).eq.'$') then
C a class of variable
          bymap=.false.
          if (words(pos)(2:2).eq.'m') then
            i=1
          elseif (words(pos)(2:2).eq.'x') then
            i=2
          elseif (words(pos)(2:2).eq.'q') then
            i=3
          elseif (words(pos)(2:2).eq.'a') then
            i=4
          end if
          dir=1
          be=1
          en=nloci
          if (words(pos)(3:3).eq.'r') then
            dir=-1
            be=nloci
            en=1
          else if (words(pos)(3:3).eq.'m') then
            bymap=.true.
          end if
          i=i+offset
          if (.not.bymap) then
            do 20 locnum=be,en,dir
            if (loctyp(locnum).eq.i .and. chosen(locnum).eq.0) then
              nterms=nterms+1
              chosen(locnum)=nterms
            end if
   20       continue
          else
            nmark=0
            do 21 locnum=1, nloci
            if (loctyp(locnum).eq.i .and. chosen(locnum).eq.0) then
              nmark=nmark+1
              ord(nmark)=locnum
              imap(nmark)=int(1000.0*map(locnum))
            end if
   21       continue
            call isort(1, nmark, imap, ord, 2)
            do 22 j=1, nmark
              nterms=nterms+1
              chosen(ord(j))=nterms
   22       continue
          end if
          locnum=1
          pos=pos+1
        else if (chfind('*',words(pos)).ne.0) then
C a wild card
          do 23 locnum=1,nloci
          if (strfind(words(pos),loc(locnum),1) .and. 
     &        chosen(locnum).eq.0) then
            nterms=nterms+1
            chosen(locnum)=nterms
          end if
   23     continue
          locnum=1
          pos=pos+1
        else
C a variable name or range of variables names 
          span=0
          if (words(pos).eq.'to' .or. words(pos).eq.'--') then
            span=locnum
            pos=pos+1
          end if
          if (pos.le.fin) then
            if (isreal(words(pos))) then
              locnum=ival(words(pos))
              if (locnum.lt.0 .or. locnum.gt.nloci) locnum=0
            else
              locnum=isinenv(words(pos)(1:20),nloci,loc)
            end if
          else
            locnum=nloci
          end if
          if (locnum.eq.0) then
            write(*,'(2a/)') 'ERROR: Unable to find locus ',words(pos)
          else     
            if (span.eq.0) span=locnum
            call order(span,locnum)
            if (typ.eq.1) then
              do 30 i=span,locnum
              if (loctyp(i).le.4 .and. chosen(i).eq.0) then
                nterms=nterms+1
                chosen(i)=nterms
              end if
   30         continue
            else if (typ.eq.2) then
              do 31 i=span,locnum
              if (loctyp(i).ge.5 .and. chosen(i).eq.0) then
                nterms=nterms+1
                chosen(i)=nterms
              end if
   31         continue
            else
              do 32 i=span,locnum
              if (chosen(i).eq.0) then
                nterms=nterms+1
                chosen(i)=nterms
              end if
   32         continue
            end if
          end if
          pos=pos+1
        end if
      goto 10
   40 continue

      do 50 locnum=1,nloci
      if (chosen(locnum).gt.0) then
        terms(chosen(locnum))=locnum
      end if
   50 continue
C     do kk=1, nloci
C       write(*,*) kk,' ',loc(kk),' ',loctyp(kk), chosen(kk)
C     end do
      return
      end
C end-of-loadnam
C
C List of active loci
C
      subroutine listloci(nord, locord, nloci,loc,loctyp,locpos,
     &           locnotes, typ)
      integer MAXLOC
      parameter (MAXLOC=120)
      integer typ
C
C Locus structure:
C
      integer nloci
      character*20 loc(MAXLOC)
      character*40 locnotes(MAXLOC)
      integer loctyp(MAXLOC),locpos(MAXLOC)
      character*1 typloc(8)
C selection list
      integer nord, locord(MAXLOC)

      integer i,j,eon,nmark,ntrait,pos
C functions
      integer eow
      double precision bonf

      data typloc/'m','x','q','a','d','d','d','d'/

      nmark=0
      ntrait=0 
      if (typ.eq.1) then
        write(*,'(2(/a,1x,a,1x,a))') 
     2    'Locus          ','Type','Position', 
     3    '---------------','----','----------'
        do 5 j=1,nord 
          i=locord(j)
          if (loctyp(i).le.2) then
            nmark=nmark+1
            write(*,'(a15,2x,a1,3x,i4,a2,i4,3x,a)') 
     2        loc(i),typloc(loctyp(i)),locpos(i)+5,'--',locpos(i)+6,
     3        locnotes(i)
          else
            write(*,'(a15,2x,a1,3x,i4,9x,a)') 
     &        loc(i),typloc(loctyp(i)),locpos(i)+5,locnotes(i)
          end if
    5   continue
        write(*,'(/a,i4,3(/a,3x,f8.6)/)') 
     2    'Number of marker loci= ',nmark,
     3    'Bonferroni corr. 5%  = ',bonf(nmark,0.05d0),
     4    'Bonferroni corr. 1%  = ',bonf(nmark,0.01d0),
     5    'Bonferroni corr. 0.1%= ',bonf(nmark,0.001d0)
      elseif (typ.eq.2) then
        nmark=0
        pos=0
        do 15 j=1,nord 
          i=locord(j)
          eon=eow(loc(i))
          pos=pos+eon+1
          if (loctyp(i).eq.3 .or. loctyp(i).eq.4) then
            ntrait=ntrait+1
            pos=pos+1
            call newlin(1,78,pos,eon+2)
            write(*,'(2a,$)') loc(i)(1:eon),'* '
          else if (loctyp(i).le.2) then
            nmark=nmark+1
            call newlin(1,78,pos,eon+2)
            write(*,'(2a,$)') loc(i)(1:eon),' '
          else
            pos=pos+2
            call newlin(1,78,pos,eon+2)
            write(*,'(3a,$)') '(',loc(i)(1:eon),') '
          end if
   15   continue
        write(*,*)
        write(*,*) ntrait, ' active traits; ',nmark, ' active markers.'
      end if
      return
      end
C end-of-listloci
C 
      subroutine newlin(sol, eol, pos, newpos)
      integer eol, newpos, pos, sol
      integer i
      if (pos.gt.eol) then
        pos=newpos
        write(*,*)
        do 10 i=1, sol-1
          write(*,'(a,$)') ' '
   10   continue
      end if
      return
      end
C end-of-newlin
C
C Count active codominant markers or active loci
C
      subroutine cntmark(nloci,loctyp,nmark,typ)
      integer MAXLOC
      parameter(MAXLOC=120)
      integer nloci, nmark, loctyp(MAXLOC), typ
      integer i

      nmark=0
      if (typ.eq.1) then
        do 10 i=1,nloci
          if (loctyp(i).le.2) nmark=nmark+1
   10   continue
      else
        do 20 i=1,nloci
          if (loctyp(i).le.4) nmark=nmark+1
   20   continue
      end if
      return
      end
C end-of-cntmark
C
C Find next active codominant marker in list
C
      integer function findmk(sta,fin,loctyp)
      integer MAXLOC, MISS
      parameter(MAXLOC=120, MISS=-9999)
      integer fin, loctyp(MAXLOC), sta
      integer i

      i=sta
   10 continue
      if (i.gt.fin) goto 20
        if (loctyp(i).le.2) then
          findmk=i
          return
        end if
        i=i+1
        goto 10
   20 continue
      findmk=MISS
      return
      end
C end-of-findmk
C
C Find first codominant marker in list
C
      integer function findml(nord,locord,loctyp)
      integer MAXLOC, MISS
      parameter(MAXLOC=120, MISS=-9999)
      integer nord, locord(MAXLOC), loctyp(MAXLOC)
      integer i
      findml=MISS
      do 10 i=1, nord
      if (loctyp(locord(i)).le.2) then
        findml=locord(i)
        return 
      end if
   10 continue
      return
      end
C end-of-findml      
C
C produce next pair of markers from: 
C     1. named pair 2. One named 3. map order 4. all pairs 10. empty
C
      subroutine ldlist(typ,loc1,loc2,nloci,loctyp,last)
      integer MAXLOC, MAXSIZ, MISS
      parameter(MAXLOC=120,MAXSIZ=1000,MISS=-9999)
      integer loc1, loc2, nloci, loctyp(MAXLOC), typ
      logical last
C functions
      integer findmk

      if (last) return

      if (typ.eq.1) then
        typ=10
      else if (typ.eq.2) then
        if (loc2.eq.MISS) loc2=0
        loc2=findmk(loc2+1, nloci, loctyp)
        if (loc2 .eq. loc1) then
          loc2=findmk(loc2+1, nloci, loctyp)
        end if
        last=(loc2.eq.MISS)
      else if (typ.eq.3 .or. typ.eq.4) then
        loc1=findmk(1, nloci, loctyp)
        if (loc1.ne.MISS) then
          loc2=findmk(loc1+1, nloci, loctyp)
          typ=typ+2
        else
          loc2=MISS
        end if
        last=(loc2.eq.MISS)
      else if (typ.eq.5) then
        loc1=loc2
        loc2=findmk(loc2+1, nloci, loctyp)
        last=(loc2.eq.MISS)
      else if (typ.eq.6) then
        loc2=findmk(loc2+1, nloci, loctyp)
        if (loc2.eq.MISS) then
          loc1=findmk(loc1+1, nloci, loctyp)
          last=(loc1.eq.MISS)
          if (.not.last) then
            loc2=findmk(loc1+1, nloci, loctyp)
            last=(loc2.eq.MISS)
          end if
        end if
      else
        last=.not.last
      end if
      return
      end
C end-of-ldlist
C 
C test if complete data for this individual
      logical function complete(idx, nvar, terms, locpos, loctyp, locus)
      integer KNOWN,MAXSIZ,MAXLOC,MISS
      parameter (KNOWN=0,MAXSIZ=1000,MAXLOC=120,MISS=-9999)
      integer idx, nvar, terms(MAXLOC)
      integer locpos(MAXLOC), loctyp(MAXLOC)
      double precision locus(MAXSIZ,MAXLOC)
      integer j

      complete=.true.
      do 10 j=1,nvar
      if ((loctyp(terms(j)).le.2 .and. 
     2     locus(idx,locpos(terms(j))).lt.KNOWN) .or.
     3    locus(idx,locpos(terms(j))).eq.MISS) then
        complete=.false.
        return 
      end if
   10 continue
      return
      end
C end-of-complete
C 
C test if all genotypes missing for this locus at this pedigree
C
      logical function allmiss(gene,num,locus)
      integer MAXSIZ,MAXLOC,MISS
      parameter (MAXSIZ=1000,MAXLOC=120,MISS=-9999)
      integer gene, num
      double precision locus(MAXSIZ,MAXLOC)
      integer i
      allmiss=.true.
      do 150 i=1,num
      if (locus(i,gene).ne.MISS) then
        allmiss=.false.
        goto 151
      end if
  150 continue
  151 continue
      return
      end
C end-of-allmiss
C 
C test if all genotypes nonmissing for this locus at this pedigree
C
      logical function alltyped(gene,num,locus)
      integer MAXSIZ,MAXLOC,MISS
      parameter (MAXSIZ=1000,MAXLOC=120,MISS=-9999)
      integer gene, num
      double precision locus(MAXSIZ,MAXLOC)
      integer i
      alltyped=.true.
      do 150 i=1,num
      if (locus(i,gene).eq.MISS) then
        alltyped=.false.
        goto 151
      end if
  150 continue
  151 continue
      return
      end
C end-of-alltyped
C
C Get a line from the stream
      subroutine getlin(strm,narg,words,lin,skipbl)
      integer LINSIZ, MAXLOC, MAXCOL
      parameter (LINSIZ=1024, MAXLOC=120, MAXCOL=MAXLOC+5)
      integer narg, skipbl, strm
C character array to initially read data into
      character*(LINSIZ) lin
      character*20 words(MAXCOL)
   10 continue
        read(strm,'(a)',end=20) lin(1:LINSIZ)
        narg=MAXCOL
        call args(lin,narg,words,1)
      if (skipbl.eq.1 .and. narg.eq.0) goto 10
   20 continue
      return
      end
C end-of-getlin
C
C Read a MERLIN locus file
C
      subroutine rdmerloc(strm, xli, lin, words, nloci, loc, 
     2                    locpos, loctyp, nord, locord, map, locnotes,
     3                    numloc, twinning,  twintrait,  token, env)
      integer ENVNUM, LINSIZ, MAXLOC, MAXCOL, MAXSIZ, TOKNUM
      parameter (ENVNUM=12,LINSIZ=1024, MAXLOC=120,
     &           MAXCOL=MAXLOC+5,MAXSIZ=1000, TOKNUM=44)
      integer nloci, numloc, strm, xli
      character*20 loc(MAXLOC)
      integer loctyp(MAXLOC), locpos(MAXLOC)
      integer nord, locord(MAXLOC)
      real map(MAXLOC)
      character*40 locnotes(MAXLOC)
C zygosity indicator
      integer twinning 
      character*20 twintrait
C reserved words to check locus names against
      character*6 env(ENVNUM), token(TOKNUM) 
C character array to initially read data into
      character*(LINSIZ) lin
      character*20 words(MAXCOL)
C local variables
      integer k
      logical oldnam
C functions
      integer eow
      logical isinuse

      nloci=0
      numloc=0
   10 continue
        read(strm,'(a)',end=20) lin(1:LINSIZ)
        narg=2
        call args(lin,narg,words,1)
        if (words(1)(1:1).ne.'E') then
          oldnam=isinuse(words(2), nloci, loc, token, env)
          numloc=numloc+1
          if (numloc.gt.MAXLOC) then
            write(*,'(a,i3,a1/7x,3a/)') 
     2        'ERROR: Number of columns of data exceeds maximum ',
     3        MAXLOC,'.',
     4        'Variable ',words(2)(1:eow(words(2))),' not added.'
            numloc=numloc-1
          else
            nloci=nloci+1
            loc(nloci)=words(2)
            if (oldnam) then
              k=min(20,eow(loc(nloci))+1)
              loc(nloci)(k:k)='_'
              write(*,'(a/7x,3a/)') 
     2        'WARNING: Locus is already declared or a reserved word.',
     3        'Changed name to "',loc(nloci)(1:k),'".'
            end if
            locpos(nloci)=numloc
            if (words(1)(1:1).eq.'M') then
              loctyp(nloci)=1+xli
              numloc=numloc+1
            else if (words(1)(1:1).eq.'A') then
              loctyp(nloci)=4
            else  if (words(1)(1:1).eq.'Z') then
              twinning=nloci
              twintrait=loc(nloci)
              loctyp(nloci)=3
              write(*,'(/3a/)') 
     2          'NOTE:  The phenotype "',twintrait(1:eow(twintrait)),
     3          '" now indicates monozygotic (twin) sibships.' 
            else 
              loctyp(nloci)=3
            end if
            locnotes(nloci)=lin
          end if
        end if
      goto 10
   20 continue
      return
      end
C end-of-rdmerloc
C
C Read a mapfile -- attempts to intelligently decide
C what to read
C
      subroutine readmap(strm,lin,words,nloci,loc,loctyp,map,plevel)
      integer LINSIZ, MAXLOC, MAXCOL, MAXSIZ
      parameter (LINSIZ=1024,MAXLOC=120,MAXCOL=MAXLOC+5,MAXSIZ=1000)
      integer nloci, plevel, strm
      character*20 loc(MAXLOC)
      integer loctyp(MAXLOC)
      real map(MAXLOC)
C character array to initially read data into
      character*(LINSIZ) lin
      character*20 words(MAXCOL)
C local variables
      integer i, lpos, mapped, mappos, nampos, typ
      real dist
C functions
      logical isreal
      double precision fval

C map type not specified, so check first two records 
      typ=1
      nampos=1
      mappos=2
      read(strm,'(a)',end=999) lin(1:LINSIZ)
      if (plevel.gt.1) then
        write(*,'(/2a)') '1: ',lin(1:65)
      end if
      narg=MAXCOL
      call args(lin,narg,words,1)
      if (narg.eq.1) then
C a MENDEL type map file?
        if (.not.isreal(words(1))) then
          read(strm,'(a)',end=999) lin(1:LINSIZ)
          if (plevel.gt.1) then
            write(*,'(2a)') '2: ',lin(1:65)
          end if
          narg=MAXCOL
          call args(lin,narg,words,1)
          if ((narg.eq.1 .or. narg.eq.2) .and. isreal(words(1))) then
            typ=2
            if (plevel.gt.0) then
              write(*,'(a)') 'NOTE:  Guessed to be a MENDEL map file.'
            end if
          end if
        end if
      else if (narg.eq.2) then
C presume name, mappos or mappos, name
        if (.not.isreal(words(1)) .and. .not.isreal(words(2))) then
          read(strm,'(a)',end=999) lin(1:LINSIZ)
          narg=MAXCOL
          call args(lin,narg,words,1)
        end if
        if (narg.eq.2) then
          if (isreal(words(1)) .and. .not.isreal(words(2))) then
            nampos=2
            mappos=1
          else if (.not.isreal(words(1)) .and. isreal(words(2))) then
            nampos=1
            mappos=2
          end if
        end if
      else if (narg.eq.3) then
C most likely chr, name, mappos or name, mpos, fpos
        if (.not.isreal(words(1)) .and. .not.isreal(words(2)) .and.
     &      .not.isreal(words(3))) then
          read(strm,'(a)',end=999) lin(1:LINSIZ)
          narg=MAXCOL
          call args(lin,narg,words,1)
        end if
        if (narg.eq.3) then
          if (.not.isreal(words(1)) .and. isreal(words(2)) .and.
     &        isreal(words(3))) then
            nampos=1
            mappos=2
          else if (isreal(words(1)) .and. .not.isreal(words(2)) .and.
     &        isreal(words(3))) then
C MERLIN maps have
C (chr at position 1) locus name at 2, map position at 3
            nampos=2
            mappos=3
            if (plevel.gt.0) then
              write(*,'(a)') 'NOTE:  Guessed to be a MERLIN map file.'
            end if
          end if
        end if
      end if
      rewind(strm)
C
C Read the mapfile
C
      mapped=0
      if (typ.eq.1) then
C name-position pair per line
   10   continue
          read(strm,'(a)',end=20) lin(1:LINSIZ)
          if (plevel.gt.1) then
            write(*,'(a)') lin(1:72)
          end if
          narg=3
          call args(lin,narg,words,1)
          do 30 i=1, nloci
          if (words(nampos).eq.loc(i) .and. isreal(words(mappos))) then
            mapped=mapped+1
            map(i)=fval(words(mappos))
            goto 31
          end if
   30     continue
   31     continue
        goto 10
   20   continue
      else if (typ.eq.2) then
C name distance on alternate lines
C assumes map and data order same
   50   continue
          dist=0.0
          read(strm,'(a)',end=70) lin(1:LINSIZ)
          if (plevel.gt.1) then
            write(*,'(a)') lin(1:72)
          end if
          narg=1
          call args(lin,narg,words,1)
          lpos=0
          do 60 i=1, nloci
          if (words(nampos) .eq. loc(i)) then
            lpos=i
            goto 61
          end if
   60     continue
   61     continue
          read(strm,'(a)',end=999) lin(1:LINSIZ)
          narg=MAXCOL
          call args(lin,narg,words,1)
          if (narg.eq.2 .and. isreal(words(1)) .and. 
     &        isreal(words(2))) then
            dist=dist+0.5*(fval(words(1))+fval(words(2)))
          else if (isreal(words(1))) then
            dist=dist+fval(words(1))
          end if
          if (lpos.gt.0) then
            mapped=mapped+1
            map(lpos)=dist
          end if
        goto 50
   70   continue
      end if
      write(*,'(/a,i4,a/)')  'Matched up ', mapped, 
     &                       ' loci with their map positions.'
      return
C read error
  999 continue
        write(*,'(a)') 'ERROR: io error in map file.'
      return
      end
C end-of-readmap
C
C Read a Linkage locus file
C
      subroutine rdlinloc(strm,lin,words,nloci,loc,
     2                    locpos,loctyp,nord,locord,
     3                    map,locnotes,wloc,numloc,token,env)
      integer ENVNUM, LINSIZ, MAXLOC, MAXCOL, MAXSIZ, TOKNUM
      parameter (ENVNUM=12,LINSIZ=1024, MAXLOC=120,
     &           MAXCOL=MAXLOC+5,MAXSIZ=1000, TOKNUM=44)
      integer nloci, numloc, strm
      character*20 loc(MAXLOC)
      integer loctyp(MAXLOC), locpos(MAXLOC)
      integer nord, locord(MAXLOC)
      integer wloc(MAXLOC)
      real map(MAXLOC)
      character*40 locnotes(MAXLOC)
C reserved words to check locus names against
      character*6 env(ENVNUM), token(TOKNUM) 
C character array to initially read data into
      character*(LINSIZ) lin
      character*20 words(MAXCOL)
C local variables
      integer i, i1, i2, j, lpos, ncol, nlrec, nmark, nrec, ntrait,  
     &        typ, xlink
      logical addloc, err, hasnam, iscm
      real r1, r2
C functions
      integer eow, ival
      logical isinuse
      double precision fval

      err=.false.
      read(strm,*,err=999) nlrec, i1, xlink, i2
      if (nlrec.gt.MAXLOC) then
        write(*,'(a/7x,a,i3,a/)') 
     2    'ERROR: Maximum number of declarable loci exceeded.',
     3           'Will read in only first ', MAXLOC, ' loci.'
        err=.true.
      end if
      read(strm,*,err=999) i1, r1, r2, i2
C list giving locus map order
      nord=MAXCOL
      call getlin(strm,nord,words,lin,1)
      nrec=nord
      do 10 i=1, nord
        locord(i)=ival(words(i))
        wloc(i)=locord(i)
   10 continue

      ncol=0
      nloci=0
      nmark=0
      ntrait=0
      numloc=0
      do 12 i=1, nlrec
        call getlin(strm,narg,words,lin,1)
        typ=ival(words(1))
        ncol=ncol+1
        if (typ.eq.3) ncol=ncol+1
        
        addloc=(nloci.lt.MAXLOC .and. ncol.le.MAXLOC)
        hasnam=(narg.ge.4 .and. .not.
     &          isinuse(words(4), nloci, loc, token, env))
        if (typ.eq.3) then
          if (addloc) then
            nloci=nloci+1
            nmark=nmark+1
            numloc=numloc+1
            locpos(nloci)=numloc
            numloc=numloc+1
            locnotes(nloci)=lin
            if (.not.hasnam) then
              write(loc(nloci),'(a,i3.3)') 'mar', nmark
            else
              loc(nloci)=words(4)
            end if
            loctyp(nloci)=1
            if (xlink.eq.1) loctyp(nloci)=2
          end if
          read(strm,*,err=999) 
        elseif (typ.eq.0 .or. typ.eq.4) then
          if (addloc) then
            nloci=nloci+1
            ntrait=ntrait+1
            numloc=numloc+1
            locpos(nloci)=numloc
            loctyp(nloci)=3
            if (.not.hasnam) then
              write(loc(nloci),'(a,i3.3)') 'trait', ntrait
            else
              loc(nloci)=words(4)
            end if
            locnotes(nloci)=lin
            if (typ.eq.0) then
              do 40 j=1,4
                read(strm,*,err=999)
   40         continue
            end if
          end if
        elseif (typ.eq.1) then
          if (addloc) then
            nloci=nloci+1
            ntrait=ntrait+1
            numloc=numloc+1
            locpos(nloci)=numloc
            loctyp(nloci)=4
            locnotes(nloci)=lin
            if (typ.eq.0) loctyp(nloci)=3
            if (.not.hasnam) then
              write(loc(nloci),'(a,i3.3)') 'trait', ntrait
            else
              loc(nloci)=words(4)
            end if
          end if
          read(strm,*,err=999) 
          read(strm,*,err=999) i1
C add in liability class as quantitative trait if necessary
          if (i1.gt.1 .and. addloc) then
            if (nloci.lt.MAXLOC) then
              write(*,'(/3a)') 
     2 'NOTE:  Liability class for "',loc(nloci)(1:eow(loc(nloci))),
     3 '" added as quantitative variable.'
              call insloc(nloci,nloci,loc,loctyp,locpos,map)
              loc(nloci+1)=loc(nloci)(1:min(eow(loc(nloci)),8)) // '_l'
              nloci=nloci+1
              numloc=numloc+1
              loctyp(nloci)=3
              locpos(nloci)=numloc
              locnotes(nloci)='Liability class for ' // loc(nloci-1)
C correct positions of later loci in prespecified order -- 
C locus list (includes extra liability loci) *and* recomb list
              j=1
   18         continue
                if (locord(j).ge.nloci) then
                  locord(j)=locord(j)+1
                else if (locord(j).eq.(nloci-1)) then
                  do 22 k=nord, j+1, -1
                    locord(k+1)=locord(k)
   22             continue
                  j=j+1
                  nord=nord+1
                  locord(j)=nloci
                end if
                j=j+1
              if (j.le.nord) goto 18
              do 20 j=1,nrec 
              if (wloc(j).ge.nloci) then
                wloc(j)=wloc(j)+1
              end if
   20         continue
            end if
          end if
          do 30 j=1, i1
            read(strm,*,err=999)
   30     continue
        end if
   12 continue
      read(strm,*,err=999) i1, i2
      narg=MAXLOC
      call getlin(strm,narg,words,lin,1)
      if (narg.ne.(nrec-1)) then
        write(*,'(a/7x,a)') 
     2    'ERROR: Number of recombination fractions does',
     3    'not match number of declared loci on map.'
      end if
      iscm=.false.
      do 50 i=1, narg
      if (fval(words(i)).gt.0.5d0) then
        iscm=.true.
        write(*,'(a)') 
     &    'NOTE:  Linkage locus file map distances inferred to be cM.'
        goto 51
      end if
   50 continue
   51 continue
      dist=0.0
      map(wloc(1))=dist
      if (iscm) then
        do 60 i=1, min(narg, nord)
          lpos=wloc(i+1)
          map(lpos)=dist+fval(words(i))
          dist=map(lpos)
   60   continue
      else
        do 70 i=1, min(narg, nord)    
          lpos=wloc(i+1)
          map(lpos)=dist-50.0*log(1.0-2*fval(words(i)))
          dist=map(lpos)
   70   continue
      end if
      return
C read error
  999 continue
        write(*,'(a)') 'ERROR: io error in Linkage locus file.'
      return
      end
C end-of-rdlinloc
C 
C insert a locus into the locus list
C other details of the slot are left blank
C
      subroutine insloc(pos,nloci,loc,loctyp,locpos,map)
      integer MAXLOC, MAXCOL
      parameter (MAXLOC=120, MAXCOL=MAXLOC+5)
      integer nloci, pos
      character*20 loc(MAXLOC)
      integer loctyp(MAXLOC), locpos(MAXLOC)
      real map(MAXLOC)
      integer i

      if (nloci.gt.MAXLOC) then
        write(*,'(a,7x,a,i3,a)') 
     2    'ERROR: Maximum number of declared loci exceeded.' ,
     3    'An additional locus cannot be inserted at ',pos,'.'
        return
      end if
      do 10 i=nloci-1, pos, -1
        loc(i+1)=loc(i)
        loctyp(i+1)=loctyp(i)
        locpos(i+1)=locpos(i)
        map(i+1)=map(i)
   10 continue
      return
      end
C end-of-insloc
C
C Make change in order of variables
C
       subroutine ordvar(twrk,nloci,loc,loctyp,locpos,
     &                   nord,locord,map,locnotes,ord)
      integer MAXSIZ, MAXLOC, MISS
      parameter(MAXSIZ=1000, MAXLOC=120, MISS=-9999)

      integer twrk
C new order      
      integer nord 
      integer locord(MAXLOC), ord(MAXLOC)
C Locus structure
      character*20 loc(MAXLOC)
      integer nloci,loctyp(MAXLOC),locpos(MAXLOC)
      real map(MAXLOC)
      character*40 locnotes(MAXLOC)
C
      integer i, pos
C
C write ordered loci followed by all others, latter set to deleted
C
      do 5 i=1,nloci 
        ord(i)=0
    5 continue
      do 10 i=1,nord  
        pos=locord(i)
        ord(pos)=i
        write(twrk) loc(pos), loctyp(pos), locpos(pos), 
     &              map(pos), locnotes(pos)
   10 continue
      do 15 i=1,nloci 
      if (ord(i).eq.0) then
        if (loctyp(i).le.4) loctyp(i)=loctyp(i)+4
        write(twrk) loc(i), loctyp(i), locpos(i), 
     &              map(i), locnotes(i)
      end if
   15 continue
      rewind(twrk)
      do 20 i=1,nloci 
        read(twrk) loc(i), loctyp(i), locpos(i), map(i), locnotes(i)
   20 continue
      return
      end
C end-of-ordvar
C
C pack pedigrees and loci
C
      subroutine packer(wrk, twrk, typ, pedigree, actset, num, nfound,
     2             id, fa, mo, sex, locus, numloc, nobs,
     3             nloci, loc, loctyp, locpos, map, locnotes, 
     4             nord, locord, plevel)
      integer ENVNUM, MAXLOC, MAXCOL, MAXSIZ, MISS, TOKNUM 
      parameter (ENVNUM=12, MAXLOC=120, MAXCOL=MAXLOC+5, 
     &           MAXSIZ=1000, MISS=-9999, TOKNUM=44)
      integer plevel,twrk,typ,wrk
C Pedigree structure
      character*10 pedigree
      integer actset, num, nfound
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ), sex(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)
C Locus structure:
      integer nloci
      character*20 loc(MAXLOC)
      character*40 locnotes(MAXLOC)
      integer loctyp(MAXLOC),locpos(MAXLOC)
      logical last
C position of locus on sex-averaged linkage map
      real map(MAXLOC)
C position of active loci
      integer nord, locord(MAXLOC)
C local variables
      integer dped, dobs, i, nped, nobs, pos
C
C make list of columns to retain
      if (typ.ne.1) then
        nord=0
        do 10 i=1, nloci
        if (loctyp(i).le.4) then
          nord=nord+1
          locord(nord)=locpos(i)
          if (loctyp(i).le.2) then
            nord=nord+1
            locord(nord)=locpos(i)+1
          end if
        end if
   10   continue
      else
        nord=numloc
        do 15 i=1, numloc
          locord(i)=i
   15   continue
      end if
C 
      nped=0
      nobs=0
      dped=0
      dobs=0
      last=.false.
      rewind(wrk)
   30 continue
       call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &            numloc, last)
       if (last) goto 40
        if (actset.gt.0 .or. typ.eq.2) then  
          nped=nped+1
          nobs=nobs+num
          write(twrk) pedigree, actset, num, nfound
          do 35 i=1,num
            write(twrk) id(i),fa(i),mo(i),sex(i),
     &                 (locus(i,locord(j)),j=1,nord)
   35     continue
        else
          if (plevel.gt.1) then
            write(*,'(2a)') 'Deleting pedigree ', pedigree
          end if
          dped=dped+1
          dobs=dobs+num
        end if
      goto 30
   40 continue
      if (dped.gt.0) then
        write(*,'(/a,i5,a,i5,a/)') 
     &  'Permanently deleted ',dped,' pedigrees (',dobs,' individuals).'
      end if
C
C update locus list, recalculate nloci (number of loci) 
C locpos (first column of locus), and numloc (total columns of data)
C
      if (typ.ne.1) then
        numloc=0
        pos=0
        do 50 i=1, nloci
          if (loctyp(i).le.4) then
            numloc=numloc+1
            pos=pos+1
            loc(pos)=loc(i)  
            locnotes(pos)=locnotes(i)  
            loctyp(pos)=loctyp(i)  
            locpos(pos)=numloc
            map(pos)=map(i)
            if (loctyp(i).le.2) numloc=numloc+1
          else if (plevel.gt.1) then
            write(*,'(2a)') 'Deleting locus ', loc(i)
          end if
   50   continue
        if (pos.lt.nloci) then
          write(*,'(a,i5,a/)') 'Permanently deleted ',nloci-pos,' loci.'
        end if
        nloci=pos
      end if
      return
      end
C end-of-packer
C
C Find the start of a "where" clause
      integer function findwh(farg, larg, narg, args)
      integer farg, larg, narg
      character*(*) args(narg)
      integer i
      do 10 i=farg, larg  
        if (args(i).eq.'whe' .or. args(i).eq.'where') then
          findwh=i
          return
        end if
   10 continue
      findwh=0
      return
      end
C end-of-findwh
C
C read a set of allele frequencies from the command line 
C make up some numbers if necessary 
C
      subroutine rdfreq(sta, fin, words, nallele, cumfrq)
      integer MAXALL, MAXLOC, MAXCOL
      parameter (MAXALL=60, MAXLOC=120, MAXCOL=MAXLOC+5)
      character*20 words(MAXCOL)
      integer fin, nallele, sta
      double precision cumfrq(MAXALL)
      integer i
      double precision x
C functions
      double precision fval

      nallele=0
C just the number of alleles given
      if (fval(words(sta)).gt.1.0d0) then
        nallele=min(MAXALL, ival(words(sta)))
        x=1.0d0/dfloat(nallele)
        cumfrq(1)=x
        do 5 i=2, nallele-1
          cumfrq(i)=cumfrq(i-1)+x
    5   continue
        cumfrq(nallele)=1.0d0
        return
      end if
C
C else read a list of allele frequencies
C   padding out if sum to less than one
      if ((fin-sta+1).gt.MAXALL) fin=MAXALL-sta

      if (fin.ge.sta) then
        cumfrq(1)=fval(words(sta))
        nallele=1
        do 10 i=sta+1, fin
          nallele=nallele+1
          cumfrq(nallele)=cumfrq(nallele-1)+fval(words(i))
          if (cumfrq(nallele).gt.1.0d0) goto 11
   10   continue
   11   continue
        if (cumfrq(nallele).gt.0.99d0 .or. nallele.eq.MAXALL) then
          cumfrq(nallele)=1.0d0
        else
          nallele=nallele+1
          cumfrq(nallele)=1.0d0
        end if
      else
        nallele=2
        cumfrq(1)=0.5d0
        cumfrq(2)=1.0d0
      end if
      return
      end
C end-of-rdfreq
