C
C Two locus linkage disequilibrium
C
      subroutine twold(wrk,gene1,loc1,gene2,loc2,pedigree,num,nfound,
     2             id,fa,mo,sex,locus,numloc,
     3             numal,name,alfrq,numal2,name2,alfrq2,
     4             eligible,ngcount,gcount,plevel)
      integer MAXALL, MAXG, MAXSIZ, MAXLOC, KNOWN
      parameter(MAXALL=60, MAXG=MAXALL*(MAXALL+1)/2, 
     &          MAXSIZ=1000, MAXLOC=120, KNOWN=0)
      integer gene1,gene2,plevel,wrk
      character*10 loc1, loc2
C pedigree structure
      character*10 pedigree
      integer sex(MAXSIZ)
      integer num, nfound
      character*8 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ)
      real locus(MAXSIZ,MAXLOC)
C
C allele frequencies within entire sample for given locus 
C
      integer numal, name(MAXALL)
      double precision alfrq(MAXALL)
      integer numal2, name2(MAXALL)
      double precision alfrq2(MAXALL)
C
C Typed founders or nonfounders who have untyped parents
      logical eligible(MAXSIZ)
C
C Genotype counts: allele1,allele2, number transmitted, number not trans
      integer ngcount,gcount(MAXG,4)
C
      integer tr1,tr2,nt1,nt2,tr3,tr4,nt3,nt4
      logical last
      integer cutoff, df, gene12, gene22, i, idx, j, nhap, ntyped  
      character*3 histo
      character*7 gtp
      double precision bigd, chisq, d, dprime, e, p1, p2, pval, tot
C functions 
      double precision chip, ftdev, getfreq
C
      if (plevel.gt.0) then
        write(*,'(/a,a10,a,a10,a/a/)')
     2   'Assoc for locus "',loc1,'" c. locus "',loc2,'"',
     3   '---------------------------------------------------'
      end if
      cutoff=0
      gene12=gene1+1
      gene22=gene2+1
      ntyped=0
      ngcount=0
      do 2 i=1,numal
        alfrq(i)=0.0d0
        do 3 j=1,numal2
          ngcount=ngcount+1
          gcount(ngcount,1)=name(i)
          gcount(ngcount,2)=name2(j)
          gcount(ngcount,3)=0
    3   continue
    2 continue
      do 4 j=1,numal2
        alfrq2(j)=0.0d0
    4 continue

      last=.false.
      rewind(wrk)
C
C If high print level, then list transmitted and nontransmitted alleles
C for each informative proband
C
      if (plevel.gt.1) then
        write(*,'(a/a)') '  Informative Parent     Trans  Not Tr',
     &                   'Pedigree  ID      Sex    1   2   1   2'
      end if
C
   10 continue
       call wrkin(wrk,pedigree,num,nfound,id,fa,mo,sex,locus,numloc,
     &            last)
       if (last) goto 20
C
C Identify typed founders or nonfounders who have untyped parents
C
         do 11 i=1,nfound
           if (locus(i,gene1).gt.KNOWN .and.locus(i,gene2).gt.KNOWN)
     &     then
             eligible(i)=.true.
           else
             eligible(i)=.false.
           end if
   11    continue
         do 12 i=nfound+1,num
           if (locus(i,gene1).gt.KNOWN .and.locus(i,gene2).gt.KNOWN 
     2         .and. locus(fa(i),gene1).lt.KNOWN
     3         .and. locus(fa(i),gene2).lt.KNOWN
     4         .and. locus(mo(i),gene1).lt.KNOWN
     5         .and. locus(mo(i),gene2).lt.KNOWN) 
     6     then
             eligible(i)=.true.
           else
             eligible(i)=.false.
           end if
   12    continue
C
C Go through offspring
C
         do 15 i=nfound+1,num
           if (locus(i,gene1).gt.KNOWN .and.locus(i,gene2).gt.KNOWN
     2         .and. (eligible(fa(i)) .or. eligible(mo(i)))
     3         .and. locus(fa(i),gene1).gt.KNOWN
     4         .and. locus(fa(i),gene2).gt.KNOWN
     5         .and. locus(mo(i),gene1).gt.KNOWN
     6         .and. locus(mo(i),gene2).gt.KNOWN) 
     7     then
             call trans(
     2             int(locus(fa(i),gene1)), int(locus(fa(i),gene12)),
     3             int(locus(mo(i),gene1)), int(locus(mo(i),gene12)),
     4             int(locus(i,gene1)), int(locus(i,gene12)),
     5             tr1,tr2,nt1,nt2,0)
             call trans(
     2             int(locus(fa(i),gene2)), int(locus(fa(i),gene22)),
     3             int(locus(mo(i),gene2)), int(locus(mo(i),gene22)),
     4             int(locus(i,gene2)), int(locus(i,gene22)),
     5             tr3,tr4,nt3,nt4,0)
C
C Note that once the haplotypes are used, the parent is set to ineligible
C along with any other full or half siblings
C
             if (eligible(fa(i))) then
               idx=fa(i)
               ntyped=ntyped+1
               call insgen(tr2,tr4,ngcount,gcount,3,2)
               call insgen(nt2,nt4,ngcount,gcount,3,2)
               call insall(tr2,numal,name,alfrq)
               call insall(nt2,numal,name,alfrq)
               call insall(tr4,numal2,name2,alfrq2)
               call insall(nt4,numal2,name2,alfrq2)
               eligible(idx)=.false.
               if (idx.gt.nfound) then
                 do 21 j=nfound+1,num
                   if (eligible(j) .and. 
     &                 (fa(idx).eq.fa(j) .or.  mo(idx).eq.mo(j))) then
                     eligible(j)=.false.
                   end if
   21            continue
               end if
               if (plevel.gt.1) then
                 write(*,'(a10,a8,x,a1,2x,4(1x,i3))') 
     &           pedigree,id(idx),'m',tr2,tr4, nt2, nt4
               end if
             end if
             if (eligible(mo(i))) then
               idx=mo(i)
               ntyped=ntyped+1
               call insgen(tr1,tr3,ngcount,gcount,3,2)
               call insgen(nt1,nt3,ngcount,gcount,3,2)
               call insall(tr1,numal,name,alfrq)
               call insall(nt1,numal,name,alfrq)
               call insall(tr3,numal2,name2,alfrq2)
               call insall(nt3,numal2,name2,alfrq2)
               eligible(idx)=.false.
               if (idx.gt.nfound) then
                 do 22 j=nfound+1,num
                   if (eligible(j) .and. 
     &                 (fa(idx).eq.fa(j) .or.  mo(idx).eq.mo(j))) then
                     eligible(j)=.false.
                   end if
   22            continue
               end if
               if (plevel.gt.1) then
                 write(*,'(a10,a8,x,a1,2x,4(1x,i3))') 
     &             pedigree,id(idx),'f',tr1,tr3, nt1, nt3 
               end if
             end if
           end if
   15    continue
       goto 10
   20  continue
C
      if (plevel.gt.0) then
       write(*,'(2a/2a)') 
     2   '       Haplotype       Observed   Expected',
     3   '     D        D''      Dev',
     4   '  ----------------------------------------',
     5   '-------------------------'
      end if
      chisq=0.0d0
      bigd=0.0d0
      tot=dfloat(2*ntyped)
      do 225 i=1,ngcount
        p1=getfreq(gcount(i,1),numal,name,alfrq)/tot 
        p2=getfreq(gcount(i,2),numal2,name2,alfrq2)/tot
        e=tot*p1*p2
        nhap=gcount(i,3)
        if (nhap.gt.cutoff) then
          chisq=chisq+dfloat(nhap)*
     &          log(dfloat(nhap)/e)
        end if    
        d=(dfloat(nhap)-e)/tot
        if (d.lt.0.0d0) then
          dprime=d/min(p1*p2,(1.0d0-p1)*(1.0d0-p2))
        elseif (d.eq.0.0d0) then
          dprime=0.0d0
        else
          dprime=d/(min(p1,p2)-p1*p2)
        end if
        if (abs(dprime).gt.bigd) bigd=abs(dprime)

        if (plevel.gt.0) then
          call wrgtp(gcount(i,1),gcount(i,2),gtp,2)
          write(*,999) gtp,nhap,'(',dfloat(nhap)/tot,')',e,
     &                 d,dprime,ftdev(dfloat(nhap),e)
  999     format(8x,a7,1x,i8,1x,1a,f5.3,1a,1x,f9.1,2x,f7.4,
     &           2x,f7.4,1x,f6.1)
        end if
  225 continue

      chisq=chisq+chisq
      df=(numal-1)*(numal2-1)
      pval=chip(chisq,df)
      if (plevel.gt.0) then
        write(*,'(/a,f6.1/a,i4)')
     2  'Linkage disequilibrium Chi-sq =',chisq,
     3  '   Nominal degrees of freedom =',df
        write(*,'(14x,a,3x,f6.4)') 'Nominal P-value =',pval
      else
        call phist(pval,1.0d0,histo)
        write(*,'(2(a10,1x),i4,2x,f6.3,1x,f6.1,1x,i4,1x,f6.4,2(1x,a))')
     &    loc1,loc2,ntyped,bigd,chisq,df,pval,'LD ',histo
      end if
C
      return
      end
C end-of-twold
C
C simple increment of allele count where all alleles already identified
C
      subroutine insall(iall,numal,name,alfrq)
      integer MAXALL
      parameter(MAXALL=60)
      integer iall, numal, name(MAXALL)
      double precision alfrq(MAXALL)
      integer idx
C functions
      integer getnam
      idx=getnam(float(iall),numal,name)
      alfrq(idx)=alfrq(idx)+1.0d0
      return
      end
C end-of-insall
C
C Additive allelic model for association with a quantitative trait
C
      subroutine doanova(wrk,wrk2,trait,locnam,gene,iter,mincnt,assfnd,
     2              x,r,b,cov,pedigree,num,nfound,
     3              id,fa,mo,sex,locus,numloc,numal,name,cumfrq,
     4              untyped,value,count,set,plevel)
      integer KNOWN,MAXIBD,MAXSIZ,MAXLOC,MAXALL,MAXCOV,MAXTER,MISS
      parameter (KNOWN=0,MAXSIZ=1000,MAXLOC=120,MAXALL=60,MAXIBD=1000,
     2           MAXTER=MAXIBD/2,MAXCOV=MAXTER*(MAXTER+1)/2,
     3           MISS=-9999)
      integer gene,iter,mincnt,numal,numloc,plevel,trait,wrk,wrk2
      logical assfnd
      character*10 locnam
C Pedigree structure
      character*10 pedigree
      integer num, nfound
      character*8 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ), sex(MAXSIZ), set(MAXSIZ,2)
      real locus(MAXSIZ,MAXLOC)
      logical last, untyped(MAXSIZ)
C allele frequencies structure
      integer name(MAXALL)
      double precision cumfrq(MAXALL)
C Storage for trait values during randomization
      integer count(MAXSIZ)
      real value(MAXSIZ)
C arrays for allelic effects
      double precision x(MAXTER), r(MAXCOV), b(MAXTER), cov(MAXCOV)
C local variables
      integer g1,g2,gen2,i,idf,ii,it,j,mdf,n,ncov,nobs,nter,tailp,nuntyp
      character*3 histo
      double precision asyp, bss, orss, lrts, mss,mu,pval,rss,vss
C functions
      integer getnam
      real random
      double precision chip, ln


      last=.false.
      it=0
      nobs=0
      nter=numal+1
      ncov=nter*(nter+1)/2
      gen2=gene+1
      call inicov(nter, ncov, r)
      bss=0.0d0
      mu=0.0d0
      nuntyp=0
      do 5 i=1,numal
        count(i)=0
    5 continue
      rewind(wrk)
   10 continue
       call wrkin(wrk,pedigree,num,nfound,id,fa,mo,sex,locus,numloc,
     &            last)
       if (last) goto 20

        n=num
        if (assfnd) n=nfound
        do 12 i=1,n
	  value(i)=locus(i,trait)
          untyped(i)=.false.
          if (locus(i,gene).lt.KNOWN) then
            untyped(i)=.true.
            if (locus(i,trait).ne.MISS) nuntyp=nuntyp+1
          elseif (locus(i,trait).ne.MISS) then
            g1=getnam(locus(i,gene),numal,name)
            g2=getnam(locus(i,gen2),numal,name)
            nobs=nobs+1
            do 15 j=1,numal
              x(j)=0.0d0
   15       continue
            x(nter)=dble(value(i))
            x(g1)=x(g1)+1
            x(g2)=x(g2)+1
            count(g1)=count(g1)+1
            count(g2)=count(g2)+1
            call moment(nobs,x(nter),mu,bss)
            call givenc(r, ncov, nter, x, 1.0d0, ifail)
          end if
   12   continue
        write(wrk2) n,nfound,(value(i),fa(i),mo(i),untyped(i),i=1,n)
      goto 10
   20 continue
      call alias(r, ncov, nter, 1.0d-15, x, ifail)
      call bsub(r, ncov, nter, b, numal, ifail)
      call var(r, ncov, cov, ncov, nter, nobs, 1, ifail)

      mdf=0
      mss=0.0d0
      do 150 i=1,numal
        call sscomp(r, ncov, nter, nobs, i, rss, idf, ifail)
        mdf=mdf+idf
        mss=mss+rss
  150 continue
      call sscomp(r, ncov, nter, nobs, 0, orss, idf, ifail)

      lrts=dfloat(nobs) * (ln(bss)-ln(orss))
      asyp=chip(lrts,max(1,mdf-1))
      mss=mss/dfloat(max(1,mdf))
      orss=orss/dfloat(max(1,idf))

      if (plevel.gt.0) then
        write(*,'(/3a/a/a)') 
     2    '  ------ QTL Association with "',locnam,'" -----',
     3    '    Allele   Allelic Mean    Stand Error   Count',
     4    '  ----------------------------------------------'
        ii=0
        do 155 i=1,numal
          ii=ii+i
          write(*,'(2x,i8,3x,f12.4,3x,f12.4,1x,i7)') 
     &       name(i),b(i),sqrt(cov(ii)),count(i)
  155   continue
        write(*,'(a/a,f12.4,3x,f12.4,1x,i7)') 
     2    '  ----------------------------------------------',
     3    '  Total      ',mu, sqrt(bss/dfloat(max(1,nobs-1))), 2*nobs

        write(*,'(2(/a,i7),2(/a,f12.4,a,i4,a))') 
     3    ' No. trait(+) marker(-)  =',nuntyp,
     4    ' No. trait(+) marker(+)  =',nobs,
     5    ' Model Mean Square       =', mss,' (df=',mdf,')',
     6    ' Mean Square Error       =',orss,' (df=',idf,')'
        write(*,'(a,f12.4,/a,f12.4)')
     2    ' Likelihood ratio test   =',lrts,
     3    ' Nominal P-value         =',asyp
      end if

      if (iter.gt.0) then
    
C Sequential Monte-Carlo P-value after Besag & Clifford Biometrika 1991
C P= tailp/it if tailp=mincnt or (tailp+1)/(it+1) if tailp<mincnt && it=iter
        mss=0.0d0
        vss=0.0d0
        tailp=0
   49   continue
        if (it.eq.iter .or. tailp.eq. mincnt) goto 50
          it=it+1
          call inicov(nter, ncov, r)
          rewind(wrk2)
   55     continue
            read(wrk2,end=70) n,nfound,
     &        (value(i),fa(i),mo(i),untyped(i),i=1,n)
            call simped(n,nfound,fa,mo,cumfrq,set)
            do 60 i=1,n
            if (.not.untyped(i).and.value(i).ne.MISS) then
              do 65 j=1,numal
                x(j)=0.0d0
   65         continue
              x(nter)=dble(value(i))
              x(set(i,1))=x(set(i,1))+1
              x(set(i,2))=x(set(i,2))+1
              call givenc(r, ncov, nter, x, 1.0d0, ifail)
            end if
   60       continue
          goto 55
   70     continue
          call alias(r, ncov, nter, 1.0d-15, x, ifail)
          call sscomp(r, ncov, nter, nobs, 0, rss, idf, ifail)
          rss=rss/dfloat(max(1,idf))
          call moment(it,rss,mss,vss)
          if (rss.lt.orss .or. (rss.eq.orss .and. 
     2        random().gt.0.5d0)) 
     3    then
            tailp=tailp+1
          end if
          if (plevel.gt.1) then
            write(*,'(/a,i4,a,f12.4)') 
     &       'Pseudosample ',it,': MSE=',rss
          end if
          goto 49
   50   continue
        if (tailp.lt.mincnt) then
          tailp=tailp+1
          it=it+1
        end if
        vss=vss/dfloat(max(1,it-1))
        pval=dfloat(tailp)/dfloat(it)
      else
        tailp=0
        pval=1.0d0
      end if

      if (plevel.gt.0) then
        write(*,'(a,i4,a,i5,a,f6.4,a/a,f12.4,a,f12.4,a)')
     2    ' Equalled or exceeded by =',tailp,'/',it,
     3    ' simulated values (',pval,')',
     4    ' Mean (SD) simulated MSE =',mss,' (',sqrt(vss),')'
      else
        call phist(asyp,pval,histo)
        write(*,'(a10,2(1x,i6),1x,f10.1,2(1x,f6.4),1x,i6,2(1x,a))')
     &    locnam, nobs, mdf, lrts, asyp, pval, it, 'ANOVA-HWE',histo
      end if
      return
      end
C end-of-doanova
C
C Additive allelic model for association with a quantitative trait
C Conditional on parental genotypes
C
      subroutine qtdt(wrk,wrk2,trait,locnam,gene,iter,mincnt,
     2             x,r,b,cov,pedigree,num,nfound,
     3             id,fa,mo,sex,locus,numloc,
     4             numal,name,untyped,value,count,set,plevel)
      integer KNOWN,MAXIBD,MAXSIZ,MAXLOC,MAXALL,MAXCOV,MAXTER,MISS
      parameter (KNOWN=0,MAXSIZ=1000,MAXLOC=120,MAXALL=60,MAXIBD=1000,
     2           MAXTER=MAXIBD/2,MAXCOV=(MAXALL+1)*(MAXALL+2)/2,
     3           MISS=-9999)
      integer gene,iter,mincnt,numal,numloc,plevel,trait,wrk,wrk2
      character*10 locnam
C Pedigree structure
      character*10 pedigree
      integer num, nfound
      character*8 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ), sex(MAXSIZ), set(MAXSIZ,2)
      real locus(MAXSIZ,MAXLOC)
      logical last, untyped(MAXSIZ)
C allele frequencies structure
      integer name(MAXALL)
C Storage for trait values during randomization
      integer count(MAXSIZ)
      real value(MAXSIZ)
C arrays for allelic effects
      double precision x(MAXTER), r(MAXCOV), b(MAXTER), cov(MAXCOV)
C local variables
      integer contrib,gen2,i,idf,ii,it,j,mdf,ncov,nobs,nter,tailp,nuntyp
      character*3 histo
      double precision asyp,bss,lrts,mss,mu,pval,orss,rss,vss
C functions
      integer getnam
      real random
      double precision chip, ln

      last=.false.
      nobs=0
      nter=numal+1
      ncov=nter*(nter+1)/2
      gen2=gene+1
      call inicov(nter, ncov, r)
      mu=0.0d0
      bss=0.0d0
      nuntyp=0
      do 5 i=1,numal
        count(i)=0
    5 continue
      rewind(wrk)
   10 continue
       call wrkin(wrk,pedigree,num,nfound,id,fa,mo,sex,locus,numloc,
     &            last)
       if (last) goto 20
C
C load set() with genotypes
        do 11 i=1,num
          untyped(i)=.false.
          value(i)=MISS
          if (locus(i,gene).lt.KNOWN) then
            untyped(i)=.true.
            set(i,1)=MISS
            set(i,2)=MISS
          else
            set(i,1)=getnam(locus(i,gene),numal,name)
            set(i,2)=getnam(locus(i,gen2),numal,name)
          end if
   11   continue
C
C Only phenotyped persons with genotyped parents used-> value() set to trait
        contrib=0
        do 12 i=nfound+1,num
          if (locus(i,trait).ne.MISS .and. .not.untyped(i) .and.
     &        .not.untyped(fa(i)) .and. .not.untyped(mo(i))) then
            contrib=contrib+1
	    value(i)=locus(i,trait)
            nobs=nobs+1
            do 15 j=1,numal
              x(j)=0.0d0
   15       continue
            x(nter)=dble(value(i))
            x(set(i,1))=x(set(i,1))+1
            x(set(i,2))=x(set(i,2))+1
            count(set(i,1))=count(set(i,1))+1
            count(set(i,2))=count(set(i,2))+1
            call moment(nobs,x(nter),mu,bss)
            call givenc(r, ncov, nter, x, 1.0d0, ifail)
          end if
   12   continue
        if (contrib.gt.0) then
          write(wrk2) num,nfound,
     &     (value(i),fa(i),mo(i),untyped(i),set(i,1),set(i,2),i=1,num) 
        end if
      goto 10
   20 continue

      if (nobs.eq.0) then
        if (plevel.gt.0) then
          write(*,'(/3a/a/a/a/2(/a,i7))') 
     2    '  ------ QTL Association with "',locnam,'"-------',
     3    '  ------ Conditioned on Parental Genotype -------',
     4    '  -----------------------------------------------',
     5    ' No. trait(+) marker(-)  =',nuntyp,
     6    ' No. trait(+) marker(+)  =',nobs 
        else
          write(*,'(a10,2(1x,i6),1x,f10.1,2(1x,f6.4),1x,i6,1x,a)')
     &    locnam, nobs, 0, 0.0d0, 1.0d0, 1.0d0, 0, 'ANOVA-CPG .'
        end if
        return
      end if
      call alias(r, ncov, nter, 1.0d-15, x, ifail)
      call bsub(r, ncov, nter, b, numal, ifail)
      call var(r, ncov, cov, ncov, nter, nobs, 1, ifail)
      mdf=0
      mss=0.0d0
      do 150 i=1,numal
        call sscomp(r, ncov, nter, nobs, i, rss, idf, ifail)
        mdf=mdf+idf
        mss=mss+rss
  150 continue
      call sscomp(r, ncov, nter, nobs, 0, orss, idf, ifail)
      lrts=dfloat(nobs) * (ln(bss)-ln(orss))
      asyp=chip(lrts,max(1,mdf-1))
      mss=mss/dfloat(max(1,mdf))
      orss=orss/dfloat(max(1,idf))
      if (plevel.gt.0) then
        write(*,'(/3a/a/a/a)') 
     2  '  ------ QTL Association with "',locnam,'"-------',
     3  '  ------ Conditioned on Parental Genotype -------',
     4  '    Allele   Allelic Mean    Stand Error   Count',
     5  '  -----------------------------------------------'
      ii=0
      do 155 i=1,numal
        ii=ii+i
        write(*,'(2x,i8,3x,f12.4,3x,f12.4,1x,i7)') 
     &     name(i),b(i),sqrt(cov(ii)),count(i)
  155 continue
        write(*,'(a/a,f12.4,3x,f12.4,1x,i7)') 
     2    '  ----------------------------------------------',
     3    '  Total      ',mu, sqrt(bss/dfloat(max(1,nobs-1))), 2*nobs
        write(*,'(2(/a,i7),2(/a,f12.4,a,i4,a))') 
     3  ' No. trait(+) marker(-)  =',nuntyp,
     4  ' No. trait(+) marker(+)  =',nobs,
     5  ' Model Mean Square       =', mss,' (df=',mdf,')',
     6  ' Mean Square Error       =',orss,' (df=',idf,')'
        write(*,'(a,f12.4,/a,f12.4)')
     2    ' Likelihood ratio test   =',lrts,
     3    ' Nominal P-value         =',asyp
      end if
      if (iter.gt.0) then
    
C Sequential Monte-Carlo P-value after Besag & Clifford Biometrika 1991
C P= tailp/it if tailp=mincnt or (tailp+1)/(it+1) if tailp<mincnt && it=iter
        mss=0.0d0
        vss=0.0d0
        it=0
        tailp=0
   49   continue
        if (it.eq.iter .or. tailp.eq. mincnt) goto 50
          it=it+1
          call inicov(nter, ncov, r)
          rewind(wrk2)
   55     continue
            read(wrk2,end=70) num,nfound,
     &      (value(i),fa(i),mo(i),untyped(i),set(i,1),set(i,2),i=1,num) 
            call csimped(num,nfound,fa,mo,untyped,set)
            do 60 i=1,num
            if (value(i).ne.MISS) then
              do 65 j=1,numal
                x(j)=0.0d0
   65         continue
              x(nter)=dble(value(i))
              x(set(i,1))=x(set(i,1))+1
              x(set(i,2))=x(set(i,2))+1
              call givenc(r, ncov, nter, x, 1.0d0, ifail)
            end if
   60       continue
          goto 55
   70     continue
          call alias(r, ncov, nter, 1.0d-15, x, ifail)
          call sscomp(r, ncov, nter, nobs, 0, rss, idf, ifail)
          rss=rss/dfloat(max(1,idf))
          call moment(it,rss,mss,vss)
          if (rss.lt.orss .or. (rss.eq.orss .and. 
     2        random().gt.0.5d0)) 
     3    then
            tailp=tailp+1
          end if
          if (plevel.gt.1) then
            write(*,'(/a,i4,a,f12.4)') 
     &       'Pseudosample ',it,': MSE=',rss
          end if
          goto 49
   50   continue
        if (tailp.lt.mincnt) then
          tailp=tailp+1
          it=it+1
        end if
        vss=vss/dfloat(max(1,it-1))
        pval=dfloat(tailp)/dfloat(it)
      else
        tailp=0
        pval=1.0d0
      end if

      if (plevel.gt.0) then
        write(*,'(a,i4,a,i5,a,f6.4,a/a,f12.4,a,f12.4,a)')
     2    ' Equalled or exceeded by =',tailp,'/',it,
     3    ' simulated values (',pval,')',
     4    ' Mean (SD) simulated MSE =',mss,' (',sqrt(vss),')'
      else
        call phist(asyp,pval,histo)
        write(*,'(a10,2(1x,i6),1x,f10.1,2(1x,f6.4),1x,i6,2(1x,a))')
     &    locnam, nobs, mdf, lrts, asyp, pval, it, 'ANOVA-CPG',histo
      end if
      return
      end
C end-of-qtdt
C
C Count alleles in cases and controls -- codominant system
C
      subroutine doassoc(wrk,wrk2,trait,locnam,gene,iter,mincnt,assfnd,
     2                   gt,thresh,pedigree,num,nfound,id,fa,mo,sex,
     3                   locus,numloc,numal,name,cntall,cumfrq,
     4                   aff,untyped,set,plevel)
      integer KNOWN,MAXSIZ,MAXLOC,MAXALL,MAXG,MISS
      parameter (KNOWN=0,MAXSIZ=1000,MAXLOC=120,MAXALL=60,
     &           MAXG=MAXALL*(MAXALL+1)/2,MISS=-9999)
      integer gene,iter,mincnt,numal,numloc,plevel,trait,wrk,wrk2
      real thresh
      logical assfnd, gt
      character*10 locnam
C Pedigree structure
      character*10 pedigree
      integer num, nfound
      character*8 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ)
      integer sex(MAXSIZ)
      real locus(MAXSIZ,MAXLOC)
      logical last
C work arrays
      integer aff(MAXSIZ), set(MAXSIZ,2)
      logical untyped(MAXSIZ)
C allele frequencies structure
      integer name(MAXALL)
      double precision cumfrq(MAXALL)
C array for allele counts in cases and controls
      integer cntall(MAXG,4)
      integer g1,g2,i,it,df,gen2,nca,nco,nuntyp,tailp
      character*3 histo
      real casden, conden
      double precision asyp, chisq, mchisq, ochisq, pexp, pval, vchisq
C functions
      integer getnam
      real isaff, random
      double precision twobyk, chip, binz

      last=.false.
      df=-1
      gen2=gene+1
      nca=0
      nco=0
      nuntyp=0
      do 2 j=1,numal  
      do 2 k=1,3
        cntall(j,k)=0
    2 continue
      mchisq=0.0d0
      vchisq=0.0d0
      rewind(wrk)
   10 continue
       call wrkin(wrk,pedigree,num,nfound,id,fa,mo,sex,locus,numloc,
     &            last)
       if (last) goto 20

        if (assfnd) then
          do 12 i=1,nfound
            aff(i)=int(isaff(locus(i,trait),thresh,gt))
            if (locus(i,gene).lt.KNOWN) then
              if (aff(i).ne.MISS) nuntyp=nuntyp+1
            elseif (aff(i).eq.1.or.aff(i).eq.2) then
              g1=getnam(locus(i,gene),numal,name)
              g2=getnam(locus(i,gen2),numal,name)
              cntall(g1,aff(i))=cntall(g1,aff(i))+1
              cntall(g2,aff(i))=cntall(g2,aff(i))+1
            endif
   12     continue
        else
          do 15 i=1,num
            untyped(i)=.false.
            aff(i)=int(isaff(locus(i,trait),thresh,gt))
            if (locus(i,gene).lt.KNOWN) then
              untyped(i)=.true.
              if (aff(i).ne.MISS) nuntyp=nuntyp+1
            elseif (aff(i).eq.1.or.aff(i).eq.2) then
              g1=getnam(locus(i,gene),numal,name)
              g2=getnam(locus(i,gen2),numal,name)
              cntall(g1,aff(i))=cntall(g1,aff(i))+1
              cntall(g2,aff(i))=cntall(g2,aff(i))+1
            endif
   15     continue
          write(wrk2) num,nfound,
     &      (aff(i),fa(i),mo(i),untyped(i),i=1,num)
        end if
      goto 10
   20 continue
      do 25 i=1,numal
        nco=nco+cntall(i,1)
        nca=nca+cntall(i,2)
        cntall(i,3)=cntall(i,1)+cntall(i,2)
        if (cntall(i,3).gt.0) df=df+1
   25 continue
      if (nca.gt.0 .and. nco.gt.0) then
        pexp=dfloat(nca)/dfloat(nca+nco)
        ochisq=twobyk(numal,cntall,pexp)
        asyp=chip(ochisq,df)
      else
        pexp=0.0d0
        ochisq=0.0d0
        asyp=1.0d0
      end if

      if (plevel.gt.0) then
        write(*,'(/3a/a/a)') 
     2    '  ---- Association Analysis for "',locnam,'"----',
     3    '    Allele   Affected   Unaffected   Total    Dev',
     4    '  -----------------------------------------------'
        casden=max(1.0,float(nca))
        conden=max(1.0,float(nco))
        do 30 i=1,numal  
          write(*,'(i8,2(2x,i5,1x,a1,f3.2,a1),i8,1x,f6.1)') 
     2     name(i),cntall(i,2),'(',float(cntall(i,2))/casden,')',
     3     cntall(i,1),'(',float(cntall(i,1))/conden,')',cntall(i,3),
     4     binz(cntall(i,2),cntall(i,3),pexp)
   30   continue
        write(*,'(a/a8,2(2x,i5,6x),i8)') 
     2    '  -----------------------------------------------',
     3      'Total',nca,nco,nca+nco
        write(*,'(/a,i6/a,i6)') 
     2    '       No. trait(+) marker(-) =',nuntyp,
     3    '       No. trait(+) marker(+) =',(nca+nco)/2
        write(*,'(a,f6.1/a,i4/a,3x,f6.4)')
     2    '   Contingency Pearson chi-sq =',ochisq,
     3    '   Nominal degrees of freedom =',df,
     4    '              Nominal P-value =',asyp
      end if
C
C if founders only, or no cases or no controls or iter=0, then
C Monte-Carlo procedure superfluous
C
      it=0
      if (assfnd .or. nca.eq.0 .or. nco.eq.0 .or. iter.eq.0) then
        tailp=0
        pval=1.0d0
      else
C
C Sequential Monte-Carlo P-value after Besag & Clifford Biometrika 1991
C P= tailp/it if tailp=mincnt or (tailp+1)/(it+1) if tailp<mincnt && it=iter
C
        tailp=0
   49   continue
        if (it.eq.iter .or. tailp.eq.mincnt) goto 50
          it=it+1
          do 52 j=1,numal  
          do 52 k=1,3
            cntall(j,k)=0
   52     continue
          rewind(wrk2)
   55     continue
            read(wrk2,end=70) num,nfound,
     &        (aff(i),fa(i),mo(i),untyped(i),i=1,num)
            call simped(num,nfound,fa,mo,cumfrq,set)
            do 65 i=1,num
            if (.not.untyped(i).and.(aff(i).eq.1.or.aff(i).eq.2)) then
              cntall(set(i,1),aff(i))=cntall(set(i,1),aff(i))+1
              cntall(set(i,2),aff(i))=cntall(set(i,2),aff(i))+1
            endif
   65       continue
          goto 55
   70     continue

          do 80 i=1,numal  
            cntall(i,3)=cntall(i,1)+cntall(i,2)
   80     continue
          chisq=twobyk(numal,cntall,pexp)
          call moment(it,chisq,mchisq,vchisq)
          if (chisq.gt.ochisq .or. (chisq.eq.ochisq .and.
     2        random().gt.0.5)) 
     3    then
            tailp=tailp+1
          end if
          if (plevel.gt.1) then
            write(*,'(/a,i4,a,f6.1)') 
     &        'Pseudosample ',it,': Chisq=',chisq
            do 85 i=1,numal
              write(*,'(i8,2(2x,i5,1x,a1,f3.2,a1),i8)') 
     2          name(i),cntall(i,2),'(',float(cntall(i,2))/float(nca),
     3          ')',cntall(i,1),'(',float(cntall(i,1))/float(nco),')',
     4          cntall(i,3)
   85        continue
          end if
          goto 49
   50   continue
        if (tailp.lt.mincnt) then
          tailp=tailp+1
          it=it+1
        end if
        vchisq=vchisq/dfloat(max(1,it-1))
        pval=dfloat(tailp)/dfloat(it)
      end if
      if (plevel.gt.0) then
        write(*,'(a,i4,a,i5,a,f6.4,a/a,f6.1,a,f6.1,a)')
     2    '      Equalled or exceeded by =',tailp,'/',it,
     3    ' simulated values (',pval,')',
     4    ' Mean (Var) simulated chi-sqs =',mchisq,' (',vchisq,')'
      else
        call phist(asyp,pval,histo)
        write(*,'(a10,2(1x,i6),1x,f10.1,2(1x,f6.4),1x,i6,2(1x,a))')
     2    locnam, (nca+nco)/2, df, ochisq, asyp, pval, it, 
     3    'AssX2-HWE',histo
      end if
      return
      end
C end-of-doassoc
C
C Pearson chi-sq for 2xK table (uses only cntall(,1-3))
C
      double precision function twobyk(nallele,cntall,pexp)
      integer MAXALL,MAXG
      parameter(MAXALL=60,MAXG=MAXALL*(MAXALL+1)/2)
      integer nallele, cntall(MAXG,4)
      double precision pexp
      integer i
      double precision num1,num2, den1, den2
      twobyk=0.0d0
      if (pexp.eq.0.0d0 .or. pexp.eq.1.0d0) return
      do 10 i=1,nallele
      if (cntall(i,3).gt.0) then
        den2=pexp*dfloat(cntall(i,3))
        den1=dfloat(cntall(i,3))-den2
        num2=dfloat(cntall(i,2))-den2
        num1=dfloat(cntall(i,1))-den1
        twobyk=twobyk+(num1*num1)/den1+(num2*num2)/den2
      end if
   10 continue
      return
      end
C end-of-twobyk
C
C Test the 4 possible unions of gametes 1 2 3 4 -> 13 14 23 24 
C if type=0 return both parental contributions, else 1=pat, 2=mat
C
      subroutine trans(pg1,pg2,mg1,mg2,cg1,cg2,tr1,tr2,nt1,nt2,type)
      integer MISS
      parameter(MISS=-9999)
      integer pg1,pg2,mg1,mg2,cg1,cg2,tr1,tr2,nt1,nt2,type
      tr1=MISS
      tr2=MISS
      nt1=MISS
      nt2=MISS
      if ((pg1.eq.MISS).and.(mg1.ne.MISS).and.
     2    .not.((mg1.eq.cg1).and.(mg2.eq.cg2)) 
     3   .and.((mg1.eq.cg1).or.(mg1.eq.cg2))) then
        tr1=mg1
        nt1=mg2
        tr2=MISS
        nt2=MISS
      elseif((pg1.eq.MISS).and.(mg1.ne.MISS)
     2       .and..not.((mg1.eq.cg1).and.(mg2.eq.cg2)) 
     3       .and.((mg2.eq.cg1).or.(mg2.eq.cg2))) then 
        tr1=mg2
        nt1=mg1
        tr2=MISS
        nt2=MISS
      elseif((pg1.ne.MISS).and.(mg1.eq.MISS)
     2        .and..not.((pg1.eq.cg1).and.(pg2.eq.cg2))  
     3        .and.((pg1.eq.cg1).or.(pg1.eq.cg2))) then
        tr1=MISS
        nt1=MISS
        tr2=pg1
        nt2=pg2
      elseif((pg1.ne.MISS).and.(mg1.eq.MISS)
     2        .and..not.((pg1.eq.cg1).and.(pg2.eq.cg2))
     3        .and.((pg2.eq.cg1).or.(pg2.eq.cg2))) then
        tr1=MISS
        nt1=MISS
        tr2=pg2
        nt2=pg1
      elseif(((pg1.eq.cg1).and.(mg1.eq.cg2))
     2        .or.((pg1.eq.cg2).and.(mg1.eq.cg1))) then
        tr1=mg1
        nt1=mg2
        tr2=pg1
        nt2=pg2
      elseif(((pg1.eq.cg1).and.(mg2.eq.cg2))
     2        .or.((pg1.eq.cg2).and.(mg2.eq.cg1))) then
        tr2=pg1
        nt2=pg2
        tr1=mg2
        nt1=mg1
      elseif(((pg2.eq.cg1).and.(mg1.eq.cg2))
     2        .or.((pg2.eq.cg2).and.(mg1.eq.cg1))) then
       tr2=pg2
       nt2=pg1
       tr1=mg1
       nt1=mg2
      elseif(((pg2.eq.cg1).and.(mg2.eq.cg2))
     2        .or.((pg2.eq.cg2).and.(mg2.eq.cg1))) then
       tr2=pg2
       nt2=pg1
       tr1=mg2
       nt1=mg1
      end if
C check to see which parental contribution to retain
      if (type.eq.1) then
        tr2=MISS
        nt2=MISS
      elseif (type.eq.2) then
        tr1=MISS
        nt1=MISS
      end if
      return
      end
C end-of-trans
C
C Increment counts of transmitted and nontransmitted alleles: parentwise
C
      subroutine incpo(tr,nt,nall,cntall)
      integer MAXALL,MAXG,MISS
      parameter(MAXALL=60,MAXG=MAXALL*(MAXALL+1)/2,MISS=-9999)
      integer tr,nt,nall,cntall(MAXG,4)
      integer i,j,a1,a2
      logical trans
      if (tr.eq.MISS.or.nt.eq.MISS.or.tr.eq.nt) return
      if (tr.le.nt) then
        trans=.true.
        a1=tr
        a2=nt
      else
        trans=.false.
        a1=nt
        a2=tr
      end if
      i=0
    5 continue
        i=i+1
      if (i.le.nall .and. (a1.gt.cntall(i,1).or.
     &    (a1.eq.cntall(i,1).and.a2.gt.cntall(i,2)))) goto 5
      if (i.le.nall .and. cntall(i,1).eq.a1.and.cntall(i,2).eq.a2) then
        if (trans) then
          cntall(i,3)=cntall(i,3)+1
        else
          cntall(i,4)=cntall(i,4)+1
        end if
      else
        do 20 j=nall,i,-1
        do 20 k=1,4
   20     cntall(j+1,k)=cntall(j,k)
        cntall(i,1)=a1
        cntall(i,2)=a2
        if(trans) then
          cntall(i,3)=1
          cntall(i,4)=0
        else
          cntall(i,3)=0
          cntall(i,4)=1
        end if
        nall=nall+1
      end if
      return
      end
C end-of-incpo
C
C Increment counts of transmitted and expected genotypes
C Revised after reading Thomas 1999
C
      subroutine incr(tr1,tr2,nt1,nt2,ngcount,gcount)
      integer MAXALL,MAXG,MISS
      parameter(MAXALL=60,MAXG=MAXALL*(MAXALL+1)/2,MISS=-9999)
      integer tr1,tr2,nt1,nt2,ngcount,gcount(MAXG,4)
C only use cases both parents typed
      if (nt1.eq.MISS .or. nt2.eq.MISS) return
C case
      call insgen(tr1,tr2,ngcount,gcount,3,1)
C 4 pseudo-sibs for control distribution
      call insgen(tr1,tr2,ngcount,gcount,4,1)
      call insgen(tr1,nt2,ngcount,gcount,4,1)
      call insgen(nt1,tr2,ngcount,gcount,4,1)
      call insgen(nt1,nt2,ngcount,gcount,4,1)
      return
      end
C end-of-incr
C
C update counts of genotypes or haplotypes for cases or controls -- 
C binary search and insertion sort
C
      subroutine insgen(a1,a2,ngcount,gcount,type,haplo)
      integer MAXALL, MAXG 
      parameter(MAXALL=60,MAXG=MAXALL*(MAXALL+1)/2)
      integer a1,a2,haplo,ngcount,gcount(MAXG,4),type
      integer g1,g2,hi,j,k,lo,pos
C if genotype, order by allele size rather than parent of origin
      if (haplo.eq.2 .or. a1.le.a2) then
        g1=a1
        g2=a2
      else
        g1=a2
        g2=a1
      end if
      pos=1
      hi=ngcount
      lo=1
    1 continue 
      if (hi.lt.lo) goto 5
        pos=(hi+lo)/2
        if (g1.gt.gcount(pos,1) .or.
     &      (g1.eq.gcount(pos,1) .and. g2.gt.gcount(pos,2))) then
          lo=pos+1
        elseif (g1.lt.gcount(pos,1).or.
     &      (g1.eq.gcount(pos,1) .and. g2.lt.gcount(pos,2))) then
          hi=pos-1
        else
          gcount(pos,type)=gcount(pos,type)+1
          return
        end if
      goto 1
    5 continue
C else create new category
      do 50 j=ngcount,pos,-1
      do 50 k=1,4
        gcount(j+1,k)=gcount(j,k)
   50 continue
      gcount(lo,1)=g1
      gcount(lo,2)=g2
      gcount(lo,3)=0
      gcount(lo,4)=0        
      gcount(lo,type)=1
      ngcount=ngcount+1
      return
      end
C end-of-insgen
C
C Monte-Carlo approach to various TDTs
C
      subroutine dotdt(wrk,wrk2,trait,locnam,gene,iter,mincnt,use2,type,
     2             cutoff,gt,thresh,pedigree,num,nfound,id,fa,mo,sex,
     3             locus, numloc, numal, name, untyped, set,
     4             nallele,cntall,ngcount,gcount,plevel)
      integer MAXALL, MAXG, MAXSIZ, MAXLOC, MISS, KNOWN
      parameter(MAXALL=60, MAXG=MAXALL*(MAXALL+1)/2, 
     &          MAXSIZ=1000, MAXLOC=120, MISS=-9999, KNOWN=0)
      integer cutoff,gene,iter,mincnt,plevel,trait,type,use2,wrk,wrk2
      real thresh
      logical gt
      character*10 locnam
C pedigree structure
      character*10 pedigree
      integer sex(MAXSIZ)
      integer num, nfound
      character*8 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ), set(MAXSIZ,2)
      real locus(MAXSIZ,MAXLOC)
C allele frequencies structure
      integer numal, name(MAXALL)
C Genotype counts: allele1,allele2, number transmitted, number not trans
      integer nallele,cntall(MAXG,4), ngcount,gcount(MAXG,4)
C
      integer cg1,cg2,pg1,pg2,mg1,mg2,tr1,tr2,nt1,nt2
      logical last, untyped(MAXSIZ)
      integer alltr,allnt,df,gdf,gen2,i,it,j,k,mxiter,ntest,tailp,tot
      integer aff(MAXSIZ),naff,prob,probandi
      character*3 histo
      double precision celltdt, tdt, otdt, gtdt, mgtdt, mcnem, pval
      double precision asyp, bestm, bestp, ewens, ftdev
      character*7 gtp, gtp2
C functions 
      double precision binp, bonf, chip, clcchi, clcmcn, ln
      real isaff,random
      logical tdtuse
C
      df=0
      ewens=0.0d0
      gdf=0
      gen2=gene+1
      nallele=0
      ngcount=0
      ntest=0
      mgtdt=0.0d0
      probandi=0
      tot=0
      tdt=0.0d0
      do 2 i=1,MAXG
      do 2 j=1,4
        gcount(i,j)=0
        cntall(i,j)=0
    2 continue
      last=.false.
      rewind(wrk)
C
C If high print level, then list transmitted and nontransmitted alleles
C for each informative proband
C
      if (plevel.gt.1) then
        write(*,'(a/a)') 'Informative Child   Trans    Not Tr ',
     &                   'Pedigree  ID        Mat Pat  Mat Pat'
      end if
C
   10 continue
       call wrkin(wrk,pedigree,num,nfound,id,fa,mo,sex,locus,numloc,
     &            last)
       if (last) goto 20
         naff=0
         do 11 i=1,nfound
           untyped(i)=.false.
           if (locus(i,gene).lt.KNOWN) untyped(i)=.true.
   11    continue
         do 12 i=nfound+1,num
           untyped(i)=.false.
           if (locus(i,gene).lt.KNOWN) then
             untyped(i)=.true.
           else if (isaff(locus(i,trait),thresh,gt).eq.2.0 .and. 
     &              tdtuse(i,gene,naff,fa,mo,locus,use2)) then
C
C nonfounder affected & typed & 1 or 2 parents heterozygous at marker
C 
             naff=naff+1
             aff(naff)=i
             pg1=MISS
             pg2=MISS
             if (locus(fa(i),gene).gt.KNOWN) then
               pg1=int(locus(fa(i),gene))
               pg2=int(locus(fa(i),gen2))
             end if
             mg1=MISS
             mg2=MISS
             if (locus(mo(i),gene).gt.KNOWN) then
               mg1=int(locus(mo(i),gene))
               mg2=int(locus(mo(i),gen2))
             end if
             cg1=int(locus(i,gene))
             cg2=int(locus(i,gen2))
             call trans(pg1,pg2,mg1,mg2,cg1,cg2,tr1,tr2,nt1,nt2,type)
             if (plevel.gt.1) then
               call wrgtp(tr1,tr2,gtp,2)
               call wrgtp(nt1,nt2,gtp2,2)
               write(*,'(a10,a8,2(1x,a8))') pedigree,id(i),gtp,gtp2
             end if
             call incpo(tr1,nt1,nallele,cntall)
             call incpo(tr2,nt2,nallele,cntall)
             call incr(tr1,tr2,nt1,nt2,ngcount,gcount)
           end if
   12    continue
         probandi=probandi+naff
         if (naff.gt.0) then
           do 14 i=1,num   
             set(i,1)=MISS
             set(i,2)=MISS
             if (locus(i,gene).gt.KNOWN) then
               set(i,1)=int(abs(locus(i,gene)))
               set(i,2)=int(abs(locus(i,gen2)))
             end if
   14      continue
           write(wrk2) naff,(aff(i),i=1,naff),num,nfound,
     &       (fa(i),mo(i),untyped(i),set(i,1),set(i,2),i=1,num) 
         end if
       goto 10
   20  continue
C
      if (plevel.gt.1) then
        write(*,*)
      end if
      if (plevel.gt.0) then
        write(*,'(/a,i3)') 'Number of informative probands: ',probandi
C
        write(*,'(/3a/a/a)') 
     2   '  - Allele by Allele TDT:"',locnam,'" -',
     3   '  Allele   Trans  Not Tr   TDT   P-value',
     4   '  --------------------------------------'
      end if
      bestm=0.0d0
      bestp=1.0d0
      do 215 i=1,numal
        alltr=0
        allnt=0
        do 220 j=1,nallele
          if (cntall(j,1).eq.name(i)) then
            alltr=alltr+cntall(j,3)
            allnt=allnt+cntall(j,4)
          elseif (cntall(j,2).eq.name(i)) then
            alltr=alltr+cntall(j,4)
            allnt=allnt+cntall(j,3)
          end if
  220   continue
        if ((alltr+allnt).gt.cutoff) then
          ntest=ntest+1
          mcnem=clcmcn(alltr,allnt)
          ewens=ewens+mcnem
          pval=binp(dfloat(alltr),dfloat(allnt))
          if (pval.lt.bestp) then
            bestp=pval
            bestm=mcnem
          end if
          if (plevel.gt.0) then
            write(*,'(3i8,f6.1,4x,f6.4)') 
     &        name(i),alltr,allnt,mcnem,pval 
          end if
        end if
  215 continue
      if (ntest.gt.1) ewens=dfloat(ntest-1)*ewens/dfloat(ntest)

      if (plevel.gt.0) then
        if (cutoff.gt.0)
     &     write(*,'(/a,i4)') 'Not using rows with totals   =<',cutoff
        if (ntest.gt.0) then
          write(*,'(/a,i4,3(/a,3x,f8.6)/)') 
     2    'No. of alleles used  = ',ntest,
     3    'Bonferroni corr. 5%  = ',bonf(ntest-1,0.05d0),
     4    'Bonferroni corr. 1%  = ',bonf(ntest-1,0.01d0),
     5    'Bonferroni corr. 0.1%= ',bonf(ntest-1,0.001d0)
        else
          write(*,'(a)') 'No alleles meet inclusion criteria'
        end if
      else
        asyp=min(1.0d0,(ntest-1)*bestp)
        call phist(asyp,asyp,histo)
        write(*,'(a10,2(1x,i6),1x,f10.1,2(1x,f6.4),1x,i6,2(1x,a))')
     2    locnam, probandi, ntest, bestm, asyp, asyp,
     3    0, 'TDT-Best ', histo
      end if
C
      alltr=0
      allnt=0
      if (plevel.gt.0) then
        write(*,'(/a/a/a)') 
     2    '  -------- Global Allelic TDT --------',
     3    '   All 1   All 2    Tr=1    Tr=2   TDT',
     4    '  ------------------------------------'
      end if
      do 15 i=1,nallele
        celltdt=0.0d0
        alltr=alltr+cntall(i,3)
        allnt=allnt+cntall(i,4)
        if ((cntall(i,3)+cntall(i,4)).gt.cutoff) then
          celltdt=dfloat(cntall(i,3)-cntall(i,4))**2
     &            /dfloat(cntall(i,3)+cntall(i,4))
          tdt=tdt+celltdt
          df=df+1
        end if
        if (plevel.gt.0) then
          write(*,'(4i8,f6.1)') 
     &       cntall(i,1),cntall(i,2),cntall(i,3),cntall(i,4),celltdt
        end if
   15 continue
      tot=alltr+allnt
      asyp=1.0d0
      if (df.gt.0) asyp=chip(tdt,df)

      if (plevel.gt.0) then
        write(*,'(/a,f6.1)') 'Allelic TDT Pearson chi-square=',tdt
        if (cutoff.gt.0) then
           write(*,'(a,i4)') 'Not using rows with totals   =<',cutoff
        end if
        write(*,'(12x,a,i4)') 'Degrees of freedom=',df
        write(*,'(23x,a,3x,f6.4)') 'P-value=', asyp
      end if
      if (iter.gt.0 .and. tot.gt.0) then
        mxiter=10*iter
        call shuffle(nallele,cntall,tot,cutoff,tdt,mxiter,mincnt,
     &               pval)
      else
        mxiter=0
        pval=1.0d0
      end if
      if (plevel.gt.0) then
        write(*,'(a,i7,a,3x,f6.4)') 
     &   'Empiric P-value (',mxiter,' iter)=',pval
        write(*,'(/a,f6.1)') '  Ewens allelic TDT chi-square=',ewens
        write(*,'(12x,a,i4)') 'Degrees of freedom=',ntest-1
        write(*,'(23x,a,3x,f6.4)') 'P-value=',chip(ewens,ntest-1)
        write(*,'(/a/a/a)') 
     2    '  ----- Genotypic Transmission Test ------',
     3    '       Genotype     Trans  Expected   Dev',
     4    '  ----------------------------------------'
      else
        call phist(asyp,pval,histo)
        write(*,'(a10,2(1x,i6),1x,f10.1,2(1x,f6.4),1x,i6,2(1x,a))')
     2    locnam, probandi, df, tdt, asyp, pval,mxiter,'TDT-All  ',histo
        asyp=chip(ewens,ntest-1)
        call phist(asyp,asyp,histo)
        write(*,'(a10,2(1x,i6),1x,f10.1,2(1x,f6.4),1x,i6,2(1x,a))')
     2    locnam, probandi, ntest-1, ewens, asyp, asyp, 0, 
     3    'TDT-Ewens',histo
      end if

      otdt=0.0d0
      do 225 i=1,ngcount
        if (gcount(i,3).gt.cutoff) then
          gdf=gdf+1
          if (gcount(i,4).gt.cutoff) then
            otdt=otdt+dfloat(gcount(i,3))*
     &           ln(dfloat(4*gcount(i,3))/dfloat(gcount(i,4)))
          end if
        end if    
        call wrgtp(gcount(i,1),gcount(i,2),gtp,1)
        if (plevel.gt.0) then
          write(*,'(8x,a7,1x,i8,1x,f9.1,1x,f6.1)') 
     2     gtp,gcount(i,3),0.25d0*dfloat(gcount(i,4)),
     3     ftdev(dfloat(gcount(i,3)),0.25d0*dfloat(gcount(i,4)))
        end if
  225 continue
      otdt=otdt+otdt
      gdf=max(gdf-1,1)
      asyp=chip(otdt,gdf)
C
C Monte-Carlo only if iter>0
C
      it=0
      tailp=0
      if (iter.eq.0) then
        pval=1.0d0
      else
C Sequential Monte-Carlo P-value after Besag & Clifford Biometrika 1991
C P= tailp/it if tailp=mincnt or (tailp+1)/(it+1) if tailp<mincnt && it=iter
   49   continue
        if (it.eq.iter .or. tailp.eq. mincnt) goto 50
          it=it+1
          do 52 j=1,ngcount
          do 52 k=1,4
            gcount(j,k)=0
   52     continue        
          ngcount=0
          rewind(wrk2)

   55     continue
            read(wrk2,end=70) naff,(aff(i),i=1,naff),num,nfound,
     &        (fa(i),mo(i),untyped(i),set(i,1),set(i,2),i=1,num) 
            call csimped(num,nfound,fa,mo,untyped,set)
            do 60 i=1,naff
              prob=aff(i)
              pg1=set(fa(prob),1)
              pg2=set(fa(prob),2)
              mg1=set(mo(prob),1)
              mg2=set(mo(prob),2)
              cg1=set(prob,1)
              cg2=set(prob,2)
              call trans(pg1,pg2,mg1,mg2,cg1,cg2,tr1,tr2,nt1,nt2,type)
              call incr(tr1,tr2,nt1,nt2,ngcount,gcount)
   60       continue
          goto 55
   70     continue
          gtdt=clcchi(ngcount,gcount,cutoff)
          mgtdt=mgtdt+gtdt
          if (gtdt.gt.otdt .or. (gtdt.eq.otdt .and. 
     2        random().gt.0.5d0)) 
     3    then
            tailp=tailp+1
          end if
          if (plevel.gt.1) then
            write(*,'(/a,i4,a,f6.1)') 
     &       'Pseudosample ',it,': gX2 =',gtdt
            do 325 i=1,ngcount
              call wrgtp(gcount(i,1),gcount(i,2),gtp,1)
  325         write(*,'(8x,a7,1x,2i8)') 
     &          gtp,gcount(i,3),gcount(i,4)
          end if
          goto 49
   50   continue
        if (tailp.lt.mincnt) then
          tailp=tailp+1
          it=it+1
        end if
        mgtdt=mgtdt/dfloat(it)
        pval=dfloat(tailp)/dfloat(it)
      end if
      if (plevel.gt.0) then
        write(*,'(/a,f6.1/a,i4)')
     2    'Genotypic Transmission Chi-sq =',otdt,
     3    '   Nominal degrees of freedom =',gdf
        if (cutoff.gt.0) then
          write(*,'(a,i4)') 'Not using rows with totals   =<',cutoff
        end if
        write(*,'(14x,a,3x,f6.4)') 'Nominal P-value =',asyp
        write(*,'(6x,a,i4,a,i4,a,f6.4,a/a,f6.1)')
     2    'Equalled or exceeded by =',tailp,'/',it,
     3    ' simulated values (',pval,')',
     4    'Mean of simulated chi-squares =',mgtdt
      else
        call phist(asyp,pval,histo)
        write(*,'(a10,2(1x,i6),1x,f10.1,2(1x,f6.4),1x,i6,2(1x,a))')
     &    locnam, probandi, gdf, otdt, asyp, pval, it,'TDT-Gtp  ',histo
      end if
      return
      end
C end-of-dotdt
C
C test if useful for TDT
C
      logical function tdtuse(idx,gene,naff,fa,mo,locus,use2)
      integer MAXSIZ, MAXLOC, KNOWN
      parameter(MAXSIZ=1000, MAXLOC=120, KNOWN=0)
      integer gene,idx, naff, use2
C pedigree structure
      integer fa(MAXSIZ),mo(MAXSIZ)
      real locus(MAXSIZ,MAXLOC)
      integer gen2

      gen2=gene+1
      tdtuse=.false.

C both parents untyped
      if (locus(fa(idx),gene).lt.KNOWN .and. 
     &    locus(mo(idx),gene).lt.KNOWN) then
        return
C only using one proband per family
      elseif (naff.gt.0 .and. use2.gt.2) then
        return
C one parent untyped and the other homozygous or same genotype as index
      elseif (locus(mo(idx),gene).lt.KNOWN .and. (use2.gt.1 .or.
     2        ((locus(fa(idx),gene).eq.locus(fa(idx),gen2) .or. 
     3        (locus(idx,gene).eq.locus(fa(idx),gene)
     4        .and. locus(idx,gen2).eq.locus(fa(idx),gen2)))))) then
        return
      elseif (locus(fa(idx),gene).lt.KNOWN .and. (use2.gt.1 .or.
     2        ((locus(mo(idx),gene).eq.locus(mo(idx),gen2) .or.
     3        (locus(idx,gene).eq.locus(mo(idx),gene)
     4        .and. locus(idx,gen2).eq.locus(mo(idx),gen2)))))) then
        return
C both parents homozygous 
      elseif (locus(fa(idx),gene).eq.locus(fa(idx),gen2) .and. 
     &        locus(mo(idx),gene).eq.locus(mo(idx),gen2)) then 
        return
C both parents same genotype as index
C     elseif (locus(idx,gene).eq.locus(fa(idx),gene) .and. 
C    2        locus(idx,gen2).eq.locus(fa(idx),gen2) .and. 
C    3        locus(idx,gene).eq.locus(mo(idx),gene) .and. 
C    4        locus(idx,gen2).eq.locus(mo(idx),gen2)) then
C       return
      end if
      tdtuse=.true.
      return
      end
C end-of-tdtuse
C
C randomization test for allelic TDT -- shuffle table ITER times 
C using TOT swaps per shuffle
C
      subroutine shuffle(nallele,cntall,tot,cutoff,tdt,mxiter,mincnt,
     &                   pvalue)
      integer MAXALL, MAXG
      parameter(MAXALL=60, MAXG=MAXALL*(MAXALL+1)/2)
      integer mxiter, mincnt
      double precision pvalue, tdt
C Genotype counts: all1, all2, #all1 trans, #all2 trans
      integer nallele,cntall(MAXG,4),tot,cutoff
C local variables
      integer toc,cum,oldcum,row,col
      integer i,it,swap,tailp
      double precision simtdt
C functions
      double precision clctdt
      integer irandom
      real random
C
C Sequential Monte-Carlo P-value after Besag & Clifford Biometrika 1991
C P= tailp/it if tailp=mincnt or (tailp+1)/(it+1) if tailp<mincnt && it=iter
C
      it=0
      tailp=0
    5 continue
      if (it.eq.mxiter .or. tailp.eq.mincnt) goto 10
        it=it+1
        do 20 i=1,tot
          swap=irandom(1,tot)
          oldcum=0
          do 25 row=1,nallele
          do 25 col=3,4
          if (cntall(row,col).gt.0) then
            cum=oldcum+cntall(row,col)
            if  (swap.le.cum .and. swap.gt.oldcum) 
     &      then
              toc=4
              if (col.eq.4) toc=3
              goto 26
            end if
	    oldcum=cum
          end if
   25     continue
   26     continue
          cntall(row,col)=cntall(row,col)-1
          cntall(row,toc)=cntall(row,toc)+1
   20   continue
        simtdt=clctdt(nallele,cntall,cutoff)
        if (simtdt.gt.tdt .or. (simtdt.eq.tdt .and. 
     2      random().gt.0.5)) 
     3  then
          tailp=tailp+1
        end if
      goto 5
   10 continue
      if (tailp.lt.mincnt) then
        tailp=tailp+1
        it=it+1
      end if
      mxiter=it
      pvalue=dfloat(tailp)/dfloat(mxiter)
      return
      end
C end-of-shuffle
C
C calculate symmetry pearson chi-square
C
      double precision function clctdt(ngcount,gcount,cutoff)
C
C Genotype counts
C genotype allele1,allele2, number transmitted, number not trans
      integer MAXALL,MAXG
      parameter(MAXALL=60,MAXG=MAXALL*(MAXALL+1)/2)
      integer ngcount,gcount(MAXG,4),cutoff
      integer j
      clctdt=0.0d0
      do 10 j=1,ngcount
      if ((gcount(j,3)+gcount(j,4)).gt.cutoff) then
        clctdt=clctdt+dfloat(gcount(j,3)-gcount(j,4))**2
     &         /dfloat(gcount(j,3)+gcount(j,4))
      end if
   10 continue
      return
      end
C end-of-clctdt
C
C calculate g.o.f. LR chi-square
C
      double precision function clcchi(ngcount,gcount,cutoff)
C
C Genotype counts
C genotype allele1,allele2, number transmitted, 
C expected number based on parental genotypes
C
      integer MAXALL,MAXG
      parameter(MAXALL=60,MAXG=MAXALL*(MAXALL+1)/2)
      integer ngcount,gcount(MAXG,4),cutoff
      integer j
      clcchi=0.0d0
      do 10 j=1,ngcount
      if (gcount(j,3).gt.cutoff .and. gcount(j,4).gt.cutoff) then
        clcchi=clcchi+dfloat(gcount(j,3))*
     &         log(dfloat(4*gcount(j,3))/dfloat(gcount(j,4)))
      end if
   10 continue
      clcchi=clcchi+clcchi
      return
      end
C end-of-clcchi
C
C perform sibship association permutation test
C
      subroutine sibship(wrk,wrk2,trait,locnam,gene,iter,mincnt,gt,
     2                   thresh,pedigree,num,nfound,id,fa,mo,sex,locus,
     3                   numloc,numal,name,cntall,aff,set,plevel)
C
      integer KNOWN, MAXALL, MAXG, MAXSIZ, MAXLOC, MISS
      parameter(KNOWN=0, MAXALL=60, MAXG=MAXALL*(MAXALL+1)/2, 
     &          MAXSIZ=1000, MAXLOC=120, MISS=-9999)
      integer gene,iter,mincnt,plevel,trait,wrk,wrk2
      real thresh
      logical gt
      character*10 locnam
C  Pedigree structure
      character*10 pedigree
      integer num, nfound
      character*8 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ)
      integer sex(MAXSIZ)
      integer numloc
      real locus(MAXSIZ,MAXLOC)
C allele frequencies structure
      integer numal, name(MAXALL)
C array for allele counts in cases and controls
      integer cntall(MAXG,4)
C work arrays for counts and MC iteration
      integer aff(MAXSIZ),set(MAXSIZ,2)
C local variables
      integer contrib,df,gen2,i,it,j,k,naff,nuntyp
      integer currf, currm, fin, g1,g2, nfam, tailp
      logical last, variety
      character*3 histo
      real casden, conden
      double precision asyp, chisq, mchisq, ochisq, pexp, pval, vchisq
C functions
      integer getnam
      real isaff, random
      double precision twobyk, chip, binz
C
      df=-1
      gen2=gene+1
      nca=0
      nco=0
      nfam=0
      nuntyp=0
      do 2 j=1,numal  
      do 2 k=1,3
        cntall(j,k)=0
    2 continue
      mchisq=0.0d0
      vchisq=0.0d0
      last=.false.
      rewind(wrk)
    5 continue
        call wrkin(wrk,pedigree,num,nfound,id,fa,mo,sex,locus,numloc,
     &             last)
        if (last) goto 20
C
C Full sibs
C
        fin=num
        currf=fa(fin)
        currm=mo(fin)
        do 10 k=num-1,nfound,-1
          if (fa(k).ne.currf .or. mo(k).ne.currm) then
            contrib=0
            g1=MISS
            naff=0
            variety=.false.
            do 12 i=k+1,fin
            if (locus(i,trait).ne.MISS) then
              if (locus(i,gene).lt.KNOWN) then
                nuntyp=nuntyp+1
              else
                contrib=contrib+1
                aff(contrib)=int(isaff(locus(i,trait),thresh,gt))
                set(contrib,1)=getnam(locus(i,gene),numal,name)
                set(contrib,2)=getnam(locus(i,gen2),numal,name)
                naff=naff+aff(contrib)-1
                if (g1.eq.MISS) then
                  g1=set(contrib,1)
                  g2=set(contrib,2)
                else if (set(contrib,1).ne.g1 .or. 
     &                   set(contrib,2).ne.g2) then
                  variety=.true.
                end if
              end if
            end if
   12       continue
C
C Skip if no usable individuals in this sibship
C
            if (contrib.gt.1 .and. naff.gt.0 .and. naff.lt.contrib .and.
     &          variety) then
              nfam=nfam+1
              do 14 i=1,contrib
                cntall(set(i,1),aff(i))=cntall(set(i,1),aff(i))+1
                cntall(set(i,2),aff(i))=cntall(set(i,2),aff(i))+1
   14         continue
              write(wrk2) contrib,(aff(i),set(i,1),set(i,2),i=1,contrib)
            end if
C Now update to next sibship
            fin=k
            currf=fa(fin)
            currm=mo(fin)
          end if
   10   continue
C mark end of sibships in current pedigree
      goto 5
   20 continue

      do 25 i=1,numal
        nco=nco+cntall(i,1)
        nca=nca+cntall(i,2)
        cntall(i,3)=cntall(i,1)+cntall(i,2)
        if (cntall(i,3).gt.0) df=df+1
   25 continue
      if (nca.gt.0 .and. nco.gt.0) then
        pexp=dfloat(nca)/dfloat(nca+nco)
        ochisq=twobyk(numal,cntall,pexp)
        asyp=chip(ochisq,df)
      else
        pexp=0.0d0
        ochisq=0.0d0
        df=0
        asyp=1.0d0
      end if

      if (plevel.gt.0) then
        write(*,'(/3a/a/a)') 
     2  '  ---- Sibship Permutation for "',locnam,'" ----',
     3  '    Allele   Affected   Unaffected   Total    Dev',
     4  '  -----------------------------------------------'
        casden=max(1.0,float(nca))
        conden=max(1.0,float(nco))
        do 30 i=1,numal  
          write(*,'(i8,2(2x,i5,1x,a1,f3.2,a1),i8,1x,f6.1)') 
     2     name(i),cntall(i,2),'(',float(cntall(i,2))/casden,')',
     3     cntall(i,1),'(',float(cntall(i,1))/conden,')',cntall(i,3),
     4     binz(cntall(i,2),cntall(i,3),pexp)
   30   continue
        write(*,'(a/a8,2(2x,i5,6x),i8)') 
     2    '  -----------------------------------------------',
     3      'Total',nca,nco,nca+nco
        write(*,'(3(/a,i6))') 
     2    '       No. trait(+) marker(-) =',nuntyp,
     3    '       No. trait(+) marker(+) =',(nca+nco)/2,
     4    '          No. useful sibships =',nfam 
          write(*,'(a,f6.1/a,i4/a,3x,f6.4)')
     2    '   Contingency Pearson chi-sq =',ochisq,
     3    '   Nominal degrees of freedom =',df,
     4    '              Nominal P-value =',asyp
      end if
C
C MC P-value estimation
C
      it=0
      if (iter.eq.0 .or. nca.eq.0 .or. nco.eq.0 .or. nfam.lt.1) then
        tailp=0
        pval=1.0d0
      else
C
C Now can simulate genotypes and do sequential P-value simulation
C
        tailp=0
   49   continue
        if (it.eq.iter .or. tailp.eq. mincnt) goto 50
          it=it+1
          do 52 j=1,numal  
          do 52 k=1,3
            cntall(j,k)=0
   52     continue
          rewind(wrk2)
   55     continue
            read(wrk2,end=70) contrib,
     &        (aff(i),set(i,1),set(i,2),i=1,contrib)
            call setperm(contrib,set)
            do 65 i=1,contrib
              cntall(set(i,1),aff(i))=cntall(set(i,1),aff(i))+1
              cntall(set(i,2),aff(i))=cntall(set(i,2),aff(i))+1
   65       continue
          goto 55
   70     continue
        
          do 80 i=1,numal  
            cntall(i,3)=cntall(i,1)+cntall(i,2)
   80     continue
          chisq=twobyk(numal,cntall,pexp)
          call moment(it,chisq,mchisq,vchisq)
          if (chisq.gt.ochisq .or. (chisq.eq.ochisq .and.
     2        random().gt.0.5)) 
     3    then
            tailp=tailp+1
          end if
          if (plevel.gt.1) then
            write(*,'(/a,i4,a,f6.1)') 
     &        'Pseudosample ',it,': Chisq=',chisq
            do 85 i=1,numal
              write(*,'(i8,2(2x,i5,1x,a1,f3.2,a1),i8)') 
     2        name(i),cntall(i,2),'(',float(cntall(i,2))/float(nca),')',
     3        cntall(i,1),'(',float(cntall(i,1))/float(nco),')',
     4        cntall(i,3)
   85       continue
          end if
          goto 49
   50   continue
C       
        if (tailp.lt.mincnt) then
          tailp=tailp+1
          it=it+1
        end if
        vchisq=vchisq/dfloat(max(1,it-1))
        pval=dfloat(tailp)/dfloat(it)
      end if
      if (plevel.gt.0) then
        write(*,'(a,i4,a,i5,a,f6.4,a/a,f6.1,a,f6.1,a)')
     2    '      Equalled or exceeded by =',tailp,'/',it,
     3    ' simulated values (',pval,')',
     4    ' Mean (Var) simulated chi-sqs =',mchisq,' (',vchisq,')'
      else
        call phist(asyp,pval,histo)
        write(*,'(a10,2(1x,i6),1x,f10.1,2(1x,f6.4),1x,i6,2(1x,a))')
     2    locnam, (nca+nco)/2, df, ochisq, asyp, pval, it, 
     3    'AssX2-CPG',histo
      end if
      return
      end
C end-of-sibship
C
C Permute alleles of genotypes for set of sibs
C
      subroutine setperm(num,set)
      integer MAXSIZ
      parameter(MAXSIZ=1000)
      integer num  
      integer set(MAXSIZ,2)
C 
      integer i, swap, toa, tmp
C functions
      integer irandom

      do 20 i=1,num
      do 20 j=1,2
        swap=irandom(1,num)
        toa=irandom(1,2)
        tmp=set(swap,toa)
        set(swap,toa)=set(i,j)
        set(i,j)=tmp
   20 continue
      return
      end
C end-of-setperm
C
C Approach of Schaid and Sommer (1993), amplified by Knapp et al (1995)
C
C MM x MM   MM x MN   MM x NN   MN x MN    MN x NN    NN x NN    
C   MM      MM   MN     MN      MM MN NN   MN   NN      NN
C   n1      n2   n3     n4      n5 n6 n7   n8   n9      n10
C
C a=4*n1 + 3*n2 + 3*n3 + 2*n4 + 2*n5 + 2*n6 + 2*n7 + n8 + n9
C b=n2 + n3 + 2*n4 + 2*n5 + 2*n6 + 2*n7 + 3*n8 + 3*n9 + 4*n10
C c=n1 + n2 + n5
C d=n3 + n4 + n6 + n8
C
C providing n-c-d!=0 and a-2c-d!=0 then
C
C p=(a-2*c-d)/2n
C r1= (1-p)*d/(2*p*(n-c-d))
C r2= (1-p)^2 c/(p^2*(n-c-d))
C
C
      subroutine nucseg(wrk,trait,gene,candal,x,r,b,cov,pedigree,
     2             num,nfound,id,fa,mo,sex,locus, numloc, key, plevel)
      integer MAXCOV, MAXLOC, MAXIBD, MAXSIZ, MAXTER, KNOWN
      parameter(MAXSIZ=1000, MAXLOC=120, KNOWN=0,
     3          MAXIBD=1000, MAXTER=MAXIBD/2, 
     4          MAXCOV=MAXTER*(MAXTER+1)/2 )
      integer gene,plevel,trait,wrk
      real candal
C pedigree structure
      character*10 pedigree
      integer sex(MAXSIZ)
      integer num, nfound
      character*8 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ)
      real locus(MAXSIZ,MAXLOC)
C work arrays for log-linear modelling
      double precision x(MAXTER), r(MAXCOV), b(MAXTER), cov(MAXCOV)
      integer key(MAXSIZ)
C local variables
      real count(16), cpgmod(40), hwemod(64)
      integer gen2, i, naff, pos
      character*7 gtp0, gtp1, gtp2
      logical last
      double precision lik0, lik1, p, p0, q, q0, r0, r1, r2,
     &                 e1,e2,e3,e4,e5,e6, se1, se2
C
C functions 
      double precision chip
C
      data hwemod / 1.0,4.0,0.0,1.0,1.0,3.0,0.0,1.0,1.0,3.0,0.0,1.0,
     2              1.0,3.0,1.0,0.0,1.0,3.0,1.0,0.0,1.0,2.0,1.0,0.0,
     3              1.0,2.0,1.0,0.0,1.0,2.0,0.0,1.0,1.0,2.0,1.0,0.0,
     4              1.0,2.0,1.0,0.0,1.0,2.0,0.0,0.0,1.0,1.0,1.0,0.0,
     5              1.0,1.0,1.0,0.0,1.0,1.0,0.0,0.0,1.0,1.0,0.0,0.0,
     6              1.0,0.0,0.0,0.0 /
      data cpgmod / 
     2 1.0,0.0,0.0,0.0,1.0,1.0,0.0,0.0,1.0,0.0,
     3 0.0,1.0,0.0,0.0,1.0,0.0,1.0,0.0,1.0,0.0,
     4 0.0,1.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,0.0,
     5 0.0,0.0,1.0,1.0,0.0,0.0,0.0,1.0,0.0,0.0 /

      gen2=gene+1
      naff=0
      do 1 i=1,10
        key(i)=0
    1 continue  
      if (plevel.gt.1) then
        write(*,'(/a)') 'Pedigree   ID         Child   Father  Mother'
      end if
      last=.false.
      rewind(wrk)
C
   10 continue
       call wrkin(wrk,pedigree,num,nfound,id,fa,mo,sex,locus,numloc,
     &            last)
       if (last) goto 20
         do 12 i=nfound+1,num
         if (locus(i,trait).eq.2.0 .and.
     2     locus(i,gene).gt.KNOWN .and. locus(fa(i),gene).gt.KNOWN .and.
     3     locus(mo(i),gene).gt.KNOWN) 
     4   then
           naff=naff+1
           nfa=0
           nmo=0
           nch=0
           if (locus(i,gene).eq.candal) nch=nch+1
           if (locus(i,gen2).eq.candal) nch=nch+1
           if (locus(fa(i),gene).eq.candal) nfa=nfa+1
           if (locus(fa(i),gen2).eq.candal) nfa=nfa+1
           if (locus(mo(i),gene).eq.candal) nmo=nmo+1
           if (locus(mo(i),gen2).eq.candal) nmo=nmo+1
           if (nmo.eq.1 .and. nfa.eq.1) then
             pos=7-nch
           else if ((nfa+nmo).gt.1) then
             pos=7-nfa-nmo-nch
           else
             pos=10-nfa-nmo-nch
           end if
           key(pos)=key(pos)+1
           if (plevel.gt.1) then
             write(*,'(a10,1x,a8,3(1x,i3,1x,i3))') pedigree,id(i),
     2         int(locus(i,gene)), int(locus(i,gen2)), 
     3         int(locus(fa(i),gene)), int(locus(fa(i),gen2)), 
     4         int(locus(mo(i),gene)), int(locus(mo(i),gen2)) 
           end if
         end if
   12    continue
       goto 10
   20 continue
      count(1)=float(key(1))
      count(2)=0.5*float(key(2))
      count(3)=count(2)
      count(4)=0.5*float(key(3))
      count(5)=count(4)
      count(6)=0.5*float(key(4))
      count(7)=count(6)
      count(8)=float(key(5))
      count(9)=0.5*float(key(6))
      count(10)=count(9)
      count(11)=float(key(7))
      count(12)=0.5*float(key(8))
      count(13)=count(12)
      count(14)=0.5*float(key(9))
      count(15)=count(14)
      count(16)=float(key(10))

      call loglin(16,4,2,count,hwemod,x,r,b,cov,lik0)
      p0=exp(b(2))
      p0=p0/(1.0d0+p0)
      q0=1.0d0-p0
      call loglin(16,4,4,count,hwemod,x,r,b,cov,lik1)
      p=exp(b(2))
      p=p/(1.0d0+p)
      q=1.0d0-p
      r1=b(3)
      r2=b(4)
      r0=p*p*exp(r2)+2*p*q*exp(r1)+q*q
      se1=1.96d0*sqrt(cov(6))
      se2=1.96d0*sqrt(cov(10))
      lik1=lik0-lik1
      lik1=lik1+lik1
C
      e1=p0*p0*p0*p0*dfloat(naff)
      e2=4*p0*q0*p0*p0*dfloat(naff)
      e3=2*p0*p0*q0*q0*dfloat(naff)
      e4=4*p0*q0*p0*q0*dfloat(naff)
      e5=4*p0*q0*q0*q0*dfloat(naff)
      e6=q*q*q*q*dfloat(naff)
      call wrgtp(int(candal),int(candal),gtp2,1)
      call wrgtp(int(candal),0,gtp1,1)
      call wrgtp(0,0,gtp0,1)

      write(*,'(/a/6x,a,9x,a,3(1x,a)/a)') 
     2  '------------------------------------------------------------',
     3  'Mating','Total Expected', gtp2, gtp1, gtp0,
     4  '------------------------------------------------------------' 
      write(*,50) gtp2,' x ',gtp2, key(1),e1,key(1),'x  ','x  ',
     2  gtp2,' x ',gtp1, key(2)+key(3),e2,key(2),key(3),'x  ',
     3  gtp2,' x ',gtp0, key(4),e3,'x  ',key(4),'x  ',
     4  gtp1,' x ',gtp1, key(5)+key(6)+key(7),e4,key(5),key(6),key(7),
     5  gtp1,' x ',gtp0, key(8)+key(9),e5,'x  ',key(8),key(9),
     6  gtp0,' x ',gtp0, key(10),e6,'x  ','x  ',key(10) 
   50 format(3a,i9,f9.1,(1x,i5,2x),2a8  /3a,i9,f9.1,2(1x,i5,2x),a8/
     2       3a,i9,f9.1,a8,(1x,i5,2x),a8/3a,i9,f9.1,3(1x,i5,2x)/
     3       3a,i9,f9.1,a8,2(1x,i5,2x)  /3a,i9,f9.1,2a8,1x,i5)
      write(*,'(a//a,i3,a,f5.3/a,i5)')  
     2  '------------------------------------------------------------',
     3  'Freq of ',int(candal),' allele   =     ',p,
     4  'N affected children  = ',naff 
      write(*,'(/a,f8.2,a,f5.3,a,2(/3(a,f8.2),a)/a,f8.2)') 
     2  'HWE Chi-square (2 df)= ',lik1,' (P=',chip(lik1,2),')',
     3  'Genotypic RR1 (f1)   = ',exp(r1),' (95%CI=',
     4     exp(r1-se1),' to ',exp(r1+se1),')',
     5  'Genotypic RR2 (f2)   = ',exp(r2),' (95%CI=',
     6     exp(r2-se2),' to ',exp(r2+se2),')',
     7  'Attributable risk    = ', (p*p*(exp(r2)-1.0d0)+
     8     2*p*q*(exp(r1)-1.0d0))/r0
C
C ML CPG test
C
      count(1)=float(key(2))
      count(2)=float(key(3))
      count(3)=float(key(5))
      count(4)=0.5*float(key(6))
      count(5)=count(4)
      count(6)=float(key(7))
      count(7)=float(key(8))
      count(8)=float(key(9))
      call loglin(8,5,3,count,cpgmod,x,r,b,cov,lik0)
      call loglin(8,5,5,count,cpgmod,x,r,b,cov,lik1)
      r1=b(4)
      r2=b(5)
      r0=p*p*exp(r2)+2*p*q*exp(r1)+q*q
      se1=1.96d0*sqrt(cov(10))
      se2=1.96d0*sqrt(cov(15))
      lik1=lik0-lik1
      lik1=lik1+lik1
      write(*,'(/a,f8.2,a,f5.3,a,2(/3(a,f8.2),a)/a,f8.2)') 
     2  'CPG Chi-sq    (2 df) = ',lik1,' (P=',chip(lik1,2),')',
     3  'Genotypic RR1 (f1)   = ',exp(r1),' (95%CI=',
     4     exp(r1-se1),' to ',exp(r1+se1),')',
     5  'Genotypic RR2 (f2)   = ',exp(r2),' (95%CI=',
     6     exp(r2-se1),' to ',exp(r2+se1),')',
     7  'Attributable risk    = ',(p*p*(exp(r2)-1.0d0)+
     8     2*p*q*(exp(r1)-1.0d0))/r0
C
      return
      end
C end-of-nucseg
C
C zero-trapped log
      double precision function ln(x)
      double precision x
      if (x.le.0.0d0) then
        ln=0.0d0
      else
        ln=log(x)
      end if
      return
      end
C end-of-ln
C
C perform sibship association permutation test
C
C Combines TDT with SDT: appropriate permutation set for each sibship
C
C If both parents genotyped, then each child can be drawn from 13,14,23,24
C If one or no parents genotyped, but may be reconstructed, then draw
C from mixture of obligate genotypes (those usable to reconstruct the missing
C parents) and 13,14,23,24.
C If cannot unequivocally reconstruct parental genotypes
C draw only from obligate (observed) genotypes among children
C
      subroutine rctdt(wrk,wrk2,trait,locnam,gene,iter,mincnt,gt,
     2                 thresh,pedigree,num,nfound,id,fa,mo,sex,locus,
     3                 numloc,numal,name,cntall,aff,set,plevel)
C
      integer KNOWN, MAXALL, MAXG, MAXSIZ, MAXLOC, MISS
      parameter(KNOWN=0, MAXALL=60, MAXG=MAXALL*(MAXALL+1)/2, 
     &          MAXSIZ=1000, MAXLOC=120, MISS=-9999)
      integer gene,iter,mincnt,plevel,trait,wrk,wrk2
      real thresh
      logical gt
      character*10 locnam
C  Pedigree structure
      character*10 pedigree
      integer num, nfound
      character*8 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ)
      integer sex(MAXSIZ)
      integer numloc
      real locus(MAXSIZ,MAXLOC)
C allele frequencies structure
      integer numal, name(MAXALL)
C array for allele counts in cases and controls
      integer cntall(MAXG,4)
C work arrays for counts and MC iteration
      integer aff(MAXSIZ), set(MAXSIZ,2)
C local variables
      integer contrib,df,gen2,i,it,j,k,naff,nuntyp
      integer currf, currm, fin, mg1, mg2, pg1,pg2, nfam, tailp
      logical last
      character*1 yn(2)
      character*3 histo
      real casden, conden, x
      double precision asyp, chisq, mchisq, ochisq, pexp, pval, vchisq
C functions
      integer getnam
      real isaff, random
      double precision twobyk, chip, binz
C
      yn(1)="n"
      yn(2)="y"
      df=-1
      gen2=gene+1
      nca=0
      nco=0
      nfam=0
      nuntyp=0
      do 2 j=1,numal  
      do 2 k=1,3
        cntall(j,k)=0
    2 continue
      mchisq=0.0d0
      vchisq=0.0d0
      last=.false.
      rewind(wrk)
    5 continue
        call wrkin(wrk,pedigree,num,nfound,id,fa,mo,sex,locus,numloc,
     &             last)
        if (last) goto 20
C
C Full sibs
C
        fin=num
        currf=fa(fin)
        currm=mo(fin)
        do 10 k=num-1,nfound,-1
          if (fa(k).ne.currf .or. mo(k).ne.currm) then
            contrib=0
            naff=0
            do 12 i=k+1,fin
            if (locus(i,trait).ne.MISS) then
              if (locus(i,gene).gt.KNOWN) then
                contrib=contrib+1
                x=locus(i,gene)
                set(contrib,1)=getnam(x,numal,name)
C               set(contrib,1)=getnam(locus(i,gene),numal,name)
                x=locus(i,gen2)
                set(contrib,2)=getnam(x,numal,name)
C               set(contrib,2)=getnam(locus(i,gen2),numal,name)
                aff(contrib)=int(isaff(locus(i,trait),thresh,gt))
                naff=naff+aff(contrib)-1
              else
                nuntyp=nuntyp+1
              end if
            end if
   12       continue
C
C Skip if no usable individuals in this sibship
C
            if (contrib.gt.0 .and. naff.gt.0) then
              nfam=nfam+1
              if (locus(fa(k),gene).gt.KNOWN) then
                pg1=getnam(locus(fa(k),gene),numal,name)
                pg2=getnam(locus(fa(k),gen2),numal,name)
              else
                pg1=MISS
                pg2=MISS
              end if
              if (locus(mo(k),gene).gt.KNOWN) then
                mg1=getnam(locus(mo(k),gene),numal,name)
                mg2=getnam(locus(mo(k),gen2),numal,name)
              else
                mg1=MISS
                mg2=MISS
              end if
              call parimp(pg1,pg2,mg1,mg2,contrib,set)
              do 14 i=1,contrib
                cntall(set(i,1),aff(i))=cntall(set(i,1),aff(i))+1
                cntall(set(i,2),aff(i))=cntall(set(i,2),aff(i))+1
   14         continue
              write(wrk2) nfam,pg1,pg2,mg1,mg2,contrib,
     &                    (aff(i),i=1,contrib)
            end if
C Now update to next sibship
            fin=k
            currf=fa(fin)
            currm=mo(fin)
          end if
   10   continue
C mark end of sibships in current pedigree
      goto 5
   20 continue

      do 25 i=1,numal
        nco=nco+cntall(i,1)
        nca=nca+cntall(i,2)
        cntall(i,3)=cntall(i,1)+cntall(i,2)
        if (cntall(i,3).gt.0) df=df+1
   25 continue
      if (nca.gt.0 .and. nco.gt.0) then
        pexp=dfloat(nca)/dfloat(nca+nco)
        ochisq=twobyk(numal,cntall,pexp)
        asyp=chip(ochisq,df)
      else
        pexp=0.0d0
        ochisq=0.0d0
        df=0
        asyp=1.0d0
      end if

      if (plevel.gt.0) then
        write(*,'(/3a/a/a)') 
     2  '  ---- Sibship Permutation for "',locnam,'" ----',
     3  '    Allele   Affected   Unaffected   Total    Dev',
     4  '  -----------------------------------------------'
        casden=max(1.0,float(nca))
        conden=max(1.0,float(nco))
        do 30 i=1,numal  
          write(*,'(i8,2(2x,i5,1x,a1,f3.2,a1),i8,1x,f6.1)') 
     2     name(i),cntall(i,2),'(',float(cntall(i,2))/casden,')',
     3     cntall(i,1),'(',float(cntall(i,1))/conden,')',cntall(i,3),
     4     binz(cntall(i,2),cntall(i,3),pexp)
   30   continue
        write(*,'(a/a8,2(2x,i5,6x),i8)') 
     2    '  -----------------------------------------------',
     3      'Total',nca,nco,nca+nco
        write(*,'(3(/a,i6))') 
     2    '       No. trait(+) marker(-) =',nuntyp,
     3    '       No. trait(+) marker(+) =',(nca+nco)/2,
     4    '          No. useful sibships =',nfam 
          write(*,'(a,f6.1/a,i4/a,3x,f6.4)')
     2    '   Contingency Pearson chi-sq =',ochisq,
     3    '   Nominal degrees of freedom =',df,
     4    '              Nominal P-value =',asyp
      end if
C
C MC P-value estimation
C
      it=0
      if (iter.eq.0 .or. nca.eq.0 .or. nco.eq.0 .or. nfam.lt.1) then
        tailp=0
        pval=1.0d0
      else
C
C Now can simulate genotypes and do sequential P-value simulation
C
        tailp=0
   49   continue
        if (it.eq.iter .or. tailp.eq. mincnt) goto 50
          it=it+1
          do 52 j=1,numal  
          do 52 k=1,3
            cntall(j,k)=0
   52     continue
          rewind(wrk2)
   55     continue
            read(wrk2,end=70) nfam,pg1,pg2,mg1,mg2,contrib,
     &                        (aff(i),i=1,contrib)
            call rctperm(pg1,pg2,mg1,mg2,contrib,set)
            if (plevel.gt.1) then
              write(*,'(i5,1x,i5,4(1x,i5),30(1x,a1,1x,i2,1x,i2):)') 
     2          it,nfam,pg1,pg2,mg1,mg2,
     3          (yn(aff(i)),set(i,1),set(i,2),i=1,contrib)
            end if
            do 65 i=1,contrib
              cntall(set(i,1),aff(i))=cntall(set(i,1),aff(i))+1
              cntall(set(i,2),aff(i))=cntall(set(i,2),aff(i))+1
   65       continue
          goto 55
   70     continue
        
          do 80 i=1,numal  
            cntall(i,3)=cntall(i,1)+cntall(i,2)
   80     continue
          chisq=twobyk(numal,cntall,pexp)
          call moment(it,chisq,mchisq,vchisq)
          if (chisq.gt.ochisq .or. (chisq.eq.ochisq .and.
     2        random().gt.0.5)) 
     3    then
            tailp=tailp+1
          end if
          if (plevel.gt.2) then
            write(*,'(/a,i4,a,f6.1)') 
     &        'Pseudosample ',it,': Chisq=',chisq
            do 85 i=1,numal
              write(*,'(i8,2(2x,i5,1x,a1,f3.2,a1),i8)') 
     2        name(i),cntall(i,2),'(',float(cntall(i,2))/float(nca),')',
     3        cntall(i,1),'(',float(cntall(i,1))/float(nco),')',
     4        cntall(i,3)
   85       continue
          end if
          goto 49
   50   continue
C       
        if (tailp.lt.mincnt) then
          tailp=tailp+1
          it=it+1
        end if
        vchisq=vchisq/dfloat(max(1,it-1))
        pval=dfloat(tailp)/dfloat(it)
      end if
      if (plevel.gt.0) then
        write(*,'(a,i4,a,i5,a,f6.4,a/a,f6.1,a,f6.1,a)')
     2    '      Equalled or exceeded by =',tailp,'/',it,
     3    ' simulated values (',pval,')',
     4    ' Mean (Var) simulated chi-sqs =',mchisq,' (',vchisq,')'
      else
        call phist(asyp,pval,histo)
        write(*,'(a10,2(1x,i6),1x,f10.1,2(1x,f6.4),1x,i6,2(1x,a))')
     2    locnam, (nca+nco)/2, df, ochisq, asyp, pval, it, 
     3    'AssX2-CPG',histo
      end if
      return
      end
C end-of-rctdt   
C
C Make list of possible parental genotypes for this sibship
C
      subroutine parimp(pg1,pg2,mg1,mg2,nsibs,set)

      integer KNOWN, MAXSIZ, MISS
      parameter(KNOWN=0, MAXSIZ=1000, MISS=-9999)

      integer nsibs, pg1,pg2,mg1,mg2, set(MAXSIZ,2)
      integer g(4,2), p11, p12, p21, p22, tmp
      logical d1,d2,d3,d4

C Both parents genotyped
      if (pg1.gt.KNOWN .and. mg1.gt.KNOWN) return 

C
C initialize g() with a heterozygote genotype if possible
      d1=.true.
      do 10 i=1, nsibs
      if (set(i,1).ne.set(i,2)) then
        d1=.false.
        g(1,1)=set(i,1)
        g(1,2)=set(i,2)
        goto 11
      end if
   10 continue
   11 continue
C if no heterozygotes
      if (d1) then
        do 20 i=1, nsibs
        if (set(i,1).eq.set(i,2)) then
          g(1,1)=set(i,1)
          g(1,2)=set(i,2)
          goto 21
        end if
   20   continue
   21   continue
      end if
C Categorise sibs genotype
C in terms of which allele is shared with starting genotype
      do 3 i=2, 4
        g(i,1)=MISS
        g(i,2)=MISS
    3 continue
      do 30 i=1, nsibs
        d1=(set(i,1).eq.g(1,1))
        d4=(set(i,2).eq.g(1,2))
        if (.not.(d1 .and. d4)) then
          d2=(set(i,1).eq.g(1,2))
          d3=(set(i,2).eq.g(1,1))
          if (d1) then
            g(2,1)=set(i,1)
            g(2,2)=set(i,2)
          else if (d3) then
            g(2,1)=set(i,2)
            g(2,2)=set(i,1)
          else if (d2) then
            g(3,1)=set(i,1)
            g(3,2)=set(i,2)
          else if (d4) then
            g(3,1)=set(i,2)
            g(3,2)=set(i,1)
          else 
            g(4,1)=set(i,1)
            g(4,2)=set(i,2)
          end if
        end if
   30 continue
  
   25 continue
C Fix order of 4th genotype so consistent with others
      if ((g(2,2).ne.MISS .and. g(4,2).ne.g(2,2)) .or.
     &    (g(3,1).ne.MISS .and. g(4,1).ne.g(3,1))) then
        tmp=g(4,2)
        g(4,2)=g(4,1)
        g(4,1)=tmp
      end if
C Produce parental phenosets and compare to any known genotypes
      p11=g(1,1)
      p21=g(1,2)
      p12=MISS
      p22=MISS
      if (g(2,2).ne.MISS) p22=g(2,2)
      if (g(4,2).ne.MISS) p22=g(4,2)
      if (g(3,2).ne.MISS) p12=g(3,2)
      if (g(4,1).ne.MISS) p12=g(4,1)
      call order(p11,p12)
      call order(p21,p22)
C Return observed and imputed genotypes
      if (mg1.le.KNOWN) then
        if (pg1.eq.p11 .and. pg2.eq.p12) then
          if (p21.ne.MISS) mg1= -p21
          if (p22.ne.MISS) mg2= -p22
        else
          if (p11.ne.MISS) mg1= -p11
          if (p12.ne.MISS) mg2= -p12
        end if
      end if
      if (pg1.le.KNOWN) then
        if (mg1.eq.p21 .and. mg2.eq.p22) then
          if (p11.ne.MISS) pg1= -p11
          if (p12.ne.MISS) pg2= -p12
        else
          if (p21.ne.MISS) pg1= -p21
          if (p22.ne.MISS) pg2= -p22
        end if
      end if
      end
C end-of-parimp
C
C Simulate the null distribution of sibship genotypes
C Parental alleles imputed via the children must be transmitted 
C at least once to that sibship
C Furthermore, if two imputed alleles are the same in the two parents,
C then these must be transmitted together to at least one child
C
      subroutine rctperm(pg1,pg2,mg1,mg2,nsibs,set)

      integer KNOWN, MAXSIZ, MISS
      parameter(KNOWN=0, MAXSIZ=1000, MISS=-9999)

      integer nsibs,mg1,mg2,pg1,pg2, set(MAXSIZ,2)
      integer i, imp0, imputd, p11, p12, p21, p22, swap, tmp
C functions
      integer irandom

C Allow restart since rejection sampling to meet conditions

      imp0=0
      if (pg1.lt.KNOWN .and. pg1.ne.MISS) imp0=imp0+1
      if (pg2.lt.KNOWN .and. pg2.ne.MISS) imp0=imp0+1
      if (mg1.lt.KNOWN .and. mg1.ne.MISS) imp0=imp0+1
      if (mg2.lt.KNOWN .and. mg2.ne.MISS) imp0=imp0+1

    1 continue

      imputd=imp0
      p11=pg1
      p12=pg2
      p21=mg1
      p22=mg2
      do 10 i=1, nsibs
        call contrans(imputd, p11, p12, p21, p22, set(i,1), set(i,2))
   10 continue

      if (imputd.gt.0) goto 1
C
C If matching conditions, now permute genotypes within sibship
C
      do 20 i=1,nsibs
        swap=irandom(1,nsibs)
        tmp=set(swap,1)
        set(swap,1)=set(i,1)
        set(i,1)=tmp
        tmp=set(swap,2)
        set(swap,2)=set(i,2)
        set(i,2)=tmp
   20 continue
      do 30 i=1,nsibs
        call order(set(i,1), set(i,2))
   30 continue
      return
      end
C end-of-rctperm
C
C Conditional parent-offspring transmission
C Flag whether an imputed parental allele is transmitted 
C
      subroutine contrans(imputd, p11, p12, p21, p22, off1, off2)
      integer KNOWN, MISS
      parameter(KNOWN=0, MISS=-9999)
      integer imputd, off1, off2, p11, p12, p21, p22
      integer tr1, tr2  
C functions
      integer ranall

      tr1=ranall(p11,p12)
      tr2=ranall(p21,p22)
      if (p11.lt.KNOWN .and. p11.ne.MISS) then
        if (p11.eq.p21) then
          tr1=1
          tr2=1
        else if (p11.eq.p22) then
          tr1=1
          tr2=2
        end if
      else if (p12.lt.KNOWN .and. p12.ne.MISS) then
        if (p12.eq.p21) then
          tr1=2
          tr2=1
        else if (p12.eq.p22) then
          tr1=2
          tr2=2
        end if
      end if
      call conoff(tr1,p11,p12,imputd,off1)
      call conoff(tr2,p21,p22,imputd,off2)
      return
      end
C end-of-contrans
C
C Randomly transmit nonmissing alleles
      integer function ranall(par1, par2)
      integer MISS
      parameter(MISS=-9999)
      integer par1, par2
C functions
      integer irandom
      if (par1.ne.MISS .and. par2.ne.MISS) then
        ranall=irandom(1,2)
      else if (par2.eq.MISS) then
        ranall=1
      else
        ranall=2
      end if
      return
      end
C end-of-ranall
C 
      subroutine conoff(tr,par1,par2,imputd,off)
      integer KNOWN
      parameter (KNOWN=0)
      integer imputd,off,par1,par2,tr
      
      if (tr.eq.1) then
        if (par1.lt.KNOWN) then
          imputd=imputd-1
          par1= -par1
        end if
        off=par1
      else 
        if (par2.lt.KNOWN) then
          imputd=imputd-1
          par2= -par2
        end if
        off=par2
      end if
      return
      end
C end-of-condoff
