
C
C Evaluate and apply simple expressions either
C
C (1) pure arithmetic, so no effect on pedigree file
C (2) Dry run, so can test if will lead to a legal effect on pedigree file
C         all variables set to MISS
C (3) Pedigree operation -- individual-wise calculation and update
C
C The parser 
C
      subroutine parser(nterm,wtyp,expr,lbp,rbp,op,error)
      integer MAXLOC, MAXCOL, MISS, TOKNUM 
      parameter (MAXLOC=120, MAXCOL=MAXLOC+5, MISS=-9999, TOKNUM=48)
C address of env, trait, geno, missing trait, missing geno, NUM
      integer ADDTRA
      parameter(ADDTRA=200000)

      integer error, nterm
      integer wtyp(MAXCOL)
      double precision expr(MAXCOL,2)
      integer lbp(0:TOKNUM), rbp(0:TOKNUM), op(0:TOKNUM)

C
C To allow if-then-else, start and end of block for parsing
C
      integer fin, posif, posth, posel, sta
      logical ismis, switch
C
C Main eval loop
C
    1 continue

C
C Read tag of each token and see if compound expression
C
      call findth(nterm,wtyp,posif,posth,posel)
C simple expression
      if (posif.eq.MISS) then
C empty list
        if (nterm.le.0) then
          nterm=1
          wtyp(nterm)=ADDTRA
          expr(nterm,1)=MISS
          expr(nterm,2)=MISS
C evaluate
        else
          sta=1
          fin=nterm
          call simpev(sta,fin,nterm,wtyp,expr,lbp,rbp,op,error)
        end if
C complex expression -- evaluate if clause
      else if ((posth-posif).gt.1) then
        sta=posif+1
        fin=posth-1
        call simpev(sta,fin,nterm,wtyp,expr,lbp,rbp,op,error)
C -- DEBUG
C       write(*,*) 'Condition value: ', wtyp(sta), expr(sta,1), 
C    &             '==', (int(expr(sta,1)).ne.0)
C -- DEBUG
C if successfully evaluated
        if (sta.eq.fin .and. .not.ismis(wtyp(sta))) then
          switch=(int(expr(sta,1)).ne.0)
          call pull(posif,3,fin,nterm,wtyp,expr)
          call findth(nterm,wtyp,posif,posth,posel)
C remove either `else' predicate
          if (switch) then
            if (posel.ne.MISS) then
              sta=posel
              fin=nterm 
              call pull(sta,fin-sta+1,fin,nterm,wtyp,expr)
            end if
C or remove `then' predicate
          else
            if (posel.ne.MISS) then
              sta=1
              fin=posel
              call pull(sta,fin-sta+1,fin,nterm,wtyp,expr)
            else
              nterm=0
            end if
          end if
          goto 1
        else 
          error=1
        end if
C no `then'
      else 
        error=1
      end if
      return
      end
C end-of-parser
C
C The non-compound evaluator
C
      subroutine simpev(sta,fin,nterm,wtyp,expr,lbp,rbp,op,error)
      integer MAXLOC, MAXCOL, MISS, TOKNUM 
      parameter (MAXLOC=120, MAXCOL=MAXLOC+5, MISS=-9999, TOKNUM=48)

      integer error, fin, nterm, sta
      integer wtyp(MAXCOL)
      double precision expr(MAXCOL,2)
      integer lbp(0:TOKNUM), rbp(0:TOKNUM), op(0:TOKNUM)

      logical change, done, three
      integer adh1, adh2, adh3, adh4, cand1, cand2, cand3,
     &        iter, pos
C functions
      logical isdata, isop
C -- DEBUG
C     logical isenv
C     integer eow
C     parameter (ENVNUM=12)
C     character*6 env(ENVNUM), token(TOKNUM)
C     data token /'(',')','if','then','else','*','/',
C    2     '+','-','^','=','not','and','or','<','>',
C    3     'ge','le','ne','eq','neg','pos','abs','sqrt','log','exp',
C    4     'sin','cos','tan','asin','acos','atan','inht','int','round',
C    5     'istyp','untyp','ishet','ishom', 'alla', 'allb',
C    6     'rand','rnorm','pi','y','n','x','NUM'/
C     data env /'female','male','isfou','isnon','num','nfoun',
C    &       'anytyp','alltyp','numtyp','famnum','index', 'commar'/
C -- DEBUG
C
C First convert compound operators (==,^=,<=,>=) to equivalent token
C
      pos=fin
   10 continue
        if (wtyp(pos).eq.11 .and. pos.gt.sta) then
          cand2=wtyp(pos-1)
          if (cand2.eq.11 .or. cand2.eq.10 .or.
     &        cand2.eq.15 .or. cand2.eq.16) then
            call compop(pos-1,sta,fin,nterm,wtyp,expr,error)
            pos=pos-1
          end if
        end if
        pos=pos-1
      if (pos.gt.sta) goto 10
C
C Then main eval loop
C
      change=.false.
      iter=0
      pos=sta-1
  100 continue
        iter=iter+1
        call incpos(pos,sta,fin)
        done=.false.
        error=0
C -- DEBUG
C       do kk=sta,fin
C       if (isenv(wtyp(kk))) then
C         write(*,'(a,$)') env(1000-wtyp(kk))(1:eow(env(1000-wtyp(kk))))
C       else if (isop(wtyp(kk))) then
C         write(*,'(1x,a,1x,$)') token(wtyp(kk))(1:eow(token(wtyp(kk))))
C       else if (wtyp(kk).eq.2000) then
C         write(*,'(a,f5.1,a,$)') ' ',expr(kk,1),' '
C       else if (wtyp(kk).eq.3000) then
C         write(*,'(2(a,i5),a,$)') ' ',
C    &      int(expr(kk,1)),'/', int(expr(kk,2)),' '
C       else if (isdata(wtyp(kk))) then
C         if (expr(kk,1).eq.MISS) then
C           write(*,'(a,$)') ' {x} '
C         else
C           write(*,'(a,f12.4,a,$)') ' {',expr(kk,1),'} '
C         end if
C       end if
C       end do
C       write(*,*)
C -- DEBUG
C
C an answer?
        if (sta.eq.fin) then
          if (isdata(wtyp(sta))) then
            done=.true.
          elseif (isop(wtyp(sta)) .and. op(wtyp(pos)).eq.10) then
            call zerop(pos,sta,fin,nterm,wtyp,expr,error)
            done=.true.
          elseif (error.ne.0) then
            done=.true.
          end if
        else 
C
C check next token and its neighbours (lookahead 1 and lookback 1)
C
          cand1=-1
          cand2=wtyp(pos)
          cand3=-1
          adh1=0
          adh2=0
          adh3=0
          adh4=0
          if (isop(cand2)) then
            adh2=lbp(cand2)
            adh3=rbp(cand2)
          end if
          if (pos.gt.sta) then
            cand1=wtyp(pos-1)
            if (isop(cand1)) then
              adh2=rbp(cand1)
            end if
          end if
          if (pos.gt.(sta+1) .and. isop(wtyp(pos-2))) then
            adh1=rbp(wtyp(pos-2))
          end if
          if (pos.lt.fin) then
            cand3=wtyp(pos+1)
            if (isop(cand3)) then
              adh3=lbp(cand3)
            end if
          end if
          if (pos.lt.(fin-1) .and. isop(wtyp(pos+2))) then
            adh4=lbp(wtyp(pos+2))
          end if
C
C Cases:   v v v, v v o, v o o, o v v, o o o     illegal
C          v o v, u o v                          binary operation
C          o v o                                 unary operation, brackets
C          o o v                                 unary
C
          three=((pos-sta).gt.0 .and. (fin-pos).gt.0)
C Zero function operation
          if (isop(cand2) .and. op(cand2).eq.10) then
            call zerop(pos,sta,fin,nterm,wtyp,expr,error)
            pos=pos-1
            change=.true.
C Brackets
          elseif (three .and. cand1.eq.1 .and. .not.isop(cand2) .and. 
     &        cand3.eq.2) then
            expr(pos-1,1)=expr(pos,1)
            expr(pos-1,2)=expr(pos,2)
            wtyp(pos-1)=wtyp(pos)
            call pull(pos,2,fin,nterm,wtyp,expr)
            pos=pos-1
            change=.true.
C Unary minus or plus
          else if ((cand1.eq.-1 .or. 
     2       (three .and. isop(cand1) .and. cand1.ne.2)) .and. 
     3       (cand2.eq.8 .or. cand2.eq.9) .and. isdata(cand3)) then
            if (cand2.eq.9) then
              wtyp(pos)=21
            else
              wtyp(pos)=22
            end if
            pos=pos-1
            change=.true.
C Binary operation
          else if (three .and. .not.isop(cand1) .and. 
     2             isop(cand2) .and. .not.isop(cand3) .and.
     3             op(cand2).eq.2 .and.
     4             adh2.ge.adh1 .and. adh3.ge.adh4) then
            call binop(pos,sta,fin,nterm,wtyp,expr,error)
            pos=pos-1
            change=.true.
C Unary operation
          else if (isop(cand2) .and. isdata(cand3) .and.
     &             op(cand2).eq.1 .and. adh3.ge.adh4) then
            call unop(pos,sta,fin,nterm,wtyp,expr,error)
            pos=pos-1
            change=.true.
          end if
          if (error.ne.0) then
            done=.true.
          end if
        end if
C
C test if expression unevaluable: a complete scan without any operations
C
        if (pos.eq.fin) then
          if (change) then
            change=.false.
          else if (.not.done) then
            done=.true.
            error=1
          end if
        end if
 
      if (.not.done .and. iter.lt.5000) goto 100
      return
      end
C end-of-simpev
C 
C write out results of command line expression evaluation
      subroutine wrans(prefix, expr, wtyp)
      integer MAXLOC, MAXCOL
      parameter (MAXLOC=120, MAXCOL=MAXLOC+5)
C address of env, trait, geno, missing trait, missing geno, NUM
      integer ADDTRA, ADDGEN, ADDMTR, ADDMGE, ADDNUM
      parameter(ADDTRA=200000, ADDGEN=300000, 
     &          ADDMTR=400000, ADDMGE=500000, ADDNUM=600000)

      character*(*) prefix
      integer wtyp(MAXCOL)
      double precision expr(MAXCOL,2)

      character*9 gtp
C functions
      logical legall

      if (wtyp(1).eq.ADDTRA) then
        write(*,'(a,$)') prefix
        write(*,*) expr(1,1)
      else if (wtyp(1).eq.ADDGEN) then
C Check bounds on result if a genotype
        if (legall(expr(1,1)) .and. legall(expr(1,2))) then
          call wrgtp(int(expr(1,1)),int(expr(1,2)),gtp,1) 
          write(*,'(2a)') prefix, gtp
        else
          write(*,'(2a)') prefix, 'Allele out of range '
        end if
      else if (wtyp(1).eq.ADDMGE) then
        write(*,'(2a)') prefix, '   x/x'
      else
        write(*,'(2a)') prefix, 'MISS'
      end if
      return
      end
C end-of-wrans
C
C the legal range of alleles
      logical function legall(xall)
      integer MISS
      parameter(MISS=-9999)
      double precision xall
      integer iall
      legall=.TRUE.
      iall=int(xall)
      if (iall .ne. MISS) then
        iall=abs(iall)
        legall=(iall.ge.1 .and. iall.le.999) .or.
     2         (iall.ge.10065 .and. iall.le.10090) .or.
     3         (iall.ge.10097 .and. iall.le.10122)
      end if
      return
      end
C end-of-legalall
C
C Is a number, variable or operator
C
      logical function isdata(idx)
C address of env, trait, geno, missing trait, missing geno, NUM
      integer ADDTRA
      parameter(ADDTRA=200000)
      integer idx
      isdata=(idx.ge.ADDTRA)
      return
      end
C end-of-isdata
      logical function isenv(idx)
C address of env, trait, geno, missing trait, missing geno, NUM
      integer ADDENV, ADDTRA
      parameter(ADDENV=100000, ADDTRA=200000)
      integer idx
      isenv=(idx.gt.ADDENV .and. idx.lt.ADDTRA)
      return
      end
C end-of-isenv
      logical function isvar(idx)
C address of env, trait, geno, missing trait, missing geno, NUM
      integer ADDTRA, ADDGEN, ADDMTR, ADDMGE, ADDNUM
      parameter(ADDTRA=200000, ADDGEN=300000, 
     &          ADDMTR=400000, ADDMGE=500000, ADDNUM=600000)
      integer idx
      isvar=((idx.gt.ADDTRA .and. idx.lt.ADDGEN) .or. 
     2       (idx.gt.ADDGEN .and. idx.lt.ADDMTR) .or. 
     3       (idx.gt.ADDMTR .and. idx.lt.ADDMGE) .or.
     4       (idx.gt.ADDMGE .and. idx.lt.ADDNUM))
      return
      end
C end-of-isvar
      logical function isop(idx)
C address of env, trait, geno, missing trait, missing geno, NUM
      integer ADDENV
      parameter(ADDENV=100000)
      integer idx
      isop=(idx.gt.0 .and. idx.lt.ADDENV)
      return
      end
C end-of-isop
C Genotype data - both values of interest
      logical function isvec(idx)
C address of env, trait, geno, missing trait, missing geno, NUM
      integer ADDGEN, ADDMTR, ADDMGE, ADDNUM
      parameter(ADDGEN=300000, ADDMTR=400000, 
     &          ADDMGE=500000, ADDNUM=600000)
      integer idx
      isvec=((idx.ge.ADDGEN .and. idx.lt.ADDMTR) .or.
     &       (idx.ge.ADDMGE .and. idx.lt.ADDNUM))
      return
      end
C end-of-isvec
      logical function ismis(idx)
C address of env, trait, geno, missing trait, missing geno, NUM
      integer ADDMTR, ADDNUM
      parameter(ADDMTR=400000, ADDNUM=600000)
      integer idx
      ismis=(idx.ge.ADDMTR .and. idx.lt.ADDNUM)
      return
      end
C end-of-ismis
C
C compound operators eg <= >= == ^=
C
      subroutine compop(pos,sta,fin,nterm,wtyp,expr,error)
      integer MAXLOC, MAXCOL, MISS
      parameter (MAXLOC=120, MAXCOL=MAXLOC+5, MISS=-9999) 
      integer error, fin, nterm, pos, sta
      integer wtyp(MAXCOL)
      double precision expr(MAXCOL,2)

      integer newop, op1, op2

      if (pos.eq.fin) then
        error=1
        return
      end if
      error=0
      op1=wtyp(pos)
      op2=wtyp(pos+1)
      newop=MISS
      if (op2.eq.11) then
        if (op1.eq.11) then
          newop=20
        elseif (op1.eq.15) then
          newop=18
        elseif (op1.eq.16) then
          newop=17
        elseif (op1.eq.10) then
          newop=19
        end if
      else
        error=1
        return
      end if
      wtyp(pos)=newop
      call pull(pos+1,1,fin,nterm,wtyp,expr)
      return
      end
C end-of-compop
C
C zero argument functions 
C
      subroutine zerop(pos,sta,fin,nterm,wtyp,expr,error)
      integer MAXLOC, MAXCOL, MISS
      parameter (MAXLOC=120, MAXCOL=MAXLOC+5, MISS=-9999) 
C address of env, trait, geno, missing trait, missing geno, NUM
      integer ADDTRA, ADDMTR, ADDNUM
      parameter(ADDTRA=200000, ADDMTR=400000, ADDNUM=600000)
      integer error, fin, nterm, pos, sta
      integer wtyp(MAXCOL)
      double precision expr(MAXCOL,2)

      integer curr, restyp
      double precision res
C functions
      real randn, random

      error=0
      curr=wtyp(pos)
      restyp=ADDTRA
      if (curr.eq.42) then
        res=dble(random())
      elseif (curr.eq.43) then
        res=dble(randn())
      elseif (curr.eq.44) then
        res=3.141592653590d0
      elseif (curr.eq.45) then
        res=1.0d0
      elseif (curr.eq.46) then
        res=0.0d0
      elseif (curr.eq.47) then
        res=MISS 
        restyp=ADDMTR
      elseif (curr.eq.48) then
        res=MISS 
        restyp=ADDNUM
      else
        res=MISS 
        restyp=ADDMTR
        error=1
      end if
      wtyp(pos)=restyp
      expr(pos,1)=res
      expr(pos,2)=res
      return
      end
C end-of-zerop
C
C unary operators
C
      subroutine unop(pos,sta,fin,nterm,wtyp,expr,error)
      integer KNOWN, MAXLOC, MAXCOL, MISS
      parameter (KNOWN=0, MAXLOC=120, MAXCOL=MAXLOC+5, MISS=-9999) 
C address of env, trait, geno, missing trait, missing geno, NUM
      integer ADDENV, ADDTRA, ADDGEN, ADDMTR, ADDMGE, ADDNUM
      parameter(ADDENV=100000, ADDTRA=200000, ADDGEN=300000, 
     &          ADDMTR=400000, ADDMGE=500000, ADDNUM=600000)
      integer error, fin, nterm, pos, sta
      integer wtyp(MAXCOL)
      double precision expr(MAXCOL,2)

      integer curr, restyp
      double precision res, x, x2
C functions
      logical ismis, isvec
      double precision inht

      if (pos.eq.fin) then
        error=1
        return
      end if
      restyp=ADDTRA
      if (isvec(wtyp(pos+1))) restyp=ADDGEN
      res=MISS 
      error=0
      curr=wtyp(pos)
      if (ismis(wtyp(pos+1))) then
        if (curr.eq.36) then
          res=0.0d0
        elseif (curr.eq.37) then
          res=1.0d0
        else
          restyp=ADDMTR
          if (isvec(wtyp(pos+1))) restyp=ADDMGE
          res=MISS
        end if
        expr(pos,1)=res
        expr(pos,2)=res
      elseif (curr.eq.36 .or. curr.eq.37) then
        x=expr(pos+1, 1)
        if ((restyp.eq.ADDGEN .and. x.gt.KNOWN) .or.
     &      (restyp.eq.ADDTRA .and. x.ne.MISS)) then
          res=1.0d0
        else
          res=0.0d0
        end if
        if (curr.eq.37) res=1.0d0-res
        restyp=ADDTRA
        expr(pos,1)=res
        expr(pos,2)=res
      else if (curr.eq.38 .or. curr.eq.39) then
        restyp=ADDTRA
        x=expr(pos+1, 1)
        x2=expr(pos+1, 2)
        if (x.gt.KNOWN .and. x2.gt.KNOWN) then
          res=0.0d0
          if (x.eq.x2) res=1.0d0
          if (curr.eq.38) res=1.0d0-res
        end if
        expr(pos,1)=res
        expr(pos,2)=res
      else if (curr.eq.40) then
        restyp=ADDTRA
        expr(pos,1)=expr(pos+1, 1)
        expr(pos,2)=expr(pos+1, 1)
      else if (curr.eq.41) then
        restyp=ADDTRA
        expr(pos,1)=expr(pos+1, 2)
        expr(pos,2)=expr(pos+1, 2)
      else  
        do 10 i=1, 2
          x=expr(pos+1, i)
          if (curr.eq.12) then
            if (x.eq.0.0d0) then 
              res=1.0d0
            else
              res=0.0d0
            end if
          elseif (curr.eq.24) then
            if (x.ge.0.0d0) then
              res=sqrt(x)
            else
              res=MISS 
              restyp=ADDNUM
            end if
          elseif (curr.eq.21) then
            res=-1.0d0*x
          elseif (curr.eq.23) then
            res=abs(x)
          elseif (curr.eq.25) then
            if (x.gt.0.0d0) then
              res=log(x)
            else
              res=MISS 
              restyp=ADDNUM
            end if
          elseif (curr.eq.26) then
            res=exp(x)
          elseif (curr.eq.27) then
            res=sin(x)
          elseif (curr.eq.28) then
            res=cos(x)
          elseif (curr.eq.29) then
            res=tan(x)
          elseif (curr.eq.30) then
            res=asin(x)
          elseif (curr.eq.31) then
            res=acos(x)
          elseif (curr.eq.32) then
            res=atan(x)
          elseif (curr.eq.33) then
            res=inht(x)
          elseif (curr.eq.34) then
            res=int(x)
          elseif (curr.eq.35) then
            res=anint(x)
          elseif (curr.eq.22) then
            res=x
          else
            restyp=ADDNUM
            res=MISS
            error=1
          end if
          expr(pos,i)=res
   10   continue
      end if
      wtyp(pos)=restyp
      call pull(pos+1,1,fin,nterm,wtyp,expr)
      return
      end
C end-of-unop
C
C binary operators
C
      subroutine binop(pos,sta,fin,nterm,wtyp,expr,error)
      integer MAXLOC, MAXCOL, MISS
      parameter (MAXLOC=120, MAXCOL=MAXLOC+5, MISS=-9999) 
C address of env, trait, geno, missing trait, missing geno, NUM
      integer ADDENV, ADDTRA, ADDGEN, ADDMTR, ADDMGE, ADDNUM
      parameter(ADDENV=100000, ADDTRA=200000, ADDGEN=300000, 
     &          ADDMTR=400000, ADDMGE=500000, ADDNUM=600000)
      integer error, fin, nterm, pos, sta
      integer wtyp(MAXCOL)
      double precision expr(MAXCOL,2)

      integer curr, i, restyp(2), wx, wy
      double precision res(2), tmp, x, y
C functions
      logical ismis, isvar, isvec
      real encgtp

      if (pos.eq.sta .or. pos.eq.fin) then
        error=1
        return
      end if

      restyp(1)=ADDTRA
      restyp(2)=ADDTRA
      if (isvec(wtyp(pos-1)) .or. isvec(wtyp(pos+1))) then
        restyp(1)=ADDGEN
        restyp(2)=ADDGEN
      end if
      res(1)=MISS 
      res(2)=MISS 
      error=0
      do 10 i=1,2
        x=expr(pos-1,i)
        y=expr(pos+1,i)
        wx=wtyp(pos-1)
        wy=wtyp(pos+1)
        curr=wtyp(pos)
C
C Generic number NUM: NUM <- NUM op <any>  (used for detecting parse error)
        if (wtyp(pos-1).eq.ADDNUM .or. wtyp(pos+1).eq.ADDNUM) then
          res(i)=MISS
          restyp(i)=ADDNUM
C
C Equality or inequality: allows comparison with missing values
        else if (curr.eq.19 .or. curr.eq.20) then
          restyp(i)=ADDTRA
          if (x.eq.y) then
            res(i)=1.0d0
          else
            res(i)=0.0d0
          end if
          if (curr.eq.19) then
            res(i)=1.0d0-res(i)
          end if
C
C Assignment:  <var> <- MISS  or  <var> <- <const>
C 
        else if (curr.eq.11) then
          if (ismis(wy)) then
            res(i)=MISS
            restyp(i)=ADDMTR
            if (.not.ismis(wx)) then
              if (isvec(wx)) then
                restyp(i)=wx-ADDGEN+ADDMGE
              else if (isvar(wx)) then
                restyp(i)=wx-ADDTRA+ADDMTR
              end if
            end if
          else
            res(i)=y
            restyp(i)=wx
            if (ismis(wx)) then
              if (isvec(wx)) then
                restyp(i)=wx-ADDMGE+ADDGEN
              else if (isvar(wx)) then
                restyp(i)=wx-ADDMTR+ADDTRA
              end if
            end if
          end if
C
C AND and OR allows (lazy) combination with missing values
C (T && x) = x   (T || x) = T    (F && x) = F   (F || x) = x
C
        else if (curr.eq.13) then
          restyp(i)=ADDTRA
          res(i)=1.0d0
          if (x .eq.0.0d0 .or. y.eq.0.0d0) then
            res(i)=0.0d0
          else if (ismis(wx) .or. ismis(wy)) then 
            res(i)=MISS
            restyp(i)=ADDMTR
          end if
        else if (curr.eq.14) then
          restyp(i)=ADDTRA
          res(i)=0.0d0
          if (x.eq.1.0d0 .or. y.eq.1.0d0) then
            res(i)=1.0d0
          elseif (ismis(wx) .or. ismis(wy)) then 
            res(i)=MISS
            restyp(i)=ADDMTR
          end if
C
C All other operations with missing values lead to MISS as outcome
        else if (ismis(wx) .or. ismis(wy)) then 
          res(i)=MISS
          restyp(i)=ADDMTR
          if (isvec(wx) .or. isvec(wy)) restyp(i)=ADDMGE
C
C All other operations 
        else if (curr.eq.6) then
          res(i)=x*y
        else if (curr.eq.7) then
          if (y.eq.0.0d0) then
            expr(pos-1,1)=MISS
            expr(pos-1,2)=MISS
            return
          else
            res(i)=x/y
          end if
        else if (curr.eq.8) then
          res(i)=x+y
        else if (curr.eq.9) then
          res(i)=x-y
        else if (curr.eq.10) then
          res(i)=x**y
        else if (curr.eq.16) then
          restyp(i)=ADDTRA
          if (x.gt.y) then
            res(i)=1.0d0
          else
            res(i)=0.0d0
          end if
        else if (curr.eq.15) then
          restyp(i)=ADDTRA
          if (x.lt.y) then
            res(i)=1.0d0
          else
            res(i)=0.0d0
          end if
        else if (curr.eq.17) then
          restyp(i)=ADDTRA
          if (x.ge.y) then
            res(i)=1.0d0
          else
            res(i)=0.0d0
          end if
        else if (curr.eq.18) then
          restyp(i)=ADDTRA
          if (x.le.y) then
            res(i)=1.0d0
          else
            res(i)=0.0d0
          end if
        else
          error=1
          return
        end if
   10 continue
      if (restyp(1).ne.restyp(2)) then
        error=1
        return
      end if
C
C Comparisons are joint for alleles of genotypes
C all equal or all not equal
C any greater or less
C >= is then tricky for geno v. geno, 
C so redo using genotype collation order
C
      if ((curr.eq.17 .or. curr.eq.18) .and.
     &    (isvec(wtyp(pos-1)) .and. isvec(wtyp(pos+1)))) then
        x=dble(encgtp(expr(pos-1,1),expr(pos-1,2)))
        y=dble(encgtp(expr(pos+1,1),expr(pos+1,2)))
        if ((curr.eq.17 .and. x.ge.y) .or.
     &      (curr.eq.18 .and. x.le.y)) then
          res(1)=1.0d0
          res(2)=1.0d0
        else
          res(1)=0.0d0
          res(2)=0.0d0
        end if 
      else if (res(1).ne.res(2)) then
        if (curr.eq.19 .or. curr.eq.20) then
          res(1)=0.0d0
          res(2)=0.0d0
        else if (curr.ge.13 .and. curr.le.18) then
          res(1)=1.0d0
          res(2)=1.0d0
        else if (res(1).gt.res(2)) then
          tmp=res(1)
          res(1)=res(2)
          res(2)=tmp 
        end if
      end if
      wtyp(pos-1)=restyp(1)
      expr(pos-1, 1)=res(1)
      expr(pos-1, 2)=res(2)
      call pull(pos,2,fin,nterm,wtyp,expr)
      return
      end
C end-of-binop
C
C Evaluate type of each term in expression word(farg...larg) and actn
C actn=0 error  =1 purely arithmetic  =2 legal
C
C Types are:         wtyp                 expr
C                    -----------------    --------
C tokens             0      + 0...TOKNUM    -
C env                100000 + 1...ENVNUM   (value)
C constant           200000                 value
C trait data         200000 + 1...NLOCI    (value)
C constant genotype  300000                 value, value
C genotype data      300000 + 1...NLOCI    (value, value)
C MISS               400000                 MISS  
C missing trait      400000 + 1...NLOCI     MISS
C MISS genotype      500000                 MISS/MISS
C missing trait      500000 + 1...NLOCI     MISS/MISS
C NUM                600000                 -   
C
      subroutine typwords(farg,larg,words,nloci,loc,loctyp,token,env,
     &                    wtyp,expr,actn)
      integer ENVNUM, KNOWN, MAXLOC, MAXCOL, MISS, TOKNUM 
      parameter (ENVNUM=12, KNOWN=0, MAXLOC=120, MAXCOL=MAXLOC+5, 
     &           MISS=-9999, TOKNUM=48)
C address of env, trait, geno, missing trait, missing geno, NUM
      integer ADDENV, ADDTRA, ADDGEN, ADDMTR, ADDMGE, ADDNUM
      parameter(ADDENV=100000, ADDTRA=200000, ADDGEN=300000, 
     &          ADDMTR=400000, ADDMGE=500000, ADDNUM=600000)
      integer actn, farg, larg
      character*20 words(MAXCOL)
      integer nloci, loctyp(MAXLOC)
      character*20 loc(MAXLOC)
      character*6 env(ENVNUM), token(TOKNUM)
      integer wtyp(MAXCOL)
      double precision expr(MAXCOL,2)

      integer i, ienv, ilok, itok
C functions
      logical isgeno, ismiss, isreal
      integer eow, isinenv
      double precision fval

      actn=1
      do 10 i=farg, larg
        expr(i,1)=MISS
        expr(i,2)=MISS
        ienv=isinenv(words(i),ENVNUM,env)
        itok=isinenv(words(i),TOKNUM,token)
        ilok=isinenv(words(i),nloci,loc)
        if (itok.gt.0) then
          wtyp(i)=itok
        else if (ilok.gt.0) then
          if (loctyp(ilok).eq.1 .or. loctyp(ilok).eq.2 .or.
     &        loctyp(ilok).eq.5 .or. loctyp(ilok).eq.6) then
            wtyp(i)=ADDGEN+ilok
          else
            wtyp(i)=ADDTRA+ilok
          end if
          actn=2
        else if (ienv.gt.0) then
          wtyp(i)=ADDENV+ienv
        else if (ismiss(words(i))) then
          wtyp(i)=ADDMTR
        else if (isgeno(words(i))) then
          call getgeno(words(i), expr(i,1), expr(i,2), wtyp(i))
        else if (isreal(words(i))) then
          wtyp(i)=ADDTRA
          expr(i,1)=fval(words(i))
          expr(i,2)=expr(i,1)
        else
          actn=0
          write(*,'(3a)') 'ERROR: token "',words(i)(1:eow(words(i))),
     &                    '" not recognised.'
          return
        end if
   10 continue
      return
      end
C end-of-typwords
C
C If checking arguments via dry run of parser, 
C replace variable values with (generic) NUM
C
      subroutine dryrun(farg,larg,wtyp)

      integer MAXLOC, MAXCOL
      parameter (MAXLOC=120, MAXCOL=MAXLOC+5) 
      integer ADDENV, ADDGEN, ADDNUM
      parameter(ADDENV=100000, ADDGEN=300000, ADDNUM=600000)

      integer farg, larg, wtyp(MAXCOL)
      integer i

              do 10 i=farg, larg
              if (wtyp(i).gt.ADDENV .and. wtyp(i).lt.ADDGEN) then
        wtyp(i)=ADDNUM
      end if
   10 continue
      return
      end
C end-of-dryrun
C
C Pull up expr
C
      subroutine pull(pos,dec,fin,nterm,typ,expr)
      integer MAXLOC, MAXCOL
      parameter (MAXLOC=120, MAXCOL=MAXLOC+5) 
      integer dec, fin, nterm, pos
      integer typ(MAXCOL)
      double precision expr(MAXCOL,2)
      integer i, j

      do 10 j=pos,nterm-dec
        typ(j)=typ(j+dec)
        do 15 i=1, 2
          expr(j,i)=expr(j+dec,i)
   15   continue
   10 continue
      nterm=nterm-dec
      if (fin.ge.pos) fin=fin-dec
      return
      end
C end-of-pull
C
C  See if a string is a missing value
C
      logical function ismiss(string)
      character*(*) string
      ismiss=(string.eq.'x' .or. string.eq.'X' .or. string.eq.'.')
      return
      end
C end-of-ismiss
C
C  See if a string is a valid real number
C
      logical function isreal(string)
      integer MISS
      parameter(MISS=-9999)
      character*20 string
      double precision v

      if (string.eq.'x' .or. string.eq.'X' .or. string.eq.'.' .or.
     2    string.eq.'y' .or. string.eq.'Y' .or. string.eq.' ' .or.
     3    string.eq.'n' .or. string.eq.'N') then
        isreal=.true.
      else
        read(string,'(f20.0)',err=10) v
        isreal=.true.
      end if 
      return
C error -- word is not a number
   10 continue
        isreal=.false.
      return
      end
C end-of-isreal
C
C  See if a string is a valid genotype
C
      logical function isgeno(string)
      integer MISS
      parameter(MISS=-9999)
      character*20 string
      integer i, lent, slash
      double precision a1, a2
C functions
      integer eow
      double precision aval

      isgeno=.false.
      if (string.eq.'x/x' .or. string.eq.'X/X' .or. 
     &    string.eq.'./.') then
        isgeno=.true.
      else
        slash=0
        lent=eow(string)
        do 10 i=1, lent
        if (string(i:i).eq.'/') then
          if (slash.eq.0) slash=i
        end if
   10   continue
        if (slash.ne.0) then
          a1=aval(string(1:(slash-1)))
          a2=aval(string((slash+1):lent))
          isgeno=(a1 .ne.  MISS .and. a2 .ne. MISS)
        end if
      end if 
      return
      end
C end-of-isgeno
C
C  Get a valid genotype
C
      subroutine getgeno(string, a1, a2, wtyp)
      integer MISS
      parameter(MISS=-9999)
C address of env, trait, geno, missing trait, missing geno, NUM
      integer ADDGEN, ADDMGE
      parameter(ADDGEN=300000, ADDMGE=500000)
      character*20 string
      double precision a1, a2, tmp
      integer i, lent, slash, wtyp
C functions
      integer eow
      double precision aval

      a1=MISS
      a2=MISS
      wtyp=ADDMGE
      if (string.eq.'x/x' .or. string.eq.'X/X' .or. 
     &    string.eq.'./.') then
        return
      else
        slash=0
        lent=eow(string)
        do 10 i=1, lent
          if (string(i:i).eq.'/' .and. slash.eq.0) slash=i
   10   continue
        if (slash.ne.0) then
          a1=aval(string(1:(slash-1)))
          a2=aval(string((slash+1):lent))
          if (a1.gt.a2) then
            tmp=a1
            a1=a2
            a2=tmp
          end if
          wtyp=ADDGEN
        end if
      end if 
      return
      end
C end-of-getgeno
C
C Is a bound environmental variable? and if so where?
C
      integer function isinenv(word,nvar,envnam)
      integer nvar
      character*(*) word, envnam(*)

      do 10 isinenv=1, nvar
      if (envnam(isinenv).eq.word) then
        return
      end if
   10 continue
      isinenv=0
      return
      end
C end-of-isinenv
C 
C Is a reserved word
C
C     integer function istoken(word,toknum,token)
C     integer toknum
C     character*(*) word, token(toknum)

C     do 10 istoken=1, toknum
C     if (word.eq.token(istoken)) then
C       return
C     end if
C  10 continue
C     istoken=0
C     return
C     end
C end-of-istoken
C
C Increment counter mod maxpos
C
      subroutine incpos(pos,minpos,maxpos)
      integer maxpos, pos
      if (pos.ge.maxpos) then
        pos=minpos
      else
        pos=pos+1
      end if
      return
      end
C end-of-incpos
C
C Evaluate expression for each pedigree member
C
      subroutine evalped(wrk, twrk, narg, words, nloci, loc, loctyp, 
     2             locpos, token, env, lbp, rbp, op, wtyp, expr,
     3             pedigree, actset, num, nfound, id, fa, mo, sex,
     4             locus, numloc, droperr, set, untyped, plevel)
      integer ENVNUM, KNOWN, MAXLOC, MAXCOL, MAXSIZ, MISS, TOKNUM 
      parameter (ENVNUM=12, KNOWN=0, MAXLOC=120, MAXCOL=MAXLOC+5, 
     &           MAXSIZ=1000, MISS=-9999, TOKNUM=48)
C address of env, trait, geno, missing trait, missing geno, NUM
      integer ADDENV, ADDTRA, ADDGEN, ADDMTR, ADDMGE, ADDNUM
      parameter(ADDENV=100000, ADDTRA=200000, ADDGEN=300000, 
     &          ADDMTR=400000, ADDMGE=500000, ADDNUM=600000)
      integer droperr,numloc,narg,plevel,twrk,wrk

      character*20 words(MAXCOL)
      character*6 env(ENVNUM), token(TOKNUM)
      integer lbp(0:TOKNUM), rbp(0:TOKNUM), op(0:TOKNUM)
      integer wtyp(MAXCOL)
      double precision expr(MAXCOL,2)
C
C Locus structure:
C number of loci, locus name, locus type, and locus position in file
C loctyp 1=marker 2=x-marker 3=quant 4=affection 5-8=deleted
C
      integer nloci
      character*20 loc(MAXLOC)
      integer loctyp(MAXLOC),locpos(MAXLOC)

C Pedigree structure
      character*10 pedigree
      integer actset, num, nfound
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ), sex(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)
      logical last
C workspace for Mendelial error checking
      logical untyped(MAXSIZ)
      integer set(MAXSIZ,2)
C
      integer actn, eop, error, i, nchange, nev, nerr, nmark, 
     &        nmiss, nped, nterm, sta, trget, tarpos
      integer ndiscard, inconsist  
      double precision tmp, x1, x2
C functions
      integer eow
      logical ismis, isvar, isvec, legall

      call cntmark(nloci,loctyp,nmark,1)

      last=.false.
      nchange=0
      ndiscard=0
      inconsist=0
      nerr=0
      nev=0
      nmiss=0
      nped=0
      trget=MISS
      rewind(wrk)
   10 continue
       call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &            numloc, last)
       if (last) goto 20
         if (actset.le.0) then
           call wrkout(twrk,pedigree,actset,num,nfound,id,fa,mo,sex,
     &                 locus,numloc)
           goto 10
         end if
C evaluate for each member of pedigree
        nped=nped+1
        eop=eow(pedigree)
        do 15 i=1, num
          sta=1
          nterm=narg
          call typwords(1,nterm,words,nloci,loc,loctyp,token,env,
     &                  wtyp,expr,actn)
C
C init variables in expr with value from locus() or environment
C
          call loadvar(i,nmark,nloci,loctyp,locpos,nev,nped,num,
     &                 nfound,sex, locus,sta,nterm,wtyp,expr)
          call parser(nterm,wtyp,expr,lbp,rbp,op,error)
C Update pedigree value if appropriate
          if (nterm.eq.1 .and. error.eq.0) then
            if (.not.isvar(wtyp(1))) then
              if (plevel.gt.0) then
                call wrans(pedigree(1:eow(pedigree)) // '-' // 
     &                     id(i)(1:eow(id(i))) // ' => ',expr, wtyp)
              end if
            else
              if (ismis(wtyp(1))) then 
                if (isvec(wtyp(1))) then
                  trget=wtyp(1)-ADDMGE
                else
                  trget=wtyp(1)-ADDMTR
                end if
              else
                if (isvec(wtyp(1))) then
                  trget=wtyp(1)-ADDGEN
                else
                  trget=wtyp(1)-ADDTRA
                end if
                if (expr(1,1).eq.MISS) expr(1,1)= -9999.001d0
              end if
              tarpos=locpos(trget)
              x1=expr(1,1)
              if (loctyp(trget).eq.4 .and. x1.ne.MISS) then
                if (x1.le.0.0d0) then
                  x1=1.0d0
                else
                  x1=2.0d0
                end if
              end if
              if ((locus(i,tarpos).ne.MISS .and. x1.eq.MISS) .or.
     2            ((loctyp(trget).eq.1 .or. loctyp(trget).eq.2) .and.
     3             locus(i,tarpos).gt.KNOWN .and. x1.le.KNOWN)) then
                nmiss=nmiss+1
              end if
              nchange=nchange+1
C If result is a trait, set to new value
              if (loctyp(trget).eq.3 .or. loctyp(trget).eq.4 .or.
     &            loctyp(trget).eq.7 .or. loctyp(trget).eq.8) then
                if (plevel.gt.1) then
                   write(*,'(7a,f12.4,a,f12.4)') 
     2             'Recoded ',pedigree(1:eop),'-',id(i)(1:eow(id(i))),
     3             ' at "',loc(trget), '" from ',
     4             locus(i,tarpos),' to ',x1
                end if
                locus(i,tarpos)=x1
C
C Else if result of evaluation is a marker,
C Genotype can change sign via arithmetic operations
C (go from + -> - == typed to untyped, and vice-versa,
C and change range of allele codes
C
              else
                if (x1.ne.MISS) then
                  x1=anint(x1)
                  if (x1.eq.0.0d0) x1=MISS
                  x2=anint(expr(1,2))
                  if (x2.eq.0.0d0) x2=MISS
                else
                  x2=MISS
                end if
                if (x1.gt.x2) then
                  tmp=x2
                  x2=x1
                  x1=tmp
                end if
                if (legall(x1) .and. legall(x2)) then
                  if (plevel.gt.1) then
                    write(*,'(6a,4(a,f4.0))') 
     2              'Recoded ',pedigree(1:eop),'-',id(i)(1:eow(id(i))),
     3              ' at "',loc(trget), '" from ',
     4              locus(i,tarpos),'/',locus(i,tarpos+1),' to ',
     5              x1,'/',x2
                  end if
                  locus(i,tarpos)=x1
                  locus(i,tarpos+1)=x2
                else
                  nerr=nerr+1
                  if (plevel.gt.1 .or. (plevel.eq.1 .and. 
     &                nerr.le.10)) then
                    write(*,'(5a)') 
     2               'NOTE:  Expression gives illegal genotype result ',
     3               'for ', pedigree(1:eow(pedigree)),'-', 
     4                       id(i)(1:eow(id(i))),'.'
                  end if
                end if
              end if
            end if
          else 
            nerr=nerr+1
            if (plevel.gt.1 .or. (plevel.eq.1 .and. nerr.le.10)) then
              write(*,'(5a)') 
     2         'NOTE:  Could not evaluate expression for ',
     3         pedigree(1:eow(pedigree)),'-',id(i)(1:eow(id(i))),'.'
            end if
          end if
   15   continue
C Mendel check if result a marker
        if (trget.ne.MISS .and. 
     2      (loctyp(trget).eq.1 .or.  loctyp(trget).eq.2 .or.
     3       loctyp(trget).eq.5 .or. loctyp(trget).eq.6)) then
          call check(pedigree,num,nfound,id,fa,mo,sex,locus,
     2               nloci,loc,loctyp,locpos,set,untyped,
     3               droperr,ndiscard,inconsist,-2)
        end if
        call wrkout(twrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &              numloc)
        nev=nev+num
      goto 10
   20 continue
      write(*,'(a,i6,a)') 'Recoded ',nchange,' values.'
      if (nmiss.gt.0) then
        write(*,'(a,i6,a)') 'Including ',nmiss,' values to missing.'
      end if
      if (nerr.gt.0) then
        write(*,'(a,i6,a,f5.1,a)') 
     2    'Could not evaluate expression for ',nerr,' records (',
     3    dfloat(100*nerr)/dfloat(nev),'%), which are left unchanged.' 
      end if
      if (inconsist.gt.0) then
        write(*,'(/a,i6,a,f5.1,a/7x,a)') 
     2    'NOTE:  Evaluation of expressions gave rise to ',inconsist,
     3    ' Mendelian inconsistencies (',
     4    dfloat(100*inconsist)/dfloat(nev),'%)' 
        if (droperr.ge.2) then
          write(*,'(7x,a,i6,a)') 
     &      'Resolved these by deleting ',ndiscard,' genotypes.'
        end if
      end if
      return
      end
C end-of-evalped
C
C Find if/then/else
C
      subroutine findth(nterm,wtyp,posif,posth,posel)
      integer MISS
      parameter (MISS=-9999)
      integer nterm, posel, posif, posth, wtyp(nterm)
      integer i
      posif=MISS
      posth=MISS
      posel=MISS
      do 10 i=1, nterm
        if (wtyp(i).eq.3 .and. posif.eq.MISS) then
          posif=i
        else if (wtyp(i).eq.4 .and. posth.eq.MISS) then
          posth=i
        else if (wtyp(i).eq.5 .and. posel.eq.MISS) then
          posel=i
        end if
   10 continue
      return
      end
C end-of-findth
C
C Load variable values for ith individual
C code y and n as 1 and 0
C tot records number of records evaluated to date
C
      subroutine loadvar(idx,nmark,nloci,loctyp,locpos,tot,nped,
     &                   num,nfound, sex,locus,sta,fin,wtyp,expr)
      integer  KNOWN, MAXCOL, MAXLOC, MAXSIZ, MISS
      parameter (KNOWN=0, MAXLOC=120, MAXCOL=MAXLOC+5, 
     &           MAXSIZ=1000, MISS=-9999)
C address of env, trait, geno, missing trait, missing geno, NUM
      integer ADDENV, ADDTRA, ADDGEN, ADDMTR, ADDMGE, ADDNUM
      parameter(ADDENV=100000, ADDTRA=200000, ADDGEN=300000, 
     &          ADDMTR=400000, ADDMGE=500000, ADDNUM=600000)
      integer fin, idx, nloci, nmark, nped, sta, tot

      integer wtyp(MAXCOL)
      double precision expr(MAXCOL,2)
      integer loctyp(MAXLOC),locpos(MAXLOC)

C Pedigree structure
      integer num, nfound
      integer sex(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)

      integer curr, i, j, iloc, marcom
C
C functions
      logical isenv, isvar, isvec

      do 10 j=sta,fin
        curr=wtyp(j)
C automatic/environmental variables
        if (isenv(curr)) then
          curr=curr-ADDENV
          expr(j,1)=MISS
          expr(j,2)=MISS
          wtyp(j)=ADDTRA
C female male
          if (curr.lt.3) then
            if (sex(idx).eq.MISS) then
              wtyp(j)=ADDMTR
            else
              expr(j,1)=dfloat(abs(sex(idx)-curr))
              expr(j,2)=expr(j,1)
            end if
C isfou
          elseif (curr.eq.3) then
            expr(j,1)=0.0d0
            if (idx.le.nfound) expr(j,1)=1.0d0
            expr(j,2)=expr(j,1)
C isnon 
          elseif (curr.eq.4) then
            expr(j,1)=0.0d0
            if (idx.gt.nfound) expr(j,1)=1.0d0
            expr(j,2)=expr(j,1)
C num
          elseif (curr.eq.5) then
            expr(j,1)=dfloat(num)
            expr(j,2)=expr(j,1)
C nfoun
          elseif (curr.eq.6) then
            expr(j,1)=dfloat(nfound)
            expr(j,2)=expr(j,1)
C famnum
          elseif (curr.eq.10) then
            expr(j,1)=dfloat(nped)
            expr(j,2)=expr(j,1)
C index
          elseif (curr.eq.11) then
            expr(j,1)=dfloat(tot+idx)
            expr(j,2)=expr(j,1)
C commar
          elseif (curr.eq.12) then
            call marshare(idx, num, locus, nloci, 
     &                    loctyp, locpos, marcom)
            expr(j,1)=dfloat(marcom)
            expr(j,2)=expr(j,1)
C anytyp alltyp numtyp 
          else
            iloc=0
            do 50 i=1, nloci
              if (loctyp(i).le.2 .and. locus(idx,locpos(i)).gt.KNOWN)
     &        then
                iloc=iloc+1
              end if
   50       continue
            expr(j,1)=0.0d0
            if (curr.eq.7) then
              if (iloc.gt.0) expr(j,1)=1.0d0
            else if (curr.eq.8) then
              if (iloc.eq.nmark) expr(j,1)=1.0d0
            else if (curr.eq.9) then
              expr(j,1)=dfloat(iloc)
            end if
            expr(j,2)=expr(j,1)
          end if
C user defined variables
        elseif (isvar(curr)) then
          if (isvec(curr)) then
            curr=curr-ADDGEN
            expr(j,1)=locus(idx,locpos(curr))
            expr(j,2)=locus(idx,locpos(curr)+1)
            if (expr(j,1).le.KNOWN) wtyp(j)=curr+ADDMGE
          else
            curr=curr-ADDTRA
            if (loctyp(curr).eq.4 .and. 
     &          locus(idx,locpos(curr)).ge.1) then
              expr(j,1)=locus(idx,locpos(curr))-1.0d0
              expr(j,2)=expr(j,1)
            else
              expr(j,1)=locus(idx,locpos(curr))
              expr(j,2)=expr(j,1)
            end if
            if (expr(j,1).eq.MISS) wtyp(j)=curr+ADDMTR
          end if
        end if
   10 continue
      return
      end
C end-of-loadvar 
C
C Select pedigrees where probands meet a given criterion v2
C
      subroutine doselect(wrk,twrk,typ,nprob,farg,larg,words,nloci,loc,
     2             loctyp,locpos,token,env,lbp,rbp,op,wtyp,expr,
     3             pedigree,actset,num,nfound,id,fa,mo,sex,locus,numloc,
     4             nobs,plevel)
      integer ENVNUM, MAXLOC, MAXCOL, MAXSIZ, MISS, TOKNUM 
      parameter (ENVNUM=12, MAXLOC=120, MAXCOL=MAXLOC+5, 
     &           MAXSIZ=1000, MISS=-9999, TOKNUM=48)
      integer farg,larg,nobs,nprob,numloc,plevel,twrk,typ,wrk

      character*20 words(MAXCOL)
      character*6 env(ENVNUM), token(TOKNUM)
      integer lbp(0:TOKNUM), rbp(0:TOKNUM), op(0:TOKNUM)
      integer wtyp(MAXCOL)
      double precision expr(MAXCOL,2)
C
C Locus structure:
C number of loci, locus name, locus type, and locus position in file
C loctyp 1=marker 2=x-marker 3=quant 4=affection 5-8=deleted
C
      integer nloci
      character*20 loc(MAXLOC)
      integer loctyp(MAXLOC),locpos(MAXLOC)

C Pedigree structure
      character*10 pedigree
      integer actset, num, nfound
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ), sex(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)
      logical last
C
C
      integer actn, error, fin, idx, nmark, nped, nuse, sta, tot, uped
      logical useful
C functions
      integer eow

      call prexpr(typ, nprob, farg, larg, words)

      call cntmark(nloci,loctyp,nmark,1)
      nped=0
      uped=0
      nobs=0
      tot=0
      last=.false.
      rewind(wrk)
   10 continue
       call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &            numloc, last)
       if (last) goto 20
 
       if (actset.gt.0) then
        useful=.false.
        nped=nped+1
        nuse=0
        do 15 idx=1, num
          sta=farg
          fin=larg 
          nterm=larg
          call typwords(sta,fin,words,nloci,loc,loctyp,token,env,
     &                  wtyp,expr,actn)
C init variables in expr with value from locus() or environment
          call loadvar(idx,nmark,nloci,loctyp,locpos,tot,nped,
     &                 num,nfound,sex,locus,sta,fin,wtyp,expr)
          call simpev(sta,fin,nterm,wtyp,expr,lbp,rbp,op,error)
C test if condition true
          if (sta.eq.fin .and. error.eq.0 .and. 
     &        expr(sta,1).ne.MISS .and. expr(sta,1).ne.0.0d0) then
            nuse=nuse+1
            if (typ.ne.5 .and. nuse .ge. nprob) then
              useful=.true.
              goto 100
            end if
          end if
   15   continue

        if (typ.eq.5 .and. nuse.eq.nprob) useful=.true.

  100   continue
        if (useful) then
          uped=uped+1
          nobs=nobs+num
          if (plevel.gt.1) then
            write(*,'(3a,a8)') 
     2      'Pedigree ',pedigree(1:eow(pedigree)),
     3      ' selected via person ',id(idx)
          end if
        else
          actset=-abs(actset)
        end if
        tot=tot+num
       end if
          call wrkout(twrk,pedigree,actset,num,nfound,id,fa,mo,sex,
     &                locus,numloc)
      goto 10
   20 continue

      write(*,'(/a,i5,a,i5,a/)') 
     &  'Number of pedigrees selected=',uped,' (',nobs,' individuals)'
      return
      end
C end-of-select
C 
C unselect or pack
      subroutine unsel(wrk,twrk,pedigree,actset,num,nfound,
     &             id,fa,mo,sex,locus,numloc,nobs,plevel)
      integer ENVNUM, MAXLOC, MAXCOL, MAXSIZ, MISS, TOKNUM 
      parameter (ENVNUM=11, MAXLOC=120, MAXCOL=MAXLOC+5, 
     &           MAXSIZ=1000, MISS=-9999, TOKNUM=48)
      integer plevel,twrk,wrk
C Pedigree structure
      character*10 pedigree
      integer actset, num, nfound
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ), sex(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)
      logical last

      integer nped, nobs, dped, dobs
C
      nped=0
      nobs=0
      dped=0
      dobs=0
      last=.false.
      rewind(wrk)
   10 continue
       call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &            numloc, last)
       if (last) goto 20
          nped=nped+1
          nobs=nobs+num
          actset=1
          call wrkout(twrk,pedigree,actset,num,nfound,id,fa,mo,sex,
     &                locus,numloc)
      goto 10
   20 continue
      write(*,'(/a,i5,a,i5,a/)') 
     &  'Number of active pedigrees=',nped,' (',nobs,' individuals)'
      if (dped.gt.0) then
        write(*,'(/a,i5,a,i5,a/)') 
     &  'Permanently deleted ',dped,' pedigrees (',dobs,' individuals)'
      end if
      return
      end
C end-of-unsel
C
C Count or print individuals per pedigree fulfilling criterion
C 
      subroutine docount(wrk,typ,farg,larg,words,nloci,loc,
     2             loctyp,locpos,token,env,lbp,rbp,op,wtyp,expr,
     3             pedigree,actset,num,nfound,id,fa,mo,sex,
     4             locus,numloc,nwid,ndec,plevel)
      integer ENVNUM,MAXLOC,MAXCOL,MAXSIZ,MISS,TOKNUM 
      parameter (ENVNUM=12, MAXLOC=120, MAXCOL=MAXLOC+5, 
     &           MAXSIZ=1000, MISS=-9999, TOKNUM=48)
      integer farg,larg,ndec,nwid,numloc,plevel,typ,wrk

      character*20 words(MAXCOL)
      character*6 env(ENVNUM), token(TOKNUM)
      integer lbp(0:TOKNUM), rbp(0:TOKNUM), op(0:TOKNUM)
      integer wtyp(MAXCOL)
      double precision expr(MAXCOL,2)
C
C Locus structure:
C number of loci, locus name, locus type, and locus position in file
C loctyp 1=marker 2=x-marker 3=quant 4=affection 5-8=deleted
C
      integer nloci
      character*20 loc(MAXLOC)
      integer loctyp(MAXLOC),locpos(MAXLOC)

C Pedigree structure
      character*10 pedigree
      integer actset, num, nfound
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ), sex(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)
      logical last
C Local variables
      integer actn,arg1,argn,currf,currm,contrib,error,fin,idx,k,nmark
      integer naff,nped,nasp,nast,nasq,nuse,taff,tasp,tast,tasq,tot
C interrupt
      integer irupt
      common /flag/ irupt

      call prexpr(typ, 1, farg, larg, words)

      if (typ.eq.1) then
        write(*,'(a/a)') 'Pedigree   Con=T   Num  ASPs Trios    4+',
     &                   '---------- ----- ----- ----- ----- -----'
      end if
      call cntmark(nloci,loctyp,nmark,1)
      irupt=0
      nped=0
      nuse=0
      taff=0
      tasp=0
      tast=0
      tasq=0
      tot=0
      last=.false.
      rewind(wrk)
   10 continue
       call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &            numloc, last)
       if (last .or. irupt.ne.0) goto 20
 
       if (actset.le.0) goto 10

        naff=0
        nasp=0
        nast=0
        nasq=0

        nped=nped+1
C founders
        do 95 idx=1,nfound
          arg1=farg
          argn=larg 
          nterm=larg
          call typwords(arg1,argn,words,nloci,loc,loctyp,token,env,
     &           wtyp,expr,actn)
          call loadvar(idx,nmark,nloci,loctyp,locpos,tot,nped,
     &                 num,nfound,sex, locus,arg1,argn,wtyp,expr)
          call simpev(arg1,argn,nterm,wtyp,expr,lbp,rbp,op,error)
          if (arg1.eq.argn .and. error.eq.0 .and.
     &        ((expr(arg1,1).ne.MISS .and. expr(arg1,1).ne.0.0d0) .or.
     &         (expr(arg1,2).ne.MISS .and. expr(arg1,2).ne.0.0d0))) then
            naff=naff+1
            if (typ.eq.2) then
              call wrind(idx,pedigree,id,fa,mo,sex,
     &                   locus,nloci,loc,loctyp,locpos,nwid,ndec)
            end if
          end if
   95   continue
C nonfounders
        fin=num
        currf=fa(num)
        currm=mo(num)
        do 90 k=num-1,nfound,-1
          if (fa(k).ne.currf .or. mo(k).ne.currm) then
            nfam=nfam+1
            contrib=0
            do 92 idx=k+1,fin
              arg1=farg
              argn=larg 
              nterm=larg
              call typwords(arg1,argn,words,nloci,loc,loctyp,token,env,
     &               wtyp,expr,actn)
C init variables in expr with value from locus() or environment
              call loadvar(idx,nmark,nloci,loctyp,locpos,tot,nped,
     &               num,nfound,sex,locus,arg1,argn,wtyp,expr)
              call simpev(arg1,argn,nterm,wtyp,expr,lbp,rbp,op,error)
C test if condition true
              if (arg1.eq.argn .and. error.eq.0 .and.
     2            ((expr(arg1,1).ne.MISS .and. expr(arg1,1).ne.0.0d0) 
     3             .or. (expr(arg1,2).ne.MISS .and. 
     4             expr(arg1,2).ne.0.0d0))) then
                naff=naff+1
                contrib=contrib+1
                if (typ.eq.2) then
                  call wrind(idx,pedigree,id,fa,mo,sex,
     &                       locus,nloci,loc,loctyp,locpos,nwid,ndec)
                end if
              end if
   92       continue
C Now update to next sibship
            if (contrib.eq.2) then
              nasp=nasp+1
            else if (contrib.eq.3) then
              nast=nast+1
            else if (contrib.gt.3) then
              nasq=nasq+1
            end if
            fin=k
            currf=fa(fin)
            currm=mo(fin)
          end if
   90   continue
        if (typ.eq.1 .and. plevel.ge.0 .and. naff.gt.0) then
          write(*,'(a,5(1x,i5))') pedigree, naff, num, nasp, nast, nasq
        end if
        taff=taff+naff
        tasp=tasp+nasp
        tast=tast+nast
        tasq=tasq+nasq
        tot=tot+num
        if (naff.gt.0) then
          nuse=nuse+1
        end if
      goto 10
   20 continue
      if (typ.eq.1) then
        write(*,'(a10,5(1x,i5))') 
     &    'Total     ',taff, tot, tasp, tast, tasq 
      end if
      write(*,'(/2(/a,i5,a,i5,a,f5.1,a))') 
     2  'Number of matched persons   =',taff,' out of ',tot,
     3   ' (',100.0d0*dfloat(taff)/dfloat(tot),'%)',
     4  'Number of matched pedigrees =',nuse,' out of ', nped,
     5   ' (',100.0d0*dfloat(nuse)/dfloat(nped),'%)' 
      return
      end
C end-of-docount 
C
C Delete data for individuals fulfilling criterion
C 
      subroutine seldel(wrk,twrk,nord,locord,farg,larg,words,nloci,loc,
     2             loctyp,locpos,token,env,lbp,rbp,op,wtyp,expr,
     3             pedigree,actset,num,nfound,id,fa,mo,sex,
     4             locus,numloc,plevel)
      integer ENVNUM,KNOWN,MAXLOC,MAXCOL,MAXSIZ,MISS,TOKNUM 
      parameter (ENVNUM=12, KNOWN=0, MAXLOC=120, MAXCOL=MAXLOC+5, 
     &           MAXSIZ=1000, MISS=-9999, TOKNUM=48)
      integer farg,larg,numloc,plevel,twrk,wrk
      integer nord, locord(MAXSIZ)

      character*20 words(MAXCOL)
      character*6 env(ENVNUM), token(TOKNUM)
      integer lbp(0:TOKNUM), rbp(0:TOKNUM), op(0:TOKNUM)
      integer wtyp(MAXCOL)
      double precision expr(MAXCOL,2)
C
C Locus structure:
C number of loci, locus name, locus type, and locus position in file
C loctyp 1=marker 2=x-marker 3=quant 4=affection 5-8=deleted
C
      integer nloci
      character*20 loc(MAXLOC)
      integer loctyp(MAXLOC),locpos(MAXLOC)

C Pedigree structure
      character*10 pedigree
      integer actset, num, nfound
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ), sex(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)
      logical last
C Local variables
      integer actn,arg1,argn,error,idx,k,nmark,pos
      integer ndel,nped,tot
C functions
      integer eow

      call prexpr(6, nord, farg, larg, words)

      ndel=0
      nped=0
      tot=0
      last=.false.
      rewind(wrk)
   10 continue
       call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &            numloc, last)
       if (last) goto 20
 
       if (actset.gt.0) then
         nped=nped+1
         do 95 idx=1,num
           arg1=farg
           argn=larg 
           nterm=larg
           call typwords(arg1,argn,words,nloci,loc,loctyp,token,env,
     &            wtyp,expr,actn)
           call loadvar(idx,nmark,nloci,loctyp,locpos,tot,nped,
     &                  num,nfound,sex, locus,arg1,argn,wtyp,expr)
           call simpev(arg1,argn,nterm,wtyp,expr,lbp,rbp,op,error)
           if (arg1.eq.argn .and. error.eq.0 .and.
     2         ((expr(arg1,1).ne.MISS .and. expr(arg1,1).ne.0.0d0) .or.
     3          (expr(arg1,2).ne.MISS .and. expr(arg1,2).ne.0.0d0))) 
     4     then
             ndel=ndel+1
             if (plevel.gt.1) then
               write(*,'(4a)') 
     &           'Deleting ', pedigree(1:eow(pedigree)), '-', id
             end if
             do 50 j=1, nord
               k=locord(j)
               pos=locpos(k)
               if ((loctyp(k).eq.1 .or. loctyp(k).eq.2) .and.
     &             locus(idx,pos).ge.KNOWN) then
                 locus(idx,pos)=-locus(idx,pos)
                 locus(idx,pos+1)=-locus(idx,pos+1)
               else if (loctyp(k).eq.3 .or. loctyp(k).eq.4) then
                 locus(idx,pos)=MISS
               end if
   50        continue
           end if
   95    continue
         tot=tot+num
       end if
        call wrkout(twrk,pedigree,actset,num,nfound,id,fa,mo,sex,
     &              locus,numloc)
      goto 10
   20 continue
      write(*,'(/2(/a,i5,a,i5,a,f5.1,a))') 
     2  'Number of deleted records   =',ndel,' out of ',tot,
     3   ' (',100.0d0*dfloat(ndel)/dfloat(tot),'%)' 
      return
      end
C end-of-seldel  
C
C
C Echo action to be performed
C
      subroutine prexpr(typ, nprob, farg, larg, words)
      integer MAXLOC,MAXCOL
      parameter (MAXLOC=120, MAXCOL=MAXLOC+5) 

      integer farg,larg,nprob,typ

      character*20 words(MAXCOL)
C Local variables
      integer k
C functions
      integer eow

      if (typ.eq.1) then
        write(*,'(/2a,$)') 
     &    'Count where "', words(farg)(1:eow(words(farg)))
      else if (typ.eq.2) then
        write(*,'(/2a,$)') 
     &    'Print where "', words(farg)(1:eow(words(farg)))
      else if (typ.eq.3) then
        write(*,'(/2a,$)') 
     &    'Selecting pedigrees where "', words(farg)(1:eow(words(farg)))
      else if (typ.eq.4) then
        write(*,'(/a,i3,2a,$)') 
     2    'Selecting pedigrees to contain ',nprob, 
     3    ' or more individuals where "',words(farg)(1:eow(words(farg)))
      else if (typ.eq.5) then
        write(*,'(/a,i3,2a,$)') 
     2  'Selecting pedigrees to contain exactly ',
     3  nprob,' individuals where "', words(farg)(1:eow(words(farg)))
      else if (typ.eq.6) then
        write(*,'(/a,i3,2a,$)') 
     2    'Zeroing ',nprob,' variables in each record where "', 
     3    words(farg)(1:eow(words(farg)))
      end if
      do 1 k=farg+1, larg
        write(*,'(1x,a,$)') words(k)(1:eow(words(k)))
    1 continue
      write(*,'(a/)') '":'
      return
      end
C end-of-prexpr
