C
C extract unrelated individuals with information for a criterion trait
C
      subroutine wricas(wrk,twrk,trait,pedigree,actset,
     &                  num,nfound,id,fa,mo,sex,locus,numloc)
      integer MAXSIZ,MAXLOC,MISS
      parameter (MAXSIZ=1000,MAXLOC=120,MISS=-9999)
      integer trait,wrk,twrk
C Pedigree structure
      character*10 pedigree
      integer actset,num,nfound 
      character*10 id(MAXSIZ) 
      integer fa(MAXSIZ),mo(MAXSIZ),sex(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)

      integer aff(MAXSIZ)

      logical last
      integer eop, i, nuse, tuse
      character*10 fam
C functions
      integer eow
      
      tuse=0
      last=.false.
      rewind(wrk)
   10 continue
       call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &            numloc, last)
       if (last) goto 20

        if (actset.le.0) then
          call wrkout(twrk,pedigree,actset,num,nfound,id,fa,mo,sex,
     &                locus,numloc)
          goto 10
        end if
       
        do 50 i=1, nfound
          if (locus(i,trait).ne.MISS) then
            aff(i)=2
          else
            aff(i)=1
          end if
   50   continue
        do 70 i=nfound+1, num
          if (aff(fa(i)).eq.1 .and. aff(mo(i)).eq.1) then 
            if (locus(i,trait).ne.MISS) then
              aff(i)=2
              aff(fa(i))=3
              aff(mo(i))=3
            else 
              aff(i)=1
            end if
          else 
            aff(i)=3
          end if
   70   continue

        nuse=0
        eop=eow(pedigree)
        do 100 i=1, num
        if (aff(i).eq.2) then
          nuse=nuse+1
          fam=pedigree
          call makeind(1,nuse,eop,10,fam)
          write(twrk) fam, actset, 1, 1  
          write(twrk) id(i),MISS,MISS,sex(i),(locus(i,j),j=1,numloc)
        end if
  100   continue
        tuse=tuse+nuse
      goto 10
   20 continue
      write(*,'(a,i6,a)') 'Extracted ',tuse,' cases.'
      return
      end
C end-of-getcas 
C
C convert into nuclear families, duplicating individuals as needed
C
      subroutine nuclear(wrk,twrk,pedigree,actset,num,nfound,
     &                   id,fa,mo,sex,locus,numloc,maxsibs,typ)
      integer MAXSIZ,MAXLOC
      parameter (MAXSIZ=1000,MAXLOC=120)
      integer maxsibs,wrk,twrk,typ
C Pedigree structure
      character*10 pedigree
      integer actset,num,nfound 
      character*10 id(MAXSIZ) 
      integer fa(MAXSIZ),mo(MAXSIZ),sex(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)
      logical last

      integer currf, currm, eop, nuc, pos, sta

C functions
      integer eow

      maxsibs=maxsibs-1

      last=.false.
      rewind(wrk)
   10 continue
       call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &            numloc, last)
       if (last) goto 20

       if (nfound.eq.num .or. actset.le.0) then
         call wrkout(twrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &              numloc)
       else
         nuc=0
         eop=eow(pedigree)
         pos=nfound+1
         sta=pos
         currf=fa(sta)
         currm=mo(sta)
   50    continue
           if (fa(pos).ne.currf .or. mo(pos).ne.currm) 
     &     then
             nuc=nuc+1
             call onefam(twrk,pedigree,actset,num,nfound,
     2               id,fa,mo,sex,locus,numloc,maxsibs,
     3               eop, nuc, currf, currm, sta, pos-1, typ)
             sta=pos
             currf=fa(sta)
             currm=mo(sta)
           end if
           pos=pos+1
         if (pos.le.num) goto 50
C last sibship
         nuc=nuc+1
         call onefam(twrk,pedigree,actset,num,nfound,
     2           id,fa,mo,sex,locus,numloc,maxsibs,
     3           eop, nuc, currf, currm, sta, num, typ)
       end if
      goto 10
   20 continue
      return
      end
C end-of-nuclear
C
C write out current nuclear family -- with or without grandparents
C
      subroutine onefam(twrk,pedigree,actset,num,nfound,
     2                  id,fa,mo,sex,locus,numloc,maxsibs,
     3                  eop, nuc, currf, currm, sta, fin, typ)
      integer MAXSIZ,MAXLOC,MISS
      parameter (MAXSIZ=1000,MAXLOC=120,MISS=-9999)
      integer maxsibs, twrk, typ
      integer currf, currm, eop, fin, nuc, sta
C Pedigree structure
      character*10 pedigree
      integer actset,num,nfound 
      character*10 id(MAXSIZ) 
      integer fa(MAXSIZ),mo(MAXSIZ),sex(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)

      character*10 fam
      integer gp1, gp2, gp3, gp4, i, j, nfou, nsibs, p1, p2

      fam=pedigree
      call makeind(1,nuc,eop,10,fam)
      nsibs=min(fin-sta,maxsibs)+1
      nfou=0
      gp1=MISS
      gp2=MISS
      gp3=MISS
      gp4=MISS
      p1=1
      p2=2
      if (typ.eq.2) then
        if (currf.gt.nfound) then
          nfou=nfou+2
          p1=p1+2
          p2=p2+2
          gp1=1
          gp2=2
        end if
        if (currm.gt.nfound) then
          nfou=nfou+2
          p1=p1+2
          p2=p2+2
          gp3=max(gp2,0)+1
          gp4=gp3+1
        end if
      end if
      write(twrk) fam, actset, nsibs+2+nfou, max(2,nfou)
C Grandparents
      if (typ.eq.2) then
        if (currf.gt.nfound) then
          write(twrk) id(fa(currf)),MISS,MISS,1, 
     &      (locus(fa(currf),j),j=1,numloc)
          write(twrk) id(mo(currf)),MISS,MISS,2, 
     &      (locus(mo(currf),j),j=1,numloc)
        end if
        if (currm.gt.nfound) then
          write(twrk) id(fa(currm)),MISS,MISS,1, 
     &      (locus(fa(currm),j),j=1,numloc)
          write(twrk) id(mo(currm)),MISS,MISS,2, 
     &      (locus(mo(currm),j),j=1,numloc)
        end if
      end if
C Parents
      write(twrk) id(currf),gp1,gp2,1, 
     &  (locus(currf,j),j=1,numloc)
      write(twrk) id(currm),gp3,gp4,2, 
     &  (locus(currm,j),j=1,numloc)
C Children
      do 55 i=sta,min(sta+maxsibs,fin)
        write(twrk) id(i),p1,p2,sex(i),
     &    (locus(i,j),j=1,numloc)
   55 continue
      return
      end
C end-of-onefam 
C
C chop into disjoint subpedigrees
C note that the pointers in set(,2) do not follow the sort order of
C the pedigree, as connect() moves both up and down the generations
C
      subroutine disjoin(wrk,twrk,pedigree,actset,num,nfound,id,fa,mo,
     &                   sex,locus,numloc,ord,set,plevel)
      integer MAXSIZ,MAXLOC,MISS
      parameter (MAXSIZ=1000,MAXLOC=120,MISS=-9999)
      integer plevel, wrk, twrk
C Pedigree structure
      character*10 pedigree
      integer actset,num,nfound 
      character*10 id(MAXSIZ) 
      integer fa(MAXSIZ), mo(MAXSIZ), sex(MAXSIZ)
      integer ord(MAXSIZ), set(MAXSIZ,2)
      integer numloc
      double precision locus(MAXSIZ,MAXLOC)
      logical last
      integer curped, eop, maxgrp, nf, nsub, no
      character*10 fam
C functions
      integer eow
C
      last=.false.
      rewind(wrk)
   10 continue
       call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &            numloc, last)
       if (last) goto 20
         if (actset.le.0) then
           call wrkout(twrk,pedigree,actset,num,nfound,id,fa,mo,sex,
     &                 locus,numloc)
           goto 10
         end if
         call connect(num,fa,mo,set,nsub,maxgrp)
         if (plevel.gt.0) then
           write(*,'(3a,i4,a)') 'Pedigree ',pedigree,' written out as ',
     &       nsub,' pedigrees.'
         end if
         if (nsub.eq.1) then
           call wrkout(twrk,pedigree,actset,num,nfound,id,fa,mo,sex,
     &                 locus,numloc)
         else
           eop=eow(pedigree)
           do 15 curped=1,nsub
             nf=0
             no=0
             do 25 i=1,nfound
             if (set(i,1).eq.curped) then
               no=no+1
               nf=nf+1
               ord(i)=no
             end if
   25        continue
             do 26 i=nfound+1,num 
             if (set(i,1).eq.curped) then
               no=no+1
               ord(i)=no
             end if
   26        continue
             fam=pedigree
             call makeind(1,curped,eop,10,fam)
             if (plevel.gt.1) then
               write(*,'(2a)') 'Created pedigree ',fam
             end if
             write(twrk) fam, actset, no, nf
             do 30 i=1,nfound
             if (set(i,1).eq.curped) then
               write(twrk) id(i),MISS,MISS,sex(i),
     &           (locus(i,j),j=1,numloc)
             end if
   30        continue
             do 31 i=nfound+1,num 
             if (set(i,1).eq.curped) then
               write(twrk) id(i),ord(fa(i)),ord(mo(i)),sex(i),
     &           (locus(i,j),j=1,numloc)
             end if
   31        continue
   15      continue
         end if
      goto 10
   20 continue
      return
      end
C end-of-disjoin
C
C Delete MZ twin with least phenotype information out of pair 
C or clean MZ genotypes 
C
      subroutine dropt2(wrk,twrk,mztwin,gt,thresh,typ,pedigree,actset,
     &             num,nfound,id,fa,mo,sex,locus,
     2             numloc,nloci,loc,loctyp,locpos,plevel)
C
      integer KNOWN, MAXSIZ, MAXLOC, MISS
      parameter(KNOWN=0, MAXSIZ=1000,MAXLOC=120,MISS=-9999)
      integer mztwin, plevel, twrk, typ, wrk
      integer gt
      double precision thresh
C  Pedigree structure
      character*10 pedigree
      integer actset, num, nfound
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ), sex(MAXSIZ)
      integer numloc
      double precision locus(MAXSIZ,MAXLOC)
C locus structure
      integer nloci
      character*20 loc(MAXLOC)
      integer loctyp(MAXLOC),locpos(MAXLOC)
C local variables
      integer i, g1,g2,g3,g4, gene, hitwin, k, lotwin, 
     &        npairs, nphen1, nphen2, twin1
      character*7 gtp1, gtp2
      logical last
C functions
      double precision isaff
C
      write(*,'(4(/a))')
     2  '------------------------------------------------------------',
     3  'Checking for MZ discordance at marker loci',
     4  '------------------------------------------------------------',
     5  'Pedigree    Person1  Person2  Locus       Geno1   Geno2'
      npairs=0
      nphen1=0
      last=.false.
      rewind(wrk)
   10 continue
        call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &             numloc, last)
        if (last) goto 50

        if (actset.gt.0) then
          twin1=MISS
          do 20 i=nfound+1,num
          if (int(isaff(locus(i,mztwin),thresh,gt)).eq.2) then
            if (twin1.eq.MISS) then
              twin1=i
              nphen1=0
              do 28 k=1, nloci
              if (loctyp(k).gt.2 .and. locpos(k).ne.MISS) then
                nphen1=nphen1+1
              end if
   28         continue
            else
              if (fa(i).eq.fa(twin1) .and. mo(i).eq.mo(twin1)) then
                nphen2=0
                npairs=npairs+1
C
C zero inconsistent genotypes and fill in blanks where applicable
                do 30 k=1,nloci
                if (loctyp(k).eq.1 .or. loctyp(k).eq.2) then
                  gene=locpos(k)
                  g1=int(locus(twin1,gene))
                  g2=int(locus(i,gene))
                  if (g1.gt.KNOWN .and. g2.gt.KNOWN) then
                    g3=int(locus(twin1,gene+1))
                    g4=int(locus(i,gene+1))
                    if (g1.ne.g2 .or. g3.ne.g4) then
                      call wrgtp(g1,g2,gtp1,1)
                      call wrgtp(g3,g4,gtp2,1)
                      write(*,'(3(1x,a),1x,a10,2(1x,a))') 
     &                  pedigree, id(twin1), id(i), loc(k), gtp1, gtp2
                      locus(twin1,gene)=-locus(twin1,gene)
                      locus(twin1,gene+1)=-locus(twin1,gene+1)
                      locus(i,gene)=-locus(i,gene)
                      locus(i,gene+1)=-locus(i,gene+1)
                    end if
                  else if (g1.le.KNOWN .and. g2.gt.KNOWN) then
                    locus(twin1,gene)=locus(i, gene)
                    locus(twin1,gene+1)=locus(i, gene+1)
                  else if (g1.gt.KNOWN .and. g2.le.KNOWN) then
                    locus(i,gene)=locus(twin1, gene)
                    locus(i,gene+1)=locus(twin1, gene+1)
                  end if
                else if (locus(i,locpos(k)).ne.MISS) then
                  nphen2=nphen2+1
                end if
   30           continue
C
C Pick twin with most phenotype to save, drop other twins data
C averaging quantitative trait values
C
                if (typ.eq.2) then
                  lotwin=i
                  hitwin=twin1
                  if (nphen1.gt.nphen2) then
                    lotwin=twin1
                    hitwin=i
                  end if
                  if (plevel.gt.1) then
                    write(*,*) 'Dropping MZ twin ',pedigree, id(lotwin)
                  end if
                  do 35 k=1,nloci
                    if (loctyp(k).eq.1 .or. loctyp(k).eq.2) then
                      gene=locpos(k)
                      if (locus(lotwin,gene).gt.KNOWN) then
                        locus(lotwin,gene)= -locus(lotwin, gene)
                        locus(lotwin,gene+1)= -locus(lotwin, gene+1)
                      end if
                    else if (loctyp(k).eq.3) then
                      gene=locpos(k)
                      if (locus(hitwin,gene).ne.MISS .and.
     &                    locus(lotwin,gene).ne.MISS) then
                        locus(hitwin,gene)= 0.5*(locus(hitwin,gene)+
     &                                           locus(lotwin, gene))
                      else if (locus(hitwin,gene).eq.MISS) then
                        locus(hitwin,gene)= locus(lotwin,gene)
                      end if
                      locus(lotwin,gene)=MISS
                    else if (loctyp(k).eq.4) then
                      gene=locpos(k)
                      locus(lotwin,gene)=MISS
                    end if
   35             continue
                end if
                twin1=MISS
              else
                twin1=i
              end if
            end if
          end if
   20     continue
        end if
        call wrkout(twrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &              numloc)
      goto 10
   50 continue
      if (typ.eq.2) then
        write(*,*) 
     &    'Dropped one member of ', npairs, ' sets of MZ twins.'
      end if
      return
      end
C end-of-dropt2
C
C Edit alleles for particular gene for particular person 
C
      subroutine edit(wrk,twrk,tped,tid,gene,loc,loctyp,all1,all2,
     2                pedigree,actset,num,nfound,id,fa,mo,sex,
     3                locus,numloc)
      integer MAXSIZ,MAXLOC,MISS
      parameter (MAXSIZ=1000,MAXLOC=120,MISS=-9999)
      integer twrk,wrk
C target pedigree,id,replacement alleles
      character*10 tid
      character*10 tped,loc
      integer gene,loctyp
      double precision all1, all2
C Pedigree structure
      character*10 pedigree
      integer actset,num,nfound 
      character*10 id(MAXSIZ) 
      integer fa(MAXSIZ),mo(MAXSIZ),sex(MAXSIZ)
      integer numloc
      double precision locus(MAXSIZ,MAXLOC)
      logical last
C
      integer i,j,eop,gen2, nchanges
      logical allids
      double precision tmp
      character*1 newbin,oldbin
      character*7 newgtp,oldgtp
      character*10 chid
C functions
      integer eow
      logical strfind

      allids=(tid.eq.'all     ')
      gen2=gene+1
      nchanges=0
      last=.false.
      rewind(wrk)
   10 continue
       call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &            numloc, last)
       if (last) goto 20
        if (actset.gt.0 .and. strfind(tped,pedigree,1)) then
          eop=eow(pedigree)
          do 15 i=1,num
          if (allids .or. strfind(tid,id(i),1)) then
            call wrid('l',id(i),chid,0)
            if (gene .eq. MISS) then
              write(*,'(4a)') 
     2          'Deleting all data for ',
     3          pedigree(1:eop),'-',chid(1:eow(chid)) 
              do 12 j=1,numloc
                locus(i,j)=MISS
   12         continue
            elseif (loctyp .le. 2) then
              if (all1.gt.all2) then
                tmp=all1
                all1=all2
                all2=tmp
              end if
              call wrgtp(int(all1),int(all2),newgtp,1)
              call wrgtp(int(locus(i,gene)),int(locus(i,gen2)),oldgtp,1)
              write(*,'(10a)') 
     2          'Changing ',pedigree(1:eop),'-',chid(1:eow(chid)),
     3          ' at locus "',loc(1:eow(loc)), 
     4          '" from ',oldgtp, ' to ',newgtp
              locus(i,gene)=all1
              locus(i,gen2)=all2
            elseif (loctyp .eq. 3) then
              write(*,'(7a,f8.4,a,f8.4)') 
     2          'Changing ',pedigree(1:eop),'-',chid(1:eow(chid)),
     3          ' at locus "',loc(1:eow(loc)),
     4          '" from ',locus(i,gene),' to ',all1
              locus(i,gene)=all1
            elseif (loctyp .eq. 4) then
              call wraff(all1,newbin)
              call wraff(locus(i,gene),oldbin)
              write(*,'(7a,a8,a,a8)') 
     2          'Changing ',pedigree(1:eop),'-',chid(1:eow(chid)),
     3          ' at locus "',loc(1:eow(loc)),
     4          '" from ', oldbin,' to ',newbin
              locus(i,gene)=all1
            end if
            nchanges=nchanges+1
          end if
   15     continue
        end if
        call wrkout(twrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &              numloc)
      goto 10
   20 continue
      if (nchanges.eq.0) then
        write(*,'(5a)') 'ERROR: Could not find any record matching "', 
     &                  tped(1:eow(tped)), '-', tid(1:eow(tid)),'".'
      end if
      return
      end
C end-of-edit
C
C include or exclude a list of pedigrees
C
      subroutine selped(wrk,twrk,typ,farg,larg,words,pedigree,actset,
     &                  num, nfound,id,fa,mo,sex,locus,numloc,plevel)
      integer MAXLOC, MAXCOL, MAXSIZ, MISS
      parameter (MAXLOC=120, MAXCOL=MAXLOC+5, MAXSIZ=1000, MISS=-9999)

      integer farg,larg,plevel,twrk,typ,wrk
      character*20 words(MAXCOL)
C Pedigree structure
      character*10 pedigree
      integer actset, num, nfound
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ), sex(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)
      logical last
C
      integer i, j, nfam
      logical found, ltyp
C functions
      logical strfind

      ltyp=(typ.eq.2 .or. typ.eq.4) 

      nfam=0
      last=.false.
      rewind(wrk)
   10 continue
       call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &            numloc, last)
       if (last) goto 20
        found=ltyp
        if (typ.le.2) then
          do 50 i=farg, larg
          if (actset.gt.0 .and. strfind(words(i)(1:10),pedigree,1)) then
            found=.not.found
            goto 60
          end if
   50     continue
        else
          do 55 i=farg, larg
          do 55 j=1, num
          if (actset.gt.0 .and. strfind(words(i)(1:10),id(j),1)) then
            found=.not.found
            goto 60
          end if
   55     continue
        end if
   60   continue
        if (found) then
          nfam=nfam+1
          if (plevel.gt.0) write(*,'(2a)') 'Selected pedigree ',pedigree
        else
          actset=-abs(actset)
        end if
        call wrkout(twrk,pedigree,actset,num,nfound,id,fa,mo,sex,
     &              locus,numloc)
      goto 10
   20 continue
      write(*,'(/a,i6,a)') 'Selected ',nfam,' pedigrees.'
      return
      end
C end-of-selped
C
C Convert to/from Julian etc
C
      subroutine dateconv(wrk,twrk,trait,pedigree,actset,num,
     &                    nfound,id,fa,mo,sex,locus,numloc,typ,epoch)
      integer MAXSIZ,MAXLOC,MISS
      parameter (MAXSIZ=1000,MAXLOC=120,MISS=-9999)
      integer trait,twrk,typ,wrk
      double precision epoch
C Pedigree structure
      character*10 pedigree
      integer actset,num, nfound
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ), sex(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)
      logical last
      character*10 sdate
      integer i
C functions
      double precision getyear, togreg, tojulian
                                                                        
      last=.false.
      rewind(wrk)
      if (typ.eq.1) then
        call wrdate(epoch, sdate, 1)
        write(*,'(/3a)') 
     2    'Converting dates from Gregorian to Julian (epoch="', sdate,
     3    '").'
   10   continue
         call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &              numloc, last)
         if (last) goto 20
          do 15 i=1, num
          if (locus(i,trait).ne.MISS) then
            locus(i,trait)=tojulian(locus(i,trait))-epoch
          end if
   15     continue
          call wrkout(twrk,pedigree,actset,num,nfound,id,fa,mo,sex,
     &                locus,numloc)
        goto 10
   20   continue
      else if (typ.eq.2) then
        call wrdate(epoch, sdate, 1)
        write(*,'(/3a)') 
     2    'Converting dates from Julian (epoch="', sdate,
     3    '") to Gregorian.'
   30   continue
         call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &              numloc, last)
         if (last) goto 40
          do 35 i=1, num
          if (locus(i,trait).ne.MISS) then
            locus(i,trait)=togreg(locus(i,trait)+epoch)
          end if
   35     continue
          call wrkout(twrk,pedigree,actset,num,nfound,id,fa,mo,sex,
     &                locus,numloc)
        goto 30
   40   continue
      else if (typ.eq.3) then
        write(*,'(/a)') 'Converting date to decimal years.'
   50   continue
         call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &              numloc, last)
         if (last) goto 60
          do 55 i=1, num
          if (locus(i,trait).ne.MISS) then
            locus(i,trait)=getyear(locus(i,trait))
          end if
   55     continue
          call wrkout(twrk,pedigree,actset,num,nfound,id,fa,mo,sex,
     &                locus,numloc)
        goto 50
   60   continue
      end if
      return
      end
C end-of-dateconv
C
C identify rare alleles at a marker locus and list for combination
C
      subroutine combine(crit,recto,nf,recfro,numal,name,alfrq)
      integer KNOWN,MAXSIZ,MAXLOC,MAXALL
      parameter (KNOWN=0,MAXSIZ=1000,MAXLOC=120,MAXALL=60)
      integer nf
      double precision crit, recto, recfro(MAXALL)
C allele frequencies within entire sample for given locus 
      integer numal, name(MAXALL)
      double precision alfrq(MAXALL)

      nf=0
      do 10 i=1, numal
      if (alfrq(i).le.crit) then
        nf=nf+1
        recfro(nf)=name(i)
      end if
   10 continue
C recode to 999 or nearest available allele number
      recto=1000.0d0
   20 continue
        recto=recto-1.0d0
      do 30 i=1, numal
        if (int(recto).eq.name(i)) goto 20
   30 continue
      return
      end
C end-of-combine
C
C flip alleles to complement eg other strand A<->T G<->C 
C
      subroutine flip(wrk,twrk,loc,gene,pedigree,actset,num,nfound,
     &                id,fa,mo,sex,locus,numloc)
      integer MAXSIZ,MAXLOC,MAXALL,MISS
      parameter (MAXSIZ=1000,MAXLOC=120,MAXALL=60,MISS=-9999)
      integer gene,twrk,wrk
      character*10 loc
C Pedigree structure
      character*10 pedigree
      integer actset,num, nfound
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ), sex(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)
      logical last
      integer g1,g2,gen2,i
C functions
      integer atgc, eow
                                                                        
      write(*,'(/3a)')
     &  'Recoding alleles at "',loc(1:eow(loc)), '" to complement.'
                                                                        
      gen2=gene+1
                                                                        
      last=.false.
      rewind(wrk)
   10 continue
       call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &            numloc, last)
       if (last) goto 20
        do 15 i=1,num
        if (locus(i,gene).ne.MISS) then
          g1=atgc(int(locus(i,gene)))
          g2=atgc(int(locus(i,gen2)))
          call order(g1,g2)
          locus(i,gene)=dfloat(g1)
          locus(i,gen2)=dfloat(g2)
        end if
   15   continue
        call wrkout(twrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &              numloc)
      goto 10
   20 continue
      return
      end
C end-of-flip
C
C complement nucleotide
      integer function atgc(g)
      integer g
      atgc=g
      if (abs(g).eq.10097 .or. abs(g).eq.10065) atgc=g+sign(19,g)
      if (abs(g).eq.10099 .or. abs(g).eq.10067) atgc=g+sign(4,g)
      if (abs(g).eq.10103 .or. abs(g).eq.10071) atgc=g-sign(4,g)
      if (abs(g).eq.10116 .or. abs(g).eq.10084) atgc=g-sign(19,g)
      return
      end
C end-of-atgc
C
C renumber alleles to consecutive integers
C
      subroutine renumb(wrk,twrk,loc,gene,typ,numal,name,alfrq,
     3             pedigree,actset,num,nfound,id,fa,mo,sex,locus,numloc)
      integer MAXSIZ,MAXLOC,MAXALL,MISS
      parameter (MAXSIZ=1000,MAXLOC=120,MAXALL=60,MISS=-9999)
      integer gene,twrk,typ,wrk
      character*10 loc
C Pedigree structure
      character*10 pedigree
      integer actset,num, nfound
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ), sex(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)
      logical last
C allele frequencies within entire sample for given locus 
      integer numal, name(MAXALL)
      double precision alfrq(MAXALL)
C
      integer i,g1,g2,gen2
      integer ifreq(MAXALL), ord(MAXALL)
C functions
      integer eow, getnam

      write(*,'(/3a,i3,a)') 'Renumbering alleles at "',loc(1:eow(loc)),
     &                      '" to 1..', numal,'.'
      if (typ.eq.3) then
        write(*,'(a)') 'Ordering by sample allele frequency.'
        do 5 i=1, numal
          ifreq(i)=int(1000.0d0*alfrq(i))
          ord(i)=i
    5   continue
        call isort(1, numal, ifreq, ord, 2)
        do 6 i=1, numal
          ifreq(ord(i))=i
    6   continue
      end if

      gen2=gene+1

      last=.false.
      rewind(wrk)
   10 continue
       call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &            numloc, last)
       if (last) goto 20
        do 15 i=1,num
        if (locus(i,gene).ne.MISS) then
          g1=getnam(locus(i,gene),numal,name)
          g2=getnam(locus(i,gen2),numal,name)
          if (typ.eq.3) then
            g1=ifreq(g1)
            g2=ifreq(g2)
            call order(g1,g2)
          end if
          locus(i,gene)=sign(1.0d0,locus(i,gene))*dfloat(g1)
          locus(i,gen2)=sign(1.0d0,locus(i,gene))*dfloat(g2)
        end if
   15   continue
        call wrkout(twrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &              numloc)
      goto 10
   20 continue
      return
      end
C end-of-renumb
C
C recode alleles or values for particular locus -- 
C replace all "from" values with "to" values
C
      subroutine recode(wrk,twrk,loc,gene,typ,recto,nf,recfro,
     &             pedigree,actset,num,nfound,id,fa,mo,sex,locus,numloc)
      integer KNOWN,MAXSIZ,MAXLOC,MAXALL,MISS
      parameter (KNOWN=0,MAXSIZ=1000,MAXLOC=120,MAXALL=60,MISS=-9999)
      integer gene,nf,twrk,typ,wrk
      character*10 loc
      double precision recto, recfro(MAXALL)
C Pedigree structure
      character*10 pedigree
      integer actset,num, nfound
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ), sex(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)
      logical last
C
      integer i,j,gen2, nchange
      character*3 allel
      logical change
      double precision swp

      write(*,'(/a,a10)') 'Recoding locus ',loc
      if (typ.eq.1 .or. typ.eq.2) then
        write(*,'(a,$)') 'From: '
        do 1 i=1, nf
          call wrall(int(recfro(i)), allel)
          write(*,'(1x,a3,$)') allel
    1   continue
        call wrall(int(recto), allel)
        write(*,'(/a,1x,a3/)') 'To  : ',allel
      else
        write(*,'(a,30(1x,f4.0):)') 'From: ',(recfro(i),i=1,nf)
        write(*,'(a,1x,f4.0/)')     'To  : ',recto
      end if

      gen2=gene+1
      nchange=0
      last=.false.
      rewind(wrk)
   10 continue
       call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &            numloc, last)
       if (last) goto 20
        if (actset.gt.0) then
          if (typ.eq.1 .or. typ.eq.2) then
            do 15 i=1,num
              change=.false.
              do 16 j=1,nf
                if (abs(locus(i,gene)).eq.recfro(j)) then
                  if (recto.eq.MISS) then
                    locus(i,gene)=MISS
                    locus(i,gen2)=MISS
                    change=.true.
                  else
                    locus(i,gene)=sign(1.0d0,locus(i,gene))*recto
                    change=(locus(i,gene).gt.KNOWN)
                  end if
                end if
                if (abs(locus(i,gen2)).eq.recfro(j)) then
                  if (recto.eq.MISS) then
                    locus(i,gene)=MISS
                    locus(i,gen2)=MISS
                    change=.true.
                  else
                    locus(i,gen2)=sign(1.0d0,locus(i,gen2))*recto
                    change=(locus(i,gene).gt.KNOWN)
                  end if
                end if
                if (change) then
                  nchange=nchange+1
                  if (locus(i,gene).gt.locus(i,gen2)) then
                    swp=locus(i,gene)
                    locus(i,gene)=locus(i,gen2)
                    locus(i,gen2)=swp
                  end if
                end if
   16         continue
   15       continue
          else
            do 25 i=1,num
            do 25 j=1,nf
              if (locus(i,gene).eq.recfro(j)) then
                locus(i,gene)=recto
                nchange=nchange+1
              end if
   25       continue
          end if
        end if
        call wrkout(twrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &              numloc)
      goto 10
   20 continue
      if (recto.eq.MISS) then
        write(*,'(a,i6,a)') 'Set ',nchange,' values to missing.'
      else
        write(*,'(a,i6,a)') 'Recoded ',nchange,' values.'
      end if
      return
      end
C end-of-recode
C
C Kaplan-Meier estimator of survival function and the Nelson-Aalen 
C estimator of cumulative hazard.
C The Nelson-Aalen estimator is used to produce residuals, if requested.
C These are the deviance residuals of Therneau et al Biometrika 1990:
C equivalent to a variance-stabilized transformed martingale residual.
C
C
      subroutine prodlim(wrk,twrk,trait,censor,pedigree,actset,num,
     2             nfound,id,fa,mo,sex,locus,numloc,
     3             onset,haz,set,typ,plevel)
C
      integer MAXSIZ, MAXLOC, MISS
      parameter(MAXSIZ=1000, MAXLOC=120, MISS=-9999)
      integer censor, plevel, trait, twrk, typ, wrk
C  Pedigree structure
      character*10 pedigree
      integer actset, num, nfound
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ), sex(MAXSIZ)
      integer numloc
      double precision locus(MAXSIZ,MAXLOC)
C Age at onset, associated survival function
      integer naff, nobs, nvals, unaff
      double precision onset(MAXSIZ), haz(MAXSIZ)
      integer set(MAXSIZ,2)
C local variables
      integer i,j,k
      double precision res,x
      double precision dn, na, pl, va
      logical last

      naff=0
      nobs=0
      nvals=0
      do 1 i=1,MAXSIZ
        set(i,1)=0
        set(i,2)=0
    1 continue

      last=.false.
      rewind(wrk)
    5 continue
        call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &             numloc, last)
        if (last) goto 20

        if (actset.gt.0) then
         do 10 i=1,num
         if (locus(i,trait).ne.MISS) then
           nobs=nobs+1
           x=locus(i,trait)
           j=0
   15      continue
             j=j+1
           if (x.gt.onset(j) .and. j.le.nvals) goto 15
           if (x.ne.onset(j)) then
             if (nvals.lt.MAXSIZ) then
               do 30 k=nvals,j,-1
                 onset(k+1)=onset(k)
                 set(k+1,1)=set(k,1)
                 set(k+1,2)=set(k,2)
   30          continue
               nvals=nvals+1
               onset(j)=x
               set(j,1)=0
               set(j,2)=0
             else
               j=nvals
             end if
           end if
           set(j,2)=set(j,2)+1
           if (locus(i,censor).eq.2) then
             naff=naff+1
             set(j,1)=set(j,1)+1
           end if
         end if
   10    continue
        end if
      goto 5
   20 continue

      if (plevel.gt.1) then
        write(*,'(2(/a))') 
     2    ' Rank  Age-at-onset  Failed     Obs',
     3    ' ----------------------------------' 
        do 50 j=1,nvals
          write(*,'(1x,i4,2x,f12.4,2i8)') j,onset(j),set(j,1),set(j,2)
   50   continue
      end if
      write(*,'(2(/a))') 
     2  ' Age-at-onset   Failed  Riskset   H(t)   S(t)    ase',
     3  ' ---------------------------------------------------' 
      na=0.0d0
      pl=1.0d0
      va=0.0d0
      unaff=nobs-naff
      do 110 j=1,nvals
        if (set(j,1).ne.0) then
          dn=dfloat(set(j,1))/dfloat(nobs)
          na=na+dn
          pl=pl*(1.0d0-dn)
          va=va+dn/dfloat(max(1,nobs-set(j,1)))
          write(*,'(1x,f12.4,2(1x,i8),3(1x,f6.4))') 
     &      onset(j),set(j,1),nobs,na,pl,pl*sqrt(va)
        end if
        haz(j)=na
        nobs=nobs-set(j,2)
  110 continue
      write(*,'(/a/a//i5,a,i5,a)')
     2  ' H(t) = Nelson-Aalen estimator of integrated hazard',
     3  ' S(t) = Kaplan-Meier estimator of survivor function',
     4  naff,' affecteds and ',unaff,' unaffecteds used'
      if (typ.eq.1) return
C
C else replace age-at-onset with residual
C
      rewind(wrk)
  175 continue
        call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &             numloc, last)
        if (last) goto 190

        if (actset.gt.0) then
         do 180 i=1,num
         if (locus(i,trait).ne.MISS) then
           x=locus(i,trait)
           j=0
  185      continue
             j=j+1
           if (x.gt.onset(j) .and. j.le.nvals) goto 185
           if (locus(i,censor).eq.2.0d0) then
             res=1.0d0-haz(j)
             locus(i,trait)=sign(1.0d0,res)*
     &                      sqrt(-2*(res+log(1.0d0-res)))
           else
             locus(i,trait)=-sqrt(2*haz(j))
           end if
         end if
  180    continue
        end if
        call wrkout(twrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &              numloc)
      goto 175
  190 continue
      return
      end
C end-of-prodlim
C
C standardization of quantitative trait overall or *within* family
C as required by the approach of Commenge 
C
      subroutine stand(wrk,twrk,trait,pedigree,actset,num,
     &             nfound,id,fa,mo,sex,locus,numloc,typ)
C
      integer MAXSIZ, MAXLOC, MISS
      parameter(MAXSIZ=1000, MAXLOC=120, MISS=-9999)
      integer wrk, twrk, trait, typ
C  Pedigree structure
      character*10 pedigree
      integer actset, num, nfound
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ), sex(MAXSIZ)
      integer numloc
      double precision locus(MAXSIZ,MAXLOC)
      integer i, n
      double precision mu, sd
      logical last

      last=.false.
      rewind(wrk)
      if (typ.eq.2) then
    5   continue
          call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &               numloc, last)
          if (last) goto 20

          if (actset.gt.0) then
            n=0
            mu=0.0d0
            sd=0.0d0
            do 10 i=1,num
            if (locus(i,trait).ne.MISS) then
              n=n+1
              call moment(n,locus(i,trait),mu,sd)
            end if
   10       continue
C
            if (n.gt.0) then
              sd=sqrt(sd/dfloat(max(1,n-1)))
              do 30 i=1,num
              if (locus(i,trait).ne.MISS) then
                locus(i,trait)=(locus(i,trait)-mu)/sd
              end if
   30         continue
            end if
          end if
          call wrkout(twrk,pedigree,actset,num,nfound,id,fa,mo,sex,
     &                locus, numloc)
        goto 5
   20   continue
      elseif (typ.eq.1) then
        n=0
        mu=0.0d0
        sd=0.0d0
   55   continue
          call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &               numloc, last)
          if (last) goto 70

          if (actset.gt.0) then
            do 60 i=1,num
            if (locus(i,trait).ne.MISS) then
              n=n+1
              call moment(n,locus(i,trait),mu,sd)
            end if
   60       continue
          end if
        goto 55
   70   continue
C
        sd=sqrt(sd/dfloat(max(1,n-1)))
        rewind(wrk)
   75   continue
          call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &               numloc, last)
          if (last) goto 90
          if (actset.gt.0) then
            do 80 i=1,num
            if (locus(i,trait).ne.MISS) then
              locus(i,trait)=(locus(i,trait)-mu)/sd
            end if
   80       continue
          end if
          call wrkout(twrk,pedigree,actset,num,nfound,id,fa,mo,sex,
     &                locus, numloc)
        goto 75
   90   continue
      end if
      return
      end
C end-of-stand
C
C linear regression correction of quantitative trait 1 versus trait 2
C
      subroutine adjust(wrk,twrk,ytrait,xtrait,adjval,pedigree,actset,
     &                  num,nfound,id,fa,mo,sex,locus,numloc,plevel)
C
      integer MAXSIZ, MAXLOC, MISS
      parameter(MAXSIZ=1000, MAXLOC=120, MISS=-9999)
      integer wrk, twrk, ytrait, xtrait, plevel
      double precision adjval
C  Pedigree structure
      character*10 pedigree
      integer actset,num, nfound
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ), sex(MAXSIZ)
      integer numloc
      double precision locus(MAXSIZ,MAXLOC)
      integer n, i, ifail
      logical last
C regression results
      double precision x(3),r(6),b(2)
      double precision alpha,beta,mux 
      n=0
      ifail=0
      mux=0.0d0
      call inicov(3, 6, r)

      last=.false.
      rewind(wrk)
    5 continue
        call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &             numloc, last)
        if (last) goto 20

        if (actset.gt.0) then
         do 10 i=1,num
         if (locus(i,ytrait).ne.MISS .and. locus(i,xtrait).ne.MISS) then
           n=n+1
           x(1)=1.0d0
           x(2)=locus(i,xtrait)
           x(3)=locus(i,ytrait)
           mux=mux+x(2)
           call givenc(r, 6, 3, x, 1.0d0, ifail)
         end if
   10    continue
        end if
      goto 5
   20 continue
C
      call bsub(r, 6, 3, b, 2, ifail)
      alpha=b(1)
      beta=b(2)
      mux=mux/dfloat(n) 
      if (adjval.eq.MISS) adjval=mux
      if (plevel.gt.0) then
        write(*,'(a,f12.4/2(a,f12.4),a,i4,a/)') 
     2    'Adjusting to x-value of ',adjval,
     3    'y = ',alpha,' + ',beta,' * x  (based on ',n,' values)' 
      end if
      if (ifail.gt.0) then
        write(*,'(a/)') 'ERROR: Regression routine problem.'
        return
      end if
C
      rewind(wrk)
   25 continue
        call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &             numloc, last)
        if (last) goto 40

        if (actset.gt.0) then
         do 30 i=1,num
         if (locus(i,ytrait).ne.MISS) then
           if (locus(i,xtrait).ne.MISS) then
             locus(i,ytrait)=locus(i,ytrait)+
     &                       sngl(beta*(adjval-locus(i,xtrait)))
           else
             locus(i,ytrait)=locus(i,ytrait)+ beta*(adjval-mux)
           end if
         end if
   30    continue
        end if
        call wrkout(twrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &              numloc)
      goto 25
   40 continue
      return
      end
C end-of-adjust
C
C transform quantitative trait value
C
C t(x) =    { (x-offset)/divisor }                    Power == 1
C t(x) = log{ (x-offset)/divisor }                    Power == 0
C t(x) =   [{ (x-offset)/divisor }**Power - 1]/Power  Power != 0 && !=1
C Resulting values can be truncated above or below
C
      subroutine boxcox(wrk,twrk,trait,offset,divisor,power,loval,hival,
     &             pedigree,actset,num,nfound,id,fa,mo,sex,locus,numloc)
      integer MAXSIZ,MAXLOC,MISS
      parameter (MAXSIZ=1000,MAXLOC=120,MISS=-9999)
      integer trait,twrk,wrk
      double precision divisor, hival, loval, offset, power
C Pedigree structure
      character*10 pedigree
      integer actset, num, nfound
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ), sex(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)
      logical last
C
      integer i,ifault
      double precision x

      ifault=0
      last=.false.
      rewind(wrk)
   10 continue
       call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &            numloc, last)
       if (last) goto 20

       if (actset.gt.0) then
        if (power.eq.1.0d0) then
          do 15 i=1,num
          if (locus(i,trait).ne.MISS) then
            locus(i,trait)=(locus(i,trait)-offset)/divisor
          end if
   15     continue
        elseif (power.eq.0.0d0) then
          do 25 i=1,num
          if (locus(i,trait).ne.MISS) then
            x=(locus(i,trait)-offset)/divisor
            if (x.le.0) then
              ifault=ifault+1
              locus(i,trait)=MISS
            else
              locus(i,trait)=log(x)
            end if
          end if
   25     continue
        else
          do 35 i=1,num
          if (locus(i,trait).ne.MISS) then
            x=(locus(i,trait)-offset)/divisor
            if ((mod(power,1.0d0).ne.0.0d0 .and. x.lt.0) .or.
     2          (power.lt.0.0d0 .and. x.eq.0.0d0))  then
              ifault=ifault+1
              locus(i,trait)=MISS
            else
              locus(i,trait)=(x**power-1.0d0)/power
            end if
          end if
   35     continue
        end if
        if (loval.ne.MISS) then
          do 45 i=1,num
          if (locus(i,trait).ne.MISS .and. locus(i,trait).lt.loval) then
            locus(i,trait)=loval
          end if
   45     continue
        end if
        if (hival.ne.MISS) then
          do 55 i=1,num
          if (locus(i,trait).ne.MISS .and. locus(i,trait).gt.hival) then
            locus(i,trait)=hival
          end if
   55     continue
        end if
       end if
        call wrkout(twrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &              numloc)
      goto 10
   20 continue

      if (ifault.gt.0) then
        write(*,'(/a,i5,2a/7x,a/)') 
     2    'NOTE:  There were ',ifault,' trait values that could not be',
     3    ' transformed as requested.','New values were set to missing.'
      end if
      return
      end
C end-of-boxcox
C
C Convert a genotype to a quantitative trait
      subroutine factor(wrk,twrk,trget, gene, numal, name, 
     2                  pedigree,actset,num,nfound,id,fa,mo,sex, 
     3                  locus,numloc)
      integer KNOWN,MAXSIZ,MAXLOC,MAXALL,MISS
      parameter (KNOWN=0,MAXSIZ=1000,MAXLOC=120,MAXALL=60,MISS=-9999)
      integer gene,numloc,trget,twrk,wrk
C alleles at the marker
      integer numal, name(MAXALL)
C Pedigree structure
      character*10 pedigree
      integer actset, num, nfound
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ), sex(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)
      logical last
C
      integer g1,g2,gen2,i
C functions
      integer getnam

      gen2=gene+1
      last=.false.
      rewind(wrk)
   10 continue
       call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &            numloc, last)
       if (last) goto 20

        if (actset.gt.0) then
          do 30 i=1,num
            locus(i,trget)=MISS
            if (locus(i,gene).gt.KNOWN) then
              g1=getnam(locus(i,gene),numal,name)
              g2=getnam(locus(i,gen2),numal,name)
              locus(i,trget)=float(g2*(g2-1)/2+g1)
            end if
   30     continue
        end if
        call wrkout(twrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &              numloc)
      goto 10
   20 continue
      return
      end
C end-of-factor
C
      subroutine dorank(wrk,twrk,trget,trait,typ,pedigree,actset,
     &             num,nfound,id,fa,mo,sex,locus,numloc,value,counts)
C
      integer MAXSIZ, MAXLOC, MISS
      parameter(MAXSIZ=1000,MAXLOC=120,MISS=-9999)
      integer trget, trait, twrk, typ, wrk
C  Pedigree structure
      character*10 pedigree
      integer actset, num, nfound
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ), sex(MAXSIZ)
      integer numloc
      double precision locus(MAXSIZ,MAXLOC)
C Quantitative trait values
      integer nvals
      double precision value(MAXSIZ)
      integer counts(MAXSIZ)
C local variables
      integer i
      logical last
C functions
      double precision rank
C
      nvals=0
C
C Tabulate sorted values and frequencies
      last=.false.
      rewind(wrk)
    5 continue
        call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &             numloc, last)
        if (last) goto 20

        if (actset.gt.0) then
         do 10 i=1,num
         if (locus(i,trait).ne.MISS) then
           call qtab(locus(i,trait),nvals,value,counts)
         end if
   10    continue
        end if
      goto 5
   20 continue
C Replace with cumulative counts
      do 100 i=2, nvals
        counts(i)=counts(i)+counts(i-1)
  100 continue
C
C Give rank of each record
      last=.false.
      rewind(wrk)
   25 continue
        call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &             numloc, last)
        if (last) goto 40

        if (actset.gt.0) then
          do 30 i=1,num
          if (locus(i,trait).ne.MISS) then
            locus(i,trget)=rank(locus(i,trait),nvals,value,counts)
          end if
   30     continue
        end if
        call wrkout(twrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &              numloc)
      goto 25
   40 continue
      return
      end
C end-of-dorank
C
C Binary search for closest position of value in an ascending sorted array
C
      double precision function rank(val,num,key,cumcnt)
      integer num, cumcnt(*)
      double precision val, key(*)
      
      integer hi, lo, pos

      hi=num
      lo=1
   10 continue
        pos=(hi+lo)/2
        if (val.gt.key(pos)) then
          lo=pos+1
        elseif (val.lt.key(pos)) then
          hi=pos-1
        else
          goto 20
        end if
      if (hi.ge.lo) goto 10
   20 continue
      lo=0
      if (pos.gt.1) lo=cumcnt(pos-1)
      rank=0.5d0*float(lo+cumcnt(pos)+1)
      return
      end
C end-of-rank 
C
C simulate a single marker, either unconditionally, or
C consistent with ibd sharing at a given locus
C
      subroutine wrsim(wrk,twrk,typ,mark,gene,pedigree,actset,num,
     2              nfound,id,fa,mo,sex,locus, numloc,numal,name,
     3              cumfrq,untyped,set,sibd,key,plevel)
      integer IBDSIZ, KNOWN, MAXALL, MAXG, MAXIBD, MAXSIZ, MAXLOC, MISS
      parameter(MAXALL=60, MAXG=MAXALL*(MAXALL+1)/2, MAXSIZ=1000, 
     2          MAXLOC=120, MISS=-9999, KNOWN=0, 
     3          MAXIBD=1000, IBDSIZ=MAXIBD*(MAXIBD+1)/2)
      integer gene,mark,plevel,twrk,typ,wrk
C  Pedigree structure
      character*10 pedigree
      integer actset,num, nfound
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ)
      integer sex(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)
C allele frequencies structure
      integer numal, name(MAXALL)
C frequency of alleles at locus to be simulated
      double precision cumfrq(MAXALL)
C work arrays for simulation
      logical untyped(MAXSIZ)
      integer set(MAXSIZ,2),sibd(MAXSIZ,2),key(2*MAXSIZ)
C local variables
      integer g1,g2,gen2,i,mark2
      double precision a1, a2
      logical last
C functions
      integer getnam

      gen2=gene+1
      mark2=mark+1
      last=.false.
      rewind(wrk)
    5 continue
        call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &             numloc, last)
        if (last) goto 20

        if (actset.le.0) goto 5
 
        if (typ.eq.1) then
C Unconditional simulation 
          call simped(num,nfound,fa,mo,cumfrq,set)
          do 10 i=1,num    
            locus(i,mark)=float(set(i,1))
            locus(i,mark2)=float(set(i,2))
   10     continue
        else
C Conditional on ibd at gene
          do 11 i=1,num
            if (locus(i,gene).le.KNOWN) then
              untyped(i)=.true.
              if (locus(i,gene).eq.0.0d0 .or.locus(i,gene).eq.MISS) then
                g1=MISS
                g2=MISS
              else
                g1=getnam(-locus(i,gene),numal,name)
                g2=getnam(-locus(i,gen2),numal,name)
              end if
            else
              untyped(i)=.false.
              g1=getnam(locus(i,gene),numal,name)
              g2=getnam(locus(i,gen2),numal,name)
            end if
            call update(i,g1,g2,set)
   11     continue
          call simibd(2,pedigree,num,nfound,fa,mo,set,sibd)
          if (typ.eq.2) then
C simulate based on given allele frequencies, ibd and missingness
            do 12 i=1,2*nfound 
              call found(cumfrq,key(i))
   12       continue
            do 13 i=1,num    
              a1=float(key(sibd(i,1)))
              a2=float(key(sibd(i,2)))
              if (untyped(i)) then
                a1=-a1
                a2=-a2
              end if
              if (a1.gt.a2) then
                locus(i,mark)=a2
                locus(i,mark2)=a1
              else
                locus(i,mark)=a1
                locus(i,mark2)=a2
              end if
   13       continue
          else
C perfect marker
            do 14 i=1,num    
              a1=float(sibd(i,1))
              a2=float(sibd(i,2))
              if (a1.gt.a2) then
                locus(i,mark)=a2
                locus(i,mark2)=a1
              else
                locus(i,mark)=a1
                locus(i,mark2)=a2
              end if
   14       continue
          end if
        end if
        call wrkout(twrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &              numloc)
      goto 5
   20 continue
C
      return
      end
C end-of-wrsim  
C
C simulate a quantitative trait of given heritability, 
C either unconditionally, or
C consistent with complete linkage to a given locus
C
      subroutine wrsimq(wrk, twrk, typ, trait, loctyp, h2, gene, 
     2              pedigree, actset, num, nfound, id, fa, mo, sex,
     3              locus, numloc, numal, name, cumfrq, set, sibd, key,
     4              ibdcount, plevel)
      integer IBDSIZ, KNOWN, MAXALL, MAXG, MAXIBD, MAXSIZ, MAXLOC, MISS
      parameter(MAXALL=60, MAXG=MAXALL*(MAXALL+1)/2, MAXSIZ=1000, 
     2          MAXLOC=120, MISS=-9999, KNOWN=0, 
     3          MAXIBD=1000, IBDSIZ=MAXIBD*(MAXIBD+1)/2)
      integer gene,loctyp,plevel,trait,twrk,typ,wrk
      double precision h2
C  Pedigree structure
      character*10 pedigree
      integer actset,num, nfound
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ)
      integer sex(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)
C allele frequencies structure
      integer numal, name(MAXALL)
C frequency of alleles at locus to be simulated
      double precision cumfrq(MAXALL)
C work arrays for simulation
      integer set(MAXSIZ,2),sibd(MAXSIZ,2),key(2*MAXSIZ)
      double precision ibdcount(IBDSIZ)
C local variables
      integer cfa, cmo, g1, g2, gen2, i
      double precision aconst, econst, midpar, segsd
      logical last
C functions
      integer getnam
      real randn

      aconst=sqrt(h2+h2)
      econst=sqrt(1.0d0-h2)
      cumfrq(1)=0.5d0
      cumfrq(2)=1.0d0
      last=.false.
      rewind(wrk)
    5 continue
        call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &             numloc, last)
        if (last) goto 20

        if (actset.le.0) goto 5
 
        if (typ.eq.1) then
C Unconditional simulation of trait under control of additive polygenes
          call kinship(num,nfound,fa,mo,ibdcount)
          do 10 i=1, nfound
            locus(i,trait)=dble(randn())
   10     continue
          do 15 i=nfound+1, num
            cfa=fa(i)
            cmo=mo(i)
            midpar=0.5d0*(locus(cfa,trait)+locus(cmo,trait))
            cfa=cfa*(cfa+1)/2
            cmo=cmo*(cmo+1)/2
            segsd=sqrt(1.0d0-0.25d0*(ibdcount(cfa)+ibdcount(cmo)))
            locus(i,trait)=midpar+segsd*dble(randn())
   15     continue
          do 16 i=1, num
            locus(i,trait)=aconst*locus(i,trait)+econst*dble(randn())
            if (loctyp.eq.4) then
              if (locus(i,trait).gt.0.0d0) then
                locus(i,trait)=2.0d0
              else
                locus(i,trait)=1.0d0
              end if
            end if
   16     continue
        else
C Conditional on ibd at marker
          gen2=gene+1
          do 25 i=1,num
            if (locus(i,gene).le.KNOWN) then
              g1=getnam(-locus(i,gene),numal,name)
              g2=getnam(-locus(i,gen2),numal,name)
            else
              g1=getnam(locus(i,gene),numal,name)
              g2=getnam(locus(i,gen2),numal,name)
            end if
            call update(i,g1,g2,set)
   25     continue
          call simibd(2,pedigree,num,nfound,fa,mo,set,sibd)
          do 30 i=1,2*nfound 
            call found(cumfrq,key(i))
   30     continue
          do 35 i=1,num    
            locus(i,trait)=aconst*(key(sibd(i,1))+key(sibd(i,2))-3) +
     &                     econst*randn()
            if (loctyp.eq.4) then
              if (locus(i,trait).gt.0.0d0) then
                locus(i,trait)=2.0d0
              else
                locus(i,trait)=1.0d0
              end if
            end if
   35     continue
        end if
        call wrkout(twrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &              numloc)
      goto 5
   20 continue
C
      return
      end
C end-of-wrsimq
