C
C Approach of Schaid and Sommer (1993), amplified by Knapp et al (1995)
C
C MM x MM   MM x MN   MM x NN   MN x MN    MN x NN    NN x NN    
C   MM      MM   MN     MN      MM MN NN   MN   NN      NN
C   n1      n2   n3     n4      n5 n6 n7   n8   n9      n10
C
C a=4*n1 + 3*n2 + 3*n3 + 2*n4 + 2*n5 + 2*n6 + 2*n7 + n8 + n9
C b=n2 + n3 + 2*n4 + 2*n5 + 2*n6 + 2*n7 + 3*n8 + 3*n9 + 4*n10
C c=n1 + n2 + n5
C d=n3 + n4 + n6 + n8
C
C providing n-c-d!=0 and a-2c-d!=0 then
C
C p=(a-2*c-d)/2n
C r1= (1-p)*d/(2*p*(n-c-d))
C r2= (1-p)^2 c/(p^2*(n-c-d))
C
C
      subroutine nucseg(wrk,trait,locnam,gene,candal,
     2             gt,thresh,pedigree,num,nfound,id,fa,mo,sex,
     3             locus, numloc, key, plevel)
      integer MAXALL, MAXG, MAXSIZ, MAXLOC, MISS, KNOWN
      parameter(MAXALL=60, MAXG=MAXALL*(MAXALL+1)/2, 
     &          MAXSIZ=1000, MAXLOC=120, MISS=-9999, KNOWN=0)
      integer gene,plevel,trait,wrk
      real candal, thresh
      logical gt
      character*10 locnam
C pedigree structure
      character*10 pedigree
      integer sex(MAXSIZ)
      integer num, nfound
      character*8 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ), set(MAXSIZ,2)
      real locus(MAXSIZ,MAXLOC)
C work array
      integer key(MAXSIZ)
      integer a, b, c, d, gen2, i, naff, pos
      logical last
      double precision den, lik0, lik1, p, q, r, r1, r2
C
C functions 
      real isaff
      double precision chip
C
      gen2=gene+1
      naff=0
      do 1 i=1,10
        key(i)=0
    1 continue  
      last=.false.
      rewind(wrk)
C
   10 continue
       call wrkin(wrk,pedigree,num,nfound,id,fa,mo,sex,locus,numloc,
     &            last)
       if (last) goto 20
         do 12 i=nfound+1,num
         if (isaff(locus(i,trait),thresh,gt).eq.2.0 .and.
     2     locus(i,gene).gt.KNOWN .and. locus(fa(i),gene).gt.KNOWN .and.
     3     locus(mo(i),gene).gt.KNOWN) 
     4   then
           naff=naff+1
           nfa=0
           nmo=0
           nch=0
           if (locus(i,gene).eq.candal) nch=nch+1
           if (locus(i,gen2).eq.candal) nch=nch+1
           if (locus(fa(i),gene).eq.candal) nfa=nfa+1
           if (locus(fa(i),gen2).eq.candal) nfa=nfa+1
           if (locus(mo(i),gene).eq.candal) nmo=nmo+1
           if (locus(mo(i),gen2).eq.candal) nmo=nmo+1
           if (nmo.eq.1 .and. nfa.eq.1) then
             pos=7-nch
           else if ((nfa+nmo).gt.1) then
             pos=7-nfa-nmo-nch
           else
             pos=10-nfa-nmo-nch
           end if
           key(pos)=key(pos)+1
           if (plevel.gt.1) then
             write(*,'(a10,1x,a8,3(1x,i3,1x,i3))') pedigree,id(i),
     2         int(locus(i,gene)), int(locus(i,gen2)), 
     3         int(locus(fa(i),gene)), int(locus(fa(i),gen2)), 
     4         int(locus(mo(i),gene)), int(locus(mo(i),gen2)) 
           end if
         end if
   12    continue
       goto 10
   20  continue
      a=4*key(1) + 3*key(2) + 3*key(3) + 2*key(4) + 
     &  2*key(5) + 2*key(6) + 2*key(7) + key(8) + key(9)
      b=key(2) + key(3) + 2*key(4) + 2*key(5) + 
     &  2*key(6) + 2*key(7) + 3*key(8) + 3*key(9) + 4*key(10)
      c=key(1) + key(2) + key(5)
      d=key(3) + key(4) + key(6) + key(8)

      p=dfloat(a-2*c-d)/dfloat(2*naff)
      q=1.0d0-p
      den=dfloat(naff-c-d)
      r1=1.0d0
      r2=1.0d0
      r=1.0d0
      if (p.gt.0.0d0 .and. den.ne.0.0d0) then
        r1=0.5d0*q*dfloat(d)/p/den
        r2=q*q*dfloat(c)/p/p/den
        r=p*p*r2+2*p*q*r1+q*q
      end if
      lik0=a*ln(p)+b*ln(q)
      lik1=den*ln(den)+dfloat(a-2*c-d)*ln(dfloat(a-2*c-d))+
     2     dfloat(2*naff-a+2*c+d)*ln(dfloat(2*naff-a+2*c+d))+
     3     dfloat(2*naff)*ln(dfloat(2*naff))+dfloat(c)*ln(dfloat(c))+
     4     dfloat(d)*ln(0.5d0*dfloat(d))-dfloat(naff)*ln(dfloat(naff))
      lik0=2.0d0*(lik1-lik0)
      se1=sqrt(2.0d0*p*q/r*(1.0d0/r1-2.0d0*p*q/r))
      se2=sqrt(p*p/r*(1.0d0/r2-p*p/r))
      write(*,*) 
     2  'LR Chi-square (2 df) = ',lik0,' (P=',chip(lik0,2),')' 
      write(*,*) 
     3  'Genotypic RR1 (f1)   = ',r1,' (ASE=',se1,')' 
      write(*,*) 
     4  'Genotypic RR2 (f2)   = ',r2,' (ASE=',se2,')' 
      return
      end
C end-of-nucseg
