C
C Count alleles in entire sample -- codominant system
C Either unweighted or weighted by number of founders in pedigree
C
C If imputation has been done and fndr=2, then return the 
C count of alleles in the founders, both observed and imputed
C
      subroutine freq(wrk,gene,loctyp,pedigree,actset,
     2                num,nfound,id,fa,mo,sex,locus,numloc,
     3                numal,name,fndr,alfrq,totall,typed)
      integer KNOWN,MAXSIZ,MAXLOC,MAXALL,MISS
      parameter (KNOWN=0,MAXSIZ=1000,MAXLOC=120,MAXALL=60,MISS=-9999)
      integer fndr, gene, numloc, totall, typed, wrk
C Pedigree structure
      character*10 pedigree
      integer actset,loctyp,num, nfound
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ), sex(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)
      logical last
C
C allele frequencies structure
      integer tfound, numal, name(MAXALL)
      double precision alfrq(MAXALL)
C
      integer act, den, gen2, i, nfall
      double precision wei

      act=fndr
      gen2=gene+1

C global restart if unimputed genotypes present and fndr=2
C
  999 continue

      numal=0
      nfall=0
      tfound=0
      totall=0
      typed=0

      last=.false.
      rewind(wrk)
   10 continue
       call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &            numloc, last)
       if (last) goto 20

       if (actset.le.0) goto 10
C
C Count observed alleles and skip if none
       den=0
       do 12 i=1,num
         if (locus(i,gene).gt.KNOWN) then
           typed=typed+1
           den=den+1
         end if
         if (loctyp.eq.2 .and. sex(i).eq.1) locus(i,gen2)=KNOWN
         if (locus(i,gen2).gt.KNOWN) den=den+1
   12  continue
       if (den.eq.0) goto 10
C
C If fndr=2 only count alleles in founders
C If fndr=1 weight count in this pedigree by number of founders
C
       tfound=tfound+nfound
       totall=totall+den
       wei=1.0d0
       if (act.eq.1) wei=dfloat(nfound)/dfloat(den)

       if (act.lt.2) then
         do 15 i=1,num
           if (locus(i,gene).gt.KNOWN) then
             call tab(int(locus(i,gene)),numal,name,alfrq,wei)
           end if
           if (locus(i,gen2).gt.KNOWN) then
             call tab(int(locus(i,gen2)),numal,name,alfrq,wei)
           end if
   15    continue
       else
C count imputed founder alleles (bail out if unimputed!)
         do 17 i=1,nfound
           if (locus(i,gene).ne.MISS) then
             if (locus(i,gene).ne.KNOWN) then
               nfall=nfall+1
               call tab(int(abs(locus(i,gene))),numal,name,alfrq,wei)
             end if
           else
             act=0
             goto 999
           end if
           if (locus(i,gen2).ne.MISS) then
             if (locus(i,gen2).ne.KNOWN) then
               nfall=nfall+1
               call tab(int(abs(locus(i,gen2))),numal,name,alfrq,wei)
             end if
           else
             act=0
             goto 999
           end if
   17    continue
       end if
      goto 10
   20 continue

      if (act.eq.0) then
        wei=1.0d0/dfloat(max(1,totall))
      else if (act.eq.1) then
        wei=1.0d0/dfloat(tfound)
      else if (act.eq.2) then
        wei=1.0d0/dfloat(nfall)
      end if
      do 30 i=1,numal
        alfrq(i)=wei*alfrq(i)
   30 continue
      return
      end
C end-of-freq
C
C update table of counts of alleles -- binary search and insertion sort
C
      subroutine tab(curr,numal,name,alfrq,wei)
      integer MAXALL
      parameter(MAXALL=60)
      integer curr, numal, name(MAXALL)
      double precision wei, alfrq(MAXALL)
      integer hi,i,lo,pos

      hi=numal
      lo=1

    1 continue 
      if (hi.lt.lo) goto 5
        pos=(hi+lo)/2
        if (curr.gt.name(pos)) then
          lo=pos+1
        elseif (curr.lt.name(pos)) then
          hi=pos-1
        else
          alfrq(pos)=alfrq(pos)+wei
          return
        end if
      goto 1
    5 continue
C else
      if (numal.lt.MAXALL) then
        do 2 i=numal,lo,-1
          name(i+1)=name(i)
          alfrq(i+1)=alfrq(i)
    2   continue
        numal=numal+1
        name(lo)=curr
        alfrq(lo)=wei
      else
        write(*,'(/a,i2,a/7x,a/)') 
     2    'ERROR: Number of alleles for locus exceeds ',MAXALL,
     3    ', the maximum allowed.','Stopping prematurely.'
        stop
      end if
      return
      end
C end-of-tab
C
C Write out frequencies
C
      subroutine wrfreq(strm,locnam,numal,name,alfrq,mappos,
     &                  totall,typed,nobs,fstyle)
      integer MAXALL
      parameter (MAXALL=60)
      character*20 locnam
      integer fstyle, nobs, strm, totall, typed
C allele frequencies structure
      integer numal, name(MAXALL)
      double precision alfrq(MAXALL)
C map position
      real mappos
C local variables
      integer i, j, nlines
      character*4 allel, allel2
      character*8 mentyp
      double precision corr, het
C functions
      integer eow
      double precision thetaf, uninf

      corr=1.0d0
      het=0.0d0
      if (fstyle.eq.1 .or. fstyle.eq.11) then
        if (fstyle.eq.1) then
          write(*,'(/a/3a/a)')
     2     '------------------------------------------------',
     3     'Allele frequencies for locus "',locnam(1:eow(locnam)),'"',
     4     '------------------------------------------------' 
        else
          write(*,'(/a/3a/a)')
     2     '------------------------------------------------',
     3     'MCEM allele frequencies for locus "',
     4     locnam(1:eow(locnam)),'"',
     5     '------------------------------------------------' 
        end if
        write(*,'(a)') '   Allele  Frequency   Count  Histogram'
        if (numal.eq.0) then
          write(*,'(/6x,a)') 'No nonmissing genotypes'
        else
          do 25 i=1,numal
            call wrall(name(i), allel)
            write(*,'(5x,a3,5x,f6.4,4x,i5,2x,20a1:)') 
     2        allel,alfrq(i),nint(float(totall)*alfrq(i)),
     3        ('*',j=1,max(1,nint(20.0d0*alfrq(i))))
            het=het+alfrq(i)*alfrq(i)
   25     continue
          if (totall.gt.1) corr=dfloat(totall)/dfloat(totall-1)
          het=1.0d0-het
          write(*,'(/a,i4,2(/a,3x,f6.4))')
     2     'Number of alleles    = ',numal,
     3     'Heterozygosity (Hu)  = ',corr*het,
     4     'Poly. Inf. Content   = ',het-uninf(numal, alfrq) 
          if (fstyle.eq.1) then
            write(*,'(a,f13.8/a,i6,1x,a,f5.1,a)')
     5     '4 Neff mu (SSMM)     = ',thetaf(het, typed), 
     6     'Number persons typed = ',typed,
     7     '(',float(100*typed)/float(nobs),'%)'
          else
            write(*,'(a,f13.8/a,i6,1x,a,f5.1,a)')
     5     '4 Neff mu (SSMM)     = ',thetaf(het, totall/2), 
     6     'Number of founders   = ',totall/2,
     7     '(',float(50*typed)/float(totall),'% typed)'
          end if
        end if
C abbreviated output
      elseif (fstyle.eq.2) then
        do 55 i=1,numal
          het=het+alfrq(i)*alfrq(i)
   55   continue
        het=1.0d0-het
        if (totall.gt.1) corr=dfloat(totall)/dfloat(totall-1)
C SNPs
        if (numal.eq.2) then
          do 30 i=1,numal
          if (alfrq(i).le.0.5) then
            call wrall(name(i), allel)
            call wrall(name(3-i), allel2)
            j=eow(allel2)+1
            allel2(j:j)=')'
            write(*,'(a15,i4,2x,3a,2x,2(1x,f6.4),1x,i5)') 
     &       locnam,2,allel,' (',allel2,alfrq(i),corr*het,typed
          end if
   30     continue
C other
        elseif (typed.eq.0) then
          write(*,'(a15,3x,a1,2x,a1,13x,a1,6x,a1,9x,a1)') 
     &      locnam,'-','-','-','-','0'
        elseif (numal.eq.1) then
          call wrall(name(1), allel)
          write(*,'(a15,i4,2x,a4,8x,2(1x,a6),1x,i5)') 
     &      locnam,1,allel,'1.0000',' -    ', typed
        else
          call wrall(name(1), allel)
          allel2=' '
          if (numal.gt.1) call wrall(name(numal), allel2)
          write(*,'(a15,i4,2x,a4,a3,a4,2x,a6,1x,f6.4,1x,i5)')
     2      locnam, numal, allel, '.. ',allel2, ' -    ',corr*het,typed
        end if
C scratch file
      elseif (fstyle.eq.3) then
        write(strm) numal,(name(i),i=1,numal),(alfrq(i),i=1,numal)
C GAS locus file
      elseif (fstyle.eq.4) then
        call precis(numal,alfrq,4)
        write(strm,'(1x,i3,100(1x,f6.4):)') numal,(alfrq(i),i=1,numal)
        write(strm,'(1x,a,100(1x,i3):)') 'name ',(name(i),i=1,numal)
C SAGE locus file
      elseif (fstyle.eq.5) then
        call precis(numal,alfrq,4)
        write(strm,'(a20)') locnam
        do 35 i=1,numal
   35     write(strm,'(1x,i4.4,a,f6.4)') name(i),' = ',alfrq(i)
        write(strm,'(1x,a1)') ';'
        do 40 i=1,numal
        do 40 j=i,numal
   40     write(strm,'(1x,4(i4.4,a))') 
     2       name(i),'/',name(j),' = {',name(i),'/',name(j),'}'
        write(strm,'(1x,a1)') ';'
C new style MENDEL locus file -- used by simwalk and relpair
      elseif (fstyle.eq.7 .or. fstyle.eq.10) then
        mentyp='AUTOSOME'
        if (fstyle.eq.10) mentyp='X-LINKED'
        call precis(numal,alfrq,6)
        write(strm,'(2a8,2i2,i4,1x,f8.3)') 
     &    locnam,mentyp,numal, 0, 1, max(0.0,0.01*mappos)
        do 45 i=1,numal
          call wrall(name(i), allel)
          write(strm,'(5x,a3,f8.6)') allel, alfrq(i)
   45   continue
C Linkage locus file
      elseif (fstyle.eq.8) then
        if (numal.eq.0) then
          write(strm,'(a,1x,2a/a)') 
     &      '3     2  #',locnam, ' #','    0.5    0.5'
        else
          call precis(numal,alfrq,4)
          write(strm,'(i1,1x,i5,3a)') 3,numal,' # ',locnam,' #'
          write(strm,'(100(1x,f6.4):)') (alfrq(i),i=1,numal)
        end if
C PAP popln.dat file
      elseif (fstyle.eq.9) then
        nlines=(numal+4)/5
        write(strm,'(i4,2a)') nlines,' F F # ',locnam
        write(strm,'(i3,5(d15.7))') numal,(alfrq(i),i=1,numal)
C new style RELPAIR locus file 
      elseif (fstyle.eq.12 .or. fstyle.eq.13) then
        mentyp='AUTOSOME'
        if (fstyle.eq.13) mentyp='X-LINKED'
        call precis(numal,alfrq,6)
        write(strm,'(a,1x,a,1x,i3,i4,1x,f8.3)') 
     2    locnam(1:max(8,eow(locnam))), mentyp, numal, 1, 
     3    max(0.0,0.01*mappos)
        do 65 i=1,numal
          call wrall(name(i), allel)
          write(strm,'(a8,1x,f8.6)') allel, alfrq(i)
   65   continue
      end if
      return
      end
C end-of-wrfreq
C
C remove rounding errors in allele frequencies printed out to precision ndec
C from f3.1 to f9.7
C
      subroutine precis(numal,alfrq,ndec)
      integer MAXALL
      parameter (MAXALL=60)
      integer ndec
C allele frequencies structure
      integer numal
      double precision alfrq(MAXALL)
C topall is most common allele, and the one where we add our correction
      integer i, topall
      character*1 ch
      character*6 fdec
      character*10 buff
      double precision rounded, topfrq, tot

C set print format
      fdec='(f0.0)'
      write(ch,'(i1)') ndec+2
      fdec(3:3)=ch
      write(ch,'(i1)') ndec
      fdec(5:5)=ch
C rewrite to given precision, and calculate accumulated error
      topall=1
      topfrq=0.0d0
      tot=0.0d0
      do 10 i=1,numal
        write(buff,fdec) alfrq(i)
        read(buff,fdec) rounded
        alfrq(i)=rounded
        if (rounded.gt.topfrq) then
          topfrq=rounded
          topall=i
        end if
        tot=tot+rounded
   10 continue
      alfrq(topall)=alfrq(topall)+1.0d0-tot
      return
      end
C end-of-precis
C
C Identify the most common allele
      integer function topall(numal,alfrq)
      integer MAXALL
      parameter (MAXALL=60)
C allele frequencies structure
      integer numal
      double precision alfrq(MAXALL)
      integer i
      double precision topfrq
      topfrq=0.0d0
      topall=0
      do 10 i=1,numal
      if (alfrq(i).gt.topfrq) then
        topfrq=alfrq(i)
        topall=i
      end if
   10 continue
      return
      end
C end-of-topall
C
C Identify an other allele
      integer function othall(thisal,numal,name)
      integer MAXALL, MISS
      parameter (MAXALL=60, MISS=-9999)
      integer thisal
C allele frequencies structure
      integer numal, name(MAXALL)
      integer i
      do 10 i=1,numal
      if (name(i).ne.thisal) then
        othall=name(i) 
        return
      end if
   10 continue
      othall=MISS
      return
      end
C end-of-othall
C
C Frequency of uninformative matings for marker locus
      double precision function uninf(numal, alfrq)
      integer MAXALL
      parameter (MAXALL=60)
C allele frequencies structure
      integer numal  
      double precision alfrq(MAXALL)
      integer i, j
      uninf=0.0d0
      do 127 i=1,numal-1
      do 127 j=i+1,numal
        uninf=uninf+2.0d0*alfrq(i)*alfrq(j)*alfrq(i)*alfrq(j)
  127 continue
      return
      end
C end-of-uninf
C
C Monte-Carlo test for HWE
C
      subroutine dohwe(wrk,wrk2,locnam,gene,xlinkd,iter,mincnt,hwefnd,
     2             pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     3             numloc,  numal, name, cumfrq, set, untyped, 
     4             ngcount,gcount,plevel)
      integer MAXALL, MAXG, MAXSIZ, MAXLOC, KNOWN
      parameter(MAXALL=60, MAXG=MAXALL*(MAXALL+1)/2, 
     &          MAXSIZ=1000, MAXLOC=120, KNOWN=0)
      integer gene,iter,mincnt,plevel,wrk,wrk2
      logical hwefnd, xlinkd
      character*10 locnam
C pedigree structure
      character*10 pedigree
      integer sex(MAXSIZ)
      integer actset,num, nfound
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ), set(MAXSIZ,2)
      double precision locus(MAXSIZ,MAXLOC)
      logical untyped(MAXSIZ)
C allele frequencies structure
      integer numal, name(MAXALL)
      double precision cumfrq(MAXALL)
C Genotype counts: allele1,allele2, genotype count, 
C                  ith allele count
      integer ngcount,gcount(MAXG,4)
C
      integer df, g1, g2, gen2, i, it, j, k, n, tailp,tot,totall,totmal
      double precision asyp, chisq, expf, invden, ochisq, mchisq, 
     &  pval, vchisq
      character*3 histo
      character*7 gtp
      logical last, xmale
C functions 
      integer getnam
      real random
      double precision chip, ftdev, hwechi
C
      gen2=gene+1
      ngcount=0
      do 1 j=1,numal
      do 1 k=1, j
        ngcount=ngcount+1
        gcount(ngcount,1)=0
        gcount(ngcount,2)=0
        gcount(ngcount,3)=0
    1 continue
      it=0
      tot=0
      totmal=0
      last=.false.
      rewind(wrk)
C
   10 continue
       call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &            numloc, last)
       if (last) goto 20

       if (actset.le.0) goto 10
C
         n=num
         if (hwefnd) n=nfound
         do 12 i=1,n
         if (locus(i,gene).le.KNOWN) then
           untyped(i)=.true.
         else
           xmale=(xlinkd .and. sex(i).eq.1)
           tot=tot+1
           if (xmale) totmal=totmal+1
           untyped(i)=.false.
           g1=getnam(locus(i,gene),numal,name)
           g2=getnam(locus(i,gen2),numal,name)
           call tabgen(g1,g2,xmale,numal,gcount)
         end if
   12    continue
         if (.not.hwefnd) then
           write(wrk2) num, nfound, 
     &                 (fa(i),mo(i),sex(i),untyped(i),i=1,num)
        end if
      goto 10
   20 continue

      ochisq=hwechi(numal,gcount,tot,totmal)
      df=numal
      if (xlinkd) df=1
      df=ngcount-df

      if (plevel.gt.0) then
        write(*,'(/3a/a/a)') 
     2   '  -------- Observed Genotypes at "',locnam,'" --------',
     3   '       Genotype          Observed    Expected  Deviate',
     4   '  ----------------------------------------------------'
        totall=2*tot-totmal
        invden=dfloat(tot-totmal)/dfloat(totall*totall)
        i=0
        do 25 j=1,numal
        do 25 k=1, j
          i=i+1
          call wrgtp(name(k),name(j),gtp,1)
          expf=dfloat(gcount(j,2)*gcount(k,2)) * invden
          if (j.ne.k) expf=expf+expf
          write(*,'(8x,a7,3x,i8,a,f5.3,a,f10.1,1x,f8.1)') 
     2      gtp, gcount(i,1), 
     3      ' (',dfloat(gcount(i,1))/dfloat(tot-totmal),') ',
     4      expf, ftdev(dfloat(gcount(i,1)),expf)
   25   continue
        if (totmal.gt.0) then
          invden=dfloat(totmal)/dfloat(totall)
          write(*,'(a)') 
     &      '     Male Haplotype      Observed    Expected  Deviate' 
          do 26 j=1,numal
            call wrgtp(name(j),0,gtp,1)
            expf=dfloat(gcount(j,2)) * invden
            write(*,'(8x,a7,3x,i8,a,f5.3,a,f10.1,1x,f8.1)') 
     2        gtp, gcount(j,3), 
     3        ' (',dfloat(gcount(j,3))/dfloat(totmal),') ',
     4        expf, ftdev(dfloat(gcount(j,3)),expf)
   26     continue
        end if
        write(*,'(a/10x,a,3x,i8,a)') 
     2   '  ----------------------------------------------------',
     3   'Total', tot,' (1.000)'
        if (xlinkd) then
          write(*,'(/a,i4,a,i4,a)')
     &    '       Number of genotypes =',tot,' (',totmal,' male)'
         else
          write(*,'(/a,i4)') '       Number of genotypes =',tot
         end if
        write(*,'(a,f6.1/a,i4/a,3x,f6.4)')
     3  '  Hardy-Weinberg LR chi-sq =',ochisq,
     4  'Nominal degrees of freedom =',df,
     5  '           Nominal P-value =',chip(ochisq,df)
        if (.not.xlinkd .and. numal.eq.2) then 
          call hwe2(gcount(1,1), gcount(2,1), gcount(3,1), expf, pval)
          write(*,'(a,3x,f6.4)')
     &  '             Exact P-value =', pval
        end if
      end if  
C
C MC sequential P-value for HWE
C
      if (.not.hwefnd .and. iter.gt.0 .and. ngcount.gt.1) then
        mchisq=0.0d0
        tailp=0
        vchisq=0.0d0
   49   continue
        if (it.eq.iter .or. tailp.eq.mincnt) goto 50
          it=it+1
          ngcount=0
          do 52 j=1,numal
          do 52 k=1, j
            ngcount=ngcount+1
            gcount(ngcount,1)=0
            gcount(ngcount,2)=0
            gcount(ngcount,3)=0
   52     continue
          rewind(wrk2)
   55     continue
            read(wrk2,end=70) num,nfound, 
     &                        (fa(i),mo(i),sex(i),untyped(i),i=1,num)
            if (xlinkd) then
              call xsimped(num,nfound,fa,mo,sex,cumfrq,set)
            else
              call simped(num,nfound,fa,mo,cumfrq,set)
            end if
            do 65 i=1,num
            if (.not.untyped(i)) then
              xmale=(xlinkd .and. sex(i).eq.1)
              call tabgen(set(i,1),set(i,2),xmale,numal,gcount)
            endif
   65       continue
          goto 55
   70     continue
          chisq=hwechi(numal,gcount,tot,totmal)
          call moment(it,chisq,mchisq,vchisq)
          if (chisq.gt.ochisq .or. (chisq.eq.ochisq .and.
     2        random().gt.0.5))  then
            tailp=tailp+1
          end if
          if (plevel.gt.1) then
            write(*,'(a,i4,a,f6.1)') 
     &        'Pseudosample ',it,': Chisq=',chisq
              if (plevel.gt.2) then
                write(*,*) 'Genos: ',(gcount(j,1), j=1, ngcount)
                write(*,*) 'Allel: ',(gcount(j,2), j=1, numal)
                if (xlinkd) then
                  write(*,*) 'Males: ',(gcount(j,3), j=1, numal)
                end if
              end if
          end if
          goto 49
   50   continue
        if (tailp.lt.mincnt) then
          tailp=tailp+1
          it=it+1
        end if
        vchisq=vchisq/dfloat(max(1,it-1))
        pval=dfloat(tailp)/dfloat(it)
      else
        tailp=0
        pval=1.0d0
      end if
      if (plevel.gt.0) then
        write(*,'(a,i4,a,i5,a,f6.4,a/a,f6.1,a,f6.1,a)')
     2    '      Equalled or exceeded by =',tailp,'/',it,
     3    ' simulated values (',pval,')',
     4    ' Mean (Var) simulated chi-sqs =',mchisq,' (',vchisq,')'
      else
        asyp=chip(ochisq,df)
        call phist(asyp,pval,histo)
        write(*,'(a10,2(1x,i6),1x,f10.1,2(1x,f6.4),1x,i6,2(1x,a))') 
     2    locnam, tot, ngcount, ochisq, chip(ochisq,df), pval, it, 
     3     'HWE',histo
      end if
      return
      end
C end-of-dohwe
C
C Increment counts of genotypes and alleles for HWE test
C Storage of allele counts in gcount(,2) indexed from 1..nall
C Genotypes indexed from 1..ngtp by gcount(,1).
C Males contribute to allele counts but not genotype counts
C
      subroutine tabgen(a1,a2,xmale,numal,gcount)
      integer MAXALL,MAXG
      parameter(MAXALL=60,MAXG=MAXALL*(MAXALL+1)/2)
      integer a1,a2,numal,gcount(MAXG,4)
      logical xmale
C allele counts
      if (xmale) then
        gcount(a1,2)=gcount(a1,2)+1
        gcount(a1,3)=gcount(a1,3)+1
      else
        gcount(a1,2)=gcount(a1,2)+1
        gcount(a2,2)=gcount(a2,2)+1
C genotype count
        idx=a2*(a2-1)/2+a1
        gcount(idx,1)=gcount(idx,1)+1
      end if
      return
      end
C end-of-tabgen
C
C Calculate HWE Chi-square for table entered on command line
C
      subroutine hwep(numal,gcount)
      integer MAXALL, MAXG
      parameter(MAXALL=60, MAXG=MAXALL*(MAXALL+1)/2)
C genotype counts
      integer gcount(MAXG,4), numal
      integer df,i,j,ngcount, tot, totmal
      double precision chisq, pa, pvalue
C functions
      double precision chip, hwechi
      ngcount=0
      tot=0
      totmal=0
      ngcount=numal*(numal+1)/2
      df=ngcount-numal
      do 1 i=1, ngcount
        gcount(i,2)=0
        gcount(i,3)=0
    1 continue
      write(*,'(i3,a,$)') ngcount,' genotype counts> '
      read(*,*,err=100) (gcount(i,1), i=1, ngcount)
      ngcount=0
      do 2 i=1, numal  
      do 2 j=1, i
        ngcount=ngcount+1
        gcount(i,2)=gcount(i,2)+gcount(ngcount,1)
        gcount(j,2)=gcount(j,2)+gcount(ngcount,1)
        tot=tot+gcount(ngcount,1)
    2 continue
      chisq=hwechi(numal,gcount,tot,totmal)
      ngcount=0
      do 5 i=1, numal  
        write(*,'(/f6.4,$)') 0.5d0*dfloat(gcount(i,2))/dfloat(tot)
        do 6 j=1, i
          ngcount=ngcount+1
          write(*,'(i5,$)') gcount(ngcount,1)
    6   continue
    5 continue
      write(*,'(//a,f10.1,a,i3,a,f6.4,a)') 
     &  'HWE X2 =',chisq,' (df=',ngcount,'; P=',chip(chisq,df),')'
      if (numal.eq.2) then
        call hwe2(gcount(1,1), gcount(2,1), gcount(3,1), pa, pvalue)
        write(*, '(a,f10.4)') 'Exact P=', pvalue
      end if 
      return
C input error
  100 write(*,'(a,i3,a)') 
     &    'ERROR: Expected ',ngcount,' genotype counts!'
      return
      end
C end-of-hwep
C
C Calculate Gibbs chi-square for HWE
C
      double precision function hwechi(numal,gcount,tot, totmal)
      integer MAXALL, MAXG
      double precision EPS
      parameter(EPS=1.0d-5, MAXALL=60, MAXG=MAXALL*(MAXALL+1)/2)
C allele frequencies and genotype counts
      integer gcount(MAXG,4), numal, tot, totmal
      integer i,j,k, totall
      double precision c,e,o 

      if (totmal.eq.0) then
        c=0.25d0/dfloat(tot)
      else
        totall=2*tot-totmal
        c=dfloat(tot-totmal)/dfloat(totall*totall)
      end if
      hwechi=0.0d0
      i=0
      do 30 j=1,numal
      do 30 k=1,j
        i=i+1
        o=dfloat(gcount(i,1))
        e=c*dfloat(gcount(j,2)*gcount(k,2))
        if (j.ne.k) e=e+e
        if (e.gt.EPS .and. o.gt.EPS) then
          hwechi=hwechi+o*log(o/e)
        end if
   30 continue
      if (totmal.ne.0) then
        c=dfloat(totmal)/dfloat(totall)
        do 40 j=1,numal
          o=dfloat(gcount(j,3))
          e=c*dfloat(gcount(j,2))
          if (e.gt.EPS .and. o.gt.EPS) then
            hwechi=hwechi+o*log(o/e)
          end if
   40   continue
      end if
      hwechi=hwechi+hwechi
      return
      end
C end-of-hwechi
C
C Calculate HWE test for diallelic autosomal marker
      subroutine hwe2(n11, n12, n22, pa, pvalue)
      integer n11, n12, n22
      integer i, fin, n, n1, n2, sta
      double precision pa, pvalue
      double precision d, obsd
C functions
      double precision dhwe2
      n=n11+n12+n22
      n1=2*n11+n12
      n2=2*n22+n12
      pa=dfloat(n1)/dfloat(n+n)
      sta=mod(n1, 2)
      fin=min(n1, n2)
      obsd=dhwe2(n11, n12, n22)
      pvalue=0.0d0
      do 10 i=sta, fin, 2
        d=dhwe2((n1-i)/2, i, (n2-i)/2)
        if (d.le.obsd) pvalue=pvalue+d
   10 continue
      return
      end
C end-of-hwe2
C
C hypergeometric for diallelic genotypes under HWE
      double precision function dhwe2(n11, n12, n22)
      integer n11, n12, n22
      integer n, n1, n2
      double precision lfact

      n=n11+n12+n22
      n1=2*n11+n12
      n2=2*n22+n12
      dhwe2=exp(log(2.0d0)*dfloat(n12) + lfact(n) - lfact(n11) 
     2          - lfact(n12) - lfact(n22) - lfact(2*n) + lfact(n1) 
     3          + lfact(n2))
      return
      end
C end-of-dhwe2
C
C marker homozygosity in all subjects or just probands -- codominant system
C
      subroutine dohomoz(wrk,wrk2,trait,locnam,gene,xlinkd,iter,
     2             mincnt,gt,thresh,pedigree,actset,num,nfound,
     3             id,fa,mo,sex,locus,numloc,
     4             numal,alfrq,cumfrq,untyped,set,plevel)
      integer KNOWN,MAXSIZ,MAXLOC,MAXALL,MISS
      parameter (KNOWN=0,MAXSIZ=1000,MAXLOC=120,MAXALL=60,MISS=-9999)
      integer gene,gt,iter,mincnt,numloc,plevel,trait,wrk,wrk2
      double precision thresh
      logical xlinkd
      character*10 locnam
C Pedigree structure
      character*10 pedigree
      integer actset,num, nfound
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ), set(MAXSIZ,2)
      integer sex(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)
      logical last, untyped(MAXSIZ)
C allele frequencies structure
      integer numal
      double precision alfrq(MAXALL), cumfrq(MAXALL)
C 
C homozygosity analysis -- limited to cases
      integer ehomoz, homoz, nca
      integer aff(MAXSIZ),gen2,i,it,tailp
      character*3 histo
      double precision den, ef, expp, fcoeff, obs, pval
C functions
      real random
      double precision binz, isaff

      expp=0.0d0
      gen2=gene+1
      homoz=0
      it=0
      nca=0
      do 5 i=1,numal
        expp=expp+alfrq(i)*alfrq(i)
    5 continue
      last=.false.
      rewind(wrk)
   10 continue
       call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &            numloc, last)
       if (last) goto 20

       if (actset.le.0) goto 10
C

        if (trait.eq.MISS) then
          do 13 i=1,num
            aff(i)=2
            if (xlinkd .and. sex(i).ne.2) aff(i)=MISS
   13     continue
        else
          do 14 i=1,num
            aff(i)=int(isaff(locus(i,trait),thresh,gt))
            if (xlinkd .and. sex(i).ne.2) aff(i)=MISS
   14     continue
        end if
        do 15 i=1,num
          untyped(i)=.false.
          set(i,1)=int(locus(i,gene))
          set(i,2)=int(locus(i,gen2))
          if (set(i,1).lt.KNOWN) then
            untyped(i)=.true.
          elseif (aff(i).eq.2) then
            nca=nca+1
            if (set(i,1).eq.set(i,2)) homoz=homoz+1 
          endif
   15   continue
        write(wrk2) num,nfound,
     &      (aff(i),fa(i),mo(i),untyped(i),i=1,num)
      goto 10
   20 continue
        
      if (nca.gt.0) then
        den=1.0d0/dfloat(nca)
        obs=den*dfloat(homoz)
        fcoeff=(obs-expp)/(1.0d0-expp)
      else
        obs=0.0d0
        fcoeff=0.0d0
      end if
C
C if iter=0 or nca=0, Monte-Carlo procedure superfluous
C
      if (iter.gt.0 .and. nca.gt.0) then
C
C Sequential Monte-Carlo P-value after Besag & Clifford Biometrika 1991
C P= tailp/it if tailp=mincnt or (tailp+1)/(it+1) if tailp<mincnt && it=iter
C
        tailp=0
   49   continue
        if (it.eq.iter .or. tailp.eq.mincnt) goto 50
          it=it+1
          ehomoz=0
          rewind(wrk2)
   55     continue
            read(wrk2,end=70) num,nfound,
     &        (aff(i),fa(i),mo(i),untyped(i),i=1,num)
            if (xlinkd) then
              call xsimped(num,nfound,fa,mo,sex,cumfrq,set)
            else
              call simped(num,nfound,fa,mo,cumfrq,set)
            end if
            do 65 i=1,num
            if (.not.untyped(i) .and. aff(i).eq.2 .and.
     &          set(i,1).eq.set(i,2)) ehomoz=ehomoz+1 
   65       continue
          goto 55
   70     continue
          
          ef=abs((den*dfloat(ehomoz)-expp)/(1.0d0-expp))

          if (ef.gt.abs(fcoeff) .or. (ehomoz.eq.homoz .and.
     2        random().gt.0.5))  then
            tailp=tailp+1
          end if
          if (plevel.gt.1) then
            write(*,'(/a,i4,a,i5)') 
     &        'Pseudosample ',it,': No. homoz=',ehomoz
          end if
          goto 49
   50   continue
        if (tailp.lt.mincnt) then
          tailp=tailp+1
          it=it+1
        end if
        pval=dfloat(tailp)/dfloat(it)
      else
        pval=1.0d0
      end if
      call phist(pval,pval,histo)
      write(*,'(a10,1x,i4,3(1x,f6.4),1x,f6.1,1x,f6.4,1x,i6,2(1x,a))')
     2  locnam, nca, obs, expp, fcoeff, binz(homoz,nca,expp), 
     3   pval, it, 'HOM', histo
      return
      end
C end-of-dohomoz
C
C
C find allele frequency
C
      double precision function getfreq(all,numal,name,alfrq)
      integer MAXALL
      parameter (MAXALL=60)
      integer numal, name(MAXALL)
      double precision alfrq(MAXALL)
      integer all
      integer i, iall
      iall=abs(all)
      call match(iall,numal,name,i)
      if (i.ne.0) then
        getfreq=alfrq(i)
      else
        write(*,'(a/a,i3,a)') 
     &    'Error in routine getfreq','Looking for ',iall,' in:'
        do 99 i=1,numal
   99     write(*,*) name(i), alfrq(i)
        getfreq=0.0d0
      end if
      return
      end
C end-of-getfreq
C
C find index for allele
C
      integer function getnam(rall,numal,name)
      integer MAXALL,MISS
      parameter (MAXALL=60, MISS=-9999)
      integer numal, name(MAXALL)
      double precision rall
      integer i,iall

      getnam=MISS
      if (rall.eq.MISS) return

      iall=int(abs(rall))
      call match(iall,numal,name,i)
      if (i.ne.0) then
        getnam=i
      else
        write(*,'(a/a,i3,a)') 
     &    'Error in routine getnam', 'Looking for ',iall,' in:'
        do 99 i=1,numal
          write(*,*) name(i)
   99   continue
      end if
      return
      end
C end-of-getnam
C
C produce cumulative allele frequencies
C
      subroutine accum(numal,alfrq,cumfrq)
      integer MAXALL
      parameter (MAXALL=60)
      integer numal
      double precision alfrq(MAXALL), cumfrq(MAXALL)
      cumfrq(1)=alfrq(1)
      cumfrq(numal)=1.0d0
      do 10 i=2,numal-1
         cumfrq(i)=cumfrq(i-1)+alfrq(i)
   10 continue
      return
      end
C end-of-accum
C
C produce genotype frequencies for Metropolis algorithm
C
      subroutine genot(numal,alfrq,ngtp,gfrq)
      integer MAXALL, MAXG
      parameter(MAXALL=60, MAXG=MAXALL*(MAXALL+1)/2)
C allele frequencies structure
      integer numal, ngtp
      double precision alfrq(MAXALL), gfrq(MAXG)
C local variables
      integer i

      ngtp=0
      do 5 i=1,numal
      do 5 j=1,i
        ngtp=ngtp+1
        gfrq(ngtp)=alfrq(i)*alfrq(j)
        if (i.ne.j) gfrq(ngtp)=gfrq(ngtp)+gfrq(ngtp)
    5 continue
      return
      end
C end-of-genot
C
C Do ibs sharing in parents as per Bishop 1990
C
      subroutine domar(wrk,gene,pedigree,actset,num,nfound, 
     2                 id,fa,mo,sex,locus,numloc,
     3                 numal,name,alfrq,plevel)
      integer KNOWN,MAXALL,MAXSIZ,MAXLOC,MISS
      parameter (KNOWN=0,MAXALL=60,MAXSIZ=1000,MAXLOC=120,MISS=-9999)
      integer gene,actset,num,numloc,plevel,wrk
C Pedigree structure
      character*10 pedigree
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ)
      integer sex(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)
C allele frequencies structure
      integer numal, name(MAXALL)
      double precision alfrq(MAXALL)
C calculate expected ibs statistics for marker
      double precision p, p2, p4, pp, pq, pq2, q, f(3)
C 2 df chi-square
      integer tab(3)
      double precision chisq, ef, expn, mu, obsn
C
      integer currf, currm, g1,g2,g3,g4,gen2,i,ibd,j,nmat
      double precision zibd
      logical last
C functions
      double precision chip

      if (numal.lt.2) return

      mu=0.0d0
      do 1 i=1,3
        tab(i)=0
    1 continue
      gen2=gene+1

C Calculate expected values for ibs statistic
      p2=0.0d0
      p4=0.0d0
      pp=0.0d0
      pq2=0.0d0
      do 3 i=1,numal
        p=alfrq(i)
        q=1.0d0-p
        p=p*p
        q=q*q
        pq2=pq2+p*q
        p4=p4+p*p
        do 3 j=i+1,numal
          p=alfrq(i)
          q=alfrq(j)
          p2=p2+p*p*q*q
          pq=1.0d0-p-q
          pp=pp+p*q*pq*pq
    3 continue
      f(1)=pq2+pp+pp
      f(3)=4.0d0*p2+p4
      f(2)=1.0d0-f(3)-f(1)
      ef=f(3)+0.5d0*f(2)
C
      rewind(wrk)
      last=.false.
    5 continue
       call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &            numloc, last)
       if (last) goto 20

        if (actset.le.0) goto 5
C 
         currf=MISS
         currm=MISS
         do 13 i=nfound+1,num
           g1=int(locus(fa(i),gene))
           g3=int(locus(mo(i),gene))
           if ((fa(i).ne.currf .or. mo(i).ne.currm) .and.
     &         g1.gt.KNOWN .and. g3.gt.KNOWN) then
             currf=fa(i)
             currm=mo(i)
             g2=int(locus(fa(i),gen2))
             g4=int(locus(mo(i),gen2))
             call share(g1,g2,g3,g4,zibd)
             ibd=int(2.0d0*zibd)+1
             tab(ibd)=tab(ibd)+1
           end if
   13    continue
      goto 5 
   20 continue
      nmat=tab(3)+tab(2)+tab(1)
      if (nmat.gt.0) mu=0.5d0*dfloat(2*tab(3)+tab(2))/dfloat(nmat)
      write(*,'(/a,i4/a,3x,f6.4,a,f6.4,a)')
     2   '   Number of typed matings =',nmat,
     3   ' Parental mean IBS sharing =',  mu, ' (Expected=',ef,')'
      if (nmat.gt.0) then
        chisq=0.0d0
        do 25 i=1,3
          expn=dfloat(nmat)*f(i)
          obsn=dfloat(tab(i))
          if (obsn.gt.0.001d0 .and. expn.gt.0.001d0) then
            chisq=chisq+obsn*log(obsn/expn) 
          end if
   25   continue
        chisq=chisq+chisq
        write(*,'(a,f6.1,a,f6.4,a)')
     &   ' Sharing Chi-square (2 df) =',chisq,' (P=',chip(chisq,2),')' 
      end if
      if (plevel.gt.0) then
        q=1.0d0/dfloat(max(nmat,1))
        write(*,'(2(/21x,a),2(/a,3f8.1))')
     2    'IBS Sharing','2/2     1/2     0/2', 'Observed sharing',
     3    q*dfloat(tab(3)),q*dfloat(tab(2)),q*dfloat(tab(1)),
     4    'Expected sharing', f(3),f(2),f(1) 
      end if
      return
      end
C end-of-domar
C
C Tabulate maternal v. paternal genotypes
C
      subroutine margen(wrk,gene,xlinkd,pedigree,actset,num,nfound, 
     2                 id,fa,mo,sex,locus,numloc,rows,cols,tble,e,
     3                 iter, numal,name,alfrq,plevel)
      integer KNOWN,MAXALL,MAXSIZ,MAXLOC,MISS
      parameter (KNOWN=0,MAXALL=60,MAXSIZ=1000,MAXLOC=120,MISS=-9999)
      integer gene,actset,num,numloc,plevel,wrk
      logical xlinkd
C Pedigree structure
      character*10 pedigree
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ)
      integer sex(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)
C allele frequencies structure
      integer numal, name(MAXALL)
      double precision alfrq(MAXALL)
C table
      integer nr, nc
      integer cols(*), rows(*), tble(*)
      double precision e(*)
C
      integer currf, currm, g1,g2,g3,g4,gen2,i,j,k,nmat,pos 
      logical last
      character*7 gtp
C functions
      integer clcpos, getnam

      if (numal.lt.2) return

      gen2=gene+1
      nc=numal*(numal+1)/2
      nr=nc
      nmat=0
      if (xlinkd) nr=numal
      do 1 i=1, nc*nr
        tble(i)=0
    1 continue
C
      rewind(wrk)
      last=.false.
    5 continue
       call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &            numloc, last)
       if (last) goto 20

        if (actset.le.0) goto 5
C 
         currf=MISS
         currm=MISS
         do 13 i=nfound+1,num
         if ((fa(i).ne.currf .or. mo(i).ne.currm) .and.
     2        locus(fa(i),gene).gt.KNOWN .and.
     3        locus(mo(i),gene).gt.KNOWN) then
             nmat=nmat+1
             currf=fa(i)
             currm=mo(i)
             g1=getnam(locus(fa(i),gene),numal,name)
             g2=getnam(locus(fa(i),gen2),numal,name)
             g3=getnam(locus(mo(i),gene),numal,name)
             g4=getnam(locus(mo(i),gen2),numal,name)
             if (xlinkd) g1=1
             pos=nc*(clcpos(g1,g2)-1)+clcpos(g3,g4)
             tble(pos)=tble(pos)+1
         end if
   13    continue
      goto 5 
   20 continue

      if (nmat.gt.0) then
        write(*,'(/12x,a/a,$)') 'Maternal Genotype','Pat Gtp  '
        do 25 i=1, numal
        do 25 j=1, i
          call wrgtp(name(j),name(i),gtp,1)
          write(*,'(1x,a7,$)') gtp
   25   continue
        write(*,*)
        pos=0
        if (xlinkd) then
          do 30 i=1, nr
            call wrgtp(name(i),0,gtp,1)
            write(*,'(a7,(10i8):)') gtp, (tble(pos+j), j=1, nc)
            pos=pos+nc
   30     continue
        else
          do 35 i=1, numal
          do 35 j=1, i
              call wrgtp(name(j),name(i),gtp,1)
            write(*,'(a7,(10i8):)') gtp, (tble(pos+k), k=1, nc)
            pos=pos+nc
   35     continue
        end if
        call rctest(nr, nc, tble, e, rows, cols, iter)
      else
        write(*,'(a)') 'No useful matings'
      end if
      return
      end
C end-of-margen
C
C Check if multilocus ibs sharing for pairs of sibs is consistent 
C with purported relationship.  Again as per Bishop et al 1990
C
      subroutine ckibs(wrk,wrk2,pedigree,actset,num,nfound,id,fa,mo,sex,
     &              locus, numloc,nloci,loctyp,locpos,numal,name,alfrq)
      integer MAXALL,MAXSIZ,MAXLOC,KNOWN
      parameter (MAXALL=60,MAXSIZ=1000,MAXLOC=120,KNOWN=0)

      integer wrk,wrk2
C Pedigree structure
      integer actset,num, nfound
      character*10 pedigree
      character*10 id(MAXSIZ) 
      integer fa(MAXSIZ), mo(MAXSIZ), sex(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)
      integer numloc
C
C locus structure
      integer nloci
      integer loctyp(MAXLOC),locpos(MAXLOC)
C allele frequencies structure
      integer numal, name(MAXALL)
      double precision alfrq(MAXALL)
C expected ibs statistics for each marker
      double precision e2(MAXLOC,2)
      double precision p, p2, p4
C
      integer den,g1,g2,g3,g4,gene,gen2,i,j,k,npairs,sib
      double precision ex, mibs, mean, var, z
      logical last, samefa, samemo
C
      mean=0.0d0
      npairs=0
      var=0.0d0
      pedigree=' '
      last=.false.
      rewind(wrk)
      rewind(wrk2)
C Calculate expected values for ibs=2 statistic
      do 2 k=1,nloci
      if (loctyp(k).eq.1) then
        read(wrk2) numal,(name(i),i=1,numal),(alfrq(i),i=1,numal)
        p2=0.0d0
        p4=0.0d0
        do 3 i=1,numal
          p=alfrq(i)
          p=p*p
          p2=p2+p
          p4=p4+p*p
    3   continue
        e2(k,1)=0.25d0*(1.0d0+2.0d0*p2*(1.0d0+p2)-p4)
        e2(k,2)=0.5d0*(p2*(1.0d0+p2+p2)-p4)
      end if
    2 continue
C
      write(*,'(4(/a))')
     2  '------------------------------------------------------------',
     3  'Estimated Prob(IBS=2) over all markers for sib-pairs',
     4  '------------------------------------------------------------',
     5  'Pedigree    Pers-1   Pers-2    ibs=2     Exp     Dev   Mrkrs'
    5 continue
       call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &            numloc, last)
       if (last) goto 20

        if (actset.le.0) goto 5
C
C only iterate nonfounders
        do 10 i=nfound+1,num-1
          do 15 j=i+1,num
            samefa=(fa(i).eq.fa(j))
            samemo=(mo(i).eq.mo(j))
C
C Share a parent
C
            if (samefa.or.samemo) then
              den=0
              ex=0.0d0
              mibs=0.0d0
              if (samefa .and. samemo) then
                sib=1
              else
                sib=2
              end if
              do 30 k=1,nloci
              if (loctyp(k).eq.1) then
                gene=locpos(k)
                g1=int(locus(i,gene))
                g3=int(locus(j,gene))
                if (g1.gt.KNOWN .and. g3.gt.KNOWN) then
                  den=den+1
                  gen2=gene+1
                  g2=int(locus(i,gen2))
                  g4=int(locus(j,gen2))
                  ex=ex+e2(k,sib)
                  if ((g1.eq.g3 .and. g2.eq.g4).or.
     &                (g1.eq.g4 .and. g2.eq.g3)) then
                    mibs=mibs+1.0d0
                  end if
                end if
              end if
   30         continue
              if (den.gt.0) then
                npairs=npairs+1
                z=sqrt(mibs)+sqrt(mibs+1)-sqrt(4*ex+1)
                mibs=mibs/dfloat(den)
                ex=ex/dfloat(den)
                call moment(npairs,mibs,mean,var)
                write(*,'(a,2(a10,1x),2(2x,f6.4),1x,f7.2,2x,i3)') 
     &             pedigree, id(i), id(j), mibs, ex, z, den
              end if
            end if
   15     continue
   10   continue
      goto 5 
   20 continue
      if (npairs.gt.1) var=var/(npairs-1)
      write(*,'(/a,f6.4,a,f6.4,a/)') 
     &  'Grand mean P(ibs=2)=',mean,' (SD=',dsqrt(var),')'
      return
      end
C end-of-ckibs
C
C Calculate observed and expected mean IBS for all pairs of relatives
C Expected distribution simulated using given map
C
      subroutine allibs(wrk,wrk2,iter,nloci,loc,loctyp,locpos,
     2             map,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     3             numloc, hset,ibscount,dev,numal,cumfrq,typ,plevel)
      integer IBDSIZ,KNOWN,MAXALL,MAXHAP,MAXIBD,MAXSIZ,MAXLOC,MISS
      parameter(KNOWN=0, MAXALL=60, MAXSIZ=1000, MAXLOC=120,
     2          MAXHAP=MAXLOC/2, MISS=-9999,
     3          MAXIBD=1000, IBDSIZ=MAXIBD*(MAXIBD+1)/2)
      integer iter,plevel,typ,wrk,wrk2
C
C Pedigree structure
      character*10 pedigree
      integer actset,num, nfound
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ), sex(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)
      integer numloc
C
C Locus structure 
      integer nloci
      character*20 loc(MAXLOC)
      integer loctyp(MAXLOC),locpos(MAXLOC)
C
C position of locus on sex-averaged linkage map
C
      real map(MAXLOC)
C
C allele and genotype frequencies within entire sample for given locus 
C
      integer numal
      double precision cumfrq(MAXALL)
C
C Storage space for haplotypes
      integer hset(MAXSIZ,MAXHAP,2)
C
C mean ibs sharing for all relative pairs
C
      double precision ibscount(IBDSIZ), dev(IBDSIZ)
C
C Marker list and intermarker distances
      integer nmark, mark(MAXHAP)  
      real recdist(MAXHAP)
C 
      integer gene, gen2, i, j, n, npairs, pos, score
      character*10 fid, mid
      real dist
      double precision crit, den, maxdev
      logical last 
C functions
      real invmap

      dist=0.0
      nmark=0
      do 1 j=1,nloci
      if (loctyp(j).eq.1) then
        nmark=nmark+1
        mark(nmark)=j
        if (map(j).ne.MISS .and. map(j).ge.dist) then
          recdist(nmark)=invmap(map(j)-dist,1)
          dist=map(j)
        else
          recdist(nmark)=0.50
          dist=-1000.0
        end if
        if (nmark.eq.MAXHAP) goto 2
      end if
    1 continue
    2 continue

      den=1.0d0/(dfloat(max(1,iter)))

      write(*,'(4(/a))')
     2  '------------------------------------------------------------',
     3  'IBS sharing outlier pairs contributed by each person',
     4  '------------------------------------------------------------',
     5  'Pedigree   Person   Father   Mother   Max Dev  Outlier Pairs'
      rewind(wrk)
   10 continue
       call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &            numloc, last)
       if (last) goto 20

        if (actset.le.0 .or. num.gt.MAXIBD) goto 10

        crit=0.95d0
        do 25 i=1,num
        do 25 j=1,nmark
          gene=locpos(mark(j))
          gen2=gene+1
          if (locus(i,gene).gt.KNOWN) then
            hset(i,j,1)=int(locus(i,gene))
            hset(i,j,2)=int(locus(i,gen2))
          else
            hset(i,j,1)=MISS
            hset(i,j,2)=MISS
          end if
   25   continue

        npairs=num*(num-1)/2
        do 90 i=1,npairs
          ibscount(i)=0.0d0
          dev(i)=0.0d0
   90   continue
        
        call allshare(num,ibscount,nmark,hset)
        
        do 100 it=1,iter
          if (plevel.gt.2) write(*,'(/a,i5)') pedigree,it
          call simhap(wrk2,nmark,mark,recdist,numal,cumfrq,
     &                num,nfound,fa,mo,hset,plevel) 
          call expshare(num,ibscount,dev,nmark,hset)
  100   continue
        
        do 105 pos=1,npairs
          dev(pos)=den*dev(pos)
  105   continue
        
        if (typ.eq.1) then
          do 110 i=1,num 
            n=0
            score=0
            maxdev=0.0d0
            pos=(i-2)*(i-1)/2
            do 115 j=1,i-1
              pos=pos+1
              if (ibscount(pos).ne.MISS) then
                n=n+1
                if (abs(dev(pos)).gt.abs(maxdev)) maxdev=dev(pos)
                if (abs(dev(pos)).ge.crit) score=score+1
              end if
  115       continue
            pos=1+(i-1)*i/2
            do 116 j=i+1,num 
              pos=pos+j-2
              if (ibscount(pos).ne.MISS) then
                n=n+1
                if (abs(dev(pos)).gt.abs(maxdev)) maxdev=dev(pos)
                if (abs(dev(pos)).ge.crit) score=score+1
              end if
  116       continue
            if (score.gt.0) then
              fid='x'
              mid='x'
              if (fa(i).ne.MISS) fid=id(fa(i))
              if (mo(i).ne.MISS) mid=id(mo(i))
              write(*,'(a,3(1x,a10),1x,f7.2,1x,i5,a1,i5,1x,5a:)') 
     2         pedigree,id(i),fid,mid,maxdev,score,'/',n,
     3         ('*',j=1,5*score/n)
          end if
  110     continue
        end if
        if (typ.eq.2 .or. plevel.gt.1) then
          if (plevel.gt.1) crit=0.0d0
          write(*,'(//a//a)')
     2      'Estimated Sum(IBS) over all markers for relative pairs',
     3      'Pedigree   Pers-1   Pers-2  Sum(IBS)     Dev'
          pos=0
          do 120 i=2,num 
          do 120 j=1,i-1
            pos=pos+1
            if (ibscount(pos).ne.MISS .and. abs(dev(pos)).ge.crit) then
              write(*,'(a,2(1x,a10),2(1x,f7.2))') 
     &         pedigree, id(i), id(j), ibscount(pos),dev(pos)
            end if
  120     continue
          write(*,*)
        end if

      goto 10
   20 continue
      return
      end
C end-of-allibs 
C
C Find closest match of genotypes between index person and all other
C active individuals
C
      subroutine genmatch(wrk, tped, tid, pedigree, actset, num, nfound,
     2                    id, fa, mo, sex, locus, numloc, nloci, 
     3                    loc, loctyp, locpos)
      integer MAXALL,MAXSIZ,MAXLOC,MISS,KNOWN
      parameter (MAXALL=60, MAXSIZ=1000, MAXLOC=120, 
     &           MISS=-9999, KNOWN=0)

      integer wrk
      character*10 tped, tid
C Pedigree structure
      integer actset,num, nfound
      character*10 pedigree
      character*10 id(MAXSIZ) 
      integer fa(MAXSIZ), mo(MAXSIZ), sex(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)
      integer numloc
C
C locus structure
      integer nloci
      character*20 loc(MAXLOC)
      integer loctyp(MAXLOC),locpos(MAXLOC)
C
      integer nmark 
      integer geno(MAXLOC,2), ord(MAXLOC)

      integer highest, i, ibs(3), j, nhet, nid, nmatch, 
     &        nped, thisped
      logical last
      character*1 sx
      character*7 gtp
C functions
      integer eow
      logical strfind

      write(*,'(/a/4a/a)')
     2  '------------------------------------------------------------',
     3  'Genetic (IBS) similarity to ', 
     4     tped(1:eow(tped)),'--',tid(1:eow(tid)),
     5  '------------------------------------------------------------' 
C
C find the index case
      nhet=0
      nmark=MISS
      nped=0
      nid=0
      last=.false.
      rewind(wrk)
   10 continue
       call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &            numloc, last)
       if (last) goto 50
        nped=nped+1
        if (strfind(tped,pedigree,1)) then
          do 15 i=1,num
          if (strfind(tid,id(i),1)) then
            nid=i
            nmark=0
            do 20 j=1, nloci
            if (loctyp(j).le.2 .and. locus(i, locpos(j)).gt.KNOWN) then
              nmark=nmark+1
              ord(nmark)=j
              geno(nmark,1)=int(locus(i, locpos(j)))
              geno(nmark,2)=int(locus(i, locpos(j)+1))
              if (geno(nmark,1).ne.geno(nmark,2)) nhet=nhet+1
            end if
   20       continue
C break
            goto 51
          end if
   15     continue
        end if
      goto 10
   50 continue
   51 continue
      
      if (nmark.le.0) then
        if (nmark.eq.MISS) then
          write(*,'(5a)') 'ERROR: Target individual ', 
     &      tped(1:eow(tped)),'--', tid(1:eow(tid)), ' not found!'
        else
          write(*,'(5a)') 'ERROR: Target individual ', 
     2      tped(1:eow(tped)),'--', tid(1:eow(tid)), 
     3      ' has no nonmissing marker genotypes.'
        end if
        return
      end if
C
C print out IBS of proband with rest of family 
      write(*,'(5a,i5,a,f5.1,a/)') 
     2  'Target individual ', tped(1:eow(tped)),'--', tid(1:eow(tid)),
     3  ' is genotyped at ', nmark, ' markers (heterozygous at ',
     4  dfloat(100*nhet)/dfloat(nmark),'%).'
      write(*,'(a,7(1x,a7):)') 
     2  'Pedigree  Individual Sex  ibs2  ibs1  ibs0 ', 
     3  (loc(ord(j)), j=1, min(nmark,6))
      call wrsex(sex(nid),sx)
      write(*,'(2a,1x,a1,1x,a,$)') tped, tid, sx, '     -     -     -'
      do 60 j=1, min(nmark, 6)
        call wrgtp(geno(j,1), geno(j,2), gtp, 1)
        write(*,'(1x,a7,$)') gtp
   60 continue
      write(*,*)
              
      highest=0
      do 70 i=1,num
      if (i .ne. nid) then
        call cntibs(i, nmark, geno, ord, locpos, locus, 
     &              nmatch, ibs)
        if (nmatch.gt.highest) highest=nmatch
        call wrsex(sex(i),sx)
        write(*,'(2a,1x,a1,1x,3i6,$)') 
     &    pedigree, id(i), sx, ibs(3), ibs(2), ibs(1)
        do 80 j=1, min(nmark, 6)
          call wrgtp(int(locus(i,locpos(ord(j)))), 
     &               int(locus(i,locpos(ord(j))+1)), gtp, 1)
          write(*,'(1x,a7,$)') gtp
   80   continue
        write(*,*)
      end if
   70 continue
      write(*,*)
C
C print out incrementally best matches from other pedigrees
      thisped=0
      last=.false.
      rewind(wrk)
  100 continue
       call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &            numloc, last)
       if (last) goto 200

        thisped=thisped+1
        if (actset.le.0 .or. thisped.eq.nped) goto 100
C
        do 110 i=1,num
          call cntibs(i, nmark, geno, ord, locpos, locus, 
     &                nmatch, ibs)
          if (nmatch.gt.highest) then 
            highest=nmatch
            call wrsex(sex(i),sx)
            write(*,'(2a,1x,a1,1x,3i6,$)') 
     &        pedigree, id(i), sx, ibs(3), ibs(2), ibs(1)
            do 160 j=1, min(nmark, 6)
              call wrgtp(int(locus(i,locpos(ord(j)))), 
     &                   int(locus(i,locpos(ord(j))+1)), gtp, 1)
              write(*,'(1x,a7,$)') gtp
  160       continue
            write(*,*)
          end if
  110   continue
      goto 100
  200 continue
      return
      end
C end-of-genmatch
C 
C IBS at specified set of markers
C
      subroutine cntibs(idx, nmark, geno, ord, locpos, locus, 
     &                  nmatch, ibs)
      integer KNOWN,MAXSIZ,MAXLOC,MISS
      parameter(KNOWN=0, MAXSIZ=1000, MAXLOC=120, MISS=-9999)
      integer idx, nmark, nmatch
      integer ibs(3)

      integer geno(MAXLOC,2), ord(MAXLOC), locpos(MAXLOC)
      double precision locus(MAXSIZ, MAXLOC)

      integer g1, g2, gene, j, nibs

      nmatch=0
      ibs(1)=0
      ibs(2)=0
      ibs(3)=0
      do 10 j=1, nmark
        gene=locpos(ord(j))
        if (locus(idx,gene).gt.KNOWN) then
          nibs=2
          g1=int(locus(idx,gene))
          g2=int(locus(idx,gene+1))
          if (g1.eq.geno(j,1) .and. g2.eq.geno(j,2)) nibs=3
          if (g1.eq.geno(j,2) .and. g2.eq.geno(j,1)) nibs=3
          if (g1.ne.geno(j,1) .and. g2.ne.geno(j,2) .and.
     &        g1.ne.geno(j,2) .and. g2.ne.geno(j,1)) nibs=1
          ibs(nibs)=ibs(nibs)+1
          nmatch=nmatch+nibs-1
        end if
   10 continue
      return
      end
C end-of-cntibs
C
C Count maximum number of active markers where proband and 
C any of relatives is genotyped at
C
      subroutine marshare(idx, num, locus, nloci, 
     &                    loctyp, locpos, marcom)
      integer MAXALL,MAXSIZ,MAXLOC,MISS,KNOWN
      parameter (MAXALL=60, MAXSIZ=1000, MAXLOC=120, 
     &           MISS=-9999, KNOWN=0)

      integer idx, marcom
C Pedigree structure
      integer num
      double precision locus(MAXSIZ,MAXLOC)
C
C locus structure
      integer nloci
      integer loctyp(MAXLOC),locpos(MAXLOC)
C
      integer ord(MAXLOC)
      integer i, j, nmark, nmatch

      marcom=0
      nmark=0
      do 20 j=1, nloci
      if (loctyp(j).le.2 .and. locus(idx, locpos(j)).gt.KNOWN) then
        nmark=nmark+1
        ord(nmark)=locpos(j)
      end if
   20 continue
C break
      if (nmark.eq.0) return
C
      do 70 i=1, num
      if (i.ne.idx) then
        nmatch=0
        do 80 j=1, nmark
        if (locus(i, ord(j)).ge.KNOWN) then
          nmatch=nmatch+1
        end if
   80   continue
        if (nmatch.gt.marcom) marcom=nmatch
      end if
   70 continue
      return
      end
C end-of-marshare
C
C Simulate haplotypes for all family members for given map
C
      subroutine simhap(wrk2,nmark,mark,recdist,numal,cumfrq,
     &                  num,nfound,fa,mo,hset,plevel) 
      integer KNOWN,MAXALL,MAXHAP,MAXSIZ,MAXLOC,MISS
      parameter(KNOWN=0,MAXALL=60, MAXSIZ=1000,MAXLOC=120,
     &          MAXHAP=MAXLOC/2,MISS=-9999)
      integer plevel, wrk2
C
C Pedigree structure
      integer num, nfound
      integer fa(MAXSIZ), mo(MAXSIZ)
C Marker list and intermarker distances
      integer nmark, mark(MAXHAP)  
      real recdist(MAXHAP)
C
C allele and genotype frequencies within entire sample for given locus 
C
      integer numal
      double precision cumfrq(MAXALL)
C
C Storage space for haplotypes
      integer hset(MAXSIZ,MAXHAP,2)

      integer i,ismiss,j
      logical fin, done(MAXSIZ)
C
C Initialize founders
C
      rewind(wrk2)
      do 30 j=1,nmark 
        read(wrk2) numal,(cumfrq(i),i=1,numal)
        do 31 i=1,nfound
          ismiss=sign(1,hset(i,j,1))
          call found(cumfrq,hset(i,j,1))
          hset(i,j,1)=ismiss*hset(i,j,1)
          call found(cumfrq,hset(i,j,2))
          hset(i,j,2)=ismiss*hset(i,j,2)
   31   continue
   30 continue
      do 32 i=1,nfound
        done(i)=.true.
   32 continue
      do 33 i=nfound+1,num
        done(i)=.false.
   33 continue
C
C then gene drop the nonfounders genotypes
C
   40 continue
        fin=.true.
        do 50 i=nfound+1,num
        if (.not.done(i)) then
          if (done(fa(i)) .and. done(mo(i))) then
            call genof6(i,fa(i),mo(i),nmark,hset,recdist)
            done(i)=.true.
          else
            fin=.false.
          end if
        end if
   50   continue
      if (.not.fin) go to 40

      if (plevel.gt.2) then
        do 100 i=1,num
          write(*,'(i4,100i3:)') i,(hset(i,j,1),j=1,nmark)
          write(*,'(4x,100i3:)')   (hset(i,j,2),j=1,nmark)
  100   continue
      end if
      return
      end
C end-of-simhap
C
C transmit haplotypes from each parent to child, including possibility
C of recombination within haplotype
C 
      subroutine genof6(idx,fa,mo,nmark,hset,recdist)
      integer MAXLOC, MAXSIZ, MAXHAP
      parameter(MAXLOC=120, MAXSIZ=1000, MAXHAP=MAXLOC/2)
      integer idx,fa,mo,nmark,hset(MAXSIZ,MAXHAP,2)
      real recdist(MAXHAP)
C local variables
      integer fagranp,mogranp,ismiss,j
C functions
      integer irandom
      real random
C
      fagranp=irandom(1,2)
      mogranp=irandom(1,2)
      do 50 j=1,nmark
        ismiss=sign(1,hset(idx,j,1))
        if (recdist(j).gt.random()) fagranp=3-fagranp
        if (recdist(j).gt.random()) mogranp=3-mogranp
        hset(idx,j,1)=ismiss*abs(hset(fa,j,fagranp))
        hset(idx,j,2)=ismiss*abs(hset(mo,j,mogranp))
   50 continue
      return
      end
C end-of-genof6
C
C Calculate sum of ibs statistics for all markers
C
      subroutine allshare(num,ibscount,nmark,hset)
      integer IBDSIZ, KNOWN, MAXHAP, MAXIBD, MAXSIZ, MAXLOC, MISS
      parameter(KNOWN=0,MAXSIZ=1000,MAXLOC=120, MAXHAP=MAXLOC/2,
     &          MISS=-9999 , MAXIBD=1000, IBDSIZ=MAXIBD*(MAXIBD+1)/2)
      integer nmark, num
C Storage space for haplotypes
      integer hset(MAXSIZ,MAXHAP,2)
C mean ibs sharing for all relative pairs
      double precision ibscount(IBDSIZ)
C local variables
      integer i,j,k,n,pos
      double precision tibs, zibs

      pos=0
      do 10 i=2,num
      do 10 j=1,i-1
        pos=pos+1
        n=0
        tibs=0.0d0
        do 20 k=1,nmark
        if (hset(i,k,1).gt.KNOWN .and. hset(j,k,1).gt.KNOWN) then
          n=n+1
          call share(hset(i,k,1),hset(i,k,2),
     &               hset(j,k,1),hset(j,k,2),zibs)
          tibs=tibs+zibs+zibs
        end if
   20   continue
        if (n.gt.0) then
          ibscount(pos)=tibs
        else
          ibscount(pos)=MISS
        end if
   10 continue
      return
      end
C end-of-allshare
C
C Accumulate null-hypothesis simulated ibs statistics for all markers
C
      subroutine expshare(num,ibscount,dev,nmark,hset)
      integer IBDSIZ, KNOWN, MAXHAP, MAXIBD, MAXSIZ, MAXLOC, MISS
      parameter(KNOWN=0,MAXSIZ=1000,MAXLOC=120, MAXHAP=MAXLOC/2,
     &          MISS=-9999 , MAXIBD=1000, IBDSIZ=MAXIBD*(MAXIBD+1)/2)
      integer nmark, num
C Storage space for haplotypes
      integer hset(MAXSIZ,MAXHAP,2)
C comparison to null hypothesis ibs sharing for all relative pairs
      double precision ibscount(IBDSIZ), dev(IBDSIZ)
C local variables
      integer i,j,k,pos
      double precision tibs, zibs

      pos=0
      do 10 i=2,num
      do 10 j=1,i-1
        tibs=0.0d0
        pos=pos+1
        if (ibscount(pos).ne.MISS) then
          do 20 k=1,nmark
          if (hset(i,k,1).gt.KNOWN .and. hset(j,k,1).gt.KNOWN) then
            call share(hset(i,k,1),hset(i,k,2),
     &                 hset(j,k,1),hset(j,k,2),zibs)
            tibs=tibs+zibs+zibs
          end if
   20     continue
          if (tibs.gt.ibscount(pos) .or. 
     &        (tibs.eq.ibscount(pos) .and. random().gt.0.5)) then
            dev(pos)=dev(pos)+1.0d0
          else
            dev(pos)=dev(pos)-1.0d0
          end if
        end if
   10 continue
      return
      end
C end-of-expshare
C
C Do LD analysis for unphased data
C
      subroutine ldp(numal,name1,numal2,name2,scatter,counts,full,ex,
     &               oldex, model,offset,x,r,b,cov,plevel)

      integer MAXALL, MAXSIZ, MAXIBD, MAXTER, MAXCOV
      parameter(MAXALL=60, MAXIBD=1000, MAXSIZ=1000,
     &          MAXTER=MAXIBD/2, MAXCOV=MAXTER*(MAXTER+1)/2)
      integer numal, numal2, plevel
      integer name1(MAXALL), name2(MAXALL)

      integer scatter(*)
      real counts(*), ex(*), full(*), model(*), offset(*), oldex(*)
C
C regression work arrays
      double precision x(MAXTER),r(MAXCOV),b(MAXTER),cov(MAXCOV)
C local variables
      integer ncells, nhcat, ple 
      character*10 loc1, loc2
C  
      loc1='Locus 1'
      loc2='Locus 2'
      ple=max(1, plevel)
      ncells=numal*(numal+1)*numal2*(numal2+1)/4 
      nhcat=numal*numal*numal2*numal2
      call ascend(numal, name1)
      call ascend(numal2, name2)
      write(*,'(i3,a,$)') ncells,' genotype counts> '
      read(*,*,err=100) (counts(i), i=1, ncells)

      call ld2(loc1,numal,name1,loc2,numal2,name2,1,
     2         ncells,nhcat,0,scatter,counts,full,
     3         ex,oldex,model,offset,x,r,b,cov,ple)
      return
C input error
  100 write(*,'(a,i3,a)') 
     &    'ERROR: Expected ',ncells,' genotype counts!'
      return
      end
C end-of-ldp
C
C Map haplotypes to genotypes 1=phase unknown 2=phase known
C
      subroutine haptogen(numal, numal2, scatter, typ, xlinkd)
      integer numal, numal2, scatter(*), typ  
      logical xlinkd
      integer i1, i2, j1, j2, n, ng, pos
C functions
      integer clcpos
      
      ng=0
      pos=0
      if (typ.eq.1 .or. typ.eq.3) then
        n=numal2*(numal2+1)/2
        do 10 i1=1, numal
        do 10 j1=1, numal2
        do 10 i2=1, numal
        do 10 j2=1, numal2
          pos=pos+1
          scatter(pos)=n*(clcpos(i1,i2)-1)+clcpos(j1,j2)
   10   continue
        ng=n*numal*(numal+1)/2
      end if
      if (typ.eq.2 .or. typ.eq.3) then
        n=numal*numal2
        do 20 i1=1, n
        do 20 j1=1, n
          pos=pos+1
          scatter(pos)=ng+clcpos(i1,j1)
   20   continue
        ng=ng+n*(n+1)/2
      end if
      if (xlinkd) then
        do 30 i1=1, numal
        do 30 j1=1, numal2
          pos=pos+1
          scatter(pos)=ng+numal*(i1-1)+j1
   30   continue
      end if
      return
      end
C end-of-haptogen
C
C Double HWE
C
      subroutine twohwe(numal, numal2, nfull, totpars, model, typ,
     &                  xlinkd)
      integer nfull, numal, numal2, totpars, typ 
      logical xlinkd
      real  model(*)
      integer  bloc, i,j, i1, i2, j1, j2, mpos, nhp

      bloc=1
      nhp=numal+numal2
      totpars=nhp
      if (typ.eq.3) then
        totpars=totpars+1
        bloc=bloc+1
      end if
      if (xlinkd) then
        totpars=totpars+1
      end if
      do 1 i=1, nfull*totpars
        model(i)=0.0
    1 continue
      
      mpos=0
      do 20 i=1, bloc
        do 10 i1=1, numal
        do 10 j1=1, numal2
        do 10 i2=1, numal
        do 10 j2=1, numal2
          model(mpos+i1)=model(mpos+i1)+1.0
          model(mpos+i2)=model(mpos+i2)+1.0
          model(mpos+numal+j1)=model(mpos+numal+j1)+1.0
          model(mpos+numal+j2)=model(mpos+numal+j2)+1.0
          if (i.eq.2) model(mpos+nhp+1)=model(mpos+nhp+1)+1.0
          mpos=mpos+totpars
   10   continue
   20 continue
      if (xlinkd) then
        do 30 i=1, numal
        do 30 j=1, numal2
          model(mpos+i)=model(mpos+i)+1.0
          model(mpos+numal+j)=model(mpos+numal+j)+1.0
          model(mpos+totpars)=model(mpos+totpars)+1.0
          mpos=mpos+totpars
   30   continue
      end if
      return
      end
C end-of-twohwe  
C
C Two locus linkage disequilibrium: autosomal or X-linked loci
C
      subroutine twold(wrk,zrec,gene1,loc1,ltyp1,gene2,loc2,ltyp2,iter,
     2             pedigree,actset,num,nfound,id,fa,mo,sex,locus,numloc,
     3             numal,name,alfrq,numal2,name2,alfrq2,
     4             eligible,ngcount,gcount,key,gfrq,plevel)
      integer MAXALL, MAXG, MAXSIZ, MAXLOC, KNOWN
      parameter(MAXALL=60, MAXG=MAXALL*(MAXALL+1)/2, 
     &          MAXSIZ=1000, MAXLOC=120, KNOWN=0)
      integer gene1,gene2,iter,ltyp1,ltyp2,plevel,wrk,zrec
      character*10 loc1, loc2
C pedigree structure
      character*10 pedigree
      integer sex(MAXSIZ)
      integer actset,num, nfound
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)
C
C allele frequencies within entire sample for given locus 
C
      integer numal, name(MAXALL)
      double precision alfrq(MAXALL)
      integer numal2, name2(MAXALL)
      double precision alfrq2(MAXALL)
C
C Typed founders or nonfounders who have untyped parents
      logical eligible(MAXSIZ)
C
C Genotype counts: allele1,allele2, number transmitted, number not trans
      integer ngcount,gcount(MAXG,4)
      integer key(2*MAXSIZ)
      double precision gfrq(MAXG)
C
      integer tr1,tr2,nt1,nt2,tr3,tr4,nt3,nt4
      logical last, xmale
      integer cutoff, df, gene12, gene22, i, idx, j, nhap, ntyped,
     &        tothap  
      character*3 histo
      character*5 rsquare
      character*7 gtp
      double precision asyp, bigd, chisq, d, dprime, e, hedrick, 
     &                 p1, p2, pval, tot
C functions 
      logical useld
      double precision chip, ftdev, getfreq
C
      if (numal.le.1 .or. numal2.le.1) return

      if (plevel.gt.0) then
        write(*,'(/a,a10,a,a10,a/a/)')
     2   'Assoc for locus "',loc1,'" c. locus "',loc2,'"',
     3   '---------------------------------------------------'
      end if
      if (ltyp1.ne.ltyp2) then
        if (plevel.gt.0) then
          write(*,'(a/a)')
     2      'NOTE:  Mixed sex-linked and autosomal markers!',
     3      '          Pooled D'' (Hedrick) =   0.0' 
        else
          write(*,'(2(a10,1x),i4,2x,f6.3,1x,f6.1,1x,i4,1x,f6.4,1x,a)')
     &      loc1,loc2,0,0.0d0,0.0d0,0,1.0d0,'LD '
        end if
        return
      end if
      cutoff=0
      gene12=gene1+1
      gene22=gene2+1
      ntyped=0
      tothap=0
      ngcount=0
      do 2 i=1,numal
        alfrq(i)=0.0d0
        do 3 j=1,numal2
          ngcount=ngcount+1
          gcount(ngcount,1)=name(i)
          gcount(ngcount,2)=name2(j)
          gcount(ngcount,3)=0
    3   continue
    2 continue
      do 4 j=1,numal2
        alfrq2(j)=0.0d0
    4 continue

      last=.false.
      rewind(wrk)
C
C If high print level, then list transmitted and nontransmitted alleles
C for each informative proband
C
      if (plevel.gt.1) then
        write(*,'(a/a)') '  Informative Parent     Trans  Not Tr',
     &                   'Pedigree  ID      Sex    1   2   1   2'
      end if
C
   10 continue
       call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &            numloc, last)
       if (last) goto 20

       if (actset.le.0) goto 10
C
C
C Identify typed founders or nonfounders who have untyped parents
C
         do 11 i=1,nfound
           if (locus(i,gene1).gt.KNOWN .and.locus(i,gene2).gt.KNOWN)
     &     then
             eligible(i)=.true.
           else
             eligible(i)=.false.
           end if
   11    continue
         do 12 i=nfound+1,num
           if (locus(i,gene1).gt.KNOWN .and.locus(i,gene2).gt.KNOWN 
     2         .and. locus(fa(i),gene1).lt.KNOWN
     3         .and. locus(fa(i),gene2).lt.KNOWN
     4         .and. locus(mo(i),gene1).lt.KNOWN
     5         .and. locus(mo(i),gene2).lt.KNOWN)  then
             eligible(i)=.true.
           else
             eligible(i)=.false.
           end if
   12    continue
C
C Go through eligible offspring
C
         do 15 i=nfound+1,num
           if ((eligible(fa(i)) .or. eligible(mo(i))) .and.
     2         useld(locus(i,gene1),locus(i,gene12),locus(i,gene2),
     3           locus(i,gene22),locus(fa(i),gene1),locus(fa(i),gene12),
     4           locus(fa(i),gene2), locus(fa(i),gene22),
     5           locus(mo(i),gene1),locus(mo(i),gene12),
     6           locus(mo(i),gene2),locus(mo(i),gene22))) then
             xmale=(sex(i).eq.1 .and. ltyp1.eq.2)
             if (xmale) then
               call xtrans(
     3             int(locus(mo(i),gene1)), int(locus(mo(i),gene12)),
     4             int(locus(i,gene1)), int(locus(i,gene12)),
     5             tr1,tr2,nt1,nt2)
               call xtrans(
     3             int(locus(mo(i),gene2)), int(locus(mo(i),gene22)),
     4             int(locus(i,gene2)), int(locus(i,gene22)),
     5             tr3,tr4,nt3,nt4)
             else
               call trans(
     2             int(locus(fa(i),gene1)), int(locus(fa(i),gene12)),
     3             int(locus(mo(i),gene1)), int(locus(mo(i),gene12)),
     4             int(locus(i,gene1)), int(locus(i,gene12)),
     5             tr1,tr2,nt1,nt2,0)
               call trans(
     2             int(locus(fa(i),gene2)), int(locus(fa(i),gene22)),
     3             int(locus(mo(i),gene2)), int(locus(mo(i),gene22)),
     4             int(locus(i,gene2)), int(locus(i,gene22)),
     5             tr3,tr4,nt3,nt4,0)
             end if
C
C Note that once the haplotypes are used, the parent is set to ineligible
C along with any other full or half siblings
C
             if (eligible(fa(i)) .and. .not.xmale) then
               idx=fa(i)
               if (tr2.gt.KNOWN .and. tr4.gt.KNOWN) then
                 tothap=tothap+1
                 call insgen(tr2,tr4,ngcount,gcount,3,2)
                 call insall(tr2,numal,name,alfrq)
                 call insall(tr4,numal2,name2,alfrq2)
               end if
               if (ltyp1.eq.1 .and. zrec.eq.1) then
                 ntyped=ntyped+1
                 tothap=tothap+1
                 call insgen(nt2,nt4,ngcount,gcount,3,2)
                 call insall(nt2,numal,name,alfrq)
                 call insall(nt4,numal2,name2,alfrq2)
               end if
               eligible(idx)=.false.
               if (idx.gt.nfound) then
                 do 21 j=nfound+1,num
                   if (eligible(j) .and. 
     &                 (fa(idx).eq.fa(j) .or.  mo(idx).eq.mo(j))) then
                     eligible(j)=.false.
                   end if
   21            continue
               end if
               if (plevel.gt.1) then
                 write(*,'(a10,a10,1x,a1,2x,4(1x,i3))') 
     &           pedigree,id(idx),'m',tr2,tr4, nt2, nt4
               end if
             end if
             if (eligible(mo(i))) then
               idx=mo(i)
               ntyped=ntyped+1
               tothap=tothap+1
               call insgen(tr1,tr3,ngcount,gcount,3,2)
               call insall(tr1,numal,name,alfrq)
               call insall(tr3,numal2,name2,alfrq2)
               if (zrec.eq.1) then
                 tothap=tothap+1
                 call insgen(nt1,nt3,ngcount,gcount,3,2)
                 call insall(nt1,numal,name,alfrq)
                 call insall(nt3,numal2,name2,alfrq2)
               end if
               eligible(idx)=.false.
               if (idx.gt.nfound) then
                 do 22 j=nfound+1,num
                   if (eligible(j) .and. 
     &                 (fa(idx).eq.fa(j) .or.  mo(idx).eq.mo(j))) then
                     eligible(j)=.false.
                   end if
   22            continue
               end if
               if (plevel.gt.1) then
                 write(*,'(a10,a10,1x,a1,2x,4(1x,i3))') 
     &             pedigree,id(idx),'f',tr1,tr3, nt1, nt3 
               end if
             end if
           end if
   15    continue
       goto 10
   20  continue
C
      if (plevel.gt.0) then
       write(*,'(2a/2a)') 
     2   '       Haplotype       Observed   Expected',
     3   '     D        D''      Dev',
     4   '  ----------------------------------------',
     5   '-------------------------'
      end if
      asyp=1.0d0
      chisq=0.0d0
      bigd=0.0d0
      hedrick=0.0d0
      pval=1.0d0
      tot=0.0d0
      if (ntyped.gt.0) then
        tot=dfloat(tothap)
        do 225 i=1,ngcount
          nhap=gcount(i,3)
          key(i)=nhap
          p1=getfreq(gcount(i,1),numal,name,alfrq)/tot 
          p2=getfreq(gcount(i,2),numal2,name2,alfrq2)/tot
          e=tot*p1*p2
          gfrq(i)=e
          if (nhap.gt.cutoff) then
            chisq=chisq+dfloat(nhap)* log(dfloat(nhap)/e)
          end if    
          d=(dfloat(nhap)-e)/tot
          if (d.lt.0.0d0) then
            dprime=d/min(p1*p2,(1.0d0-p1)*(1.0d0-p2))
          elseif (d.eq.0.0d0) then
            dprime=0.0d0
          else
            dprime=d/(min(p1,p2)-p1*p2)
          end if
          if (abs(dprime).gt.abs(bigd)) bigd=abs(dprime)
          hedrick=hedrick+p1*p2*abs(dprime)

          if (plevel.gt.0) then
            call wrgtp(gcount(i,1),gcount(i,2),gtp,2)
            write(*,999) gtp,nhap,'(',dfloat(nhap)/tot,')',e,
     &                   d,dprime,ftdev(dfloat(nhap),e)
  999       format(8x,a7,1x,i8,1x,a1,f5.3,a1,1x,f9.1,2x,f7.4,
     &             2x,f7.4,1x,f6.1)
          end if
  225   continue

        chisq=chisq+chisq
        df=(numal-1)*(numal2-1)
        asyp=chip(chisq,df)

        call simchi(numal,name,numal2,name2,key,gfrq,
     &              chisq,tothap,iter,pval)
      end if 
      if (plevel.gt.0) then
        write(*,'(/a,i4/a,3x,f6.4)')
     2  '   Number of individuals used =',ntyped,
     3  '          Pooled D'' (Hedrick) =',hedrick 
        if (numal.eq.2 .and. numal2.eq.2) then
          d=d/sqrt(p1*(1.0d0-p1))/sqrt(p2*(1.0d0-p2))
          write(*,'(20x,a,3x,f6.4)') 'r-squared =', d*d
        end if
        write(*,'(a,f6.1/a,i4)')
     3  'Linkage disequilibrium Chi-sq =',chisq,
     4  '   Nominal degrees of freedom =',df
        write(*,'(14x,a,3x,f6.4)') 'Nominal P-value =',asyp
        write(*,'(14x,a,3x,f6.4,a,i8,a)') 'Empiric P-value =',pval,
     &    ' (',10*tothap*iter,' MCMC iterations)'
      else
        rsquare=' -   '
        if (numal.eq.2 .and. numal2.eq.2) then
          d=d/sqrt(p1*(1.0d0-p1))/sqrt(p2*(1.0d0-p2))
          write(rsquare,'(f5.3)') d*d
        end if
        call phist(pval,1.0d0,histo)
        write(*,'(2(a10,1x),i4,2x,f6.3,1x,a5,1x,f6.1,1x,i4,
     21x,f6.4,2(1x,a))')
     3    loc1,loc2,ntyped,hedrick,rsquare,chisq,df,pval,'LD ',histo
      end if
C
      return
      end
C end-of-twold
C
C simple increment of allele count where all alleles already identified
C
      subroutine insall(iall,numal,name,alfrq)
      integer MAXALL
      parameter(MAXALL=60)
      integer iall, numal, name(MAXALL)
      double precision alfrq(MAXALL)
      integer idx
C functions
      integer getnam
      idx=getnam(dfloat(iall),numal,name)
      alfrq(idx)=alfrq(idx)+1.0d0
      return
      end
C end-of-insall
C
C Check if useful triad for haplotype inference 
C
      logical function useld(c1,c2,c3,c4,f1,f2,f3,f4,m1,m2,m3,m4)
      integer KNOWN
      parameter(KNOWN=0)
      double precision c1,c2,c3,c4,f1,f2,f3,f4,m1,m2,m3,m4
      logical het1, het2, hom1, hom2

      useld=.false.
      if (c1.le.KNOWN .or. c3.le.KNOWN) return
      if (f1.le.KNOWN .or. f3.le.KNOWN) return
      if (m1.le.KNOWN .or. m3.le.KNOWN) return
C drop out uninformative triads: eg 1.2/3.4 x 1.2/1.3 -> 1.2/3.3
C                      but keep: eg 1.2/3.3 x 1.2/3.3 -> 1.2/3.3
      het1=(c1.eq.f1 .and. c2.eq.f2 .and. c1.eq.m1 .and. c2.eq.m2 .and.
     &      c1.ne.c2)
      hom1=(f1.eq.f2 .and. m1.eq.m2 .and. f1.eq.m1)
      het2=(c3.eq.f3 .and. c4.eq.f4 .and. c3.eq.m3 .and. c4.eq.m4 .and.
     &      c3.ne.c4)
      hom2=(f3.eq.f4 .and. m3.eq.m4 .and. f3.eq.m3)

      if (het1 .and. .not.hom2) return
      if (het2 .and. .not.hom1) return
      
      useld=.true.
      return
      end
C end-of-useld
C
C Do LD analysis for unphased and phased data
C
      subroutine ld2(loc1,numal,name1,loc2,numal2,name2,
     2               typ,ngcat, nhcat, nxcat, scatter,counts,
     3               full,ex,oldex,model,offset,x,r,b,cov,plevel)

      integer MAXALL, MAXSIZ, MAXIBD, MAXTER, MAXCOV
      parameter(MAXALL=60, MAXIBD=1000, MAXSIZ=1000,
     &          MAXTER=MAXIBD/2, MAXCOV=MAXTER*(MAXTER+1)/2)
      integer ngcat, nhcat, numal, numal2, nxcat, plevel, typ
      integer name1(MAXALL), name2(MAXALL)
      character*10 loc1, loc2

      integer scatter(*)
      real ex(*), counts(*), full(*), model(*), offset(*), oldex(*)
C
C regression work arrays
      double precision x(MAXTER),r(MAXCOV),b(MAXTER),cov(MAXCOV)
C local variables
      integer a1,a2,df,df1,ncells,nfull,npg,
     &        nhap,nobs,noff,npars,nph, nunph,totpars
      logical xlinkd
      character*3 allel, allel2, histo
      character*5 rsquare
      real lnoff
      double precision chisq, d, dprime, hedrick, lrts, p1, p2, pval, r2
C functions
      double precision chip
C  
C set up design and scatter matrices
      nhap=numal*numal2
      npg=nhap*(nhap+1)/2
      totpars=nhap
      nfull=nhcat
      ncells=0
      nmal=0
      nph=0
      nunph=0
      xlinkd=(nxcat.gt.0)
      if (typ.eq.1) then
C unphased problem
        npg=0
        ncells=ngcat
        do 2 i=1, ngcat
          nunph=nunph+int(counts(i))
    2   continue
        noff=nunph
      else if (typ.eq.2) then
C phased data
        ncells=npg
        noff=ncells
        do 3 i=1, npg
          nph=nph+int(counts(i))
    3   continue
        noff=nph
      else if (typ.eq.3) then
C both
        ncells=ngcat+npg
        nfull=nhcat+nhcat
        totpars=totpars+1
        do 4 i=1, ngcat
          nunph=nunph+int(counts(i))
    4   continue
        do 5 i=1, npg
          nph=nph+int(counts(ngcat+i))
    5   continue
        noff=nunph
      end if
C If X-linked, male haplotypes are added at end
      if (xlinkd) then
        ncells=ncells+nxcat
        nfull=nfull+nxcat
        totpars=totpars+1
        do 6 i=1, nxcat
          nmal=nmal+int(counts(ngcat+npg+i))
    6   continue
      end if

      nobs=nph+nunph+nmal
      call twofrq(numal, numal2, ncells, counts, typ, xlinkd)
      npars=totpars
      df1=ncells-totpars
      do 10 i=1, nfull*totpars
        model(i)=0.0
   10 continue
      call gl(nfull-nxcat, npars, model, 1, nhap, nhap, .false.)
      call gl(nfull, npars, model, 1, nhap, 1   , .false.)
      if (typ.eq.3) then
        call gl(nfull-nxcat, npars, model, nhap+1, 2, 
     &          (nfull-nxcat)/2, .true.)
      end if
      if (xlinkd) then
        call gl(nfull, npars, model, npars, 2, nfull-nxcat , .true.)
      end if
      call haptogen(numal, numal2, scatter, typ, xlinkd)
C
C offset by N to give haplotype proportions
      lnoff=log(float(noff))
      do 20 i=1, nfull 
        offset(i)=lnoff
   20 continue

C     write(*,*) ncells, nfull, totpars, npars
C     write(*,*) (counts(kk), kk=1, ncells)

      if (plevel.gt.0) then
        if (typ.eq.1) then
          write(*,'(a,i3,a,i5,a)') 
     &      'Modelling ',ngcat,' unphased genotypes (N=',nunph,').'
        else if (typ.eq.2) then
          write(*,'(a,i3,a,i5,a)') 
     &      'Modelling ',npg, ' phased genotypes (N=',nph,').'
        else
          write(*,'(a,2(i3,a,i5,a))') 
     2      'Modelling ',npg,' phased genotypes (N=',nph,
     3      ') and ',ngcat,' unphased genotypes (N=',nunph,').'
        end if
        if (xlinkd) then
          write(*,'(a,i3,a,i5,a)') 
     &      'And ',nxcat,' male haplotypes (N=',nmal,').'
        end if
      end if
      call emllm(ncells,nfull,totpars,npars,counts,scatter,model,
     &           ex,oldex,full,offset,x,r,b,cov,lrts,plevel)

      if (plevel.gt.1) then
        call ldtab(numal, numal2, counts, ex, typ, xlinkd)
      end if
      if (plevel.gt.0) then
        write(*,'(/a/a)') 
     2  '  Haplotype  Prop      95% CL           D        D''',
     3  '  ----------------------------------------------------'
      end if

      ii=0
      a1=1
      a2=1
      hedrick=0.0d0
      bigd=0.0d0
      r2=0.0d0
      if (numal.eq.2 .and. numal2.eq.2) then
        p1=dble(counts(ncells+a1))
        p2=dble(counts(ncells+numal+a2))
        r2=(exp(b(1))-p1*p2)
        r2=r2*r2/p1/(1.0-p1)/p2/(1.0d0-p2)
      end if
      do 250 i=1,nhap 
        ii=ii+i
        ase=1.96d0*sqrt(cov(ii))
        p1=dble(counts(ncells+a1))
        p2=dble(counts(ncells+numal+a2))
        d=exp(b(i))-p1*p2
        if (d.lt.0.0d0) then
          dprime=d/min(p1*p2,(1.0d0-p1)*(1.0d0-p2))
        elseif (d.eq.0.0d0 .or. p1.eq.0.0d0 .or. p2.eq.0.0d0) then
          dprime=0.0d0
        else
          dprime=d/(min(p1,p2)-p1*p2)
        end if
        if (abs(dprime).gt.abs(bigd)) bigd=abs(dprime)
        hedrick=hedrick+p1*p2*abs(dprime)
        if (plevel.gt.0) then
          call wrall(name1(a1), allel)
          call wrall(name2(a2), allel2)
          write(*,'(1x,a3,1x,a3,3x,f6.4,3x,f6.4,a,f6.4,2(3x,f7.4))') 
     2    allel, allel2, exp(b(i)), 
     3    exp(b(i)-ase), '--', exp(b(i)+ase), d, dprime
        end if
        a2=a2+1
        if (a2.gt.numal2) then
          a1=a1+1
          a2=1
        end if
  250 continue
      call twohwe(numal, numal2, nfull, totpars, model, typ, xlinkd)
      call emllm(ncells,nfull,totpars,totpars,counts,scatter,model,
     &           ex,oldex,full,offset,x,r,b,cov,chisq,plevel)
      df=(numal-1)*(numal2-1)
      chisq=chisq-lrts
      pval=chip(chisq,df)
      rsquare=' -   '
      if (plevel.gt.0) then
        write(*,'(/a,i10/a,f12.2,a,i4,a,f6.4,a)') 
     2    '  Number of genotypes used =', nobs,
     3    '    LD Model LR Chi-square =', lrts,
     4    ' (df=',df1,', P=',chip(lrts,df1),')' 
        write(*,'(a,f12.2,a,i4,a,f6.4,a/a,7x,f7.4)') 
     2    '       LR Chi-square (D=0) =', chisq,
     3    ' (df=',df,', P=',pval,')' ,
     4    '  Hedrick weighted mean D'' =', hedrick
        if (numal.eq.2 .and. numal2.eq.2) then
          write(*,'(17x,a,7x,f7.4)') 'r-squared =', r2
        end if
      else
        if (numal.eq.2 .and. numal2.eq.2) then
          write(rsquare,'(f5.3)') r2
        end if
        call phist(pval,1.0d0,histo)
        write(*,'(2(a10,1x),i4,2x,f6.3,1x,a5,
     21x,f6.1,1x,i4,1x,f6.4,2(1x,a))')
     3    loc1,loc2,nobs,hedrick,rsquare,chisq,df,pval,'LD ',histo
      end if
      return
      end
C end-of-ld2
C
C Marginal allele frequencies two loci
C
      subroutine twofrq(numal, numal2, ncells, counts, typ, xlinkd)
      integer ncells, numal, numal2, typ
      logical xlinkd
      real counts(*)

      integer i,j,i1, i2, j1, j2, n, pos
      real tot

      do 5 pos=ncells+1, ncells+numal+numal2
        counts(pos)=0.0
    5 continue
      tot=0.0
      pos=0
      if (typ.eq.1 .or. typ.eq.3) then
        do 10 i1=1, numal
        do 10 i2=1, i1
        do 10 j1=1, numal2
        do 10 j2=1, j1
          pos=pos+1
          tot=tot+counts(pos)
          counts(ncells+i1)=counts(ncells+i1)+counts(pos)
          counts(ncells+i2)=counts(ncells+i2)+counts(pos)
          counts(ncells+numal+j1)=counts(ncells+numal+j1)+counts(pos)
          counts(ncells+numal+j2)=counts(ncells+numal+j2)+counts(pos)
   10   continue
      end if
      if (typ.eq.2 .or. typ.eq.3) then
        n=numal*numal2
        j1=0
        i1=1
        do 20 i=1, n
          j1=j1+1
          if (j1.gt.numal2) then
            j1=1
            i1=i1+1
          end if
          j2=0
          i2=1
          do 30 j=1, i
            j2=j2+1
            if (j2.gt.numal2) then
              j2=1
              i2=i2+1
            end if
            pos=pos+1
            tot=tot+counts(pos)
            counts(ncells+i1)=counts(ncells+i1)+counts(pos)
            counts(ncells+i2)=counts(ncells+i2)+counts(pos)
            counts(ncells+numal+j1)=counts(ncells+numal+j1)+counts(pos)
            counts(ncells+numal+j2)=counts(ncells+numal+j2)+counts(pos)
   30     continue
   20   continue
      end if
      tot=tot+tot
      if (xlinkd) then
        do 40 i=1, numal
        do 40 j=1, numal2
          pos=pos+1
          tot=tot+counts(pos)
          counts(ncells+i)=counts(ncells+i)+counts(pos)
          counts(ncells+numal+j)=counts(ncells+numal+j)+counts(pos)
   40   continue
      end if
      do 50 pos=ncells+1, ncells+numal+numal2
        counts(pos)=counts(pos)/tot
   50 continue
      return
      end
C end-of-twofrq 
C
C Show table of genotypes and haplotypes
C
      subroutine ldtab(numal,numal2,counts,ex,typ,xlinkd)
      integer numal, numal2, typ
      logical xlinkd
      real counts(*), ex(*)

      integer i,j,i1, i2, j1, j2, n, pos
      character*7 gtp1, gtp2
C functions
      double precision ftdev

      pos=0
      if (typ.eq.1 .or. typ.eq.3) then
        write(*,'(/a)') 
     &    'Unphased Genotypes  Observed  Expected  Deviance'
        do 10 i1=1, numal
        do 10 i2=1, i1
        do 10 j1=1, numal2
        do 10 j2=1, j1
          call wrgtp(i2,i1,gtp1,1)
          call wrgtp(j2,j1,gtp2,1)
          pos=pos+1
          write(*,'(a,1x,a,7x,f6.0,2(3x,f6.1))') 
     2      gtp1,gtp2,counts(pos),ex(pos), 
     3      ftdev(dble(counts(pos)), dble(ex(pos)))
   10   continue
      end if
      if (typ.eq.2 .or. typ.eq.3) then
        write(*,'(a)') 
     &    'Phased Genotypes    Observed  Expected  Deviance'
        n=numal*numal2
        j1=0
        i1=1
        do 20 i=1, n
          j1=j1+1
          if (j1.gt.numal2) then
            j1=1
            i1=i1+1
          end if
          j2=0
          i2=1
          do 30 j=1, i
            j2=j2+1
            if (j2.gt.numal2) then
              j2=1
              i2=i2+1
            end if
            pos=pos+1
            write(*,'(2i3,a,2i3,9x,f6.0,2(3x,f6.1))') 
     2        i1,i2,';',j1,j2,counts(pos),ex(pos), 
     3        ftdev(dble(counts(pos)), dble(ex(pos)))
   30     continue
   20   continue
      end if
      if (xlinkd) then
        write(*,'(a)') 
     &    'Male Haplotypes     Observed  Expected  Deviance'
        do 40 i=1, numal
        do 40 j=1, numal2
          call wrgtp(i,j,gtp1,0)
          pos=pos+1
          write(*,'(3x,a,12x,f6.0,2(3x,f6.1))') 
     2      gtp1,counts(pos),ex(pos), 
     3      ftdev(dble(counts(pos)), dble(ex(pos)))
   40   continue
      end if
      return
      end
C end-of-ldtab  
C
C Two locus linkage disequilibrium: autosomal or X-linked loci
C
      subroutine twold2(wrk,zrec,gene1,loc1,ltyp1,gene2,loc2,ltyp2,iter,
     2  pedigree,actset,num,nfound,id,fa,mo,sex,locus,numloc,
     3  numal,name1,numal2,name2, scatter,counts,
     4  full,ex,oldex,model,offset,x,r,b,cov,eligible,plevel)

      integer KNOWN, MAXALL, MAXLOC, MAXSIZ, MAXIBD, MAXTER, 
     &        MAXCOV, MISS
      parameter(KNOWN=0, MAXALL=60, MAXLOC=120, MAXIBD=1000, 
     2          MISS=-9999, MAXSIZ=1000,MAXTER=MAXIBD/2, 
     3          MAXCOV=MAXTER*(MAXTER+1)/2)
      integer gene1,gene2,iter,ltyp1,ltyp2,plevel,wrk, zrec
      integer numal, numal2
      integer name1(MAXALL), name2(MAXALL)
      character*10 loc1, loc2

      integer scatter(*)
      real counts(*), ex(*), full(*), model(*), offset(*), oldex(*)
C
C regression work arrays
      double precision x(MAXTER),r(MAXCOV),b(MAXTER),cov(MAXCOV)
C pedigree structure
      character*10 pedigree
      integer sex(MAXSIZ)
      integer actset,num, nfound
      character*10 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ)
      double precision locus(MAXSIZ,MAXLOC)
C
C Typed founders or nonfounders who have untyped parents
      logical eligible(MAXSIZ)
C
      integer tr1,tr2,nt1,nt2,tr3,tr4,nt3,nt4
      character*1 ch, sx(2)
      logical last, xmale
      integer cutoff, gene12, gene22, i, idx, j,
     &        ngcat, nhcat, npg, totgeno, tothap, totmal, typ
C functions 
      logical useld
C
      data sx /'m','f'/

      if (numal.le.1 .or. numal2.le.1) return

      ngcat=numal*(numal+1)*numal2*(numal2+1)/4 
      nxcat=numal*numal2
      npg=nxcat*(nxcat+1)/2
      nhcat=nxcat*nxcat

      if (nhcat.gt.MAXSIZ) then
        write(*,'(a)') 'ERROR: Too many possible haplotypes.'
        return
      end if
      if (plevel.gt.0) then
        write(*,'(/a,a10,a,a10,a/a/)')
     2   'Assoc for locus "',loc1,'" c. locus "',loc2,'"',
     3   '---------------------------------------------------'
      end if
      if (ltyp1.ne.ltyp2) then
        if (plevel.gt.0) then
          write(*,'(a/a)')
     2      'NOTE:  Mixed sex-linked and autosomal markers!',
     3      '          Pooled D'' (Hedrick) =   0.0' 
        else
          write(*,'(2(a10,1x),i4,2x,f6.3,1x,f6.1,1x,i4,1x,f6.4,1x,a)')
     &      loc1,loc2,0,0.0d0,0.0d0,0,1.0d0,'LD '
        end if
        return
      end if
      
      cutoff=0
      gene12=gene1+1
      gene22=gene2+1
      totgeno=0
      tothap=0
      totmal=0
      do 5 i=1, MAXSIZ
        counts(i)=0.0
    5 continue


      last=.false.
      rewind(wrk)
C
C If high print level, then list transmitted and nontransmitted alleles
C for each informative proband
C
      if (plevel.gt.2) then
        write(*,'(a/a)') '  Informative Parent     Trans  Not Tr',
     &                   'Pedigree  ID      Sex    1   2   1   2'
      end if
C
   10 continue
       call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &            numloc, last)
       if (last) goto 20

       if (actset.le.0) goto 10
C
C
C Identify typed founders or nonfounders who have untyped parents
C
         do 11 i=1,nfound
           if (locus(i,gene1).gt.KNOWN .and.locus(i,gene2).gt.KNOWN)
     &     then
             eligible(i)=.true.
           else
             eligible(i)=.false.
           end if
   11    continue
         do 12 i=nfound+1,num
           if (locus(i,gene1).gt.KNOWN .and.locus(i,gene2).gt.KNOWN 
     2         .and. locus(fa(i),gene1).lt.KNOWN
     3         .and. locus(fa(i),gene2).lt.KNOWN
     4         .and. locus(mo(i),gene1).lt.KNOWN
     5         .and. locus(mo(i),gene2).lt.KNOWN)  then
             eligible(i)=.true.
           else
             eligible(i)=.false.
           end if
   12    continue
C
C Go through eligible offspring
C
         do 15 i=nfound+1,num
           if ((eligible(fa(i)) .or. eligible(mo(i))) .and.
     2         useld(locus(i,gene1),locus(i,gene12),locus(i,gene2),
     3           locus(i,gene22),locus(fa(i),gene1),locus(fa(i),gene12),
     4           locus(fa(i),gene2), locus(fa(i),gene22),
     5           locus(mo(i),gene1),locus(mo(i),gene12),
     6           locus(mo(i),gene2),locus(mo(i),gene22))) then
             xmale=(sex(i).ne.2 .and. ltyp1.eq.2)
             if (xmale) then
               call xtrans(
     3             int(locus(mo(i),gene1)), int(locus(mo(i),gene12)),
     4             int(locus(i,gene1)), int(locus(i,gene12)),
     5             tr1,tr2,nt1,nt2)
               call xtrans(
     3             int(locus(mo(i),gene2)), int(locus(mo(i),gene22)),
     4             int(locus(i,gene2)), int(locus(i,gene22)),
     5             tr3,tr4,nt3,nt4)
             else
               call trans(
     2             int(locus(fa(i),gene1)), int(locus(fa(i),gene12)),
     3             int(locus(mo(i),gene1)), int(locus(mo(i),gene12)),
     4             int(locus(i,gene1)), int(locus(i,gene12)),
     5             tr1,tr2,nt1,nt2,0)
               call trans(
     2             int(locus(fa(i),gene2)), int(locus(fa(i),gene22)),
     3             int(locus(mo(i),gene2)), int(locus(mo(i),gene22)),
     4             int(locus(i,gene2)), int(locus(i,gene22)),
     5             tr3,tr4,nt3,nt4,0)
             end if
C
C Note that once the haplotypes are used, the parent is set to ineligible
C along with any other full or half siblings
C
             if (eligible(fa(i)) .and. .not.xmale) then
               idx=fa(i)
               ntyped=ntyped+1
               if (ltyp1.eq.1 .and. zrec.eq.1) then
                 tothap=tothap+2
                 call inchap(tr2,nt2,tr4,nt4,ngcat,npg,
     &                  numal,name1,numal2,name2,counts,2)
               else if (ltyp1.eq.2) then
                 totmal=totmal+1
                 call inchap(tr2,tr4,0,0,ngcat,npg,
     &                  numal,name1,numal2,name2,counts,3)
               end if
               eligible(idx)=.false.
               if (idx.gt.nfound) then
                 do 21 j=nfound+1,num
                   if (eligible(j) .and. 
     &                 (fa(idx).eq.fa(j) .or.  mo(idx).eq.mo(j))) then
                     eligible(j)=.false.
                   end if
   21            continue
               end if
               if (plevel.gt.2) then
                 write(*,'(a10,a10,1x,a1,2x,4(1x,i3))') 
     &           pedigree,id(idx),'m',tr2,tr4, nt2, nt4
               end if
             end if
             if (eligible(mo(i))) then
               idx=mo(i)
               ntyped=ntyped+1
               tothap=tothap+2
               if (zrec.eq.1) then
                 call inchap(tr1,nt1,tr3,nt3,ngcat,npg,
     &                  numal,name1,numal2,name2,counts,2)
               else if (xmale) then
                 totmal=totmal+1
                 call inchap(tr1,tr3,0,0,ngcat,npg,
     &                  numal,name1,numal2,name2,counts,3)
               else
                 call inchap(tr1,tr2,tr3,tr4,ngcat,npg,
     &                  numal,name1,numal2,name2,counts,2)
               end if
               eligible(idx)=.false.
               if (idx.gt.nfound) then
                 do 22 j=nfound+1,num
                   if (eligible(j) .and. 
     &                 (fa(idx).eq.fa(j) .or.  mo(idx).eq.mo(j))) then
                     eligible(j)=.false.
                   end if
   22            continue
               end if
               if (plevel.gt.2) then
                 write(*,'(a10,a10,1x,a1,2x,4(1x,i3))') 
     &             pedigree,id(idx),'f',tr1,tr3, nt1, nt3 
               end if
             end if
           end if
   15    continue
         do 17 i=1,num
         if (eligible(i)) then
           xmale=(sex(i).ne.2 .and. ltyp1.eq.2)
           if (xmale) then
             totmal=totmal+1
             call inchap(int(locus(i,gene1)),int(locus(i,gene2)),
     3              0,0,ngcat,npg,numal,name1,numal2,name2,counts,3)
             if (plevel.gt.2) then
               write(*,'(a10,a10,1x,a1,2x,2(1x,i3),2(2x,a1,1x))') 
     2           pedigree, id(i),'m',int(locus(i,gene1)),
     3           int(locus(i,gene2)),'-','-'
             end if
C
C If imputation on and X-linked marker, then unimputable pedigrees
C differ significantly from imputable pedigrees 
C
           else if (ltyp1.le.2) then
             totgeno=totgeno+1
             call inchap(int(locus(i,gene1)),int(locus(i,gene12)),
     2              int(locus(i,gene2)),int(locus(i,gene22)),
     3              ngcat,npg,numal,name1,numal2,name2,counts,1)
             if (plevel.gt.2) then
               ch='x'
               if (sex(i).ne.MISS) ch=sx(sex(i))
               write(*,'(a10,a10,1x,a1,2x,2(1x,i3,a1,i3))') 
     2           pedigree, id(i),ch,
     3           int(locus(i,gene1)),'/',int(locus(i,gene12)),
     4           int(locus(i,gene2)),'/',int(locus(i,gene22)) 
             end if
           end if
         end if
   17    continue
       goto 10
   20 continue
      typ=0
      if (totgeno.gt.0) typ=typ+1
      if (tothap.gt.0) typ=typ+2
      if (totmal.eq.0) nxcat=0
      if (typ.gt.0) then
C if only unphased or phased genotypes, reduce table to that length
        if (typ.eq.1) then
          do 45 i=ngcat+npg+1, ngcat+npg+nxcat
            counts(i-npg)=counts(i)
   45     continue
        else if (typ.eq.2) then
          do 50 i=ngcat+1, ngcat+npg+nxcat
            counts(i-ngcat)=counts(i)
   50     continue
        end if

        call ld2(loc1,numal,name1,loc2,numal2,name2,typ,
     2           ngcat, nhcat, nxcat, scatter,
     3           counts,full,ex,oldex,model,offset,x,r,b,cov,plevel)
      else if (plevel.gt.0) then 
        write(*,'(a)') 'No usable observations.'
      else
        write(*,'(2(a10,1x),a)')
     &    loc1,loc2, '   0    -        -     -  -     LD'
      end if
      return
      end
C end-of-twold2
C 
C increment count of phased or unphased genotype, haplotype 
C
      subroutine inchap(g11,g12,g21,g22,ngcat,npg,  
     &                  numal,name1,numal2,name2,counts,typ)
      integer MISS
      parameter (MISS=-9999)
      integer g11,g12,g21,g22,ngcat,npg,numal,numal2,typ   
      integer name1(*), name2(*)
      real counts(*)
      integer idx
C functions
      integer clcpos, getnam

      if (g11.eq.MISS .or. g21.eq.MISS) return

      if (typ.eq.1) then
        idx=numal2*(numal2+1)/2 *
     2        (clcpos(getnam(dfloat(g11),numal,name1),
     3                getnam(dfloat(g12),numal,name1))-1)+
     4         clcpos(getnam(dfloat(g21),numal2,name2),
     5                getnam(dfloat(g22),numal2,name2))
      else if (typ.eq.2) then
        idx=ngcat+
     2        clcpos(numal*(getnam(dfloat(g11),numal,name1)-1)+
     3               getnam(dfloat(g21),numal2,name2),
     4               numal*(getnam(dfloat(g12),numal,name1)-1)+
     5               getnam(dfloat(g22),numal2,name2))
      else if (typ.eq.3) then
        idx=ngcat+npg+
     2        numal*(getnam(dfloat(g11),numal,name1)-1)+
     3        getnam(dfloat(g12),numal2,name2)
      end if
C     write(*,*) 'index: ',idx, ' ', typ, ' (',g11,g12,g21,g22,')'
      counts(idx)=counts(idx)+1.0
      return
      end
C end-of-inchap
