C
C Binomial regression association analysis 
C
      subroutine binass(wrk,wrk2,twrk,trait,gene,assfnd,loc,locpos,
     2               x,r,b,cov,pedigree,actset,num,nfound,id,fa,mo,sex,
     3               locus,numloc,numal,name,cumfrq,plevel)
     3              
C
      integer KNOWN, MAXIBD, MAXTER, MAXCOV, MAXSIZ, MAXLOC, MISS
      double precision DELTA, EPS
      parameter(DELTA=1.0d-5, EPS=1.0d-6,
     2          KNOWN=0, MAXIBD=1000, MAXTER=MAXIBD/2, 
     3          MAXCOV=MAXTER*(MAXTER+1)/2,
     4          MAXSIZ=1000, MAXLOC=120, MISS=-9999)
      integer gene, numal, plevel, trait, twrk, wrk, wrk2
C position of y and x variables
      integer terms(MAXSIZ)
C  Pedigree structure
      character*10 pedigree
      integer actset,num, nfound
      character*8 id(MAXSIZ)
      integer fa(MAXSIZ), mo(MAXSIZ), sex(MAXSIZ)
      integer numloc
      real locus(MAXSIZ,MAXLOC)
C
C Locus structure:
C number of loci, locus name, locus type, and locus position in file
C
      character*10 loc(MAXLOC)
      integer locpos(MAXLOC)
C allele frequencies structure
      integer name(MAXALL)
      double precision cumfrq(MAXALL)
C regression work arrays
      double precision x(MAXTER),r(MAXCOV),b(MAXTER),cov(MAXCOV)
C local variables
      integer i,ifail,ii,itmax,j,ncov,nobs,nter,ntot,pos,wrknum
      character*12 wrkfil
      logical complete, last
      double precision y
C regression results
      integer idf, naff
      double precision base,tval,x2
      character*3 histo
C functions
      double precision zp

      wrknum=1
      wrkfil='sp-log.wrk'

      naff=0
      nobs=0
      ntot=0
      ifail=0
      idf=nall-1
      nter=nall+1
      ncov=nter*(nter+1)/2

      open(twrk,file=wrkfil,form='unformatted')

      last=.false.
      rewind(wrk)
    5 continue
        call wrkin(wrk,pedigree,actset,num,nfound,id,fa,mo,sex,locus,
     &             numloc, last)
        if (last) goto 20

        if (actset.le.0) goto 5
C
            n=num
            if (assfnd) n=nfound
            do 12 i=1,n
              untyped(i)=.false.
              if (locus(i,gene).lt.KNOWN) then
                untyped(i)=.true.
                if (locus(i,trait).ne.MISS) nuntyp=nuntyp+1
              elseif (locus(i,trait).ne.MISS) then
                g1=getnam(locus(i,gene),numal,name)
                g2=getnam(locus(i,gen2),numal,name)
                nobs=nobs+1
                do 15 j=1,numal
                  x(j)=0.0d0
   15           continue
                x(nter)=dble(value(i)-1.0)
                x(g1)=x(g1)+1
                x(g2)=x(g2)+1
                count(g1)=count(g1)+1
                count(g2)=count(g2)+1
                call moment(nobs,x(nter),mu,bss)
                call givenc(r, ncov, nter, x, 1.0d0, ifail)
              end if
   12       continue
            y=x(nter) 
            if (y.eq.1.0d0) naff=naff+1
            x(nter)=0.25d0*(y-0.5d0)-0.6931472d0
            write(twrk) y, 4.0d0, (x(j), j=1, nter)
          end if
   10   continue
        ntot=ntot+num
      goto 5
   20 continue
      base=dfloat(naff)/dfloat(nobs)
      base=dfloat(naff)*log(base)+dfloat(nobs-naff)*log(1.0d0-base)
      base=-base-base
C
      it=0
      itmax=20
      x2=0.0d0
      oldx2=-1.0d0
  150 continue
      if (it.gt.itmax .or. abs(x2-oldx2).lt.DELTA) goto 50
        it=it+1
        oldx2=x2
        call newnam(wrknum, wrkfil)
        open(wrk2,file=wrkfil,form='unformatted')
        call binirls(twrk,wrk2,nobs,nter,ncov,x2,r,b,y,x,w)
        close(twrk,status='delete')
        close(wrk2,status='keep')
        open(twrk,file=wrkfil,form='unformatted')
        if (plevel.gt.1) then
          write(*,'(i4,a,f16.4)') it, ': ',x2
        end if
      goto 150
   50 continue
      close(twrk,status='delete')

      if (it.gt.itmax) then 
        write(*,'(/a,i4,a/)') 
     &    'NOTE:  Exceeded max (',itmax,') iterations.'
      end if

      call var(r, ncov, cov, ncov, nter, nobs, 2, ifail)
      write(*,'(/a/a)') 
     2  '    Allele           Beta    Stand Error        t-Value',
     3  '  -----------------------------------------------------'
      tval=abs(b(1))/sqrt(cov(1))
      call phist(zp(tval),1.0d0,histo)
      write(*,'(2x,a10,1x,f12.4,3x,f12.4,3x,f12.4,1x,a3)') 
     &   'Intercept ',b(1),sqrt(cov(1)), tval, histo
      ii=1
      do 250 i=2,nter-1
        ii=ii+i
        tval=abs(b(i))/sqrt(cov(ii))
        call phist(zp(tval),1.0d0,histo)
        write(*,'(2x,a10,1x,f12.4,3x,f12.4,3x,f12.4,1x,a3)') 
     &     name(i),b(i),sqrt(cov(ii)), tval, histo
  250 continue

      write(*,'(/a,i7,a,f5.1,a/a,f12.4/a,i7/a,f12.4,a,i4,a/a,f12.4)') 
     2  'No. usable observations =',nobs,
     3  '      ( ',float(100*nobs)/float(ntot),'%)',
     4  'Null deviance           =', base, 
     5  'Number of iterations    =', it,
     6  'Model LR Chi-square     =', base-x2,' (df=',idf,')',
     7  'Akaike Inf. Criterion   =', dfloat(2*idf)+x2
      return
      end
C end-of-binass
